Ext.define('VirtualServers.view.Topology',{
		extend: 'utilities.OuterPanel',
		requires:['VirtualServers.view.Form'],
		alias: 'widget.topology',
		//floating:true,
		//floatable:true,
		layout:{
			type : 'vbox',
			align : 'stretch'
		},
		style:{'border':'0px solid blue !important'},
		flex:1,
		title:'Virtual Servers Topology',
		header:{
			padding:'5 10',
			margin:0,
		},
		tools:[{
			xtype: 'checkbox',
			cls: 'checkbt1',
			//margin:'5 25 0 25',
			//boxLabel: 'Show VMs from other services',
			id:'showOtherVM',
			hidden:hiddenflag,
			style:{'background-position':'left bottom !important'},
			checked:false,
			listeners: {
				change:function(){
					showOtherVM = Ext.getCmp('showOtherVM').getValue();
					if(virtualTopologyUrl != null && virtualTopologyUrl != undefined && virtualTopologyUrl != ''){
						var params = virtualTopologyUrl.split("&");
						virtualTopologyUrl = "";
						var flag = false;
						if(params != null && params.length > 0){
							for(var k=0;k<params.length;k++){
								var reqparam = params[k].substr(0,params[k].indexOf("="));
								var value = params[k].substr(params[k].indexOf("=")+1);
								if(reqparam == 'showOtherVMs'){
									value = showOtherVM;
									flag = true;
								}
								else if(reqparam == 'fromMenu')
									value = fromMenu;
								virtualTopologyUrl += "&"+reqparam+"="+value;
							}
							if(virtualTopologyUrl != null && virtualTopologyUrl.indexOf("&") == 0)
								virtualTopologyUrl = virtualTopologyUrl.substr(1);
						}
					}
					if(flag == false || flag == 'false')
						virtualUrl = '/final/monitor/EgVmwareCompGraphData.jsp?'+virtualTopologyUrl+"&showOtherVMs="+showOtherVM+"&fromMenu="+fromMenu;
					else
						virtualUrl = '/final/monitor/EgVmwareCompGraphData.jsp?'+virtualTopologyUrl;
					VirtualServers.app.getController('Main').getVirtualTopologyReload(virtualUrl,lm_state);
				}
			}
		},{
			xtype:'label',
			id:'showVMLabel',
			hidden:hiddenflag,
			margin:'1 20 0 0',
			html:'Show VMs from other '+chkLabel
		},{
			xtype:'commonbackbutton',
			id:'overrideId',
			text:backbtnTxt
		}],
		items:[{
			xtype:'selectForm',
			cls:'virtualServerHeader',
			align:'middle',
			margin:'7px 0px',
//			bodyStyle:{'background-color':'green'},
		},{
			xtype:'commonPanel',
			flex:1,
			border:false,
			frame:false,
			margin:0,
			itemId:'topologyView',
			id:'Virt_topology',
			scroll:false,
			autoScroll:false,
			layout:{
					type : 'vbox',
					align : 'stretch'
			},
			style:{'padding':'0px 10px'},
		}],

		initComponent:function(){
			this.callParent();
			//this.iconCls = "alarmCritical";
		}
	});