Ext.define('VirtualTopology.controller.Main', {
    extend: 'Ext.app.Controller',
    requires:['VirtualTopology.view.Main','VirtualTopology.view.VmDetailsGrid','VirtualTopology.view.ApplicationVmGrid'],
    views:['Main','VmDetailsGrid','ApplicationVmGrid'],
    refs:[
		{
			ref:'main',
			selector:'main'
		},
		{
			ref:'vmdetailsgrid',
			selector:'vmdetailsgrid'
		},
		{
			ref:'applicationvmgrid',
			selector:'applicationvmgrid'
		}
		],
	
    init: function() {
    	this.control({
					'main':{
						'boxready':this.loadform
					},
					'virtualtopologyform combo[id="component"]':{
						'select':this.component_onchange
					},
					'virtualtopologyform button[id="tabButton"]':{
						'click':this.tabShow
					}
				});
	},
	loadform:function(obj)
	{
		Ext.Ajax.request({
                 url:'/final/monitor/EgVmwareCompGraphData.jsp?'+queryValue,
                 success: function(response)
                 {
                    var formdata = Ext.decode(response.responseText);
					var ComponentValue = Ext.getCmp('component');
					ComponentValue.getStore().loadRawData(formdata.selectedField.selectOptions);
					ComponentValue.setValue(formdata.selectedField.chosenField);

					var resultPanel = Ext.getCmp('resultPanel');
					resultPanel.update(formdata.graphData);

					var mainTitle = Ext.getCmp('virtualtopologyform');
					mainTitle.setTitle(formdata.screenLabels.title);
                 }
            }); 
	},
	
	component_onchange:function(obj)
	{
		var resultTab = Ext.getCmp('resultTab');
		resultTab.hide();

		var selectedComponent = Ext.getCmp('component').value;
		var queryString = null;
		if(!Ext.isEmpty(selectedComponent))
		{
			if(selectedComponent.indexOf(':') > -1 )
			{
				var vmcomp_type = selectedComponent.substring(0,selectedComponent.indexOf(':'));
				queryString = 'vmcomp_type='+vmcomp_type;
				var TempVmhost = selectedComponent.substring(selectedComponent.indexOf(':')+1,selectedComponent.length);
				if(!Ext.isEmpty(TempVmhost))
				{
					if(TempVmhost.indexOf(':') > -1)
					{
						var Vmhost = TempVmhost.substring(0,TempVmhost.indexOf(':'));
						var port = TempVmhost.substring(TempVmhost.indexOf(':')+1,TempVmhost.length);
						queryString = queryString+"&Vmhost="+Vmhost+"&port="+port;
					}
				}
			}

		}
		Ext.Ajax.request({
                 url:'/final/monitor/EgVmwareCompGraphData.jsp?'+queryString,
                 success: function(response)
                 {
                    var formdata = Ext.decode(response.responseText);
					var ComponentValue = Ext.getCmp('component');
					
					ComponentValue.getStore().loadRawData(formdata.selectedField.selectOptions);
					ComponentValue.setValue(formdata.selectedField.chosenField);

					var resultPanel = Ext.getCmp('resultPanel');
					resultPanel.update(formdata.graphData);

					var mainTitle = Ext.getCmp('virtualtopologyform');
					mainTitle.setTitle(formdata.screenLabels.title);
                 }
            }); 
	},
	tabShow:function()
	{
		var resultTab = Ext.getCmp('resultTab');
		resultTab.show();

		var selectedComponent = Ext.getCmp('component').value;
		var queryString = null;
		if(!Ext.isEmpty(selectedComponent))
		{
			queryString = 'vmHost='+selectedComponent;

			var TempVmhost = selectedComponent.substring(selectedComponent.indexOf(':')+1,selectedComponent.length);
				if(!Ext.isEmpty(TempVmhost))
				{
					if(TempVmhost.indexOf(':') > -1)
					{
						var me = this;
						var Vmhost = TempVmhost.substring(0,TempVmhost.indexOf(':'));
						queryString = queryString+"&vmware="+Vmhost;
						Ext.Ajax.request({
							 url:'/final/monitor/virtualCompdetails.jsp?'+queryString,
							 success: function(response)
							 {
								var formdata = Ext.decode(response.responseText);
								console.log(formdata);
								me.getVmdetailsgrid().getStore().loadRawData(formdata.vmDetails);
								me.getApplicationvmgrid().getStore().loadRawData(formdata.appVmData);
							 }
						}); 
					}
				}
		}
	}
});