Ext.define('VirtualTopology.view.VirtualTopologyForm', {
	extend : 'Ext.panel.Panel',
	alias : 'widget.virtualtopologyform',
	cls:'outerpanel',
	title:'',
	border : false,
	id:'virtualtopologyform',
	requires : ['utilities.ScrollCombo','VirtualTopology.view.VmDetailsGrid','VirtualTopology.view.ApplicationVmGrid'],
	initComponent: function(){
		this.bodyPadding ='10 20 0 20';
		this.buttonAlign = 'center';
		this.callParent()
	},
	tools:[{
				xtype:'button',
				id:'tabButton',
				style:{'border':'none','background':'none'},
				iconCls:'iconTreeRightArrow',
			}],
	items:[
				{
					xtype : 'scrollcombo',
					width: 180,
					fieldLabel : 'Select a Component',
					labelAlign : 'top',
					editable : false,
					name : 'component',
					id:'component',
					cls : 'dropdown',
					displayField : 'displayField',
					valueField : 'valueField',
					queryMode : 'local',
					store : new Ext.data.Store({
								fields : ['displayField', 'valueField'],
								data : []
							}),
				},
				{
					xtype:'panel',
					layout:'hbox',
					items:[
						{
							xtype:'panel',
							id:'resultPanel',
							height:450,
							width:'70%',
						},
						{
							xtype:'tabpanel',
							border:false,
							id:'resultTab',
							hidden:true,
							cls:'tablayout',
							frame:false,
							width:'30%',
							height:'100%',
							items:[
								{
									title:'VM Tab',
									items:[{
									xtype:'vmdetailsgrid',
									id: 'vmtab',							
									}]
								},
								{
									title:'Application Tab',
									items:[{
									xtype:'applicationvmgrid',
									id:'applicationtab',
									}]
								}
							]
						}
					]
				}
			]
});
	
