//Ext.Loader.setPath("utilities","../../scripts/utilities");

Ext.define('ZoomGraphPanel', {
	extend : 'ScrollPanel',
	xtype : 'zoomgraphpanel',
	id:'zoompanel',
	jsonData : null,
	tools:[{
			type:'close',
			tooltip: 'Close',
			itemId : 'minimizePanelDiv',
			collapsible:true,
			cls:'commonPanelBg'

		}],
	items:[],
	initComponent : function() {
		this.callParent();
	},
	createItems : function(jsonData){
		this.jsonData=jsonData;
		var ZoomedGraph ="";
		
		//var minimizeIconPanel = this.resizeGraphIcon();
		var timeLinePanel = this.createTimeLinePanel();
		var chartOpt = jsonData.graphImage.chartType;
		//if(chartOpt != null && chartOpt != "" && chartOpt.indexOf("highchart") > -1)
		if(!Ext.isEmpty(chartOpt) && chartOpt.indexOf("highchart") > -1)
		{
			ZoomedGraph = this.createHSCZoomedGraph();
		}
		else if(!Ext.isEmpty(chartOpt) && chartOpt.indexOf("fusionchart") > -1)
		{
			ZoomedGraph = this.createZoomedFusionCharts();
		}
		else if(!Ext.isEmpty(chartOpt) && chartOpt.indexOf("fcURL") > -1)
		{
			ZoomedGraph = this.createZoomedIframeFusionCharts();
		}
		else 
			ZoomedGraph = this.createZoomedGraph();

		var ZoomedGraphData ="";
		if(!Ext.isEmpty(jsonData.minMaxAvgDivDisplay) && jsonData.minMaxAvgDivDisplay=='block'){
			ZoomedGraphData = this.createDataGrid();
		}

		//this.add([minimizeIconPanel,timeLinePanel,ZoomedGraph]);
		if(!Ext.isEmpty(ZoomedGraphData))
		{
			this.add([timeLinePanel,ZoomedGraph,ZoomedGraphData]);
		}
		else
			this.add([timeLinePanel,ZoomedGraph]);
		var pageUrl = jsonData.graphImage.imageSrc;
		this.doLayout();
	},
	createGraphItems : function(jsonData){
		this.jsonData=jsonData;
		var ZoomedGraph ="";
		ZoomedGraph = this.createHighChartZoomedGraph();
		if(!Ext.isEmpty(ZoomedGraph))
		{
			this.add([ZoomedGraph]);
		}
	},
	createTimeLinePanel : function() {
		var jsonData = this.jsonData;
			var chartOpt = jsonData.graphImage.chartType;
			var isHidden = false;
		if(!Ext.isEmpty(jsonData.graphFilters && jsonData.graphFilters.length>0)){
			var filterArray=new Array();
			for(var i=0;i<jsonData.graphFilters.length;i++){
				var filterData=jsonData.graphFilters[i];
				var filterComp=null;
				switch(filterData.type){
					case "combo": 
								filterComp=this.createCombo(filterData,isHidden);
								break;
					case "date": 
								filterComp=this.createDateField(filterData);
								break;
					case "image":
								filterComp={
									xtype : 'button',
									src : filterData.imageSrc,
									cls : 'button20',
									margin:'0 0 0 10',
									width : 70,
									text:'Graph',
									//minWidth : 25,
									//maxWidth : 25,
									//columnWidth : 0.05,
									itemId : 'timelineAny'
								}
								break;
					case "anchorDD":
								filterComp={
									xtype : 'button',
									//src : filterData.imageSrc,
									cls : 'button20',
									margin:'0 0 0 10',
									width : 60,
									text:filterData.label,
									itemId : 'ddIcon'
								}
								break;
				}
				if(!Ext.isEmpty(filterComp)){
					filterArray.push(filterComp);
				}
			}
		}
		var timeLinePanel = {
				xtype : 'panel',
				layout : 'hbox',
				//columnWidth : 1 ,
				width:'100%',
				margin:10,
				height:30,
				border:false,
				items:filterArray,
				itemId:'timelinePanel',
				cls : 'commonPanelBg'
				
		}	
		return timeLinePanel;
	},
	
	createZoomedGraph : function() {
		
		var jsonData = this.jsonData;
		var pageUrl = jsonData.graphImage.imageSrc;
		
		var ZoomedGraph = {
						xtype : 'container',
						height:400,
						//width:'auto',
						//layout:'auto',
						
						border:false,
						//columnWidth : 1 ,
						//html  :'<center><div id="zoomChartDiv" style="width:100%;"><table><tr><td><img onload="graphZoomLoad();" style="width:100%" id="graphImage" name="graphImage" src="'+pageUrl+'" border="0" onClick="javascript:bigGraphOnClick();"/></td></tr></table></div></center>',
						html  :'<center><div id="zoomChartDiv" style="width:100%;"><table><tr><td><img style="width:100%" id="graphImage" name="graphImage" src="'+pageUrl+'" border="0" onClick="javascript:bigGraphOnClick();"/></td></tr></table></div></center>'
						//cls : 'zoomed-image-panel'
		}	
		return ZoomedGraph;
	},
	createHSCZoomedGraph : function(){
		var isAxisTimeReq = true;
		var legendPos = "right";
		var jsonData = this.jsonData;
		var imgSrc = jsonData.graphImage.imageSrc;
		var pageUrl = '';
		if(imgSrc == "" || imgSrc == undefined)
			pageUrl = this.urlparam;
		else
			pageUrl = jsonData.graphImage.imageSrc;

		//var pageUrl = jsonData.graphImage.imageSrc;
		var panelId = 'graphImage';
		var	imgdiv = '<center><div id="zoomChartDiv" style="width:100%;"><div id="graphImage"></div></div></center>';
		var ZoomedGraph = {
			xtype : 'container',
			//height:400,
			//width:'auto',
			//layout:'auto',
			id:'graphImage',
			border:true,
			//columnWidth : 1 ,
			html  :imgdiv,
			listeners:{
				'afterrender': function(imgdiv)
				{
					bigHighChart(pageUrl,panelId,400,950,'close',isAxisTimeReq,legendPos);
				}
			}
		}
		return ZoomedGraph;
	},
	createHighChartZoomedGraph : function(){
		var jsonData = this.jsonData;
		var panelId = 'graphImage';
		var	imgdiv = '<center><div id="zoomChartDiv" style="width:100%;"><div id="graphImage"></div></div></center>';
		var ZoomedGraph = {
			xtype : 'container',
			id:'graphImage',
			border:true,
			html  :imgdiv,
			listeners:{
				'afterrender': function(thisObj)
				{
					var lineChart = {};

					lineChart = jQuery.extend(true, {}, getHighCharts(thisObj.id,400,950,null), lineChart);

					//lineChart.setData(jsonData,currentDateFormat_js,null,'','right');
					lineChart.setData(jsonData,mgr_disp_dateFormat,null,'','right');
					lineChart.drawChart();
				}
			}
		}
		return ZoomedGraph;
	},
	createZoomedDDData : function(){
		var jsonData = this.jsonData;
		var panelId = 'ddDataId';
		var dddiv = '<center><div id="zoomDDDiv" style="width:100%;"><div id="ddDataId"></div></div></center>';
		var ZoomedDD = {
						xtype : 'container',
						height:400,
						id:'ddDataId',
						border:false,
						html:dddiv,
						listeners:{
							'afterrender': function(dddiv)
							{
								//bigHighChart(pageUrl,panelId);
							}
						}
		}
		return ZoomedDD;
	},
	createZoomedFusionCharts : function(){
		var jsonData = this.jsonData;
		var pageUrl = jsonData.graphImage.imageSrc;
		var fcChartObj=jsonData.graphImageObject;
		var panelId = 'fcChartId';
		var fcdiv = '<center><div id="zoomFCChartDiv" style="width:100%;"><div id="'+fcChartObj.divId+'"  style="height:100%;"></div></div></center>';
		var ZoomedFC = {
						xtype : 'container',
						height:400,
						id:'fcChartId',
						border:false,
						html:fcdiv,
						fcObj:fcChartObj,
						listeners:{
							'afterrender': function(thisFC2Obj)
							{
								if  ( FusionCharts( thisFC2Obj.fcObj.fcId ) )
										FusionCharts( thisFC2Obj.fcObj.fcId ).dispose();
								var myChart = new FusionCharts( thisFC2Obj.fcObj.movie,thisFC2Obj.fcObj.fcId, thisFC2Obj.fcObj.graphWidth, thisFC2Obj.graphHeight,"0","1");
								myChart.setXMLData(thisFC2Obj.fcObj.dataXML);
								myChart.setTransparent(true);
								myChart.render(thisFC2Obj.fcObj.divId);
							}
						}
		}
		return ZoomedFC;
	},
	createZoomedIframeFusionCharts : function() {
		var jsonData = this.jsonData;
		var pageUrl = jsonData.graphImage.iframeSrc;
		var ZoomedGraph = {
						xtype : 'container',
						height:400,
						border:false,
						html  :'<center><div id="zoomChartDiv" style="width:100%;"><table><tr><td><iframe src="'+pageUrl+'" scrolling="no" width="'+jsonData.graphImage.graphWidth+'px" height="'+jsonData.graphImage.graphHeight+'px" frameborder="0" marginheight="0" marginwidth="0" id="graphImage" name="graphImage" ALLOWTRANSPARENCY="true"></iframe></td></tr></table></div></center>',
		}
		return ZoomedGraph;
	},
	createDataGrid :function(){
		var jsonData = this.jsonData;
		var me = this;
		
		if(!Ext.isEmpty(jsonData.measuresTable) || !Ext.isEmpty(jsonData.minMaxTable))
		{
			var dataHeaders = jsonData.minMaxTable.minMaxTableHeadersArray;
			var dataItems = jsonData.measuresTable.measuresTableDataArray;
			//var dataItems = jsonData.minMaxTable.minMaxTableDataArray;
			var fieldsArray = new Array();
			if(!Ext.isEmpty(dataHeaders))
			{
				for(var i=0 ; i<dataHeaders.length ; i++){
					fieldsArray.push("value"+i);
				}
			}

			var tempStore = Ext.create('Ext.data.Store', {
				fields : fieldsArray,
				proxy: {
					type: 'memory',
					 reader: {
						 type: 'json',
						 root: 'items'
					 }
				 },
				 data :dataItems
			 });
			var columnsArray = new Array();

			if(!Ext.isEmpty(dataHeaders))
			{
				for(var i=0 ; i<dataHeaders.length ; i++){
					var tempwidth;
					if(i==1)
						tempwidth=dataHeaders[i].width-0.3+'%';
					else
						tempwidth=dataHeaders[i].width+'%';
					columnsArray.push({  
						text: dataHeaders[i].name,
						//flex:1,
						width :tempwidth,
						sortType : dataHeaders[i].textType,
						dataIndex: "value"+i,
						menuDisabled :true,
						renderer : function(value,metaData,record,rowIndex,colIndex){
							if(colIndex == 0){
								return '<div style="height:10px;width:15px;background-color:'+value+';"></div>';
							} else {
								return value;
							}
						}
					});
				}
			}
			var Table = {
						xtype :'customgrid',
						store : tempStore,
						border :true,
						width: 600,
						columns : columnsArray
						//forcefit: true,
						//margin:'20 50 20 50'
				};
		}

		var TablePanel ={
				xtype:'container',
				border : false,
				layout:{
					type:'vbox',
					align:'center'
				},
				margin:'20 0 10 0',
				items:[Table]
				//height:450,
				//html:'<div style="text-align:center"><img src="'+source+'"/></div>'
		}
		return TablePanel;
	},
	resizeGraphIcon : function(){
		var resizeGraphIconPanel = {
									xtype : 'panel',
									height : '30px',
									columnWidth : 1,
									//cls : 'minimize-Icon-panel',
									items : [{
												xtype : 'panel',
												
												cls : 'minimize-Icon-div',
												
									}]	
								}
				return resizeGraphIconPanel;
	},
	createCombo:function(comboData,isHidden){
		var comboStore = Ext.create('Ext.data.Store',{
			fields:['value','text'],
			proxy:{
				type: 'memory',
				reader: {
	            	type: 'json',
	            	root:'options'
	        	}
			},
			data:comboData
		});
		
		var compCombo={
				xtype:'combo',
				editable : false,
				store:comboStore,
				//columnWidth : 0.1,
				width:100,
				labelWidth:30,
				margin:'0 0 0 10',
				cls : 'dropdown',
				displayField:'text',
				valueField:'value',
				trigerAction:'all',
				fieldLabel:comboData.label,
				value:comboData.selectedValue,
				itemId:comboData.combo
		};
		
		if(comboData.combo=="timeline"){
			compCombo.labelWidth=55;
			compCombo.width=145;
			compCombo.minWidth=145;
			compCombo.maxWidth=145;
			compCombo.columnWidth=0.2;
			this.timeLine=comboData.selectedValue;
		}else if(comboData.combo=="fromhr" || comboData.combo=="tohr"){
			compCombo.labelWidth=20;
			compCombo.width=75;
			compCombo.minWidth=75;
			compCombo.maxWidth=75;
			compCombo.defaultListConfig={
					minWidth: 55,
					loadingHeight: 55,
					maxHeight: 200
			};
			if(this.timeLine!="Any"){
				compCombo.disabled=true;
			}
		}else if(comboData.combo=="mode"){
			compCombo.labelWidth=40;
			compCombo.width=90;
			compCombo.minWidth=90;
			compCombo.maxWidth=90;
			compCombo.hidden=isHidden;
			compCombo.defaultListConfig={
					minWidth: 50
			};
		}
		
		return compCombo;
	},
	createDateField:function(fieldData){
		var dateField={
				xtype:'datefield',
				cls : 'datepicker datefield-zoom-panel',
				//columnWidth : 0.2,
				fieldLabel:fieldData.label,
				format:mgr_dateFormat,
				value:fieldData.dispDate,
				labelWidth:50,
				width:210,
				itemId:fieldData.combo,
				name : fieldData.dateError,
				editable : false
		}
		if(fieldData.combo=="from"){
			dateField.labelWidth=35;
			dateField.minWidth=150;
			dateField.maxWidth=150;
			dateField.margin='0 0 0 10';
		}else if(fieldData.combo=="to"){
			dateField.labelWidth=20;
			dateField.width=135;
			dateField.minWidth=135;
			dateField.maxWidth=135;
			dateField.margin='0 0 0 10';
		}
		
		if(this.timeLine!="Any"){
			dateField.disabled=true;
		}
		return dateField;
	}

});