Ext.define('monitor.controller.InfrastructureHealthView', {
    extend: 'Ext.app.Controller',
    views:['monitor.view.InfrastructureHealthView','ErrorPanel'],
    jsonData:null,
    jsonFullData:null,
    
    refs:[{
    	ref:'healthViewMenu',
		selector:'infrastructurehealthviewmenu'
    },{
    	ref:'healthViewData',
    	selector:'infrastructurehealthviewdata'
    },{
    	ref:'infrastructureHealthView',
    	selector:'infrastructurehealthview'
    },{
    	ref:'problemAnalysis',
    	selector:'problemanalysis'
    },{
    	ref:'topPanel',
    	selector:'container[itemId=topPanel]'
    },{
    	ref:'bottomPanel',
    	selector:'measureandanalysis'
    },{
		ref:'main',
		selector:'main'
	}],
    
    init: function() {
		this.control({
			'infrastructurehealthviewmenu > button':{
				//'click':this.healthViewMenuClick,
				'afterrender':function(button){
					var htmlContent = '';

					if(isShowBottomPanel)
					{
						htmlContent = '<a href="javascript:void(0);" class="infra-health mouse"><span class="left" >'
						  +'<div id = "menuItem'+button.itemNumber+'" ></div>'
						  +'</span>'
						  +'<span class="right menu-title">'+button.contentText+'<br/>'+button.contentTotal+'</span></a>';
					}
					else
					{
						/*htmlContent = '<a href="javascript:void(0);" class="infra-health mouse"><span class="center" >'
						  +'<div id = "menuItem'+button.itemNumber+'"></div>'
						  +'</span>'
						 // +'<span class="right menu-title">'+button.contentText+'<br/>'+button.contentTotal+'</span></a>';
						  +'<span >'+button.contentText+'</span></a>';*/
						  htmlContent = '<div style="vertical-align:middle;text-align:center;display:table-cell"><a href="javascript:void(0);" class="infra-health mouse">'
						  +'<div id = "menuItem'+button.itemNumber+'"></div>'
						  +button.contentText+'</a></div>';
					}

					if(button.highChartData!=null && button.highChartData!=undefined && button.highChartData.DataSet!=null && button.highChartData.DataSet!=undefined)
					{
						button.update(htmlContent);

						var container = button;
						var jsonPieData=null;
						jsonPieData=button.highChartData;
						jsonPieData['customMsg'] = 'yes';
						jsonPieData['formatTip'] = 'yes';
						jsonPieData['rumPie'] = 'yes';
						//jsonPieData['showLegend'] = false;
						jsonPieData['dataLabels'] = false;
						jsonPieData['fromPage'] ='HomePage';
						jsonPieData['showMonitorHomeBottomPanel'] = isShowBottomPanel;
						
						var pieChart = {};

						if (!Ext.isEmpty(pieChart))
						{
							if(isShowBottomPanel)
							{
								//pieChart = jQuery.extend(true, {}, createPie(button.idString,60,70), pieChart);
								pieChart = jQuery.extend(true, {}, createPie(button.idString,80,90), pieChart);
								pieChart.setData(jsonPieData,'','','donut');
								button.chartObj=pieChart;
								pieChart.drawChart();
							}
							else
							{
								jsonPieData['useHtml'] = true;
								jsonPieData['title'] = '<div style="position:relative;top:-9px;z-index:-9999"><b style="font-size:14px;">'+button.elementTotal+'</b></div>';
								pieChart = jQuery.extend(true, {}, createPie(button.idString,90,110), pieChart);
								pieChart.setData(jsonPieData,'','','donut');
								button.chartObj=pieChart;
								pieChart.drawChart();
								
							}
						}

						htmlContent = null ;
						delete htmlContent;

					}
					/*else // Fusion chart - support
					{
						htmlContent = '<a href="javascript:void(0);" class="infra-health mouse"><span class="left" >'
						  +'<div id = "menuItem'+button.itemNumber+'" class="flashobj"></div>'
						  +'</span>'
						  +'<span class="right menu-title">'+button.contentText+'<br/>'+button.contentTotal+'</span></a>';


						FusionCharts.setCurrentRenderer('javascript');

						button.update(htmlContent);

						FusionCharts.debugMode.enable = true;
						FusionCharts.debugMode.outputTo(console.log);

						if(FusionCharts("infraItemId_"+button.itemNumber))
							FusionCharts("infraItemId_"+button.itemNumber).dispose();
						var healthChart = new FusionCharts('/final/FusionCharts/swf/Doughnut2D.swf','infraItemId_'+button.itemNumber, '90', '60', '0', '1');
						healthChart.setDataXML(button.xmlData);
						healthChart.setTransparent(true);
						healthChart.render(button.idString);

						htmlContent = null ;
						delete htmlContent;

						healthChart = null;
						delete healthChart;
					}*/
				}
			}
		});
	},
	
	infrastructureHealthViewRender:function(jsonData){
		this.jsonData=jsonData;
		this.jsonFullData=jsonData;
		if(!Ext.isEmpty(jsonData) && !Ext.isEmpty(jsonData.healthView) && !Ext.isEmpty(jsonData.healthView.componentslist))
		{
			if(this.getInfrastructureHealthView().query('errorpanel')){
				this.getInfrastructureHealthView().removeAll(false);
				this.getInfrastructureHealthView().add([
					this.getHealthViewMenu(),this.getHealthViewData()
				]);
			}

			if(isShowBottomPanel && this.getTopPanel().isVisible() && this.getBottomPanel().isVisible())
			{
				this.getInfrastructureHealthView().setHeight(234);
			}
			else if((!isShowBottomPanel) && this.getTopPanel().isVisible())
			{
				this.getInfrastructureHealthView().setHeight(495);
			}
			else
			{
				var height = 580; 
				try
				{
					height =Ext.getBody().getViewSize().height - 5;
				}
				catch (e)
				{
					height = 580; 
				}
				this.getInfrastructureHealthView().setHeight(height);
			}

			this.getHealthViewMenu().createMenuItems(jsonData.healthView.componentslist);

			if(!Ext.isEmpty(jsonData.screenLabels)){
				if(this.getTopPanel().isVisible() && this.getBottomPanel().isVisible())
				{
					this.getInfrastructureHealthView().setTitle(jsonData.screenLabels["Infrastructure Health"]);
				}
				else
				{
					if(this.getTopPanel().isVisible() && (!isShowBottomPanel))
					{
						this.getInfrastructureHealthView().setTitle(jsonData.screenLabels["Infrastructure Health"]);
					}
					else
					{
						this.getInfrastructureHealthView().setTitle("Components At-A-Glance");
					}
				}
				
				if(!Ext.isEmpty(this.getProblemAnalysis())){
					this.getProblemAnalysis().setTitle(jsonData.screenLabels["Event Analysis"]);
				}
			}

			if (lasInfrastructureMenuSelection == 'components' )
			{
				this.getHealthViewData().createMenuItems("components",jsonData.healthView.components,jsonData.screenLabels);	//default show components view
				if(isShowMaxiCompAtGlanceIcon && this.getTopPanel().isVisible() && this.getBottomPanel().isVisible())
				{
					Ext.getCmp('toolMinimizeId').hide();
					Ext.getCmp('toolMaximizeId').show();
				}
			}
			else if (lasInfrastructureMenuSelection == 'virtual_components' )
			{
				this.getHealthViewData().createMenuItems("virtual_components",jsonData.healthView.virtual_components,jsonData.screenLabels);

				if(isShowMaxiCompAtGlanceIcon && this.getTopPanel().isVisible() && this.getBottomPanel().isVisible())
				{
					Ext.getCmp('toolMinimizeId').hide();
					Ext.getCmp('toolMaximizeId').show();
				}
			}
			else if ( lasInfrastructureMenuSelection == 'zones' )
			{
				this.getHealthViewData().createMenuItems("zones",jsonData.healthView.zones,jsonData.screenLabels);	//default show components view

				if(isShowMaxiCompAtGlanceIcon && this.getTopPanel().isVisible() && this.getBottomPanel().isVisible())
				{
					Ext.getCmp('toolMinimizeId').hide();
					Ext.getCmp('toolMaximizeId').hide();
				}
			}
			else if ( lasInfrastructureMenuSelection == 'services' )
			{
				this.getHealthViewData().createMenuItems("services",jsonData.healthView.services,jsonData.screenLabels);	//default show components view

				if(isShowMaxiCompAtGlanceIcon && this.getTopPanel().isVisible() && this.getBottomPanel().isVisible())
				{
					Ext.getCmp('toolMinimizeId').hide();
					Ext.getCmp('toolMaximizeId').hide();
				}
			}
			else if ( lasInfrastructureMenuSelection == 'serviceGroups' )
			{
				this.getHealthViewData().createMenuItems("serviceGroups",jsonData.healthView.serviceGroups,jsonData.screenLabels);	//default show components view

				if(isShowMaxiCompAtGlanceIcon && this.getTopPanel().isVisible() && this.getBottomPanel().isVisible())
				{
					Ext.getCmp('toolMinimizeId').hide();
					Ext.getCmp('toolMaximizeId').hide();
				}
			}
			else if ( lasInfrastructureMenuSelection == 'segments' )
			{
				this.getHealthViewData().createMenuItems("segments",jsonData.healthView.segments,jsonData.screenLabels);	//default show components view

				if(isShowMaxiCompAtGlanceIcon && this.getTopPanel().isVisible() && this.getBottomPanel().isVisible())
				{
					Ext.getCmp('toolMinimizeId').hide();
					Ext.getCmp('toolMaximizeId').hide();
				}
			}
			else if ( lasInfrastructureMenuSelection == 'aggregates' )
			{
				this.getHealthViewData().createMenuItems("aggregates",jsonData.healthView.aggregates,jsonData.screenLabels);	//default show components view

				if(isShowMaxiCompAtGlanceIcon && this.getTopPanel().isVisible() && this.getBottomPanel().isVisible())
				{
					Ext.getCmp('toolMinimizeId').hide();
					Ext.getCmp('toolMaximizeId').hide();
				}
			}
			else
			{
				var selectedInfraStructure = jsonData['selectedInfraStructure'];
				if(!Ext.isEmpty(selectedInfraStructure))
				{
					var healthViewMenu = this.getHealthViewMenu();
					for(var menu=0;menu<healthViewMenu.items.getCount();menu++){
						var menuBtn=healthViewMenu.items.getAt(menu);
						if(!Ext.isEmpty(menuBtn.id) && menuBtn.action==selectedInfraStructure)
						{
							menuBtn.removeCls('non-selected-menu');
							menuBtn.addCls('selected-menu');
						}
						else
						{
							menuBtn.removeCls('selected-menu');
							menuBtn.addCls('non-selected-menu');
						}
						menuBtn = null;
						delete menuBtn;
						
					}
					healthViewMenu = null;
					delete healthViewMenu;

					var healthViewData = null;
					switch(selectedInfraStructure){
					case "zones": healthViewData=this.jsonData.healthView.zones;
									if(isShowMaxiCompAtGlanceIcon && this.getTopPanel().isVisible() && this.getBottomPanel().isVisible())
									{
										Ext.getCmp('toolMinimizeId').hide();
										Ext.getCmp('toolMaximizeId').hide();
									}
								  break;
					case "services": healthViewData=this.jsonData.healthView.services;
									if(isShowMaxiCompAtGlanceIcon && this.getTopPanel().isVisible() && this.getBottomPanel().isVisible())
									{
										Ext.getCmp('toolMinimizeId').hide();
										Ext.getCmp('toolMaximizeId').hide();
									}
									 break;
					case "serviceGroups" : healthViewData=this.jsonData.healthView.serviceGroups;
									if(isShowMaxiCompAtGlanceIcon && this.getTopPanel().isVisible() && this.getBottomPanel().isVisible())
									{
										Ext.getCmp('toolMinimizeId').hide();
										Ext.getCmp('toolMaximizeId').hide();
									}
									 break;
					case "segments": healthViewData=this.jsonData.healthView.segments;
									if(isShowMaxiCompAtGlanceIcon && this.getTopPanel().isVisible() && this.getBottomPanel().isVisible())
									{
										Ext.getCmp('toolMinimizeId').hide();
										Ext.getCmp('toolMaximizeId').hide();
									}
									 break;
					case "aggregates": healthViewData=this.jsonData.healthView.aggregates;
									if(isShowMaxiCompAtGlanceIcon && this.getTopPanel().isVisible() && this.getBottomPanel().isVisible())
									{
										Ext.getCmp('toolMinimizeId').hide();
										Ext.getCmp('toolMaximizeId').hide();
									}
									 break;
					case "components": healthViewData=this.jsonData.healthView.components;
									if(isShowMaxiCompAtGlanceIcon && this.getTopPanel().isVisible() && this.getBottomPanel().isVisible())
									{
										Ext.getCmp('toolMinimizeId').hide();
										Ext.getCmp('toolMaximizeId').show();
									}
									 break;
					}
					if(healthViewData!=null)
						this.getHealthViewData().createMenuItems(selectedInfraStructure,healthViewData,this.jsonData.screenLabels);
					this.getMain().doLayout();

					healthViewData = null;
					delete healthViewData;
				}

				selectedInfraStructure = null;
				delete selectedInfraStructure;
			}
		}
		jsonData = null;
		Ext.destroy(jsonData);
	},
	infrastructureHealthViewReload:function(jsonData){
		if(!Ext.isEmpty(jsonData) && !Ext.isEmpty(jsonData.healthView) && !Ext.isEmpty(jsonData.healthView.componentslist))
		{
			if(this.getInfrastructureHealthView().query('errorpanel')){
				this.getInfrastructureHealthView().removeAll(false);
				this.getInfrastructureHealthView().add([
					this.getHealthViewMenu(),this.getHealthViewData()
				]);
			}
			if(isShowBottomPanel && this.getTopPanel().isVisible() && this.getBottomPanel().isVisible())
			{
				this.getInfrastructureHealthView().setHeight(234);
			}
			else if((!isShowBottomPanel) && this.getTopPanel().isVisible())
			{
				this.getInfrastructureHealthView().setHeight(495);
			}
			else
			{
				var height = 580; 
				try
				{
					height =Ext.getBody().getViewSize().height - 5;
				}
				catch (e)
				{
					height = 580; 
				}
				this.getInfrastructureHealthView().setHeight(height);
			}
			this.getHealthViewMenu().createMenuItems(jsonData.healthView.componentslist);
			if(!Ext.isEmpty(jsonData.screenLabels))
			{
				if(this.getTopPanel().isVisible() && this.getBottomPanel().isVisible())
				{
					this.getInfrastructureHealthView().setTitle(jsonData.screenLabels["Infrastructure Health"]);
				}
				else
				{
					if(this.getTopPanel().isVisible() && (!isShowBottomPanel))
					{
						this.getInfrastructureHealthView().setTitle(jsonData.screenLabels["Infrastructure Health"]);
					}
					else
					{
						this.getInfrastructureHealthView().setTitle("Components At-A-Glance");
					}
				}
				if(!Ext.isEmpty(this.getProblemAnalysis())){
					this.getProblemAnalysis().setTitle(jsonData.screenLabels["Event Analysis"]);
				}
			}
			if (lasInfrastructureMenuSelection == 'components' )
			{
				this.getHealthViewData().createMenuItems("components",jsonData.healthView.components,jsonData.screenLabels);	//default show components view
				if(isShowMaxiCompAtGlanceIcon && this.getTopPanel().isVisible() && this.getBottomPanel().isVisible())
				{
					Ext.getCmp('toolMinimizeId').hide();
					Ext.getCmp('toolMaximizeId').show();
				}
			}
			else if (lasInfrastructureMenuSelection == 'virtual_components' )
			{
				this.getHealthViewData().createMenuItems("virtual_components",jsonData.healthView.virtual_components,jsonData.screenLabels);
				if(isShowMaxiCompAtGlanceIcon && this.getTopPanel().isVisible() && this.getBottomPanel().isVisible())
				{
					Ext.getCmp('toolMinimizeId').hide();
					Ext.getCmp('toolMaximizeId').show();
				}
			}
			else if ( lasInfrastructureMenuSelection == 'zones' )
			{
				this.getHealthViewData().createMenuItems("zones",jsonData.healthView.zones,jsonData.screenLabels);	//default show components view
				if(isShowMaxiCompAtGlanceIcon && this.getTopPanel().isVisible() && this.getBottomPanel().isVisible())
				{
					Ext.getCmp('toolMinimizeId').hide();
					Ext.getCmp('toolMaximizeId').hide();
				}
			}
			else if ( lasInfrastructureMenuSelection == 'services' )
			{
				this.getHealthViewData().createMenuItems("services",jsonData.healthView.services,jsonData.screenLabels);	//default show components view
				if(isShowMaxiCompAtGlanceIcon && this.getTopPanel().isVisible() && this.getBottomPanel().isVisible())
				{
					Ext.getCmp('toolMinimizeId').hide();
					Ext.getCmp('toolMaximizeId').hide();
				}
			}
			else if ( lasInfrastructureMenuSelection == 'serviceGroups' )
			{
				this.getHealthViewData().createMenuItems("serviceGroups",jsonData.healthView.serviceGroups,jsonData.screenLabels);	//default show components view
				if(isShowMaxiCompAtGlanceIcon && this.getTopPanel().isVisible() && this.getBottomPanel().isVisible())
				{
					Ext.getCmp('toolMinimizeId').hide();
					Ext.getCmp('toolMaximizeId').hide();
				}
			}
			else if ( lasInfrastructureMenuSelection == 'segments' )
			{
				this.getHealthViewData().createMenuItems("segments",jsonData.healthView.segments,jsonData.screenLabels);	//default show components view
				if(isShowMaxiCompAtGlanceIcon && this.getTopPanel().isVisible() && this.getBottomPanel().isVisible())
				{
					Ext.getCmp('toolMinimizeId').hide();
					Ext.getCmp('toolMaximizeId').hide();
				}
			}
			else if ( lasInfrastructureMenuSelection == 'aggregates' )
			{
				this.getHealthViewData().createMenuItems("aggregates",jsonData.healthView.aggregates,jsonData.screenLabels);	//default show components view
				if(isShowMaxiCompAtGlanceIcon && this.getTopPanel().isVisible() && this.getBottomPanel().isVisible())
				{
					Ext.getCmp('toolMinimizeId').hide();
					Ext.getCmp('toolMaximizeId').hide();
				}
			}
			else
			{
				var selectedInfraStructure = jsonData['selectedInfraStructure'];
				if(!Ext.isEmpty(selectedInfraStructure))
				{
					var healthViewMenu = this.getHealthViewMenu();
					for(var menu=0;menu<healthViewMenu.items.getCount();menu++){
						var menuBtn=healthViewMenu.items.getAt(menu);
						if(!Ext.isEmpty(menuBtn.id) && menuBtn.action==selectedInfraStructure)
						{
							menuBtn.removeCls('non-selected-menu');
							menuBtn.addCls('selected-menu');
						}
						else
						{
							menuBtn.removeCls('selected-menu');
							menuBtn.addCls('non-selected-menu');
						}
						menuBtn = null;
						delete menuBtn;
					}
					healthViewMenu = null;
					delete healthViewMenu;
					var healthViewData = null;
					switch(selectedInfraStructure){
					case "zones": healthViewData=jsonData.healthView.zones;
									if(isShowMaxiCompAtGlanceIcon && this.getTopPanel().isVisible() && this.getBottomPanel().isVisible())
									{
										Ext.getCmp('toolMinimizeId').hide();
										Ext.getCmp('toolMaximizeId').hide();
									}
								  break;
					case "services": healthViewData=jsonData.healthView.services;
									if(isShowMaxiCompAtGlanceIcon && this.getTopPanel().isVisible() && this.getBottomPanel().isVisible())
									{
										Ext.getCmp('toolMinimizeId').hide();
										Ext.getCmp('toolMaximizeId').hide();
									}
									 break;
					case "serviceGroups" : healthViewData=jsonData.healthView.serviceGroups;
									if(isShowMaxiCompAtGlanceIcon && this.getTopPanel().isVisible() && this.getBottomPanel().isVisible())
									{
										Ext.getCmp('toolMinimizeId').hide();
										Ext.getCmp('toolMaximizeId').hide();
									}
									 break;
					case "segments": healthViewData=jsonData.healthView.segments;
									if(isShowMaxiCompAtGlanceIcon && this.getTopPanel().isVisible() && this.getBottomPanel().isVisible())
									{
										Ext.getCmp('toolMinimizeId').hide();
										Ext.getCmp('toolMaximizeId').hide();
									}
									 break;
					case "aggregates": healthViewData=jsonData.healthView.aggregates;
									if(isShowMaxiCompAtGlanceIcon && this.getTopPanel().isVisible() && this.getBottomPanel().isVisible())
									{
										Ext.getCmp('toolMinimizeId').hide();
										Ext.getCmp('toolMaximizeId').hide();
									}
									 break;
					case "components": healthViewData=jsonData.healthView.components;
									if(isShowMaxiCompAtGlanceIcon && this.getTopPanel().isVisible() && this.getBottomPanel().isVisible())
									{
										Ext.getCmp('toolMinimizeId').hide();
										Ext.getCmp('toolMaximizeId').show();
									}
									 break;
					}
					if(healthViewData!=null)
						this.getHealthViewData().createMenuItems(selectedInfraStructure,healthViewData,jsonData.screenLabels);
					this.getMain().doLayout();
					healthViewData = null;
					delete healthViewData;
				}
				selectedInfraStructure = null;
				delete selectedInfraStructure;
			}
		}
		jsonData = null;
		Ext.destroy(jsonData);
	},
	healthViewMenuClick:function(btn)
	{
		lasInfrastructureMenuSelection = btn.action;
		var jsonData=null;
		var healthViewMenu=this.getHealthViewMenu();
		for(var menu=0;menu<healthViewMenu.items.getCount();menu++){
			var menuBtn=healthViewMenu.items.getAt(menu);
			menuBtn.removeCls('selected-menu');
			menuBtn.addCls('non-selected-menu');
		
			menuBtn = null;
			delete menuBtn;

		}

		var searchField = Ext.getCmp('searchBox');
		if(!Ext.isEmpty(searchField.getValue())){
			searchField.setValue('');
		}

		switch(btn.action){
		case "zones": jsonData=this.jsonFullData.healthView.zones;
						if(isShowMaxiCompAtGlanceIcon && this.getTopPanel().isVisible() && this.getBottomPanel().isVisible())
						{
							Ext.getCmp('toolMinimizeId').hide();
							Ext.getCmp('toolMaximizeId').hide();
						}
					  break;
		case "services": jsonData=this.jsonFullData.healthView.services;
						if(isShowMaxiCompAtGlanceIcon && this.getTopPanel().isVisible() && this.getBottomPanel().isVisible())
						{
							Ext.getCmp('toolMinimizeId').hide();
							Ext.getCmp('toolMaximizeId').hide();
						}
						 break;
		case "serviceGroups" : jsonData=this.jsonFullData.healthView.serviceGroups;
						if(isShowMaxiCompAtGlanceIcon && this.getTopPanel().isVisible() && this.getBottomPanel().isVisible())
						{
							Ext.getCmp('toolMinimizeId').hide();
							Ext.getCmp('toolMaximizeId').hide();
						}
						 break;
		case "segments": jsonData=this.jsonFullData.healthView.segments;
						if(isShowMaxiCompAtGlanceIcon && this.getTopPanel().isVisible() && this.getBottomPanel().isVisible())
						{
							Ext.getCmp('toolMinimizeId').hide();
							Ext.getCmp('toolMaximizeId').hide();
						}
		 				 break;
		case "aggregates": jsonData=this.jsonFullData.healthView.aggregates;
						if(isShowMaxiCompAtGlanceIcon && this.getTopPanel().isVisible() && this.getBottomPanel().isVisible())
						{
							Ext.getCmp('toolMinimizeId').hide();
							Ext.getCmp('toolMaximizeId').hide();
						}
		 				 break;
		case "components": jsonData=this.jsonFullData.healthView.components;
						if(isShowMaxiCompAtGlanceIcon && this.getTopPanel().isVisible() && this.getBottomPanel().isVisible())
						{
							Ext.getCmp('toolMinimizeId').hide();
							Ext.getCmp('toolMaximizeId').show();
						}
						 break;
		/*case "virtual_components": jsonData=this.jsonFullData.healthView.virtual_components;
						if(isShowMaxiCompAtGlanceIcon && this.getTopPanel().isVisible() && this.getBottomPanel().isVisible())
						{
							Ext.getCmp('toolMinimizeId').hide();
							Ext.getCmp('toolMaximizeId').hide();
						}
						 break;*/
		}
		btn.addCls('selected-menu');
		this.getHealthViewData().createMenuItems(btn.action,jsonData,this.jsonFullData.screenLabels);
		this.getMain().doLayout();

		jsonData = null;
		Ext.destroy(jsonData);

		healthViewMenu = null;
		delete healthViewMenu;
	},
	resizeInfraHealthPanel:function(event,el,header,button){
		var healthPanel = header.up('infrastructurehealthview');
		if(button.type == 'maximize'){
			this.getTopPanel().hide();
			this.getBottomPanel().hide();
			this.getHealthViewMenu().hide();
			var height = 580; 
			try
			{
				height =Ext.getBody().getViewSize().height - 5;
			}
			catch (e)
			{
				height = 580; 
			}
			healthPanel.setHeight(height);
			healthPanel.setAutoScroll(true);
			//button.setDisabled(true);
			//button.previousSibling('tool').setDisabled(false);

			button.hide();
			button.previousSibling('tool').show();

			this.getInfrastructureHealthView().setTitle("Components At-A-Glance");
		}
		else{
			this.getTopPanel().show();

			if(isShowBottomPanel)
			{
				this.getBottomPanel().show();
			}
			else
			{
				this.getBottomPanel().hide();
			}

			this.getHealthViewMenu().show();

			if(isShowBottomPanel)
			{
				healthPanel.setHeight(234);
			}
			else
			{
				healthPanel.setHeight(495);
			}
			
			//button.setDisabled(true);
			//button.nextSibling('tool').setDisabled(false);
			
			button.hide();
			button.nextSibling('tool').show();

			this.getInfrastructureHealthView().setTitle("Infrastructure Health");
		}
		this.getHealthViewMenu().createMenuItems(this.jsonData.healthView.componentslist);
	}
});