Ext.define('monitor.controller.Main', {
    extend: 'Ext.app.Controller',
    views:['monitor.view.Main','utilities.ErrorPanel','monitor.view.DashboardSummary','monitor.view.DashboardSummaryChart','monitor.view.MeasureAndAnalysisTab','monitor.view.InfrastructureHealthView'],
    stores:['monitor.store.Measures','monitor.store.ProblemAnalysisProblems','monitor.store.ProblemAnalysisComponents'],
	
    refs:[{
    	ref:'main',
		selector:'main'
    },{
    	ref:'problemAnalysis',
		selector:'problemanalysis'
    },{
    	ref:'infrastructureHealthView',
		selector:'infrastructurehealthview'
    },{
    	ref:'dashboardSummary',
		selector:'dashboardsummary'
    },{
    	ref:'dashboardSummaryChart',
    	selector:'dashboardsummarychart'
    },{
    	ref:'measures',
    	selector:'measures'
    },{
    	ref:'measureAndAnalysis',
    	selector:'measureandanalysis'
    },{
    	ref:'topPanel',
    	selector:'container[itemId=topPanel]'
    },{
    	ref:'bottomPanel',
    	selector:'measureandanalysis'
    },
	{
    	ref:'healthViewData',
    	selector:'infrastructurehealthviewdata'
    }],

    init: function() {
		setInterval("execute()",monitorRefreshFrequency);
		   this.control({
			   'main':{
				    scope:this,
					beforerender: this.refreshDashboard
			   },
			   'measures': {
			   		scope:this,
			   		beforerender: this.onMeasuresRender
           		},
           		'problemanalysiscomponents':{
           			scope:this,
           			beforerender:this.problemAnalysisComponentsRender
           		},
           		'problemanalysis':{
           			scope:this,
           			activate:this.loadEventAnalysisTab
           		},
				'infrastructurehealthview trigger':
				{
					specialkey: this.searchKeyPress,
					click : this.searchData
				}
		   });
//		if(!Ext.isEmpty(this.getMonitorStoreMeasuresStore())){
//			this.getMeasures().getStore().on('load',this.measuresStoreLoadHandler,this);
//		}
	},

	searchKeyPress:function(field,e){
		if (e.getKey() == e.ENTER) {

			if(!Ext.isEmpty(sortKey) && sortKey != null && sortKey != undefined){
				sortKey = "";
				sortState = "";
			}

			this.searchData(field);
		}
	},
	searchData:function(field){
		if(field == null || field == undefined || field.value == null || field.value == undefined)
			return;

		var searchText = field.value;
		if(!Ext.isEmpty(searchText) && searchText != null && searchText != undefined)
		{
			if(searchText == '(' || searchText == ')' || searchText == '\\' || searchText == '?' || searchText == '[')
			{
				Ext.MessageBox.show({
					title: 'Alert',
					msg: 'Please enter the valid search pattern',
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
				return;
			}
			else
			{
				var jsondata = this.getController('InfrastructureHealthView').jsonData;

				var selectedInfraStructure = "";
				if(!Ext.isEmpty(lasInfrastructureMenuSelection) && lasInfrastructureMenuSelection != null && lasInfrastructureMenuSelection != undefined)
					selectedInfraStructure = lasInfrastructureMenuSelection;
				else
					selectedInfraStructure = jsondata['selectedInfraStructure'];
				if(!Ext.isEmpty(selectedInfraStructure))
				{
					var healthViewData = null;
					if(selectedInfraStructure == 'components')
					{
						healthViewData = jsondata.healthView.components;
					}
					else if(selectedInfraStructure == 'aggregates')
					{
						healthViewData = jsondata.healthView.aggregates;
					}
					else if(selectedInfraStructure == 'segments')
					{
						healthViewData = jsondata.healthView.segments;
					}
					else if(selectedInfraStructure == 'serviceGroups')
					{
						healthViewData = jsondata.healthView.serviceGroups;
					}
					else if(selectedInfraStructure == 'services')
					{
						healthViewData = jsondata.healthView.services;
					}
					else if(selectedInfraStructure == 'zones')
					{
						healthViewData = jsondata.healthView.zones;
					}
					else if(selectedInfraStructure == 'virtual_components')
					{
						healthViewData = jsondata.healthView.virtual_components;
					}

					if(!Ext.isEmpty(healthViewData) && healthViewData != null && healthViewData != undefined){
						var finalHealthViewData = new Array();
						var value = null;
						for(var k=0;k<healthViewData.length;k++)
						{
							if(selectedInfraStructure == 'components' || selectedInfraStructure == 'aggregates')
								value = healthViewData[k].compType;
							else
								value = healthViewData[k].displayName;

							value = value.toLowerCase();
							if((value == searchText.toLowerCase()) || (value.indexOf(searchText.toLowerCase()) >= 0))
							{
								finalHealthViewData.push(healthViewData[k]);
							}
						}
						if(!Ext.isEmpty(finalHealthViewData) && finalHealthViewData != null)
							this.getHealthViewData().createMenuItems(selectedInfraStructure,finalHealthViewData,jsondata.screenLabels);
						else{
							Ext.MessageBox.show({
								title: 'Alert',
								msg: 'No '+selectedInfraStructure+' Found for the search text - '+searchText,
								buttons: Ext.MessageBox.OK,
								icon: Ext.MessageBox.WARNING
							});
							field.setValue('');
						}

					}
				}
			}
		}
		else
		{
			var jsondata = this.getController('InfrastructureHealthView').jsonData;

			var selectedInfraStructure = "";
			if(!Ext.isEmpty(lasInfrastructureMenuSelection) && lasInfrastructureMenuSelection != null && lasInfrastructureMenuSelection != undefined)
				selectedInfraStructure = lasInfrastructureMenuSelection;
			else
				selectedInfraStructure = jsondata['selectedInfraStructure'];

			if(!Ext.isEmpty(selectedInfraStructure))
			{
				var healthViewData = null;
				if(selectedInfraStructure == 'components')
				{
					healthViewData = jsondata.healthView.components;
				}
				else if(selectedInfraStructure == 'aggregates')
				{
					healthViewData = jsondata.healthView.aggregates;
				}
				else if(selectedInfraStructure == 'segments')
				{
					healthViewData = jsondata.healthView.segments;
				}
				else if(selectedInfraStructure == 'serviceGroups')
				{
					healthViewData = jsondata.healthView.serviceGroups;
				}
				else if(selectedInfraStructure == 'services')
				{
					healthViewData = jsondata.healthView.services;
				}
				else if(selectedInfraStructure == 'zones')
				{
					healthViewData = jsondata.healthView.zones;
				}

				if(!Ext.isEmpty(healthViewData) && healthViewData != null && healthViewData != undefined){
					this.getHealthViewData().createMenuItems(selectedInfraStructure,healthViewData,jsondata.screenLabels);
				}
			}
		}
	},

	loadEventAnalysisTab:function(obj,updateLabels,duration){
		var thisObj;

		if(obj.id == 'Main')
			thisObj = obj.getProblemAnalysis();
		else if(obj.getXType() == 'problemanalysis')
			thisObj = obj

		if(Ext.isEmpty(duration.newValue))
		{
			thisObj.refreshData(Ext.getCmp('eventAnalysis').jsonData,false);
		}
		else
		{
			var url='/final/servlet/com.eg.EgMonitorController?monCmd=jsonResponse&action=problemAnalysis';
			var thisObj;

		if(obj.id == 'Main')
			thisObj = obj.getProblemAnalysis();
		else if(obj.getXType() == 'problemanalysis')
			thisObj = obj

		if(!Ext.isEmpty(duration.newValue)){
			url += '&duration=';
			url += duration.newValue;
		}
		else if (!Ext.isEmpty(lastProbsDuration))
		{
			url = url+'&duration=';
			url.concat(lastProbsDuration);
		}

		Ext.Ajax.request({
			url : url,
			timeout:280000,
			success: function(response){
				var jsonData = Ext.decode(response.responseText);
				if(!Ext.isEmpty(thisObj) && !Ext.isEmpty(jsonData)){
					thisObj.refreshData(jsonData.eventAnalysis,false);
				}
				delete jsonData;
				Ext.destroy(jsonData);
			},
			failure : function(){
				//window.parent.location.href="/final/servlet/com.egurkha.Logout";
			}
		});

		url=null;
		delete url;

		delete thisObj;
	   }
	},

	problemAnalysisComponentsRender:function(cmp){
		cmp.on('hourComboChange',this.problemAnalysisHourChange,this);
	},

	problemAnalysisHourChange:function(obj){
		if(!Ext.isEmpty(this)){
			this.loadEventAnalysisTab(this,false,obj);
		}
	},

	onMeasuresRender:function(grid){
		grid.getStore().on('load',this.measuresStoreLoadHandler,this);
	},

	measuresStoreLoadHandler:function(store,records){
		var tabpanel=this.getMeasureAndAnalysis();
		if(store.getCount()==0){
			var comp=tabpanel.items.getAt(0);
			/*if(comp.xtype!='errorpanel'){
				var measuresGrid=this.getMeasures();
				var title=measuresGrid.screenLabels["Measure At-A-Glance"];
				var errorMessage=measuresGrid.screenLabels["monitor.segments.noDataMsg"];
				tabpanel.child('#measures').tab.hide();
				tabpanel.insert(0,{xtype:'errorpanel',title:title,html:errorMessage});
				tabpanel.setActiveTab(0);
			}
		}else{
			var comp=tabpanel.items.getAt(0);
			if(comp.xtype=='errorpanel'){
				tabpanel.remove(comp);
				tabpanel.child('#measures').tab.show();
				tabpanel.setActiveTab(0);
			}*/

		}
	},

	refreshDashboard:function()
	{
		var dataURL = '../servlet/com.eg.EgMonitorController?monCmd=jsonResponse';
		if(autoRefreshURL!=null && autoRefreshURL!=undefined && autoRefreshURL!="")
			dataURL = autoRefreshURL;

		if(!Ext.isEmpty(sortKey) && sortKey != null && sortKey != undefined && sortKey != "null")
			dataURL += "&sortKey="+sortKey+"&sortState="+sortState;
		var jsonData;
		var me = this;
		Ext.Ajax.request({
			url : dataURL,
			timeout:280000,
			success: function(response){
				jsonData = Ext.decode(response.responseText);
				
				
				if(!Ext.isEmpty(me.getInfrastructureHealthView()) && !Ext.isEmpty(jsonData.infraHealth) && !Ext.isEmpty(jsonData.infraHealth.healthView) && !Ext.isEmpty(jsonData.infraHealth.healthView.componentslist)){

					//me.getMain().removeAll(false);
					
					Ext.getCmp('errorId').hide();

					if(me.getTopPanel().isVisible())
					{
						Ext.getCmp('summaryAndChartContainer').show();
					}
					else
					{
						Ext.getCmp('summaryAndChartContainer').hide();
					}

					Ext.getCmp('infrastructurehealthview').show();

					if(me.getBottomPanel().isVisible())
					{
						Ext.getCmp('measureandanalysis').show();
					}
					else
					{
						Ext.getCmp('measureandanalysis').hide();
					}

					me.getMain().show();
					
					try
					{
						Ext.getCmp('eventAnalysis').jsonData = jsonData.eventAnalysis;	
					}
					catch (e)
					{
					}
					
					var infHealthController=me.getController('InfrastructureHealthView');
					infHealthController.infrastructureHealthViewRender(jsonData.infraHealth);

					infHealthController = null;
					delete infHealthController;

					if(!Ext.isEmpty(me.getDashboardSummary())){
						me.getMain().show();
						me.getDashboardSummary().refreshData(jsonData.dashboardSummary);
						//me.getMain().doLayout();
					}
					if(!Ext.isEmpty(me.getDashboardSummaryChart())){
						me.getMain().show();
						me.getDashboardSummaryChart().refreshData(jsonData.dashboardChart);
						//me.getMain().doLayout();
					}

					
					if(!Ext.isEmpty(me.getMeasures()))
					{
						me.getMeasures().refreshData(jsonData.measure,true);
						//me.getMain().show();
						//me.getMeasures().doLayout();
					}else{
						if(jsonData.measure.measures != undefined && jsonData.measure.measures.length > 0)
						{
							var el = Ext.getCmp('measureandanalysis');
							el.removeAll();
							el.add({
								itemId:'measures',
								title:'Measure At-A-Glance',
								xtype:'measures'
							});

							el.add({
								itemId:'eventanalysis',
								title:'Event Analysis',
								xtype:'problemanalysis'
							});
							el.show();
							el.doLayout();
							me.getMeasures().refreshData(jsonData.measure,true);
						}
					}
					
					me.getMain().doLayout();
					var searchField = Ext.getCmp('searchBox');
					if(!Ext.isEmpty(searchField.getValue())){
						me.searchData(searchField);
					}
				}
				else{

					me.getMain().show();
					Ext.getCmp('errorId').show();
					Ext.getCmp('summaryAndChartContainer').hide();
					Ext.getCmp('infrastructurehealthview').hide();
					Ext.getCmp('measureandanalysis').hide();
					me.getMain().doLayout();

					/*me.getMain().show();
					me.getMain().setLoading(true);
					var errorPanel = Ext.create('utilities.ErrorPanel',{
						errorMsg:'No components have been enabled for monitoring',
						imageCls:'iconExclamation',
						width : 500,
						id:'errorId',
						title:'Monitor Dashboard',
						margin:'8 8 0 8',
						flex:1,
						frame:true,
						padding:'0',
						cls:'error-panel outerpanel',
						bodyStyle:{'margin-top':'15%'},
						style:{'text-align':'center'},
					});

					me.getMain().removeAll(false);
					me.getMain().add(errorPanel);
					me.getMain().doLayout();
					me.getMain().setLoading(false);*/

					//errorPanel = null;
					//delete errorPanel;
				}
				
			},
			failure : function(){
				//window.parent.location.href="/final/servlet/com.egurkha.Logout";
			}
		});

		dataURL=null;
		delete dataURL;

		jsonData = null;
		Ext.destroy(jsonData);

		delete me;
	},
	loadDashboard:function()
	{
		var dataURL = '../servlet/com.eg.EgMonitorController?monCmd=jsonResponse';
		if(autoRefreshURL!=null && autoRefreshURL!=undefined && autoRefreshURL!="")
			dataURL = autoRefreshURL;
		var jsonData;
		var me = this;
		Ext.Ajax.request({
			url : dataURL,
			timeout:280000,
			success: function(response){
				jsonData = Ext.decode(response.responseText);
				if(!Ext.isEmpty(me.getInfrastructureHealthView()) && !Ext.isEmpty(jsonData.infraHealth) && !Ext.isEmpty(jsonData.infraHealth.healthView) && !Ext.isEmpty(jsonData.infraHealth.healthView.componentslist)){
					//me.getMain().removeAll(false);
					Ext.getCmp('errorId').hide();
					if(me.getTopPanel().isVisible())
					{
						Ext.getCmp('summaryAndChartContainer').show();
					}
					else
					{
						Ext.getCmp('summaryAndChartContainer').hide();
					}
					Ext.getCmp('infrastructurehealthview').show();
					if(me.getBottomPanel().isVisible())
					{
						Ext.getCmp('measureandanalysis').show();
					}
					else
					{
						Ext.getCmp('measureandanalysis').hide();
					}
					me.getMain().show();
					var infHealthController=me.getController('InfrastructureHealthView');
					infHealthController.infrastructureHealthViewRender(jsonData.infraHealth);
					infHealthController = null;
					delete infHealthController;
					if(!Ext.isEmpty(me.getDashboardSummary())){
						me.getMain().show();
						me.getDashboardSummary().refreshData(jsonData.dashboardSummary);
						//me.getMain().doLayout();
					}
				/*	if(!Ext.isEmpty(me.getDashboardSummaryChart()))
					{
						me.getMain().show();
						me.getDashboardSummaryChart().refreshData(jsonData.dashboardChart);
						//me.getMain().doLayout();
					}*/
					if(!Ext.isEmpty(me.getMeasures())){
						me.getMeasures().refreshData(jsonData.measure,true);
						//me.getMain().show();
						//me.getMeasures().doLayout();
					}
					me.getMain().doLayout();
				}
				else{
					me.getMain().show();
					Ext.getCmp('errorId').show();
					Ext.getCmp('summaryAndChartContainer').hide();
					Ext.getCmp('infrastructurehealthview').hide();
					Ext.getCmp('measureandanalysis').hide();
					me.getMain().doLayout();
					/*me.getMain().show();
					me.getMain().setLoading(true);
					var errorPanel = Ext.create('utilities.ErrorPanel',{
						errorMsg:'No components have been enabled for monitoring',
						imageCls:'iconExclamation',
						width : 500,
						id:'errorId',
						title:'Monitor Dashboard',
						margin:'8 8 0 8',
						flex:1,
						frame:true,
						padding:'0',
						cls:'error-panel outerpanel',
						bodyStyle:{'margin-top':'15%'},
						style:{'text-align':'center'},
					});
					me.getMain().removeAll(false);
					me.getMain().add(errorPanel);
					me.getMain().doLayout();
					me.getMain().setLoading(false);*/
					//errorPanel = null;
					//delete errorPanel;
				}
			},
			failure : function(){
				//window.parent.location.href="/final/servlet/com.egurkha.Logout";
			}
		});
		dataURL=null;
		delete dataURL;
		jsonData = null;
		Ext.destroy(jsonData);
		delete me;
	},
	reloadDashboard:function(loadUrl)
	{
		var dataURL = loadUrl;
		if(loadUrl==null || loadUrl==undefined || loadUrl=="")
			dataURL = '../servlet/com.eg.EgMonitorController?monCmd=jsonResponse';
		var jsonData;
		var me = this;
		Ext.Ajax.request({
			url : dataURL,
			timeout:280000,
			success: function(response){
				jsonData = Ext.decode(response.responseText);
				if(!Ext.isEmpty(me.getInfrastructureHealthView()) && !Ext.isEmpty(jsonData.infraHealth) && !Ext.isEmpty(jsonData.infraHealth.healthView) && !Ext.isEmpty(jsonData.infraHealth.healthView.componentslist))
				{
					//me.getMain().removeAll(false);
					Ext.getCmp('errorId').hide();
					if(me.getTopPanel().isVisible())
					{
						Ext.getCmp('summaryAndChartContainer').show();
					}
					else
					{
						Ext.getCmp('summaryAndChartContainer').hide();
					}
					Ext.getCmp('infrastructurehealthview').show();
					if(me.getBottomPanel().isVisible())
					{
						Ext.getCmp('measureandanalysis').show();
					}
					else
					{
						Ext.getCmp('measureandanalysis').hide();
					}
					me.getMain().show();
					var infHealthController=me.getController('InfrastructureHealthView');
					infHealthController.infrastructureHealthViewReload(jsonData.infraHealth);
					infHealthController = null;
					delete infHealthController;
					/*if(!Ext.isEmpty(me.getDashboardSummary())){
						me.getMain().show();
						me.getDashboardSummary().refreshData(jsonData.dashboardSummary);
						//me.getMain().doLayout();
					}
					if(!Ext.isEmpty(me.getDashboardSummaryChart())){
						me.getMain().show();
						me.getDashboardSummaryChart().refreshData(jsonData.dashboardChart);
						//me.getMain().doLayout();
					}
					if(!Ext.isEmpty(me.getMeasures())){
						me.getMeasures().refreshData(jsonData.measure,true);
						//me.getMain().show();
						//me.getMeasures().doLayout();
					}*/
					me.getMain().doLayout();
				}
				else{
					me.getMain().show();
					Ext.getCmp('errorId').show();
					Ext.getCmp('summaryAndChartContainer').hide();
					Ext.getCmp('infrastructurehealthview').hide();
					Ext.getCmp('measureandanalysis').hide();
					me.getMain().doLayout();
				}
			},
			failure : function(){
				//window.parent.location.href="/final/servlet/com.egurkha.Logout";
			}
		});
		dataURL=null;
		delete dataURL;
		jsonData = null;
		Ext.destroy(jsonData);
		delete me;
	}
});