Ext.define('monitor.view.HealthViewGrid', {
	extend: 'utilities.CustomGrid',
	//extend: 'Ext.grid.Panel',
	alias:'widget.healthviewgrid',
	cls:'gridSkin',
	dataArray:null,
	screenLabels:null,
	border:false,
	frame:false,
	forceFit : false,
	emptyText:'No records',
	style:{'border':'none !important'},
	initComponent : function() {
		this.store=Ext.create('Ext.data.Store', {
	     //fields: ['compType','href','count','tdWidth','curve','curveHref','size','sizeHref','backgroundColor','barchart'],
		fields: [{
				name : 'compType',
				sortType : 'asUCText'
			},{
				name : 'href'
			},{
				name : 'count',
				sortType : 'asFloat'
			},{
				name : 'tdWidth'
			},{
				name : 'curve'
			},{
				name : 'curveHref'
			},{
				name : 'size'
			},{
				name : 'sizeHref'
			},{
				name : 'backgroundColor'
			},{
				name : 'barchart'
			}
		],
	     proxy: {
	         type: 'memory',
	         reader: {
	             type: 'json'
	         }
	     },
		 sorters: { property: sortKey, direction : sortState },
	     autoLoad: true,
	     data:this.dataArray
	 });

		this.columns=[{
			header:!Ext.isEmpty(this.screenLabels['Component Type'])?this.screenLabels['Component Type']:"Component Type",
			dataIndex:'compType',
			width:200,
			menuDisabled: true,
			resizable: true,
			flex:.6,
			renderer:function(value,metaData,record,rowIndex){
				return '<a href="'+record.get('href')+'">'+value+'</a>';
			},
			listeners: {
				'headerclick': function(gridheader,eventobj, tml){
					sortKey = eventobj.dataIndex;
					sortState=eventobj.sortState;
				}
			}
		},{
			header:!Ext.isEmpty(this.screenLabels['Count'])?this.screenLabels['Count']:"Count",
			dataIndex:'count',
			menuDisabled: true,
			width:50,
			resizable: true,
			flex:.2,
			listeners: {
				'headerclick': function(gridheader,eventobj, tml){
					sortKey = eventobj.dataIndex;
					sortState=eventobj.sortState;
				}
			}
		},{
			header:!Ext.isEmpty(this.screenLabels['Status'])?this.screenLabels['Status']:"Status",
			dataIndex:'',
			width:300,
			menuDisabled: true,
			resizable: true,
			flex:2,
			renderer:function(value,metaData,record,rowIndex){
				var barchartObj = record.get('barchart');
				var htmlStr='<div class="healthviewgridbar"><div style="width:'+record.get('tdWidth')+'%;" class="outer12 cursorHand">'
				if ( !Ext.isEmpty( barchartObj ) )
				{
					for ( var i = 0; i < barchartObj.length ; i++ )
					{
						htmlStr += '<div id="'+barchartObj[i].backgroundColor+'" style="width:'+barchartObj[i].tdWidth+'%;" class="'+barchartObj[i].curve+'">'
						+'<a  href="'+barchartObj[i].sizeHref+'" style="display:block">'+barchartObj[i].size+'</a>'
						+'</div>';
					}
					htmlStr += '</div><div style="clear:both"></div></div>';
				}
				return htmlStr;

				barchartObj = null;
				delete barchartObj;

				htmlStr = null;
				delete htmlStr;
			}
		}];

		this.callParent();
	}
});