Ext.define('monitor.view.Main', {
	extend: 'Ext.container.Container',
	requires:['monitor.view.DashboardSummary','monitor.view.DashboardSummaryChart','monitor.view.MeasureAndAnalysisTab','monitor.view.InfrastructureHealthView','utilities.ErrorPanel'],
	alias:'widget.main',
	border:false,
	hidden:true,
	layout: {
		type: 'vbox',
		align: 'stretch'
	},
	items:[{
			xtype:'container',
			id:'summaryAndChartContainer',
			itemId:'topPanel',
			hidden:false,
			height:77,
			padding:2,
			margin:'8 8 0 8',
			cls:'top-summary-block',
			layout:{
				type:'hbox',
				align:'stretch'
			},
			items:[{
				xtype:'dashboardsummarychart',
				id:'dashboardsummarychart',
				padding:'0 10 0 0',
				hidden:false,
				flex:0.75
			},/*{
				xtype:'container',
				width:20,
				margin:'13 0 0 0'
			},*/{
				xtype:'dashboardsummary',
				id:'dashboardsummary',
				hidden:false,
				cls:'',
				margin:'0 0 0 0',
				flex:1.25
			}]
	},{
		title:'Infrastructure Health',
		xtype:'infrastructurehealthview',
		hidden:false,
		id:'infrastructurehealthview',
		height:234
	},{
		xtype:'measureandanalysis',
		id:'measureandanalysis',
		hidden:(!isShowBottomPanel),
		flex:0.90
	},{
		xtype:'errorpanel',
		errorMsg:error_message,
		imageCls:'iconInformation',
		width : 500,
		id:'errorId',
		title:'Monitor Dashboard',
		margin:'8 8 0 8',
		flex:1,
		frame:true,
		padding:'0',
		cls:'error-panel outerpanel',
		bodyStyle:{'margin-top':'15%'},
		style:{'text-align':'center'},
		hidden:true
	}],

listeners:{
		boxready:function(){
			


//alert('setTimeDelay'+setTimeDelay)

//TV MODE AUTO SCROLL FUNCTION
		Ext.defer(function(){

			
             
		if(!Ext.isEmpty(window.parent.isTvMode)){

			//var $ = $.noConflict();
			$.fn.hasScrollBar = function() {
					return $("body").height() > $(window).height();
			}
			//console.log("getTimeFrequency"+window.parent.Ext.getCmp('tvmode').getTimeFrequency)
			if(window.parent.isTvMode){
					var silderAction = window.parent.Ext.getCmp('tvmode').sliderAction;
					window.parent.Ext.getCmp('playBtn').ifScroll = false;
					var ifPageHasScroll = $('#indexmain-body').hasScrollBar();
					var count = 0;
					var ClickActionPause=false;
					var getTvModePlayAction = function () {
					//	console.log('count',count++)
								var silderAction = window.parent.Ext.getCmp('tvmode').sliderAction;
							if(silderAction == "pause"){
								Ext.get('indexmain-body').getActiveAnimation().paused = false;
								ClickActionPause = true;
								
								}
								else{
								clearTimeout( clearTimeOut );
								Ext.get('indexmain-body').getActiveAnimation().paused = true;
								window.parent.Ext.getCmp('tvmode').sliderObj.pause();
								ClickActionPause = false;
								}

							
							
							
								
					}
					var runner = new Ext.util.TaskRunner();
											 var task = runner.start({
												 run: getTvModePlayAction,
												 interval: 1000
												});
					
					var totalScrollLength = $("body").height() - $(window).height();
					var scrollHeightx = totalScrollLength * 100;
					var scrollHeightDurationx = totalScrollLength * 70;
					//var scrollHeightDurationx =1000;
					if(ifPageHasScroll){
						
						var sc = Ext.get('indexmain-body').getActiveAnimation().paused = true;
						window.parent.Ext.getCmp('tvmode').sliderObj.pause();
						var ifScrollt = window.parent.Ext.getCmp('playBtn').ifScroll = true;
					//	console.log("ifScrollt",ifScrollt)
					//	console.log("sc",sc)
						Ext.get('indexmain-body').scroll("b",
					scrollHeightx, 
					{
					duration:scrollHeightDurationx,
					listeners: {
										beforeanimate:function( el, eOpts ){		},
										afteranimate:function(el, startTime, eOpts ){
											Ext.get('indexmain-body').stopAnimation( );			
											Ext.defer(function(){
												window.parent.Ext.getCmp('tvmode').sliderObj.play();
												runner.destroy();
											},1000);
											window.parent.Ext.getCmp('playBtn').ifScroll = false;	
										}
						}
					},
					{
						scope: Ext.get('indexmain-body')
					});
						// if(ifScroll == true){
						// 	window.parent.Ext.getCmp('tvmode').sliderObj.pause();
						// 	  clearTimeout( clearTimeOut );
						// }

					}else{
						window.parent.Ext.getCmp('playBtn').ifScroll = false;
						window.parent.Ext.getCmp('tvmode').sliderObj.pause();
						if(ClickActionPause == true){
							clearTimeout( clearTimeOut );
							window.parent.Ext.getCmp('tvmode').sliderObj.pause();
							
						}
						else{
						var clearTimeOut = Ext.defer(function(){
								window.parent.Ext.getCmp('tvmode').sliderObj.play();  
						},window.parent.Ext.getCmp('tvmode').getTimeFrequency)  
						}
						

						
					}
					
			
		}
			
				
			}
		},500);
	//end TV MODE AUTO SCROLL FUNCTION


		}
	},

});
