Ext.define('monitor.view.Measures', {
	extend: 'utilities.CustomGrid',
	//extend: 'Ext.grid.Panel',
	alias:'widget.measures',
	itemId:'measures',
	border:false,
	forceFit : false,
	store:'monitor.store.Measures',
	screenLabels:null,
	autoScroll:true,
	//scroll:true,
	height:200,
	loadMask:true,
	cls:'gridSkin',
	   viewConfig: {
            stripeRows: true,
            enableTextSelection: true,
			   onItemMouseEnter: function(record, item, index, e) {

        if (this.trackOver) {
		return false;
           // this.highlightItem(item);
        }
    },

    // private
    onItemMouseLeave : function(record, item, index, e) {
        if (this.trackOver) {
			return false;
            //this.clearHighlight();
        }
    }

        },
	initComponent : function() {

		this.columns=[{
			header:'Measure',
			dataIndex:'measure',
			resizable: true,
			menuDisabled: true,
			flex:1,
			scope:this,
			renderer:function(value,metaData,record,rowIndex,colIndex){
				if(this.columns[colIndex].getVisibleIndex() % 2 != 0){
					//metaData.tdCls='odd-col';
				}
				return '<img style="vertical-align:middle;display:inline-block;margin-right:10px;margin-top:-2px;" src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" class="state_footer_'+record.get('state')+'"/><a href="'+record.get('links')+'">'+record.get('min_max')+' '+value+'</a>';
			}
		},{
			header:'Test',
			dataIndex:'test',
			resizable: true,
			menuDisabled: true,
			flex:1,
			scope:this,
			renderer:function(value,metaData,record,rowIndex,colIndex){
				if(this.columns[colIndex].getVisibleIndex() % 2 != 0){
					//metaData.tdCls='odd-col';
				}
				return '<a href="'+record.get('links')+'">'+value+'</a>';
			}
		},{
			header:'Component - Descriptor',
			dataIndex:'componentName',
			resizable: true,
			menuDisabled: true,
			flex:2,
			scope:this,
			renderer:function(value,metaData,record,rowIndex,colIndex){
				if(this.columns[colIndex].getVisibleIndex() % 2 != 0){
					//metaData.tdCls='odd-col';
				}
				return '<a href="'+record.get('links')+'">'+decodeURIComponent(value)+'<i>'+record.get('componentIndex')+'</i></a>';
			}
		},{
			header:'Value',
			dataIndex:'value',
			resizable: true,
			menuDisabled: true,
			flex:1,
			scope:this,
			renderer:function(value,metaData,record,rowIndex,colIndex){
				if(this.columns[colIndex].getVisibleIndex() % 2 != 0){
					//metaData.tdCls='odd-col';
				}
				return '<a href="'+record.get('links')+'">'+value+' '+record.get('valueUnit')+'</a>';
			}
		}];

		this.callParent();
	},

	onRender : function(){
		this.callParent();
	},

	refreshData : function(jsonData,updateLabels){
		if(!Ext.isEmpty(this.getEl())){
			this.getEl().setHeight(Ext.getBody().getViewSize().height/3);
			this.getEl().setWidth(Ext.getBody().getViewSize().width);
			this.getEl().mask("Loading...");
		}
		if(!Ext.isEmpty(updateLabels) && updateLabels === true){
			if(!Ext.isEmpty(jsonData)){
				var screenLabels=jsonData.screenLabels;
				this.screenLabels=jsonData.screenLabels;
				this.updateLabels(screenLabels);

				screenLabels = null;
				delete screenLabels;
			}
		}

		if(!Ext.isEmpty(jsonData.measures)){
			this.getStore().loadRawData(jsonData);
		}
		else{
			var tabpanel=this.findParentByType('tabpanel').child('#measures');
			this.findParentByType('tabpanel').remove(tabpanel);
		}

		if(!Ext.isEmpty(this.getEl())){
			this.getEl().unmask();
		}
	},

	updateLabels:function(screenLabels){
		if(!Ext.isEmpty(this.columns)){
			this.columns[0].setText(screenLabels["monitor.home.Measure"]);
			this.columns[1].setText(screenLabels["monitor.common.Test"]);
			this.columns[2].setText(screenLabels["monitor.home.Component"]);
			this.columns[3].setText(screenLabels["monitor.home.Value"]);
		}
		this.setTitle(screenLabels["Measure At-A-Glance"]);
	}
});
