Ext.define('monitor.view.MeasuresGrid', {
	extend: 'utilities.CustomGrid',
	//extend: 'Ext.grid.Panel',
	alias:'widget.measuresgrid',
	itemId:'measuresgrid',
	border:false,
	forceFit : true,
	autoScroll:true,
	columnLabels:["Measure","Test","Component","Value"],

	initComponent : function() {

	this.columns=[{
		header:this.columnLabels[0],
		dataIndex:'measure',
		width:200,
		scope:this,
		renderer:function(value,metaData,record,rowIndex,colIndex){
			if(this.columns[colIndex].getVisibleIndex() % 2 != 0){
				metaData.tdCls='odd-col';
			}
			return '<a href="'+record.get('links')+'">'+value+'</a>';
		}
	},{
		header:this.columnLabels[1],
		dataIndex:'test',
		width:100,
		scope:this,
		renderer:function(value,metaData,record,rowIndex,colIndex){
			if(this.columns[colIndex].getVisibleIndex() % 2 != 0){
				metaData.tdCls='odd-col';
			}
			return '<a href="'+record.get('links')+'">'+value+'</a>';
		}
	},{
		header:this.columnLabels[2],
		dataIndex:'componentName',
		width:200,
		scope:this,
		renderer:function(value,metaData,record,rowIndex,colIndex){
			if(this.columns[colIndex].getVisibleIndex() % 2 != 0){
				metaData.tdCls='odd-col';
			}
			return '<a href="'+record.get('links')+'">'+value+'<i>'+record.get('componentIndex')+'</i></a>';

		}
	},{
		header:this.columnLabels[3],
		dataIndex:'value',
		width:50,
		scope:this,
		renderer:function(value,metaData,record,rowIndex,colIndex){
			if(this.columns[colIndex].getVisibleIndex() % 2 != 0){
				metaData.tdCls='odd-col';
			}
			return '<a href="'+record.get('links')+'">'+value+' '+record.get('valueUnit')+'</a>';
		}
	}];
	this.listeners={
			scope:this,
			'columnhide':function(){
				this.getView().refresh();
			},
			'columnshow':function(){
				this.getView().refresh();
			}
	};
	this.callParent();
}
});