Ext.define('monitor.view.ProblemAnalysis', {
	extend: 'Ext.form.Panel',
	alias:'widget.problemanalysis',
	requires:['monitor.view.ProblemAnalysisProblems','monitor.view.ProblemAnalysisComponents','utilities.ErrorPanel'],
	screenLabels:null,
	id:'eventAnalysis',
	height:'100%',
	layout:{
		type:'hbox',
		align:'stretch'
	},
	//cls:'problem-analysis',
	
	items:[{
		xtype:'problemanalysisproblems',
		flex:1
	},{
		xtype:'problemanalysiscomponents',
		flex:1
	}],
	onRender : function(){
		this.callParent();
	},
	
	refreshData : function(jsonData,updateLabels){
		if(!Ext.isEmpty(this.getEl())){
			this.getEl().mask("Loading...");
		}
		if(!Ext.isEmpty(jsonData)){
			var screenLabels=jsonData.screenLabels;
			this.screenLabels=screenLabels;

			screenLabels = null;
			delete screenLabels;
		}
		if(!Ext.isEmpty(jsonData.problemAnalysis)){
			if(!Ext.isEmpty(jsonData.problemAnalysis.problems) || !Ext.isEmpty(jsonData.problemAnalysis.components)){
				var errorPanel=Ext.fly('analysis-error-panel');

				if(!Ext.isEmpty(errorPanel)){
					var tabpanel=this.findParentByType('tabpanel');
					tabpanel.remove(errorPanel);

					tabPanel = null;
					delete tabPanel;
				}
				var tabpanel=this.findParentByType('tabpanel');
				tabpanel.child('#eventanalysis').tab.show();
				var problemGrid=this.getComponent(0);
				problemGrid.getStore().loadRawData(jsonData);
				
				var componentsGrid=this.getComponent(1);
				componentsGrid.duration=jsonData.problemAnalysis.duration;
				if(!Ext.isEmpty(componentsGrid.getStore()))
					componentsGrid.getStore().loadRawData(jsonData);

				lastProbsDuration = jsonData.problemAnalysis.duration;

				errorPanel = null;
				delete errorPanel;

				problemGrid = null;
				delete problemGrid;

				componentsGrid = null;
				delete componentsGrid;
			}
			else
			{
				this.showNoEventsMsg();
			}
		}
		else{
			this.showNoDataMsg();
		}
		
		if(!Ext.isEmpty(this.screenLabels)){

			if(!Ext.isEmpty(updateLabels) && updateLabels === true){
				this.updateLabels(screenLabels);
			}
		}
		if(!Ext.isEmpty(this.getEl())){
			this.getEl().unmask();
		}
	},

	showNoDataMsg:function(){
		var tabpanel=this.findParentByType('tabpanel');
		var errorMessage=this.screenLabels["monitor.info.noDataMsg"];
		var errorPanel=Ext.fly('analysis-error-panel');
    	if(Ext.isEmpty(errorPanel)){
    		var errPanel=Ext.create('utilities.ErrorPanel',{
				imageCls:'iconNoalarms',
				margin:'10',
				flex:1,
				padding:'0',
				cls:'error-panel',
				bodyStyle:{'margin-top':'5%'},
				style:{'text-align':'center'},
				id:'analysis-error-panel',
    			errorMsg:errorMessage,
				title:this.title
    		});
    		tabpanel.add(errPanel);
    		tabpanel.setActiveTab(errPanel);

			errPanel = null;
			delete errPanel;
    	}else{
    		tabpanel.setActiveTab(errorPanel);
    	}
    	tabpanel.child('#eventanalysis').tab.hide();

		tabpanel = null;
		delete tabpanel;

		errorMessage = null;
		delete errorMeassage;

		errorPanel = null;
		delete errorPanel;
	},
	
	showNoEventsMsg:function(){
		var tabpanel=this.findParentByType('tabpanel');
		var errorMessage=this.screenLabels["monitor.info.noEventsMsg"];
		var errorPanel=Ext.fly('analysis-error-panel');
    	if(Ext.isEmpty(errorPanel)){
    		var errPanel=Ext.create('utilities.ErrorPanel',{
    			
				imageCls:'iconNoalarms',
				margin:'10',
				flex:1,
				padding:'0',
				cls:'error-panel',
				bodyStyle:{'margin-top':'5%'},
				style:{'text-align':'center'},
				id:'analysis-error-panel', 
    			errorMsg:errorMessage,
				title:this.title
    		});
    		tabpanel.add(errPanel);
    		tabpanel.setActiveTab(errPanel);

			errPanel = null;
			delete errPanel;
    	}
		else
		{
    		tabpanel.setActiveTab(errorPanel);
    	}
    	tabpanel.child('#eventanalysis').tab.hide();
		
		tabpanel = null;
		delete tabpanel;

		errorMessage = null;
		delete errorMeassage;

		errorPanel = null;
		delete errorPanel;
	},
	
	updateLabels:function(screenLabels){
		//for problems grid
		var problemGrid=this.getComponent(0);
		problemGrid.columns[0].setText(screenLabels["monitor.home.Layer"]);
		problemGrid.columns[1].setText(screenLabels["monitor.home.Unresolved Problems"]);
		problemGrid.columns[2].setText(screenLabels["monitor.home.Average Duration"]);
		problemGrid.columns[3].setText(screenLabels["monitor.home.Maximum Duration"]);
		problemGrid.getView().refresh();
		
		//for components grid
		 var componentsGrid=this.getComponent(1);
		 componentsGrid.columns[0].setText(screenLabels["monitor.home.Type"]);
		 componentsGrid.columns[1].setText(screenLabels["monitor.home.Name"]);
		 componentsGrid.columns[2].setText(screenLabels["monitor.home.Events"]);
		 componentsGrid.getView().refresh();
		 
		 this.setTitle(screenLabels["Event Analysis"]);

		 problemGrid = null;
		 delete problemGrid;

		 componentsGrid = null;
		 delete componentsGrid;
	}
});