Ext.define('monitor.view.ProblemAnalysisComponents', {
	//extend: 'CustomGrid',
	extend: 'utilities.CustomGrid',
	//extend: 'Ext.grid.Panel',
	alias:'widget.problemanalysiscomponents',
	duration:"",
	flex:1,
	height:200,
	cls:'gridSkin border-left',
	margin:'0 0 0 10',
	//cls:'problem-analysis-components',
	store:'monitor.store.ProblemAnalysisComponents',

    viewConfig: {
        getRowClass: function(record, index, rowParams, store) {
			if(record.get('componentType')=='hourCombo'){
				return "first-row";
			}
            return '';
        }
    },

	initComponent : function() {

		this.columns=[{
			header:CmpTypeLbl,
			dataIndex:'componentType',
			menuDisabled: true,
			sortable:false,
			resizable: true,
			flex:1,
			renderer:function(value,metaData,record,rowIndex){
			    if(value!='hourCombo'){
			    	return '<a href="'+record.get('address')+'">'+value+'</a>';
			    }else{
			    	return "";
			    }
			}
		},{
			header:CmpNameLbl,
			dataIndex:'componentName',
			menuDisabled: true,
			sortable:false,
			resizable: true,
			flex:1,
			renderer:function(value,metaData,record,rowIndex){
				if(record.get('componentType')!='hourCombo'){
					return '<a href="'+record.get('address')+'">'+decodeURI(value)+'</a>';
				}else{
					metaData.style="overflow:visible;padding-top:5px;";
					return decodeURI(value);
				}
			}
		},{
			header:eventsLbl,
			menuDisabled: true,
			//align:'center',
			dataIndex:'events',
			sortable:false,
			resizable: true,
			flex:1,
			renderer:function(value,metaData,record,rowIndex){
				if(record.get('componentType')=='hourCombo'){
					if(!Ext.isEmpty(Ext)){
						var divId = Ext.id();
						Ext.Function.defer(this.renderCombo,25,this,[divId]);
						return (Ext.String.format('<center><div id="{0}" style="position:absolute"></div></center>',divId));

						divId = null;
						delete divId;
					}

					return value;
				}else{
					return value;
				}
			}
		}];
			this.callParent();
	},

	renderCombo : function(divId) {
				var hours = Ext.create('Ext.data.Store', {
					fields : [ 'value', 'name' ],
					data : [ {
						"value" : "1 hour",
						"name" : "1 "+hourLbl
					}, {
						"value" : "6 hours",
						"name" : "6 "+hoursLbl
					}, {
						"value" : "12 hours",
						"name" : "12 "+hoursLbl
					}, {
						"value" : "18 hours",
						"name" : "18 "+hoursLbl
					}, {
						"value" : "24 hours",
						"name" : "24 "+hoursLbl
					} ]
				});

				var comboInitialValue="1 "+hourLbl;
				if(!Ext.isEmpty(this.duration)){
					comboInitialValue=this.duration;
				};

				if(!Ext.isEmpty(Ext.fly(divId))){
					new Ext.form.ComboBox({
						fieldLabel : compEnvLbl,
						labelStyle:'',
						labelSeparator:'',
						labelAlign:'right',
						labelCls:'hourCombo-label',
						store : hours,
						editable:false,
						width:100,
						cls:'dropdown hourCombo',
						queryMode : 'local',
						displayField : 'name',
						valueField : 'value',
						renderTo : divId,
						value:comboInitialValue,
						listeners:{
							scope:this,
							'change':function(cmp,newValue,oldValue){
								this.fireEvent('hourComboChange',{'newValue':newValue});
							}
						}
					});
				}

				comboInitialValue = null;
				delete comboInitialValue;

				hours = null;
				delete hours;

	},

	afterRender:function(){
		this.getStore().on('load',this.storeLoadHandler,this);
		this.getStore().on('refresh',this.storeRefreshHandler,this);
		this.callParent();
	},

	storeRefreshHandler:function(store){
		var index=store.find('events','hours',0,true,false);
		if(index>-1){
			store.removeAt(index);
			store.insert(0,{
				'componentType':'hourCombo',
				'events':'24 hours'
			});
		}

		index = null;
		delete index;
	},

	storeLoadHandler:function(store,records){
		store.insert(0,{
			'componentType':'hourCombo',
//			'componentName':'Components with most events in the last',
			'events':'24 hours'
		});
	}

});