Ext.define('monitor.view.ProblemAnalysisProblems', {
	extend:'utilities.CustomGrid',
	//extend:'Ext.grid.Panel',
	alias:'widget.problemanalysisproblems',
	flex:1,
	margin:'0 0 0 0',
	id:'problems',
	cls:'gridSkin border-right',
	store:'monitor.store.ProblemAnalysisProblems',
    viewConfig: {
        getRowClass: function(record, index, rowParams, store) {
			if(record.get('layer').toLowerCase()=="summary"){
				return "row-bold";
			}
			else if ( record.get('layer').toLowerCase() == 'linklayer' )
			{
				return "first-row";
			}
            return '';
        }
    },
	initComponent : function() {

		this.columns=[{
			header:layerLbl,
			menuDisabled: true,
			dataIndex:'layer',
			resizable: true,
			flex:2,
			sortable:false,
			renderer: function(value, metaData, record, rowIndex)
			{
				if ( value == 'linklayer' )
				{
					return "";
				}
				else
				{
					return value;
				}
			}
		},{
			header:openAlarmsLbl,
			menuDisabled: true,
			sortable:false,
			dataIndex:'unresolvedPrblms'
		},{
			header:avgDurationLbl,
			menuDisabled: true,
			dataIndex:'avgDur',
			resizable: true,
			flex:1,
			sortable:false,
			renderer: function(value, metaData, record, rowIndex)
			{
				if ( record.get('layer') == 'linklayer' )
				{
					var divId = Ext.id();
					var idx = this.store.find('layer','linklayer',0,true,false,false);
					return (Ext.String.format('<div id="{0}" style="position:absolute;right:0px;margin-right:25px;"><a href="/final/monitor/EgSiteInfraView.jsp?disphist=yes&fromePage=true" style="text-decoration:underline;vertical-align:middle">'+linkMoreEvents+' <img src="/final/images/clear.png" border="0" class="iconTreeRightArrow" style="margin-bottom:-5px"></a></div>',divId));
				}
				else
				{
					return value;
				}
			}
		},{
			header:maxDurationLbl,
			menuDisabled: true,
			resizable: true,
			flex:1,
			sortable:false,
			dataIndex:'maxDur'
		}];
			this.callParent();
	},
	afterRender:function(){
		this.getStore().on('load',this.storeLoadHandlerForLink,this);
		this.callParent();
	},
	storeLoadHandlerForLink:function(store,records){
		if (store.getCount() >= 6)
		{
			store.insert(0, {'layer':'linklayer'});
		}
	}
});