var errorPanel = false;
var curServiceName='';
var reqArray = [
		'citrixDashboard.view.Main',
		'citrixDashboard.view.OverviewPanel',
		'citrixDashboard.view.OverviewVerticalPanel',
		'citrixDashboard.view.OverviewCtxPanel',
		'citrixDashboard.view.CitrixDashMenu',
		'widgets.ChartPanel',
		'widgets.ChartParentPanel',
		'citrixDashboard.view.Resources',
		'citrixDashboard.view.UxDashboard',
		'citrixDashboard.view.LogonActivity',
		'citrixDashboard.view.BrokerActivity',
		'citrixDashboard.view.Applications',
		'citrixDashboard.view.Overview',
		'citrixDashboard.view.Sessions',
		'citrixDashboard.view.GeoPanel',
		'citrixDashboard.view.Geo',
		'citrixDashboard.view.Alerts',
		'citrixDashboard.view.Metrics',
		'citrixDashboard.view.Systems',
		'citrixDashboard.view.Aggregates',
		'citrixDashboard.view.Topology',
		'citrixDashboard.view.LogonDashboard',
		'citrixDashboard.view.WebTransactionsDashboard',
		'citrixDashboard.view.EmulatedDashboard',
		'citrixDashboard.view.TransactionsChartPanel',
		'citrixDashboard.view.TransactionGridPanel',
		'citrixDashboard.view.MetricsComponentList',
		'widgets.SessionsParentPanel',
		'citrixDashboard.view.ListView',
		'citrixDashboard.view.CustomConfigTemplateWindow',
		'sessionSimulation.view.SessionSimulation'
	];
			
/*if(!Ext.isEmpty(isZoneViewNeeded) && isZoneViewNeeded){
	var zoneViewArray = ['citrixDashboard.view.ZonesDetails'];
	for(var c in zoneViewArray)
		reqArray.push(zoneViewArray[c]);
}*/

Ext.define('citrixDashboard.controller.Main', {
    extend: 'Ext.app.Controller',
	requires :reqArray,
	transactionMeasuresChartURL:"/final/servlet/com.egurkha.TransactionMeasures",
	time_line_obj:null,
	chart_url:null,
	siteName:null,	
	refs:[
	{
		ref: 'main',
		selector: 'main'
	},
	{
		ref: 'overviewdetails',
		selector: 'overviewdetails'
	},
	{
		ref: 'citrixdashmenu',
		selector: 'citrixdashmenu'
	},
	{
		ref:'chartpanel',
		selector: 'chartpanel'
	},
	{
		ref:'resources',
		selector: 'resources'
	},
	{
		ref:'transactiongridpanel',
		selector: 'transactiongridpanel'
	},
	{
		ref:'transactionschartpanel',
		selector: 'transactionschartpanel'
	},
	{
		ref:'myTimeWindow',
		selector:'floatingContainer'
	},
	{
		ref:'myTimelinePanel',
		selector:'floatingContainer > panel'
	},
	{
		ref : 'transactionComboMode',
		selector : 'floatingContainer > panel > combo[itemId= "mode"]'
	},
	{
		ref : 'systemPanel',
		selector : 'dashboardgeneralmeasuresgridpanel[itemId="system"]'
	},
	{
		ref : 'transactionComboTimeline',
		selector : 'floatingContainer > panel > combo[itemId= "timeline"]'
	},
	{
		ref : 'transactionComboFromhr',
		selector : 'floatingContainer > panel > combo[itemId= "fromhr"]'
	},
	{
		ref : 'transactionComboTohr',
		selector : 'floatingContainer > panel > combo[itemId= "tohr"]'
	},
	{
		ref : 'transactionComboFrommin',
		selector : 'floatingContainer > panel > combo[itemId= "frommin"]'
	},
	{
		ref : 'transactionComboTomin',
		selector : 'floatingContainer > panel > combo[itemId= "tomin"]'
	},
	{
		ref : 'transactionFromDate',
		selector : 'floatingContainer > panel > datefield[itemId= "from"]'
	},
	{
		ref : 'transactionToDate',
		selector : 'floatingContainer > panel > datefield[itemId= "to"]'
	},
	{
		ref:'transactionsPanelToolbar',
		selector:'floatingContainer > panel'
	},
    	{
		ref : 'mydashboardlistview',
		selector : 'mydashboardlistview'
	},
	{
		ref : 'customConfigTemplateWindow',
		selector : 'customConfigTemplateWindow'
	}
	],
    init: function() {
		setInterval("execute()",panelRefFreq);
		this.control({
			'overviewdetails': {
				afterrender: this.overviewdetailsRender
			},
			'button[itemId="overviewtoggle"]': {
				toggle: this.toggleOverView
			},
			'applications':{ 
				'render':this.loadView,
			},
			'geo':{ 
				'render':this.loadView,
			},
			'overview':{ 
				'render':this.loadView,
			},
			'resources':{
				'render':this.loadView,
			},
			'alerts':{
				'render':this.loadView,
			},
			'metrics':{
				'render':this.loadView,
			},
			'systems':{
				'render':this.loadView,
			},
			'aggregates':{
				'render':this.loadView,
			},
			'uxdashboard':{
				'render':this.loadView,
			},
			'sessions':{
				'render':this.loadView,
			},
			'logonactivity':{
				'render':this.loadView,
			},
			'brokeractivity':{
				'render':this.loadView,
			},
			'topology':{
				'render':this.loadView,
			},
			'logondashboard':{
				'render':this.loadView,
			},
			'webtransactionsdashboard':{
				'render':this.loadView,
			},
			'emulateddashboard':{
				'render':this.loadView,
			},
			'transactionschartpanel button[id= "settingBt"]':{
				click:this.settingClick
			},			  
			'transactionschartpanel':{
				'afterrender':this.onChartsPanelRender
			},			  
			'floatingContainer > panel > combo[itemId= "timeline"]':{
				select:this.timelineChangeHandler // Date 
			},
			'floatingContainer > panel > button[action = "transactionGraphBtn"]':{
				click:this.displayGraph
			},
			'main combo[id="TimeLineId"]':{
				'select': this.refresh
			},
			'main button[id="back"]':
			{
				'click': this.goBack
			},
			'geo combo[id="countryComboId"]':
			{
				'select': this.geoComboOnChange
			},
			'geo combo[id="regionComboId"]':
			{
				'select': this.geoComboOnChange
			},
			'generalMeasuresGridPanel combo[id="filterByCombo"]':{
				'select':this.compFilterByComboOnChange
			},
			'generalMeasuresGridPanel combo[id="subFilterCombo"]':{
				change:this.compSubFilterComboOnChange
			},
			'generalMeasuresGridPanel combo[id="componentTypCombo"]':{
				change:this.componentTypeComboOnChange
			},
			'dashboardgeneralmeasuresgridpanel[itemId="system"] > panel > toolbar > combobox':{
       				change:this.systemsComboChange
       			},
			'dashboardgeneralmeasuresgridpanel[itemId="system"] > toolbar > combobox':{
       				change:this.systemsComboChange
       			},
			'generalMeasuresGridPanel combo[id="sortByCombo"]':{
				'select':this.componentsmeasureComboChange
			},
			'generalMeasuresGridPanel textfield[id="nickName"]':{
				specialkey: function(field, e){
					if (e.getKey() == e.ENTER) {
						this.compSubmitButtonClicked();
					}
				}
			},
			'main button[id="listBtn"]' : {
				'click' : this.loadListView
			},
			'main button[action="addNew"]' : {
				'click' : this.loadAddDashboardPopup
			},
			'main checkbox[id="selectAllDashboards"]': {
				'change':this.checkboxClick
			},
			'main button[id="DeleteListOfDashboards"]': {
				'click':this.deleteSelectedDashBoards
			},
			'customConfigTemplateWindow  combo[id="infraTypeCombo"]' : {
				'select' : this.getCustomOptionsForType
			},
			'customConfigTemplateWindow  combo[id="subInfraTypeCombo"]' : {
				'select' : this.setValuesForSiteAndDirector
			},
			'customConfigTemplateWindow  button[id="customCreateDashboardBtn"]' : { 
				'click' : this.createCtxCustomDashboard
			},
			'button[action = "transactionsGridConfigureBtn"]':{
				'click':this.configureTransactionsHandler
			},
		});
	},
	configurePanels : function(jsonData){
		
		var itemsArray =new Array();
		var upperPanel= "";
		var trans = [];
		
		var comboStore = Ext.create('Ext.data.Store',{
			fields:['value','name'],
			proxy:{
				type: 'memory',
				reader: {
					type: 'json',
					root:'options'
				}
			},
			data:jsonData.IconsInfo
		});
		
		//setValue("");
		if(trans.length<12){
			var addtransactionDetails = {
				xtype:'form',
				//width:780,
				//cls:'formOuter',
				bodyPadding:0,
				margin:'0px 0px 0px 0px',
				defaults:{
					labelSeparator:'',
					labelAlign:'top',
					margin:'5px 10px 10px 10px',
				},
				layout:'hbox',
				items:[
				{
							xtype: 'scrollcombo',
							//cls : 'dropdown',
							store:comboStore,
							id:'imagecombo',
							cls:'imagecombo',
							name:'imagecombo',
							displayField:'name',
							valueField:'value',
							queryMode: 'local',
							editable: false,
							typeAhead: false,
							editable:false,
							value:'Choose a type',
							fieldLabel: jsonData.DownGridLabels.newTransType,
							tpl: Ext.create('Ext.XTemplate',
								'<ul>',
								'<tpl for=".">',
									'<li class="x-boundlist-item"><span style="padding-left:18px" class=trans_{value}_small></span><span style="font-size: 12px;">{name}</span></li>',
								'</tpl>',
								'</ul>'
							),
							listeners:{
								select:function(combo, records, eOpts){
									var record = records[0];
									var image = record.get('value');
									cls = 'trans_'+image+'_small';
									if(image){
										$('#'+combo.inputEl.id).removeClass().addClass(cls);
									}
									
			
								}
							},
							// template for the content inside text field
							/*displayTpl: Ext.create('Ext.XTemplate',
								'<tpl for=".">',
									'{name}',
								'</tpl>'
							)*/
						},
				 {
						xtype : 'textfield',
						cls:'textbox',
						fieldLabel:jsonData.DownGridLabels.newTransName,
						
						
						//cls : 'configure-transaction-textfield',
						//fieldCls:'top-left-radius top-right-radius bottom-left-radius bottom-right-radius',
						
						labelSeparator:'',
						width : '220px',
						labelAlign:'top',
						id : 'tname',
						action : 'tname'
					}, {
						xtype : 'textfield',
						fieldLabel:jsonData.DownGridLabels.pagesToInclude,
						labelAlign:'top',
						cls:'textbox',
						
						//cls : 'configure-transaction-textfield',
						//fieldCls:'top-left-radius top-right-radius bottom-left-radius bottom-right-radius',
						
						labelSeparator:'',
						labelAlign:'top',
						width : '210px',
						action : 'tpage',
						id : 'tpage'
					},{
						xtype : 'button',
						text : jsonData.DownGridLabels.addBtnLabel,
						
						//cls : 'delete-service-transaction-button',
						action:'addAction',
						id:'addButton',
						cls: 'button20',
						margin:'27px 10px 0px 10px',
						handler: function() {
							var transNameStr = Ext.getCmp('tname').getValue();
							var incluedPageStr = Ext.getCmp('tpage').getValue();
							//var imagecomboStr = Ext.getCmp('imagecombo').getRawValue();
							var imagecomboStr = Ext.getCmp('imagecombo').getRawValue();
							var imagecomboDispStr = Ext.getCmp('imagecombo').getValue();
							var siteName = jsonData.HiddenFields.site;
							if(siteName==null || siteName==undefined)
								siteName = jsonData.HiddenFields.siteName;
							var cuserName = jsonData.HiddenFields.currentuser;
							if( Ext.isEmpty(imagecomboStr) || Ext.isEmpty(transNameStr) || Ext.isEmpty(incluedPageStr) )
							{
								Ext.Msg.alert('Empty',"Choose required fields");
								return;
							}
							else
							{
								//incluedPageStr =  services.app.getController("Main").checkFields(incluedPageStr,'Page Include');
								

								var arrayValue2 = [];
								var arrayValue1 = [];

								var styleStr = '<div><img style="padding-left:18px;vertical-align:middle;dispaly:inline-block" src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" class="trans_'+imagecomboDispStr+'_small"/>'+imagecomboStr+'</div>';
								//styleStr = styleStr;
								arrayValue1.push(styleStr);
								arrayValue1.push(transNameStr);
								arrayValue1.push(incluedPageStr);
								arrayValue2.push(arrayValue1);

								 

								var resultUrl = "../monitor/addTransactionsP.jsp?mode=add&site="+siteName+"&m="+imagecomboDispStr+"&currentuser="+cuserName+"&tran="+transNameStr+"&pageinclude="+incluedPageStr+"&isFromCitrix=true";
								Ext.Ajax.request({
									url: resultUrl,
									method: 'POST',
									async: false,
									success: function( response )
									{
										if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
										{
											
											
											var gridValue = Ext.getCmp('gridStore');
											if(!Ext.isEmpty(gridValue))
											{
												var recCount = gridValue.getStore().getCount()+1;
												gridValue.getStore().insert(recCount,arrayValue2);
												Ext.getCmp('tname').setValue('');
												Ext.getCmp('tpage').setValue('');
											}
											else
											{
												
											}
										}
									}
								});
							}

					    }
						
					}
				]
			}
			var topToolbar= {
					xtype : 'toolbar',
					docked : 'top',
					cls : 'component-list-right-panel-header',
					height : '30px',
					style:{'border':'0px solid red !important'},
					border:false,
					frame:false,
					items : [{
						xtype : 'label',
						text : jsonData.DownGridLabels.newTransName,
						cls : 'configure-transaction-label',
						action : 'tname'
					}, {
						xtype : 'textfield',
						cls:'textbox',
						margin:'0px 20px 0px 0px',
						//cls : 'configure-transaction-textfield',
						//fieldCls:'top-left-radius top-right-radius bottom-left-radius bottom-right-radius',
						labelCls :'config-window-font',
						labelSeparator:'',
						width : '200px',
						itemId : 'tname',
						action : 'tname'
					}, {
						xtype : 'label',
						text : jsonData.DownGridLabels.pagesToInclude,
						cls : 'configure-transaction-label'
					}, {
						xtype : 'textfield',
						cls:'textbox',
						margin:'0px 20px 0px 0px',
						//cls : 'configure-transaction-textfield',
						//fieldCls:'top-left-radius top-right-radius bottom-left-radius bottom-right-radius',
						labelCls :'config-window-font',
						labelSeparator:'',
						width : '250px',
						action : 'tpage',
						itemId : 'tpage'
					},'->',{
						xtype : 'button',
						text : jsonData.DownGridLabels.addBtnLabel,
						cls: 'button20',
						//cls : 'delete-service-transaction-button',
						itemId :'addbtn',
						action:'addbtn',
					}]
				}
				// Transaction image changes start here
				var transImages = [{
						xtype : 'panel',
						width : '100%',
						height : 25,
						border : false,
						html : '<div class="configure-transaction-info-text">&nbsp;* '+jsonData.DownGridLabels.info+'</div>'
				}];

				for(i=0;i<jsonData.IconsInfo.length;i++){
					transImages.push({
						xtype : 'container',
						width : 80,
						margin:14,
						layout:'column',
						border : true,
						items:[{
							xtype : 'radio',
							name : 'transaction',
							cls : 'radiobt',
							margin:'5 4 0 2',
							value:jsonData.IconsInfo[i].value			//Prem
						},{
							xtype:'component',
							html : '<div class="trans_'+jsonData.IconsInfo[i].value+'" title="'+jsonData.IconsInfo[i].name+'"></div>',
							listeners:{
								render: function(imageObj){
									imageObj.getEl().on({
										click: function() {
											imageObj.prev().setValue(true);
										}
									});
								}
							}
						}]
					});
				}
				// end here
			var lowerPanel = {
					xtype : 'panel',
					//autoScroll:true,
					
					width : '100%',
					cls:'block1',
					border:false,
					frame:false,
					
					//scrollable : true,
					//cls : 'new-transaction-panel',
					//bodyCls:'bottom-left-radius bottom-right-radius',
					flex : 3,
					layout:'vbox',
					items :[addtransactionDetails]			 // changes
				};
			
			//lowerPanel.xtype = 'scrollpanel';
			//lowerPanel.dockedItems=topToolbar;
			itemsArray.push(lowerPanel);
		}
		
			{
			var transArray = new Array();
			trans = jsonData.upperGridLabels.transHeaders;
			var panel = "";
			if(trans.length==0){
						var toolbar = {
								xtype : 'toolbar',
								docked : 'top',
								style:{'border':'0px solid red !important'},
								border:false,
								frame:false,
								//cls : 'top-left-radius top-right-radius',
								items : [{
									xtype : 'label',
									text : jsonData.upperGridLabels.transactionName,
									cls :'delete-service-transaction-label'
									},'->',
									{
									xtype : 'button',
									text : jsonData.upperGridLabels.deleteBtn,
									action : 'deleteTrans',
									//cls : 'delete-service-transaction-button',
									cls : 'button20',
									user : jsonData.upperGridLabels.user,
									
									tname : jsonData.upperGridLabels.transactionName,
									currentUser : Ext.isEmpty(jsonData.HiddenFields.currentuser)?"":jsonData.HiddenFields.currentuser
								}]
						}
				 panel = {
						xtype : 'panel',
						cls:'service-transaction-toolbar',
						//bodyCls:'bottom-left-radius bottom-right-radius',
						border:false,
						frame:false,
						style:{'border':'0px solid blue !important'},
						width : '100%',
						html : jsonData.upperGridLabels.files
						}
						panel.dockedItems = toolbar;
						transArray.push(panel);
			}
			var toolbar ="";
			var myOuterArray = [];
			var myData = [];
			for(var i=0; i < trans.length; i++){
				if(user_name != 'admin' && user_name == trans[i].user)
					this.enableSelectAll = true;

				var trmpStr = '<div><img style="padding-left:18px;vertical-align:middle;dispaly:inline-block" src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" class="trans_'+trans[i].img+'_small"/>'+trans[i].uiImg+'</div>';
				//var trmpStr = '<div class="x-boundlist-item"><span style="padding-left:18px" class="'+trans[i].img+'"></span>'+trans[i].uiImg+'</div>';
				myData.push([trmpStr,trans[i].transactionName,trans[i].files]);
			}
			myOuterArray.push(myData);
			var store = Ext.create('Ext.data.ArrayStore', {
				fields: [
				   {name: 'Type'},
				   {name: 'Transaction Name'},
				   {name: 'Pages'}
				],
				data: myData
			});
				var grid = {
					xtype:'grid',
					id:'gridStore',
					height : 405,
					border:false,
					cls:'gridSkin',
					store:store,
					columns: [
								{
									text     : 'Type',
									flex     : .25,
									sortable : false,
									dataIndex: 'Type'
								},
								{
									text     : 'Transaction Name',
									//width    : 150,
									flex     : .3,
									sortable : true,
									dataIndex: 'Transaction Name'
								},
								{
									text     : 'Pages',
									//width    : 75,
									flex     : .4,
									sortable : true,
									dataIndex: 'Pages'
								},{
									xtype:'actioncolumn',
									width:32,
									items:[{
									iconCls:'iconDelete',
									tooltip:'Delete',
									 handler: function(grid, rowIndex, colIndex) {
											if(Ext.isEmpty(grid))
											{
												alert("No data found");
											}
											else
											{
												var rec = grid.getStore().getAt(rowIndex);
												
												var columnValue = grid.getStore().getAt(colIndex);
												var transName = rec.raw[1];
												var siteName = jsonData.HiddenFields.site;
												if(siteName==null || siteName==undefined)
													siteName = jsonData.HiddenFields.siteName;
												var cuserName = jsonData.upperGridLabels.user;
												var resultUrl = "../monitor/addTransactionsP.jsp?mode=del&site="+siteName+"&currentuser="+cuserName+"&trans="+transName+"&isFromCitrix=true";
												Ext.Ajax.request({
													url: resultUrl,
													method: 'POST',
													async: false,
													success: function( response )
													{
														if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
														{
															grid.getStore().removeAt(rowIndex);
															
														}
													}
												});
											}
										}
									}]
								}]
					}
				
			//}

			upperPanel = {
				xtype : 'panel',
				height : 405,
				padding:0,
				border:false,
				items:[grid],
				margin:'0 10 0 10',
				flex : 4
			}
			itemsArray.push(upperPanel);
		}
		return itemsArray;
	},
	configureTransactionsHandler:function(fromTopo,site){
		if(this.siteName == null || this.siteName == "null")
			this.siteName = selectedParam;
		var newUrl = loadTransConfigOnTopo(this.siteName);
		Ext.Ajax.request({
			url: newUrl,
			scope:this,
			timeout:280000,
			success: function(response){
				var jsonText = response.responseText;
				var jsonData=Ext.decode(jsonText);
				this.jsonData = jsonData;
				//if(!Ext.isEmpty(fromTopo) && fromTopo == true)
					//this.getController('ServicesTopology').jsonData = jsonData;
				//this.getTransactionsMainPanel().removeAll();
				//var topToolbar=this.getTransactionsMainPanel().getDockedItems('toolbar[dock="top"]');
				//if(!Ext.isEmpty(topToolbar))
					//topToolbar[0].setVisible(false);
				var items = this.configurePanels(jsonData);
				//var selectButtonFlag = this.getTransactionsMainPanel().enableSelectAll;
				//Ext.getCmp('imagecombo').getStore().loadRawData(publicJSON['imageArray']);
				/*this.getTransactionsMainPanel().add({
					xtype : 'configuretransactions',
					items : items,
					flex : 1
				});*/
					var configWindow = Ext.create('Ext.window.Window',{
						cls:'alarmsbg lightbox',
						width:810,
						closeAction:'destroy',
						autoDestroy:true,
						frame:true,
						doClose: function() {
							var me = this;
							location.reload();
							//this.destroy();
							//citrixDashboard.app.getController("Main").refresh();
						},
						modal:false,
						title:'CONFIGURE TRANSACTION DETAILS',
						height:510,
						margin:10,
						items : items,
						flex : 1
						//id:'w1'
				});
				configWindow.show();				
			},
			failure:function(){
				window.parent.location.href="/final/servlet/com.egurkha.Logout";
			}
		});
	},
	getGroupPanelArray:function(chartdata1,id,a,mainObj,headingVal){
		var conatiner = {
			xtype:'panel',
			layout:{
				type:'hbox',
				align:'strech'
			},
			minHeight:140,
			items:[],
			margin:0,
			padding:'10 0 0 0',
			listeners:{
				'afterrender':function(e){
					var me = this;
					for(var b in chartdata1)
					{
						var chart_type1 = chartdata1[b]['chart'];
						if(chart_type1 != undefined && chart_type1 == 'GraphText' )
						{
							var id=chart_type1+'_GraphText_'+b+'_overviewextra';
							var marginVal = '0 40 0 0';
							if(b == 2)
								marginVal = '0 0 0 0';
							var graphtextPanel = citrixDashboard.app.getController("Main").getGraphtextPanel(chartdata1[b],id,b,marginVal);
							me.add(graphtextPanel);									
							Ext.getCmp(id).removeCls("widgetcon");
						}
						else if(chart_type1 != undefined && chart_type1.toLowerCase() == 'gauge' )
						{
							var id=chart_type1+'_Gauge_'+b+'_overviewextra';
							var marginVal = '0 0 0 0';
							var graphtextPanel = citrixDashboard.app.getController("Main").getGaugePanel(chartdata1[b],id,b,true);
							me.add(graphtextPanel);				
							if(b == 2)
								Ext.getCmp(id).removeCls("widgetcon");
						}
						else if(chart_type1 != undefined && chart_type1 == 'ColourText' )
						{
							var id=chart_type1+'_ColourText_'+b+'_overviewextra';
							var marginVal = '0 0 0 0';
							var colourtextPanel = citrixDashboard.app.getController("Main").getColourTextPanel(chartdata1[b],id,b,true);
							me.add(colourtextPanel);									
						}
					}

				}
			}
		}
		return conatiner;
	},
	getGraphtextPanel:function(obj,id,a,marginVal){
		var panelCls='separator_measure';
		
		if (a==0)
		{
			panelCls='';
		}
		var dafault_colr='#35c8c2';
		if(obj.colorValue != undefined)
			dafault_colr = obj.colorValue; 

		
		var container = {
			xtype:'panel',
			flex:1,
			margin:0,
			margin:marginVal,
			bodyPadding:'5 0 0 0',
			autoScroll:false,
			minHeight:160,
			items:[{
				xtype:'graphtext',
				cls:'widgetcon font_bold12',
				ifVer:false,
				data:obj,
				id:id,
				num:id+'_'+a,
				aid:a
			}],
		};
		return container;
	},
	getGaugePanel:function(obj,id,a,noWidth){
		var panelCls='separator_measure';

		if (a==0)
		{
			panelCls='';
		}
		var dafault_colr='#35c8c2';
		if(obj.colorValue != undefined)
			dafault_colr = obj.colorValue; 
		
		var minWidthObj = null;
		var ifGroupObj = true;
		var classNeeded = '';
		if(Ext.isEmpty(noWidth) || (!Ext.isEmpty(noWidth) && !noWidth)){
			ifGroupObj = false;
			minWidthObj = 165;	
			classNeeded = 'widgetcon';
		}

		var container = {
			xtype:'panel',
			cls:classNeeded+' font_bold12',
			baseCls:'panelHeader',
			margin:'-10 0 0 0',
			flex:1,
			minWidth:minWidthObj,
			items:[
				{
					xtype:'gauge',
					data:obj,
					id:id,
					num:id+'_'+a,
					//cls:'widgetcon',
					titleNeeded:true,
					ifGroup:ifGroupObj,
					ifOvCtxPFlag:true
				}	
			],
		};
		return container;
	},
	getColourTextPanel:function(obj,id,a,noWidth){
		var panelCls='separator_measure';

		if (a==0)
		{
			panelCls='';
		}
		var dafault_colr='#35c8c2';
		var minWidthObj = null;
		var ifGroupObj = true;
		var classNeeded = '';
		if(Ext.isEmpty(noWidth) || (!Ext.isEmpty(noWidth) && !noWidth)){
			ifGroupObj = false;
			minWidthObj = 165;	
			classNeeded = 'widgetcon';
		}
		var container = {
			xtype:'panel',
			cls:classNeeded+' font_bold12',
			baseCls:'panelHeader',
			margin:'20 0 0 10',
			flex:1,
			minWidth:minWidthObj,
			items:[
				{
					xtype:'colourtext',
					ifVer:false,
					data:obj,
					id:id,
					num:id+'_'+a,
					ifGroup:ifGroupObj,
				}	
			],
		};
		return container;
	},
	goBack: function()
	{
		var isFromZone1 = false;

		if(isFromZone != undefined && isFromZone != null && isFromZone == "true")
			isFromZone1 = true;
		
		if((isFromZone1 && !isFromZoneMain) || (isFromZone1 && !isFromZoneMain && ((parentZone !=null && parentZone != 'null' && parentZone != undefined && parentZone != 'undefined' && parentZone !='') ||(iszoneName !=null && iszoneName != 'null' && iszoneName != undefined && iszoneName != 'undefined' && iszoneName !=''))))
		{
			window.location.href = '/final/monitor/zoneDash.jsp?&selectNode=Zone$cap$'+iszoneName+'&selectedParam='+iszoneName+'&currentTab=details&zoneName='+iszoneName+'&iszoneName='+iszoneName+'&aggregateTab=false&openNode=null&treeFlag=false&fromHomepage=true&parentZone='+parentZone+'&fromZoneMenu='+isFromZoneMenu;
		}
		else if(isFromHomePage && !isFromServiceMenu && !isFromZoneMain && !isFromServiceGroup)
			window.location.href = "/final/servlet/com.eg.EgMonitorController?monCmd=dashboard";
		else if(isFromZonePage && !isFromZoneMain)
			window.location.href = "/final/servlet/com.eg.EgMonitorController?monCmd=zoneList&from=MainDashboard&action=zone";
		else if(isFromServiceMenu && !isFromZoneMain)
		{
			window.location.href = "/final/servlet/com.eg.EgMonitorController?monCmd=serviceList&from=MainDashboard&action=service&isFromMenu=true";
		}
		else if(isFromServiceGroup)
		{
			document.location="/final/servlet/com.eg.EgMonitorController?monCmd=serviceList&from=MainDashboard&action=serviceGroup&isFromMenu=true";	
		}
		else if(isFromZoneMain)
		{
			window.location.href = "/final/servlet/com.eg.EgMonitorController?monCmd=zoneList&from=MainDashboard&action=zone&isFromMenu=true";	
		}        
		else
			window.history.go(-1);
	},
	onComponentChange:function(combo,activeTab,siteName,simulationSelectedOrgValue,selected_view_name)
	{
		//added because when component changes the chart was not being displayed properly
		var comboVal = combo.getValue();
		refreshSimulation = "";
		if(activeTab != null && activeTab == 'webTrans')
		{
			selectedCompTypeValue = comboVal;
		}
		else
		{
			selectedCompTypeValue = '';
		}
		if(activeTab != null && activeTab == 'logonSim')
		{
			var logonComponentList = extSimData[comboVal];
			var compCombo = Ext.getCmp('simulationCombo');
			compCombo.getStore().removeAll();
			compCombo.getStore().loadRawData('');
			compCombo.getStore().loadRawData(logonComponentList);
			compCombo.setValue(logonComponentList.selectedValue);
			compCombo.setFieldLabel(logonComponentList.label);	
			
			var compComboValue = logonComponentList.selectedValue;
			var dashboard_grid_containerObj = Ext.getCmp('dashboard_container_grid');	
			var dashboard_chart_containerObj = Ext.getCmp('dashboard_container_chart');	
			selectedVal = comboVal;
			var selected_dash = '';
			if(!Ext.isEmpty(Ext.getCmp('dashListComId')) && Ext.getCmp('dashListComId')!=null && Ext.getCmp('dashListComId')!=undefined)
				selected_dash = Ext.getCmp('dashListComId').getValue();
			
			//if(siteName != null)
				//fromServiceDashboard = true;
			var simulationSelectedOrgValue1 = "";
			if(compComboValue != null && compComboValue.indexOf(":NULL") > -1)
				simulationSelectedOrgValue1 = compComboValue.substring(0,compComboValue.indexOf(":NULL"));
			else
			{
				simulationSelectedOrgValue1 = compComboValue;
				compComboValue = compComboValue+":NULL";
			}
			var perf_url = "/final/monitor/comparisonLogonSimulator.jsp?"+logonParam+"&componentType=&selectedState=&subFilter=&simulationName="+simulationSelectedOrgValue1+"&externalAgent="+selectedVal+"&isfromCitrix=true&iniName="+iniName+"&user_name="+user_name+"&dashboard_mapping="+selected_dash+"&dashboard_name="+dashboard+"&view_name="+selected_view_name+"&fromServiceDashboard="+fromServiceDashboard+"&servicename="+siteName+"&fromSerComboChange="+fromSerComboChange+"&fromServiceHomePage="+isFromHomePage+"&isFromZone="+isFromZone+"&iszoneName="+iszoneName+"&parentZone="+parentZone+"&componentNameService="+compComboValue+"&isLogonType=true&filter=service&filterBy="+encodeURIComponent(filterByParamFlag)+"&isFromServiceMenu="+isFromServiceMenu+"&isFromZoneMain="+isFromZoneMain+"&isFromZoneMenu="+isFromZoneMenu+"&isFromServiceGroup="+isFromServiceGroup;

			var transurl = "/final/monitor/simulationGraph.jsp?treeTitle=services&site=NULL&mHost="+selectedVal+"&simulationName="+simulationSelectedOrgValue1+"&componentNameService="+compComboValue;
			
			Ext.Ajax.request({
				url : transurl,
				scope:this,
				async:true,
				success: function(response){
					var jsonText = response.responseText;
					//var panelArr = new Array();
					if(!Ext.isEmpty(jsonText))
					{
						var jsondata1 = Ext.decode(jsonText);
						if(jsondata1 != null && jsondata1 != undefined)
						{
							if(!Ext.isEmpty(dashboard_grid_containerObj))
								dashboard_grid_containerObj.removeAll(true);
							var css_class='gridHeadercenter iconGrid';
							if(!Ext.isEmpty(logon_treeTitle) && logon_treeTitle=='ExtTestDashboard')
								css_class='gridHeadercenter';

							dashboard_grid_containerObj.add({
								xtype:'generalMeasuresGridPanel',
								plugins:Ext.create('Ext.ux.AutoColumnWithLockingPlugin'),
								//title:titlesys,
								//title:perf_disp_name+" --Man At Work--",
								cls:css_class,
								//itemId:itemIdforsysandcom,
								itemId:'logonSimualtion',
								searchBoxCombo:false,
								margin:0,
								padding:0,
								id:'perPanel',
								height:185,
								frame:false,
								border:true,
								layout:{type:'vbox',align:'stretch'},
								flex:1,
								screenLabelPath:"monitor.Dashboard",
								url:perf_url,
								listeners: {
									'afterrender': function (obj) {
										this.loadTab(obj.url,null,null,null,null,true,"citrixDashBoard");
									}
								}
							});

							if(!Ext.isEmpty(dashboard_chart_containerObj))
								dashboard_chart_containerObj.removeAll(true);

							//panelArr.push({
							dashboard_chart_containerObj.add({
								xtype:'transactionschartpanel',
								id:'transactionschartpanelid',
								//animCollapse:true,
								//columnWidth:1.0,
								//height:255,
								//height:(Ext.getBody().getViewSize().height - 225),
								//flex:1,
								jsonData:jsondata1,
								minHeight:265,
								margin:'10 1 0 0',
								//margin:'5 0 0 0',
								padding:0,
								//flex:0.57,
								border:true,
								isNotAreaChart:false
							});
						
							//curViewPort.add(panelArr);
							//curViewPort.doLayout();
						}
					}
				  },
				failure:function(){
					//window.parent.location.href="/final/servlet/com.egurkha.Logout";
				}
			});
			return;
		}
		var service = siteName;
		if(service==null || service==undefined || service=='null')
			return;
		var fromLayer = false;
		var url= '/final/monitor/serviceDashHelper.jsp?&site='+encodeURI(service)+'&isSite=true&serviceName='+encodeURI(service)+'&fromLayer='+fromLayer;
		
    	  
	    /*var timeLineCombo=this.getTransactionChartComboTimeline();
		  var fromHrCombo=this.getTransactionChartComboFromhr();
		  var toHrCombo=this.getTransactionChartComboTohr();
		  var modeCombo=this.getTransactionChartComboMode();
		  var fromDateCombo=this.getTransactionChartFromDate();
		  var toDateCombo=this.getTransactionChartToDate();*/

		var timeLineCombo=this.getTransactionComboTimeline();
		var fromHrCombo=this.getTransactionComboFromhr();
		var toHrCombo=this.getTransactionComboTohr();
		var modeCombo=this.getTransactionComboMode();
		var fromDateCombo=this.getTransactionFromDate();
		var toDateCombo=this.getTransactionToDate();
	    	  
		if(!Ext.isEmpty(combo)){
		  url+="&transComp="+combo.getValue();
		}
		if(this.tab=="emulated"){
		  url+="&selectedTab=EmulatedClients&from=emulated";
		}
		else
		{
		  url+="&selectedTab="+this.tab;
		}
		if(!Ext.isEmpty(timeLineCombo)){
		  url+="&time_line="+timeLineCombo.getValue();
		  if(timeLineCombo.getValue()=='Any')
		  {
				if(!Ext.isEmpty(fromHrCombo))
				 url+="&starthr="+fromHrCombo.getValue();

				if(!Ext.isEmpty(toHrCombo))
				  url+="&endhr="+toHrCombo.getValue();

				if(!Ext.isEmpty(modeCombo))
				  url+="&mode="+modeCombo.getValue();

				if(!Ext.isEmpty(fromDateCombo))
				{
				  tempstarttime=Ext.Date.format(fromDateCombo.getValue(),mgr_dateFormat);
				  url+="&starttime="+tempstarttime;
				}
				if(!Ext.isEmpty(toDateCombo))
				{
				  tempendtime=Ext.Date.format(toDateCombo.getValue(),mgr_dateFormat);
				  url+="&endtime="+tempendtime;
				}
			}
		}			  
		
		// url=this.getTransactionsMainPanel().url;
		Ext.Ajax.request({
			url :url,
			scope:this,
			success: function(response){
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				if(jsonData.HiddenFields!=null && jsonData.HiddenFields.siteName!=undefined)
				{
					var siteName = jsonData.HiddenFields.siteName;
					if(siteName!=null && siteName!=undefined)
						citrixDashboard.app.getController('Main').siteName=siteName;
				}
				citrixDashboard.app.getController('Main').showTransactionGridPanelData(jsonData.GridScreenLabels,jsonData);
				//this.loadTransaction(jsonData);
			},
			failure:function(){
				//window.parent.location.href="/final/servlet/com.egurkha.Logout";
			}
		});
	},
	showTransactionGridPanelData:function(screenLabels ,jsonData){
		var tabPanelAll = Ext.getCmp('tabAll');
		var selectedTabProp = new Object();
		
		var hideConfigIcon = true;
		selectedTabProp['title'] = screenLabels["emulBtnLabel"];
		selectedTabProp['itemId'] = 'serviceToolbarEmulatedButton';
		selectedTabProp['dataUrl'] = screenLabels["emulBtnURL"];
		var isEmuEnabled = ( !Ext.isEmpty(screenLabels["emulBtnLabel"]) )?true:false;
		
		var compCombo22 = Ext.getCmp('componentCombo');
		var ComponentList = jsonData.ComponentList;
		var siteName = jsonData.HiddenFields.siteName;
		
		if(siteName!=null && siteName!=undefined)
			citrixDashboard.app.getController('Main').siteName=siteName;
			//services.app.getController("ServicesTransactions").siteName=siteName;
		var label='',selectedVal='';
		var defalutHide = true;
		var comboStore;
		if(!Ext.isEmpty(ComponentList) && ComponentList!=null && ComponentList!=undefined)
		{
			defalutHide = false;
		}
		if(!Ext.isEmpty(compCombo22)){
			if(defalutHide == false || defalutHide == 'false')
			{
				try{
					compCombo22.suspendEvents(true);
					compCombo22.getStore().removeAll();
					compCombo22.getStore().loadRawData('');
					compCombo22.getStore().loadRawData(ComponentList);
					compCombo22.setValue(ComponentList.selectedValue);
					compCombo22.setFieldLabel(ComponentList.label);
					compCombo22.resumeEvents();
				}catch(e){
					alert(e)
				}
			}
			else
			{
				compCombo22.setVisible(false);
			}
		}

		if (strSkin=="Dark")
		{
			skinBg="#444444";
		}
		else if (strSkin=="Light")
		{
			skinBg="#ffffff";
		}

		var dashboard_view_container_gridObj = Ext.getCmp('dashboard_view_container_grid');	
		var dashboard_view_container_chartObj = Ext.getCmp('dashboard_view_container_chart');	

		var dashboard_grid_containerObj = Ext.getCmp('dashboard_container_grid');	
		var dashboard_chart_containerObj = Ext.getCmp('dashboard_container_chart');	

		//var dashboard_grid_emu_containerObj = Ext.getCmp('dashboard_container_Emu_Grid');	
		//var dashboard__chart_emu_containerObj = Ext.getCmp('dashboard_container_Emu_Chart');
		
		var grid_container;
		var chart_container;
		if(!Ext.isEmpty(dashboard_view_container_gridObj) && !Ext.isEmpty(dashboard_view_container_chartObj)){
			grid_container = dashboard_view_container_gridObj;
			chart_container = dashboard_view_container_chartObj;
		}else if(!Ext.isEmpty(dashboard_grid_containerObj) && !Ext.isEmpty(dashboard_chart_containerObj)){
			grid_container = dashboard_grid_containerObj;
			chart_container = dashboard_chart_containerObj;
		}
		/*else if(!Ext.isEmpty(dashboard_grid_emu_containerObj) && !Ext.isEmpty(dashboard__chart_emu_containerObj)){
			grid_container = dashboard_grid_emu_containerObj;
			chart_container = dashboard__chart_emu_containerObj;
		}*/
		
		grid_container.removeAll();
		chart_container.removeAll();
		grid_container.add({
			xtype:'transactiongridpanel',
			id:'transactiongridpanelid',
			ui:'newGridPanel',
			//title:'<span class="font_bold12">Transactions-&&&</span>',
			//columnWidth:1.0,
			jsonData:jsonData,
			isEmuEnabled:isEmuEnabled,
			margin:'0 0 0 0',
			padding:0,
			height:185,
			autoScroll:false,
			scroll:false,
			border:true
			
		});
		chart_container.add({
			xtype:'transactionschartpanel',
			id:'transactionschartpanelid',
			//title:'Graphs',
			columnWidth:1.0,
			//height:500,
			jsonData:jsonData,
			margin:'10 0 0 0',
			padding:0,
			//flex:0.57,
			border:false,
			layout:{type:'fit'},
			//style:{'overflow':'auto'}
				
		});		
	},
	onComponentTypeChange:function(combo,activeTab,siteName,componentType,selected_view_name){

		var selCompType='';
		var selSimulation = '';
		var selAgent='';
		var temLogonParam = '';
		var selSimulOrg = '';
		var comboVal = combo.getValue();
		if(activeTab != null && activeTab == 'logonSim')
		{
			var selected_dash = '';
			if(!Ext.isEmpty(Ext.getCmp('dashListComId')) && Ext.getCmp('dashListComId')!=null && Ext.getCmp('dashListComId')!=undefined)
				selected_dash = Ext.getCmp('dashListComId').getValue();

			var d_url = '/final/monitor/transactions.jsp?componentType='+comboVal+'&treeTitle=services&1=1&selectNode=Service$cap$'+encodeURIComponent(filterByParamFlag)+'&selectedParam='+encodeURIComponent(filterByParamFlag)+'&currentTab=transactions&aggregateTab=false&hasTransactions=true&hasEmulatedTransactions=false&fromHomepage=&hasLogonSimulations=true&site='+encodeURIComponent(filterByParamFlag)+'&isSite='+isSite+'&serviceName='+encodeURIComponent(filterByParamFlag)+'&fromLayer=false&selectNode='+encodeURIComponent(filterByParamFlag)+'&currentTab=transactions&transTab=true&from=null&treeOpen=false&openNode=Services&refresh=true&action=service&topoSegment='+encodeURIComponent(filterByParamFlag)+'&isfromCitrix=true&iniName='+iniName+'&user_name='+user_name+'&dashboard_mapping='+selected_dash+'&dashboard_name='+dashboard+'&view_name='+selected_view_name+"&fromServiceHomePage="+isFromHomePage+"&fromSerComboChange="+fromSerComboChange+"&isFromZone="+isFromZone+"&iszoneName="+iszoneName+"&parentZone="+parentZone+"&fromLogonTab=true";
			Ext.Ajax.request({
				url:d_url,
				timeout:280000,
				scope:this,
				success: function(response){
					var jsonText = response.responseText;
					if(!Ext.isEmpty(jsonText))
					{
						var jsonData = Ext.decode(jsonText);
						var externalAgentList = jsonData.externalAgents;
						var logonComponentList = jsonData.logonComponentList;
						var componentListObj = jsonData.componentListObj;
						selCompType=componentListObj.selectedValue;
						selSimulation = '';
						selAgent=externalAgentList.selectedValue;

						temLogonParam = jsonData.logonParam;
						var compCombo = Ext.getCmp('componentCombo');
						if(!Ext.isEmpty(compCombo))
							compCombo.setVisible(true);
						var simulationCombo = Ext.getCmp('simulationCombo');
						if(!Ext.isEmpty(simulationCombo))
							simulationCombo.setVisible(true);

						var compTypecombo = Ext.getCmp('compTypeCombo');
						if(!Ext.isEmpty(compTypecombo))
							compTypecombo.setVisible(true);
						
						if(!Ext.isEmpty(compTypecombo) && componentListObj!=null && componentListObj!=undefined)
						{
							selectedCompType=componentListObj.selectedValue;
						}

						if(!Ext.isEmpty(compCombo) && externalAgentList!=null && externalAgentList!=undefined)
						{
							selectedExtAgent = externalAgentList.selectedValue;

							//simulation combo data set start
							if(!Ext.isEmpty(simulationCombo) && logonComponentList!=null && logonComponentList!=undefined)
							{
								extSimData = logonComponentList;
								logonComponentList = logonComponentList[selectedExtAgent];
								selectedSimulation = logonComponentList.selectedValue;
								selSimulation = logonComponentList.selectedValue;
								selSimulOrg = logonComponentList.selectedOrgValue;

								if(!Ext.isEmpty(simulationCombo.getValue()))
								{
									simulationCombo.getStore().removeAll();
									simulationCombo.getStore().loadRawData('');
									simulationCombo.getStore().loadRawData(logonComponentList);
									simulationCombo.setFieldLabel(logonComponentList.label);
									simulationCombo.setValue(logonComponentList.selectedValue);
								}
								else
								{
									var simcomboStore = Ext.create('Ext.data.Store',{
										fields:['value', 'name', 'comptype'],
										proxy:{
											type: 'memory',
											reader: {
												type: 'json',
												root:'options'
											}
										},
										data:logonComponentList
									});
									simulationCombo.bindStore(simcomboStore);
									simulationCombo.setFieldLabel(logonComponentList.label);
									simulationCombo.setValue(logonComponentList.selectedValue);
								}
							}
							//simulation combo data set end

							if(!Ext.isEmpty(compCombo.getValue()))
							{
								compCombo.getStore().removeAll();
								compCombo.getStore().loadRawData('');
								compCombo.getStore().loadRawData(externalAgentList);
								compCombo.setFieldLabel(externalAgentList.label);
								compCombo.setValue(externalAgentList.selectedValue);
							}
							else
							{
								var comboAgentStore = Ext.create('Ext.data.Store',{
									fields:['value', 'name'],
									proxy:{
										type: 'memory',
										reader: {
											type: 'json',
											root:'options'
										}
									},
									data:externalAgentList
								});
								compCombo.bindStore(comboAgentStore);
								compCombo.setFieldLabel(externalAgentList.label);
								compCombo.setValue(externalAgentList.selectedValue);
							}
						}
						

						var dashboard_grid_containerObj = Ext.getCmp('dashboard_container_grid');	
						var dashboard_chart_containerObj = Ext.getCmp('dashboard_container_chart');	
						selectedVal = comboVal;
						var selected_dash = '';
						if(!Ext.isEmpty(Ext.getCmp('dashListComId')) && Ext.getCmp('dashListComId')!=null && Ext.getCmp('dashListComId')!=undefined)
							selected_dash = Ext.getCmp('dashListComId').getValue();
						
						var simulationSelectedOrgValue1 = "";
						if(selSimulation != null && selSimulation.indexOf(":NULL") > -1)
							simulationSelectedOrgValue1 = selSimulation.substring(0,selSimulation.indexOf(":NULL"));
						else
							simulationSelectedOrgValue1 = selSimulation;

						var perf_url = "/final/monitor/comparisonLogonSimulator.jsp?"+logonParam+"&componentType=&selectedState=&subFilter=&simulationName="+simulationSelectedOrgValue1+"&externalAgent="+selAgent+"&isfromCitrix=true&iniName="+iniName+"&user_name="+user_name+"&dashboard_mapping="+selected_dash+"&dashboard_name="+dashboard+"&view_name="+selected_view_name+"&fromServiceDashboard="+fromServiceDashboard+"&servicename="+siteName+"&fromSerComboChange="+fromSerComboChange+"&isFromZone="+isFromZone+"&iszoneName="+iszoneName+"&parentZone="+parentZone+"&componentNameService="+selSimulOrg+"&isLogonType=true&filter=service&filterBy="+encodeURIComponent(filterByParamFlag)+"&isFromServiceMenu="+isFromServiceMenu+"&isFromZoneMain="+isFromZoneMain+"&isFromZoneMenu="+isFromZoneMenu+"&isFromServiceGroup="+isFromServiceGroup;

						if(temLogonParam != null && temLogonParam != '' && temLogonParam != undefined)
							perf_url ="/final/monitor/comparisonLogonSimulator.jsp?"+temLogonParam+"&componentType=&selectedState=&subFilter=&simulationName="+simulationSelectedOrgValue1+"&externalAgent="+selAgent+"&isfromCitrix=true&iniName="+iniName+"&user_name="+user_name+"&dashboard_mapping="+selected_dash+"&dashboard_name="+dashboard+"&view_name="+selected_view_name+"&fromServiceDashboard="+fromServiceDashboard+"&servicename="+siteName+"&fromSerComboChange="+fromSerComboChange+"&isFromZone="+isFromZone+"&iszoneName="+iszoneName+"&parentZone="+parentZone+"&componentNameService="+selSimulOrg+"&isLogonType=true&filter=service&filterBy="+encodeURIComponent(filterByParamFlag)+"&isFromServiceMenu="+isFromServiceMenu+"&isFromZoneMain="+isFromZoneMain+"&isFromZoneMenu="+isFromZoneMenu+"&isFromServiceGroup="+isFromServiceGroup;

						var transurl = "/final/monitor/simulationGraph.jsp?treeTitle=services&site=NULL&mHost="+selAgent+"&componentNameSearch="+selSimulation+"&componentNameService="+selSimulOrg;
						
						Ext.Ajax.request({
						url : transurl,
						scope:this,
						async : true,
						success: function(response){
							var jsonText = response.responseText;
							if(!Ext.isEmpty(jsonText))
							{
								var jsondata1 = Ext.decode(jsonText);
								if(jsondata1 != null && jsondata1 != undefined)
								{
									if(!Ext.isEmpty(dashboard_grid_containerObj))
										dashboard_grid_containerObj.removeAll(true);

									var css_class='gridHeadercenter iconGrid';
									if(!Ext.isEmpty(logon_treeTitle) && logon_treeTitle=='ExtTestDashboard')
										css_class='gridHeadercenter';

									dashboard_grid_containerObj.add({
										xtype:'generalMeasuresGridPanel',
										plugins:Ext.create('Ext.ux.AutoColumnWithLockingPlugin'),
										cls:css_class,
										itemId:'logonSimualtion',
										searchBoxCombo:false,
										margin:0,
										padding:0,
										id:'perPanel',
										height:185,
										frame:false,
										border:true,
										layout:{type:'vbox',align:'stretch'},
										flex:1,
										screenLabelPath:"monitor.Dashboard",
										url:perf_url,
										listeners: {
											'afterrender': function (obj) {
												this.loadTab(obj.url,null,null,null,null,true,"citrixDashBoard");
											}
										}
									});

									if(!Ext.isEmpty(dashboard_chart_containerObj))
										dashboard_chart_containerObj.removeAll(true);

									dashboard_chart_containerObj.add({
										xtype:'transactionschartpanel',
										id:'transactionschartpanelid',
										jsonData:jsondata1,
										minHeight:265,
										margin:'10 1 10 0',
										padding:0,
										border:true,
										isNotAreaChart:false
									});
								}
							}
						  },
						failure:function(){
							//window.parent.location.href="/final/servlet/com.egurkha.Logout";
						}
					});	
					}
				},
				failure:function(){

					var dashboard_grid_containerObj = Ext.getCmp('dashboard_container_grid');	
					var dashboard_chart_containerObj = Ext.getCmp('dashboard_container_chart');	
					selectedVal = comboVal;
					var selected_dash = '';
					if(!Ext.isEmpty(Ext.getCmp('dashListComId')) && Ext.getCmp('dashListComId')!=null && Ext.getCmp('dashListComId')!=undefined)
						selected_dash = Ext.getCmp('dashListComId').getValue();

					var simulationSelectedOrgValue1 = "";
					if(selSimulation != null && selSimulation.indexOf(":NULL") > -1)
						simulationSelectedOrgValue1 = selSimulation.substring(0,selSimulation.indexOf(":NULL"));
					else
						simulationSelectedOrgValue1 = selSimulation;

					var perf_url = "/final/monitor/comparisonLogonSimulator.jsp?"+logonParam+"&componentType=&selectedState=&subFilter=&simulationName="+simulationSelectedOrgValue1+"&externalAgent="+selAgent+"&isfromCitrix=true&iniName="+iniName+"&user_name="+user_name+"&dashboard_mapping="+selected_dash+"&dashboard_name="+dashboard+"&view_name="+selected_view_name+"&fromServiceDashboard="+fromServiceDashboard+"&servicename="+siteName+"&fromSerComboChange="+fromSerComboChange+"&isFromZone="+isFromZone+"&iszoneName="+iszoneName+"&parentZone="+parentZone+"&componentNameService="+selSimulOrg+"&isLogonType=true&filter=service&filterBy="+encodeURIComponent(filterByParamFlag)+"&isFromServiceMenu="+isFromServiceMenu+"&isFromZoneMain="+isFromZoneMain+"&isFromZoneMenu="+isFromZoneMenu+"&isFromServiceGroup="+isFromServiceGroup;

					if(temLogonParam != null && temLogonParam != '' && temLogonParam != undefined)
						perf_url ="/final/monitor/comparisonLogonSimulator.jsp?"+logonParam+"&componentType=&selectedState=&subFilter=&simulationName="+simulationSelectedOrgValue1+"&externalAgent="+selAgent+"&isfromCitrix=true&iniName="+iniName+"&user_name="+user_name+"&dashboard_mapping="+selected_dash+"&dashboard_name="+dashboard+"&view_name="+selected_view_name+"&fromServiceDashboard="+fromServiceDashboard+"&servicename="+siteName+"&fromSerComboChange="+fromSerComboChange+"&isFromZone="+isFromZone+"&iszoneName="+iszoneName+"&parentZone="+parentZone+"&componentNameService="+selSimulOrg+"&isLogonType=true&filter=service&filterBy="+encodeURIComponent(filterByParamFlag)+"&isFromServiceMenu="+isFromServiceMenu+"&isFromZoneMain="+isFromZoneMain+"&isFromZoneMenu="+isFromZoneMenu+"&isFromServiceGroup="+isFromServiceGroup;

					var transurl = "/final/monitor/simulationGraph.jsp?treeTitle=services&site=NULL&mHost="+selAgent+"&componentNameSearch="+selSimulation+"&componentNameService="+selSimulOrg;
					
					Ext.Ajax.request({
					url : transurl,
					scope:this,
					async : true,
					success: function(response){
						var jsonText = response.responseText;
						if(!Ext.isEmpty(jsonText))
						{
							var jsondata1 = Ext.decode(jsonText);
							if(jsondata1 != null && jsondata1 != undefined)
							{
								if(!Ext.isEmpty(dashboard_grid_containerObj))
									dashboard_grid_containerObj.removeAll(true);

								var css_class='gridHeadercenter iconGrid';
								if(!Ext.isEmpty(logon_treeTitle) && logon_treeTitle=='ExtTestDashboard')
									css_class='gridHeadercenter';

								dashboard_grid_containerObj.add({
									xtype:'generalMeasuresGridPanel',
									plugins:Ext.create('Ext.ux.AutoColumnWithLockingPlugin'),
									cls:css_class,
									itemId:'logonSimualtion',
									searchBoxCombo:false,
									margin:0,
									padding:0,
									id:'perPanel',
									height:185,
									frame:false,
									border:true,
									layout:{type:'vbox',align:'stretch'},
									flex:1,
									screenLabelPath:"monitor.Dashboard",
									url:perf_url,
									listeners: {
										'afterrender': function (obj) {
											this.loadTab(obj.url,null,null,null,null,true,"citrixDashBoard");
										}
									}
								});

								if(!Ext.isEmpty(dashboard_chart_containerObj))
									dashboard_chart_containerObj.removeAll(true);

								dashboard_chart_containerObj.add({
									xtype:'transactionschartpanel',
									id:'transactionschartpanelid',
									jsonData:jsondata1,
									minHeight:265,
									margin:'10 1 10 0',
									padding:0,
									border:true,
									isNotAreaChart:false
								});
							}
						}
					  },
					failure:function(){
						//window.parent.location.href="/final/servlet/com.egurkha.Logout";
					}
				});	
				}
			});
			return;
		}
	},
	onSimulationChange:function(combo,activeTab,siteName,simulationSelectedOrgValue,selected_view_name){
		//var tabPanelAll = this.getTransactionsMainTabPanelAll();
		//var activeTab = tabPanelAll.getActiveTab();
		var comboVal = combo.getValue();
		if(activeTab != null && activeTab == 'logonSim')
		{			
			var servicename = siteName;
			if(Ext.isEmpty(servicename) || servicename == null || servicename == undefined)
				servicename = curServiceName;

			var componentVal = comboVal;
			if(!Ext.isEmpty(componentVal) && componentVal != null && componentVal.indexOf(":") > 0)
			{
				componentVal = componentVal.substring(0,componentVal.indexOf(":"));
			}

			/*var externalAgentList = extAgentData[componentVal];
			var compCombo = Ext.getCmp('componentCombo');
			compCombo.getStore().removeAll();
			compCombo.getStore().loadRawData('');
			compCombo.getStore().loadRawData(externalAgentList);
			compCombo.setValue(externalAgentList.selectedValue);
			compCombo.setFieldLabel(extAgentData.label);
			selectedExtAgent = externalAgentList.selectedValue; */
			selectedExtAgent =  Ext.getCmp('componentCombo').getValue();
			var dashboard_grid_containerObj = Ext.getCmp('dashboard_container_grid');	
			var dashboard_chart_containerObj = Ext.getCmp('dashboard_container_chart');	
			selectedVal = comboVal;
			var selected_dash = '';
			if(!Ext.isEmpty(Ext.getCmp('dashListComId')) && Ext.getCmp('dashListComId')!=null && Ext.getCmp('dashListComId')!=undefined)
				selected_dash = Ext.getCmp('dashListComId').getValue();

			//if(siteName != null)
				//fromServiceDashboard = true;
			var simulationSelectedOrgValue1 = "";
			if(selectedVal != null && selectedVal.indexOf(":NULL") > -1)
				simulationSelectedOrgValue1 = selectedVal.substring(0,selectedVal.indexOf(":NULL"));
			else
			{
				simulationSelectedOrgValue1 = selectedVal;
				selectedVal = selectedVal+":NULL";
			}
			var perf_url = "/final/monitor/comparisonLogonSimulator.jsp?"+logonParam+"&componentType=&selectedState=&subFilter=&simulationName="+simulationSelectedOrgValue1+"&externalAgent="+selectedExtAgent+"&isfromCitrix=true&iniName="+iniName+"&user_name="+user_name+"&dashboard_mapping="+selected_dash+"&dashboard_name="+dashboard+"&view_name="+selected_view_name+"&fromServiceDashboard="+fromServiceDashboard+"&servicename="+siteName+"&fromSerComboChange="+fromSerComboChange+"&isFromZone="+isFromZone+"&iszoneName="+iszoneName+"&parentZone="+parentZone+"&componentNameService="+selectedVal+"&isLogonType=true&filter=service&filterBy="+encodeURIComponent(filterByParamFlag)+"&isFromServiceMenu="+isFromServiceMenu+"&isFromZoneMain="+isFromZoneMain+"&isFromZoneMenu="+isFromZoneMenu+"&isFromServiceGroup="+isFromServiceGroup+"&fromServiceHomePage="+isFromHomePage;

			var transurl = "/final/monitor/simulationGraph.jsp?treeTitle=services&site=NULL&mHost="+selectedExtAgent+"&simulationName="+simulationSelectedOrgValue1+"&componentNameService="+selectedVal+"&fromServiceHomePage="+isFromHomePage;

			Ext.Ajax.request({
				url : transurl,
				scope:this,
				async : true,
				success: function(response){
					var jsonText = response.responseText;
					//var panelArr = new Array();
					if(!Ext.isEmpty(jsonText))
					{
						var jsondata1 = Ext.decode(jsonText);
						if(jsondata1 != null && jsondata1 != undefined)
						{
							if(!Ext.isEmpty(dashboard_grid_containerObj))
								dashboard_grid_containerObj.removeAll(true);

							var css_class='gridHeadercenter iconGrid';
							if(!Ext.isEmpty(logon_treeTitle) && logon_treeTitle=='ExtTestDashboard')
								css_class='gridHeadercenter';

							dashboard_grid_containerObj.add({
								xtype:'generalMeasuresGridPanel',
								plugins:Ext.create('Ext.ux.AutoColumnWithLockingPlugin'),
								//title:titlesys,
								//title:perf_disp_name+" --Man At Work--",
								cls:css_class,
								//itemId:itemIdforsysandcom,
								itemId:'logonSimualtion',
								searchBoxCombo:false,
								margin:0,
								padding:0,
								id:'perPanel',
								height:185,
								frame:false,
								border:true,
								layout:{type:'vbox',align:'stretch'},
								flex:1,
								screenLabelPath:"monitor.Dashboard",
								url:perf_url,
								listeners: {
									'afterrender': function (obj) {
										this.loadTab(obj.url,null,null,null,null,true,"citrixDashBoard");
									}
								}
							});

							if(!Ext.isEmpty(dashboard_chart_containerObj))
								dashboard_chart_containerObj.removeAll(true);

							//panelArr.push({
							dashboard_chart_containerObj.add({
								xtype:'transactionschartpanel',
								id:'transactionschartpanelid',
								//animCollapse:true,
								//columnWidth:1.0,
								//height:255,
								//height:(Ext.getBody().getViewSize().height - 225),
								//flex:1,
								jsonData:jsondata1,
								minHeight:265,
								margin:'10 1 10 0',
								//margin:'5 0 0 0',
								padding:0,
								//flex:0.57,
								border:true,
								isNotAreaChart:false
							});
						
							//curViewPort.add(panelArr);
							//curViewPort.doLayout();
						}
					}
				  },
				failure:function(){
					//window.parent.location.href="/final/servlet/com.egurkha.Logout";
				}
			});
			selectedSimulation = comboVal;
			return;
		}
	},
	onChartsPanelRender:function(panel){
		this.displayGraphInitially(panel.jsonData);
	},
	settingClick:function(image){
		var timlinePos=Ext.getCmp("settingBt").getPosition();
		var winObj = Ext.getCmp('timeWindow');
		winObj.showAt([timlinePos[0]-680,timlinePos[1]+20]);
		//winObj.show();
		//winObj.setPosition(image.x+50-winObj.getWidth(),image.y+320);

	},
	createDivforHighChart:function(size){
		var chartPanel=Ext.getCmp('transactionschartpanelid');
		var imgDiv = '';
		//if(this.tab=='emulated')
		tmp_div_size_of_td=size;
		//else
		//tmp_div_size_of_td=(size/2);
		var inc = 0;
		var chartPane = '',legendPanel = '';
		chartPanel.removeAll();
		var scrollPanel=Ext.create('utilities.ScrollPanel',{
		layout:{type:'vbox',align:'stretch'},
		padding:'0 15 15 15',
		//height:80,
		items:[
				{
					xtype:'container',
					id:'legends'
				},
				{
					xtype : 'container',
					//height:525,
					border:true,
					layout:'column',
					id:'midid',
					defaults:{
						columnWidth:.33,
						//height: 250
					},
					items:this.getItems(size)
				}]
		});
		chartPanel.add(scrollPanel);
		/*--Adding Legend--*/
		/* var chartToolbar=this.getTransactionsChartPanel().getDockedItems()[1];
		chartToolbar.remove(Ext.getCmp('legends'));
		chartToolbar.add('->',{xtype:'container',id:'legends'});*/

	},
	getItems:function(size){
		var skinBg="";
		var items=[];
		for(var y=1;y<size+1;y++){
			i = y-1;
			var borderright="";
			var borderbottom="";
			if (strSkin=="Dark")
			{
				skinBg="#404040";
				borderright="1px solid #515151 !important";
				borderbottom="1px solid #515151 !important";
			}
			else if (strSkin=="Light")
			{
				skinBg="#ffffff";
				borderright="1px solid #f2f2f2 !important";
				borderbottom="1px solid #f2f2f2 !important";
			}
			var idName ='transchart'+i; 
			if(size % 2 === 0){
				if (y != 0 && y%3 === 0)
				{
					borderright="0px solid #f2f2f2 !important";				
				}
			}else{
				if (y != 0 && y === size+1)
				{
					borderright="0px solid #f2f2f2 !important";				
				}
			}

			items.push({
				xtype: 'panel',
				ui:'newPlainPanel',
				height:280,
				style:{background: skinBg+'!important',borderRight:borderright, borderBottom: borderbottom},
				
				/*tools:[
				{
					xtype:'toolbar',
					ui:'footer',
					items:[
					{
						xtype:'button',
						border:0,
						id:'highMax'+i,
						cls:'iconMaximize showgraph',
						handler:function(){
							var idStr = this.getId();
							idStr = idStr.substring(7);
							showGraph('event',idStr);
						}
					}	
					]
				}	 
				],*/
				//margin:'5 10',
				frame:true,
				border:true,
				padding:'10 0 10 0',
				title:'',
				id:idName
			})
		}
		return items;
	},
	timelineChangeHandler:function(combo){
		var timelineValue=combo.getValue();
		if(timelineValue=="Any"){
		this.enableDisableDateFields(true);
		}else{
		this.enableDisableDateFields(false);
		}
		var chartToolbar=this.getTransactionsPanelToolbar();
		//var chartPanel=this.getTransactionsChartPanel();
		var chartPanel=Ext.getCmp('transactionschartpanelid');
		var remoteURL=chartPanel.jsonData.HiddenFields.remoteURL;
		var format=chartPanel.jsonData.HiddenFields.currentDateFormat;

		var starttime="";
		var startTimeField=chartToolbar.getComponent("from");
		if(!Ext.isEmpty(startTimeField) && !Ext.isEmpty(startTimeField.getValue())){
			starttime=Ext.Date.format(startTimeField.getValue(),mgrDateFormat);
		}

		var endtime="";
		var endTimeField=chartToolbar.getComponent("to");
		if(!Ext.isEmpty(endTimeField) && !Ext.isEmpty(endTimeField.getValue())){
			endtime=Ext.Date.format(endTimeField.getValue(),mgrDateFormat);
		}

		var startHr="";
		var fromCombo=chartToolbar.getComponent("fromhr");
		if(!Ext.isEmpty(fromCombo) && !Ext.isEmpty(fromCombo.getValue())){
			startHr=fromCombo.getValue();
		}			  

		var endHr="";
		var toCombo=chartToolbar.getComponent("tohr");
		if(!Ext.isEmpty(toCombo) && !Ext.isEmpty(toCombo.getValue())){
			endHr=toCombo.getValue();
		}

		//Get Minutes
		var startMin="";
		var fromMinCombo=chartToolbar.getComponent("frommin");
		if(!Ext.isEmpty(fromMinCombo) && !Ext.isEmpty(fromMinCombo.getValue())){
			startMin=fromMinCombo.getValue();
		}			

		var endMin="";
		var toMinCombo=chartToolbar.getComponent("tomin");
		if(!Ext.isEmpty(toMinCombo) && !Ext.isEmpty(toMinCombo.getValue())){
			endMin=toMinCombo.getValue();
		}
		var paramValues='F=getTimeJSON&P0=['+timelineValue+']&P1=['+starttime+']&P2=['+endtime+']&P3=['+startHr+']&P4=['+endHr+']&P5=['+format+']&P6=['+startMin+']&P7=['+endMin+']&C=1&calljson=true';

		Ext.Ajax.request({
			url: remoteURL,
			scope:this,
			method: 'POST',
			params: paramValues,
			timeout:280000,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty(response.responseText))
				{
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				this.setTime(jsonData.getTime,timelineValue);
				}
			},
			failure:function(){
				//window.parent.location.href="/final/servlet/com.egurkha.Logout";
			}
		});
		//jsrsExecute(remoteURL,this.setTime,"getTime",new Array(""+timelineValue,""+starttime,""+endtime,""+startHr,""+endHr,""+format));
	},
	setTime:function(timeVal,timelineValue){	
		var arrOptions = timeVal.split('\t');
		var frHr="",toHr="";
		var frMin="",toMin="";
		time_line_obj=new Object();
		time_line_obj.starttime=arrOptions[0];
		var startdt ="",enddt="";
		//var mgr_dateFormat = 'M d, Y';
		if(timelineValue=="Any"){
			startdt = Ext.Date.format(arrOptions[6],mgrDateFormat);
			enddt = Ext.Date.format(arrOptions[7],mgrDateFormat);
		}
		else
		{
			startdt = new Date(arrOptions[6]);
			enddt = new Date(arrOptions[7]);
			startdt = Ext.Date.format(arrOptions[6],mgrDateFormat);
			enddt = Ext.Date.format(arrOptions[7],mgrDateFormat);
		}
		if(startdt == "Invalid Date" || startdt =="" )
			startdt = arrOptions[6];
		//enddt = new Date(arrOptions[7]);
		if(enddt == "Invalid Date" || enddt =="" )
			enddt = arrOptions[7];
		var tmp_start_date="",tmp_end_date="";
		tmp_start_date= Ext.Date.format(startdt,mgrDateFormat);
		tmp_end_date = Ext.Date.format(enddt,mgrDateFormat);
		startdt = (tmp_start_date == "")?startdt:tmp_start_date;
		enddt = (tmp_end_date == "")?enddt:tmp_end_date;
		this.getTransactionsPanelToolbar().getComponent("from").setValue(startdt);

		time_line_obj.endtime=arrOptions[1];
		this.getTransactionsPanelToolbar().getComponent("to").setValue(enddt);
		time_line_obj.starthr=arrOptions[2];
		if(timelineValue=="Any"){
			//frHr = arrOptions[2];
			//toHr = arrOptions[3];
			frHr = arrOptions[8];
			toHr = arrOptions[9];
		}
		else
		{
			frHr = arrOptions[8];
			toHr = arrOptions[9];
		}

		//set Min
		frMin = arrOptions[10];
		toMin = arrOptions[11];
		this.getTransactionsPanelToolbar().getComponent("frommin").setValue(frMin);
		this.getTransactionsPanelToolbar().getComponent("tomin").setValue(toMin);			
		this.getTransactionsPanelToolbar().getComponent("fromhr").setValue(frHr);
		time_line_obj.endhr=arrOptions[3];
		this.getTransactionsPanelToolbar().getComponent("tohr").setValue(toHr);
		var chartToolbar=this.getTransactionsPanelToolbar();
	},
	enableDisableDateFields:function(enable){
		var chartToolbar=this.getTransactionsPanelToolbar();
		var startTimeField=chartToolbar.getComponent("from");
		var endTimeField=chartToolbar.getComponent("to");
		var fromCombo=chartToolbar.getComponent("fromhr");
		var toCombo=chartToolbar.getComponent("tohr");

		if(enable){
			startTimeField.setDisabled(false);
			endTimeField.setDisabled(false);
			fromCombo.setDisabled(false);
			toCombo.setDisabled(false);
		}else{
			startTimeField.setDisabled(true);
			endTimeField.setDisabled(true);
			fromCombo.setDisabled(true);
			toCombo.setDisabled(true);
		}
	},
	createHighStockChart:function(url,param){
		var seriesOptions = [],
		yAxisOptions = [],
		seriesCounter = 0;
		var title = "";
		var colors = "";
		var fmts = "";
		var axisTitle = "";
		var min = "";
		var max = "";
		var xmax = "";
		var xmin = "";
		var lineWidth = "";
		var TotalTd = 0;
		var cell_count=0;
		var itemsArray=[];
		var tdValues="";
		//var chartPanel=this.getTransactionsChartPanel();
		var chartPanel=Ext.getCmp('transactionschartpanelid');
		var measures=chartPanel.jsonData.HiddenFields.measurelst;
		var measure_list_value=measures.split(",");
		var tab="Web";

		var firstCmp = Ext.getCmp('firstid');
		var midCmp = Ext.getCmp('midid');
		var lastCmp = Ext.getCmp('lastid');

		if(!Ext.isEmpty(errorPanel) && errorPanel==true)
		{
			chartPanel.update("");
			if(!Ext.isEmpty(firstCmp))
			chartPanel.remove(firstCmp);
			if(!Ext.isEmpty(midCmp))
			chartPanel.remove(midCmp);
			if(!Ext.isEmpty(lastCmp))
			chartPanel.remove(lastCmp);
		}
		var me = this;
		//var chartPnl=this.getTransactionsChartPanel();
		var chartPnl=Ext.getCmp('transactionschartpanelid');
		//chartPnl.setLoading(true,true);
		Ext.Ajax.request(
		{
			url : url,
			params:param,
			scope:this,
			timeout:6000000,
			success: function(response) 
			{	
				if(response.status == 200 && !Ext.isEmpty(response))
				{
					var jsonText = response.responseText;
					if(!Ext.isEmpty(jsonText))
					{
						var data=Ext.decode(jsonText);
						if(!Ext.isEmpty(data))
						{
							var chartData=[];
							var htmlStr1='';
							var htmlStr2='';
							var htmlStrMid='';
							var itemsArray=[];
							var highChartUrls = new Array();
							var highChartIds = new Array();
							var highChartFmts = new Array();
							var highChartXmax = new Array();
							var highChartXmin = new Array();
							var highChartMax = new Array();
							var highChartAxislabel = new Array();
							var highChartSeriesOptions = new Array();
							var highChartTotalTd = new Array();
							var highChartColor = new Array();
							var highChartTitle = new Array();
							var size = 0;
							var tmp_div_size_of_td = 0;
							var itemInc = 0;
							for(var inc in data)
							{
								if(inc.indexOf("chart") > -1)
								size = size+1;
							}
							var graphPanel = Ext.getCmp("transactionschartpanelid");
							if(graphPanel != null && graphPanel != undefined && !Ext.isEmpty(graphPanel))
							{
								var graphEndRow = size%3;
								var graphRows =Math.floor(size/3); 
								var graphTotalRows = graphRows;
								if(graphEndRow >0)
									graphTotalRows = graphRows + 1;
								var graphHight = graphTotalRows * 300;
								var graphHeaderHight = 40; 
									graphHight = graphHight+graphHeaderHight;
								graphPanel.setHeight(graphHight);
							}
							me.createDivforHighChart(size);
							if(size > 0 )
							{
								var styleAttrbs=new Object();
								styleAttrbs['fontFamily']='Arial';
								styleAttrbs['fontSize']='11px';
								
								styleAttrbs['axisLabelGridColor']= ( strSkin == 'Light' )?'#e1e1e1':'#666666';
								styleAttrbs['axisLabelColor']= ( strSkin == 'Light' )?'#969696':'#c6c6c6';
								styleAttrbs['axisLabelFontFmy']='Arial';
								styleAttrbs['axisLabelFontSize']='11px';
								styleAttrbs['axisLabelLineColor']= ( strSkin == 'Light' )?'#e1e1e1':'#666666';
								styleAttrbs['axisLabelMinorGrid']= ( strSkin == 'Light' )?'#e1e1e1':'#666666';
								styleAttrbs['axisLabelTickColor']= ( strSkin == 'Light' )?'#e1e1e1':'#666666';
								styleAttrbs['axisTitleColor']= ( strSkin == 'Light' )?'#606060':'#c0c0c0';
								styleAttrbs['axisTitleFontFmy']='Arial';
								styleAttrbs['axisTitleFontSize']='11px';


								styleAttrbs['TooltipFontFmy']='Arial';
								styleAttrbs['TooltipFontSize']='11px';
								styleAttrbs['TooltipBgColor']= ( strSkin == 'Light' )?'white':'#161616';
								styleAttrbs['TooltipBorderColor']= ( strSkin == 'Light' )?'black':'#0c0c0c';

								styleAttrbs['legendFontFmy']='Arial';
								styleAttrbs['legendFontSize']='12px';
								styleAttrbs['legendColor']= ( strSkin == 'Light' )?'#2a292a':'#c6c6c6';
								styleAttrbs['titleFontClr']=( strSkin == 'Light' )?'#2a292a':'#c6c6c6';
								styleAttrbs['titleFontFmy']='Roboto-Bold';
								styleAttrbs['titleFontSize']='13px';
								styleAttrbs['lineThickness']='2';

								var styleObj = data["styles"];
								/*if(!Ext.isEmpty(styleObj['axisLabelStyle']))
								{
								styleAttrbs['capFontClr'] = styleObj['axisLabelStyle'].COLOR;
								styleAttrbs['capFontFmy'] = styleObj['axisLabelStyle'].FAMILY;
								styleAttrbs['capFontSize'] = styleObj['axisLabelStyle'].SIZE;
								styleAttrbs['capFontWgt'] = styleObj['axisLabelStyle'].WEIGHT;
								}

								if(!Ext.isEmpty(styleObj['timeLabelStyle']))
								{
								styleAttrbs['xlabelfontClr'] = styleObj['timeLabelStyle'].COLOR;
								styleAttrbs['xlabelfontFmy'] = styleObj['timeLabelStyle'].FAMILY;
								styleAttrbs['xlabelfontSize'] = styleObj['timeLabelStyle'].SIZE;
								styleAttrbs['xlabelfontWgt'] = styleObj['timeLabelStyle'].WEIGHT;
								}
								if(!Ext.isEmpty(styleObj['panelLineStyle']))
								{
								styleAttrbs['plotPanelColor']=styleObj['panelLineStyle'].COLOR;
								styleAttrbs['lineThickness']=styleObj['panelLineStyle'].LINETHICKNESS;
								}*/

								for(var mainKey in data)
								{
									var dataOfKey = data[mainKey];
									if( mainKey != "styles" && mainKey != 'chartKey' && dataOfKey.indexOf("^eg^") == -1)
									{
										for ( var key in dataOfKey )
										{
											if(!isNaN(key))
											{
												title = dataOfKey[key]['title'];
												fmts = dataOfKey[key]['fmts'];
												axisTitle = dataOfKey[key]['axislabel'];
												xmax = dataOfKey[key]['xmax'];
												xmin = dataOfKey[key]['xmin'];
												max = dataOfKey[key]['max'];
												colors = dataOfKey[key]['color'],
												lineWidth = dataOfKey[key]['lineWidth'],
												seriesOptions[key] =
												{
													name: dataOfKey[key]['name'],
													data: dataOfKey[key]['data'],
													color: dataOfKey[key]['color'],
													dataGrouping: {
													enabled: false
													}
												};
											}
											highChartColor.push(colors);
										}
										highChartTitle.push(title);
										highChartFmts.push(fmts);
										highChartXmax.push(xmax);
										highChartXmin.push(xmin);
										highChartMax.push(max);
										highChartAxislabel.push(axisTitle);
										highChartSeriesOptions.push(seriesOptions);
										highChartTotalTd.push(TotalTd);
										//highChartColor.push(colors);
										//if(TotalTd == 3)
										if(TotalTd == 2 || (this.tab=="emulated" && TotalTd ==1) ) //fix for emulated legends
										{
											var Legend_Total = seriesOptions.length;
											var tdValues="<table align='right'style='margin-top:-10px;'><tr>";
											var padRight="";
											if(Legend_Total!=null && Legend_Total!='')
											{
												for(var z=0;z<Legend_Total;z++)
												{
													if (z!=(Legend_Total-1))
													{
														padRight="15px";
													}
													else
													{
														padRight="0px";
													}
													var LegendTdName    =seriesOptions[z].name;
													if(LegendTdName!=null && LegendTdName.indexOf("^")>-1)
													{
														var trans_name_temp=LegendTdName.substring(0,LegendTdName.lastIndexOf("^"));
														//var color_code_temp=LegendTdName.substring(LegendTdName.lastIndexOf("^")+1);
														tdValues=tdValues+"<td width='10' height='10' align='center'>";
														tdValues=tdValues+"<table cellpadding='0' cellspacing='1' border='0'>";
														tdValues=tdValues+"<tr>";
														//tdValues=tdValues+"<td width = '10' style='background:#"+color_code_temp+"' class='linesquare_white' height='10'><img src = '/final/monitor/eg_images/spacer.gif' width = '10' height = '10' border = '0'></td></tr></table></td>";
														tdValues=tdValues+"<td nowrap style='width:40px;padding-right:10px; height:10px' >"+trans_name_temp+"</td>";
													}
													else
													{
														tdValues=tdValues+"<td width='10' height='10' align='center'>";
														tdValues=tdValues+"<table cellpadding='0' cellspacing='1' border='0'>";
														tdValues=tdValues+"<tr>";
														tdValues=tdValues+"<td width = '10' style='vetical-align:top' class='linesquare_white' height='5'><div style='background:"+highChartColor[z]+";height:8px;width:8px' ><div></td></tr></table></td>";
														tdValues=tdValues+"<td nowrap class='font_normal11' style='padding-left:5px;padding-right:"+padRight+"; height:35px' >"+LegendTdName+"</td>";
													}
												}
											}
											tdValues = tdValues+"</tr></table>";
											var legContainer = Ext.get('legends');
											if(!Ext.isEmpty(legContainer))
											{
											Ext.getCmp('legends').update(tdValues);
											}
										}
										if(!Ext.isEmpty(chartPnl.isNotAreaChart))
											loadTransHCGrap(seriesOptions,TotalTd,axisTitle,fmts,'',max,xmax,xmin,lineWidth,styleAttrbs,true);
										else
											loadTransHCGrap(seriesOptions,TotalTd,axisTitle,fmts,'',max,xmax,xmin,lineWidth,styleAttrbs);
										Ext.getCmp('transchart'+TotalTd).setTitle('<span style="margin-top:20px;display:block;text-align:center" class="font_bold13 fontStyleRobot">'+title+'</span>');
										TotalTd = TotalTd+1;
										itemInc = itemInc+1;
										if(!Ext.isEmpty(chartPanel.getEl()) && chartPanel.getEl() != null && chartPanel.getEl() != 'undefined')
										{
											chartPanel.getEl().unmask();
											//chartPnl.setLoading(false);
										}
									}
									else
									{
										if(  mainKey != "styles" && mainKey != 'chartKey' && dataOfKey.indexOf("^eg^") > -1 )
										{
											var myImgHtml = '<div style="margin:7% 20% auto 30%"><img src="/final/images/'+strSkin+'/nomeasures_custom.png" /></div>';
											if( itemInc < size )
											{
												var timTitle = dataOfKey.substring(4);
												Ext.getCmp('transchart'+itemInc).setTitle('<span style="margin-top:20px;display:block;text-align:center" class="font_bold13 fontStyleRobot">'+timTitle+'</span>');
												Ext.getCmp('transchart'+itemInc).update(myImgHtml);
												TotalTd = TotalTd+1;
												itemInc = itemInc+1;
											}
										}
										//chartPnl.setLoading(false);
									}
								}
								errorPanel = false;
							}
							else
							{
							this.displayErrorMsg();
							}
							errorPanel = false;
						}
						else
						{
						this.displayErrorMsg();
						}
						errorPanel = false;
					}
					else
					{
						this.displayErrorMsg();
					}
				}
			},
			failure:function(){
				//window.parent.location.href="/final/servlet/com.egurkha.Logout";
			}
		});
	},
	displayErrorMsg:function(){
		errorPanel = true;
		//var chartPanel=this.getTransactionsChartPanel();
		var chartPanel=Ext.getCmp('transactionschartpanelid');
		
		var htmlStr='<table width="100%" height="100%"><tr style="text-align:center;" width="100%" height="100%"><td width="100%" height="100%">';
		//htmlStr+='<img hspace = "0" vspace = "0" border = "0" align = "center" valign="middle" src="/final/monitor/eg_images/'+chartPanel.jsonData.HiddenFields.monitorSkin+'/nographformeasure.gif">';
		htmlStr+='<div style="text-align:center"><div class="iconInformation" style="margin:0px auto"></div><div class="font_normal11">No measure available for the current selection</div></div>'
		htmlStr+='</td></tr></table>';
		chartPanel.setHeight(screen.height-465);
		chartPanel.setLoading(false);
		chartPanel.removeAll();
		//chartPanel.setHeight(Ext.getBody().getViewSize().height-280);
		var errPanel=Ext.create('Ext.panel.Panel',
			{
				//height:180,
				layout:'fit',
				//id:'errID',
				//height:Ext.getBody().getViewSize().height-330,
				html:htmlStr
		});
		chartPanel.add(errPanel);
		//chartPanel.update(htmlStr);
	},
	getCurrentDateTime:function(){
		var endHr="";
		var startHr="";
		var starttime="";
		var endtime="";
		var time_line ="";
		var retDate = "";
		//var chartToolbar=this.getTransactionsChartPanelToolbar();
		var chartToolbar=this.getTransactionsPanelToolbar();
		var timelineCombo=chartToolbar.getComponent("timeline");
		if(!Ext.isEmpty(timelineCombo) && !Ext.isEmpty(timelineCombo.getValue())){
			  time_line=timelineCombo.getValue();
		  }
		 var startTimeField=chartToolbar.getComponent("from");
		  if(!Ext.isEmpty(startTimeField)){
			  if(!startTimeField.isDisabled()  && !Ext.isEmpty(startTimeField.getValue())){
				  starttime=Ext.Date.format(startTimeField.getValue(),mgrDateFormat);
			  }else{
				  if(!Ext.isEmpty(time_line_obj)){
					  starttime=time_line_obj.starttime;
				  }else{
					  starttime=Ext.Date.format(startTimeField.getValue(),mgrDateFormat);
				  }
			  }
		  }
		  
		  var endTimeField=chartToolbar.getComponent("to");
		  if(!Ext.isEmpty(endTimeField)){
			  if(!endTimeField.isDisabled()  && !Ext.isEmpty(endTimeField.getValue())){
			  endtime=Ext.Date.format(endTimeField.getValue(),mgrDateFormat);
			  }else{
				  if(!Ext.isEmpty(time_line_obj)){
					  endtime=time_line_obj.endtime;
				  }else{
					  endtime=Ext.Date.format(endTimeField.getValue(),mgrDateFormat);
				  }
			  }
		  }
		
		var fromCombo=chartToolbar.getComponent("fromhr");
		if(!Ext.isEmpty(fromCombo))
			{
			  if(!fromCombo.isDisabled() && !Ext.isEmpty(fromCombo.getValue())){
				startHr=fromCombo.getValue();
				 
			  }else{
				  if(!Ext.isEmpty(time_line_obj)){
					  startHr=time_line_obj.starthr;
					   
				  }else{
						startHr=fromCombo.getValue();
					}
			}
		}

		  var toCombo=chartToolbar.getComponent("tohr");
		  if(!Ext.isEmpty(toCombo)){
			  if(!toCombo.isDisabled() && !Ext.isEmpty(toCombo.getValue())){
				  endHr=toCombo.getValue();
			}else{
				  if(!Ext.isEmpty(time_line_obj)){
						endHr=time_line_obj.endhr;
				  }else{
						endHr=toCombo.getValue();
				  }
			  }
		  }
		if(!Ext.isEmpty(startTimeField) && !Ext.isEmpty(endTimeField)){
			starttime = Ext.Date.dateFormat(startTimeField.getValue(), 'm/d/Y');
			endtime = Ext.Date.dateFormat(endTimeField.getValue(), 'm/d/Y');
			retDate = time_line+":"+starttime+":"+startHr+":"+endtime+":"+endHr;
		}
		return retDate;
	},
	displayGraph:function(){
		var cdate = this.getCurrentDateTime();
		var chartOption = "highcharts";
		if(chartOption.indexOf("highchart") > -1)
		{
			//this.getTransactionChartComboMode().hide();
			this.getTransactionComboMode().hide();
		}
		else
		{
			//this.getTransactionChartComboMode().hide();
			this.getTransactionComboMode().hide();
		}
		//var chartPanel=this.getTransactionsChartPanel();
		var chartPanel=Ext.getCmp('transactionschartpanelid');
		if(!Ext.isEmpty(chartPanel) && !Ext.isEmpty(chartPanel.jsonData)){
			var jsonData=chartPanel.jsonData;
			var mode="";
			var starttime="";
			var endtime="";
			var startHr="";
			var startMin="";
			var endHr="";
			var endMin="";
			var time_line="";
			var dateError = '';
			//  var chartToolbar=this.getTransactionsChartPanelToolbar();
			var chartToolbar=this.getTransactionsPanelToolbar();
			var modeCombo=chartToolbar.getComponent("mode");
			if(!Ext.isEmpty(modeCombo) && !Ext.isEmpty(modeCombo.getValue())){
				mode=modeCombo.getValue();
			}
			var startTimeField=chartToolbar.getComponent("from");
			if(!Ext.isEmpty(startTimeField)){
				if(!startTimeField.isDisabled()  && !Ext.isEmpty(startTimeField.getValue())){
				starttime=Ext.Date.format(startTimeField.getValue(),mgrDateFormat);
				}else{
					if(!Ext.isEmpty(time_line_obj)){
						starttime=time_line_obj.starttime;
					}else{
						starttime=Ext.Date.format(startTimeField.getValue(),mgrDateFormat);
					}
				}
			}

			var endTimeField=chartToolbar.getComponent("to");
			if(!Ext.isEmpty(endTimeField)){
				if(!endTimeField.isDisabled()  && !Ext.isEmpty(endTimeField.getValue())){
				endtime=Ext.Date.format(endTimeField.getValue(),mgrDateFormat);
				}else{
					if(!Ext.isEmpty(time_line_obj)){
						endtime=time_line_obj.endtime;
					}else{
						endtime=Ext.Date.format(endTimeField.getValue(),mgrDateFormat);
					}
				}
			}

			var fromCombo=chartToolbar.getComponent("fromhr");
			if(!Ext.isEmpty(fromCombo)){
				if(!fromCombo.isDisabled() && !Ext.isEmpty(fromCombo.getValue())){
					startHr=fromCombo.getValue();
				}else{
					if(!Ext.isEmpty(time_line_obj)){
						startHr=time_line_obj.starthr;
					}else{
						startHr=fromCombo.getValue();
					}
				}
			}

			var toCombo=chartToolbar.getComponent("tohr");
			if(!Ext.isEmpty(toCombo)){
				if(!toCombo.isDisabled() && !Ext.isEmpty(toCombo.getValue())){
					endHr=toCombo.getValue();
				}else{
					if(!Ext.isEmpty(time_line_obj)){
						endHr=time_line_obj.endhr;
					}else{
						endHr=toCombo.getValue();
					}
				}
			}			

			//Get Minutes
			var startMin="";
			var fromMinCombo=chartToolbar.getComponent("frommin");
			if(!Ext.isEmpty(fromMinCombo) && !Ext.isEmpty(fromMinCombo.getValue())){
				startMin=fromMinCombo.getValue();
			}			

			var endMin="";
			var toMinCombo=chartToolbar.getComponent("tomin");
			if(!Ext.isEmpty(toMinCombo) && !Ext.isEmpty(toMinCombo.getValue())){
				endMin=toMinCombo.getValue();
			}

			//

			// var timeLineCombo=this.getTransactionChartComboTimeline();
			var timeLineCombo=this.getTransactionComboTimeline();
			if(timeLineCombo.getValue() =="Any"){
				var dateError = startTimeField.getName();
				var currentDateError = endTimeField.getName()
				var startTime = startTimeField.getValue();
				var endTime = endTimeField.getValue();
				var curTime = curDateTime;
				var currentMgrDate = new Date(curTime);

				var starttime= formatDate(startTime, "MM/dd/yyyy");
				var endtime= formatDate(endTime, "MM/dd/yyyy");

				if(dateValidation(starttime,endtime,parseInt(startHr),parseInt(endHr),0,0)==-1)
				{
					//var msg ="From date should be lesser than to date";
					Ext.Msg.alert('Error', dateError);
					return;
				}


				/*if((startTime > currentMgrDate )|| (endTime > currentMgrDate)){
				Ext.Msg.alert('Error', currentDateError);
				return;
				}
				if(startTimeField.getValue() > endTimeField.getValue()){
				Ext.Msg.alert('Error', dateError);
				return;
				}
				else if(startTimeField.getValue().getDate()==endTimeField.getValue().getDate()&&startTimeField.getValue().getMonth()==endTimeField.getValue().getMonth()&&startTimeField.getValue().getFullYear()==endTimeField.getValue().getFullYear()){
				if(startHr>=endHr){
				Ext.Msg.alert('Error', dateError);
				return;
				}
				}*/
			}

			this.anyStartTime=starttime;
			this.anyEndTime=endtime;
			this.anyStartHr=startHr;
			this.anyEndHr=endHr;
			var timelineCombo=chartToolbar.getComponent("timeline");
			if(!Ext.isEmpty(timelineCombo) && !Ext.isEmpty(timelineCombo.getValue())){
				time_line=timelineCombo.getValue();
			}
			//var chartPanel=this.getTransactionsChartPanel();
			var chartPanel=Ext.getCmp('transactionschartpanelid');

			var cdate = this.getCurrentDateTime();
			var chartOption = "highcharts";
			//var mgr_dateFormat = 'M d, Y';
			this.transactionMeasuresParam={
				startTrans:'',
				site:jsonData.HiddenFields.siteName,
				comp:jsonData.HiddenFields.compName,
				test:jsonData.HiddenFields.testForTab,
				measure:jsonData.HiddenFields.measurelst,
				gformat:"graph",
				chartType:chartOption,
				GraphSize:"true",
				monitorSkin:jsonData.HiddenFields.monitorSkin,
				mode:'2D',
				starttime:startTimeField.getRawValue(),
				endtime:endTimeField.getRawValue(),
				starthr:startHr,
				endhr:endHr,
				startmin:startMin,
				endmin:endMin,
				time_line:time_line,
				all_trans_names:jsonData.HiddenFields.all_trans_names,
				msmt_host:jsonData.HiddenFields.mHost,
				endTrans:'',
				isAreaChart:isAreaChart,
				isLogonType:isLogonType
			};

			// this.getTransactionChartComboMode().show();
			if(chartOption.indexOf("highchart") > -1)
			{
				this.createHighStockChart(this.transactionMeasuresChartURL,this.transactionMeasuresParam);
				// this.getTransactionChartComboMode().hide();
				this.getTransactionComboMode().hide();
			}
			else
			{
				// this.getTransactionChartComboMode().hide();
				this.getTransactionComboMode().hide();
				chartPanel.getEl().mask("Loading...");
					Ext.Ajax.request({
					url : this.transactionMeasuresChartURL,
					params: this.transactionMeasuresParam,
					method:'get',
					scope:this,
					success: function(response){
						var chartPnl=Ext.getCmp('transactionschartpanelid');
						chartPnl.getEl().unmask();
						this.createGraphs(response);
					},
					failure:function(){
						var chartPnl=Ext.getCmp('transactionschartpanelid');
						chartPnl.getEl().unmask();
					}
				});
			}
		}
	},
	displayGraphInitially:function(jsonData){	    	  
		var  mode=jsonData.HiddenFields.mode
		var  starttime=jsonData.HiddenFields.starttime
		var  endtime=jsonData.HiddenFields.endtime
		var  starthr=jsonData.HiddenFields.startHr
		var  endhr=jsonData.HiddenFields.endHr
		var  time_line=jsonData.HiddenFields.timeline
		var  startmin = jsonData.HiddenFields.startMin
		var  endmin = 	 jsonData.HiddenFields.endMin
		var cdate = this.getCurrentDateTime();
		var chartOption = "highcharts";

		if(requestParams.refresh==true){
			mode=requestParams.mode
			starttime=jsonData.HiddenFields.starttime
			endtime=jsonData.HiddenFields.endtime
			starthr=jsonData.HiddenFields.startHr
			endhr=jsonData.HiddenFields.endHr
			startmin = jsonData.HiddenFields.startMin
			endmin=jsonData.HiddenFields.endMin
			time_line=requestParams.timeline
		}
		if(isRefreshing)
		{
			if(timeLineValueForRefresh != null && timeLineValueForRefresh != '' && timeLineValueForRefresh != undefined)
			{
				if(timeLineValueForRefresh != 'Any')
					time_line = timeLineValueForRefresh;
				else if(timeLineValueForRefresh == 'Any')
				{	
					time_line = timeLineValueForRefresh;

					if(fromDateValueForRefresh != null && fromDateValueForRefresh != '' && fromDateValueForRefresh != undefined)
						starttime = fromDateValueForRefresh;
					
					if(toDateValueForRefresh != null && toDateValueForRefresh != '' && toDateValueForRefresh != undefined)
						endtime = toDateValueForRefresh;
					
					if(fromHrValueForRefresh != null && fromHrValueForRefresh != '' && fromHrValueForRefresh != undefined)
						starthr = fromHrValueForRefresh;

					if(toHrValueForRefresh != null && toHrValueForRefresh != '' && toHrValueForRefresh != undefined)
						endhr = toHrValueForRefresh;

					if(fromMinValueForRefresh != null && fromMinValueForRefresh != '' && fromMinValueForRefresh != undefined)
						startmin = fromMinValueForRefresh;

					if(toMinValueForRefresh != null && toMinValueForRefresh != '' && toMinValueForRefresh != undefined)
						endmin = toMinValueForRefresh;
				}
			}
		}
		if(!Ext.isEmpty(starttime) && !Ext.isEmpty(endtime))
		{
			starttime=Ext.Date.format(new Date(starttime),mgrDateFormat);
			endtime=Ext.Date.format(new Date(endtime),mgrDateFormat);	
		}
		this.transactionMeasuresParam={
			site:jsonData.HiddenFields.siteName,
			comp:jsonData.HiddenFields.compName,
			test:jsonData.HiddenFields.testForTab,
			measure:jsonData.HiddenFields.measurelst,
			gformat:"graph",
			GraphSize:"true",
			monitorSkin:jsonData.HiddenFields.monitorSkin,
			mode:'2D',
			starttime:starttime,
			endtime:endtime,
			starthr:starthr,
			startmin:startmin,

			//starthr:startHr,
			endhr:endhr,
			endmin:endmin,
			time_line:time_line,
			all_trans_names:jsonData.HiddenFields.all_trans_names,
			msmt_host:jsonData.HiddenFields.mHost,
			isAreaChart:isAreaChart,
			isLogonType:isLogonType
		};
		if(!Ext.isEmpty(jsonData.HiddenFields)){
			var cdate = this.getCurrentDateTime();
			//  this.getTransactionChartComboMode().hide();
			var chartOption = "highcharts";
			if(chartOption != null){
				if(chartOption.indexOf("highchart") > -1)
				{
					// this.getTransactionChartComboMode().hide();
					this.getTransactionComboMode().hide();
					this.createHighStockChart(this.transactionMeasuresChartURL,this.transactionMeasuresParam);
				}
				else
				{
				//  this.getTransactionChartComboMode().hide();
				this.getTransactionComboMode().hide();
				var chartPnl=this.getTransactionsChartPanel();
				//chartPnl.setLoading(true,true);
				Ext.Ajax.request({
					url : this.transactionMeasuresChartURL,
					params:this.transactionMeasuresParam,
					scope:this,
					success: function(response){
						this.createGraphs(response);
						//chartPnl.setLoading(false);
					},
					failure:function(){
						//window.parent.location.href="/final/servlet/com.egurkha.Logout";
					}
				});
				}
			}
		}
	},
	compFilterByComboOnChange:function(combo){
		var userName=requestParams.userName;		
		//var hostType=combo.getValue();
		var filterByComboVal="";
		if(Ext.getCmp('filterByCombo')!=null && Ext.getCmp('filterByCombo')!=undefined && Ext.getCmp('filterByCombo').getValue()!=null && Ext.getCmp('filterByCombo').getValue()!='null')
		{
			filterByComboVal = Ext.getCmp('filterByCombo').getValue();
		}

		var subFilterComboVal="";
		if(Ext.getCmp('subFilterCombo')!=null && Ext.getCmp('subFilterCombo')!=undefined && Ext.getCmp('subFilterCombo').getValue()!=null && Ext.getCmp('subFilterCombo').getValue()!='null')
		{
			subFilterComboVal = Ext.getCmp('subFilterCombo').getValue();
		}

		var componentTypeVal="";
		if(Ext.getCmp('componentTypCombo')!=null && Ext.getCmp('componentTypCombo')!=undefined && Ext.getCmp('componentTypCombo').getValue()!=null && Ext.getCmp('componentTypCombo').getValue()!='null')
		{
			componentTypeVal = Ext.getCmp('componentTypCombo').getValue();
		}

		var nickNameVal="";
		if(Ext.getCmp('nickName')!=null && Ext.getCmp('nickName')!=undefined && Ext.getCmp('nickName').getValue()!=null && Ext.getCmp('nickName').getValue()!='null')
		{
			nickNameVal = Ext.getCmp('nickName').getValue();
		}

		var url="";
		var itemIdVal=Ext.getCmp('perPanel').itemId;
		if(itemIdVal=='system' || itemIdVal=='System')
		{
			url="/final/monitor/comparisonSystem.jsp?treeTitle=System";
		}
		else if(itemIdVal=='components' || itemIdVal=='Components')
		{
			url="/final/monitor/comparisonComponent.jsp?treeTitle=Component";
		}
		else if(itemIdVal=='network' || itemIdVal=='Network')
		{
			url="/final/monitor/comparisonComponent.jsp?treeTitle=Network";
		}

		url=url+"&filterBy="+filterByComboVal;

		if(requestParams.fromPageView != null && requestParams.fromPageView == 'CitrixDashboard')
			url=url+"&timeline="+timeline;
		
		var subFilterComboObj = Ext.getCmp('subFilterCombo');
		var isOthers=false;

		url=url+"&isCitrixComp=true&isfromCitrix=true&fromServiceHomePage="+isFromHomePage+"&isFromZone="+isFromZone+"&iszoneName="+iszoneName+"&parentZone="+parentZone+"&serviceName="+encodeURIComponent(filterByParamFlag);

		if(filterByComboVal=='Component' || filterByComboVal=='System' ||  filterByComboVal=='Network')
		{
			subFilterComboObj.hide();
			isOthers = true;
		}
		else
		{
			//subFilterComboObj.show();
		}

		sortState="";
		DirProperty="";
		
		if(isOthers)
		{
			Ext.getCmp('perPanel').loadTab(url,'','','','','','citrixDashboardForComponent');
			Refurl=url;
		}
		else
		{
			Ext.Ajax.request({
				url :url,
				scope:this,
				timeout:280000,
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					subFilterComboObj.getStore().loadRawData(jsonData.subFilterOptions);
					subFilterComboObj.setValue(jsonData.pageParams.selectedSubFilterOption);
					subFilterComboObj.setFieldLabel(jsonData.pageParams.subFilterLabel);
					subFilterComboObj.show();
				}
			});
		}
	},	
	compSubFilterComboOnChange:function(combo){
		var userName=requestParams.userName;
		
		var filterByComboVal="";
		if(Ext.getCmp('filterByCombo')!=null && Ext.getCmp('filterByCombo')!=undefined && Ext.getCmp('filterByCombo').getValue()!=null && Ext.getCmp('filterByCombo').getValue()!='null')
		{
			filterByComboVal = Ext.getCmp('filterByCombo').getValue();
		}

		var subFilterComboVal="";
		if(Ext.getCmp('subFilterCombo')!=null && Ext.getCmp('subFilterCombo')!=undefined && Ext.getCmp('subFilterCombo').getValue()!=null && Ext.getCmp('subFilterCombo').getValue()!='null')
		{
			subFilterComboVal = Ext.getCmp('subFilterCombo').getValue();
		}
		
		var componentTypeVal="";
		if(Ext.getCmp('componentTypCombo')!=null && Ext.getCmp('componentTypCombo')!=undefined && Ext.getCmp('componentTypCombo').getValue()!=null && Ext.getCmp('componentTypCombo').getValue()!='null')
		{
			componentTypeVal = Ext.getCmp('componentTypCombo').getValue();
		}

		var nickNameVal="";
		if(Ext.getCmp('nickName')!=null && Ext.getCmp('nickName')!=undefined && Ext.getCmp('nickName').getValue()!=null && Ext.getCmp('nickName').getValue()!='null')
		{
			nickNameVal = Ext.getCmp('nickName').getValue();
		}

		var url="";
		var itemIdVal=Ext.getCmp('perPanel').itemId;
		
		sortState="";
		DirProperty="";

		if(itemIdVal=='system' || itemIdVal=='System')
		{
			url="/final/monitor/comparisonSystem.jsp?treeTitle=System";
			url=url+"&filterBy="+filterByComboVal+"&subFilter="+encodeURIComponent(subFilterComboVal)+"&componentNameSearch="+encodeURIComponent(nickNameVal)+"&serviceName="+encodeURIComponent(filterByParamFlag)+"&isFromZone="+isFromZone+"&iszoneName="+iszoneName+"&parentZone="+parentZone;
			var url = url;
			url=url+"&isfromCitrix=true";
			Refurl=url;
			Ext.getCmp('perPanel').loadTab(url,'','','','','','citrixDashboardForComponent');
		}
		else if(itemIdVal=='components' || itemIdVal=='Components' )
		{
			url="/final/monitor/comparisonComponent.jsp?treeTitle=Component";
			url=url+"&filterBy="+filterByComboVal+"&subFilter="+encodeURIComponent(subFilterComboVal);
			if(requestParams.fromPageView != null && requestParams.fromPageView == 'CitrixDashboard')
				url=url+"&timeline="+encodeURIComponent(timeline);
			url=url+"&isCitrixComp=true&isfromCitrix=true&fromServiceHomePage="+isFromHomePage+"&isFromZone="+isFromZone+"&iszoneName="+iszoneName+"&parentZone="+parentZone+"&serviceName="+encodeURIComponent(filterByParamFlag);
			Ext.Ajax.request({
				url :url,
				scope:this,
				timeout:280000,
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					var componentTypCombo = Ext.getCmp('componentTypCombo');
					componentTypCombo.getStore().loadRawData(jsonData.componentTypeOptions);
					componentTypCombo.setValue(jsonData.componentTypeOptions.selectedComponentType);
					componentTypCombo.setFieldLabel(jsonData.componentTypeOptions.componentTypeLabel);
				}
			});
		}
		else if(itemIdVal=='network' || itemIdVal=='Network')
		{
			url="/final/monitor/comparisonComponent.jsp?treeTitle=Network";
			url=url+"&filterBy="+filterByComboVal+"&subFilter="+encodeURIComponent(subFilterComboVal);
			if(requestParams.fromPageView != null && requestParams.fromPageView == 'CitrixDashboard')
				url=url+"&timeline="+encodeURIComponent(timeline);
			url=url+"&isCitrixComp=true&isfromCitrix=true&fromServiceHomePage="+isFromHomePage+"&isFromZone="+isFromZone+"&iszoneName="+iszoneName+"&parentZone="+parentZone+"&serviceName="+encodeURIComponent(filterByParamFlag);
			Ext.Ajax.request({
				url :url,
				scope:this,
				timeout:280000,
				success: function(response){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					var componentTypCombo = Ext.getCmp('componentTypCombo');
					componentTypCombo.getStore().loadRawData(jsonData.componentTypeOptions);
					componentTypCombo.setValue(jsonData.componentTypeOptions.selectedComponentType);
					componentTypCombo.setFieldLabel(jsonData.componentTypeOptions.componentTypeLabel);
				}
			});
		}
	},
	componentTypeComboOnChange:function(combo)
	{
		var treeFlag_SBD=requestParams.treeFlag_SBD;
		var outsideService_SBD=requestParams.outsideService_SBD;
		var titleText_SBD = requestParams.titleText_SBD;
		var selectNode_SBD = requestParams.selectNode_SBD;
		var isEmulTrans_SBD = requestParams.isEmulTrans_SBD;
		var serviceState_SBD = requestParams.serviceState_SBD;
		var serviceName = requestParams.serviceName;
		var serviceState = requestParams.serviceState;
		var isServiceBusiDash = requestParams.isServiceBusiDash;

		var userName=requestParams.userName;
		var stateName=requestParams.stateName;
		stateName=(stateName==null || stateName==undefined || stateName=='null')?"":stateName;
		var fromPageView=requestParams.fromPageView;
		var componentTypeVal=combo.getValue();
			compListType=componentTypeVal;
		var filterByComboVal="";
		if(Ext.getCmp('filterByCombo')!=null && Ext.getCmp('filterByCombo')!=undefined)
		{
			filterByComboVal = Ext.getCmp('filterByCombo').getValue();
		}

		var subFilterComboVal="";
		if(Ext.getCmp('subFilterCombo')!=null && Ext.getCmp('subFilterCombo')!=undefined && Ext.getCmp('subFilterCombo').getValue()!=null && Ext.getCmp('subFilterCombo').getValue()!='null')
		{
			subFilterComboVal = Ext.getCmp('subFilterCombo').getValue();
		}

		if(Ext.isEmpty(subFilterComboVal) || subFilterComboVal == null || subFilterComboVal == undefined){
			if(!Ext.isEmpty(filterByComboVal) && filterByComboVal != null && filterByComboVal != undefined && filterByComboVal.toLowerCase().indexOf("component") > -1 && !Ext.isEmpty(userMappingApplisTo) && userMappingApplisTo != null && userMappingApplisTo != undefined){
				if(userMappingApplisTo.indexOf(":") > 0){
					subFilterComboVal = userMappingApplisTo.substring(userMappingApplisTo.indexOf(":")+1);
				}
			}
		}

		if(Ext.isEmpty(subFilterComboVal) || subFilterComboVal == null || subFilterComboVal == undefined)
			subFilterComboVal = componentTypeVal;

		var nickNameVal="";
		if(Ext.getCmp('nickName')!=null && Ext.getCmp('nickName')!=undefined)
		{
			nickNameVal = Ext.getCmp('nickName').getValue();
		}
		
		var menuObj = Ext.getCmp('dashmenu_model_id');

		var store_data=menuObj.getStore();
		var forceKey=menuObj.forceClickKey;
		var selected_view_name="";
		for(var k=0;k<store_data.getCount();k++)
		{
			var caption_value=store_data.getAt(k).data.caption;
			if(requestParams.activeViewIndex==k)
			{
				selected_view_name=store_data.getAt(k).data.name;
				break;
			}
		}

		var url="";
		var itemIdVal=Ext.getCmp('perPanel').itemId;
		if(itemIdVal=='system' || itemIdVal=='System')
		{
			url="/final/monitor/comparisonSystem.jsp?treeTitle=System";
		}
		else if(itemIdVal=='components' || itemIdVal=='Components')
		{
			url="/final/monitor/comparisonComponent.jsp?treeTitle=Component";
		}
		else if(itemIdVal=='network' || itemIdVal=='Network')
		{
			url="/final/monitor/comparisonComponent.jsp?treeTitle=Network";
		}

		//url=url+"&filterBy="+filterByComboVal+"&subFilter="+encodeURIComponent(subFilterComboVal)+"&componentType="+encodeURIComponent(componentTypeVal)+"&componentNameSearch="+nickNameVal+"&fromPageView="+fromPageView;
		//Dashboard_ComponentType = componentTypeVal;
		selected_CompType_st = componentTypeVal;
		compTypeChanged = componentTypeVal;
		url=url+"&isCitrixComp=true&filterBy="+filterByComboVal+"&subFilter="+encodeURI(subFilterComboVal)+"&componentType="+encodeURI(componentTypeVal)+"&componentNameSearch=&fromPageView=CitrixDashboard&userName="+encodeURI(userName)+"&selectedState="+stateName;
		sortState="";
		DirProperty="";
		if(!Ext.isEmpty(requestParams.isServiceBusiDetails) && requestParams.isServiceBusiDetails!=undefined && requestParams.isServiceBusiDetails!=null)
			url = url +"&isServiceBusiViewMetrics="+requestParams.isServiceBusiDetails + '&treeFlag_SBD='+treeFlag_SBD+'&outsideService_SBD='+outsideService_SBD+'&titleText_SBD='+titleText_SBD+'&selectNode_SBD='+selectNode_SBD+'&serviceFromZone='+serviceName+'&isEmulTrans_SBD='+isEmulTrans_SBD+'&serviceName='+serviceName+'&serviceState_SBD='+serviceState_SBD+'&isServiceBusiDash='+isServiceBusiDash;

		if(requestParams.fromPageView != null && requestParams.fromPageView == 'CitrixDashboard')
			url=url+"&timeline="+encodeURIComponent(timeline);
		
		var selected_dash = '';
		if(!Ext.isEmpty(Ext.getCmp('dashListComId')) && Ext.getCmp('dashListComId')!=null && Ext.getCmp('dashListComId')!=undefined)
			selected_dash = Ext.getCmp('dashListComId').getValue();

		url=url+'&isfromCitrix=true&iniName='+iniName+'&user_name='+user_name+'&dashboard_mapping='+selected_dash+'&dashboard_name='+dashboard+'&firstTime=true&view_name='+selected_view_name+"&fromServiceHomePage="+isFromHomePage+"&isFromZone="+isFromZone+"&iszoneName="+iszoneName+"&parentZone="+parentZone+"&serviceName="+encodeURIComponent(filterByParamFlag)+"&isFromServiceMenu="+isFromServiceMenu+"&isFromZoneMain="+isFromZoneMain+"&isFromZoneMenu="+isFromZoneMenu+"&isFromServiceGroup="+isFromServiceGroup+"&isCitrixComp=true&fromSerComboChange="+fromSerComboChange;

		Refurl=url;
		Ext.getCmp('perPanel').loadTab(url,'','','','','','citrixDashboardForComponent');
	},
	systemsComboChange:function(combo)
	{
		selected_CompType_st ='';
		var selected_dash = '';
		if(!Ext.isEmpty(Ext.getCmp('dashListComId')) && Ext.getCmp('dashListComId')!=null && Ext.getCmp('dashListComId')!=undefined)
			selected_dash = Ext.getCmp('dashListComId').getValue();
		
		var menuObj = Ext.getCmp('dashmenu_model_id');

		var store_data=menuObj.getStore();
		var forceKey=menuObj.forceClickKey;
		var selected_view_name="";
		for(var k=0;k<store_data.getCount();k++)
		{
			var caption_value=store_data.getAt(k).data.caption;
			if(requestParams.activeViewIndex==k)
			{
				selected_view_name=store_data.getAt(k).data.name;
				break;
			}
		}

		
		SysComponentType = combo.getValue(); 

		var systemView_containerObj = Ext.getCmp('systemViewMeasuresgridpanel');
		var urlt = systemView_containerObj.url;
		urlt += "&selectNode=Service$cap$"+encodeURIComponent(filterByParamFlag)+"&componentType="+encodeURI(SysComponentType)+"&selectedParam="+encodeURIComponent(filterByParamFlag)+"&currentTab=Systems&isSite=true&aggregateTab=false&hasTransactions=true&hasEmulatedTransactions=false&fromHomepage=&hasLogonSimulations=true&refresh=true&action=Systems&topoSegment="+encodeURIComponent(filterByParamFlag)+'&isfromCitrix=true&iniName='+iniName+'&user_name='+user_name+'&dashboard_name='+dashboard+'&dashboard_mapping='+selected_dash+'&view_name='+selected_view_name+"&fromServiceHomePage="+isFromHomePage+"&fromSerComboChange="+fromSerComboChange+"&isFromZone="+isFromZone+"&iszoneName="+iszoneName+"&parentZone="+parentZone+"&filter=service&filterBy="+encodeURIComponent(filterByParamFlag)+"&isFromServiceMenu="+isFromServiceMenu+"&isFromZoneMain="+isFromZoneMain+"&isFromZoneMenu="+isFromZoneMenu+"&isFromServiceGroup="+isFromServiceGroup;
		systemView_containerObj.loadTab(urlt,'servicesSys');
	},
	compSubmitButtonClicked:function()
	{
		componentNameSearch = "";
		var fromPageView=requestParams.fromPageView;
		var userName=requestParams.userName;
		var stateName=requestParams.stateName;
		stateName=(stateName==null || stateName==undefined || stateName=='null')?"":stateName;
		if(stateName==null || stateName==undefined || stateName=='')
		{
			stateName = requestParams.selectedState;
		}
		stateName=(stateName==null || stateName==undefined || stateName=='null')?"":stateName;
		var filterByComboVal="";
		if(Ext.getCmp('filterByCombo')!=null && Ext.getCmp('filterByCombo')!=undefined)
		{
			filterByComboVal = Ext.getCmp('filterByCombo').getValue();
		}

		var subFilterComboVal="";
		if(Ext.getCmp('subFilterCombo')!=null && Ext.getCmp('subFilterCombo')!=undefined && Ext.getCmp('subFilterCombo').getValue()!=null && Ext.getCmp('subFilterCombo').getValue()!='null')
		{
			subFilterComboVal = Ext.getCmp('subFilterCombo').getValue();
		}

		var componentTypeVal="";
		if(Ext.getCmp('componentTypCombo')!=null && Ext.getCmp('componentTypCombo')!=undefined && Ext.getCmp('componentTypCombo').getValue()!=null && Ext.getCmp('componentTypCombo').getValue()!='null')
		{
			componentTypeVal = Ext.getCmp('componentTypCombo').getValue();
		}
		var nickNameVal="";
		if(Ext.getCmp('nickName')!=null && Ext.getCmp('nickName')!=undefined && Ext.getCmp('nickName').getValue()!=null && Ext.getCmp('nickName').getValue()!='null')
		{
			nickNameVal = Ext.getCmp('nickName').getValue();
		}
		var sortByComboVal="";
		if(Ext.getCmp('sortByCombo')!=null && Ext.getCmp('sortByCombo')!=undefined && Ext.getCmp('sortByCombo').getValue()!=null && Ext.getCmp('sortByCombo').getValue()!='null')
		{
			sortByComboVal = Ext.getCmp('sortByCombo').getValue();
		}
		var url="";
		var itemIdVal=Ext.getCmp('perPanel').itemId;

		if(itemIdVal=='system' || itemIdVal=='System')
		{
			url="/final/monitor/comparisonSystem.jsp?treeTitle=System";
			url=url+"&filterBy="+filterByComboVal+"&subFilter="+encodeURIComponent(subFilterComboVal)+"&componentNameSearch="+encodeURIComponent(nickNameVal)+"&viewPageTitle="+encodeURIComponent(requestParams.viewPageTitle);
		}
		else if(itemIdVal=='components' || itemIdVal=='Components')
		{
			url="/final/monitor/comparisonComponent.jsp?treeTitle=Component";
			url=url+"&isCitrixComp=true&filterBy="+filterByComboVal+"&subFilter="+encodeURIComponent(subFilterComboVal)+"&componentType="+encodeURIComponent(componentTypeVal)+"&componentNameSearch="+encodeURIComponent(nickNameVal)+"&fromPageView="+fromPageView+"&userName="+encodeURIComponent(userName)+"&selectedState="+stateName+"&viewPageTitle="+encodeURIComponent(requestParams.viewPageTitle);
		}
		else if(itemIdVal=='network' || itemIdVal=='Network')
		{
			url="/final/monitor/comparisonComponent.jsp?treeTitle=Network";
			url=url+"&isCitrixComp=true&filterBy="+filterByComboVal+"&subFilter="+encodeURIComponent(subFilterComboVal)+"&componentType="+encodeURIComponent(componentTypeVal)+"&componentNameSearch="+encodeURIComponent(nickNameVal)+"&fromPageView="+fromPageView+"&userName="+encodeURIComponent(userName)+"&selectedState="+stateName+"&viewPageTitle="+encodeURIComponent(requestParams.viewPageTitle);
		}

		/*if(!Ext.isEmpty(isServiceBusiViewMetrics) && isServiceBusiViewMetrics!=null && isServiceBusiViewMetrics!=undefined && (isServiceBusiViewMetrics=='true'||isServiceBusiViewMetrics==true))
			url = url +"&isServiceBusiViewMetrics="+isServiceBusiViewMetrics;*/

		if(requestParams.fromPageView != null && requestParams.fromPageView == 'CitrixDashboard')
			url=url+"&timeline="+encodeURIComponent(timeline);
		
		var url = url+"&serviceName="+encodeURIComponent(filterByParamFlag);

		var selected_dash = '';
		if(!Ext.isEmpty(Ext.getCmp('dashListComId')) && Ext.getCmp('dashListComId')!=null && Ext.getCmp('dashListComId')!=undefined)
			selected_dash = Ext.getCmp('dashListComId').getValue();
		
		var menuObj = Ext.getCmp('dashmenu_model_id');

		var store_data=menuObj.getStore();
		var forceKey=menuObj.forceClickKey;
		var selected_view_name="";
		for(var k=0;k<store_data.getCount();k++)
		{
			var caption_value=store_data.getAt(k).data.caption;
			if(requestParams.activeViewIndex==k)
			{
				selected_view_name=store_data.getAt(k).data.name;
				break;
			}
		}

		url=url+'&isfromCitrix=true&iniName='+iniName+'&user_name='+user_name+'&dashboard_mapping='+selected_dash+'&dashboard_name='+dashboard+'&view_name='+selected_view_name+"&fromServiceHomePage="+isFromHomePage+"&fromServiceHomePage="+isFromHomePage+"&isFromZone="+isFromZone+"&iszoneName="+iszoneName+"&parentZone="+parentZone;
		Refurl=url;
		Ext.getCmp('perPanel').loadTab(url,'','','','','','citrixDashboardForComponent');
	},
	geoComboOnChange:function(currObj)
	{
		perVal=0;
		
		var TimeLineObj = Ext.getCmp('TimeLineId');
		var time_line = null;
		if(TimeLineObj!=null && TimeLineObj!=undefined)
		{
			time_line = TimeLineObj.getValue();
		}
		if(time_line==null || time_line==undefined || time_line=="")
			time_line="Current";

		var menuObj = Ext.getCmp('dashmenu_model_id');

		var store_data=menuObj.getStore();
		var forceKey=menuObj.forceClickKey;
		var selected_view_name="";
		for(var k=0;k<store_data.getCount();k++)
		{
			var caption_value=store_data.getAt(k).data.caption;
			if(requestParams.activeViewIndex==k)
			{
				selected_view_name=store_data.getAt(k).data.name;
				break;
			}
		}

		var filterName="";
		var filter_view_name="";
		if(!Ext.isEmpty(selected_view_name) && selected_view_name.trim() == "Geo_View") 
		{
			var countryComboIdObj = Ext.getCmp('countryComboId');
			var regionComboIdObj = Ext.getCmp('regionComboId');
			var currId=null;
			if(currObj!=null && currObj!=undefined)
			{
				currId = currObj.id;
			}

			if(countryComboIdObj!=null && countryComboIdObj!=undefined && currId!=null && currId!=undefined && currId==countryComboIdObj.id)
			{
				filterName = countryComboIdObj.getValue();
				if(filterName!=null && filterName!=undefined && filterName=='World')
				{
					filterName = "World";
					filter_view_name = "";
				}
				else
				{
					try
					{
						var regionlblObj = Ext.getCmp('region_label');
						var countryComboIdObj = Ext.getCmp('countryComboId');
						var countryComboIdObjF = countryComboIdObj.getRawValue();
						if(countryComboIdObjF != undefined && countryComboIdObjF != null){
							//regionlblObj.setHTML('<span style="margin:1px !important;text-decoration:none;float:left" class="geoDrilldownLink">'+regionComboIdValF+'</span>');
							regionlblObj.setText(countryComboIdObjF);	
						}
					}catch(ww){

					}
					filter_view_name = "Geo_Country_View";
				}
			}
			else if(regionComboIdObj!=null && regionComboIdObj!=undefined && currId!=null && currId!=undefined && currId==regionComboIdObj.id)
			{
				filterName = regionComboIdObj.getValue();

				if(filterName!=null && filterName!=undefined && filterName=='AllRegion')
				{
					if(countryComboIdObj!=null && countryComboIdObj!=undefined && countryComboIdObj.getValue()!="World")
					{
						if(!Ext.isEmpty(forceKey))
							filterName = forceKey;
						else
							filterName = countryComboIdObj.getValue();
						filter_view_name = "Geo_Country_View";
					}
					else
					{
						filterName ="";
						filter_view_name = "";
					}
				}
				else
				{
					try
					{
						var regionObj = Ext.getCmp('region_icon');
						var countryComboIdObj = Ext.getCmp('countryComboId');
						var countryComboIdValF = countryComboIdObj.getRawValue();
						if(countryComboIdValF != undefined && countryComboIdValF != null){
							regionObj.setText('<span style="float:left" class="geoDrilldownLink">'+countryComboIdValF+'</span><div class="geoDrilldownArrow"></div>');	
						}
						
						var cityObj = Ext.getCmp('city_icon');
						var regionComboIdObj = Ext.getCmp('regionComboId');
						var regionComboIdValF = regionComboIdObj.getRawValue();
						if(regionComboIdValF != undefined && regionComboIdValF != null){
							//cityObj.setHTML('<span style="margin:1px !important;text-decoration:none;float:left" class="geoDrilldownLink">'+regionComboIdValF+'</span>');
							cityObj.setText(regionComboIdValF);
						}
					}
					catch (ert)
					{
					}
							
					filter_view_name = "Geo_Region_View";
				}
			}

			if(filterName==null || filterName==undefined || filterName=="")
				filterName="";
		}
		else if(!Ext.isEmpty(selected_view_name) && selected_view_name.trim() == "Logon_View") 
		{
			filterName = "Logon_View";
		}

		var refurl="/final/servlet/com.eg.EgCommonDashboardController?iniName="+iniName+"&user_name="+encodeURI(user_name)+"&action=loadViewData&subject="+encodeURI(dashboard)+"&time_line="+encodeURI(time_line)+"&isUserBased=true&view_name="+encodeURI(selected_view_name)+"&filterName="+encodeURI(filterName)+"&filterViewName="+encodeURI(filter_view_name)+"&dashboard_mapping="+encodeURI(dashboard_mapping)+"&fromSerComboChange="+fromSerComboChange+'&dashboard_name='+dashboard;

		Ext.Ajax.request({
		url : refurl,
		method : 'POST',
		scope:this,
		timeout:280000,
		success : function(response, opts)
		{
			var jsonText = response.responseText;
			var noWidgets=true;
			if(jsonText!=null && jsonText!=undefined)
			{
				var jsonData = Ext.decode(jsonText);
				if(!Ext.isEmpty(selected_view_name) && selected_view_name.trim() == "Geo_View")
				{
					if(jsonData!=null && jsonData!=undefined)
					{
						if(jsonData.loadViewDetails!=null && jsonData.loadViewDetails!=undefined)
						{
							var panelDataArr=jsonData.loadViewDetails;
							if(panelDataArr!=null && panelDataArr!=undefined && panelDataArr.length>0)
							{
								if(!Ext.isEmpty(panelDataArr[0]) && panelDataArr[0]!=undefined)
								{
									var geoidObj = Ext.getCmp('geo_first_header_id');
									geoidObj.setTitle(panelDataArr[0].Geo_Block_1_Title);
								}

								if(!Ext.isEmpty(panelDataArr[1]) && panelDataArr[1]!=undefined)
								{
									//Ext.getCmp('hostDetailsId').updateData(panelDataArr[1].Geo_Block_1_Value);
									Ext.getCmp('geo_overviewpanel_id').updateData(panelDataArr[1].Geo_Block_1_Value);
									//Ext.getCmp('geo_overview_id').jsonData=panelDataArr[1].Geo_Block_1_Value;
									//Ext.getCmp('geo_overview_id').updateData(panelDataArr[1].Geo_Block_1_Value);
								}

								if(!Ext.isEmpty(panelDataArr[2]) && panelDataArr[2]!=undefined)
								{
									if(panelDataArr[2].Geo_Block_2_Value[0].resultArray != null && panelDataArr[2].Geo_Block_2_Value[0].resultArray.length > 0)
									{
										if(filter_view_name==null || filter_view_name==undefined || filter_view_name=='')
										{
											var countryComboObj = Ext.getCmp('countryComboId');
											if(!Ext.isEmpty(countryComboObj) && countryComboObj!=undefined)
											{
												countryComboObj.show();

												countryComboObj.getStore().loadRawData(panelDataArr[2].Geo_Block_2_Value[0].countryArray);
												countryComboObj.setValue(panelDataArr[2].Geo_Block_2_Value[0].selectedCountry);
											}

											var regionComboObj = Ext.getCmp('regionComboId');
											if(!Ext.isEmpty(regionComboObj) && regionComboObj!=undefined)
											{
												regionComboObj.show();
												regionComboObj.getStore().loadRawData();
												regionComboObj.setValue("");
												regionComboObj.hide();
												//regionComboObj.getStore().loadRawData(panelDataArr[2].Geo_Block_2_Value[0].regionArray);
												//regionComboObj.setValue(panelDataArr[2].Geo_Block_2_Value[0].selectedRegion);
											}
										}
										else if(filter_view_name!=null && filter_view_name!=undefined && filter_view_name=='Geo_Country_View')
										{
											var regionComboObj = Ext.getCmp('regionComboId');
											if(!Ext.isEmpty(regionComboObj) && regionComboObj!=undefined)
											{
												regionComboObj.show();

												regionComboObj.getStore().loadRawData(panelDataArr[2].Geo_Block_2_Value[0].regionArray);
												regionComboObj.setValue(panelDataArr[2].Geo_Block_2_Value[0].selectedRegion);
											}
										}
									}
									
									Ext.getCmp('geo_id_map').updateData(panelDataArr[2].Geo_Block_2_Value[0]);
									try
									{
										if(filter_view_name==null || filter_view_name==undefined || filter_view_name=='')
										{
											Ext.getCmp('geo_map_conainer_id').remove('geo_mapdetails_id');
										}
										else
											Ext.getCmp('geo_id_mapdetails').updateData(panelDataArr[2].Geo_Block_2_Value[0]);
									}
									catch (e)
									{
										Ext.getCmp('geo_map_conainer_id').add({
											xtype:'container',
											id:'geo_mapdetails_id',
											flex:0.3,
											width:210,
											padding:'20 10 10 10',
											items:[{
												xtype:'geomapdetails',
												id:'geo_id_mapdetails',
												jsonData:panelDataArr[2].Geo_Block_2_Value[0],
												//jsonData1:JsonMapData1
											}]
										});
									}
									//Ext.getCmp('geo_id_mapdetails').updateData(panelDataArr[2].Geo_Block_2_Value[0]);
								}

								if(!Ext.isEmpty(panelDataArr[3]) && panelDataArr[3]!=undefined)
								{
									//var geoidObj = Ext.getCmp('geo_first_header_id');
									//geoidObj.setTitle(panelDataArr[3].Geo_Block_1_Title);

									//var geoidObj = Ext.getCmp('geo_first_header_id');
									//geoidObj.setTitle(panelDataArr[0].Geo_Block_1_Title);
								}

								if(!Ext.isEmpty(panelDataArr[4]) && panelDataArr[4]!=undefined)
								{
									if(filter_view_name==null || filter_view_name==undefined || filter_view_name=='')
									{
										Ext.getCmp('geo_alerts3x1_id').flex = 0.40;
										Ext.getCmp('geo_alerts3x1_id').getEl().setStyle({padding:'10 15 10 10'});
										Ext.getCmp('geo_alerts3x1_id').removeAll(true);
										try
										{
											Ext.getCmp('geo_alerts3x1_id').add({
												xtype:'overviewctxpanel',
												id:'geo_overviewpanel3x1_alert_id',
												jsonData:panelDataArr[4].Geo_Block_3_Value,
												//jsonData:tmpPanelArrays2,
												key:'overview',
												layout:{
													type:'vbox',
													align:'stretch'
												}
											});
										}
										catch (e)
										{
										}
										Ext.getCmp('geoViewId').doLayout();
									}
									else
									{
										Ext.getCmp('geo_alerts3x1_id').flex = 0.25;
										Ext.getCmp('geo_alerts3x1_id').getEl().setStyle({padding:'10 0 0 10'});
										Ext.getCmp('geo_alerts3x1_id').removeAll(true);
										try
										{
											Ext.getCmp('geo_alerts3x1_id').add({
												xtype:'overviewverticalpanel',
												id:'geo_overviewpanel3x1_alert_id',
												margin:0,
												padding:'0 0 0 0',
												ifGeo:true,
												flex:1,
												//jsonData:panelDataArr[4].Geo_Block_3_Value,
												//jsonData:tmpPanelArrays2,
												jsonData:panelDataArr[4].Geo_Block_3_Value,
												key:'geo3x1',
											});
										}
										catch (e)
										{
										}
										Ext.getCmp('geoViewId').doLayout();
									}
									
								}

								if((!Ext.isEmpty(panelDataArr[5]) && panelDataArr[5]!=undefined))
								{
									var geo_chartObj = Ext.getCmp('multBarIns_geo');
									var geoBarInsObj = Ext.getCmp('geoBarIns');
									geoBarInsObj.removeAll(true);
									geoBarInsObj.add({
										xtype:'chartparentpanel',
										id:'multBarIns_geo',
										//style:{'border':'1px solid red'},
										bodyPadding:0,
										margin:0,
										//legendPosition: 'top',
										//chartType:panelDataArr[3].Application_Block_2_Value.result.chartType,
										data:panelDataArr[5].Geo_Block_4_Value,
										flex:1,
										//height:500
										//width:'100%',
										//data:panelDataArr[3].Application_Block_2_Value.result
										//data:panelDataArr[3].Application_Block_2.result
										//html:'<table><tr><td>'+overviewData[0]['chart']+'</td></tr></table>'
									});
									geoBarInsObj.doLayout();
								}
							}
						}
					}
				}
				else if(!Ext.isEmpty(selected_view_name) && selected_view_name.trim() == "Overview_View")
				{
					if(!Ext.isEmpty(panelDataArr[0]) && panelDataArr[0]!=undefined)
					{
						var overviewIdObj = Ext.getCmp('overview_first_header_id');
						overviewIdObj.setTitle(panelDataArr[0].Overview_Block_1_Title);
					}

					if(!Ext.isEmpty(panelDataArr[1]) && panelDataArr[1]!=undefined)
					{
						Ext.getCmp('overview_details_id').updateData(panelDataArr[1].Overview_Block_1_Value);
					}

					if(!Ext.isEmpty(panelDataArr[2]) && panelDataArr[2]!=undefined)
					{
						Ext.getCmp('overview_map_id').updateData(panelDataArr[2].Overview_Block_2_Value[0]);
						Ext.getCmp('overviewctxpanel_right_top_panel_id').updateData(panelDataArr[2].Overview_Block_2_Value[0]);
					}

					if((!Ext.isEmpty(panelDataArr[3]) && panelDataArr[3]!=undefined))
					{
						var overview_chartObj = Ext.getCmp('multBarIns_overview');
						overview_chartObj.data=panelDataArr[3].Overview_Block_3_Value;
						overview_chartObj.updateChart(panelDataArr[3].Overview_Block_3_Value);
					}
				}
			}
		},
		failure:function(){
			//setTimeout("execute()",60000);
		}
		});
	},
	refresh:function(currObj)
	{
		isRefreshing = true;
		perVal=0;
		try
		{
			var isSessionWindowOpen = document.getElementById('isSessionWindowOpen').value;	
			if(isSessionWindowOpen == 'true' || isSessionWindowOpen == true)
				return;
			
		}
		catch (e)
		{
		}
		var TimeLineObj = Ext.getCmp('TimeLineId');
		var time_line = null;
		if(TimeLineObj!=null && TimeLineObj!=undefined)
		{
			time_line = TimeLineObj.getValue();
		}
		if(time_line==null || time_line==undefined || time_line=="")
			time_line="Current";

		var menuObj = Ext.getCmp('dashmenu_model_id');
		var store_data = null;
		var forceKey=null;
		if(!Ext.isEmpty(menuObj) && menuObj!=undefined && menuObj!=null){
			store_data = menuObj.getStore();
			forceKey = menuObj.forceClickKey;
		}
		var selected_view_name = "";
		if(!Ext.isEmpty(store_data) && store_data!=undefined && store_data!=null)
		{
			for(var k=0;k<store_data.getCount();k++)
			{
				var caption_value=store_data.getAt(k).data.caption;
				if(requestParams.activeViewIndex==k)
				{
					selected_view_name=store_data.getAt(k).data.name;
					break;
				}
			}
		}

		var filterName="";
		//var forceKey=menuObj.forceClickKey;
		var filter_view_name="";
		if(!Ext.isEmpty(selected_view_name) && selected_view_name.trim() == "Geo_View") 
		{
			var countryComboIdObj = Ext.getCmp('countryComboId');
			var regionComboIdObj = Ext.getCmp('regionComboId');

			if(countryComboIdObj!=null && countryComboIdObj!=undefined)
			{
				var countryFilterName = countryComboIdObj.getValue();
				if(countryFilterName!=null && countryFilterName!=undefined && countryFilterName!="" && countryFilterName!='World')
				{
					if(!Ext.isEmpty(forceKey))
						filterName = forceKey;
					else
						filterName = countryFilterName;
					filter_view_name = "Geo_Country_View";
				}
				else if(countryFilterName!=null && countryFilterName!=undefined && countryFilterName!="" && countryFilterName=='World')
				{
					filterName = countryFilterName;
					filter_view_name = "";
				}
			}

			if(regionComboIdObj!=null && regionComboIdObj!=undefined)
			{
				var regionFilterName = regionComboIdObj.getValue();
				if(regionFilterName!=null && regionFilterName!=undefined && regionFilterName!="" && regionFilterName!='AllRegion' && regionFilterName!='World')
				{
					filterName = regionFilterName;
					filter_view_name = "Geo_Region_View";
				}
				else if(regionFilterName!=null && regionFilterName!=undefined && regionFilterName!="" && regionFilterName!='AllRegion' && regionFilterName=='World')
				{
					filterName = countryFilterName;
					filter_view_name = "";
				}
			}

			if(filterName==null || filterName==undefined || filterName=="")
				filterName="World";

			try
			{
				var ComboBarObject = '';
				var tval = '';
				var appendValset = '';
				var firstIte = 0;
				for(var y=0;y<20;y++)
				{
					ComboBarObject = Ext.getCmp('Geo_View_ComboBar'+y);
					if(!Ext.isEmpty(ComboBarObject))
					{
						tval = ComboBarObject.getValue();
						if(firstIte == 0)
							appendValset = tval;
						else
							appendValset += '^#^'+tval

						firstIte++;
					}					
				}
			}
			catch (ert)
			{}
		}
		else if(!Ext.isEmpty(selected_view_name) && selected_view_name.trim() == "Overview_View")
		{
			filterName = "World";
			filter_view_name = "";
			try
			{
				var ComboBarObject = '';
				var tval = '';
				var appendValset = '';
				var firstIte = 0;
				for(var y=0;y<20;y++)
				{
					ComboBarObject = Ext.getCmp('Overview_View_ComboBar'+y);
					if(!Ext.isEmpty(ComboBarObject))
					{
						tval = ComboBarObject.getValue();
						if(firstIte == 0)
							appendValset = tval;
						else
							appendValset += '^#^'+tval

						firstIte++;
					}					
				}
			}
			catch (ert)
			{}
			//Overview_View_ComboBar
		}
		else if(!Ext.isEmpty(selected_view_name) && selected_view_name.trim() == "Logon_View") 
		{
			filterName="Logon_View";
		}

		if(Ext.isEmpty(appendValset) && appendValset == undefined && appendValset == null)
			appendValset='';

		if(!Ext.isEmpty(selected_view_name) && selected_view_name.trim() == "Metrics_View")
		{
			var metrics_containerObj = Ext.getCmp('metrics_container');
			if(!Ext.isEmpty(userMappingApplisTo) && userMappingApplisTo != null && userMappingApplisTo != undefined){
				if(userMappingApplisTo.indexOf(":") > 0){
					var filter = userMappingApplisTo.substring(0,userMappingApplisTo.indexOf(":"));
					var filterBy = userMappingApplisTo.substring(userMappingApplisTo.indexOf(":")+1);
					if(filter != null && filter == 'Service')
						filter = 'services';					
				}
			}
			var compTypeComboFlag = false;
			if(filter.toLowerCase().indexOf("component") > -1)
				compTypeComboFlag = true;

			var selected_dash = '';
			if(!Ext.isEmpty(Ext.getCmp('dashListComId')) && Ext.getCmp('dashListComId')!=null && Ext.getCmp('dashListComId')!=undefined)
				selected_dash = Ext.getCmp('dashListComId').getValue();
			
			var compTypeName="";
			if(Ext.getCmp('componentTypCombo')!=null && Ext.getCmp('componentTypCombo')!=undefined && Ext.getCmp('componentTypCombo')!=null && Ext.getCmp('componentTypCombo')!='null')
			{
				compTypeName =Ext.getCmp('componentTypCombo').getValue();
			}

			var nickNameVal="";
			if(Ext.getCmp('nickName')!=null && Ext.getCmp('nickName')!=undefined && Ext.getCmp('nickName').getValue()!=null && Ext.getCmp('nickName').getValue()!='null')
			{
				nickNameVal = Ext.getCmp('nickName').getValue();
			}
			if(componentNameSearch != null && componentNameSearch !='null' && componentNameSearch != undefined &&  componentNameSearch != 'undefined')
			{
				nickNameVal = componentNameSearch;
			}
			var url = '/final/monitor/comparisonComponent.jsp?treeTitle=citrixcomponents&selectedState=&componentNameSearch='+nickNameVal+'&fromPageView=CitrixDashboard&viewPageTitle=Components&action=component&fromHomepage=&userName=&filterBy='+filter+'&subFilter='+filterBy+'&timeline=null&isfromCitrix=true&iniName='+iniName+'&user_name='+user_name+'&dashboard_mapping='+selected_dash+'&dashboard_name='+dashboard+'&view_name='+selected_view_name+"&fromServiceHomePage="+isFromHomePage+"&isFromZone="+isFromZone+"&iszoneName="+iszoneName+"&parentZone="+parentZone+"&firstTime=true&filter=service&serviceName="+encodeURIComponent(filterByParamFlag)+"&isFromServiceMenu="+isFromServiceMenu+"&isFromZoneMain="+isFromZoneMain+"&isFromZoneMenu="+isFromZoneMenu+"&isFromServiceGroup="+isFromServiceGroup+"&isCitrixComp=true&fromSerComboChange="+fromSerComboChange;
			
			
			if (typeof hasCitrix === "string"){
				if(hasCitrix == "true"){
					if(selected_CompType_st != null && selected_CompType_st !='' && selected_CompType_st != 'undefined' && selected_CompType_st != undefined)
						url += '&componentType='+selected_CompType_st;
					else if(((filter != null && filter.indexOf("Agg_") >= 0) || (requestParams.serviceCombo != null && requestParams.serviceCombo[0].selected.indexOf("Agg_") >= 0)) && isUserHaveDirector)
						url += '&componentType='+directorTypes;
				}
				else
				{
					if(selected_CompType_st != null && selected_CompType_st !='' && selected_CompType_st != 'undefined' && selected_CompType_st != undefined)
						url += '&componentType='+selected_CompType_st;
					else if(((filter != null && filter.indexOf("Agg_") >= 0) || (requestParams.serviceCombo != null && requestParams.serviceCombo[0].selected.indexOf("Agg_") >= 0)) && isUserHaveDirector)
						url += '&componentType='+directorTypes;	
				}
			}else{
				if(hasCitrix){
					if(selected_CompType_st != null && selected_CompType_st !='' && selected_CompType_st != 'undefined' && selected_CompType_st != undefined)
						url += '&componentType='+selected_CompType_st;
					else if(((filter != null && filter.indexOf("Agg_") >= 0) || (requestParams.serviceCombo != null && requestParams.serviceCombo[0].selected.indexOf("Agg_") >= 0)) && isUserHaveDirector)
						url += '&componentType='+directorTypes;
				}
				else
				{
					if(selected_CompType_st != null && selected_CompType_st !='' && selected_CompType_st != 'undefined' && selected_CompType_st != undefined)
						url += '&componentType='+selected_CompType_st;
					else if(((filter != null && filter.indexOf("Agg_") >= 0) || (requestParams.serviceCombo != null && requestParams.serviceCombo[0].selected.indexOf("Agg_") >= 0)) && isUserHaveDirector)
						url += '&componentType='+directorTypes;		
				}
			}

			metrics_containerObj.removeAll(true);
			metrics_containerObj.add({
				xtype:'metricscomponentlist',
				id:'metricscomponentlist_id',
				compTypeComboNeeded:compTypeComboFlag,
				margin:0,
				padding:0,
				metricsURL:url
			});
			metrics_containerObj.doLayout();			
		}
		else if(!Ext.isEmpty(selected_view_name) && selected_view_name.trim() == "Systems_View")
		{			
			var selected_dash = '';
			if(!Ext.isEmpty(Ext.getCmp('dashListComId')) && Ext.getCmp('dashListComId')!=null && Ext.getCmp('dashListComId')!=undefined)
				selected_dash = Ext.getCmp('dashListComId').getValue();
			var systemView_containerObj = Ext.getCmp('systemViewMeasuresgridpanel');
			var urlt = systemView_containerObj.url;
			urlt += "&selectNode=Service$cap$"+encodeURIComponent(filterByParamFlag)+"&componentType="+encodeURI(SysComponentType)+"&selectedParam="+encodeURIComponent(filterByParamFlag)+"&currentTab=Systems&isSite=true&aggregateTab=false&hasTransactions=true&hasEmulatedTransactions=false&fromHomepage=&hasLogonSimulations=true&refresh=true&action=Systems&topoSegment="+encodeURIComponent(filterByParamFlag)+'&isfromCitrix=true&iniName='+iniName+'&user_name='+user_name+'&dashboard_mapping='+selected_dash+'&dashboard_name='+dashboard+'&view_name='+selected_view_name+"&fromServiceHomePage="+isFromHomePage+"&fromSerComboChange="+fromSerComboChange+"&isFromZone="+isFromZone+"&iszoneName="+iszoneName+"&parentZone="+parentZone+"&filter=service&filterBy="+encodeURIComponent(filterByParamFlag)+"&isFromServiceMenu="+isFromServiceMenu+"&isFromZoneMain="+isFromZoneMain+"&isFromZoneMenu="+isFromZoneMenu+"&isFromServiceGroup="+isFromServiceGroup;		
			systemView_containerObj.loadTab(urlt,'servicesSys');			
		}
		else if(!Ext.isEmpty(selected_view_name) && selected_view_name.trim() == "Aggregates_View")
		{			
			var selected_dash = '';
			if(!Ext.isEmpty(Ext.getCmp('dashListComId')) && Ext.getCmp('dashListComId')!=null && Ext.getCmp('dashListComId')!=undefined)
				selected_dash = Ext.getCmp('dashListComId').getValue();
			var aggView_containerObj = Ext.getCmp('systemViewAggregatesgridpanel');
			var urlt = aggView_containerObj.url;
			urlt += "&selectNode=Service$cap$"+encodeURIComponent(filterByParamFlag)+"&selectedParam="+encodeURIComponent(filterByParamFlag)+"&currentTab=Systems&isSite=true&aggregateTab=true&hasTransactions=true&hasEmulatedTransactions=false&fromHomepage=&hasLogonSimulations=true&refresh=true&action=Systems&topoSegment="+encodeURIComponent(filterByParamFlag)+'&isfromCitrix=true&iniName='+iniName+'&user_name='+user_name+'&dashboard_mapping='+selected_dash+'&dashboard_name='+dashboard+'&view_name='+selected_view_name+"&fromServiceHomePage="+isFromHomePage+"&fromSerComboChange="+fromSerComboChange+"&isFromZone="+isFromZone+"&iszoneName="+iszoneName+"&parentZone="+parentZone+"&filter=service&filterBy="+encodeURIComponent(filterByParamFlag)+"&isFromServiceMenu="+isFromServiceMenu+"&isFromZoneMain="+isFromZoneMain+"&isFromZoneMenu="+isFromZoneMenu+"&isFromServiceGroup="+isFromServiceGroup;
			//urlt += '&aggregateComp='+requestParams.aggregateComp;
			aggView_containerObj.loadTab(urlt,'servicesAgg');			
		}
		else if(!Ext.isEmpty(selected_view_name) && selected_view_name.trim() == "Services_Topology_View"){
			if(!Ext.isEmpty(userMappingApplisTo) && userMappingApplisTo != null && userMappingApplisTo != undefined){
				if(userMappingApplisTo.indexOf(":") > 0){
					var serName = userMappingApplisTo.substring(userMappingApplisTo.indexOf(":")+1);									
				}
			}
			
			var selected_dash = '';
			if(!Ext.isEmpty(Ext.getCmp('dashListComId')) && Ext.getCmp('dashListComId')!=null && Ext.getCmp('dashListComId')!=undefined)
				selected_dash = Ext.getCmp('dashListComId').getValue();
			var record = '';
			try
			{
				record = Ext.getCmp('servce_combo_id').getValue();	
				if(!Ext.isEmpty(selectedSegmentName) && selectedSegmentName != null && selectedSegmentName != undefined && selectedSegmentName != 'null' && selectedSegmentName != 'undefined')
				{
					record = selectedSegmentName;
				}
			}
			catch (er)
			{
				if(!Ext.isEmpty(ifAssSeg) && ifAssSeg != null && ifAssSeg != undefined){
					var segName = "";
					if(ifAssSeg.indexOf(",") > 0){
						ifAssSeg = ifAssSeg.trim();
						isSerComboNeed = true;
						assSeg = ifAssSeg.split(',');
						for(var t=0;t<assSeg.length;t++){
							assSegArray[t] = {"value":assSeg[t]};
						}
						var segName = ifAssSeg.substring(0,ifAssSeg.indexOf(","));									
					}else if(!Ext.isEmpty(ifAssSeg) && ifAssSeg != null && ifAssSeg != undefined){
						var segName = ifAssSeg;
					}
				}
				if(!Ext.isEmpty(selectedSegmentName) && selectedSegmentName != null && selectedSegmentName != undefined && selectedSegmentName != 'null' && selectedSegmentName != 'undefined')
				{
					segName = selectedSegmentName;
				}
				record = segName;
			}
			var serurl = '/final/monitor/EgServiceTopologyD3JS.jsp?physical_topology=0&type=monitor&treeFlag=null&zoneName=&currentTab=null&aggregateTab=null&openNode=null&treeFlag=null&fromHomepage='+isFromHomePage+'&dashboard_mapping='+selected_dash+'&user_name='+user_name+'&serviceGroup=&iszoneName='+iszoneName+'&isFromZone='+isFromZone+'&parentZone='+parentZone+'&action=service&serviceState=service20New_'+ifAssSegState+'&service='+serName+'&site='+serName+'&segment='+record+"&filter=service&filterBy="+encodeURIComponent(filterByParamFlag)+"&isfromCitrix=true&isFromServiceMenu="+isFromServiceMenu+"&isFromZoneMain="+isFromZoneMain+"&isFromZoneMenu="+isFromZoneMenu+"&isFromServiceGroup="+isFromServiceGroup+"&activeView=topology"; //isFromZone
			Ext.get('serTopologyMainCon').dom.src=serurl;
		}
		else if(!Ext.isEmpty(selected_view_name) && selected_view_name.trim() == "Segments_Topology_View"){
			if(!Ext.isEmpty(userMappingApplisTo) && userMappingApplisTo != null && userMappingApplisTo != undefined){
				if(userMappingApplisTo.indexOf(":") > 0){
					var segName = userMappingApplisTo.substring(userMappingApplisTo.indexOf(":")+1);									
				}
			}
			var segurl = '/final/monitor/EgSegmentTopologyD3JS.jsp?segment='+segName+'&physical_topology=1&fromHomepage='+isFromHomePage+'&type=segment&zoom=100&iszoneName='+iszoneName+'&isFromZone='+isFromZone+'&parentZone='+parentZone+'&segmentState=segment20New_HIGH';
			Ext.get('segTopologyMainCon').dom.src=segurl;
		}
		else if(!Ext.isEmpty(selected_view_name) && selected_view_name.trim() == "Web_Transaction_Sub_View" ){
			var timeLineCombo=this.getTransactionComboTimeline();
			if(!Ext.isEmpty(timeLineCombo))
				timeLineValueForRefresh = timeLineCombo.getValue();

			var fromHrCombo=this.getTransactionComboFromhr();
			if(!Ext.isEmpty(fromHrCombo))
				fromHrValueForRefresh = fromHrCombo.getValue();

			var toHrCombo=this.getTransactionComboTohr();
			if(!Ext.isEmpty(toHrCombo))
				toHrValueForRefresh = toHrCombo.getValue();

			var modeCombo=this.getTransactionComboMode();
			if(!Ext.isEmpty(modeCombo))
				modeValueForRefresh = modeCombo.getValue();
			
			var toMinCombo=this.getTransactionComboTomin();
			if(!Ext.isEmpty(toMinCombo))
				toMinValueForRefresh = toMinCombo.getValue();

			var fromMinCombo=this.getTransactionComboFrommin();
			if(!Ext.isEmpty(fromMinCombo))
				fromMinValueForRefresh = fromMinCombo.getValue();

			var fromDateCombo=this.getTransactionFromDate();
			if(!Ext.isEmpty(fromDateCombo))
			{
				//fromDateValueForRefresh = Ext.Date.format(fromDateCombo.getValue(),mgr_dateFormat);
				fromDateValueForRefresh =fromDateCombo.getValue();
			}

			var toDateCombo=this.getTransactionToDate();
			if(!Ext.isEmpty(toDateCombo))
			{
				//toDateValueForRefresh = Ext.Date.format(toDateCombo.getValue(),mgr_dateFormat);
				toDateValueForRefresh = toDateCombo.getValue();
			}

			var dashboard_view_container_gridObj = Ext.getCmp('dashboard_view_container_grid');	
			var dashboard_view_container_chartObj = Ext.getCmp('dashboard_view_container_chart');	
			var dashboard_view_header_idObj = Ext.getCmp('dashboard_view_header_id');
			if(!Ext.isEmpty(dashboard_view_container_gridObj))
				dashboard_view_container_gridObj.removeAll(true);
			if(!Ext.isEmpty(dashboard_view_container_chartObj))
				dashboard_view_container_chartObj.removeAll(true);
			if(!Ext.isEmpty(dashboard_view_header_idObj))
				dashboard_view_header_idObj.removeAll(true);
			if(!Ext.isEmpty(Ext.getCmp('tabBarHeader1')))
				Ext.getCmp('tabBarHeader1').removeAll(true);
			var selected_dash = '';
			if(!Ext.isEmpty(Ext.getCmp('dashListComId')) && Ext.getCmp('dashListComId')!=null && Ext.getCmp('dashListComId')!=undefined)
				selected_dash = Ext.getCmp('dashListComId').getValue();
			var d_url = '/final/monitor/transactions.jsp?treeTitle=services&1=1&selectNode=Service$cap$'+encodeURIComponent(filterByParamFlag)+'&selectedParam='+encodeURIComponent(filterByParamFlag)+'&currentTab=transactions&isSite=true&aggregateTab=false&hasTransactions=true&hasEmulatedTransactions=false&fromHomepage=&hasLogonSimulations=true&site='+encodeURIComponent(filterByParamFlag)+'&isSite=true&serviceName='+encodeURIComponent(filterByParamFlag)+'&fromLayer=false&selectNode='+encodeURIComponent(filterByParamFlag)+'&currentTab=transactions&transTab=true&from=null&treeOpen=false&openNode=Services&refresh=true&action=service&topoSegment='+encodeURIComponent(filterByParamFlag)+'&isfromCitrix=true&iniName='+iniName+'&user_name='+user_name+'&dashboard_mapping='+selected_dash+'&dashboard_name='+dashboard+'&view_name='+selected_view_name+"&fromServiceHomePage="+isFromHomePage+"&fromSerComboChange="+fromSerComboChange+"&isFromZone="+isFromZone+"&iszoneName="+iszoneName+"&parentZone="+parentZone+"&fromLogonTab=true";
			Ext.Ajax.request({
				url : d_url,
				timeout:280000,
				//scope:this,
				success: function(response){
					var jsonText = response.responseText;
					if(!Ext.isEmpty(jsonText))
					{
						var jsonData = Ext.decode(jsonText);
						//after refresh the tab value needs to be retained for layout of graphs
						 // if(!Ext.isEmpty(requestParams.selectedTab)){
						  /*if(!Ext.isEmpty(jsonData.HiddenFields.selectedTab)){
							  if(jsonData.HiddenFields.selectedTab=="EmulatedClients"){
								  this.tab="emulated";
							  }else{
								  this.tab="web";
							  }
						  }*/
						//this.loadTransaction(jsonData);
						//this.getTransactionsMainPanel().showTransactionGridPanel(jsonData.GridScreenLabels,jsonData);
						var screenLabels = jsonData.GridScreenLabels;
						var compType = jsonData.HiddenFields.compType;
						var compName = jsonData.HiddenFields.compName;
						var siteName = jsonData.HiddenFields.siteName;
						if(siteName!=null && siteName!=undefined)
							citrixDashboard.app.getController('Main').siteName=siteName;
						var isEmuEnabled = ( !Ext.isEmpty(screenLabels["emulBtnLabel"]) )?true:false;
						var isTransEnabled = ( !Ext.isEmpty(screenLabels["webBtnLabel"]) )?true:false;
						var isTabChanged = ( !Ext.isEmpty(jsonData['isTabChanged']) )?true:false;
						var isFromRefresh = ( !Ext.isEmpty(jsonData['fromRefresh']) )?true:false;
						var isLogonEnabled = jsonData.HiddenFields.isLogonSimul;
						var refreshing = jsonData.HiddenFields.Refreshing;
						var innerActiveTab = jsonData.HiddenFields.innerActiveTab;
						var graphParam = jsonData.HiddenFields.timelineParam;

						if(!Ext.isEmpty(jsonData.HiddenFields))
						{
							serviceRefSortByLogon = jsonData.HiddenFields.serviceRefSortByLogon;
							serviceRefSortByLogonType = jsonData.HiddenFields.serviceRefSortByLogonType;
							serviceRefSortByLogonId = jsonData.HiddenFields.serviceRefSortByLogonId;
						}

						/*var ComponentList = jsonData.ComponentList;
						var externalAgentsList = jsonData.externalAgents;
						var logonComponentList = jsonData.logonComponentList;
						var label='',selectedVal='',simLabel='',simulationSelectedVal='',simulationSelectedOrgValue = '';
						var defalutHide = false;
						var comboStore,simulationComboStore;

						if(!Ext.isEmpty(logonComponentList) && logonComponentList!=null && logonComponentList!=undefined)
						{
							simulationComboStore = Ext.create('Ext.data.Store',{
								fields:['value', 'name', 'comptype'],
								proxy:{
									type: 'memory',
									reader: {
										type: 'json',
										root:'options'
									}
								},
								data:logonComponentList
							});
							simLabel = logonComponentList.label;
							simulationSelectedVal = logonComponentList.selectedValue;
							simulationSelectedOrgValue = logonComponentList.selectedOrgValue;
						}
						if(!Ext.isEmpty(ComponentList) && ComponentList!=null && ComponentList!=undefined && (innerActiveTab == null || innerActiveTab == undefined || innerActiveTab == 'undefined')){
							comboStore = Ext.create('Ext.data.Store',{
								fields:['value', 'name', 'comptype'],
								proxy:{
									type: 'memory',
									reader: {
										type: 'json',
										root:'options'
									}
								},
								data:ComponentList
							});
							defalutHide = false;
							label = ComponentList.label;
							selectedVal = ComponentList.selectedValue;
						}
						else if(!Ext.isEmpty(externalAgentsList) && externalAgentsList!=null && externalAgentsList!=undefined && (innerActiveTab == 'logonSim' || (!isEmuEnabled && !isTransEnabled))){
							extAgentData = externalAgentsList;
							externalAgentsList = externalAgentsList[simulationSelectedVal];
							comboStore = Ext.create('Ext.data.Store',{
								fields:['value', 'name'],
								proxy:{
									type: 'memory',
									reader: {
										type: 'json',
										root:'options'
									}
								},
								data:externalAgentsList
							});
							defalutHide = false;
							label = extAgentData.label;
							selectedVal = externalAgentsList.selectedValue;
						}
						else
							defalutHide = true;*/
						var ComponentList = jsonData.ComponentList;
						var externalAgentsList = jsonData.externalAgents;
						var logonComponentList = jsonData.logonComponentList;
						var componentListObj = jsonData.componentListObj;

						var label='',selectedVal='',simLabel='',compLabel='',simulationSelectedVal='',compSelectedVal='',simulationSelectedOrgValue = '';
						var defalutHide = false;
						var isComponentType = true;
						var comboStore,simulationComboStore,compStroe;

						/*if(!Ext.isEmpty(componentListObj) && componentListObj!=null && componentListObj!=undefined && (innerActiveTab == 'logonSim' || (!isEmuEnabled && !isTransEnabled)))
						{
							isComponentType = false;
							compStroe = Ext.create('Ext.data.Store',{
								fields:['value', 'name', 'url'],
								proxy:{
									type: 'memory',
									reader: {
										type: 'json',
										root:'options'
									}
								},
								data:componentListObj
							});
							compLabel = componentListObj.label;
							compSelectedVal = componentListObj.selectedValue;
							selectedCompType =componentListObj.selectedValue;
						}
						*/
						
						if(!Ext.isEmpty(ComponentList) && ComponentList!=null && ComponentList!=undefined && (innerActiveTab == null || innerActiveTab == undefined || innerActiveTab == 'undefined')){
							comboStore = Ext.create('Ext.data.Store',{
								fields:['value', 'name', 'comptype'],
								proxy:{
									type: 'memory',
									reader: {
										type: 'json',
										root:'options'
									}
								},
								data:ComponentList
							});
							defalutHide = false;
							label = ComponentList.label;

						if(selectedCompTypeValue == null || selectedCompTypeValue == 'null' || selectedCompTypeValue == '' || selectedCompTypeValue == undefined || selectedCompTypeValue == 'undefined')
							selectedVal = ComponentList.selectedValue;
						else
							selectedVal = selectedCompTypeValue;
							
						}
						else if(!Ext.isEmpty(externalAgentsList) && externalAgentsList!=null && externalAgentsList!=undefined && (innerActiveTab == 'logonSim' || (!isEmuEnabled && !isTransEnabled))){
							extAgentData = externalAgentsList;
							//externalAgentsList = externalAgentsList[simulationSelectedVal];
							comboStore = Ext.create('Ext.data.Store',{
								fields:['value', 'name'],
								proxy:{
									type: 'memory',
									reader: {
										type: 'json',
										root:'options'
									}
								},
								data:externalAgentsList
							});
							defalutHide = false;
							label = extAgentData.label;
							selectedVal = externalAgentsList.selectedValue;
						}
						else
							defalutHide = true;
						/*
						if(!Ext.isEmpty(logonComponentList) && logonComponentList!=null && logonComponentList!=undefined)
						{
							logonComponentList = logonComponentList[selectedVal];
							simulationComboStore = Ext.create('Ext.data.Store',{
								fields:['value', 'name', 'comptype'],
								proxy:{
									type: 'memory',
									reader: {
										type: 'json',
										root:'options'
									}
								},
								data:logonComponentList
							});
							simLabel = logonComponentList.label;
							simulationSelectedVal = logonComponentList.selectedValue;
							simulationSelectedOrgValue = logonComponentList.selectedOrgValue;
						}*/
						
						var serviceState = "GOOD";
						serviceState=jsonData.GridScreenLabels.siteState;
						var simulationComboHide = true;
						if(!Ext.isEmpty(innerActiveTab) && innerActiveTab != null && innerActiveTab != undefined && innerActiveTab == 'logonSim')
							simulationComboHide = false;
						curViewTab = innerActiveTab;
						//dashboard_view_header_idObj.setTitle("USER EXPERIENCE - WEB TRANSACTIONS");
						dashboard_view_header_idObj.setTitle("USER EXPERIENCE - WEB TRANSACTIONS <img style='position: relative;left: 6px;top: 3px;' src='/final/images/clear.png' data-qtip='Layer Model' class='iconLayerstack mouse' onclick=\"DashboardToLayers('"+compName+"','"+compType+"','"+siteName+"','WebTransactions','"+selected_view_name+"','"+iniName+"','"+user_name+"','"+selected_dash+"')\" /> <img style='position: relative;left: 12px;top: 3px;' src='/final/images/clear.png' class='iconTopology mouse' data-qtip='Topology' onclick=\"loadView('Services_Topology_View')\"/>");
						dashboard_view_header_idObj.addTool(
						{
							xtype:'container',
							id:'tabBarHeader1',
							layout:{type:'hbox',align:'right'},
							margin:'10 0 0 0',
							style:{'float':'right'},
							items:[
							/*{
								xtype:'label',
								cls:"service20_"+serviceState,
								border:0,
								margin:'0 0 0 0'
							},{
								xtype:'label',
								margin:'2 0 0 0',
								html:'&nbsp;<span class="font_bold13 fontStyleRobot" >SITE :</span> <span style="margin-right:6px;" class="font_normal13 fontStyleRobot">'+screenLabels["Title"]+'</span>'		
							},
							{xtype:'tbseparator',height:21,style:{'width':'1px !important','background-position':'right top !important'}},
							{
								xtype:'button',
								tooltip:'Layer Model',
								style:{'border':'none'},
								margin:'3 0 0 0',
								cls:'iconLayerstack',
								handler: function() {
									DashboardToLayers(compName,compType,siteName,'WebTransactions',selected_view_name,iniName,user_name,selected_dash);
								}
							},
							{xtype:'tbseparator',height:21,style:{'width':'1px !important','background-position':'right top !important'}},
							{
								xtype:'button',
								tooltip:'Topology',
								style:{'border':'none','top':'3px !important'},
								cls:'iconTopology',
								margin:'3 0 0 0',
								handler: function() {
									//DashboardToTopology();
									loadView('Services_Topology_View');
								}
							},
							{
								xtype:'combo',
								id:'simulationCombo',
								itemId:'simulationCombo',
								editable : false,
								margin:'0 0 0 10',
								width:290,
								hidden:simulationComboHide,
								store:simulationComboStore,
								cls : 'dropdown',
								displayField:'name',
								valueField:'value',
								trigerAction:'all',
								fieldLabel:''+simLabel,
								labelWidth:80,
								value:simulationSelectedVal,
								queryMode : 'local'
							},*/
							{
								xtype:'combo',
								id:'componentCombo',
								itemId:'componentCombo',
								editable : false,
								labelWidth:75,
								margin:'0 0 0 10',
								hidden:defalutHide,
								store:comboStore,
								cls : 'dropdown',
								width:290,
								displayField:'name',
								valueField:'value',
								trigerAction:'all',
								fieldLabel:''+label,
								value:selectedVal,
								queryMode : 'local',
								listeners:{
									'change':function(e){
										citrixDashboard.app.getController('Main').onComponentChange(this,'webTrans',siteName);
									}
								}
							}
							]
						}
						);
						dashboard_view_container_gridObj.add([{
							xtype:'container',
							ui:'eg-container',
							margin:'0 0 0 0',
							padding:'0 10 10 10',
							items:[{
								xtype:'transactiongridpanel',
								ui:'newGridPanel',
								id:'transactiongridpanelid',
								//title:'<span class="font_bold12">Transactions</span>',
								//columnWidth:1.0,
								jsonData:jsonData,
								isEmuEnabled:isEmuEnabled,
								//bodyPadding:10,
								id:'transGrid1',
								height:185,
								//flex:0.43,
								border:true
							}]
						}]);
						try
						{
							dashboard_view_container_chartObj.add([{
								xtype:'container',
								//ui:'eg-container',
								margin:'10 2 0 0',
								//padding:10,
								//height:220,
								items:[{
									xtype:'transactionschartpanel',
									id:'transactionschartpanelid',
									//height:500,
									//minHeight:250,
									//title:'Graphs',
									//columnWidth:1.0,
									jsonData:jsonData,
									padding:0,
									//flex:0.57,
									border:false,
									layout:{type:'fit'},
									//style:{'overflow':'auto'}
								}]
							}]);
						}
						catch(e1)
						{
						}
					}
				},
				failure:function(){
					//window.parent.location.href="/final/servlet/com.egurkha.Logout";
				}
			});
		}
		else if(!Ext.isEmpty(selected_view_name) && selected_view_name.trim() == "Logon_Sub_View" ){
		
			var timeLineCombo=this.getTransactionComboTimeline();
			if(!Ext.isEmpty(timeLineCombo))
				timeLineValueForRefresh = timeLineCombo.getValue();

			var fromHrCombo=this.getTransactionComboFromhr();
			if(!Ext.isEmpty(fromHrCombo))
				fromHrValueForRefresh = fromHrCombo.getValue();

			var toHrCombo=this.getTransactionComboTohr();
			if(!Ext.isEmpty(toHrCombo))
				toHrValueForRefresh = toHrCombo.getValue();

			var modeCombo=this.getTransactionComboMode();
			if(!Ext.isEmpty(modeCombo))
				modeValueForRefresh = modeCombo.getValue();
			
			var toMinCombo=this.getTransactionComboTomin();
			if(!Ext.isEmpty(toMinCombo))
				toMinValueForRefresh = toMinCombo.getValue();

			var fromMinCombo=this.getTransactionComboFrommin();
			if(!Ext.isEmpty(fromMinCombo))
				fromMinValueForRefresh = fromMinCombo.getValue();

			var fromDateCombo=this.getTransactionFromDate();
			if(!Ext.isEmpty(fromDateCombo))
			{
				//fromDateValueForRefresh = Ext.Date.format(fromDateCombo.getValue(),mgr_dateFormat);
				fromDateValueForRefresh =fromDateCombo.getValue();
			}

			var toDateCombo=this.getTransactionToDate();
			if(!Ext.isEmpty(toDateCombo))
			{
				//toDateValueForRefresh = Ext.Date.format(toDateCombo.getValue(),mgr_dateFormat);
				toDateValueForRefresh = toDateCombo.getValue();
			}

			var compObj = Ext.getCmp('compTypeCombo');
			var compValue = '';
			if(compObj!=null && compObj != undefined && compObj != 'null' && compObj == 'undefined')
			{
				 compValue = compObj.getValue();
				 singleComponentTypeValue = '';
				 singleComponentTypeName = '';
			}			
			else if((compObj==null || compObj == undefined) && (singleComponentTypeValue != '' && singleComponentTypeValue != null && singleComponentTypeValue != undefined))
			{
				compValue = singleComponentTypeValue
			}

			var extMonitorObj = Ext.getCmp('componentCombo');
			var extMonitorValue = extMonitorObj.getValue();

			var simulationObj = Ext.getCmp('simulationCombo');
			refreshSimulation = simulationObj.getValue();

			var dashboard_grid_containerObj = Ext.getCmp('dashboard_container_grid');	
			var dashboard_chart_containerObj = Ext.getCmp('dashboard_container_chart');	
			var dashboard_header_idObj = Ext.getCmp('dashboard_header_id');
			if(!Ext.isEmpty(dashboard_grid_containerObj))
				dashboard_grid_containerObj.removeAll(true);
			if(!Ext.isEmpty(dashboard_chart_containerObj))
				dashboard_chart_containerObj.removeAll(true);
			if(!Ext.isEmpty(dashboard_header_idObj))
				dashboard_header_idObj.removeAll(true);
			if(!Ext.isEmpty(Ext.getCmp('tabBarHeader1')))
				Ext.getCmp('tabBarHeader1').removeAll(true);
			var selected_dash = '';
			if(!Ext.isEmpty(Ext.getCmp('dashListComId')) && Ext.getCmp('dashListComId')!=null && Ext.getCmp('dashListComId')!=undefined)
				selected_dash = Ext.getCmp('dashListComId').getValue();
			var d_url = '/final/monitor/transactions.jsp?componentType='+compValue+'&treeTitle=services&selectNode=Service$cap$'+encodeURIComponent(filterByParamFlag)+'&selectedParam='+encodeURIComponent(filterByParamFlag)+'&currentTab=logon&isSite=false&aggregateTab=false&hasTransactions=false&hasEmulatedTransactions=false&fromHomepage=&hasLogonSimulations=true&site='+encodeURIComponent(filterByParamFlag)+'&isSite=true&serviceName='+encodeURIComponent(filterByParamFlag)+'&fromLayer=false&selectNode='+encodeURIComponent(filterByParamFlag)+'&currentTab=logon&transTab=true&from=null&treeOpen=false&openNode=Services&refresh=true&action=service&topoSegment='+encodeURIComponent(filterByParamFlag)+'&isfromCitrix=true&iniName='+iniName+'&user_name='+user_name+'&dashboard_mapping='+selected_dash+'&dashboard_name='+dashboard+'&view_name='+selected_view_name+"&fromServiceHomePage="+isFromHomePage+"&fromSerComboChange="+fromSerComboChange+"&isFromZone="+isFromZone+"&iszoneName="+iszoneName+"&parentZone="+parentZone+"&fromLogonTab=true";
			Ext.Ajax.request({
				url : d_url,
				timeout:280000,
				success: function(response){
					var jsonText = response.responseText;
					if(!Ext.isEmpty(jsonText))
					{
						var jsonData = Ext.decode(jsonText);
						//after refresh the tab value needs to be retained for layout of graphs
						// if(!Ext.isEmpty(requestParams.selectedTab)){
						/*if(!Ext.isEmpty(jsonData.HiddenFields.selectedTab)){
						if(jsonData.HiddenFields.selectedTab=="EmulatedClients"){								 
						this.tab="emulated";
						}else{
						this.tab="web";
						}
						}*/
						//this.loadTransaction(jsonData);
						//this.getTransactionsMainPanel().showTransactionGridPanel(jsonData.GridScreenLabels,jsonData);
						var temLogonParam = jsonData.logonParam;
						var screenLabels = jsonData.GridScreenLabels;
						var compType = jsonData.HiddenFields.compType;
						var compName = jsonData.HiddenFields.compName;
						var siteName = jsonData.HiddenFields.siteName;
						if(siteName!=null && siteName!=undefined)
							citrixDashboard.app.getController('Main').siteName=siteName;
						var isEmuEnabled = ( !Ext.isEmpty(screenLabels["emulBtnLabel"]) )?true:false;
						var isTransEnabled = ( !Ext.isEmpty(screenLabels["webBtnLabel"]) )?true:false;
						var isTabChanged = ( !Ext.isEmpty(jsonData['isTabChanged']) )?true:false;
						var isFromRefresh = ( !Ext.isEmpty(jsonData['fromRefresh']) )?true:false;
						var isLogonEnabled = jsonData.HiddenFields.isLogonSimul;
						var refreshing = jsonData.HiddenFields.Refreshing;
						var innerActiveTab = jsonData.HiddenFields.innerActiveTab;
						//var graphParam = jsonData.HiddenFields.timelineParam;
						var graphParam = jsonData.HiddenFields.timelineParam;
						var timelineUrl = '';
						if(!Ext.isEmpty(graphParam) && graphParam != null && graphParam != undefined)
						{
							timelineUrl = '&mode='+graphParam.mode+'&time_line='+graphParam.time_line+'&starthr='+graphParam.starthr+'&endhr='+graphParam.endhr+'&starttime='+graphParam.starttime+'&endtime='+graphParam.endtime+'&startmin='+graphParam.startmin+'&endmin='+graphParam.endmin;
						}
						innerActiveTab = "logonSim";
						if(!Ext.isEmpty(jsonData.HiddenFields))
						{
							serviceRefSortByLogon = jsonData.HiddenFields.serviceRefSortByLogon;
							serviceRefSortByLogonType = jsonData.HiddenFields.serviceRefSortByLogonType;
							serviceRefSortByLogonId = jsonData.HiddenFields.serviceRefSortByLogonId;
						}

						/*var ComponentList = jsonData.ComponentList;
						var externalAgentsList = jsonData.externalAgents;
						var logonComponentList = jsonData.logonComponentList;
						var label='',selectedVal='',simLabel='',simulationSelectedVal='',simulationSelectedOrgValue = '';
						var defalutHide = false;
						var comboStore,simulationComboStore;
						if(!Ext.isEmpty(logonComponentList) && logonComponentList!=null && logonComponentList!=undefined)
						{
							simulationComboStore = Ext.create('Ext.data.Store',{
							fields:['value', 'name', 'comptype'],
							proxy:{
							type: 'memory',
							reader: {
							type: 'json',
							root:'options'
							}
							},
							data:logonComponentList
							});
							simLabel = logonComponentList.label;
							simulationSelectedVal = logonComponentList.selectedValue;
							simulationSelectedOrgValue = logonComponentList.selectedOrgValue;
						}
						if(!Ext.isEmpty(ComponentList) && ComponentList!=null && ComponentList!=undefined && (innerActiveTab == null || innerActiveTab == undefined || innerActiveTab == 'undefined')){
							comboStore = Ext.create('Ext.data.Store',{
							fields:['value', 'name', 'comptype'],
							proxy:{
							type: 'memory',
							reader: {
							type: 'json',
							root:'options'
							}
							},
							data:ComponentList
							});
							defalutHide = false;
							label = ComponentList.label;
							selectedVal = ComponentList.selectedValue;
						}
						else if(!Ext.isEmpty(externalAgentsList) && externalAgentsList!=null && externalAgentsList!=undefined && (innerActiveTab == 'logonSim' || (!isEmuEnabled && !isTransEnabled))){
							extAgentData = externalAgentsList;
							externalAgentsList = externalAgentsList[simulationSelectedVal];
							comboStore = Ext.create('Ext.data.Store',{
							fields:['value', 'name'],
							proxy:{
							type: 'memory',
							reader: {
							type: 'json',
							root:'options'
							}
							},
							data:externalAgentsList
							});
							defalutHide = false;
							label = extAgentData.label;
							selectedVal = externalAgentsList.selectedValue;
						}
						else
						defalutHide = true;*/
						
						var ComponentList = jsonData.ComponentList;
						var externalAgentsList = jsonData.externalAgents;
						var logonComponentList = jsonData.logonComponentList;
						var componentListObj = jsonData.componentListObj;

						var isSingleCompType = false;
						if(jsonData.componentListObj != null && jsonData.componentListObj['options'].length==1)
							isSingleCompType = true;
						var label='',selectedVal='',simLabel='',compLabel='',simulationSelectedVal='',compSelectedVal='',simulationSelectedOrgValue = '';
						var defalutHide = false;
						var isComponentType = true;
						var comboStore,simulationComboStore,compStroe;

						if(!Ext.isEmpty(componentListObj) && componentListObj!=null && componentListObj!=undefined && (innerActiveTab == 'logonSim' || (!isEmuEnabled && !isTransEnabled)))
						{
							isComponentType = false;
							compStroe = Ext.create('Ext.data.Store',{
								fields:['value', 'name', 'url'],
								proxy:{
									type: 'memory',
									reader: {
										type: 'json',
										root:'options'
									}
								},
								data:componentListObj
							});
							compLabel = componentListObj.label;
							compSelectedVal = componentListObj.selectedValue;
							selectedCompType =componentListObj.selectedValue;
						}

						
						if(!Ext.isEmpty(ComponentList) && ComponentList!=null && ComponentList!=undefined && (innerActiveTab == null || innerActiveTab == undefined || innerActiveTab == 'undefined')){
							comboStore = Ext.create('Ext.data.Store',{
								fields:['value', 'name', 'comptype'],
								proxy:{
									type: 'memory',
									reader: {
										type: 'json',
										root:'options'
									}
								},
								data:ComponentList
							});
							defalutHide = false;
							label = ComponentList.label;
							selectedVal = ComponentList.selectedValue;
						}
						else if(!Ext.isEmpty(externalAgentsList) && externalAgentsList!=null && externalAgentsList!=undefined && (innerActiveTab == 'logonSim' || (!isEmuEnabled && !isTransEnabled))){
							extAgentData = externalAgentsList;
							//externalAgentsList = externalAgentsList[simulationSelectedVal];
							comboStore = Ext.create('Ext.data.Store',{
								fields:['value', 'name'],
								proxy:{
									type: 'memory',
									reader: {
										type: 'json',
										root:'options'
									}
								},
								data:externalAgentsList
							});
							defalutHide = false;
							label = extAgentData.label;
							if(!Ext.isEmpty(extMonitorValue) && extMonitorValue != null)
							{
								selectedVal = extMonitorValue;
							}
							else
							{
								selectedVal = externalAgentsList.selectedValue;
							}
						}
						else
							defalutHide = true;
						
						if(!Ext.isEmpty(logonComponentList) && logonComponentList!=null && logonComponentList!=undefined)
						{
							logonComponentList = logonComponentList[selectedVal];
							simulationComboStore = Ext.create('Ext.data.Store',{
								fields:['value', 'name', 'comptype'],
								proxy:{
									type: 'memory',
									reader: {
										type: 'json',
										root:'options'
									}
								},
								data:logonComponentList
							});
							simLabel = logonComponentList.label;
							if(!Ext.isEmpty(refreshSimulation) && refreshSimulation != null)
							{
								if(refreshSimulation.indexOf(":")>-1)
								{
									var componentVal = refreshSimulation;
									componentVal = componentVal.substring(0,componentVal.indexOf(":"));
									simulationSelectedVal = componentVal;
								}
								simulationSelectedOrgValue = refreshSimulation;
							}
							else
							{
								simulationSelectedVal = logonComponentList.selectedValue;
								simulationSelectedOrgValue = logonComponentList.selectedOrgValue;
							}
						}
						if(isSingleCompType)
						{
							isComponentType = true;
						}

						var serviceState = "GOOD";
						serviceState=jsonData.GridScreenLabels.siteState;
						var simulationComboHide = true;
						if(!Ext.isEmpty(innerActiveTab) && innerActiveTab != null && innerActiveTab != undefined && innerActiveTab == 'logonSim')
						simulationComboHide = false;
						curViewTab = innerActiveTab;
						if(singleComponentTypeName != '' && singleComponentTypeName != null && singleComponentTypeName !=undefined)
						{
							singleComponentTypeName = singleComponentTypeName.toUpperCase();
							dashboard_header_idObj.setTitle("USER EXPERIENCE - "+singleComponentTypeName+" <img style='position: relative;left: 6px;top: 3px;' src='/final/images/clear.png' class='iconLayerstack mouse' data-qtip='Layer Model' onclick=\"DashboardToLayers('"+compName+"','"+compType+"','"+siteName+"','logonSim','"+selected_view_name+"','"+iniName+"','"+user_name+"','"+selected_dash+"')\" /> <img style='position: relative;left: 12px;top: 3px;' src='/final/images/clear.png' class='iconTopology mouse' data-qtip='Topology' onclick=\"loadView('Services_Topology_View')\"/>");
						}
						else
						{
							dashboard_header_idObj.setTitle("USER EXPERIENCE - LOGON SIMULATIONS <img style='position: relative;left: 6px;top: 3px;' src='/final/images/clear.png' class='iconLayerstack mouse' data-qtip='Layer Model' onclick=\"DashboardToLayers('"+compName+"','"+compType+"','"+siteName+"','logonSim','"+selected_view_name+"','"+iniName+"','"+user_name+"','"+selected_dash+"')\" /> <img style='position: relative;left: 12px;top: 3px;' src='/final/images/clear.png' class='iconTopology mouse' data-qtip='Topology' onclick=\"loadView('Services_Topology_View')\"/>");
						}
						dashboard_grid_containerObj.removeAll(true);
						dashboard_header_idObj.addTool(
							{
								xtype:'container',
								id:'tabBarHeader1',
								layout:{type:'hbox',align:'right'},
								margin:'10 0 0 0',
								style:{'float':'right','border':'none !important'},
								items:[
								/*{
									xtype:'label',
									cls:"service20_"+serviceState,
									border:0,
									margin:'1 0 0 0'
								},{
									xtype:'label',
									margin:'2 0 0 0',
									html:'&nbsp;<span style="margin-right:6px;" class="font_normal13 fontStyleRobot">'+screenLabels["Title"]+'</span>'		
								},
								{xtype:'tbseparator',height:20,style:{'width':'1px !important','background-position':'right top !important'}},
								{
									xtype:'button',
									tooltip:'Layer Model',
									style:{'border':'none'},
									cls:'iconLayerstack',
									margin:'3 0 0 0',
									handler: function() {
										DashboardToLayers(compName,compType,siteName,'logonSim',selected_view_name,iniName,user_name,selected_dash);
									}
								},
								{xtype:'tbseparator',height:20,style:{'width':'1px !important','background-position':'right top !important'}},
								{
									xtype:'button',
									tooltip:'Topology',
									style:{'border':'none'},
									cls:'iconTopology',
									margin:'3 0 0 0',
									handler: function() {
										//DashboardToTopology();
										loadView('Services_Topology_View');
									}
								},*/
								{
									xtype:'combo',
									id:'compTypeCombo',
									itemId:'compTypeCombo',
									labelAlign : 'left',
									editable : false,
									store:compStroe,
									hidden:isComponentType,
									labelSeparator:'',
									cls : 'dropdown',
									displayField: 'name',
									valueField: 'value',
										url:'url',
									trigerAction:'all',
									fieldLabel:compLabel+':',
									labelWidth:100,
									width:290,
									queryMode: 'local',
									margin:'0 0 0 20',
									value:compSelectedVal,
									listeners:{
										'change':function(e){
											citrixDashboard.app.getController('Main').onComponentTypeChange(this,'logonSim',siteName,compSelectedVal,selected_view_name);
										}
									}
								},
								{
									xtype:'combo',
									id:'componentCombo',
									itemId:'componentCombo',
									editable : false,
									margin:'0 0 0 20',
									hidden:defalutHide,
									store:comboStore,
									cls : 'dropdown',
									width:290,
									displayField:'name',
									valueField:'value',
									trigerAction:'all',
									fieldLabel:''+label,
									labelWidth:100,
									value:selectedVal,
									queryMode : 'local',
									listeners:{
										'change':function(e){
											citrixDashboard.app.getController('Main').onComponentChange(this,'logonSim',siteName,simulationSelectedOrgValue,selected_view_name);
										}	
									}
								},
								{
									xtype:'combo',
									id:'simulationCombo',
									itemId:'simulationCombo',
									editable : false,
									margin:'0 0 0 20',
									width:270,
									hidden:simulationComboHide,
									store:simulationComboStore,
									cls : 'dropdown',
									displayField:'name',
									valueField:'value',
									trigerAction:'all',
									fieldLabel:''+simLabel,
									labelWidth:70,
									value:simulationSelectedOrgValue,
									queryMode : 'local',
									listeners:{
										'change':function(e){
											citrixDashboard.app.getController('Main').onSimulationChange(this,'logonSim',siteName,simulationSelectedOrgValue,selected_view_name);
										}	
									}
								}
								]
							}
						);
						var selected_dash = '';
						if(!Ext.isEmpty(Ext.getCmp('dashListComId')) && Ext.getCmp('dashListComId')!=null && Ext.getCmp('dashListComId')!=undefined)
							selected_dash = Ext.getCmp('dashListComId').getValue();
						
						//if(siteName != null)
							//fromServiceDashboard = true;
						var simulationSelectedOrgValue1 = "";
						if(simulationSelectedOrgValue != null && simulationSelectedOrgValue.indexOf(":NULL") > -1)
							simulationSelectedOrgValue1 = simulationSelectedOrgValue.substring(0,simulationSelectedOrgValue.indexOf(":NULL"));
						else
							simulationSelectedOrgValue1 = simulationSelectedOrgValue;
						var perf_url = "/final/monitor/comparisonLogonSimulator.jsp?"+logonParam+"&componentType=&selectedState=&subFilter=&simulationName="+simulationSelectedOrgValue1+"&externalAgent="+selectedVal+"&isfromCitrix=true&iniName="+iniName+"&user_name="+user_name+"&dashboard_mapping="+selected_dash+"&dashboard_name="+dashboard+"&view_name="+selected_view_name+"&fromServiceDashboard="+fromServiceDashboard+"&servicename="+siteName+"&fromSerComboChange="+fromSerComboChange+"&fromServiceHomePage="+isFromHomePage+"&isFromZone="+isFromZone+"&iszoneName="+iszoneName+"&parentZone="+parentZone+"&isLogonType=true&filter=service&filterBy="+encodeURIComponent(filterByParamFlag)+"&isFromServiceMenu="+isFromServiceMenu+"&isFromZoneMain="+isFromZoneMain+"&isFromZoneMenu="+isFromZoneMenu+"&isFromServiceGroup="+isFromServiceGroup;

						if(temLogonParam != null && temLogonParam != '' && temLogonParam != undefined)
							perf_url ="/final/monitor/comparisonLogonSimulator.jsp?"+temLogonParam+"&componentType=&selectedState=&subFilter=&simulationName="+simulationSelectedOrgValue1+"&externalAgent="+selectedVal+"&isfromCitrix=true&iniName="+iniName+"&user_name="+user_name+"&dashboard_mapping="+selected_dash+"&dashboard_name="+dashboard+"&view_name="+selected_view_name+"&fromServiceDashboard="+fromServiceDashboard+"&servicename="+siteName+"&fromSerComboChange="+fromSerComboChange+"&isFromZone="+isFromZone+"&iszoneName="+iszoneName+"&parentZone="+parentZone+"&componentNameService="+simulationSelectedOrgValue+"&isLogonType=true&filter=service&filterBy="+encodeURIComponent(filterByParamFlag)+"&isFromServiceMenu="+isFromServiceMenu+"&isFromZoneMain="+isFromZoneMain+"&isFromZoneMenu="+isFromZoneMenu+"&isFromServiceGroup="+isFromServiceGroup;

						var transurl = "/final/monitor/simulationGraph.jsp?treeTitle=services&site=NULL&mHost="+selectedVal+"&simulationName="+simulationSelectedOrgValue1+"&componentNameService="+simulationSelectedOrgValue;
						
						Ext.Ajax.request({
							url : transurl,
							scope:this,
							success: function(response){
								var jsonText = response.responseText;
								//var panelArr = new Array();
								if(!Ext.isEmpty(jsonText))
								{
									var jsondata1 = Ext.decode(jsonText);
									if(jsondata1 != null && jsondata1 != undefined)
									{
										var css_class='gridHeadercenter iconGrid';
										if(!Ext.isEmpty(logon_treeTitle) && logon_treeTitle=='ExtTestDashboard')
											css_class='gridHeadercenter';
										dashboard_grid_containerObj.add({
											xtype:'generalMeasuresGridPanel',
											plugins:Ext.create('Ext.ux.AutoColumnWithLockingPlugin'),
											//title:titlesys,
											//title:perf_disp_name+" --Man At Work--",
											cls:css_class,
											//itemId:itemIdforsysandcom,
											itemId:'logonSimualtion',
											searchBoxCombo:false,
											margin:0,
											padding:3,
											id:'perPanel',
											height:185,
											frame:false,
											border:true,
											layout:{type:'vbox',align:'stretch'},
											flex:1,
											screenLabelPath:"monitor.Dashboard",
											url:perf_url,
											listeners: {
												'afterrender': function (obj) {
													this.loadTab(obj.url,null,null,null,null,true,"citrixDashBoard");
												}
											}
										});
										//panelArr.push({
										dashboard_chart_containerObj.add({
											xtype:'transactionschartpanel',
											id:'transactionschartpanelid',
											//animCollapse:true,
											//columnWidth:1.0,
											//height:255,
											//height:(Ext.getBody().getViewSize().height - 225),
											height:(Ext.getBody().getViewSize().height-280),
											//flex:1,
											jsonData:jsondata1,
											//minHeight:265,
											margin:'10 1 0 0',
											//margin:'5 0 0 0',
											padding:0,
											//flex:0.57,
											border:false,
											isNotAreaChart:false
										});
									
										//curViewPort.add(panelArr);
										//curViewPort.doLayout();
									}
								}
							  },
							failure:function(){
								//window.parent.location.href="/final/servlet/com.egurkha.Logout";
							}
						});
					}
				},
				failure:function(){
					//window.parent.location.href="/final/servlet/com.egurkha.Logout";
				}
			});
		}
		else if(!Ext.isEmpty(selected_view_name) && selected_view_name.trim() == "Emulated_Transaction_Sub_View" ){
			
			try
			{
				var isSessionWindowOpen = document.getElementById('isSessionWindowOpen').value;	
				if(isSessionWindowOpen == 'true' || isSessionWindowOpen == true)
				{
					return;
				}
				
			}
			catch (e)
			{
			}
			var selected_dash = '';
			if(!Ext.isEmpty(Ext.getCmp('dashListComId')) && Ext.getCmp('dashListComId')!=null && Ext.getCmp('dashListComId')!=undefined)
				selected_dash = Ext.getCmp('dashListComId').getValue();
			var d_url = '/final/monitor/transactions.jsp?treeTitle=services&1=1&&selectNode=Service$cap$'+encodeURIComponent(filterByParamFlag)+'&selectedParam='+encodeURIComponent(filterByParamFlag)+'&currentTab=transactions&isSite=false&aggregateTab=false&hasTransactions=false&hasEmulatedTransactions=true&fromHomepage=&hasLogonSimulations=false&site='+encodeURIComponent(filterByParamFlag)+'&isSite=true&serviceName='+encodeURIComponent(filterByParamFlag)+'&fromLayer=false&selectNode='+encodeURIComponent(filterByParamFlag)+'&selectedParam='+encodeURIComponent(filterByParamFlag)+'&currentTab=transactions&transTab=true&from=null&treeOpen=false&openNode=Services&refresh=true&action=service&topoSegment='+encodeURIComponent(filterByParamFlag)+'&isfromCitrix=true&iniName='+iniName+'&user_name='+user_name+'&dashboard_mapping='+selected_dash+'&dashboard_name='+dashboard+'&view_name='+selected_view_name+"&fromServiceHomePage="+isFromHomePage+"&fromSerComboChange="+fromSerComboChange+"&isFromZone="+isFromZone+"&iszoneName="+iszoneName+"&parentZone="+parentZone+"&fromLogonTab=true";
			Ext.Ajax.request({
				url : d_url,
				timeout:280000,
				success: function(response){
					var jsonText = response.responseText;
					if(!Ext.isEmpty(jsonText))
					{
						var jsonData = Ext.decode(jsonText);
						var screenLabels = jsonData.GridScreenLabels;
						var compType = jsonData.HiddenFields.compType;
						var compName = jsonData.HiddenFields.compName;
						var siteName = jsonData.HiddenFields.siteName;
						if(siteName!=null && siteName!=undefined)
							citrixDashboard.app.getController('Main').siteName=siteName;
						var isWebTrans = jsonData.HiddenFields.isWebTrans;
						
						if(!Ext.isEmpty(sess_sim_compType))
							compType=sess_sim_compType;
						if(!Ext.isEmpty(sess_sim_comp))
							compName=sess_sim_comp;
						
						var script = selectedScript;
						if(!Ext.isEmpty(sess_sim_script))
							script=sess_sim_script;

						var siteBasedWeb = "NULL";
						if(isWebTrans=='true')
						 siteBasedWeb = filterByParamFlag;

						var dashboard_header_idObj = Ext.getCmp('dashboard_header_id_Emu');	

						dashboard_header_idObj.setTitle("<div style=position:relative;top:-4px;><span>"+webAppSimulation+"</span><img style='position: relative;left: 6px;top: 4px;' src='/final/images/clear.png' onclick=\"DashboardToLayers('"+compName+"','"+compType+"','"+siteName+"','emulated','"+selected_view_name+"','"+iniName+"','"+user_name+"','"+selected_dash+"')\" class='iconLayerstack mouse' data-qtip='Layer Model' /> <img style='position: relative;left: 12px;top: 4px;' src='/final/images/clear.png' class='iconTopology mouse' data-qtip='Topology' onclick=\"loadView('Services_Topology_View')\"/></div>");
						
						var sessionSimTopology = Ext.getCmp('sessionSimTopology');
						if(!Ext.isEmpty(sessionSimTopology))
							Ext.get('sessionSimTopology').dom.src="/final/monitor/sessionSimulation.jsp?scriptName="+script+"&site="+siteName+"&dashboard_name="+dashboard+"&compName="+compName+"&site="+siteBasedWeb+"&compType="+compType+"&serviceName="+filterByParamFlag+"&iniName="+iniName+"&user_name="+user_name+"&dashboard_mapping="+selected_dash+"&view_name="+selected_view_name+"&fromServiceHomePage="+isFromHomePage+"&fromSerComboChange="+fromSerComboChange+"&isFromZone="+isFromZone+"&iszoneName="+iszoneName+"&parentZone="+parentZone+"&isCitrix=true";	
							//Ext.get('sessionSimTopology').dom.src="/final/monitor/sessionSimulation.jsp?compName="+compName+"&site=NULL&compType="+compType;	

						/*dashboard_header_idObj.add({
						xtype : 'container',
						margin : 0,
						id : 'sessionSimTopology',
						bodyPadding :0,
						padding:0,
						autoScroll:false,
						scroll:false,
						border : false,
						frame : false,
						layout:'fit',
						autoEl : {
							tag : 'iframe',
							name : 'perMainIframe',
							id:'sessionSimTopologyIframe',
							frameborder : '0',
							style:{'top':'0px','left':'0px'},
							marginLeft:0,
							marginTop:0,
							height : '100%',
							src:"/final/monitor/sessionSimulation.jsp"
						}
					});*/
				}
			}
		});
		}
		
		var selected_dash = '';
		if(!Ext.isEmpty(Ext.getCmp('dashListComId')) && Ext.getCmp('dashListComId')!=null && Ext.getCmp('dashListComId')!=undefined)
			selected_dash = Ext.getCmp('dashListComId').getValue();
		if(!Ext.isEmpty(selected_dash) && selected_dash!=null && selected_dash!=undefined)
			dashboard_mapping = selected_dash;

		if(appendValset!=null && appendValset!=undefined && appendValset!="")
		{
			do
			{
				if (appendValset!=null && appendValset.indexOf("%")>-1)
					appendValset=appendValset.replace("%","|pct|");
			}	while(appendValset.indexOf("%")>-1);

			do
			{
				if (appendValset!=null && appendValset.indexOf("#")>-1)
					appendValset=appendValset.replace("#","|hash|");
			}	while(appendValset.indexOf("#")>-1);

			do
			{
				if (appendValset!=null && appendValset.indexOf("*")>-1)
					appendValset=appendValset.replace("*","|star|");
			}	while(appendValset.indexOf("*")>-1);

			do
			{
				if (appendValset!=null && appendValset.indexOf("(")>-1)
					appendValset=appendValset.replace("(","|lb|");
			}	while(appendValset.indexOf("(")>-1);

			do
			{
				if (appendValset!=null && appendValset.indexOf(")")>-1)
					appendValset=appendValset.replace(")","|rb|");
			}	while(appendValset.indexOf(")")>-1);
		}
		var refurl="/final/servlet/com.eg.EgCommonDashboardController?iniName="+iniName+"&user_name="+encodeURI(user_name)+"&action=loadViewData&subject="+encodeURI(dashboard)+"&time_line="+encodeURI(time_line)+"&isUserBased=true&view_name="+encodeURI(selected_view_name)+"&filterName="+encodeURI(filterName)+"&filterViewName="+encodeURI(filter_view_name)+"&allSelectedMeasure="+encodeURI(appendValset)+"&dashboard_mapping="+encodeURI(dashboard_mapping)+"&fromSerComboChange="+fromSerComboChange+"&isFromCitrix=true"+"&dashboard_name="+dashboard;
		
		if(isFromHomePage || isFromHomePage == 'true')
			refurl += "&fromServiceHomePage="+isFromHomePage+"&appliesTo="+userMappingApplisTo;

		Ext.Ajax.request({
			url : refurl,
			method : 'POST',
			scope:this,
			timeout:280000,
			success : function(response, opts)
			{
				var jsonText = response.responseText;
				var noWidgets=true;
				if(jsonText!=null && jsonText!=undefined)
				{
					var jsonData = Ext.decode(jsonText);
					var toggleObjSpc = null;
					if(!Ext.isEmpty(selected_view_name) && selected_view_name.trim() == "Applications_View")
					{
						if(jsonData!=null && jsonData!=undefined)
						{
							if(jsonData.loadViewDetails!=null && jsonData.loadViewDetails!=undefined)
							{
								var panelDataArr=jsonData.loadViewDetails;
								
								if(panelDataArr!=null && panelDataArr!=undefined && panelDataArr.length>0)
								{
									var appBlock_1_Title=panelDataArr[0];
									var appBlock_1_Value=panelDataArr[1];
									var appBlock_2_Title=panelDataArr[2];
									var appBlock_2_Value=panelDataArr[3];
									var appBlock_3_Value=panelDataArr[4];

									if(!Ext.isEmpty(panelDataArr[0]) && panelDataArr[0]!=undefined)
									{
										var appidObj = Ext.getCmp('app_id');
										appidObj.setTitle(panelDataArr[0].Application_Block_1_Title);
									}
									if(!Ext.isEmpty(panelDataArr[1]) && panelDataArr[1]!=undefined)
									{
										Ext.getCmp('app_overviewpanel_id').updateData(panelDataArr[1].Application_Block_1_Value);
									}

									if(!Ext.isEmpty(panelDataArr[2]) && panelDataArr[2]!=undefined)
									{
										var topAppidObj = Ext.getCmp('top_app_id');
										topAppidObj.setTitle(panelDataArr[2].Application_Block_2_Title);
									}

									if((!Ext.isEmpty(panelDataArr[3]) && panelDataArr[3]!=undefined))
									{
										var multBarIns = Ext.getCmp('multBarIns');
										multBarIns.updateChart(panelDataArr[3].Application_Block_2_Value);
									}

									if(!Ext.isEmpty(panelDataArr[4]) && panelDataArr[4]!=undefined)
									{
										var gridInst = Ext.getCmp('gridInst');
										gridInst.data=panelDataArr[4].Application_Block_3_Value[0];
										gridInst.loadData(panelDataArr[4].Application_Block_3_Value[0]);
									}
								}
							}
						}
					}
					else if(!Ext.isEmpty(selected_view_name) && selected_view_name.trim() == "Resources_View")
					{
						toggleObjSpc = 'res_toogle';
						if(jsonData!=null && jsonData!=undefined)
						{
							if(jsonData.loadViewDetails!=null && jsonData.loadViewDetails!=undefined)
							{
								var panelDataArr=jsonData.loadViewDetails;
								
								if(panelDataArr!=null && panelDataArr!=undefined && panelDataArr.length>0)
								{
									var appBlock_1_Title=panelDataArr[0];
									var appBlock_1_Value=panelDataArr[1];
									var appBlock_2_Title=panelDataArr[2];
									var appBlock_2_Value=panelDataArr[3];
									var appBlock_3_Value=panelDataArr[4];
									if(!Ext.isEmpty(panelDataArr[0]) && panelDataArr[0]!=undefined)
									{
										var residObj = Ext.getCmp('res_first_header_id');
										residObj.setTitle(panelDataArr[0].Resources_Block_1_Title);
									}

									if(!Ext.isEmpty(panelDataArr[1]) && panelDataArr[1]!=undefined)
									{
										Ext.getCmp('res_overviewpanel_id').updateData(panelDataArr[1].Resources_Block_1_Value);
									}

									if(!Ext.isEmpty(panelDataArr[2]) && panelDataArr[2]!=undefined)
									{
										var topResidObj = Ext.getCmp('res_user_header_id');
										topResidObj.setTitle(panelDataArr[2].Resources_Block_2_Title);
									}

									if((!Ext.isEmpty(panelDataArr[3]) && panelDataArr[3]!=undefined))
									{
										var multBarIns_userObj = Ext.getCmp('multBarIns_user');
										multBarIns_userObj.data=panelDataArr[3].Resources_Block_2_Value;
										multBarIns_userObj.updateChart(panelDataArr[3].Resources_Block_2_Value);
									}
									
									if(!Ext.isEmpty(panelDataArr[4]) && panelDataArr[4]!=undefined)
									{
										var topResidObj = Ext.getCmp('res_app_header_id');
										topResidObj.setTitle(panelDataArr[4].Resources_Block_3_Title);
									}
									
									if((!Ext.isEmpty(panelDataArr[5]) && panelDataArr[5]!=undefined))
									{
										var multBarIns_appObj = Ext.getCmp('multBarIns_app');
										if(Ext.isEmpty(multBarIns_appObj))
										{
											var res_chartObj = Ext.getCmp('res_app_header_id');
											res_chartObj.removeAll(true);
											res_chartObj.add({
												xtype:'chartparentpanel',
												id:'multBarIns_app',
												ifRes:true,
												//legendPosition: 'top',
												//chartType:panelDataArr[3].Application_Block_2_Value.result.chartType,
												data:panelDataArr[5].Resources_Block_3_Value,
												orgData:panelDataArr[5].Resources_Block_3_Value,
												flex:1,
												//height:500
												//width:'100%',
												//data:panelDataArr[3].Application_Block_2_Value.result
												//data:panelDataArr[3].Application_Block_2.result
												//html:'<table><tr><td>'+overviewData[0]['chart']+'</td></tr></table>'
											});
											res_chartObj.doLayout();
										}
										else
										{
											multBarIns_appObj.data=panelDataArr[5].Resources_Block_3_Value;
											multBarIns_appObj.updateChart(panelDataArr[5].Resources_Block_3_Value);
										}
									}
									
									if(!Ext.isEmpty(panelDataArr[6]) && panelDataArr[6]!=undefined)
									{
										var topResidObj = Ext.getCmp('res_server_header_id');
										topResidObj.setTitle(panelDataArr[6].Resources_Block_4_Title);
									}

									if((!Ext.isEmpty(panelDataArr[7]) && panelDataArr[7]!=undefined))
									{
										var multBarIns_serverObj = Ext.getCmp('multBarIns_server');
										if(Ext.isEmpty(multBarIns_serverObj))
										{
											var res_chartObj = Ext.getCmp('res_server_header_id');
											res_chartObj.removeAll(true);
											res_chartObj.add({
												xtype:'chartparentpanel',
												id:'multBarIns_server',
												ifRes:true,
												//legendPosition: 'top',
												//chartType:panelDataArr[3].Application_Block_2_Value.result.chartType,
												data:panelDataArr[7].Resources_Block_4_Value,
												orgData:panelDataArr[7].Resources_Block_4_Value,
												flex:1,
												//height:500
												//width:'100%',
												//data:panelDataArr[3].Application_Block_2_Value.result
												//data:panelDataArr[3].Application_Block_2.result
												//html:'<table><tr><td>'+overviewData[0]['chart']+'</td></tr></table>'
											});
											res_chartObj.doLayout();
										}
										else
										{
											multBarIns_serverObj.data=panelDataArr[7].Resources_Block_4_Value;
											multBarIns_serverObj.updateChart(panelDataArr[7].Resources_Block_4_Value);
										}
									}
								}
							}
						}
					}
					else if(!Ext.isEmpty(selected_view_name) && selected_view_name.trim() == "Geo_View")
					{
						toggleObjSpc = 'geo_toogle';
						if(jsonData!=null && jsonData!=undefined)
						{
							if(jsonData.loadViewDetails!=null && jsonData.loadViewDetails!=undefined)
							{
								var panelDataArr=jsonData.loadViewDetails;
								
								if(panelDataArr!=null && panelDataArr!=undefined && panelDataArr.length>0)
								{
									if(!Ext.isEmpty(panelDataArr[0]) && panelDataArr[0]!=undefined)
									{
										var geoidObj = Ext.getCmp('geo_first_header_id');
										geoidObj.setTitle(panelDataArr[0].Geo_Block_1_Title);
									}

									if(!Ext.isEmpty(panelDataArr[1]) && panelDataArr[1]!=undefined)
									{
										//Ext.getCmp('hostDetailsId').updateData(panelDataArr[1].Geo_Block_1_Value);
										Ext.getCmp('geo_overviewpanel_id').updateData(panelDataArr[1].Geo_Block_1_Value);
									}

									if(!Ext.isEmpty(panelDataArr[2]) && panelDataArr[2]!=undefined)
									{
										if(panelDataArr[2].Geo_Block_2_Value[0].resultArray != null && panelDataArr[2].Geo_Block_2_Value[0].resultArray.length > 0)
										{
											//var map_obj = Ext.getCmp('geo_id_map');
											//map_obj.jsonData = panelDataArr[2].Geo_Block_2_Value[0];
											//map_obj.updateData(map_obj);
											if(filter_view_name==null || filter_view_name==undefined || filter_view_name=='')
											{
												var countryComboObj = Ext.getCmp('countryComboId');
												if(!Ext.isEmpty(countryComboObj) && countryComboObj!=undefined)
												{
													countryComboObj.show();

													countryComboObj.getStore().loadRawData(panelDataArr[2].Geo_Block_2_Value[0].countryArray);
													countryComboObj.setValue(panelDataArr[2].Geo_Block_2_Value[0].selectedCountry);
												}
											}
											else if(filter_view_name!=null && filter_view_name!=undefined && filter_view_name=='Geo_Country_View')
											{
												var regionComboObj = Ext.getCmp('regionComboId');
												if(!Ext.isEmpty(regionComboObj) && regionComboObj!=undefined)
												{
													regionComboObj.show();

													regionComboObj.getStore().loadRawData(panelDataArr[2].Geo_Block_2_Value[0].regionArray);
													regionComboObj.setValue(panelDataArr[2].Geo_Block_2_Value[0].selectedRegion);
												}
											}
											/*else if(filter_view_name!=null && filter_view_name!=undefined && filter_view_name=='Geo_Region_View')
											{
												var regionComboObj = Ext.getCmp('regionComboId');
												if(!Ext.isEmpty(regionComboObj) && regionComboObj!=undefined)
												{
													regionComboObj.show();

													regionComboObj.getStore().loadRawData(panelDataArr[2].Geo_Block_2_Value[0].regionArray);
													regionComboObj.setValue(panelDataArr[2].Geo_Block_2_Value[0].selectedRegion);
												}
											}*/
											try
											{
												Ext.getCmp('geo_id_map').updateData(panelDataArr[2].Geo_Block_2_Value[0]);
												Ext.getCmp('geo_id_mapdetails').updateData(panelDataArr[2].Geo_Block_2_Value[0]);
											}
											catch (e)
											{
											}
										}										
									}

									if(!Ext.isEmpty(panelDataArr[3]) && panelDataArr[3]!=undefined)
									{
										//var geoidObj = Ext.getCmp('geo_first_header_id');
										//geoidObj.setTitle(panelDataArr[3].Geo_Block_1_Title);

										//var geoidObj = Ext.getCmp('geo_first_header_id');
										//geoidObj.setTitle(panelDataArr[0].Geo_Block_1_Title);
									}

									if(!Ext.isEmpty(panelDataArr[4]) && panelDataArr[4]!=undefined)
									{
										if(panelDataArr[2].Geo_Block_2_Value[0].resultArray != null && panelDataArr[2].Geo_Block_2_Value[0].resultArray.length > 0)
										{
											try
											{
												var geo_overviewpanel3x1_alert_id = Ext.getCmp('geo_overviewpanel3x1_alert_id');
												geo_overviewpanel3x1_alert_id.updateData(panelDataArr[4].Geo_Block_3_Value);
											}
											catch (e)
											{
											}											
										}
										else
										{
											var data = panelDataArr[4].Geo_Block_3_Value;
											if(data != undefined && data != null && data.length > 0)
											{
												for(var a in data){
													var obj = data[a];
													try
													{
														var chart_type = obj['chart'];
														if(chart_type == undefined)
															chart_type= obj['type'];
													}
													catch (ert)
													{
													}
													if(chart_type != undefined && chart_type.toLowerCase() == 'tierhealth')
													{
														var id=chart_type+'_'+a+'_overviewextra';
														Ext.getCmp(id).updateData(obj);
													}
													else if(chart_type != undefined && chart_type.toLowerCase() == 'donut' )
													{
														var id=chart_type+'_'+a+'_overviewextra';
														Ext.getCmp(id).updateData(obj);
													}
													else if(chart_type != undefined && chart_type == 'Gauge' )
													{
														var chartdata1 = obj.data;
														if(chartdata1 != undefined && chartdata1 != null){
															for(var b in chartdata1)
															{
																var chart_type1 = chartdata1[b]['chart'];
																if(chart_type1 != undefined && chart_type1 == 'Gauge' )
																{
																	var id=chart_type1+'_Gauge_'+b+'_overviewextra';
																	Ext.getCmp(id).updateData(chartdata1[b].graphData);
																}
																else if(chart_type1 != undefined && chart_type1 == 'ColourText' )
																{
																	var id=chart_type1+'_ColourText_'+b+'_overviewextra';
																	Ext.getCmp(id).updateData(chartdata1[b]);
																}
															}						
														}
													}
													else if(chart_type != undefined && chart_type == 'GraphText' )
													{
														var chartdata1 = obj.data;
														if(chartdata1 != undefined && chartdata1 != null){
															for(var b in chartdata1)
															{
																var chart_type1 = chartdata1[b]['chart'];
																if(chart_type1 != undefined && chart_type1 == 'GraphText' )
																{
																	var id=chart_type1+'_GraphText_'+b+'_overviewextra';
																	Ext.getCmp(id).updateData(chartdata1[b]);
																}
																else if(chart_type1 != undefined && chart_type1.toLowerCase() == 'gauge' )
																{
																	var id=chart_type1+'_Gauge_'+b+'_overviewextra';
																	Ext.getCmp(id).updateData(chartdata1[b]);
																}
															}						
														}
													}
												}
											}
										}
									}

									if((!Ext.isEmpty(panelDataArr[5]) && panelDataArr[5]!=undefined))
									{
										var geo_chartObj = Ext.getCmp('multBarIns_geo');
										geo_chartObj.data=panelDataArr[5].Geo_Block_4_Value;
										geo_chartObj.updateChart(panelDataArr[5].Geo_Block_4_Value);
									}
								}
							}
						}
					}
					else if(!Ext.isEmpty(selected_view_name) && selected_view_name.trim() == "Overview_View")
					{
						toggleObjSpc = 'over_toogle';
						if(jsonData!=null && jsonData!=undefined)
						{
							if(jsonData.loadViewDetails!=null && jsonData.loadViewDetails!=undefined)
							{
								var panelDataArr=jsonData.loadViewDetails;
								
								if(!Ext.isEmpty(panelDataArr[0]) && panelDataArr[0]!=undefined)
								{
									var overviewIdObj = Ext.getCmp('overview_first_header_id');
									overviewIdObj.setTitle(panelDataArr[0].Overview_Block_1_Title);
								}

								if(!Ext.isEmpty(panelDataArr[1]) && panelDataArr[1]!=undefined)
								{
									Ext.getCmp('overviewpanel_id').updateData(panelDataArr[1].Overview_Block_1_Value);
								}

								if(!Ext.isEmpty(panelDataArr[2]) && panelDataArr[2]!=undefined)
								{
									Ext.getCmp('overview_map_id').updateData(panelDataArr[2].Overview_Block_2_Value[0]);
									Ext.getCmp('overviewctxpanel_right_top_panel_id').updateData(panelDataArr[2].Overview_Block_2_Value[0]);
								}

								if(!Ext.isEmpty(panelDataArr[2]) && panelDataArr[2]!=undefined)
								{
									var tmpPanelArrays = new Array();
									var tmpPanelArrays2 = new Array();
									if(panelDataArr[2].Overview_Block_2_Value != undefined && panelDataArr[2].Overview_Block_2_Value != null && panelDataArr[2].Overview_Block_2_Value.length > 0)
									{
										var obj_tmp = panelDataArr[2].Overview_Block_2_Value[1];
										tmpPanelArrays.push(obj_tmp);

										var obj_tmp = panelDataArr[2].Overview_Block_2_Value[2];
										tmpPanelArrays2.push(obj_tmp);
									}
									Ext.getCmp('overviewctxpanel_right_top_panel_id').updateData(panelDataArr[2].Overview_Block_2_Value);
								}

								if((!Ext.isEmpty(panelDataArr[3]) && panelDataArr[3]!=undefined))
								{
									var overview_chartObj = Ext.getCmp('multBarIns_overview');
									//overview_chartObj.data=panelDataArr[3].Overview_Block_3_Value;
									overview_chartObj.updateChart(panelDataArr[3].Overview_Block_3_Value);
								}
							}
						}
					}
					else if(!Ext.isEmpty(selected_view_name) && selected_view_name.trim() == "Alerts_View")
					{
						if(jsonData!=null && jsonData!=undefined)
						{
							if(jsonData.loadViewDetails!=null && jsonData.loadViewDetails!=undefined)
							{
								var panelDataArr=jsonData.loadViewDetails;
								
								if(!Ext.isEmpty(panelDataArr[0]) && panelDataArr[0]!=undefined)
								{
									var overviewIdObj = Ext.getCmp('alerts_header_id');
									overviewIdObj.setTitle(panelDataArr[0].Alert_Block_1_Title);
								}

								if(!Ext.isEmpty(panelDataArr[1]) && panelDataArr[1]!=undefined)
								{
									var alertsWidgetsIns_idObj = Ext.getCmp('alertswidgets_Ins');
									alertsWidgetsIns_idObj.updateData(panelDataArr[1].Alert_Block_1_Value);
									/*alertsWidgetsIns_idObj.removeAll(true);
									alertsWidgetsIns_idObj.add({
										xtype:'alertswidgets',
										id:'alertswidgets_Ins',
										data:panelDataArr[1].Alert_Block_1_Value,
									});*/
								}

								if(!Ext.isEmpty(panelDataArr[2]) && panelDataArr[2]!=undefined)
								{
									var alerts_gridIns = Ext.getCmp('alerts_gridInst');
									alerts_gridIns.data = panelDataArr[2].Alert_Block_2_Value;
									alerts_gridIns.updateChart(panelDataArr[2].Alert_Block_2_Value);
								}
							}
						}
					}
					else if(!Ext.isEmpty(selected_view_name) && selected_view_name.trim() == "UserExperience_View")
					{
						toggleObjSpc = 'ux_toogle';
						if(jsonData!=null && jsonData!=undefined)
						{
							if(jsonData.loadViewDetails!=null && jsonData.loadViewDetails!=undefined)
							{
								var panelDataArr=jsonData.loadViewDetails;

								if(!Ext.isEmpty(panelDataArr[0]) && panelDataArr[0]!=undefined)
								{
									var UxDashHeaderIdObj = Ext.getCmp('UxDashHeader_id');
									//UxDashHeaderIdObj.setTitle(panelDataArr[0].UserExperience_Block_1_Title);
									UxDashHeaderIdObj.setTitle("USER EXPERIENCE - REAL USERS");
								}

								if(!Ext.isEmpty(panelDataArr[1]) && panelDataArr[1]!=undefined)
								{
									var overviewpaneluxdash_InsObj = Ext.getCmp('overviewpaneluxdash_Ins');
									overviewpaneluxdash_InsObj.updateData(panelDataArr[1].UserExperience_Block_1_Value);
								}
								if(!Ext.isEmpty(panelDataArr[2]) && panelDataArr[2]!=undefined)
								{
									var ux_dash_chart_panel_idObj = Ext.getCmp('ux_dash_chart_panel_id');
									ux_dash_chart_panel_idObj.data = panelDataArr[2].UserExperience_Block_2_Value;
									ux_dash_chart_panel_idObj.updateChart(panelDataArr[2].UserExperience_Block_2_Value);
								}
							}
						}
					}
					else if(!Ext.isEmpty(selected_view_name) && selected_view_name.trim() == "Sessions_View")
					{
						var panelDataArr=jsonData.loadViewDetails;
						if(!Ext.isEmpty(panelDataArr[0]) && panelDataArr[0]!=undefined)
						{
							var sessions_headeridObj = Ext.getCmp('sessions_headerid');
							sessions_headeridObj.setTitle(panelDataArr[0].Sessions_Block_1_Title);
						}

						if(!Ext.isEmpty(panelDataArr[1]) && panelDataArr[1]!=undefined)
						{
							var sessionsparentpanel_idObj = Ext.getCmp('sessionsparentpanel_Obj');
							sessionsparentpanel_idObj.updatePanelData(panelDataArr);
						}


					}
					else if(!Ext.isEmpty(selected_view_name) && selected_view_name.trim() == "Logon_View")
					{
						var panelDataArr=jsonData.loadViewDetails;
						if(!Ext.isEmpty(panelDataArr[0]) && panelDataArr[0]!=undefined)
						{
							var logon_hId = Ext.getCmp('logon_header_Id');
							logon_hId.setTitle(panelDataArr[0].Logon_Block_1_Title);								
						}
						
						if(!Ext.isEmpty(panelDataArr[1]) && panelDataArr[1]!=undefined)
						{
							var sessionOverViewIdIns_hId = Ext.getCmp('sessionOverViewId_Ins');
							sessionOverViewIdIns_hId.updateData(panelDataArr[1].Logon_Block_1_Value);
						}

						if(!Ext.isEmpty(panelDataArr[2]) && panelDataArr[2]!=undefined)
						{
							var sessionOverViewId_Obj = Ext.getCmp('sessionOverViewId_prpanel');
							sessionOverViewId_Obj.data = panelDataArr[2].Logon_Block_2_Value;
							sessionOverViewId_Obj.updateChart(panelDataArr[2].Logon_Block_2_Value);
						}
					}
					else if(!Ext.isEmpty(selected_view_name) && selected_view_name.trim() == "Broker_View")
					{
						var panelDataArr=jsonData.loadViewDetails;
						if(!Ext.isEmpty(panelDataArr[0]) && panelDataArr[0]!=undefined)
						{
							var brokeridObj = Ext.getCmp('broker_header_Id');
							brokeridObj.setTitle(panelDataArr[0].Broker_Block_1_Title);
						}
						if(!Ext.isEmpty(panelDataArr[1]) && panelDataArr[1]!=undefined)
						{
							var brokerOverviewObj = Ext.getCmp('broker_overviewpanel_id');
							brokerOverviewObj.updateData(panelDataArr[1].Broker_Block_1_Value);
						}
						if(!Ext.isEmpty(panelDataArr[2]) && panelDataArr[2]!=undefined)
						{
							var brokerDesidObj = Ext.getCmp('br_desktop_header_id');
							brokerDesidObj.setTitle(panelDataArr[2].Broker_Block_2_Title);
						}
						
						if((!Ext.isEmpty(panelDataArr[3]) && panelDataArr[3]!=undefined))
						{
							var res_chartObj = Ext.getCmp('multBarIns_Des');
							res_chartObj.data=panelDataArr[3].Broker_Block_2_Value;
							res_chartObj.updateChart(panelDataArr[3].Broker_Block_2_Value);
						}

						if(!Ext.isEmpty(panelDataArr[4]) && panelDataArr[4]!=undefined)
						{
							var brokerSeridObj = Ext.getCmp('br_server_header_id');
							brokerSeridObj.setTitle(panelDataArr[4].Broker_Block_3_Title);
						}

						if((!Ext.isEmpty(panelDataArr[5]) && panelDataArr[5]!=undefined))
						{
							var res_chartObj = Ext.getCmp('multBarIns_Ser');
							res_chartObj.data=panelDataArr[5].Broker_Block_3_Value;
							res_chartObj.updateChart(panelDataArr[5].Broker_Block_3_Value);
						}
						
					}
					var me = this;
					try{
						var button = Ext.ComponentQuery.query('button[itemId="overviewtoggle"]')[0];
						if(!Ext.isEmpty(button)){
							//toggleObjSpc = 'ux_toogle';
							if(toggleObjSpc != null)
							{
								var toggleObj = Ext.getCmp(toggleObjSpc);
								if (!Ext.isEmpty(toggleObj) && !Ext.isEmpty(toggleObj.pressed) && toggleObj.pressed) {
									button.pressed = true;
									me.toggleOverViewrefresh(button, true);
								} else if (!Ext.isEmpty(toggleObj)) {
									button.pressed = false;
									me.toggleOverViewrefresh(button, false);
								}
							}
						}
					}catch(ee){
					}
				}
			},
			failure:function(){
				//setTimeout("execute()",60000);
			}
		});
	},
	loadView:function()
	{
		isRefreshing = false;
		perVal=0;
		var TimeLineObj = Ext.getCmp('TimeLineId');
		var time_line = null;
		if(TimeLineObj!=null && TimeLineObj!=undefined)
		{
			time_line = TimeLineObj.getValue();
		}
		if(time_line==null || time_line==undefined || time_line=="")
			time_line="Current";
		
		var menuObj = Ext.getCmp('dashmenu_model_id');
		var forceKey=menuObj.forceClickKey;

		selected_view_name = requestParams.activeView;
		var resources_url="";
		var url="/final/servlet/com.eg.EgCommonDashboardController?iniName="+iniName+"&user_name="+encodeURI(user_name)+"&action=loadViewData&subject="+encodeURI(dashboard)+"&time_line="+encodeURI(time_line)+"&isUserBased=true&view_name="+encodeURI(selected_view_name)+"&dashboard_mapping="+encodeURI(dashboard_mapping)+"&fromSerComboChange="+fromSerComboChange+'&dashboard_name='+dashboard;


		if(isFromHomePage || isFromHomePage == 'true')
			url += "&fromServiceHomePage="+isFromHomePage+"&appliesTo="+userMappingApplisTo;

		if(isFromZonePage || isFromZonePage == 'true')
			url += "&fromZonePage="+fromZonePage;

		var cnt_url = "/final/servlet/com.eg.EgCommonDashboardController?iniName="+iniName+"&user_name="+encodeURI(user_name)+"&action=loadViewData&subject="+encodeURI(dashboard)+"&time_line="+encodeURI(time_line)+"&isUserBased=true&view_name=Geo_View&filterName=World&filterViewName="+"&dashboard_mapping="+encodeURI(dashboard_mapping)+"&fromSerComboChange="+fromSerComboChange+'&dashboard_name='+dashboard;

		var reg_url = "/final/servlet/com.eg.EgCommonDashboardController?iniName="+iniName+"&user_name="+encodeURI(user_name)+"&action=loadViewData&subject="+encodeURI(dashboard)+"&time_line="+encodeURI(time_line)+"&isUserBased=true&view_name=Geo_View&filterName="+countryCode+"&filterViewName=Geo_Country_View"+"&dashboard_mapping="+encodeURI(dashboard_mapping)+"&fromSerComboChange="+fromSerComboChange+'&dashboard_name='+dashboard;

		var isCountryRequestNeeded = false;
		var isRegionRequestNeeded = false;
		var isFromForce=false;
		//if(!Ext.isEmpty(selected_view_name) && selected_view_name.trim() == "Geo_View" && forceKey!=null && forceKey!=undefined && forceKey!="" && forceKey!="World")
		if((!isFromUED || isFromUED == 'false') && (forceKey==null || forceKey==undefined || forceKey==""))
			forceKey="World";

		if(!Ext.isEmpty(selected_view_name) && (selected_view_name.trim() == "Geo_View" || selected_view_name.trim() == "Overview_View") && forceKey!=null && forceKey!=undefined && forceKey!="")
		{
			selected_CompType_st ='';
			if(forceKey=='World')
				url=url+"&filterName="+encodeURI(forceKey)+"&filterViewName=";
			else
			{
				url=url+"&filterName="+encodeURI(forceKey)+"&filterViewName=Geo_Country_View";
				isFromForce=true;
			}			
		}
		else if((isFromUED == true || isFromUED == 'true') && !Ext.isEmpty(selected_view_name) && selected_view_name.trim() == "Geo_View")
		{
			selected_CompType_st ='';
			if(filterName!=null && filterName!=undefined && filterName=='World')
			{
				url=url+"&filterName=World&filterViewName=";
			}
			else
			{
				url=url+"&filterName="+encodeURI(filterName)+"&filterViewName="+filterViewName;
			}

			url +="&isFromUED=true";
			isCountryRequestNeeded = true; //-- for temp command this line

			if(filterViewName!=null && filterViewName!=undefined && filterViewName=='Geo_Region_View')
			{
				isRegionRequestNeeded = true; //-- for temp command this line
			}
		}
		else if(!Ext.isEmpty(selected_view_name) && selected_view_name.trim() == "Logon_View") 
		{
			selected_CompType_st ='';
			url=url+"&filterName=Logon_View&filterViewName=";
		}
		else if(!Ext.isEmpty(selected_view_name) && selected_view_name.trim() == "Resources_View") 
		{
			selected_CompType_st ='';
			resources_url = url;
			url=url+"&selectedVariable=Resources_Block_1_Title,Resources_Block_1_Value,Resources_Block_2_Title,Resources_Block_2_Value";
		}
		else if(!Ext.isEmpty(selected_view_name) && selected_view_name.trim() == "Services_Topology_View"){
			selected_CompType_st ='';
			var topology_containerObj = Ext.getCmp('topology_container');
			var topology_header_idObj = Ext.getCmp('topology_header_id');
			topology_containerObj.removeAll(true);
			topology_header_idObj.removeAll(true);
			var assSeg = null;
			var assSegArray = [];
			if(!Ext.isEmpty(userMappingApplisTo) && userMappingApplisTo != null && userMappingApplisTo != undefined){
				if(userMappingApplisTo.indexOf(":") > 0){
					var serName = userMappingApplisTo.substring(userMappingApplisTo.indexOf(":")+1);									
				}
			}
			var selected_dash = '';
			if(!Ext.isEmpty(Ext.getCmp('dashListComId')) && Ext.getCmp('dashListComId')!=null && Ext.getCmp('dashListComId')!=undefined)
				selected_dash = Ext.getCmp('dashListComId').getValue();
			if(isFromHomePage)
				topology_header_idObj.setTitle("<p style='font-size:13px'>TOPOLOGY</p>");
			else
				topology_header_idObj.setTitle("TOPOLOGY FOR Service : "+serName);
			var isSerComboNeed = false;
			if(!Ext.isEmpty(ifAssSeg) && ifAssSeg != null && ifAssSeg != undefined){
				var segName = "";
				if(ifAssSeg.indexOf(",") > 0){
					ifAssSeg = ifAssSeg.trim();
					isSerComboNeed = true;
					assSeg = ifAssSeg.split(',');
					for(var t=0;t<assSeg.length;t++){
						assSegArray[t] = {"value":assSeg[t]};
					}
					var segName = ifAssSeg.substring(0,ifAssSeg.indexOf(","));									
				}else if(!Ext.isEmpty(ifAssSeg) && ifAssSeg != null && ifAssSeg != undefined){
					var segName = ifAssSeg;
				}
			}
			if(!Ext.isEmpty(selectedSegmentName) && selectedSegmentName != null && selectedSegmentName != undefined && selectedSegmentName != 'null' && selectedSegmentName != 'undefined')
			{
				segName = selectedSegmentName;
			}
			if(isSite != null && isSite == "true" && hasTransactions != "true")
			{
				topology_header_idObj.addTool({
					xtype : 'button',
					text : 'Configure Transactions',
					id:'service_trans_id',
					cls:'button20',
					action:'transactionsGridConfigureBtn'
				});
			}
			if(isSerComboNeed){
				topology_header_idObj.addTool({
					xtype:'combo',
					cls:'dropdown',
					id:'servce_combo_id',
					style:{'margin-left':'10px'},
					store:Ext.create('Ext.data.Store',{
						fields:['value'],
						data:assSegArray
					}),
					editable:false,
					labelWidth:60,
					width:305,
					margin:0,
					displayField:'value',
					valueField:'value',
					value:segName,
					fieldLabel:'Segment',
					listeners:{
						'change':function(combo,record){
							var turl = '/final/monitor/EgServiceTopologyD3JS.jsp?physical_topology=0&type=monitor&treeFlag=null&zoneName=&currentTab=null&aggregateTab=null&openNode=null&treeFlag=null&dashboard_mapping='+selected_dash+'&fromHomepage='+isFromHomePage+'&serviceGroup=&iszoneName='+iszoneName+'&isFromZone='+isFromZone+'&parentZone='+parentZone+'&user_name='+user_name+'&action=service&serviceState=service20New_'+ifAssSegState+'&service='+serName+'&segment='+record+'&site='+serName+"&filter=service&filterBy="+encodeURIComponent(filterByParamFlag)+"&isfromCitrix=true&isFromServiceMenu="+isFromServiceMenu+"&isFromZoneMain="+isFromZoneMain+"&isFromZoneMenu="+isFromZoneMenu+"&isFromServiceGroup="+isFromServiceGroup+"&activeView=topology";//&isfromCitrix=true
							Ext.get('serTopologyMainCon').dom.src=turl;
						}
					}
				});
			}
			var top_url = '/final/monitor/EgServiceTopologyD3JS.jsp?physical_topology=0&type=monitor&treeFlag=null&zoneName=&currentTab=null&aggregateTab=null&openNode=null&treeFlag=null&dashboard_mapping='+selected_dash+'&fromHomepage='+isFromHomePage+'&serviceGroup=&iszoneName='+iszoneName+'&isFromZone='+isFromZone+'&parentZone='+parentZone+'&user_name='+user_name+'&action=service&serviceState=service20New_'+ifAssSegState+'&service='+serName+'&segment='+segName+'&site='+serName+"&filter=service&filterBy="+encodeURIComponent(filterByParamFlag)+"&isfromCitrix=true&isFromServiceMenu="+isFromServiceMenu+"&isFromZoneMain="+isFromZoneMain+"&isFromZoneMenu="+isFromZoneMenu+"&isFromServiceGroup="+isFromServiceGroup+"&activeView=topology";
			topology_containerObj.add({
				xtype : 'container',
				margin : 0,
				id : 'serTopologyMainCon',
				bodyPadding :0,
				padding:0,
				autoScroll:false,
				scroll:false,
				border : false,
				frame : false,
				layout:'fit',
				autoEl : {
					tag : 'iframe',
					name : 'perMainIframe',
					scrolling:"no",
					id:'serTopologyIframe',
					frameborder : '0',
					style:{'top':'0px','left':'0px'},
					marginLeft:0,
					marginTop:0,
					height : '100%',
					src:top_url
				}
			});
			topology_containerObj.doLayout();

		}
		else if(!Ext.isEmpty(selected_view_name) && selected_view_name.trim() == "Segments_Topology_View")
		{
			selected_CompType_st ='';
			var topology_containerObj = Ext.getCmp('topology_container');
			var topology_header_idObj = Ext.getCmp('topology_header_id');
			topology_containerObj.removeAll(true);
			if(!Ext.isEmpty(userMappingApplisTo) && userMappingApplisTo != null && userMappingApplisTo != undefined){
				if(userMappingApplisTo.indexOf(":") > 0){
					var segName = userMappingApplisTo.substring(userMappingApplisTo.indexOf(":")+1);									
				}
			}

			if(isFromHomePage)
				topology_header_idObj.setTitle("TOPOLOGY");
			else
				topology_header_idObj.setTitle("TOPOLOGY FOR Segment : "+segName);

			var top_url = '/final/monitor/EgSegmentTopologyD3JS.jsp?segment='+segName+'&physical_topology=1&fromHomepage='+isFromHomePage+'&type=segment&zoom=100&isFromZone='+isFromZone+'&iszoneName='+iszoneName+'&parentZone='+iszoneName+'&segmentState=segment20New_HIGH';
			topology_containerObj.add({
				xtype : 'container',
				margin : 0,
				id : 'segTopologyMainCon',
				bodyPadding :0,
				padding:0,
				autoScroll:false,
				scroll:false,
				border : false,
				frame : false,
				layout:'fit',
				autoEl : {
					tag : 'iframe',
					name : 'perMainIframe',
					id:'segTopologyIframe',
					scrolling:"no",
					frameborder : '0',
					style:{'top':'0px','left':'0px'},
					marginLeft:0,
					marginTop:0,
					height : '100%',
					src:top_url
				}
			});
			topology_containerObj.doLayout();
		}
		else if(!Ext.isEmpty(selected_view_name) && selected_view_name.trim() == "Metrics_View")
		{
			var metrics_containerObj = Ext.getCmp('metrics_container');
			if(!Ext.isEmpty(userMappingApplisTo) && userMappingApplisTo != null && userMappingApplisTo != undefined){
				if(userMappingApplisTo.indexOf(":") > 0){
					var filterBy = userMappingApplisTo.substring(0,userMappingApplisTo.indexOf(":"));
					var filter = userMappingApplisTo.substring(userMappingApplisTo.indexOf(":")+1);
					if(filterBy != null && filterBy == 'Service')
						filterBy = 'services';
				}
			}
			var compTypeComboFlag = false;
			if(filterBy.toLowerCase().indexOf("component") > -1)
				compTypeComboFlag = true;

			var selected_dash = '';
			if(!Ext.isEmpty(Ext.getCmp('dashListComId')) && Ext.getCmp('dashListComId')!=null && Ext.getCmp('dashListComId')!=undefined)
				selected_dash = Ext.getCmp('dashListComId').getValue();

			var nickNameVal="";
			if(Ext.getCmp('nickName')!=null && Ext.getCmp('nickName')!=undefined && Ext.getCmp('nickName').getValue()!=null && Ext.getCmp('nickName').getValue()!='null')
			{
				nickNameVal = Ext.getCmp('nickName').getValue();
			}
			if(componentNameSearch != null && componentNameSearch !='null' && componentNameSearch != undefined &&  componentNameSearch != 'undefined')
			{
				nickNameVal = componentNameSearch;
			}
			var url = '/final/monitor/comparisonComponent.jsp?treeTitle=citrixcomponents&selectedState=&componentNameSearch='+nickNameVal+'&fromPageView=CitrixDashboard&viewPageTitle=Components&action=component&fromHomepage=&userName=&filterBy='+filterBy+'&subFilter='+filter+'&timeline=null&isfromCitrix=true&iniName='+iniName+'&user_name='+user_name+'&dashboard_mapping='+selected_dash+'&dashboard_name='+dashboard+'&view_name='+selected_view_name+"&fromServiceHomePage="+isFromHomePage+"&isFromZone="+isFromZone+"&iszoneName="+iszoneName+"&parentZone="+parentZone+"&firstTime=true&filter=service&serviceName="+encodeURIComponent(filterByParamFlag)+"&isFromServiceMenu="+isFromServiceMenu+"&isFromZoneMain="+isFromZoneMain+"&isFromZoneMenu="+isFromZoneMenu+"&isFromServiceGroup="+isFromServiceGroup+"&isCitrixComp=true&fromSerComboChange="+fromSerComboChange;
			

			if (typeof hasCitrix === "string"){
				if(hasCitrix == "true"){
					if(selected_CompType_st != null && selected_CompType_st !='' && selected_CompType_st != 'undefined' && selected_CompType_st != undefined)
						url += '&componentType='+selected_CompType_st;
					else if(((filter != null && filter.indexOf("Agg_") >= 0) || (requestParams.serviceCombo != null && requestParams.serviceCombo[0].selected.indexOf("Agg_") >= 0)) && isUserHaveDirector)
						url += '&componentType='+directorTypes;
				}
				else
				{
					if(selected_CompType_st != null && selected_CompType_st !='' && selected_CompType_st != 'undefined' && selected_CompType_st != undefined)
						url += '&componentType='+selected_CompType_st;
					else if(((filter != null && filter.indexOf("Agg_") >= 0) || (requestParams.serviceCombo != null && requestParams.serviceCombo[0].selected.indexOf("Agg_") >= 0)) && isUserHaveDirector)
						url += '&componentType='+directorTypes;	
				}
			}else{
				if(hasCitrix){
					if(selected_CompType_st != null && selected_CompType_st !='' && selected_CompType_st != 'undefined' && selected_CompType_st != undefined)
						url += '&componentType='+selected_CompType_st;
					else if(((filter != null && filter.indexOf("Agg_") >= 0) || (requestParams.serviceCombo != null && requestParams.serviceCombo[0].selected.indexOf("Agg_") >= 0)) && isUserHaveDirector)
						url += '&componentType='+directorTypes;
				}
				else
				{
					if(selected_CompType_st != null && selected_CompType_st !='' && selected_CompType_st != 'undefined' && selected_CompType_st != undefined)
						url += '&componentType='+selected_CompType_st;
					else if(((filter != null && filter.indexOf("Agg_") >= 0) || (requestParams.serviceCombo != null && requestParams.serviceCombo[0].selected.indexOf("Agg_") >= 0)) && isUserHaveDirector)
						url += '&componentType='+directorTypes;		
				}
			}
			
			metrics_containerObj.removeAll(true);
			metrics_containerObj.add({
				xtype:'metricscomponentlist',
				id:'metricscomponentlist_id',
				compTypeComboNeeded:compTypeComboFlag,
				margin:0,
				padding:0,
				metricsURL:url
			});
			metrics_containerObj.doLayout();
		}
		else if(!Ext.isEmpty(selected_view_name) && selected_view_name.trim() == "Systems_View")
		{
			selected_CompType_st ='';
			var selected_dash = '';
			if(!Ext.isEmpty(Ext.getCmp('dashListComId')) && Ext.getCmp('dashListComId')!=null && Ext.getCmp('dashListComId')!=undefined)
				selected_dash = Ext.getCmp('dashListComId').getValue();
			var systemView_containerObj = Ext.getCmp('systemViewMeasuresgridpanel');
			var urlt = systemView_containerObj.url;
			urlt += "&selectNode=Service$cap$"+encodeURIComponent(filterByParamFlag)+"&selectedParam="+encodeURIComponent(filterByParamFlag)+"&currentTab=Systems&isSite=true&aggregateTab=false&hasTransactions=true&hasEmulatedTransactions=false&fromHomepage=&hasLogonSimulations=true&refresh=true&action=Systems&topoSegment="+encodeURIComponent(filterByParamFlag)+'&isfromCitrix=true&iniName='+iniName+'&user_name='+user_name+'&dashboard_name='+dashboard+'&dashboard_mapping='+selected_dash+'&view_name='+selected_view_name+"&fromServiceHomePage="+isFromHomePage+"&fromSerComboChange="+fromSerComboChange+"&isFromZone="+isFromZone+"&iszoneName="+iszoneName+"&parentZone="+parentZone+"&filter=service&filterBy="+encodeURIComponent(filterByParamFlag)+"&isFromServiceMenu="+isFromServiceMenu+"&isFromZoneMain="+isFromZoneMain+"&isFromZoneMenu="+isFromZoneMenu+"&isFromServiceGroup="+isFromServiceGroup;

			if(selectedSystemCompType !=null && selectedSystemCompType != 'null' && selectedSystemCompType !='')
				urlt = urlt + "&componentType="+selectedSystemCompType;
			systemView_containerObj.loadTab(urlt,'servicesSys',Reftot,RefpageVal,ReftotalPageno);			
		}
		else if(!Ext.isEmpty(selected_view_name) && selected_view_name.trim() == "Aggregates_View")
		{
			selected_CompType_st ='';
			var selected_dash = '';
			if(!Ext.isEmpty(Ext.getCmp('dashListComId')) && Ext.getCmp('dashListComId')!=null && Ext.getCmp('dashListComId')!=undefined)
				selected_dash = Ext.getCmp('dashListComId').getValue();
			var aggView_containerObj = Ext.getCmp('systemViewAggregatesgridpanel');
			var urlt = aggView_containerObj.url;
			urlt += "&selectNode=Service$cap$"+encodeURIComponent(filterByParamFlag)+"&selectedParam="+encodeURIComponent(filterByParamFlag)+"&currentTab=Systems&isSite=true&aggregateTab=true&hasTransactions=true&hasEmulatedTransactions=false&fromHomepage=&hasLogonSimulations=true&refresh=true&action=Systems&topoSegment="+encodeURIComponent(filterByParamFlag)+'&isfromCitrix=true&iniName='+iniName+'&user_name='+user_name+'&dashboard_name='+dashboard+'&dashboard_mapping='+selected_dash+'&view_name='+selected_view_name+"&fromServiceHomePage="+isFromHomePage+"&fromSerComboChange="+fromSerComboChange+"&isFromZone="+isFromZone+"&iszoneName="+iszoneName+"&parentZone="+parentZone+"&filter=service&filterBy="+encodeURIComponent(filterByParamFlag)+"&isFromServiceMenu="+isFromServiceMenu+"&isFromZoneMain="+isFromZoneMain+"&isFromZoneMenu="+isFromZoneMenu+"&isFromServiceGroup="+isFromServiceGroup;
			//urlt += '&aggregateComp='+requestParams.aggregateComp;
			aggView_containerObj.loadTab(urlt,'servicesAgg');			
		}
		else if(!Ext.isEmpty(selected_view_name) && selected_view_name.trim() == "Web_Transaction_Sub_View" ){
			selected_CompType_st ='';
			var dashboard_view_container_gridObj = Ext.getCmp('dashboard_view_container_grid');	
			var dashboard_view_container_chartObj = Ext.getCmp('dashboard_view_container_chart');	
			var dashboard_view_header_idObj = Ext.getCmp('dashboard_view_header_id');
			if(!Ext.isEmpty(dashboard_view_container_gridObj))
				dashboard_view_container_gridObj.removeAll(true);
			if(!Ext.isEmpty(dashboard_view_container_chartObj))
				dashboard_view_container_chartObj.removeAll(true);
			if(!Ext.isEmpty(dashboard_view_header_idObj))
				dashboard_view_header_idObj.removeAll(true);
			if(!Ext.isEmpty(Ext.getCmp('tabBarHeader1')))
				Ext.getCmp('tabBarHeader1').removeAll(true);
			var selected_dash = '';
			if(!Ext.isEmpty(Ext.getCmp('dashListComId')) && Ext.getCmp('dashListComId')!=null && Ext.getCmp('dashListComId')!=undefined)
				selected_dash = Ext.getCmp('dashListComId').getValue();
			var d_url = '/final/monitor/transactions.jsp?treeTitle=services&1=1&&selectNode=Service$cap$'+encodeURIComponent(filterByParamFlag)+'&selectedParam='+encodeURIComponent(filterByParamFlag)+'&currentTab=transactions&isSite=true&aggregateTab=false&hasTransactions=true&hasEmulatedTransactions=false&fromHomepage=&hasLogonSimulations=true&site='+encodeURIComponent(filterByParamFlag)+'&isSite=true&serviceName='+encodeURIComponent(filterByParamFlag)+'&fromLzayer=false&selectNode='+encodeURIComponent(filterByParamFlag)+'&currentTab=transactions&transTab=true&from=null&treeOpen=false&openNode=Services&refresh=true&action=service&topoSegment='+encodeURIComponent(filterByParamFlag)+'&isfromCitrix=true&iniName='+iniName+'&user_name='+user_name+'&dashboard_mapping='+selected_dash+'&dashboard_name='+dashboard+'&view_name='+selected_view_name+"&fromServiceHomePage="+isFromHomePage+"&fromSerComboChange="+fromSerComboChange+"&isFromZone="+isFromZone+"&iszoneName="+iszoneName+"&parentZone="+parentZone+"&fromLogonTab=true";
			Ext.Ajax.request({
				  url : d_url,
				  timeout:280000,
				  //scope:this,
				  success: function(response){
					var jsonText = response.responseText;
					if(!Ext.isEmpty(jsonText))
					{
						var jsonData = Ext.decode(jsonText);
						//after refresh the tab value needs to be retained for layout of graphs
						 // if(!Ext.isEmpty(requestParams.selectedTab)){
						  /*if(!Ext.isEmpty(jsonData.HiddenFields.selectedTab)){
							  if(jsonData.HiddenFields.selectedTab=="EmulatedClients"){								 
								  this.tab="emulated";
							  }else{
								  this.tab="web";
							  }
						  }*/
						//this.loadTransaction(jsonData);
						//this.getTransactionsMainPanel().showTransactionGridPanel(jsonData.GridScreenLabels,jsonData);
						var screenLabels = jsonData.GridScreenLabels;
						var compType = jsonData.HiddenFields.compType;
						var compName = jsonData.HiddenFields.compName;
						var siteName = jsonData.HiddenFields.siteName;
						if(siteName!=null && siteName!=undefined)
							citrixDashboard.app.getController('Main').siteName=siteName;
						var isEmuEnabled = ( !Ext.isEmpty(screenLabels["emulBtnLabel"]) )?true:false;
						var isTransEnabled = ( !Ext.isEmpty(screenLabels["webBtnLabel"]) )?true:false;
						var isTabChanged = ( !Ext.isEmpty(jsonData['isTabChanged']) )?true:false;
						var isFromRefresh = ( !Ext.isEmpty(jsonData['fromRefresh']) )?true:false;
						var isLogonEnabled = jsonData.HiddenFields.isLogonSimul;
						var refreshing = jsonData.HiddenFields.Refreshing;
						var innerActiveTab = jsonData.HiddenFields.innerActiveTab;
						var graphParam = jsonData.HiddenFields.timelineParam;

						if(!Ext.isEmpty(jsonData.HiddenFields))
						{
							serviceRefSortByLogon = jsonData.HiddenFields.serviceRefSortByLogon;
							serviceRefSortByLogonType = jsonData.HiddenFields.serviceRefSortByLogonType;
							serviceRefSortByLogonId = jsonData.HiddenFields.serviceRefSortByLogonId;
						}

						/*var ComponentList = jsonData.ComponentList;
						var externalAgentsList = jsonData.externalAgents;
						var logonComponentList = jsonData.logonComponentList;
						var label='',selectedVal='',simLabel='',simulationSelectedVal='',simulationSelectedOrgValue = '';
						var defalutHide = false;
						var comboStore,simulationComboStore;

						if(!Ext.isEmpty(logonComponentList) && logonComponentList!=null && logonComponentList!=undefined)
						{
							simulationComboStore = Ext.create('Ext.data.Store',{
								fields:['value', 'name', 'comptype'],
								proxy:{
									type: 'memory',
									reader: {
										type: 'json',
										root:'options'
									}
								},
								data:logonComponentList
							});
							simLabel = logonComponentList.label;
							simulationSelectedVal = logonComponentList.selectedValue;
							simulationSelectedOrgValue = logonComponentList.selectedOrgValue;
						}
						if(!Ext.isEmpty(ComponentList) && ComponentList!=null && ComponentList!=undefined && (innerActiveTab == null || innerActiveTab == undefined || innerActiveTab == 'undefined')){
							comboStore = Ext.create('Ext.data.Store',{
								fields:['value', 'name', 'comptype'],
								proxy:{
									type: 'memory',
									reader: {
										type: 'json',
										root:'options'
									}
								},
								data:ComponentList
							});
							defalutHide = false;
							label = ComponentList.label;
							selectedVal = ComponentList.selectedValue;
						}
						else if(!Ext.isEmpty(externalAgentsList) && externalAgentsList!=null && externalAgentsList!=undefined && (innerActiveTab == 'logonSim' || (!isEmuEnabled && !isTransEnabled))){
							extAgentData = externalAgentsList;
							externalAgentsList = externalAgentsList[simulationSelectedVal];
							comboStore = Ext.create('Ext.data.Store',{
								fields:['value', 'name'],
								proxy:{
									type: 'memory',
									reader: {
										type: 'json',
										root:'options'
									}
								},
								data:externalAgentsList
							});
							defalutHide = false;
							label = extAgentData.label;
							selectedVal = externalAgentsList.selectedValue;
						}
						else
							defalutHide = true;*/
						
						var ComponentList = jsonData.ComponentList;
						var externalAgentsList = jsonData.externalAgents;
						var logonComponentList = jsonData.logonComponentList;
						var componentListObj = jsonData.componentListObj;
						var label='',selectedVal='',simLabel='',compLabel='',simulationSelectedVal='',compSelectedVal='',simulationSelectedOrgValue = '';
						var defalutHide = false;
						var isComponentType = true;
						var comboStore,simulationComboStore,compStroe;

						if(!Ext.isEmpty(componentListObj) && componentListObj!=null && componentListObj!=undefined && (innerActiveTab == 'logonSim' || (!isEmuEnabled && !isTransEnabled)))
						{
							isComponentType = false;
							compStroe = Ext.create('Ext.data.Store',{
								fields:['value', 'name', 'url'],
								proxy:{
									type: 'memory',
									reader: {
										type: 'json',
										root:'options'
									}
								},
								data:componentListObj
							});
							compLabel = componentListObj.label;
							compSelectedVal = componentListObj.selectedValue;
							selectedCompType =componentListObj.selectedValue;
						}

						
						if(!Ext.isEmpty(ComponentList) && ComponentList!=null && ComponentList!=undefined && (innerActiveTab == null || innerActiveTab == undefined || innerActiveTab == 'undefined')){
							comboStore = Ext.create('Ext.data.Store',{
								fields:['value', 'name', 'comptype'],
								proxy:{
									type: 'memory',
									reader: {
										type: 'json',
										root:'options'
									}
								},
								data:ComponentList
							});
							defalutHide = false;
							label = ComponentList.label;
							selectedVal = ComponentList.selectedValue;
							selectedCompTypeValue = ComponentList.selectedValue;
						}
						else if(!Ext.isEmpty(externalAgentsList) && externalAgentsList!=null && externalAgentsList!=undefined && (innerActiveTab == 'logonSim' || (!isEmuEnabled && !isTransEnabled))){
							extAgentData = externalAgentsList;
							//externalAgentsList = externalAgentsList[simulationSelectedVal];
							comboStore = Ext.create('Ext.data.Store',{
								fields:['value', 'name'],
								proxy:{
									type: 'memory',
									reader: {
										type: 'json',
										root:'options'
									}
								},
								data:externalAgentsList
							});
							defalutHide = false;
							label = extAgentData.label;
							selectedVal = externalAgentsList.selectedValue;
						}
						else
							defalutHide = true;
						
						if(!Ext.isEmpty(logonComponentList) && logonComponentList!=null && logonComponentList!=undefined)
						{
							logonComponentList = logonComponentList[selectedVal];
							simulationComboStore = Ext.create('Ext.data.Store',{
								fields:['value', 'name', 'comptype'],
								proxy:{
									type: 'memory',
									reader: {
										type: 'json',
										root:'options'
									}
								},
								data:logonComponentList
							});
							simLabel = logonComponentList.label;
							simulationSelectedVal = logonComponentList.selectedValue;
							simulationSelectedOrgValue = logonComponentList.selectedOrgValue;
						}
						
						var serviceState = "GOOD";
						serviceState=jsonData.GridScreenLabels.siteState;
						var simulationComboHide = true;
						if(!Ext.isEmpty(innerActiveTab) && innerActiveTab != null && innerActiveTab != undefined && innerActiveTab == 'logonSim')
							simulationComboHide = false;
						curViewTab = innerActiveTab;
						//dashboard_view_header_idObj.setTitle("USER EXPERIENCE - WEB TRANSACTIONS");
						dashboard_view_header_idObj.setTitle("USER EXPERIENCE - WEB TRANSACTIONS <img style='position: relative;left: 6px;top: 3px;' src='/final/images/clear.png' class='iconLayerstack mouse' data-qtip='Layer Model' onclick=\"DashboardToLayers('"+compName+"','"+compType+"','"+siteName+"','WebTransactions','"+selected_view_name+"','"+iniName+"','"+user_name+"','"+selected_dash+"')\" /> <img style='position: relative;left: 12px;top: 3px;' src='/final/images/clear.png' class='iconTopology mouse' data-qtip='Topology' onclick=\"loadView('Services_Topology_View')\"/>");
						dashboard_view_header_idObj.addTool(
						{
							xtype:'container',
							id:'tabBarHeader1',
							layout:{type:'hbox',align:'right'},
							margin:'10 0 0 0',
							style:{'float':'right'},
							items:[
							/*{
								xtype:'label',
								cls:"service20_"+serviceState,
								border:0,
								margin:'1 0 0 0'
							},{
								xtype:'label',
								margin:'2 0 0 0',
								html:'&nbsp;<span class="font_bold13 fontStyleRobot" >SITE :</span> <span style="margin-right:6px;" class="font_normal13 fontStyleRobot">'+screenLabels["Title"]+'</span>'		
							},
							{xtype:'tbseparator',height:21,style:{'width':'1px !important','background-position':'right top !important'}},
							{
								xtype:'button',
								tooltip:'Layer Model',
								style:{'border':'none'},
								margin:'3 0 0 0',
								cls:'iconLayerstack',
								handler: function() {
									//DashboardToLayers(compName,compType,siteName,'WebTransactions',selected_view_name);
									DashboardToLayers(compName,compType,siteName,'WebTransactions',selected_view_name,iniName,user_name,selected_dash);
								}
							},
							{xtype:'tbseparator',height:21,style:{'width':'1px !important','background-position':'right top !important'}},
							{
								xtype:'button',
								tooltip:'Topology',
								style:{'border':'none','top':'3px !important'},
								cls:'iconTopology',
								margin:'3 0 0 0',
								handler: function() {
									//DashboardToTopology();
									loadView('Services_Topology_View');
								}
							},*/
							{
								xtype:'combo',
								id:'simulationCombo',
								itemId:'simulationCombo',
								editable : false,
								margin:'0 0 0 10',
								width:290,
								hidden:simulationComboHide,
								store:simulationComboStore,
								cls : 'dropdown',
								displayField:'name',
								valueField:'value',
								trigerAction:'all',
								fieldLabel:''+simLabel,
								labelWidth:80,
								value:simulationSelectedVal,
								queryMode : 'local'
							},
							{
								xtype:'combo',
								id:'componentCombo',
								itemId:'componentCombo',
								editable : false,
								labelWidth:75,
								margin:'0 0 0 10',
								hidden:defalutHide,
								store:comboStore,
								cls : 'dropdown',
								width:290,
								displayField:'name',
								valueField:'value',
								trigerAction:'all',
								fieldLabel:''+label,
								value:selectedVal,
								queryMode : 'local',
								listeners:{
									'change':function(e){
										citrixDashboard.app.getController('Main').onComponentChange(this,'webTrans',siteName);
									}	
								}
							}
							]
							}
						);
						dashboard_view_container_gridObj.add([{
							xtype:'container',
							ui:'eg-container',
							margin:'0 0 0 0',
							padding:'0 10 10 10',
							items:[{
								xtype:'transactiongridpanel',
								ui:'newGridPanel',
								id:'transactiongridpanelid',
								//title:'<span class="font_bold12">Transactions</span>',
								//columnWidth:1.0,
								jsonData:jsonData,
								isEmuEnabled:isEmuEnabled,								
								//bodyPadding:10,
								id:'transGrid1',
								height:185,
								//flex:0.43,
								border:true
							}]
						
						}]);
						try
						{
							dashboard_view_container_chartObj.add([{
							xtype:'container',
							//ui:'eg-container',
							margin:'10 2 0 0',
							//padding:10,
							//height:220,
							items:[{
								xtype:'transactionschartpanel',
								id:'transactionschartpanelid',
								//height:500,
								//minHeight:250,
								//title:'Graphs',
								//columnWidth:1.0,
								jsonData:jsonData,
								padding:0,
								//flex:0.57,
								border:false,
								layout:{type:'fit'},
								//style:{'overflow':'auto'}
								
							}]
							}]);
							
						}
						catch (e1)
						{
						}
				   }
				  },
				failure:function(){
					//window.parent.location.href="/final/servlet/com.egurkha.Logout";
				}
			  });
		}
		else if(!Ext.isEmpty(selected_view_name) && selected_view_name.trim() == "Logon_Sub_View" ){
			selected_CompType_st ='';
			var dashboard_grid_containerObj = Ext.getCmp('dashboard_container_grid');	
			var dashboard_chart_containerObj = Ext.getCmp('dashboard_container_chart');	
			var dashboard_header_idObj = Ext.getCmp('dashboard_header_id');	
			if(!Ext.isEmpty(dashboard_grid_containerObj))
				dashboard_grid_containerObj.removeAll(true);
			if(!Ext.isEmpty(dashboard_chart_containerObj))
				dashboard_chart_containerObj.removeAll(true);
			if(!Ext.isEmpty(dashboard_header_idObj))
				dashboard_header_idObj.removeAll(true);
			if(!Ext.isEmpty(Ext.getCmp('tabBarHeader1')))
				Ext.getCmp('tabBarHeader1').removeAll(true);
			var selected_dash = '';
			if(!Ext.isEmpty(Ext.getCmp('dashListComId')) && Ext.getCmp('dashListComId')!=null && Ext.getCmp('dashListComId')!=undefined)
				selected_dash = Ext.getCmp('dashListComId').getValue();
			var d_url = '/final/monitor/transactions.jsp?treeTitle=services&selectNode=Service$cap$'+encodeURIComponent(filterByParamFlag)+'&selectedParam='+encodeURIComponent(filterByParamFlag)+'&currentTab=logon&isSite=false&aggregateTab=false&hasTransactions=false&hasEmulatedTransactions=false&fromHomepage=&hasLogonSimulations=true&site='+encodeURIComponent(filterByParamFlag)+'&isSite=true&serviceName='+encodeURIComponent(filterByParamFlag)+'&fromLayer=false&selectNode='+encodeURIComponent(filterByParamFlag)+'&currentTab=logon&transTab=true&from=null&treeOpen=false&openNode=Services&refresh=true&action=service&topoSegment='+encodeURIComponent(filterByParamFlag)+'&isfromCitrix=true&iniName='+iniName+'&user_name='+user_name+'&dashboard_mapping='+selected_dash+'&dashboard_name='+dashboard+'&view_name='+selected_view_name+"&fromServiceHomePage="+isFromHomePage+"&fromSerComboChange="+fromSerComboChange+"&isFromZone="+isFromZone+"&iszoneName="+iszoneName+"&parentZone="+parentZone+"&fromLogonTab=true";
			Ext.Ajax.request({
				url : d_url,
				timeout:280000,
				success: function(response){
					var jsonText = response.responseText;
					if(!Ext.isEmpty(jsonText))
					{
						var jsonData = Ext.decode(jsonText);
						var siteName = jsonData.HiddenFields.siteName;
						if(siteName!=null && siteName!=undefined)
							citrixDashboard.app.getController('Main').siteName=siteName;
						//after refresh the tab value needs to be retained for layout of graphs
						// if(!Ext.isEmpty(requestParams.selectedTab)){
						/*if(!Ext.isEmpty(jsonData.HiddenFields.selectedTab)){
						if(jsonData.HiddenFields.selectedTab=="EmulatedClients"){								 
						this.tab="emulated";
						}else{
						this.tab="web";
						}
						}*/
						//this.loadTransaction(jsonData);
						//this.getTransactionsMainPanel().showTransactionGridPanel(jsonData.GridScreenLabels,jsonData);
						var temLogonParam = jsonData.logonParam;
						var screenLabels = jsonData.GridScreenLabels;
						var compType = jsonData.HiddenFields.compType;
						var compName = jsonData.HiddenFields.compName;
						var siteName = jsonData.HiddenFields.siteName;
						var isEmuEnabled = ( !Ext.isEmpty(screenLabels["emulBtnLabel"]) )?true:false;
						var isTransEnabled = ( !Ext.isEmpty(screenLabels["webBtnLabel"]) )?true:false;
						var isTabChanged = ( !Ext.isEmpty(jsonData['isTabChanged']) )?true:false;
						var isFromRefresh = ( !Ext.isEmpty(jsonData['fromRefresh']) )?true:false;
						var isLogonEnabled = jsonData.HiddenFields.isLogonSimul;
						var refreshing = jsonData.HiddenFields.Refreshing;
						var innerActiveTab = jsonData.HiddenFields.innerActiveTab;
						//var graphParam = jsonData.HiddenFields.timelineParam;
						var graphParam = jsonData.HiddenFields.timelineParam;
						var timelineUrl = '';
						if(!Ext.isEmpty(graphParam) && graphParam != null && graphParam != undefined)
						{
							timelineUrl = '&mode='+graphParam.mode+'&time_line='+graphParam.time_line+'&starthr='+graphParam.starthr+'&endhr='+graphParam.endhr+'&starttime='+graphParam.starttime+'&endtime='+graphParam.endtime+'&startmin='+graphParam.startmin+'&endmin='+graphParam.endmin;
						}
						innerActiveTab = "logonSim";
						if(!Ext.isEmpty(jsonData.HiddenFields))
						{
						serviceRefSortByLogon = jsonData.HiddenFields.serviceRefSortByLogon;
						serviceRefSortByLogonType = jsonData.HiddenFields.serviceRefSortByLogonType;
						serviceRefSortByLogonId = jsonData.HiddenFields.serviceRefSortByLogonId;
						}

						/*var ComponentList = jsonData.ComponentList;
						var externalAgentsList = jsonData.externalAgents;
						var logonComponentList = jsonData.logonComponentList;
						var label='',selectedVal='',simLabel='',simulationSelectedVal='',simulationSelectedOrgValue = '';
						var defalutHide = false;
						var comboStore,simulationComboStore;
						if(!Ext.isEmpty(logonComponentList) && logonComponentList!=null && logonComponentList!=undefined)
						{
							simulationComboStore = Ext.create('Ext.data.Store',{
							fields:['value', 'name', 'comptype'],
							proxy:{
							type: 'memory',
							reader: {
							type: 'json',
							root:'options'
							}
							},
							data:logonComponentList
							});
							simLabel = logonComponentList.label;
							simulationSelectedVal = logonComponentList.selectedValue;
							simulationSelectedOrgValue = logonComponentList.selectedOrgValue;
						}
						if(!Ext.isEmpty(ComponentList) && ComponentList!=null && ComponentList!=undefined && (innerActiveTab == null || innerActiveTab == undefined || innerActiveTab == 'undefined')){
							comboStore = Ext.create('Ext.data.Store',{
							fields:['value', 'name', 'comptype'],
							proxy:{
							type: 'memory',
							reader: {
							type: 'json',
							root:'options'
							}
							},
							data:ComponentList
							});
							defalutHide = false;
							label = ComponentList.label;
							selectedVal = ComponentList.selectedValue;
						}
						else if(!Ext.isEmpty(externalAgentsList) && externalAgentsList!=null && externalAgentsList!=undefined && (innerActiveTab == 'logonSim' || (!isEmuEnabled && !isTransEnabled))){
							extAgentData = externalAgentsList;
							externalAgentsList = externalAgentsList[simulationSelectedVal];
							comboStore = Ext.create('Ext.data.Store',{
							fields:['value', 'name'],
							proxy:{
							type: 'memory',
							reader: {
							type: 'json',
							root:'options'
							}
							},
							data:externalAgentsList
							});
							defalutHide = false;
							label = extAgentData.label;
							selectedVal = externalAgentsList.selectedValue;
						}
						else
						defalutHide = true;*/

						var ComponentList = jsonData.ComponentList;
						var externalAgentsList = jsonData.externalAgents;
						var logonComponentList = jsonData.logonComponentList;
						var componentListObj = jsonData.componentListObj;
						var isSingleCompType = false;
						if(jsonData.componentListObj != null && jsonData.componentListObj['options'].length==1)
						{
							isSingleCompType = true;
							singleComponentTypeValue = jsonData.componentListObj['options'][0].value;
							singleComponentTypeName = jsonData.componentListObj['options'][0].name;
						}
						var label='',selectedVal='',simLabel='',compLabel='',simulationSelectedVal='',compSelectedVal='',simulationSelectedOrgValue = '';
						var defalutHide = false;
						var isComponentType = true;
						var comboStore,simulationComboStore,compStroe;

						if(!Ext.isEmpty(componentListObj) && componentListObj!=null && componentListObj!=undefined && (innerActiveTab == 'logonSim' || (!isEmuEnabled && !isTransEnabled)))
						{
							isComponentType = false;
							compStroe = Ext.create('Ext.data.Store',{
								fields:['value', 'name', 'url'],
								proxy:{
									type: 'memory',
									reader: {
										type: 'json',
										root:'options'
									}
								},
								data:componentListObj
							});
							compLabel = componentListObj.label;
							compSelectedVal = componentListObj.selectedValue;
							selectedCompType =componentListObj.selectedValue;
						}

						
						if(!Ext.isEmpty(ComponentList) && ComponentList!=null && ComponentList!=undefined && (innerActiveTab == null || innerActiveTab == undefined || innerActiveTab == 'undefined')){
							comboStore = Ext.create('Ext.data.Store',{
								fields:['value', 'name', 'comptype'],
								proxy:{
									type: 'memory',
									reader: {
										type: 'json',
										root:'options'
									}
								},
								data:ComponentList
							});
							defalutHide = false;
							label = ComponentList.label;
							selectedVal = ComponentList.selectedValue;
						}
						else if(!Ext.isEmpty(externalAgentsList) && externalAgentsList!=null && externalAgentsList!=undefined && (innerActiveTab == 'logonSim' || (!isEmuEnabled && !isTransEnabled))){
							extAgentData = externalAgentsList;
							//externalAgentsList = externalAgentsList[simulationSelectedVal];
							comboStore = Ext.create('Ext.data.Store',{
								fields:['value', 'name'],
								proxy:{
									type: 'memory',
									reader: {
										type: 'json',
										root:'options'
									}
								},
								data:externalAgentsList
							});
							defalutHide = false;
							label = extAgentData.label;
							selectedVal = externalAgentsList.selectedValue;
						}
						else
							defalutHide = true;
						
						if(!Ext.isEmpty(logonComponentList) && logonComponentList!=null && logonComponentList!=undefined)
						{
							extSimData = logonComponentList;
							logonComponentList = logonComponentList[selectedVal];
							simulationComboStore = Ext.create('Ext.data.Store',{
								fields:['value', 'name', 'comptype'],
								proxy:{
									type: 'memory',
									reader: {
										type: 'json',
										root:'options'
									}
								},
								data:logonComponentList
							});
							simLabel = logonComponentList.label;
							simulationSelectedVal = logonComponentList.selectedValue;
							simulationSelectedOrgValue = logonComponentList.selectedOrgValue;
						}
						if(isSingleCompType)
						{
							isComponentType = true;
						}
						var serviceState = "GOOD";
						serviceState=jsonData.GridScreenLabels.siteState;
						var simulationComboHide = true;
						if(!Ext.isEmpty(innerActiveTab) && innerActiveTab != null && innerActiveTab != undefined && innerActiveTab == 'logonSim')
						simulationComboHide = false;
						curViewTab = innerActiveTab;
						if(singleComponentTypeName != '' && singleComponentTypeName != null && singleComponentTypeName != undefined)
						{
							singleComponentTypeName = singleComponentTypeName.toUpperCase();
							dashboard_header_idObj.setTitle("USER EXPERIENCE - "+singleComponentTypeName+" <img style='position: relative;left: 6px;top: 3px;' src='/final/images/clear.png' class='iconLayerstack mouse' data-qtip='Layer Model' onclick=\"DashboardToLayers('"+compName+"','"+compType+"','"+siteName+"','logonSim','"+selected_view_name+"','"+iniName+"','"+user_name+"','"+selected_dash+"')\" /> <img style='position: relative;left: 12px;top: 3px;' src='/final/images/clear.png' class='iconTopology mouse' data-qtip='Topology' onclick=\"loadView('Services_Topology_View')\"/>");
						}
						else
						{
							dashboard_header_idObj.setTitle("USER EXPERIENCE - LOGON SIMULATIONS <img style='position: relative;left: 6px;top: 3px;' src='/final/images/clear.png' class='iconLayerstack mouse' data-qtip='Layer Model' onclick=\"DashboardToLayers('"+compName+"','"+compType+"','"+siteName+"','logonSim','"+selected_view_name+"','"+iniName+"','"+user_name+"','"+selected_dash+"')\" /> <img style='position: relative;left: 12px;top: 3px;' src='/final/images/clear.png' class='iconTopology mouse' data-qtip='Topology' onclick=\"loadView('Services_Topology_View')\"/>");
						}
						dashboard_grid_containerObj.removeAll(true);
						dashboard_header_idObj.addTool(
							{
								xtype:'container',
								id:'tabBarHeader1',
								layout:{type:'hbox',align:'right'},
								margin:'10 0 0 0',
								style:{'float':'right','border':'none !important'},
								items:[
								/*{
									xtype:'label',
									cls:"service20_"+serviceState,
									border:0,
									margin:'1 0 0 0'
								},{
									xtype:'label',
									margin:'2 0 0 0',
									html:'&nbsp;<span style="margin-right:6px;" class="font_normal13 fontStyleRobot">'+screenLabels["Title"]+'</span>'		
								},
								{xtype:'tbseparator',height:20,style:{'width':'1px !important','background-position':'right top !important'}},
								{
									xtype:'button',
									tooltip:'Layer Model',
									style:{'border':'none'},
									cls:'iconLayerstack',
									margin:'3 0 0 0',
									handler: function() {
										DashboardToLayers(compName,compType,siteName,'logonSim',selected_view_name,iniName,user_name,selected_dash);
									}
								},
								{xtype:'tbseparator',height:20,style:{'width':'1px !important','background-position':'right top !important'}},
								{
									xtype:'button',
									tooltip:'Topology',
									style:{'border':'none'},
									cls:'iconTopology',
									margin:'3 0 0 0',
									handler: function() {
										//DashboardToTopology();
										loadView('Services_Topology_View');
									}
								},*/
								{
									xtype:'combo',
									id:'compTypeCombo',
									itemId:'compTypeCombo',
									labelAlign : 'left',
									editable : false,
									store:compStroe,
									hidden:isComponentType,
									labelSeparator:'',
									cls : 'dropdown',
									displayField: 'name',
									valueField: 'value',
										url:'url',
									trigerAction:'all',
									fieldLabel:compLabel+':',
									labelWidth:100,
									width:290,
									queryMode: 'local',
									margin:'0 0 0 20',
									value:compSelectedVal,
									listeners:{
										'change':function(e){
											citrixDashboard.app.getController('Main').onComponentTypeChange(this,'logonSim',siteName,compSelectedVal,selected_view_name);
										}
									}
								},
								{
									xtype:'combo',
									id:'componentCombo',
									itemId:'componentCombo',
									editable : false,
									margin:'0 0 0 20',
									hidden:defalutHide,
									store:comboStore,
									cls : 'dropdown',
									width:290,
									displayField:'name',
									valueField:'value',
									trigerAction:'all',
									fieldLabel:''+label,
									labelWidth:100,
									value:selectedVal,
									queryMode : 'local',
									listeners:{
										'change':function(e){
											citrixDashboard.app.getController('Main').onComponentChange(this,'logonSim',siteName,simulationSelectedOrgValue,selected_view_name);
										}	
									}
								},
								{
									xtype:'combo',
									id:'simulationCombo',
									itemId:'simulationCombo',
									editable : false,
									margin:'0 0 0 20',
									width:270,
									hidden:simulationComboHide,
									store:simulationComboStore,
									cls : 'dropdown',
									displayField:'name',
									valueField:'value',
									trigerAction:'all',
									fieldLabel:''+simLabel,
									labelWidth:70,
									value:simulationSelectedVal,
									queryMode : 'local',
									listeners:{
										'change':function(e){
											citrixDashboard.app.getController('Main').onSimulationChange(this,'logonSim',siteName,simulationSelectedOrgValue,selected_view_name);
										}	
									}
								}
								
								]
							}
						);
						var selected_dash = '';
						if(!Ext.isEmpty(Ext.getCmp('dashListComId')) && Ext.getCmp('dashListComId')!=null && Ext.getCmp('dashListComId')!=undefined)
							selected_dash = Ext.getCmp('dashListComId').getValue();
						
						//if(siteName != null)
							//fromServiceDashboard = true;
						var simulationSelectedOrgValue1 = "";
						if(simulationSelectedOrgValue != null && simulationSelectedOrgValue.indexOf(":NULL") > -1)
							simulationSelectedOrgValue1 = simulationSelectedOrgValue.substring(0,simulationSelectedOrgValue.indexOf(":NULL"));
						else
							simulationSelectedOrgValue1 = simulationSelectedOrgValue;
						var perf_url = "/final/monitor/comparisonLogonSimulator.jsp?"+logonParam+"&componentType=&selectedState=&subFilter=&simulationName="+simulationSelectedOrgValue1+"&externalAgent="+selectedVal+"&isfromCitrix=true&iniName="+iniName+"&user_name="+user_name+"&dashboard_mapping="+selected_dash+"&dashboard_name="+dashboard+"&view_name="+selected_view_name+"&fromServiceDashboard="+fromServiceDashboard+"&servicename="+siteName+"&fromSerComboChange="+fromSerComboChange+"&fromServiceHomePage="+isFromHomePage+"&isFromZone="+isFromZone+"&iszoneName="+iszoneName+"&parentZone="+parentZone+"&isLogonType=true&filter=service&filterBy="+encodeURIComponent(filterByParamFlag)+"&isFromServiceMenu="+isFromServiceMenu+"&isFromZoneMain="+isFromZoneMain+"&isFromZoneMenu="+isFromZoneMenu+"&isFromServiceGroup="+isFromServiceGroup;
						
						if(temLogonParam != null && temLogonParam!="")
						{
							perf_url = "/final/monitor/comparisonLogonSimulator.jsp?"+temLogonParam+"&componentType=&selectedState=&subFilter=&simulationName="+simulationSelectedOrgValue1+"&externalAgent="+selectedVal+"&isfromCitrix=true&iniName="+iniName+"&user_name="+user_name+"&dashboard_mapping="+selected_dash+"&dashboard_name="+dashboard+"&view_name="+selected_view_name+"&fromServiceDashboard="+fromServiceDashboard+"&servicename="+siteName+"&fromSerComboChange="+fromSerComboChange+"&fromServiceHomePage="+isFromHomePage+"&isFromZone="+isFromZone+"&iszoneName="+iszoneName+"&parentZone="+parentZone+"&componentNameService="+simulationSelectedOrgValue+"&isLogonType=true&filter=service&filterBy="+encodeURIComponent(filterByParamFlag)+"&isFromServiceMenu="+isFromServiceMenu+"&isFromZoneMain="+isFromZoneMain+"&isFromZoneMenu="+isFromZoneMenu+"&isFromServiceGroup="+isFromServiceGroup;
						
						}
						var transurl = "/final/monitor/simulationGraph.jsp?treeTitle=services&site=NULL&mHost="+selectedVal+"&simulationName="+simulationSelectedOrgValue1+"&componentNameService="+simulationSelectedOrgValue;
						
						Ext.Ajax.request({
							url : transurl,
							scope:this,
							success: function(response){
								var jsonText = response.responseText;
								//var panelArr = new Array();
								if(!Ext.isEmpty(jsonText))
								{
									var jsondata1 = Ext.decode(jsonText);
									if(jsondata1 != null && jsondata1 != undefined)
									{
										var css_class='gridHeadercenter iconGrid';
										if(!Ext.isEmpty(logon_treeTitle) && logon_treeTitle=='ExtTestDashboard')
											css_class='gridHeadercenter';
										dashboard_grid_containerObj.add({
											xtype:'generalMeasuresGridPanel',
											plugins:Ext.create('Ext.ux.AutoColumnWithLockingPlugin'),
											//title:titlesys,
											//title:perf_disp_name+" --Man At Work--",
											cls:css_class,
											//itemId:itemIdforsysandcom,
											itemId:'logonSimualtion',
											searchBoxCombo:false,
											margin:0,
											padding:3,
											id:'perPanel',
											height:185,
											frame:false,
											border:true,
											layout:{type:'vbox',align:'stretch'},
											flex:1,
											screenLabelPath:"monitor.Dashboard",
											url:perf_url,
											listeners: {
												'afterrender': function (obj) {
													this.loadTab(obj.url,null,null,null,null,true,'citrixDashBoard');
												}
											}
										});
										//panelArr.push({
										dashboard_chart_containerObj.add({
											xtype:'transactionschartpanel',
											id:'transactionschartpanelid',
											//animCollapse:true,
											//columnWidth:1.0,
											//height:255,
											height:(Ext.getBody().getViewSize().height-280),
											//flex:1,
											jsonData:jsondata1,
											//minHeight:265,
											margin:'10 1 0 0',
											//margin:'5 0 0 0',
											padding:0,
											//flex:0.57,
											border:false,
											isNotAreaChart:false
										});
									
										//curViewPort.add(panelArr);
										//curViewPort.doLayout();
									}
								}
							  },
							failure:function(){
								//window.parent.location.href="/final/servlet/com.egurkha.Logout";
							}
						});
					}
				},
				failure:function(){
					//window.parent.location.href="/final/servlet/com.egurkha.Logout";
				}
			});
		}
		else if(!Ext.isEmpty(selected_view_name) && selected_view_name.trim() == "Emulated_Transaction_Sub_View" ){
			selected_CompType_st ='';
			var dashboard_header_idObj = Ext.getCmp('dashboard_header_id_Emu');	
			var selected_dash = '';
			if(!Ext.isEmpty(Ext.getCmp('dashListComId')) && Ext.getCmp('dashListComId')!=null && Ext.getCmp('dashListComId')!=undefined)
				selected_dash = Ext.getCmp('dashListComId').getValue();
			var d_url = '/final/monitor/transactions.jsp?treeTitle=services&1=1&&selectNode=Service$cap$'+encodeURIComponent(filterByParamFlag)+'&selectedParam='+encodeURIComponent(filterByParamFlag)+'&currentTab=transactions&isSite=false&aggregateTab=false&hasTransactions=false&hasEmulatedTransactions=true&fromHomepage=&hasLogonSimulations=false&site='+encodeURIComponent(filterByParamFlag)+'&isSite=true&serviceName='+encodeURIComponent(filterByParamFlag)+'&fromLayer=false&selectNode='+encodeURIComponent(filterByParamFlag)+'&selectedParam='+encodeURIComponent(filterByParamFlag)+'&currentTab=transactions&transTab=true&from=null&treeOpen=false&openNode=Services&refresh=true&action=service&topoSegment='+encodeURIComponent(filterByParamFlag)+'&isfromCitrix=true&iniName='+iniName+'&user_name='+user_name+'&dashboard_mapping='+selected_dash+'&dashboard_name='+dashboard+'&view_name='+selected_view_name+"&fromServiceHomePage="+isFromHomePage+"&fromSerComboChange="+fromSerComboChange+"&isFromZone="+isFromZone+"&iszoneName="+iszoneName+"&parentZone="+parentZone+"&fromLogonTab=true";

			Ext.Ajax.request({
				url : d_url,
				timeout:280000,
				success: function(response){
					var jsonText = response.responseText;
					if(!Ext.isEmpty(jsonText))
					{
						var jsonData = Ext.decode(jsonText);
						this.siteName = jsonData.HiddenFields.siteName;
						var screenLabels = jsonData.GridScreenLabels;
						var compType = jsonData.HiddenFields.compType;
						var compName = jsonData.HiddenFields.compName;
						var isWebTrans = jsonData.HiddenFields.isWebTrans;
						var siteName = jsonData.HiddenFields.siteName;

						if(siteName!=null && siteName!=undefined)
							citrixDashboard.app.getController('Main').siteName=siteName;

						var siteBasedWeb = "NULL";
						if(isWebTrans=='true')
						 siteBasedWeb = filterByParamFlag;
						
						if(sesCombo != null && sesCombo != undefined && sesCombo != 'null' )
							compName=sesCombo;

						dashboard_header_idObj.setTitle("<div style=position:relative;top:-4px;><span>"+webAppSimulation+"</sapn> <img style='position: relative;left: 6px;top: 4px;' src='/final/images/clear.png' onclick=\"DashboardToLayers('"+compName+"','"+compType+"','"+siteName+"','emulated','"+selected_view_name+"','"+iniName+"','"+user_name+"','"+selected_dash+"')\" class='iconLayerstack mouse' data-qtip='Layer Model'/> <img style='position: relative;left: 12px;top: 4px;' src='/final/images/clear.png' class='iconTopology mouse' data-qtip='Topology' onclick=\"loadView('Services_Topology_View')\"/></div>");
						//Ext.get('sessionSimTopology').dom.src="/final/monitor/sessionSimulation.jsp";
						Ext.get('sessionSimTopology').dom.src="/final/monitor/sessionSimulation.jsp?scriptName="+selectedScript+"&site="+siteName+"&dashboard_name="+dashboard+"&compName="+compName+"&site="+siteBasedWeb+"&compType="+compType+"&serviceName="+filterByParamFlag+"&iniName="+iniName+"&user_name="+user_name+"&dashboard_mapping="+selected_dash+"&view_name="+selected_view_name+"&fromServiceHomePage="+isFromHomePage+"&fromSerComboChange="+fromSerComboChange+"&isFromZone="+isFromZone+"&iszoneName="+iszoneName+"&parentZone="+parentZone+"&isCitrix=true";	
						//Ext.get('sessionSimTopology').dom.src="/final/monitor/sessionSimulation.jsp?compName="+compName+"&site=NULL&compType="+compType;	
						}
					}
				});
		}
			
		Ext.Ajax.request({
			url : url,
			method : 'POST',
			scope:this,
			timeout:280000,
			success : function(response, opts)
			{
				var jsonText = response.responseText;
				var noWidgets=true;
				if(jsonText!=null && jsonText!=undefined)
				{
					var jsonData = Ext.decode(jsonText);

					if(jsonData!=null && jsonData!=undefined)
					{
						if(jsonData.loadViewDetails!=null && jsonData.loadViewDetails!=undefined)
						{
							var panelDataArr=jsonData.loadViewDetails;
							if(panelDataArr!=null && panelDataArr!=undefined && panelDataArr.length>0)
							{
								if(!Ext.isEmpty(selected_view_name) && selected_view_name.trim() == "Applications_View")
								{
									selected_CompType_st ='';
									var appBlock_1_Title=panelDataArr[0];
									var appBlock_1_Value=panelDataArr[1];
									var appBlock_2_Title=panelDataArr[2];
									var appBlock_2_Value=panelDataArr[3];
									var appBlock_3_Value=panelDataArr[4];

									if(!Ext.isEmpty(panelDataArr[0]) && panelDataArr[0]!=undefined)
									{
										var appidObj = Ext.getCmp('app_id');
										appidObj.setTitle(panelDataArr[0].Application_Block_1_Title);
									}

									if(!Ext.isEmpty(panelDataArr[1]) && panelDataArr[1]!=undefined)
									{
										var overviewdetailsObj = Ext.getCmp('overviewdetails_id');
										overviewdetailsObj.add({
											xtype:'overviewpanel',
											id:'app_overviewpanel_id',
											jsonData:panelDataArr[1].Application_Block_1_Value,
											ifApp:true,
											height:140,
										});
									}

									if(!Ext.isEmpty(panelDataArr[2]) && panelDataArr[2]!=undefined)
									{
										var topAppidObj = Ext.getCmp('top_app_id');
										topAppidObj.setTitle(panelDataArr[2].Application_Block_2_Title);
									}

									if((!Ext.isEmpty(panelDataArr[3]) && panelDataArr[3]!=undefined) || (!Ext.isEmpty(panelDataArr[4]) && panelDataArr[4]!=undefined))
									{
										var app_chartObj = Ext.getCmp('app_chart_id');
										app_chartObj.removeCls("eg-container");
										app_chartObj.getEl().dom.style.margin="0px 0px 0px 0px";

										app_chartObj.removeAll(true);
										app_chartObj.add({
											xtype:'chartparentpanel',
											id:'multBarIns',
											//legendPosition: 'top',
											//chartType:panelDataArr[3].Application_Block_2_Value.result.chartType,
											data:panelDataArr[3].Application_Block_2_Value,
											flex:1,
											//height:500
											//width:'100%',
											//data:panelDataArr[3].Application_Block_2_Value.result
											//data:panelDataArr[3].Application_Block_2.result
											//html:'<table><tr><td>'+overviewData[0]['chart']+'</td></tr></table>'
										});
										app_chartObj.doLayout();
									}

									if(!Ext.isEmpty(panelDataArr[4]) && panelDataArr[4]!=undefined)
									{
										var grid_idObj = Ext.getCmp('grid_id');
										grid_idObj.removeAll(true);
										grid_idObj.add({
											xtype:'commongrid',
											width:'100%',
											//id:'asdasdf',
											id:'gridInst',
											data:panelDataArr[4].Application_Block_3_Value[0]
										});
										grid_idObj.doLayout();
									}
								}
								else if(!Ext.isEmpty(selected_view_name) && selected_view_name.trim() == "Resources_View")
								{
									selected_CompType_st ='';
									if(!Ext.isEmpty(this.getResources()) && this.getResources()!=undefined)
									{
										this.getResources().currUrl=resources_url;
									}

									if(!Ext.isEmpty(panelDataArr[0]) && panelDataArr[0]!=undefined)
									{
										var residObj = Ext.getCmp('res_first_header_id');
										residObj.setTitle(panelDataArr[0].Resources_Block_1_Title);
									}
									if(!Ext.isEmpty(panelDataArr[1]) && panelDataArr[1]!=undefined)
									{
										var resOverviewObj = Ext.getCmp('res_overview_id');
										resOverviewObj.add({
											xtype:'overviewpanel',
											id:'res_overviewpanel_id',
											jsonData:panelDataArr[1].Resources_Block_1_Value,
											key:'res',
										});
									}
									if(!Ext.isEmpty(panelDataArr[2]) && panelDataArr[2]!=undefined)
									{
										var topResidObj = Ext.getCmp('res_user_header_id');
										topResidObj.setTitle(panelDataArr[2].Resources_Block_2_Title);
									}
									
									if((!Ext.isEmpty(panelDataArr[3]) && panelDataArr[3]!=undefined))
									{
										var res_chartObj = Ext.getCmp('res_user_header_id');
										res_chartObj.removeAll(true);
										res_chartObj.add({
											xtype:'chartparentpanel',
											id:'multBarIns_user',
											ifRes:true,
											//legendPosition: 'top',
											//chartType:panelDataArr[3].Application_Block_2_Value.result.chartType,
											data:panelDataArr[3].Resources_Block_2_Value,
											orgData:panelDataArr[3].Resources_Block_2_Value,
											ifRes:true,
											flex:1,
											//height:500
											//width:'100%',
											//data:panelDataArr[3].Application_Block_2_Value.result
											//data:panelDataArr[3].Application_Block_2.result
											//html:'<table><tr><td>'+overviewData[0]['chart']+'</td></tr></table>'
										});
										res_chartObj.doLayout();
									}

									if(!Ext.isEmpty(panelDataArr[4]) && panelDataArr[4]!=undefined)
									{
										var topResidObj = Ext.getCmp('res_app_header_id');
										topResidObj.setTitle(panelDataArr[4].Resources_Block_3_Title);
									}

									if((!Ext.isEmpty(panelDataArr[5]) && panelDataArr[5]!=undefined))
									{
										var res_chartObj = Ext.getCmp('res_app_header_id');
										res_chartObj.removeAll(true);
										res_chartObj.add({
											xtype:'chartparentpanel',
											id:'multBarIns_app',
											ifRes:true,
											//legendPosition: 'top',
											//chartType:panelDataArr[3].Application_Block_2_Value.result.chartType,
											data:panelDataArr[5].Resources_Block_3_Value,
											orgData:panelDataArr[5].Resources_Block_3_Value,
											flex:1,
											//height:500
											//width:'100%',
											//data:panelDataArr[3].Application_Block_2_Value.result
											//data:panelDataArr[3].Application_Block_2.result
											//html:'<table><tr><td>'+overviewData[0]['chart']+'</td></tr></table>'
										});
										res_chartObj.doLayout();
									}
									
									if(!Ext.isEmpty(panelDataArr[6]) && panelDataArr[6]!=undefined)
									{
										var topResidObj = Ext.getCmp('res_server_header_id');
										topResidObj.setTitle(panelDataArr[6].Resources_Block_4_Title);
									}

									if((!Ext.isEmpty(panelDataArr[7]) && panelDataArr[7]!=undefined))
									{
										var res_chartObj = Ext.getCmp('res_server_header_id');
										res_chartObj.removeAll(true);
										res_chartObj.add({
											xtype:'chartparentpanel',
											id:'multBarIns_server',
											ifRes:true,
											//legendPosition: 'top',
											//chartType:panelDataArr[3].Application_Block_2_Value.result.chartType,
											data:panelDataArr[7].Resources_Block_4_Value,
											orgData:panelDataArr[7].Resources_Block_4_Value,
											flex:1,
											//height:500
											//width:'100%',
											//data:panelDataArr[3].Application_Block_2_Value.result
											//data:panelDataArr[3].Application_Block_2.result
											//html:'<table><tr><td>'+overviewData[0]['chart']+'</td></tr></table>'
										});
										res_chartObj.doLayout();
									}
								}
								else if(!Ext.isEmpty(selected_view_name) && selected_view_name.trim() == "Geo_View")
								{
									selected_CompType_st ='';
									if(!Ext.isEmpty(panelDataArr[0]) && panelDataArr[0]!=undefined)
									{
										var geoidObj = Ext.getCmp('geo_first_header_id');
										geoidObj.setTitle(panelDataArr[0].Geo_Block_1_Title);
									}

									if(!Ext.isEmpty(panelDataArr[1]) && panelDataArr[1]!=undefined)
									{
										var geoOverviewObj = Ext.getCmp('geo_overview_id');
										geoOverviewObj.add({
											xtype:'overviewpanel',
											id:'geo_overviewpanel_id',
											jsonData:panelDataArr[1].Geo_Block_1_Value,
											key:'geo',
										});
									}

									if(!Ext.isEmpty(panelDataArr[2]) && panelDataArr[2]!=undefined)
									{
										var geoMapObj = Ext.getCmp('geo_map_id');

										var countryComboObj = Ext.getCmp('countryComboId');
										if(!Ext.isEmpty(countryComboObj) && countryComboObj!=undefined)
										{
											if(panelDataArr[2].Geo_Block_2_Value[0].resultArray != null && panelDataArr[2].Geo_Block_2_Value[0].resultArray.length > 0)
											{												
												countryComboObj.show();
												countryComboObj.getStore().loadRawData(panelDataArr[2].Geo_Block_2_Value[0].countryArray);

												if(isFromUED || isFromUED == 'true')
												{
													if(isCountryRequestNeeded)
													{
														Ext.Ajax.request({
															url : cnt_url,
															method : 'POST',
															scope:this,
															timeout:280000,
															success : function(res, opts)
															{
																var _jsonText = res.responseText;
																if(_jsonText!=null && _jsonText!=undefined)
																{
																	var _jsonData = Ext.decode(_jsonText);
																	if(_jsonData!=null && _jsonData!=undefined)
																	{
																		var _panelDataArr=_jsonData.loadViewDetails;

																		countryComboObj.getStore().loadRawData(_panelDataArr[2].Geo_Block_2_Value[0].countryArray);

																		if(isRegionRequestNeeded && countryCode!=null && countryCode!=undefined && countryCode!="")
																		{
																			countryComboObj.setValue(countryCode);
																		}
																		else
																		{
																			countryComboObj.setValue(filterName);
																		}
																	}
																}
															}
														});
													}
													else
													{
														countryComboObj.setValue(filterName);
													}

													var regionComboObj = Ext.getCmp('regionComboId');
													if(isRegionRequestNeeded)
													{
														Ext.Ajax.request({
															url : reg_url,
															method : 'POST',
															scope:this,
															timeout:280000,
															success : function(res, opts)
															{
																var _jsonTextReg = res.responseText;
																if(_jsonTextReg!=null && _jsonTextReg!=undefined)
																{
																	var _jsonDataReg = Ext.decode(_jsonTextReg);
																	if(_jsonDataReg!=null && _jsonDataReg!=undefined)
																	{
																		var _panelDataArrReg=_jsonDataReg.loadViewDetails;

																		//if(filterViewName!=null && filterViewName!=undefined && filterViewName=='Geo_Country_View')
																		{
																			if(!Ext.isEmpty(regionComboObj) && regionComboObj!=undefined)
																			{
																				regionComboObj.show();

																				regionComboObj.getStore().loadRawData(_panelDataArrReg[2].Geo_Block_2_Value[0].regionArray);

																				regionComboObj.setValue(regionName);
																			}
																		}
																	}
																}
															}
														});
													}
													else
													{
														if(filterName!=null && filterName!=undefined && filterName!='World')
														{
															if(!Ext.isEmpty(regionComboObj) && regionComboObj!=undefined)
															{
																regionComboObj.show();

																regionComboObj.getStore().loadRawData(panelDataArr[2].Geo_Block_2_Value[0].regionArray);
																regionComboObj.setValue(panelDataArr[2].Geo_Block_2_Value[0].selectedRegion);
															}
														}
													}
												}
												else
													countryComboObj.setValue(panelDataArr[2].Geo_Block_2_Value[0].selectedCountry);
											}																						
										}

										if(isFromForce)
										{
											var countryComboObj = Ext.getCmp('countryComboId');
											if(!Ext.isEmpty(countryComboObj) && countryComboObj!=undefined)
											{
												countryComboObj.show();
												countryComboObj.getStore().loadRawData(menuObj.cnCombo);
											}

											var regionComboObj = Ext.getCmp('regionComboId');
											if(!Ext.isEmpty(regionComboObj) && regionComboObj!=undefined)
											{
												regionComboObj.show();

												regionComboObj.getStore().loadRawData(panelDataArr[2].Geo_Block_2_Value[0].regionArray);
												regionComboObj.setValue(panelDataArr[2].Geo_Block_2_Value[0].selectedRegion);
											}
										}

										Ext.getCmp('geo_map_conainer_id').hide();
										if(panelDataArr[2].Geo_Block_2_Value[0].resultArray != null && panelDataArr[2].Geo_Block_2_Value[0].resultArray.length > 0)
										{
											Ext.getCmp('geo_map_conainer_id').show();
											geoMapObj.add({
												xtype:'geopanel',
												id:'geo_id_map',
												//style:{'border':'1px solid blue'},
												//jsonData:JsonMapData,
												jsonData:panelDataArr[2].Geo_Block_2_Value[0],
												height:347,
												mapStyle:strRumSkin == "Dark"?'dark':'light', //light,dark,default
												mapType:'styled_map',  //'roadmap', 'satellite', 'hybrid', 'terrain', 'styled_map',
												center: {
													lat: 40.3780, // Marker latitude
													lng:10.4359 // Marker longitude
												},
												infoBoxArray:[],
												markerArray:[],
												feauturesArray:[],
												stateArray:[],
												selectedView:selected_view_name
											});
										}								

										/*var geoMapDetailsObj = Ext.getCmp('geo_mapdetails_id');
										//geoMapDetailsObj.jsonData=panelDataArr[2].Geo_Block_2_Value;
										//geoMapDetailsObj.updateData(panelDataArr[2].Geo_Block_2_Value);
										geoMapDetailsObj.add({
											xtype:'geomapdetails',
											id:'geo_id_mapdetails',
											jsonData:panelDataArr[2].Geo_Block_2_Value[0],
											//jsonData1:JsonMapData1
										});*/											
									}									

									if(!Ext.isEmpty(panelDataArr[3]) && panelDataArr[3]!=undefined)
									{
										//var geoidObj = Ext.getCmp('geo_first_header_id');
										//geoidObj.setTitle(panelDataArr[3].Geo_Block_1_Title);
									}

									if(!Ext.isEmpty(panelDataArr[4]) && panelDataArr[4]!=undefined)
									{
										var geo_alerts3x1Obj = Ext.getCmp('geo_alerts3x1_id');

										/*geo_alerts3x1Obj.add({
											xtype:'overviewverticalpanel',
											id:'geo_overviewpanel3x1_alert_id',
											margin:0,
											padding:'0 0 0 0',
											ifGeo:true,
											flex:1,
											//jsonData:panelDataArr[4].Geo_Block_3_Value,
											//jsonData:tmpPanelArrays2,
											jsonData:panelDataArr[4].Geo_Block_3_Value,
											key:'geo3x1',
										});*/
										if(panelDataArr[2].Geo_Block_2_Value[0].resultArray != null && panelDataArr[2].Geo_Block_2_Value[0].resultArray.length > 0)
										{
											geo_alerts3x1Obj.add({
												xtype:'overviewctxpanel',
												id:'geo_overviewpanel3x1_alert_id',
												jsonData:panelDataArr[4].Geo_Block_3_Value,
												//jsonData:tmpPanelArrays2,
												key:'overview',
												layout:{
													type:'vbox',
													align:'stretch'
												}
											});
										}
										else
										{
											var geoextraInsObj = Ext.getCmp('geoextraIns');
											geoextraInsObj.removeAll(true);
											//Ext.getCmp('geo_map_parent_conainer_id').setHeight(300);
											Ext.getCmp('geo_map_parent_conainer_id').setHeight(0);
											geoextraInsObj.add({
												xtype:'panel',
												margin:'10px 0px -17px 0px',
												defaults:{
													columnWidth: 0.5,
													height: 180
												},
												layout:'column',
												manageOverflow:2,
												items:[
												{
													xtype:'panel',
													ui: 'eg-x-panel',
													height:180,
													columnWidth:0.5,
													margin: '0 10 10 0',
													bodyPadding: '10 10 10 10',
													layout: {
														type: 'vbox',
														align: 'stretch'
													},
													listeners:
													{
														'afterrender':function(e)
														{
															var me = this;
															var data = panelDataArr[4].Geo_Block_3_Value;
															if(data != undefined && data != null && data.length > 0)
															{
																var obj = data[0];
																var chart_type = obj['chart'];
																if(chart_type == undefined)
																	chart_type= obj['type'];
																if(chart_type != undefined && chart_type.toLowerCase() == 'tierhealth')
																{
																	var id=chart_type+'_0_overviewextra';
																	me.add({
																		xtype:'panel',
																		margin:'0px 0px 15px 0px',
																		cls:'widgetBottomBorder',
																		//flex:1,
																		minHeight:180,
																		//cls:'widgetcon',
																		//title:obj.title,
																		autoDestroy:false,
																		items:[
																		{
																			xtype:'tierhealth',
																			id:id,
																			jsonData:obj,
																			data:obj,
																			key:'overview',
																		}
																		]
																	});
																}
																else if(chart_type != undefined && chart_type.toLowerCase() == 'donut' )
																{
																	var id=chart_type+'_0_overviewextra';
																	try
																	{
																		//var donutPanel = this.getDonutPanel(obj,id);
																		me.add({
																			xtype:'panel',
																			margin:'0px 0px 0px 0px',
																			//flex:1.5,
																			//minWidth:230,
																			height:180,
																			style:{'border':'0px solid blue !important'},
																			cls:'widgetcon',
																			autoDestroy:true,
																			items:[
																			{
																				xtype:'donutalert',
																				ifXtra:true,
																				data:obj,
																				id:id,
																				num:id+'1'
																			}]
																		});		
																	}
																	catch (eert)
																	{							
																	}
																}
															}															
														}
													}
												},
												{
													xtype:'panel',
													ui: 'eg-x-panel',
													height:180,
													columnWidth:0.5,
													margin: '0 1 10 0',
													bodyPadding: '10 10 10 10',
													layout: {
														type: 'vbox',
														align: 'stretch'
													},
													listeners:
													{
														'afterrender':function(e)
														{
															var me = this;
															var data = panelDataArr[4].Geo_Block_3_Value;
															if(data != undefined && data != null && data.length > 0)
															{
																var obj = data[1];
																var chart_type = obj['chart'];
																if(chart_type == undefined)
																	chart_type= obj['type'];
																
																if(chart_type != undefined && chart_type == 'Gauge' ){
																	var chartdata1 = obj.data;
																	me.add(
																	{
																		xtype:'container',
																		//title:'dummytitle',
																		baseCls:'panelHeader',
																		cls:'font_normal15 fontStyleRobot',
																		//title:obj.heading,
																		html:obj.heading,
																		padding:'0px 0px 0px 0px',
																		style:{'border':'0px solid grey;float:left'},
																		minHeight:20
																	}
																	);
																	if(chartdata1 != undefined && chartdata1 != null){
																		var graphtextPanel1 = citrixDashboard.app.getView("Main").getGroupPanelArray(chartdata1,null,null,me,obj.heading);
																		me.add(graphtextPanel1);							
																	}
																}
																else if(chart_type != undefined && chart_type == 'GraphText' )
																{						
																	var chartdata1 = obj.data;
																	me.add(
																	{
																		xtype:'container',
																		baseCls:'panelHeader',
																		cls:'font_normal15 fontStyleRobot',
																		html:'<span>'+obj.heading+'</span><span style="float:right" class="font_bold9 grayColor">'+obj.timeline+'</span>',
																		padding:'0px 0px 0px 0px',
																		style:{'border':'0px solid grey;float:left'},
																		minHeight:20
																	}
																	);
																	if(chartdata1 != undefined && chartdata1 != null){
																		var graphtextPanel1 = citrixDashboard.app.getController("Main").getGroupPanelArray(chartdata1,null,null,me,obj.heading);
																		me.add(graphtextPanel1);							
																	}
																}
															}
														}
													}
												}
												]
											});
										}
										
									}

									if((!Ext.isEmpty(panelDataArr[5]) && panelDataArr[5]!=undefined))
									{
										var geoBarInsObj = Ext.getCmp('geoBarIns');
										geoBarInsObj.removeAll(true);

										geoBarInsObj.add({
											xtype:'chartparentpanel',
											id:'multBarIns_geo',
											//style:{'border':'1px solid red'},
											bodyPadding:0,
											margin:0,
											//legendPosition: 'top',
											//chartType:panelDataArr[3].Application_Block_2_Value.result.chartType,
											data:panelDataArr[5].Geo_Block_4_Value,
											flex:1,
											//height:500
											//width:'100%',
											//data:panelDataArr[3].Application_Block_2_Value.result
											//data:panelDataArr[3].Application_Block_2.result
											//html:'<table><tr><td>'+overviewData[0]['chart']+'</td></tr></table>'
										});
										geoBarInsObj.doLayout();
									}

									try
									{
										if(isFromUED || isFromUED == 'true')
										{
											Ext.defer(function(){
												try{
													var regionObj = Ext.getCmp('region_icon');
													var regionlblObj = Ext.getCmp('region_label');
													var regionComboIdObj = Ext.getCmp('regionComboId');
													var regionComboIdValF = regionComboIdObj.getRawValue();
													var countryComboIdObj = Ext.getCmp('countryComboId');
													var countryComboIdValF = countryComboIdObj.getRawValue();
													if(countryComboIdValF != undefined && countryComboIdValF != null && countryComboIdValF != "Countries"){
														if(regionComboIdValF != undefined && regionComboIdValF != null && regionComboIdValF == "All States"){
															regionlblObj.setText(countryComboIdValF);
														}
														else
														{
															regionlblObj.setText(countryComboIdValF);
															Ext.getCmp('region_icon').setVisible(true);
															Ext.getCmp('city_icon').setVisible(true);
															regionObj.setText('<span style="float:left" class="geoDrilldownLink">'+countryComboIdValF+'</span><div class="geoDrilldownArrow"></div>');	
														}
													}
												}catch(ert){}
												try{
													var cityObj = Ext.getCmp('city_icon');
													var regionComboIdObj = Ext.getCmp('regionComboId');
													var regionComboIdValF = regionComboIdObj.getRawValue();
													if(regionComboIdValF != undefined && regionComboIdValF != null){
														cityObj.setText(regionComboIdValF);	
													}
												}catch(fe){}
											},1000);
										}
										else
										{
											var regionlblObj = Ext.getCmp('region_label');
											var countryComboIdObj = Ext.getCmp('countryComboId');
											var countryComboIdObjF = countryComboIdObj.getRawValue();
											if(countryComboIdObjF != undefined && countryComboIdObjF != null){
												regionlblObj.setText(countryComboIdObjF);	
											}
										}
									}catch(ww){}
								}
								else if(!Ext.isEmpty(selected_view_name) && selected_view_name.trim() == "Overview_View")
								{
									selected_CompType_st ='';
									if(!Ext.isEmpty(panelDataArr[0]) && panelDataArr[0]!=undefined)
									{
										var overviewIdObj = Ext.getCmp('overview_first_header_id');
										overviewIdObj.setTitle(panelDataArr[0].Overview_Block_1_Title);
									}

									if(!Ext.isEmpty(panelDataArr[1]) && panelDataArr[1]!=undefined)
									{
										var OverviewDetailsObj = Ext.getCmp('overview_details_id');
										OverviewDetailsObj.removeAll(true);
										OverviewDetailsObj.add({
											xtype:'overviewpanel',
											id:'overviewpanel_id',
											jsonData:panelDataArr[1].Overview_Block_1_Value,
											key:'overview',
										});
									}

									if(!Ext.isEmpty(panelDataArr[2]) && panelDataArr[2]!=undefined)
									{
										var overviewLeftObj = Ext.getCmp('overview_large_panel_id');
										//OverviewDetailsObj.removeAll(true);
										overviewLeftObj.add({
											xtype:'geopanel',
											id:'overview_map_id',
											jsonData:panelDataArr[2].Overview_Block_2_Value[0],
											height:325,
											mapStyle:strRumSkin == "Dark"?'dark':'light', //light,dark,default
											mapType:'styled_map',  //'roadmap', 'satellite', 'hybrid', 'terrain', 'styled_map',
											center: {
												lat: 40.3780, // Marker latitude
												lng:10.4359 // Marker longitude
											},
											infoBoxArray:[],
											markerArray:[],
											feauturesArray:[],
											stateArray:[],
											selectedView:selected_view_name
										});

										var tmpPanelArrays = new Array();
										var tmpPanelArrays2 = new Array();
										if(panelDataArr[2].Overview_Block_2_Value != undefined && panelDataArr[2].Overview_Block_2_Value != null && panelDataArr[2].Overview_Block_2_Value.length > 0)
										{
											//for(var a in panelDataArr[4].Geo_Block_3_Value)
											//for(var a=0;a<panelDataArr[2].Overview_Block_2_Value.length-1;a++)
											{
												var obj_tmp = panelDataArr[2].Overview_Block_2_Value[1];
												tmpPanelArrays.push(obj_tmp);
											}

											var obj_tmp = panelDataArr[2].Overview_Block_2_Value[2];
											var obj_tmp1 = panelDataArr[2].Overview_Block_2_Value[3];
											tmpPanelArrays2.push(obj_tmp);
											tmpPanelArrays2.push(obj_tmp1);
										}

										var overviewRightObj = Ext.getCmp('overview_large_right_top_panels_id');
										overviewRightObj.add({
											xtype:'overviewctxpanel',
											id:'overviewctxpanel_right_top_panel_id',
											jsonData:panelDataArr[2].Overview_Block_2_Value,
											//jsonData:tmpPanelArrays2,
											key:'overview',
											layout:{
												type:'vbox',
												align:'stretch'
											},
										});										
									}

									if((!Ext.isEmpty(panelDataArr[3]) && panelDataArr[3]!=undefined))
									{
										var overviewBarInsObj = Ext.getCmp('overviewBarIns');
										overviewBarInsObj.removeAll(true);
										overviewBarInsObj.add({
											xtype:'chartparentpanel',
											id:'multBarIns_overview',
											data:panelDataArr[3].Overview_Block_3_Value,
											margin:0,
											flex:1,
										
										});
										overviewBarInsObj.doLayout();
									}
								}
								else if(!Ext.isEmpty(selected_view_name) && selected_view_name.trim() == "Alerts_View")
								{
									selected_CompType_st ='';
									if(!Ext.isEmpty(panelDataArr[0]) && panelDataArr[0]!=undefined)
									{
										var overviewIdObj = Ext.getCmp('alerts_header_id');
										overviewIdObj.setTitle(panelDataArr[0].Alert_Block_1_Title);
									}
									
									if(!Ext.isEmpty(panelDataArr[1]) && panelDataArr[1]!=undefined)
									{
										var alertsWidgetsIns_idObj = Ext.getCmp('alertsWidgetsIns');
										alertsWidgetsIns_idObj.removeAll(true);
										alertsWidgetsIns_idObj.add({
											xtype:'alertswidgets',
											id:'alertswidgets_Ins',
											data:panelDataArr[1].Alert_Block_1_Value,
										});
									}

									if(!Ext.isEmpty(panelDataArr[2]) && panelDataArr[2]!=undefined)
									{
										var alerts_grid_idObj = Ext.getCmp('alertsBarIns');
										alerts_grid_idObj.removeAll(true);
										alerts_grid_idObj.add({
											xtype:'chartparentpanel',
											id:'alerts_gridInst',
											isAlerts:true,
											data:panelDataArr[2].Alert_Block_2_Value,
											flex:1
										});
										alerts_grid_idObj.doLayout();
									}
								}
								else if(!Ext.isEmpty(selected_view_name) && selected_view_name.trim() == "UserExperience_View")
								{
									selected_CompType_st ='';
									if(!Ext.isEmpty(panelDataArr[0]) && panelDataArr[0]!=undefined)
									{
										var UxDashHeaderIdObj = Ext.getCmp('UxDashHeader_id');
										//UxDashHeaderIdObj.setTitle(panelDataArr[0].UserExperience_Block_1_Title);
										UxDashHeaderIdObj.setTitle("USER EXPERIENCE - REAL USERS");
									}

									if(!Ext.isEmpty(panelDataArr[1]) && panelDataArr[1]!=undefined)
									{
										var UxDashHeaderoverviewdetails_idObj = Ext.getCmp('UxDashHeaderoverviewdetails_ins');
										UxDashHeaderoverviewdetails_idObj.removeAll(true);
										UxDashHeaderoverviewdetails_idObj.add({
											xtype:'overviewpanel',
											id:'overviewpaneluxdash_Ins',
											jsonData:panelDataArr[1].UserExperience_Block_1_Value,
											key:'overviewpaneluxdash_Ins',
										});
									}
									if(!Ext.isEmpty(panelDataArr[2]) && panelDataArr[2]!=undefined)
									{
										var uxdash_idObj = Ext.getCmp('uxdashBarIds');
										uxdash_idObj.removeCls("eg-container");
										uxdash_idObj.removeAll(true);
										uxdash_idObj.add({
											xtype:'chartparentpanel',
											id:'ux_dash_chart_panel_id',
											ifUx:true,
											margin:0,
											padding:0,
											data:panelDataArr[2].UserExperience_Block_2_Value,
											flex:1
										});
										uxdash_idObj.doLayout();
									}
								}
								else if(!Ext.isEmpty(selected_view_name) && selected_view_name.trim() == "Sessions_View")
								{
									selected_CompType_st ='';
									if(!Ext.isEmpty(panelDataArr[0]) && panelDataArr[0]!=undefined)
									{
										var sessions_headeridObj = Ext.getCmp('sessions_headerid');
										sessions_headeridObj.setTitle(panelDataArr[0].Sessions_Block_1_Title);
									}

									if(!Ext.isEmpty(panelDataArr[1]) && panelDataArr[1]!=undefined)
									{

										var sessions_connected_established_idObj = Ext.getCmp('sessions_connected_established_id');
										//UxDashHeaderoverviewdetails_idObj.removeAll(true);
										sessions_connected_established_idObj.add({
											xtype:'sessionsparentpanel',
											id:'sessionsparentpanel_Obj',
											flex:1,
											//padding:0,
											//margin:'0 0 0 0',
											data:panelDataArr
										});
									}									
								}
								else if(!Ext.isEmpty(selected_view_name) && selected_view_name.trim() == "Logon_View")
								{
									selected_CompType_st ='';
									if(!Ext.isEmpty(panelDataArr[0]) && panelDataArr[0]!=undefined)
									{
										var logon_hId = Ext.getCmp('logon_header_Id');
										logon_hId.setTitle(panelDataArr[0].Logon_Block_1_Title);
									}

									if(!Ext.isEmpty(panelDataArr[1]) && panelDataArr[1]!=undefined)
									{
										var sessionOverView_hId = Ext.getCmp('sessionOverViewp_Id');
										sessionOverView_hId.removeAll(true);
										sessionOverView_hId.add({
											xtype:'overviewpanel',
											id:'sessionOverViewId_Ins',
											jsonData:panelDataArr[1].Logon_Block_1_Value,
											ifLogon:true
										});
									}

									if(!Ext.isEmpty(panelDataArr[2]) && panelDataArr[2]!=undefined)
									{
										var logon_idObj = Ext.getCmp('LogonBarIns');
										logon_idObj.removeAll(true);
										logon_idObj.add({
											xtype:'chartparentpanel',
											id:'sessionOverViewId_prpanel',
											padding:'10 0 0 0',
											margin:'0 0 0 0',
											ifLogOn:true,
											data:panelDataArr[2].Logon_Block_2_Value
										});
										logon_idObj.doLayout();
									}
								}
								else if(!Ext.isEmpty(selected_view_name) && selected_view_name.trim() == "Broker_View")
								{
									selected_CompType_st ='';
									if(!Ext.isEmpty(panelDataArr[0]) && panelDataArr[0]!=undefined)
									{
										var brokeridObj = Ext.getCmp('broker_header_Id');
										brokeridObj.setTitle(panelDataArr[0].Broker_Block_1_Title);
									}
									if(!Ext.isEmpty(panelDataArr[1]) && panelDataArr[1]!=undefined)
									{
										var brokerOverviewObj = Ext.getCmp('broker_overview_id');
										brokerOverviewObj.add({
											xtype:'overviewpanel',
											id:'broker_overviewpanel_id',
											jsonData:panelDataArr[1].Broker_Block_1_Value,
											ifBroker:true
										});
									}
									if(!Ext.isEmpty(panelDataArr[2]) && panelDataArr[2]!=undefined)
									{
										var brokerDesidObj = Ext.getCmp('br_desktop_header_id');
										brokerDesidObj.setTitle(panelDataArr[2].Broker_Block_2_Title);
									}
									
									if((!Ext.isEmpty(panelDataArr[3]) && panelDataArr[3]!=undefined))
									{
										var res_chartObj = Ext.getCmp('br_desktop_header_id');
										res_chartObj.removeAll(true);
										res_chartObj.add({
											xtype:'chartparentpanel',
											id:'multBarIns_Des',
											ifBro:true,
											//legendPosition: 'top',
											//chartType:panelDataArr[3].Application_Block_2_Value.result.chartType,
											data:panelDataArr[3].Broker_Block_2_Value,
											orgData:panelDataArr[3].Broker_Block_2_Value,
											flex:1,
											//height:500
											//width:'100%',
											//data:panelDataArr[3].Application_Block_2_Value.result
											//data:panelDataArr[3].Application_Block_2.result
											//html:'<table><tr><td>'+overviewData[0]['chart']+'</td></tr></table>'
										});
										res_chartObj.doLayout();
									}

									if(!Ext.isEmpty(panelDataArr[4]) && panelDataArr[4]!=undefined)
									{
										var brokerSeridObj = Ext.getCmp('br_server_header_id');
										brokerSeridObj.setTitle(panelDataArr[4].Broker_Block_3_Title);
									}

									if((!Ext.isEmpty(panelDataArr[5]) && panelDataArr[5]!=undefined))
									{
										var res_chartObj = Ext.getCmp('br_server_header_id');
										res_chartObj.removeAll(true);
										res_chartObj.add({
											xtype:'chartparentpanel',
											id:'multBarIns_Ser',
											ifBro:true,
											//legendPosition: 'top',
											//chartType:panelDataArr[3].Application_Block_2_Value.result.chartType,
											data:panelDataArr[5].Broker_Block_3_Value,
											orgData:panelDataArr[5].Broker_Block_3_Value,
											flex:1,
											//height:500
											//width:'100%',
											//data:panelDataArr[3].Application_Block_2_Value.result
											//data:panelDataArr[3].Application_Block_2.result
											//html:'<table><tr><td>'+overviewData[0]['chart']+'</td></tr></table>'
										});
										res_chartObj.doLayout();
									}
								}
							}
						}
					}
				}
			},
			failure:function(){
				//setInterval("execute()",60000);
			}
		});
	},
	addPage:function(menuItem,metric_url){
		var me = this,	card = Ext.getCmp('citrix_ground');
		try
		{
			if(isPaddingRightChanged)
			{
				card.getEl().setStyle({'padding-right':'15px'});
				isPaddingRightChanged = false;
			}

		}
		catch (e)
		{
		}
		// @ destroy all the objects in the card
		for (var i=0;i<Ext.getCmp('citrix_ground').items.items[0].items.items.length ;i++ )
		{
			Ext.destroy(card.items.items[0].items.items[i])
		}
		card.removeAll(true);
		if (menuItem == "Alerts") {
			card.add({
				xtype: 'cardItem',
				items: [{
					xtype: 'alerts'
				}]
			});
		} else if (menuItem == "Overview") {
			card.add({
				xtype: 'cardItem',
				items: [{
					xtype: 'geo'
				}]
			});
		} else if (menuItem == "Geo") {
			card.add({
				xtype: 'cardItem',
				items: [{
					xtype: 'geo'
				}]
			});
		} else if (menuItem == "Sessions") {
			card.add({
				xtype: 'cardItem',
				items: [{
					xtype: 'sessions'
				}]
			});
		} else if (menuItem == "Applications") {
			card.add({
				xtype: 'cardItem',
				items: [{
					xtype: 'applications',

				}]
			});
		} else if (menuItem == "Resources") {
			card.add({
				xtype: 'cardItem',
				items: [{
					xtype: 'resources'
				}]
			});
		} else if (menuItem == "User Experience#1") {
			card.add({
				xtype: 'cardItem',
				items: [{
					xtype: 'logondashboard'
				}]
			});
		} else if (menuItem == "User Experience#2") {
			try {
				if (!isPaddingRightChanged) {
					card.getEl().setStyle({
						'padding-right': '10px'
					});
					isPaddingRightChanged = true;
				}

			} catch (e) {}
			card.add({
				xtype: 'cardItem',
				items: [{
					xtype: 'emulateddashboard'
				}]
			});
		} else if (menuItem == "User Experience#3") {
			card.add({
				xtype: 'cardItem',
				items: [{
					xtype: 'webtransactionsdashboard'
				}]
			});
		} else if (menuItem == "User Experience" || menuItem == "Citrix" || menuItem == "Real Users") {
			card.add({
				xtype: 'cardItem',
				items: [{
					xtype: 'uxdashboard'
				}]
			});
		} else if (menuItem == "Web Transactions") {
			card.add({
				xtype: 'cardItem',
				items: [{
					xtype: 'webtransactionsdashboard'
				}]
			});
		} else if (menuItem == "Emulated Transactions" || menuItem == "Full Session Simulations") {
			try {
				if (!isPaddingRightChanged) {
					card.getEl().setStyle({
						'padding-right': '10px'
					});
					isPaddingRightChanged = true;
				}

			} catch (e) {}
			card.add({
				xtype: 'cardItem',
				items: [{
					xtype: 'emulateddashboard'
				}]
			});
		} else if (menuItem == "Logon Simulations") {
			card.add({
				xtype: 'cardItem',
				items: [{
					xtype: 'logondashboard'
				}]
			});
		} else if (menuItem == "Logon") {
			card.add({
				xtype: 'cardItem',
				items: [{
					xtype: 'logonactivity'
				}]
			});
		} else if (menuItem == "Delivery Groups") {
			card.add({
				xtype: 'cardItem',
				items: [{
					xtype: 'brokeractivity'
				}]
			});
		} else if (menuItem == "Geo") {
			/*
			 */
			card.add({
				xtype: 'container',
				id: "cardID",
				items: [{
					xtype: 'geopanel',
					height: 500,
					mapStyle: strRumSkin == "Dark" ? 'dark' : 'light', //light,dark,default
					width: 500,
					//zoom: 2,
					//id:'maps',
					gmapType: 'map',
					mapType: 'roadmap', //'roadmap', 'satellite', 'hybrid', 'terrain', 'styled_map',
				}]
			});
		} else if (menuItem == "Metrics" || menuItem == "Components") {
			card.add({
				xtype: 'cardItem',
				items: [{
					xtype: 'metrics'
				}]
			});
		} else if (menuItem == "Topology") {
			card.add({
				xtype: 'cardItem',
				items: [{
					xtype: 'topology'
				}]
			});
		} else if (menuItem == "Systems") {
			card.add({
				xtype: 'cardItem',
				items: [{
					xtype: 'systems'
				}]
			});
		} else if (menuItem == "Aggregates") {
			card.add({
				xtype: 'cardItem',
				items: [{
					xtype: 'aggregates'
				}]
			});
		} else {
			card.add({
				xtype: 'container',
				id: "cardID"
			});
		}
		card.doLayout();
	},	
	  /*
     * overview checking for collapsible config
     */
    overviewdetailsRender: function() {
        var me = this;
        var button = Ext.ComponentQuery.query('button[itemId="overviewtoggle"]')[0];
		try{
			if(!Ext.isEmpty(button)){
				//if (me.getOverviewdetails().collapsible) {
				if (Ext.getCmp('geo_toggle').pressed) {
					button.pressed = true;
					Ext.defer(function() {
						me.toggleOverView(button, true);
					}, 1);
				} else {
					button.pressed = false;
					me.toggleOverView(button, false);
				}
			}
		}catch(ee){

		}
    },
    /*
     * overview toggle button
     */
	 toggleOverView: function(btn, pressed, eOpts) {
        var me = this,
            toggleOuterEl = Ext.get(me.getOverviewdetails().el.id),
            toggleIn = 60,
            toggleOut = 147,
            //toggleDuration = 500,
            toggleDuration = 200,
            sbox = Ext.get(me.getOverviewdetails().el.id).select('.s_box'),
            bbox = Ext.get(me.getOverviewdetails().el.id).select('.b_box');
        if (pressed) {
          //  btn.setText("<b>+</b>");
          btn.setIconCls('toggle_p');
            me.getOverviewdetails().suspendLayouts();
            bbox.setStyle('display', 'none');
            sbox.setStyle('display', 'block');
            toggleOuterEl.animate({
                duration: toggleDuration,
                to: {
                    height: toggleIn
                },
                listeners: {
                    beforeanimate: function() {
                        sbox.animate({
                            to: {
                                top: 0
                            }
                        });
                    },
                    afteranimate: function() {
                        me.getOverviewdetails().setHeight(toggleIn);
                        //me.getOverviewdetails().doLayout();
                    }
                }
            });
            me.getOverviewdetails().resumeLayouts(true);
        } else {

           // btn.setText("<b>-</b>");
            btn.setIconCls('toggle_m');
			 me.getOverviewdetails().suspendLayouts();
            bbox.setStyle('display', 'block');
            toggleOuterEl.animate({
                duration: toggleDuration,
                to: {
                    height: toggleOut
                },
                listeners: {
                    beforeanimate: function() {
                        me.getOverviewdetails().setHeight(toggleOut);
                        sbox.animate({
                            to: {
                                top: 500
                            }
                        });
                        sbox.setStyle('display', 'none');
                    },
                    afteranimate: function() {

                        //me.getOverviewdetails().doLayout();
                    }
                }
            });
			me.getOverviewdetails().resumeLayouts(true);
        }
		  
		this.getMain().doComponentLayout();
    },
	 toggleOverViewrefresh: function(btn, pressed, eOpts) {
        var me = this,
            toggleOuterEl = Ext.get(me.getOverviewdetails().el.id),
            toggleIn = 60,
            toggleOut = 147,
            toggleDuration = 200,
            sbox = Ext.get(me.getOverviewdetails().el.id).select('.s_box'),
            bbox = Ext.get(me.getOverviewdetails().el.id).select('.b_box');
        if (pressed) {
          //  btn.setText("<b>+</b>");
          btn.setIconCls('toggle_p');
            me.getOverviewdetails().suspendLayouts();
            bbox.setStyle('display', 'none');
            sbox.setStyle('display', 'block');
            toggleOuterEl.animate({
                duration: toggleDuration,
                to: {
                    height: toggleIn
                },
                listeners: {
                    beforeanimate: function() {
						sbox.setStyle('top', '0');
                        /*sbox.animate({
                            to: {
                                top: 0
                            }
                        });*/
                    },
                    afteranimate: function() {
                        me.getOverviewdetails().setHeight(toggleIn);
                        //me.getOverviewdetails().doLayout();
                    }
                }
            });
            me.getOverviewdetails().resumeLayouts(true);
        } else {

           // btn.setText("<b>-</b>");
            btn.setIconCls('toggle_m');
			 me.getOverviewdetails().suspendLayouts();
            bbox.setStyle('display', 'block');
            toggleOuterEl.animate({
                duration: toggleDuration,
                to: {
                    height: toggleOut
                },
                listeners: {
                    beforeanimate: function() {
                        me.getOverviewdetails().setHeight(toggleOut);
                        sbox.animate({
                            to: {
                                top: 500
                            }
                        });
                        sbox.setStyle('display', 'none');
                    },
                    afteranimate: function() {

                        //me.getOverviewdetails().doLayout();
                    }
                }
            });
			me.getOverviewdetails().resumeLayouts(true);
        }
		  
		this.getMain().doComponentLayout();
	},
	loadListView : function()
	{
		Ext.Ajax.request({
			url : '/final/servlet/com.eg.EgCommonDashboardController?comesFrom=listViewPage&action=loadCtxDashList&isDisablePopupOption=true'+'&iniName='+iniName+"&fromSerComboChange="+fromSerComboChange+'&dashboard_name='+dashboard,
			method : 'POST',
			scope:this,
			success: function(response)
			{
				var jsonText = response.responseText;
				if(jsonText!=null && jsonText!='')
				{
					publicJson = Ext.decode(jsonText);
					this.loadListViewPage(publicJson);
				}
				jsonText=null;
				delete jsonText;
			}
		});
	},
	loadListViewPage : function(publicJson)
	{
		if(!Ext.isEmpty(publicJson) && publicJson!=null && publicJson!=undefined)
		{
			var mainPageView = this.getMain();
			if(!Ext.isEmpty(mainPageView) && mainPageView!=null && mainPageView!=undefined)
				mainPageView.removeAll();
			var myDashboardsListJson = publicJson['myDashboardsList'];
			var defaultMyDashboard = myDashboardsListJson['defaultMyDashboard'];
			var dataforView = myDashboardsListJson['personalSharingData'];
			var mainPageWidth = mainPageView.getWidth() - 20;
			var mainPageHeight = mainPageView.getHeight() - 75;
			var jsonDataView =  publicJson['myDashboardsList']['personalSharingData'];
			var errorMsg =  publicJson['myDashboardsList']['errorMsg'];

			if(dataforView != null && dataforView!= '-')
			{
				mainPageView.add({
					xtype : 'mydashboardlistview',
					autoscroll : true,
					scroll : true,
					height : (mainPageView.getHeight() - 55),
					dataforView: publicJson['myDashboardsList']['personalSharingData']
				});
			}
			else
			{
				mainPageView.add({
					xtype : 'container',
					id:'errorContainer',
					autoscroll : true,
					scroll : true,
					width : (mainPageView.getWidth() - 35),
					height : (mainPageView.getHeight() - 55),
					listeners:{
						'resize':function(panel){
							panel.width = (panel.getWidth() - 35)

						}
					},
					html: '<div style="height:100%;width:100%;display:table"><div class="msgFont" style="display:table-cell;vertical-align:middle"> <div class="iconInformation" style="margin:0px auto"></div><div style="text-align:center">'+errorMsg+'</div></div></div>'
				})
			}
			//isListView = true;
			this.hideDashboardTools(mainPageView);
			mainPageView.doLayout();
		}
	},
	hideDashboardTools : function(mainPageView){
		if(!Ext.isEmpty(mainPageView))
			mainPageView.setTitle('');
		var dbStore = Ext.create('Ext.data.Store', {
			fields: ['valueField', 'displayField'],
			data: []
		});
		var screenWidth = Ext.getBody().getViewSize().width-540;

		var listViewToolbar = Ext.create('Ext.toolbar.Toolbar',{
			items : [
				{
					xtype: 'container',
					dock: 'top',
					ui:'footer',
					id : 'listPageHeaderMenu',
					layout:'hbox',
					align:'left',
					hidden : true,
					items : [
						{
							xtype:'checkbox',
							boxLabel  : '',
							cls:'checkbt',
							margin:'2 0 0 0',
							name: 'selectAllDashboards',
							inputValue: 'selectAll',
							id	: 'selectAllDashboards',
							hidden :false,
						},{
							xtype: 'button',
							width: 16,
							height:16,
							padding:0,
							margin:'4 0 0 0',
							overCls: 'buttonOver',
							id: 'DeleteListOfDashboards',
							iconCls: 'iconDelete',
							style : {'border':'0px !important','background':'transparent;'},
							hidden:true,
							listeners: {
								afterrender: function () {
									Ext.create('Ext.tip.ToolTip', {
										target: this.id,
										anchor: 'top',
										cls: 'yellowTip',
										html: toolDelete,
										ghost:false,
										trackMouse: true
										/*modal:true,
										listeners:{
											show: function(win)
											{
												if (this.modal)
												{
													console.log('--$$--');
													var dom = Ext.dom.Query.select('.x-mask');
													var el = Ext.fly(dom[dom.length-1]);
													el.addCls('windowModal');
												}
											}
										}*/
									});
								}
							}
						},{
							xtype:'tbseparator',
							id:'deleteAllSeparator',
							hidden:true,
							height:22,
							//margin:'8px 5px 0px 4px',
						},{
							xtype: 'container',
							margin:'0px 0px 0 0px',
							//padding:'12 10 0 3',
							html: '<div class="fontStyleRobot font_normal13" style="margin-top:3px">AVAILABLE DASHBOARDS VIEWS</div>',
						},
						{
							xtype:'button',
							cls:'buttonNew',
							margin:'0px 0 0px 5px',
							iconCls:'iconAddDashboardPlus',
							padding:0,
							text:'Add New',
							listeners: {
								afterrender: function () {
									Ext.create('Ext.tip.ToolTip', {
										target: this.id,
										anchor: 'top',
										cls: 'yellowTip',
										trackMouse: true,
										html: addDashLbl
									});
								}
							},
							action:'addNew'
						}
					]
				}, 
				{
					xtype:'tbspacer',
					width:screenWidth
				},
				{
					xtype:'container',
					//height:30,
					items:[{
						xtype:'trigger',
						id : 'searchMyDashboard',
						name : 'searchMyDashboard',
						labelWidth:40,
						margin: '0px 10px 0px 0px',
						fieldLabel:'',
						cls: 'whitedropdown_search',
						emptyText:searchDashLbl,
						//hidden : true,
						listeners: {
							change: function(trig,newVal,oldVal,eOpts) {
								trig.onTextFieldChange(trig,newVal,oldVal,eOpts);
								$('.textView').highlight(newVal);
							}
						},
						onTextFieldChange : function(triggerField, newValue, oldValue, eOpts)
						{
							var dataViewId = Ext.getCmp('dataViewId');

							if(!Ext.isEmpty(dataViewId))
							{

								if(newValue=="*")
								{
									dataViewId.store.clearFilter();
								}
								else
								{
									if(newValue.lastIndexOf("*")==(newValue.length-1))
									{
										newValue = newValue.substr(0,(newValue.length-1));
									}
									dataViewId.store.suspendEvents(true); // This is used for good performance
									dataViewId.store.clearFilter();
									dataViewId.store.resumeEvents(); // This is used for good performance
									if (newValue) {
										var matcher = new RegExp(Ext.String.escapeRegex(newValue), "i");
										dataViewId.store.filter({
											filterFn: function(record) {
												var dashboardName = record.get('dashboardName');
												var match= matcher.test(dashboardName) ;
												if(!match)
												{
													var searchString =newValue;
													dataViewId.emptyText = '<table width="100%" height="480px" style="margin:0% auto"><tr><td align="center" valign="middle"><div class="iconInformation"></div><div styel="margin:10px auto">'+dataViewNoDashboardExistMsg +' '+searchString+'</div></td></tr></table>';
												}
												return match;
											}
										});
									}
									triggerField.focus();
								}
							}
							Ext.getCmp('selectAllDashboards').setValue(false);
						}
						}]
					},
					{
						xtype: 'container',
						margin: '0 5px 0 0px',
						itemId: 'homeBtnContainer',
						cls: 'iconBg',
						//disabled: true,
						items:[{
							xtype: 'button',
							iconCls: 'dashboard_home',
							listeners: {
								afterrender : function(){
									Ext.create('Ext.tip.ToolTip',{
										target: this.id,
										anchor: 'top',
										cls: 'yellowTip',
										trackMouse: true,
										html: homeTooltipLbl
										//html: 'Home'
									});
								},
								'click':function(){
									var selected_dash = '';
									if(!Ext.isEmpty(Ext.getCmp('dashListComId')) && Ext.getCmp('dashListComId')!=null && Ext.getCmp('dashListComId')!=undefined)
										selected_dash = Ext.getCmp('dashListComId').getValue();
									//isListView = false;
									var urlForView = "/final/monitor/citrixDashboard.jsp?&userBased=true&fromMenu=true&showConfig=true&iniName="+iniName+"&dashboard_mapping="+selected_dash+"&dashboard_name="+dashboard;
									if(deletedDefaultView)
									{
										Ext.Msg.show({
											title: ctxDashboardAlertLbl,
											msg: defaultDashboardAlertMsg,
											buttons: Ext.MessageBox.OK,
											icon: Ext.MessageBox.WARNING
										});
									}
									else
									{
										citrixDashboard.app.getController("Main").goToCitrixDashboard(urlForView);
									}
								}
							},
							//tooltip: homeTooltipLbl,
							id: 'homeBtn',
							style:{
								background: 'none',
								border: '0px'
							}
						}]
					}
				]
		});
		
		var mainToolbar = Ext.getCmp('mainview_tbar_Id');
		if(!Ext.isEmpty(mainToolbar) && mainToolbar!=null && mainToolbar!=undefined)
		{
			mainToolbar.removeAll();
			mainToolbar.add(listViewToolbar);
			Ext.getCmp('listPageHeaderMenu').show();
		}
	},
	createCtxCustomDashboard : function(createBtn)
	{
		var meC=this;
		var customdashboardconfigurationObj = Ext.getCmp('customConfigTemplateWindow');
		var addDashboardForm = customdashboardconfigurationObj.getComponent('customdashconfigform').getForm();
		var dashboardName = addDashboardForm.findField('customDashbrdNam').getValue();
		
		var previousDashboardName  = '';
		if(customdashboardconfigurationObj.dashBoardAction == 'Modify') {
			previousDashboardName = customdashboardconfigurationObj.dashboardName;
		}
		createBtn.setDisabled(true);
		if (this.checkBlankSpc(dashboardName)) {
			Ext.Msg.show({
				title : ctxDashboardAlertLbl,
				msg : dashboardBlankNameAlertMsg,
				buttons : Ext.MessageBox.OK,
				icon : Ext.MessageBox.WARNING
			});
			createBtn.setDisabled(false);
			return;
		}
		if (dashboardName != null && dashboardName.length > 32) {
			Ext.Msg.show({
				title : ctxDashboardAlertLbl,
				msg : maxDashbrdLengthAlert,
				buttons : Ext.MessageBox.OK,
				icon : Ext.MessageBox.WARNING
			});
			createBtn.setDisabled(false);
			return;
		}
		if (this.checkSpecialCharacter(dashboardName)) {
			Ext.Msg.show({
				title : ctxDashboardAlertLbl,
				msg : dashboardSplCharacterAlertMsg,
				buttons : Ext.MessageBox.OK,
				icon : Ext.MessageBox.WARNING
			});
			createBtn.setDisabled(false);
			return;
		}		

		var selectedType = addDashboardForm.findField('infraTypeCombo').getValue();
		var compMultiSelectValues = Ext.getCmp('compMultiSelect').getValue();
		
		var selected_value = '';
		var selected_Typevalue = '';
		if(selectedType != null && (selectedType == "Zone" || selectedType == "Segment" || selectedType == "Service"|| selectedType == "ComponentType")){
			selected_value = addDashboardForm.findField('subInfraTypeCombo').getValue();
			if (selected_value == '-1') 
			{
				var chooseReqParamsAlert = '';
				if (selectedType == "Zone")
					chooseReqParamsAlert = noZoneSelectedAlertMsg;
				else if (selectedType == "Segment")
					chooseReqParamsAlert = noSegmentSelectedAlertMsg;
				else if (selectedType == "Service")
					chooseReqParamsAlert = noServiceSelectedAlertMsg;
				else if (selectedType == "ComponentType")
					chooseReqParamsAlert = noCompTypeSelectedAlertMsg;

				Ext.Msg.show({
					title : ctxDashboardAlertLbl,
					msg : chooseReqParamsAlert,
					buttons : Ext.MessageBox.OK,
					icon : Ext.MessageBox.WARNING
				});
				createBtn.setDisabled(false);
				return;
			}
		}
		else
		{
			var compMultiSeltVal = '';
			if(!Ext.isEmpty(compMultiSelectValues) && compMultiSelectValues!=undefined && compMultiSelectValues!=null)
			{
				for(var i=0;i<compMultiSelectValues.length;i++)
				{
					compMultiSeltVal = compMultiSeltVal + ',' + compMultiSelectValues[i];
				}
				if(!Ext.isEmpty(compMultiSeltVal) && compMultiSeltVal!=null && compMultiSeltVal!=undefined && compMultiSeltVal.indexOf(',') == 0)
				{
					selected_value = compMultiSeltVal.substring(1);
				}
			}
			selected_Typevalue = addDashboardForm.findField('subInfraTypeCombo').getValue();
		}

		var aggSelectedVal = Ext.getCmp('aggregateTypeCombo').getValue();
		var siteAndDirectorValues = Ext.getCmp('siteDirMultiSelect').getValue();
		var siteAndDirVal = '';
		if(!Ext.isEmpty(siteAndDirectorValues) && siteAndDirectorValues!=undefined)
		{
			for(var i=0;i<siteAndDirectorValues.length;i++)
			{
				siteAndDirVal = siteAndDirVal + ',' + siteAndDirectorValues[i];
			}
			if(!Ext.isEmpty(siteAndDirVal) && siteAndDirVal!=null && siteAndDirVal!=undefined && siteAndDirVal.indexOf(',') == 0)
			{
				siteAndDirVal = siteAndDirVal.substring(1);
			}
		}
		
		if(!Ext.isEmpty(selected_value) && selected_value!=null && selected_value!=undefined && selected_value.indexOf('None,') == 0)
			selected_value = selected_value.substring(selected_value.indexOf('None,')+5);
		if(!Ext.isEmpty(siteAndDirVal) && siteAndDirVal!=null && siteAndDirVal!=undefined && siteAndDirVal.indexOf('None,') == 0)
			siteAndDirVal = siteAndDirVal.substring(siteAndDirVal.indexOf('None,')+5);
		
		selected_value = (Ext.isEmpty(selected_value)||selected_value==null||selected_value==undefined||selected_value=='')?'None':selected_value;
		aggSelectedVal = (Ext.isEmpty(aggSelectedVal)||aggSelectedVal==null||aggSelectedVal==undefined||aggSelectedVal=='')?'None':aggSelectedVal;
		siteAndDirVal = (Ext.isEmpty(siteAndDirVal)||siteAndDirVal==null||siteAndDirVal==undefined||siteAndDirVal=='')?'None':siteAndDirVal;

		if(!Ext.isEmpty(Ext.getCmp('aggregateTypeCombo')) && Ext.getCmp('aggregateTypeCombo')!=null && Ext.getCmp('aggregateTypeCombo')!=undefined && !Ext.getCmp('aggregateTypeCombo').isVisible()){
			aggSelectedVal = '';
		}

		if(!Ext.isEmpty(Ext.getCmp('siteDirMultiSelect')) && Ext.getCmp('siteDirMultiSelect')!=null && Ext.getCmp('siteDirMultiSelect')!=undefined && !Ext.getCmp('siteDirMultiSelect').isVisible()){
			siteAndDirVal = '';
		}
		
		if((!Ext.isEmpty(selected_value) && selected_value=='None'))
		{
			Ext.Msg.show({
				title : ctxDashboardAlertLbl,
				msg : noFilterTypeSelectedAlertMsg+' '+selectedType,
				buttons : Ext.MessageBox.OK,
				icon : Ext.MessageBox.WARNING
			});
			createBtn.setDisabled(false);
			return;
		}

		if((!Ext.isEmpty(selected_value) && selected_value=='None')  && (!Ext.isEmpty(aggSelectedVal) && aggSelectedVal=='None') && (!Ext.isEmpty(siteAndDirVal) && siteAndDirVal=='None'))
		{
			Ext.Msg.show({
				title : ctxDashboardAlertLbl,
				msg : noTypeSelectedAlertMsg,
				buttons : Ext.MessageBox.OK,
				icon : Ext.MessageBox.WARNING
			});
			createBtn.setDisabled(false);
			return;
		}

		if(!Ext.isEmpty(selected_Typevalue) && selected_Typevalue != null && selected_Typevalue != 'undefined')
			selectedType = encodeURIComponent(selectedType+"~^~"+selected_Typevalue);

		var actionParam = 'addCtxDash';
		if(customdashboardconfigurationObj.dashBoardAction == 'Modify') {
			actionParam = 'modifyCtxDash';
		}
		var paramsForSave = '&action=' + actionParam + '&dashboardName=' + encodeURIComponent(dashboardName) + '&selectedType=' + selectedType + '&selected_value=' + selected_value+"&aggregateSelected="+aggSelectedVal+"&siteAndDirVal="+siteAndDirVal+'&dashboard_name='+dashboard; 

		if(customdashboardconfigurationObj.dashBoardAction == 'Modify') {
			paramsForSave = paramsForSave + '&prevDashboardName=' + encodeURIComponent(previousDashboardName); 
		}
		

		Ext.Ajax.request({
			url : '/final/servlet/com.eg.EgCommonDashboardController?comesFrom=listViewPage'+ paramsForSave +'&iniName='+iniName+"&fromSerComboChange="+fromSerComboChange+'&dashboard_name='+dashboard,
			method : 'POST',
			scope : this,
			success : function(response) {
				var jsonText = response.responseText;
				if(jsonText != null && jsonText != '') {
					var dashbrdAction=customdashboardconfigurationObj.dashBoardAction;
					//customdashboardconfigurationObj.hide();
					Ext.destroy(Ext.getCmp('customConfigTemplateWindow'));
					var jsonData = Ext.decode(jsonText);
					var dashExistsMsg = jsonData['myDashboardsList']['dashboardExists'];
					if(!Ext.isEmpty(dashExistsMsg) && dashExistsMsg!=undefined && dashExistsMsg!=null)
					{
						Ext.Msg.show({
							title: ctxDashboardAlertLbl,
							msg: dashboardExistAlertMsg,
							buttons: Ext.MessageBox.OK,
							icon: Ext.MessageBox.WARNING
						});
					}
					this.loadListViewPage(jsonData);
				}
			},
			failure : function(response, opts){
				createBtn.setDisabled(false);
			}
		});
	},
	modifyCtxListDashboard : function(dashboardName,actionParam,isFromMain)
	{
		var meC = this;
	
		var customdashboardconfigurationObj = Ext.create('citrixDashboard.view.CustomConfigTemplateWindow',{modal:true,id:'customConfigTemplateWindow'});
		Ext.Ajax.request({
			url : '/final/servlet/com.eg.EgCommonDashboardController?comesFrom=listViewPage&selectedType=ComponentType&action='+actionParam+"&dashboardName="+dashboardName+'&iniName='+iniName+"&loadModifyDashboardPopup=true&fromSerComboChange="+fromSerComboChange+'&dashboard_name='+dashboard,
			method : 'POST',
			scope : this,
			success : function(response){
				var jsonText = response.responseText;
				if(jsonText != null && jsonText != ''){
					var jsonData = Ext.decode(jsonText);
					var updateJson = jsonData['myDashboardsList'];
					var modifyTitle = jsonData['screenLabels']['monitor.common.Modify Dashboard'];

					customdashboardconfigurationObj.suspendEvents(true);
					//customdashboardconfigurationObj.setTitle('<span>'+jsonData['screenLabels']['monitor.common.Modify Dashboard']+'</span>');
					Ext.apply(customdashboardconfigurationObj,{title:modifyTitle});
					var addDashboardForm = customdashboardconfigurationObj.getComponent('customdashconfigform').getForm();
					var dashbrdNamObj = addDashboardForm.findField('customDashbrdNam');
					dashbrdNamObj.setFieldLabel(jsonData['screenLabels']['monitor.dashboard.Dashboard Name']);
					var dashName = updateJson['dashboardName'];
					if(!Ext.isEmpty(dashName) && dashName!=null && dashName!=undefined)
					{
						dashbrdNamObj.setValue(dashName);
						dashbrdNamObj.readOnly = true;
						dashbrdNamObj.show();
					}
					
					var createDashboardBtn = Ext.getCmp('customCreateDashboardBtn');
					if(!Ext.isEmpty(createDashboardBtn) && createDashboardBtn!=null && createDashboardBtn!=undefined)
					{
						createDashboardBtn.setText(jsonData['screenLabels']['admin.mpolicy.Update']);
						createDashboardBtn.setDisabled(false);
					}
				
					var infraTypeComboObj = addDashboardForm.findField('infraTypeCombo');
					infraTypeComboObj.setFieldLabel(jsonData['screenLabels']['monitor.common.View by']);
					var seleted_type = updateJson['listViewTypes']['selectedType'];
					if(!Ext.isEmpty(infraTypeComboObj) && infraTypeComboObj!=null && infraTypeComboObj!=undefined)
					{
						var typeOptsJson = updateJson['listViewTypes']['typeOptions'];
						meC.setValueWithOptionInList(infraTypeComboObj, typeOptsJson,seleted_type,'');
					}

					var subInfraTypeComboObj = Ext.getCmp('subInfraTypeCombo');
					var compMultiSelect = Ext.getCmp('compMultiSelect');
					if(!Ext.isEmpty(seleted_type) && seleted_type!=null && seleted_type!=undefined && seleted_type=='Components')
					{
						if(!Ext.isEmpty(compMultiSelect) && compMultiSelect!=null && compMultiSelect!=undefined && !Ext.isEmpty(updateJson['listViewCompValues']) && updateJson['listViewCompValues'] != null && updateJson['listViewCompValues'] != undefined)
						{
							compMultiSelect.getStore().loadRawData(updateJson['listViewCompValues']['selectedOptions']);
							var value = updateJson['listViewCompValues']['selectedTypeValue'];
							compMultiSelect.setValue(value);
							
							var compMultiTitle = addDashboardForm.findField('infraTypeCombo').getRawValue();
							var compMultiLblObj = Ext.getCmp('compMultiLbl');
							if(!Ext.isEmpty(compMultiLblObj) && compMultiLblObj!=null && compMultiLblObj!=undefined)
							{
								compMultiLblObj.setText(compMultiTitle);
							}
							//subInfraTypeComboObj.hide();
						}
						else{
							compMultiSelect.hide();
							var compMultiLblObj = Ext.getCmp('compMultiLbl');
							compMultiLblObj.hide();
						}
						if(!Ext.isEmpty(subInfraTypeComboObj) && subInfraTypeComboObj!=null && subInfraTypeComboObj!=undefined)
						{
							meC.setValueWithOptionInList(subInfraTypeComboObj, updateJson['listViewValues']['selectedOptions'], updateJson['listViewValues']['selectedTypeValue'], '');
							subInfraTypeComboObj.setFieldLabel(addDashboardForm.findField('infraTypeCombo').getRawValue());
							//compMultiSelect.hide();
							subInfraTypeComboObj.show();
						}
					}
					else
					{
						if(!Ext.isEmpty(subInfraTypeComboObj) && subInfraTypeComboObj!=null && subInfraTypeComboObj!=undefined)
						{
							meC.setValueWithOptionInList(subInfraTypeComboObj, updateJson['listViewValues']['selectedOptions'], updateJson['listViewValues']['selectedTypeValue'], '');
							subInfraTypeComboObj.setFieldLabel(addDashboardForm.findField('infraTypeCombo').getRawValue());
							compMultiSelect.hide();
							subInfraTypeComboObj.show();
						}
					}

					if(!Ext.isEmpty(seleted_type) && seleted_type!=null && seleted_type!=undefined && (seleted_type == "Zone" || seleted_type == "Segment" || seleted_type == "Service"))
					{
						meC.setValuesForSiteAndDirector('loadModifyDashboardPopup');
					}
					else
					{
						var aggregateTypeComboObj = Ext.getCmp('aggregateTypeCombo');
						var selected_val = Ext.getCmp('subInfraTypeCombo').getValue();
						if(!Ext.isEmpty(seleted_type) && seleted_type!=undefined && seleted_type!=null && (seleted_type =='ComponentType' || seleted_type =='Components') && selected_val != null && selected_val != undefined && selected_val.indexOf("Agg_") == 0){
							var aggregateTypeLblObj = Ext.getCmp('aggregateTypeLbl');
							if(!Ext.isEmpty(aggregateTypeLblObj) && aggregateTypeLblObj!=null && aggregateTypeLblObj!=undefined)
								aggregateTypeLblObj.setText("");
							aggregateTypeComboObj.hide();
						}
						else{
							if(!Ext.isEmpty(aggregateTypeComboObj) && aggregateTypeComboObj!=null && aggregateTypeComboObj!=undefined && updateJson['listViewAggregates']['selectedOptions'] != null && !Ext.isEmpty(updateJson['listViewAggregates']['selectedOptions']) && (updateJson['listViewAggregates']['selectedOptions']).length > 1 && updateJson['listViewAggregates']['selectedTypeValue'] != 'None')
							{
								var aggregateTypeComboJson = updateJson['listViewAggregates']['selectedOptions'];
								//meC.setValueWithOptionInList(aggregateTypeComboObj, aggregateTypeComboJson, updateJson['listViewAggregates']['selectedTypeValue'],'');
								aggregateTypeComboObj.getStore().loadRawData(aggregateTypeComboJson);
								var value = updateJson['listViewAggregates']['selectedTypeValue'];
								aggregateTypeComboObj.setValue(value);
								var title = (seleted_type != null && (seleted_type == 'Components' || seleted_type == 'ComponentType'))?'Select Aggregates for Graph (Optional)':'Aggregates';
								var aggregateTypeLblObj = Ext.getCmp('aggregateTypeLbl');
								if(!Ext.isEmpty(aggregateTypeLblObj) && aggregateTypeLblObj!=null && aggregateTypeLblObj!=undefined)
									aggregateTypeLblObj.setText(title);
							}
							else{
								var aggregateTypeLblObj = Ext.getCmp('aggregateTypeLbl');
								if(!Ext.isEmpty(aggregateTypeLblObj) && aggregateTypeLblObj!=null && aggregateTypeLblObj!=undefined)
									aggregateTypeLblObj.setText("");
								aggregateTypeComboObj.hide();
							}
						}
						var siteDirMultiSelectObj = Ext.getCmp('siteDirMultiSelect');
						if(!Ext.isEmpty(siteDirMultiSelectObj) && siteDirMultiSelectObj!=null && siteDirMultiSelectObj!=undefined && !Ext.isEmpty(updateJson['listViewSiteAndDirector']) && updateJson['listViewSiteAndDirector']!=null && updateJson['listViewSiteAndDirector']!=undefined && updateJson['listViewSiteAndDirector']['selectedOptions'].length > 1 && updateJson['listViewSiteAndDirector']['selectedTypeValue'] != 'None')
						{
							var siteDirMultiSelectJson = updateJson['listViewSiteAndDirector']['selectedOptions'];
							siteDirMultiSelectObj.getStore().loadRawData(siteDirMultiSelectJson);
							
							var value = updateJson['listViewSiteAndDirector']['selectedTypeValue'];
							siteDirMultiSelectObj.setValue(value);
							
							var siteDirTitle = jsonData['screenLabels']['monitor.common.SitesAndDirector'];
							var siteDirMultiLblObj = Ext.getCmp('siteDirMultiLbl');
							if(!Ext.isEmpty(siteDirMultiLblObj) && siteDirMultiLblObj!=null && siteDirMultiLblObj!=undefined)
							{
								siteDirMultiLblObj.setText(siteDirTitle);
								siteDirMultiSelectObj.show();
							}
						}
						else{
							siteDirMultiSelectObj.hide();
							var siteDirMultiLblObj = Ext.getCmp('siteDirMultiLbl');
							siteDirMultiLblObj.hide();
						}
					}

					customdashboardconfigurationObj.show();
					//customdashboardconfigurationObj.dashBoardAction = 'Modify';
					//customdashboardconfigurationObj.dashboardName = dashName;
					customdashboardconfigurationObj.resumeEvents();
				}
			},
			failure : function(response, opts) {
				if(response.timedout) {
					customdashboardconfigurationObj.removeAll();
					customdashboardconfigurationObj.suspendEvents(true);
					customdashboardconfigurationObj.update('<table width="100%" height="' + (configtemplatewindow.getHeight() - 20) + '"><tr><td align="center" valign="middle"><div class="requestTimeOut" style="z-index:19001;left:45%;top:35%;width:180px"><div style="position:relative">' + requestTimeoutMsg + '</div></div></td></tr></table>');
					customdashboardconfigurationObj.resumeEvents();
					customdashboardconfigurationObj.doComponentLayout();
				}
			}
		});
	},
	loadAddDashboardPopup : function()
	{
		var meC = this;
		var customdashboardconfigurationObj = Ext.create('citrixDashboard.view.CustomConfigTemplateWindow',{modal:true,cls:'myDashboardwindow',id:'customConfigTemplateWindow'});
		
		Ext.Ajax.request({
			url : '/final/servlet/com.eg.EgCommonDashboardController?comesFrom=listViewPage&selectedType=ComponentType&action=loadAddDashboardPopup&iniName='+iniName+"&fromSerComboChange="+fromSerComboChange+'&dashboard_name='+dashboard,
			method : 'POST',
			scope : this,
			success : function(response){
				var jsonText = response.responseText;
				if(jsonText != null && jsonText != ''){
					var jsonData = Ext.decode(jsonText);
					
					var addDashTitle = jsonData['screenLabels']['monitor.common.Add Dashboard'];
					customdashboardconfigurationObj.suspendEvents(true);
					Ext.apply(customdashboardconfigurationObj,{title:addDashTitle});
					var addDashboardForm = customdashboardconfigurationObj.getComponent('customdashconfigform').getForm();
					var dashbrdNamObj = addDashboardForm.findField('customDashbrdNam');
					dashbrdNamObj.setFieldLabel(jsonData['screenLabels']['monitor.dashboard.Dashboard Name']);
					dashbrdNamObj.setValue('');
					dashbrdNamObj.show();
					
					var createDashboardBtn = Ext.getCmp('customCreateDashboardBtn');
					if(!Ext.isEmpty(createDashboardBtn) && createDashboardBtn!=null && createDashboardBtn!=undefined)
					{
						createDashboardBtn.setText(jsonData['screenLabels']['admin.mpolicy.Create']);
						createDashboardBtn.setDisabled(false);
					}

					var infraTypeComboObj = addDashboardForm.findField('infraTypeCombo');
					infraTypeComboObj.setFieldLabel(jsonData['screenLabels']['monitor.common.View by']);
					var seleted_type = jsonData['listViewTypes']['selectedType'];
					if(!Ext.isEmpty(infraTypeComboObj) && infraTypeComboObj!=null && infraTypeComboObj!=undefined)
					{
						var typeOptsJson = jsonData['listViewTypes']['typeOptions'];
						meC.setValueWithOptionInList(infraTypeComboObj, typeOptsJson,seleted_type,'');
					}

					var subInfraTypeComboObj = Ext.getCmp('subInfraTypeCombo');
					var compMultiSelect = Ext.getCmp('compMultiSelect');
					if(!Ext.isEmpty(seleted_type) && seleted_type!=null && seleted_type!=undefined && seleted_type=='Components')
					{
						if(!Ext.isEmpty(compMultiSelect) && compMultiSelect!=null && compMultiSelect!=undefined)
						{
							compMultiSelect.getStore().loadRawData(jsonData['listViewValues']['selectedOptions']);
							var value = jsonData['listViewValues']['selectedTypeValue'];
							compMultiSelect.setValue(value);
							
							var compMultiTitle = addDashboardForm.findField('infraTypeCombo').getRawValue();
							var compMultiLblObj = Ext.getCmp('compMultiLbl');
							if(!Ext.isEmpty(compMultiLblObj) && compMultiLblObj!=null && compMultiLblObj!=undefined)
							{
								compMultiLblObj.setText(compMultiTitle);
							}
							subInfraTypeComboObj.hide();
							compMultiSelect.show();
						}
					}
					else
					{
						if(!Ext.isEmpty(subInfraTypeComboObj) && subInfraTypeComboObj!=null && subInfraTypeComboObj!=undefined)
						{
							meC.setValueWithOptionInList(subInfraTypeComboObj, jsonData['listViewValues']['selectedOptions'], jsonData['listViewValues']['selectedTypeValue'], '');
							subInfraTypeComboObj.setFieldLabel(addDashboardForm.findField('infraTypeCombo').getRawValue());
							compMultiSelect.hide();
							subInfraTypeComboObj.show();
						}
					}
					
					var aggregateTypeComboObj = Ext.getCmp('aggregateTypeCombo');
					if(!Ext.isEmpty(aggregateTypeComboObj) && aggregateTypeComboObj!=null && aggregateTypeComboObj!=undefined)
					{
						var aggregateTypeComboJson = jsonData['listViewAggregates']['selectedOptions'];
						//meC.setValueWithOptionInList(aggregateTypeComboObj, aggregateTypeComboJson, jsonData['listViewAggregates']['selectedTypeValue'],'');
						if(!Ext.isEmpty(jsonData['listViewAggregates']) && jsonData['listViewAggregates']!=null && jsonData['listViewAggregates']!=undefined && aggregateTypeComboJson.length > 1){
							aggregateTypeComboObj.getStore().loadRawData(aggregateTypeComboJson);
							
							var value = jsonData['listViewAggregates']['selectedTypeValue'];
							aggregateTypeComboObj.setValue(value);
						}
						else{
							aggregateTypeComboObj.hide();
							var aggregateTypeLblObj = Ext.getCmp('aggregateTypeLbl');
							aggregateTypeLblObj.hide();
						}
					}
					
					var siteDirMultiSelectObj = Ext.getCmp('siteDirMultiSelect');
					if(!Ext.isEmpty(siteDirMultiSelectObj) && siteDirMultiSelectObj!=null && siteDirMultiSelectObj!=undefined)
					{
						var siteDirMultiSelectJson = jsonData['listViewSiteAndDirector']['selectedOptions'];
						siteDirMultiSelectObj.getStore().loadRawData(siteDirMultiSelectJson);
						
						var value = jsonData['listViewSiteAndDirector']['selectedTypeValue'];
						siteDirMultiSelectObj.setValue(value);

						var siteDirTitle = jsonData['screenLabels']['monitor.common.SitesAndDirector'];
						var siteDirMultiLblObj = Ext.getCmp('siteDirMultiLbl');
						var siteDirContainerObj = Ext.getCmp('siteDirContainer');
						if(!Ext.isEmpty(siteDirMultiLblObj) && siteDirMultiLblObj!=null && siteDirMultiLblObj!=undefined)
						{
							siteDirMultiLblObj.setText(siteDirTitle);
							if(Ext.getCmp('compMultiSelect') != null && !Ext.isEmpty(Ext.getCmp('compMultiSelect')) && (Ext.getCmp('compMultiSelect')).isVisible){
							
								$("siteDirMultiLbl").css("margin-left","-10px");
								$("aggregateTypeCombo").css("margin-left","-10px");

							
							}
							siteDirMultiSelectObj.show();
						}
					}

					customdashboardconfigurationObj.show();
					customdashboardconfigurationObj.dashBoardAction = 'Add';
					customdashboardconfigurationObj.resumeEvents();
					jsonData=null;
					delete jsonData;
				}
				jsonText=null;
				delete jsonText;
			},
			failure : function(response, opts) {
				if(response.timedout) {
					customdashboardconfigurationObj.removeAll();
					customdashboardconfigurationObj.suspendEvents(true);
					customdashboardconfigurationObj.update('<table width="100%" height="' + (configtemplatewindow.getHeight() - 20) + '"><tr><td align="center" valign="middle"><div class="requestTimeOut" style="z-index:19001;left:45%;top:35%;width:180px"><div style="position:relative">' + requestTimeoutMsg + '</div></div></td></tr></table>');
					customdashboardconfigurationObj.resumeEvents();
					customdashboardconfigurationObj.doComponentLayout();
				}
			}
		});
	},
	setValueWithOptionInList : function(comboObj, list, value, defaultMsg){
		var comboStre = comboObj.getStore();
		if(!Ext.isEmpty(comboStre))
		{
			comboStre.removeAll();
			comboObj.suspendEvents(false);
			comboStre.loadRawData(list);
			if (defaultMsg != null && defaultMsg != '') {
				comboStre.insert(0, {
					displayField : defaultMsg,
					valueField : '-1'
				});
				comboObj.setValue(value);
			} else {
				var valueAssigned = false;
				for ( var listCounter = 0; listCounter < list.length; listCounter++) {
					if (list[listCounter].valueField == value && value != "" && value != null) {
						comboObj.setValue(value);
						valueAssigned = true;
					}
				}
				if (!valueAssigned) {
					comboObj.setValue(list[0].valueField);
				}
			}
			comboObj.resumeEvents();
		}
	},
	getCustomOptionsForType : function(){
		var customConfigTemplateWindow = this.getCustomConfigTemplateWindow();
		if (Ext.isEmpty(customConfigTemplateWindow))
			customConfigTemplateWindow = Ext.widget('customConfigTemplateWindow');

		var addDashboardForm = customConfigTemplateWindow.getComponent('customdashconfigform').getForm();
		var selectedType = Ext.getCmp('infraTypeCombo').getValue();
		var subInfraTypeComboObj = addDashboardForm.findField('subInfraTypeCombo');
		var selectedValue = null;
		//if(!Ext.isEmpty(selectedType) && selectedType!=undefined && selectedType!=null && selectedType!='Components')
		if(!Ext.isEmpty(selectedType) && selectedType!=undefined && selectedType!=null)
			selectedValue = Ext.getCmp('subInfraTypeCombo').getValue();
		
		var compMultiSelect = Ext.getCmp('compMultiSelect');
		//customConfigTemplateWindow.width = 700;
		customConfigTemplateWindow.width = 500;
		if (selectedType != null && selectedType == "Components") {
			//subInfraTypeComboObj.hide();
			//compMultiSelect.show();
		} else {
			compMultiSelect.hide();
			subInfraTypeComboObj.show();
		}
		var dash_name = '';
		if(!Ext.isEmpty(Ext.getCmp('customDashbrdNam')) && Ext.getCmp('customDashbrdNam')!=null && Ext.getCmp('customDashbrdNam')!=undefined)
			dash_name = Ext.getCmp('customDashbrdNam').getValue(); 
		var meC = this;
		Ext.Ajax.request({
			url : '/final/servlet/com.eg.EgCommonDashboardController?comesFrom=listViewPage&action=loadAddDashboardPopup&selectedType=' + selectedType +'&iniName='+iniName+"&selected_value="+selectedValue+'&dashboardName='+dash_name+'&fromSerComboChange='+fromSerComboChange+'&dashboard_name='+dashboard,
			method : 'POST',
			scope : this,
			async : true,
			success : function(response){
				var jsonText = response.responseText;
				if(jsonText != null && jsonText != ''){
					var jsonData = Ext.decode(jsonText);
					/*if(!Ext.isEmpty(selectedType) && selectedType != null && selectedType == "Components")
					{
						if(!Ext.isEmpty(compMultiSelect) && compMultiSelect!=null && compMultiSelect!=undefined)
						{
							compMultiSelect.getStore().loadRawData(jsonData['listViewValues']['selectedOptions']);
							var value = jsonData['listViewValues']['selectedTypeValue'];
							compMultiSelect.setValue(value);
							
							var compMultiTitle = addDashboardForm.findField('infraTypeCombo').getRawValue();
							var compMultiLblObj = Ext.getCmp('compMultiLbl');
							if(!Ext.isEmpty(compMultiLblObj) && compMultiLblObj!=null && compMultiLblObj!=undefined)
							{
								compMultiLblObj.setText(compMultiTitle);
								compMultiLblObj.show();
							}
							if(!Ext.isEmpty(subInfraTypeComboObj) && subInfraTypeComboObj!=null && subInfraTypeComboObj!=undefined)
								subInfraTypeComboObj.hide();
							compMultiSelect.show();
						}
					}
					else{*/
						var subInfraTypeComboObj = addDashboardForm.findField('subInfraTypeCombo');
						meC.setValueWithOptionInList(subInfraTypeComboObj, jsonData['listViewValues']['selectedOptions'], jsonData['listViewValues']['selectedTypeValue'], '');
						var title = (selectedType != null && selectedType == "Components" && selectedValue == 'None')?'Component Type':addDashboardForm.findField('infraTypeCombo').getRawValue();
						subInfraTypeComboObj.setFieldLabel(title);
						compMultiSelect.hide();
						var compMultiLblObj = Ext.getCmp('compMultiLbl');
						if(!Ext.isEmpty(compMultiLblObj) && compMultiLblObj!=null && compMultiLblObj!=undefined)
						{
							compMultiLblObj.hide();
						}
						subInfraTypeComboObj.show();
						var aggregateTypeComboObj = Ext.getCmp('aggregateTypeCombo');
						aggregateTypeComboObj.hide();
						var aggregateTypeLblObj = Ext.getCmp('aggregateTypeLbl');
						aggregateTypeLblObj.hide();
						var siteDirMultiSelectObj = Ext.getCmp('siteDirMultiSelect');
						siteDirMultiSelectObj.hide();
						var siteDirMultiLblObj = Ext.getCmp('siteDirMultiLbl');
						siteDirMultiLblObj.hide();
					//}
				//	meC.setValuesForSiteAndDirector('loadModifyDashboardPopup');
					//meC.setValuesForSiteAndDirector('loadAddDashboardPopup');
					jsonData=null;
					delete jsonData;
				}
				jsonText=null;
				delete jsonText;
			}
		});
	},
	setValuesForSiteAndDirector : function(thisObj)
	{
		var selected_type = Ext.getCmp('infraTypeCombo').getValue();
		var selected_val = null;
		//if(!Ext.isEmpty(selected_type) && selected_type!=undefined && selected_type!=null && selected_type!='Components')
		if(!Ext.isEmpty(selected_type) && selected_type!=undefined && selected_type!=null)
			selected_val = Ext.getCmp('subInfraTypeCombo').getValue();
		
		var tmpAction = 'modifyCtxDash&loadModifyDashboardPopup=true';
		
		var dash_name = '';
		if(!Ext.isEmpty(Ext.getCmp('customDashbrdNam')) && Ext.getCmp('customDashbrdNam')!=null && Ext.getCmp('customDashbrdNam')!=undefined)
			dash_name = Ext.getCmp('customDashbrdNam').getValue(); //+'&dashboardName='+dash_name,
		Ext.Ajax.request({
			url : '/final/servlet/com.eg.EgCommonDashboardController?comesFrom=listViewPage&action='+tmpAction+'&selectedType=' + selected_type +'&iniName='+iniName+"&selected_value="+selected_val+'&dashboardName='+dash_name+'&fromSerComboChange='+fromSerComboChange+'&dashboard_name='+dashboard,
			method : 'POST',
			scope : this,
			async : true,
			success : function(response){
				var jsonText = response.responseText;
				if(jsonText != null && jsonText != ''){
					var jsonData = Ext.decode(jsonText);
					var screenLablesJson = jsonData['screenLabels'];
					if(!Ext.isEmpty(jsonData['myDashboardsList'] && jsonData['myDashboardsList']!=undefined && jsonData['myDashboardsList']!=null))
						jsonData = jsonData['myDashboardsList'];
					//if(!Ext.isEmpty(selected_type) && selected_type != null && selected_type == "Components")
					if(jsonData['listViewCompValues'] != null && !Ext.isEmpty(jsonData['listViewCompValues'])&& (jsonData['listViewCompValues']['selectedOptions']).length > 1)
					{
						var customConfigTemplateWindow = this.getCustomConfigTemplateWindow();
						if (Ext.isEmpty(customConfigTemplateWindow))
							customConfigTemplateWindow = Ext.widget('customConfigTemplateWindow');
						var addDashboardForm = customConfigTemplateWindow.getComponent('customdashconfigform').getForm();
						var compMultiSelect = Ext.getCmp('compMultiSelect');
						if(!Ext.isEmpty(compMultiSelect) && compMultiSelect!=null && compMultiSelect!=undefined)
						{
							compMultiSelect.getStore().loadRawData(jsonData['listViewCompValues']['selectedOptions']);
							var value = jsonData['listViewCompValues']['selectedTypeValue'];
							compMultiSelect.setValue(value);
							
							//var compMultiTitle = addDashboardForm.findField('infraTypeCombo').getRawValue();
							var compMultiLblObj = Ext.getCmp('compMultiLbl');
							if(!Ext.isEmpty(compMultiLblObj) && compMultiLblObj!=null && compMultiLblObj!=undefined)
							{
								compMultiLblObj.setText('Components');
								compMultiLblObj.show();
							}
							//if(!Ext.isEmpty(subInfraTypeComboObj) && subInfraTypeComboObj!=null && subInfraTypeComboObj!=undefined)
								//subInfraTypeComboObj.hide();
							compMultiSelect.show();
						}
					}
					else{
						var compMultiSelect = Ext.getCmp('compMultiSelect');
						compMultiSelect.hide();
						var compMultiLblObj = Ext.getCmp('compMultiLbl');
						compMultiLblObj.hide();
					}

					var aggregateTypeComboObj = Ext.getCmp('aggregateTypeCombo');
					var siteDirMultiSelectObj = Ext.getCmp('siteDirMultiSelect');
					var siteDirContainerObj = Ext.getCmp('siteDirContainer');
					var  aggregateTypeContainerObj = Ext.getCmp('aggregatesContainer');
					var compMultiselectContainerObj=Ext.getCmp('compMultiselectContainer');
					if (siteDirContainerObj)
					{
						siteDirContainerObj.getEl().setStyle({'margin-top' : '-10px','margin-left' : '-30px','width':'268px'});
						siteDirContainerObj.doLayout();
					}

					if(!Ext.isEmpty(selected_type) && selected_type!=undefined && selected_type!=null && (selected_type =='ComponentType' || selected_type =='Components') && selected_val.indexOf("Agg_") == 0){
						var aggregateTypeLblObj = Ext.getCmp('aggregateTypeLbl');
						if(!Ext.isEmpty(aggregateTypeLblObj) && aggregateTypeLblObj!=null && aggregateTypeLblObj!=undefined)
							aggregateTypeLblObj.setText("");
						aggregateTypeComboObj.hide();
						if ((Ext.getCmp('aggregateTypeCombo')).isVisible && (Ext.getCmp('compMultiSelect')).isVisible)
							{
								siteDirContainerObj.getEl().setStyle({'margin-top' : '-10px','margin-left' : '-30px','width':'273px'});
								aggregateTypeContainerObj.getEl().setStyle({'margin-top' : '10px','margin-left' : '-17px','width':'215px'});
								siteDirContainerObj.doLayout();
							}

						if ((Ext.getCmp('aggregateTypeCombo')).isVisible && (Ext.getCmp('compMultiSelect')).isVisible)
							{
								siteDirContainerObj.getEl().setStyle({'margin-top' : '-10px','margin-left' : '-30px','width':'273px'});
								aggregateTypeContainerObj.getEl().setStyle({'margin-top' : '10px','margin-left' : '-17px','width':'215px'});
								siteDirContainerObj.doLayout();
							}

							if ((Ext.getCmp('siteDirMultiSelect')).isVisible || (Ext.getCmp('compMultiSelect')).isVisible)
							{
								siteDirContainerObj.getEl().setStyle({'margin-top' : '-10px','margin-left' : '-33px','width':'273px'});
								siteDirContainerObj.doLayout();
							}

							if (siteDirContainerObj)
							{
								siteDirContainerObj.getEl().setStyle({'margin-top' : '-10px','margin-left' : '-30px','width':'273px'});
								compMultiselectContainerObj.getEl().setStyle({'width':'217px'});
								siteDirContainerObj.doLayout();
							}

							if ((Ext.getCmp('siteDirMultiSelect')).isVisible || (Ext.getCmp('compMultiSelect')).isVisible)
							{
								aggregateTypeComboObj.getEl().setStyle({'margin-left' : '16px','width':'215px'});
								aggregateTypeComboObj.doLayout();
							}

							if ((Ext.getCmp('compMultiSelect')).isVisible)
							{

								aggregateTypeContainerObj.getEl().setStyle({'margin-left' : '0px','width':'215px'});
								aggregateTypeComboObj.doLayout();
							}
					}
					else{
						if(!Ext.isEmpty(aggregateTypeComboObj) && aggregateTypeComboObj!=null && aggregateTypeComboObj!=undefined && !Ext.isEmpty(jsonData['listViewAggregates']) && jsonData['listViewAggregates']!=null && jsonData['listViewAggregates']!=undefined && (jsonData['listViewAggregates']['selectedOptions']).length > 1 && jsonData['listViewAggregates']['selectedTypeValue'] != 'None')
						{
							var aggregateTypeComboJson = jsonData['listViewAggregates']['selectedOptions'];
							//this.setValueWithOptionInList(aggregateTypeComboObj, aggregateTypeComboJson, jsonData['listViewAggregates']['selectedTypeValue'],'');
							aggregateTypeComboObj.getStore().loadRawData(aggregateTypeComboJson);
							var value = jsonData['listViewAggregates']['selectedTypeValue'];
							aggregateTypeComboObj.setValue(value);
							if(Ext.getCmp('compMultiSelect') != null && !Ext.isEmpty(Ext.getCmp('compMultiSelect')) && (Ext.getCmp('compMultiSelect')).isVisible){
								aggregateTypeComboObj.getEl().setStyle({'margin-right' : '30px'});
								if(!Ext.isEmpty(customConfigTemplateWindow) && customConfigTemplateWindow != null && customConfigTemplateWindow != undefined)
									customConfigTemplateWindow.doLayout();
							}
							aggregateTypeComboObj.show();
							var aggregateTypeLblObj = Ext.getCmp('aggregateTypeLbl');
							var siteDirMultiLblObj = Ext.getCmp('siteDirMultiLbl');
							var siteDirMultiSelectObj = Ext.getCmp('siteDirMultiSelect');

	
							var title = (selected_type != null && (selected_type == 'Components' || selected_type == 'ComponentType'))?'Select Aggregates for Graph (Optional)':'Aggregates';
							if(!Ext.isEmpty(aggregateTypeLblObj) && aggregateTypeLblObj!=null && aggregateTypeLblObj!=undefined){
								aggregateTypeLblObj.setText(title);
								if(Ext.getCmp('compMultiSelect') != null && !Ext.isEmpty(Ext.getCmp('compMultiSelect')) && (Ext.getCmp('compMultiSelect')).isVisible){
									aggregateTypeLblObj.getEl().setStyle({'margin-left' : '17px'});
									aggregateTypeComboObj.getEl().setStyle({'margin-left' : '17px'});
									aggregateTypeContainerObj.getEl().setStyle({'width':'207px','margin-top':'10px'});
									if(!Ext.isEmpty(customConfigTemplateWindow) && customConfigTemplateWindow != null && customConfigTemplateWindow != undefined)
										customConfigTemplateWindow.doLayout();
								}

								if ((Ext.getCmp('aggregateTypeCombo')).isVisible && (Ext.getCmp('compMultiSelect')).isVisible)
								{
									siteDirContainerObj.getEl().setStyle({'margin-top' : '0px','margin-left' : '-26px','width':'268px'});
									siteDirContainerObj.doLayout();
								}

								if ((Ext.getCmp('siteDirMultiSelect')).isVisible || (Ext.getCmp('compMultiSelect')).isVisible)
								{
									aggregateTypeComboObj.getEl().setStyle({'margin-left' : '16px','width':'215px'});
									aggregateTypeComboObj.doLayout();
								}

								if ((Ext.getCmp('compMultiSelect')).isVisible)
								{
									siteDirContainerObj.getEl().setStyle({'margin-left' : '-28px','width':'268px'});
									aggregateTypeContainerObj.getEl().setStyle({'margin-left' : '-15px','width':'215px'});
									aggregateTypeComboObj.doLayout();
									siteDirContainerObj.doLayout();
								}

								if ((Ext.getCmp('siteDirMultiSelect')).isVisible)
								{
									siteDirContainerObj.getEl().setStyle({'margin-left' : '-28px','width':'268px'});
									aggregateTypeContainerObj.getEl().setStyle({'margin-left' : '-15px','width':'215px'});
									aggregateTypeComboObj.doLayout();
									siteDirContainerObj.doLayout();
								}

								if ((Ext.getCmp('compMultiSelect')).isVisible && (Ext.getCmp('siteDirMultiSelect')).isVisible)
								{
									siteDirContainerObj.getEl().setStyle({'margin-left' : '-28px','width':'268px'});
									aggregateTypeContainerObj.getEl().setStyle({'margin-left' : '-15px','width':'215px'});
									compMultiselectContainerObj.getEl().setStyle({'width':'220px'});
									aggregateTypeContainerObj.doLayout();
									siteDirContainerObj.doLayout();
								}
							
								aggregateTypeLblObj.show();
							}
						}
						else{
							aggregateTypeComboObj.hide();
							var aggregateTypeLblObj = Ext.getCmp('aggregateTypeLbl');
							aggregateTypeLblObj.hide();
						}
					}

					var siteDirMultiSelectObj = Ext.getCmp('siteDirMultiSelect');
					if(!Ext.isEmpty(siteDirMultiSelectObj) && siteDirMultiSelectObj!=null && siteDirMultiSelectObj!=undefined && !Ext.isEmpty(jsonData['listViewSiteAndDirector']) && (jsonData['listViewSiteAndDirector'] != null && jsonData['listViewSiteAndDirector'] != undefined && jsonData['listViewSiteAndDirector']['selectedOptions']).length > 1 && jsonData['listViewSiteAndDirector']['selectedTypeValue'] != 'None')
					{
						var siteDirMultiSelectJson = jsonData['listViewSiteAndDirector']['selectedOptions'];
						siteDirMultiSelectObj.getStore().loadRawData(siteDirMultiSelectJson);
						var value = jsonData['listViewSiteAndDirector']['selectedTypeValue'];
						var  aggregateTypeContainerObj = Ext.getCmp('aggregatesContainer');
						siteDirMultiSelectObj.setValue(value);
					
						var siteDirTitle = screenLablesJson['monitor.common.SitesAndDirector'];
						var siteDirMultiLblObj = Ext.getCmp('siteDirMultiLbl');
						if(!Ext.isEmpty(siteDirMultiLblObj) && siteDirMultiLblObj!=null && siteDirMultiLblObj!=undefined){
							siteDirMultiLblObj.setText(siteDirTitle);

							if(Ext.getCmp('compMultiSelect') != null && !Ext.isEmpty(Ext.getCmp('compMultiSelect')) && (Ext.getCmp('compMultiSelect')).isVisible){
									siteDirMultiSelectObj.getEl().setStyle({'margin-left' : '20px'});
									siteDirMultiLblObj.getEl().setStyle({'margin-left' : '21px'});
									aggregateTypeContainerObj.getEl().setStyle({'width':'235px'});
									if(!Ext.isEmpty(customConfigTemplateWindow) && customConfigTemplateWindow != null && customConfigTemplateWindow != undefined)
										customConfigTemplateWindow.doLayout();
							}
							siteDirMultiLblObj.show();
						}
						siteDirMultiSelectObj.show();
					}
					else{
						siteDirMultiSelectObj.hide();
						var siteDirMultiLblObj = Ext.getCmp('siteDirMultiLbl');
						siteDirMultiLblObj.hide();
					}
					jsonData=null;
					delete jsonData;
				}
				jsonText=null;
				delete jsonText;
			}
		});
	},
	checkboxClick: function(obj,newValue,oldValue,eOpts)
	{
		var renderCheckBox = Ext.query('div.addCheckBox');
		var checked = obj.getValue();
		if(checked)
		{
			Ext.getCmp('deleteAllSeparator').show();
			for (var i = 0; i < renderCheckBox.length; i++ )
			{
				var chkBoxObj = Ext.getCmp('cc_'+i);
				if(!Ext.isEmpty(chkBoxObj.data) && chkBoxObj.data!=null && chkBoxObj.data!=undefined && chkBoxObj.data=='DefaultDashboard')
				{
					continue;
				}
				var isshared = chkBoxObj.SharedData;
				if(isshared == 'false')
				{
					chkBoxObj.setValue(true);
					chkBoxObj.show();
				}
			}
			Ext.getCmp('DeleteListOfDashboards').show();
		}
		else
		{
			Ext.getCmp('deleteAllSeparator').hide();
			for (var i = 0; i < renderCheckBox.length; i++ )
			{
				var chkBoxObj=Ext.getCmp('cc_'+i);
				chkBoxObj.setValue(false);
				chkBoxObj.hide();
			}
			Ext.getCmp('DeleteListOfDashboards').hide();
		}
	},
	deleteSelectedDashBoards : function()
	{
		var panelViewId = Ext.getCmp('myDashListPageView');
		var meC = this;
		var selectedDashBoards = '';
		var renderCheckBox = Ext.query('div.addCheckBox');
		deletedDefaultView =  false;
		for( var i = 0; i < renderCheckBox.length; i++ )
		{
			var ccc = Ext.getCmp('cc_'+i);
			if(ccc.checked)
			{
				selectedDashBoards +='$'+ccc.data;
				if(!Ext.isEmpty(ccc.data) && !Ext.isEmpty(defaultView) && ccc.data==defaultView)
				{
					deletedDefaultView = true;
				}
			}
			if(selectedDashBoards!=null && selectedDashBoards.indexOf('$')==0)
			{
				selectedDashBoards = selectedDashBoards.substr(1);
			}
		}
		if(selectedDashBoards.length > 0)
		{
			Ext.Msg.show({
				title:ctxDashboardAlertLbl,
				msg:deleteDashboardsMsg+"?",
				buttons: Ext.Msg.YESNO,
				icon: 'iconConfirmation',
				fn:function(buttonId)
				{
					if(buttonId =="yes")
					{
						Ext.Ajax.request({
						url : '/final/servlet/com.eg.EgCommonDashboardController?comesFrom=listViewPage&action=deleteCtxDashboard&dashboardNames='+encodeURIComponent(selectedDashBoards)+'&iniName='+iniName+'&fromSerComboChange='+fromSerComboChange+'&dashboard_name='+dashboard,
						method: 'POST',
						scope: this,
							success: function (response) {
								var jsonText = response.responseText;
								var ctxDashListJson = '';
								if(!Ext.isEmpty(jsonText)) {
									ctxDashListJson = Ext.decode(jsonText);
								}
								Ext.getCmp('selectAllDashboards').setValue(false);
								panelViewId.removeAll();
								panelViewId.setLoading(false);
								panelViewId.doLayout();
								meC.loadListViewPage(ctxDashListJson);
							}
						});
					}
				}
			});
		}
		else
		{
			Ext.Msg.show({
				title : ctxDashboardAlertLbl,
				msg : deleteAlertMsg,
				buttons : Ext.MessageBox.OK,
				icon : Ext.MessageBox.WARNING
			});
			return;
		}
	},
	deleteSingleDashboard :function(dashboardName)
	{
		var meC=this;
		var dataViewId = Ext.getCmp('dataViewId');
		var dashboardName = dashboardName;
		deletedDefaultView = false;
		Ext.Msg.show({
			title:ctxDashboardAlertLbl,
			msg:deleteDashboardMsg+"?",
			buttons: Ext.Msg.YESNO,
			modal:true,
			ghost:false,
			cls:'ctxWindowModal',
			icon: 'iconConfirmation',
			listeners:{
				show: function(win)
				{
					if (this.modal)
					{
						var dom = Ext.dom.Query.select('.x-mask');
						
						var el = Ext.fly(dom[dom.length-1]);
						
						el.addCls('ctxWindowModal');
					}
				},
				hide: function(win)
				{
					if (this.modal)
					{
						var dom = Ext.dom.Query.select('.x-mask');
						var el = Ext.fly(dom[dom.length-1]);
						el.removeCls('ctxWindowModal');
					}
				}	
			},
			fn:function(buttonId)
			{
				if(buttonId =="yes")
				{
					var selectedDashboard = dashboardName;
					Ext.Ajax.request({
						url : '/final/servlet/com.eg.EgCommonDashboardController?comesFrom=listViewPage&action=deleteCtxDashboard&dashboardNames='+encodeURIComponent(selectedDashboard)+'&iniName='+iniName+'&screenWidth=' + (Ext.getBody().getViewSize().width) + '&screenHeight=' + (Ext.getBody().getViewSize().height)+'&fromSerComboChange='+fromSerComboChange+'&dashboard_name='+dashboard,
						method: 'POST',
						scope: this,
						success: function (response) {
							var jsonText = response.responseText;
							if(!Ext.isEmpty(jsonText))
							{
								ctxDashList = Ext.decode(jsonText);
							}
							Ext.Msg.show({
								title: ctxDashboardAlertLbl,
								msg: singleDashboardDeleteMsg,
								buttons: Ext.MessageBox.OK,
								icon: Ext.MessageBox.WARNING
							});
							//if(isListView)
							//{
								if(!Ext.isEmpty(defaultView) && !Ext.isEmpty(selectedDashboard) && selectedDashboard==defaultView)
								{
									deletedDefaultView = true;
								}
								meC.loadListViewPage(ctxDashList);
							/*}
							else
							{
								var deleteDashUrl = "/final/monitor/citrixDashboard.jsp?&userBased=true&fromMenu=true&showConfig=true&dashboard_name="+dashboard+"&iniName="+iniName+"&deleted_dashboard_mapping="+selectedDashboard;
								citrixDashboard.app.getController("Main").goToCitrixDashboard(deleteDashUrl);
							}*/
						}
					});
				}
			}
		}).setHeight(120);
	},
	setThisCtxDashboardAsHome : function(dashboardName) {
		var meC = this;
		Ext.Msg.show({
			title:ctxDashboardAlertLbl,
			msg:setasHome+"?",
			modal:true,
			ghost:false,
			cls:'ctxWindowModal',
			buttons: Ext.Msg.YESNO,
			icon: 'iconConfirmation',
			listeners:{
				show: function(win)
				{
					if (this.modal)
					{
						var dom = Ext.dom.Query.select('.x-mask');
						
						var el = Ext.fly(dom[dom.length-1]);
						
						el.addCls('ctxWindowModal');
					}
				},
				hide: function(win)
				{
					if (this.modal)
					{
						var dom = Ext.dom.Query.select('.x-mask');
						var el = Ext.fly(dom[dom.length-1]);
						el.removeCls('ctxWindowModal');
					}
				}	
			},
			fn:function(buttonId)
			{
				if(buttonId =="yes")
				{
					dashboardName = unescape(dashboardName);
					Ext.Ajax.request({
						url : '/final/servlet/com.eg.EgCommonDashboardController?comesFrom=listViewPage&action=setAsHomeDash&dashboardNames=' + encodeURIComponent(dashboardName)+'&iniName='+iniName+'&fromSerComboChange='+fromSerComboChange+'&dashboard_name='+dashboard,
						method : 'POST',
						scope : this,
						success : function(response) {
							var jsonText = response.responseText;
							if (jsonText != null && jsonText != '') {
								var setAsHomeJson = Ext.decode(jsonText);
								defaultMyDashboard = dashboardName;
								defaultView = setAsHomeJson['myDashboardsList']['defaultMyDashboard'];
									meC.loadListViewPage(setAsHomeJson);
							}
							jsonText=null;
							delete jsonText;
						}
					});
				}
			}
		});
	},
	goToCitrixDashboard : function(citrixDashUrl) {
		document.location = citrixDashUrl;
	},
	checkBlankSpc : function(dashboardName) {
		dashboardName.replace(/^[\s]+/, '').replace(/[\s]+$/, '').replace(/[\s]{2,}/, ' ');
		if (dashboardName.length == 0 || dashboardName == "") {
			return true;
		}
		return false;
	},
	checkSpecialCharacter : function(dashboardName) {
		var splChar = "%&+=\"?#";
		for (var i = 0; i < dashboardName.length; i++) {
			check_char = splChar.indexOf(dashboardName.charAt(i))
			// Returns value 1 if the special character listed
			// in splChar is found
			if (check_char >= 0) {
				return true;
			}
		}
		return false;
	}
});