Ext.create('Ext.data.Store', {
    fields:['description', 'users','high','intermediate','low'],
	id:'simpsonsStore',
    data:{'items':[
        { "description":"User profile size is large", "users":"10", "high":"6", "intermediate":"2", "low":"1"},
		 { "description":"User logon is slow", "users":"7", "high":"4", "intermediate":"1", "low":"4"},
		 { "description":"CPU time used is high", "users":"5", "high": "1", "intermediate":"5", "low":"2"},
		 { "description":"Memory time used is high", "users":"4", "high":"1", "intermediate":"2", "low":"4"},
		 { "description":"Sed ut perspiciatis unde omnis", "users":"3", "high":"1", "intermediate":"2", "low":"2"},

		
    ]},
    proxy: {
        type: 'memory',
        reader: {
            type: 'json',
            root: 'items'
        }
    }
});

Ext.define('citrixDashboard.view.AlertsGrid', {
	extend:'Ext.panel.Panel',
	alias:'widget.alertsgrid',
	autoDestroy:true,
	//bodyPadding:'10 20 10 20',
	padding:'0 20 10 20',
	flex:1,
	//margin:'0 2 10 0',
	initComponent:function(){
			var me = this;
			me.items = me.loadGrid();
			me.callParent();
	},
	loadGrid:function(){
		var me = this;
		var grid = Ext.create('Ext.grid.Panel', {
				flex:1,
				cls:'gridSkin gridHeader',
				store: Ext.data.StoreManager.lookup('simpsonsStore'),
				columns: [
					{ text: 'DESCRIPTION', dataIndex: 'description',flex:1},
					{ text: 'USERS', dataIndex: 'users',flex:1 },
					{ text: '<div class="state_HIGH"></div>', dataIndex: 'high',flex:1 },
					{ text: '<div class="state_INTERMEDIATE"></div>', dataIndex: 'intermediate',flex:1 },
					{ text: '<div class="state_low"></div>', dataIndex: 'low',flex:1 }
				]
			});
		return grid;
	}
   
});