
Ext.define('citrixDashboard.view.AlertsWidgets', {
     extend: 'Ext.container.Container',
	alias:'widget.alertswidgets',
	requires:[
			'citrixDashboard.view.UniqueSessionsWidget',
			'citrixDashboard.view.CurrentStatus',
			//'widgets.StatusBar',
			'citrixDashboard.view.OpenAlerts'
	 ],
	layout:{
			type:'hbox',
			align:'stretch'
	},
	flex:1,
	padding:0,
	defaults:{
		flex:1,
		padding:'20 10 20 10',
	},
	data:'',
	autoDestroy:true,	
	initComponent:function(){
		var overviewwidgets =  this;
		overviewwidgets.callParent();
	},
	updateData:function(data){
		var currentstatusid = Ext.getCmp('currentstatus_id');
		currentstatusid.updateData(data[0]);
		var openalertsid = Ext.getCmp('openalerts_id');
		openalertsid.updateData(data[1]);
	},
	listeners:{
		'afterrender':function(x){
			var me = this;
			if(me.data != undefined && me.data != null)
			{
				me.add(
					{
						xtype:'currentstatus',
						data:me.data[0],
						flex:0.45,
						id:'currentstatus_id'
					},
					{
						xtype:'container',
						flex:0.01,
						//cls:'dottedDivider'
						html:'<div class="dottedDivider" style="margin-top:3px;height:110px"></div>'
					},
					{
						xtype:'openalerts',
						padding:'14 0 0 20',
						data:me.data[1],
						flex:0.55,
						id:'openalerts_id'
					}					
				);
			}
		}
	},
	items:[]
 });