Ext.define('EstablishedSessionModel', {
    extend: 'Ext.data.Model',
    fields: [
        { name:'state', type:'string' },
        { name:'heading', type:'string' },
        { name:'value', type:'number' },
		{ name:'legend', type:'string' },
		{ name:'sessions' },
		{ name:'graphID', type:'string' }
    ]
});

Ext.create('Ext.data.Store', {
    id:'Establishedsession_model_id',
    model: 'EstablishedSessionModel',
	autoLoad:true,
    data: [
        {  
			"state":"HIGH" ,
			"heading":"Established Session",
			"value":"24",
			"legend":"No.s",
			"sessions":[
				{"name":"desktop_session","y":8,"color": "#a1b0e7","text": "Desktop","value": "11"},	
				{"name":"tab_session","y":4,"color": "#ced4b0","text": "Mobile","value": "4"},

			]
		}
    
    ]
});

// .stateIconRumAppFlowHealthy, .stateIconRumAppFlowMinor, .stateIconRumAppFlowMajor, .stateRumAppFlowNotOk
var AlertsTpl = new Ext.XTemplate(
	'<div class="widgetholders">',
    '<tpl for=".">',
        '<div class="b_box">',
		  '<div class="font_bold14"><img style="vertical-align:sub" src="/final/images/clear.png" class="stateIconRumAppFlow{state}" /> <span>{heading}</ span></div>',
			 '<div  style="text-align:center;width:60px;height:60px;float:left" id="establishedsession-graph"></div>',
			 '</div>',
			 '<div style="clear:both"></div>',
			'<div class="sessions_legends" style="margin-top:0px !important">',
			'<table style="margin-right:0px;margin-top:128px"><tr>',
			'<tpl for="sessions">',
			'<td style="padding:8px;"><div style="width:5px;height:5px;background:{color}"></div></td><td class="font_normal11">{text}({value})</td>',
			'</tpl>',
			'</tr></table>',
			'</div>',
        '</div>',
    '</tpl>',
	'</div>'
);

Ext.define('citrixDashboard.view.BigDonutCount', {
     extend: 'Ext.container.Container',
	alias:'widget.bigdonutcount',
	cls:'widgetcon',
	ui:'uniqueSessions',
	autoDestroy:true,
	data:'',
	items:[],
	listeners:{
		'afterrender':function(e){
			AlertsTpl = new Ext.XTemplate(
				'<div class="widgetholders">',
				'<tpl for=".">',
					'<div class="b_box">',
					  '<div class="font_bold14"><img style="vertical-align:sub" src="/final/images/clear.png" class="stateIconRumAppFlow{state}" /> <span>{heading}</ span></div>',
						 '<div  style="text-align:center;width:60px;height:60px;float:left" id="establishedsession-graph"></div>',
						 '</div>',
						 '<div style="clear:both"></div>',
						'<div class="sessions_legends" style="margin-top:0px !important">',
						'<table style="margin-right:0px;margin-top:128px"><tr>',
						'<tpl for="sessions">',
						'<td style="padding:8px;"><div style="width:5px;height:5px;background:{color}"></div></td><td class="font_normal11">{text}({value})</td>',
						'</tpl>',
						'</tr></table>',
						'</div>',
					'</div>',
				'</tpl>',
				'</div>'
			);
			var Bdonut_item = getBigDonutItem(this.data);
			this.add(Bdonut_item);
		}
	 }
 });

function getBigDonutItem(dummyData){
	var donutItem = 
			{
				xtype:'dataview',
				padding:5,
				store: Ext.data.StoreManager.lookup('Establishedsession_model_id'),
				tpl: AlertsTpl,
				listeners:{
					//'resize':function(x){
					viewready:function(x){
						var jsonData = '';
						if(!Ext.isEmpty(dummyData)){
							try
							{
								var pieChart = {};
								//pieChart = jQuery.extend(true, {}, getDonutChartsInstance1(this.id,height-25,width/3), pieChart);
								//data1['fghffh']=7;
								dummyData['outersize']='140%';
								dummyData['innersize']='45%';
								pieChart = jQuery.extend(true, {}, getDonutChartsInstance1(this.id,170,170), pieChart);
								pieChart.setData(dummyData,'','','donut');
								jsonData = pieChart.highchart;
							}
							catch (er)
							{
								console.log("er=-=-=->",er)
							}
						}
						else
						{
							jsonData = {
								chart: {
									
									type: 'pie',
									spacingBottom: 0,
									spacingTop: 0,
									spacingLeft: 0,
									spacingRight: 0,
									width: 170,
									height:170,
									backgroundColor: null
									},
									tooltip: {
										enabled: false
									},

									title: {
										text: '47',
										align: 'center',
										verticalAlign: 'middle',
										y: 10
									},
									exporting: {
										enabled: false
									},
									credits: {
										enabled: false
									},
									plotOptions: {
										pie: {
											borderColor: '#fff',
											showInLegend: false,
											innerSize: '65%',
											 dataLabels: {
													enabled: false
												},
											showInLegend: false
										}
									},

									series: [{
									   data: Ext.data.StoreManager.lookup('Establishedsession_model_id').data.items[0].data.sessions
										}
									]
								}
						}
		   
							$('#establishedsession-graph').highcharts(jsonData); 
							
					}
				}
			};
			return donutItem;
	}