 Ext.define('RumAppFlow.view.ChartPanel', {
     extend: 'Ext.panel.Panel',
     alias: 'widget.chartpanel',
	//cls:'animation_box',
	 border: true,
     flex: 1,
     ui: 'eg-x-panel',
     margin: '0 1 1 0',
     bodyPadding: '0 20 20 20',
     height: 301,
     title: 'Response time breakup - Desktop',
	legendPosition: 'bottom', // top,left, bottom and right
    chartType: 'area', // pie,line,column,area -  chart type
     layout: {
         type: 'vbox',
         align: 'stretch'
     },
     config: {
         data: null
     },
	data:[],
     constructor: function(config) {
         this.initConfig(config);
         this.callParent(arguments);
     },
     initComponent: function() {
         var me = this;
		 me.mon(me, 'boxready', me.loadChart, me);
		 me.mon(me, 'resize', me.resizePanel, me);
		 me.mon(me, 'removed', me.destroyChart, me);
         me.callParent(arguments);
	 },
     updateChart: function(el,data,chartType) {
         var me = this;
         $('#' + el).highcharts(me.chartConfig(data,chartType));
     },
	 destroyChart:function(){
		 try
		 {
			var me = this,chartObj = $('#'+me.body.id).highcharts();
			if(!Ext.isEmpty(chartObj)){
				chartObj.destroy();
			}	
		 }
		 catch (e)
		 {
		 }	
	 },
	 resizePanel:function(){
		var me = this,chartObj = $('#' + me.body.id).highcharts();
		if(!Ext.isEmpty(chartObj)){
			alert("chartObj=-=-=->"+chartObj)
			chartObj.reflow();
		}
	 },
     loadChart: function() {
         var me = this;
         $('#' + me.body.id).highcharts(me.chartConfig(me.data,me.chartType));
		 
     },
     chartLegendAlignment: function(obj) {
         var me = this,
				alignment, 
				verticalAlign = me.legendPosition;
         switch (verticalAlign) {
             case "top":
                 alignment = "center";
                 verticalAlign = "top";
                 Ext.apply(obj, {
                     align: alignment,
                     verticalAlign: verticalAlign,
                     layout: 'horizontal'
                 });

                 break;
             case "bottom":
                 alignment = "center";
                 verticalAlign = "bottom";
                 Ext.apply(obj, {
                     align: alignment,
                     verticalAlign: verticalAlign,
                     layout: 'horizontal'
                 });

                 break;
             case "left":
                 alignment = "left";
                 verticalAlign = "middle";
                 Ext.apply(obj, {
                     align: alignment,
                     verticalAlign: verticalAlign,
                     layout: 'vertical'
                 });

                 break;
             case "right":
                 alignment = "right";
                 verticalAlign = "middle";
                 Ext.apply(obj, {
                     align: alignment,
                     verticalAlign: verticalAlign,
                     layout: 'vertical'
                 });
                 break;
         }

     },
     chartConfig: function(data,chartType) {
         var me = this;
		 chartType = me.chartType;
		// @chartConfig
		 me.chartProps = {
             chart: {
                 type: chartType,
                 backgroundColor: 'transparent'
             },
             title: "",
             exporting: {
                 enabled: false
             },
             credits: {
                 enabled: false
             },
				
             legend: {
                 symbolWidth: 6,
                 symbolHeight: 6,
                 squareSymbol: false,
                 symbolRadius: 6,
                 itemMarginTop: 10,
                 itemHoverStyle: {
                     "color": "#84b8e4"
                 },
                 itemStyle: {
                     fontSize: "11px",
                     fontWeight: "normal",
                     fontFamily: "Arial"
                 },
                 y: 0
             },
             tooltip: {
                 formatter: function() {
                     return this.point.name + '</b>: ' + Math.round(this.percentage * 100) / 100 + ' %';
                 }
             }
            /* series: [{
                 data: data
             }]*/
         }
		// @setting the chartConfig
		 switch(chartType){
			case "pie" :
		
			Ext.apply(me.chartProps, {
                     chart: {
							type: chartType,
							 backgroundColor: 'transparent'
						},
						 plotOptions: {
							 pie: {
								 shadow: false,
								 showInLegend: true,
								 startAngle: 0,
								 endAngle: 360,
								 borderWidth: 0,
								 size: '85%',
								 shadow: false,
								 dataLabels: {
									 distance: -25,
									 enabled: false,
									 formatter: function() {
										 return Math.round(this.percentage * 100) / 100 + ' %';
									 },
									 style: {
										 fontWeight: 'bold',
										 color: '#FFFFFF'
									 }
								 }
							 }

						 },
					  series: [{
								data: data
						}]
                 });
			break;
			case "area" :
			Ext.apply(me.chartProps, {
                     chart: {
							type: chartType,
							 backgroundColor: 'transparent'
						},
						yAxis: {
							allowDecimals: false,
							gridLineWidth: 0,
							title: {
									 text: 'Page load time'
							}
						},
						xAxis: {
							gridLineWidth: 1,
							 categories: ['11', '11:20', '11:30', '11:40', '11:50'],
							
							title: {
									 text: 'Time hrs'
							}
						},
						plotOptions: {
							
							 series:{
							 fillOpacity: 1
							 }
						},
					  series: data
                 });
			break;
			case "line" :
			Ext.apply(me.chartProps, {
                     chart: {
							type: chartType,
							 backgroundColor: 'transparent'
						},
						yAxis: {
							allowDecimals: false,
							gridLineWidth: 0,
							title: {
									 text: 'Page load time'
							}
						},
						xAxis: {
							gridLineWidth: 1,
							allowDecimals: false,
							title: {
									 text: 'Time hrs'
							}
						},
						plotOptions: {
						
						},
					  series: data
                 });
			break;
			case "column":
				
			Ext.apply(me.chartProps, {
                     chart: {
							type: chartType,
							 backgroundColor: 'transparent'
						},
					yAxis: {
							allowDecimals: false,
							gridLineWidth: 0,
							title: {
									 text: 'Page load time'
							}
						},
						xAxis: {
							gridLineWidth: 1,
							allowDecimals: false,
							title: {
									 text: 'Time hrs'
							}
						},
					plotOptions: {
							 series: {
									allowPointSelect: true
							}
					},
					  series: data
                 });
				break;
		 }
         me.chartLegendAlignment(me.chartProps.legend);
         return me.chartProps;
     }
    
 });
 