 Ext.define('RumAppFlow.view.ChartParentPanel', {
	 extend: 'Ext.panel.Panel',
     alias: 'widget.chartparentpanel',
	requires:['RumAppFlow.view.ChartPanel'],
	margin:'10 0 0 0',
	defaults:{
		columnWidth: 0.5,
		 height: 301
	 },
	layout:'column',
	manageOverflow:2,
	config: {
         data: null
     },
     constructor: function(config) {
         this.initConfig(config);
         this.callParent(arguments);
     },
	initComponent: function() {
         var me = this,item=[];
		// @ render the chart panel
		me.renderChart(me.data)
        me.callParent(arguments);
     },
	chartPanelObj:function(){
		return { xtype:'chartpanel'}
	 },
	renderChart:function(data){
		var me = this,chartitemArry=[],margin="";
		if(!Ext.isEmpty(data)){
			 Ext.suspendLayouts();
			for (var i= 0; i <  data.length;i++ )
			{
					//legendPosition: 'bottom', // top,left, bottom and right
					//chartType: 'area', // pie,line,column,area -  chart type
					if(i%2 == 0){
						margin = '0 8 8 0';
					}else{
						margin = '0 2 8 0';
					}
					var chartTypes = '';
					chartitemArry.push(Ext.apply(me.chartPanelObj(), {
						"title": data[i].title,
						"data":data[i].data,
						margin:margin,
						tools:[
						{
							xtype:'label',
							text: data[i].chartHistory
						}
						],
						"chartType": data[i].chartType,
						"legendPosition": data[i].legendPosition
					}));

			}
			me.items = chartitemArry;
			Ext.resumeLayouts(true);
		}

	 }
 })