Ext.define('CitrixDashMenuModel', {
    extend: 'Ext.data.Model',
    fields: [{
        name: 'name'
    }, {
        name: 'caption'
    }, {
        name: 'lcaption'
    }, {
        name: 'children'
    }, {
        name: 'iconCls'
    }, {
        name: 'id'
    }, {
        name: 'isParent'
    }]
});

Ext.create('Ext.data.Store', {
    id: 'citrixdashmenu_model_id',
    model: 'CitrixDashMenuModel',
    autoLoad: true,
    data: requestParams.views
});

var citrixDashMenuTpl = new Ext.XTemplate(
    '<div class="sidebarmenu">',
    '<ul>',
    '<tpl for=".">',
    '<li class="x-item <tpl if="children"><tpl if="id != \'seeMore\'">has-sub</tpl> submenuitems</tpl>" id={id}>',
    '<a href="javascript:void(0)" id="{id}-link"><img id="{id}-images"  style="vertical-align:middle;" src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" class="{iconCls}" /><span>{lcaption}</span></a>',
    '<tpl if="children">',
    '<ul class="<tpl if="id == \'seeMore\'">seeMoreMenu </tpl>submenu">',
    '<tpl for="children">',
    '<li  class="x-item x-item-child" index={#} id={id}>',
    '<a href="javascript:void(0)" id="{id}-link"><img id="{id}-images" style="vertical-align:middle;" src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" class="{iconCls}" /> <span>{lcaption}</span></a>',
    '</li>',
    '</tpl>',
    '</ul>',
    '</tpl>',
    '</li>',
    '</tpl>',
    '</ul>',
    '</div>'
);

Ext.define('citrixDashboard.view.CitrixDashMenu', {
    extend: 'Ext.view.View',
    ui: 'sidebar',
    alias: 'widget.citrixdashmenu',
    id: 'dashmenu_model_id',
    store: Ext.data.StoreManager.lookup('citrixdashmenu_model_id'),
    tpl: citrixDashMenuTpl,
    trackOver: false,
    multiSelect: true,
    scroll: true,
    autoScroll: true,
    //overItemCls:'eg-menu-view-over',
    //itemSelector: 'li.menu-wrap',
    itemSelector: '.x-item',
    emptyText: '',
    listeners: {
        itemclick: function(menu, record, item, index, event, eOpts) {
            var selectedRecord = record.data,
                subMenuIndex = "";
            selected = menu.getSelectionModel().getSelection(),
                me = this,
                selectedRecord = record.data,
                visibleSubmenu = $('li ul.submenu:visible'),
                submenu = $(item).find('ul.submenu'),
                seeMoreID = $('li.x-item-selected #seeMore-link').is(":visible");
            thatSubMenu = $("" + me.itemSelector + ".x-item-selected").find('.submenu');

            if (!Ext.isEmpty(record.get('children'))) {
                //submenu child event
                var childrenIndex = Ext.fly(item).getAttribute('index'),
                    subMenuItems = record.get('children');

                if (!Ext.isEmpty(subMenuItems[childrenIndex - 1])) {
                    selectedRecord = subMenuItems[childrenIndex - 1];
                    subMenuIndex = childrenIndex - 1;

                    var thisSubMenu = $(item).parent().closest("li" + me.itemSelector + ".x-item-selected").find('.submenu').is(":visible");

                    var moreLinkVisible = $("li" + me.itemSelector + "").find('#seeMore-link').is(":visible");
                    $(this).siblings().find("ul").hide();
                    //close other submenu 
                    if (!thisSubMenu) {
                        thatSubMenu.slideUp({
                            easing: 'swing'
                        });
                        //remove the arrow selected
                        $("" + me.itemSelector + ".x-item-selected").removeClass('x-selected');
                    } else {
                        //    
                    }
                    //load the view Fn
                    requestParams.activeView = selectedRecord.id;
                    setSession(requestParams.activeView);
                    var me = this,
                        innerCard = citrixDashboard.app.getController('Main').getMain().getComponent('citrix_ground').getComponent('cardID');

                    if (!Ext.isEmpty(innerCard)) {
                        innerCard.stopAnimation();
                        innerCard.animate({
                            duration: 500,
                            to: {
                                'opacity': 0
                            },
                            listeners: {
                                afteranimate: function() {
                                    citrixDashboard.app.getController('Main').addPage(selectedRecord.caption);
                                }
                            },
                            scope: citrixDashboard.app.getController('Main').getMain()
                        });
                    }
                } else {
                    //Parent item event
                    //if menu is open 
                    $(item).addClass('currentSel').siblings().removeClass('currentSel');
                    if (!submenu.is(":visible")) {
                        var moreLinkVisible = $(this.getNode(record)).find('#seeMore-link').is(":visible");
                        if (moreLinkVisible) {
                            $("li" + me.itemSelector + "").find('#seeMore-link').hide();

                        } else {
                            $("li" + me.itemSelector + "").find('#seeMore-link').show();

                        }
                        if (submenu.length >= 1) {
                            try {
                                event.preventDefault();
                            } catch (e) {}

                            submenu.slideToggle('fast', function() {
                                //to roll the submenu arrow
                                $(item).addClass('x-selected');
                            });
                        }
                        return false;
                    } else
                        return false;
                }

            } else {
                //Parent without children  event
                selectedRecord = record.data;

                if (visibleSubmenu.length >= 1) {
                    try {
                        event.preventDefault();
                    } catch (e) {}


                    if (!$('#seeMore-link').is(':empty'))
                        $("" + me.itemSelector + "").find('#seeMore-link').show();

                    if ($("" + me.itemSelector + "").hasClass('x-selected'))
                        $("" + me.itemSelector + "").removeClass('x-selected');

                    visibleSubmenu.slideUp({
                        speed: 'fast',
                        easing: 'swing'
                    });

                }
                //load the view Fn
                requestParams.activeView = selectedRecord.id;
                setSession(requestParams.activeView);
                var innerCard = citrixDashboard.app.getController('Main').getMain().getComponent('citrix_ground').getComponent('cardID');
                if (!Ext.isEmpty(innerCard)) {
                    innerCard.stopAnimation();
                    innerCard.animate({
                        duration: 500,
                        to: {
                            'opacity': 0
                        },
                        listeners: {
                            afteranimate: function() {
                                citrixDashboard.app.getController('Main').addPage(selectedRecord.caption);
                            }
                        },
                        scope: citrixDashboard.app.getController('Main').getMain()
                    });
                }
            }
        },
        viewready: function(view) {
            //for POC
            var allRecords = view.store.snapshot || view.store.data;
            var dupData = requestParams.views;
            //Highlight menu onload
            var index = null;
            var subIndex = null;
            for (var r = 0; r < dupData.length; r++) {
                if (Ext.isEmpty(dupData[r].children)) {
                    if (requestParams.activeView == dupData[r].id) {
                        index = r;
                    }
                } else {
                    var childrenArray = dupData[r].children;
                    for (var y = 0; y < childrenArray.length; y++) {
                        if (requestParams.activeView == childrenArray[y].id) {
                            subIndex = y;
                            index = r;
                        }
                    }
                }
            }
            view.onLoadSelectItem(index, allRecords.items[index], subIndex)
            view.toggleMenu();
        }
    },
    toggleMenu: function() {
        var me = this;
        $("#" + this.id).hover(
            //open
            function() {
                $(this).addClass('sidebarmenu-open');
                if ($("" + me.itemSelector + "").hasClass('x-item-selected')) {
                    // $(""+me.itemSelector+".x-item-selected").find('.submenu').show();
                    $("" + me.itemSelector + ".x-item-selected").find('.submenu').slideToggle('fast', function() {
                        //callback
                    });

                    if (!$('#seeMore-link').is(':empty')) {
                        $("" + me.itemSelector + ".x-item-selected").find('#seeMore-link').hide();
                    }
                }
                $(this).stop().animate({
                    width: 251,
                }, 300, 'linear', function() {
                    // callback

                });
            },
            //close
            function() {
                $(this).removeClass('sidebarmenu-open');
                //hide subMenu, if selected item has children 
                if ($("" + me.itemSelector + "").hasClass('x-item-selected')) {

                    $("" + me.itemSelector + "").find('.submenu').slideUp('fast', function() {
                        //callback
                    });
                }
                //Always show seeMore link in close state
                if (!$('#seeMore-link').is(':empty')) {
                    $('#seeMore-link').show();
                }
                //if submenu arrow is unselected submenuItem
                if ($("" + me.itemSelector + "").hasClass('x-selected')) {
                    $("" + me.itemSelector + "").removeClass('x-selected');
                }

                $(this).stop().animate({
                    width: 51
                }, 300, 'linear', function() {
                    // callback

                });
            }
        );
    },
    onItemSelect: function(record) {
        var node = this._selectedNode; //this.getNode(record);
        var me = this;
        if (node) {
            Ext.select('li.x-item').removeCls(me.selectedItemCls);
            Ext.select('li.x-item.x-item-selected').removeCls(me.selectedItemCls);
            Ext.fly(me.getNode(record)).addCls(me.selectedItemCls);
            Ext.fly(node).addCls(this.selectedItemCls);
            if (node.getAttribute('id') != this.getNode(record).getAttribute('id')) {
                if ($(me.getNode(record)).hasClass('submenuitems')) {
                    Ext.fly(node).addCls('x-item-selected');
                } else {
                    Ext.fly(node).removeCls('x-item-selected');
                    Ext.fly(me.getNode(record)).addCls('x-item-selected');
                }
            }
        } else {
            Ext.select('li.x-item').removeCls(me.selectedItemCls);
            Ext.select('li.x-item.x-item-selected').removeCls(me.selectedItemCls);
            Ext.fly(me.getNode(record)).addCls(me.selectedItemCls);
        }
    },
    onLoadSelectItem: function(selectedIndex, record, submenuIndex) {
        var node = record;
        if (node) {
            this.getSelectionModel().select(selectedIndex);
            Ext.fly(this.getNode(record)).addCls(this.selectedItemCls);
            Ext.fly(node).addCls(this.selectedItemCls);
            if (!Ext.isEmpty(node.data.children)) {
                var subMenuItem = node.data.children[submenuIndex];
                Ext.get(subMenuItem.id).addCls(this.selectedItemCls);
            }

            //animation on load
            $(".x-item").css({
                'marginLeft': "300px"
            });
            $(".x-item").each(function(i) {
                $(this).delay(100 * i).animate({
                    marginLeft: "0"
                }, 500);
            });
        }

    },
    onItemDeselect: function(record) {
        var node = this._deselectedNode; //this.getNode(record);
        Ext.select('li.x-item.x-item-selected').removeCls(this.selectedItemCls);
        Ext.select('li.x-item').removeCls(this.overItemCls);
        if (node) {
            Ext.fly(this.getNode(record)).removeCls(this.selectedItemCls);
            Ext.fly(node).removeCls(this.selectedItemCls);
        } else {
            var node = this.getNode(record);
            Ext.fly(this.getNode(record)).removeCls(this.selectedItemCls);
        }
    },
    onTriggerSelect: function(id) {
        var item = id,
            view = this;
        if (!Ext.isEmpty(id)) {
            var records = view.store.snapshot || view.store.data;
            var recs = records.items;
            recs.forEach(function(element, index, recs) {
                var recordID = element.data.id;
                if (!Ext.isEmpty(element.data.children)) {
                    element.data.children.forEach(function(childElement, childIndex) {
                        var recordID = childElement.id;
                        if (id == recordID) {}
                    });
                } else {
                    if (id == recordID) {
                        view.onItemSelect(element);
                    }
                }
            })
        }
    },
    processItemEvent: function(record, item, index, e) {
        if (e.type == "mousedown" && e.button == 0) {
            this._deselectedNode = this._selectedNode;
            this._selectedNode = item;
        }
    },
    updateIndexes: function(startIndex, endIndex) {
        var ns = this.all.elements,
            records = this.store.getRange(),
            i, j;

        startIndex = startIndex || 0;
        endIndex = endIndex || ((endIndex === 0) ? 0 : (ns.length - 1));
        for (i = startIndex, j = startIndex - 1; i <= endIndex; i++) {
            if (!Ext.fly(ns[i]).is('.x-item-child')) {
                j++;
            }
            ns[i].viewIndex = i;

            ns[i].viewRecordId = records[j].internalId;
            if (!ns[i].boundView) {
                ns[i].boundView = this.id;
            }
        }
    }
});