Ext.define('EstablishedSessionModel', {
    extend: 'Ext.data.Model',
    fields: [
        { name:'state', type:'string' },
        { name:'changeTabView', type:'string' },
        { name:'heading', type:'string' },
        { name:'value', type:'number' },
		{ name:'linkurl', type:'string' },
		{ name:'legend', type:'string' },
		{ name:'sessions' },
		{ name:'DataSet' },
		{ name:'data' },
		{ name:'graphID', type:'string' }
    ]
});
/*
	{
    "chart": "donut",
    "chartType": "donut",
    "state": "",
    "heading": "Established sessions",
    "legends": "",
    "donutSize": "Medium",
    "legendPos": "BOTTOM",
    "showTotalValinDonut": false,
    "DataSet": [{
        "data": [{
            "name": "Desktop",
            "y": 4,
            "value": 4,
            "color": "#99d3c4",
            "text": "Desktop"
        }, {
            "name": "Mobile",
            "y": 0,
            "value": 0,
            "color": "#ffcd50",
            "text": "Mobile"
        }]
    }]
}

*/
Ext.create('Ext.data.Store', {
    id:'Establishedsession_model_id',
    model: 'EstablishedSessionModel',
	autoLoad:true,
    data: [
        {  
			"state":"HIGH" ,
			//"heading":"Established Session",
			"value":"24",
			"legend":"No.s",
			"sessions":[
				{"name":"desktop_session","y":8,"color": "#a1b0e7","text": "Desktop","value": "11"},	
				{"name":"tab_session","y":4,"color": "#ced4b0","text": "Mobile","value": "4"},

			]
		}
    
    ]
});

// .stateIconRumAppFlowHealthy, .stateIconRumAppFlowMinor, .stateIconRumAppFlowMajor, .stateRumAppFlowNotOk

Ext.define('citrixDashboard.view.EstablishedSessions', {
     extend: 'Ext.panel.Panel',
	alias:'widget.establishedsessions',
	//cls:'widgetcon',
	ui:'uniqueSessions',
	autoDestroy:true,
	data:'',
	items:[],
	updateData:function(Udata){
		var dataViewI_Cmp_id = Ext.getCmp(this.id+'_dataview');
		//data.data[0].icon = 'alertIcon_User';
		dataViewI_Cmp_id.store.loadRawData(Udata);
		if(!Ext.isEmpty(Udata)){
			var jsonData = getDonutHighChartChartData(Udata,this.id);
		}		   
		$('#establishedsession-graph_'+this.id).highcharts(jsonData); 

	},
	listeners:{
		'afterrender':function(e){
			var strSkinclr = ( strSkin == 'Dark' )?'#6a6a6a':'#cdcdcd';

			AlertsTpl = new Ext.XTemplate(
				'<div class="widgetholders">',
				'<tpl for=".">',
					'<div class="c_box">',
					 // '<div class="font_bold14"><img style="vertical-align:sub" src="/final/images/clear.png" class="stateIconRumAppFlow{state}" /> <span>{heading}</ span></div>',
						 //'<div onmousedown="javascript:loadView(\'UED\',\'1\')" class="ctxMouse" style="border:0px solid red !important;display:block;text-align:center;width:100%;" id="establishedsession-graph_'+this.id+'"></div>',
						 '<div style="margin-top:20px;display:block;text-align:center;width:100%;" id="establishedsession-graph_'+this.id+'"></div>',
						 '</div>',
						'<div class="sessions_legends" style="display:block;border:0px solid red">',
						'<table style="margin-right:0px;margin-top:0px;margin:auto;"><tr>',
						'<tpl for="DataSet">',
							'<tpl for="data">',
							 '<tpl if="color !=&quot;'+strSkinclr+'&quot;">',
								'<tpl if="measure_org!=&quot;IDLE_TIME_MEASUREPRD&quot;">',
									'<td class="widgetholders ctxMouse" onclick=\"loadView(\'{changeTabView}\',\'{value}\',\'\',\'{test_org}\',\'{measure_org}\');\"><h3 style="color:{color};">.</h3><td style="padding-right:20px" class="widgetholders ctxMouse font_normal11" onclick=\"loadView(\'{changeTabView}\',\'{value}\',\'\',\'{test_org}\',\'{measure_org}\',\'{linkurl}\');\">{text}&nbsp;({value})</div></td>',
								'<tpl else>',
									'<td class="widgetholders"><h3 style="color:{color};">.</h3><td style="padding-right:20px" class="font_normal11">{text}&nbsp;({value})</div></td>',
								'</tpl>',
							 '</tpl>',
							'</tpl>',
						'</tpl>',
						'</tr></table>',
						'</div>',
					'</div>',
				'</tpl>',
				'</div>'
			);
			var Bdonut_item = getBigDonutItem(this.data,this.id);
			this.add(Bdonut_item);
		}
	 }
 });

function getBigDonutItem(dummyData,idObj){
	var donutItem = 
			{
				xtype:'dataview',
				//padding:5,
				id:idObj+'_dataview',
				//store: Ext.data.StoreManager.lookup('Establishedsession_model_id'),
				store: Ext.create('Ext.data.Store', {
					id:'Establishedsession_model_id',
					model: 'EstablishedSessionModel',
					autoLoad:true,
					data:dummyData
				}),
				tpl: AlertsTpl,
				listeners:{
					viewready:function(x){
						if(!Ext.isEmpty(dummyData)){
							var jsonData = getDonutHighChartChartData(dummyData,idObj);
						}		   
						$('#establishedsession-graph_'+idObj).highcharts(jsonData); 
							
					}
				}
			};
			return donutItem;
	}


	function getDonutHighChartChartData(dummyData1,idObj1){
		var jsonData = '';
		try
		{
			var pieChart = {};
			dummyData1['outersize']='129%';
			dummyData1['innersize']='64%';
			dummyData1['setTitle']=true;
			dummyData1['useHtml']=true;
			dummyData1['sessionGraphs']=true;
			pieChart = jQuery.extend(true, {}, getDonutChartsInstance1(idObj1,160,160), pieChart);
			pieChart.setData(dummyData1,'','','donut');
			jsonData = pieChart.highchart;
		}
		catch (er)
		{
			console.log("er=-=-=->",er)
		}
		return jsonData;
	}
