Ext.define('citrixDashboard.view.GeoMapControls', {
    extend: 'Ext.container.Container',
    alias: 'widget.geomapcontrols',
    autoDestroy: true,
    //margin: '0 10 0 0',
    padding: 0,
    width: 400,
    border: false,
    layout: {
        type: "hbox"
    },
    id: 'geomapHeaderID',
    items: [{
            xtype: 'label',
            cls: "b_label",
            text: 'Geo Map',
			 margin: '2 0 0 0',
        },
        {
            xtype: 'button',
            margin: '0 5',
            cls: 'infobutton',
            infoToolTip: function(btn) {
                var me = this;
                var tooltip = Ext.create("Ext.tip.ToolTip", {
                    anchor: "top",
					shadow: true,
                    anchorOffset: 25,
                    mouseOffset: [0, 0],
                    target: btn.id,
                    cls: "moreoptionstooltip",
                    listeners: {
                        hide: function(tooltip) {
                            if (!Ext.isEmpty(tooltip)) {
                                Ext.destroy(tooltip);
                            }
                        },
                        render: function(a) {
                            Ext.EventManager.onWindowResize(function(b, c) {
                                a.hide();
                            });
                        }
                    },
                    getTargetXY: function() {
                        var x = btn.el.getXY()[0];
                        var y = btn.el.getXY()[1];
                        return [x - tooltip.anchorOffset - 12, btn.getHeight() + y];
                    },
                    autoHide: false,
                    anchorToTarget: true,
                    width: 210,
                    padding: "10 2 10 10",
                    style: 'text-align:left',
                    html: "<div class='t_b'> <ol><li>Shows where Citrix users are coming from</li><li>Size of the geo-marker varies with the number of Citrix user sessions</li><li>State indicates the level of HDX latency experienced by the users connecting from a geography</li></ol></div>"
                });
				return tooltip;
            },
            handler: function(btn) {
                btn.infoToolTip(btn).show();				
            },
			iconCls: 'big_infoIcon'
        },{
            xtype: 'button',
            margin: '0 0',
			padding:0,
            cls: 'geoDrilldown',
			//text:'World',
			//iconCls:'geoDrilldownIcon',
			//text:'<span style="float:left">Countries</span><div class="geoDrilldownIcon"></div>',
			text:'<span style="float:left" class="geoDrilldownLink">Countries</span><div class="geoDrilldownArrow"></div>',
			id: 'world_icon',
			style:{'background':'none'},
            handler: function(btn) {
				try
				{
					var countryComboObj = Ext.getCmp('countryComboId');
					countryComboObj.setValue("World");
					citrixDashboard.app.getController('Main').geoComboOnChange(countryComboObj);
				}
				catch (e)
				{
				}
                
            },
			hidden:true,
			//iconCls: 'big_infoIcon'
        },
		{
            xtype: 'button',
			padding:0,
			margin:'0 0 0 -3px',
            cls: 'geoDrilldown',
			//iconCls:'geoDrilldownIcon',
			//text:'<span style="float:left">States</span><div class="geoDrilldownIcon"></div>',
			text:'<span style="float:left" class="geoDrilldownLink">States</span><div class="geoDrilldownArrow"></div>',
			id: 'region_icon',
            //cls: 'stateIcon_GOOD',
			style:{'background':'none','border':'0px solid red !important'},
            handler: function(btn) {
               try
				{
					var regionComboObj = Ext.getCmp('regionComboId');
					regionComboObj.setValue("AllRegion");
					citrixDashboard.app.getController('Main').geoComboOnChange(regionComboObj);
				}
				catch (e)
				{
				}			
            },
			hidden:true
			//iconCls: 'big_infoIcon'
        },
		{
            xtype: 'label',
			padding:0,
			cls:'geoDrilldownLabel',
			//iconCls:'geoDrilldownIcon',
			//text:'<span style="float:left">States</span><div class="geoDrilldownIcon"></div>',
			//text:'<span style="text-decoration:none;float:left" class="geoDrilldownLink">Region</span><div class="geoDrilldownArrow"></div>',
			text:'',
			id: 'region_label',
            		//cls: 'stateIcon_GOOD',
			style:{'top':'3px !important','border':'0px solid green !important'},
            hidden:true
			//iconCls: 'big_infoIcon'
        },
		{
            xtype: 'label',
			padding:0,
			cls:'geoDrilldownLabel',
			//iconCls:'geoDrilldownIcon',
			//text:'<span style="float:left">States</span><div class="geoDrilldownIcon"></div>',
			//text:'<span style="text-decoration:none;float:left" class="geoDrilldownLink">Region</span><div class="geoDrilldownArrow"></div>',
			text:'Region',
			id: 'city_icon',
            //cls: 'stateIcon_GOOD',
			style:{'top':'3px !important','border':'0px solid blue !important'},
            hidden:true
			//iconCls: 'big_infoIcon'
        }
    ]
})