Ext.define('citrixDashboard.view.GeoMapDetails', {
	 extend: 'Ext.grid.Panel',
    requires: ['Ext.grid.feature.RowBody'],
    padding: 0,
    border: 0,
    margin:'10px 5px 10px 5px',
	columnLines : false,
    alias: 'widget.geomapdetails',
	//title: 'World',
	title: 'Countries',
	//infoCls:'big_infoIcon',
	addInfo:true, // enable infoIcon
	ui:'plainGrid',
	id:'',
	jsonData:'',
	jsonData1:'',
	store:null,
	columns:null,
	initComponent: function() {
        var me = this;
		var dataArr = [];
		if(!Ext.isEmpty(me.jsonData) && !Ext.isEmpty(me.jsonData.resultArray))
			dataArr=me.jsonData.resultArray;
		me.store=Ext.create('Ext.data.Store', {
			storeId: 'mapStore',
			//fields: ['loadTime', 'pageViews', 'from', 'chartData', 'legendColor'],
			fields: [{name: 'm1',sortType: 'asFloat'},{name: 'm2',sortType: 'asFloat'},'from', 'chartData', 'legendColor'],
			data:dataArr,
			sorters: [{
				property: 'm1',
				direction: 'DESC'
			}],
			proxy: {
				type: 'memory',
				reader: {
					type: 'json'
				}
			}
		});
		if(!Ext.isEmpty(me.jsonData.ng_cols) && me.jsonData.ng_cols != undefined && me.jsonData.ng_cols != null)
			me.columns=me.jsonData.ng_cols;
		else
			me.columns=null;

		if (!Ext.isEmpty(me.store.data.items)) {
            var data = me.store.data.items;
            me.mon(me, 'viewready', function() {
                me.loadChart(data)

				if (!Ext.isEmpty(me.jsonData.mapMode) && me.jsonData.mapMode=='Region')
				{
					me.setTitle("Regions");
				}
				else if (!Ext.isEmpty(me.jsonData.mapMode) && me.jsonData.mapMode=='City')
				{
					me.setTitle("Cities");
				}
				else
				{
					me.setTitle("Countries");
				}
            }, me);
        }
		
		me.mon(me, 'sortchange', function() {
            me.loadChart(data)
        }, me);

		me.mon(me, 'resize', function() {
			me.loadChart(data)
		}, me);
	
		this.callParent();
	},
	updateData:function(data){
		var me = this;
		if (!Ext.isEmpty(data.mapMode) && data.mapMode=='Region')
			me.setTitle("Regions");
		else if (!Ext.isEmpty(data.mapMode) && data.mapMode=='City')
			me.setTitle("Cities");
		else
			me.setTitle("Countries");
		
		if(!Ext.isEmpty(data.ng_cols) && data.ng_cols != undefined && data.ng_cols != null)
			me.columns=data.ng_cols;
		else
			me.columns=null;

		me.store.loadRawData(data.resultArray);
		if (!Ext.isEmpty(me.store.data.items)) {
				var data = me.store.data.items;
				me.loadChart(data)
			me.mon(me, 'sortchange', function() {
					me.loadChart(data)
				}, me);
			
			me.mon(me, 'resize', function() {
				me.loadChart(data)
			}, me);
        }
		
	},
	infoToolTip:function(btn){
		var me = this;	
		var tooltip=  Ext.create("Ext.tip.ToolTip", {
			anchor: "top",
			shadow: true,
			anchorOffset: 25,
			mouseOffset:[0,0],
			target:Ext.fly(btn),
			cls: "moreoptionstooltip",
		
			listeners: {
				hide:function(tooltip){
					if(!Ext.isEmpty(tooltip)){
							Ext.destroy(tooltip);
					}
				},
				render: function(a) {
					Ext.EventManager.onWindowResize(function(b, c) {
						a.hide();
					});
				}
			},
			
			 getTargetXY: function() {
				  var x = Ext.fly(btn).getXY()[0];
				  var y = Ext.fly(btn).getXY()[1];
				   return [x - tooltip.anchorOffset - 12,  Ext.fly(btn).getHeight() + y];
			 },
			autoHide: false,
			anchorToTarget: true,
			width: 210,
			padding: "10 2 10 10",
			style: 'text-align:left',
			html: "<div class='t_b'><ol><li>Shows where Citrix users are coming from</li><li>Size of the geo-marker varies with the number of Citrix user sessions</li><li>State indicates the level of HDX latency experienced by the users connecting from a geography</li></ol></div>"
		});
		tooltip.show();
		return tooltip;
	},
	addInfoIcon:function(iconCls){
		 var me = this;
		 var el = Ext.get(me.header.getComponent(0).id).createChild({ 
				tag: 'span', 
				cls:iconCls ,
				style:"padding:5px 7px;margin-left:5px;cursor:pointer"
			},null,true);
			Ext.fly(el).addListener('click', function() { me.infoToolTip(el) });
	},
	
    loadChart: function(data) {
        var me = this;
		if(data == undefined || data == null)
			return;
		try
		{
			 for (var i = 0; i < data.length; i++) {
			   $('#geo_mapbar' + i + 'Id').highcharts(me.chartConfig(data[i].data.chartData));
			}
		}
		catch (ee)
		{
			return;
		}
       
    },
    chartConfig: function(data) {
        var me = this,
            config = {
                chart: {
                    type: 'bar',
                    backgroundColor: 'transparent',
                    height: 8,
                    padding: 0,
                    margin: 0
                },
                title: "",
                exporting: {
                    enabled: false
                },
                credits: {
                    enabled: false
                },
                tooltip: {
                    enabled: false
                },
                yAxis: {
                    gridLineWidth: 0,
					max:100,
                    labels: {
                        enabled: false
                    },
                    lineColor: 'transparent',
                    tickLength: 0,
                    minorGridLineWidth: 0
                },
                xAxis: {
                    gridLineWidth: 0,
                    labels: {
                        enabled: false
                    },
                    lineColor: 'transparent',
                    tickLength: 0,
                    minorGridLineWidth: 0
                },
                legend: {
                    enabled: false,
                    reversed: true
                },
                plotOptions: {
                    bar: {
						 borderWidth: 0,
                        dataLabels: {
                            enabled: false
                        },
                        series: {
                            borderColor: 'transparent'
                        }
                    }
                },
                series: data.DataSet
            };
        return config;

    },
    features: [{
        ftype: 'rowbody',
        getAdditionalData: function(data, rowIndex, record, orig) {
            var headerCt = this.view.headerCt,
                colspan = headerCt.getColumnCount();
            return {
                rowBody: '<div style="margin:0px 0px 5px 0px">' + record.get("from") + '</div><div id="geo_mapbar' + rowIndex + 'Id"  class="mapdetail_chart">' + record.get("chartData") + '</div>',
                rowBodyCls: "plainGrid-body-cls",
                rowBodyColspan: colspan
            };
        }
    }]
});