/*
* "roadmap" displays the default road map view. This is the default map type.
* "satellite" displays Google Earth satellite images
* "hybrid" displays a mixture of normal and satellite views
* "terrain" displays a physical map based on terrain information.
*/


Ext.define('citrixDashboard.view.GeoStaticPanel', {
	extend: 'Ext.ux.GMapPanel',
	alias: 'widget.geostaticpanel',
	markers:new Array(),
	controllersShow:true,
	//jsonData:Ext.decode(jsonData),
	jsonData:'',
	jsonData1:'',
	infoBoxArray:[],
	markerArray:[],
	feauturesArray:[],
	stateArray:[],
	listenerArray:[],
	access:null,
	mapMode:'Country',
	zoomLevel:0,
	initComponent : function(){
		var me = this;
		Ext.applyIf(this,{
            plain: true,
            gmapType: 'map',
			mapType:'satellite',
            border: false,
			
        });
		this.callParent(arguments);
		/*Ext.defer(function(){
			me.updateData(me);
		},10000);*/
    },
	mapStyle:'default', //light,dark,default
	styleMap:function(){
		var me = this,style;
		//options = Ext.apply({}, this.mapOptions);
		switch(me.mapStyle){
			case 'light':
				style = lightStyle;
				break;
			case 'dark':
				style = darkStyle;
				break;
		}
		var styledMapType = new google.maps.StyledMapType(style,{name: 'Styled Map'});
		this.gmap.mapTypes.set('styled_map', styledMapType);
		this.gmap.setMapTypeId('styled_map');
	},
	zoom:1,
	updateData:function(data){
		this.jsonData = data;
		this.access=null;
		this.closeAllInfoBox();
		this.clearMap(this);
		this.removeAllListeners(this);
		var mapMode = data.mapMode;
		this.mapMode=mapMode;
		if(mapMode == undefined || mapMode == null || mapMode == "Country")
			this.refreshMapDetails(this);
		else
			this.loadRegionDetails(this);
	},
	stateCheck:function(me,stateArray){
		var oldStateArray = me.stateArray;

		try
		{
			var add_el = [];
			var remove_el = [];
			if(!Ext.isEmpty(stateArray) && !Ext.isEmpty(oldStateArray)){
				for(var c in oldStateArray){
					var el = oldStateArray[c];
					if(stateArray.indexOf(el) == -1)
						remove_el.push(el);
				}

				for(var c in stateArray)
				{
					var el = stateArray[c];
					if(oldStateArray.indexOf(el) == -1)
						add_el.push(el);
				}
			}
			else if( !Ext.isEmpty(stateArray) && Ext.isEmpty(oldStateArray)){
				for(var c in stateArray)
					add_el.push(stateArray[c]);
			}
			else if(Ext.isEmpty(stateArray) && !Ext.isEmpty(oldStateArray)){
				for(var c in oldStateArray)
					remove_el.push(stateArray[c]);
			}

			if(!Ext.isEmpty(add_el)){
				for (var a in add_el )
				{
					var st = add_el[a];
					if(st=='GOOD')
					{
						var st_good = Ext.getCmp('filtermenu_Normal');
						if(st_good.isDisabled()){
							st_good.setValue(true);
							st_good.setDisabled(false);
						}
					}
					else if(st=='UNKNOWN')
					{
						var st_unknown = Ext.getCmp('filtermenu_Unknown');
						if(st_unknown.isDisabled()){
							st_unknown.setValue(true);
							st_unknown.setDisabled(false);
						}
					}
					else if(st=='LOW')
					{
						var st_minor = Ext.getCmp('filtermenu_Minor');
						if(st_minor.isDisabled()){
							st_minor.setValue(true);
							st_minor.setDisabled(false);
						}
					}
					else if(st=='INTERMEDIATE')
					{
						var st_major = Ext.getCmp('filtermenu_Major');
						if(st_major.isDisabled()){
							st_major.setValue(true);
							st_major.setDisabled(false);
						}
					}
					else if(st=='HIGH')
					{
						var st_critical = Ext.getCmp('filtermenu_Critical');
						if(st_critical.isDisabled()){
							st_critical.setValue(true);
							st_critical.setDisabled(false);
						}
					}
				}
			}

			if(!Ext.isEmpty(remove_el)){
				for (var a in remove_el )
				{
					var st = remove_el[a];
					if(st=='GOOD')
					{
						var st_good = Ext.getCmp('filtermenu_Normal');
						st_good.setValue(false);
						st_good.setDisabled(true);
						
					}
					else if(st=='UNKNOWN')
					{
						var st_unknown = Ext.getCmp('filtermenu_Unknown');
						st_unknown.setValue(false);
						st_unknown.setDisabled(true);
					}
					else if(st=='LOW')
					{
						var st_minor = Ext.getCmp('filtermenu_Minor');
						st_minor.setValue(false);
						st_minor.setDisabled(true);
					}
					else if(st=='INTERMEDIATE')
					{
						var st_major = Ext.getCmp('filtermenu_Major');
						st_major.setValue(false);
						st_major.setDisabled(true);
					}
					else if(st=='HIGH')
					{
						var st_critical = Ext.getCmp('filtermenu_Critical');
						st_critical.setValue(false);
						st_critical.setDisabled(true);
					}
				}
			}

		}
		catch (w)
		{
			console.log('w------>',w)
		}
	},
	clearMap:function(me){
		try
		{
			var disableArrfea=[];
			var disableArricon=[];

			
			if(!Ext.isEmpty(me)){
				disableArrfea = me.feauturesArray;
				disableArricon = me.markerArray;

				if(!Ext.isEmpty(disableArrfea)){
					for(var c in disableArrfea){
						for (var l in disableArrfea[c] )
						{
							disableArrfea[c][l].setMap(null);
						}
					}
					me.feauturesArray=[];
				}

				if(!Ext.isEmpty(disableArricon)){
					for(var c in disableArricon)
						disableArricon[c].setMap(null);
					me.markerArray=[];
				}

				me.infoBoxArray=[];
			}
			
		}
		catch (e)
		{
			console.log('e------>',e)
		}
	},
	createMap: function(center, marker) {
		var me = this;		
        options = Ext.apply({}, this.mapOptions);
        options = Ext.applyIf(options, {
            zoom: 0,
            center: center,
			disableDefaultUI: true,
			mapTypeControl: false,
			scaleControl: false,
			draggable: false,
			backgroundColor: 'none',
			minZoom:0,
			zoomControl: false,
			scrollwheel: false,
			zoomControlOptions: {
			  style: google.maps.ZoomControlStyle.LARGE 
			},
			mapTypeControlOptions: {
					mapTypeIds: []
			},
			mapTypeId: me.mapType
        });
		
		me.gmap = new google.maps.Map(me.body.dom, options);
		me.styleMap();
		me.setmapFixedView(me);
		// @adding the Header
		if(me.controllersShow){
			
			/*Ext.create('citrixDashboard.view.GeoMapControls', {
						style:{"position":"absolute","top":"0","border":"1px solid brown !important"},
						id:'geoMapControls-'+me.id,
						renderTo: me.id+'-body'
			});*/
			/*Ext.create('citrixDashboard.view.GeoMapControls', {
				//style:{"border":"1px solid brown !important"},
				id:'geoMapControls-'+me.id,
				margin:'-25px 10px 0 20px',
				renderTo:'geo_map_header_id'
			});*/
			//@appending the zoom buttons
			//$('#'+me.id+'-body').append('<div class="gmap_control"><div id="zoomout" title="Zoom in" class="zoombt">+</div><div title="Zoom out" id="zoomin" class="zoombt">-</div></div><div title="Filters" id="mapfilter" class="gmap_filters"><span>_<br>_<br>_</span></div><div style="class="filter_menu" id="filter_menu"></div>');
			//me.mapControl();

		}

		try
		{
			google.maps.event.addListener(me.gmap, 'click', function(e) {
				var tooltip1 = $("#filtermenu");
				if(!Ext.isEmpty(tooltip1))
					tooltip1.hide();		
			});	
		}
		catch (e)
		{
			console.log(e)
		}
		
			

		var data = me.jsonData;
		var mapMode = data.mapMode;
		if(mapMode != undefined && mapMode != null && mapMode != "" && mapMode != "Country")
			me.updateData(data);
		else
			me.loadMapDetails(me);

		//me.loadMapDetails(me);
    },
	mapControl:function() {
		 var me = this,map= this.gmap,
		filtermenu = Ext.create('citrixDashboard.view.GeoMapFliters',{
					renderTo:'filter_menu',
					id:'filtermenu',
					hidden:true,
					map:me,
			});
		 $('body').on( "click","#zoomin",function() {
		   var currentZoomLevel = map.getZoom();
		   if(currentZoomLevel != 0){
				map.setZoom(currentZoomLevel - 1);}     
		  });

		 $('body').on( "click","#zoomout",function() {
		   var currentZoomLevel = map.getZoom();
		   if(currentZoomLevel != 21){
				map.setZoom(currentZoomLevel + 1);}
		  });
		 $('#mapfilter').click(function(){
				$( "#filtermenu").slideToggle( "slow");	
		 });		 
	},
	refreshMapDetails:function(me){
		try
		{
			var mapData = me.reformColorArray(me);
			var data = me.jsonData;
			var mapMode = data.mapMode;
			var colorArray = [];
			//if(!Ext.isEmpty(data) && !Ext.isEmpty(data.colorArray) )
				//colorArray = data.colorArray;
			if(!Ext.isEmpty(mapData))
				colorArray = mapData;

			var jsonArray = [];
			if(!Ext.isEmpty(data) && !Ext.isEmpty(data.resultArray) )
				jsonArray = data.resultArray;
			
			var stateArray = [];
			if(!Ext.isEmpty(data) && !Ext.isEmpty(data.stateArray) )
				stateArray = data.stateArray;

			me.stateCheck(me,stateArray);
			me.stateArray=stateArray;
			if (!Ext.isEmpty( jsonArray))
			{
				var colorClass;
				var markerLocation;

				if(jsonArray.length > 0)
				{
					try
					{
						Ext.getCmp('filtermenu_Response_Time').setValue(true);
						Ext.getCmp('filtermenu_Requests').setValue(true);
						Ext.getCmp('filtermenu_Response_Time').setDisabled(false);
						Ext.getCmp('filtermenu_Requests').setDisabled(false);						
					}
					catch (e1)
					{
					}
					
				}

				for(var item=0; item<jsonArray.length; item++)
				{
					var jsonItem=jsonArray[item];
					var tempCon = new Array();
					tempCon.push(jsonItem.DispInfo);
					tempCon.push(jsonItem.CountryCode);
					tempCon.push(jsonItem.magnitude);
					tempCon.push(jsonItem.RealInfo);
					tempCon.push(jsonItem.State);
					tempCon.push(jsonItem.CountryLAT);
					tempCon.push(jsonItem.CountryLNG);
					tempCon.push(jsonItem.LocDetails);
					tempCon.push(jsonItem.BottomLocDetails);
					try
					{
						//colorClass =colorArray[jsonItem.Info];	
						if(colorArray.containsKey(jsonItem.DispInfo))
							colorClass = colorArray.get(jsonItem.DispInfo);
					}
					catch (w)
					{
					}

					if(jsonItem.CountryCode == 'NIL' )
						continue;
					
					markerLocation = null;
					markerLocation = { lat: parseFloat(jsonItem.CountryLAT), lng: parseFloat(jsonItem.CountryLNG)};
					
					var infobox = new InfoBox({
						content: "",
						 //disableAutoPan: true,
						 maxWidth: "340px",
						 pixelOffset: new google.maps.Size(20,-85),
						 zIndex: null,
						 boxStyle: {
							//background: "url('https://google-maps-utility-library-v3.googlecode.com/svn/trunk/infobox/examples/tipbox.gif') no-repeat",
							opacity: 0.85,
							//width: "340px",
							width: "auto",
							height:"30px",
							margin:"45 0 0 0"
						},
						//closeBoxMargin: "-6px -6px 0px 0px", //-108px -58px 2px 2px  - Normal:12px 4px 2px 2px   -58px 130px 2px 2px
						closeBoxURL: "",
						infoBoxClearance: new google.maps.Size(1, 1)
					});


					me.infoBoxArray.push(infobox);
					var onclickText='';
					if(me.selectedView != undefined && me.selectedView != null && me.selectedView=='Overview_View'){
						onclickText=" onclick=\"loadGeoCountry('"+jsonItem.CountryCode+"','"+me.id+"')\" ";
					}

					var locDetailsDiv="";
					var locDetailsDiv1="<div id='infobox' style='display:block !important;margin:auto;font-size:15px !important;text-align:left;padding:5px 10px !important;height:30px !important;white-space: nowrap'>"+jsonItem.DispInfo+"</div>";
					var info_height="height:100px";
					if(jsonItem.BottomLocDetails.length>3)
						info_height="height:150px";
					//locDetailsDiv = locDetailsDiv+"<div id='infobox' style='width:340px;"+info_height+";'>";
					locDetailsDiv = locDetailsDiv+"<div id='infobox' >";
					locDetailsDiv = locDetailsDiv+"<div style='position: absolute;top: -10px;left: 170px;'><img src='/final/images/Light/iconMapArrow.png'/></div><ul class='rumMapData' style='	list-style:none;margin:0px;padding:3px 0 10px 0;height:20px;border-bottom:1px solid #cccccc'>";

					//locDetailsDiv = locDetailsDiv+"<li><div  data-qclass='yellowTip' "+onclickText+" data-qtip='"+jsonItem.DispInfo+"' ><table cellspacing='0' cellpadding='0' border='1'><tr><td><img data-qclass='yellowTip' data-qtip='"+jsonItem.DispInfo+"' src='/final/images/clear.png' class='state_"+jsonItem.State+"' width='15' height='15' border='0' style='margin-left:5px'/></td><td style='padding:1px 0 0 5px;width:185px;font-size:18px;text-align:left;color:"+jsonItem.StateCode+" !important;white-space: nowrap'><div class='mouse' title='"+jsonItem.DispInfo+"' style='text-overflow:ellipsis;width:185px;overflow:hidden;text-align:left !important'>"+jsonItem.DispInfo+"</div></td></tr></table></div></li>";
					locDetailsDiv = locDetailsDiv+"<li><div  data-qclass='yellowTip' "+onclickText+" data-qtip='"+jsonItem.DispInfo+"' ><table cellspacing='0' cellpadding='0' border='0'><tr><td class='header' style='padding:1px 0 0 5px;width:100%;text-align:left;color:"+jsonItem.StateCode+" !important;white-space: nowrap'><div class='mouse' title='"+jsonItem.DispInfo+"' style='margin-top:-3px;text-overflow:ellipsis;width:185px;overflow:hidden;text-align:left !important'>"+jsonItem.DispInfo+"</div></td></tr></table></div></li>";


					if(jsonItem.HeaderMeasureName!=null && jsonItem.HeaderMeasureName!=undefined && jsonItem.HeaderMeasureName!="")
					{
						if(!Ext.isEmpty(jsonItem.DD_URL) && jsonItem.DD_URL!=null && jsonItem.DD_URL!=undefined)
						{
							locDetailsDiv = locDetailsDiv+"<li style='padding-top:4px;white-space:normal;display:inline-block;float:left;text-align:right'><span style='font-size:17px;text-transform:lowercase;color:#000;font-weight:bold' class='rumVisitsText'>11"+jsonItem.HeaderMeasureValue+"</span>&nbsp;"+jsonItem.HeaderMeasureDispName+"</li>";
						}
						else
						{
							locDetailsDiv = locDetailsDiv+"<li style='padding-top:4px;white-space:normal;display:inline-block;float:left;text-align:right'><span style='font-size:17px;text-transform:lowercase;color:#000;font-weight:bold' > 22"+jsonItem.HeaderMeasureValue+"</span>&nbsp;"+jsonItem.HeaderMeasureDispName+"</li>";
						}
					}

					locDetailsDiv = locDetailsDiv+"</ul><br/>";
					locDetailsDiv = locDetailsDiv+"<ul class='rumMapData' style='	list-style:none;margin:0px;padding:0px;display:inline-block;line-height:1.5em;'>";
					// Preparing the content to be shown on the popup window
					// || jsonDetailsItem.MeasureDispName == 'Apdex Score'
					for(var d=0; d<jsonItem.BottomLocDetails.length; d++)
					{
						var jsonDetailsItem=jsonItem.BottomLocDetails[d];

						
						if(jsonDetailsItem!=null && jsonDetailsItem!=undefined)
						{
							var mapInfoMeasure = jsonDetailsItem.MeasureDispName;
							
							if(jsonDetailsItem.MeasureUnit == 'milliseconds')
								jsonDetailsItem.MeasureUnit='ms';

							if(jsonDetailsItem.MeasureUnit == 'Seconds')
								jsonDetailsItem.MeasureUnit='S';

							if(!Ext.isEmpty(jsonDetailsItem.DD_URL) && jsonDetailsItem.DD_URL!=null && jsonDetailsItem.DD_URL!=undefined)
							{
								locDetailsDiv = locDetailsDiv+"<li style='text-align:center;padding:3px 8px 10px 8px;white-space:normal;display:inline-block;float:left'><div style='float:left' class='stateSymbol_"+jsonDetailsItem.State+"'></div><span class ='value' style='text-transform:lowercase;' class='rumVisitsText'>"+jsonDetailsItem.MeasureValue+"</span><span class ='unit'>"+jsonDetailsItem.MeasureUnit+" </span><br/><span style='margin-top:10px;display:block'>"+jsonDetailsItem.MeasureDispName+"</span></li>";
							}
							else
							{
								locDetailsDiv = locDetailsDiv+"<li style='text-align:center;padding:0px 10px 0px 10px;white-space:normal;display:inline-block;float:left'><div style='float:left' class='stateSymbol_"+jsonDetailsItem.State+"'></div><span class ='value' style='text-transform:lowercase;'> "+jsonDetailsItem.MeasureValue+"</span><span class ='unit'>"+jsonDetailsItem.MeasureUnit+" </span><br/><span style='margin-top:10px;display:block'>"+jsonDetailsItem.MeasureDispName+"</span></li>";
							}
						}
					}
					locDetailsDiv = locDetailsDiv+"</ul>";
					locDetailsDiv = locDetailsDiv+"</div>";


					if (Ext.isEmpty( jsonItem.CountryCode))
					{
						tempCon.push("No_Code");
					}
					else
					{
						tempCon.push(jsonItem.CountryCode);
						var xhr = new XMLHttpRequest();
						
						var url = "geojson/"+jsonItem.CountryCode+".geojson" ;
						xhr.open('GET', url, false);
						var style = GRAY;
						if(jsonItem.State == "HIGH")
							style = HIGH;
						else if(jsonItem.State == "INTERMEDIATE")
							style = INTERMEDIATE;
						else if(jsonItem.State == "LOW")
							style = LOW;
						else if(jsonItem.State == "UNKNOWN")
							style = UNKNOWN;
						else if(jsonItem.State == "GOOD")
							style = GOOD;
						
						xhr.onload = function() {
							if(xhr.status == 200)
								me.loadGeoJSON(me,xhr.responseText,style,infobox,markerLocation,locDetailsDiv1,tempCon,colorClass);
							
						};
						xhr.send();
					}
				}
				me.addZoomChangeListener(me);
			}
			me.setmapFixedView(me);
			//me.gmap.setZoom(1);
			//me.filterCheck(me);
		}
		catch (e)
		{
			console.log('aa==>',e)
		}
		me.zoomLevel = me.gmap.getZoom();
	},
	reformColorArray:function(me){
		var data = me.jsonData;
		var jsonArray = data.resultArray;
		var valueArr=[];
		var map = new Ext.util.HashMap();
		var finalmap = new Ext.util.HashMap();
		try
		{
			for (var a in jsonArray )
			{
				var obj = jsonArray[a];
				var val = obj.MeasureValue;
				var info = obj.DispInfo;
				if(!Ext.Array.contains(valueArr,obj.MeasureValue))
					valueArr.push(val);
				if(map.containsKey(val)){
					var temp = map.get(val);
					temp.push(info);
					map.add(val,temp);
				}
				else
				{
					var temp = [];
					temp.push(info);
					map.add(val,temp);
				}
			}	
			valueArr.sort(function(a, b){return a - b});
			valueArr.reverse();
			
			var count = 5;
			for(var b in valueArr)
			{
				var key = valueArr[b];
				var keyArr=[];
				if(count <1)
					count=1;
				if(map.containsKey(key)){
					//var style='histData5_'+count;
					var style='mapPointer'+count+'_GRAY';
					keyArr = map.get(key);
					for (var l in keyArr )
					{
						var k_info = keyArr[l];
						finalmap.add(k_info,style);
					}
					
					count --;
				}
			}
		}
		catch(e)
		{
			console.log(e)
		}

		return finalmap;
	},
	loadMapDetails:function(me){
		try
		{
			me.removeAllListeners(me);
			var mapData = me.reformColorArray(me);
			var data = me.jsonData;
			var mapMode = data.mapMode;
			me.mapMode=mapMode;
			var colorArray = [];
			//if(!Ext.isEmpty(data) && !Ext.isEmpty(data.colorArray) )
				//colorArray = data.colorArray;
			if(!Ext.isEmpty(mapData))
				colorArray = mapData;
			var jsonArray = [];
			if(!Ext.isEmpty(data) && !Ext.isEmpty(data.resultArray) )
				jsonArray = data.resultArray;
			
			var stateArray = [];
			if(!Ext.isEmpty(data) && !Ext.isEmpty(data.stateArray) )
				stateArray = data.stateArray;

			me.stateArray=stateArray;
			var latlangBounds = [];
			if (!Ext.isEmpty( jsonArray))
			{
				var colorClass;
				var markerLocation;
				if(jsonArray.length > 0){
					try
					{
						Ext.getCmp('filtermenu_Response_Time').setValue(true);
						Ext.getCmp('filtermenu_Requests').setValue(true);
						Ext.getCmp('filtermenu_Response_Time').setDisabled(false);
						Ext.getCmp('filtermenu_Requests').setDisabled(false);						
					}
					catch (e2)
					{
					}					
				}

				if(!Ext.isEmpty(stateArray)){
					for (var a in stateArray )
					{
						var st = stateArray[a];
						try{
							if(st=='GOOD')
							{
								Ext.getCmp('filtermenu_Normal').setValue(true);
								Ext.getCmp('filtermenu_Normal').setDisabled(false);
							}
							else if(st=='UNKNOWN')
							{
								Ext.getCmp('filtermenu_Unknown').setValue(true);
								Ext.getCmp('filtermenu_Unknown').setDisabled(false);
							}
							else if(st=='LOW')
							{
								Ext.getCmp('filtermenu_Minor').setValue(true);
								Ext.getCmp('filtermenu_Minor').setDisabled(false);
							}
							else if(st=='INTERMEDIATE')
							{
								Ext.getCmp('filtermenu_Major').setValue(true);
								Ext.getCmp('filtermenu_Major').setDisabled(false);
							}
							else if(st=='HIGH')
							{
								Ext.getCmp('filtermenu_Critical').setValue(true);
								Ext.getCmp('filtermenu_Critical').setDisabled(false);
							}
						}
						catch(e3)
						{
						}
					}
				}
				
				for(var item=0; item<jsonArray.length; item++)
				{
					var jsonItem=jsonArray[item];
					var tempCon = new Array();
					tempCon.push(jsonItem.DispInfo);
					tempCon.push(jsonItem.CountryCode);
					tempCon.push(jsonItem.magnitude);
					tempCon.push(jsonItem.RealInfo);
					tempCon.push(jsonItem.State);
					tempCon.push(jsonItem.CountryLAT);
					tempCon.push(jsonItem.CountryLNG);
					tempCon.push(jsonItem.LocDetails);
					tempCon.push(jsonItem.BottomLocDetails);
					
					try
					{
						//colorClass =colorArray[jsonItem.Info];
						if(colorArray.containsKey(jsonItem.DispInfo))
							colorClass = colorArray.get(jsonItem.DispInfo);
					}
					catch (w)
					{
					}
					

					if(jsonItem.CountryCode == 'NIL' )
						continue;
					
					markerLocation = null;
					markerLocation = { lat: parseFloat(jsonItem.CountryLAT), lng: parseFloat(jsonItem.CountryLNG)};
					
					latlangBounds.push(markerLocation);
					var infobox = new InfoBox({
						content: "",
						 //disableAutoPan: true,
						 maxWidth: "340px",
						 pixelOffset: new google.maps.Size(20,-85),
						 zIndex: null,
						 boxStyle: {
							//background: "url('https://google-maps-utility-library-v3.googlecode.com/svn/trunk/infobox/examples/tipbox.gif') no-repeat",
							opacity: 0.85,
							//width: "340px",
							width: "auto",
							height:"30px",
							margin:"45 0 0 0"
						},
						//closeBoxMargin: "-6px -6px 0px 0px", //-108px -58px 2px 2px  - Normal:12px 4px 2px 2px   -58px 130px 2px 2px
						closeBoxURL: "",
						infoBoxClearance: new google.maps.Size(1, 1)
					});


					me.infoBoxArray.push(infobox);
					
					var onclickText='';
					if(me.selectedView != undefined && me.selectedView != null && me.selectedView=='Overview_View'){
						onclickText=" onclick=\"loadGeoCountry('"+jsonItem.CountryCode+"','"+me.id+"')\" ";
					}
					var locDetailsDiv="";
					var locDetailsDiv1="<div id='infobox' style='display:block !important;margin:auto;font-size:15px !important;text-align:left;padding:5px 10px !important;height:30px !important;white-space: nowrap'>"+jsonItem.DispInfo+"</div>";
					var info_height="height:100px";
					if(jsonItem.BottomLocDetails.length>3)
						info_height="height:150px";
					locDetailsDiv = locDetailsDiv+"<div id='infobox' style='width:340px;"+info_height+";'>";
					locDetailsDiv = locDetailsDiv+"<ul class='rumMapData' style='list-style:none;margin:0px;padding:3px 0 10px 0;height:27px;border-bottom:1px solid #cccccc'>";

					locDetailsDiv = locDetailsDiv+"<li><div  data-qclass='yellowTip' "+onclickText+" data-qtip='"+jsonItem.DispInfo+"' ><table cellspacing='0' cellpadding='0' border='0'><tr><td><img data-qclass='yellowTip' data-qtip='"+jsonItem.DispInfo+"' src='/final/images/clear.png' class='state_"+jsonItem.State+"' width='15' height='15' border='0' style='margin-left:5px'/></td><td style='padding:1px 0 0 5px;width:185px;font-size:18px;text-align:left;color:"+jsonItem.StateCode+" !important;white-space: nowrap'><div class='mouse' title='"+jsonItem.DispInfo+"' style='text-overflow:ellipsis;width:185px;overflow:hidden;text-align:left !important'>"+jsonItem.DispInfo+"</div></td></tr></table></div></li>";


					if(jsonItem.HeaderMeasureName!=null && jsonItem.HeaderMeasureName!=undefined && jsonItem.HeaderMeasureName!="")
					{
						if(!Ext.isEmpty(jsonItem.DD_URL) && jsonItem.DD_URL!=null && jsonItem.DD_URL!=undefined)
						{
							locDetailsDiv = locDetailsDiv+"<li style='padding-top:4px;white-space:normal;display:inline-block;float:left;text-align:right'><span style='font-size:17px;text-transform:lowercase;color:#000;font-weight:bold' class='rumVisitsText'>"+jsonItem.HeaderMeasureValue+"</span>&nbsp;"+jsonItem.HeaderMeasureDispName+"</li>";
						}
						else
						{
							locDetailsDiv = locDetailsDiv+"<li style='padding-top:4px;white-space:normal;display:inline-block;float:left;text-align:right'><span style='font-size:17px;text-transform:lowercase;color:#000;font-weight:bold' > "+jsonItem.HeaderMeasureValue+"</span>&nbsp;"+jsonItem.HeaderMeasureDispName+"</li>";
						}
					}

					locDetailsDiv = locDetailsDiv+"</ul><br/>";
					locDetailsDiv = locDetailsDiv+"<ul class='rumMapData' style='	list-style:none;margin:0px;padding:0px;display:inline-block;line-height:1.5em;'>";
					// Preparing the content to be shown on the popup window
					// || jsonDetailsItem.MeasureDispName == 'Apdex Score'
					for(var d=0; d<jsonItem.BottomLocDetails.length; d++)
					{
						var jsonDetailsItem=jsonItem.BottomLocDetails[d];
						if(jsonDetailsItem!=null && jsonDetailsItem!=undefined)
						{
							var mapInfoMeasure = jsonDetailsItem.MeasureDispName;
							
							if(jsonDetailsItem.MeasureUnit == 'milliseconds')
								jsonDetailsItem.MeasureUnit='ms';
							
							if(jsonDetailsItem.MeasureUnit == 'Seconds')
								jsonDetailsItem.MeasureUnit='S';

							if(!Ext.isEmpty(jsonDetailsItem.DD_URL) && jsonDetailsItem.DD_URL!=null && jsonDetailsItem.DD_URL!=undefined)
							{
								locDetailsDiv = locDetailsDiv+"<li style='text-align:center;padding:3px 8px 10px 8px;white-space:normal;display:inline-block;float:left'><span style='font-size:17px;font-weight:bold;text-transform:lowercase;color:"+jsonDetailsItem.StateCode+" !important;' class='rumVisitsText'> "+jsonDetailsItem.MeasureValue+" "+jsonDetailsItem.MeasureUnit+" </span><br/>"+jsonDetailsItem.MeasureDispName+"</li>";
							}
							else
							{
								locDetailsDiv = locDetailsDiv+"<li style='text-align:center;padding:0px 5px 0px 5px;white-space:normal;display:inline-block;float:left'><span style='font-size:17px;font-weight:bold;text-transform:lowercase;color:"+jsonDetailsItem.StateCode+" !important;'> "+jsonDetailsItem.MeasureValue+" "+jsonDetailsItem.MeasureUnit+" </span><br/>"+jsonDetailsItem.MeasureDispName+"</li>";
							}
						}
					}
					locDetailsDiv = locDetailsDiv+"</ul>";
					locDetailsDiv = locDetailsDiv+"</div>";


					if (Ext.isEmpty( jsonItem.CountryCode))
					{
						tempCon.push("No_Code");
					}
					else
					{
						tempCon.push(jsonItem.CountryCode);
						var xhr = new XMLHttpRequest();
						
						var url = "geojson/"+jsonItem.CountryCode+".geojson" ;
						xhr.open('GET', url, false);
						var style = GRAY;
						if(jsonItem.State == "HIGH")
							style = HIGH;
						else if(jsonItem.State == "INTERMEDIATE")
							style = INTERMEDIATE;
						else if(jsonItem.State == "LOW")
							style = LOW;
						else if(jsonItem.State == "UNKNOWN")
							style = UNKNOWN;
						else if(jsonItem.State == "GOOD")
							style = GOOD;
						
						xhr.onload = function() {
							if(xhr.status == 200)
								me.loadGeoJSON(me,xhr.responseText,style,infobox,markerLocation,locDetailsDiv1,tempCon,colorClass);
							
						};
						xhr.send();
					}
				}

				me.addZoomChangeListener(me);
			}
			//me.setmapBounds(latlangBounds,me);
			//me.setmapFixedView(me);
			//me.gmap.setZoom(1);
		}
		catch (e)
		{
			console.log('aa==>',e)
		}
		me.zoomLevel = me.gmap.getZoom();		
	},
	loadRegionDetails:function(me){
		try
		{
			var data = me.jsonData;

			var mapData = me.reformColorArray(me);
			var colorArray = [];
			//if(!Ext.isEmpty(data) && !Ext.isEmpty(data.colorArray) )
				//colorArray = data.colorArray;
			if(!Ext.isEmpty(mapData))
				colorArray = mapData;
			var jsonArray = [];
			if(!Ext.isEmpty(data) && !Ext.isEmpty(data.resultArray) )
				jsonArray = data.resultArray;
			
			var stateArray = [];
			if(!Ext.isEmpty(data) && !Ext.isEmpty(data.stateArray) )
				stateArray = data.stateArray;

			me.stateArray=stateArray;
			var latlangBounds = [];
			if (!Ext.isEmpty( jsonArray))
			{
				var colorClass;
				var markerLocation;

				//Ext.getCmp('filtermenu_Response_Time').setValue(false);
				//Ext.getCmp('filtermenu_Response_Time').setDisabled(true);
				/*if(jsonArray.length > 0){
					Ext.getCmp('filtermenu_Response_Time').setValue(true);
					Ext.getCmp('filtermenu_Requests').setValue(true);
					Ext.getCmp('filtermenu_Response_Time').setDisabled(false);
					Ext.getCmp('filtermenu_Requests').setDisabled(false);
				}

				if(!Ext.isEmpty(stateArray)){
					for (var a in stateArray )
					{
						var st = stateArray[a];
						if(st=='GOOD')
						{
							Ext.getCmp('filtermenu_Normal').setValue(true);
							Ext.getCmp('filtermenu_Normal').setDisabled(false);
						}
						else if(st=='UNKNOWN')
						{
							Ext.getCmp('filtermenu_Unknown').setValue(true);
							Ext.getCmp('filtermenu_Unknown').setDisabled(false);
						}
						else if(st=='LOW')
						{
							Ext.getCmp('filtermenu_Minor').setValue(true);
							Ext.getCmp('filtermenu_Minor').setDisabled(false);
						}
						else if(st=='INTERMEDIATE')
						{
							Ext.getCmp('filtermenu_Major').setValue(true);
							Ext.getCmp('filtermenu_Major').setDisabled(false);
						}
						else if(st=='HIGH')
						{
							Ext.getCmp('filtermenu_Critical').setValue(true);
							Ext.getCmp('filtermenu_Critical').setDisabled(false);
						}
					}
				}*/
				
				for(var item=0; item<jsonArray.length; item++)
				{
					var jsonItem=jsonArray[item];
					var tempCon = new Array();
					tempCon.push(jsonItem.DispInfo);
					tempCon.push(jsonItem.magnitude);
					tempCon.push(jsonItem.RealInfo);
					tempCon.push(jsonItem.State);
					tempCon.push(jsonItem.CountryLAT);
					tempCon.push(jsonItem.CountryLNG);
					tempCon.push(jsonItem.LocDetails);
					tempCon.push(jsonItem.BottomLocDetails);
					
					try
					{
						//colorClass =colorArray[jsonItem.Info];
						if(colorArray.containsKey(jsonItem.DispInfo))
							colorClass = colorArray.get(jsonItem.DispInfo);
					}
					catch (w)
					{
					}
					

					if(jsonItem.CountryCode == 'NIL' )
						continue;
					
					
					var infobox = new InfoBox({
						content: "",
						 //disableAutoPan: true,
						 maxWidth: "340px",
						 pixelOffset: new google.maps.Size(20,-85),
						 zIndex: null,
						 boxStyle: {
							//background: "url('https://google-maps-utility-library-v3.googlecode.com/svn/trunk/infobox/examples/tipbox.gif') no-repeat",
							opacity: 0.85,
							//width: "340px",
							width: "auto",
							height:"30px",
							margin:"45 0 0 0"
						},
						//closeBoxMargin: "-6px -6px 0px 0px", //-108px -58px 2px 2px  - Normal:12px 4px 2px 2px   -58px 130px 2px 2px
						closeBoxURL: "",
						infoBoxClearance: new google.maps.Size(1, 1)
					});


					me.infoBoxArray.push(infobox);

					var locDetailsDiv="";
					var locDetailsDiv1="<div id='infobox' style='display:block !important;margin:auto;font-size:15px !important;text-align:left;padding:5px 10px !important;height:30px !important;white-space: nowrap'>"+jsonItem.DispInfo+"</div>";
					var info_height="height:100px";
					if(jsonItem.BottomLocDetails.length>3)
						info_height="height:150px";
					locDetailsDiv = locDetailsDiv+"<div id='infobox' style='width:340px;"+info_height+";'>";
					locDetailsDiv = locDetailsDiv+"<ul class='rumMapData' style='	list-style:none;margin:0px;padding:3px 0 10px 0;height:27px;border-bottom:1px solid #cccccc'>";

					locDetailsDiv = locDetailsDiv+"<li><div  data-qclass='yellowTip' data-qtip='"+jsonItem.DispInfo+"' ><table cellspacing='0' cellpadding='0' border='0'><tr><td><img data-qclass='yellowTip' data-qtip='"+jsonItem.DispInfo+"' src='/final/images/clear.png' class='state_"+jsonItem.State+"' width='15' height='15' border='0' style='margin-left:5px'/></td><td style='padding:1px 0 0 5px;width:185px;font-size:18px;text-align:left;color:"+jsonItem.StateCode+" !important;white-space: nowrap'><div class='mouse' title='"+jsonItem.DispInfo+"' style='text-overflow:ellipsis;width:185px;overflow:hidden;text-align:left !important'>"+jsonItem.DispInfo+"</div></td></tr></table></div></li>";


					if(jsonItem.HeaderMeasureName!=null && jsonItem.HeaderMeasureName!=undefined && jsonItem.HeaderMeasureName!="")
					{
						if(!Ext.isEmpty(jsonItem.DD_URL) && jsonItem.DD_URL!=null && jsonItem.DD_URL!=undefined)
						{
							locDetailsDiv = locDetailsDiv+"<li style='padding-top:4px;white-space:normal;display:inline-block;float:left;text-align:right'><span style='font-size:17px;text-transform:lowercase;color:#000;font-weight:bold' class='rumVisitsText'>"+jsonItem.HeaderMeasureValue+"</span>&nbsp;"+jsonItem.HeaderMeasureDispName+"</li>";
						}
						else
						{
							locDetailsDiv = locDetailsDiv+"<li style='padding-top:4px;white-space:normal;display:inline-block;float:left;text-align:right'><span style='font-size:17px;text-transform:lowercase;color:#000;font-weight:bold' > "+jsonItem.HeaderMeasureValue+"</span>&nbsp;"+jsonItem.HeaderMeasureDispName+"</li>";
						}
					}

					locDetailsDiv = locDetailsDiv+"</ul><br/>";
					locDetailsDiv = locDetailsDiv+"<ul class='rumMapData' style='	list-style:none;margin:0px;padding:0px;display:inline-block;line-height:1.5em;'>";
					// Preparing the content to be shown on the popup window
					// || jsonDetailsItem.MeasureDispName == 'Apdex Score'
					for(var d=0; d<jsonItem.BottomLocDetails.length; d++)
					{
						var jsonDetailsItem=jsonItem.BottomLocDetails[d];
						if(jsonDetailsItem!=null && jsonDetailsItem!=undefined)
						{
							var mapInfoMeasure = jsonDetailsItem.MeasureDispName;
							
							if(jsonDetailsItem.MeasureUnit == 'milliseconds')
								jsonDetailsItem.MeasureUnit='ms';

							if(jsonDetailsItem.MeasureUnit == 'Seconds')
								jsonDetailsItem.MeasureUnit='S';

							if(!Ext.isEmpty(jsonDetailsItem.DD_URL) && jsonDetailsItem.DD_URL!=null && jsonDetailsItem.DD_URL!=undefined)
							{
								locDetailsDiv = locDetailsDiv+"<li style='text-align:center;padding:3px 8px 10px 8px;white-space:normal;display:inline-block;float:left'><span style='font-size:17px;font-weight:bold;text-transform:lowercase;color:"+jsonDetailsItem.StateCode+" !important;' class='rumVisitsText'> "+jsonDetailsItem.MeasureValue+" "+jsonDetailsItem.MeasureUnit+" </span><br/>"+jsonDetailsItem.MeasureDispName+"</li>";
							}
							else
							{
								locDetailsDiv = locDetailsDiv+"<li style='text-align:center;padding:0px 5px 0px 5px;white-space:normal;display:inline-block;float:left'><span style='font-size:17px;font-weight:bold;text-transform:lowercase;color:"+jsonDetailsItem.StateCode+" !important;'> "+jsonDetailsItem.MeasureValue+" "+jsonDetailsItem.MeasureUnit+" </span><br/>"+jsonDetailsItem.MeasureDispName+"</li>";
							}
						}
					}
					locDetailsDiv = locDetailsDiv+"</ul>";
					locDetailsDiv = locDetailsDiv+"</div>";

					var wid,hit;
					var obj = getStyle(colorClass);
					if(obj != null && obj != undefined){
						wid=obj.width;
						hit=obj.height;
					}
					//var geocoderObj = new google.maps.Geocoder();
					//geocoderObj.geocode( { 'address':jsonItem.RealInfo},function(results, status) {
						//if ( ( status == google.maps.GeocoderStatus.OK || jsonItem.CountryLAT ) && results != undefined && results[0] != undefined ) 
						//{
							//var geo = results[0];
							//jsonItem.CountryLAT = geo.geometry.location.lat().toFixed(5);
							//jsonItem.CountryLNG = geo.geometry.location.lng().toFixed(5);

							var markerLocation = null;
							markerLocation = { lat: parseFloat(jsonItem.CountryLAT), lng: parseFloat(jsonItem.CountryLNG)};
							latlangBounds.push(markerLocation);
							var iconMarker =   new MarkerWithLabel({
								position: markerLocation,
								map: me.gmap,
								icon:image,
								draggable:false,
								labelAnchor: new google.maps.Point(wid,hit),
								labelContent: '',
								info:jsonItem.DispInfo,
								labelClass:colorClass
							  });
							
							me.markerArray.push(iconMarker);
							var centerMarker =  new MarkerWithLabel
							({
							   position: markerLocation,
							   draggable: false,
							   raiseOnDrag: false,
							   map: me.gmap,
							   labelAnchor: new google.maps.Point(2,8),//may be (0,5) --> if so then it display the label from center of bubble
							   labelClass: "labels", 
							   labelStyle: {opacity: 0.90, color:labelColor},
							   icon : image
							});

							var zl = google.maps.event.addListener(iconMarker, 'click',function(e)
									{
										//	code to open infoBox
										//infobox.setContent(locDetailsDiv);
										//me.closeAllInfoBox();
										//infobox.open(me.gmap,centerMarker);
									});
							
							me.listenerArray.push(zl);

							var mi = google.maps.event.addListener(iconMarker, 'mouseover',function(e)
									{
										me.access = this.info;
									});
							
							me.listenerArray.push(mi);
							var mo = google.maps.event.addListener(iconMarker, 'mouseout',function(e)
									{
										me.access = undefined;
									});

							me.listenerArray.push(mo);


							if(latlangBounds.length == jsonArray.length)
							{
								me.setmapBounds(latlangBounds,me);
								//if(me.mapMode == 'Region')
									me.addZoomChangeListener(me);
							}
						//}
					//});
				}
			}
			//me.setmapBounds(latlangBounds,me);
			//me.setmapFixedView(me);
			//me.gmap.setZoom(2);
		}
		catch (e)
		{
			alert(e)
			console.log('aa==>',e)
		}
		me.zoomLevel = me.gmap.getZoom();
	},
	removeAllListeners:function(me){
		var listenerArray = me.listenerArray;
		if(listenerArray != undefined && listenerArray != null){
			for(var l=0;l<listenerArray.length;l++){
				google.maps.event.removeListener(listenerArray[l]);
			}
		}
		me.listenerArray=[];
	},
	addZoomChangeListener:function(me){

		if(me.selectedView != undefined && me.selectedView != null && me.selectedView !='Geo_View')
			return;

		me.zoomLevel = me.gmap.getZoom();
		var zl = google.maps.event.addListener(me.gmap, 'zoom_changed',function(e)
		{
			if(me.access != null && me.access != undefined && me.access != ''){
				var countryComboObj = Ext.getCmp('countryComboId');
				var regionComboObj = Ext.getCmp('regionComboId');

				if(me.zoomLevel < me.gmap.getZoom()){
					if(me.mapMode == 'Country'){
						countryComboObj.setValue(me.access);
						citrixDashboard.app.getController('Main').geoComboOnChange(countryComboObj);
					}
					else if(me.mapMode == 'Region'){
						regionComboObj.setValue(me.access);
						citrixDashboard.app.getController('Main').geoComboOnChange(regionComboObj);
					}
				}
				else{
					if(me.mapMode == 'Region'){
						countryComboObj.setValue('World');
						citrixDashboard.app.getController('Main').geoComboOnChange(countryComboObj);
					}
					else if(me.mapMode == 'City'){
						regionComboObj.setValue('AllRegion');
						citrixDashboard.app.getController('Main').geoComboOnChange(regionComboObj);
					}
				}
			}
		});

		me.listenerArray.push(zl);
	},
	setmapFixedView:function(me){
		try
		{
			var centerMap = new google.maps.LatLng(40.3780, 10.4359);
			//var centerMap = new google.maps.LatLng(6.349789, 16.540727);
			me.gmap.setCenter(centerMap);
			me.gmap.setZoom(1);
		}
		catch (e)
		{
			me.gmap.setZoom(1);
		}
	},
	setmapBounds:function(latlangBounds,me){
		try
		{
			if(latlangBounds != null && latlangBounds != undefined && latlangBounds.length > 0){
				var bounds = new google.maps.LatLngBounds();
				for (var i = 0; i < latlangBounds.length; i++) {
					bounds.extend(latlangBounds[i]);
				}
				if(latlangBounds.length == 1)
				{
					if(me.mapMode == 'Region')
						me.gmap.setZoom(3);
					else if(me.mapMode == 'City')
						me.gmap.setZoom(4);
					else
						me.gmap.setZoom(2);

					me.gmap.setCenter(bounds.getCenter());
				}
				else{
					Ext.defer(function(){
						me.gmap.fitBounds(bounds);
						me.gmap.setCenter(bounds.getCenter());
					},1000)	
				}
			}else
				me.gmap.setZoom(1);
		}
		catch (e)
		{
			me.gmap.setZoom(1);
		}
	},
	loadGeoJSON:function(me,text,style,infobox,markerLocation,locDetailsDiv,detailsArray,colorClass){
		try
		{

			var wid,hit;
			var obj = getStyle(colorClass);
			if(obj != null && obj != undefined){
				wid=obj.width;
				hit=obj.height;
			}
			var iconMarker =   new MarkerWithLabel({
				position: markerLocation,
				map: me.gmap,
				icon:image,
				draggable:false,
				labelAnchor: new google.maps.Point(wid,hit),
				labelContent: '',
				info:detailsArray[1],
				labelClass:colorClass
			  });
			
			me.markerArray.push(iconMarker);
			var centerMarker =  new MarkerWithLabel
			({
			   position: markerLocation,
			   draggable: false,
			   raiseOnDrag: false,
			   map: me.gmap,
			   labelAnchor: new google.maps.Point(2,8),//may be (0,5) --> if so then it display the label from center of bubble
			   labelClass: "labels", 
			   labelStyle: {opacity: 0.90, color:labelColor},
			   icon : image
			});

			var zl = google.maps.event.addListener(iconMarker, 'click',function(e)
					{
						loadView("UED","1",detailsArray[0]);
						//	code to open infoBox
						//infobox.setContent(locDetailsDiv);
						//me.closeAllInfoBox();
						//infobox.open(me.gmap,centerMarker);
					});
			
			me.listenerArray.push(zl);

			var mi = google.maps.event.addListener(iconMarker, 'mouseover',function(e)
					{
						me.access = this.info;
						//	code to open infoBox
						infobox.setContent(locDetailsDiv);
						me.closeAllInfoBox();
						infobox.open(me.gmap,centerMarker);
					});
			
			me.listenerArray.push(mi);
			var mo = google.maps.event.addListener(iconMarker, 'mouseout',function(e)
					{
						me.access = undefined;
						me.closeAllInfoBox();
					});

			me.listenerArray.push(mo);

			var json = JSON.parse(text);
			/*var features = new GeoJSON(json,style);
			me.feauturesArray.push(features);
			for (var i = 0; i < features.length; i++){
				features[i].info=detailsArray[1];
				features[i].colorClass=colorClass;
				features[i].setMap(me.gmap);

				google.maps.event.addListener(features[i], 'click',function(e)
				{
					infobox.setContent(locDetailsDiv);
					me.closeAllInfoBox();
					infobox.open(me.gmap,centerMarker);
				});

				mi = google.maps.event.addListener(features[i], 'mouseover',function(e)
					{
						me.access = this.info;
					});
			
				me.listenerArray.push(mi);

				mo = google.maps.event.addListener(features[i], 'mouseout',function(e)
						{
							me.access = undefined;
						});

				me.listenerArray.push(mo);
			}*/
			
		}
		catch (e)
		{
			console.log('e-->',e)
		}
	},
	closeAllInfoBox:function(){
		try
		{
			var infoBoxArr = this.infoBoxArray;
			for(var a in infoBoxArr)
				infoBoxArr[a].close();
			
		}
		catch (e)
		{
		}
	},
	filterCheck:function(me){
		try
		{
			var disableArrfea=[];
			var disableArricon=[];
			if(!Ext.isEmpty(me)){
				disableArrfea = me.feauturesArray;
				disableArricon = me.markerArray;
								
				var response =  Ext.getCmp('filtermenu_Response_Time').getValue();
				var requests =  Ext.getCmp('filtermenu_Requests').getValue();
				var normal =  Ext.getCmp('filtermenu_Normal').getValue();
				var unknown =  Ext.getCmp('filtermenu_Unknown').getValue();
				var minor =  Ext.getCmp('filtermenu_Minor').getValue();
				var major =  Ext.getCmp('filtermenu_Major').getValue();
				var critical =  Ext.getCmp('filtermenu_Critical').getValue();
				
				if(!Ext.isEmpty(disableArrfea)){
					for(var c in disableArrfea){
						for (var l in disableArrfea[c] )
						{
							if(response){
								var cls = disableArrfea[c][l].colorClass;
								cls = cls.substring(cls.indexOf('_')+1);
								switch(cls){
									case 'GOOD' :if(normal)
													disableArrfea[c][l].setMap(me.gmap);
												else
													disableArrfea[c][l].setMap(null);
												 break;
									case 'UNKNOWN' :if(unknown)
														disableArrfea[c][l].setMap(me.gmap);
													else
														disableArrfea[c][l].setMap(null);
												 break;
									case 'LOW' :if(minor)
													disableArrfea[c][l].setMap(me.gmap);
												else
													disableArrfea[c][l].setMap(null);
												 break;
									case 'INTERMEDIATE' :if(major)
															disableArrfea[c][l].setMap(me.gmap);
														else
															disableArrfea[c][l].setMap(null);
														 break;
									case 'HIGH' :if(critical)
													disableArrfea[c][l].setMap(me.gmap);
												else
													disableArrfea[c][l].setMap(null);
												 break;
									default : disableArrfea[c][l].setMap(me.gmap);
												break;
								}
							}else{
								disableArrfea[c][l].setMap(null);
							}
						}
					}
				}
				
				if(!Ext.isEmpty(disableArricon)){
					for(var c in disableArricon){
						if(requests){
							var cls = disableArricon[c].labelClass;
							cls = cls.substring(cls.indexOf('_')+1);

							switch(cls){
								case 'GOOD' :if(normal)
												disableArricon[c].setMap(me.gmap);
											else
												disableArricon[c].setMap(null);
											 break;
								case 'UNKNOWN' :if(unknown)
													disableArricon[c].setMap(me.gmap);
												else
													disableArricon[c].setMap(null);
											 break;
								case 'LOW' :if(minor)
												disableArricon[c].setMap(me.gmap);
											else
												disableArricon[c].setMap(null);
											 break;
								case 'INTERMEDIATE' :if(major)
														disableArricon[c].setMap(me.gmap);
													else
														disableArricon[c].setMap(null);
													 break;
								case 'HIGH' :if(critical)
												disableArricon[c].setMap(me.gmap);
											else
												disableArricon[c].setMap(null);
											 break;
								default :	disableArricon[c].setMap(me.gmap);
											break;
							}
						}else{
							disableArricon[c].setMap(null);
						}
						
					}
				}
			}
		}
		catch (ert)
		{			
		}

	}	
});


function loadGeoCountry(countryCode,el){
	try
	{
		var menuObj = Ext.getCmp('dashmenu_model_id');
		var elObj = Ext.getCmp(el);
		var store_data=menuObj.getStore();
		var selected_view_name="";
		var index=0;
		for(var k=0;k<store_data.getCount();k++)
		{
			var caption_value=store_data.getAt(k).data.name;
			if(caption_value != null && caption_value != undefined && caption_value=='Geo_View'){
				index=k;
				break;
			}
		}
		try
		{
			menuObj.getSelectionModel().select(index);
			menuObj.forceClickIndex=index;
			menuObj.forceClickKey=countryCode;
			menuObj.cnCombo=elObj.jsonData.countryArray;
			menuObj.fireEvent('itemclick', menuObj, menuObj.getSelectionModel().getLastSelected());
		}
		catch (asa)
		{
			//menuObj.fireEvent('itemclick', Ext.getCmp('Geo_View'),index);
		}
	}
	catch (ee)
	{
		alert(ee)
	}
}
