Ext.define("citrixDashboard.view.LogonPanel", {
	extend: 'Ext.container.Container',
	alias: "widget.logonpanel",
	id:'logonId',	
	//cls:'panelWithoutHeader',
	layout:{
		type:'hbox',
		align:'stretch'
	},
	title:'',
	key:'old',
	//flex:1,
	padding:20,
	margin:0,
	jsonData:null,
	items:[],
	listeners : {
		afterrender:function(){
			var me = this;
			this.renderHostData(this.jsonData);
		}
	},
	renderHostData:function(data){
		var me = this;
		try
		{
			if(data != undefined && data != null && data.length > 0){
				var el=1;
				for(var a in data){
					var obj = data[a];
					var chart_type = obj['chart'];
					if(chart_type == undefined)
						chart_type= obj['type'];
					if(chart_type != undefined && chart_type.toLowerCase() == 'text')
					{
						var textPanel = this.getTextPanel(obj);
						me.add(textPanel);
					}
					else if(chart_type != undefined && chart_type.toLowerCase() == 'grouptext' )
					{
						var groupArr = obj['groupArr'];
						var groupTextPanel = this.getGroupTextPanel(obj);
						me.add(groupTextPanel);
					}
					else if(chart_type != undefined && chart_type.toLowerCase() == 'pie' ){
						var id=chart_type+'_'+a;
						var piePanel = this.getPiePanel(obj,id);
						me.add(piePanel);
					}
					else if(chart_type != undefined && chart_type.toLowerCase() == 'donut' ){
						var id=chart_type+'_'+a;
						var donutPanel = this.getDonutPanel(obj,id);
						me.add(donutPanel);
					}
					else if(chart_type != undefined && chart_type == 'Gauge' ){
						var id=chart_type+'_'+a;
						var gaugePanel = this.getGaugePanel(obj,id,a);
						me.add(gaugePanel);
					}
					el++;
				}
			}else{
				me.add([{xtype:'container', html:'<table align="center" style="margin:22% auto 0 auto;height:100%"><tr><td style="text-align:center"><img src="/final/images/spacer.gif" class="iconInformation"/></br>No Data Available now!</td></tr></table>'}]);
			}
		}
		catch (e)
		{
			me.add([{xtype:'container', html:'<table align="center" style="margin:22% auto 0 auto;height:100%"><tr><td style="text-align:center"><img src="/final/images/spacer.gif" class="iconInformation"/></br>No Data Available now!</td></tr></table>'}]);
		}
	},
	getGroupTextPanel:function(obj){
		var grpTextPanel = {
			xtype:'container',
			cls:'widgetcon font_bold12',
			html:'Avg Logon Time',
			//baseCls:'panelHeader',
			layout:{
				type:'hbox',
				align:'stretch'
			},
			flex:1,
			padding:'0 20 0 0',
			margin:'0 10 0 0',
			items:[],
			listeners:{
				'afterrender':function(panel){
					var groupTextArr=obj['groupArr'];
					if(groupTextArr != undefined && groupTextArr != null){

						for (i=0;i<groupTextArr.length ;i++ )
						{
							panel.add({
								xtype:'container',
								//height:80,
								flex:1,
								margin:'0 0 0 0',
								padding:'20 0 0 0',
								html:'<span class="font_bold9 grayColor" style="position:relative;top:20px">Last 5 Mins</span><div class="widgetholders chartminmax" style="height:66px;"><div class="b_box"><div class="font_bold12"><div class="font_normal31 d_m_t20 d_p_t20" style="text-align:center;">'+groupTextArr[i]['value']+'</div><div class="font_normal11 legendLabel" style="text-align:center;">'+groupTextArr[i]['title']+'<div style="clear:both"></div></div></div></div>'
							});		
						}
					}
				}
			},
			items:[],
		
		};

		return grpTextPanel;
	},
	getGaugePanel:function(obj,id,a){
		var panelCls='separator_measure';

		if (a==0)
		{
			panelCls='';
		}
		var dafault_colr='#35c8c2';
		if(obj.colorValue != undefined)
			dafault_colr = obj.colorValue; 

		
		var container = {
			xtype:'panel',
			id:id,
			cls:'widgetcon font_bold12',
			//cls:panelCls,
			baseCls:'panelHeader',
			data:obj,
			margin:'0 10 0 10',
			highChartObj:null,
			flex:1,
			listeners:{
				'afterrender':function(){
					try
					{
						var jsonData = this.data['chartXML'];
						jsonData['useHtml'] = false;
						var strSkinclr = ( strSkin == 'Dark' )?'#c6c6c6':'#333333';
						jsonData['strSkinclr'] = strSkinclr;
						var gaugeChartObj = {};
						//gaugeChartObj = jQuery.extend(true, {}, getHighChartsGuageEnd(id,'',hegiht,width),gaugeChartObj);
						gaugeChartObj = jQuery.extend(true, {}, getHighChartsGuageEnd(id,'',123,246,'65%'),gaugeChartObj,dafault_colr);
						gaugeChartObj.setData(jsonData);
						gaugeChartObj.drawChart();
						this.highChartObj = gaugeChartObj;
						gaugeChartObj=null;
						delete gaugeChartObj;
						var title = '<span style="display: block;float:left;margin-top:-2px;"><img class="'+this.data['state']+'" src="/final/images/clear.png" border="0" /></span><span>'+jsonData['title']+'</span>';
						this.setTitle(title);
					}
					catch (e)
					{
						//console.log('e-->',e)
					}
				}
			}
		};
		return container;
	},
	getDonutPanel:function(obj,id){
		var container = {
			xtype:'panel',
			baseCls:'panelHeader',
			id:id,
			data:obj,
			title:'Distribution Alerts',
			cls:'widgetcon font_bold12',
			flex:1,
			margin:'0 0 0 0',
			items:[
				{
					xtype:'container',
					cls:'font_bold12',
				},
				{
					xtype:'container',
					flex:1,
					id:'donutContainer',
					data:obj,
					listeners:{
						'resize':function(){
							this.data['customMsg'] = 'yes';
							this.data['formatTip'] = 'yes';
							this.data['rumPie'] = 'yes';
							this.data['legendNeeded'] = true;
							this.data['dataLabels'] = false;
							
							this.data['startAngle'] = '-90';
							this.data['endAngle'] ='360';
							this.data['innerSize'] ='40%';
							
							var width = Ext.getCmp(id).getWidth();
							var height = Ext.getCmp(id).getHeight();
								try
								{
									var pieChart = {};
									pieChart = jQuery.extend(true, {}, getDonutChartsInstance1(this.id,height,width), pieChart);
									pieChart.setData(this.data,'','','donut');
									container.chartObj=pieChart;
									pieChart.drawChart();		
								}
								catch (er)
								{
									//console.log("er=-=-=->",er)
								}
							
						}
					}
				}
			],
			
			
		};

		return container;
	},
	getPiePanel:function(obj,id){
		var container = {
			xtype:'panel',
			id:id,
			data:obj,
			cls:'widgetcon font_bold12',
			flex:1,
			margin:'0 10 0 10',
			items:[
				
			],
			listeners:{
				'afterrender':function(){
					this.data['customMsg'] = 'yes';
					this.data['formatTip'] = 'yes';
					this.data['rumPie'] = 'yes';
					this.data['dataLabels'] = false;
					var pieChart = {};
					pieChart = jQuery.extend(true, {}, createPie(this.id,100,150), pieChart);
					pieChart.setData(this.data,'','','pie');
					container.chartObj=pieChart;
					pieChart.drawChart();
				}
			}
		};

		return container;
	},
	getTextPanel:function(obj){
		var temp = {
			xtype:'panel',
			cls:'widgetcon',
			flex:1,
			margin:'0 10 0 0',
			items:[
				{
					xtype:'container',
					cls:'font_bold12',
					html:"<div style='float:left;margin-right:5px' class="+obj['state']+"></div>"+"<div>"+obj['title']+"</div>"
				},
				{
					xtype:'container',
					cls:'font_normal31',
					style:{'margin-top':'39px','text-align':'center'},
					html:obj['value']+"<span style='font-size:21px'>%</span>"
				},
				{
					xtype:'container',
					style:{'margin-top':'14px','text-align':'center'},
					html:obj['fun']
				}
			]
		};

		return temp;
	}
});