
Ext.define('UserWidgetModel', {
    extend: 'Ext.data.Model',
    fields: [
        { name:'state', type:'string' },
        { name:'heading', type:'string' },
        { name:'value', type:'number' },
		{ name:'legend', type:'string' },
		{ name:'graphID', type:'number' },
		{ name:'graphData' }
    ]
});

Ext.create('Ext.data.Store', {
    id:'userWidget_model_id',
    model: 'UserWidgetModel',
	autoLoad:true,
    data: [

        {  
			"state":"HIGH" ,
			"heading":"Users",
			"value":"95",
			"legend":"Nos.",
			"graphData":[0,9, 9, 30, 15, 19, 9, 27, 19, 19, 0]
	}
    
    ]
});


var userWidget= {
			xtype:'dataview',
			padding:'5 0 5 0',
			store: Ext.data.StoreManager.lookup('userWidget_model_id'),
			tpl: new Ext.XTemplate(
				'<div class="widgetholders">',
				'<tpl for=".">',
					'<div class="s_box">',
					 '<div class="font_bold12 div_center" style="float:left;width:50%"><img src="/final/images/clear.png" class="state_{state}" /> <span>{heading}</ span></div>',
					 '<div style="float:right;width:50%" class="div_center"><div  class="font_bold18" style="text-align:right">{value}</div><div class="font_normal11 trim_text" style="text-align:right;vertical-align:top;width:100%"> {legend}</div></div>',
					 '<div style="clear:both"></div>',
					 '</div>',
					'<div class="b_box">',
					  '<div class="font_bold12"><img style="vertical-align:sub" src="/final/images/clear.png" class="stateIconRumAppFlow{state}" /> <span>{heading}</ span></div>',
						'<div class="font_normal31 d_m_t20" style="text-align:center;margin-top:50px">{value}</div>',
						'<div class="font_normal11 legendLabel" style="text-align:center">{legend}</div>',
					'</div>',
				'</tpl>',
				'</div>'
			),
		}


Ext.define('citrixDashboard.view.OverviewWidgets', {
     extend: 'Ext.container.Container',
	alias:'widget.overviewwidgets',
	requires:[
			'citrixDashboard.view.TrafficWidget',
			'citrixDashboard.view.UniqueSessionsWidget',
			'citrixDashboard.view.UxEWidget',
			'citrixDashboard.view.PageLoadTimeWidget',
			'citrixDashboard.view.ErrorWidget',
			'widgets.TextDonutLegend'
			
			
	 ],
	layout:{
			type:'hbox',
			align:'stretch'
	},
	flex:1,
	padding:0,
	defaults:{
		flex:1,
		padding:'0 10 0 10',
		margin:'15 0 15 0',
		layout:{
			//type:'fit'
		}
	},
	autoDestroy:true,	
	initComponent:function(){
		var overviewwidgets =  this;
		overviewwidgets.callParent();
	},
	items:[
	/*{
		xtype:'trafficwidget'
	},*/
	{
		xtype:'uniquesessionswidget',
		//xtype:'textdonutlegend',
		//data:itemJson,
		id:'OVId',
		flex:1.25
	},
	{
		xtype:'container',
		flex:1,
		cls:'widgetcon',
		//items:[userWidget]
		items:[]
	},
	{
		xtype:'errorwidget',
		flex:1,
		//data:sparklineData
	},
	{
		xtype:'container',
		flex:1,
		cls:'widgetcon',
		//items:[userWidget]
		items:[]
	},
	{
		xtype:'pageloadtimewidget',
		flex:1,
		//data:sparklineDataColumn
	},
		
	]
 });