Ext.define('citrixDashboard.view.Resources', {
     extend: 'Ext.container.Container',
	alias:'widget.resources',
	requires:[
			'citrixDashboard.view.OverviewPanel',
	 ],
	layout:'fit',
	autoDestroy:true,
	currUrl:null,
	//padding:'0 5 5 5',
	//ui:'eg-container',
	id:'resources_view_id',
	tools:[
		{
		xtype:'toolbar',
		items:[
				{
				xtype:'combo',
				cls:'dropdown',
				width:250,
				labelWidth:130,
				labelSeparator:'',
				margin:'0 10 0 0',
				fieldLabel:'Showing data for last',
			}
		]
	}
	],
	items:[
		{
			xtype:'header',
			height:25,
			id:'res_first_header_id',
			title:'SERVER RESOURCES',
		},{
				xtype:'container',
				height:1,
				items:[
				{
						xtype:'button',
						id:'res_toogle',
						height:16,
						width:16,
						style:{'margin-right':'5px !important'},
						iconCls:'toggle_m',
						itemId:'overviewtoggle',
						enableToggle:true,
						ui:'overviewtoggle'
				}	
				]
		},{
			xtype:'overviewdetails',
			layout:'fit',
			margin:'0 1 0 0',
			id:'res_overview_id',
			items:[]
		},
		{
			xtype:'panel',
			id:'res_acc_pan_id',
			ui:'eg-accordion-panel',
			padding:0,
			margin:0,
			//fill:true,
			flex:2,
			layout: {
				type: 'accordion',
				animate: true,
				multi: true,				
			},
			items:[
			{
				id:'res_user_header_id',
				title:'Top Users',
				width:'100%',
				layout:{type:'anchor',anchor:'50%'},
				margin:'10 2 0 0',
				bodyPadding:'0 20 20 20',
				collapsed : (!isExpendAllBlocks),
				items:[],
				listeners: {
					afterlayout: function() {
						var res_chartObj = Ext.getCmp('multBarIns_user');
						
						if(!Ext.isEmpty(res_chartObj) && !Ext.isEmpty(res_chartObj.data) && res_chartObj.data!=undefined)
						{
							for (var i= 0; i <  res_chartObj.data.length;i++ )
							{
								var topUserJsonDataObj=null;
								try
								{
									topUserJsonDataObj=res_chartObj.data[i][0];
								}
								catch (ee)
								{
									topUserJsonDataObj=res_chartObj.data[i];
								}

								if(topUserJsonDataObj == undefined || topUserJsonDataObj == null)
									continue;

								//var chartObj_id = 'chartParent_multBarIns_user_'+res_chartObj.orgData[i].chartCId+'_'+i;
								var chartObj_id = 'chartParent_multBarIns_user_'+topUserJsonDataObj.chartCId+'_'+i;

								if(chartObj_id.indexOf("(") != -1)
									chartObj_id = chartObj_id.replace("(","LB")

								if(chartObj_id.indexOf(")") != -1)
									chartObj_id = chartObj_id.replace(")","RB")

								if(!Ext.isEmpty(Ext.getCmp(chartObj_id)))
								{
									$('#'+chartObj_id+'-body').width('100%');
									var skinBorder=( (strSkin=='Dark' || strSkin=='dark') )?'#525252':'#f2f2f2';
									if(i%2 == 0)
										Ext.getCmp(chartObj_id).getEl().dom.style.borderRight="1px solid "+skinBorder;
									else
										Ext.getCmp(chartObj_id).getEl().dom.style.borderRight="0px solid "+skinBorder;
									
									var dividend = 2;
									if(res_chartObj.data.length%2 != 0)
										dividend = 1;

									if((res_chartObj.data.length-dividend)>i)
										Ext.getCmp(chartObj_id).getEl().dom.style.borderBottom="1px solid "+skinBorder;
									else
										Ext.getCmp(chartObj_id).getEl().dom.style.borderBottom="0px solid "+skinBorder;
								}
							}
						}
					},
					expand: function() 
					{						
						var res_chartObj = Ext.getCmp('multBarIns_user');
						if(!Ext.isEmpty(res_chartObj) && !Ext.isEmpty(res_chartObj.data) && res_chartObj.data!=undefined)
						{							
							for (var i= 0; i <  res_chartObj.data.length;i++ )
							{
								var topUserJsonDataObj=null;
								try
								{
									topUserJsonDataObj=res_chartObj.data[i][0];
								}
								catch (ee)
								{
									topUserJsonDataObj=res_chartObj.data[i];
								}

								if(topUserJsonDataObj == undefined || topUserJsonDataObj == null)
									continue;

								var chartObj_id = 'chartParent_multBarIns_user_'+topUserJsonDataObj.chartCId+'_'+i;

								if(chartObj_id.indexOf("(") != -1)
									chartObj_id = chartObj_id.replace("(","LB")

								if(chartObj_id.indexOf(")") != -1)
									chartObj_id = chartObj_id.replace(")","RB")

								if(!Ext.isEmpty(Ext.getCmp(chartObj_id)))
									Ext.getCmp(chartObj_id).updateChart(chartObj_id+'-body',topUserJsonDataObj,'Bar');									
							}
						}
					}
				}
			},{
				id:'res_app_header_id',
				title:'Top Applications',
				width:'100%',
				flex:2,
				layout:{type:'vbox',align:'stretch'},
				margin:'10 2 0 0',
				bodyPadding:'0 20 20 20',
				collapsed : (!isExpendAllBlocks),
				items:[],
				listeners: {
					afterlayout: function() {
						var res_chartObj = Ext.getCmp('multBarIns_app');						
						if(!Ext.isEmpty(res_chartObj) && !Ext.isEmpty(res_chartObj.data) && res_chartObj.data!=undefined)
						{
							for (var i= 0; i <  res_chartObj.data.length;i++ )
							{
								var topAppJsonDataObj=null;
								try
								{
									topAppJsonDataObj=res_chartObj.data[i][0];
								}
								catch (ee)
								{
									topAppJsonDataObj=res_chartObj.data[i];
								}

								if(topAppJsonDataObj == undefined || topAppJsonDataObj == null)
									continue;

								var chartObj_id = 'chartParent_multBarIns_app_'+topAppJsonDataObj.chartCId+'_'+i;

								if(chartObj_id.indexOf("(") != -1)
									chartObj_id = chartObj_id.replace("(","LB")

								if(chartObj_id.indexOf(")") != -1)
									chartObj_id = chartObj_id.replace(")","RB")


								var skinBorder=( (strSkin=='Dark' || strSkin=='dark') )?'#525252':'#f2f2f2';

								if(!Ext.isEmpty(Ext.getCmp(chartObj_id)))
								{
									$('#'+chartObj_id+'-body').width('100%');

									if(i%2 == 0)
										Ext.getCmp(chartObj_id).getEl().dom.style.borderRight="1px solid "+skinBorder;
									else
										Ext.getCmp(chartObj_id).getEl().dom.style.borderRight="0px solid "+skinBorder;

									var dividend = 2;
									if(res_chartObj.data.length%2 != 0)
										dividend = 1;

									if((res_chartObj.data.length-dividend)>i)
										Ext.getCmp(chartObj_id).getEl().dom.style.borderBottom="1px solid "+skinBorder;
									else
										Ext.getCmp(chartObj_id).getEl().dom.style.borderBottom="0px solid "+skinBorder;
								}
							}
						}
						
					},
					expand: function() {
						var app_r_url=Ext.getCmp('resources_view_id').currUrl;
						if(!Ext.isEmpty(app_r_url) && app_r_url!=undefined)
						{
							app_r_url=app_r_url+"&selectedVariable=Resources_Block_3_Title,Resources_Block_3_Value";

							Ext.Ajax.request({
							url : app_r_url,
							method : 'POST',
							scope:this,
							timeout:280000,
							success : function(response, opts)
							{
								var jsonText = response.responseText;
								var noWidgets=true;
								if(jsonText!=null && jsonText!=undefined)
								{
									var jsonData = Ext.decode(jsonText);

									if(jsonData!=null && jsonData!=undefined)
									{
										if(jsonData.loadViewDetails!=null && jsonData.loadViewDetails!=undefined)
										{
											var panelDataArr=jsonData.loadViewDetails;
											if(panelDataArr!=null && panelDataArr!=undefined && panelDataArr.length>0)
											{
												if(!Ext.isEmpty(panelDataArr[0]) && panelDataArr[0]!=undefined)
												{
													var topResidObj = Ext.getCmp('res_app_header_id');
													topResidObj.setTitle(panelDataArr[0].Resources_Block_3_Title);
												}
												if((!Ext.isEmpty(panelDataArr[1]) && panelDataArr[1]!=undefined))
												{
													var res_chartObj = Ext.getCmp('res_app_header_id');
													res_chartObj.removeAll(true);
													res_chartObj.add({
														xtype:'chartparentpanel',
														id:'multBarIns_app',
														ifRes:true,
														//legendPosition: 'top',
														//chartType:panelDataArr[3].Application_Block_2_Value.result.chartType,
														data:panelDataArr[1].Resources_Block_3_Value,
														orgData:panelDataArr[1].Resources_Block_3_Value,
														flex:1,
														//height:500
														//width:'100%',
														//data:panelDataArr[3].Application_Block_2_Value.result
														//data:panelDataArr[3].Application_Block_2.result
														//html:'<table><tr><td>'+overviewData[0]['chart']+'</td></tr></table>'
													});
													res_chartObj.doLayout();
												}
											}
										}
									}
								}
							}
							});
						}
						else
						{
							var res_chartObj = Ext.getCmp('multBarIns_app');
							if(!Ext.isEmpty(res_chartObj) && !Ext.isEmpty(res_chartObj.data) && res_chartObj.data!=undefined)
							{
								for (var i= 0; i <  res_chartObj.data.length;i++ )
								{
									var topAppJsonDataObj=null;
									try
									{
										topAppJsonDataObj=res_chartObj.data[i][0];
									}
									catch (ee)
									{
										topAppJsonDataObj=res_chartObj.data[i];
									}

									if(topAppJsonDataObj == undefined || topAppJsonDataObj == null)
										continue;

									var chartObj_id = 'chartParent_multBarIns_app_'+topAppJsonDataObj.chartCId+'_'+i;

									if(chartObj_id.indexOf("(") != -1)
										chartObj_id = chartObj_id.replace("(","LB")

									if(chartObj_id.indexOf(")") != -1)
										chartObj_id = chartObj_id.replace(")","RB")

									if(!Ext.isEmpty(Ext.getCmp(chartObj_id)))
									{
										Ext.getCmp(chartObj_id).updateChart(chartObj_id+'-body',topAppJsonDataObj,'Bar');
									}
								}
							}
						}
					}
				}
			},
			{
				id:'res_server_header_id',
				title:'Top Servers',
				width:'100%',
				flex:2,
				layout:{type:'vbox',align:'stretch'},
				margin:'10 2 10 0',
				bodyPadding:'0 20 20 20',
				collapsed : (!isExpendAllBlocks),
				items:[],
				listeners: {
					afterlayout: function() {
						var res_chartObj = Ext.getCmp('multBarIns_server');						
						if(!Ext.isEmpty(res_chartObj) && !Ext.isEmpty(res_chartObj.data) && res_chartObj.data!=undefined)
						{
							for (var i= 0; i <  res_chartObj.data.length;i++ )
							{
								var topServerJsonDataObj=null;
								try
								{
									topServerJsonDataObj=res_chartObj.data[i][0];
								}
								catch (ee)
								{
									topServerJsonDataObj=res_chartObj.data[i];
								}

								if(topServerJsonDataObj == undefined || topServerJsonDataObj == null)
									continue;

								var chartObj_id = 'chartParent_multBarIns_server_'+topServerJsonDataObj.chartCId+'_'+i;

								if(chartObj_id.indexOf("(") != -1)
									chartObj_id = chartObj_id.replace("(","LB")

								if(chartObj_id.indexOf(")") != -1)
									chartObj_id = chartObj_id.replace(")","RB")

								var skinBorder=( (strSkin=='Dark' || strSkin=='dark') )?'#525252':'#f2f2f2';

								if(!Ext.isEmpty(Ext.getCmp(chartObj_id)))
								{
									$('#'+chartObj_id+'-body').width('100%');
									if(i%2 == 0)
										Ext.getCmp(chartObj_id).getEl().dom.style.borderRight="1px solid "+skinBorder;
									else
										Ext.getCmp(chartObj_id).getEl().dom.style.borderRight="0px solid "+skinBorder;
									
									var dividend = 2;
									if(res_chartObj.data.length%2 != 0)
										dividend = 1;

									if((res_chartObj.data.length-dividend)>i)
										Ext.getCmp(chartObj_id).getEl().dom.style.borderBottom="1px solid "+skinBorder;
									else
										Ext.getCmp(chartObj_id).getEl().dom.style.borderBottom="0px solid "+skinBorder;
								}
							}
						}
					},
					expand: function() {
						var ser_r_url=Ext.getCmp('resources_view_id').currUrl;
						if(!Ext.isEmpty(ser_r_url) && ser_r_url!=undefined)
						{
							ser_r_url=ser_r_url+"&selectedVariable=Resources_Block_4_Title,Resources_Block_4_Value";

							Ext.Ajax.request({
							url : ser_r_url,
							method : 'POST',
							scope:this,
							timeout:280000,
							success : function(response, opts)
							{
								var jsonText = response.responseText;
								if(jsonText!=null && jsonText!=undefined)
								{
									var jsonData = Ext.decode(jsonText);

									if(jsonData!=null && jsonData!=undefined)
									{
										if(jsonData.loadViewDetails!=null && jsonData.loadViewDetails!=undefined)
										{
											var panelDataArr=jsonData.loadViewDetails;

											if(!Ext.isEmpty(panelDataArr[0]) && panelDataArr[0]!=undefined)
											{
												var topResidObj = Ext.getCmp('res_server_header_id');
												topResidObj.setTitle(panelDataArr[0].Resources_Block_4_Title);
											}

											if((!Ext.isEmpty(panelDataArr[1]) && panelDataArr[1]!=undefined))
											{
												var res_chartObj = Ext.getCmp('res_server_header_id');
												res_chartObj.removeAll(true);
												res_chartObj.add({
													xtype:'chartparentpanel',
													id:'multBarIns_server',
													ifRes:true,
													//legendPosition: 'top',
													//chartType:panelDataArr[3].Application_Block_2_Value.result.chartType,
													data:panelDataArr[1].Resources_Block_4_Value,
													orgData:panelDataArr[1].Resources_Block_4_Value,
													flex:1,
													//height:500
													//width:'100%',
													//data:panelDataArr[3].Application_Block_2_Value.result
													//data:panelDataArr[3].Application_Block_2.result
													//html:'<table><tr><td>'+overviewData[0]['chart']+'</td></tr></table>'
												});
												res_chartObj.doLayout();
											}
										}
									}
								}
							}
							});
						}
						else
						{
							var res_chartObj = Ext.getCmp('multBarIns_server');
							if(!Ext.isEmpty(res_chartObj) && !Ext.isEmpty(res_chartObj.data) && res_chartObj.data!=undefined)
							{
								for (var i= 0; i <  res_chartObj.data.length;i++ )
								{
									var topServerJsonDataObj=null;
									try
									{
										topServerJsonDataObj=res_chartObj.data[i][0];
									}
									catch (ee)
									{
										topServerJsonDataObj=res_chartObj.data[i];
									}

									if(topServerJsonDataObj == undefined || topServerJsonDataObj == null)
										continue;

									var chartObj_id = 'chartParent_multBarIns_server_'+topServerJsonDataObj.chartCId+'_'+i;

									if(chartObj_id.indexOf("(") != -1)
										chartObj_id = chartObj_id.replace("(","LB")

									if(chartObj_id.indexOf(")") != -1)
										chartObj_id = chartObj_id.replace(")","RB")

									if(!Ext.isEmpty(Ext.getCmp(chartObj_id)))
									{
										Ext.getCmp(chartObj_id).updateChart(chartObj_id+'-body',topServerJsonDataObj,'Bar');
									}
								}
							}
						}
					}
				}
			}
			]
		},
	 ]
	
 });


