Ext.define('citrixDashboard.view.SessionMapDetails', {
	 extend: 'Ext.grid.Panel',
    requires: ['Ext.grid.feature.RowBody'],
    padding: 0,
   border: true,
    margin:'65px 5px 10px 5px',
	columnLines : true,
	//style:{'border':'1px solid green !important'},
    alias: 'widget.sessionmapdetails',
	//title: 'World',
	//infoCls:'big_infoIcon',
	//addInfo:true, // enable infoIcon
	//ui:'plainGrid',
	ui:'newGridPanel',
	id:'',
	jsonData:'',
	jsonData1:'',
	//store: Ext.data.StoreManager.lookup('mapStore'),
	store:null,
	columns:null,
	viewConfig: {
		emptyText:'<div style="display:table;height:98%;width:100%" ><div style="display:table-cell;vertical-align:middle;text-align:center;"><div style="margin:auto;" class="iconInformation"></div><div>No Data Found!</div></div></div>',
		deferEmptyText: false,
	},
	initComponent: function() {
        var me = this;
		var dataArr = [];
		//console.log("me.jsonData=-=-=->",me.jsonData)
		if(!Ext.isEmpty(me.jsonData) && !Ext.isEmpty(me.jsonData.resultArray))
			dataArr=me.jsonData.resultArray;
		me.store=Ext.create('Ext.data.Store', {
			storeId: 'mapStore1',
			//fields: ['loadTime', 'pageViews', 'from', 'chartData', 'legendColor'],
			fields: ['m1', 'm2', 'from', 'chartData', 'legendColor','m1_code'],
			data:dataArr,
			sorters: [{
				property: 'm1',
				direction: 'DESC'
			}],
			proxy: {
				type: 'memory',
				reader: {
					type: 'json'
				}
			}
		});
		if(!Ext.isEmpty(me.jsonData.ng_cols) && me.jsonData.ng_cols != undefined && me.jsonData.ng_cols != null)
			me.columns=me.jsonData.ng_cols;
		else
			me.columns=null;


		if(!Ext.isEmpty(me.columns) && me.columns != undefined && me.columns != null){
			//for adding Flag for Countries
			for (var i=0;i< me.columns.length;i++){
				me.columns[i].renderer=function(value,metaData,record,rowIndex,colIndex,view){
					try
					{
						var codeCls = record.data.m1_code;
						codeCls = codeCls.toLowerCase();
						if(this.columns[colIndex].dataIndex == "m1"){
							var tmp_val = "<a href=\"javascript:loadView('UED','1','"+value+"')\">"+value+"</a>";
							value = "<span  class ='f16' data-qclass='yellowTip' data-qtip='"+value+"' ><img src='../images/clear.png' class='flag "+codeCls+"' style='vertical-align: middle'/>&nbsp;"+tmp_val+"</span>";
							
						}
						else
						{
							var tempVal = record.data.m1;
							value = "<a href=\"javascript:loadView('UED','1','"+tempVal+"')\">"+value+"</a>";
						}
					}
					catch (end)
					{
					}	
					return value;
				}
			}
		}
		
		this.callParent();
	},
	updateData:function(data){
		var me = this;
		if(!Ext.isEmpty(data.ng_cols) && data.ng_cols != undefined && data.ng_cols != null)
			me.columns=data.ng_cols;
		else
			me.columns=null;
		me.store.loadRawData(data.resultArray);		
	},
	infoToolTip:function(btn){
		var me = this;
	
		var tooltip=  Ext.create("Ext.tip.ToolTip", {
						anchor: "top",
						shadow: true,
						anchorOffset: 25,
						mouseOffset:[0,0],
						target:Ext.fly(btn),
						cls: "moreoptionstooltip",
					
						listeners: {
							hide:function(tooltip){
								if(!Ext.isEmpty(tooltip)){
										Ext.destroy(tooltip);
								}
							},
							render: function(a) {
								Ext.EventManager.onWindowResize(function(b, c) {
									a.hide();
								});
							}
						},
						
						 getTargetXY: function() {
							  var x = Ext.fly(btn).getXY()[0];
							  var y = Ext.fly(btn).getXY()[1];
							   return [x - tooltip.anchorOffset - 12,  Ext.fly(btn).getHeight() + y];
						 },
						autoHide: false,
						anchorToTarget: true,
						width: 210,
						padding: "10 2 10 10",
						style: 'text-align:left',
						html: "<div class='t_b'><ol><li>Shows where Citrix users are coming from</li><li>Size of the geo-marker varies with the number of Citrix user sessions</li><li>State indicates the level of HDX latency experienced by the users connecting from a geography</li></ol></div>"
					});
		tooltip.show();
		return tooltip;
	},
	addInfoIcon:function(iconCls){
		 var me = this;
		 var el = Ext.get(me.header.getComponent(0).id).createChild({ 
				tag: 'span', 
				cls:iconCls ,
				style:"padding:5px 7px;margin-left:5px;cursor:pointer"
			},null,true);
			Ext.fly(el).addListener('click', function() { me.infoToolTip(el) });
	},    
    /*columns: [{
            text: 'AVG PAGE LOAD TIME (ms)',
            dataIndex: 'm1',
			menuDisabled : true,
			overCls:'header_over',
            width:174
        },
        {
            text: "PAGE VIEWS",
            dataIndex: "m2",
			menuDisabled : true,
			overCls:'header_over',
            flex: 1
        }
    ],*/
    features: [{
        ftype: 'rowbody'        
    }]
});