Ext.define('SessionsLogoutModel', {
    extend: 'Ext.data.Model',
    fields: [
        { name:'state', type:'string' },
        { name:'heading', type:'string' },
        { name:'value', type:'number' },
		{ name:'legend', type:'string' },
		{ name:'sessions' },
		{ name:'graphID', type:'string' }
    ]
});

Ext.create('Ext.data.Store', {
    id:'Sessionslogout_model_id',
    model: 'SessionsLogoutModel',
	autoLoad:true,
    data: [
        {  
			"state":"HIGH" ,
			"heading":"Connected vs Disconnected",
			"value":"24",
			"legend":"No.s",
			"sessions":[
				{"name":"desktop_session","y":8,"color": "#a1b0e7","text": "Users","value": "11"},	
				{"name":"tab_session","y":4,"color": "#ced4b0","text": "Applications","value": "4"},
			]
		}
    
    ]
});

// .stateIconRumAppFlowHealthy, .stateIconRumAppFlowMinor, .stateIconRumAppFlowMajor, .stateRumAppFlowNotOk
var SessionsLogoutTpl = new Ext.XTemplate(
	'<div class="widgetholders">',
    '<tpl for=".">',
	'<div class="s_box">',
		 //'<div style="float:left;width:100%"><img style="vertical-align:sub" src="/final/images/clear.png" class="state_{state}" /> <span class="font_bold14 " >{heading}</span></div>',
		 '<div style="float:right;width:30%" class="div_center"><div  class="font_bold18" style="text-align:right">{value}</div><div class="font_normal11 trim_text" style="vertical-align:top;text-align:right;width:100%"> {legend}</div></div>',
		 '<div style="clear:both"></div>',
		 '</div>',
        '<div class="b_box">',
		  //'<div class="font_bold14"><span>{heading}</ span></div>',
			 '<div  style="text-align:center;width:260px;height:370px;float:left;margin-top:10px" id="sessionslogout-graph"></div>',
			 //'<div style="clear:both"></div>',
			 '</div>',
        '</div>',
    '</tpl>',
	'</div>'
);

Ext.define('citrixDashboard.view.SessionsLogout', {
    extend: 'Ext.container.Container',
	alias:'widget.sessionslogout',
	ui:'uniqueSessions',
	autoDestroy:true,
	items:[],
	data:'',
	style:{'border':'0px solid red !important'},
	id:'SessionLogoutId',
	listeners:{
		afterrender:function(e){
			var chartDData = this.data;
			//this.add({xtype:'panel',width:150,html:'asdadcadasdad'});
			SessionsLogoutTpl = new Ext.XTemplate(
				'<div class="widgetholders">',
				'<tpl for=".">',
				'<div class="s_box">',
					// '<div style="float:left;width:100%"><img style="vertical-align:sub" src="/final/images/clear.png" class="state_{state}" /> <span class="font_bold14 " >{heading}</span></div>',
					 '<div style="float:right;width:30%" class="div_center"><div  class="font_bold18" style="text-align:right">{value}</div><div class="font_normal11 trim_text" style="vertical-align:top;text-align:right;width:100%"> {legend}</div></div>',
					 '<div style="clear:both"></div>',
					 '</div>',
					'<div class="b_box">',
					 // '<div class="font_bold14"><span>{heading}</ span></div>',
						 '<div  style="text-align:center;width:260px;height:370px;float:left;margin-top:10px" id="sessionslogout-graph"></div>',
						 //'<div style="clear:both"></div>',
						 '</div>',
					'</div>',
				'</tpl>',
				'</div>'
			);
			/*var getItems = getAreaItemforSess(this.data);
			if(!Ext.isEmpty(Ext.getCmp('areaChartSessLog'))){
				Ext.getCmp('areaChartSessLog').destroy();
			}*/
			//this.add(getItems);
			this.add({
				xtype:'dataview',
				padding:5,
				id:'areaChartSessLog',
				autoDestroy:true,
				store: Ext.data.StoreManager.lookup('Sessionslogout_model_id'),
				tpl: SessionsLogoutTpl,
				listeners:{
					viewready:function(x){						
						var jsonData = '';
						if(!Ext.isEmpty(chartDData)){
							try
							{
								var lineChart = {};	
								var width = Ext.getCmp('SessionLogoutId').getWidth();
								var height = Ext.getCmp('SessionLogoutId').getHeight();
								lineChart = jQuery.extend(true, {},getHighcharts1('SessionLogoutId',height-150,width-20,''), lineChart);
								lineChart.setData(chartDData,'','','','bottom');
								jsonData = lineChart.highchart;
							}
							catch (eer)
							{
								console.log("eer=-=->",eer)
							}				
						}
						else
						{
							jsonData = {
								chart: {
									
									type: 'area',
									spacingBottom: 0,
									spacingTop: 0,
									spacingLeft: 0,
									spacingRight: 0,
									width: 530,
									height:220,
									backgroundColor: null
								},
								accessibility:{
									enabled:false	
								},
								exporting:{
									buttons:{
										contextButton:{
											enabled:false
										}
									}	
									
								},
								tooltip: {
									enabled: false
								},

								title: {
									text: '',
									align: 'center',
									verticalAlign: 'middle',
									y: 10
								},  
								xAxis: {
									allowDecimals: false,
									labels: {
										formatter: function () {
											return this.value; // clean, unformatted number for year
										}
									}
								},
								yAxis: {
									title: {
										text: 'Sessions'
									},
									labels: {
										formatter: function () {
											return this.value / 1000 + 'k';
										}
									}
								},
								tooltip: {
									pointFormat: '{series.name} produced <b>{point.y:,.0f}</b><br/>warheads in {point.x}'
								},
								plotOptions: {
									area: {
										pointStart: 1940,
										marker: {
											enabled: false,
											symbol: 'circle',
											radius: 2,
											states: {
												hover: {
													enabled: true
												}
											}
										}
									}
								},
								  series: [{
									name: 'Connected',
									data: [null, null, null, null, null, 6, 11, 32, 110, 235, 369, 640,
										1005, 1436, 2063, 3057, 4618, 6444, 9822, 15468, 20434, 24126,
										27387, 29459, 31056, 31982, 32040, 31233, 29224, 27342, 26662,
										26956, 27912, 28999, 28965, 27826, 25579, 25722, 24826, 24605,
										24304, 23464, 23708, 24099, 24357, 24237, 24401, 24344, 23586,
										22380, 21004, 17287, 14747, 13076, 12555, 12144, 11009, 10950,
										10871, 10824, 10577, 10527, 10475, 10421, 10358, 10295, 10104]
								}, {
									name: 'Disconnected',
									data: [null, null, null, null, null, null, null, null, null, null,
										5, 25, 50, 120, 150, 200, 426, 660, 869, 1060, 1605, 2471, 3322,
										4238, 5221, 6129, 7089, 8339, 9399, 10538, 11643, 13092, 14478,
										15915, 17385, 19055, 21205, 23044, 25393, 27935, 30062, 32049,
										33952, 35804, 37431, 39197, 45000, 43000, 41000, 39000, 37000,
										35000, 33000, 31000, 29000, 27000, 25000, 24000, 23000, 22000,
										21000, 20000, 19000, 18000, 18000, 17000, 16000]
								}]
								//series: [{
								  // data: Ext.data.StoreManager.lookup('Tierhealth_model_id').data.items[0].data.sessions
									//}
								//]
							}
						}
						$('#sessionslogout-graph').highcharts(jsonData); 							
					}
				}
			});
		}
	}
 });

function getAreaItemforSess(areaData){
	//alert("sdf")
	var areaItemfrSess = 
		{
			xtype:'dataview',
			padding:5,
			id:'areaChartSessLog',
			autoDestroy:true,
			store: Ext.data.StoreManager.lookup('Sessionslogout_model_id'),
			tpl: SessionsLogoutTpl,
			listeners:{
				viewready:function(x){
					var jsonData = '';
					if(!Ext.isEmpty(areaData)){
						try
						{
							var lineChart = {};	
							var width = Ext.getCmp('SessionLogoutId').getWidth();
							var height = Ext.getCmp('SessionLogoutId').getHeight();
							lineChart = jQuery.extend(true, {},getHighcharts1('SessionLogoutId',height-150,width-20,''), lineChart);
							lineChart.setData(areaData,'','','','bottom');
							jsonData = lineChart.highchart;
						}
						catch (eer)
						{
							console.log("eer=-=->",eer)
						}
					}
					else
					{
						jsonData = {
							chart: {
								
								type: 'area',
								spacingBottom: 0,
								spacingTop: 0,
								spacingLeft: 0,
								spacingRight: 0,
								width: 530,
								height:220,
								backgroundColor: null
							},
							accessibility:{
								enabled:false	
							},
							exporting:{
								buttons:{
									contextButton:{
										enabled:false
									}
								}	
								
							},
							tooltip: {
								enabled: false
							},

							title: {
								text: '',
								align: 'center',
								verticalAlign: 'middle',
								y: 10
							},  
							xAxis: {
								allowDecimals: false,
								labels: {
									formatter: function () {
										return this.value; // clean, unformatted number for year
									}
								}
							},
							yAxis: {
								title: {
									text: 'Sessions'
								},
								labels: {
									formatter: function () {
										return this.value / 1000 + 'k';
									}
								}
							},
							tooltip: {
								pointFormat: '{series.name} produced <b>{point.y:,.0f}</b><br/>warheads in {point.x}'
							},
							plotOptions: {
								area: {
									pointStart: 1940,
									marker: {
										enabled: false,
										symbol: 'circle',
										radius: 2,
										states: {
											hover: {
												enabled: true
											}
										}
									}
								}
							},
							  series: [{
								name: 'Connected',
								data: [null, null, null, null, null, 6, 11, 32, 110, 235, 369, 640,
									1005, 1436, 2063, 3057, 4618, 6444, 9822, 15468, 20434, 24126,
									27387, 29459, 31056, 31982, 32040, 31233, 29224, 27342, 26662,
									26956, 27912, 28999, 28965, 27826, 25579, 25722, 24826, 24605,
									24304, 23464, 23708, 24099, 24357, 24237, 24401, 24344, 23586,
									22380, 21004, 17287, 14747, 13076, 12555, 12144, 11009, 10950,
									10871, 10824, 10577, 10527, 10475, 10421, 10358, 10295, 10104]
							}, {
								name: 'Disconnected',
								data: [null, null, null, null, null, null, null, null, null, null,
									5, 25, 50, 120, 150, 200, 426, 660, 869, 1060, 1605, 2471, 3322,
									4238, 5221, 6129, 7089, 8339, 9399, 10538, 11643, 13092, 14478,
									15915, 17385, 19055, 21205, 23044, 25393, 27935, 30062, 32049,
									33952, 35804, 37431, 39197, 45000, 43000, 41000, 39000, 37000,
									35000, 33000, 31000, 29000, 27000, 25000, 24000, 23000, 22000,
									21000, 20000, 19000, 18000, 18000, 17000, 16000]
							}]
							//series: [{
							  // data: Ext.data.StoreManager.lookup('Tierhealth_model_id').data.items[0].data.sessions
								//}
							//]
						}
					}
	   
					$('#sessionslogout-graph').highcharts(jsonData); 
						
				},
				}
			}
		return areaItemfrSess;
}
