Ext.define('TierhealthModel', {
    extend: 'Ext.data.Model',
    fields: [
        { name:'state', type:'string' },
        { name:'heading', type:'string' },
        { name:'value', type:'number' },
		{ name:'legend', type:'string' },
		{ name:'sessions' },
		{ name:'DataSet' },
		{ name:'data' },
		{ name:'graphID', type:'string' }
    ]
});

/*Ext.create('Ext.data.Store', {
    id:'Tierhealth_model_id',
    model: 'TierhealthModel',
	autoLoad:true,
    data: [
        {  
			"heading":"Tierwise Health",
			"sessions":[
				{"name":"desktop_session","y":8,"color": "#a1b0e7","text": "Users","value": "11"},	
				{"name":"tab_session","y":4,"color": "#ced4b0","text": "Applications","value": "4"},
				{"name":"moblie_session","y":12,"color": "#e5b58f","text": "Processers/Services","value": "9" },
				{"name":"moblie_session","y":12,"color": "#7d4f6c","text": "OS","value": "9" }
			]
		}
    
    ]
});*/

/*
	json data

	{  
   "stack_highChart":{  
      "heading":"Tierwise Health",
      "DataSet":[  
         {  
            "name":"HIGH",
            "data":[  
               {  
                  "y":100,
                  "color":"#cd0f0f"
               }
            ]
         },
         {  
            "name":"INTERMEDIATE",
            "data":[  
               {  
                  "y":0,
                  "color":"#fa9d1c"
               }
            ]
         },
         {  
            "name":"LOW",
            "data":[  
               {  
                  "y":0,
                  "color":"#ccc100"
               }
            ]
         },
         {  
            "name":"UNKNOWN",
            "data":[  
               {  
                  "y":0,
                  "color":"#30a1d9"
               }
            ]
         },
         {  
            "name":"GOOD",
            "data":[  
               {  
                  "y":0,
                  "color":"#0c9a12"
               }
            ]
         }
      ],
      "chartType":"stackedBar",
      "chartHeight":300,
      "chartWidth":300,
      "yLabel":"Number",
      "xAxisLabel":[  
         "XenApp7.x"
      ],
      "LegendPosition":"bottom",
      "legend":false,
      "inside":true
   },
   "maxCompCount":"2",
   "tierHealthArr":[  
      {  
         "comptype":"Citrix XenApp 7.x",
         "comptypeCompListUrl":"/final/servlet/com.eg.EgMonitorController?monCmd=componentList&from=MainDashboard&action=componentType&searchIndComps=true&componentType=Citrix_XcXenApp_server",
         "leng":[  
            {  
               "len":"100.0%",
               "classname":"bar12_high",
               "stateCount":"2",
               "compListUrl":"/final/servlet/com.eg.EgMonitorController?monCmd=componentList&from=MainDashboard&fromPage=MyDashboard&action=componentTypeState&searchIndComps=true&componentType=Citrix_XcXenApp_server&stateName=HIGH"
            }
         ],
         "totalCompCnt":"2"
      }
   ],
   "errorMsg":"-",
   "title":"Tierwise Health",
   "type":"tierhealth"
}

*/


var itemJson2 = {"heading":"Tierwise Health","DataSet":[{"data":[{"y":60},{"y":40},{"y":20},{"y":80},{"y":0}],"name":"Xenapp"},{"data":[{"y":20},{"y":40},{"y":60},{"y":80},{"y":85}],"name":"License"},{"data":[{"y":40},{"y":20},{"y":60},{"y":80},{"y":0}],"name":"Store Front"}],"NodataFound":false,"chartType":"stackedBar","chartHeight":300,"chartWidth":300,"yLabel":"Number","xAxisLabel":["XenApp","License","Store Front","Database","Network"],"LegendPosition":"bottom","legend":false,"inside":true};
// .stateIconRumAppFlowHealthy, .stateIconRumAppFlowMinor, .stateIconRumAppFlowMajor, .stateRumAppFlowNotOk
var AlertsTpl = new Ext.XTemplate(
	'<div class="widgetholders">',
    '<tpl for=".">',
	'<div class="s_box">',
		 '<div class="font_bold12 div_center trim_text" style="float:left;width:70%"><img style="vertical-align:sub" src="/final/images/clear.png" class="state_{state}" /> <span>{heading}</span></div>',
		 '<div style="float:right;width:30%" class="div_center"><div  class="font_bold18" style="text-align:right">{value}</div><div class="font_normal11 trim_text" style="vertical-align:top;text-align:right;width:100%"> {legend}</div></div>',
		 '<div style="clear:both"></div>',
		 '</div>',
        '<div class="b_box">',
		  '<div class="font_bold12"><img style="vertical-align:sub" src="/final/images/clear.png" class="stateIconRumAppFlow{state}" /> <span>{heading}</ span></div>',
			 '<div  style="text-align:center;width:260px;height:400px;float:left" id="tierhealth-graph"></div>',
			 //'<div style="clear:both"></div>',
			 '</div>',
        '</div>',
    '</tpl>',
	'</div>'
);

Ext.define('citrixDashboard.view.TierwiseHealth', {
     extend: 'Ext.container.Container',
	alias:'widget.tierwisehealth',
	//cls:'widgetcon',
	//ui:'uniqueSessions',
	autoDestroy:true,
	items:[],
	data:'',
	updateData:function(data){
			var me = this;
			//me.items.items[0].store.loadData(data);
			try
			{
				if(!Ext.isEmpty(this.data[0].stack_highChart))
					dataObj = this.data[0].stack_highChart
				else
					dataObj = this.data.stack_highChart
				
			}
			catch (ert)
			{
				dataObj = this.data.stack_highChart
			}
			var jsonData = getTierWiseHealthChartJSON(dataObj,me.id);
			$('#tierhealth-graph').highcharts(jsonData); 
	},
	listeners:{
		'afterrender':function(e){

			tierWiseTpl = new Ext.XTemplate(
				'<div class="widgetholders" style="border:0px solid red;margin-top:0px">',
				'<tpl for=".">',
					'<div class="b_box">',
					  '<div ><span class="font_normal13 fontStyleRobot">{heading}</ span></div>',
						 //'<div  style="text-align:center;width:305px;height:235px;float:left" id="tierhealth-graph"></div>',
						 //'<div  style="border:1px solid red;text-align:center;width:100%;height:235px;float:left" id="tierhealth-graph"></div>',
						 '<div  style="border:0px solid red;text-align:center;width:100%;height:100%" id="tierhealth-graph"></div>',
						 //'<div style="clear:both"></div>',
						 '</div>',
					'</div>',
				'</tpl>',
				'</div>'
			);
			var dataObj = '';
			try
			{
				if(!Ext.isEmpty(this.data[0].stack_highChart))
					dataObj = this.data[0].stack_highChart
				else
					dataObj = this.data.stack_highChart
				
			}
			catch (ert)
			{
				//console.log("ert=-=-=->",ert)
				dataObj = this.data.stack_highChart
			}
			

			//var tier_item = getTierWiseItem(this.data[0].stack_highChart,this.id);
			var tier_item = getTierWiseItem(dataObj,this.id);
			this.add(tier_item);
		}
	 }
 });

function getTierWiseItem(data,iid){
	var item = 
		{
			xtype:'dataview',
			padding:0,
			//store: Ext.data.StoreManager.lookup('Tierhealth_model_id'),
			store: Ext.create('Ext.data.Store', {
				//id:'Tierhealth_model_id',
				model: 'TierhealthModel',
				autoLoad:true,
				data:data
			}),
			tpl: tierWiseTpl,
			listeners:{
				//'resize':function(x){
				viewready:function(x){
					var jsonData = '';
					if(!Ext.isEmpty(data)){
					//if(false){
						try
						{
							/*var barChart = {};
							data['showLegend'] = false;
							data['xaxisShow'] = false;
							data['yaxisShow'] = false;
							data['MaxValue'] = 100;
							barChart = jQuery.extend(true, {}, getHighChartsBarInstance1(iid,null,null), barChart);
							barChart.setData(data, "", "",'stackedBar');*/
							jsonData = getTierWiseHealthChartJSON(data,iid);
						}
						catch (barChartEx)
						{
							console.log("asjdknasdkjn=-=-=->",barChartEx);
						}
					}
					else
						{
						var jsonData = {
							chart: {
								type: 'bar'
							},
							title: {
								text: 'Stacked bar chart'
							},
							xAxis: {
								categories: ['Apples', 'Oranges', 'Pears', 'Grapes', 'Bananas']
							},
							yAxis: {
								min: 0,
								title: {
									text: 'Total fruit consumption'
								}
							},
							legend: {
								reversed: true
							},
							plotOptions: {
								series: {
									stacking: 'normal'
								}
							},
							series: [{
								name: 'John',
								data: [5, 3, 4, 7, 2]
							}, {
								name: 'Jane',
								data: [2, 2, 3, 2, 1]
							}, {
								name: 'Joe',
								data: [3, 4, 4, 2, 5]
							}]
						}	

					}
				$('#tierhealth-graph').highcharts(jsonData); 
					
				}
			}
		}
		return item;
}

function getTierWiseHealthChartJSON(data,idi){
	try
	{
		var barChart = {};
		data['showLegend'] = false;
		data['xaxisShow'] = false;
		data['yaxisShow'] = false;
		data['MaxValue'] = 100;
		barChart = jQuery.extend(true, {}, getHighChartsBarInstance1(idi,null,null), barChart);
		barChart.setData(data, "", "",'stackedBar');
		jsonData = barChart.highchart;
	}
	catch (barChartEx)
	{
		console.log("asjdknasdkjn=-=-=->",barChartEx);
	}
	return jsonData;
}
