Ext.define('citrixDashboard.view.TransactionGridPanel', {
	extend : 'utilities.CustomGrid',
	requires:['citrixDashboard.store.TransactionsStore'],
	alias : 'widget.transactiongridpanel',
	forceFit:false,
	layout:'fit',
	jsonData:null,
	ui:'newGridPanel',
	border:true,
	frame:false,
	margin:'0 0 0 0',
	height:250,
	itemId : 'transactiongridpanel',
	id:'transactiongridpanel',
	listeners:{
		'render':function(panel){
			var width = Ext.getBody().getViewSize().width - 160;
			var height = (Ext.getBody().getViewSize().height - 150)/2;
			Ext.EventManager.onWindowResize(function () {
				panel.doLayout();
			});
		},
		'afterrender':function(panel){

			var faultyServer = this.jsonData.GridScreenLabels["faultyServer"];
			var regexObj = RegExp('NULL','i');
			var flag = regexObj.test(String(faultyServer));
			if(flag)
				faultyServer = faultyServer.substring(0,faultyServer.indexOf(':')) + ')';

			var lastTimeStr = "";
			if(!Ext.isEmpty(this.jsonData.GridScreenLabels["lastMeasurementTime"]))
				lastTimeStr = '<div style="margin:2px 0px"><span id="lastMeasurementTime" class="font_normal11"> '+this.jsonData.GridScreenLabels["lastMeasurementTime_Text"]+': '+this.jsonData.GridScreenLabels["lastMeasurementTime"]+'</div>';
			else
				lastTimeStr = '<div style="font-size:12px;margin:2px 20px"><span id="faultyServer">'+faultyServer+'</span></div>';

			var lastMTimeIdObj=Ext.getCmp("lastMTimeId");
			if(lastMTimeIdObj!=null && lastMTimeIdObj!=undefined && lastTimeStr!=null && lastTimeStr!=undefined)
			{
				lastMTimeIdObj.update(lastTimeStr);
			}
		}
	},
	tools:[
		{
			xtype:'container',
			id:'lastMTimeId',
			itemid:'lastMTimeId',
			html:'',
		},
		{xtype:'tbseparator',cls:'uxSeparator',height:20,style:{'top':'0px !important'}},
		{
			xtype:'button',
			iconCls: 'iconAdd',
			margin:'3 0 0 3',
			id:'iconAddId',
			itemid:'iconAddId',
			//hidden:hideConfigIcon,
			style:{
				background:'none',border:'0px'
				},
			//cls : 'component-list-right-panel-header-button',
			//text : jsonData.GridScreenLabels["configureTransBtnLabel"],
			action:'transactionsGridConfigureBtn',
			listeners:{
				afterrender:function(){
					if(this.up('grid').isEmuEnabled!=null && this.up('grid').isEmuEnabled!=undefined)
					{
						this.hidden = this.up('grid').isEmuEnabled;
					}
				}
			}
		},
	],
	collapsed:false,
	collapsible: true,
	hideCollapseTool:true,
    viewConfig: {
        getRowClass: function(record, index, rowParams, store) {
			if(!Ext.isEmpty(record.get('Message'))){
				return "msg-row";
			}
				return '';
        },
		emptyText:'<center><div style="text-align:center;margin-top:40px"><div class="iconInformation" style="margin:0px auto"></div><div>No data found</div></div></center>',
		deferEmptyText: false 
    },
    
	initComponent : function() {
		this.store=Ext.create('citrixDashboard.store.TransactionsStore');
    	var jsonData=this.jsonData;
		var storeFields=['Message','transImage','transactionStateClass','transactionStateTitle'];
		var columns=new Array();
		if(jsonData != null && jsonData != undefined && !Ext.isEmpty(jsonData.GridScreenLabels.TransactionHeaders))
		{
			for(var j=0;j<jsonData.GridScreenLabels.TransactionHeaders.length;j++){
				var recMeasureCol=jsonData.GridScreenLabels.TransactionHeaders[j];
				var measureCol=new Object();
				if(j==0){
					measureCol.text='<span style="text-transform:uppercase;font-size:11px">'+recMeasureCol.Header+'</span>';
				}else{
					measureCol.text='<span style="text-transform:uppercase;font-size:11px;line-height:8px">'+recMeasureCol.Header+'</span>&nbsp;<span style="font-size:11px;line-height:8px">('+recMeasureCol.UnitForHeader+')</span';
				}
				if(j==0){
					measureCol.sortType='asString';
					measureCol.dataIndex='transactionName';			// Small Image Display
					measureCol.sortable=false;
					measureCol.width=250;
					measureCol.renderer=function(value,metaData,record,rowIndex,colIndex){
						var htmlStr= '<a href="javascript:loadView(\'Services_Topology_View\');" style="position:relative;display:block"><img style="vertical-align:middle;margin-top:-2px;padding-right:19px;"  class=" '+record.get("transactionStateClass")+'" src="/final/images/clear.png" title="'+record.get("transactionStateTitle")+'"/> <span>'+value+'</span><img style="vertical-align:middle;position:absolute;right:0px;top:-2px"   class="trans_'+record.raw.transImageTitle+'_small" src="/final/images/clear.png" /></a>';
						return htmlStr;						
					};
				}else if(j==2 || j==3){
					measureCol.dataIndex=(j-1)+'MeasureValue';
					measureCol.sortType=(j-1)+'asFloat';
					if(jsonData.GridScreenLabels.TransactionHeaders.length == 3 )
						measureCol.flex=.6;
					else
						measureCol.width=200;
					storeFields.push((j-1)+'MeasureValueImg');
					storeFields.push((j-1)+'MeasureValueImgTitle');
					
					measureCol.renderer=function(value,metaData,record,rowIndex,colIndex){
						var imgStr;

						if(!Ext.isEmpty(record.get((colIndex-1)+'MeasureValueImg'))){
							
							imgStr = '<a href="javascript:loadView(\'Services_Topology_View\');"; return false;><img style="vertical-align:middle;padding-right:22px;margin-top:-3px" class="'+record.get((colIndex-1)+'MeasureValueImg')+'"  src="/final/images/clear.png"/>'+value +'</a>';
							return imgStr;
						}
						else
						{
							imgStr = '<div style="text-align:left">&nbsp; - </div>';
							return imgStr;
						}
					}
				}else{
					measureCol.sortType=(j-1)+'asFloat';
					measureCol.dataIndex=(j-1)+'MeasureValue';
					measureCol.flex=.6;
					storeFields.push((j-1)+'MeasureValueImg');
					storeFields.push((j-1)+'MeasureValueImgTitle');
					
					measureCol.renderer=function(value,metaData,record,rowIndex,colIndex){
						var imgStr;

						if(!Ext.isEmpty(record.get((colIndex-1)+'MeasureValueImg'))){
							
							//imgStr = '<a href="javascript:void(0)"; return false;><img style="vertical-align:middle;padding-right:22px;" class="'+record.get((colIndex-1)+'MeasureValueImg')+'"  src="/final/images/clear.png"/>'+value +'</a>';
							imgStr = '<a href="javascript:loadView(\'Services_Topology_View\');"; return false;><img style="vertical-align:middle;padding-right:22px;margin-top:-3px" class="'+record.get((colIndex-1)+'MeasureValueImg')+'"  src="/final/images/clear.png"/>'+value +'</a>';
							return imgStr;
						}
						else
						{
							imgStr = '<div style="text-align:left">&nbsp; - </div>';
							return imgStr;
						}
					}
				}
				if(j==1){
					measureCol.renderer=function(value,metaData,record,rowIndex,colIndex){
						var msg=record.get('Message');
						if(!Ext.isEmpty(msg)){
							//metaData.style="display:inline;text-align:center;position:relative;left:200%;white-space: nowrap !important;";
							msg = '<div style="text-align:left">&nbsp; - </div>';
							//return msg;
							return '-';
						}else{
							if(!Ext.isEmpty(record.get((colIndex-1)+'MeasureValueImg'))){
								//imgStr = '<a href="javascript:void(0)"; return false;><img style="vertical-align:middle;padding-right:22px;" class="'+record.get((colIndex-1)+'MeasureValueImg')+'"  src="/final/images/clear.png"/>'+value +'</a>';
								imgStr = '<a href="javascript:loadView(\'Services_Topology_View\');"; return false;><img style="vertical-align:middle;padding-right:22px;margin-top:-3px" class="'+record.get((colIndex-1)+'MeasureValueImg')+'"  src="/final/images/clear.png"/>'+value +'</a>';
								return imgStr;
							}
							else
							{
								imgStr = '<div style="text-align:left">&nbsp; - </div>';
								return imgStr;
							}
						}
					};
				}
				storeFields.push(measureCol.dataIndex);
				columns.push(measureCol);
			}
		}
		var gridStore=Ext.create('Ext.data.Store',{
			fields:storeFields,
		    proxy: {
		        type: 'memory',
		        reader: {
		            type: 'json',
		            root:'TransactionsIfo'
		        }
		    },
		    data:jsonData
		});
		
		var toolbarArray=new Array();

		
		if(!Ext.isEmpty(jsonData.GridScreenLabels["lastMeasurementTime_Text"])){
			toolbarArray.push({
				xtype:'label',
				text:jsonData.GridScreenLabels["lastMeasurementTime_Text"]+" : "
			});
		}
		
		if(!Ext.isEmpty(jsonData.GridScreenLabels["lastMeasurementTime"])){
			toolbarArray.push({
				xtype:'label',
				text:jsonData.GridScreenLabels["lastMeasurementTime"]
			});
		}

		/*--- Kaliraj ---*/

		var faultyServer = jsonData.GridScreenLabels["faultyServer"];
		var regexObj = RegExp('NULL','i');
		var flag = regexObj.test(String(faultyServer));
		if(flag)
			faultyServer = faultyServer.substring(0,faultyServer.indexOf(':')) + ')';

		/*--------*/

		if(!Ext.isEmpty(jsonData.GridScreenLabels["faultyServer"])){
			toolbarArray.push({
				xtype:'label',
				text:faultyServer         // Kaliraj
			});
		}
		
		if(!Ext.isEmpty(jsonData.GridScreenLabels["configureTransBtnLabel"])){
			toolbarArray.push("->");
			toolbarArray.push({
				xtype:'button',
				cls: 'button20',
				//cls : 'component-list-right-panel-header-button',
				text : jsonData.GridScreenLabels["configureTransBtnLabel"],
				action:'transactionsGridConfigureBtn'
			});
		}		
		
		this.store=gridStore;
		this.columns=columns;
		this.callParent();
	}
});