Ext.define('comparisonDashboard.view.TreePanel', {
	extend: 'Ext.panel.Panel',
	requires : ['utilities.ErUtils','utilities.OuterPanel','comparisonDashboard.view.Paging'],
	alias:'widget.treepanel',
	layout : {
		align : 'stretch',
		type : 'vbox'
	},
	flex:1,
	margin:'8 0 0 0',
	bodyCls:'top-left-radius bottom-left-radius',
	autoDestroy:true,
	url : null,
	id:'treepanel',
	nodeId:null,
	items:[],
	initComponent : function(){
		var me = this;

		Ext.Ajax.request({
			url : me.url,
			method : 'POST',
			success : function(response, opts){
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				jsonData["expanded"] = true;
				//jsonData["cls"] = "list-tree-root-expand-collapse";
				jsonData["iconCls"] ="";
				var treePanelStore = Ext.create('Ext.data.TreeStore', {
					id:'treestore',
					root : jsonData
				});

				var treeTitle='<a href="'+jsonData.link+'">'+jsonData.text+'</a>';

				if(!Ext.isEmpty(jsonData.iconCls)){
					//treeTitle='<div class="'+jsonData.iconCls+'"><span style="padding-left:20px">'+treeTitle+'</span></div>';
					treeTitle='<div ><span style="padding-left:20px">'+treeTitle+'</span></div>';
				}

				var treePanel = Ext.create('utilities.TreeScrollPanel',{
					store : treePanelStore,
					cls:'treePanelDesign',
					margin:'0 0 0 8',
					animate:true,
					//iconCls:'service20_GRAY',
					layout : {
							align : 'stretch',
							type : 'vbox'
					},
					scroll: true,
					containerScroll: false,
					autoScroll: false,
					//overflowY: 'scroll',
					border : true,
					frame:true,
					flex:1,
					//maxWidth:150,
					//minWidth : 150,
					//width:150,
					title: 'Comparison Dashboard',
					//style:{'border':'0px solid red'},
	//				selModel: Ext.create("Ext.selection.RowModel", { mode : 'SINGLE'}),
					selModel: Ext.create("Ext.selection.TreeModel", { mode : 'MULTI'}),
					//title : treeTitle,
					useArrows: true,
					rootVisible : false,
					iconCls: '',
					//collapsible: false,
					stateId:'services-tree-panel-stateId',
					id:'select',
				});

				//me.items.add(treePanel);
				me.add(treePanel);
				me.doLayout();
			},
			failure : function(response, opts){
				//alert("Failure");
			}
		});

		this.callParent();
	}
});
