Ext.define('componentDashboard.controller.ApplicationController', {
    extend: 'Ext.app.Controller',
	//reqiures:['componentDashboard.view.Application.fullViewPanel'],
	requires : ['utilities.ScrollTabPanel','componentDashboard.view.Application.SubApplicationPanel','componentDashboard.view.Application.ThreadDetails', 'componentDashboard.view.Application.SubApplicationTabPanel','componentDashboard.view.Application.ApplicationTimeLinePanel', 'utilities.Multiselector','componentDashboard.view.Application.fullViewPanel','utilities.CustomGrid'],
    refs:[
    		{ref:'subapplicationpanel', selector:'subapplicationpanel'},
    		{ref:'applicationpanel', selector:'applicationpanel'},
    		{ref:'subapplicationtabpanel', selector:'subapplicationtabpanel'},
    		{ref:'applicationtimeline', selector:'applicationtimeline'},
			{ref:'stackThreadDetails', selector:'stackThreadDetails'},
			{ref:'fullviewpanel', selector:'fullviewpanel'}
    	],
    init: function()
	{
    	applicationController= this;
		this.control({
			'subapplicationpanel combo[id="appSubsystem"]':
		   {
				'select': this.selectSubSystem
		   },
		   'applicationpanel':
		   {
		   		'beforeshow': this.beforeShowApplicationPanel
		   },
			'stackThreadDetails':{
						'boxready':this.loadform
			},
			'stackThreadDetails combo[id="timeid"]':{
					'select':this.timeOnChange
			},
			'stackThreadDetails combo[id="measureid"]':{
					'select':this.measureOnChange
			},
			'stackThreadDetails combo[id="sortByOrderid"]':{
				'select':this.sortOnChange
			},
			/*
				'stackThreadDetails #threadnameSelect':{
				'itemclick':this.sortOnThread
			},
			*/
			'stackThreadDetails #threadnameid':{
				'change':this.loadFormForThreadName
			},
			'fullviewpanel':
			{
				'boxready': this.loadFullViewPanel
			}
	   });
    },
	showThreadDetails : function(val,timeVal)
	{
			var win = Ext.create('Ext.window.Window', {
			title: threadAnalysisLbl,
			height: 500,
			width: '80%',
			padding:'3 10 10 10',
			shadow:true,
			autoheight: true,
			autowidth: true,
			id:'windowVal',
			URLValue:val,
			selectedDate:timeVal,
			scroll:false,
			autoScroll:false,
			modal: true,
			URLVal:val,
			//ghost: false,
			closeAction:'destroy',
			//iconCls:'iconClose',
			closable:true,
			layout:{
				type:'fit',
				//align:'stretch',
				pack: 'center'
			},
			items: {
					xtype:'stackThreadDetails'

			}
		}).show();
	},
	loadform: function(obj)
	{
		var urlVal = Ext.getCmp('windowVal').URLVal;
		urlVal = urlVal.split("|");
		var url = urlVal[0];
		var selectedDate = urlVal[1];
		var me= this;
		if(!Ext.isEmpty(obj))
		{
			var elementId = obj.id;
			var meas =null;
			var sortValue = null;
			if(!Ext.isEmpty(elementId))
			{
				if(elementId=="timeid")
				{
					if(!Ext.isEmpty(obj.value))
					{
						url = url+"&time="+obj.value;
						meas = Ext.getCmp("measureid").value;
						url = url.replace(/(s_measure=)[^\&]+/, '$1' + meas);
					}
				}
				else if(elementId=="measureid")
				{
					if(!Ext.isEmpty(obj.value))
					{
						var timeTemp = Ext.getCmp("timeid").value;
						url = url+"&time="+timeTemp;
						meas = obj.value;
						url = url.replace(/(s_measure=)[^\&]+/, '$1' + meas);
					}
				}
				else if(elementId=="sortByOrderid")
				{
					var sortValue = obj.value;
					url = url + "&sortby="+sortValue;
					var timeTemp = Ext.getCmp("timeid").value;
					url = url+"&time="+timeTemp;
					meas = Ext.getCmp("measureid").value;
					url = url.replace(/(s_measure=)[^\&]+/, '$1' + meas);
				}
				else if(elementId=="threadnameSelectid")
				{
					//var selectedThreadName = this.getThreadName().getValue();
					var selectedThreadName = Ext.getCmp('threadnameid').getValue();
					var timeTemp = Ext.getCmp("timeid").value;
					url = url+"&time="+timeTemp;
					 meas = Ext.getCmp("measureid").value;
					url = url.replace(/(s_measure=)[^\&]+/, '$1' + meas);
					url = url+"&selectedThreadName="+encodeURIComponent(selectedThreadName);
				}
				if(!Ext.isEmpty(meas) && !Ext.isEmpty(elementId) && elementId!="sortByOrderid")
				{
					if(meas == 'Total_current_threads')
						sortValue ="1";
					else if(meas == 'Blocked_threads')
						sortValue ="8";
					else if(meas == 'Deadlock_threads')
						sortValue ="8";
					else if(meas == 'Waiting_threads')
						sortValue ="11";
					else if(meas == 'Timed_waiting_threads')
						sortValue ="11";
					else
						sortValue ="5";
					url = url+"&sortby="+sortValue;
				}
			}
		}
		var selectedDateTime = Ext.getCmp('windowVal').selectedDate;
		if(!Ext.isEmpty(selectedDateTime))
		{
			url = url+"&time="+selectedDateTime;
		}
		Ext.Ajax.request({
			url : url,
			success : function(response) {
				var formdata = Ext.decode(response.responseText);

				var subformdata =null;
				if(!Ext.isEmpty(formdata))
				{
					for(var i = 0;i<formdata.data.length;i++)
					{
						var name=formdata.data[i].name;
						if(!Ext.isEmpty(name))
						{
							if(name=="memtime")
							{	//var selectedvalue = Ext.getCmp("time").value;
								var selectedvalue = formdata.data[i].selectedvalue;
								if(selectedvalue==null)
									selectedvalue ='';
								subformdata = formdata.data[i].time;
								me.setComboOptionsInList('timeid', subformdata,selectedvalue);
							}
							else if(name=="Measurement")
							{
								var selectedvalue = formdata.data[i].selectedvalue;
								if(selectedvalue==null)
									selectedvalue ='';
								subformdata = formdata.data[i].measure;
								me.setComboOptionsInList('measureid', subformdata,selectedvalue);
							}
							else if(name=="memsortname")
							{
								//var selectedvalue = Ext.getCmp("sortByOrder").value;
								var selectedvalue = formdata.data[i].selectedValue;
								if(selectedvalue==null)
									selectedvalue ='';
								subformdata = formdata.data[i].sortByOrder;
								me.setComboOptionsInList('sortByOrderid', subformdata,selectedvalue);
							}
							else
							{
								var selectedvalue = formdata.data[i].selectedValue;
								subformdata = formdata.data[i].threadname;
								me.setComboOptionsInList('threadnameid', subformdata,selectedvalue);
								var threadCombo = Ext.getCmp("threadnameid");
								var tempSelectedValue = [];
								tempSelectedValue.push(selectedvalue);
								threadCombo.setValue(tempSelectedValue);
							}
						}
					}
					//this.loadData();
					var resultPanel = Ext.getCmp("threadResulPanelid");
					var measureTime = Ext.getCmp('timeid').value;
					var selectedvalue = Ext.getCmp('threadnameid').value;
					params="time="+measureTime+"&details="+encodeURIComponent(selectedvalue);
					Ext.Ajax.request({
						url : '/final/monitor/jvmThreads.jsp?'+params,
						success : function(response) {
							var resultData = Ext.decode(response.responseText);
							resultPanel.update(resultData.tableData);
						}
					});
				}
			},
			failure: function()
			{
				alert("failure");
			}
		});
	},
	loadFormForThreadName:function(obj)
	{
		var resultPanel = Ext.getCmp("threadResulPanelid");
		var measureTime = Ext.getCmp('timeid').value;
		var selectedvalue = Ext.getCmp('threadnameid').value;
		params="time="+measureTime+"&details="+encodeURIComponent(selectedvalue);
		Ext.Ajax.request({
			url : '/final/monitor/jvmThreads.jsp?'+params,
			success : function(response) {
				var resultData = Ext.decode(response.responseText);
				//resultPanel.update(resultData);
				resultPanel.update(resultData.tableData);
			}
		});
	},
	timeOnChange:function(obj)
	{
		this.loadform(obj);
	},
	measureOnChange:function(obj)
	{
		this.loadform(obj);
	},
	sortOnChange:function(obj)
	{
		this.loadform(obj);
	},
	sortOnThread:function(obj)
	{
		this.loadform(obj);
	},
    callView: function( graphType )
    {
    	var isFlag = 'default';
    	var getPanelObj = Ext.getCmp(Ext.getCmp('tabpanel').getActiveTab().getId());
    	getPanelObj.getEl().mask(loadingLbl+'...', 'maskCenter');
    	var me = this;
    	var tmpTimeline = (Ext.getCmp('er_timeline')!=undefined)?Ext.getCmp('er_timeline').getValue():timelineVals['timeline'];
    //	var startDt = Ext.Date.format((Ext.getCmp('er_stdate') != undefined)?Ext.getCmp('er_stdate').getValue():timelineVals['starttime'], mgrDateFormat);
    	//var endDt = Ext.Date.format((Ext.getCmp('er_enddate') != undefined )?Ext.getCmp('er_enddate').getValue():timelineVals['endtime'], mgrDateFormat);
		var startDt="";
		var endDt="";
		if((Ext.getCmp('er_stdate') != undefined))
		{
			var data=Ext.getCmp('er_stdate').getValue();
			//startDt = Ext.Date.dateFormat(data, mgrDateFormat);
			startDt = formatDate(Ext.getCmp('er_stdate').getValue(), mgrDisplayDateFormat);
		}
		else
		{
			startDt = timelineVals['starttime'];
		}
		if((Ext.getCmp('er_enddate') != undefined))
		{
			var data=Ext.getCmp('er_enddate').getValue();
			//endDt = Ext.Date.dateFormat(data, mgrDateFormat);
			endDt = formatDate(Ext.getCmp('er_enddate').getValue(), mgrDisplayDateFormat);
		}
		else
		{
			endDt = timelineVals['endtime'];
		}
		//Ext.get('configModApp').hide();
    	var starthr = (Ext.getCmp('er_sthr') != undefined )?Ext.getCmp('er_sthr').getValue():timelineVals['starthour'];
    	var endhr = (Ext.getCmp('er_endhr') != undefined )?Ext.getCmp('er_endhr').getValue():timelineVals['endhour'];
		var genParams = '';
		if (graphType == 'summaryGraph' || graphType == 'trendGraph' )
		{			
			genParams = 'tab=Application&hostName='+encodeURIComponent(componentName)+'&compType='+encodeURIComponent(componentType)+'&subsystem='+encodeURIComponent(Ext.getCmp('appSubsystem').getValue())+'&graphType='+encodeURIComponent(graphType)+'&showGraph='+encodeURIComponent(graphType)+'&time_line=24 hours&starttime='+encodeURIComponent(startDt)+'&endtime='+encodeURIComponent(endDt)+'&starthr='+encodeURIComponent(starthr)+'&endhr='+encodeURIComponent(endhr)+'&format='+encodeURIComponent(dateFormatForTimeline)+'&host='+encodeURIComponent(componentName);
		}
		else
		{
			genParams = 'tab=Application&hostName='+encodeURIComponent(componentName)+'&compType='+encodeURIComponent(componentType)+'&subsystem='+encodeURIComponent(Ext.getCmp('appSubsystem').getValue())+'&graphType='+encodeURIComponent(graphType)+'&showGraph='+encodeURIComponent(graphType)+'&time_line=1 hour&starttime='+encodeURIComponent(startDt)+'&endtime='+encodeURIComponent(endDt)+'&starthr='+encodeURIComponent(starthr)+'&endhr='+encodeURIComponent(endhr)+'&format='+encodeURIComponent(dateFormatForTimeline)+'&host='+encodeURIComponent(componentName);
		}
    
		appLastLoadedURL = '/final/monitor/egAppDashboardJSON.jsp?'+genParams;
    	me.loadInnerTab(Ext.getCmp('tabpanel').getActiveTab().getId(), '/final/monitor/egDashboardHistoryJSON.jsp?'+genParams,isFlag);
	   	appLastGraphTypeLoaded = graphType;
    },
    callMe: function()
    {
    	alert('Hi...'+Ext.get('configModApp'));
    },
    selectSubSystem: function( obj )
    {
    	var getVal = obj.getValue();
    	appLastLoadedURL = '';		// To reset the URLs and Tabs
    	appCurrentTabId = '';
		appLastGraphTypeLoaded = '';
    	if ( getVal != undefined )
    	{
    		if ( getVal.toLowerCase() == 'overview' )
    		{
    			Ext.getCmp('overviewpanel').show();
    		}
    		else
    		{
    			Ext.getCmp('overviewpanel').hide();
    		}
    		var appSubsystem = Ext.getCmp('appSubsystem').getValue();
    		if ( Ext.isEmpty( appSubsystem ) || appSubsystem.length == 0 )
			{
				appSubsystem = 'Overview';
			}
			Ext.getCmp('applicationdetails').fireEvent('beforeshow', Ext.getCmp('applicationdetails'));
    	}
    },
    prepareQueryString: function( lastSession )
    {
    	var hashMap = new Ext.util.HashMap();
    	if ( lastSession != undefined )
    	{
    		var splitStr = lastSession.split('&');
    		for ( var i = 0; i < splitStr.length; i++ )
    		{
    			var param = splitStr[i].substring(0, splitStr[i].indexOf('='));
    			var value = splitStr[i].substring( splitStr[i].indexOf('=') + 1);
    			hashMap.add(param, decodeURIComponent(value));
    		}
    	}
    	return hashMap;
    },
	applicationDefaultLoad: function( jsonData )
	{
		if(Ext.getCmp('subapplicationpanelId')==null || Ext.getCmp('subapplicationpanelId')==undefined)
		{
			this.getApplicationpanel().add(
			{
				xtype:'subapplicationpanel',
				id:'subapplicationpanelId',
				border:false,
			},
			{
				xtype:'subapplicationtabpanel',
				id:'subapplicationtabpanelId',
				border:false,
				flex:1,
				frame:false
			});
		}

		var fullviewIdObj = Ext.getCmp('fullviewId');
		if(fullviewIdObj!=null)
		{
			fullviewIdObj.destroy();
			Ext.getCmp('subapplicationpanelId').show();
			Ext.getCmp('subapplicationtabpanelId').show();
		}
		var isFlag = 'default';
		var me = this;
		var hashMap = this.prepareQueryString(monitorLastSession);
		Ext.getCmp('applicationdetails').suspendEvents(true);
		var objectArr = new Array();
		var serverType = subject;		
		if ( jsonData != '' && jsonData != null && !Ext.isEmpty(jsonData))
		{
			var appSubsystem = jsonData['SUBSYSTEM'];					
			var screenLabels = jsonData['screenLabels'];
			objectArr['appSubsystem'] = screenLabels['subsystemTitle'];
			me.loadScreenLabels(objectArr);
			var subsystemCombo = jsonData['subsystemCombo'];
			var selectedValues = jsonData['selectedValues'];

			me.setValueWithOptionInList('appSubsystem', subsystemCombo, appSubsystem);
			if ( appSubsystem != undefined )
			{
				if ( serverType == 'Citrix_server' || serverType == 'Citrix_XcXenApp_server')
				{
					if ( appSubsystem.toLowerCase() == 'overview' )
					{
						Ext.getCmp('overviewpanel').show();
						var overviewData = jsonData['OVERVIEW'];
						me.showOverview(overviewData);
						var selectedGraphType = jsonData['selectedGraphType'];

						if(selectedGraphType!=null && selectedGraphType!="" && selectedGraphType.toLowerCase()!="null")
						{
							if(selectedGraphType=="Application_summaryGraph" || selectedGraphType=="Application_trendGraph")
							{
								appCurrentTabId = "Application_measureGraph";
							}
							else
							{
								appCurrentTabId = selectedGraphType;
							}
						}
						else
						{
							selectedGraphType = Ext.getCmp('tabpanel').getActiveTab().getId();
						}
						var getTabURL = jsonData['TAB_URL'];
						me.showTabs(getTabURL);
						var getInnerTabURL = jsonData['INNER_TAB_URL'];
						getInnerTabURL = encodeURI(getInnerTabURL);
						if ( !Ext.isEmpty( appCurrentTabId ) )
						{
							me.loadInnerTab(appCurrentTabId, getInnerTabURL,isFlag);
						}
						else
						{
							me.loadInnerTab(selectedGraphType, getInnerTabURL,isFlag);
						}

						var getTabName = Ext.getCmp(Ext.getCmp('tabpanel').getActiveTab().getId()).tabName;
						if ( getTabName.toLowerCase() == 'history' && isDisableTrendComputation == false)
						{
							me.showTools();
						}
						else
						{
							me.hideTools();
						}
					}
					else if ( appSubsystem.toLowerCase() == 'citrixserver' || appSubsystem.toLowerCase() == 'citrixsessions' || appSubsystem.toLowerCase() == 'citrixapplications' || appSubsystem.toLowerCase() == 'citrixusers' || appSubsystem.toLowerCase() == 'terminalservices' )
					{

						var getTabURL = jsonData['TAB_URL'];
						var selectedGraphType = jsonData['selectedGraphType'];
						if(selectedGraphType!=null && selectedGraphType!="" && selectedGraphType.toLowerCase()!="null")
						{
							if(selectedGraphType=="Application_summaryGraph" || selectedGraphType=="Application_trendGraph")
							{
								appCurrentTabId = "Application_measureGraph";
							}
							else
							{
								appCurrentTabId = selectedGraphType;
							}
						}
						else
						{
							selectedGraphType = Ext.getCmp('tabpanel').getActiveTab().getId();
						}
						me.showTabs(getTabURL);
						var getInnerTabURL = jsonData['INNER_TAB_URL'];
						getInnerTabURL = encodeURI(getInnerTabURL);
						if ( !Ext.isEmpty( appCurrentTabId ) )
						{
							me.loadInnerTab(appCurrentTabId, getInnerTabURL,isFlag);
						}
						else
						{
							me.loadInnerTab(selectedGraphType, getInnerTabURL,isFlag);
						}

						var getTabName = Ext.getCmp(Ext.getCmp('tabpanel').getActiveTab().getId()).tabName;
						if ( getTabName.toLowerCase() == 'history' && isDisableTrendComputation == false)
						{
							me.showTools();
						}
						else
						{
							me.hideTools();
						}
					}
				}
				else if ( serverType == 'Oracle_server' )
				{
					if ( appSubsystem.toLowerCase() == 'overview' )
					{
						Ext.getCmp('overviewpanel').show();
						var overviewData = jsonData['OVERVIEW'];
						me.showOverview(overviewData);
						var selectedGraphType = jsonData['selectedGraphType'];

						if(selectedGraphType!=null && selectedGraphType!="" && selectedGraphType.toLowerCase()!="null")
						{
							if(selectedGraphType=="Application_summaryGraph" || selectedGraphType=="Application_trendGraph")
							{
								appCurrentTabId = "Application_measureGraph";
							}
							else
							{
								appCurrentTabId = selectedGraphType;
							}
						}
						else
						{
							selectedGraphType = Ext.getCmp('tabpanel').getActiveTab().getId();
						}
						var getTabURL = jsonData['TAB_URL'];
						me.showTabs(getTabURL);
						var getInnerTabURL = jsonData['INNER_TAB_URL'];
						getInnerTabURL = encodeURI(getInnerTabURL);
						if ( !Ext.isEmpty( appCurrentTabId ) )
						{
							me.loadInnerTab(appCurrentTabId, getInnerTabURL,isFlag);
						}
						else
						{
							me.loadInnerTab(selectedGraphType, getInnerTabURL,isFlag);
						}

						var getTabName = Ext.getCmp(Ext.getCmp('tabpanel').getActiveTab().getId()).tabName;
						if ( getTabName.toLowerCase() == 'history' && isDisableTrendComputation == false)
						{
							me.showTools();
						}
						else
						{
							me.hideTools();
						}
					}
					else if ( appSubsystem.toLowerCase() == 'memory structures' || appSubsystem.toLowerCase() == 'tablespaces' || appSubsystem.toLowerCase() == 'datafiles' || appSubsystem.toLowerCase() == 'database access' )
					{
						var getTabURL = jsonData['TAB_URL'];
						var selectedGraphType = jsonData['selectedGraphType'];
						if(selectedGraphType!=null && selectedGraphType!="" && selectedGraphType.toLowerCase()!="null")
						{
							if(selectedGraphType=="Application_summaryGraph" || selectedGraphType=="Application_trendGraph")
							{
								appCurrentTabId = "Application_measureGraph";
							}
							else
							{
								appCurrentTabId = selectedGraphType;
							}
						}
						else
						{
							selectedGraphType = Ext.getCmp('tabpanel').getActiveTab().getId();
						}
						me.showTabs(getTabURL);
						var getInnerTabURL = jsonData['INNER_TAB_URL'];
						getInnerTabURL = encodeURI(getInnerTabURL);
						if ( !Ext.isEmpty( appCurrentTabId ) )
						{
							me.loadInnerTab(appCurrentTabId, getInnerTabURL,isFlag);
						}
						else
						{
							me.loadInnerTab(selectedGraphType, getInnerTabURL,isFlag);
						}

						var getTabName = Ext.getCmp(Ext.getCmp('tabpanel').getActiveTab().getId()).tabName;
						if ( getTabName.toLowerCase() == 'history' && isDisableTrendComputation == false)
						{
							me.showTools();
						}
						else
						{
							me.hideTools();
						}
					}
				}
				else if ( serverType == 'MS_sql_server' )
				{
					if ( appSubsystem.toLowerCase() == 'overview' )
					{
						Ext.getCmp('overviewpanel').show();
						var overviewData = jsonData['OVERVIEW'];
						me.showOverview(overviewData);
						var getTabURL = jsonData['TAB_URL'];
						var selectedGraphType = jsonData['selectedGraphType'];

						if(selectedGraphType!=null && selectedGraphType!="" && selectedGraphType.toLowerCase()!="null")
						{
							if(selectedGraphType=="Application_summaryGraph" || selectedGraphType=="Application_trendGraph")
							{
								appCurrentTabId = "Application_measureGraph";
							}
							else
							{
								appCurrentTabId = selectedGraphType;
							}
						}
						else
						{
							selectedGraphType = Ext.getCmp('tabpanel').getActiveTab().getId();
						}

						me.showTabs(getTabURL);
						var getInnerTabURL = jsonData['INNER_TAB_URL'];
						getInnerTabURL = encodeURI(getInnerTabURL);
						if ( !Ext.isEmpty( appCurrentTabId ) )
						{
							me.loadInnerTab(appCurrentTabId, getInnerTabURL,isFlag);
						}
						else
						{
							me.loadInnerTab(selectedGraphType, getInnerTabURL,isFlag);
						}

						var getTabName = Ext.getCmp(Ext.getCmp('tabpanel').getActiveTab().getId()).tabName;
						if ( getTabName.toLowerCase() == 'history' && isDisableTrendComputation == false)
						{
							me.showTools();
						}
						else
						{
							me.hideTools();
						}
					}
					else if ( appSubsystem.toLowerCase() == 'sqlserver' || appSubsystem.toLowerCase() == 'sqlmemory' || appSubsystem.toLowerCase() == 'sqlservice' || appSubsystem.toLowerCase() == 'sqlprocesses' || appSubsystem.toLowerCase() == 'sqldatabases' || appSubsystem.toLowerCase() == 'sqlapplications' )
					{
						Ext.getCmp('overviewpanel').hide();
						var getTabURL = jsonData['TAB_URL'];
						var selectedGraphType = jsonData['selectedGraphType'];
						if(selectedGraphType!=null && selectedGraphType!="" && selectedGraphType.toLowerCase()!="null")
						{
							if(selectedGraphType=="Application_summaryGraph" || selectedGraphType=="Application_trendGraph")
							{
								appCurrentTabId = "Application_measureGraph";
							}
							else
							{
								appCurrentTabId = selectedGraphType;
							}
						}
						else
						{
							selectedGraphType = Ext.getCmp('tabpanel').getActiveTab().getId();
						}

						me.showTabs(getTabURL);
						var getInnerTabURL = jsonData['INNER_TAB_URL'];
						getInnerTabURL = encodeURI(getInnerTabURL);
						if ( !Ext.isEmpty( appCurrentTabId ) )
						{
							me.loadInnerTab(appCurrentTabId, getInnerTabURL,isFlag);
						}
						else
						{
							me.loadInnerTab(selectedGraphType, getInnerTabURL,isFlag);
						}
						var getTabName = Ext.getCmp(Ext.getCmp('tabpanel').getActiveTab().getId()).tabName;
						if ( getTabName.toLowerCase() == 'history' && isDisableTrendComputation == false)
						{
							me.showTools();
						}
						else
						{
							me.hideTools();
						}
					}
				}
				else if ( serverType == 'WebLogic_server' )
				{
					if ( appSubsystem.toLowerCase() == 'overview' )
					{
						Ext.getCmp('overviewpanel').show();
						var overviewData = jsonData['OVERVIEW'];
						me.showOverview(overviewData);
						var getTabURL = jsonData['TAB_URL'];
						var selectedGraphType = jsonData['selectedGraphType'];
						if(selectedGraphType!=null && selectedGraphType!="" && selectedGraphType.toLowerCase()!="null")
						{
							if(selectedGraphType=="Application_summaryGraph" || selectedGraphType=="Application_trendGraph")
							{
								appCurrentTabId = "Application_measureGraph";
							}
							else
							{
								appCurrentTabId = selectedGraphType;
							}
						}
						else
						{
							selectedGraphType = Ext.getCmp('tabpanel').getActiveTab().getId();
						}

						me.showTabs(getTabURL);
						var getInnerTabURL = jsonData['INNER_TAB_URL'];
						getInnerTabURL = encodeURI(getInnerTabURL);
						if ( !Ext.isEmpty( appCurrentTabId ) )
						{
							me.loadInnerTab(appCurrentTabId, getInnerTabURL,isFlag);
						}
						else
						{
							me.loadInnerTab(selectedGraphType, getInnerTabURL,isFlag);
						}
						var getTabName = Ext.getCmp(Ext.getCmp('tabpanel').getActiveTab().getId()).tabName;
						if ( getTabName.toLowerCase() == 'history' && isDisableTrendComputation == false)
						{
							me.showTools();
						}
						else
						{
							me.hideTools();
						}
					}
					else if ( appSubsystem.toLowerCase() == 'history' || appSubsystem.toLowerCase() == 'details' )
					{
						Ext.getCmp('overviewpanel').hide();
						var getTabURL = jsonData['TAB_URL'];
						var selectedGraphType = jsonData['selectedGraphType'];
						if(selectedGraphType!=null && selectedGraphType!="" && selectedGraphType.toLowerCase()!="null")
						{
							if(selectedGraphType=="Application_summaryGraph" || selectedGraphType=="Application_trendGraph")
							{
								appCurrentTabId = "Application_measureGraph";
							}
							else
							{
								appCurrentTabId = selectedGraphType;
							}
						}
						else
						{
							selectedGraphType = Ext.getCmp('tabpanel').getActiveTab().getId();
						}

						me.showTabs(getTabURL);
						var getInnerTabURL = jsonData['INNER_TAB_URL'];
						getInnerTabURL = encodeURI(getInnerTabURL);
						if ( !Ext.isEmpty( appCurrentTabId ) )
						{
							me.loadInnerTab(appCurrentTabId, getInnerTabURL,isFlag);
						}
						else
						{
							me.loadInnerTab(selectedGraphType, getInnerTabURL,isFlag);
						}
						var getTabName = Ext.getCmp(Ext.getCmp('tabpanel').getActiveTab().getId()).tabName;
						if ( getTabName.toLowerCase() == 'history' && isDisableTrendComputation == false)
						{
							me.showTools();
						}
						else
						{
							me.hideTools();
						}
					}
					else if ( appSubsystem.toLowerCase() == 'jvm' )
					{
						Ext.getCmp('overviewpanel').hide();
						var getTabURL = jsonData['TAB_URL'];
						var selectedGraphType = jsonData['selectedGraphType'];
						if(selectedGraphType!=null && selectedGraphType!="" && selectedGraphType.toLowerCase()!="null")
						{
							if(selectedGraphType=="Application_summaryGraph" || selectedGraphType=="Application_trendGraph")
							{
								appCurrentTabId = "Application_measureGraph";
							}
							else
							{
								appCurrentTabId = selectedGraphType;
							}
						}
						else
						{
							selectedGraphType = Ext.getCmp('tabpanel').getActiveTab().getId();
						}

						me.showTabs(getTabURL);
						var getInnerTabURL = jsonData['INNER_TAB_URL'];
						getInnerTabURL = encodeURI(getInnerTabURL);
						if ( !Ext.isEmpty( appCurrentTabId ) )
						{
							me.loadInnerTab(appCurrentTabId, getInnerTabURL,isFlag);
						}
						else
						{
							me.loadInnerTab(selectedGraphType, getInnerTabURL,isFlag);
						}
						var getTabName = Ext.getCmp(Ext.getCmp('tabpanel').getActiveTab().getId()).tabName;
						if ( getTabName.toLowerCase() == 'history' && isDisableTrendComputation == false)
						{
							me.showTools();
						}
						else
						{
							me.hideTools();
						}
					}
					else if ( appSubsystem.toLowerCase() == 'weblogic threads' )
					{
						Ext.getCmp('overviewpanel').hide();
						var getTabURL = jsonData['TAB_URL'];
						var selectedGraphType = jsonData['selectedGraphType'];
						if(selectedGraphType!=null && selectedGraphType!="" && selectedGraphType.toLowerCase()!="null")
						{
							if(selectedGraphType=="Application_summaryGraph" || selectedGraphType=="Application_trendGraph")
							{
								appCurrentTabId = "Application_measureGraph";
							}
							else
							{
								appCurrentTabId = selectedGraphType;
							}
						}
						else
						{
							selectedGraphType = Ext.getCmp('tabpanel').getActiveTab().getId();
						}

						me.showTabs(getTabURL);
						var getInnerTabURL = jsonData['INNER_TAB_URL'];
						getInnerTabURL = encodeURI(getInnerTabURL);
						if ( !Ext.isEmpty( appCurrentTabId ) )
						{
							me.loadInnerTab(appCurrentTabId, getInnerTabURL,isFlag);
						}
						else
						{
							me.loadInnerTab(selectedGraphType, getInnerTabURL,isFlag);
						}
						var getTabName = Ext.getCmp(Ext.getCmp('tabpanel').getActiveTab().getId()).tabName;
						if ( getTabName.toLowerCase() == 'history' && isDisableTrendComputation == false)
						{
							me.showTools();
						}
						else
						{
							me.hideTools();
						}
					}
					else if ( appSubsystem.toLowerCase() == 'weblogic service' )
					{
						Ext.getCmp('overviewpanel').hide();
						var getTabURL = jsonData['TAB_URL'];
						var selectedGraphType = jsonData['selectedGraphType'];
						if(selectedGraphType!=null && selectedGraphType!="" && selectedGraphType.toLowerCase()!="null")
						{
							if(selectedGraphType=="Application_summaryGraph" || selectedGraphType=="Application_trendGraph")
							{
								appCurrentTabId = "Application_measureGraph";
							}
							else
							{
								appCurrentTabId = selectedGraphType;
							}
						}
						else
						{
							selectedGraphType = Ext.getCmp('tabpanel').getActiveTab().getId();
						}

						me.showTabs(getTabURL);
						var getInnerTabURL = jsonData['INNER_TAB_URL'];
						getInnerTabURL = encodeURI(getInnerTabURL);
						if ( !Ext.isEmpty( appCurrentTabId ) )
						{
							me.loadInnerTab(appCurrentTabId, getInnerTabURL,isFlag);
						}
						else
						{
							me.loadInnerTab(selectedGraphType, getInnerTabURL,isFlag);
						}
						var getTabName = Ext.getCmp(Ext.getCmp('tabpanel').getActiveTab().getId()).tabName;
						if ( getTabName.toLowerCase() == 'history' && isDisableTrendComputation == false)
						{
							me.showTools();
						}
						else
						{
							me.hideTools();
						}
					}
					else if ( appSubsystem.toLowerCase() == 'weblogic databases' )
					{
						Ext.getCmp('overviewpanel').hide();
						var getTabURL = jsonData['TAB_URL'];
						var selectedGraphType = jsonData['selectedGraphType'];
						if(selectedGraphType!=null && selectedGraphType!="" && selectedGraphType.toLowerCase()!="null")
						{
							if(selectedGraphType=="Application_summaryGraph" || selectedGraphType=="Application_trendGraph")
							{
								appCurrentTabId = "Application_measureGraph";
							}
							else
							{
								appCurrentTabId = selectedGraphType;
							}
						}
						else
						{
							selectedGraphType = Ext.getCmp('tabpanel').getActiveTab().getId();
						}

						me.showTabs(getTabURL);
						var getInnerTabURL = jsonData['INNER_TAB_URL'];
						getInnerTabURL = encodeURI(getInnerTabURL);
						if ( !Ext.isEmpty( appCurrentTabId ) )
						{
							me.loadInnerTab(appCurrentTabId, getInnerTabURL,isFlag);
						}
						else
						{
							me.loadInnerTab(selectedGraphType, getInnerTabURL,isFlag);
						}
						var getTabName = Ext.getCmp(Ext.getCmp('tabpanel').getActiveTab().getId()).tabName;
						if ( getTabName.toLowerCase() == 'history' && isDisableTrendComputation == false)
						{
							me.showTools();
						}
						else
						{
							me.hideTools();
						}
					}
					else if ( appSubsystem.toLowerCase() == 'weblogic ejb' )
					{
						Ext.getCmp('overviewpanel').hide();
						var getTabURL = jsonData['TAB_URL'];
						var selectedGraphType = jsonData['selectedGraphType'];
						if(selectedGraphType!=null && selectedGraphType!="" && selectedGraphType.toLowerCase()!="null")
						{
							if(selectedGraphType=="Application_summaryGraph" || selectedGraphType=="Application_trendGraph")
							{
								appCurrentTabId = "Application_measureGraph";
							}
							else
							{
								appCurrentTabId = selectedGraphType;
							}
						}
						else
						{
							selectedGraphType = Ext.getCmp('tabpanel').getActiveTab().getId();
						}

						me.showTabs(getTabURL);
						var getInnerTabURL = jsonData['INNER_TAB_URL'];
						getInnerTabURL = encodeURI(getInnerTabURL);
						if ( !Ext.isEmpty( appCurrentTabId ) )
						{
							me.loadInnerTab(appCurrentTabId, getInnerTabURL,isFlag);
						}
						else
						{
							me.loadInnerTab(selectedGraphType, getInnerTabURL,isFlag);
						}
						var getTabName = Ext.getCmp(Ext.getCmp('tabpanel').getActiveTab().getId()).tabName;
						if ( getTabName.toLowerCase() == 'history' && isDisableTrendComputation == false)
						{
							me.showTools();
						}
						else
						{
							me.hideTools();
						}
					}
				}
				else if ( serverType == 'Java_virtual_machine' )
				{
					if ( appSubsystem.toLowerCase() == 'overview' )
					{
						Ext.getCmp('overviewpanel').show();
						var overviewData = jsonData['OVERVIEW'];
						me.showOverview(overviewData);
						var selectedGraphType = jsonData['selectedGraphType'];

						if(selectedGraphType!=null && selectedGraphType!="" && selectedGraphType.toLowerCase()!="null")
						{
							if(selectedGraphType=="Application_summaryGraph" || selectedGraphType=="Application_trendGraph")
							{
								appCurrentTabId = "Application_measureGraph";
							}
							else
							{
								appCurrentTabId = selectedGraphType;
							}
						}
						else
						{
							selectedGraphType = Ext.getCmp('tabpanel').getActiveTab().getId();
						}
						var getTabURL = jsonData['TAB_URL'];
						me.showTabs(getTabURL);
						var getInnerTabURL = jsonData['INNER_TAB_URL'];
						getInnerTabURL = encodeURI(getInnerTabURL);
						if ( !Ext.isEmpty( appCurrentTabId ) )
						{
							me.loadInnerTab(appCurrentTabId, getInnerTabURL,isFlag);
						}
						else
						{
							me.loadInnerTab(selectedGraphType, getInnerTabURL,isFlag);
						}

						var getTabName = Ext.getCmp(Ext.getCmp('tabpanel').getActiveTab().getId()).tabName;
						if ( getTabName.toLowerCase() == 'history' && isDisableTrendComputation == false)
						{
							me.showTools();
						}
						else
						{
							me.hideTools();
						}
					}
					else if ( appSubsystem.toLowerCase() == 'jvm memory' || appSubsystem.toLowerCase() == 'jvm thread' || appSubsystem.toLowerCase() == 'jvm classes' || appSubsystem.toLowerCase() == 'jvm uptime' )
					{
						Ext.getCmp('overviewpanel').hide();
						var selectedGraphType = jsonData['selectedGraphType'];
						if(selectedGraphType!=null && selectedGraphType!="" && selectedGraphType.toLowerCase()!="null")
						{
							if(selectedGraphType=="Application_summaryGraph" || selectedGraphType=="Application_trendGraph")
							{
								appCurrentTabId = "Application_measureGraph";
							}
							else
							{
								appCurrentTabId = selectedGraphType;
							}
						}
						else
						{
							selectedGraphType = Ext.getCmp('tabpanel').getActiveTab().getId();
						}
						var getTabURL = jsonData['TAB_URL'];
						me.showTabs(getTabURL);
						var getInnerTabURL = jsonData['INNER_TAB_URL'];
						getInnerTabURL = encodeURI(getInnerTabURL);

						var getTabName = Ext.getCmp(Ext.getCmp('tabpanel').getActiveTab().getId()).tabName;
						if ( getTabName.toLowerCase() == 'jvm memory' ||  getTabName.toLowerCase() == 'thread analysis')
						{
							getInnerTabURL = '/final/monitor/egSummaryJSON.jsp?tab=Application&subsystem='+encodeURIComponent(appSubsystem)+'&hostName='+encodeURIComponent(componentName)+'&compType='+encodeURIComponent(componentType)+'&info=&measure=&host='+encodeURIComponent(componentName);
						}

						if ( !Ext.isEmpty( appCurrentTabId ) )
						{
							me.loadInnerTab(appCurrentTabId, getInnerTabURL,isFlag);
						}
						else
						{
							me.loadInnerTab(selectedGraphType, getInnerTabURL,isFlag);
						}


						if ( getTabName.toLowerCase() == 'history' && isDisableTrendComputation == false)
						{
							me.showTools();
						}
						else
						{
							me.hideTools();
						}
					}
				}
				else
				{
					if ( appSubsystem.toLowerCase() == 'overview' )
					{
						Ext.getCmp('overviewpanel').show();
						var overviewData = jsonData['OVERVIEW'];
						me.showOverview(overviewData);
							var selectedGraphType = jsonData['selectedGraphType'];

						if(selectedGraphType!=null && selectedGraphType!="" && selectedGraphType.toLowerCase()!="null")
						{
							if(selectedGraphType=="Application_summaryGraph" || selectedGraphType=="Application_trendGraph")
							{
								appCurrentTabId = "Application_measureGraph";
							}
							else
							{
								appCurrentTabId = selectedGraphType;
							}
						}
						else
						{
							selectedGraphType = Ext.getCmp('tabpanel').getActiveTab().getId();
						}
						var getTabURL = jsonData['TAB_URL'];
						me.showTabs(getTabURL);
						var getInnerTabURL = jsonData['INNER_TAB_URL'];
						getInnerTabURL = encodeURI(getInnerTabURL);
						if ( !Ext.isEmpty( appCurrentTabId ) )
						{
							me.loadInnerTab(appCurrentTabId, getInnerTabURL,isFlag);
						}
						else
						{
							me.loadInnerTab(selectedGraphType, getInnerTabURL,isFlag);
						}
						var getTabName = Ext.getCmp(Ext.getCmp('tabpanel').getActiveTab().getId()).tabName;
						if ( getTabName.toLowerCase() == 'history' && isDisableTrendComputation == false)
						{
							me.showTools();
						}
						else
						{
							me.hideTools();
						}
					}
					else 
					{
						var getTabURL = jsonData['TAB_URL'];
						var selectedGraphType = jsonData['selectedGraphType'];
						if(selectedGraphType!=null && selectedGraphType!="" && selectedGraphType.toLowerCase()!="null")
						{
							if(selectedGraphType=="Application_summaryGraph" || selectedGraphType=="Application_trendGraph")
							{
								appCurrentTabId = "Application_measureGraph";
							}
							else
							{
								appCurrentTabId = selectedGraphType;
							}
						}
						else
						{
							selectedGraphType = Ext.getCmp('tabpanel').getActiveTab().getId();
						}
						me.showTabs(getTabURL);
						var getInnerTabURL = jsonData['INNER_TAB_URL'];
						getInnerTabURL = encodeURI(getInnerTabURL);
						if ( !Ext.isEmpty( appCurrentTabId ) )
						{
							me.loadInnerTab(appCurrentTabId, getInnerTabURL,isFlag);
						}
						else
						{
							me.loadInnerTab(selectedGraphType, getInnerTabURL,isFlag);
						}

						var getTabName = Ext.getCmp(Ext.getCmp('tabpanel').getActiveTab().getId()).tabName;
						if ( getTabName.toLowerCase() == 'history' && isDisableTrendComputation == false)
						{
							me.showTools();
						}
						else
						{
							me.hideTools();
						}
					}
				}
			}
			Ext.getCmp('applicationdetails').resumeEvents();
			var mask = null;
			var wholeViewport = document.getElementsByTagName("body")[0];
			if ( !Ext.isEmpty( Ext.get( wholeViewport ) ) )
			{
				mask = new Ext.LoadMask(Ext.get(wholeViewport), {msg:loadingLbl+"...",cls:'maskDash'});
				mask.hide();
			}
			//Ext.Ajax.on('requestcomplete', function(){});
		}
	},
	beforeShowApplicationPanel: function( obj )
	{

		if(Ext.getCmp('subapplicationpanelId')==null || Ext.getCmp('subapplicationpanelId')==undefined)
		{
			this.getApplicationpanel().add(
			{
				xtype:'subapplicationpanel',
				id:'subapplicationpanelId',
				border:false,
			},
			{
				xtype:'subapplicationtabpanel',
				id:'subapplicationtabpanelId',
				border:false,
				flex:1,
				frame:false
			});
		}
		

		var me = this;
		if ( Ext.getCmp('componentsDropDown') != undefined && Ext.getCmp('componentsDropDown') != null )
		{
			var getCmpVal = Ext.getCmp('componentsDropDown').getValue();
			if ( !Ext.isEmpty( getCmpVal ) )
			{
				componentType = getCmpVal.substring(0, getCmpVal.indexOf(':'));
				componentName = getCmpVal.substring(getCmpVal.indexOf(':')+1);
			}
		}
		//Ext.getCmp('applicationdetails').suspendEvents(true);
		var appObj = this.getApplicationpanel();
		var getElObj = Ext.getCmp(appObj.getId()).getEl();
		getElObj.mask(loadingLbl+"...", "maskCenter");

		var appSubsystem = Ext.getCmp('appSubsystem').getValue();
		if ( Ext.isEmpty( appSubsystem ) || appSubsystem.length == 0 )
		{
			appSubsystem = 'Overview';
		}
		appLastLoadedURL ='/final/monitor/egAppDashboardJSON.jsp?tab=Application&hostName='+encodeURIComponent(componentName)+'&compType='+encodeURIComponent(componentType)+'&subsystem='+encodeURIComponent(appSubsystem)+'&screenWidth=1012&screenHeight=570&host='+encodeURIComponent(componentName)+'&time_line=&starttime=&endtime=&starthr=&endhr=&format='+encodeURIComponent(dateFormatForTimeline);

		if( appLastGraphTypeLoaded!=null && appLastGraphTypeLoaded!=null && !Ext.isEmpty(appLastGraphTypeLoaded) && appLastGraphTypeLoaded!=undefined)
		{
			if( appLastLoadedURL.indexOf('graphType') > -1 )
			{
				appLastLoadedURL=appLastLoadedURL.replace(/(graphType=)[^\&]+/, '$1' + appLastGraphTypeLoaded);
			}
			else
			{
				appLastLoadedURL += "&graphType="+appLastGraphTypeLoaded;
			}
		}


		Ext.Ajax.request({
			url:appLastLoadedURL,
			method: 'POST',
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					getElObj.unmask();
					var jsonText = response.responseText;
					var jsonData = Ext.decode( jsonText );
					me.applicationDefaultLoad(jsonData);
				}
			}
		});
	},
	applicationRefreshFunc: function(jsonData)
	{
		var isFlag = 'refresh';
		var me=this;
		var serverType = subject;
		if ( jsonData != '' && jsonData != null && !Ext.isEmpty(jsonData))
		{
			var appSubsystem = Ext.getCmp('appSubsystem').getValue();
			
			if ( appSubsystem != null )
			{
				if ( serverType == 'Citrix_server' || serverType == 'Citrix_XcXenApp_server')
				{
					if ( appSubsystem.toLowerCase() == 'overview' )
					{
						Ext.getCmp('overviewpanel').show();
						var overviewData = jsonData['OVERVIEW'];
						me.showOverview(overviewData);
						var getTabName = Ext.getCmp(Ext.getCmp('tabpanel').getActiveTab().getId()).tabName;
						var getInnerTabURL = jsonData['INNER_TAB_URL'];
						getInnerTabURL = encodeURI(getInnerTabURL);
						me.loadInnerTab("Application_"+appLastGraphTypeLoaded, getInnerTabURL,isFlag);
						if ( getTabName.toLowerCase() == 'history' && isDisableTrendComputation == false)
						{
							me.showTools();
						}
						else
						{
							me.hideTools();
						}
					}
					else if ( appSubsystem.toLowerCase() == 'citrixserver' || appSubsystem.toLowerCase() == 'citrixsessions' || appSubsystem.toLowerCase() == 'citrixapplications' || appSubsystem.toLowerCase() == 'citrixusers' || appSubsystem.toLowerCase() == 'terminalservices' )
					{
						var getInnerTabURL = jsonData['INNER_TAB_URL'];
						getInnerTabURL = encodeURI(getInnerTabURL);
						var getTabName = Ext.getCmp(Ext.getCmp('tabpanel').getActiveTab().getId()).tabName;
						me.loadInnerTab("Application_"+appLastGraphTypeLoaded, getInnerTabURL,isFlag);
						if ( getTabName.toLowerCase() == 'history' && isDisableTrendComputation == false)
						{
							me.showTools();
						}
						else
						{
							me.hideTools();
						}
					}
				}
				else if ( serverType == 'Oracle_server' )
				{
					if ( appSubsystem.toLowerCase() == 'overview' )
					{
						Ext.getCmp('overviewpanel').show();
						var overviewData = jsonData['OVERVIEW'];
						me.showOverview(overviewData);
						var getInnerTabURL = jsonData['INNER_TAB_URL'];
						getInnerTabURL = encodeURI(getInnerTabURL);
						var getTabName = Ext.getCmp(Ext.getCmp('tabpanel').getActiveTab().getId()).tabName;
						me.loadInnerTab("Application_"+appLastGraphTypeLoaded, getInnerTabURL,isFlag);
						if ( getTabName.toLowerCase() == 'history' && isDisableTrendComputation == false)
						{
							me.showTools();
						}
						else
						{
							me.hideTools();
						}
					}
					else if ( appSubsystem.toLowerCase() == 'memory structures' || appSubsystem.toLowerCase() == 'tablespaces' || appSubsystem.toLowerCase() == 'datafiles' || appSubsystem.toLowerCase() == 'database access' )
					{
						var getInnerTabURL = jsonData['INNER_TAB_URL'];
						getInnerTabURL = encodeURI(getInnerTabURL);
						var getTabName = Ext.getCmp(Ext.getCmp('tabpanel').getActiveTab().getId()).tabName;
						me.loadInnerTab("Application_"+appLastGraphTypeLoaded, getInnerTabURL,isFlag);
						if ( getTabName.toLowerCase() == 'history' && isDisableTrendComputation == false)
						{
							me.showTools();
						}
						else
						{
							me.hideTools();
						}
					}
				}
				else if ( serverType == 'MS_sql_server' )
				{
					if ( appSubsystem.toLowerCase() == 'overview' )
					{
						Ext.getCmp('overviewpanel').show();
						var overviewData = jsonData['OVERVIEW'];
						me.showOverview(overviewData);
						var getInnerTabURL = jsonData['INNER_TAB_URL'];						
						getInnerTabURL = encodeURI(getInnerTabURL);
						var getTabName = Ext.getCmp(Ext.getCmp('tabpanel').getActiveTab().getId()).tabName;
						me.loadInnerTab("Application_"+appLastGraphTypeLoaded, getInnerTabURL,isFlag);
						if ( getTabName.toLowerCase() == 'history' && isDisableTrendComputation == false)
						{
							me.showTools();
						}
						else
						{
							me.hideTools();
						}
					}
					else if ( appSubsystem.toLowerCase() == 'sqlserver' || appSubsystem.toLowerCase() == 'sqlmemory' || appSubsystem.toLowerCase() == 'sqlservice' || appSubsystem.toLowerCase() == 'sqlprocesses' || appSubsystem.toLowerCase() == 'sqldatabases' || appSubsystem.toLowerCase() == 'sqlapplications' )
					{
						Ext.getCmp('overviewpanel').hide();
						var getInnerTabURL = jsonData['INNER_TAB_URL'];
						getInnerTabURL = encodeURI(getInnerTabURL);
						if(appSubsystem.toLowerCase() == 'sqlprocesses' && isFlag == 'refresh')
						{
							if(appSQLLastLoadedURL!='')
							{
								 getInnerTabURL = appSQLLastLoadedURL;
							}
						}
						var getTabName = Ext.getCmp(Ext.getCmp('tabpanel').getActiveTab().getId()).tabName;
						me.loadInnerTab("Application_"+appLastGraphTypeLoaded, getInnerTabURL,isFlag);
						if ( getTabName.toLowerCase() == 'history' && isDisableTrendComputation == false)
						{
							me.showTools();
						}
						else
						{
							me.hideTools();
						}
					}
				}
				else if ( serverType == 'WebLogic_server' )
				{
					if ( appSubsystem.toLowerCase() == 'overview' )
					{
						Ext.getCmp('overviewpanel').show();
						var overviewData = jsonData['OVERVIEW'];
						me.showOverview(overviewData);
						var getInnerTabURL = jsonData['INNER_TAB_URL'];
						getInnerTabURL = encodeURI(getInnerTabURL);
						var getTabName = Ext.getCmp(Ext.getCmp('tabpanel').getActiveTab().getId()).tabName;
						me.loadInnerTab("Application_"+appLastGraphTypeLoaded, getInnerTabURL,isFlag);
						if ( getTabName.toLowerCase() == 'history' && isDisableTrendComputation == false)
						{
							me.showTools();
						}
						else
						{
							me.hideTools();
						}
					}
					else if ( appSubsystem.toLowerCase() == 'history' || appSubsystem.toLowerCase() == 'details' )
					{
						Ext.getCmp('overviewpanel').hide();
						var getInnerTabURL = jsonData['INNER_TAB_URL'];
						getInnerTabURL = encodeURI(getInnerTabURL);
						var getTabName = Ext.getCmp(Ext.getCmp('tabpanel').getActiveTab().getId()).tabName;
						me.loadInnerTab("Application_"+appLastGraphTypeLoaded, getInnerTabURL,isFlag);
						if ( getTabName.toLowerCase() == 'history' && isDisableTrendComputation == false)
						{
							me.showTools();
						}
						else
						{
							me.hideTools();
						}
					}
					else if ( appSubsystem.toLowerCase() == 'jvm' )
					{
						Ext.getCmp('overviewpanel').hide();
						var getInnerTabURL = jsonData['INNER_TAB_URL'];
						getInnerTabURL = encodeURI(getInnerTabURL);
						var getTabName = Ext.getCmp(Ext.getCmp('tabpanel').getActiveTab().getId()).tabName;
						me.loadInnerTab("Application_"+appLastGraphTypeLoaded, getInnerTabURL,isFlag);
						if ( getTabName.toLowerCase() == 'history' && isDisableTrendComputation == false)
						{
							me.showTools();
						}
						else
						{
							me.hideTools();
						}
					}
					else if ( appSubsystem.toLowerCase() == 'weblogic threads' )
					{
						Ext.getCmp('overviewpanel').hide();
						var getInnerTabURL = jsonData['INNER_TAB_URL'];
						getInnerTabURL = encodeURI(getInnerTabURL);
						var getTabName = Ext.getCmp(Ext.getCmp('tabpanel').getActiveTab().getId()).tabName;
						me.loadInnerTab("Application_"+appLastGraphTypeLoaded, getInnerTabURL,isFlag);
						if ( getTabName.toLowerCase() == 'history' && isDisableTrendComputation == false)
						{
							me.showTools();
						}
						else
						{
							me.hideTools();
						}
					}
					else if ( appSubsystem.toLowerCase() == 'weblogic service' )
					{
						Ext.getCmp('overviewpanel').hide();
						var getInnerTabURL = jsonData['INNER_TAB_URL'];
						getInnerTabURL = encodeURI(getInnerTabURL);
						var getTabName = Ext.getCmp(Ext.getCmp('tabpanel').getActiveTab().getId()).tabName;
						me.loadInnerTab("Application_"+appLastGraphTypeLoaded, getInnerTabURL,isFlag);
						if ( getTabName.toLowerCase() == 'history' && isDisableTrendComputation == false)
						{
							me.showTools();
						}
						else
						{
							me.hideTools();
						}
					}
					else if ( appSubsystem.toLowerCase() == 'weblogic databases' )
					{
						Ext.getCmp('overviewpanel').hide();
						var getInnerTabURL = jsonData['INNER_TAB_URL'];
						getInnerTabURL = encodeURI(getInnerTabURL);
						var getTabName = Ext.getCmp(Ext.getCmp('tabpanel').getActiveTab().getId()).tabName;
						me.loadInnerTab("Application_"+appLastGraphTypeLoaded, getInnerTabURL,isFlag);
						if ( getTabName.toLowerCase() == 'history' && isDisableTrendComputation == false)
						{
							me.showTools();
						}
						else
						{
							me.hideTools();
						}
					}
					else if ( appSubsystem.toLowerCase() == 'weblogic ejb' )
					{
						Ext.getCmp('overviewpanel').hide();
						var getInnerTabURL = jsonData['INNER_TAB_URL'];
						getInnerTabURL = encodeURI(getInnerTabURL);
						var getTabName = Ext.getCmp(Ext.getCmp('tabpanel').getActiveTab().getId()).tabName;
						me.loadInnerTab("Application_"+appLastGraphTypeLoaded, getInnerTabURL,isFlag);
						if ( getTabName.toLowerCase() == 'history' && isDisableTrendComputation == false)
						{
							me.showTools();
						}
						else
						{
							me.hideTools();
						}
					}
				}
				else if ( serverType == 'Java_virtual_machine' )
				{
					if ( appSubsystem.toLowerCase() == 'overview' )
					{
						Ext.getCmp('overviewpanel').show();
						var overviewData = jsonData['OVERVIEW'];
						me.showOverview(overviewData);
						var getInnerTabURL = jsonData['INNER_TAB_URL'];
						getInnerTabURL = encodeURI(getInnerTabURL);
						var getTabName = Ext.getCmp(Ext.getCmp('tabpanel').getActiveTab().getId()).tabName;
						me.loadInnerTab("Application_"+appLastGraphTypeLoaded, getInnerTabURL,isFlag);
						if ( getTabName.toLowerCase() == 'history' && isDisableTrendComputation == false)
						{
							me.showTools();
						}
						else
						{
							me.hideTools();
						}
					}
					else if ( appSubsystem.toLowerCase() == 'jvm memory' || appSubsystem.toLowerCase() == 'jvm thread' || appSubsystem.toLowerCase() == 'jvm classes' || appSubsystem.toLowerCase() == 'jvm uptime' )
					{
						Ext.getCmp('overviewpanel').hide();
						var getInnerTabURL = jsonData['INNER_TAB_URL'];
						getInnerTabURL = encodeURI(getInnerTabURL);
						var getTabName = Ext.getCmp(Ext.getCmp('tabpanel').getActiveTab().getId()).tabName;
						
						if ( getTabName.toLowerCase() == 'jvm memory' ||  getTabName.toLowerCase() == 'thread analysis')
						{
							getInnerTabURL = '/final/monitor/egSummaryJSON.jsp?tab=Application&subsystem='+encodeURIComponent(appSubsystem)+'&hostName='+encodeURIComponent(componentName)+'&compType='+encodeURIComponent(componentType)+'&info=&measure=&host='+encodeURIComponent(componentName);
						}
						me.loadInnerTab("Application_"+appLastGraphTypeLoaded, getInnerTabURL,isFlag);
						if ( getTabName.toLowerCase() == 'history' && isDisableTrendComputation == false)
						{
							me.showTools();
						}
						else
						{
							me.hideTools();
						}
					}
				}
				else
				{
					if ( appSubsystem.toLowerCase() == 'overview' )
					{
						Ext.getCmp('overviewpanel').show();
						var overviewData = jsonData['OVERVIEW'];
						me.showOverview(overviewData);
						var getInnerTabURL = jsonData['INNER_TAB_URL'];
						getInnerTabURL = encodeURI(getInnerTabURL);
						var getTabName = Ext.getCmp(Ext.getCmp('tabpanel').getActiveTab().getId()).tabName;
						me.loadInnerTab("Application_"+appLastGraphTypeLoaded, getInnerTabURL,isFlag);
						if ( getTabName.toLowerCase() == 'history' && isDisableTrendComputation == false)
						{
							me.showTools();
						}
						else
						{
							me.hideTools();
						}
					}
				}
			}
		}
	},
	showTools: function()
	{
		Ext.getCmp('history-tool').show();
    	Ext.getCmp('calendar-tool').show();
    	Ext.getCmp('history-tool').show();
    	Ext.getCmp('summary-tool').show();
    	Ext.getCmp('area-tool').show();
    	//Ext.getCmp('calendar-btn').fireEvent('loadTime', Ext.getCmp('calendar-btn'));
	},
	hideTools: function()
	{
		Ext.getCmp('history-tool').hide();
    	Ext.getCmp('calendar-tool').hide();
    	Ext.getCmp('history-tool').hide();
    	Ext.getCmp('summary-tool').hide();
    	Ext.getCmp('area-tool').hide();
	},
	loadTimeline: function( getTabURL )
	{
		var tpl = new Ext.XTemplate('<div style="float:left;margin:4px 0px 0px 4px"><b>'+defSettingsLbl+'</b></div><div style="text-align:right;float:right;"><div class="iconClose3" id="closeSettingsApp"></div></div>');
		Ext.create('Ext.container.Container',
		{
			padding:'5 5 5 0',
			width: 560,
			style:{'position':'absolute'},
			id:'configModApp',
			closeAction:'hide',
			cls:'configMode_popup',
			//html:tpl.apply(),
			items:[
					{
						xtype:'container',
						cls:'configMode_popupArrow',
						style:{'top':'-14px','left':'425px'}
					},
					{
						xtype:'container',
						html:tpl.apply(),
						style:{'top':'0px','margin':'2px'}
					},
					{
						xtype : 'applicationtimeline',
						parent:this
					}
			],
			renderTo: 'tabpanel-body'

		});
		Ext.get('configModApp').animate({to: {'top':30},listeners:{ afteranimate:function(){  Ext.get('configModApp').setStyle('left', '');}}}).show();
		Ext.getBody().on('click',function()
		{
			var configobj = Ext.get('configModApp');
			if ( configobj != null && configobj != undefined )
			{
				configobj.hide();
			}
			configobj.animate({duration: 500,to: {y: -500}});
		},null,{delegate:'#closeSettingsApp'});

	},
	showOverview: function( overviewData )
	{
		var currentAlertsObj = Ext.getCmp('currentAlerts');
		var title = overviewData['alertTitle'];
		var currentAlertArr = new Array();
		var resArr = new Array();
		currentAlertArr.push({
			xtype:'container',
			id:'App_AlertTilte',
			padding: '0px 0px 0px 35%',
			html: '<div class="title"><b>'+title+'</b></div>'
		});
		var alertsData = overviewData['ALERTS'];
		if ( alertsData != undefined )
		{
			if ( alertsData == '-' )
			{
				var NO_ALERTS = overviewData['NO_ALERTS'];
				currentAlertArr.push({
					xtype: 'container',
					id:'App_NoAlertID',
					width: '100%',
					html: '<table width="100%" height="100%"><tr><td valign="middle" align="center"><div class="iconNoalarms" style="margin-top:5%"></div><div style="font-size:12px">'+NO_ALERTS+'</div></td></tr></table>'
				});
			}
			else
			{
				var openalertTitle = alertsData['OPEN_ALERT_TITLE'];
				var openAlerts = alertsData['OPEN_ALERTS'];
				var distribTitle = alertsData['DISTRIBUTION_TITLE'];
				var distribValsHTML = '';
				if ( alertsData['DISTRIBUTION_CRITICAL_VALUE'] != undefined && alertsData['DISTRIBUTION_CRITICAL_VALUE'] > 0)
				{
					var distribDesc = alertsData['DISTRIBUTION_CRITICAL_DESC'];
					var linkHTML = '';
					if ( alertsData['DISTRIBUTION_CRITICAL_LINK'] != undefined )
					{
						var linkData = alertsData['DISTRIBUTION_CRITICAL_LINK'];
						var methodName = linkData['METHOD_NAME'];
						var params = linkData['PARAMS'];
						var getParams = params.split('|');


						var genHTML = '<div style="text-align:center;" >'+alertsData['DISTRIBUTION_CRITICAL_VALUE']+'</div>';
						distribValsHTML += '<td><div class="bar12_high" style="text-align:center;color:#ffffff;height: 13px !important;">'+genHTML+'</div></td>'
					}
					else
					{
						distribValsHTML += '<td><div class="bar12_high" style="float:left;width:24px;text-align:center;display:none;height: 13px !important;">'+alertsData['DISTRIBUTION_CRITICAL_VALUE']+'</div></td>';
					}
				}
				if ( alertsData['DISTRIBUTION_MAJOR_VALUE'] != undefined &&  alertsData['DISTRIBUTION_MAJOR_VALUE'] > 0)
				{
					var distribDesc = alertsData['DISTRIBUTION_MAJOR_DESC'];
					var linkHTML = '';
					if ( alertsData['DISTRIBUTION_MAJOR_LINK'] != undefined )
					{
						var linkData = alertsData['DISTRIBUTION_MAJOR_LINK'];
						var methodName = linkData['METHOD_NAME'];
						var params = linkData['PARAMS'];
						var getParams = params.split('|');
						var genHTML = '<div style="text-align:center;" >'+alertsData['DISTRIBUTION_MAJOR_VALUE']+'</div>';
						distribValsHTML += '<td><div class="bar12_intermediate" style="float:left;width:100%;text-align:center;color:#ffffff;height: 13px !important">'+genHTML+'</div></td>';
					}
					else
					{
						distribValsHTML += '<td><div class="bar12_intermediate" style="display:none;float:left;width:100%;text-align:center;height: 13px !important;">'+alertsData['DISTRIBUTION_MAJOR_VALUE']+'</div></td>';
					}
				}
				if ( alertsData['DISTRIBUTION_MINOR_VALUE'] != undefined && alertsData['DISTRIBUTION_MINOR_VALUE'] > 0)
				{
					var distribDesc = alertsData['DISTRIBUTION_MINOR_DESC'];
					var linkHTML = '';
					if ( alertsData['DISTRIBUTION_MINOR_LINK'] != undefined )
					{
						var linkData = alertsData['DISTRIBUTION_MINOR_LINK'];
						var methodName = linkData['METHOD_NAME'];
						var params = linkData['PARAMS'];
						var getParams = params.split('|');
						var genHTML = '<div style="text-align:center;" >'+alertsData['DISTRIBUTION_MINOR_VALUE']+'</div>';
						distribValsHTML += '<td><div class="bar12_low" style="width:100%;float:left;text-align:center;color:#ffffff;height: 13px !important;">'+genHTML+'</div></td>';
					}
					else
					{
						distribValsHTML += '<td><div class="bar12_low" style="display:none;float:left;text-align:center;height: 13px !important;">'+alertsData['DISTRIBUTION_MINOR_VALUE']+'</div></td>';
					}
				}
				distribValsHTML = '<table width="100%"><tr>'+distribValsHTML+'</tr></table>';
				currentAlertArr.push(
					/*{
					xtype: 'container',
					layout:'column',
					columnWidth: 0.5,
					width: '100%',
					padding: '4px 0px 4px 0px',
					items:[
						{
							xtype: 'container',
							id:'App_OpenAlertsID',
							width:'100%',
							html: '<div style="text-align:right;padding:0px 5px 0 5px;"><div class="summaryOpenProblems" style="position:absolute;top:25px;left:4.5%;"></div><div></div><div  id="openAlerts"></div></div>'
						}
					]
				}, */
				{
					xtype: 'container',
					layout: 'hbox',
					items:[
						{
							xtype: 'container',
							id:'App_distribValsHTMLID',
							width: '100%',
							padding:10,
							html:'<table width="100%" height="100%" style="margin-top: 16px;"><tr><td width="5%"></td><td width="90%"></td></tr><tr><td width="5%"><div class="summaryOpenProblems" style="top:25px;"></td><td width="90%"><div style="float: right" class="font_no">'+openAlerts+'</div><div class="font_bold12" style="margin-top: 16px;float: right;margin-right: -8px;">'+openalertTitle+'</div></td></tr></table><div class="outer_round" style="margin-top: 5px;">'+distribValsHTML+'</div>'												
							//html: '<table width="100%" height="100%"><tr><td width="90%"><div style="font-size:12px;font-weight:bold;margin-top: 5px;float: right;">'+openAlerts+'</div></td></tr><tr><td width="90%"><div style="font-size:12px;font-weight:bold;margin-top: 5px;float: right;">'+openalertTitle+'</div></td></tr></table><div class="outer_round">'+distribValsHTML+'</div>'
						}

					]
				}
				);
			}
		}
		if(Ext.getCmp('App_AlertTilte')!=null)
		{
			Ext.getCmp('App_AlertTilte').update('<div class="title"><b>'+title+'</b></div>');
			if ( alertsData == '-' )
			{
				if(Ext.getCmp('App_NoAlertID')!=null)
				{
					Ext.getCmp('App_NoAlertID').update('<table width="100%" height="100%"><tr><td valign="middle" align="center"><div class="iconNoalarms" style="margin-top:5%"></div><div style="font-size:12px">'+NO_ALERTS+'</div></td></tr></table>');
				}
				else
				{
					currentAlertsObj.removeAll();
					currentAlertsObj.add(currentAlertArr);
					currentAlertsObj.doLayout();
				}
			}
			else
			{
				if(Ext.getCmp('App_distribValsHTMLID')!=null)
				{
					//Ext.getCmp('App_OpenAlertsID').update('<div style="text-align:right;padding:0px 5px 0 5px;"><div class="summaryOpenProblems" style="position:absolute;top:25px;left:4.5%;"></div><div></div><div  id="openAlerts"></div></div> <div style="text-align:right;padding:0px 5px 0 5px;"><div class="summaryOpenProblems" style="position:absolute;top:25px;left:4.5%;"></div><div><b><span style="font-size:23px">'+openAlerts+'</span></b></div><div  id="openAlerts"><span style="font-size:12px;fonr-weight:bold"><b>'+openalertTitle+'</b></span></div></div>');
					Ext.getCmp('App_distribValsHTMLID').update( '<table width="100%" height="100%" style="margin-top: 16px;"><tr><td width="5%"></td><td width="90%"></td></tr><tr><td width="5%"><div class="summaryOpenProblems" style="top:25px;"></td><td width="90%"><div class="font_bold12" style="float: right">'+openAlerts+'</div><div class="font_bold12" style="margin-top: 16px;float: right;margin-right: -8px;">'+openalertTitle+'</div></td></tr></table><div class="outer_round" style="margin-top: 5px;">'+distribValsHTML+'</div>');
				}
				else
				{
					currentAlertsObj.removeAll();
					currentAlertsObj.add(currentAlertArr);
					currentAlertsObj.doLayout();
				}
			}
		}
		else
		{
			currentAlertsObj.removeAll();
			currentAlertsObj.add(currentAlertArr);
			currentAlertsObj.doLayout();	
		}
		

		/**********To Load Current Events *************/

		var currentEvents = overviewData['EVENTS'];
		var eventCriticalPageUrl = overviewData['eventUrl1'];
		var eventMajorPageUrl = overviewData['eventUrl2'];
		var eventMinorPageUrl = overviewData['eventUrl3'];
		var eventsTitle = currentEvents['eventsTitle'];
		if ( eventsTitle == undefined && currentEvents == '-' )
		{
			eventsTitle = overviewData['eventsTitle'];
		}
		var currenEventsObj = Ext.getCmp('currentEvents');
		var currentEventArr = new Array();
		currentEventArr.push({
			xtype: 'container',
			id:'App_eventsTitleID',
			width: '100%',
			html: '<div class="title"><b>'+eventsTitle+'</b></div>'
		});
		if ( currentEvents != undefined )
		{
			if ( currentEvents == '-' )
			{
				var NO_EVENTS = overviewData['NO_EVENTS'];
				currentEventArr.push({
					xtype: 'container',
					id:'App_NoEventsData',
					width: '100%',
					html: '<table width="100%" height="100%"><tr><td align="center"><br/><div class="iconNoalarms" style=""></div><div style="font-size:12px">'+NO_EVENTS+'</div></td></tr></table>'
				});
			}
			else
			{
				//var swfPath = currentEvents['SWF_PATH'];
				//var xmlData = currentEvents['XML_DATA'];
				var distribEvtsHTML = '';
				var criticalEvtCount = currentEvents['criticalEvtCount'];
				var majorEvtCount = currentEvents['majorEvtCount'];
				var minorEvtCount = currentEvents['minorEvtCount'];
				if (criticalEvtCount != undefined && criticalEvtCount > 0)
				{
					if (eventCriticalPageUrl!=undefined)
					{
						var genHTML = '<div onclick="javascript:goToAlarmHistory(\''+eventCriticalPageUrl+'\');" style="text-align:center;cursor:pointer" >'+criticalEvtCount+'</div>';
						distribEvtsHTML += '<td><div class="bar12_high" style="text-align:center;color:#ffffff;height: 13px !important;">'+genHTML+'</div></td>'
					}
					else
					{
						distribEvtsHTML += '<td><div class="bar12_high" style="float:left;width:24px;text-align:center;display:none;height: 13px !important;">'+criticalEvtCount+'</div></td>';
					}
				}
				if (majorEvtCount != undefined && majorEvtCount > 0)
				{
					if(eventMajorPageUrl!=undefined)
					{
						var genHTML = '<div onclick="javascript:goToAlarmHistory(\''+eventMajorPageUrl+'\');" style="text-align:center;cursor:pointer" >'+majorEvtCount+'</div>';
						distribEvtsHTML += '<td><div class="bar12_intermediate" style="text-align:center;color:#ffffff;height: 13px !important;">'+genHTML+'</div></td>'
					}
					else
					{
						distribEvtsHTML += '<td><div class="bar12_intermediate" style="float:left;width:24px;text-align:center;display:none;height: 13px !important;">'+majorEvtCount+'</div></td>';
					}
				}
				if (minorEvtCount != undefined && minorEvtCount > 0)
				{
					if (eventMinorPageUrl!=undefined)
					{
						var genHTML = '<div onclick="javascript:goToAlarmHistory(\''+eventMinorPageUrl+'\');" style="text-align:center;cursor:pointer" >'+minorEvtCount+'</div>';
						distribEvtsHTML += '<td><div class="bar12_low" style="text-align:center;color:#ffffff;height: 13px !important;">'+genHTML+'</div></td>'
					}
					else
					{
						distribEvtsHTML += '<td><div class="bar12_low" style="float:left;width:24px;text-align:center;display:none;height: 13px !important;">'+minorEvtCount+'</div></td>';
					}
				}
				distribEvtsHTML = '<table width="100%"><tr>'+distribEvtsHTML+'</tr></table>';
				//var dataArray = new Array();
				//dataArray[dataArray.length] = swfPath;
				//dataArray[dataArray.length] = xmlData;
				var totalEventsTitle = currentEvents['monitor.dashboard.Total Events'];
				var totalEvents = currentEvents['TOTAL_EVENTS'];
				var avgDurationTitle = currentEvents['monitor.dashboard.Avg Duration'];
				var avgDuration = currentEvents['AVG_DURATION'];
				var maxDurationTitle = currentEvents['monitor.dashboard.Max Duration'];
				var maxDuration = currentEvents['MAX_DURATION'];

				currentEventArr.push({
					xtype: 'container',
					layout: {
						type: 'hbox',
						align: 'stretch'
					},
					width: '100%',
					items:[
					/*	{
							xtype: 'container',
							width: 320,
							padding:5,
							height:86,
							items:[
								{
									xtype: 'container',
									id:'App_distribEvtsHTMLCon',
									width: '100%',
									margin:'55 0 0 0',
									html: '<div class="outer_round">'+distribEvtsHTML+'</div>'
								}]

							//xtype: 'container',
							//id: 'eventChartContainer',
							//cls:'fancy_border first',
							//dataArray: dataArray,
							//padding:5,
							//width:320,
							//html: '<div id="barChart" style="border:0px solid red;height:75px;width:320px;"></div>'
							//html: distribEvtsHTML
						}, */

						{
							xtype: 'container',
							layout: 'vbox',
							cls:'fancy_border',
							flex:.4,
							height:86,
							items:[
								{
									xtype: 'container',
									id:'App_totalEventsTitle',
									width: '100%',
									padding:10,
									html: '<table width="100%" height="100%" style="margin-top: 16px;"><tr><td width="5%"></td><td width="90%"></td></tr><tr><td width="5%"><div class="totalEvents" style="top:25px;"></td><td width="90%"><div style="float: right" class="font_no">'+totalEvents+'</div><div class="font_bold12" style="margin-top: 16px;float: right;margin-right: -8px;">'+totalEventsTitle+'</div></td></tr></table><div class="outer_round" style="margin-top: 5px;">'+distribEvtsHTML+'</div>'
									//html: '<div><div class="totalEvents" style="position:absolute;top:45px;"></div><div class="font_no" style="margin:5px 0px 0px 0;">'+totalEvents+'</div><div style="margin:20px 0px 0px 0;" class="font_bold">'+totalEventsTitle+'</div></div>'
								}

							]
						},{
							xtype: 'container',
							cls:'fancy_border',
							layout: 'vbox',
							flex:.2,
							items:[
								{
									xtype: 'container',
									id:'App_avgDuration',
									width: '100%',
									style:{'text-align':'right','padding':'0 10px 0 10px'},
									html: '<div><div class="summaryAverageDuration" style="position:absolute;top:45px;"></div><div class="font_no" style="margin:25px 0px 0px 0;">'+avgDuration+'</div><div style="margin:15px 0px 0px 0;" class="font_bold">'+avgDurationTitle+'</div></div>'
								}

							]
						},{
							xtype: 'container',
							cls:'fancy_border last',
							layout: 'vbox',
							flex:.2,
							items:[
								{
									xtype: 'container',
									id:'App_maxDuration',
									width: '100%',
									style:{'text-align':'right','padding':'0 10px 0 10px'},
									html: '<div><div class="summaryMaximumDuration" style="position:absolute;top:45px;"></div><div class="font_no" style="margin:25px 0px 0px 0;">'+maxDuration+'</div><div style="margin:15px 0px 0px 0;" class="font_bold">'+maxDurationTitle+'</div></div>'
								}

							]
						}
					]
				});
			}
		}
		if(Ext.getCmp('App_eventsTitleID')!=null)
		{
			Ext.getCmp('App_eventsTitleID').update('<div class="title"><b>'+eventsTitle+'</b></div>');
			if ( currentEvents == '-' )
			{
				if(Ext.getCmp('App_NoEventsData')!=null )
				{
					Ext.getCmp('App_NoEventsData').update('<table width="100%" height="100%"><tr><td align="center"><br/><div class="iconNoalarms" style=""></div><div style="font-size:12px">'+NO_EVENTS+'</div></td></tr></table>');
				}
				else
				{
					currenEventsObj.removeAll();
					currenEventsObj.add(currentEventArr);
					currenEventsObj.doLayout();	
				}
			}
			else
			{
				if(Ext.getCmp('App_totalEventsTitle')!=null && Ext.getCmp('App_avgDuration')!=null &&Ext.getCmp('App_maxDuration')!=null)
				{
					//Ext.getCmp('App_distribEvtsHTMLCon').update('<div class="outer_round">'+distribEvtsHTML+'</div>');
					Ext.getCmp('App_totalEventsTitle').update('<table width="100%" height="100%" style="margin-top: 16px;"><tr><td width="5%"></td><td width="90%"></td></tr><tr><td width="5%"><div class="totalEvents" style="top:25px;"></td><td width="90%"><div class="font_bold12" style="float: right">'+totalEvents+'</div><div class="font_bold12" style="margin-top: 16px;float: right;margin-right: -8px;">'+totalEventsTitle+'</div></td></tr></table><div class="outer_round" style="margin-top: 5px;">'+distribEvtsHTML+'</div>');
					Ext.getCmp('App_avgDuration').update('<div><div class="summaryAverageDuration" style="position:absolute;top:45px;"></div><div class="font_no" style="margin:25px 0px 0px 0;">'+avgDuration+'</div><div style="margin:15px 0px 0px 0;" class="font_bold">'+avgDurationTitle+'</div></div>');
					Ext.getCmp('App_maxDuration').update('<div><div class="summaryMaximumDuration" style="position:absolute;top:45px;"></div><div class="font_no" style="margin:25px 0px 0px 0;">'+maxDuration+'</div><div style="margin:15px 0px 0px 0;" class="font_bold">'+maxDurationTitle+'</div></div>');
				}
				else
				{
					currenEventsObj.removeAll();
					currenEventsObj.add(currentEventArr);
					currenEventsObj.doLayout();	
				}
			}
		}
		else
		{
			currenEventsObj.removeAll();
			currenEventsObj.add(currentEventArr);
			currenEventsObj.doLayout();	
		}
		
	/*	var getEvenContObj = Ext.getCmp('eventChartContainer');
		if ( getEvenContObj != undefined )
		{
			var getDataArray = getEvenContObj.dataArray;
			var swfPath = getDataArray[0];
			var xmlData = getDataArray[1];
			if ( xmlData != undefined )
			{
				if ( FusionCharts('currentEventsChart') )
				{
					FusionCharts('currentEventsChart').dispose();
				}
				var myChart = new FusionCharts(swfPath,'currentEventsChart', '100%', '100%','0','1');
				myChart.setXMLData(xmlData);
				myChart.setTransparent(true);
				myChart.render('barChart');
			}
		}*/
	},
	showTabs: function( URL )
	{
	
		var serverType = subject;
		var isFlag='default';
		var subSystemVal = Ext.getCmp('appSubsystem').getValue();
		var me = this;
		var subapplicationtabObj = this.getSubapplicationtabpanel();
		var subapplicationtabEl = subapplicationtabObj.getEl();
		subapplicationtabObj.removeAll();
		subapplicationtabEl.mask(loadingLbl+"...", "maskCenter");
		var jsonText = '', jsonData = '';
		//lastGraphTimelineURL = URL;
		var tabs = new Array();
		Ext.Ajax.request({
			url: URL,
			method: 'GET',
			async: false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					subapplicationtabEl.unmask();
					jsonText = response.responseText;
					jsonData = Ext.decode( jsonText );
					tabs = jsonData['tabs'];
				}
			},
			failure: function()
			{
//				alert('I am in failure...');
			}
		});
		var tabArr = new Array();
		if ( !Ext.isEmpty( tabs ) )
		{
			for ( var i = 0; i < tabs.length; i++ )
			{
				var tmpTab = tabs[i];
				var tabName = tmpTab['TAB_NAME'];
				var tabTitle = tmpTab['TAB_MAPPING_NAME'];
				var methodName = tmpTab['METHOD_NAME'];
				var params = tmpTab['PARAMS'];
				var no_params = params.split('|');
				var tabId = tmpTab['TAB_ID'];
				var no_params = params.split('|');

				var getTmpTimelineData = jsonData['TimelineWindow'];
				timelineVals['timeline'] = getTmpTimelineData[0]['selected'];
				timelineVals['starttime'] = getTmpTimelineData[1]['value'];
				timelineVals['starthour'] = getTmpTimelineData[2]['selected'];
				timelineVals['endtime'] = getTmpTimelineData[3]['value'];
				timelineVals['endhour'] = getTmpTimelineData[4]['selected'];

				tabArr.push({
					title: tabTitle,
					id: tabId,
					tabName: tabName,
					dataArray: tmpTab,
					xtype: 'container',
					layout: 'vbox',
					listeners:
					{
						'beforeshow': function( obj )
						{
							if ( Ext.get('configModApp') != undefined ) // ensure configModApp is close before show tab panel
							{
								Ext.get('configModApp').destroy();
							}
							var tmpDataArray = this.dataArray;
							var URL = '';
							if ( componentType == 'Citrix_server' || componentType == 'Citrix_XcXenApp_server')
							{
								if ( tmpDataArray['TAB_NAME'].toLowerCase() == 'at-a-glance' )
								{
									if ( subSystemVal.toLowerCase() == 'overview' )
									{
										URL = "/final/monitor/egDashboardOverviewJSON.jsp";
										URL += "?"+"hostName="+encodeURIComponent(componentName)+"&compType="+encodeURIComponent(componentType)+"&tab="+tab
									}
									else if ( subSystemVal.toLowerCase() == 'citrixusers' )
									{
										URL = "/final/monitor/egCitrixUsersJSON.jsp";
										URL += "?"+"hostName="+encodeURIComponent(componentName)+"&compType="+encodeURIComponent(componentType)+"&tab="+tab+"&fromCitrixApplication=false&subject="+encodeURIComponent(componentType);
									}
									else
									{
										URL = "/final/monitor/egCitrixUsersJSON.jsp";
										URL += "?"+"hostName="+encodeURIComponent(componentName)+"&compType="+encodeURIComponent(componentType)+"&tab="+tab+"&fromCitrixApplication=true";
									}
									me.loadInnerTab(tmpDataArray['TAB_ID'], URL,isFlag);
								}
								else if ( tmpDataArray['TAB_NAME'].toLowerCase() == 'details' || tmpDataArray['TAB_NAME'].toLowerCase() == 'comparison' )
								{
									var timelineData = jsonData['TimelineWindow'];
									var timeline = timelineData[0]['selected'];
									var starttime = timelineData[1]['value'];
									var starthour = timelineData[2]['selected'];
									var endtime = timelineData[3]['value'];
									var endhour = timelineData[4]['selected'];
									URL = '/final/monitor/egDashboardHistoryJSON.jsp';
									var no_params= tmpDataArray['PARAMS'].split('|');

									me.loadInnerTab(tmpDataArray['TAB_ID'], URL+'?tab=Application&hostName='+encodeURIComponent(componentName)+'&compType='+encodeURIComponent(componentType)+'&subsystem='+encodeURIComponent(Ext.getCmp('appSubsystem').getValue())+'&graphType='+encodeURIComponent(no_params[2])+'&showGraph='+encodeURIComponent(no_params[2])+'&time_line=&starttime='+encodeURIComponent(starttime)+'&endtime='+encodeURIComponent(endtime)+'&starthr='+encodeURIComponent(starthour)+'&endhr='+encodeURIComponent(endhour)+'&format='+encodeURIComponent(dateFormatForTimeline)+'&host='+encodeURIComponent(componentName),isFlag);
								}
								else if ( tmpDataArray['TAB_NAME'].toLowerCase() == 'history' )
								{
									var timelineData = jsonData['TimelineWindow'];
									var timeline = timelineData[0]['selected'];
									var starttime = timelineData[1]['value'];
									var starthour = timelineData[2]['selected'];
									var endtime = timelineData[3]['value'];
									var endhour = timelineData[4]['selected'];
									URL = '/final/monitor/egDashboardHistoryJSON.jsp';
									var no_params= tmpDataArray['PARAMS'].split('|');
									me.loadInnerTab(tmpDataArray['TAB_ID'], URL+'?tab=Application&hostName='+encodeURIComponent(componentName)+'&compType='+encodeURIComponent(componentType)+'&subsystem='+encodeURIComponent(Ext.getCmp('appSubsystem').getValue())+'&graphType='+encodeURIComponent(no_params[2])+'&showGraph='+encodeURIComponent(no_params[2])+'&time_line=&starttime='+encodeURIComponent(starttime)+'&endtime='+encodeURIComponent(endtime)+'&starthr='+encodeURIComponent(starthour)+'&endhr='+encodeURIComponent(endhour)+'&format='+encodeURIComponent(dateFormatForTimeline)+'&host='+encodeURIComponent(componentName),isFlag)
								}
							}
							else if ( componentType == 'Oracle_server' )
							{
								if ( tmpDataArray['TAB_NAME'].toLowerCase() == 'at-a-glance' )
								{
									if ( subSystemVal.toLowerCase() == 'tablespaces' || subSystemVal.toLowerCase() == 'database access' )
									{
										var selectedInfo = "";
										var selectedTabName = 'oracletablespaces';
										if ( subSystemVal.toLowerCase() == 'database access' )
										{
											selectedTabName = 'oracleconnection';
										}
										URL = "/final/monitor/egOracleDashboardJSON.jsp?tab=Application&hostName="+encodeURIComponent(componentName)+"&compType="+encodeURIComponent(componentType)+"&tab="+tab+"&subsystem="+encodeURIComponent(subSystemVal)+"&subject="+encodeURIComponent(componentType)+"&selectedInfo="+encodeURIComponent(selectedInfo)+"&selectedTabName="+encodeURIComponent(selectedTabName);
									}
									else
									{
										URL = "/final/monitor/egDashboardOverviewJSON.jsp?tab=Application&hostName="+encodeURIComponent(componentName)+"&compType="+encodeURIComponent(componentType)+"&tab="+tab;
									}
									me.loadInnerTab(tmpDataArray['TAB_ID'], URL,isFlag);
								}
								else if ( tmpDataArray['TAB_NAME'].toLowerCase() == 'details' || tmpDataArray['TAB_NAME'].toLowerCase() == 'comparison' || tmpDataArray['TAB_NAME'].toLowerCase() == 'history' )
								{
									var timelineData = jsonData['TimelineWindow'];
									var timeline = timelineData[0]['selected'];
									var starttime = timelineData[1]['value'];
									var starthour = timelineData[2]['selected'];
									var endtime = timelineData[3]['value'];
									var endhour = timelineData[4]['selected'];
									URL = '/final/monitor/egDashboardHistoryJSON.jsp';
									var no_params= tmpDataArray['PARAMS'].split('|');

									me.loadInnerTab(tmpDataArray['TAB_ID'], URL+'?tab=Application&hostName='+encodeURIComponent(componentName)+'&compType='+encodeURIComponent(componentType)+'&subsystem='+encodeURIComponent(Ext.getCmp('appSubsystem').getValue())+'&graphType='+encodeURIComponent(no_params[2])+'&showGraph='+encodeURIComponent(no_params[2])+'&time_line=&starttime='+encodeURIComponent(starttime)+'&endtime='+encodeURIComponent(endtime)+'&starthr='+encodeURIComponent(starthour)+'&endhr='+encodeURIComponent(endhour)+'&format='+encodeURIComponent(dateFormatForTimeline)+'&host='+encodeURIComponent(componentName),isFlag);
								}
								else if ( tmpDataArray['TAB_NAME'].toLowerCase() == 'top queries' )
								{
									var selectedInfo = "";
									URL = "/final/monitor/egOracleDashboardJSON.jsp?tab=Application&hostName="+encodeURIComponent(componentName)+"&compType="+encodeURIComponent(componentType)+"&tab="+tab+"&subsystem="+encodeURIComponent(subSystemVal)+"&subject="+encodeURIComponent(componentType)+"&selectedInfo="+encodeURIComponent(selectedInfo)+"&selectedTabName=OracleHighUtilQueries&graphType="+encodeURIComponent('OracleHighUtilQueries');
									me.loadInnerTab(tmpDataArray['TAB_ID'], URL,isFlag);
								}
							}
							else if ( componentType == 'MS_sql_server' )
							{
								if ( tmpDataArray['TAB_NAME'].toLowerCase() == 'at-a-glance' )
								{
									if ( subSystemVal.toLowerCase() == 'overview' )
									{
										URL = "/final/monitor/egDashboardOverviewJSON.jsp";
										URL += "?"+"hostName="+encodeURIComponent(componentName)+"&compType="+encodeURIComponent(componentType)+"&tab="+tab
									}
									else if ( subSystemVal.toLowerCase() == 'sqldatabases' )
									{
										URL = "/final/monitor/egSQLDatabasesJSON.jsp";
										URL += "?"+"tab=Application&selectedInfo=null&hostName="+encodeURIComponent(componentName)+"&compType="+encodeURIComponent(componentType)+"&tab="+tab+"&selectedTabName=sqldatabases";
									}
									me.loadInnerTab(tmpDataArray['TAB_ID'], URL,isFlag);
								}
								else if ( tmpDataArray['TAB_NAME'].toLowerCase() == 'details' || tmpDataArray['TAB_NAME'].toLowerCase() == 'comparison' || tmpDataArray['TAB_NAME'].toLowerCase() == 'history' || tmpDataArray['TAB_NAME'].toLowerCase() == 'stacktrace' )
								{
									var timelineData = jsonData['TimelineWindow'];
									var timeline = timelineData[0]['selected'];
									var starttime = timelineData[1]['value'];
									var starthour = timelineData[2]['selected'];
									var endtime = timelineData[3]['value'];
									var endhour = timelineData[4]['selected'];
									URL = '/final/monitor/egDashboardHistoryJSON.jsp';
									var no_params= tmpDataArray['PARAMS'].split('|');
									if ( tmpDataArray['TAB_NAME'].toLowerCase() == 'stacktrace' )
									{
										URL = '/final/monitor/egSQLDatabasesJSON.jsp';
									}
									me.loadInnerTab(tmpDataArray['TAB_ID'], URL+'?tab=Application&hostName='+encodeURIComponent(componentName)+'&compType='+encodeURIComponent(componentType)+'&subsystem='+encodeURIComponent(Ext.getCmp('appSubsystem').getValue())+'&graphType='+encodeURIComponent(no_params[2])+'&showGraph='+encodeURIComponent(no_params[2])+'&time_line=&starttime='+encodeURIComponent(starttime)+'&endtime='+encodeURIComponent(endtime)+'&starthr='+encodeURIComponent(starthour)+'&endhr='+encodeURIComponent(endhour)+'&format='+encodeURIComponent(dateFormatForTimeline)+'&host='+encodeURIComponent(componentName)+'&selectedTabName=sqlprocess',isFlag);
								}
								else if ( tmpDataArray['TAB_NAME'].toLowerCase() ==  'top queries' )
								{
									URL = '/final/monitor/egSQLDatabasesJSON.jsp?tab=Application&hostName='+encodeURIComponent(componentName)+'&compType='+encodeURIComponent(componentType)+'&subsystem='+encodeURIComponent(Ext.getCmp('appSubsystem').getValue())+'&host='+encodeURIComponent(componentName)+'&graphType=sqlapps&selectedTabName=sqlapps';

									me.loadInnerTab(tmpDataArray['TAB_ID'], URL,isFlag);
								}
							}
							else if ( componentType == 'WebLogic_server' )
							{
								if ( tmpDataArray['TAB_NAME'].toLowerCase() == 'at-a-glance' )
								{
									if ( subSystemVal.toLowerCase() == 'overview' )
									{
										URL = "/final/monitor/egDashboardOverviewJSON.jsp";
										URL += "?"+"hostName="+encodeURIComponent(componentName)+"&compType="+encodeURIComponent(componentType)+"&tab="+tab;
									}
									else if ( subSystemVal.toLowerCase() == 'jvm' )
									{
										URL = "/final/monitor/egWeblogicDashboardJSON.jsp";
										URL += "?"+"hostName="+encodeURIComponent(componentName)+"&compType="+encodeURIComponent(componentType)+"&tab="+tab+"&graphType=JVM&threadType=&subsystem="+encodeURIComponent(subSystemVal);
									}
									else if ( subSystemVal.toLowerCase() == 'weblogic threads' )
									{
										var timelineData = jsonData['TimelineWindow'];
										var timeline = timelineData[0]['selected'];
										var starttime = timelineData[1]['value'];
										var starthour = timelineData[2]['selected'];
										var endtime = timelineData[3]['value'];
										var endhour = timelineData[4]['selected'];
										URL = '/final/monitor/egWeblogicDashboardJSON.jsp';
										var no_params= tmpDataArray['PARAMS'].split('|');

										URL += '?tab=Application&hostName='+encodeURIComponent(componentName)+'&compType='+encodeURIComponent(componentType)+'&subsystem='+encodeURIComponent(Ext.getCmp('appSubsystem').getValue())+'&graphType='+encodeURIComponent(no_params[2])+'&showGraph='+encodeURIComponent(no_params[2])+'&time_line=&starttime='+encodeURIComponent(starttime)+'&endtime='+encodeURIComponent(endtime)+'&starthr='+encodeURIComponent(starthour)+'&endhr='+encodeURIComponent(endhour)+'&format='+encodeURIComponent(dateFormatForTimeline)+'&host='+encodeURIComponent(componentName)+'&graphType=DDgraph&showGraph=DDgraph';
									}
									else if ( subSystemVal.toLowerCase() == 'weblogic service' )
									{
										URL = '/final/monitor/egWeblogicDashboardJSON.jsp?tab=Application&hostName='+encodeURIComponent(componentName)+'&compType='+encodeURIComponent(componentType)+'&subsystem='+encodeURIComponent(Ext.getCmp('appSubsystem').getValue())+'&host='+encodeURIComponent(componentName);
									}
									else if ( subSystemVal.toLowerCase() == 'weblogic databases' )
									{
										URL = '/final/monitor/egWeblogicDashboardJSON.jsp?tab=Application&hostName='+encodeURIComponent(componentName)+'&compType='+encodeURIComponent(componentType)+'&subsystem='+encodeURIComponent(Ext.getCmp('appSubsystem').getValue())+'&host='+encodeURIComponent(componentName)+'&subject='+encodeURIComponent(componentType)+'&selectedInfo=';
									}
									me.loadInnerTab(tmpDataArray['TAB_ID'], URL,isFlag);
								}
								else if ( tmpDataArray['TAB_NAME'].toLowerCase() == 'details' || tmpDataArray['TAB_NAME'].toLowerCase() == 'comparison' )
								{
									var timelineData = jsonData['TimelineWindow'];
									var timeline = timelineData[0]['selected'];
									var starttime = timelineData[1]['value'];
									var starthour = timelineData[2]['selected'];
									var endtime = timelineData[3]['value'];
									var endhour = timelineData[4]['selected'];
									URL = '/final/monitor/egDashboardHistoryJSON.jsp';
									var no_params= tmpDataArray['PARAMS'].split('|');

									me.loadInnerTab(tmpDataArray['TAB_ID'], URL+'?tab=Application&hostName='+encodeURIComponent(componentName)+'&compType='+encodeURIComponent(componentType)+'&subsystem='+encodeURIComponent(Ext.getCmp('appSubsystem').getValue())+'&graphType='+encodeURIComponent(no_params[2])+'&showGraph='+encodeURIComponent(no_params[2])+'&time_line=&starttime='+encodeURIComponent(starttime)+'&endtime='+encodeURIComponent(endtime)+'&starthr='+encodeURIComponent(starthour)+'&endhr='+encodeURIComponent(endhour)+'&format='+encodeURIComponent(dateFormatForTimeline)+'&host='+encodeURIComponent(componentName),isFlag);
								}
								else if ( tmpDataArray['TAB_NAME'].toLowerCase() == 'history' )
								{
									var timelineData = jsonData['TimelineWindow'];
									var timeline = timelineData[0]['selected'];
									var starttime = timelineData[1]['value'];
									var starthour = timelineData[2]['selected'];
									var endtime = timelineData[3]['value'];
									var endhour = timelineData[4]['selected'];
									URL = '/final/monitor/egDashboardHistoryJSON.jsp';
									var no_params= tmpDataArray['PARAMS'].split('|');
									me.loadInnerTab(tmpDataArray['TAB_ID'], URL+'?tab=Application&hostName='+encodeURIComponent(componentName)+'&compType='+encodeURIComponent(componentType)+'&subsystem='+encodeURIComponent(Ext.getCmp('appSubsystem').getValue())+'&graphType='+encodeURIComponent(no_params[2])+'&showGraph='+encodeURIComponent(no_params[2])+'&time_line=&starttime='+encodeURIComponent(starttime)+'&endtime='+encodeURIComponent(endtime)+'&starthr='+encodeURIComponent(starthour)+'&endhr='+encodeURIComponent(endhour)+'&format='+encodeURIComponent(dateFormatForTimeline)+'&host='+encodeURIComponent(componentName),isFlag);
								}
								else if ( tmpDataArray['TAB_NAME'].toLowerCase() == 'stacktrace' )
								{
									var timelineData = jsonData['TimelineWindow'];
									var timeline = timelineData[0]['selected'];
									var starttime = timelineData[1]['value'];
									var starthour = timelineData[2]['selected'];
									var endtime = timelineData[3]['value'];
									var endhour = timelineData[4]['selected'];
									URL = '/final/monitor/egWeblogicDashboardJSON.jsp';
									me.loadInnerTab(tmpDataArray['TAB_ID'], URL+'?tab=Application&hostName='+encodeURIComponent(componentName)+'&compType='+encodeURIComponent(componentType)+'&subsystem='+encodeURIComponent(Ext.getCmp('appSubsystem').getValue())+'&host='+encodeURIComponent(componentName)+'&graphType=jvmthreadstacktrace&selectedInfo=&info=&measure=',isFlag);
								}
								else if ( tmpDataArray['TAB_NAME'].toLowerCase() == 'stacktrace' )
								{
									var timelineData = jsonData['TimelineWindow'];
									var timeline = timelineData[0]['selected'];
									var starttime = timelineData[1]['value'];
									var starthour = timelineData[2]['selected'];
									var endtime = timelineData[3]['value'];
									var endhour = timelineData[4]['selected'];
									URL = '/final/monitor/egWeblogicDashboardJSON.jsp';
									me.loadInnerTab(tmpDataArray['TAB_ID'], URL+'?tab=Application&hostName='+encodeURIComponent(componentName)+'&compType='+encodeURIComponent(componentType)+'&subsystem='+encodeURIComponent(Ext.getCmp('appSubsystem').getValue())+'&host='+encodeURIComponent(componentName)+'&graphType=DDgraph&showGraph=DDgraph',isFlag);
								}
							}
							else if ( serverType == 'Java_virtual_machine' )
							{
								if ( tmpDataArray['TAB_NAME'].toLowerCase() == 'at-a-glance' )
								{
									if ( subSystemVal.toLowerCase() == 'overview' )
									{
										URL = "/final/monitor/egDashboardOverviewJSON.jsp";
										URL += "?"+"hostName="+encodeURIComponent(componentName)+"&compType="+encodeURIComponent(componentType)+"&tab="+tab+"&subsystem="+encodeURIComponent(subSystemVal);
										me.loadInnerTab(tmpDataArray['TAB_ID'], URL,isFlag);
									}
								}
								else if ( tmpDataArray['TAB_NAME'].toLowerCase() == 'details' || tmpDataArray['TAB_NAME'].toLowerCase() == 'comparison' )
								{
									var timelineData = jsonData['TimelineWindow'];
									var timeline = timelineData[0]['selected'];
									var starttime = timelineData[1]['value'];
									var starthour = timelineData[2]['selected'];
									var endtime = timelineData[3]['value'];
									var endhour = timelineData[4]['selected'];
									URL = '/final/monitor/egDashboardHistoryJSON.jsp';
									var no_params= tmpDataArray['PARAMS'].split('|');

									me.loadInnerTab(tmpDataArray['TAB_ID'], URL+'?tab=Application&hostName='+encodeURIComponent(componentName)+'&compType='+encodeURIComponent(componentType)+'&subsystem='+encodeURIComponent(Ext.getCmp('appSubsystem').getValue())+'&graphType='+encodeURIComponent(no_params[2])+'&showGraph='+encodeURIComponent(no_params[2])+'&time_line=&starttime='+encodeURIComponent(starttime)+'&endtime='+encodeURIComponent(endtime)+'&starthr='+encodeURIComponent(starthour)+'&endhr='+encodeURIComponent(endhour)+'&format='+encodeURIComponent(dateFormatForTimeline)+'&host='+encodeURIComponent(componentName),isFlag);
								}
								else if ( tmpDataArray['TAB_NAME'].toLowerCase() == 'history' )
								{
									var timelineData = jsonData['TimelineWindow'];
									var timeline = timelineData[0]['selected'];
									var starttime = timelineData[1]['value'];
									var starthour = timelineData[2]['selected'];
									var endtime = timelineData[3]['value'];
									var endhour = timelineData[4]['selected'];
									URL = '/final/monitor/egDashboardHistoryJSON.jsp';
									var no_params= tmpDataArray['PARAMS'].split('|');
									me.loadInnerTab(tmpDataArray['TAB_ID'], URL+'?tab=Application&hostName='+encodeURIComponent(componentName)+'&compType='+encodeURIComponent(componentType)+'&subsystem='+encodeURIComponent(Ext.getCmp('appSubsystem').getValue())+'&graphType='+encodeURIComponent(no_params[2])+'&showGraph='+encodeURIComponent(no_params[2])+'&time_line=&starttime='+encodeURIComponent(starttime)+'&endtime='+encodeURIComponent(endtime)+'&starthr='+encodeURIComponent(starthour)+'&endhr='+encodeURIComponent(endhour)+'&format='+encodeURIComponent(dateFormatForTimeline)+'&host='+encodeURIComponent(componentName),isFlag);
								}
								else if ( tmpDataArray['TAB_NAME'].toLowerCase() == 'thread analysis' )
								{
									URL = '/final/monitor/egSummaryJSON.jsp?tab=Application&subsystem='+encodeURIComponent('JVM Thread')+'&hostName='+encodeURIComponent(componentName)+'&compType='+encodeURIComponent(componentType)+'&info=&measure=&host='+encodeURIComponent(componentName);
									me.loadInnerTab(tmpDataArray['TAB_ID'], URL,isFlag);
								}
								else if ( tmpDataArray['TAB_NAME'].toLowerCase() == 'jvm memory' )
								{
									URL = '/final/monitor/egSummaryJSON.jsp?tab=Application&subsystem='+encodeURIComponent('JVM Memory')+'&hostName='+encodeURIComponent(componentName)+'&compType='+encodeURIComponent(componentType)+'&info=&measure=&host='+encodeURIComponent(componentName);
									me.loadInnerTab(tmpDataArray['TAB_ID'], URL,isFlag);
								}
							}
							else
							{
								if ( tmpDataArray['TAB_NAME'].toLowerCase() == 'at-a-glance' )
								{
									if ( subSystemVal.toLowerCase() == 'overview' )
									{
										URL = "/final/monitor/egDashboardOverviewJSON.jsp";
										URL += "?"+"hostName="+encodeURIComponent(componentName)+"&compType="+encodeURIComponent(componentType)+"&tab="+tab+"&subsystem="+encodeURIComponent(subSystemVal);
									}
								}
								else if ( tmpDataArray['TAB_NAME'].toLowerCase() == 'details' || tmpDataArray['TAB_NAME'].toLowerCase() == 'comparison' )
								{
									var timelineData = jsonData['TimelineWindow'];
									var timeline = timelineData[0]['selected'];
									var starttime = timelineData[1]['value'];
									var starthour = timelineData[2]['selected'];
									var endtime = timelineData[3]['value'];
									var endhour = timelineData[4]['selected'];
									URL = '/final/monitor/egDashboardHistoryJSON.jsp';
									var no_params= tmpDataArray['PARAMS'].split('|');

									me.loadInnerTab(tmpDataArray['TAB_ID'], URL+'?tab=Application&hostName='+encodeURIComponent(componentName)+'&compType='+encodeURIComponent(componentType)+'&subsystem='+encodeURIComponent(Ext.getCmp('appSubsystem').getValue())+'&graphType='+encodeURIComponent(no_params[2])+'&showGraph='+encodeURIComponent(no_params[2])+'&time_line=&starttime='+encodeURIComponent(starttime)+'&endtime='+encodeURIComponent(endtime)+'&starthr='+encodeURIComponent(starthour)+'&endhr='+encodeURIComponent(endhour)+'&format='+encodeURIComponent(dateFormatForTimeline)+'&host='+encodeURIComponent(componentName),isFlag);
								}
								else if ( tmpDataArray['TAB_NAME'].toLowerCase() == 'history' )
								{
									var timelineData = jsonData['TimelineWindow'];
									var timeline = timelineData[0]['selected'];
									var starttime = timelineData[1]['value'];
									var starthour = timelineData[2]['selected'];
									var endtime = timelineData[3]['value'];
									var endhour = timelineData[4]['selected'];
									URL = '/final/monitor/egDashboardHistoryJSON.jsp';
									var no_params= tmpDataArray['PARAMS'].split('|');
									me.loadInnerTab(tmpDataArray['TAB_ID'], URL+'?tab=Application&hostName='+encodeURIComponent(componentName)+'&compType='+encodeURIComponent(componentType)+'&subsystem='+encodeURIComponent(Ext.getCmp('appSubsystem').getValue())+'&graphType='+encodeURIComponent(no_params[2])+'&showGraph='+encodeURIComponent(no_params[2])+'&time_line=&starttime='+encodeURIComponent(starttime)+'&endtime='+encodeURIComponent(endtime)+'&starthr='+encodeURIComponent(starthour)+'&endhr='+encodeURIComponent(endhour)+'&format='+encodeURIComponent(dateFormatForTimeline)+'&host='+encodeURIComponent(componentName),isFlag);
								}
							}
							//me.loadInnerTab(tmpDataArray['TAB_ID'], URL+"?"+"hostName="+hostNameEncoded+"&compType="+hostTypeEncoded+"&tab="+tab);
						}
					}
				});

			}
		}
		if ( !Ext.isEmpty( tabArr ) )
		{
				subapplicationtabObj.add({
				xtype: 'scrolltabPanel',
				id: 'tabpanel',
				dataArray: URL,
				name: 'tabpanel',
				flex:1,
				layout:
				{
					type: 'fit',
					//align: 'stretch'
				},
				plain: false,
				border: false,
				frame: false,
				defaults:{
					border:true,
					frame:true
				},
				activeTab:appCurrentTabId,
				listeners:{

					render: function()
					{
						var getId = '';
						this.items.each(function(obj)
						{
			                obj.tab.on('click', function()
			                {
			                	getId = obj.id;
			                	appCurrentTabId = getId;
			                    if ( obj.tabName.toLowerCase() == 'history' && isDisableTrendComputation == false)
			                    {
			                    	Ext.getCmp('history-tool').show();
			                    	Ext.getCmp('calendar-tool').show();
			                    	Ext.getCmp('history-tool').show();
			                    	Ext.getCmp('summary-tool').show();
			                    	Ext.getCmp('area-tool').show();
			                    }
			                    else
			                    {
			                    	Ext.getCmp('history-tool').hide();
			                    	Ext.getCmp('calendar-tool').hide();
			                    	Ext.getCmp('history-tool').hide();
			                    	Ext.getCmp('summary-tool').hide();
			                    	Ext.getCmp('area-tool').hide();
			                    }
			                });
			            });
						this.tabBar.add(
							{
								xtype:'tbfill',
								id: 'tab-seperator'
							},
							{
								xtype: 'toolbar',
								width:27,
								hidden: true,
								id: 'calendar-tool',
								cls:'iconBg',
								height:21,
								margin:'0 50 0 0',
								dock: 'right',
								items:[
									{
										xtype: 'button',
										iconCls:'iconCalendar',
										id: 'calendar-btn',
										tooltip:'Calendar',
										hidden:true,
										afterrender: function ()
										{
											Ext.create('Ext.tip.ToolTip', {
												target: this.id,
												anchor: 'top',
												cls: 'yellowTip',
												trackMouse: true,
												html: 'Calendar'
											});
										},
										handler: function()
										{
											Ext.get('configModApp').animate({to: {'top':10},listeners:{ afteranimate:function(){
												Ext.get('configModApp').setStyle('left', '');
											}}}).show();
										},
										listeners:
										{
											'click': function()
											{
												var configModWn = Ext.get('configModApp');
												if(Ext.isEmpty(configModWn))
												{
													var tpl = new Ext.XTemplate('<div style="float:left;margin:4px 0px 0px 4px"><b>'+defSettingsLbl+'</b></div><div style="text-align:right;float:right;"><div class="iconClose3" id="closeSettingsApp"></div></div>');
													Ext.create('Ext.container.Container',
													{
														padding:'5 5 5 0',
														width: 560,
														style:{'position':'absolute'},
														id:'configModApp',
														cls:'configMode_popup',
														closeAction:'hide',
														//html:tpl.apply(),
														items:[
																{
																	xtype:'container',
																	cls:'configMode_popupArrow',
																	style:{'top':'-14px','left':'425px'}
																},
																{
																	xtype:'container',
																	html:tpl.apply(),
																	style:{'top':'0px','margin':'2px'}
																},
																{
																	xtype : 'applicationtimeline',
																	parent:this
																}
														],
														renderTo: 'tabpanel-body'
													});
												}
												else
												{
													configModWn.show();
												}
												Ext.getBody().on('click',function()
												{
													var configobj = Ext.get('configModApp');
													if ( configobj != null && configobj != undefined )
													{
														configobj.hide();
													}
													configobj.animate({duration: 500,to: {y: -500}});
												},null,{delegate:'#closeSettingsApp'});

												Ext.Ajax.request({
													url: URL,
													method: 'GET',
													async: false,
													success: function( response )
													{
														if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
														{
															var tmpJsonText = response.responseText;
															var tmpJsonData = Ext.decode( tmpJsonText );
															var timelineData = tmpJsonData['TimelineWindow'];
															var timeline = timelineData[0]['selected'];
															var starttime = timelineData[1]['value'];
															var starthour = timelineData[2]['selected'];
															var endtime = timelineData[3]['value'];
															var endhour = timelineData[4]['selected'];
															var erTimelineObj = Ext.getCmp('er_timeline');
															erTimelineObj.getStore().loadRawData(timelineData[0]['items']);
															var selTimeline = erTimelineObj.getValue();
															var startTimeObj = Ext.getCmp('er_stdate');
															var endTimeObj = Ext.getCmp('er_enddate');
															var startHrObj = Ext.getCmp('er_sthr');
															var endHrObj = Ext.getCmp('er_endhr');
															if(selTimeline!=null && selTimeline!="")
															{
																erTimelineObj.setValue(selTimeline);
																var startTimeVal = startTimeObj.getValue();
																var endTimeVal = endTimeObj.getValue();
																var startHrVal = startHrObj.getValue();
																var endHrVal = endHrObj.getValue();

																startTimeObj.setValue(startTimeVal);
																endTimeObj.setValue(endTimeVal);
																startHrObj.setValue(startHrVal);
																endHrObj.setValue(endHrVal);
															}
															else
															{
																erTimelineObj.setValue(timeline);
																startTimeObj.setValue(starttime);
																endTimeObj.setValue(endtime);
																startHrObj.setValue(starthour);
																endHrObj.setValue(endhour);
															}
														}
													}
												});
											},
											'afterrender': function( obj )
											{
												obj.addListener('loadTime');
											}
										}
									}
								]
							},
							{
								xtype: 'toolbar',
								id: 'history-tool',
								hidden: true,
								cls: 'iconBg',
								height: 21,
								ui:'footer',
								layout:'hbox',
								dock: 'right',
								items: [
									{
										xtype: 'button',
										id: 'history-bar',
										margin: '0 2 0 2',
										iconCls: 'iconLineChart',
										style: {
											background: 'none',
											border: '0px'
										},
										listeners: {
											afterrender: function () {
												Ext.create('Ext.tip.ToolTip', {
													target: this.id,
													anchor: 'top',
													cls: 'yellowTip',
													trackMouse: true,
													html: historyViewText
												});
											}
										},
										handler: function()
										{
											me.callView('measureGraph');
										}
									},{
										xtype:'tbseparator',
										margin: '2 2 0 2',
									}
								]
							},
							{
								xtype: 'toolbar',
								
								cls: 'iconBg',
								hidden: true,
								id: 'summary-tool',
								height: 21,
								ui:'footer',
								layout:'hbox',
								dock: 'right',
								items: [
									{
										xtype: 'button',
										iconCls: 'iconBarChart',
										margin: '0 2 0 2',
										style: {
											background: 'none',
											border: '0px'
										},
										listeners: {
											afterrender: function () {
												Ext.create('Ext.tip.ToolTip', {
													target: this.id,
													anchor: 'top',
													cls: 'yellowTip',
													trackMouse: true,
													html: summaryViewText
												});
											}
										},
										handler: function()
										{
											me.callView('summaryGraph');
										}
									},{
										xtype:'tbseparator',
										margin: '2 2 0 2',
									}
								]
							},
							{
								xtype: 'toolbar',
								width: 27,
								hidden: true,
								id: 'area-tool',
								cls: 'iconBg',
								height: 21,
								ui:'footer',
								ui:'footer',
								layout:'hbox',
								dock: 'right',
								items: [
									{
										xtype: 'button',
										iconCls: 'iconAreaChart',
										margin: '0 2 0 2',
										style: {
											background: 'none',
											border: '0px'
										},
										listeners: {
											afterrender: function () {
												Ext.create('Ext.tip.ToolTip', {
													target: this.id,
													anchor: 'top',
													cls: 'yellowTip',
													trackMouse: true,
													html:trendViewText
												});
											}
										},
										handler: function()
										{
											me.callView('trendGraph');
										}
									},
								]
							});
					},
					'afterrender': function()
					{
						/*var getTabName = Ext.getCmp(Ext.getCmp('tabpanel').getActiveTab().getId()).tabName;
						if ( getTabName.toLowerCase() == 'history' )
						{
							me.showTools();
						}*/
					},
					'click': function()
					{
						alert('I am clicking...');
					}
				},
				items: tabArr
			});
		}
		subapplicationtabObj.doLayout();
		subapplicationtabObj.show();
	},
	loadInnerTab: function( tabId, URL ,isFlag)
	{
		if(tabId == 'Application_trendGraph' || tabId == 'Application_summaryGraph' )
		{
			tabId='Application_measureGraph';
		}
		var appSubsystem = Ext.getCmp('appSubsystem').getValue();
		var serverType = subject;
		var me = this;
		var getTabObj = Ext.getCmp(tabId);
		if(isFlag == 'default')
		{
			getTabObj.removeAll();
		}
		//var defaultHeight = 0;
		//if ( !Ext.isEmpty( appSubsystem ) && appSubsystem.toLowerCase() != 'overview' )
		//{
			//defaultHeight = 133;
		//}
		//getTabObj.setHeight((Ext.getBody().getHeight()-265)+defaultHeight);
		var getEl = getTabObj.getEl();
		var getDataArray = getTabObj.dataArray;
		var tabName = getDataArray['TAB_NAME'];
		var jsonText = '', jsonData = '';
		getEl.mask(loadingLbl+"...","maskCenter");
		Ext.Ajax.request({
			url: URL+'&screenWidth='+(Ext.getBody().getViewSize().width)+'&screenHeight='+(Ext.getBody().getViewSize().height),
			method: 'POST',
			//timeout: ( 60 * 60 * 1000 ),
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					jsonText = response.responseText;
					getEl.unmask();
					jsonData = Ext.decode( jsonText );
					graphUrl = jsonData['hiddens'];
					appInnerPublicJSON = jsonData;
					if ( serverType == 'Citrix_server' || serverType == 'Citrix_XcXenApp_server')
					{
						if ( tabName.toLowerCase() == 'at-a-glance' )
						{
							if ( appSubsystem.toLowerCase() == 'overview' )
							{
								me.showAtAGlance( tabId, jsonData ,isFlag)
							}
							else if ( appSubsystem.toLowerCase() == 'citrixapplications' )
							{
								me.showCitrixApplicationsAtAGlance( tabId, jsonData ,isFlag);
							}
							else if ( appSubsystem.toLowerCase() == 'citrixusers' )
							{
								me.showCitrixUsersAtAGlance( tabId, jsonData ,isFlag );
							}
						}
						else if ( tabName.toLowerCase() == 'details' || tabName.toLowerCase() == 'comparison' )
						{
							me.showDetailsTab( tabId, jsonData ,isFlag)
						}
						else if ( tabName.toLowerCase() == 'history' )
						{
							me.showHistoryTab( tabId, jsonData ,isFlag);
						}
					}
					else if ( serverType == 'Oracle_server' )
					{
						if ( tabName.toLowerCase() == 'at-a-glance' )
						{
							if ( appSubsystem.toLowerCase() == 'overview' )
							{
								me.showAtAGlance( tabId, jsonData ,isFlag);
							}
							else if ( appSubsystem.toLowerCase() == 'tablespaces' )
							{
								me.showOracleTableSpaces( tabId, jsonData,isFlag);
							}
							else if ( appSubsystem.toLowerCase() == 'database access' )
							{
								me.showDataAccessAtAGlance( tabId, jsonData ,isFlag);
							}
						}
						else if ( tabName.toLowerCase() == 'details' || tabName.toLowerCase() == 'comparison' )
						{
							me.showDetailsTab( tabId, jsonData ,isFlag)
						}
						else if ( tabName.toLowerCase() == 'top queries' )
						{
							me.showTopQueries( tabId, jsonData ,isFlag);
						}
						else if ( tabName.toLowerCase() == 'history' )
						{
							me.showHistoryTab( tabId, jsonData ,isFlag);
						}
					}
					else if ( serverType == 'MS_sql_server' )
					{
						if ( tabName.toLowerCase() == 'at-a-glance' )
						{
							if ( appSubsystem.toLowerCase() == 'overview' )
							{
								me.showAtAGlance( tabId, jsonData ,isFlag);
							}
							else if ( appSubsystem.toLowerCase() == 'sqldatabases' )
							{
								me.showSQLAtAGlance( tabId, jsonData ,isFlag);
							}
						}
						else if ( tabName.toLowerCase() == 'details' || tabName.toLowerCase() == 'comparison' )
						{
							me.showDetailsTab( tabId, jsonData ,isFlag);
						}
						else if ( tabName.toLowerCase() == 'history' )
						{
							me.showHistoryTab( tabId, jsonData ,isFlag);
						}
						else if ( tabName.toLowerCase() == 'stacktrace' )
						{
							me.showStackTrace(tabId, jsonData ,isFlag);
						}
						else if ( tabName.toLowerCase() == 'top queries' )
						{
							me.showTopQueriesForSQL(tabId, jsonData ,isFlag);
						}
					}
					else if ( serverType == 'WebLogic_server' )
					{
						if ( tabName.toLowerCase() == 'at-a-glance' )
						{
							if ( appSubsystem.toLowerCase() == 'overview' )
							{
								me.showAtAGlance( tabId, jsonData ,isFlag)
							}
							else if ( appSubsystem.toLowerCase() == 'jvm' )
							{
								me.showJVMAtAGlance( tabId, jsonData ,isFlag);
							}
							else if ( appSubsystem.toLowerCase() == 'weblogic threads' )
							{
								me.showWebLogicThreadsAtAGlance( tabId, jsonData ,isFlag);
							}
							else if ( appSubsystem.toLowerCase() == 'weblogic service' )
							{
								me.showWebLogicServiceAtAGlance( tabId, jsonData ,isFlag);
							}
							else if ( appSubsystem.toLowerCase() == 'weblogic databases' )
							{
								me.showWebLogicDatabaseAtAGlance( tabId, jsonData ,isFlag);
							}
						}
						else if ( tabName.toLowerCase() == 'stacktrace' )
						{
							me.showJVMStackTrace( tabId, jsonData ,isFlag);
						}
						else if ( tabName.toLowerCase() == 'details' || tabName.toLowerCase() == 'comparison' )
						{
							me.showDetailsTab( tabId, jsonData ,isFlag);
						}
						else if ( tabName.toLowerCase() == 'history')
						{
							me.showHistoryTab( tabId, jsonData ,isFlag);
						}
					}
					else if ( serverType == 'Java_virtual_machine' )
					{
						if ( tabName.toLowerCase() == 'at-a-glance' )
						{
							if ( appSubsystem.toLowerCase() == 'overview' )
							{
								me.showAtAGlance( tabId, jsonData ,isFlag)
							}
						}
						else if ( tabName.toLowerCase() == 'details' || tabName.toLowerCase() == 'comparison' )
						{
							me.showDetailsTab( tabId, jsonData ,isFlag);
						}
						else if ( tabName.toLowerCase() == 'history' )
						{
							me.showHistoryTab( tabId, jsonData ,isFlag);
						}
						else if ( tabName.toLowerCase() == 'thread analysis' )
						{
							me.showJVMThreadAnalysis( tabId, jsonData ,isFlag);
						}
						else if ( tabName.toLowerCase() == 'jvm memory' )
						{
							me.showJVMThreadMemory( tabId, jsonData ,isFlag);
						}
					}
					else
					{
						if ( tabName.toLowerCase() == 'at-a-glance' )
						{
							if ( appSubsystem.toLowerCase() == 'overview' )
							{
								me.showAtAGlance( tabId, jsonData ,isFlag)
							}
						}
						else if ( tabName.toLowerCase() == 'details' || tabName.toLowerCase() == 'comparison' )
						{
							me.showDetailsTab( tabId, jsonData ,isFlag);
						}
						else if ( tabName.toLowerCase() == 'history' )
						{
							me.showHistoryTab( tabId, jsonData ,isFlag);
						}
					}
				}
			},
			failure: function()
			{
				//alert('I am in failure');
			}
		});
	},
	showJVMThreadMemory: function( tabId, resultData ,isFlag)
	{
		var me = this;
		var subSystemVal = Ext.getCmp('appSubsystem').getValue();
		//var defaultHeight = 0;
		//if ( !Ext.isEmpty( subSystemVal ) && subSystemVal.toLowerCase() != 'overview' )
		//{
		//	defaultHeight = 133;
		//}
		var getElObj = Ext.getCmp(tabId).getEl();
		var getPanelObj = Ext.getCmp(tabId);
		getPanelObj.setAutoScroll(true);
		if(isFlag == 'default')
		{
			getPanelObj.removeAll();
			
		}
	
		//getPanelObj.setHeight((Ext.getBody().getHeight()-265)+defaultHeight);
		//getPanelObj.setAutoScroll(true);
		getPanelObj.getEl().mask(loadingLbl+'...', 'maskCenter');
		if ( resultData['JVM_MEMORY'] != undefined )
		{
			var jvmMemory = resultData['JVM_MEMORY'];
			var title = jvmMemory['TITLE'];
			if(isFlag=='default')
			{
				getPanelObj.add({
						xtype: 'panel',
						title: title,
						id: 'memory-outer-panel',
						width: '100%',
						//margin:8,
						//cls:'datapanelWithoutShadow',
						border:true,
						frame:false,
						layout: 'hbox'
						//height: getPanelObj.getHeight()
					});
				getPanelObj.doLayout();
			}
			var panelObj = Ext.getCmp('memory-outer-panel');
			panelObj.removeAll();
			var heapAvail = false;
			var nonHeapAvail = false;
			if(jvmMemory['HEAP_VALUE']!=null && jvmMemory['HEAP_VALUE']!=undefined)
			{
				heapAvail = true;
			}
			if(jvmMemory['HEAP_VALUE']!=null && jvmMemory['HEAP_VALUE']!=undefined)
			{
				nonHeapAvail = true;
			}
			if ( jvmMemory['DATA'] == 'true' )
			{
				if(heapAvail || nonHeapAvail)
				{
					var heapMsg = heapMemTitle;
					var nonHeapMsg = nonHeapMemTitle;
					if(heapAvail)
					{
						heapMsg = heapMemTitle+'    -     '+jvmMemory['HEAP_VALUE']+" (%)";
					}
					if(nonHeapAvail)
					{
						nonHeapMsg = nonHeapMemTitle+'    -     '+jvmMemory['NON_HEAP_VALUE']+" (%)";
					}
					panelObj.add(
					{
						xtype: 'panel',
						//title: jvmMemory['monitor.dashboard.Heap']+'    -     '+jvmMemory['HEAP_VALUE']+" (%)",
						title:heapMsg,
						id: 'memory-heap-panel',
						width: '50%',
						cls:'datapanel optionalListPanel',
						border:false,
						frame:false,
						height:310,
						margin:10,
						layout: 'column',
						defaults:{
							columnWidth: 0.3
						}
						//height: getPanelObj.getHeight()+10
					},
					{
						xtype: 'panel',
						//title: jvmMemory['monitor.dashboard.Non Heap']+'    -     '+jvmMemory['NON_HEAP_VALUE']+" (%)",
						title:nonHeapMsg,
						id: 'memory-nonHeap-panel',
						width: '50%',
						height:310,
						cls:'datapanel optionalListPanel',
						border:false,
						frame:false,
						margin:10,
						layout: 'column',
						defaults:{
							columnWidth: 0.3
						}
						//height: getPanelObj.getHeight()+10
					}
				);
					var charts = jvmMemory['CHARTS'];
					if(heapAvail)
					{
						var heapObj = Ext.getCmp('memory-heap-panel');
						heapObj.removeAll();
						//heap layout
						for ( var i = 0; i < 3; i++ )
						{
							var getHeight = charts[i]['HEIGHT'];
							var getWidth = charts[i]['WIDTH'];
							var heading = charts[i]['HEADING'];
							var xmlData = charts[i]['XML_DATA'];
							if ( xmlData!=null && xmlData != undefined && xmlData!="-")
							{
								heapObj.add({
									xtype: 'container',
									layout: 'column',
									border:true,
									frame:true,
									flex:1,
									width: '100%',
									items:[{
										xtype: 'container',
										id: 'jvmMemory-Container-'+i,
										dataArray: charts[i],
										//cls:'optionalListPanel',
										//height: getHeight,
										height:210,
										width: getWidth,
										html: '<div style="text-align:center;width:100%;padding:4px 0px;" class="font_bold">'+heading+'</div> <div id="jvmMemory-Div-'+i+'" style="height:'+getHeight+'px;width:'+getWidth+'px;margin:2px 2px 12px 2px"></div>'
									}]
								});
							}
						}
						heapObj.doLayout();
						for ( var i = 0; i < 3; i++ )
						{
							var xmlData = charts[i]['XML_DATA'];
							//if ( xmlData != undefined )
							if ( xmlData!=null && xmlData != undefined && xmlData!="-")
							{
								var swfPath = charts[i]['SWF_PATH'];
								if ( FusionCharts('jvmLEDChart-'+i) )
								{
									FusionCharts('jvmLEDChart-'+i).dispose();
								}
								var myChart = new FusionCharts(swfPath,'jvmLEDChart-'+i, 180,190,'0','1');
								myChart.setXMLData(xmlData);
								myChart.setTransparent(true);
								myChart.render('jvmMemory-Div-'+i);
							}
							/*else
							{
								var getMsg = charts[i]['MSG'];
								Ext.get('jvmMemory-Div-'+i).update('<div class="iconExclamation" style="margin:0px 0px 0px 35%;"></div><div style="text-align:center;">'+getMsg+'</div>');
							}*/
						}
					}
					/*else
					{
						var heapObj = Ext.getCmp('memory-heap-panel');
						heapObj.layout ='fit';
						heapObj.add({
							xtype: 'container',
							id:'heapMemoryNoMeas',
							layout:'fit',
							flex:1,
							html: '<div style="text-align:center;width:100%;height:100%"><div class="iconExclamation" style="margin:14% 0px 0px 47%;"></div><div style="text-align:center;">'+noMeasureExcl+'</div></div>'
						});
						Ext.getCmp('memory-heap-panel').doComponentLayout();
					}*/
					if(nonHeapAvail)
					{
						//non heap layout
						var panelsNonHeapObj = Ext.getCmp('memory-nonHeap-panel');
						panelsNonHeapObj.removeAll();
						//var charts = jvmMemory['CHARTS'];
						for ( var i = 3; i < charts.length; i++ )
						{
							var getHeight = charts[i]['HEIGHT'];
							var getWidth = charts[i]['WIDTH'];
							var heading = charts[i]['HEADING'];
							var xmlData = charts[i]['XML_DATA'];
							if ( xmlData!=null && xmlData != undefined && xmlData!="-")
							{
								panelsNonHeapObj.add({
									xtype: 'container',
									layout: 'column',
									border:true,
									frame:true,
									flex:1,
									width: '100%',
									items:[{
										xtype: 'container',
										id: 'jvmMemory-Container-'+i,
										dataArray: charts[i],
										//height: getHeight,
										height:210,
										width: getWidth,
										html: '<div style="text-align:center;padding:4px 0px;width:100%" class="font_bold">'+heading+'</div><div id="jvmMemory-Div-'+i+'" style="height:'+getHeight+'px;width:'+getWidth+'px;margin:2px 2px 2px 2px"></div>'
									}]
								});
							}
						}
						panelsNonHeapObj.doLayout();
						for ( var i = 3; i < charts.length; i++ )
						{
							var xmlData = charts[i]['XML_DATA'];
							if ( xmlData!=null && xmlData != undefined && xmlData!="-")
							{
								var swfPath = charts[i]['SWF_PATH'];
								if ( FusionCharts('jvmLEDChart-'+i) )
								{
									FusionCharts('jvmLEDChart-'+i).dispose();
								}
								var myChart = new FusionCharts(swfPath,'jvmLEDChart-'+i, 180 , 190 ,'0','1');
								myChart.setXMLData(xmlData);
								myChart.setTransparent(true);
								myChart.render('jvmMemory-Div-'+i);
							}
							/*else
							{
								var getMsg = charts[i]['MSG'];
								Ext.get('jvmMemory-Div-'+i).update('<div class="iconExclamation" style="margin:0px 0px 0px 35%;"></div><div style="text-align:center;">'+getMsg+'</div>');
							}*/
						}
					}
				/*	else
					{
						var nonHeapObj = Ext.getCmp('memory-nonHeap-panel');
						nonHeapObj.layout ='fit';
						nonHeapObj.add({
							xtype: 'container',
							id:'nonHeapMemoryNoMeas',
							layout:'fit',
							flex:1,
							html: '<div style="text-align:center;width:100%;height:100%"><div class="iconExclamation" style="margin:14% 0px 0px 47%;"></div><div style="text-align:center;">'+noMeasureExcl+'</div></div>'
						});
						Ext.getCmp('memory-nonHeap-panel').doComponentLayout();
					}*/

					/*if ( jvmMemory['HEAP_AVAILABLE'] != undefined && jvmMemory['HEAP_AVAILABLE'] == 'true' )
					{
						var genHTML = '<table cellspacing="0" cellpadding="0" border="0" class="x-grid-table x-grid-table-resizer" width="100%">'
									 +'<tr class="x-grid-row">'
									 +'<td class=" x-grid-cell x-grid-cell-first" width="40%"><div class="x-grid-cell-inner">'+jvmMemory['monitor.dashboard.Heap']+'</div></td>'
									 +'<td class=" x-grid-cell x-grid-cell-first" width="10%"><div class="x-grid-cell-inner">'+jvmMemory['HEAP_VALUE']+'</div></td>'
									 +'<td class=" x-grid-cell x-grid-cell-first" width="40%"><div class="x-grid-cell-inner">'+jvmMemory['monitor.dashboard.Non Heap']+'</div></td>'
									 +'<td class=" x-grid-cell x-grid-cell-first" width="10%"><div class="x-grid-cell-inner">'+jvmMemory['NON_HEAP_VALUE']+'</div></td>'
						panelObj.add({
							xtype: 'container',
							width: '100%',
							columnWidth: 1.0,
							html: genHTML
						});
					}*/
				}
				else
				{
						panelObj.add({
							xtype: 'container',
							id:'jvmMemoryNoMeas',
							height: getPanelObj.getHeight()-50,
							width: '100%',
							html: '<div class="iconInformation" style="margin:12% 0px 0px 48%;"></div><div style="text-align:center;">'+noMeasureExcl+'</div>'
						});
				}
			}
			else
			{
				var getMsg = jvmMemory['MSG'];
				if(isFlag == 'default')
				{
					panelObj.add({
						xtype: 'container',
						id:'jvmMemoryNoID',
						height: getPanelObj.getHeight()-50,
						width: '100%',
						html: '<div class="iconInformation" style="margin:12% 0px 0px 48%;"></div><div style="text-align:center;">'+getMsg+'</div>'
					});
				}
				else if(Ext.getCmp('jvmMemoryNoID')!=null)
				{
					Ext.getCmp('jvmMemoryNoID').update('<div class="iconInformation" style="margin:12% 0px 0px 48%;"></div><div style="text-align:center;">'+getMsg+'</div>');
				}
				else
				{
					panelObj.add({
						xtype: 'container',
						id:'jvmMemoryNoID',
						height: getPanelObj.getHeight()-50,
						width: '100%',
						html: '<div class="iconInformation" style="margin:12% 0px 0px 48%;"></div><div style="text-align:center;">'+getMsg+'</div>'
					});
				}
			}
		}
		else
		{
			var getMsg = resultData['MSG'];
			if(isFlag == 'default')
			{
				getPanelObj.add({
					xtype: 'container',
					id:'jvmMemoryNoMeasureID',
					height: getPanelObj.getHeight(),
					html: '<div class="iconInformation" style="margin:0px 0px 0px 35%;"></div><div style="text-align:center;">'+noMeasure+'</div>'
				});
			}
			else if(Ext.getCmp('jvmMemoryNoMeasureID')!=null)
			{
				Ext.getCmp('jvmMemoryNoMeasureID').update('<div class="iconInformation" style="margin:0px 0px 0px 35%;"></div><div style="text-align:center;">'+noMeasure+'</div>');
			}
			else
			{	
				getPanelObj.add({
					xtype: 'container',
					id:'jvmMemoryNoMeasureID',
					height: getPanelObj.getHeight(),
					html: '<div class="iconInformation" style="margin:0px 0px 0px 35%;"></div><div style="text-align:center;">'+noMeasure+'</div>'
				});
			}
		}
		getPanelObj.doLayout();
		getPanelObj.getEl().unmask();
		appLastGraphTypeLoaded = 'JVMMemory';
	},
	showJVMThreadAnalysis: function( tabId, resultData ,isFlag)
	{
		var threadAnalysis = resultData['JVM_THREAD_ANALYSIS'];
		var stackTraceData = threadAnalysis['STACKTRACE'];
		var threadAnalysisCombo = threadAnalysis['threadTypeCombo'];
		var analysisBy = threadAnalysis['monitor.dashboard.Analysis By'];
		var me = this;
		var comboValue = '';
		var subSystemVal = Ext.getCmp('appSubsystem').getValue();
		var defaultHeight = 0;
		if ( !Ext.isEmpty( subSystemVal ) && subSystemVal.toLowerCase() != 'overview' )
		{
			//defaultHeight = 133;
		}
		var getElObj = Ext.getCmp(tabId).getEl();
		var getPanelObj = Ext.getCmp(tabId);
		if(isFlag=='default')
		{
			getPanelObj.removeAll();
			getPanelObj.add({
			xtype: 'container',
			id: 'jvmThreadOuterContainer',
			layout: 'vbox',
			border:true,
			//autoScroll: true,
			//height: getPanelObj.getHeight(),
			width: '100%',
			items:[{
				xtype: 'container',
				layout: 'hbox',
				id: 'jvmControlContainer',
				margin:'10 10 0 10',
				width: getPanelObj.getWidth()
				//height: 50
			},{
				xtype: 'container',
				layout: 'vbox',
				padding:'0 10 10 10',
				id: 'jvmResultContainer',
				//flex:1
				width: getPanelObj.getWidth()
			}]
		});
		getPanelObj.doLayout();
		}
		getPanelObj.setHeight((Ext.getBody().getHeight()-265)+defaultHeight);
		getPanelObj.setAutoScroll(true);
		getPanelObj.getEl().mask(loadingLbl+'...', 'maskCenter');
		
		if( stackTraceData!=null && stackTraceData!=undefined && !Ext.isEmpty(stackTraceData))
		{
			var imgSrc = stackTraceData['IMG_SRC'];
			var methodName =  stackTraceData['METHOD_NAME'];
			var params =  stackTraceData['PARAMS'];
			var timeVal =  stackTraceData['timeVal'];
		}
		var jvmControlContainerObj = Ext.getCmp('jvmControlContainer');
		jvmControlContainerObj.removeAll();
		if ( threadAnalysisCombo != undefined && analysisBy!=undefined)
		{
			jvmControlContainerObj.add(
			{
				xtype: 'combo',
				width: '30%',
				fieldLabel: analysisBy,
				id:'ThreadAnalysisBy',
				cls:'dropdown',
				name:'ThreadAnalysisBy',
				editable: false,
				labelAlign:'right',
				queryMode: 'local',
				labelSeparator:'',
				hidden:true,
				valueField: 'valueField',
				displayField: 'displayField',
				store:new Ext.data.Store({
					fields: ['valueField','displayField'],
					data:threadAnalysisCombo
				}),
				value: '',
				listeners:{
						'select': function( combo )
						{
							Ext.getCmp('jvmResultContainer').getEl().mask(loadingLbl+'...','maskCenter');
							Ext.Ajax.request({
								url: '/final/monitor/egSummaryJSON.jsp?tab=Application&subsystem='+encodeURIComponent(Ext.getCmp('appSubsystem').getValue())+'&hostName='+encodeURIComponent(componentName)+'&compType='+encodeURIComponent(componentType)+'&info=&measure=&host='+encodeURIComponent(componentName)+'&threadType='+encodeURIComponent(combo.getValue()),
								method: 'POST',
								success: function( response )
								{
									var tmpJsonText = response.responseText;
									if ( response.status == 200 && !Ext.isEmpty( tmpJsonText ) )
									{
										var tmpJsonData = Ext.decode(tmpJsonText);
										threadAnalysis = tmpJsonData['JVM_THREAD_ANALYSIS'];
										stackTraceData = threadAnalysis['STACKTRACE'];
										if ( stackTraceData!=null && stackTraceData!=undefined)
										{
											Ext.getCmp('stackeTraceId').stackTraceUrl=stackTraceData['PARAMS'];
										}
										me.showJVMThreadAnalysisResult(tabId, threadAnalysis);
									}
									Ext.getCmp('jvmResultContainer').getEl().unmask();
								}
							});
						},
						'afterrender': function()
						{
							this.setValue(threadAnalysisCombo[0]['valueField']);
						}
					}
			},
			{
				xtype:'container',
				id:'stackeTraceId',
				margin:'2 4 0 10',
				hidden:true,
				stackTraceUrl : params,
				html:'<a href="javascript:void(0)" data-qtip="'+stackTraceLbl+'" data-qclass="yellowTip"><img src='+imgSrc+' onclick="javascript:threadWindow(\''+timeVal+'\')"></a>'
			});
		}
		getPanelObj.getEl().unmask();
		if( threadAnalysis['DATA'] == 'true' )
		{
			var ThreadAnalysisBycont = Ext.getCmp('ThreadAnalysisBy');
			if (ThreadAnalysisBycont!=null && ThreadAnalysisBycont!= undefined)
			{
				ThreadAnalysisBycont.show();
			}
		}
		if( stackTraceData!=null && stackTraceData!=undefined && !Ext.isEmpty(stackTraceData))
		{
			var stackTraceCont = Ext.getCmp('stackeTraceId');
			if (stackTraceCont!=null && stackTraceCont!= undefined)
			{
				stackTraceCont.show();
			}
		}
		me.showJVMThreadAnalysisResult(tabId, threadAnalysis);
		jvmControlContainerObj.doLayout();
		appLastGraphTypeLoaded = 'JVMThread';
	},
	showJVMThreadAnalysisResult: function( tabId, threadAnalysis )
	{
		var getPanelObj = Ext.getCmp(tabId);
		var resultObj = Ext.getCmp('jvmResultContainer');
		resultObj.removeAll();
		var stackTraceCont = Ext.getCmp('stackeTraceId');
		if ( threadAnalysis['DATA'] == 'true' )
		{
			var datas = threadAnalysis['DATAS'];
			for ( var i = 0; i < datas.length; i++ )
			{
				var getTitle = datas[i]['TITLE'];
				var xmlData = datas[i]['XML_DATA'];
				var swfPath = datas[i]['SWF_PATH'];
				var getHeight = datas[i]['HEIGHT'];
				var getWidth = datas[i]['WIDTH'];
				var getLines = datas[i]['LINES'];
				resultObj.add({
					xtype: 'panel',
					id: 'jvm-thread-panel-'+i,
					dataArray: datas[i],
					width: '99%',
					border:true,
					frame:true,
					cls:'datapanel',
					margin:10,
					layout: 'hbox',
					title: getTitle,
					items:[
					{
						xtype: 'container',
						minHeight:185,
						width:500,
						html: '<div id="jvmThreadAnalysis-div-'+i+'" style="height:150px;width:400px;"></div>'
					},{
						xtype: 'container',
						width: '100%',
						margin:'0 0 10 0',
						html: '<div>'+getLines+'</div>'
					}]
				});

				resultObj.doLayout();
				if ( xmlData != '-' )
				{
						try
						{													
							var barChart = {};
							barChart = jQuery.extend(true, {}, getHighChartsBarInstance('jvmThreadAnalysis-div-'+i, 180, 550), barChart);
							barChart.setData(xmlData, currentDateFormat, '', 'jvmThreadPie');
							barChart.drawChart();
						}
						catch (barChartEx)
						{
							console.log(barChartEx);
						}
				}
			}
			if (stackTraceCont!=null && stackTraceCont!= undefined)
			{
				stackTraceCont.show();
			}
		}
		else
		{
			if (stackTraceCont!=null && stackTraceCont!= undefined)
			{
				stackTraceCont.hide();
			}
			var getMsg = threadAnalysis['MSG'];
			resultObj.add({
				xtype: 'container',
				height: getPanelObj.getHeight()-100,
				width:'100%',
				html: '<table width="100%" height="100%" style="text-align:center"><tr><td><div class="iconInformation" style="margin:0px auto 0px auto"></div><div>'+getMsg+'</div></td></tr></table>'
			});
			//Ext.getCmp('ThreadAnalysisBy').hide();
		}
		resultObj.doLayout();
		appLastGraphTypeLoaded = 'JVMThread';
	},
	showWebLogicDatabaseAtAGlance: function( tabId, resultData ,isFlag)
	{
		var me = this;
		var subSystemVal = Ext.getCmp('appSubsystem').getValue();
		var defaultHeight = 0;
		if ( !Ext.isEmpty( subSystemVal ) && subSystemVal.toLowerCase() != 'overview' )
		{
			defaultHeight = 133;
		}
		var getElObj = Ext.getCmp(tabId).getEl();
		var getPanelObj = Ext.getCmp(tabId);
		getPanelObj.removeAll();
		getPanelObj.setHeight((Ext.getBody().getHeight()-265)+defaultHeight);
		getPanelObj.setAutoScroll(true);
		var weblogicDatabases = resultData['WEBLOGIC_DATABASES'];
		if ( !Ext.isEmpty( weblogicDatabases ) )
		{
			if ( weblogicDatabases['DATA'] == 'true' )
			{
				me.createTreeView(getPanelObj);
				var treeData = weblogicDatabases['TREE'];
				if ( !Ext.isEmpty( treeData ) )
				{
					var treeContainerObj = Ext.getCmp('treeContainer');
					treeContainerObj.add(
						{
							xtype: 'treepanel',
							id: 'tree-panel',
							store: Ext.create('Ext.data.TreeStore', treeData),
			            	border:true,
							frame:true,
							collapsible: false,
							iconCls :'iconUser',
							header:{
								height:26
							},
							cls:'treeAccordionDesign', // treepanel done - oracle table space
						    height: treeContainerObj.getHeight()-5,
						    rootVisible: false,
							useArrows: true,
						    listeners:{
						    	'itemclick': function(obj, record, item, index)
						    	{
						    		var URL = record['raw']['URL'];
									if(URL!=null && URL!=undefined)
									{
						    		Ext.Ajax.request({
						    			url: URL,
						    			method: 'GET',
						    			success: function( response )
						    			{
						    				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
						    				{
						    					var tmpJsonText = response.responseText;
						    					var tmpJsonData = Ext.decode( tmpJsonText );
						    					var tmpWeblogicDatabasees = tmpJsonData['WEBLOGIC_DATABASES'];
													//console.log(response.responseText);
						    					me.showCenterViewForWebLogicDatabases(tmpWeblogicDatabasees);
						    				}
						    			}
						    		});
									}
									else
									{
										return;
									}
						    	},
								'afterrender': function()
								{
								    if(weblogicDatabases!=null && weblogicDatabases.hasOwnProperty('SELECTED_NODE') && weblogicDatabases.SELECTED_NODE!=null)
									{
										this.getSelectionModel().select(1);
									}
								}
						    }
						});
						treeContainerObj.doLayout();
						me.showCenterViewForWebLogicDatabases(weblogicDatabases);
				}
			}
			else
			{
				var getMsg = weblogicDatabases['MSG'];
				getPanelObj.update('<table width="100%" height="100%"><tr><td align="center"><div class="iconInformation"></div>'+getMsg+'</td></tr></table>');
			}
		}
		getPanelObj.doLayout();
		appLastGraphTypeLoaded="weblogic databases";
	},
	showCenterViewForWebLogicDatabases: function( weblogicDatabases )
	{
		var centerObj = Ext.getCmp('centerContainer');
		var getElObj = Ext.getCmp('centerContainer').getEl();
		getElObj.mask(loadingLbl+"...","maskCenter");
		centerObj.removeAll();
		centerObj.add({
				xtype: 'commonPanel',
				id: 'innerPanel',
				autoScroll: true,
				margin:'10 10 10 0',
				//height: ( Ext.getBody().getHeight() - 265 ) + 118,
				layout:
				{
					type: 'column'
				},
				defaults:{
					columnWidth: 0.25,
					margin:5,
				}
			});
		centerObj.doLayout();
		var innerPanelObj = Ext.getCmp('innerPanel');
		var measures = weblogicDatabases['MEASURES'];
		layerModelURL = weblogicDatabases['hiddens'];
		if ( measures != '-' )
		{
			for ( var i = 0; i < measures.length; i++ )
			{
				var getHeight = measures[i]['HEIGHT'];
				var getWidth = measures[i]['WIDTH'];
				var getTitle = measures[i]['TITLE'];
				var toolTipTitle = measures[i]['TOOLTIP_TITLE'];
				var testMeasure = measures[i]['TEST_MEASURE'];
				var imgSrc = measures[i]['IMG_SRC'];
				var imgTooltipTitle = measures[i]['IMG_TOOLTIP_TITLE'];
				var methodName = measures[i]['METHOD_NAME'];
				var params = measures[i]['PARAMS'];
				innerPanelObj.add({
					xtype: 'container',
					layout: 'vbox',
					align: 'stretch',
					items:[
						{
							xtype: 'label',
							margin:'0 0 5 0',
							html: '<div style="text-align:center;" title="'+toolTipTitle+'"><b>'+getTitle+'</b></div>'
						},
						{
							xtype: 'container',
							height: getHeight,
							width:'100%',
							html: '<div style="margin-left:10%;"><img src="'+imgSrc+'" height="'+getHeight+'px" width="'+getWidth+'px" title="'+imgTooltipTitle+'" style="cursor:pointer" onclick="javascript:wayToLayerModel(\''+params+'\');"/></div>'
						}]
				});
			}
		}
		else
		{
			var getMsg = weblogicDatabases['MSG'];
			innerPanelObj.add({
				xtype: 'container',
				columnWidth: 1,
				margin:0,
				padding:0,
				height: centerObj.getHeight()-25,
				//width: centerObj.getWidth(),
				html: ' <table width="100%" height="100%" style="text-align:center"><tr><td><div class="iconInformation" style="margin:0px auto 0px auto"></div><div>'+getMsg+'</div></td></tr></table>'
			});
		}
		innerPanelObj.doLayout();
		getElObj.unmask();
	},
	showWebLogicServiceAtAGlance: function( tabId, resultData ,isFlag)
	{
		var me = this;
		var subSystemVal = Ext.getCmp('appSubsystem').getValue();
		var defaultHeight = 0;
		if ( !Ext.isEmpty( subSystemVal ) && subSystemVal.toLowerCase() != 'overview' )
		{
			defaultHeight = 133;
		}
		var getElObj = Ext.getCmp(tabId).getEl();
		var getPanelObj = Ext.getCmp(tabId);
		getPanelObj.removeAll();
		getPanelObj.setHeight((Ext.getBody().getHeight()-265)+defaultHeight);
		getPanelObj.setAutoScroll(true);
		var weblogicServices = resultData['WEBLOGIC_SERVICE'];
		if ( weblogicServices != undefined )
		{
			var measures = weblogicServices['MEASURES'];
			for ( var i = 0; i < measures.length; i++ )
			{
				var getType = measures[i]['TYPE'];
				var getTitle = measures[i]['TITLE'];
				var adminPermission = measures[i]['ADMIN_PERMISSION'];
				var measure = measures[i]['MEASURE'];
				if ( getType == 'spark' )
				{
					if ( measure == 'true' )
					{
						var values = measures[i]['VALUES'];
						var genHTML = '<table cellspacing="0" cellpadding="0" border="0" class="x-grid-table x-grid-table-resizer" width="100%">';
						for ( var j = 0; j < values.length; j++ )
						{
							var tmpMeasures = values[j]['MEASURE'];
							var getHeight = values[j]['HEIGHT'];
							var getWidth = values[j]['WIDTH'];
							var xmlData = values[j]['XML_DATA'];
							var value = values[j]['VALUE'];
							genHTML += '<tr class="x-grid-row">'
									  +'<td class=" x-grid-cell x-grid-cell-first" width="35%"><div class="x-grid-cell-inner">'+tmpMeasures+'</div></td>'
									  +'<td class=" x-grid-cell x-grid-cell-first" width="50%"><div class="x-grid-cell-inner"><div style="width:100%" id="weblogicserviceSpark-'+i+'"></div></div></td>'
									  +'<td class=" x-grid-cell x-grid-cell-first" width="15%"><div class="x-grid-cell-inner">'+value+'</div></td>'
									  +'</tr>';
						}
						genHTML += '</table>';
						getPanelObj.add({
							xtype: 'panel',
							id: 'weblogicservicepanel',
							width: '100%',
							cls:'datapanel',
							margin:10,
							dataArray: values,
							title: getTitle,
							tools:[{
										xtype: 'button',
										iconCls: 'iconMaximize'
									}],
							html: genHTML
						});
						getPanelObj.doLayout();
						if ( Ext.getCmp('weblogicservicepanel') != undefined && Ext.getCmp('weblogicservicepanel').dataArray != undefined )
						{
							var tmpDataArray = Ext.getCmp('weblogicservicepanel').dataArray;
							for ( var k = 0; k < tmpDataArray.length; k++ )
							{
								var xmlData = tmpDataArray[k]['XML_DATA'];
								if ( xmlData != '-' )
								{
									var swfPath = tmpDataArray[k]['SWF_PATH'];
									if ( FusionCharts('chart-weblogicserviceSpark-'+k) )
									{
										FusionCharts('chart-weblogicserviceSpark-'+k).dispose();
									}
									var myChart = new FusionCharts(swfPath,'chart-weblogicserviceSpark-'+k, '100%', '100%','0','1');
									myChart.setXMLData(xmlData);
									myChart.setTransparent(true);
									myChart.render('weblogicserviceSpark-'+k);
								}
								else
								{
									var getMsg = tmpDataArray[k]['MSG'];
									Ext.get('weblogicserviceSpark-'+k).update('<div class="iconInformation" style="margin:5% 0px 0px 48%;"></div><div style="text-align:center;">'+getMsg+'</div>');
								}
							}
						}

					}
					else
					{
						var getMsg = measures[i]['MSG'];
						getPanelObj.add({
							xtype: 'panel',
							width: '100%',
							height: 200,
							cls:'datapanel',
							border:true,
							frame:true,
							margin:10,
							title: getTitle,
							//tools:[{
										//xtype: 'button',
										//iconCls: 'iconMaximize'
									//}],
							html: '<table width="100%" height="100%" style="text-align:center"><tr><td><div class="iconInformation" style="margin:0px auto 0px auto"></div><div>'+getMsg+'</div></td></tr></table>'
						});
					}
				}
				else if ( getType == 'grid' )
				{
					if ( measure == 'true' )
					{
						var values = measures[i]['VALUES'];
						var gridVals = measures[i]['GRID_VALUES'];
						var gridColArr = measures[i]['GRID_COLUMNS'];
						var genStoreModel = new Array();
						var colArr = new Array();
						for ( var i = 0; i < gridColArr.length; i++ )
						{
							genStoreModel[genStoreModel.length] = 'COLUMN_'+i;
							colArr.push({
								header: gridColArr[i],
								flex: 0.2,
								dataIndex: 'COLUMN_'+i
							});
						}

						getPanelObj.add({
							xtype: 'panel',
							id: 'weblogicservicepanel',
							width: '100%',
							dataArray: values,
							title: getTitle,
							cls:'datapanel',
							tools:[{
										xtype: 'button',
										iconCls: 'iconMaximize',
										style:{
											background:'none',
											border:0
											}
									}],
							items:[{
								xtype: 'grid',
								width: getPanelObj.getWidth(),
								height: Math.round( getPanelObj.getHeight()/2 ),
								autoScroll: true,
								cls:'gridSkin',
								store: new Ext.data.Store({
									fields: genStoreModel,
									data: gridVals
								}),
								columns: colArr
							}]
						});
					}
					else
					{
						var getMsg = measures[i]['MSG'];
						getPanelObj.add({
							xtype: 'panel',
							width: '100%',
							height: 200,
							cls:'datapanel',
							border:true,
							frame:true,
							margin:10,
							title: getTitle,
							//tools:[{
								//xtype: 'button',
								//iconCls: 'iconMaximize'
							//}],
							html: '<table width="100%" height="100%" style="text-align:center"><tr><td><div class="iconInformation" style="margin:0px auto 0px auto"></div><div>'+getMsg+'</div></td></tr></table>'
						});
					}
				}
				getPanelObj.doLayout();
				appLastGraphTypeLoaded="weblogic service";
			}
		}
	},
	showWebLogicThreadsAtAGlance: function( tabId, resultData ,isFlag)
	{
		var me = this;
		var subSystemVal = Ext.getCmp('appSubsystem').getValue();
		var defaultHeight = 0;
		if ( !Ext.isEmpty( subSystemVal ) && subSystemVal.toLowerCase() != 'overview' )
		{
			defaultHeight = 133;
		}
		var getElObj = Ext.getCmp(tabId).getEl();
		var getPanelObj = Ext.getCmp(tabId);
		getPanelObj.removeAll();
		getPanelObj.setHeight((Ext.getBody().getHeight()-265)+defaultHeight);
		//getPanelObj.setAutoScroll(true);
		getPanelObj.addCls('weblogicpanel');
		var webLogicThreads = resultData['WEBLOGIC_THREADS'];
		var measures = webLogicThreads['MEASURES'];
		for ( var i = 0; i < measures.length; i++ )
		{
			var getType = measures[i]['TYPE'];
			var data = measures[i]['DATA'];
			var getTitle = measures[i]['TITLE'];
			var adminPermission = measures[i]['ADMIN_PERMISSION'];
			var toolsArr = new Array();
			toolsArr.push({
									xtype: 'button',
									iconCls: 'iconMaximize'
								});
			var measure = measures[i]['MEASURE'];
			if ( data == 'true' )
			{
				if ( getType == 'grid' )
				{
					if ( measure == 'true' )
					{
						var gridVals = measures[i]['GRID_VALUES'];
						var gridColArr = measures[i]['GRID_COLUMNS'];
						var genStoreModel = new Array();
						var colArr = new Array();
						for ( var i = 0; i < gridColArr.length; i++ )
						{
							genStoreModel[genStoreModel.length] = 'COLUMN_'+i;
							colArr.push({
								header: gridColArr[i],
								flex: 0.2,
								dataIndex: 'COLUMN_'+i,
								renderer: function( val )
								{
									return '<div style="white-space:normal !important;word-wrap:break-word;">'+ val +'</div>';
								}
							});
						}
						getPanelObj.add({
							xtype: 'grid',
							width: getPanelObj.getWidth(),
							height: Math.round( getPanelObj.getHeight()/2 ),
							autoScroll: true,
							cls:'gridSkin',
							store: new Ext.data.Store({
								fields: genStoreModel,
								data: gridVals
							}),
							columns: colArr
						});
					}
					else
					{
						var getMsg = measures[i]['MSG'];
						getPanelObj.add({
							xtype: 'panel',
							width: getPanelObj.getWidth()-20,
							height: 220,
							cls:'datapanel',
							border:true,
							margin:'10 10 0 10',							
							frame:true,
							title: getTitle,
							html: '<table width="100%" height="100%" style="text-align:center"><tr><td><div class="iconInformation" style="margin:0px auto 0px auto"></div><div>'+getMsg+'</div></td></tr></table>'
						});
						getPanelObj.doLayout();
					}
				}
				else if ( getType = 'spark' )
				{
					if ( measure == 'true' )
					{
						var values = measures[i]['VALUES'];
						var genHTML = '<table cellspacing="0" cellpadding="0" border="0" class="x-grid-table x-grid-table-resizer" width="100%">';
						for ( var j = 0; j < values.length; j++ )
						{
							var tmpMeasures = values[i]['MEASURE'];
							var getHeight = values[i]['HEIGHT'];
							var getWidth = values[i]['WIDTH'];
							var xmlData = values[i]['XML_DATA'];
							var value = values[i]['VALUE'];
							genHTML += '<tr class="x-grid-row">'
									  +'<td class=" x-grid-cell x-grid-cell-first" width="35%"><div class="x-grid-cell-inner">'+tmpMeasures+'</div></td>'
									  +'<td class=" x-grid-cell x-grid-cell-first" width="50%"><div class="x-grid-cell-inner"><div style="width:100%" id="threadSpark-'+i+'"></div></div></td>'
									  +'<td class=" x-grid-cell x-grid-cell-first" width="15%"><div class="x-grid-cell-inner">'+value+'</div></td>'
									  +'</tr>';
						}
						genHTML += '</table>';
						getPanelObj.add({
							xtype: 'container',
							id: 'weblogicThreadPanel',
							dataArray: values,
							html: genHTML
						});
						if ( Ext.getCmp('weblogicThreadPanel') != undefined && Ext.getCmp('weblogicThreadPanel').dataArray != undefined )
						{
							var tmpDataArray = Ext.getCmp('weblogicThreadPanel').dataArray;
							for ( var k = 0; k < tmpDataArray.length; k++ )
							{
								var xmlData = tmpDataArray[k]['XML_DATA'];
								if ( xmlData != '-' )
								{
									var swfPath = tmpDataArray[k]['SWF_PATH'];
									if ( FusionCharts('weblogicthreadspark-'+k) )
									{
										FusionCharts('weblogicthreadspark-'+k).dispose();
									}
									var myChart = new FusionCharts(swfPath,'weblogicthreadspark-'+k, '100%', '100%','0','1');
									myChart.setXMLData(xmlData);
									myChart.setTransparent(true);
									myChart.render('threadSpark-'+k);
								}
								else
								{
									var getMsg = tmpDataArray[k]['MSG'];
									Ext.get('threadSpark-'+k).update('<div class="iconInformation" style="margin:5% 0px 0px 48%;"></div><div style="text-align:center;">'+getMsg+'</div>');
								}
							}
						}
					}
					else
					{
						var getMsg = measures[i]['MSG'];
						getPanelObj.add({
							xtype: 'panel',
							width: getPanelObj.getWidth(),
							height: 220,
							title: getTitle,
							html: '<div class="iconInformation" style="margin:5% 0px 0px 48%;"></div><div style="text-align:center;">'+getMsg+'</div>'
						});
						getPanelObj.doLayout();
				}
			}
			else
			{
				var getMsg = measures[i]['MSG'];
				getPanelObj.add({
					xtype: 'panel',
					width: getPanelObj.getWidth(),
							height: 220,
							title: getTitle,
							html: '<div class="iconInformation" style="margin:5% 0px 0px 48%;"></div><div style="text-align:center;">'+getMsg+'</div>'
						});
						getPanelObj.doLayout();
				}
			}
			else
			{
				var getMsg = measures[i]['MSG'];
				getPanelObj.add({
					xtype: 'panel',
					width: getPanelObj.getWidth(),
					height: 220,
					//tools: toolsArr,
					title: getTitle,
					html: '<table width="100%" height="100%"><tr><td align="center"><div class="iconInformation"></div>'+getMsg+'</td></tr></table>'
				});
				getPanelObj.doLayout();
				appLastGraphTypeLoaded="weblogic threads";
			}
		}
	},
	showJVMStackTrace: function( tabId, resultData ,isFlag)
	{
		var jvmStackTraceData = resultData['JVM_STACKTRACE'];
		var stackTrace = jvmStackTraceData['STACKTRACE'];
		var threadAnalysisCombo = jvmStackTraceData['threadAnalysisCombo'];
		var analysisByCombo = jvmStackTraceData['monitor.dashboard.Analysis By'];
		var me = this;
		var subSystemVal = Ext.getCmp('appSubsystem').getValue();
		var defaultHeight = 0;
		if ( !Ext.isEmpty( subSystemVal ) && subSystemVal.toLowerCase() != 'overview' )
		{
			defaultHeight = 133;
		}
		var getElObj = Ext.getCmp(tabId).getEl();
		var getPanelObj = Ext.getCmp(tabId);
		getPanelObj.removeAll();
		getPanelObj.setHeight((Ext.getBody().getHeight()-265)+defaultHeight);
		getPanelObj.setAutoScroll(true);
		getPanelObj.getEl().mask(loadingLbl+'...', 'maskCenter');
		getPanelObj.add({
			xtype: 'container',
			id: 'jvmStackTraceThreadOuterContainer',
			layout: 'vbox',
			border:true,
			//autoScroll: true,
			height: getPanelObj.getHeight(),
			width: '100%',
			items:[{
				xtype: 'container',
				layout: 'hbox',
				id: 'jvmStackTraceControlContainer',
				margin:'10 10 0 10',
				width: getPanelObj.getWidth()
				//height: 50
			},{
				xtype: 'container',
				layout: 'vbox',
				padding:'0 10 10 10',
				id: 'jvmStackTraceResultContainer',
				autoScroll:true,
				flex:1,
				width: getPanelObj.getWidth()
			}]
		});
		getPanelObj.doLayout();
		if ( stackTrace != undefined || stackTrace != null || !Ext.isEmpty(stackTrace))
		{
			var imgSrc = stackTrace['IMG_SRC'];
			var methodName =  stackTrace['METHOD_NAME'];
			var params =  stackTrace['PARAMS'];
			var timeVal = '';
		}
		var jvmSTControlContainerObj = Ext.getCmp('jvmStackTraceControlContainer');
		if ( threadAnalysisCombo != undefined && analysisByCombo!=undefined)
		{
			jvmSTControlContainerObj.add(
			{
				xtype: 'combo',
				width: '30%',
				fieldLabel: analysisByCombo,
				id:'ThreadAnalysisBy',
				cls:'dropdown',
				name:'ThreadAnalysisBy',
				editable: false,
				labelAlign:'right',
				queryMode: 'local',
				labelSeparator:'',
				valueField: 'valueField',
				displayField: 'displayField',
				store:new Ext.data.Store({
					fields: ['valueField','displayField'],
					data: threadAnalysisCombo
				}),
				value: '',
				listeners:{
						'select': function( combo )
						{
							Ext.getCmp('jvmStackTraceResultContainer').getEl().mask(loadingLbl+'...','maskCenter');
							Ext.Ajax.request({
								url: '/final/monitor/egWeblogicDashboardJSON.jsp?tab=Application&subsystem='+encodeURIComponent(Ext.getCmp('appSubsystem').getValue())+'&hostName='+encodeURIComponent(componentName)+'&compType='+encodeURIComponent(componentType)+'&info=&measure=&host='+encodeURIComponent(componentName)+'&threadType='+encodeURIComponent(combo.getValue())+'&graphType=jvmthreadstacktrace',
								method: 'POST',
								success: function( response )
								{
									var tmpJsonText = response.responseText;
									if ( response.status == 200 && !Ext.isEmpty( tmpJsonText ) )
									{
										var tmpJsonData = Ext.decode(tmpJsonText);
										var tmpStackTrace = tmpJsonData['JVM_STACKTRACE'];
										var stackTraceData = tmpJsonData['STACKTRACE'];
										if ( stackTraceData!=null && stackTraceData!=undefined)
										{
											Ext.getCmp('stackeTraceId').stackTraceUrl=stackTraceData['PARAMS'];
										}
										me.showJVMStackTraceResult(tabId, tmpStackTrace);
									}
									Ext.getCmp('jvmStackTraceResultContainer').getEl().unmask();
								}
							});
						},
						'afterrender': function()
						{
							this.setValue(threadAnalysisCombo[0]['valueField']);
						}
					}
			}
			
			);
		}

		if ( stackTrace != undefined && stackTrace != null && !Ext.isEmpty(stackTrace))
		{
			var imgSrc = stackTrace['IMG_SRC'];
			var methodName =  stackTrace['METHOD_NAME'];
			var params =  stackTrace['PARAMS'];
			var timeVal = '';
		
			jvmSTControlContainerObj.add({
				xtype: 'container',
				id: 'stackeTraceId',
				hidden: true,
				stackTraceUrl: params,
				margin: '2 4 0 10',
				html: '<a href="javascript:void(0)" data-qtip="StackTrace" data-qclass="yellowTip"><img src='+imgSrc+' onclick="javascript:threadWindow(\''+timeVal+'\')"></a>'
			});
		}
		getPanelObj.getEl().unmask();
		me.showJVMStackTraceResult(tabId, jvmStackTraceData);
		jvmSTControlContainerObj.doLayout();
		appLastGraphTypeLoaded="jvmthreadstacktrace";
	},
	showJVMStackTraceResult: function( tabId, jvmStackTraceData )
	{
		var getPanelObj = Ext.getCmp(tabId);
		var resultObj = Ext.getCmp('jvmStackTraceResultContainer');
		resultObj.removeAll();
		var stacktraceCont = Ext.getCmp('stackeTraceId');
		if ( jvmStackTraceData['DATA'] == 'true' )
		{
			var datas = jvmStackTraceData['DATAS'];
			for ( var i = 0; i < datas.length; i++ )
			{
				var getTitle = datas[i]['TITLE'];
				var xmlData = datas[i]['XML_DATA'];
				var swfPath = datas[i]['SWF_PATH'];
				var getHeight = datas[i]['HEIGHT'];
				var getWidth = datas[i]['WIDTH'];
				var getLines = datas[i]['LINES'];
				resultObj.add({
					xtype: 'panel',
					id: 'jvm-stackTrace-panel-'+i,
					dataArray: datas[i],
					width: '95%',
					border:true,
					frame:true,
					cls:'datapanel',
					margin:10,
					layout: 'hbox',
					title: getTitle,
					items:[
					{
						xtype: 'container',
						html: '<div id="jvmStackTrace-div-'+i+'" style="height:'+getHeight+'px;width:'+getWidth+'px;"></div>'
					},{
						xtype: 'container',
						width: '100%',
						margin:'0 0 10 0',
						html: '<div>'+getLines+'</div>'
					}]
				});
				resultObj.doLayout();
				if ( xmlData != '-' )
				{
					
					 /**
						if ( FusionCharts('jvmStackTraceChart'+i) )
						{
							FusionCharts('jvmStackTraceChart'+i).dispose();
						}
						var myChart = new FusionCharts(swfPath,'jvmStackTraceChart'+i, '100%', '100%','0','1');
						myChart.setXMLData(xmlData);
						myChart.setTransparent(true);
						myChart.render('jvmStackTrace-div-'+i);
						**/
						try
						{
							var barChart = {};
							barChart = jQuery.extend(true, {}, getHighChartsBarInstance('jvmStackTrace-div-'+i, 100, 225), barChart);
							barChart.setData(xmlData, currentDateFormat, '','pie');
							barChart.drawChart();
						}
						catch (barChartEx)
						{
							console.log(barChartEx);
						}
				}
			}
			if (stacktraceCont!=null && stacktraceCont!=undefined)
			{
				stacktraceCont.show();
			}
		}
		else
		{
			if (stacktraceCont!=null && stacktraceCont!=undefined)
			{
				stacktraceCont.hide();
			}
			var getMsg = jvmStackTraceData['MSG'];
			resultObj.add({
				xtype: 'container',
				height: getPanelObj.getHeight()-100,
				width:'100%',
				html: '<table width="100%" height="100%" style="text-align:center"><tr><td><div class="iconInformation" style="margin:0px auto 0px auto"></div><div>'+getMsg+'</div></td></tr></table>'
			});
		}
		resultObj.doLayout();
		appLastGraphTypeLoaded = 'jvmthreadstacktrace';
	},
	showJVMAtAGlance: function ( tabId, resultData ,isFlag)
	{
		var me = this;
		var subSystemVal = Ext.getCmp('appSubsystem').getValue();
		var defaultHeight = 0;
		if ( !Ext.isEmpty( subSystemVal ) && subSystemVal.toLowerCase() != 'overview' )
		{
			defaultHeight = 133;
		}
		var getElObj = Ext.getCmp(tabId).getEl();
		var getPanelObj = Ext.getCmp(tabId);
		getPanelObj.removeAll();
		getPanelObj.setHeight((Ext.getBody().getHeight()-265)+defaultHeight);
		getPanelObj.setAutoScroll(true);
		getPanelObj.add({
			xtype: 'container',
			id: 'jvmAtAGlanceCnt',
			width: '100%',
			//layout:'fit',
			layout:{
				type:'vbox',
				align:'stretch'
			},
			flex:1,
			//height: getPanelObj.getHeight(),
			//autoScroll: true,
			items:[{
				xtype: 'panel',
				id: 'rockitJVMCnt',
				title: '',
				//height: Math.round(getPanelObj.getHeight()/2),
				cls:'datapanel',
				margin:'10 10 0 10',
				padding:'10 0 10 0', 
				border:true,
				frame:true,
				layout: {
					type: 'column',
					align: 'stretch'
				},
				defaults:{
					columnWidth: 0.25
				},
				flex:0.5,
			},{
				xtype: 'panel',
				title: '',
				cls:'datapanel',
				margin:10,
				padding:10,
				border:true,
				frame:true,
				id: 'JVMDetailsCnt',
				layout:{
					type: 'hbox',
						align:'stretch'
				},
				defaults:{
					flex: 0.25,
					layout:{
						type: 'vbox',
						align:'stretch'
					}
					
				},
				//height:'100%',
				flex:0.5,
				//height: Math.round(getPanelObj.getHeight()/2)-30
			}]
		});
		getPanelObj.doLayout();
		getElObj.mask(loadingLbl+"...","maskCenter");
		var rockitJVMObj = Ext.getCmp('rockitJVMCnt');
		var jvmGlance = resultData['JVM_GLANCE'];
		
		if ( jvmGlance != undefined )
		{
			rockitJVMObj.setTitle(jvmGlance['ROCKIT_JVM_DETAILS_TITLE']);
			var healthData = jvmGlance['HEALTH'];
			if ( healthData != undefined )
			{
				var getTitle = healthData['TITLE'];
				var getHeight = healthData['HEIGHT'];
				var getWidth = healthData['WIDTH'];
				rockitJVMObj.add({
					xtype: 'container',
					//layout: 'vbox',
					items:[{
						xtype: 'container',
						id: 'heapUsageCnt',
						dataArray: healthData,
						height: getHeight,
						width: getWidth,
						html: '<div style="text-align:center;width:100%;margin:10px 10px 0 0px" class="font_bold">'+getTitle+'</div><div id="heapUsageDiv" style="height:'+getHeight+'px;width:'+getWidth+'px;margin:0px auto"></div>'
					}]
				});
				rockitJVMObj.doLayout();
				if ( Ext.getCmp('heapUsageCnt') != undefined && Ext.getCmp('heapUsageCnt').dataArray != undefined )
				{
					var tmpDataArray = Ext.getCmp('heapUsageCnt').dataArray;
					var xmlData = tmpDataArray['XML_DATA'];
					if ( xmlData != '-' )
					{
							try
							{
								var barChart = {};
								barChart = jQuery.extend(true, {}, getHighChartsBarInstance('heapUsageDiv', 145, 225), barChart);
								barChart.setData(xmlData, currentDateFormat, '','pie');
								barChart.drawChart();
							}
							catch (barChartEx)
							{
								console.log(barChartEx);
							}
					}
					else
					{
						var getMsg = tmpDataArray['MSG'];
						Ext.get('heapUsageDiv').update('<table width="100%" height="100%" style="text-align:center;margin-top: 4%"><tr><td><div class="iconInformation" style="margin:0px auto 0px auto"></div><div>'+getMsg+'</div></td></tr></table>');
					}
				}
			}

			var angularCharts = jvmGlance['ANGULAR_CHARTS'];
			if ( angularCharts != undefined )
			{
				for ( var i = 0; i < angularCharts.length; i++ )
				{
					var getTitle = angularCharts[i]['TITLE'];
					var getHeight = angularCharts[i]['HEIGHT']-20;
					var getWidth = angularCharts[i]['WIDTH']-40;
					
					rockitJVMObj.add({
						xtype: 'container',
						//style: {'border': '1px solid black'},
						cls:'last_border',
						layout: 'fit',
						items:[{
							xtype: 'container',
							id: 'percentHeapCnt-'+i,
							dataArray: angularCharts[i],
							height: getHeight+20,
							width: getWidth+40,
							html: '<div style="text-align:center;width:100%;margin:10px 10px 0 0px" class="font_bold">'+getTitle+'</div><div id="percentHeapDiv-'+i+'" style="height:'+getHeight+'px;width:'+getWidth+'px;"></div>'
						}]
					});
					rockitJVMObj.doLayout();
					if ( Ext.getCmp('percentHeapCnt-'+i) != undefined && Ext.getCmp('percentHeapCnt-'+i).dataArray != undefined )
					{
						var tmpDataArray = Ext.getCmp('percentHeapCnt-'+i).dataArray;
						var xmlData = tmpDataArray['XML_DATA'];
						if ( xmlData != '-' )
						{
							var swfPath = tmpDataArray['SWF_PATH'];
							getHighChartsGuage('percentHeapDiv-'+i,xmlData);
								
								/**
								if ( FusionCharts('percentHeapCnt-chart-'+i) )
								{
									FusionCharts('percentHeapCnt-chart-'+i).dispose();
								}

								FusionCharts.debugMode.enabled(true);
								FusionCharts.debugMode.outputTo(function () { console.log(arguments); });
								var myChart = new FusionCharts(swfPath,'percentHeapCnt-chart-'+i, '100%', '100%','0','1');
								myChart.setXMLData(xmlData);
								myChart.setTransparent(true);
								myChart.render('percentHeapDiv-'+i);
								**/
								
						
						}
						else
						{
							var getMsg = tmpDataArray['MSG'];
							Ext.get('percentHeapDiv-'+i).update('<table width="100%" height="100%" style="text-align:center;margin-top: 4%;"><tr><td><div class="iconInformation" style="margin:0px auto 0px auto"></div><div>'+getMsg+'</div></td></tr></table>');
						}
					}
				}
			}
			var digitalCharts = jvmGlance['DIGITAL_CHARTS'];
			if ( digitalCharts != undefined )
			{
				for ( var i = 0; i < digitalCharts.length; i++ )
				{
					var getTitle = digitalCharts[i]['TITLE'];
					var getHeight = digitalCharts[i]['HEIGHT'];
					var getWidth = digitalCharts[i]['WIDTH'];
					var getImgSrc = digitalCharts[i]['IMG_SRC'];
					if(getImgSrc=='/final/images/nomeasures_custom.gif')
					{
						rockitJVMObj.add({
						xtype: 'container',
						layout:{
							type: 'vbox',
							align: 'stretch'
						},	
						cls:'last_border',
						height:194,
						style:{'text-align':'center'},
						items:[{
							xtype: 'container',
//							id: 'percentHeapCnt-'+i,
							dataArray: angularCharts[i],
							height: getHeight,
							width: getWidth,
							html: '<div style="width:'+getWidth+'px;height:150px"><div style="text-align:center;width:100%;margin:15px 10px 0 0px" class="font_bold">'+getTitle+'</div><div><div class="iconInformation" style="margin:0px auto 0px auto;margin-top:20%"></div><div style="text-align:center">'+noMeasureExcl+'</div></div></div>'
						}]
					});
					}
					else
					{
					rockitJVMObj.add({
						xtype: 'container',
						layout:{
							type: 'vbox',
							align: 'stretch'
						},	
						cls:'last_border',
						height:194,
						style:{'text-align':'center'},
						items:[{
							xtype: 'container',
//							id: 'percentHeapCnt-'+i,
							dataArray: angularCharts[i],
							height: getHeight,
							width: getWidth,
							html: '<div style="text-align:center;width:100%;margin:10px 10px 20px 0px" class="font_bold">'+getTitle+'</div><div><img src="'+getImgSrc+'" height="'+getHeight+'px" width="'+getWidth+'px" /></div>'
							
						}]
					});
					}
					rockitJVMObj.doLayout();
				}
			}

			var JVMDetailsObj = Ext.getCmp('JVMDetailsCnt');
			var getJVMDetailsTitle = jvmGlance['JVM_DETAILS_TITLE'];
			JVMDetailsObj.setTitle(getJVMDetailsTitle);
			JVMDetailsObj.add({
				xtype: 'container',
				//layout: 'vbox',
				id: 'jvmHeapUsageCnt',
			},{
				xtype: 'container',
				id: 'jvmCPUUsageCnt',
				cls:'last_border',
			},{
				xtype: 'container',
				columnWidth: 0.5,
				//style:{'border':'1px solid red'},
				layout:{type:'fit',align:'stretch'},
				cls:'last_border',
				height:'100%',
			
				//type: 'vbox',
				//border:true,
				//frame:true,
				//margin:'10 0 0 10',
				
		        //align: 'center',
		        //pack: 'center',
				id: 'jvmThreadCnt'
			})
			JVMDetailsObj.doLayout();
			var jvmHeapUsageData = jvmGlance['JVM_HEAP_USAGE'];
			if ( jvmHeapUsageData != undefined )
			{
				var jvmHeapUsageObj = Ext.getCmp('jvmHeapUsageCnt');
				var getTitle = jvmHeapUsageData['TITLE'];
				var getHeight = Math.round(jvmHeapUsageData['HEIGHT']);
				var getWidth = Math.round(jvmHeapUsageData['WIDTH']);
				jvmHeapUsageObj.add({
					xtype: 'container',
					id: 'heapUsageCnt',
					dataArray: jvmHeapUsageData,
					html: '<div style="text-align:center;width:100%;margin:10px 10px 0 0px" class="font_bold">'+getTitle+'</div><div id="jvmheapUsageDiv" style="width:'+getWidth+'px;height:'+getHeight+'px;border:0px solid blue;"></div>'
				});
				jvmHeapUsageObj.doLayout();
				if ( jvmHeapUsageData['DATA'] == 'true' )
				{
					var tmpDataArray = Ext.getCmp('heapUsageCnt').dataArray;
					var xmlData = tmpDataArray['XML_DATA'];
					if ( xmlData != '-' )
					{
							try
							{
								var barChart = {};
								barChart = jQuery.extend(true, {}, getHighChartsBarInstance('jvmheapUsageDiv', 145, 225), barChart);
								barChart.setData(xmlData, currentDateFormat, '','pie');
								barChart.drawChart();
							}
							catch (barChartEx)
							{
								console.log(barChartEx);
						}
					}
					else
					{
						var getMsg = tmpDataArray['MSG'];
						Ext.get('jvmheapUsageDiv').update('<table width="100%" height="100%" style="text-align:center;margin-top: -6%;"><tr><td><div class="iconInformation" style="margin:0px auto 0px auto"></div><div>'+getMsg+'</div></td></tr></table>');
					}
				}
				else
				{
					var getMsg = jvmHeapUsageData['MSG'];
					Ext.get('jvmheapUsageDiv').update('<table width="100%" height="100%" style="text-align:center"><tr><td><div class="iconInformation" style="margin:0px auto 0px auto"></div><div>'+getMsg+'</div></td></tr></table>');
				}
			}
			var jvmCPUUsageCntObj = Ext.getCmp('jvmCPUUsageCnt');
			var jvmCPUUsageData = jvmGlance['JVM_CPU_USAGE'];
			if ( jvmCPUUsageData != undefined )
			{
				var getTitle = jvmCPUUsageData['TITLE'];
				var height = Math.round(jvmCPUUsageData['HEIGHT']-20);
				var width = Math.round(jvmCPUUsageData['WIDTH']-20);
				jvmCPUUsageCntObj.add({
					xtype: 'container',
					id: 'jvmUsageCon',
					dataArray: jvmCPUUsageData,
					html: '<div style="text-align:center;width:100%;margin:10px 10px 0 0px" class="font_bold">'+getTitle+'</div><div id="jvmCPUUsageDiv" style="height:'+height+'px;width:'+width+'px;"></div>'
				});
				if ( Ext.getCmp('jvmUsageCon') != undefined && Ext.getCmp('jvmUsageCon').dataArray )
				{
					var tmpDataArray = Ext.getCmp('jvmUsageCon').dataArray;
					var xmlData = tmpDataArray['XML_DATA'];
					if ( xmlData != '-' )
					{
						var swfPath = tmpDataArray['SWF_PATH'];
						/**if ( FusionCharts('jvmCPUUsageDivChart') )
						{
							FusionCharts('jvmCPUUsageDivChart').dispose();
						}
						var myChart = new FusionCharts(swfPath,'jvmCPUUsageDivChart', '100%', '100%','0','1');
						myChart.setXMLData(xmlData);
						myChart.setTransparent(true);
						myChart.render('jvmCPUUsageDiv');
						**/
						getHighChartsGuage('jvmCPUUsageDiv',xmlData);

					}
					else
					{
						var getMsg = tmpDataArray['MSG'];
						Ext.get('jvmCPUUsageDiv').update('<table width="100%" height="100%" style="text-align:center;margin-top: 7%"><tr><td><div class="iconInformation" style="margin:0px auto 0px auto"></div><div>'+getMsg+'</div></td></tr></table>');
					}
				}
				jvmCPUUsageCntObj.doLayout();
			}

			var jvmThreadCntObj = Ext.getCmp('jvmThreadCnt');
			var jvmThreadData = jvmGlance['JVM_THREAD'];
			if ( jvmThreadData != undefined )
			{
				var getTitle = jvmThreadData['TITLE'];
				jvmThreadCntObj.add({
					xtype: 'label',
					width: '100%',
					margin:0,
					html: '<div style="text-align:center;width:100%;margin:10px 10px 0 0px" class="font_bold">'+getTitle+'</div>'
				});
				jvmThreadCntObj.doLayout();
				if ( jvmThreadData['TEST_ENABLED'] == 'true' && jvmThreadData['DATA'] != 'false' )
				{
					var genHTML = '<table cellspacing="0" cellpadding="0" border="0" class="x-grid-table x-grid-table-resizer" width="100%">';
					var getDatas = jvmThreadData['VALUES'];
					
					if ( getDatas != undefined )
					{
						for ( var i = 0; i < getDatas.length; i++ )
						{
							var getTestMeasure = getDatas[i]['TEST_MEASURE'];
							var geHeight = getDatas[i]['HEIGHT'];
							var getWidth = getDatas[i]['WIDTH'];
							var getValue = getDatas[i]['VALUE'];
							genHTML += '<tr class="x-grid-row">'
									  +'<td class=" x-grid-cell x-grid-cell-first" width="35%"><div class="x-grid-cell-inner">'+getTestMeasure+'</div></td>'
									  +'<td class=" x-grid-cell x-grid-cell-first" width="50%"><div class="x-grid-cell-inner"><div style="width:100%" id="jvmspark-'+i+'"></div></div></td>'
									  +'<td class=" x-grid-cell x-grid-cell-first" width="15%"><div class="x-grid-cell-inner">'+getValue+'</div></td>'
									  +'</tr>';
						}
						genHTML += '</table>';

						jvmThreadCntObj.add({
								xtype: 'container',
								id: 'jvmSparkContainer',
								flex:1,
								scroll:true,
								height:200,
								autoScroll:true,
								layout:'fit',
								margin:'10 5 0 5',
								//style:{'border':'1px solid red'},
								dataArray: getDatas,
								html: genHTML
						});
						jvmThreadCntObj.doLayout();
						if ( Ext.getCmp('jvmSparkContainer') != undefined && Ext.getCmp('jvmSparkContainer').dataArray != undefined )
						{
							var tmpDataArray = Ext.getCmp('jvmSparkContainer').dataArray;
							for ( var i = 0; i < tmpDataArray.length; i++ )
							{
								var xmlData = tmpDataArray[i]['XML_DATA'];
								if ( xmlData != '-' )
								{
									var swfPath = tmpDataArray[i]['SWF_PATH'];
									if ( FusionCharts('jvmspark-chart-'+i) )
									{
										FusionCharts('jvmspark-chart-'+i).dispose();
									}
									var myChart = new FusionCharts(swfPath,'jvmspark-chart-'+i, '100', '20','0','1');
									myChart.setXMLData(xmlData);
									myChart.setTransparent(true);
									myChart.render('jvmspark-'+i);
								}
								else
								{
									Ext.get('jvmspark-'+i).update('&nbsp;');
								}
							}
						}
					}
				}
				else
				{
					var getMsg = jvmThreadData['MSG'];
					jvmThreadCntObj.add({
						xtype: 'container',
						html: '<table width="100%" height="100%" style="text-align:center"><tr><td><div class="iconInformation" style="margin:0px auto 0px auto"></div><div>'+getMsg+'</div></td></tr></table>'
					});
				}
				jvmThreadCntObj.doLayout();
			}
		}
		getElObj.unmask();
		appLastGraphTypeLoaded="JVM";
	},
	showTopQueriesForSQL: function( tabId, resultData ,isFlag)
	{
		var me = this;
		var subSystemVal = Ext.getCmp('appSubsystem').getValue();
		var defaultHeight = 0;
		if ( !Ext.isEmpty( subSystemVal ) && subSystemVal.toLowerCase() != 'overview' )
		{
			defaultHeight = 133;
		}
		var getElObj = Ext.getCmp(tabId).getEl();
		var getPanelObj = Ext.getCmp(tabId);
		getPanelObj.setHeight((Ext.getBody().getHeight()-265)+defaultHeight);
		getElObj.mask(loadingLbl+"...","maskCenter");
		var topQueries = resultData['TOP_QUERIES'];
		if ( !Ext.isEmpty( topQueries ) )
		{
			if ( topQueries['GRID'] != undefined && topQueries['GRID'] == 'true' )
			{
				var gridVals = topQueries['GRID_VALUES'];
				var gridColArr = topQueries['GRID_COLUMNS'];
				var genStoreModel = new Array();
				var colArr = new Array();
				for ( var i = 0; i < gridColArr.length; i++ )
				{
					var columnWidth = 65;
					if ( i == 0 || ( i == gridColArr.length - 1 ) )
					{
					//columnWidth = 170;
					}
					genStoreModel[genStoreModel.length] = 'COLUMN_'+i;
					colArr.push({
						header: gridColArr[i],
						minWidth: columnWidth,
						flex: 0.2,
						dataIndex: 'COLUMN_'+i,
						renderer: function( val )
						{
							return '<div style="white-space:normal !important;word-wrap:break-word;">'+ val +'</div>';
						}
					});
				}
				getPanelObj.add({
					xtype: 'customgrid',
					cls:'gridSkin',
					layout:'fit',
					width:'100%',
					store: new Ext.data.Store({
						fields: genStoreModel,
						data: gridVals
					}),
					columns: colArr
				});
			}
			else if ( topQueries['GRID'] == 'false' )
			{
				var getMsg = topQueries['MSG'];
				getPanelObj.add({
					xtype: 'container',
					border:true,
					height: getPanelObj.getHeight(),
					html: '<table width="100%" height="100%" style="text-align:center"><tr><td><div class="iconInformation" style="margin:0px auto 0px auto"></div><div>'+getMsg+'</div></td></tr></table>'
				});
			}
		}
		else if ( resultData['NO_DATA'] == 'true' )
		{
			var getMsg = resultData['MSG'];
			getPanelObj.add({
				xtype: 'container',
				border:true,
				width:'100%',
				height: getPanelObj.getHeight(),
				html: '<table width="100%" height="100%" style="text-align:center"><tr><td><div class="iconInformation" style="margin:0px auto 0px auto"></div><div>'+getMsg+'</div></td></tr></table>'
			});
		}
		getPanelObj.doLayout();
		getElObj.unmask();
		appLastGraphTypeLoaded="sqlapps";
	},
	showSQLAtAGlance: function( tabId, resultData )
	{
		var me = this;
		var subSystemVal = Ext.getCmp('appSubsystem').getValue();
		//var defaultHeight = 0;
		//if ( !Ext.isEmpty( subSystemVal ) && subSystemVal.toLowerCase() != 'overview' )
		//{
		//	defaultHeight = 133;
		//}
		var getElObj = Ext.getCmp(tabId).getEl();
		var getPanelObj = Ext.getCmp(tabId);
		//getPanelObj.setHeight((Ext.getBody().getHeight()-265)+defaultHeight);
		getElObj.mask(loadingLbl+"...","maskCenter");
		var sqlDatabases = resultData['SQL_DATABASES'];

		if ( !Ext.isEmpty( sqlDatabases ) )
		{
			var dbTransaction = sqlDatabases['DATABASE_TRANSACTION_USAGE'];
			var dbUsage = sqlDatabases['DATABASE_USAGE'];
			if( (dbTransaction['DATA'] !='false') || (dbUsage['DATA'] !='false'))
			{
				me.createTreeView(getPanelObj);
				var treeData = sqlDatabases['TREE'];

				if ( !Ext.isEmpty( treeData ) )
				{
					var treeContainerObj = Ext.getCmp('treeContainer');
					treeContainerObj.add(
						{
							xtype: 'treepanel',
							id: 'tree-panel',
							store: Ext.create('Ext.data.TreeStore', treeData),
							width: '100%',
							border:true,
							frame:true,
							iconCls :'iconDatabase',
							title:SQLNavigationLbl,
							collapsible: false,
							cls:'treePanelDesign', // treepanel done - sql database at-a-grance
							height: treeContainerObj.getHeight()-5,
							rootVisible: false,
							useArrows: true,
							listeners:{
								'itemclick': function(obj, record, item, index)
								{
									var URL = record['raw']['URL'];
									if(URL!=null && URL!=undefined)
									{
									Ext.Ajax.request({
										url: URL,
										method: 'GET',
										success: function( response )
										{
											if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
											{
												var tmpJsonText = response.responseText;
												var tmpJsonData = Ext.decode( tmpJsonText );
												var tmpDatabasees = tmpJsonData['SQL_DATABASES'];
												me.showCenterViewForSQLDatabases(tmpDatabasees);
											}
										}
									});
									}
									else
									{
										return;
									}
								},
									'afterrender': function()
									{
										if(sqlDatabases!=null && sqlDatabases.hasOwnProperty('SELECTED_NODE') && sqlDatabases.SELECTED_NODE!=null)
										{
											this.getSelectionModel().select(1);
										}
									}
							}
						});
						treeContainerObj.doLayout();
						me.showCenterViewForSQLDatabases(sqlDatabases);
				}
			}
			else if ( (dbTransaction['DATA'] =='false' && dbUsage['DATA'] =='false'))
			{
				var getMsg = dbTransaction['MSG'];				
				getPanelObj.add({
					xtype: 'container',
					width:'100%',
					height: getPanelObj.getHeight(),
					html: '<table width="100%" height="100%" style="text-align:center"><tr><td><div class="iconInformation" style="margin:0px auto 0px auto"></div><div>'+getMsg+'</div></td></tr></table>'
				});
				getPanelObj.doLayout();
			}
		}
		else if ( resultData['NO_DATA'] == 'true' )
		{
			var getMsg = resultData['MSG'];
			getPanelObj.add({
				xtype: 'container',
				width:'100%',
				height: getPanelObj.getHeight(),
				html: '<table width="100%" height="100%" style="text-align:center;"><tr><td><div class="iconInformation" style="margin:0px auto 0px auto"></div><div>'+getMsg+'</div></td></tr></table>'
			});
			getPanelObj.doLayout();
		}
		getElObj.unmask();
		appLastGraphTypeLoaded="sqldatabases";
	},
	showCenterViewForSQLDatabases: function(sqlDatabases)
	{
		var centerObj = Ext.getCmp('centerContainer');
		var getElObj = Ext.getCmp('centerContainer').getEl();
		getElObj.mask(loadingLbl+"...","maskCenter");
		centerObj.removeAll();
		centerObj.add({

				xtype: 'panel',
				id: 'innerPanel',
				autoScroll: true,
				border:false,
				frame:false,
			//	cls:'datapanelWithoutShadow',
				flex:1,
//				height: ( Ext.getBody().getHeight() - 265 ) + 118,
				//height: ( Ext.getBody().getHeight() - 180 ),
				layout:
				{
					type: 'column',
					align: 'stretch'
				},
				defaults:{
					columnWidth: 0.5,
					margin:10
				}
			});
		centerObj.doLayout();
		var innerPanelObj = Ext.getCmp('innerPanel');
		var databaseUsage = sqlDatabases['DATABASE_USAGE'];
		if ( !Ext.isEmpty( databaseUsage ) )
		{
			var getTitle = databaseUsage['TITLE'];
			if ( databaseUsage['DATA'] == 'true' )
			{
				var tpl = new Ext.XTemplate(
						'<div class="x-table" width="100%" class="borTop">',
						'<table cellspacing="0" cellpadding="0" border="0" class="x-grid-table x-grid-table-resizer" width="100%">',
						'<tbody>',
					    '<tpl for=".">',
					    '<tr class="x-grid-row">',
					        '<td class=" x-grid-cell x-grid-cell-first" width="50%" height="20px"><div class="x-grid-cell-inner">{COLUMN_0}</div></td>',
					        '<td class=" x-grid-cell x-grid-cell-first" width="50%"><div class="x-grid-cell-inner">{COLUMN_1}</div></td>',
					    '</tr>',
					    '</tpl>',
					    '</tbody>',
					    '</table>',
					    '</div>'
					);
				var tableValues = databaseUsage['TABLE_VALUES'];
				innerPanelObj.add({
					xtype: 'panel',
					title: getTitle,
					height: 200,
					padding:0,
					cls:'datapanel',
					border:true,
					frame:true,
					items:[
					{
						xtype: 'dataview',
						tpl: tpl,
						store: new Ext.data.Store({
							fields: ['COLUMN_0', 'COLUMN_1'],
							data: tableValues
						})

					}]
				});
			}
			else
			{
				var getMsg = databaseUsage['MSG'];
				innerPanelObj.add({
					xtype: 'panel',
					title: getTitle,
					padding:0,
					height: 200,
					cls:'datapanel',
					border:true,
					frame:true,
					html: '<table width="100%" height="100%" style="text-align:center"><tr><td><div class="iconInformation" style="margin:0px auto 0px auto"></div><div>'+getMsg+'</div></td></tr></table>'
				});
			}
			innerPanelObj.doLayout();

		}
		var databaseTransactUsage = sqlDatabases['DATABASE_TRANSACTION_USAGE'];
		if ( !Ext.isEmpty( databaseTransactUsage ) )
		{
			var getTitle = databaseTransactUsage['TITLE'];
			if ( databaseTransactUsage['DATA'] == 'true' )
			{
				var tpl = new Ext.XTemplate(
						'<div class="x-table" width="100%"  class="borTop">',
						'<table cellspacing="0" cellpadding="0" border="0" class="x-grid-table x-grid-table-resizer" width="100%">',
						'<tbody>',
					    '<tpl for=".">',
					    '<tr class="x-grid-row">',
					        '<td class=" x-grid-cell x-grid-cell-first" width="50%"><div class="x-grid-cell-inner">{COLUMN_0}</div></td>',
					        '<td class=" x-grid-cell x-grid-cell-first" width="50%"><div class="x-grid-cell-inner">{COLUMN_1}</div></td>',
					    '</tr>',
					    '</tpl>',
					    '</tbody>',
					    '</table>',
					    '</div>'
					);
				var tableValues = databaseTransactUsage['TABLE_VALUES'];
				innerPanelObj.add({
					xtype: 'panel',
					title: getTitle,
					height: 200,
					padding:0,
					cls:'datapanel',
					border:true,
					frame:true,
					items:[
					{
						xtype: 'dataview',
						tpl: tpl,
						store: new Ext.data.Store({
							fields: ['COLUMN_0', 'COLUMN_1'],
							data: tableValues
						})

					}]
				});
			}
			else
			{
				var getMsg = databaseTransactUsage['MSG'];
				innerPanelObj.add({
					xtype: 'panel',
					title: getTitle,
					cls:'datapanel',
					padding:0,
					border:true,
					frame:true,
					height: 200,
					html: '<table width="100%" height="100%" style="text-align:center"><tr><td><div class="iconInformation" style="margin:0px auto 0px auto"></div><div>'+getMsg+'</div></td></tr></table>'
				});
				innerPanelObj.doLayout();
			}
		}
		getElObj.unmask();
	},
	showStackTrace: function( tabId, resultData,isFlag )
	{
		var me = this;
		var subSystemVal = Ext.getCmp('appSubsystem').getValue();
		var defaultHeight = 0;
		if ( !Ext.isEmpty( subSystemVal ) && subSystemVal.toLowerCase() != 'overview' )
		{
			defaultHeight = 133;
		}
		var getElObj = Ext.getCmp(tabId).getEl();
		var getPanelObj = Ext.getCmp(tabId);
		getPanelObj.removeAll();
		getPanelObj.setHeight((Ext.getBody().getHeight()-265)+defaultHeight);
		getElObj.mask(loadingLbl+"...","maskCenter");
		if ( !Ext.isEmpty( resultData ) && resultData['SQL_TYPE'] != undefined && resultData['SQL_TYPE'].toLowerCase() == 'sqlprocess' )
		{
			

			var screenLabels = resultData['screenLabels'];
			var selectedValues = resultData['selectedValues'];
			var userCombo = resultData['userCombo'];
			var processCombo = resultData['processCombo'];
			var genHTML = '';
			if ( selectedValues['processSelected'].toLowerCase() == 'none' )
			{
				genHTML = '<table width="100%" height="100%" style="text-align:center"><tr><td><div class="iconInformation" style="margin:0px auto 0px auto"></div><div>'+noMeasureExcl+'</div></td></tr></table>';
			}

			var measureCombo = resultData['measureCombo'];
			var outerObjq = new Array();
			/*
			outerObj.removeAll();
			outerObjq.push();
			outerObj.doLayout();

			Ext.getCmp('resultContainer').removeAll();
			Ext.getCmp('resultContainer').update(genHTML); 
			*/
			
			var stackTraceArr = new Array();
			stackTraceArr.push({
				xtype: 'panel',
				id: 'outer-container',
				layout: 'vbox',
				border:false,
				frame:false,
				autoScroll:true,
				flex:1,
				width: '100%',
			//	title : 'testpanel',
				items : [{
				xtype: 'container',
				width: '100%',
				border:true,
				layout: {
					type: 'column',
					align: 'stretch'
				},
				defaults:
				{
					padding: 4,
					margin:5
					//columnWidth: 0.33
				},
				items:[
					{
					xtype: 'scrollcombo',
						fieldLabel:screenLabels['admin.auditlog.User'],
						id:'selectedUser',
					cls:'dropdown',
						name:'selectedUser',
					editable: false,
					labelAlign:'top',
					queryMode: 'local',
					labelSeparator:'',
					width:200,
					valueField: 'valueField',
					displayField: 'displayField',
					store:new Ext.data.Store({
						fields: ['valueField','displayField'],
							data: userCombo
					}),
						value: selectedValues['userInfoSelected'],
					listeners:{
							'select': function()
							{
								var reloadURL = resultData['URL'];
									var measureVal = Ext.getCmp('measure').getValue();
									if(reloadURL.indexOf('&s_measure') > 0 )
									{
										reloadURL = reloadURL.replace(/(s_measure=)[^\&]+/, '$1' + measureVal);	
									}
									else
									{
										reloadURL += "&s_measure="+Ext.getCmp('measure').getValue();
									}
									var selectedUser = Ext.getCmp('selectedUser').getValue();
									if(reloadURL.indexOf('&selectedUser') > 0 )
									{
										reloadURL = reloadURL.replace(/(selectedUser=)[^\&]+/, '$1' + selectedUser);	
									}
									else
									{
										reloadURL += "&selectedUser="+selectedUser;
									}
									reloadURL +="&subsystem="+Ext.getCmp('appSubsystem').getValue();
								Ext.Ajax.request({
									url: reloadURL,
									method: 'GET',
									success: function( response )
									{
										if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
										{
											var tmpJSONText = response.responseText;
											var tmpJSONData = Ext.decode( tmpJSONText );
											me.showStackTrace(tabId, tmpJSONData,isFlag);
											me.getSqlProcesses(tabId);
										}
									}
								});
							}
						}
				},
				{
					xtype: 'scrollcombo',
					fieldLabel: screenLabels['reporter.common.Processes'],
					id:'measure',
					cls:'dropdown',
					name:'measure',
					editable: false,
					labelAlign:'top',
					queryMode: 'local',
					labelSeparator:'',
					width:200,
					valueField: 'valueField',
					displayField: 'displayField',
					store:new Ext.data.Store({
						fields: ['valueField','displayField'],
						data: measureCombo
					}),
					value: selectedValues['measureSelected'],
					listeners:{
							'select': function()
							{
								var reloadURL = resultData['URL'];
								var measureVal = Ext.getCmp('measure').getValue();
								if(reloadURL.indexOf('&s_measure') > 0 )
								{
									reloadURL = reloadURL.replace(/(s_measure=)[^\&]+/, '$1' + measureVal);	
								}
								else
								{
									reloadURL += "&s_measure="+Ext.getCmp('measure').getValue();
								}
								reloadURL += "&subsystem="+Ext.getCmp('appSubsystem').getValue()+"&selectedUser="+Ext.getCmp('selectedUser').getValue();
								Ext.Ajax.request({
									url: reloadURL,
									method: 'GET',
									success: function( response )
									{
										if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
										{
											var tmpJSONText = response.responseText;
											var tmpJSONData = Ext.decode( tmpJSONText );
											me.showStackTrace(tabId, tmpJSONData,isFlag);
											me.getSqlProcesses(tabId);
										}
									}
								});
							}
						}
				},
				{
					xtype: 'scrollcombo',
						fieldLabel: 'Process ID',

							id: 'process',
							cls:'dropdown',
							name:'process',
							editable: false,
						labelAlign:'top',
							queryMode: 'local',
							labelSeparator:'',
							valueField: 'valueField',
							displayField: 'displayField',
							store:new Ext.data.Store({
								fields: ['valueField','displayField'],
								data: processCombo
							}),
							value: selectedValues['processSelected'],
							listeners:{
								'select': function()
								{
									me.getSqlProcesses(tabId);
								}
							}
					}]
			},{
				xtype: 'panel',
				layout: 'hbox',
				width: '100%',
				flex:1,
				border:true,
				items:[
				{
					xtype: 'container',
					id: 'resultContainer',
					width: '100%',
					height:'100%',
					margin:'8 8 8 8',
					border: true,
					frame:true,
					//style:{'border':'1px solid #c3c3c3','border-top':'0px !important'},
					cls:'datapanel',
					padding:0,
					flex:1,
					//html: genHTML,
					listeners: {
						afterrender: function() {
							me.getSqlProcesses(tabId);
						}
					}
				}]
				
			 }]
			});
			getPanelObj.add(stackTraceArr);
			getPanelObj.doLayout();
		}
		else if ( resultData['NO_DATA'] == 'true' )
		{
			var getMsg = resultData['MSG'];
			getPanelObj.add({
				xtype: 'container',
				height: getPanelObj.getHeight(),
				html: '<div class="iconInformation" style="margin:0px 0px 0px 45%;"></div><div style="text-align:center;">'+getMsg+'</div>'
			});
			getPanelObj.doLayout();
		}
		getElObj.unmask();
		appSQLLastLoadedURL = resultData['URL'];
		var measureVal = Ext.getCmp('measure').getValue();
		if(appSQLLastLoadedURL.indexOf('&s_measure') > 0 )
		{
			appSQLLastLoadedURL = appSQLLastLoadedURL.replace(/(s_measure=)[^\&]+/, '$1' + measureVal);	
		}
		else
		{
			appSQLLastLoadedURL += "&s_measure="+Ext.getCmp('measure').getValue();
		}
		var selectedUser = Ext.getCmp('selectedUser').getValue();
		if(appSQLLastLoadedURL.indexOf('&selectedUser') > 0 )
		{
			appSQLLastLoadedURL = appSQLLastLoadedURL.replace(/(selectedUser=)[^\&]+/, '$1' + selectedUser);	
		}
		else
		{
			appSQLLastLoadedURL += "&selectedUser="+selectedUser;
		}
		appSQLLastLoadedURL +="&subsystem="+Ext.getCmp('appSubsystem').getValue();
		appLastGraphTypeLoaded="sqlprocess";
	},
	getSqlProcesses: function(tabId)
	{
		var me = this;
		var measureValue = Ext.getCmp('measure').getValue();
		var processValue = Ext.getCmp('process').getValue();
		var userValue = Ext.getCmp('selectedUser').getValue();
		var resultObj = Ext.getCmp('resultContainer');
		var URL = '/final/monitor/sqlProcessJSON.jsp';
		var params = '&details='+encodeURIComponent(processValue)+'&measure='+encodeURIComponent(measureValue)+'&test=MsSqlConnsTest&selectedTabName=sqlprocess&selectedUser='+userValue;
		Ext.Ajax.request({
			url: URL+'?'+params,
//			params: params,
			method: 'GET',
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					var jsonData = Ext.decode( jsonText );
					if ( jsonData['DATA'] == 'false' )
					{
						var getMsg = jsonData['MSG'];
						var genHTML = '<table width="100%" height="100%" style="text-align:center"><tr><td><div class="iconInformation" style="margin:0px auto 0px auto"></div><div>'+getMsg+'</div></td></tr></table>';
						resultObj.removeAll();
						resultObj.update(genHTML);
					}
					else
					{
						var tableValues = jsonData['TABLE_VALUES'];
						var commandValues = jsonData['COMMAND'];

						var tpl = new Ext.XTemplate(
							'<div class="x-table" width="100%" class="borTop">',
							'<table cellspacing="0" cellpadding="0" border="0" class="x-grid-table x-grid-table-resizer" width="100%">',
							'<tbody>',
						    '<tpl for=".">',
						    '<tr class="x-grid-row">',
						        '<td class=" x-grid-cell x-grid-cell-first" width="50%"><div class="x-grid-cell-inner"><b>{COLUMN_0}</b></div></td>',
						        '<td class=" x-grid-cell x-grid-cell-first" width="50%"><div class="x-grid-cell-inner">{COLUMN_1}</div></td>',
						    '</tr>',
						    '</tpl>',
						    '</tbody>',
						    '</table>',
						    '</div>'
						);
						resultObj.removeAll();
						resultObj.add({
							xtype: 'dataview',
							tpl: tpl,
							store: new Ext.data.Store({
								fields: ['COLUMN_0', 'COLUMN_1'],
								data: tableValues
							})
						});
						resultObj.add({
							xtype: 'container',
							html: '<div class="x-table" width="100%">'
								  +'<table cellspacing="0" cellpadding="0" border="0" class="x-grid-table x-grid-table-resizer" width="100%">'
						    	  +'<tr class="x-grid-row">'
						          +'<td class=" x-grid-cell x-grid-cell-first" width="100%"><div class="x-grid-cell-inner"><b>'+commandValues['TEXT']+'</b></div></td>'
						          +'<td class=" x-grid-cell x-grid-cell-first" width="100%"><div class="x-grid-cell-inner">'+commandValues['VALUE']+'</div></td>'
						          +'</tr>'
						          +'</table>'
						          +'</div>'
						});
						resultObj.doLayout();
					}
				}
			}
		});
	},
	showTopQueries: function( tabId, resultData )
	{
		var me = this;
		var subSystemVal = Ext.getCmp('appSubsystem').getValue();
		var defaultHeight = 0;
		if ( !Ext.isEmpty( subSystemVal ) && subSystemVal.toLowerCase() != 'overview' )
		{
			defaultHeight = 133;
		}
		var getElObj = Ext.getCmp(tabId).getEl();
		var getPanelObj = Ext.getCmp(tabId);
		getPanelObj.removeAll();
		getPanelObj.setHeight((Ext.getBody().getHeight()-265)+defaultHeight);
		getElObj.mask(loadingLbl+"...","maskCenter");

		var databaseAccess = resultData['DATABASE_ACCESS'];
		if(databaseAccess!=null && !Ext.isEmpty( databaseAccess ))
		{
			var data = databaseAccess['DATA'];
			var oracleHighUtilQueries = databaseAccess['ORACLE_HIGH_UTIL_QUERIES'];
						
			var genXType = '';
			if ( data == 'true' )
			{
				if ( !Ext.isEmpty( oracleHighUtilQueries ) )
				{
					var data_available = oracleHighUtilQueries['DATA_AVAILABLE'];
					if(data_available==true)
					{
						var isGridAvailable = oracleHighUtilQueries['GRID'];
						if ( isGridAvailable == 'true' )
						{
							var gridColArr = oracleHighUtilQueries['GRID_COLUMNS'];
							var gridVals = oracleHighUtilQueries['GRID_VALUES'];
							var genStoreModel = new Array();
							var colArr = new Array();
							for ( var i = 0; i < gridColArr.length; i++ )
							{
								var columnWidth = 65;
								if ( i == 0 || ( i == gridColArr.length - 1 ) )
								{
									columnWidth = 170;
								}
								genStoreModel[genStoreModel.length] = 'COLUMN_'+i;
								colArr.push({
									header: gridColArr[i],
									minWidth: columnWidth,
									flex:0.2,
									dataIndex: 'COLUMN_'+i,
									renderer: function( val )
									{
										return '<div style="white-space:normal!important;word-wrap:break-word;">'+ val +'</div>';
									}
								});
							}
							genXType = {
								xtype: 'customgrid',
								width: getPanelObj.getWidth(),
								height: getPanelObj.getHeight(),
								autoScroll: true,
								layout:'fit',
								cls:'gridSkin',
								store: new Ext.data.Store({
									fields: genStoreModel,
									data: gridVals
								}),
								columns: colArr
							};
						}
						else
						{
							var getMsg = oracleHighUtilQueries['MSG'];
							var genHTML = '<table width="100%" height="100%" style="text-align:center"><tr><td><div class="iconInformation" style="margin:0px auto 0px auto"></div><div>'+getMsg+'</div></td></tr></table>'
							genXType = {
								xtype: 'container',
								width:'100%',
								flex:1,
								html: genHTML
							};
						}
					}
					else
					{
						var getMsg = oracleHighUtilQueries['MSG'];
						var genHTML = '<table width="100%" height="100%" style="text-align:center"><tr><td><div class="iconInformation" style="margin:0px auto 0px auto"></div><div>'+getMsg+'</div></td></tr></table>'
						genXType = {
							xtype: 'container',
							width:'100%',
							flex:1,
							html: genHTML
						};
					}
				}
			}
			else
			{
				var getMsg = databaseAccess['MSG'];
				var genHTML = '<table width="100%" height="100%" style="text-align:center"><tr><td><div class="iconInformation" style="margin:0px auto 0px auto"></div><div>'+getMsg+'</div></td></tr></table>'
				genXType = {
					xtype: 'container',
					width:'100%',
					flex:1,
					style:{'text-align':'center'},
					html: genHTML
				};
			}
		}
		getPanelObj.add(genXType);
		getPanelObj.doLayout();
		getElObj.unmask();
		appLastGraphTypeLoaded="OracleHighUtilQueries";
	},
	showDataAccessAtAGlance: function( tabId, resultData ,isFlag)
	{
		var me = this;
		var subSystemVal = Ext.getCmp('appSubsystem').getValue();
		var defaultHeight = 0;
		if ( !Ext.isEmpty( subSystemVal ) && subSystemVal.toLowerCase() != 'overview' )
		{
			defaultHeight = 133;
		}
		var getElObj = Ext.getCmp(tabId).getEl();
		var getPanelObj = Ext.getCmp(tabId);
		getPanelObj.setHeight((Ext.getBody().getHeight()-265)+defaultHeight);
		getPanelObj.setAutoScroll(true);
		getPanelObj.removeAll();
		getElObj.mask(loadingLbl+"...","maskCenter");
		if ( !Ext.isEmpty( resultData ) )
		{
			var databaseAccess = resultData['DATABASE_ACCESS'];
			if ( databaseAccess['DATA'] == 'true' )
			{
				me.createTreeView(getPanelObj);
				var treeData = databaseAccess['TREE'];
				if ( !Ext.isEmpty( treeData ) )
				{
					var treeContainerObj = Ext.getCmp('treeContainer');
					treeContainerObj.add(
						{
							xtype: 'treepanel',
							id: 'tree-panel',
							iconCls :'iconUser',
							store: Ext.create('Ext.data.TreeStore', treeData),
			            	width: '100%',
							title:oracleUsersNavigationsLbl,
							border:true,
							frame:true,
							collapsible: false,
							cls:'treePanelDesign', // treepanel done - oracle database access WithoutHeader
						    height: treeContainerObj.getHeight()+15,
						    rootVisible: false,
							useArrows: true,
						    listeners:{
						    	'itemclick': function(obj, record, item, index)
						    	{
						    		var URL = record['raw']['URL'];
									if(URL!=null && URL!=undefined)
									{
						    		Ext.Ajax.request({
						    			url: URL,
						    			method: 'GET',
						    			success: function( response )
						    			{
						    				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
						    				{
						    					var tmpJsonText = response.responseText;
						    					var tmpJsonData = Ext.decode( tmpJsonText );
						    					var tmpDatabaseAccess = tmpJsonData['DATABASE_ACCESS'];
						    					me.showCenterViewForDatabaseAccess(tmpDatabaseAccess);
						    				}
						    			}
						    		});
									}
									else
									{
										return;
									}
						    	},
								'afterrender': function()
								{
								    if(databaseAccess!=null && databaseAccess.hasOwnProperty('SELECTED_NODE') && databaseAccess.SELECTED_NODE!=null)
									{
										this.getSelectionModel().select(1);
									}
								}
						    }
						});
						treeContainerObj.doLayout();
						me.showCenterViewForDatabaseAccess(databaseAccess);
				}
			}
			else
			{
				var getMsg = databaseAccess['MSG'];
				getPanelObj.add({
					xtype: 'container',
					width:'100%',
					height: getPanelObj.getHeight(),
					html: '<table width="100%" height="100%" style="text-align:center"><tr><td><div class="iconInformation" style="margin:0px auto 0px auto"></div><div>'+getMsg+'</div></td></tr></table>'
				});
			}
			getPanelObj.doLayout();
		}
		getElObj.unmask();
		appLastGraphTypeLoaded="oracleconnection";
	},
	showCenterViewForDatabaseAccess: function( databaseAccess )
	{
		var centerObj = Ext.getCmp('centerContainer');
		var getElObj = Ext.getCmp('centerContainer').getEl();
		getElObj.mask(loadingLbl+"...","maskCenter");
		centerObj.removeAll();
		centerObj.add({

				xtype: 'panel',
				id: 'innerPanel',
				autoScroll: true,
				border:false,
				frame:false,
				//cls:'block1',  /*   jjjjjjjjjjjj */
				flex:1,
				//margin:'10 10 10 0',
//				height: ( Ext.getBody().getHeight() - 265 ) + 118,
				//height: ( Ext.getBody().getHeight() - 180 ),
				layout:
				{
					type: 'column',
					align: 'stretch'
				},
				defaults:{
					columnWidth: 0.5,
				}
			});
		centerObj.doLayout();
		var innerPanelObj = Ext.getCmp('innerPanel');
		if ( !Ext.isEmpty( databaseAccess ) )
		{
			var userConnections = databaseAccess['USER_CONNECTIONS'];
			if ( !Ext.isEmpty( userConnections ) )
			{
				var getTitle = userConnections['TITLE'];
				var tmpHeight = userConnections['HEIGHT'];
				var tmpWidth = userConnections['WIDTH'];
				var xmlData = userConnections['XML_DATA'];
				var genHTML = '';
				if ( xmlData != '-' )
				{
					//genHTML = '<div id="userConnectionDiv" style="height:'+tmpHeight+'px;width:'+tmpWidth+'px"></div>';
					genHTML = '<div id="userConnectionDiv"></div>';
				}
				else
				{
					var getMsg = userConnections['MSG'];
					genHTML = '<table width="100%" height='+tmpHeight+'px;"><tr><td style="text-align:center"><div class="iconInformation" style="margin:0 auto 0 auto"></div><div style="text-align:center;">'+getMsg+'</div></td></tr></table>'
				}
				innerPanelObj.add({
					xtype: 'panel',
					cls:'datapanel',
					padding:0,
					border:true,
					frame:true,
					margin:'10 10 10 0',
					title: getTitle,
					height: tmpHeight,
					width: tmpWidth,
					html: genHTML
				});
				innerPanelObj.doLayout();
				if ( xmlData != '-' )
				{
						try
						{
							var barChart = {};//
							barChart = jQuery.extend(true, {}, getHighChartsBarInstance('userConnectionDiv', 150, 250), barChart);
							barChart.setData(xmlData, currentDateFormat, '', 'pie');
							barChart.drawChart();
						}
						catch (barChartEx)
						{
							console.log(barChartEx);
						}
				}
			}
			var userSession = databaseAccess['USER_SESSIONS'];
			if ( !Ext.isEmpty( userSession ) )
			{
				var getTitle = userSession['TITLE'];
				var tmpHeight = userSession['HEIGHT'];
				var tmpWidth = userSession['WIDTH'];
				var xmlData = userSession['XML_DATA'];
				var genHTML = '';
				if ( xmlData != '-' )
				{
					//genHTML = '<div id="userSessionDiv" style="height:'+tmpHeight+'px;width:'+tmpWidth+'px"></div>';
					genHTML = '<div id="userSessionDiv"></div>';
				}
				else
				{
					var getMsg = userSession['MSG'];
					genHTML = '<table width="100%" height='+tmpHeight+'px;"><tr><td style="text-align:center"><div style="margin:0 auto 0 auto" class="iconInformation" ></div><div style="text-align:center;">'+getMsg+'</div></td></tr></table>'
				}
				innerPanelObj.add({
					xtype: 'panel',
					cls:'datapanel',
					padding:0,
					border:true,
					frame:true,
					title: getTitle,
					margin:'10 10 10 0',
					height: tmpHeight,
					width: tmpWidth,
					html: genHTML
				});
				innerPanelObj.doLayout();
				if ( xmlData != '-' )
				{
						try
						{
							var barChart = {};//
							barChart = jQuery.extend(true, {}, getHighChartsBarInstance('userSessionDiv', 150, 250), barChart);
							barChart.setData(xmlData, currentDateFormat, '', 'pie');
							barChart.drawChart();
						}
						catch (barChartEx)
						{
							console.log(barChartEx);
						}
				}
			}

			var userLocks = databaseAccess['USER_LOCKS'];

			if ( !Ext.isEmpty( userLocks ) )
			{
				var genHTML = '';
				var getTitle = userLocks['TITLE'];
				var genXType = '';
				if ( userLocks['DATA'] == 'true' )
				{
					var gridColArr = userLocks['GRID_COLUMNS'];
					var gridVals = userLocks['GRID_VALUES'];
					var genStoreModel = new Array();
					var colArr = new Array();
					for ( var i = 0; i < gridColArr.length; i++ )
					{
						genStoreModel[genStoreModel.length] = 'COLUMN_'+i;
						colArr.push({
							header: gridColArr[i],
							dataIndex: 'COLUMN_'+i,
							flex: 0.2
						});
					}
					genXType = {
						xtype: 'customgrid',
						layout:'fit',
						cls:'gridSkin',
						store: new Ext.data.Store({
							fields: genStoreModel,
							data: gridVals
						}),
						columns: colArr
					};
				}
				else
				{
					var getMsg = userLocks['MSG'];
					genHTML = '<table width="100%" height="120px"><tr><td style="text-align:center"><div style="margin:0 auto 0 auto" class="iconInformation" ></div><div style="text-align:center;">'+getMsg+'</div></td></tr></table>'
					genXType = {
						xtype: 'container',
						html: genHTML
					};
				}
				innerPanelObj.add({
					xtype: 'panel',
					cls:'datapanel',
					padding:0,
					border:true,
					margin:'0 10 10 0',
					frame:true,
					columnWidth: 1.0,
					title: getTitle,
					items: genXType
				});
				innerPanelObj.doLayout();
			}
		}
		getElObj.unmask();
	},
	showOracleTableSpaces: function( tabId, resultData ,isFlag)
	{
		var me = this;
		var subSystemVal = Ext.getCmp('appSubsystem').getValue();
		var defaultHeight = 0;
		if ( !Ext.isEmpty( subSystemVal ) && subSystemVal.toLowerCase() != 'overview' )
		{
			defaultHeight = 133;
		}
		var getElObj = Ext.getCmp(tabId).getEl();
		var getPanelObj = Ext.getCmp(tabId);
		getPanelObj.setHeight((Ext.getBody().getHeight()-265)+defaultHeight);
		getPanelObj.setAutoScroll(true);
		getPanelObj.removeAll();
		getElObj.mask(loadingLbl+"...","maskCenter");

		if ( !Ext.isEmpty( resultData ) )
		{
			var tableSpaces = resultData['TABLESPACES'];
			var getData = tableSpaces['DATA'];
			if ( getData == 'true' )
			{
				me.createTreeView(getPanelObj);
				var treeData = tableSpaces['TREE'];

					// To create a Tree View
				if ( !Ext.isEmpty( treeData ) )
				{
					var treeContainerObj = Ext.getCmp('treeContainer');
					treeContainerObj.add(
						{
							xtype: 'treepanel',
							id: 'tree-panel',
							iconCls :'iconTableSpace',
							store: Ext.create('Ext.data.TreeStore', treeData),
			            	width: '100%',
							title:oracleNavigationsLbl,
							border:true,
							frame:true,
							collapsible: false,
							cls:'treePanelDesign', // treepanel done - oracle table space WithoutHeader
						    height: treeContainerObj.getHeight()+15,
						    rootVisible: false,
							useArrows: true,
						    listeners:{
						    	'itemclick': function(obj, record, item, index)
						    	{
						    		var URL = record['raw']['URL'];
									if(URL!=null && URL!=undefined)
									{
						    		Ext.Ajax.request({
						    			url: URL,
						    			method: 'GET',
						    			success: function( response )
						    			{
						    				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
						    				{
						    					var tmpJsonText = response.responseText;
						    					var tmpJsonData = Ext.decode( tmpJsonText );
						    					var tmpTableSpaces = tmpJsonData['TABLESPACES'];
						    					me.showCenterView(tmpTableSpaces);
						    				}
						    			}
						    		});
									}
									else
									{
										return;
									}
						    	},
								'afterrender': function()
								{
								    if(tableSpaces!=null && tableSpaces.hasOwnProperty('SELECTED_NODE') && tableSpaces.SELECTED_NODE!=null)
									{
										this.getSelectionModel().select(1);
									}
								}
						    }
						});
						treeContainerObj.doLayout();
						me.showCenterView( tableSpaces );
				}
			}
			else
			{
				var getMsg = tableSpaces['MSG'];
				getPanelObj.setHeight(Ext.getBody().getHeight()-133);
				getPanelObj.add({
					xtype: 'container',
					border:true,
					width:'100%',
					height: getPanelObj.getHeight(),
					html: '<table width="100%" height="100%" style="text-align:center"><tr><td><div class="iconInformation" style="margin:0px auto 0px auto"></div><div>'+getMsg+'</div></td></tr></table>'
				})
			}
			getElObj.unmask();
			appLastGraphTypeLoaded="oracletablespaces";
		}
	},
	showCenterView: function( tableSpaces )
	{
		if ( !Ext.isEmpty( tableSpaces ) )
		{
			var centerObj = Ext.getCmp('centerContainer');
			var getElObj = Ext.getCmp('centerContainer').getEl();
			getElObj.mask(loadingLbl+"...", "maskCenter");
			centerObj.removeAll();
			centerObj.add({
				xtype: 'commonPanel',
				id: 'innerPanel',
				autoScroll: true,
				border:true,
				frame:false,
				cls:'datapanel',
				flex:1,
				margin:'8 8 8 0',
//				height: ( Ext.getBody().getHeight() - 265 ) + 118,
				//height: ( Ext.getBody().getHeight() - 180 ),

			});
			centerObj.doLayout();
			var header = tableSpaces['HEADER'];
			var innerPanelObj = Ext.getCmp('innerPanel');
			innerPanelObj.removeAll();
			innerPanelObj.setTitle(header);
			var chartArr = new Array();
			var angularData = tableSpaces['ANGULAR_CHARTS'];
			if ( !Ext.isEmpty( angularData ) )
			{
			//	chartArr.splice(0, chartArr.length);

				for ( var i = 0; i < angularData.length; i++ )
				{
					var tmpWidth = parseInt(angularData[i]['WIDTH']);
					var tmpHeight = parseInt(angularData[i]['HEIGHT']);
					var tmpTitle = angularData[i]['TITLE'];
					chartArr.push({
						xtype: 'container',
						border:true,
						//margin:5,
						style:{'text-align':'center'},
						//width: tmpWidth,
						//height: tmpHeight,
						id: 'tablespace-angular-'+i,
						items:[
							
							{
								xtype: 'container',
								html: '<div style="padding:0px 0px 5px 0px;margin:10px 10px 0 0px" class="font_bold">'+tmpTitle+'</div><div id="tablespace-angular-div-'+i+'" style="margin:0 auto 0 auto;height:'+(tmpHeight)+'px;width:'+tmpWidth+'px;"></div>'
							}
						]
					});
				}
				innerPanelObj.add({
					xtype: 'container',
					cls:'datapanel',
					margin:10,
					border:true,
					frame:true,
					//style:{'border':'1px solid #c3c3c3'},
					padding:0,
					layout:{
						type: 'column',
						align: 'stretch'
					},
					defaults:{
						columnWidth: 0.33
					},
					items:chartArr
				})
				//innerPanelObj.add(chartArr);
				innerPanelObj.doLayout();
				for ( var i = 0; i < angularData.length; i++ )
				{
					var xmlData = angularData[i]['XML_DATA'];
					if ( xmlData != '-' )
					{
							getHighChartsGuage('tablespace-angular-div-'+i,xmlData);
						}
					else
					{
						var getMsg = angularData[i]['MSG'];
						Ext.get('tablespace-angular-div-'+i).update('<div class="iconInformation" style="margin:10% 0px 0px 30%;"></div><div style="text-align:center;">'+getMsg+'</div>');
					}
				}
			}
			var digitalData = tableSpaces['DIGITAL_CHARTS'];
			if ( !Ext.isEmpty( digitalData ) )
			{
				chartArr.splice(0, chartArr.length);
				for ( var i = 0; i < digitalData.length; i++ )
				{
					var title = digitalData[i]['TITLE'];
					var toolTip = digitalData[i]['TOOLTIP_TITLE'];
					var tmpWidth = digitalData[i]['WIDTH'];
					var data = digitalData[i]['DATA'];
					var imgSrc = digitalData[i]['IMG_SRC'];
					var noMeasuresXType = '';
					if(imgSrc=='NoData')
					{
						chartArr.push({
						xtype: 'container',
						border:true,
						margin:5,
						style:{'text-align':'center'},
						items:[
							{
								xtype: 'label',
								html: '<div style="padding:0px 0px 5px 0px;"><b>'+title+'</b></div>'
							},
							{
								xtype: 'container',
								html: '<div class="iconInformation" style="margin:0px 0px 0px 35%;"></div><div style="text-align:center;">'+noMeasureExcl+'</div>'
							}
						]
					});
					}
					else
					{
					chartArr.push({
						xtype: 'container',
						border:true,
						margin:5,
						style:{'text-align':'center'},
						items:[
							{
								xtype: 'label',
								html: '<div style="padding:0px 0px 5px 0px;"><b>'+title+'</b></div>'
							},
							{
								xtype: 'container',
								html: '<div style="margin:0 auto 0 auto"><img src="'+imgSrc+'"/></div>'
							}
						]
					});
					}
				}
				innerPanelObj.add({
					xtype: 'container',
					cls:'datapanel',
					margin:10,
					border:true,
					frame:true,
					//style:{'border':'1px solid #c3c3c3'},
					padding:0,
					layout:{
						type: 'column',
						align: 'stretch'
					},
					defaults:{
						columnWidth: 0.25
					},
					height: parseInt(Ext.getCmp('innerPanel').getHeight() / 2.6),
					items: chartArr
				});
				innerPanelObj.doLayout();
			}
			getElObj.unmask();
		}
	},
	createTreeView: function( getPanelObj )
	{
		getPanelObj.removeAll();
		getPanelObj.add({
			xtype: 'container',
			height: getPanelObj.getHeight(),
			width: getPanelObj.getWidth(),
			layout: 'border',
			defaults: {
	            split: true
	        },
			items:[
				{
		            region: 'center',
					//autoScroll:true,
		           // height: getPanelObj.getHeight(),
		            width: '80%',
					flex:4,
					layout:'fit',
		            items:[
		            	{
		            		xtype: 'container',
							layout:'fit',
		            		id: 'centerContainer'
		            	}
		            ]
		        },{
		            region: 'west',
		          	split: true,
					collapseMode :'mini',
					collapsible: true,
		            width: '20%',
					flex:1,
					xtype: 'panel',
					header:false,
					margin:'8 0 8 8',
		            height: getPanelObj.getHeight(),
					id: 'treeContainer',
		           /* items:[ - jaiwin hide this
		            	{
		            		xtype: 'treepanel',
							cls:'treePanelDesign',
		            		height: getPanelObj.getHeight(),
		            		id: 'treeContainer'
		            	}
		            ]*/
		        }
			]
		});
		getPanelObj.doLayout();
	},
	showCitrixUsersAtAGlance: function( tabId, resultData ,isFlag)
	{
		var me = this;
		var subSystemVal = Ext.getCmp('appSubsystem').getValue();
		var defaultHeight = 0;
		if ( !Ext.isEmpty( subSystemVal ) && subSystemVal.toLowerCase() != 'overview' )
		{
			defaultHeight = 133;
		}
		var getElObj = Ext.getCmp(tabId).getEl();
		var getPanelObj = Ext.getCmp(tabId);
		getPanelObj.setHeight((Ext.getBody().getHeight()-265)+defaultHeight);
		getPanelObj.setAutoScroll(true);
		getPanelObj.removeAll();
		getElObj.mask(loadingLbl+"...", "maskCenter");
		var citrixUsers = resultData['CITRIX_USERS'];
		if ( !Ext.isEmpty( citrixUsers ) )
		{
			getPanelObj.add({
				xtype: 'container',
				layout:{type:'hbox',
					align:'stretch'},
				id: 'outer-panel',
				flex:1,

				//autoScroll:true,
				width: '100%'
			});
			getPanelObj.doLayout();
			var outerPanelObj = Ext.getCmp('outer-panel');
			if ( citrixUsers['NO_USERS'] != undefined && citrixUsers['NO_USERS'] == 'true' )
			{
				var getMsg = citrixUsers['MSG'];
				outerPanelObj.add({
					xtype: 'container',
					width: '100%',
					html: '<table width="100%" height="100%"><tr><td align="center"><div class="iconInformation"></div>'+getMsg+'</td></tr></table>'
				});
			}
			else
			{
				var treeStore = citrixUsers['TREE'];
				outerPanelObj.add({
					xtype: 'panel',
					layout: {
						type:'hbox',
					align:'stretch'},
					items:[
					{
						xtype: 'treepanel',
						layout:'fit',
						id: 'tree-panel',
						iconCls :'iconUser',
						store: Ext.create('Ext.data.TreeStore', treeStore),
						width:200,
						border:true,
						flex:1,

						margin:'5 0 5 5',
						frame:true,
						collapsible: false,
						cls:'treePanelDesign', // treepanel - citrix xenapp WithoutHeader
						//height: getPanelObj.getHeight()-5,
						rootVisible: false,
						useArrows: true,
					    listeners:{
					    	'itemclick': function(obj, record, item, index)
					    	{
					    		var URL = record['raw']['URL'];
								if(URL!=null && URL!=undefined)
								{
					    		Ext.Ajax.request({
					    			url: URL,
					    			method: 'GET',
					    			success: function( response )
					    			{
					    				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					    				{
					    					var tmpJsonText = response.responseText;
					    					var tmpJsonData = Ext.decode( tmpJsonText );
					    					var citrixUsers = tmpJsonData['CITRIX_USERS'];
					    					me.showCitrixSummary(citrixUsers);
					    				}
					    			}
					    		});
								}
								else
								{
									return;
								}
					    	},
								'afterrender': function()
								{
								    if(citrixUsers!=null && citrixUsers.hasOwnProperty('SELECTED_NODE') && citrixUsers.SELECTED_NODE!=null)
									{
										this.getSelectionModel().select(1);
									}
								}
					    }
					}
					]
				},{
					xtype: 'commonPanel',
					//width:Ext.getCmp('outer-panel').getWidth() - 200,
					id: 'right-panel',
					layout: {
						type:'vbox',
						align:'stretch'
					}

				});

				me.showCitrixSummary(citrixUsers);

			}
		}
		getElObj.unmask();
		appLastGraphTypeLoaded="citrixuser";

	},
	showCitrixSummary: function( citrixUsers )
	{
		var rightPanelObj = Ext.getCmp('right-panel');
		rightPanelObj.removeAll();
		rightPanelObj.add({
							xtype: 'container',
							id: 'angular-cylinder-chart',
							//style:{'border':'1px solid #c3c3c3'},
							layout: 'hbox',
							margin:10,
							//flex:1,

							width:'100%',
							defaults:{
							height:230
							},
							cls:'datapanel',
							border:true,
							frame:true
		});
		var chartPanelObj = Ext.getCmp('angular-cylinder-chart');
		var angularData = citrixUsers['ANGULAR'];

		chartPanelObj.removeAll();
		rightPanelObj.doComponentLayout();
		if ( !Ext.isEmpty( angularData ) )
		{
			var angularArr = new Array();
			for ( var i = 0; i < angularData.length; i++ )
			{
				var angularTitle = angularData[i]['TITLE'];
				var angularHeight = angularData[i]['HEIGHT'];
				var angularWidth = angularData[i]['WIDTH'];
				angularArr.push({
					xtype: 'container',
					//width: angularWidth+10,
					flex:.2,
					cls:'fancy_border',
					style:{'text-align':'center'},
					layout: 'vbox',
					items:[
						{
							xtype: 'container',
							margin:8,
							height:20,
							width:'100%',
							style:{'text-align':'center'},
							html: '<div style="text-align:center;"><b>'+angularTitle+'</b></div>'
						},
						{
							xtype: 'container',
							//margin:10,
							id: 'angular-'+i,
							flex:1,
							width:'100%',
							border:true,
							style:{'text-align':'center'},
							html: '<div id="angular-chart-'+i+'" style="margin:15px 0px 0px 0px;width:'+angularWidth+'px;height:'+angularHeight+'px;"></div>'
						}
					]
				});
			}
			chartPanelObj.add(angularArr);
			chartPanelObj.doLayout();
			for ( var i = 0; i < angularData.length; i++ )
			{
				var xmlData = angularData[i]['XML_DATA'];
				var swfPath = angularData[i]['SWF_PATH'];
				if ( FusionCharts('angularChart-'+i) )
				{
					FusionCharts('angularChart-'+i).dispose();
				}
				var myChart = new FusionCharts(swfPath,'angularChart-'+i, '100%', '100%','0','1');
				myChart.setXMLData(xmlData);
				myChart.setTransparent(true);
				myChart.render('angular-chart-'+i);
			}
		}
		var cylinderData = citrixUsers['CYLINDER'];
		if ( !Ext.isEmpty( cylinderData ) )
		{
			var cylinderArr = new Array();
			for ( var i = 0; i < cylinderData.length; i++ )
			{
				var cylinderTitle = cylinderData[i]['TITLE'];
				var cylinderHeight = cylinderData[i]['HEIGHT'];
				var cylinderWidth = cylinderData[i]['WIDTH'];
				cylinderArr.push({
					xtype: 'container',
					//width: cylinderWidth+10,
					flex:.16,
					cls:'fancy_border',
					style:{'text-align':'center'},
					layout: 'vbox',
					items:[
						{
							xtype: 'container',
							height:20,
							width:'100%',
							style:{'text-align':'center'},
							html: '<div style="margin:8px 0px 0px 10px;text-align:center;width:'+cylinderWidth+'px"><b>'+cylinderTitle+'</b></div>'
						},
						{
							xtype: 'container',
							id: 'cylinder-'+i,
							flex:1,
							width:'100%',
							border:true,
							style:{'text-align':'center'},
							html: '<div id="cylinder-chart-'+i+'" style="margin:49px 0px 0px 15px;width:'+cylinderWidth+'px;height:'+cylinderHeight+'px;border:0px solid red"></div>'
						}
					]
				});
			}
			chartPanelObj.add(cylinderArr);
			chartPanelObj.doLayout();
			for ( var i = 0; i < cylinderData.length; i++ )
			{
				var xmlData = cylinderData[i]['XML_DATA'];
				var swfPath = cylinderData[i]['SWF_PATH'];
				if ( xmlData != '-' )
				{
					if ( FusionCharts('cylinderChart-'+i) )
					{
						FusionCharts('cylinderChart-'+i).dispose();
					}
					var myChart = new FusionCharts(swfPath,'cylinderChart-'+i, '100%', '100%','0','1');
					myChart.setXMLData(xmlData);
					myChart.setTransparent(true);
					myChart.render('cylinder-chart-'+i);
				}
				else
				{
					var getMsg = cylinderData[i]['MSG'];
					Ext.get('cylinder-chart-'+i).update('<div class="iconInformation" style="margin:0px 0px 0px 35%;"></div><div style="text-align:center;">'+getMsg+'</div>');
				}
			}
		}
		var citrixUserSessionSummary = citrixUsers['CITRIX_USER_SESSION_SUMMARY'];
		if ( !Ext.isEmpty( citrixUserSessionSummary ) )
		{
			var tpl = new Ext.XTemplate(
						'<div class="x-table" width="100%"  class="borTop">',
						'<table cellspacing="0" cellpadding="0" border="0" class="x-grid-table x-grid-table-resizer" width="100%">',
						'<tbody>',
					    '<tpl for=".">',
					    '<tr class="x-grid-row">',
					        '<td class=" x-grid-cell x-grid-cell-first" width="50%"><div class="x-grid-cell-inner">{COLUMN_0}</div></td>',
					        '<td class=" x-grid-cell x-grid-cell-first" width="50%"><div class="x-grid-cell-inner">{COLUMN_1}</div></td>',
					    '</tr>',
					    '</tpl>',
					    '</tbody>',
					    '</table>',
					    '</div>'
					);
			var getTitle = citrixUserSessionSummary['TITLE'];
			var tableValues = citrixUserSessionSummary['TABLE_VALUES'];
			rightPanelObj.add({
				xtype: 'panel',
				title: getTitle,
				id: 'xtemplate-panel',
				border:true,
				margin:10,
				padding:0,
				cls:'datapanel',
				frame:true,
				width: Ext.getCmp('right-panel').getWidth()-25,
				items:[
					{
						xtype: 'dataview',
						tpl: tpl,

						store: new Ext.data.Store({
							fields: ['COLUMN_0', 'COLUMN_1'],
							data: tableValues
						})
					}
				]
			});
			rightPanelObj.doLayout();

		}

		var citrixAppUserSummary = citrixUsers['CITRIX_USER_APPLICATIONS_SUMMARY'];
		if ( !Ext.isEmpty( citrixAppUserSummary ) )
		{
			var getTitle = citrixAppUserSummary['TITLE'];
			rightPanelObj.add({
				xtype: 'panel',
				id: 'user-application-panel',
				cls:'datapanel',
				padding:0,
				border:true,
				margin:10,
				frame:true,
				title: getTitle,
				width: Ext.getCmp('right-panel').getWidth()-25
			});
			rightPanelObj.doLayout();
			Ext.getCmp('user-application-panel').removeAll();
			if ( citrixAppUserSummary['NO_GRID'] == 'true' )
			{
				var getMsg = citrixAppUserSummary['MSG'];
				Ext.getCmp('user-application-panel').update('<table width="100%" height="100%"><tr><td align="center"><div class="iconInformation"></div>'+getMsg+'</td></tr></table>');
			}
			else
			{
				var gridCols = citrixAppUserSummary['GRID_COLUMNS'];
				var gridValues = citrixAppUserSummary['GRID_VALUES'];
				var storeModel = new Array();
				var colArr = new Array();
				for ( var j = 0; j < gridCols.length; j++ )
				{
					storeModel[storeModel.length] = 'COLUMN_'+j;
					colArr.push({
						header: gridCols[j],
						dataIndex: 'COLUMN_'+j,
						flex: 0.1
					});
				}
				var gridValues = citrixAppUserSummary['GRID_VALUES'];				
				Ext.getCmp('user-application-panel').add({
					xtype: 'customgrid',
					layout:'fit',
					height:250,	
					scroll:true,
					cls:'gridSkin',
					store : new Ext.data.Store({
						fields: storeModel,
						data: gridValues
					}),
					columns: colArr
				});
			}
		}
	},
	showCitrixApplicationsAtAGlance: function( tabId, resultData ,isFlag)
	{
		var subSystemVal = Ext.getCmp('appSubsystem').getValue();
		var defaultHeight = 0;
		if ( !Ext.isEmpty( subSystemVal ) && subSystemVal.toLowerCase() != 'overview' )
		{
			defaultHeight = 133;
		}
		var getElObj = Ext.getCmp(tabId).getEl();
		var getPanelObj = Ext.getCmp(tabId);
		//getPanelObj.setHeight((Ext.getBody().getHeight()-265)+defaultHeight+200);
		getPanelObj.setAutoScroll(true);
		getElObj.mask(loadingLbl+"...", "maskCenter");
		var citrixAppData = resultData['CITRIX_APPLICATIONS'];
		if ( !Ext.isEmpty( citrixAppData ) )
		{
			getPanelObj.removeAll();
			var getTitle = citrixAppData['TITLE'];
			getPanelObj.add({
				xtype: 'panel',
				id: 'grid-result',
				title: '<b>'+getTitle+'</b>',
				width: '100%',
				cls:'datapanel',
				
				autoScroll:true,
				//height:200,
				flex:1,
				//height: getPanelObj.getHeight()-200
			});
			getPanelObj.doLayout();
			if ( citrixAppData['GRID_VALUES'] != undefined )
			{
				var gridColArr = citrixAppData['GRID_COLUMNS'];
				var gridStore = new Array();
				var columnsArr = new Array();
				var gridVals = citrixAppData['GRID_VALUES'];
				for ( var i = 0; i < gridColArr.length; i++ )
				{
					gridStore[gridStore.length] = 'COLUMN_'+i;
					columnsArr.push({
						header: gridColArr[i],
						dataIndex: 'COLUMN_'+i,
						flex: 0.1,
						align: 'center'
					});
				}
				Ext.getCmp('grid-result').add({
					xtype: 'customgrid',
					columns: columnsArr,
					cls:'gridSkin',
					store: new Ext.data.Store({
						fields: gridStore,
						data: gridVals
					})
				});
			}
			else if ( citrixAppData['NO_GRID'] == 'true' )
			{
				var getMsg = citrixAppData['MSG'];
				Ext.getCmp('grid-result').add({
					xtype: 'container',
					html: '<div class="iconInformation" style="margin:20% 0px 0px 48%;"></div><br/><div style="text-align:center;">'+getMsg+'</div>'
				});
			}
			Ext.getCmp('grid-result').doLayout();
			//appLastGraphTypeLoaded = 'citrixapps';
		}
		getElObj.unmask();
		appLastGraphTypeLoaded = 'citrixapps';
	},
	//oracle app History tab graph Jaiwin -- done
	showHistoryTab: function ( tabId, resultData ,isFlag)
	{
		var historyObj = Ext.getCmp(tabId);
		historyObj.setAutoScroll(true);
		var subapplicationheight=Ext.getCmp('subapplicationtabpanelId').getHeight();
		var cvbheight=Ext.getBody().getViewSize().height-20;	
		historyObj.setHeight(cvbheight);
		if(isFlag == 'default')
		{
			historyObj.removeAll();
		}
		var subSystemVal = Ext.getCmp('appSubsystem').getValue();
		var defaultHeight = 0;
		if ( !Ext.isEmpty( subSystemVal ) && subSystemVal.toLowerCase() != 'overview' )
		{
			//defaultHeight = 133;
		}
		//historyObj.setHeight((Ext.getBody().getHeight()-265)+defaultHeight);
		//historyObj.setAutoScroll(true);
		historyObj.getEl().mask(loadingLbl+"...", "maskCenter");
		var tmpHeight = historyObj.getHeight();
		var chartsData = resultData['CHARTS'];
		var hiddens = resultData['hiddens'];
		appLastGraphTypeLoaded = hiddens['graphType'];
		if ( !Ext.isEmpty( chartsData ) )
		{
			if ( chartsData['NO_CHARTS'] != undefined && chartsData['NO_CHARTS'] == 'true' )
			{
				var getMsg = chartsData['NO_CHARTS_MSG'];
				if (isFlag == 'default')
				{
				
					historyObj.add({
						xtype: 'container',
						id:'App_Nomeasure',
						width: '100%',
						html :'<table width="100%" height="100%" style="margin: 10% auto;"><tr><td align="center"><div class="iconInformation"></div>'+getMsg+'</td></tr></table>'
					});
				}
				else if(Ext.getCmp('App_Nomeasure')!=null)
				{
					Ext.getCmp('App_Nomeasure').update('<table width="100%" height="100%" style="margin: 10% auto;"><tr><td align="center"><div class="iconInformation"></div>'+getMsg+'</td></tr></table>');	
				}
				else
				{
					historyObj.removeAll();
					historyObj.add({
						xtype: 'container',
						id:'App_Nomeasure',						
						width: '100%',
						html :'<table width="100%" height="100%" style="margin: 10% auto;"><tr><td align="center"><div class="iconInformation"></div>'+getMsg+'</td></tr></table>'
					});
				}
			}
		}
		else if ( !Ext.isEmpty( resultData['MEASURE_GRAPHS'] ) && hiddens['graphType'] == 'measureGraph' )
		{
			var chartArr = new Array();
			var measureData = resultData['MEASURE_GRAPHS'];

			if (isFlag=='default')
			{
				historyObj.add({
				xtype: 'container',
				id: 'chart-container',
				width: '100%',
				margin:'10',
				layout:{
					type: 'column'
					//align: 'stretch'
				},
				defaults:{
					columnWidth: 0.333,
					
					cls:'datapanel',
					
					//style:{'border':'5px solid red'},
					//style:{'border':'1px solid #c3c3c3'}
				}
				});
				historyObj.doComponentLayout();
			}
			for ( var i = 0; i < measureData.length; i++ )
			{
				var chartData = measureData[i];
				var tmpHeight = chartData['HEIGHT'];
				var tmpWidth = chartData['WIDTH'];
				var chartTitle = chartData['TITLE'];
				var toolTipTitle = chartData['TOOLTIP_TITLE'];
				var imgSrc = chartData['IMG_SRC'];
				var hightChartEnabled = chartData['HIGH_CHART'];
				var genHTML = '';
				if ( hightChartEnabled == 'false' )
				{
					var maxViewUrl = measureData[i]['PARAMS'];					
					genHTML = '<img onClick="javascript:MeasureGraphOnClick(\''+maxViewUrl+'\');" src="'+imgSrc+'" height="'+tmpHeight+'" width="'+tmpWidth+'" />';
				}
				else
				{
					genHTML = '<div id="high-chart-'+i+'" style="border:0px solid yellow;height:'+tmpHeight+'px"></div>';
				}
				chartArr.push({
					xtype: 'container',
					id: 'measure-graph-'+i,
					cls:'datapanel optionalListPanel cursor',
					border:false,
					frame:true,
					width: '100%',
					margin:5,
					padding:0,
					//style:{'border':'1px solid #c3c3c3'},
					dataArray: chartData,
					items: [
						{
							xtype: 'label',
							style:{'text-align':'center'},
							html: '<div title="'+toolTipTitle+'" class="font_bold" style="padding:5px">'+chartTitle+'</div>'
						},
						{
							xtype: 'container',
							html: genHTML
						}
					]
				});
			}
			Ext.getCmp('chart-container').removeAll();
			Ext.getCmp('chart-container').add(chartArr);
			Ext.getCmp('chart-container').doComponentLayout();
			
			for ( var i = 0; i < measureData.length; i++ )
			{
				var imgSrc = measureData[i]['IMG_SRC'];
				if ( measureData[i]['HIGH_CHART'] == 'true' )
				{
					var maxViewUrl = measureData[i]['PARAMS'];					
					if ( Ext.get('high-chart-'+i) != null && Ext.get('high-chart-'+i) != 'null' && Ext.get('high-chart-'+i) != undefined )
					{
						Ext.Ajax.request({
							url: imgSrc,
							method: 'GET',
							async: false,
							success: function( response )
							{
								if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
								{
									var tmpJsonTxt = response.responseText;
									if ( tmpJsonTxt.indexOf('png') == -1 && tmpJsonTxt.indexOf('PNG') == -1 && tmpJsonTxt.indexOf('gif') == -1 && tmpJsonTxt.indexOf('GIF') == -1 )
									{
										var tmpJsonData = Ext.decode( tmpJsonTxt );
										try
										{
											var lineChart = {};
											lineChart = jQuery.extend(true, {}, getHighCharts('high-chart-'+i, measureData[i]['HEIGHT'],measureData[i]['WIDTH'],maxViewUrl), lineChart);
											if ( tmpJsonData.hasOwnProperty('title'))
											{
												tmpJsonData.title='';
											}
											tmpJsonData['legVerAlignWBottom'] = true;
											lineChart.setData(tmpJsonData,currentDateFormat,maxViewUrl,true,'bottom');
											lineChart.drawChart();
										}
										catch (e)
										{
											alert("e::"+e)
										}
									}
									else
									{
										Ext.get('high-chart-'+i).update('<table width="100%" height="100%" border="0"><tr><td align="center"><div class="iconInformation" style="margin:0px auto 0px auto;margin-top: -22px;"></div><div>'+noMeasureExcl+'</div></td></tr></table>');
									}
								}
								else
								{
									Ext.get('high-chart-'+i).update('<table width="100%" height="100%" border="0"><tr><td align="center"><div class="iconInformation" style="margin:0px auto 0px auto;margin-top: -22px;"></div><div>'+noMeasureExcl+'</div></td></tr></table>');
								}
							}
						});
					}
				}
			}
		}
		// History summary view tab graph Jaiwin -- done
		else if ( !Ext.isEmpty( resultData['SUMMARY_GRAPHS'] ) && hiddens['graphType'] == 'summaryGraph' )
		{
			var chartArr = new Array();
			var measureData = resultData['SUMMARY_GRAPHS'];
			if(isFlag == 'default')
			{
				historyObj.add({
					xtype: 'panel',
					id: 'chart-container',
					width: '100%',
					padding:0,
					margin:10,
					autoScroll: false,
					layout: 'column',
					defaults: {
						columnWidth: 0.5
					}
				});
				
				historyObj.doComponentLayout();
			}
			for ( var i = 0; i < measureData.length; i++ )
			{
				var chartData = measureData[i];
				var tmpWidth = chartData['WIDTH'];
				var tmpHeight = chartData['HEIGHT'];
				var chartTitle = chartData['TITLE'];
				var toolTipTitle = chartData['TOOLTIP_TITLE'];
				var maxUrl = chartData['summryFullviewGraphUrl'];
				chartArr.push(
				{
					xtype:'container',
					margin:5,
					cls:'containerShadow',
					items:[
					{
						xtype: 'label',
						html: '<div style="text-align: center;margin-top: 10px;"><span title="'+toolTipTitle+'" style="padding:5px;text-align:center" class="font_normal13">'+chartTitle+'</span></div>'						
					},
					{
						xtype: 'container',
						id: 'summary-graph-'+i,
						dataArray: chartData,					
						width: '100%',
						padding:0,
						style:{cursor:'pointer'},
						margin:10,
						MaxURL :maxUrl,
						html: '<div id="summaryChart-'+i+'" style="width:'+tmpWidth+'px;height:'+tmpHeight+'px;"></div>',
						listeners : {
							'afterrender' : function()
							{
								var xmlData = this.dataArray['XML_DATA'];								
								if ( xmlData != '-' )
								{
										try
										{
											var barChart = {};
											barChart = jQuery.extend(true, {}, getHighChartsBarInstance(this.id, 250, tmpWidth), barChart);
											barChart.setData(xmlData, currentDateFormat,this.MaxURL,'stackedColumn');
											barChart.drawChart();
										}
										catch (barChartEx)
										{
											console.log(barChartEx);
										}
									}
							}
						}
				}]});
			}
			Ext.getCmp('chart-container').removeAll();
			Ext.getCmp('chart-container').add(chartArr);
			Ext.getCmp('chart-container').doComponentLayout();
		}
		// History Trend view tab graph Jaiwin -- done
		else if ( !Ext.isEmpty( resultData['TREND_GRAPHS'] ) && hiddens['graphType'] == 'trendGraph' )
		{
			var chartArr = new Array();
			var measureData = resultData['TREND_GRAPHS'];
			if(isFlag == 'default')
			{
				historyObj.add({
					xtype: 'panel',
					id: 'chart-container',
					width: '100%',
					autoScroll: true,
					
					layout: 'column',
					defaults: {
						columnWidth: 0.333
					}
				});
				historyObj.doComponentLayout();
			}
			for ( var i = 0; i < measureData.length; i++ )
			{
				var chartData = measureData[i];
				var tmpWidth = chartData['WIDTH'];
				var tmpHeight = chartData['HEIGHT'];
				var chartTitle = chartData['TITLE'];
				var toolTipTitle = chartData['TOOLTIP_TITLE'];
					chartArr.push({
						xtype: 'panel',
						cls:'datapanel optionalListPanel cursor',
						margin:'5',
						//padding:5,
						bodyPadding:5,
						id: 'app-trend-graph-'+i,
						width: '100%',
						//style : 'border:2px solid red',
						dataArray: chartData,
						items: [
							{
								xtype: 'label',
								style:{'text-align':'center'},
								html: '<div title="'+toolTipTitle+'" class="font_bold" style="padding:5px;margin-top:7px;text-align:center" >'+chartTitle+'</div>'
							},
							{
								xtype: 'container',
								id : 'app-trendChart-'+i,
								//style : 'border:2px solid blue',
								width: '100%',
								height : parseInt(tmpHeight)
								//html: '<div id="sys-trendChart-'+i+'" style="border:1px solid yellow;cursor:pointer;height:'+tmpHeight+'px;width:100%"></div>'
								//<div style="text-align:center"><div data-qtip="'+toolTipTitle+'"     data-qclass="yellowTip"><b>'+chartTitle+'</b></div>
							}
						]

					});
			}
			Ext.getCmp('chart-container').removeAll();
			Ext.getCmp('chart-container').add(chartArr);
			Ext.getCmp('chart-container').doComponentLayout();
			for ( var i = 0; i < measureData.length; i++ )
			{
				var getSummaryObj = Ext.getCmp('app-trend-graph-'+i);
				var tmpDataArray = getSummaryObj.dataArray;
				var charwidth = getSummaryObj.getWidth();
				var xmlData = tmpDataArray['XML_DATA'];
				if ( xmlData != '-' )
				{
						try
						{
							var chartWidth = tmpDataArray['WIDTH'];
							var chartHeight = tmpDataArray['HEIGHT'];
							var maxUrl = tmpDataArray['minMaxtrendFullView'];
							//chartHeight=220;
							var lineChart = {};
							lineChart = jQuery.extend(true, {}, createLineChart('app-trendChart-'+i,chartHeight,charwidth-10,false), lineChart);
							lineChart.setData(xmlData, currentDateFormat,maxUrl ,'line');
							lineChart.drawChart();
						}
						catch (trendChartEx)
						{
							console.log(trendChartEx);
						}
				}
			}
		}
		historyObj.getEl().unmask();
		if ( !Ext.isEmpty(Ext.getCmp('calendar-btn')) )
		{
			//Ext.getCmp('calendar-btn').fireEvent('loadTime', Ext.getCmp('calendar-btn'));
		}
	},
	// done details graph - oracle - jaiwin
	showDetailsTab: function( tabId, resultData ,isFlag)
	{
		var detailsObj = Ext.getCmp(tabId);
		detailsObj.setAutoScroll(true);
		var defaultHeight = 0;
		var subSystemVal = Ext.getCmp('appSubsystem').getValue();
		if ( !Ext.isEmpty( subSystemVal ) && subSystemVal.toLowerCase() != 'overview' )
		{
			//defaultHeight = 133;
		}
		//detailsObj.setHeight( ( Ext.getBody().getHeight()-265 ) + defaultHeight );
		//detailsObj.doLayout();
		//var tmpHeight = detailsObj.getHeight();
		
		var outerChartArr = new Array();

		if(isFlag == 'default')
		{	
			detailsObj.removeAll();
			detailsObj.add({
				xtype: 'container',
				id: 'details-outer-panel',
				width: '100%',
				margin:'10',
				//autoScroll: true,
				layout:{
					type: 'column'
					//align: 'stretch'
				},
				defaults:{
					columnWidth: 0.333,
					
					
					//style:{'border':'1px solid #c3c3c3','background': '#ffffff !important'}
				}
			});
			detailsObj.doComponentLayout( );
		}
		var outerObj = Ext.getCmp('details-outer-panel');
		outerObj.removeAll();
		var chartsData = resultData['CHARTS'];
		if ( !Ext.isEmpty( chartsData ) )
		{
			if ( chartsData['NO_CHARTS'] != undefined && chartsData['NO_CHARTS'] == 'true' )
			{
				if(subSystemVal == 'Overview') 
				{
					var cheight=Ext.getBody().getViewSize().height-290;	
					var overviewmargin='margin-top:0px';
				}
				else
				{
					var cheight=Ext.getBody().getViewSize().height-140;	
					var overviewmargin='margin-top:5%';
				}
				
				var getMsg = chartsData['NO_CHARTS_MSG'];
				outerChartArr.push({
					xtype: 'container',
					
					//height: cheight,
					width: '100%',
					//border:true,
					//frame:true,
					columnWidth:1.0,
					style:{'text-align':'center','height':'300px !important;margin-top: 6%'},
					html :'<table width="100%" height="100%" style='+overviewmargin+'><tr><td align="center"><div class="iconInformation"></div>'+getMsg+' </td></tr></table>'
				});
				outerObj.add(outerChartArr);
				outerObj.doComponentLayout( );
			}
			else
			{
				var chartArr = new Array();
				for ( var i = 0; i < chartsData.length; i++ )
				{
					var chartData = chartsData[i];
					var tmpHeight = chartsData[i]['HEIGHT'];
					var tmpWidth = chartsData[i]['WIDTH'];
					var ddGraphUrlLarge = chartsData[i]['ddGraphUrlLarge'];
					outerChartArr.push({
						xtype: 'container', // Detail chart
						cls:'datapanel optionalListPanel',
					//	style:{'border':'1px solid blue'},
						id: 'bar-container-'+i,
						dataArray: chartData,
						chartCnt : i,
						width : tmpWidth,
						//height : tmpHeight,
						max:ddGraphUrlLarge,
						border:false,
						frame:false,
						margin:5,
						padding:0,
						autoScroll : true,
						scroll : true,
						//html:'<div id="barChart'+i+'" style="margin:0px auto;border 1px solid red;cursor:pointer;width:'+tmpWidth+'px;height:'+tmpHeight+'px"></div>',
						html:'<div id="barChart'+i+'" style="margin:0px auto;border 0px solid red;cursor:pointer;"></div>',
						listeners : {
							'afterrender' : function()
							{
									try
									{
										//Ext.get("barChart"+i).setHeight(tmpHeight);
										Ext.get("barChart"+this.chartCnt).setHeight(tmpHeight-3);
										//var barGraphHeight=this.dataArray['XML_DATA']['barGraphHeight'];
										var barGraphHeight=Ext.get('barChart'+this.chartCnt).getHeight();
										var barGraphWidth=Ext.get('barChart'+this.chartCnt).getWidth();
										var barChart = {};
										barChart = jQuery.extend(true, {}, getHighChartsBarInstance('barChart'+this.chartCnt, barGraphHeight,barGraphWidth), barChart);	
										var maxUrl=this.dataArray['ddGraphUrlLarge'];
										barChart.setData(this.dataArray['XML_DATA'], currentDateFormat,maxUrl,'bar');
										barChart.drawChart();
									}
									catch (barChartEx)
									{
										console.log(barChartEx);
									}
							},
							'resize' : function()
							{
									try
									{
										//Ext.get("barChart"+i).setHeight(tmpHeight);
										Ext.get("barChart"+this.chartCnt).setHeight(tmpHeight-3);
										//var barGraphHeight=this.dataArray['XML_DATA']['barGraphHeight'];
										var barGraphHeight=Ext.get('barChart'+this.chartCnt).getHeight();
										var barGraphWidth=Ext.get('barChart'+this.chartCnt).getWidth();
										var barChart = {};
										barChart = jQuery.extend(true, {}, getHighChartsBarInstance('barChart'+this.chartCnt, barGraphHeight,barGraphWidth), barChart);	
										var maxUrl=this.dataArray['ddGraphUrlLarge'];
										barChart.setData(this.dataArray['XML_DATA'], currentDateFormat,maxUrl,'bar');
										barChart.drawChart();
									}
									catch (barChartEx)
									{
										console.log(barChartEx);
									}
							}
						}
					});
				}
				outerObj.add(outerChartArr);
				outerObj.doComponentLayout( );
			}
		}
		else
		{
			outerChartArr.push({
				xtype: 'panel',
				layout:'fit',
				columnWidth: 1,
				margin:10,
				border:true,
				frame:true,
				height:detailsObj.getHeight()-20,
				cls:'block1',
				html :'<table width="100%" height="100%" style="text-align:center"><tr><td><div class="iconInformation" style="margin:0px auto 0px auto"></div><div>'+noMeasureExcl+'</div></td></tr></table>'
			});
			outerObj.add(outerChartArr);
			outerObj.doLayout();
			//outerObj.doComponentLayout();
		}
		appLastGraphTypeLoaded = 'DDgraph';
	},
	 // done At a glance - oracle - jaiwin
	showAtAGlance: function( tabId, resultData ,isFlag)
	{
		var atAGlanceOuterObj = Ext.getCmp(tabId);
		atAGlanceOuterObj.setAutoScroll(true);
		
		var atAGlanceArr = new Array();
		if(isFlag == 'default')
		{
			atAGlanceOuterObj.removeAll();
			//	atAGlanceOuterObj.setHeight(Ext.getBody().getHeight()-245);
			
			atAGlanceOuterObj.add({
				xtype: 'panel',
				id: 'overview-outer',
				frame:false,
				border:true,
				width: '100%',
				margin:'5',
				padding:0
				//overflowX:'hidden',
					//overflowY:'auto'
				//scroll:true,
				//autoScroll:true
			});
			
			var atAGlanceObj = Ext.getCmp('overview-outer');
			atAGlanceOuterObj.doComponentLayout( );
			atAGlanceObj.add({
				xtype: 'panel',
				padding:0,
				id: 'healthdialpanel',
				cls:'block1',
				margin:'5 5 0 5',
				padding:10,
				//style:{'border':'1px solid #e3e3e3'},
				frame:false,
				border:true,
				//height:225,
				layout:
				{
					type: 'hbox',
					align: 'stretch'
				}
			});
			
			atAGlanceObj.add({
				xtype: 'panel',
				id: 'digitalpanel',
				cls:'datapanel',
				padding:'8 0 8 0',
				margin:'10 5 5 5',
				height:135,
				//style:{'border':'1px solid #e3e3e3'},
				frame:true,
				border:true,
				layout:
				{
					type: 'hbox',
					align: 'stretch'
				},
				defaults:
		        {
		           columnWidth: 0.20
		        }
			},
			{
				xtype: 'panel',
				id: 'configpanel',
				frame:false,
				padding:0,
				//cls:'datapanel',
				border:false,
				//autoScroll:true,
				//height:200,
				layout:
				{
					type: 'column',
					align: 'stretch'
				},
				defaults:
		        {
		            margin:8,
		            columnWidth: 0.5
		        }
			});
			atAGlanceObj.doComponentLayout( );
		}
		var getHealthDialObj = Ext.getCmp('healthdialpanel');
		var getDigitalObj = Ext.getCmp('digitalpanel');
		var configObj = Ext.getCmp('configpanel');
		getDigitalObj.removeAll();
		configObj.removeAll();
		if ( !Ext.isEmpty( resultData ) )
		{
			atAGlanceArr.splice(0, atAGlanceArr.length);
			// To Load Health Chart
			var healthData = resultData['HEALTH'];

			if ( !Ext.isEmpty( healthData ) )
			{
				var healthArr = new Array();
				var healthTitle = healthData['TITLE'];
				var xmlData = healthData['XML_DATA'];
				var swfPath = healthData['SWF_PATH'];
				var chartHeight = Math.round(healthData['HEIGHT']);
				var chartWidth = Math.round(healthData['WIDTH']);
				chartHeight = chartHeight+10;
				if ( xmlData == '-' )
				{
					var errorMsg = healthData['MSG'];
			
					healthArr.push(
						{
							xtype: 'container',
							padding: 0,
							margin: 0,
							layout: {
								type: 'vbox',
								align: 'stretch'
							},
							cls:'componentnetworkseperator',
							//height:125,
							//style: {'border':'1px solid gr'},
							items:[
								{
									xtype: 'label',
									align: 'center',
//									style: {'border':'1px solid blue'},
									html: '<div style="text-align:center;" class="font_bold">'+healthTitle+'</div>'
								},
								{
									xtype: 'container',
									//style: {'border':'1px solid pink'},
									flex:1,
									height: chartHeight,
									width: chartWidth,
									html: '<table width="100%" height="100%" style="text-align:center"><tr><td><div class="iconInformation" style="margin:0px auto"></div><div>'+errorMsg+'</div></td></tr></table>'
								}
							]
						}
					);
				}
				else
				{
					healthArr.push(
						{
							xtype: 'container',
							//flex:.25,
							cls:'componentnetworkseperator',
							margin:'13 0 0 0',
							height:172,
							width:262,
							items:[
								{
									xtype: 'container',
									align: 'center',
									margin:'5 0 0 0',
									style: {'position':'relative','z-index':'9999'},
									html: '<div style="text-align:center;" class="font_bold">'+healthTitle+'</div>'
								},
								{
									xtype: 'container',
									//height: chartHeight,
									
									id: 'tmpChart',
									//width: chartWidth,piecHART
									html: '<div id="HealthChart" style="margin-top:-15px"></div>'
								}
							]
						}
					);
				}
				getHealthDialObj.removeAll();
				getHealthDialObj.add(healthArr);
				getHealthDialObj.doComponentLayout( );
				
				if ( xmlData != '-' )
				{
						try
						{
							var barChart = {};
							barChart = jQuery.extend(true, {}, getHighChartsBarInstance('HealthChart',  147, 225), barChart);
							barChart.setData(xmlData, currentDateFormat, '', 'pie');
							barChart.drawChart();
						}
						catch (barChartEx)
						{
							console.log(barChartEx);
						}
				}
			}
			// To Load Dial Chart
			layerModelURL = resultData['hiddens'];
			var dialData = resultData['DIAL'];
			var weblogicwidth='';
			if ( !Ext.isEmpty( dialData ) && dialData != '-' )
			{
				atAGlanceArr.splice(0, atAGlanceArr.length);

				for ( var i = 0; i < dialData.length; i++ )
				{
					var title = dialData[i]['TITLE'];
					var toolTipTitle = dialData[i]['TOOL_TIP_TITLE'];
					var chartHeight = Math.round(dialData[i]['HEIGHT']);
					var chartWidth = Math.round(dialData[i]['WIDTH']);
					var xmlData = dialData[i]['XML_DATA'];
					var swfPath = dialData[i]['SWF_PATH'];
					if(chartHeight==null || chartHeight==undefined)
					{
						chartWidth="255";
						chartHeight="150"
					}
					chartHeight=chartHeight-15;
				//	if ( xmlData != '-' )
					{
							atAGlanceArr.push({
							xtype: 'container',
							flex:.20,
							cls:'componentnetworkseperator',
							//height:125,
							margin:'5 0 10 0',
							layout:{
								type: 'vbox',
								width: chartWidth,
								//padding: '0px 5px 0px 5px',
								align: 'stretch'
							},
							items:[
								{
									xtype: 'container',
									margin:5,
									style: {'text-align':'center'},
									
									align: 'center',
									html: '<div style="text-align:center;" title="'+toolTipTitle+'" class="font_bold">'+title+'</div>'
								},
								{
									xtype: 'container',
									id: 'dialChart-'+i,
									dataArray: dialData[i],
									align: 'center',
									html: '<div id="chart'+i+'" style="margin:0 auto 0 auto;border:0px solid blue;width:'+chartWidth+'px;height:'+chartHeight+'px;"></div>'
								}
							]
						});
					}
				}
				var outerArr = new Array();
				outerArr.push({
					xtype: 'container',
					//width: '100%',
					id: 'dialpanel',
					flex:1,
					border:true,
					layout: {
						type: 'hbox',
						align: 'stretch'
					},
					items: atAGlanceArr
				});
				getHealthDialObj.add(outerArr);
				for ( var i = 0; i < dialData.length; i++ )
				{
					var getObj = Ext.getCmp('dialChart-'+i);
					var getDataArray = getObj.dataArray;
					var xmlData = getDataArray['XML_DATA'];
					var swfPath = dialData[i]['SWF_PATH'];
					if ( xmlData != '-' )
					{
						
							getHighChartsGuage('chart'+i,xmlData);
											
					}
					else
						{
							Ext.get('chart'+i).update('<div style="border:0px solid blue;margin:0px auto"><div class="iconInformation" width="100%" style="text-align:center;margin:0px auto;margin-top: 20px;"></div><div style="text-align:center;margin:0px auto;">'+noMeasureExcl+'</div></div>');
						}
				}
			}
			else
			{
				getHealthDialObj.add({
					xtype: 'container',
					width: '100%',
					height: 207,
					id: 'dialpanel',
					flex: 0.25,
					border:true,
					margin:'0 10 0 10',
					padding:'0 0 8 0',
					//style:{'border':'2px solid green'},
					cls:'fancy_border',
					layout: {
						type: 'hbox',
						padding: '0px 5px 0px 5px',
						align: 'stretch'
					}
				})
			}
			getHealthDialObj.doComponentLayout( );
			atAGlanceArr= new Array();
			// To load WebLogic Heap Usage Charts

			if ( resultData['WEBLOGIC_HEAP_USAGE'] != undefined )
			{
				var webLogicHeap = resultData['WEBLOGIC_HEAP_USAGE'];
				var genHTML = '';
				var getHeight = parseInt(webLogicHeap['HEIGHT']);
				var getWidth = parseInt(webLogicHeap['WIDTH']);
				var tmpDialObj = Ext.getCmp('dialpanel');
				var getTitle = webLogicHeap['TITLE'];
				if ( webLogicHeap['DATA'] == 'true' )
				{
					var xmlData = webLogicHeap['XML_DATA'];
					var swfPath = webLogicHeap['SWF_PATH'];
					if ( xmlData != '-' )
					{
						tmpDialObj.add(
							{
							xtype: 'container',
							id: 'weblogic-panel',
							dataArray: webLogicHeap,
							margin:'5 0 20 0',
							width:262,
							items:[
								{
									xtype: 'container',
									align: 'center',
									margin:'5 0 0 0',
									style: {'position':'relative','z-index':'9999'},
									html: '<div style="text-align:center;margin-top: 5px;" class="font_bold">'+getTitle+'</div>'
							},
							{
							xtype: 'container',
									html: '<div id="weblogicChartDiv" style="margin-top:-15px"></div>'
								}
							]
						});
					}
					else
					{
						var getMsg = webLogicHeap['MSG'];
						genHTML = '<div style="text-align:center;margin:20px auto;margin-top: 17px;margin-bottom: 26px" class="font_bold">'+getTitle+'</div><div class="iconInformation" style="margin:0px auto 0px auto"></div><div style="text-align:center">'+getMsg+'</div>';
						tmpDialObj.add({
							xtype: 'container',
							columnWidth:1,
							width:300,
							html: genHTML
						});
					}
				}
				else
				{
					var getMsg = webLogicHeap['MSG'];

					genHTML = '<table width="100%" height="100%"><tr><td align="center"><div class="iconInformation"></div>'+getMsg+'</td></tr></table>'
					tmpDialObj.add(
						{
							xtype: 'container',
							width:300,
							
							html: '<div><div style="text-align:center;margin:10px 10px 0 0px" class="font_bold">'+getTitle+'</div><div style="margin-top:20px">'+genHTML+'</div></div>'
						});
				}
				tmpDialObj.doLayout();
				if ( Ext.getCmp('weblogic-panel') != null && Ext.getCmp('weblogic-panel').dataArray != null )
				{
					var tmpArray = Ext.getCmp('weblogic-panel').dataArray;
					var xmlData = tmpArray['XML_DATA'];
					var swfPath = tmpArray['SWF_PATH'];
					if ( xmlData != '-' )
					{
							try
							{
								var barChart = {};
								barChart = jQuery.extend(true, {}, getHighChartsBarInstance('weblogicChartDiv', 145, 225), barChart);
								barChart.setData(xmlData, currentDateFormat, '','pie');
								barChart.drawChart();
							}
							catch (barChartEx)
							{
								console.log(barChartEx);
							}
					}
					else
					{
						var getMsg = tmpArray['MSG'];
						Ext.get('weblogicChartDiv').update('<div class="iconInformation" style="margin:0px 0px 0px 35%;"></div><div style="text-align:center;">'+getMsg+'</div>');
					}
				}
			}
			// To load Digital Data

			var digitalData = resultData['DIGITAL'];

			if ( !Ext.isEmpty( digitalData ) )
			{
				//atAGlanceArr.splice(0, atAGlanceArr.length);
				Ext.getCmp('digitalpanel').defaults.columnWidth = (1/digitalData.length);
				for ( var i = 0;i < digitalData.length; i++ )
				{
					var heading = digitalData[i]['IMG_HEADING'];
					var imgSRC = digitalData[i]['IMG_SRC'];
					var height = digitalData[i]['HEIGHT'];
					var width = digitalData[i]['WIDTH'];
					var unit = digitalData[i]['UNIT'];
					var containerWidth = Math.round(digitalData[i]['CONTAINER_WIDTH']);
					if(containerWidth==null|| containerWidth==undefined)
					{
					containerWidth="255";
					}
					if(imgSRC!='-')
					{
						atAGlanceArr.push({
							xtype: 'container',
							//style:{'height':'90px !important'},
							//height:90,
							flex:.25,
							cls:'componentnetworkseperator',
							layout:
							{
								type: 'vbox',
								align: 'stretch'
							},
							items:[
								{
									xtype: 'label',
									html: '<div style="text-align:center;" class="font_bold12">'+heading+'</div>'
								},
								{
									xtype: 'container',
									id:'App_digitalChartId'+i,
									height:30,
									margin:'8 0 0 0',
									style:{'text-align':'center','height':'65px !important'},
									dataArray: digitalData[i],
									listeners:{
										'afterrender': function(container)
										{
											var tmpDataArray = this.dataArray;
											var imgsrc = tmpDataArray['IMG_SRC'];
											var imgHeight = tmpDataArray['HEIGHT'];
											var imgWidth = tmpDataArray['WIDTH'];
											var imgTitle = tmpDataArray['IMG_TITLE'];
											var methodName = tmpDataArray['METHOD_NAME'];
											var params = tmpDataArray['PARAMS'];
												var genImage = '<img vspace="auto" hspace="auto" src="'+imgsrc+'" title="'+imgTitle+'" style="cursor:pointer" onclick="javascript:'+methodName+'(\''+params+'\');"/>';
												imgHeight= Math.round(imgHeight);
												this.setHeight(imgHeight);
												this.update(genImage);
										}
									}
								},
								{
									xtype: 'label',
									html: '<div style="text-align:center;">'+unit+'</div>'
								}
							]
						});
					}
					else
					{
						atAGlanceArr.push({
							xtype: 'container',
							style:{'height':'90px !important'},
							//height:90,
							width: containerWidth,							
							cls:'componentnetworkseperator',
							items:[
								{
									xtype: 'label',
									
									html: '<div style="text-align:center;margin:10px 10px 5px 0px" class="font_bold">'+heading+'</div>'
								},
								{
									xtype: 'container',
									id:'App_digitalChartId'+i,
									//dataArray: digitalData[i],
									listeners:{
										'afterrender': function(container)
										{
											var digitalId=this.id;
											Ext.get(container.id).update('<div style="border:0px solid blue;margin:0px auto"><div class="iconInformation" width="100%" style="text-align:center;margin:0px auto"></div><div style="text-align:center;margin:0px auto;">'+noMeasureExcl+'</div></div>');
										}
									}
								}
							]
						});
					}
				}
			}
			if ( (dialData == undefined || Ext.isEmpty(dialData)) && (digitalData == undefined  || Ext.isEmpty(digitalData)))
			{
				
				var noGraphTitle = resultData['APP_TAB_NoGraphTitle'];	
				var dialDigitalMsg = resultData['DIAL_DIGITAL_MSG'];
				var noMeasureMsg = testExcludedorDisabledMsg;
				if( dialDigitalMsg == undefined || Ext.isEmpty(dialDigitalMsg)){
					noMeasureMsg = noMeasure;
				}
				Ext.getCmp('dialpanel').removeAll();
				Ext.getCmp('dialpanel').update('<div class="noGraphTitle" style="padding-top:5px;">'+noGraphTitle+'</div><table width="100%" height="189px" style="text-align:center"><tr><td><div class="iconInformation" style="margin:0px auto"></div><div>'+noMeasureMsg+'</div></td></tr></table>');
				//Ext.getCmp('dialpanel').update('<div style="border:1px solid red;text-align:center;margin:5px"><b>'+noGraphTitle+'</b></div><br/><br/><table width="100%" style="text-align:center"><tr><td><div class="iconExclamation" style="margin:0px auto 0px auto"></div><div>'+noMeasure+'</div></td></tr></table>');
				getDigitalObj.hide();
			}
			else if ( Ext.isEmpty( dialData ))
			{				
				
				var noGraphTitle = resultData['APP_TAB_NoGraphTitle'];
				var dialMsg = resultData['DIAL_MSG'];
				var noMeasureMsg = testExcludedorDisabledMsg;

				if( dialMsg == undefined || Ext.isEmpty(dialMsg)){
					noMeasureMsg = noMeasure;
				}

				Ext.getCmp('dialpanel').removeAll();
				Ext.getCmp('dialpanel').flex=1;
				var dialNoMes = {
					xtype:'container',
					margin:'1px 0px 0px 0',
					//style:{'border':'1px solid blue'},
					width:'100%',
					height: 200,
					html:'<div class="noGraphTitle" style="padding-top:5px;">'+noGraphTitle+'</div><table width="100%" height="189px" style="text-align:center"><tr><td><div class="iconInformation" style="margin:0px auto"></div><div>'+noMeasureMsg+'</div></td></tr></table>'
					//html:'<table width="100%" height="100%" style="text-align:center"><tr><td><div>'+noGraphTitle+'</div><div class="iconExclamation" style="margin:0px auto"></div><div>'+noMeasure+'</div></td></tr></table>'
					//html:'<div style="text-align:center"><b>'+noGraphTitle+'</b></div><table width="100%" style="margin-top:30px"><tr><td align="center" ><div class="iconExclamation" style="margin:0px auto"></div><div>'+noMeasure+'</div></td></tr></table>'
				};
				var dialObj = Ext.getCmp('dialpanel');
				dialObj.removeAll();
				dialObj.add(dialNoMes);
				dialObj.doComponentLayout();
				//getDigitalObj.hide();
			}
			/*else if ( Ext.isEmpty( digitalData ) )
			{
				var noGraphTitle = resultData['DIGITAL_TITLE'];				
				getDigitalObj.removeAll();
				var dialNoMes = {
					xtype:'container',
					margin:'1px 0px 0px 0',
					html:'<div style="text-align:center"><b>'+noGraphTitle+'</b></div><table width="100%" style="margin-top:30px"><tr><td align="center" ><div class="iconExclamation" style="margin:0px auto"></div><div>'+noMeasure+'</div></td></tr></table>'
				};				
				getDigitalObj.add(dialNoMes);
				getDigitalObj.doComponentLayout();
			}*/
			else if(Ext.isEmpty( digitalData )){
				getDigitalObj.hide();
			}

			getDigitalObj.add(atAGlanceArr);
			getDigitalObj.doComponentLayout( );

			// To load configurations

			var configsData = resultData['CONFIG_DATAS'];
			if ( !Ext.isEmpty( configsData ) )
			{
				atAGlanceArr.splice(0, atAGlanceArr.length);
				var cnt = 0; //To count no of sparkline
				for ( var i = 0; i < configsData.length; i++ )
				{
					var configData = configsData[i];
					var configurationTitle = configData['TITLE'];
					var type = configData['TYPE'];
					type = type.toLowerCase();
					var adminPermission = configData['ADMIN_PERMISSION'];
					var toolsArr = new Array();
					if ( adminPermission.toLowerCase() == 'true' )
					{
						toolsArr.push({
									/*xtype: 'button',
									iconCls: 'iconMaximize',
									dataArray: 'config-'+i,
									style: {
										background: 'none',
										border: '0px'
									},
									handler: function()
									{
										var tmpDataArray = this.dataArray;
									}*/
									//hidden for remove the maximize icon
								});
					}
					else
					{
						toolsArr.push({
									/*xtype: 'button',
									iconCls: 'iconMaximize',
									dataArray: 'config-'+i,
									handler: function()
									{
										var tmpDataArray = this.dataArray;
									}*/
									//hidden for remove the maximize icon
								});
					}
					if ( type == 'table' )
					{
						var configuration = configData['CONFIGURATION'];
						var genHTML = '';
						if ( configuration != '-' )
						{
							genHTML = '<div class="x-table"><table cellspacing="0" cellpadding="0" border="0" class="x-grid-table" width="100%">';
							for ( var j = 0; j < configuration.length; j++ )
							{
								var getVal = '';
								/* if ( configuration[j]['TITLE'] == undefined)
								{
									//genHTML +='<thead><tr class="x-grid-row"><td colspan="2" class="x-grid-cell x-grid-cell-first"><div class="x-grid-cell-inner">'+configuration[j]['TITLE']+'</div></td></tr></thead><tbody>';
								} */
								 if(configuration[j]['TITLE'] == '&nbsp;')
								{
								//genHTML +='<tr><td colspan="2">-xfgdgdg</td></tr>';
								}
								else if ( configuration[j]['TITLE'] != undefined)
								{
									genHTML +='<thead><tr class="x-grid-row"><td colspan="2" class="x-grid-cell x-grid-cell-first"><div class="x-grid-cell-inner">'+configuration[j]['TITLE']+'</div></td></tr></thead><tbody>';
								}
								else
								{
									var getVal1 = '', getVal2 = '';
									if ( configuration[j]['VALUE_1'] != undefined )
									{
										getVal1 = configuration[j]['VALUE_1'];
									}
									if ( configuration[j]['VALUE_2'] != undefined )
									{
										getVal2 = configuration[j]['VALUE_2'];
									}
									genHTML +='<tr class="x-grid-row"><td class="x-grid-cell"><div class="x-grid-cell-inner">'+getVal1+'</div></td><td class="x-grid-cell"><div class="x-grid-cell-inner">'+getVal2+'</div></td></tr>';
								}
							}
							genHTML +='</tbody></table></div>';
						}
						else
						{
							var msg = configData['MSG'];
							genHTML = '<table cellspacing="0" cellpadding="0" border="0" width="100%"><tbody>'
									+'<tr class="x-grid-row"><td width="100%" height="170px" valign="middle" align="center"><div class="iconInformation" width="100%" style="text-align:center;"></div><div>'+msg+'</div></td></tr></tbody></table>';
						}

						atAGlanceArr.push(
						{
							xtype: 'panel',
							height: 200,
							cls:'datapanel',
							margin:10,
							padding:0,
							frame:true,
							border:true,
							title: configurationTitle,
							id: 'config-'+i,
							bodyStyle:{'overflow-y': 'auto'},
							//tools: toolsArr, hidden for remove the maximize icon
							html: genHTML
						});
					}
					else if ( type == 'spark' )
					{
						var configuration = configData['CONFIGURATION'];
						var genHTML = '';
						var kpiwidth='';
						if(configurationTitle=='Key Performance Indicators')
						{
							kpiwidth='80%';
						}
						else
						{
							kpiwidth='40%';
						}
						if ( configuration != '-' )
						{
							genHTML = '<div class="x-table"  class="borTop"><table cellspacing="0" cellpadding="0" class="x-grid-table" width="100%"><tbody>';
							for ( var j = 0; j < configuration.length; j++ )
							{
								var conData = configuration[j];
								genHTML += '<tr class="x-grid-row">';
								var genTD = '';
								for ( var kk in conData )
								{
									var getValue = conData[kk];
									if ( kk.toLowerCase() == 'state' )
									{
										genTD += '<td class="x-grid-cell" width="25px" ><div class="x-grid-cell-inner" ><div class="stateSymbol_'+getValue+'"></div></div></td>';
									}
									else if ( kk.toLowerCase() == 'link' )
									{
										var getLinkObj = getValue;
										var getMeasures = getLinkObj['MEASURE'];

										if ( getLinkObj['Thread_METHOD_NAME'] != undefined || getLinkObj['Thread_PARAMS'] != undefined )
										{
											var Thread_METHOD_NAME = getLinkObj['Thread_METHOD_NAME'];
											var Thread_PARAMS_cnt = getLinkObj['PARAMS'];
											var Thread_PARAMS = getLinkObj[Thread_PARAMS_cnt];
											var measureName = getLinkObj['measureName'];
                                                                                
											var timeVal = getLinkObj['timeVal'];
                                            if(Thread_PARAMS!=null && Thread_PARAMS!=undefined)                     
											{
												if(Thread_PARAMS.indexOf('&s_measure') > -1 )
											{
												Thread_PARAMS = Thread_PARAMS.replace(/(s_measure=)[^\&]+/, '$1' + measureName);	
											}
											else
											{
												Thread_PARAMS += "&s_measure="+measureName;
											}    
											}
											genTD += '<td class="x-grid-cell" width='+kpiwidth+'><div class="x-grid-cell-inner"><a href="javascript:void(0);" onclick="javascript:'+Thread_METHOD_NAME+'(\''+Thread_PARAMS+'\',\''+timeVal+'\');" title="'+getMeasures+'">'+getMeasures+'</a></div></td>';
										}
										else
										{
											genTD += '<td class="x-grid-cell" width='+kpiwidth+'><div class="x-grid-cell-inner">'+getMeasures+'</div></td>';
										}
									}
									else if ( kk.toLowerCase() == 'xml_data' )
									{
										var xmlData = getValue;
										if ( xmlData != '-' )
										{
											var swfPath = getValue['SWF_PATH'];
											genTD += '<td class="x-grid-cell" width="40%"><div class="x-grid-cell-inner" ><div id="chartSparkContainer'+cnt+'" style="height:18px;cursor:pointer"></div></div></td>';
										}
										else
										{
											genTD += '<td class="x-grid-cell" width="40%"><div class="x-grid-cell-inner" ><div id="chartSparkContainer'+cnt+'" style="height:18px;">&nbsp;</div></div></td>';
										}
										cnt++;
									}
									else if ( kk.toLowerCase() == 'value' )
									{
										if(componentType == 'Java_virtual_machine')
										{
											if(getValue > 0)
											{
												genTD += '<td class="x-grid-cell"><div class="x-grid-cell-inner"><a href="javascript:void(0);" onclick="javascript:'+Thread_METHOD_NAME+'(\''+Thread_PARAMS+'\',\''+timeVal+'\');" title="'+getMeasures+'">'+getValue+'</a></div></td>';
											}
											else
											{			
												if(getValue!=undefined && getValue > 0 && getValue!='' && !isNaN(getValue))
												{
													genTD += '<td class="x-grid-cell" width="100px"><div class="x-grid-cell-inner" >'+Number(getValue).toFixed(2)+'</div></td>';
												}
												else
												{
													genTD += '<td class="x-grid-cell" width="100px"><div class="x-grid-cell-inner">'+getValue+'</div></td>';
												}
											}
										}
										else
										{	
											if(getValue!=undefined && getValue > 0 && getValue!='' && !isNaN(getValue))
											{
												genTD += '<td class="x-grid-cell" width="100px"><div class="x-grid-cell-inner">'+Number(getValue).toFixed(2)+'</div></td>';
											}
											else
											{
												genTD += '<td class="x-grid-cell" width="100px"><div class="x-grid-cell-inner">'+getValue+'</div></td>';
											}
										}
										
									}
								}
								genHTML += genTD+'</tr>';
							}
							genHTML +='</tbody></table></div>';
						}
						else
						{
							var msg = configData['MSG'];
							genHTML = '<table cellspacing="0" cellpadding="0" border="0"  width="100%"><tbody>'
									+'<tr class="x-grid-row"><td width="100%" height="170px" valign="middle" align="center"><div class="iconInformation" width="100%" style="text-align:center;"></div><div>'+msg+'</div></td></tr></tbody></table>';
						}

						atAGlanceArr.push(
						{
							xtype: 'panel',
							height: 200,
							cls:'datapanel',
							padding:0,
							frame:true,
							border:true,
							margin:10,
							title: configurationTitle,
							dataArray: configuration,
							id: 'config-'+i,
							//tools: toolsArr, hidden for remove the maximize icon
							html: genHTML
						});
					}
					else if ( type == 'grid' )
					{
						var XType = '';
						var columnWidth = 0.5;
						if ( configData['COLUMN_WIDTH'] != undefined )
						{
							columnWidth = configData['COLUMN_WIDTH'];
						}
						if ( configData['GRID_COLUMNS'] != undefined && configData['GRID_VALUES'] != undefined )
						{
							var gridCols = configData['GRID_COLUMNS'];
							var gridVals = configData['GRID_VALUES'];
							var columnArr = new Array();
							var gridStoreModel = new Array();
							if ( !Ext.isEmpty( gridCols ) )
							{
								for ( var l = 0 ; l < gridCols.length; l++ )
								{
									if(l==0)
									{
										gridStoreModel[gridStoreModel.length] = {name : 'COLUMN_'+l , type : 'string'};
									}
									else
									{
										gridStoreModel[gridStoreModel.length] = {name : 'COLUMN_'+l , type : 'FLOATORSTRING'};
									}
									columnArr.push({
										header: gridCols[l],
										flex: 0.2,
										dataIndex: 'COLUMN_'+l
									});
								}
							}
							XType = {
								xtype: 'customgrid',
								height:174,
								width: '100%',
								style:{'box-shadow':'none','-webkit-box-shadow':'none'},
								cls:'gridSkin borTop',
								store: new Ext.data.Store({
									fields: gridStoreModel,
									data: gridVals
								}),
								columns: columnArr
							};
						}
						else
						{
							var msg = configData['MSG'];
							XType = {
								xtype: 'container',
								width: '100%',
								height: '100%',
								html: '<table width="100%" height="100%"><tr><td align="center"><div class="iconInformation"></div>'+msg+'</td></tr></table>'
							};
						}
						atAGlanceArr.push(
						{
							xtype: 'panel',
							height: 200,
							cls:'datapanel',
							padding:0,
							frame:true,
							scroll:false,
							autoScroll:false,
							border:true,
							margin:10,
							columnWidth: columnWidth,
							title: configurationTitle,
							id: 'config-'+i,
							//tools: toolsArr, hidden for remove the maximize icon
							items: [XType]
						});
					}
					else if ( type == 'xtemplate' )
					{
						var XType = '';
						var columnWidth = 0.5;
						if ( configData['COLUMN_WIDTH'] != undefined )
						{
							columnWidth = configData['COLUMN_WIDTH'];
						}
						var values = configData['CONFIGURATION'];
					
						if ( values!=null && !Ext.isEmpty(values) && values != '-' )
						{
							var tpl = new Ext.XTemplate(
								'<div class="x-table" width="100%" class="borTop">',
								'<table cellspacing="0" cellpadding="0" border="0" class="x-grid-table x-grid-table-resizer" width="100%">',
								'<tbody>',
							    '<tpl for=".">',
							    '<tr class="x-grid-row">',
							        '<td class=" x-grid-cell x-grid-cell-first" width="50%"><div class="x-grid-cell-inner">{VALUE_1}</div></td>',
							        '<td class=" x-grid-cell x-grid-cell-first" width="50%"><div class="x-grid-cell-inner"><img src="{VALUE_2}" /></div></td>',
							        '<td class=" x-grid-cell x-grid-cell-first" width="50%"><div class="x-grid-cell-inner">{VALUE_3}</div></td>',
							        '<td class=" x-grid-cell x-grid-cell-first" width="50%"><div class="x-grid-cell-inner">{VALUE_4}</div></td>',
							    '</tr>',
							    '</tpl>',
							    '</tbody>',
							    '</table>',
							    '</div>'
							);
							var genHTML = '<div class="x-table"  class="borTop"><table cellspacing="0" cellpadding="0" border="0" class="x-grid-table" width="100%"><tbody>';
							for ( var ii = 0; ii < values.length; ii++ )
							{
								var value1 = values[ii]['VALUE_1'];
								var value2 = values[ii]['VALUE_2'];
								var value3 = values[ii]['VALUE_3'];
								var value4 = values[ii]['VALUE_4'];

								if ( ii == 0 )
								{
								//	value2 = '<img src="'+value2+'" />';
									value2 = '<img class='+value2+' src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw=="/>';

								}

								genHTML += '<tr class="x-grid-row">'
											+'<td class=" x-grid-cell" width="40%" style="padding:2px"><div class="x-grid-cell-inner">'+value1+'</div></td>'
											+'<td class=" x-grid-cell" width="10%" ><div class="x-grid-cell-inner">'+value2+'</div></td>'
											+'<td class=" x-grid-cell" width="40%" style="padding:2px"><div class="x-grid-cell-inner">'+value3+'</div></td>'
											+'<td class=" x-grid-cell" width="10%" style="padding:2px"><div class="x-grid-cell-inner">'+value4+'</div></td>'
											+'</tr>';
							}
							genHTML += '</tbody></table>';
							XType = {
									xtype: 'container',
									width: '100%',
									//height: 200, /* for bug id - 12824 - Unnecessary space is seen in the dashboard.  */
									border:true,
									margin:0,
									padding:0,
									autoScroll: true,
									html: genHTML
								};
						}
						else
						{

						}
						if ( XType != '' )
						{
							atAGlanceArr.push(
							{
								xtype: 'panel',
								//height: 200, /* for bug id - 12824 - Unnecessary space is seen in the dashboard.  */
								height: '100%',
								cls:'datapanel',
								margin:10,
								border:false,
								frame:false,
								columnWidth: columnWidth,
								title: configurationTitle,
								id: 'config-'+i,
								//tools: toolsArr, hidden for remove the maximize icon
								items: [XType]
							});
						}
					}
					else if(type == 'fusion_chart')
					{
						var XML_DATA = configData['XML_DATA'];
						var SWF_PATH = configData['SWF_PATH'];
						var HEIGHT = configData['HEIGHT'];
						var WIDTH = configData['WIDTH'];
						atAGlanceArr.push(
						{
							xtype: 'panel',
							//cls: 'block1',
							frame:false,
							height: 200,
							title: configurationTitle,
							id: 'Config-'+i,
						//	tools: toolsArr,
							html: '<div id="LayerwiseHealth" style="margin:0px auto 0px auto"></div>',
							listeners:{
								'afterrender': function(container)
								{
									if ( XML_DATA != '-' )
									{
											try
											{
												var barChart = {};
												barChart = jQuery.extend(true, {}, getHighChartsBarInstance('LayerwiseHealth', 160,450), barChart);										
												barChart.setData(XML_DATA, currentDateFormat, "",'stackedBar');
												barChart.drawChart();
											}
											catch (barChartEx)
											{
												console.log(barChartEx);
											}
									}
									else
									{
										Ext.get('LayerwiseHealth').update('<div style="border:0px solid blue;margin:0px auto"><div class="iconInformation" width="100%" style="text-align:center;margin:0px auto;margin-top: 20px;"></div><div style="text-align:center;margin:0px auto;">'+noMeasureExcl+'</div></div>');
									}
							}
							}
						});
					}
					else
					{
						atAGlanceArr.push(
						{
							xtype: 'panel',
							height: 200,
							cls:'datapanel',
							border:true,
							margin:10,
							frame:true,
							title: configurationTitle,
							id: 'config-'+i,
						//	tools: toolsArr,
							html: '<table cellspacing="0" cellpadding="0" border="0" class="x-grid-table x-grid-table-resizer" width="100%"><tbody><tr class="x-grid-row"><td width="100%" height="170px" valign="middle" align="center"><div class="iconInformation" width="100%" style="text-align:center;margin:0px auto"></div><div>'+noMeasureExcl+'</div></td></tr></tbody></table>'
						});
					}
				}
				configObj.add(atAGlanceArr);
				configObj.doComponentLayout( );
				var counter = 0;
				var sparkCnt = 0;
				for ( var ii = 0; ii < configObj.items.length; ii++ )
				{
					var getSparkBlockObj = Ext.getCmp('config-'+ii);
					if ( getSparkBlockObj != undefined && getSparkBlockObj.dataArray != null )
					{
						var getDataArray = getSparkBlockObj.dataArray;
						var arrCnt = 0;
						for ( var jj = counter; jj < cnt; jj++ )
						{
							var getInnerHTML = getSparkBlockObj.getEl().dom.innerHTML;
							if ( getInnerHTML.indexOf('chartSparkContainer'+jj) > -1 )
							{
								var tmpXMLData = getDataArray[arrCnt]['XML_DATA'];
								if ( tmpXMLData != '-' )
								{
									var swfPath = getDataArray[arrCnt]['SPARK_PATH'];
									/*if ( FusionCharts('spark-'+jj) )
									{
										FusionCharts('spark-'+jj).dispose();
									}*/
								    var sparkChart = getSparkCharts('chartSparkContainer'+jj,'100','20',tmpXMLData,swfPath);

								}
								else
								{
//									alert('I am Empty');
								}
							}
							arrCnt++;
							sparkCnt++;
						}
						counter += getSparkBlockObj.dataArray.length;
					}
				}
			}
		}
		
		
		appLastGraphTypeLoaded = 'SummaryAtGlance';
	},
	loadScreenLabels: function ( ObjectArr )
	{
		for ( var key in ObjectArr )
		{
			if ( Ext.getCmp(key) != undefined )
			{
				Ext.getCmp(key).setFieldLabel(ObjectArr[key]);
			}
		}
	},
	setValueWithOptionInList : function(fieldName, list, value)
	{
		if ( !Ext.isEmpty( list) )
		{
			Ext.getCmp(fieldName).getStore().loadRawData(list);
		}
		Ext.getCmp(fieldName).suspendEvents(false);
		if( !Ext.isEmpty(value) )
		{
			Ext.getCmp(fieldName).setValue(value);
		}
		else
		{
			Ext.getCmp(fieldName).setValue(list[0].valueField);
		}
		Ext.getCmp(fieldName).resumeEvents();
	},
	setComboOptionsInList : function(fieldName, list, value) {
		var selector = '';
		if(fieldName == 'threadnameid'){
			selector = 'multiselect[itemId='+fieldName+']';
		}
		else{
			selector = 'combo[itemId='+fieldName+']'
		}
		var field = this.getStackThreadDetails().down(selector);
		field.getStore().loadRawData(list);
		field.suspendEvents(true);
		if(value=='')
		{
			value = field.getStore().getAt(0).get('value');
		}
		field.setValue(value);
		field.resumeEvents();
	},
	ddOnclick: function(urlData)
	{
		Ext.getCmp('subapplicationpanelId').hide();
		Ext.getCmp('subapplicationtabpanelId').hide();
		comboChangeURL = '/final/monitor/egDashTimelineJSON.jsp?'+urlData+'&graphType=DDgraph';
		var wobj = this.getApplicationpanel();
		wobj.remove('fullviewpanel');
		var fullviewObj = {
			xtype:'fullviewpanel',
			Dataurl:'/final/monitor/egDashTimelineJSON.jsp?'+urlData+'&graphType=DDgraph',
			viewType:'barGraph',
			gtype:'bar'
		};
		wobj.add(fullviewObj);
		wobj.doLayout();	
	},
	comparisionBarOnclick: function(urlData)
	{
		Ext.getCmp('subapplicationpanelId').hide();
		Ext.getCmp('subapplicationtabpanelId').hide();
		urlData = urlData.split('?');
		var params = urlData[1];
		comboChangeURL = '/final/monitor/egDashTimelineJSON.jsp?'+params+'&graphType=comparisionBargraph';
		var wobj = this.getApplicationpanel();
		wobj.remove('fullviewpanel');
		var fullviewObj = {
			xtype:'fullviewpanel',
			width : (Ext.getBody().getViewSize().width-10),
			height : (Ext.getBody().getViewSize().height-60),
			Dataurl:'/final/monitor/egDashTimelineJSON.jsp?'+params+'&graphType=comparisionBargraph',
			viewType:'barGraph',
			gtype:'bar'
		};
		wobj.add(fullviewObj);
		wobj.doLayout();
	},
	trendGraphOnclick: function(urlData)
	{
		Ext.getCmp('subapplicationpanelId').hide();
		Ext.getCmp('subapplicationtabpanelId').hide();
		urlData = urlData.split('?');
		var params = urlData[1];
		comboChangeURL = '/final/monitor/egDashTimelineJSON.jsp?'+params+'&graphType=Trendgraph';
		var wobj = this.getApplicationpanel();
		wobj.remove('fullviewpanel');
		var fullviewObj = {
			xtype:'fullviewpanel',
			width : (Ext.getBody().getViewSize().width-10),
			height : (Ext.getBody().getViewSize().height-60),
			Dataurl:'/final/monitor/egDashTimelineJSON.jsp?'+params+'&graphType=Trendgraph',
			viewType:'trendGraph',
			gtype:'trend'
		};
		wobj.add(fullviewObj);
		wobj.doLayout();
	},
	summaryGraphOnclick: function(urlData)
	{
		Ext.getCmp('subapplicationpanelId').hide();
		Ext.getCmp('subapplicationtabpanelId').hide();
		urlData = urlData.split('?');
		var params = urlData[1];
		comboChangeURL = '/final/monitor/egDashTimelineJSON.jsp?'+params+'&graphType=Summarygraph';
		var wobj = this.getApplicationpanel();
		wobj.remove('fullviewpanel');
		var fullviewObj = {
			xtype:'fullviewpanel',
			width : (Ext.getBody().getViewSize().width-10),
			height : (Ext.getBody().getViewSize().height-60),
			Dataurl:'/final/monitor/egDashTimelineJSON.jsp?'+params+'&graphType=Summarygraph',
			viewType:'Summarygraph',
			gtype:'summary'
		};
		wobj.add(fullviewObj);
		wobj.doLayout();
	},
	ComparisonGraphGraphOnClick: function(urlData)
	{
		Ext.getCmp('subapplicationpanelId').hide();
		Ext.getCmp('subapplicationtabpanelId').hide();
		urlData = urlData.split('?');
		var params = urlData[1];
		comboChangeURL = '/final/monitor/egDashTimelineJSON.jsp?'+params+'&graphType=comparisionBargraph';
		var wobj = this.getApplicationpanel();
		wobj.remove('fullviewpanel');
		var fullviewObj = {
			xtype:'fullviewpanel',
			width : (Ext.getBody().getViewSize().width-10),
			height : (Ext.getBody().getViewSize().height-60),
			Dataurl:'/final/monitor/egDashTimelineJSON.jsp?'+params+'&graphType=comparisionBargraph',
			viewType:'barGraph',
			gtype:'bar'
		};
		wobj.add(fullviewObj);
		wobj.doLayout();
	},
	DDGraphOnClick: function(urlData)
	{
		Ext.getCmp('subapplicationpanelId').hide();
		Ext.getCmp('subapplicationtabpanelId').hide();
		urlData = urlData.split('?');
		var params = urlData[1];
		comboChangeURL = '/final/monitor/egDashTimelineJSON.jsp?'+params+'&graphType=DDgraph';
		var wobj = this.getApplicationpanel();
		wobj.remove('fullviewpanel');
		var fullviewObj = {
			xtype:'fullviewpanel',
			width : (Ext.getBody().getViewSize().width-10),
			height : (Ext.getBody().getViewSize().height-60),
			Dataurl:'/final/monitor/egDashTimelineJSON.jsp?'+params+'&graphType=DDgraph',
			viewType:'barGraph',
			gtype:'bar'
		};
		wobj.add(fullviewObj);
		wobj.doLayout();
	},
	MeasureGraphOnClick: function(urlData)
	{
		Ext.getCmp('subapplicationpanelId').hide();
		Ext.getCmp('subapplicationtabpanelId').hide();
		urlData = urlData.split('?');
		var params = urlData[1];
		comboChangeURL = '/final/monitor/egDashTimelineJSON.jsp?'+params+'&graphType=measureGraph';
		var wobj = this.getApplicationpanel();
		wobj.remove('fullviewpanel');
		var fullviewObj = {
			xtype:'fullviewpanel',
			width : (Ext.getBody().getViewSize().width-10),
			height : (Ext.getBody().getViewSize().height-60),
			Dataurl:'/final/monitor/egDashTimelineJSON.jsp?'+params+'&graphType=measureGraph',
			viewType:'measureGraph',
			gtype:'measure'
		};
		wobj.add(fullviewObj);
		wobj.doLayout();
	},
	loadFullViewPanel: function()
	{
		var me =this;
		var fullViewPanelObj = Ext.getCmp('fullviewId');
		var urlData = fullViewPanelObj.Dataurl;
		var fullViewPnlObj = fullViewPanelObj.up('panel');
		fullViewPanelObj.setLoading(true,true);
		urlData +='&screenWidth='+(fullViewPnlObj.getWidth()-10)+'&screenHeight='+(fullViewPnlObj.getHeight());
		var viewType = Ext.getCmp('fullviewId').viewType;
		if (viewType == 'barGraph')
		{
			Ext.getCmp('period').hide();
			//Ext.getCmp('modeID').hide();
			Ext.getCmp('graphID').hide();
			Ext.getCmp('Show').show();
		}
		else if (viewType == 'trendGraph')
		{
			Ext.getCmp('period').show();
		//	Ext.getCmp('modeID').show();
			Ext.getCmp('graphID').show();
			Ext.getCmp('Show').hide();
		}
		else if (viewType == 'Summarygraph')
		{
			Ext.getCmp('period').show();
		//	Ext.getCmp('modeID').show();
			Ext.getCmp('Show').hide();
		}
		else if (viewType == 'measureGraph' )
		{
			Ext.getCmp('period').hide();
			Ext.getCmp('Show').hide();
		//	Ext.getCmp('modeID').show();
		}			
		Ext.Ajax.request({
			url:urlData,
			scope:this,
			method: 'POST',
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;						
					var jsonData = Ext.decode(jsonText);
					var dateArray = jsonData['dateArrayValues'];
					var trendGrpDuration = jsonData['trendGrpDuration'];
					if (trendGrpDuration!=null && trendGrpDuration!='' && !Ext.isEmpty(trendGrpDuration))
					{
						var durationLabel = trendGrpDuration['monitor.dashboard.Duration'];
						var selectedDuration = trendGrpDuration['selectedDuration'];
						var durationComboVal = trendGrpDuration['trendGrpDurationArr'];

						var durationObj = Ext.getCmp('period');
						durationObj.setFieldLabel(durationLabel);
						durationObj.getStore().loadRawData(durationComboVal);
						durationObj.setValue(selectedDuration);
					}
					var barGraphVal = jsonData['BARGRAPH'];
					if( barGraphVal!=null && barGraphVal!=''& !Ext.isEmpty(barGraphVal))
					{
						var showLabel = barGraphVal['monitor.common.Show'];
						var selectedShowVal = barGraphVal['selectedShowCombo'];
						var showComboVal = barGraphVal['barGraphShowCombo'];
					//	var historyLabel = barGraphVal['monitor.measure.History'];
						var showComboObj = Ext.getCmp('Show');
						showComboObj.setFieldLabel(showLabel);
						showComboObj.getStore().loadRawData(showComboVal);
						showComboObj.setValue(selectedShowVal);
					}
					var timelineValues = jsonData['timelineCombo'];
					if ( timelineValues!=null && timelineValues!=''& !Ext.isEmpty(timelineValues) )
					{
						var timelineLabel = timelineValues['monitor.dashboard.TimeLine'];
						var selectedTimelineCombo = timelineValues['selectedTimelineCombo'];
						var TimelineComboVal = timelineValues['timelineCombo'];

						var timelineObj = Ext.getCmp('high_er_timeline');
						timelineObj.setFieldLabel(timelineLabel);
						timelineObj.getStore().loadRawData(TimelineComboVal);
						timelineObj.setValue(selectedTimelineCombo);
					}	
					var fromData = jsonData['fromValues'];
					if ( fromData!=null && fromData!=''& !Ext.isEmpty(fromData) )
					{
						var fromlabel = fromData['monitor.VirtualDashboard.From'];
						var isFromDisabled = fromData['from'];
						var fromValue = fromData['value'];
						var fromObj = Ext.getCmp('high_er_stdate');
						fromObj.setFieldLabel(fromlabel);
						fromObj.setDisabled(isFromDisabled);						
						
						fromObj.dataArray = dateArray[0];
						fromObj.setValue(dateArray[6]);
					}
					var startHr = jsonData['startHr'];
					if ( startHr!=null && startHr!=''& !Ext.isEmpty(startHr) )
					{
						var hrLabel = startHr['monitor.VirtualDashboard.Hr'];
						var isStartHrEnabled = startHr['isStartHrEnabled'];
						var selectedStartHr = startHr['selectedStartHr'];
						var startHrCmbo = startHr['startHrArray'];

						var startHrObj = Ext.getCmp('high_er_sthr');
						startHrObj.setFieldLabel(hrLabel);
						startHrObj.getStore().loadRawData(startHrCmbo);						
						startHrObj.setDisabled(isStartHrEnabled);

						startHrObj.dataArray = dateArray[2];
						startHrObj.setValue(dateArray[7]);
					}
					var toValues = jsonData['toValues'];
					if ( toValues!=null && toValues!=''& !Ext.isEmpty(toValues) )
					{
						var toLabel = toValues['monitor.VirtualDashboard.To'];
						var isToDisabled = toValues['to'];
						var value = toValues['value'];
						var toObj = Ext.getCmp('high_er_enddate');
						toObj.setDisabled(isToDisabled);
						toObj.setFieldLabel(toLabel);					

						toObj.dataArray = dateArray[1];
						toObj.setValue(dateArray[9]);
					}
					var endHr = jsonData['endHr'];
					if ( endHr!=null && endHr!=''& !Ext.isEmpty(endHr) )
					{
						var hrLabel = endHr['monitor.VirtualDashboard.Hr'];
						var isEndHrEnabled = endHr['isEndHrEnabled'];
						var selectedEndHr = endHr['selectedEndHr'];
						var endHrCmbo = endHr['endHrArray'];

						var endHrObj = Ext.getCmp('high_er_endhr');
						endHrObj.setFieldLabel(hrLabel);
						endHrObj.getStore().loadRawData(endHrCmbo);						
						endHrObj.setDisabled(isEndHrEnabled);

						endHrObj.dataArray = dateArray[3];
						endHrObj.setValue(dateArray[10]);
					}
				/*	var ModeCombo = jsonData['ModeCombo'];
					if (ModeCombo!=null && ModeCombo!=undefined && ModeCombo!='')
					{
						var modeComboVal = ModeCombo['comparisonBarModeArr'];
						var selectedMode = ModeCombo['selectedMode'];

						var modeObj = Ext.getCmp('modeID');
						modeObj.getStore().loadRawData(modeComboVal);
						modeObj.setValue(selectedMode);
					}*/
					var GraphCombo = jsonData['GraphCombo'];
					if (GraphCombo!=null && GraphCombo!=undefined && GraphCombo!='')
					{
						var graphLabel = GraphCombo['monitor.dashboard.Graph'];
						var graphComboVal = GraphCombo['trendGraph'];
						var selectedGraph = GraphCombo['selectedGraph'];

						var graphObj = Ext.getCmp('graphID');
						graphObj.setFieldLabel(graphLabel);
						graphObj.getStore().loadRawData(graphComboVal);
						graphObj.setValue(selectedGraph);
					}
					var ddGraphLink = jsonData['ddGraphObj'];
					if ( ddGraphLink!=null && ddGraphLink!=''& !Ext.isEmpty(ddGraphLink) )
					{
						var DetailsLink = ddGraphLink['DetailsLink'];
						var DetailsLabel = ddGraphLink['DetailsLabel'];	
						if (DetailsLink == 'true')
						{
							Ext.getCmp('detailsID').show();
						}						
					}
					var fullViewContObj = Ext.getCmp('fullViewBarId');
					fullViewContObj.removeAll();
					fullViewContObj.update('');
					if (viewType == 'measureGraph' )
					{
						var MeasureGraphImage = jsonData['MeasureGraphImage'];
						if (MeasureGraphImage!=null && MeasureGraphImage!=''& !Ext.isEmpty(MeasureGraphImage) && MeasureGraphImage!=undefined)
						{
							var DATA = MeasureGraphImage['DATA'];
							var HIGH_CHART = MeasureGraphImage['HIGH_CHART'];
							var isHighChartEnabled = '';
							if (HIGH_CHART == 'highcharts')
							{
								isHighChartEnabled = true;
							}
							else
							{
								isHighChartEnabled = false;
							}
							var minMaxTable = jsonData['minMaxTable'];
							var minMaxTableHeadersArray = '';
							var measuresTableDataArray = '';
							if (minMaxTable!=null && minMaxTable!=''& !Ext.isEmpty(minMaxTable) && minMaxTable!=undefined)
							{
								minMaxTableHeadersArray = minMaxTable['minMaxTableHeadersArray'];
							}
							var measuresTable = jsonData['measuresTable'];
							if (measuresTable!=null && measuresTable!=''& !Ext.isEmpty(measuresTable) && measuresTable!=undefined)
							{						
								measuresTableDataArray = measuresTable['measuresTableDataArray'];	
							}
							if (DATA == 'true')
							{
								var img_src = MeasureGraphImage['iframeSrc'];
								me.loadMeasureGraph(img_src,isHighChartEnabled);
							}
							else
							{
								var Msg = MeasureGraphImage['Msg'];
								fullViewContObj.update(Msg);
								fullViewPanelObj.setLoading(false);
							}
						}
					}
					else
					{
						var FullViewXmlData = jsonData['FullViewXmlData'];
						if ( FullViewXmlData!=null && FullViewXmlData!=''& !Ext.isEmpty(FullViewXmlData) )
						{
							var data = FullViewXmlData['DATA'];							
							if (data == 'true')
							{			
								var WIDTH = FullViewXmlData['WIDTH'];
								var HEIGHT = FullViewXmlData['HEIGHT'];
								HEIGHT = parseInt(HEIGHT);
								fullViewContObj.add({
									xtype: 'container',
									id: 'fullViewPanelBigId',
									xmlData:FullViewXmlData,
									style:{'text-align':'center','margin':'10px auto'},
									width:WIDTH,
									//height:HEIGHT,
									listeners:
									{
										'afterrender': function(thisObj)
										{
												var XMLDATA = thisObj.xmlData['XMLDATA'];
												try
												{
													if (viewType == 'Summarygraph')
													{
														var barChart = {};
														barChart = jQuery.extend(true, {}, getHighChartsBarInstance(thisObj.id, 480,WIDTH), barChart);	
														barChart.setData(XMLDATA, currentDateFormat, '','stackedColumn');
														barChart.drawChart();
													}
													else if (viewType == 'trendGraph')
													{
														var widthInPix = thisObj.xmlData['WIDTH'];
														var heightInPix = thisObj.xmlData['HEIGHT'];
														var lineChart = {};
														lineChart = jQuery.extend(true, {}, createLineChart(thisObj.id,heightInPix,widthInPix), lineChart);
														lineChart.setData(XMLDATA, currentDateFormat,'' ,'line',true);
														lineChart.drawChart();
													}
													else
													{
														var barChart = {};
														barChart = jQuery.extend(true, {}, getHighChartsBarInstance(thisObj.id, 450,WIDTH -150), barChart);	
														barChart.setData(XMLDATA, currentDateFormat, '','bar');
														barChart.drawChart();
													}	
													fullViewPanelObj.setLoading(false);
												}
												catch (barChartEx)
												{

													console.log(barChartEx);
												}

										}
									}
								});										
							}
							else
							{
								var msg = FullViewXmlData['MSG'];
								fullViewContObj.update(msg);
							}						
						}
					}
				}
			}
		});		
	},
	loadFullViewGraph: function(urlData)
	{
		var fullViewPanelObj = Ext.getCmp('fullviewId');
		fullViewPanelObj.setLoading(true,true);
		var fullViewPnlObj = fullViewPanelObj.up('panel');
		urlData +='&screenWidth='+(fullViewPnlObj.getWidth()-10)+'&screenHeight='+(fullViewPnlObj.getHeight());
		var fullViewContObj = Ext.getCmp('fullViewBarId');
		fullViewContObj.removeAll();
		fullViewContObj.update('');
		var me = this;
		var viewType = Ext.getCmp('fullviewId').viewType;		
		Ext.Ajax.request({
			url:urlData,
			scope:this,
			method: 'POST',
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					if (viewType == 'measureGraph' )
					{
						var MeasureGraphImage = jsonData['MeasureGraphImage'];
						if (MeasureGraphImage!=null && MeasureGraphImage!=''& !Ext.isEmpty(MeasureGraphImage) && MeasureGraphImage!=undefined)
						{
							var DATA = MeasureGraphImage['DATA'];
							var HIGH_CHART = MeasureGraphImage['HIGH_CHART'];
							var isHighChartEnabled = '';
							if (HIGH_CHART == 'highcharts')
							{
								isHighChartEnabled = true;
							}
							else
							{
								isHighChartEnabled = false;
							}
							var minMaxTable = jsonData['minMaxTable'];
							var minMaxTableHeadersArray = '';
							var measuresTableDataArray = '';
							if (minMaxTable!=null && minMaxTable!=''& !Ext.isEmpty(minMaxTable) && minMaxTable!=undefined)
							{
								minMaxTableHeadersArray = minMaxTable['minMaxTableHeadersArray'];
							}
							var measuresTable = jsonData['measuresTable'];
							if (measuresTable!=null && measuresTable!=''& !Ext.isEmpty(measuresTable) && measuresTable!=undefined)
							{						
								measuresTableDataArray = measuresTable['measuresTableDataArray'];	
							}
							if (DATA == 'true')
							{
								var img_src = MeasureGraphImage['iframeSrc'];
								me.loadMeasureGraph(img_src,isHighChartEnabled);
							}
							else
							{
								var Msg = MeasureGraphImage['Msg'];
								fullViewContObj.update(Msg);
								fullViewPanelObj.setLoading(false);
							}							
						}
					}
					else
					{
						var FullViewXmlData = jsonData['FullViewXmlData'];
						if ( FullViewXmlData!=null && FullViewXmlData!=''& !Ext.isEmpty(FullViewXmlData) )
						{
							var data = FullViewXmlData['DATA'];
							var fullViewContObj = Ext.getCmp('fullViewBarId');
							if (data == 'true')
							{		
								var WIDTH = FullViewXmlData['WIDTH'];
								var HEIGHT = FullViewXmlData['HEIGHT'];
								HEIGHT = parseInt(HEIGHT);
								fullViewContObj.add({
									xtype: 'container',
									id: 'fullViewPanelBigId',
									xmlData:FullViewXmlData,
									width:WIDTH,
									height:HEIGHT,
									listeners:
									{
										'afterrender': function(thisObj)
										{
												var XMLDATA = thisObj.xmlData['XMLDATA'];
												try
												{
													if (viewType == 'Summarygraph')
													{
														var barChart = {};
														barChart = jQuery.extend(true, {}, getHighChartsBarInstance(thisObj.id,fullViewPanelObj.getHeight(),fullViewPanelObj.getWidth()), barChart);	
														barChart.setData(XMLDATA, currentDateFormat, '','stackedColumn');
														barChart.drawChart();
													}
													else if (viewType == 'trendGraph')
													{
														var widthInPix = thisObj.xmlData['WIDTH'];
														var heightInPix = thisObj.xmlData['HEIGHT'];
														var lineChart = {};
														lineChart = jQuery.extend(true, {}, createLineChart(thisObj.id,heightInPix,widthInPix), lineChart);
														lineChart.setData(XMLDATA, currentDateFormat,'' ,'line',true);
														lineChart.drawChart();
													}
													else
													{
														var barChart = {};
														var chartcontainer=parseInt(fullViewPanelObj.getWidth())-100;
														barChart = jQuery.extend(true, {}, getHighChartsBarInstance(thisObj.id,490,chartcontainer), barChart);	
														barChart.setData(XMLDATA, currentDateFormat, '','bar');
														barChart.drawChart();
													}	
													fullViewPanelObj.setLoading(false);
												}
												catch (barChartEx)
												{
													console.log(barChartEx);
												}
										}
									}
								});										
							}
							else
							{
								var msg = FullViewXmlData['MSG'];
								fullViewContObj.update( '<table width="100%" height="300"><tr><td valign="middle" align="center"><div class="iconInformation" style="margin-top:5%"></div><div style="font-size:12px">'+msg+'</div></td></tr></table>');
								fullViewPanelObj.setLoading(false);
							}						
						}
					}
				}
			}
		});		
	},
	dateDiff: function( fromDate,toDate )
    {
    	var oneDay=24*60*60*1000;   //hours*mins*seconds*millisecs
		var fromDate=new Date(fromDate);
		var toDate=new Date(toDate);
		var diffDays = Math.round(Math.abs(fromDate.getTime()-toDate.getTime())/(oneDay));
		return diffDays;
    },

	goBtnOnClick: function()
	{
		var fromHrObj =  Ext.getCmp('high_er_sthr');
		var toHrObj =  Ext.getCmp('high_er_endhr');

		var showValue = Ext.getCmp('Show').getValue();
		var timelineVal = Ext.getCmp('high_er_timeline').getValue();
		var fromValue = Ext.getCmp('high_er_stdate').getValue();
		fromValue = formatDate(Ext.getCmp('high_er_stdate').getValue(), mgrDisplayDateFormat);
		var fromHr = fromHrObj.getValue();

		var ToValue = Ext.getCmp('high_er_enddate').getValue();
		ToValue = formatDate(Ext.getCmp('high_er_enddate').getValue(), mgrDisplayDateFormat);
		var toHr = toHrObj.getValue();

       //Date validation
		var today = new Date();
		var diffDays = this.dateDiff(new Date(fromValue),new Date(ToValue));
		var currentDate = today.getMonth() + "/" + today.getDay() + "/" + today.getYear();
		if(timelineVal!=null && timelineVal.toLowerCase() == 'any')
		{
			if(new Date(fromValue) > new Date(ToValue))
			{
				Ext.MessageBox.show({
					title: alertLbl,
					msg: _stDateLessThanEndDateMsg,
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
				return false;
			}
			if(new Date(fromValue).valueOf() == new Date(ToValue).valueOf())
			{	
				if(fromHr > toHr)
				{
					Ext.MessageBox.show({
					title: alertLbl,
					msg: _stDateLessThanEndDateMsg,
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
					});
					return false;
				}
			}		
			if(today < new Date(fromValue) )
			{
				Ext.MessageBox.show({
					title: alertLbl,
					msg: _fromdatelesserThanMsg,
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
					});
					return false;
			}
		}
		if ( viewType =='measureGraph')
		{
			if( diffDays > 14 && viewType =='measureGraph')
			{
				Ext.MessageBox.show({
				title: alertLbl,
				msg: _timelineTwoWeeksMsg,
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				return false;
			}
		}

		var modeVal = '2D';//Ext.getCmp('modeID').getValue();
		var durationVal = Ext.getCmp('period').getValue();
		var graphVal = Ext.getCmp('graphID').getValue();

		var viewType = Ext.getCmp('fullviewId').viewType;

     
		if (viewType == 'barGraph')
		{
			comboChangeURL = comboChangeURL.replace(/(priority=)[^\&]+/, '$1' + showValue);
		}
		else if (viewType == 'trendGraph')
		{
			comboChangeURL = comboChangeURL.replace(/(mode=)[^\&]+/, '$1' + modeVal);
			if (comboChangeURL.indexOf('duration') > 0)
			{
				comboChangeURL = comboChangeURL.replace(/(duration=)[^\&]+/, '$1' + durationVal);
			}
			else
			{
				comboChangeURL += '&duration='+durationVal;
			}
			if (comboChangeURL.indexOf('trendType') > 0)
			{
				comboChangeURL = comboChangeURL.replace(/(trendType=)[^\&]+/, '$1' + graphVal);
			}
			else
			{
				comboChangeURL += '&trendType='+graphVal;
			}
			//comboChangeURL += '&duration='+durationVal+'&trendType='+graphVal;
		}
		else if ( viewType =='Summarygraph')
		{
			comboChangeURL = comboChangeURL.replace(/(mode=)[^\&]+/, '$1' + modeVal);
			if (comboChangeURL.indexOf('duration') > 0)
			{
				comboChangeURL = comboChangeURL.replace(/(duration=)[^\&]+/, '$1' + encodeURIComponent(durationVal));
			}
			else
			{
				comboChangeURL += '&duration='+encodeURIComponent(durationVal);
			}
		}
		else if ( viewType =='measureGraph')
		{
			comboChangeURL = comboChangeURL.replace(/(mode=)[^\&]+/, '$1' + modeVal);
		}
		comboChangeURL = comboChangeURL.replace(/(timeline_compare=)[^\&]+/, '$1' + encodeURIComponent(timelineVal));
		comboChangeURL = comboChangeURL.replace(/(starttime=)[^\&]+/, '$1' + encodeURIComponent(fromValue));
		comboChangeURL = comboChangeURL.replace(/(starthr=)[^\&]+/, '$1' + fromHrObj.dataArray);
		comboChangeURL = comboChangeURL.replace(/(endtime=)[^\&]+/, '$1' + encodeURIComponent(ToValue));
		comboChangeURL = comboChangeURL.replace(/(endhr=)[^\&]+/, '$1' + toHrObj.dataArray);
		if (comboChangeURL.indexOf('durationChanged') > 0)
		{
			comboChangeURL = comboChangeURL.replace(/(durationChanged=)[^\&]+/, '$1' + 'false');
		}
		this.loadFullViewGraph(comboChangeURL);	
		Ext.get('configMod').animate({duration: 500,to: {y: -350}});
	},
	durationComboChange: function(obj)
	{
		var durationVal = obj.getValue();
		if (comboChangeURL.indexOf('duration') > 0)
		{
			comboChangeURL = comboChangeURL.replace(/(duration=)[^\&]+/, '$1' + durationVal);
		}
		else
		{
			comboChangeURL += '&duration='+durationVal;
		}
		if (comboChangeURL.indexOf('durationChanged') > 0)
		{
			comboChangeURL = comboChangeURL.replace(/(durationChanged=)[^\&]+/, '$1' + 'true');
		}
		else
		{
			comboChangeURL +='&durationChanged=true';		
		}
		Ext.Ajax.request({
			url:comboChangeURL,
			method: 'POST',
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					var timelineValues = jsonData['timelineCombo'];
					if ( timelineValues!=null && timelineValues!=''& !Ext.isEmpty(timelineValues) )
					{
						var timelineLabel = timelineValues['monitor.dashboard.TimeLine'];
						var selectedTimelineCombo = timelineValues['selectedTimelineCombo'];						
						var TimelineComboVal = timelineValues['timelineCombo'];

						var timelineObj = Ext.getCmp('high_er_timeline');
						timelineObj.setFieldLabel(timelineLabel);
						timelineObj.getStore().loadRawData(TimelineComboVal);						
						timelineObj.setValue(selectedTimelineCombo);
					}	
					Ext.getCmp('high_er_timeline').fireEvent('select',Ext.getCmp('high_er_timeline'));
					/*var fromData = jsonData['fromValues'];
					if ( fromData!=null && fromData!=''& !Ext.isEmpty(fromData) )
					{
						var fromlabel = fromData['monitor.VirtualDashboard.From'];
						var isFromDisabled = fromData['from'];
						var fromValue = fromData['value'];
						var fromObj = Ext.getCmp('high_er_stdate');
						fromObj.setFieldLabel(fromlabel);
						fromObj.setDisabled(isFromDisabled);
						fromObj.setValue(fromValue);
					}
					var startHr = jsonData['startHr'];
					if ( startHr!=null && startHr!=''& !Ext.isEmpty(startHr) )
					{
						var hrLabel = startHr['monitor.VirtualDashboard.Hr'];
						var isStartHrEnabled = startHr['isStartHrEnabled'];
						var selectedStartHr = startHr['selectedStartHr'];
						var startHrCmbo = startHr['startHrArray'];

						var startHrObj = Ext.getCmp('high_er_sthr');
						startHrObj.setFieldLabel(hrLabel);
						startHrObj.getStore().loadRawData(startHrCmbo);
						startHrObj.setValue(selectedStartHr);
						startHrObj.setDisabled(isStartHrEnabled);
					}
					var toValues = jsonData['toValues'];
					if ( toValues!=null && toValues!=''& !Ext.isEmpty(toValues) )
					{
						var toLabel = toValues['monitor.VirtualDashboard.To'];
						var isToDisabled = toValues['to'];
						var value = toValues['value'];
						var toObj = Ext.getCmp('high_er_enddate');
						toObj.setDisabled(isToDisabled);
						toObj.setFieldLabel(toLabel);
						toObj.setValue(value);
					}
					var endHr = jsonData['endHr'];
					if ( endHr!=null && endHr!=''& !Ext.isEmpty(endHr) )
					{
						var hrLabel = endHr['monitor.VirtualDashboard.Hr'];
						var isEndHrEnabled = endHr['isEndHrEnabled'];
						var selectedEndHr = endHr['selectedEndHr'];
						var endHrCmbo = endHr['endHrArray'];

						var endHrObj = Ext.getCmp('high_er_endhr');
						endHrObj.setFieldLabel(hrLabel);
						endHrObj.getStore().loadRawData(endHrCmbo);
						endHrObj.setValue(selectedEndHr);
						endHrObj.setDisabled(isEndHrEnabled);
					}*/
				}
			}
		});		
	},
	loadMeasureGraph: function(imgSrc,isHighChartEnabled)
	{
		var MeasurementTable_Highcharts='';
		var minMaxTableHeadersArray = '';
		var measuresTableDataArray = '';
		var fullViewContObj = Ext.getCmp('fullViewBarId');
		var fullViewPanelObj = Ext.getCmp('fullviewId');
		fullViewContObj.removeAll();
		fullViewContObj.update('');		
		if (isHighChartEnabled)
		{			
			Ext.Ajax.request({
				url:imgSrc,
				method: 'POST',
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						var tmpJsonTxt = response.responseText;
						var chartData = Ext.decode(tmpJsonTxt);
						var errorMsg = chartData['ERROR'];
						if(errorMsg!=null && errorMsg!=undefined && !Ext.isEmpty(errorMsg) && errorMsg=='NO_DATA_FOUND')
						{
							Ext.getCmp('measureTableID').update('');
							fullViewContObj.update('<div class="iconInformation" style="margin:15% auto 0 auto"></div><div style="text-align:center;">'+noMeasure+'</div>');							
							fullViewPanelObj.setLoading(false);
						}
						else
						{
							MeasurementTable_Highcharts = chartData['MeasurementTable_Highcharts'];
							var minMaxTable = MeasurementTable_Highcharts['minMaxTable'];
							
							if (minMaxTable!=null && minMaxTable!=''& !Ext.isEmpty(minMaxTable) && minMaxTable!=undefined)
							{
								minMaxTableHeadersArray = minMaxTable['minMaxTableHeadersArray'];
							}
							var measuresTable = MeasurementTable_Highcharts['measuresTable'];
							if (measuresTable!=null && measuresTable!=''& !Ext.isEmpty(measuresTable) && measuresTable!=undefined)
							{						
								measuresTableDataArray = measuresTable['measuresTableDataArray'];	
							}
							if ( tmpJsonTxt.indexOf('png') == -1 && tmpJsonTxt.indexOf('PNG') == -1 && tmpJsonTxt.indexOf('gif') == -1 && tmpJsonTxt.indexOf('GIF') == -1 )
							{							
								fullViewContObj.add({
									xtype: 'container',
									id: 'fullViewPanelHighChatrBigId',
									html : '<div id="high-chart-measuregraph" style="border:0px solid yellow;height:300px;"></div>',
									listeners:
									{
										'afterrender': function(thisObj)
										{
											var chartData = Ext.decode(tmpJsonTxt);
											try
											{											
												var lineChart = {};
												lineChart = jQuery.extend(true, {}, getHighCharts('high-chart-measuregraph', 345,900,''), lineChart);
												lineChart.setData(chartData,currentDateFormat,'',true,'bottom');
												lineChart.drawChart();
												fullViewPanelObj.setLoading(false);
											}
											catch (e)
											{
												console.log("e::"+e)
											}
											if (!Ext.isEmpty(minMaxTableHeadersArray) && minMaxTableHeadersArray!=undefined && minMaxTableHeadersArray!=null && minMaxTableHeadersArray!='' && measuresTableDataArray!=undefined && measuresTableDataArray!=null && measuresTableDataArray!='' && !Ext.isEmpty(measuresTableDataArray))
											{												
												 var str='';
												 str += '<div class="x-table" class="minMaxTable"> '
												+ '<table cellspacing="0" cellpadding="0" border="0"  class="gridSkin x-grid-table x-grid-table-resizer">'
												+ '<thead>'
												+ '<tr class="x-grid-row">'
												+ '<th class="x-grid-cell" style="width:50px">'
												+ '<div class="x-grid-cell-inner" style="margin-left: 30px;">'+minMaxTableHeadersArray[0]['name']+'</div>'
												+ '</th>'
												+ '<th class=" x-grid-cell x-grid-cell-first" style="width: 210px;">'
												+ '<div class="x-grid-cell-inner">'+minMaxTableHeadersArray[1]['name']+'</div>'		
												+ '</th>'
												+ '<th class=" x-grid-cell" style="width: 50px;">'
												+ '<div class="x-grid-cell-inner">'+minMaxTableHeadersArray[2]['name']+'</div>'
												+ '</th>'
												+ '<th class=" x-grid-cell" style="width: 50px;">'
												+ '<div class="x-grid-cell-inner" >'+minMaxTableHeadersArray[3]['name']+'</div>'
												+ '</th>'
												+ '<th class=" x-grid-cell" style="width: 50px;">'
												+ '<div class="x-grid-cell-inner">'+minMaxTableHeadersArray[4]['name']+'</div>'
												+ '</th>'
												+ '</tr>'
												+ '</thead>'
												+ '<tbody>';
												for ( var j = 0; j < measuresTableDataArray.length ; j++ )
												{
													var records = measuresTableDataArray[j];
													str += '<tr class="x-grid-row">'
													for (var k in records )
													{
														if (k == 'value0')
														{
															str += '<td class=" x-grid-cell x-grid-cell-first" style="verical-align:middle" width="50px">'
															 + '<div class="x-grid-cell-inner"  ><span id="id_colorcheck" style="display: inline-block;background:'+records[k]+';height: 10px;width: 10px;margin-left: 40px;"><span></div>'
															 + '</td>';	
														}
														else
														{
															str += '<td class=" x-grid-cell x-grid-cell-first">'
															+ '<div class="x-grid-cell-inner" >'+records[k]+'</div>'
															+ '</td>';				
														}
													}
													str += '</tr>';
												}
												str += '</tbody>'
												+ '</table>'
												+ '</div>';
												Ext.getCmp('measureTableID').update(str);
											}
										}
									}
								});										
							}
							else
							{
								fullViewContObj.update(tmpJsonTxt);
								fullViewPanelObj.setLoading(false);
							}
						}
					}
					else
					{						
						fullViewContObj.update("<table border='0' height='100%' width='100%'><tr><td align='center'><img src='/final/monitor/eg_images/gray/graph_error_message.gif'></td></tr></table>");
						fullViewPanelObj.setLoading(false);
					}
				}
			});
		}
		else
		{
	        fullViewContObj.update('<table width="100%" height="360px"><tr><td align="center" valign="middle"><img src="' + imgSrc + '" border="0" /></td></tr></table>');
		fullViewPanelObj.setLoading(false);
		}		
		
	}
});