Ext.define('componentDashboard.controller.LayersController',{
    extend: 'Ext.app.Controller',
	currentLayer:null,
	testQS:null,
	testSearchedLayers:[],
	allCheck:{},
	allNodeCheck:{},
	openLayer:'',
	rootCauseNode:null,
    views:['componentDashboard.view.Layers.Measures','componentDashboard.view.Layers.FiltersToolbar','componentDashboard.view.Layers.LayersTree','componentDashboard.view.ComponentTabPanel','componentDashboard.view.Layers.LayersList'],
    refs:[{
    	ref:'measures',
    	selector:'measures'
    },{
    	ref:'layerstree',
    	selector:'layerstree'
    },{
    	ref:'filterstoolbarServerType',
    	selector:'main combo[itemId=componentTypeCombo]'
    },{
    	ref:'filterstoolbarCompType',
    	selector:'main combo[itemId=componentsDropDown]'
    },{
    	ref:'filterstoolbarServerName',
    	selector:'main combo[itemId=componentNameCombo]'
    },{
    	ref:'componentsTreePanel',
    	selector:'componentstreepanel'
    },{
    	ref:'compDashLayersTab',
    	selector:'compdashlayerstab'
    },{
		ref:'componenttabpanel',
		selector:'componenttabpanel'
	},{
	 ref:'layerslist',
	selector:'layerslist'
	}],
    recordClicked: new Array(),
    init: function(){
		this.control({
	   		'layerstree':{
				itemclick:this.layerClick,
				beforeitemexpand:this.expandNodes,
				beforeitemcollapse:this.collapseNodes,
				afteritemexpand:this.afterExpandNodes,
				afteritemcollapse:this.afterCollapseNodes,
       			beforerender:function(){
       				if(requestParams.refresh!==true){
       					Ext.state.Manager.clear('layers-tree-stateId');
       				}
       			},
				afterrender:this.afterLayersTreeRender
		   	},
		   	'main combo[itemId=componentTypeCombo]':{
		   		select: this.selectedServerType
		   	},
		   	'main combo[itemId=componentsDropDown]':{
		   		select: this.selectedCompType
		   	},
		   	'main combo[itemId=componentNameCombo]':{
		   		select: this.selectedServerName
		   	}
	   });
	},
    layersTreeBeforeItemClick:function(treeView, record, item, index, e, eOpts){
	   	var me = this;
    	this.getLayerstree().getRootNode().eachChild(me.removePreSelected,me);
    	var thisRecord = treeView.getNode(record);
		if(!Ext.isEmpty(thisRecord))
    		Ext.get(thisRecord).addCls('layers-tree-bold-node');
    	var parentOfRecord = record.parentNode;
    	while(!Ext.isEmpty(parentOfRecord)){
    		thisRecord = treeView.getNode(parentOfRecord);
			if(!Ext.isEmpty(thisRecord)){
    			Ext.get(thisRecord).addCls('layers-tree-bold-node');
			}
    		parentOfRecord = parentOfRecord.parentNode;
    	}
    	this.getLayerstree().doLayout();
    },
    removePreSelected : function(node){
		var layerName = node.raw.text;
		if(!Ext.isEmpty(layerName) && layerName.indexOf('<div') > -1 && layerName.indexOf('_trigger')>-1){
			layerName = layerName.substring(0,layerName.indexOf('<div'));
			if(!Ext.isEmpty(this.openLayer) && this.openLayer != layerName && node.raw.text.indexOf('<div') > -1){
				/*if(this.recordClicked.indexOf(node) > -1){
					var index = this.recordClicked.indexOf(node);
					this.recordClicked.splice(index,1);
				}*/
				node.collapse();
			}
		}
	   	var thisRecord = Ext.get(this.getLayerstree().getView().getNode(node));
    	if(!Ext.isEmpty(thisRecord) && thisRecord.hasCls('layers-tree-bold-node')){
    		thisRecord.removeCls('layers-tree-bold-node');
    	}
		node.eachChild(this.removePreSelected,this);
    },
    afterLayersTreeRender : function(tree, eOpts){
    	var me = this;
		var getIconCls = this.getComponenttabpanel().down('button[itemId=compoentDetails]').iconCls;

		if(!Ext.isEmpty(this.getLayerslist()) && !Ext.isEmpty(this.getLayerslist().down('button[itemId=compoentDetails]'))){
			this.getLayerslist().down('button[itemId=compoentDetails]').setIconCls(getIconCls);
		}

		if(rootCauseCheck)
		{
			if(!Ext.isEmpty(tree) && !Ext.isEmpty(tree.getStore()) && !Ext.isEmpty(tree.getStore().getRootNode()) && !Ext.isEmpty(me.currentChildDisplay))
			{
    			tree.getStore().getRootNode().eachChild(me.currentChildDisplay,me);
			}
		}
    },
    currentChildDisplay : function(node){
    	var me = this;
    	if(node.raw.rootCauseUrl == true || node.raw.rootCauseUrl == "true"){
			this.rootCauseNode = node;
// Working for Layermodel state change issues - saran
			if(this.recordClicked==null || this.recordClicked==undefined || this.recordClicked.length==0)
			{
				this.recordClicked = new Array();
				this.recordClicked = [];
				this.recordClicked.push(node);
			}
			var layerName = node.raw.text;
			if(!Ext.isEmpty(layerName))
				layerName = layerName.substring(0,layerName.indexOf('<'));
			this.openLayer = layerName;
			rootCauseCheck = false;
			var currLayerState=node.raw.state;
			if(Ext.isEmpty(currLayerState))
				currLayerState="GOOD";
    		me.setTestsForLayer(node.internalId, node.raw.hiddenvalue+"&currLayerState="+currLayerState,false);
    	}
		else
		{
			this.rootCauseNode = null;
		}
    },

	layerClick : function(layerTree,record,item,index,e,eOpts){
		var parentNode = record.parentNode;
        if(parentNode) {
            //console.log(parentNode.childNodes);
        }
		//console.log(record.childNodes.length);
		var targetId = e.target.id;
		if(!Ext.isEmpty(targetId) && targetId == 'virtualLive')
			return false;

		var layerName = record.raw.text;
		if(!Ext.isEmpty(layerName) && layerName.indexOf('iconLayerMoreInfo') != -1)
		{
			var fireEventParam = record.raw.fireEvent;
			if(!Ext.isEmpty(fireEventParam))
			{
				MoreInfoLayerTreePopUp(fireEventParam,'');
				return;
			}
			else
				return false;
		}
		if(!Ext.isEmpty(layerName) && layerName.indexOf('<div') > -1 && layerName.indexOf('_trigger') > -1){
			layerName = layerName.substring(0,layerName.indexOf('<div'));
			this.openLayer = layerName;
		}
		// To deselect previously selected test and its info
		this.layersTreeBeforeItemClick(layerTree,record,item,index,e,eOpts);

		// To close layer if it is already opened
		if(record.isExpanded()){
			record.collapse();
			for(i=0;i<this.recordClicked.length;i++){
				var tempLayerName = record.raw.text.substring(0,record.raw.text.indexOf('<'));
				var savedLayerName = this.recordClicked[i].raw.text.substring(0,this.recordClicked[i].raw.text.indexOf('<'));
				if(tempLayerName == savedLayerName){
					this.recordClicked.splice(i,1);
					for(j=0;j<this.testSearchedLayers.length;j++)
					{
						if(!Ext.isEmpty(this.testSearchedLayers[j][tempLayerName])){
							this.testSearchedLayers.splice(j,1);
							break;
						}
					}
					break;
				}
			}
		}	// To open layer and to load its tests if it is not open already
		else if(!Ext.isEmpty(record.raw.onclickurl) && record.childNodes.length == 0){
			this.allNodeCheck = new Object();
			this.allCheck = new Object();
			this.recordClicked = new Array();
			this.recordClicked = [];
			this.recordClicked.push(record);
			var currLayerState=record.raw.state;
			if(Ext.isEmpty(currLayerState))
				currLayerState="GOOD";
			this.setTestsForLayer(record.internalId, record.raw.onclickurl+"&currLayerState="+currLayerState,false);		
			this.selectedTest = record.raw.text;
			this.measuresUrl = '/final/monitor/egDashBoardDispCompMeasure.jsp?'+record.raw.onclickurl;
			this.getMeasures().changeUrl(this.measuresUrl);
			this.getMeasures().refreshData();
		}	// To load measures for the respective test or info clicked in the test panel
		else if(!Ext.isEmpty(record.raw.measuresLink) && record.childNodes.length == 0){
			var layerName = '';
			layerNode = record.parentNode;
			while(!Ext.isEmpty(layerNode.parentNode.raw.onclickurl)){
				layerNode = layerNode.parentNode;
			}
			layerName = layerNode.raw.text;
			layerName = layerName.substring(0,layerName.indexOf('<'));

			if(Ext.isEmpty(layerName) && !Ext.isEmpty(layerNode.data.children))
			{
				layerNode = record.parentNode.parentNode.parentNode;
				if(!Ext.isEmpty(layerNode))
				{
					layerName = layerNode.raw.text;
				}

				if(!Ext.isEmpty(layerName) && (layerName.indexOf('<')>-1))
				{
					layerName = layerName.substring(0,layerName.indexOf('<'));
				}
			}

			this.currentLayer = layerName;
			this.selectedTest = record.raw.text;
			this.testQS = record.raw.measuresLink;
			if(isDouble)
			{
				this.measuresUrl = '/final/monitor/egDashBoardDispCompMeasure.jsp?'+encodeURI(record.raw.measuresLink);
			}
			else
			{
				this.measuresUrl = '/final/monitor/egDashBoardDispCompMeasure.jsp?'+encodeURI(record.raw.measuresLink);
			}
			
			if(!Ext.isEmpty(this.allCheck) && !Ext.isEmpty(this.allCheck[layerName]))
			{
				this.allNodeCheck[layerName+"_Test_Exp"] = true;
			}

			this.getMeasures().changeUrl(this.measuresUrl);
			this.getMeasures().refreshData();
		}	// To open the More infos window if the link is clicked
		else if(!Ext.isEmpty(record.raw.moreDescriptorsURL) && record.childNodes.length == 0 ){
			var url=record.raw.moreDescriptorsURL;
			var params=url.substring(url.indexOf("?")+1,url.length);
			window.openWindow("/final/monitor/EgMoreInfosApp.jsp?"+params+"&page=More Infos","MoreDescriptors","width=1012,height=603,left=0,top=105,scrollbars=1,scrollbars=yes,resizable=yes,location=no");

			this.getMeasures().changeUrl('/final/monitor/egDashBoardDispCompMeasure.jsp?');
			this.getMeasures().refreshData();

		}
		else if(!Ext.isEmpty(record.raw.moreDescriptorsTreeURL) && record.childNodes.length == 0 ){
			var url=record.raw.moreDescriptorsTreeURL;
			var params=url.substring(url.indexOf("?")+1,url.length);
			//window.openWindow("/final/monitor/EgMoreInfosTreeApp.jsp?"+params+"&page=More Infos","MoreTreeDescriptors","width=1012,height=603,left=0,top=105,scrollbars=1,scrollbars=yes,resizable=yes,location=no");
			//qctr=1&from=list&showAll=yes&MoreInfosTreeView=true&test=EsxDiskUsageTest&host=vdi_10.15%3ANULL&layer=HOST&site=NULL&comptype=VmVdi_i_server&faketype=&fromalarm=null
			//params=-=-=-=-=-> qctr=1&from=list&showAll=yes&MoreInfosTreeView=true&test=EgServletInfoTest&host=egmanager_63%3A7077&layer=EG_APPLICATION&site=NULL&comptype=eG_Manager&faketype=&fromalarm=null
			//window.openWindow("/final/servlet/com.eg.EgDashboardController?"+params+"&page=More Infos","MoreTreeDescriptors","width=1012,height=603,left=0,top=105,scrollbars=1,scrollbars=yes,resizable=yes,location=no");

			MoreInfoLayerTreePopUp("/final/servlet/com.eg.EgDashboardController?"+params+"&page=More Infos","More Infos");

			this.getMeasures().changeUrl('/final/monitor/egDashBoardDispCompMeasure.jsp?');
			this.getMeasures().refreshData();

		}
		else if(!record.isExpanded()){
			record.expand();

			var layerName = '';
			layerName = record.raw.text;
			if(layerName!=null && layerName!=undefined && layerName.indexOf('<a href') > -1)
			{
				layerName = (layerName).substr((layerName).indexOf(";>")+2);
			}
			layerName = layerName.substring(0,layerName.indexOf('<'));
			if(!Ext.isEmpty(layerName) && Ext.isEmpty(record.data.children))
			{
				this.recordClicked = new Array();
				this.allNodeCheck = new Object();
				this.allCheck = new Object();
				this.recordClicked.push(record);
				this.setTestsForLayer(record.internalId, record.raw.onclickurl+"&currLayerState="+currLayerState,false);
			}
		}
	},
	recordOpen: function(record){
		var me=this;
		var layerTree=this.getLayerstree();
		layerTree.getStore().getRootNode().eachChild(function(child){
			var expandChild= function(child,record){
				if((child.raw.text===record.raw.text) || (child.raw.text.substring(0,child.raw.text.indexOf("<"))==record.raw.text.substring(0,record.raw.text.indexOf("<"))))
				{
					var tempLayerName = child.raw.text;
					var currLayerState=record.raw.state;
					if(Ext.isEmpty(currLayerState))
						currLayerState="GOOD";
					tempLayerName = tempLayerName.substring(0,tempLayerName.indexOf('<'));
					if(tempLayerName == me.currentLayer)
						me.setTestsForLayer(child.internalId, me.testQS+"&currLayerState="+currLayerState,false);
					else
						me.setTestsForLayer(child.internalId, child.raw.onclickurl+"&currLayerState="+currLayerState,false);
				}
			}
			expandChild(child,record);
		});
	},
	setTestsForLayer : function(recordId,urlParams,callback) {
		
		var me = this;
		
		var record = this.getLayerstree().getView().getTreeStore().getNodeById(recordId);
		var layerNameSearch = record.raw.text.substring(0,record.raw.text.indexOf('<'));
		var temTestSearchedLayers="";
		for(i=0;i<this.testSearchedLayers.length;i++){
				//if(!Ext.isEmpty(this.testSearchedLayers[i][layerNameSearch]) && urlParams.indexOf('&searchString=') < 0){
				if(!Ext.isEmpty(this.testSearchedLayers[i][layerNameSearch])){
				temTestSearchedLayers=this.testSearchedLayers[i][layerNameSearch];
				//urlParams += '&searchString='+this.testSearchedLayers[i][layerNameSearch];
			}
		}
		
		if(urlParams!=null && urlParams.indexOf('&searchString=') >-1)
		{
			urlParams=urlParams.replace(/(searchString=)[^\&]+/, '$1' +temTestSearchedLayers);
		}
		else
		{
			urlParams += '&searchString='+temTestSearchedLayers;
		}
		
		if(!Ext.isEmpty(requestParams.isMoreInfosTreeView) && (requestParams.isMoreInfosTreeView || requestParams.isMoreInfosTreeView =="true"))
		{
			if(urlParams!=null && urlParams!=undefined && urlParams.indexOf("MoreInfosTreeView")<0)
			{
				urlParams = urlParams+'&MoreInfosTreeView=true&showAll=yes&searchByDescriptor=true';
			}
		}
		
		var layersTree = this.getLayerstree();
		if(!Ext.isEmpty(layersTree.getEl())){
			//layersTree.getEl().mask("Loading...","maskCenter");
		}
		
		if(isDouble)
			urlParams=encodeURI(urlParams);
		Ext.Ajax.request({
			url : '/final/monitor/egDashBoardDispCompTests.jsp?'+urlParams,
			scope:this,
			disableCaching:false,
			timeout:280000,
		    success: function(response){
				
				var jsonText = null;
		        jsonText = response.responseText;

				var jsonData=null;
				if(!Ext.isEmpty(jsonText) && jsonText !=null)
					jsonData=Ext.decode(jsonText);
				jsonText = null;
				delete jsonText;
				Ext.destroy(jsonText);

				var layerState="GOOD_border";
				if(!Ext.isEmpty(jsonData.layerState))
				{
					layerState=jsonData.layerState+"_border";
				}

	        	//record.collapse();
	        	//record.removeAll();
		        if(jsonData.tests.length>0){
					var testsArray = [];
					/*if(!Ext.isEmpty(jsonData.liveGraph)){
						testsArray.push({
							iconCls : "iconLiveGraph",
							selected:'false',
							cls:'layerSplBox',
							padding:'10 0',
							leaf : true,
							text : '<a href="javascript:void(0);" title="'+jsonData.liveGraph["liveGraphTooltip"]+'" onclick=goToLiveGraph("'+encodeURI(jsonData.liveGraph["liveGraphURL"])+'")>Link</a>'
						});
					}*/
					if(!Ext.isEmpty(jsonData.tests)){
						for(i=0;i<jsonData.tests.length;i++)
						{
							var last_leaf="";
							if((jsonData.tests.length-1)==i)
							{
								last_leaf="last_leaf";
							}
							
							jsonData.tests[i].cls = 'secondlevel '+layerState+" "+last_leaf;

							var maitananceString = '';
							if(!Ext.isEmpty(jsonData.tests[i].maintenaceTimePeriodStr))
								maitananceString = jsonData.tests[i].maintenaceTimePeriodStr;
							else if(!Ext.isEmpty(jsonData.tests[i].descriptorMaintenaceTimePeriodStr))
								maitananceString = jsonData.tests[i].descriptorMaintenaceTimePeriodStr;

							if(!Ext.isEmpty(maitananceString)){
								var testNode = jsonData.tests[i].text;
								var backText = '';
								if(testNode.indexOf('<') > -1){
									testNode = jsonData.tests[i].text.substring(0,jsonData.tests[i].text.indexOf('<'));
									backText = jsonData.tests[i].text.substring(jsonData.tests[i].text.indexOf('<'));
								}
								testNode += '<img class="iconMaintenance" style="margin:2px 5px 0" data-qtip="'+maitananceString+'" data-qclass="yellowTip"  src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==">';

								testNode += backText;
								jsonData.tests[i].text = testNode;
							}
							if(!Ext.isEmpty(jsonData.tests[i].children)){
								for(j=0;j<jsonData.tests[i].children.length;j++)
								{
									jsonData.tests[i].children[j].cls = 'thirdlevel '+layerState+" "+last_leaf;
									if(!Ext.isEmpty(jsonData.tests[i].children[j])){
										for (k=0;k< jsonData.tests[i].children.length;k++ )
										{
											jsonData.tests[i].children[j].cls = 'fourthlevel '+layerState;
											// To show border for default expand
											if((jsonData.tests[i].children.length-1==j && Ext.isEmpty(jsonData.tests[i].children[j].children)) || jsonData.tests[i].children.length-1==j)
											{
												jsonData.tests[i].children[j].cls = 'fourthlevel '+layerState+" "+last_leaf;
											}

											if(!Ext.isEmpty(jsonData.tests[i].children[j].children)){
												for (l=0;l< jsonData.tests[i].children[j].children.length;l++ ){
													jsonData.tests[i].children[j].children[l].cls = 'fifthlevel '+layerState;
													// To show border if last test contains sub nodes
													if((jsonData.tests[i].children.length-1==j && jsonData.tests[i].children[j].children.length-1==l) || (jsonData.tests[i].children.length-1==1 && Ext.isEmpty(jsonData.tests[i].children[j].children)))
													{
														jsonData.tests[i].children[j].children[l].cls  = 'fifthlevel '+layerState+" "+last_leaf;
													}

													if(!Ext.isEmpty(jsonData.tests[i].children[j].children[l]) && jsonData.tests[i].children[j].children[l].children!=null && jsonData.tests[i].children[j].children[l].children!=undefined)
													{
														var lastLeafCount =jsonData.tests[i].children[j].children[l].children.length;
														for (m=0;m< jsonData.tests[i].children[j].children[l].children.length;m++ )
														{
															jsonData.tests[i].children[j].children[l].children[m].cls = 'sixthlevel '+layerState;
															if((jsonData.tests[i].children.length-1==j && jsonData.tests[i].children[j].children.length-1 == l && lastLeafCount-1 == m) || (jsonData.tests[i].children.length-1==1 && Ext.isEmpty(jsonData.tests[i].children[j].children)))
															//if(jsonData.tests[i].children.length-1==m || (jsonData.tests[i].children.length-1==1 && Ext.isEmpty(jsonData.tests[i].children[j].children)))
															{
																if(m+1 == lastLeafCount)
																{
																	jsonData.tests[i].children[j].children[l].children[m].cls  = 'sixthlevel '+layerState+" "+last_leaf;
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
					
					testsArray.push(jsonData.tests);
					record.removeAll();
		        	record.insertChild(0,testsArray);
		        	record.expand();
		        	//record.expandChildren();
					record.collapseChildren();
					me.selectTestInfo(record);
		        }
				else {
					record.removeAll();
		        	record.insertChild(0,{
		        		//iconCls : "error-state-icon",
						cls:'errorBox '+layerState,
		        		text : '<div style="display:table;min-height:60px;height:98%;width:100%"><div style="display:table-cell;vertical-align:middle;text-align:center;"><div style="margin:auto;" class="iconInformation"></div><div>'+(jsonData.errormsg.Msgfortest?jsonData.errormsg.Msgfortest:jsonData.errormsg.MsgforSearchTest)+(jsonData.errormsg.SearchString?", "+jsonData.errormsg.SearchString:"") +'</div></div></div>'
		        	});
		        	record.expand();
					record.expandChildren();
		        }
				if(callback){
		        	record.eachChild(me.reloadMeasures,me);
		        }

				if( Ext.isDefined(jsonData.liveGraph) && !Ext.isEmpty(jsonData.liveGraph) && jsonData.liveGraph!=null ){
					var virtualLiveMetricsImg = Ext.create('Ext.form.Label',{
	        			renderTo : "virtualLiveImg",
	        			html : jsonData.liveGraphDiv
	        		});
				}

		        if(!Ext.isEmpty(jsonData.SearchRequired)){
					var thisLayer = (record.raw.text).substr(0, (record.raw.text).indexOf("<div"));
	        		var recordText = "searchTests_" + thisLayer;
	        		if(recordText.indexOf('<a href') > -1){
	        			recordText = "searchTests_" + (recordText).substr((recordText).indexOf(";>") + 2);
	        		}

					if(recordText!=null && recordText!=undefined && recordText.indexOf('</a>') > -1){
	        			recordText = (recordText).substr(0,(recordText).indexOf("</a>"));
	        		}

					recordText = recordText.replace(/ /g,"_");
					var moreinfos= false;
					if(!Ext.isEmpty(requestParams.isMoreInfosTreeView) && (requestParams.isMoreInfosTreeView || requestParams.isMoreInfosTreeView =="true"))
					{
						moreinfos = true;
					}
					
					var searchTests = Ext.create('Ext.form.field.Trigger', {
						//renderTo : recordText+"_trigger",
						width : 115,
						style : 'position:absolute; right:65px;top:0px;',
						emptyText:'Search',
						layer:thisLayer,
						id: moreinfos ? "moreinfo_search_trigger" : recordText+'Trigger',
						//hidden:true,
						cls : 'whitedropdown_search x-hidden',
						value : (jsonData.SearchText?jsonData.SearchText:""),
						onTriggerClick : function(e){
							var searchRetain = new Object();
							if(!Ext.isEmpty(this.getValue())){
								searchRetain[this.layer] = this.getValue();
								me.testSearchedLayers.push(searchRetain);
							}
							else{
								for(i=0;i<me.testSearchedLayers.length;i++){
									if(!Ext.isEmpty(me.testSearchedLayers[i][this.layer])){
										me.testSearchedLayers.splice(i,1);
									}
								}
							}
							if(urlParams.indexOf('&searchString=') > -1){
								var postSearchStringParams = urlParams.substr(urlParams.indexOf('&searchString=') + 14);
								if(postSearchStringParams.indexOf('&') > -1){
									postSearchStringParams = postSearchStringParams.substr(postSearchStringParams.indexOf('&'));
								} else {
									postSearchStringParams = "";
								}
								urlParams = urlParams.substr(0,urlParams.indexOf('&searchString=')) + postSearchStringParams;
							}

							if(!Ext.isEmpty(requestParams.isMoreInfosTreeView) && (requestParams.isMoreInfosTreeView || requestParams.isMoreInfosTreeView =="true"))
							{
								if(urlParams!=null && urlParams!=undefined && urlParams.indexOf("searchByDescriptor")<0)
								{
									urlParams = urlParams+'&searchByDescriptor=true';
								}
							}
							me.setTestsForLayer(recordId, urlParams + "&searchString=" + this.getValue());
						},
						listeners : {
							scope:this,
							blur:function(cmp,eOpts){
								Ext.fly(recordText+'iconMagnify').show();
								if(moreinfos){
								Ext.fly('moreinfo_search_trigger').addCls('x-hidden');
								}else{
									Ext.fly(recordText+'Trigger').addCls('x-hidden');
								}
								
							},
							afterrender : function(cmp){

								cmp.getEl().swallowEvent(['mouseover','mouseout','click','dblclick'],'true');
								
								if(Ext.getCmp(recordText+"Trigger")!=null && Ext.getCmp(recordText+"Trigger")!=undefined && Ext.getCmp(recordText+"Trigger")!="null" && Ext.getCmp(recordText+"Trigger")!="undefined")
								{
									var searchVal="";
								if(moreinfos){
									searchVal = Ext.getCmp('moreinfo_search_trigger').getValue();
								}else{
								
									searchVal = Ext.getCmp(recordText+"Trigger").getValue();
								}
									if(!Ext.isEmpty(searchVal) && searchVal!=null && searchVal!=undefined && searchVal!="null")
									{
										//Ext.fly(recordText+'Trigger').removeCls('x-hidden');
										if(moreinfos){
											Ext.fly('moreinfo_search_trigger').removeCls('x-hidden');
											}else{
												Ext.fly(recordText+'Trigger').removeCls('x-hidden');
										}
									}
									else
									{
										
										if(moreinfos){
											Ext.fly('moreinfo_search_trigger').addCls('x-hidden');
											}else{
												Ext.fly(recordText+'Trigger').addCls('x-hidden');
										}
									}
								}
								
							},
							specialKey : function(field, e){
								if(e.getKey() === e.ENTER){
									/*var searchRetain = new Object();
									if(!Ext.isEmpty(field.getValue())){
										searchRetain[field.layer] = field.getValue();
										me.testSearchedLayers.push(searchRetain);
									}
									else{
										for(i=0;i<me.testSearchedLayers.length;i++){
											if(!Ext.isEmpty(me.testSearchedLayers[i][field.layer])){
												me.testSearchedLayers.splice(i,1);
											}
										}
									}
									if(urlParams.indexOf('&searchString=') > -1){
										var postSearchStringParams = urlParams.substr(urlParams.indexOf('&searchString=') + 14);
										if(postSearchStringParams.indexOf('&') > -1){
											postSearchStringParams = postSearchStringParams.substr(postSearchStringParams.indexOf('&'));
										} else {
											postSearchStringParams = "";
										}
										urlParams = urlParams.substr(0,urlParams.indexOf('&searchString=')) + postSearchStringParams;
									}
									me.setTestsForLayer(recordId, urlParams + "&searchString=" + this.getValue());*/
									
									field.onTriggerClick(e);
									field.triggerBlur();
									field.blur();
								}
							}
						}
					});
					var searchIcon = Ext.create('Ext.Button', {
						iconCls:'iconTopologySearch',
						tooltip:'Search',
						margin:'0 0 0 95',
						style:{'background':'none','background-image':'none','border':'0px #000 solid!important'},
						onClick:function(){
							//Ext.fly(recordText+'Trigger').show();
							if(moreinfos){
											Ext.fly('moreinfo_search_trigger').removeCls('x-hidden');
											}else{
												Ext.fly(recordText+'Trigger').removeCls('x-hidden');
										}
							//Ext.fly(recordText+'Trigger').removeCls('x-hidden');
							this.getEl().hide();
						},
						listeners:{
						afterrender : function(cmp){
								cmp.getEl().swallowEvent(['mouseover','mouseout','click','Dblclick'],'true');
								
							}},
						
						id:recordText+'iconMagnify'
					});
					
					var layerName = record.raw.text.substring(0,record.raw.text.indexOf('<'));
	        		
	        		var allCheckbox = Ext.create('Ext.form.field.Checkbox',{
	        			renderTo : recordText+"_checkbox",
	        			cls : 'layer_checkbt',
						style : '',
						//boxLabel:'All',
	        			//checked : (!Ext.isEmpty(me.allCheck) && !Ext.isEmpty(me.allCheck[layerName]))?me.allCheck[layerName]:true,
	        			checked : (!Ext.isEmpty(me.allCheck) && !Ext.isEmpty(me.allCheck[layerName]))?me.allCheck[layerName]:jsonData.checkBox,
	        			labelWidth : 0,
	        			listeners : {
							afterrender : function(cmp){
								var me2 = this;
								cmp.getEl().swallowEvent(['mouseover','mouseout','click','dblclick'],'true');
								me2.fireEvent('change',me2,me2.checked);
							},
							change : function(cmp, newValue, oldValue, eOpts){
								if(newValue){
									record.expandChildren();
									me.allNodeCheck = new Object();
								}
								else
								{
									//record.collapseChildren();
									if(!Ext.isEmpty(me.allNodeCheck) && !Ext.isEmpty(me.allNodeCheck[layerName+"_Test_Exp"]) && me.allNodeCheck[layerName+"_Test_Exp"]==true)
									{
										me.selectTestInfoCol(record);
									}
									else
									{
										record.collapseChildren();
										if(!Ext.isEmpty(me.allNodeCheck) && !Ext.isEmpty(me.allNodeCheck[layerName+"_Test_Exp"]))
										{
											me.allNodeCheck[layerName+"_Test_Exp"] = false;
										}
									}
								}
								me.allCheck[layerName] = newValue;
							}
						}
	        		});
				
					
					if(recordText+"_trigger"){
							
							Ext.create('Ext.container.Container',{
								id:recordText+"_holder",
								renderTo : recordText+"_trigger",
								autoDestroy : true,
								items:[searchIcon,searchTests]
							});
					}
					Ext.getCmp(recordText+"_holder").doComponentLayout();
				
					
					delete searchTests, searchIcon;

	        		/*var allCheckbox = Ext.create('Ext.form.Label',{
	        			renderTo : recordText+"_checkbox",
	        			style : 'position:absolute;font-size:11px; right:40px; top: 1px;font-weight:normal;',
	        			text : 'All'
						//hidden:true
	        		});*/
	        	}

	        	if(!Ext.isEmpty(layersTree.getEl())){
					//layersTree.getEl().unmask();
				}

				jsonData = null;
				delete jsonData;
				Ext.destroy(jsonData);
		    }, 
		    failure : function(){
		    	if(!Ext.isEmpty(layersTree.getEl())){
					//layersTree.getEl().unmask();
				}
			}
		});
	},
	reloadMeasures : function(node){
    	var me = this;
    	var measuresOpened = false;
    	if(node.raw.selected == true && node.raw.leaf == true){
    		measuresOpened = true;
    		if(Ext.isEmpty()){
    			me.layersTreeBeforeItemClick(me.getLayerstree().getView(), node, me.getLayerstree().getView().getNode(node), 0, "", "");
    		} else {
    			var myNode;
				treePanel=me.getLayerstree();
				var myRoot = treePanel.getRootNode();
				myNode=myRoot.findChild('text',me.selectedTest);
				if(myNode===null){
					myRoot.eachChild(function(child){
						myNode=child.findChild('text',me.selectedTest);
						if(myNode!==null){
							me.layersTreeBeforeItemClick(me.getLayerstree().getView(), myNode, me.getLayerstree().getView().getNode(myNode), 0, "", "");
						} else {
							child.eachChild(function(child){
								var thisNode=child.findChild('text',me.selectedTest);
								if(thisNode!==null){
									me.layersTreeBeforeItemClick(me.getLayerstree().getView(), thisNode, me.getLayerstree().getView().getNode(thisNode), 0, "", "");
								}
							});
						}
					});
				}
				else{
					me.layersTreeBeforeItemClick(me.getLayerstree().getView(), myNode, me.getLayerstree().getView().getNode(myNode), 0, "", "");
				}
    		}
    		if(Ext.isEmpty(me.measuresUrl)){
    			me.measuresUrl = '/final/monitor/egDashBoardDispCompMeasure.jsp?'+node.raw.measuresLink;
    		}
    		me.getMeasures().changeUrl(me.measuresUrl);
			me.getMeasures().refreshData();
    	} else if(!Ext.isEmpty(me.selectedTest)) {
    		measuresOpened = true;
			var myNode;
			treePanel=me.getLayerstree();
			var myRoot = treePanel.getRootNode();
			myNode=myRoot.findChild('text',me.selectedTest);
			if(myNode==null){
				myRoot.eachChild(function(child){
					myNode=child.findChild('text',me.selectedTest);
					if(myNode!==null && myNode.raw.selected == true){
						me.layersTreeBeforeItemClick(me.getLayerstree().getView(), myNode, me.getLayerstree().getView().getNode(myNode), 0, "", "");
					} else {
						child.eachChild(function(child){
							var thisNode=child.findChild('text',me.selectedTest);
							if(thisNode!==null && thisNode.raw.selected == true){
								me.layersTreeBeforeItemClick(me.getLayerstree().getView(), thisNode, me.getLayerstree().getView().getNode(thisNode), 0, "", "");
							}else {
								child.eachChild(function(child){
									var noder=child.findChild('text',me.selectedTest);
									if(noder!==null && noder.raw.selected == true){
										me.layersTreeBeforeItemClick(me.getLayerstree().getView(), noder, me.getLayerstree().getView().getNode(noder), 0, "", "");
									}
								});
							}
						});
					}
				});
			}
			else if(myNode.raw.selected == true){
				me.layersTreeBeforeItemClick(me.getLayerstree().getView(), myNode, me.getLayerstree().getView().getNode(myNode), 0, "", "");
			}
		}
	},
	getMeasuresUrl : function(){
		return this.measuresUrl;
	},
	selectedServerType : function(combo, records, eOpts){
		var serverType=this.getFilterstoolbarServerType().getValue();
		var wholeViewport = document.getElementsByTagName("body")[0];

		// To display previous selected component if compType is empty
		if(serverType=="")
		{
			//alert(_noComponentTypeMsg);
			alert("Please choose a valid component type");
			this.getFilterstoolbarServerType().setValue(selected_compType);
			return false;
		}

		if(!Ext.isEmpty(Ext.get(wholeViewport))){
			mask = new Ext.LoadMask(Ext.get(wholeViewport), {msg:"Loading...",cls:'maskDash'});
			mask.show();
		}

		//var treePanel=this.getComponentsTreePanel();
		var treeCollapsed=false;//!treePanel.getCollapsed();
		//var selected = this.getFilterstoolbarServerType().findRecordByValue(this.getFilterstoolbarServerType().getValue());
		//selected = selected.get('text');

		var url = "/final/servlet/com.eg.EgDashboardController?from=list&comesFrom=componentSelect&comptype="+encodeURI(serverType);
		document.location = url;
	},
	selectedServerName : function(combo, records, eOpts){
		var serverType=this.getFilterstoolbarServerType().getValue();
		var serverName=this.getFilterstoolbarServerName().getValue();
		var wholeViewport = document.getElementsByTagName("body")[0];
		
		if(serverType=="")
		{
			//alert(_noComponentMsg);
			alert("Please choose a valid component name");
			return false;
		}

		if(!Ext.isEmpty(Ext.get(wholeViewport))){
			mask = new Ext.LoadMask(Ext.get(wholeViewport), {msg:"Loading...",cls:'maskDash'});
			mask.show();
		}

		//var treePanel=this.getComponentsTreePanel();
		var treeCollapsed=false//!treePanel.getCollapsed();
		//var selected = this.getFilterstoolbarServerName().findRecordByValue(this.getFilterstoolbarServerName().getValue());
		//selected = selected.get('text');
		var url = "/final/servlet/com.eg.EgDashboardController?from=list&comesFrom=componentSelect&comptype="+encodeURI(serverType)+"&host="+encodeURI(serverName);
		document.location = url;
	},
	selectedCompType : function(combo, records, eOpts){
		localStorage.setItem("netflowactivetab","");
		localStorage.setItem("interfaceLastSelectedView","");
		localStorage.setItem("showLastSelectedView","");
		localStorage.setItem("timelineLastSelectedView","");
		var element=this.getFilterstoolbarCompType().getValue();
		var compType=element.substring(0,element.indexOf(":"));
		var compName=element.substring(element.indexOf(":")+1,element.length);
		var wholeViewport = document.getElementsByTagName("body")[0];
		
		// To display previous selected component if compType is empty
		if(compType=="")
		{
			//alert(_noComponentMsg);
			alert("Please choose a valid component");
			this.getFilterstoolbarCompType().setValue(selected_comp);
			return false;
		}

		if(!Ext.isEmpty(Ext.get(wholeViewport))){
			mask = new Ext.LoadMask(Ext.get(wholeViewport), {msg:"Loading...",cls:'maskDash'});
			mask.show();
		}
		//var treePanel=this.getComponentsTreePanel();
		var treeCollapsed=false;
		//var selected = this.getFilterstoolbarCompType().findRecordByValue(this.getFilterstoolbarCompType().getValue());
		//var componentType = selected.get('text');
		//selected = selected.get('text');
		//selected = selected.substring(selected.indexOf(":")+1,selected.length);
		this.recordClicked =[];
		this.testSearchedLayers =[];
		this.allCheck = new Object();
		this.allNodeCheck = new Object();
		rootCauseCheck = true;
		document.location = '/final/servlet/com.eg.EgDashboardController?from=list&comesFrom=componentSelect&comptype='+encodeURI(compType)+'&host='+encodeURI(compName);
	},

	selectTestInfo:function(layers){
		var me = this;
		var selectionModel = this.getLayerstree().getSelectionModel();
		me.getLayerstree().getView().suspendEvents(true);
		var countTestLen=0;
		layers.eachChild(function(test){
			if(test.raw.selected == true || test.raw.selected == 'true'){
				me.selectedTest = test.raw.text;
				if(test.childNodes.length > 0){
					var countInfoLen=0;
					test.eachChild(function(info)
					{
						if(info.raw.selected == true || info.raw.selected == 'true' || info.raw.text.indexOf('Click here for the complete list') > -1)
						{
							if(info.childNodes.length > 0)
							{
								var countInnerInfoLen=0;
								info.eachChild(function(subtree)
								{
									if(subtree.raw.selected == true || subtree.raw.selected == 'true')
									{
										me.layersTreeBeforeItemClick(me.getLayerstree().getView(), subtree, me.getLayerstree().getView().getNode(subtree), 0, "", "");
										info.expand();
									}
									else
									{
										countInnerInfoLen++;
										if(info.childNodes.length==countInnerInfoLen)
										{
											//me.getMeasures().changeUrl('/final/monitor/egDashBoardDispCompMeasure.jsp?');
											//me.getMeasures().refreshData();
										}
									}
								});
							}
							else
							{
								me.layersTreeBeforeItemClick(me.getLayerstree().getView(), info, me.getLayerstree().getView().getNode(info), 0, "", "");
							}
						}
						else
						{
							countInfoLen++;
							if(test.childNodes.length==countInfoLen)
							{
								//me.getMeasures().changeUrl('/final/monitor/egDashBoardDispCompMeasure.jsp?');
								//me.getMeasures().refreshData();
							}
						}
					});
				}
				else{
					me.layersTreeBeforeItemClick(me.getLayerstree().getView(), test, me.getLayerstree().getView().getNode(test), 0, "", "");
				}
			}
			/*else
			{
				countTestLen++;
				if(test.length==countTestLen)
				{
					me.getMeasures().changeUrl('/final/monitor/egDashBoardDispCompMeasure.jsp?');
					me.getMeasures().refreshData();
				}
			}*/
		});
		me.getLayerstree().getView().resumeEvents();
	},
	selectTestInfoCol:function(layers){
		var me = this;
		var selectionModel = this.getLayerstree().getSelectionModel();
		me.getLayerstree().getView().suspendEvents(true);

		layers.eachChild(function(test){
			if(test.raw.selected == true || test.raw.selected == 'true'){
				me.selectedTest = test.raw.text;
				if(test.childNodes.length > 0){
					test.eachChild(function(info){
						if(info.raw.selected == true || info.raw.selected == 'true' || info.raw.selected == true || info.raw.text.indexOf('Click here for the complete list') > -1){
							if(info.childNodes.length > 0)
							{
								info.eachChild(function(subtree){
									if(subtree.raw.selected == true || subtree.raw.selected == 'true')
									{
										me.layersTreeBeforeItemClick(me.getLayerstree().getView(), subtree, me.getLayerstree().getView().getNode(subtree), 0, "", "");
										info.expand();
									}
									else
									{
										test.expand();
									}
								});
							}
							else{
								me.layersTreeBeforeItemClick(me.getLayerstree().getView(), info, me.getLayerstree().getView().getNode(info), 0, "", "");
								test.expand();
							}
						}
						else
						{
							test.expand();
						}
					});
				}
				else{
					me.layersTreeBeforeItemClick(me.getLayerstree().getView(), test, me.getLayerstree().getView().getNode(test), 0, "", "");
					test.collapse();
				}
			}
			else
			{
				test.collapse();
			}
		});
		me.getLayerstree().getView().resumeEvents();
	},
	expandNodes:function(nodeInterface,eOpts){
		if(!Ext.isEmpty(this.getLayerstree())){
			var element = Ext.fly(this.getLayerstree().getView().getNode(nodeInterface));
			if(!Ext.isEmpty(element) && element.hasCls('layers-tree-bold-node')){
				
				nodeInterface.applyCls = 'layers-tree-bold-node';
				
			}
		}
	},

	collapseNodes:function(nodeInterface,eOpts){
		if(!Ext.isEmpty(this.getLayerstree())){
			var element = Ext.fly(this.getLayerstree().getView().getNode(nodeInterface));
			if(!Ext.isEmpty(element) && element.hasCls('layers-tree-bold-node')){
				
				nodeInterface.applyCls = 'layers-tree-bold-node';
				
			}
		}
	},

	afterExpandNodes:function(node,index,item,eOpts){
		if(!Ext.isEmpty(node.applyCls)){
			this.selectTestInfo(node);
		}
	},

	afterCollapseNodes:function(node,index,item,eOpts){
		if(!Ext.isEmpty(node.applyCls)){
			this.selectTestInfo(node);
		}
	},
	showMaintenanceWindow : function(entityType,entityDispName,instantMaintenanceConfigParams)
	{
		var meLyrCtrl=this;
		var winParObj = window.parent;
		try
		{
			Ext.Ajax.request({
						url : '/final/servlet/com.eg.EgDashboardController',
						mathod : 'POST',
						params : 'from=loadInstantanceMaintenanceOptions',
						async: true,
						scope:this,
						success: function(response) 
						{
							var jsonText = response.responseText;
							if(!Ext.isEmpty(jsonText))
							{
								var jsonData=Ext.decode(jsonText);
								entityDispName = replaceAll(entityDispName,'!spc!',' ');
								var windowHeightVal=200;
								if(entityType!=null && entityType=='Descriptor for Component')
								{
									var entityDispArr = entityDispName.split('!sep!');
									if(!Ext.isEmpty(entityDispArr))
									{
										var tmpHtm='<table id="tableId" class="policyLabelBottomBorder1" border="0" cellspacing="0" cellpadding="0" width="100%" style="margin: 0px 0 0;">';
												tmpHtm+='<tr>';
													tmpHtm+='<td width="90" style="padding:3px 0 18px 0" >Component</td><td style="padding:3px 0 18px 0">'+entityDispArr[0]+'</td>';
												tmpHtm+='</tr>';
												tmpHtm+='<tr>';
													tmpHtm+='<td style="padding:3px 0 18px 0">Test</td><td style="padding:3px 0 18px 0">'+entityDispArr[1]+'</td>';
												tmpHtm+='</tr>';
												var descForComp=entityDispArr[2];
												if(!Ext.isEmpty(descForComp) && descForComp!='+')
												{
													tmpHtm+='<tr>';
														tmpHtm+='<td style="padding:3px 0 18px 0">Descriptor</td><td style="padding:3px 0 18px 0">'+entityDispArr[2]+'</td>';
													tmpHtm+='</tr></table>';
												}

										entityDispName=tmpHtm;

										windowHeightVal=255;
									}
									else
									{
										entityDispName='<span>'+entityDispName+'</span>';
									}
								}
								else
								{
									var entityDispArr = entityDispName.split('!sep!');
									if(!Ext.isEmpty(entityDispArr))
									{
										var tmpHtm='<table id="tableId" border="0" cellspacing="0" cellpadding="0" width="100%" style="margin: 0px 0 0;">';
										tmpHtm+='<tr >';
											tmpHtm+='<td width="90" style="padding:3px 0 18px 0">Component</td><td style="padding:3px 0 18px 0">'+entityDispArr[0]+'</td>';
										tmpHtm+='</tr>';
										tmpHtm+='<tr >';
											tmpHtm+='<td style="padding:3px 0 18px 0">Test</td><td style="padding:3px 0 18px 0">'+entityDispArr[1]+'</td>';
										tmpHtm+='</tr>';
										entityDispName=tmpHtm;
										//entityDispName='<span>'+entityDispName+'</span>';
									}
									else
									{
										entityDispName='<span>'+entityDispName+'</span>';
									}
								}
								var mainpolArr=[];
								mainpolArr.push({
										xtype:'form',
										layout:'anchor',
										itemId : 'maintenanceConfigForm',
										name:'layoutConfig',
										bodyPadding:'18 20 20 20',
										autoScroll : true,
										defaults:{
											labelSeparator:'',
											labelAlign:'top',
											
										},
										buttonAlign: 'center',
										hideMinutes : true,
										selectedMgrStMin : '',
										selectedMgrEndMin : '',
										selectedStMinForDisplay : '',
										selectedEndminForDisplay : '',
										buttons : [
														{
															text: '<span style="font-size:12px;line-height:25px;width:83px">'+addPolicyLbl+'</span>',
															labelAlign:'top',
															id: 'addPolicyBtn',
															name: 'addPolicyBtn',
															cls: 'buttonNew',
															height: 25,
															padding: 0,
															margin: '0 0 0 0',
															handler : function(btnObj)
															{
																var policyname=Ext.getCmp('mainPolicyName').getValue();
																
																if (policyname == "" || policyname.length == 0) {
																	Ext.Msg.show({
																		title: instMainPlcyTitle,
																		msg: emptyPolicyName,
																		buttons: Ext.Msg.OK,
																		icon : 'iconExclamation'
																	});
																	return;
																}
																if (policyname.match(/[ ]/) != null) {
																	Ext.Msg.show({
																		title: instMainPlcyTitle,
																		msg: spaceMsg,
																		buttons: Ext.Msg.OK,
																		icon : 'iconExclamation'
																	});
																	return;
																}			
																if (meLyrCtrl.checkSpecialCharacter(policyname)) {
																//if (policyname.match(/[~!@#$%^&*()-+={}:<>?\|`,]/) != null) {
																	Ext.Msg.show({
																		title: instMainPlcyTitle,
																		msg: specialcharacterMsg,
																		buttons: Ext.Msg.OK,
																		icon : 'iconExclamation'
																	});
																	return;
																}
																var startDateVal = Ext.getCmp('er_stdate').dataArray;
																var endDateVal = Ext.getCmp('er_enddate').dataArray;
																var startHour = Ext.getCmp('er_sthr').getValue();
																var endHour = Ext.getCmp('er_endhr').getValue();
																var start_minValue = Ext.getCmp('er_stmin').dataArray;
																var end_MinValue = Ext.getCmp('er_endmin').dataArray;
																var stDate = Ext.getCmp('er_stdate').getValue();
																var enDate = Ext.getCmp('er_enddate').getValue();
																stDate.setHours(Ext.getCmp('er_sthr').getValue());
																enDate.setHours(Ext.getCmp('er_endhr').getValue());
																var startMinObj = Ext.getCmp('er_stmin');
																var endMinObj = Ext.getCmp('er_endmin');
																var stmin=startMinObj.getValue();
																var endmin=endMinObj.getValue();
																stDate.setMinutes(stmin);
																enDate.setMinutes(endmin);
																start_minValue = stmin;
																end_MinValue = endmin;


																var fromValue = formatDate(stDate, mgrDisplayDateFormat);
																var ToValue = formatDate(enDate, mgrDisplayDateFormat);
																//Date validation
																var today = new Date();
																var currentDate = today.getMonth() + "/" + today.getDay() + "/" + today.getYear();
																
																if(new Date(fromValue) > new Date(ToValue))
																{
																	Ext.MessageBox.show({
																		title:instMainPlcyTitle,
																		msg: DateErrorMsg,
																		buttons: Ext.MessageBox.OK,
																		icon: Ext.MessageBox.WARNING
																	});
																	return false;
																}
																if(new Date(fromValue).valueOf() == new Date(ToValue).valueOf())
																{
																	if(startHour > endHour)
																	{
																		Ext.MessageBox.show({
																		title: instMainPlcyTitle,
																		msg: DateErrorMsg,
																		buttons: Ext.MessageBox.OK,
																		icon: Ext.MessageBox.WARNING
																		});
																		return false;
																	}
																}
																var timeNowDateObj = formatDate(today, mgrDisplayDateFormat);
																if(new Date(fromValue) < new Date(timeNowDateObj))
																{
																	Ext.MessageBox.show({
																		title: instMainPlcyTitle,
																		msg: timeErrorMsg,
																		buttons: Ext.MessageBox.OK,
																		icon: Ext.MessageBox.WARNING
																		});
																		return false;
																}
																if (isLimitedAdmin == 'true' && policyname.indexOf('|$|') == -1) //Limited admin
																{
																	internalPolicyName = policyname + '|$|' + userLoginID;
																}
																//alert(startDateVal+" "+endDateVal);
																
																startDateVal = formatDate(new Date(getDateFromFormat(startDateVal, mgrDisplayDateFormat)), "MM/dd/yyyy");
																endDateVal = formatDate(new Date(getDateFromFormat(endDateVal, mgrDisplayDateFormat)), "MM/dd/yyyy");
																 var policyEntries = startHour + ":" + start_minValue + "-" + endHour + ":" + end_MinValue + "!HASH!" + startDateVal + "|" + endDateVal;
																policyEntries=winParObj.filterEncode(policyEntries);
																instantMaintenanceConfigParams=instantMaintenanceConfigParams+'&policyName='+encodeURIComponent(policyname)+'&policyEntries='+encodeURIComponent(policyEntries)+"&decodePolicyEntries=yes";
																Ext.Ajax.request(
																{
																	url : '/final/servlet/com.eg.EgDashboardController',
																	method : 'POST',
																	params : instantMaintenanceConfigParams,
																	async: false,
																	scope:this,
																	success: function(response) 
																	{
																		if(response.status == 200 && !Ext.isEmpty(response))
																		{
																			var jsonText = response.responseText;
																			jsonText=Ext.String.trim(jsonText);
																			
																			if(jsonText != null && jsonText != 'null' && jsonText != 'undefined' && jsonText != undefined && (!Ext.isEmpty(jsonText)))
																			{
																				var chartData=Ext.decode(jsonText);
																				Ext.getCmp('MaintenanceConfigWindow').close();
																				Ext.Msg.show({
																					title: instMainPlcyTitle,
																					msg: policyCreationMsg,
																					buttons:Ext.MessageBox.OK,
																					icon:Ext.MessageBox.INFO
																				});
																			}
																		}
																	}
																});
															}
														}
										],
										items:[
											{
												xtype : 'container',
												flex : 1,
												layout : 'auto',
												margin:0,
												padding:0,
												items: [
													{
														xtype: 'container',
														flex:1,
														html : entityDispName,
														cls:'policyLabelBottomBorder',
														padding: '18 0 0 0',
														margin:0,
													}
												]
												
											},
											{
												xtype:'textfield',
												id : 'mainPolicyName',
												name:'mainPolicyName',
												cls: 'textbox24',
												labelAlign:'top',
												padding: 0,
												margin: '16 0 6 0',
												width:	'100%',
												
												fieldLabel:mpolicyLbl
											},
											{
												xtype: 'container',
												layout: {
													type:'vbox',
													align: 'stretch'
												},
												id: 'timeline_box',
												//hidden: true,
												//width : 314,
												defaults: {
													labelAlign: 'top',
													labelSeparator:'',
												},
												margin:'0 0 0 0',
												padding:'0 0 0 0',
												//style : { 'border' : '2px solid red'},
												items: [{
															xtype: 'container',
															layout: {
																type:'hbox',
																align: 'stretch'
															},
															//width : '314',
															defaults: {
																labelAlign: 'top',
																labelSeparator:'',
															},				
															margin:'0 0 10 0',
															padding:'0 0 0 0',
															items : [{
																	xtype: 'datefield',
																	id: 'er_stdate',
																	name: 'er_stdate',
																	format: mgrDateFormat,
																	fieldLabel: fromLbl,
																	cls: 'datepickerBig',
																	labelAlign: 'top',
																	width : 132,
																	margin : '0 0 0 0',
																	disabled: false,
																	dataArray: null,
																	listeners:
																	{
																		'select': function(obj)
																		{
																			var stMinObj=Ext.getCmp('er_stmin');
																			var enMinObj=Ext.getCmp('er_endmin');
																			
																			var strtdt = Ext.getCmp("er_stdate").getValue();
																			var enddt = Ext.getCmp("er_enddate").getValue();
																			var strthour = Ext.getCmp("er_sthr").getValue();
																			var endhr = Ext.getCmp("er_endhr").getValue();
																			var strtmin = Ext.getCmp("er_stmin").getValue();
																			var endmin = Ext.getCmp("er_endmin").getValue();
																			var erModeObj = Ext.getCmp('er_mode');
																			var isHideMinutes=false;
																			/*if (window['appConstants']!=undefined && appConstants.appController!='reportermenudashboard.controller.ReporterController')
																		{					
																			this.up('form').erUtils.toggleGraphCombo(timeline,strtdt,enddt,strthour,endhr,erModeObj);
																		}*/
																			strtdt = Ext.Date.dateFormat(strtdt, 'm/d/Y');
																			enddt = Ext.Date.dateFormat(enddt, 'm/d/Y');
																			
																			var no_params = "&P0=[Any]&P1=[" + strtdt + "]&P2=[" + enddt + "]&P3=[" + strthour + "]&P4=[" + endhr + "]&P5=[" + strtmin + "]&P6=[" + endmin + "]&P7=[" + dateFormatForTimeline + "]";
																			
																			no_params += "&F=getTime";
																			if(!isHideMinutes)
																			{
																				no_params +="&P8=[true]";
																			}
																			
																			var param = "C=id" + no_params;
																			Ext.Ajax.request(
																			{
																				url: '/final/servlet/com.eg.ErRemoteScriptingServlet',
																				params: param,
																				scope: this,
																				method: 'POST',
																				success: function(response)
																				{
																					var jsontext = response.responseText;
																					var jsonData = Ext.decode(jsontext);
																					if (!Ext.isEmpty(jsonData))
																					{

																						var timedata = jsonData.timeline;

																						Ext.getCmp("er_stdate").dataArray = timedata[0];
																						Ext.getCmp("er_enddate").setValue(timedata[7]);
																						Ext.getCmp("er_stdate").setValue(timedata[6]);
																						Ext.getCmp("er_enddate").dataArray = timedata[1];
																						if (!isTrend)
																						{
																							Ext.getCmp("er_sthr").setValue(timedata[8]);
																							Ext.getCmp("er_sthr").dataArray = timedata[2];
																							Ext.getCmp("er_endhr").setValue(timedata[9]);
																							Ext.getCmp("er_endhr").dataArray = timedata[3];
																							Ext.getCmp("er_stmin").setValue(timedata[4]);
																							Ext.getCmp("er_stmin").dataArray = timedata[4];
																							Ext.getCmp("er_endmin").setValue(timedata[5]);
																							Ext.getCmp("er_endmin").dataArray = timedata[5];
																							/*stmin = timedata[10];
																							enmin = timedata[11];
																							mgr_stmin = timedata[4];
																							mgr_enmin = timedata[5];*/

																							if(!isHideMinutes)
																							{
																								var selectedStMinForDisplay=this.up('form').selectedStMinForDisplay;
																								var selectedEndminForDisplay=this.up('form').selectedEndminForDisplay;
																								
																								if((selectedStMinForDisplay!=null && selectedStMinForDisplay!='') && (selectedEndminForDisplay!=null && selectedEndminForDisplay!=''))
																								{
																									var selectedMgrStMin=this.up('form').selectedMgrStMin;
																									var selectedMgrEndMin=this.up('form').selectedMgrEndMin;
																									stMinObj.setValue(selectedStMinForDisplay);
																									stMinObj.dataArray = selectedMgrStMin;
																									enMinObj.setValue(selectedEndminForDisplay);
																									enMinObj.dataArray = selectedMgrEndMin;
																									this.up('form').selectedStMinForDisplay='';
																									this.up('form').selectedMgrStMin='';
																									this.up('form').selectedEndminForDisplay='';
																									this.up('form').selectedMgrEndMin='';
																								}
																								else
																								{
																									stMinObj.setValue(timedata[4]);
																									stMinObj.dataArray = timedata[4];
																									enMinObj.setValue(timedata[5]);
																									enMinObj.dataArray = timedata[5];
																								}
																							}
																						}
																					}
																				}
																			});
																		}
																	}
																},
																{
																	xtype: 'scrollcombo',
																	width: 54,
																	id: 'er_sthr',
																	name: 'er_sthr',
																	defaultListConfig:
																	{
																		loadingHeight: 70,
																		minWidth: 30,
																		maxHeight: 300,
																		shadow: 'sides'
																	},
																	margin : '0 0 0 10',
																	store: ['00', '01', '02', '03', '04', '05', '06', '07', '08', '09', '10', '11', '12', '13', '14', '15', '16', '17', '18', '19', '20', '21', '22', '23'],
																	displayField: 'displayField',
																	valueField: 'valueField',
																	queryMode: 'local',
																	fieldLabel: hrLbl,
																	cls: 'dropdown24',
																//	disabled: true,
																	dataArray: null,
																	listeners:
																	{
																		'select': function(combo)
																		{
																			formated_sdate = Ext.Date.dateFormat(Ext.getCmp("er_stdate").getValue(), mgrDateFormat);
																			if (stmin == null || stmin == "undefined" || stmin == '')
																				stmin = "00";
																			var dateValue = formated_sdate + " " + combo.getValue() + ":" + stmin + ":00";

																			var param = "date=" + dateValue + "&method=getDateTime&isReverse=true&isFromReporter=true";
																			Ext.Ajax.request(
																			{
																				url: '/final/servlet/com.eg.EgTimeZoneConverterServlet',
																				params: param,
																				scope: this,
																				method: 'POST',
																				success: function(response)
																				{


																					var responseText = response.responseText;
																					responseText = Ext.String.trim(responseText);
																					var dt = responseText.substring(0, responseText.lastIndexOf(" "));
																					var tim = responseText.substring(responseText.lastIndexOf(" ") + 1);

																					if (!isTrend)
																					{
																						if (tim != null && (tim.indexOf(":") == tim.lastIndexOf(":")))
																						{
																							Ext.getCmp("er_sthr").dataArray = tim.substring(0, tim.indexOf(":"));
																						}
																						else if (tim != null && tim.length > 0 && tim.indexOf(":") > -1)
																						{
																							Ext.getCmp("er_sthr").dataArray = tim.substring(0, tim.indexOf(":"));

																						}
																					}
																				}
																			});
																		}
																	}
																},
																{
																	xtype: 'scrollcombo',
																	width: 54,
																	id: 'er_stmin',
																	name: 'er_stmin',
																	defaultListConfig: {
																		loadingHeight: 70,
																		minWidth: 30,
																		maxHeight: 300,
																		shadow: 'sides'
																	},
																	margin : '0 0 0 20',
																	store: ['00', '01', '02', '03', '04', '05', '06', '07', '08', '09', '10', '11', '12', '13', '14', '15', '16', '17', '18', '19', '20', '21', '22', '23','24','25','26','27','28','29','30','31','32','33','34','35','36','37','38','39','40','41','42','43','44','45','46','47','48','49','50','51','52','53','54','55','56','57','58','59'],
																	displayField: 'displayField',
																	valueField: 'valueField',
																	queryMode: 'local',
																	fieldLabel: minLbl,
																	cls: 'dropdown24',
																//	disabled: true,
																	hidden : this.hideMinutes,
																	dataArray: null,
																	listeners: {
																		'select': function (combo) {
																			formated_sdate = Ext.Date.dateFormat(Ext.getCmp("er_stdate").getValue(),mgrDateFormat);
																			var dateValue = formated_sdate + " " + Ext.getCmp("er_sthr").getValue() + ":" + combo.getValue() + ":00";
																			var param = "date=" + dateValue + "&method=getDateTime&isReverse=true&isFromReporter=true";
																			Ext.Ajax.request({
																				url: '/final/servlet/com.eg.EgTimeZoneConverterServlet',
																				params: param,
																				scope: this,
																				method: 'POST',
																				success: function (response) {
																					var responseText = response.responseText;
																					responseText = Ext.String.trim(responseText);
																					var dt = responseText.substring(0, responseText.lastIndexOf(" "));
																					var tim = responseText.substring(responseText.lastIndexOf(" ") + 1);
																				   if(!isTrend){
																					if (tim != null && (tim.indexOf(":") == tim.lastIndexOf(":"))) {
																					   Ext.getCmp("er_stmin").dataArray = '00';
																					} else if (tim != null && tim.length > 0 && tim.indexOf(":") > -1) {
																						Ext.getCmp("er_stmin").dataArray = tim.substring(tim.indexOf(":")+1,tim.lastIndexOf(":"));
																					}
																				   }
																				}
																			});
																		}
																	}
																}]
														},
														{
															xtype: 'container',
															layout: {
																type:'hbox',
																align: 'stretch'
															},
															flex  : 1,
															defaults: {
																labelAlign: 'top',
																labelSeparator:'',
															},				
															margin:'0 0 0 0',
															padding:'0 0 0 0',
															items : [{
																		xtype: 'datefield',
																		id: 'er_enddate',
																		name: 'er_enddate',
																		format: mgrDateFormat,
																		fieldLabel: Tolbl,
																		cls: 'datepickerBig',
																		labelAlign: 'top',
																		width : 132,
																		margin : '0 0 0 0',
																		disabled: false,
																		dataArray: null,
																		listeners:
																		{
																			'select': function(obj)
																			{
																				var stMinObj=Ext.getCmp('er_stmin');
																				var enMinObj=Ext.getCmp('er_endmin');
																				
																				var strtdt = Ext.getCmp("er_stdate").getValue();
																				var enddt = Ext.getCmp("er_enddate").getValue();
																				var strthour = Ext.getCmp("er_sthr").getValue();
																				var endhr = Ext.getCmp("er_endhr").getValue();
																				var strtmin = Ext.getCmp("er_stmin").getValue();
																				var endmin = Ext.getCmp("er_endmin").getValue();
																				var erModeObj = Ext.getCmp('er_mode');
																				var isHideMinutes=false;
																				/*if (window['appConstants']!=undefined && appConstants.appController!='reportermenudashboard.controller.ReporterController')
																			{					
																				this.up('form').erUtils.toggleGraphCombo(timeline,strtdt,enddt,strthour,endhr,erModeObj);
																			}*/
																				
																				strtdt = Ext.Date.dateFormat(strtdt, 'm/d/Y');
																				enddt = Ext.Date.dateFormat(enddt, 'm/d/Y');
																				
																				var no_params = "&P0=[Any]&P1=[" + strtdt + "]&P2=[" + enddt + "]&P3=[" + strthour + "]&P4=[" + endhr + "]&P5=[" + strtmin + "]&P6=[" + endmin + "]&P7=[" + dateFormatForTimeline + "]";
																				
																				no_params += "&F=getTime";
																				if(!isHideMinutes)
																				{
																					no_params +="&P8=[true]";
																				}
																				
																				var param = "C=id" + no_params;
																				Ext.Ajax.request(
																				{
																					url: '/final/servlet/com.eg.ErRemoteScriptingServlet',
																					params: param,
																					scope: this,
																					method: 'POST',
																					success: function(response)
																					{
																						var jsontext = response.responseText;
																						var jsonData = Ext.decode(jsontext);
																						if (!Ext.isEmpty(jsonData))
																						{
																							var timedata = jsonData.timeline;
																							Ext.getCmp("er_stdate").setValue(timedata[6]);
																							Ext.getCmp("er_stdate").dataArray = timedata[0];
																							Ext.getCmp("er_enddate").setValue(timedata[7]);
																							Ext.getCmp("er_enddate").dataArray = timedata[1];
																							if (!isTrend)
																							{

																								Ext.getCmp("er_sthr").setValue(timedata[8]);
																								Ext.getCmp("er_sthr").dataArray = timedata[2];
																								Ext.getCmp("er_endhr").setValue(timedata[9]);
																								Ext.getCmp("er_endhr").dataArray = timedata[3];
																								Ext.getCmp("er_stmin").setValue(timedata[4]);
																								Ext.getCmp("er_stmin").dataArray = timedata[4];
																								Ext.getCmp("er_endmin").setValue(timedata[5]);
																								Ext.getCmp("er_endmin").dataArray = timedata[5];
																								/*stmin = timedata[10];							
																								enmin = timedata[11];
																								mgr_stmin = timedata[4];
																								mgr_enmin = timedata[5];*/

																								if(!isHideMinutes)
																								{
																									var selectedStMinForDisplay=this.up('form').selectedStMinForDisplay;
																									var selectedEndminForDisplay=this.up('form').selectedEndminForDisplay;
																									
																									if((selectedStMinForDisplay!=null && selectedStMinForDisplay!='') && (selectedEndminForDisplay!=null && selectedEndminForDisplay!=''))
																									{
																										var selectedMgrStMin=this.up('form').selectedMgrStMin;
																										var selectedMgrEndMin=this.up('form').selectedMgrEndMin;
																										stMinObj.setValue(selectedStMinForDisplay);
																										stMinObj.dataArray = selectedMgrStMin;
																										enMinObj.setValue(selectedEndminForDisplay);
																										enMinObj.dataArray = selectedMgrEndMin;
																										this.up('form').selectedStMinForDisplay='';
																										this.up('form').selectedMgrStMin='';
																										this.up('form').selectedEndminForDisplay='';
																										this.up('form').selectedMgrEndMin='';
																									}
																									else
																									{
																										stMinObj.setValue(timedata[4]);
																										stMinObj.dataArray = timedata[4];
																										enMinObj.setValue(timedata[5]);
																										enMinObj.dataArray = timedata[5];
																									}
																								}
																							}
																						}
																					}
																				});
																			}
																		}
																	},
																	{
																		xtype: 'scrollcombo',
																		width: 54,
																		defaultListConfig:
																		{
																			loadingHeight: 70,
																			minWidth: 30,
																			maxHeight: 300,
																			shadow: 'sides'
																		},
																		fieldLabel: hrLbl,
																		cls: 'dropdown24',
																		id: 'er_endhr',
																		name: 'er_endhr',
																		margin : '0 0 0 10',
																		store: ['00', '01', '02', '03', '04', '05', '06', '07', '08', '09', '10', '11', '12', '13', '14', '15', '16', '17', '18', '19', '20', '21', '22', '23'],
																		displayField: 'displayField',
																		valueField: 'valueField',
																		queryMode: 'local',
																	//	disabled: true,
																		dataArray: null,
																		listeners:
																		{
																			'select': function(combo)
																			{
																				formated_sdate = Ext.Date.dateFormat(Ext.getCmp("er_enddate").getValue(), mgrDateFormat);
																				if (enmin == null || enmin == "undefined" || enmin == '')
																					enmin = "00";
																				var dateValue = formated_sdate + " " + combo.getValue() + ":" + enmin + ":00";
																				var param = "date=" + dateValue + "&method=getDateTime&isReverse=true&isFromReporter=true";
																				Ext.Ajax.request(
																				{
																					url: '/final/servlet/com.eg.EgTimeZoneConverterServlet',
																					params: param,
																					scope: this,
																					method: 'POST',
																					success: function(response)
																					{
																						var responseText = response.responseText;
																						responseText = Ext.String.trim(responseText);
																						var dt = responseText.substring(0, responseText.lastIndexOf(" "));
																						var tim = responseText.substring(responseText.lastIndexOf(" ") + 1);
																						if (!isTrend)
																						{
																							if (tim != null && (tim.indexOf(":") == tim.lastIndexOf(":")))
																							{
																								Ext.getCmp("er_endhr").dataArray = tim.substring(0, tim.indexOf(":"));
																							}
																							else if (tim != null && tim.length > 0 && tim.indexOf(":") > -1)
																							{
																								Ext.getCmp("er_endhr").dataArray = tim.substring(0, tim.indexOf(":"));
																							}
																						}
																					}
																				});
																			}
																		}
																	},
																	{
																		xtype: 'scrollcombo',
																		width: 54,
																		id: 'er_endmin',
																		name: 'er_endmin',
																		defaultListConfig: {
																			loadingHeight: 70,
																			minWidth: 30,
																			maxHeight: 300,
																			shadow: 'sides'
																		},
																		margin : '0 0 0 20',
																		store: ['00', '01', '02', '03', '04', '05', '06', '07', '08', '09', '10', '11', '12', '13', '14', '15', '16', '17', '18', '19', '20', '21', '22', '23','24','25','26','27','28','29','30','31','32','33','34','35','36','37','38','39','40','41','42','43','44','45','46','47','48','49','50','51','52','53','54','55','56','57','58','59'],
																		displayField: 'displayField',
																		valueField: 'valueField',
																		queryMode: 'local',
																		fieldLabel: minLbl,
																		cls: 'dropdown24',
																	//	disabled: true,
																		hidden : this.hideMinutes,
																		dataArray: null,
																		listeners: {
																			'select': function (combo) {
																				formated_sdate = Ext.Date.dateFormat(Ext.getCmp("er_enddate").getValue(),mgrDateFormat);
																				var dateValue = formated_sdate + " " + Ext.getCmp("er_endhr").getValue() + ":" + combo.getValue() + ":00";
																				var param = "date=" + dateValue + "&method=getDateTime&isReverse=true&isFromReporter=true";
																				Ext.Ajax.request({
																					url: '/final/servlet/com.eg.EgTimeZoneConverterServlet',
																					params: param,
																					scope: this,
																					method: 'POST',
																					success: function (response) {
																						var responseText = response.responseText;
																						responseText = Ext.String.trim(responseText);
																						var dt = responseText.substring(0, responseText.lastIndexOf(" "));
																						var tim = responseText.substring(responseText.lastIndexOf(" ") + 1);
																					   if(!isTrend){
																						if (tim != null && (tim.indexOf(":") == tim.lastIndexOf(":"))) {
																						   Ext.getCmp("er_endmin").dataArray = '00';
																						} else if (tim != null && tim.length > 0 && tim.indexOf(":") > -1) {
																							Ext.getCmp("er_endmin").dataArray = tim.substring(tim.indexOf(":")+1,tim.lastIndexOf(":"));
																						}
																					   }
																					}
																				});
																			}
																		}
																	}]
															}
														
														]
											},
											]
								});
								var win = Ext.create('Ext.window.Window', {
									title: '<span style="font-weight: 500;text-transform: uppercase;" class="">'+heading+'</span>',
									ui:'newPopupWindow',
									header : {
										height: 40,
									},
									cls: 'maintenanceConfigWindow',
									width: 314,
									resizable : false,
									padding:0,
									margin:0,
									shadow:true,
									bodyPadding:0,
									scroll:false,
									autoScroll:true,
									modal: true,
									loadMask: true,
									ghost: false,
									title : instMainPlcyTitle,
									id: 'MaintenanceConfigWindow',
									//html:"<div id='"+divId+"'></div>",
									//id:'windowValue',
									//selectedValue:val,
									closeAction: "destroy",
									constrain: true,
									//iconCls:'iconClose2',
									closable:true,
									//unformatVal:val,	
									layout:{ type: 'vbox', align: 'stretch' },
									flex:1,
									items : mainpolArr,
										listeners : {

											show: function (f){
													if (this.modal) {
														var g = Ext.dom.Query.select(".x-mask");
														var e = Ext.fly(g[0]);
														e.addCls("windowModal");
													}
												},
												hide: function (f) {
													if (this.modal) {
														var g = Ext.dom.Query.select(".x-mask");
														var e = Ext.fly(g[0]);
														e.removeCls("windowModal");
													}
												},
											 afterrender: function (thisobj) {
												var startdateObj =Ext.getCmp('er_stdate');
												var enddateObj =Ext.getCmp('er_enddate');
												var startHourObj =Ext.getCmp('er_sthr');
												var endHourObj =Ext.getCmp('er_endhr');
												var startMinObj =Ext.getCmp('er_stmin');
												var endMinObj =Ext.getCmp('er_endmin');

												startdateObj.setValue(jsonData['selectedStartDate']);
												startdateObj.dataArray = jsonData['startDateInMgrDateFormat'];
												enddateObj.setValue(jsonData['selectedEndDate']);
												enddateObj.dataArray = jsonData['endDateInMgrDateFormat'];
												startHourObj.setValue(jsonData['selectedStartHour']);
												startHourObj.dataArray = jsonData['startHrInMgrDate'];
												endHourObj.setValue(jsonData['selectedEndHour']);
												endHourObj.dataArray = jsonData['endHourInMgrDate'];
												stmin = jsonData.startMinInMgrDate;
												enmin = jsonData.endMinInMgrDate;
												startMinObj.setValue(jsonData['selectedStartMin']);
												endMinObj.setValue(jsonData['selectedEndMin']);
												startMinObj.dataArray = jsonData['startMinInMgrDate'];
												endMinObj.dataArray = jsonData['endMinInMgrDate'];
												mgr_stmin = jsonData.startMinInMgrDate;
												mgr_enmin = jsonData.endMinInMgrDate;
											//	me.threadLinkWindow1(thisobj.unformatVal,thisobj.mtime,divId);
											}
									}
								}).show();
							}
					}
			});
		}
		catch (excp)
		{
			console.log("excp---->",excp);
		}
	},
	checkSpecialCharacter : function(policyname) {
		var splChar = "`~!@#$%^&*()+={}[]|\\:;\"\'<>,?/";
		for ( var i = 0; i < policyname.length; i++) {
			var check_char = splChar.indexOf(policyname.charAt(i))
			// Returns value 1 if the special character listed
			// in splChar is found
			if (check_char >= 0) {
				return true;
			}
		}
		return false;
	},
	showMaintenanceWindowForComp : function(hostNam,prtNo,sid,entityDispName)
	{
		var meLyrCtrl=this;
		var winParObj = window.parent;
		try
		{
			Ext.Ajax.request({
						url : '/final/servlet/com.eg.EgDashboardController',
						mathod : 'POST',
						params : 'from=loadInstantanceMaintenanceOptions',
						async: false,
						scope:this,
						success: function(response) 
						{
							var jsonText = response.responseText;
							if(!Ext.isEmpty(jsonText))
							{
								var jsonData=Ext.decode(jsonText);
								
								var mainpolArr=[];
								mainpolArr.push({
										xtype:'form',
										layout:'anchor',
										itemId : 'maintenanceConfigForm',
										name:'layoutConfig',
										bodyPadding:'18 20 20 20',
										autoScroll : true,
										defaults:{
												labelSeparator:'',
												labelAlign:'top',
												
											},
										buttonAlign: 'center',
										hideMinutes : true,
										selectedMgrStMin : '',
										marginTop: 0,
										padding: 0,
										selectedMgrEndMin : '',
										selectedStMinForDisplay : '',
										selectedEndminForDisplay : '',
										buttons : [
														{
															text:'<span style="font-size:12px;line-height:25px;width:83px;">'+addPolicyLbl+'</span>',
															id: 'addPolicyBtn',
															name: 'addPolicyBtn',
															cls: 'buttonNew',
															height: 25,
															padding: 0,
															margin: '0 0 0 0',
															handler : function(btnObj)
															{
																var policyname=Ext.getCmp('mainPolicyName').getValue();
																
																if (policyname == "" || policyname.length == 0) {
																	Ext.Msg.show({
																		title: instMainPlcyTitle,
																		msg: emptyPolicyName,
																		buttons: Ext.Msg.OK,
																		icon : 'iconExclamation'
																	});
																	return;
																}
																if (policyname.match(/[ ]/) != null) {
																	Ext.Msg.show({
																		title: instMainPlcyTitle,
																		msg: spaceMsg,
																		buttons: Ext.Msg.OK,
																		icon : 'iconExclamation'
																	});
																	return;
																}			
																if (meLyrCtrl.checkSpecialCharacter(policyname)) {
																//if (policyname.match(/[~!@#$%^&*()-+={}:<>?\|`,]/) != null) {
																	Ext.Msg.show({
																		title: instMainPlcyTitle,
																		msg: specialcharacterMsg,
																		buttons: Ext.Msg.OK,
																		icon : 'iconExclamation'
																	});
																	return;
																}
																var startDateVal = Ext.getCmp('er_stdate').dataArray;
																var endDateVal = Ext.getCmp('er_enddate').dataArray;
																var startHour = Ext.getCmp('er_sthr').getValue();
																var endHour = Ext.getCmp('er_endhr').getValue();
																
																var stDate = Ext.getCmp('er_stdate').getValue();
																var enDate = Ext.getCmp('er_enddate').getValue();
																stDate.setHours(Ext.getCmp('er_sthr').getValue());
																enDate.setHours(Ext.getCmp('er_endhr').getValue());
																var startMinObj = Ext.getCmp('er_stmin');
																var endMinObj = Ext.getCmp('er_endmin');
																var stmin=startMinObj.getValue();
																var endmin=endMinObj.getValue();
																stDate.setMinutes(stmin);
																enDate.setMinutes(endmin);
																var start_minValue = stmin;
																var end_MinValue = endmin;

																var fromValue = formatDate(stDate, mgrDisplayDateFormat);
																var ToValue = formatDate(enDate, mgrDisplayDateFormat);
																//Date validation
																var today = new Date();
																var currentDate = today.getMonth() + "/" + today.getDay() + "/" + today.getYear();
																
																if(new Date(fromValue) > new Date(ToValue))
																{
																	Ext.MessageBox.show({
																		title:instMainPlcyTitle,
																		msg: DateErrorMsg,
																		buttons: Ext.MessageBox.OK,
																		icon: Ext.MessageBox.WARNING
																	});
																	return false;
																}
																if(new Date(fromValue).valueOf() == new Date(ToValue).valueOf())
																{
																	if(startHour > endHour)
																	{
																		Ext.MessageBox.show({
																		title: instMainPlcyTitle,
																		msg: DateErrorMsg,
																		buttons: Ext.MessageBox.OK,
																		icon: Ext.MessageBox.WARNING
																		});
																		return false;
																	}
																}
																var timeNowDateObj = formatDate(today, mgrDisplayDateFormat);
																if(new Date(fromValue) < new Date(timeNowDateObj))
																{
																	Ext.MessageBox.show({
																		title: instMainPlcyTitle,
																		msg: timeErrorMsg,
																		buttons: Ext.MessageBox.OK,
																		icon: Ext.MessageBox.WARNING
																		});
																		return false;
																}
																if (isLimitedAdmin == 'true' && policyname.indexOf('|$|') == -1) //Limited admin
																{
																	internalPolicyName = policyname + '|$|' + userLoginID;
																}
																
																var maintenanceType=Ext.getCmp('maintenanceType').getValue();
																var instantMaintenanceConfigParams='from=saveQuickMaintenancePolicy&type=showPolicies&operation=create&combination='+encodeURIComponent(maintenanceType);

																if(!Ext.isEmpty(maintenanceType) && maintenanceType=='Component')
																{
																	var compNameForMain=hostNam+":"+prtNo;
																	if(!Ext.isEmpty(sid))
																	{
																		compNameForMain=compNameForMain+":"+sid;
																	}
																	instantMaintenanceConfigParams=instantMaintenanceConfigParams+'&comptype=Component Type&fassociate='+encodeURIComponent(compNameForMain);
																}
																else
																{
																	instantMaintenanceConfigParams=instantMaintenanceConfigParams+'&fassociate='+encodeURIComponent(hostNam);
																}
																//alert(startDateVal+" "+endDateVal);
																
																startDateVal = formatDate(new Date(getDateFromFormat(startDateVal, mgrDisplayDateFormat)), "MM/dd/yyyy");
																endDateVal = formatDate(new Date(getDateFromFormat(endDateVal, mgrDisplayDateFormat)), "MM/dd/yyyy");
																var policyEntries = startHour + ":" + start_minValue + "-" + endHour + ":" + end_MinValue + "!HASH!" + startDateVal + "|" + endDateVal;
																policyEntries=winParObj.filterEncode(policyEntries);
																instantMaintenanceConfigParams=instantMaintenanceConfigParams+'&policyName='+encodeURIComponent(policyname)+'&policyEntries='+encodeURIComponent(policyEntries)+"&decodePolicyEntries=yes";

																Ext.Ajax.request(
																{
																	url : '/final/servlet/com.eg.EgDashboardController',
																	method : 'POST',
																	params : instantMaintenanceConfigParams,
																	async: true,
																	scope:this,
																	success: function(response) 
																	{
																		if(response.status == 200 && !Ext.isEmpty(response))
																		{
																			var jsonText = response.responseText;
																			jsonText=Ext.String.trim(jsonText);
																			
																			if(jsonText != null && jsonText != 'null' && jsonText != 'undefined' && jsonText != undefined && (!Ext.isEmpty(jsonText)))
																			{
																				var chartData=Ext.decode(jsonText);
																				Ext.getCmp('MaintenanceConfigWindow1').close();
																				Ext.Msg.show({
																					title: instMainPlcyTitle,
																					msg: policyCreationMsg,
																					buttons:Ext.MessageBox.OK,
																					icon:Ext.MessageBox.INFO
																				});
																			}
																		}
																	}
																});
															}
														}
										],
										flex:1,
										items:[
											{
												xtype : 'container',
												flex : 1,
												layout : {
													type : 'hbox',
													align : 'stretch'
												},
												cls:'policyLabelBottomBorder1',
												padding: '0 0 15 0',
												margin: '0',
												items :[
													{
														xtype : 'label',
														width: 90,
														text : componentNameLbl,
														
													},
													{
														xtype : 'label',
														width: 180,
														html : entityDispName
													}
												]
											},
											{
												xtype:'textfield',
												id : 'mainPolicyName',
												name:'mainPolicyName',
												labelAlign:'top',
												cls: 'textbox24',
												width: '100%',
												flex:1,
												padding: 0,
												margin: '16 0 6 0',
												fieldLabel:mpolicyLbl
											},
											{
												 xtype: 'combo',
												 id: 'maintenanceType',
												 name: 'maintenanceType',
												 style: {
													'width': '100%'
												 },
												 padding: 0,
												 flex:1,
												layout : {
													type : 'vbox',
													align: 'stretch'
												 },
												 margin: '0 0 10 0',
												 cls: 'dropdown24 policy',
												 fieldLabel:applyMainForLbl,
												 //emptyText: applyMainForLbl,
												 store: Ext.create('Ext.data.Store', {
															fields: ['displayField', 'valueField'],
															data: [{'displayField' : 'Host','valueField' : 'Host'},{'displayField' : 'Component','valueField' : 'Component',}]
												 }),
												 editable: false,
												 displayField: 'displayField',
												 valueField: 'valueField',
												 queryMode: 'local',
												 value : 'Host'
											},
											{
												xtype: 'container',
												layout: {
													type:'vbox',
													align: 'stretch'
												},
												id: 'timeline_box',
												//hidden: true,
												//width : 314,
												defaults: {
													labelAlign: 'top',
													labelSeparator:''
												},
												margin:'0 0 0 0',
												padding:'0 0 0 0',
												//style : { 'border' : '2px solid red'},
												items: [{
															xtype: 'container',
															layout: {
																type:'hbox',
																align: 'stretch'
															},
															//width : 314,
															defaults: {
																labelAlign: 'top',
																labelSeparator:'',
															},				
															margin:'0 0 10 0',
															padding:'0 0 0 0',
															items : [{
																	xtype: 'datefield',
																	id: 'er_stdate',
																	name: 'er_stdate',
																	format: mgrDateFormat,
																	fieldLabel: fromLbl,
																	cls: 'datepickerBig',
																	labelAlign: 'top',
																	width : 132,
																	margin : '0 0 0 0',
																	disabled: false,
																	dataArray: null,
																	listeners:
																	{
																		'select': function(obj)
																		{
																			var stMinObj=Ext.getCmp('er_stmin');
																			var enMinObj=Ext.getCmp('er_endmin');
																			
																			var strtdt = Ext.getCmp("er_stdate").getValue();
																			var enddt = Ext.getCmp("er_enddate").getValue();
																			var strthour = Ext.getCmp("er_sthr").getValue();
																			var endhr = Ext.getCmp("er_endhr").getValue();
																			var strtmin = Ext.getCmp("er_stmin").getValue();
																			var endmin = Ext.getCmp("er_endmin").getValue();
																			var erModeObj = Ext.getCmp('er_mode');
																			var isHideMinutes=false;
																			/*if (window['appConstants']!=undefined && appConstants.appController!='reportermenudashboard.controller.ReporterController')
																		{					
																			this.up('form').erUtils.toggleGraphCombo(timeline,strtdt,enddt,strthour,endhr,erModeObj);
																		}*/
																			strtdt = Ext.Date.dateFormat(strtdt, 'm/d/Y');
																			enddt = Ext.Date.dateFormat(enddt, 'm/d/Y');
																			
																			var no_params = "&P0=[Any]&P1=[" + strtdt + "]&P2=[" + enddt + "]&P3=[" + strthour + "]&P4=[" + endhr + "]&P5=[" + strtmin + "]&P6=[" + endmin + "]&P7=[" + dateFormatForTimeline + "]";
																			
																			no_params += "&F=getTime";
																			if(!isHideMinutes)
																			{
																				no_params +="&P8=[true]";
																			}
																			
																			var param = "C=id" + no_params;
																			Ext.Ajax.request(
																			{
																				url: '/final/servlet/com.eg.ErRemoteScriptingServlet',
																				params: param,
																				scope: this,
																				method: 'POST',
																				success: function(response)
																				{
																					var jsontext = response.responseText;
																					var jsonData = Ext.decode(jsontext);
																					if (!Ext.isEmpty(jsonData))
																					{

																						var timedata = jsonData.timeline;

																						Ext.getCmp("er_stdate").dataArray = timedata[0];
																						Ext.getCmp("er_enddate").setValue(timedata[7]);
																						Ext.getCmp("er_stdate").setValue(timedata[6]);
																						Ext.getCmp("er_enddate").dataArray = timedata[1];
																						if (!isTrend)
																						{
																							Ext.getCmp("er_sthr").setValue(timedata[8]);
																							Ext.getCmp("er_sthr").dataArray = timedata[2];
																							Ext.getCmp("er_endhr").setValue(timedata[9]);
																							Ext.getCmp("er_endhr").dataArray = timedata[3];
																							Ext.getCmp("er_stmin").setValue(timedata[4]);
																							Ext.getCmp("er_stmin").dataArray = timedata[4];
																							Ext.getCmp("er_endmin").setValue(timedata[5]);
																							Ext.getCmp("er_endmin").dataArray = timedata[5];
																							/*stmin = timedata[10];
																							enmin = timedata[11];
																							mgr_stmin = timedata[4];
																							mgr_enmin = timedata[5];*/

																							if(!isHideMinutes)
																							{
																								var selectedStMinForDisplay=this.up('form').selectedStMinForDisplay;
																								var selectedEndminForDisplay=this.up('form').selectedEndminForDisplay;
																								
																								if((selectedStMinForDisplay!=null && selectedStMinForDisplay!='') && (selectedEndminForDisplay!=null && selectedEndminForDisplay!=''))
																								{
																									var selectedMgrStMin=this.up('form').selectedMgrStMin;
																									var selectedMgrEndMin=this.up('form').selectedMgrEndMin;
																									stMinObj.setValue(selectedStMinForDisplay);
																									stMinObj.dataArray = selectedMgrStMin;
																									enMinObj.setValue(selectedEndminForDisplay);
																									enMinObj.dataArray = selectedMgrEndMin;
																									this.up('form').selectedStMinForDisplay='';
																									this.up('form').selectedMgrStMin='';
																									this.up('form').selectedEndminForDisplay='';
																									this.up('form').selectedMgrEndMin='';
																								}
																								else
																								{
																									stMinObj.setValue(timedata[4]);
																									stMinObj.dataArray = timedata[4];
																									enMinObj.setValue(timedata[5]);
																									enMinObj.dataArray = timedata[5];
																								}
																							}
																						}
																					}
																				}
																			});
																		}
																	}
																},
																{
																	xtype: 'scrollcombo',
																	width: 54,
																	id: 'er_sthr',
																	name: 'er_sthr',
																	defaultListConfig:
																	{
																		loadingHeight: 70,
																		minWidth: 30,
																		maxHeight: 300,
																		shadow: 'sides'
																	},
																	margin : '0 0 0 10',
																	store: ['00', '01', '02', '03', '04', '05', '06', '07', '08', '09', '10', '11', '12', '13', '14', '15', '16', '17', '18', '19', '20', '21', '22', '23'],
																	displayField: 'displayField',
																	valueField: 'valueField',
																	queryMode: 'local',
																	fieldLabel: hrLbl,
																	cls: 'dropdown24',
																//	disabled: true,
																	dataArray: null,
																	listeners:
																	{
																		'select': function(combo)
																		{
																			formated_sdate = Ext.Date.dateFormat(Ext.getCmp("er_stdate").getValue(), mgrDateFormat);
																			if (stmin == null || stmin == "undefined" || stmin == '')
																				stmin = "00";
																			var dateValue = formated_sdate + " " + combo.getValue() + ":" + stmin + ":00";

																			var param = "date=" + dateValue + "&method=getDateTime&isReverse=true&isFromReporter=true";
																			Ext.Ajax.request(
																			{
																				url: '/final/servlet/com.eg.EgTimeZoneConverterServlet',
																				params: param,
																				scope: this,
																				method: 'POST',
																				success: function(response)
																				{


																					var responseText = response.responseText;
																					responseText = Ext.String.trim(responseText);
																					var dt = responseText.substring(0, responseText.lastIndexOf(" "));
																					var tim = responseText.substring(responseText.lastIndexOf(" ") + 1);

																					if (!isTrend)
																					{
																						if (tim != null && (tim.indexOf(":") == tim.lastIndexOf(":")))
																						{
																							Ext.getCmp("er_sthr").dataArray = tim.substring(0, tim.indexOf(":"));
																						}
																						else if (tim != null && tim.length > 0 && tim.indexOf(":") > -1)
																						{
																							Ext.getCmp("er_sthr").dataArray = tim.substring(0, tim.indexOf(":"));

																						}
																					}
																				}
																			});
																		}
																	}
																},
																{
																	xtype: 'scrollcombo',
																	width: 54,
																	id: 'er_stmin',
																	name: 'er_stmin',
																	defaultListConfig: {
																		loadingHeight: 70,
																		minWidth: 30,
																		maxHeight: 300,
																		shadow: 'sides'
																	},
																	margin : '0 0 0 20',
																	store: ['00', '01', '02', '03', '04', '05', '06', '07', '08', '09', '10', '11', '12', '13', '14', '15', '16', '17', '18', '19', '20', '21', '22', '23','24','25','26','27','28','29','30','31','32','33','34','35','36','37','38','39','40','41','42','43','44','45','46','47','48','49','50','51','52','53','54','55','56','57','58','59'],
																	displayField: 'displayField',
																	valueField: 'valueField',
																	queryMode: 'local',
																	fieldLabel: minLbl,
																	cls: 'dropdown24',
																//	disabled: true,
																	hidden : this.hideMinutes,
																	dataArray: null,
																	listeners: {
																		'select': function (combo) {
																			formated_sdate = Ext.Date.dateFormat(Ext.getCmp("er_stdate").getValue(),mgrDateFormat);
																			var dateValue = formated_sdate + " " + Ext.getCmp("er_sthr").getValue() + ":" + combo.getValue() + ":00";
																			var param = "date=" + dateValue + "&method=getDateTime&isReverse=true&isFromReporter=true";
																			Ext.Ajax.request({
																				url: '/final/servlet/com.eg.EgTimeZoneConverterServlet',
																				params: param,
																				scope: this,
																				method: 'POST',
																				success: function (response) {
																					var responseText = response.responseText;
																					responseText = Ext.String.trim(responseText);
																					var dt = responseText.substring(0, responseText.lastIndexOf(" "));
																					var tim = responseText.substring(responseText.lastIndexOf(" ") + 1);
																				   if(!isTrend){
																					if (tim != null && (tim.indexOf(":") == tim.lastIndexOf(":"))) {
																					   Ext.getCmp("er_stmin").dataArray = '00';
																					} else if (tim != null && tim.length > 0 && tim.indexOf(":") > -1) {
																						Ext.getCmp("er_stmin").dataArray = tim.substring(tim.indexOf(":")+1,tim.lastIndexOf(":"));
																					}
																				   }
																				}
																			});
																		}
																	}
																}]
														},
														{
															xtype: 'container',
															layout: {
																type:'hbox',
																align: 'stretch'
															},
															flex  : 1,
															defaults: {
																labelAlign: 'top',
																labelSeparator:'',
															},				
															margin:'0 0 0 0',
															padding:'0 0 0 0',
															items : [{
																		xtype: 'datefield',
																		id: 'er_enddate',
																		name: 'er_enddate',
																		format: mgrDateFormat,
																		fieldLabel: Tolbl,
																		cls: 'datepickerBig',
																		width : 132,
																		margin : '0 0 0 0',
																		disabled: false,
																		dataArray: null,
																		listeners:
																		{
																			'select': function(obj)
																			{
																				var stMinObj=Ext.getCmp('er_stmin');
																				var enMinObj=Ext.getCmp('er_endmin');
																				
																				var strtdt = Ext.getCmp("er_stdate").getValue();
																				var enddt = Ext.getCmp("er_enddate").getValue();
																				var strthour = Ext.getCmp("er_sthr").getValue();
																				var endhr = Ext.getCmp("er_endhr").getValue();
																				var strtmin = Ext.getCmp("er_stmin").getValue();
																				var endmin = Ext.getCmp("er_endmin").getValue();
																				var erModeObj = Ext.getCmp('er_mode');
																				var isHideMinutes=false;
																				/*if (window['appConstants']!=undefined && appConstants.appController!='reportermenudashboard.controller.ReporterController')
																			{					
																				this.up('form').erUtils.toggleGraphCombo(timeline,strtdt,enddt,strthour,endhr,erModeObj);
																			}*/
																				
																				strtdt = Ext.Date.dateFormat(strtdt, 'm/d/Y');
																				enddt = Ext.Date.dateFormat(enddt, 'm/d/Y');
																				
																				var no_params = "&P0=[Any]&P1=[" + strtdt + "]&P2=[" + enddt + "]&P3=[" + strthour + "]&P4=[" + endhr + "]&P5=[" + strtmin + "]&P6=[" + endmin + "]&P7=[" + dateFormatForTimeline + "]";
																				
																				no_params += "&F=getTime";
																				if(!isHideMinutes)
																				{
																					no_params +="&P8=[true]";
																				}
																				
																				var param = "C=id" + no_params;
																				Ext.Ajax.request(
																				{
																					url: '/final/servlet/com.eg.ErRemoteScriptingServlet',
																					params: param,
																					scope: this,
																					method: 'POST',
																					success: function(response)
																					{
																						var jsontext = response.responseText;
																						var jsonData = Ext.decode(jsontext);
																						if (!Ext.isEmpty(jsonData))
																						{
																							var timedata = jsonData.timeline;
																							Ext.getCmp("er_stdate").setValue(timedata[6]);
																							Ext.getCmp("er_stdate").dataArray = timedata[0];
																							Ext.getCmp("er_enddate").setValue(timedata[7]);
																							Ext.getCmp("er_enddate").dataArray = timedata[1];
																							if (!isTrend)
																							{

																								Ext.getCmp("er_sthr").setValue(timedata[8]);
																								Ext.getCmp("er_sthr").dataArray = timedata[2];
																								Ext.getCmp("er_endhr").setValue(timedata[9]);
																								Ext.getCmp("er_endhr").dataArray = timedata[3];
																								Ext.getCmp("er_stmin").setValue(timedata[4]);
																								Ext.getCmp("er_stmin").dataArray = timedata[4];
																								Ext.getCmp("er_endmin").setValue(timedata[5]);
																								Ext.getCmp("er_endmin").dataArray = timedata[5];
																								/*stmin = timedata[10];							
																								enmin = timedata[11];
																								mgr_stmin = timedata[4];
																								mgr_enmin = timedata[5];*/

																								if(!isHideMinutes)
																								{
																									var selectedStMinForDisplay=this.up('form').selectedStMinForDisplay;
																									var selectedEndminForDisplay=this.up('form').selectedEndminForDisplay;
																									
																									if((selectedStMinForDisplay!=null && selectedStMinForDisplay!='') && (selectedEndminForDisplay!=null && selectedEndminForDisplay!=''))
																									{
																										var selectedMgrStMin=this.up('form').selectedMgrStMin;
																										var selectedMgrEndMin=this.up('form').selectedMgrEndMin;
																										stMinObj.setValue(selectedStMinForDisplay);
																										stMinObj.dataArray = selectedMgrStMin;
																										enMinObj.setValue(selectedEndminForDisplay);
																										enMinObj.dataArray = selectedMgrEndMin;
																										this.up('form').selectedStMinForDisplay='';
																										this.up('form').selectedMgrStMin='';
																										this.up('form').selectedEndminForDisplay='';
																										this.up('form').selectedMgrEndMin='';
																									}
																									else
																									{
																										stMinObj.setValue(timedata[4]);
																										stMinObj.dataArray = timedata[4];
																										enMinObj.setValue(timedata[5]);
																										enMinObj.dataArray = timedata[5];
																									}
																								}
																							}
																						}
																					}
																				});
																			}
																		}
																	},
																	{
																		xtype: 'scrollcombo',
																		width: 54,
																		defaultListConfig:
																		{
																			loadingHeight: 70,
																			minWidth: 30,
																			maxHeight: 300,
																			shadow: 'sides'
																		},
																		fieldLabel: hrLbl,
																		cls: 'dropdown24',
																		id: 'er_endhr',
																		name: 'er_endhr',
																		margin : '0 0 0 10',
																		store: ['00', '01', '02', '03', '04', '05', '06', '07', '08', '09', '10', '11', '12', '13', '14', '15', '16', '17', '18', '19', '20', '21', '22', '23'],
																		displayField: 'displayField',
																		valueField: 'valueField',
																		queryMode: 'local',
																	//	disabled: true,
																		dataArray: null,
																		listeners:
																		{
																			'select': function(combo)
																			{
																				formated_sdate = Ext.Date.dateFormat(Ext.getCmp("er_enddate").getValue(), mgrDateFormat);
																				if (enmin == null || enmin == "undefined" || enmin == '')
																					enmin = "00";
																				var dateValue = formated_sdate + " " + combo.getValue() + ":" + enmin + ":00";
																				var param = "date=" + dateValue + "&method=getDateTime&isReverse=true&isFromReporter=true";
																				Ext.Ajax.request(
																				{
																					url: '/final/servlet/com.eg.EgTimeZoneConverterServlet',
																					params: param,
																					scope: this,
																					method: 'POST',
																					success: function(response)
																					{
																						var responseText = response.responseText;
																						responseText = Ext.String.trim(responseText);
																						var dt = responseText.substring(0, responseText.lastIndexOf(" "));
																						var tim = responseText.substring(responseText.lastIndexOf(" ") + 1);
																						if (!isTrend)
																						{
																							if (tim != null && (tim.indexOf(":") == tim.lastIndexOf(":")))
																							{
																								Ext.getCmp("er_endhr").dataArray = tim.substring(0, tim.indexOf(":"));
																							}
																							else if (tim != null && tim.length > 0 && tim.indexOf(":") > -1)
																							{
																								Ext.getCmp("er_endhr").dataArray = tim.substring(0, tim.indexOf(":"));
																							}
																						}
																					}
																				});
																			}
																		}
																	},
																	{
																		xtype: 'scrollcombo',
																		width: 54,
																		id: 'er_endmin',
																		name: 'er_endmin',
																		defaultListConfig: {
																			loadingHeight: 70,
																			minWidth: 30,
																			maxHeight: 300,
																			shadow: 'sides'
																		},
																		margin : '0 0 0 20',
																		store: ['00', '01', '02', '03', '04', '05', '06', '07', '08', '09', '10', '11', '12', '13', '14', '15', '16', '17', '18', '19', '20', '21', '22', '23','24','25','26','27','28','29','30','31','32','33','34','35','36','37','38','39','40','41','42','43','44','45','46','47','48','49','50','51','52','53','54','55','56','57','58','59'],
																		displayField: 'displayField',
																		valueField: 'valueField',
																		queryMode: 'local',
																		fieldLabel: minLbl,
																		cls: 'dropdown24',
																	//	disabled: true,
																		hidden : this.hideMinutes,
																		dataArray: null,
																		listeners: {
																			'select': function (combo) {
																				formated_sdate = Ext.Date.dateFormat(Ext.getCmp("er_enddate").getValue(),mgrDateFormat);
																				var dateValue = formated_sdate + " " + Ext.getCmp("er_endhr").getValue() + ":" + combo.getValue() + ":00";
																				var param = "date=" + dateValue + "&method=getDateTime&isReverse=true&isFromReporter=true";
																				Ext.Ajax.request({
																					url: '/final/servlet/com.eg.EgTimeZoneConverterServlet',
																					params: param,
																					scope: this,
																					method: 'POST',
																					success: function (response) {
																						var responseText = response.responseText;
																						responseText = Ext.String.trim(responseText);
																						var dt = responseText.substring(0, responseText.lastIndexOf(" "));
																						var tim = responseText.substring(responseText.lastIndexOf(" ") + 1);
																					   if(!isTrend){
																						if (tim != null && (tim.indexOf(":") == tim.lastIndexOf(":"))) {
																						   Ext.getCmp("er_endmin").dataArray = '00';
																						} else if (tim != null && tim.length > 0 && tim.indexOf(":") > -1) {
																							Ext.getCmp("er_endmin").dataArray = tim.substring(tim.indexOf(":")+1,tim.lastIndexOf(":"));
																						}
																					   }
																					}
																				});
																			}
																		}
																	}]
															}
														
														]
											}
											]
								});
								var win = Ext.create('Ext.window.Window', {
									title: '<span style="font-weight: 500; " class="">'+heading+'</span>',
									shadow:true,
									ui:'newPopupWindow',
									header : {
										height: 40,
									},
									cls: 'maintenanceConfigWindow',
									resizable : false,
									width: 314,
									bodyPadding:0,
									scroll:false,
									autoScroll:true,
									modal: true,
									id : 'MaintenanceConfigWindow1',
									padding: 0,
									margin:0,
									ghost: false,
									title : instMainPlcyTitle,
									//html:"<div id='"+divId+"'></div>",
									//id:'windowValue',
									//selectedValue:val,
									closeAction: "destroy",
									constrain: true,
									//iconCls:'iconClose2',
									closable:true,
									//unformatVal:val,	
									layout:{ type: 'vbox', align: 'stretch' },
										//align:'stretch'
										//pack: 'center'
									flex:1,
									items : mainpolArr,
										listeners : {
											show: function (f){
													if (this.modal) {
														var g = Ext.dom.Query.select(".x-mask");
														var e = Ext.fly(g[0]);
														e.addCls("windowModal");
													}
												},
												hide: function (f) {
													if (this.modal) {
														var g = Ext.dom.Query.select(".x-mask");
														var e = Ext.fly(g[0]);
														e.removeCls("windowModal");
													}
												},
											 afterrender: function (thisobj) {
												var startdateObj =Ext.getCmp('er_stdate');
												var enddateObj =Ext.getCmp('er_enddate');
												var startHourObj =Ext.getCmp('er_sthr');
												var endHourObj =Ext.getCmp('er_endhr');
												var startMinObj =Ext.getCmp('er_stmin');
												var endMinObj =Ext.getCmp('er_endmin');

												startdateObj.setValue(jsonData['selectedStartDate']);
												startdateObj.dataArray = jsonData['startDateInMgrDateFormat'];
												enddateObj.setValue(jsonData['selectedEndDate']);
												enddateObj.dataArray = jsonData['endDateInMgrDateFormat'];
												startHourObj.setValue(jsonData['selectedStartHour']);
												startHourObj.dataArray = jsonData['startHrInMgrDate'];
												endHourObj.setValue(jsonData['selectedEndHour']);
												endHourObj.dataArray = jsonData['endHourInMgrDate'];
												stmin = jsonData.startMinInMgrDate;
												enmin = jsonData.endMinInMgrDate;
												startMinObj.setValue(jsonData['selectedStartMin']);
												endMinObj.setValue(jsonData['selectedEndMin']);
												startMinObj.dataArray = jsonData['startMinInMgrDate'];
												endMinObj.dataArray = jsonData['endMinInMgrDate'];
												mgr_stmin = jsonData.startMinInMgrDate;
												mgr_enmin = jsonData.endMinInMgrDate;
											//	me.threadLinkWindow1(thisobj.unformatVal,thisobj.mtime,divId);
											}
									}
								}).show();
							}
					}
			});
		}
		catch (excp)
		{
			console.log("excp---->",excp);
		}
	}
});