var netflowMask;
var interfaceSelectedView = null;
var showVal = null;
var globalTimeline = null;
var intObj;
Ext.define('componentDashboard.controller.NetflowController', {
	extend: 'Ext.app.Controller',
	requires: [
		'componentDashboard.view.netflow.NetflowMainPanel',
		'Ext.ux.CheckCombo',
		'utilities.GenericPieChartSlider',
		'utilities.TimeLine'
	],
	refs: [{
		ref: 'netflowmainpanel',
		selector: 'netflowmainpanel'
	}],
	init: function() {
		intObj = this;
		this.control({
			'netflowmainpanel': {
				'beforerender': this.netflowmainpanelBeforeRender,
				'afterrender': this.netflowmainpanelRender,
				'tabchange': this.netflowmainpanelTabChange,
			},
			'netflowmainpanel trigger[name="gridSearch"]':
			{
				'change': this.textFieldSearch
			}
		})
	},
	textFieldSearch: function(){
		
		var gridsearch = Ext.getCmp('gridSearch').getValue();
		
		if (gridsearch == "" || gridsearch.length == 0)
		{
			Ext.get('MyTrigger_0').setStyle('display','none');
			Ext.get('MyTrigger_1').setStyle('display','block');
		}
		else
		{
			Ext.get('MyTrigger_1').setStyle('display','none');
			Ext.get('MyTrigger_0').setStyle('display','block');
		}
		
		var itemSelectorObj = Ext.getCmp('gridDisplay');
		if (Ext.String.trim(gridsearch).length > 0 && (Ext.String.trim(gridsearch) != '' || Ext.String.trim(gridsearch) != null)) {
			var regex = RegExp(gridsearch, 'i');
			var elementsItems = itemSelectorObj.getStore();
			elementsItems.clearFilter(true);								
			elementsItems.filter(new Ext.util.Filter({
				caseSensitive: true,
				filterFn: function (object) {
					var items=0;
					var match = false;
					Ext.Object.each(object.data, function (property, value) {										
						match = match || regex.test(String(value));
						items++;
					});
					return match;
				}
			}));
		} else {
			itemSelectorObj.getStore().clearFilter();
		}
	},
	netflowmainpanelTabChange: function(tabPanel, newCard, oldCard, eOpts) {
		
		var me = this;
		if (oldCard != null && oldCard != undefined &&  oldCard != 'undefined')
		{
			oldCard.removeAll();
		}
		if (newCard != null && newCard != undefined && newCard != 'undefined')
		{
			newCard.removeAll();
		}
		newCard.add({
			items: [me.loadTabItems(newCard)]
		});
	},	
	setValueWithOptionInList : function(fieldName, list, selectedTimeline)
	{	
		if ( !Ext.isEmpty( list) && list!=null && list!=undefined)
		{
			Ext.getCmp(fieldName).getStore().loadRawData(list);
				
			Ext.getCmp(fieldName).suspendEvents(false);
			if( !Ext.isEmpty(selectedTimeline) )
			{
				if(fieldName == "er_timeline"){
					var timeline = selectedTimeline[0];
					if(timeline == "Any" || timeline == "any"){
						Ext.getCmp(fieldName).setValue(timeline);
						Ext.getCmp("er_stdate").setValue(selectedTimeline[1].anyStartDate);
						Ext.getCmp("er_sthr").setValue(selectedTimeline[1].anyStartHr);
						Ext.getCmp("er_stmin").setValue(selectedTimeline[1].anyStartMin);
						Ext.getCmp("er_enddate").setValue(selectedTimeline[1].anyEndDate);
						Ext.getCmp("er_endhr").setValue(selectedTimeline[1].anyEndHr);
						Ext.getCmp("er_endmin").setValue(selectedTimeline[1].anyEndMin);
					}
					else {
						Ext.getCmp(fieldName).setValue(timeline);
					}
				}
				else {
					Ext.getCmp(fieldName).setRawValue(selectedTimeline);
				}
			}
			else
			{
				Ext.getCmp(fieldName).setValue(list[0].valueField);
			}
			Ext.getCmp(fieldName).resumeEvents();
		}
	},
	addNetflowTabtoolbar:function(newCard){
		var me = this;
		if (Ext.isEmpty(Ext.getCmp('netflowInnerTabsToolbarId')))
		{
			this.getNetflowmainpanel().getTabBar().add([{
				xtype:'toolbar',
				flex:1,
				align:'right',
				id:'netflowInnerTabsToolbarId',
				layout:{
					type:'hbox',
					pack:'right',
				},
				defaults:{
					margin:'0 0 0 20',
					labelAlign:'left',
					labelSeparator:'',
				},
				items:['->',{
						xtype:"container",
						id:"timelineTitle",
						margin:"0 20 1 0",
						html:'<div class="x-form-item-label" style="float:right;font-weight:normal;">'+newCard.timelineTitle+'</div>',
						
					},
					{
					xtype: 'toolbar',
					width:27,
					height:21,
					dock: 'right',
					cls:'iconBg',
					id:'settingsBtn',
					name:'settingsBtn',
					margin:0,
					items:[{
						xtype:'button',
						iconCls:'iconSettings',
						tooltip:'<b>'+settingsLbl+'</b>',
						style:{
							background:'none',border:'0px'
						},
						handler:function(e){
							intObj.showConfigDropdown(newCard);
							if(!Ext.isEmpty(Ext.get('configMod_summary')))
							{
								Ext.get('configMod_summary').animate({to: {'top': '84px'},listeners:{ 
									afteranimate:function(){  
										Ext.get('configMod_summary').setStyle('left', '');
										Ext.getCmp('settingsBtn').setDisabled(true);
								}}}).show();
							}

						}
					}],
				}]
			}]);
		}
	},
	overviewTimelineSelect: function(timeline)
	{
		var me = this;
		globalTimeline=timeline;
		localStorage.setItem("timelineLastSelectedView",globalTimeline);
		var newCard = this.getNetflowmainpanel().getActiveTab();
		var lineChartURL = newCard.data['AREACHART_URL'];
		if(!Ext.isEmpty(timeline))
		{
			if(netflowLastLoadedURL!=null && netflowLastLoadedURL.indexOf("&selectedTimeline=")>0)
			{
				netflowLastLoadedURL = netflowLastLoadedURL.replace(/(selectedTimeline=)[^\&]+/, '$1' + encodeURIComponent(timeline));
			}
			else
			{
				netflowLastLoadedURL=netflowLastLoadedURL+'&selectedTimeline='+encodeURIComponent(timeline);
			}
		}
		newCard.removeAll();
		var queryParams='';
		var tmpURL = '';
		if(netflowLastLoadedURL!=null && netflowLastLoadedURL.indexOf("?")>-1)
		{
			tmpURL=netflowLastLoadedURL.substr(0,netflowLastLoadedURL.indexOf("?"));
			queryParams=netflowLastLoadedURL.substr(netflowLastLoadedURL.indexOf("?")+1);
		}
		Ext.Ajax.request({
			url:tmpURL,
			params:queryParams,
			method: 'POST',
			success: function(response) {

				if (response.status == 200 && !Ext.isEmpty(response.responseText)) {

					var jsonText = response.responseText;	
					var jsonData = Ext.decode(jsonText);
					lineChartURL = jsonData['AREACHART_URL'];
					newCard.data['AREACHART_URL']=lineChartURL;
					newCard.selectedTimeline=timeline;
					newCard.add({
						items: [me.loadTabItems(newCard)]
					});
					if(!Ext.isEmpty(netflowMask))
					{
						Ext.destroy(netflowMask);
						delete netflowMask;
					}
				}
			}
		});
		
	},
	interfaceComboLoad: function(obj)
	{
		var me = this;
		var comboVal = Ext.getCmp('interfaceCombo').getValue();
		var timelineVal = Ext.getCmp('protocolsTimelineCombo').getValue();		
		var protocolURL = '/final/monitor/EgNetflowDashHelperJSON.jsp?tab=Network&hostName='+encodeURIComponent(requestParams.hostName)+'&compType='+encodeURIComponent(componentType)+'&ciscoSelectedType=Protocols&screenWidth=1012&screenHeight=570&subsystem=Protocols&blockType=Protocols';		
		if(protocolURL.indexOf("&selectedInterface")>0)
		{
			protocolURL = protocolURL.replace(/(selectedInterface=)[^\&]+/, '$1' + encodeURIComponent(comboVal));
		}
		else
		{
			protocolURL += '&selectedInterface='+encodeURIComponent(comboVal);
		}
		if(protocolURL.indexOf("&protocolTimeline")>0)
		{
			protocolURL = protocolURL.replace(/(protocolTimeline=)[^\&]+/, '$1' + encodeURIComponent(timelineVal));	
		}
		else
		{
			protocolURL += '&protocolTimeline='+encodeURIComponent(timelineVal);
		}	
		netflowLastLoadedURL = protocolURL;
		var newCard = this.getNetflowmainpanel().getActiveTab();
		newCard.removeAll();
		newCard.DataURL=netflowLastLoadedURL;
		newCard.add({
			items: [me.loadTabItems(newCard)]
		});
	},
	selectFlowInterfaces: function(obj)
	{	
		var me = this;
		var getVal = obj.getValue();
		interfaceSelectedView = getVal;
		localStorage.setItem("interfaceLastSelectedView",interfaceSelectedView);
	/*	getVal = getVal.replace(",",", ");
		var getValList = getVal.split(",");
		var valueList = getVal.split(",").length;*/
		if(getVal!=null && !Ext.isEmpty(getVal) && getVal!=undefined)
		{
			if(netflowLastLoadedURL!=null && netflowLastLoadedURL.indexOf("interfaceToView")>0)
			{
				netflowLastLoadedURL = netflowLastLoadedURL.replace(/(interfaceToView=)[^\&]+/, '$1' + encodeURIComponent(getVal));
			}
			else
			{
				netflowLastLoadedURL = netflowLastLoadedURL+"&interfaceToView="+encodeURIComponent(getVal);
			}

			if(netflowLastLoadedURL!=null && netflowLastLoadedURL.indexOf("infosToArea")>0)
			{
				netflowLastLoadedURL = netflowLastLoadedURL.replace(/(infosToArea=)[^\&]+/, '$1' + getVal);
			}
			else
			{
				netflowLastLoadedURL = netflowLastLoadedURL+"&infosToArea="+encodeURIComponent(getVal);
			}

			if(netflowLastLoadedURL!=null && netflowLastLoadedURL.indexOf("interfaceSelection")>0)
			{
				netflowLastLoadedURL = netflowLastLoadedURL.replace(/(interfaceSelection=)[^\&]+/, '$1' + 'true');
			}
			else
			{
				netflowLastLoadedURL = netflowLastLoadedURL+"&interfaceSelection=true";
			}
		}
	},
	timelineSelect: function(timelineVal)
	{
		var me = this;
		globalTimeline=timelineVal;
		localStorage.setItem("timelineLastSelectedView",globalTimeline);
		if(netflowLastLoadedURL.indexOf("timeline") > -1)
		{
			netflowLastLoadedURL = netflowLastLoadedURL.replace(/(timeline=)[^\&]+/, '$1' + encodeURIComponent(timelineVal));
		}
		else
		{
			netflowLastLoadedURL += '&timeline='+encodeURIComponent(timelineVal);
		}
		var newCard = this.getNetflowmainpanel().getActiveTab();
		newCard.removeAll();
		newCard.DataURL=netflowLastLoadedURL;
		newCard.add({
			items: [me.loadTabItems(newCard)]
		});
		if(!Ext.isEmpty(netflowMask))
		{
			Ext.destroy(netflowMask);
			delete netflowMask;
		}
	},
	showSelect: function(obj)
	{
		showVal = obj.getValue();
		localStorage.setItem("showLastSelectedView",showVal);
		if(netflowLastLoadedURL.indexOf("show") > -1)
		{
			netflowLastLoadedURL = netflowLastLoadedURL.replace(/(show=)[^\&]+/, '$1' + encodeURIComponent(showVal));
		}
		else
		{
			
			netflowLastLoadedURL += '&show='+encodeURIComponent(showVal);
		}
	},
	eventsPerPageSelect: function(obj)
	{
		var eventsPerPageVal = obj.getValue();
		if(netflowLastLoadedURL.indexOf("eventsPerPage") > -1)
		{
			netflowLastLoadedURL = netflowLastLoadedURL.replace(/(eventsPerPage=)[^\&]+/, '$1' + eventsPerPageVal);
		}
		else
		{
			netflowLastLoadedURL += '&eventsPerPage='+eventsPerPageVal;
		}
	},
	loadTabItems: function(newCard) {
		var activeTab = newCard.getId();
		localStorage.setItem("netflowactivetab",newCard.getId());
		var panelItems = {};
		var me = this;
		if (!Ext.isEmpty(Ext.getCmp('netflowInnerTabsToolbarId')))
		{
			Ext.destroy(Ext.getCmp('netflowInnerTabsToolbarId'))
		}
		if (!Ext.isEmpty(Ext.getCmp('netflowInnerTabsToolbarId1')))
		{
			Ext.destroy(Ext.getCmp('netflowInnerTabsToolbarId1'))
		}
		if (!Ext.isEmpty(Ext.getCmp('configMod_summary')))
		{
			Ext.getCmp('configMod_summary').destroy();
		}
		if (!Ext.isEmpty(Ext.getCmp('gridDisplay')))
		{
			Ext.destroy(Ext.getCmp('gridDisplay'))
		}
		if (activeTab == "overview") 
		{
			netflowLastLoadedURL = "/final/monitor/EgNetflowDashboardJSON.jsp?tab=Network&hostName="+encodeURIComponent(requestParams.hostName)+"&compType="+encodeURIComponent(componentType)+"&ciscoSelectedType=overview&screenWidth=1012&screenHeight=570";
			var timelineselected = newCard.selectedTimeline;
			var timelinetSelectedView = localStorage.getItem("timelineLastSelectedView");
			if(timelinetSelectedView!=null && !Ext.isEmpty(timelinetSelectedView))
			{
				globalTimeline = timelinetSelectedView;
				timelineselected = timelinetSelectedView;
			} 		
			var overviewDataObj = newCard.data;
			dialChartData = overviewDataObj['FUSION-CHART']['dialChartValues'];
			var dailChart = [];
			if (!Ext.isEmpty(dialChartData)) 
			{
				for (var j = 0; j < dialChartData.length; j++) {
					dailChart.push(
					{
						xtype: 'container',
						layout: {
							type: 'vbox',
							align: 'stretch',
							pack: 'start'
						},
						margin: '10 10 0 10',
						items: [{
							xtype: 'container',
							height: 120,
							width: 200,
							chartData: dialChartData[j]['dialXMLData'],
							listeners: {
								boxready: function(chartDivId) {
									getHighChartsGuageforNetflow(chartDivId.id, chartDivId.chartData, "Netflow");
								}
							}
						},{
							xtype: 'container',
							margin:10,
							html: '<div style="text-align:center;" >' + dialChartData[j].dial_measureMapping +' ('+dialChartData[j].unit+')</div>'
						}]
					});
				}
			}
			else
			{
				dailChart.push(
				{
					xtype: 'container',
					margin: 10,
					height: 640,
					flex:1,
					layout:{
						type:'fit',
					},
					html:'<table width="100%" height="100%"><tr><td valign="middle" align="center"><div class="iconInformation" ></div><div >'+noMeasure+'!</div></td></tr></table>'
				});
			}
			var maxGraphLineNo;
			var lineChartArr = [];
			var lineChartURL = overviewDataObj['AREACHART_URL'];
			
			if(lineChartURL!=null && lineChartURL.indexOf("&selectedDate=")>0)
			{
				lineChartURL = lineChartURL.replace(/(selectedDate=)[^\&]+/, '$1' + encodeURIComponent(timelineselected));
			}
			else
			{
				lineChartURL=lineChartURL+'&selectedDate='+encodeURIComponent(timelineselected);
			}
			var TIMELINE_VALUES = overviewDataObj['TIMELINE_VALUES'];
			var selectedTimeline = overviewDataObj['selectedTimeline'];
			var GRAPH_TIMELINE_VALUES = overviewDataObj['GRAPH_TIMELINE_VALUES'];
			var timelineTitle;
			if (!Ext.isEmpty(lineChartURL)) {
				var lineChartParams='';
				var tmplineChartURL = lineChartURL;
				if(tmplineChartURL!=null && tmplineChartURL.indexOf("?")>-1)
				{
					lineChartURL=tmplineChartURL.substr(0,tmplineChartURL.indexOf("?"));
					lineChartParams=tmplineChartURL.substr(tmplineChartURL.indexOf("?")+1);
				}
				Ext.Ajax.request({
					method : 'POST',
					url: lineChartURL,//+'&selectedDate='+timelineselected ,
					params : lineChartParams,
					scope: this,
					async: false,
					success: function (response)
					{
						if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
						{
							var jsonText = response.responseText;
							var jsonData = Ext.decode(jsonText);
							var areaValues=jsonData['AREACHART_DATA'];
							var NoMeasure=jsonData['NoMeasureMsg'];
							selectedTimeline = jsonData['selectedTimeline'];
							timelineTitle = jsonData['timelineTitle'];
							for ( var key in areaValues )
							{
								var NoTestMsg = areaValues[key]['NoTestMsg'];
								var areaTitle = areaValues[key]['Title'];
								if(NoTestMsg!=null && NoTestMsg == '-')
								{									
									var imgURL = areaValues[key]['areaChartURL'];

									var timeline = areaValues[key]['Timeline'];
									var startDate = areaValues[key]['startDate'];
									var startHr = areaValues[key]['startHr'];
									var endDate = areaValues[key]['endDate'];
									var endHr = areaValues[key]['endHr'];
									var startMin = areaValues[key]['startMin'];
									var endMin = areaValues[key]['endMin'];
								
									var type = areaValues[key]['Type'];
									var graphFormat = areaValues[key]['GRAPH_FORMAT'];
									var tmp_imgURL = imgURL;
									var queryParams = '';
									if(tmp_imgURL!=null && tmp_imgURL.indexOf("?")>-1)
									{
										imgURL=tmp_imgURL.substr(0,tmp_imgURL.indexOf("?"));
										queryParams=tmp_imgURL.substr(tmp_imgURL.indexOf("?")+1);
									}
									Ext.Ajax.request({
										url: imgURL,
										method : 'POST',
										params : queryParams,
										scope: this,
										async: false,
										success: function (response)
										{
											if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
											{
												var tmpJsonTxt = response.responseText;
												if ( tmpJsonTxt.indexOf('png') == -1 && tmpJsonTxt.indexOf('PNG') == -1 && tmpJsonTxt.indexOf('gif') == -1 && tmpJsonTxt.indexOf('GIF') == -1 && (tmpJsonTxt.indexOf('iconExclamation') == -1 && tmpJsonTxt.indexOf('iconInformation') == -1) && tmpJsonTxt.indexOf('<div') == -1)
												{
													var jsonData = Ext.decode(tmpJsonTxt);
													var tmpHeight = 240;
													if(jsonData!=null && jsonData.hasOwnProperty('DataSet'))
													{
														lineChartArr.push({
															xtype: 'panel',
															border: false,
															frame: false,
															padding: 0,
															ui:'egGraphPanel',
															title: areaTitle,
															id: 'lineChartId' + key,
															lineData: jsonData,
															columnWidth: .5,
															margin: '5 5 5 5',
															height: 305,
															maxURL: imgURL,
																
															layout:{
																type:'vbox',
																align:'stretch',
																pack:'start'
															},
															idNo : key,
															items:[
															{
																xtype:'container',
																id: 'lineChartLegendId'+ key,
																height:33,
																//width:450,
																border:false,
																autoScroll:true,
																layout:'fit',
																margin:'10 30 0 60',
																style:{'border':'0px solid red'},
															},
															{
																xtype:'panel',
																id: 'netlineChartId'+ key,
																height: 260,
																scroll:false,
																autoScroll:false,
																bodyStyle: {
																	'border-top':'0px solid gray !important',
																},
																margin:'0 0 0 0',
															}],
															listeners: {
																"boxready": function(lineChartId) {
																	var liveMeasHtml = "";
																	var dataSetObj = jsonData['DataSet'];
																	liveMeasHtml += '<table width="95%" ><tr ><td width="100%">';
																	for ( var dObj in dataSetObj) 
																	{
																		var seriesObj = dataSetObj[dObj];
																		if (seriesObj != null && seriesObj.hasOwnProperty('dispLegend')) 
																		{
																			var legndName = seriesObj['dispLegend'];
																			var measVal = seriesObj['measVal'];
																			if(measVal!=null && measVal!="NA")
																			{
																				var layerModelUrl = seriesObj['layerModelUrl'];
																				var legndColor=seriesObj['color'];
																				var unitForMeas=seriesObj['unit'];
																				
																				var legend_store = legndName;
																				if(legend_store.length > 18){
																					var legndName = legndName.substr(0,14)+'...';
																				}
																				liveMeasHtml+='<div style="float:left;width:135px;">';
																				if(legndName!=null && legndName!="-" && measVal!=null && measVal!="-" && measVal!="NA")
																				{
																					liveMeasHtml += '<div style="float:left;width:8px;height:8px;margin:5px 4px;background:'+legndColor+';"></div>';
																				
																					liveMeasHtml += '<div style="float:left;width:105px;height;20px;margin:2px 10px 2px 2px;" ><a href=\'javascript:wayToLayerModelForArea("' + encodeURIComponent(layerModelUrl) + '")\'><span class="status font_normal10" data-qtip="'+legend_store+'">'+legndName+'</span></a></div>';
																				}
																				
																				liveMeasHtml+='</div>';
																																						
																			}
																		}
																	}	
																	liveMeasHtml+='</td></tr></table>';
																		
																	Ext.defer(function(){
																		Ext.getCmp('lineChartLegendId'+ lineChartId.idNo).update(liveMeasHtml);	
																		
																	},250);
																	var timeline = selectedTimeline[0];
																	
																	tmpHeight = lineChartId.getHeight()-70 ;
																	if(timeline == undefined || timeline == "undefined" ||  timeline == ''){
																		tmpHeight = lineChartId.getHeight()-50 ;
																	}
																	else {
																		if((timeline.indexOf("hour")>-1) && ((timeline == "24 hours") == false)){
																			tmpHeight = lineChartId.getHeight()-50 ;
																		}
																	}
																	var chartContainer =  'netlineChartId'+ lineChartId.idNo + '-body';
																	try {
																		var lineChart = {};
																		var chartWidth = lineChartId.getWidth()-50;
																		lineChart = jQuery.extend(true, {}, getHighCharts(chartContainer, tmpHeight, chartWidth, this.maxURL), lineChart);
																		lineChart.setData(lineChartId.lineData, currentDateFormat, this.maxURL, true, 'center');
																		lineChart.drawChart();
																	} catch (e) {
																		console.log("exception in highchart method::" + e)
																	}
																},
																"resize": function(lineChartId) {
																	var timeline = selectedTimeline[0];
																	tmpHeight = lineChartId.getHeight()-70 ;
																	if(timeline == undefined || timeline == "undefined" ||  timeline == ''){
																		tmpHeight = lineChartId.getHeight()-50 ;
																	}
																	else {
																		if((timeline.indexOf("hour")>-1) && ((timeline == "24 hours") == false)){
																			tmpHeight = lineChartId.getHeight()-50 ;
																		}
																	}
																	var chartContainer =  'netlineChartId'+ lineChartId.idNo + '-body';
																	try {
																		var lineChart = {};
																		var chartWidth = lineChartId.getWidth()-50;
																		lineChart = jQuery.extend(true, {}, getHighCharts(chartContainer, tmpHeight, chartWidth, this.maxURL), lineChart);
																		lineChart.setData(lineChartId.lineData, currentDateFormat, this.maxURL, true, 'center');
																		lineChart.drawChart();
																	} catch (e) {
																		console.log("exception in highchart method::" + e)
																	}
																}
															},
															tools: [{ 
																xtype: 'button',
																iconCls: 'iconMaximize',
																areaTitle: areaTitle,
																lineData: jsonData,
																maxURL: imgURL,
																style:{'background':'transparent','border':'1px solid transparent'},
																listeners:{
																	'afterrender': function () {
																		Ext.create('Ext.tip.ToolTip', {
																			target: this.id,
																			anchor: 'top',
																			cls: 'yellowTip',
																			trackMouse: true,
																			html:maximizeViewLbl
																		});
																	}
																},
																handler: function()
																{
																	var chartLegendContainer = "";
																	var chartContainer = "";
																	var chartContainerID = "";
																	var tmpMaxURL = "";
																	var maxWindow = Ext.create('utilities.GenericWindow',
																	{
																		title: this.areaTitle,
																		lineData: this.lineData,
																		maxURL: this.maxURL,
																		width: '90%',
																		height:'90%',
																		cssMask: true,
																		id: 'idForGettingWidth',
																		padding: '5 10 10 10',
																		resizable: false,
																		draggable: true,
																		closeAction: 'destroy',
																		scroll: false,
																		autoScroll: false,
																		idNo: key,
																		items:[
																			{
																				xtype: 'container',
																				layout:{
																					type:'hbox',
																					pack:'center',
																					align:'center'
																				},
																				flex:1,
																				height:60,
																				defaults: {
																					labelAlign: 'top',
																				},
																				margin:'10 10 0 10',
																				items: [{
																					xtype:'timeline',
																					cls:'timeline_left',
																					id: 'timelineNetflow'+ key,
																					name: 'timelineNetflow'+ key,
																					margin:'10 0 0 10',
																					hidden: false,
																					hideMinutes : false,
																					layout:{
																						type:'hbox',
																						pack:'center',
																						align:'center'
																					},
																				},{
																					xtype:'button',
																					text:'Submit',
																					margin:'31 0 0 10',
																					text:"SUBMIT",
																					cls:"button20",
																					width:60,
																					id:"submitNetflow"+ key,
																					name:"submitNetflow"+ key,
																					
																					listeners: {
																						"click": function(maxlineChartId) {
																							var tmpImgURL = tmpMaxURL.substring(0,tmpMaxURL.indexOf("&Timeline"));
																							
																							var timeline = Ext.getCmp("er_timeline").getValue();
																							var startDate = Ext.getCmp("er_stdate").getValue();
																							var startHr = Ext.getCmp("er_sthr").getValue();
																							var startMin = Ext.getCmp("er_stmin").getValue();
																							var endDate = Ext.getCmp("er_enddate").getValue();
																							var endHr = Ext.getCmp("er_endhr").getValue();
																							var endMin = Ext.getCmp("er_endmin").getValue();
																							if(timeline == "Any"){
																								startDate=Ext.Date.dateFormat(startDate,"m/d/Y");
																								endDate=Ext.Date.dateFormat(endDate,"m/d/Y");
																							}
																							else{
																								startDate=Ext.Date.dateFormat(startDate,"m/d/Y");
																								endDate=Ext.Date.dateFormat(endDate,"m/d/Y");
																							}
																							tmpImgURL = tmpImgURL + "&Timeline="+timeline+"&TimePeriod="+encodeURIComponent(startDate+" "+startHr+":"+startMin+"|"+endDate+" "+endHr+":"+endMin);
																							tmpImgURL = tmpImgURL + imgURL.substring(imgURL.indexOf("&components"));
																							var queryParams='';
																							var tmpURL = tmpImgURL;
																							if(tmpURL!=null && tmpURL.indexOf("?")>-1)
																							{
																								tmpImgURL=tmpURL.substr(0,tmpURL.indexOf("?"));
																								queryParams=tmpURL.substr(tmpURL.indexOf("?")+1);
																							}
																							Ext.Ajax.request({
																								url: tmpImgURL,
																								method : 'POST',
																								params : queryParams,
																								scope: this,
																								async: false,
																								success: function (response)
																								{
																									if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
																									{
																										var tmpJsonTxt = response.responseText;
																										if ( tmpJsonTxt.indexOf('png') == -1 && tmpJsonTxt.indexOf('PNG') == -1 && tmpJsonTxt.indexOf('gif') == -1 && tmpJsonTxt.indexOf('GIF') == -1 && (tmpJsonTxt.indexOf('iconExclamation') == -1 || tmpJsonTxt.indexOf('iconInformation') == -1))
																										{
																											var tmpJsonData = Ext.decode(tmpJsonTxt);
																											
																											if(tmpJsonData!=null && tmpJsonData.hasOwnProperty('DataSet'))
																											{
																												var liveMeasHtml = "";
																												var dataSetObj = tmpJsonData['DataSet'];
																												liveMeasHtml += '<table width="600px" align="center"><tr><td width="100%" >';
																												for ( var dObj in dataSetObj) 
																												{
																													liveMeasHtml += '<div style="float:left;margin-right:10px">';
																													var seriesObj = dataSetObj[dObj];
																													if (seriesObj != null && seriesObj.hasOwnProperty('dispLegend')) 
																													{
																														var legndName = seriesObj['dispLegend'];
																														var measVal = seriesObj['measVal'];
																														if(measVal!=null && measVal!="NA")
																														{
																															var layerModelUrl = seriesObj['layerModelUrl'];
																															var legndColor=seriesObj['color'];
																															var unitForMeas=seriesObj['unit'];
																															var legend_store = legndName;
																															if(legend_store.length > 15){
																																var legndName = legndName.substr(0,12)+'...';
																															}
																															liveMeasHtml+='<div style="float:left;width:140px;">';
																															if(legndName!=null && legndName!="-" && measVal!=null && measVal!="-")
																															{
																																liveMeasHtml += '<div style="float:left;width:8px;height:8px;margin:5px 4px;background:'+legndColor+';"></div>';
																																liveMeasHtml += '<div style="float:left;height;20px;width:110px;margin:2px 10px 2px 2px;" ><a href=\'javascript:wayToLayerModelForArea("' + encodeURIComponent(layerModelUrl) + '")\'><span class="status font_normal10" data-qtip="'+legend_store+'">'+legndName+'</span></a></div>';
																															}
																															liveMeasHtml+='</div>';
																														}
																													}
																													liveMeasHtml+='</div>';
																												}
																												liveMeasHtml += '<div style="clear:both" class="font_normal9">* All values are in percentage(%) </div></td></tr></table>';
																												
																												Ext.defer(function(){
																													Ext.getCmp(chartLegendContainer).update(liveMeasHtml);	
																												},250);
																												var getPanelId = Ext.get('idForGettingWidth');
																												var tmpHeight = getPanelId.getHeight()-180 ;
																												if(timeline == undefined || timeline == "undefined" || timeline == ''){
																													tmpHeight = getPanelId.getHeight()-160 ;
																												}
																												else {
																													if((timeline.indexOf("hour")>-1) && (timeline=="24 hours" == false)){
																													tmpHeight = getPanelId.getHeight()-160 ;
																													}
																												}
																												try {
																													var lineChart = {};
																													lineChart = jQuery.extend(true, {}, getHighCharts(chartContainer, tmpHeight, getPanelId.getWidth()-100, this.maxURL), lineChart);
																													lineChart.setData(tmpJsonData, currentDateFormat, this.maxURL, true, 'center');
																													lineChart.drawChart();
																												} catch (e) {
																													console.log("exception in highchart method::" + e)
																												}
																											}
																											else {
																												Ext.getCmp(chartLegendContainer).update('');
																												var getPanelId = Ext.get('idForGettingWidth');
																												var tmpHeight = getPanelId.getHeight()-180;
																												Ext.getCmp(chartContainerID).setHeight(tmpHeight);
																												Ext.getCmp(chartContainerID).update('<div style="margin-top:115px;"><table width="100%" height="100%"><tr><td valign="middle" align="center"><div class="iconInformation" ></div><div style="font-size:12px">'+noMeasure+'! </div></td></tr></table></div>');	
																											}
																										}
																										else{
																											Ext.getCmp(chartLegendContainer).update('');
																											var getPanelId = Ext.get('idForGettingWidth');
																											var tmpHeight = getPanelId.getHeight()-180;
																											Ext.getCmp(chartContainerID).setHeight(tmpHeight);
																											Ext.getCmp(chartContainerID).update('<div style="margin-top:115px;"><table width="100%" height="100%"><tr><td valign="middle" align="center"><div class="iconInformation" ></div><div style="font-size:12px">'+noMeasure+'! </div></td></tr></table></div>');	
																										}
																									}
																								}
																							});
																						}
																					},
																				}]
																			},
																			{	
																				xtype:'container',
																				//id: 'maxviewlineChartLegendId'+ key,
																				//autoScroll:true,
																				//scroll:true,
																				//height:40,
																				//width: "90%",
																				layout:{
																						type:'vbox',
																						pack:'center',
																						align:'center'
																					},
																				//padding:'',
																				//margin: '5 0 10 0',
																				style:{'border':'0px solid red'},
																				items: [
																						{
																						xtype:'container',
																						id: 'maxviewlineChartLegendId'+ key,
																						autoScroll:true,
																						scroll:true,
																						height:40,
																						width: "95%",
																						padding: 0,
																						margin: 0,
																					
																						}
																					]
																			},
																			{
																				xtype:'panel',
																				id: 'maxviewlineChartId'+ key,
																				scroll:false,
																				autoScroll:false,
																				margin:'0 0 0 0',
																			},
																		],
																			listeners: {
																				"boxready": function(maxlineChartId) {
																					tmpMaxURL=maxlineChartId.maxURL;
																					var tmpJsonData= maxlineChartId.lineData;
																					Ext.getCmp("er_timeline").getStore().loadRawData(TIMELINE_VALUES);
																					Ext.getCmp("er_timeline").setValue(timeline.valueField);
																					
																					if(timeline.valueField == "Any"){
																						Ext.getCmp("er_stdate").setValue(startDate);
																						Ext.getCmp("er_sthr").setValue(startHr);
																						Ext.getCmp("er_stmin").setValue(startMin);
																						Ext.getCmp("er_enddate").setValue(endDate);
																						Ext.getCmp("er_endhr").setValue(endHr);
																						Ext.getCmp("er_endmin").setValue(endMin);
																						Ext.getCmp('er_timeline').fireEvent('select',Ext.getCmp('er_timeline'));
																					}
																					else {
																						Ext.getCmp('er_timeline').fireEvent('select',Ext.getCmp('er_timeline'));
																					}
																					var liveMeasHtml = "";
																					var dataSetObj = tmpJsonData['DataSet'];
																					liveMeasHtml += '<table width="100%" align="center"><tr><td width="100%" >';
																					for ( var dObj in dataSetObj) 
																					{
																						liveMeasHtml += '<div style="float:left;width: 33%;display:inline-block;">';
																						var seriesObj = dataSetObj[dObj];
																						if (seriesObj != null && seriesObj.hasOwnProperty('dispLegend')) 
																						{
																							var legndName = seriesObj['dispLegend'];
																							var measVal = seriesObj['measVal'];
																							if(measVal!=null && measVal!="NA")
																							{
																								var layerModelUrl = seriesObj['layerModelUrl'];
																								var legndColor=seriesObj['color'];
																								var unitForMeas=seriesObj['unit'];
																								var legend_store = legndName;
																								/*if(legend_store.length > 15){
																									var legndName = legndName.substr(0,12)+'...';
																								}*/
																								liveMeasHtml+='<div style="float:left;width:100%;margin-right:10px;position:relative">';
																								if(legndName!=null && legndName!="-" && measVal!=null && measVal!="-" && measVal!="NA")
																								{
																									liveMeasHtml += '<div style="position:absolute;width:8px;height:8px;margin:5px 4px;display: inline-block;background:'+legndColor+';"></div>';
																									liveMeasHtml += '<div style="float:left;height;20px;;width: 100%;padding: 0 15px 0 16px;display: inline-block;margin:0px 0px 4px 0px;white-space: nowrap;overflow: hidden;text-overflow: ellipsis;" ><a href=\'javascript:wayToLayerModelForArea("' + encodeURIComponent(layerModelUrl) + '")\'><span class="status font_normal10" data-qtip="'+legend_store+'">'+legndName+'</span></a></div>';
																								}
																								liveMeasHtml+='</div>';
																							}
																						}
																						liveMeasHtml+='</div>';
																					}
																					liveMeasHtml += '<div style="clear:both" class="font_normal9">* All values are in percentage(%) </div></td></tr></table>';
																					chartLegendContainer = 'maxviewlineChartLegendId'+ maxlineChartId.idNo;
																					Ext.defer(function(){
																						Ext.getCmp(chartLegendContainer).update(liveMeasHtml);
																					},250);
																					chartContainerID = 'maxviewlineChartId'+ maxlineChartId.idNo;
																					chartContainer = 'maxviewlineChartId'+ maxlineChartId.idNo + '-body';
																					var getPanelId = Ext.get('idForGettingWidth');
																					var tmpHeight = getPanelId.getHeight()-200 ;
																					var timelineVal = timeline.valueField;								
																					if(timelineVal == undefined || timelineVal == "undefined" || timelineVal == ''){
																						tmpHeight = getPanelId.getHeight()-180 ;
																					}
																					else {
																						if((timelineVal.indexOf("hour")>-1) && (timelineVal=="24 hours" == false)){
																							tmpHeight = getPanelId.getHeight()-180 ;
																						}
																					}
																					try {
																						var lineChart = {};
																						lineChart = jQuery.extend(true, {}, getHighCharts(chartContainer, tmpHeight, getPanelId.getWidth()-100, this.maxURL), lineChart);
																						lineChart.setData(maxlineChartId.lineData, currentDateFormat, this.maxURL, true, 'center');
																						lineChart.drawChart();
																					} catch (e) {
																						console.log("exception in highchart method::" + e)
																					}
																				},
																				"resize": function(maxlineChartId) {
																					var getPanelId = Ext.get('idForGettingWidth');
																					var tmpHeight = getPanelId.getHeight()-200 ;
																					var timelineVal = timeline.valueField;							
																					if(timelineVal == undefined || timelineVal == "undefined" || timelineVal == ''){
																						tmpHeight = getPanelId.getHeight()-170 ;
																					}
																					else {
																						if((timelineVal.indexOf("hour")>-1) && (timelineVal=="24 hours" == false)){
																						tmpHeight = getPanelId.getHeight()-170 ;
																						}
																					}
																					try {
																						var lineChart = {};
																						lineChart = jQuery.extend(true, {}, getHighCharts(chartContainer, tmpHeight, getPanelId.getWidth()-100, this.maxURL), lineChart);
																						lineChart.setData(maxlineChartId.lineData, currentDateFormat, this.maxURL, true, 'center');
																						lineChart.drawChart();
																					} catch (e) {
																						console.log("exception in highchart method::" + e)
																					}
																				}
																			},
																			bodyStyle:{'overflow-y': 'auto'},
																		}
																	).show();
																}
															}]
														});
													}
													else
													{
														lineChartArr.push({
															xtype: 'panel',
															border: false,
															frame: false,
															padding: 0,
															ui:'egGraphPanel',
															header: {
																cls: "netflow_panel_graph_header",
																style: {
																	'border-bottom': '1px solid #cccccc !important'
																},
															},
															title: areaTitle,
															columnWidth: .5,
															margin: '5 5 10 5',
															items:[{
																xtype:'container',
																html:'<table width="100%" height="100%"><tr><td valign="middle" align="center"><div class="iconInformation" ></div><div style="font-size:12px">'+noMeasure+'! </div></td></tr></table>'
															}]
														});
													}
												}
												else
												{
													lineChartArr.push({
														xtype: 'panel',
														border: false,
														frame: false,
														padding: 0,
														ui:'egGraphPanel',
														title: areaTitle,
														columnWidth: .5,
														layout:{
															type:'fit',
															align:'stretch',
														},
														flex:1,
														margin: '5 5 5 5',
														items:[{
															xtype:'container',
															height:280,
															html:tmpJsonTxt
														}]
													});
												}
											}
										}
									});
								}
								else
								{
									console.log("alert here");
									lineChartArr.push({
										xtype: 'panel',
										border: false,
										frame: false,
										padding: 0,
										ui:'egGraphPanel',
										header: {
											cls: "netflow_panel_graph_header",
											style: {
												'border-bottom': '1px solid #cccccc !important'
											},
										},
										title: areaTitle,
										columnWidth: .5,
										margin: '5 5 10 5',
										items:[{
											xtype:'container',
											height:280,
											html:'<table width="100%" height="100%"><tr><td valign="middle" align="center"><div class="iconInformation" ></div><div style="font-size:12px">'+NoTestMsg+'! </div></td></tr></table>'
										}]
									});
								}
							}
						}
					}
				});
			}
			
			newCard.timelineComboArray =TIMELINE_VALUES;
			newCard.selectedTimelineCombo = selectedTimeline;
			newCard.timelineTitle = timelineTitle;
			this.addNetflowTabtoolbar(newCard);
			panelItems = {
				autoScroll: false,
				scroll: false,
				layout: {
					type: 'hbox',
					align: 'stretch'
				},
				flex:1,
				frame:false,
					items: [{
						xtype: 'container',
						defaults: {
							margin: '0 10 10 10',
						},
						layout: {
							type: 'vbox',
							align:'stretch',
						},
						width: 220,
						items: dailChart,
					}, {
						xtype: 'panel',
						columnWidth: 1,
						layout: {
							type: 'column',
							pack:'start',
						},
						title:'<span style="text-transform:uppercase">'+networkInterfacesLbl+'</span>',
						header:{
							style:{'background':'transparent','border':'none','padding':'4px 0px 0px 10px'},
						},
						flex: 1,
						margin:0,
						frame:false,
						items: [
							{
								xtype: 'panel',
								border: false,
								frame:false,
								columnWidth: 1,
								layout: {
									type: 'column',
									align: 'stretch'
								},
								margin:'0 5 5 5',
								items: lineChartArr
							},
						]
					}]
			};
        }
        else if (activeTab == "protocols") 
		{
			var protocolurl = newCard.DataURL;
			var interafceLastSelected = localStorage.getItem("interfaceLastSelectedView");
			if(interafceLastSelected!=null && !Ext.isEmpty(interafceLastSelected))
			{
				interfaceSelectedView = interafceLastSelected;
			}   
			var showSelectedView = localStorage.getItem("showLastSelectedView");
			if(showSelectedView!=null && !Ext.isEmpty(showSelectedView))
			{
				showVal = showSelectedView;
			}   
			var timelinetSelectedView = localStorage.getItem("timelineLastSelectedView");
			if(timelinetSelectedView!=null && !Ext.isEmpty(timelinetSelectedView))
			{
				globalTimeline = timelinetSelectedView;
			} 
			if(interfaceSelectedView != null){

				if(protocolurl!=null && protocolurl.indexOf("interfaceToView")>0)
				{
					protocolurl = protocolurl.replace(/(interfaceToView=)[^\&]+/, '$1' + encodeURIComponent(interfaceSelectedView));				
				}
				else
				{
					protocolurl = protocolurl+"&interfaceToView="+encodeURIComponent(interfaceSelectedView);
				}
				if(protocolurl!=null && protocolurl.indexOf("infosToArea")>0)
				{
					protocolurl = protocolurl.replace(/(infosToArea=)[^\&]+/, '$1' + interfaceSelectedView);
				}
				else
				{
					protocolurl = protocolurl+"&infosToArea="+encodeURIComponent(interfaceSelectedView);
				}
			}
			if(showVal != null){
				if(protocolurl.indexOf("show") > -1)
				{
					protocolurl = protocolurl.replace(/(show=)[^\&]+/, '$1' + encodeURIComponent(showVal));
				}
				else
				{
					
					protocolurl += '&show='+encodeURIComponent(showVal);
				}
			}
			if(globalTimeline != null){
				if(protocolurl.indexOf("selectedTimeline") > -1)
				{
					protocolurl = protocolurl.replace(/(selectedTimeline=)[^\&]+/, '$1' + encodeURIComponent(globalTimeline));
				}
				else
				{
					
					protocolurl += '&selectedTimeline='+encodeURIComponent(globalTimeline);
				}
				if(protocolurl.indexOf("timeline") > -1)
				{
					protocolurl = protocolurl.replace(/(timeline=)[^\&]+/, '$1' + encodeURIComponent(globalTimeline));
				}
				else
				{
					
					protocolurl += '&timeline='+encodeURIComponent(globalTimeline);
				}
			}

			netflowLastLoadedURL = protocolurl;

			if(netflowLastLoadedURL!=null && netflowLastLoadedURL.indexOf("&ciscoSelectedType=")>0)
			{
				netflowLastLoadedURL = netflowLastLoadedURL.replace(/(ciscoSelectedType=)[^\&]+/, '$1' + 'protocols');
			}
			else
			{
				netflowLastLoadedURL=netflowLastLoadedURL+'&ciscoSelectedType=protocols';
			}
			var NoMeasure = noMeasureExcl;
			var NOMSG = noMeasureExcl;
			var selectedInterfaceCombo = '';
			var selectedShowCombo = '';
			var chartdata = '';
			var protocolTimelineCombo = '';
			var lineChartURL = '';
			var protocolGridPanel = '';
			var protocolTimelineComboArray = '';
			var pieChartPanel = '';
			var protocolSelectedTimelineCombo = '';
			var allInterfacesSelected = false;	
			var dataAvailable = '';
			var errorMsg = '';
			var protocolLineChart = '';
			var showTimelineChart = false;
			
			var protocolurlParams='';
			var tmpprotocolurl = protocolurl;
			if(tmpprotocolurl!=null && tmpprotocolurl.indexOf("?")>-1)
			{
				protocolurl=tmpprotocolurl.substr(0,tmpprotocolurl.indexOf("?"));
				protocolurlParams=tmpprotocolurl.substr(tmpprotocolurl.indexOf("?")+1);
			}
			Ext.Ajax.request({
				url: protocolurl ,
				method : 'POST',
				params : protocolurlParams,
				scope: this,
				async: false,
				success: function (response)
				{
					if ( !Ext.isEmpty( response.responseText ) )
					{
						var jsonText = response.responseText;							
						var jsonData = Ext.decode(jsonText);
						var showChart = jsonData['showChart'];
						var fromView = jsonData['fromView'];
						if(showChart!=null && showChart=="true")
						{
							showTimelineChart = true;
						}
						
						var tableData = jsonData['PROTOCOLSTABLE'];						
						errorMsg = tableData['errorMsg'];
						chartdata = jsonData['CHARTNTABLE_DATA'];
						pieTitle = jsonData['pieTitle'];
						protocolTimelineCombo = jsonData['protocolTimelineCombo'];
						protocolSelectedTimelineCombo = protocolTimelineCombo['selectedTimelineCombo'];
						protocolTimelineComboArray = protocolTimelineCombo['protocolTimelineComboArray'];
						var showCombo = jsonData['showCombo'];
						var showComboArray = showCombo['showComboArray'];
						selectedShowCombo = showCombo['selectedShowCombo'];
						var interfaceComboArray = jsonData['protocolInterfaceCombo'];
						selectedInterfaceCombo = jsonData['selectedInterfaceCombo'];
						NoMeasure = jsonData['NoMeasureMsg'];
						var pieChartData = jsonData['pieChart'];
						if(pieChartData!=null){
							NOMSG = pieChartData[0]['NOMSG'];
						}
						dataAvailable = jsonData['Data'];
						var isfromInterfaceComboChange = jsonData['isfromInterfaceComboChange'];
						var isInterfaceCountExceeded = jsonData['isInterfaceCountExceeded'];
						var timelineTitle = jsonData['timelineTitle'];
						var eventsPerPageCombo = jsonData['eventsPerPageCombo'];
						var eventsPerPageArray = '';
						var selectedEventsPerPage = '';
						if(timelineTitle!=null)
						{
							newCard.timelineTitle = timelineTitle;
						}
						if(interfaceComboArray!=null)
						{
							newCard.flowsInterfaceCombo = interfaceComboArray;
							newCard.flowsInterfaceSelectedCombo = selectedInterfaceCombo;
						}
						newCard.timelineComboArray =protocolTimelineComboArray;
						newCard.selectedTimelineCombo = protocolSelectedTimelineCombo;
						if(showCombo != null){
							newCard.showComboArray = showComboArray;
							newCard.selectedShowCombo = selectedShowCombo;
						}
						if(eventsPerPageCombo != null){
							eventsPerPageArray=eventsPerPageCombo['eventsPerPageArray']; 
							selectedEventsPerPage=eventsPerPageCombo['selectedEventsPerPage'];
							newCard.eventsPerPageArray = eventsPerPageArray;
							newCard.selectedEventsPerPage = selectedEventsPerPage;
						}
						this.addNetflowTabtoolbar(newCard);
								
						if(dataAvailable == "true") 
						{
							if(fromView!=null && fromView =='SummaryView' && isInterfaceCountExceeded)
							{
								var piePanel = '';
								if(!Ext.isEmpty(NOMSG))
								{
									piePanel = {
										xtype:'panel',
										flex:.5,
										height:300,
										margin:5,
										layout:{
											type:'fit',
										},
										ui:'egGraphPanel',
										title:pieTitle,
										items:[
											{
												xtype:'container',
												html:'<table width="100%" height="100%"><tr><td valign="middle" align="center"><div class="iconInformation" ></div><div >'+NOMSG+'</div></td></tr></table>' 
											}
										]
									}
								}
								else
								{
									piePanel = {
										xtype:'panel',
										flex:.5,
										height:300,
										margin:5,
										ui:'egGraphPanel',
										title:pieTitle,
										id:'piechart',
										pieChartData:pieChartData,
										listeners:
										{
											afterrender:function(){
												var me = this;
												if(!Ext.isEmpty(me.pieChartData)){													
													try {
														var barChart = {};
														barChart = jQuery.extend(true, {}, getPieChartsforNetflow('piechart-body', '290', '600'), barChart);
														barChart.setData(me.pieChartData[0]['XML_DATA'], currentDateFormat, '', 'ProtocolPieNetflow');
														barChart.drawChart();
													} catch (barChartEx) {
														console.log(barChartEx);
													}
													$(window).resize(function(){
														if(Ext.isEmpty(NOMSG)){
															if($("#"+"piechart-body").highcharts() != undefined)
															{
																$("#"+"piechart-body").highcharts().reflow();
															}
														}
													});
												}
											}
										}
									};
								}
								
								var barchartPanel = '';
								var barData = jsonData['comparisonCharts'];
								if(!Ext.isEmpty(barData['NoMeasure']))
								{
									barchartPanel = {
										xtype:'panel',
										flex:.5,
										height:300,
										margin:5,
										layout:{
											type:'fit',
										},
										ui:'egGraphPanel',
										title:jsonData['barTitle'],
										items:[
											{
												xtype:'container',
												html:'<table width="100%" height="100%"><tr><td valign="middle" align="center"><div class="iconInformation" ></div><div >'+barData['NoMeasure']+'</div></td></tr></table>' 
											}
										]																			
									};
								}
								else
								{
									barchartPanel = {
										xtype:'panel',
										flex:.5,
										height:300,
										margin:5,
										ui:'egGraphPanel',
										title:jsonData['barTitle'],
										id:'barGraphPanel',
										barData:barData,
										listeners:
										{
											afterrender:function(){
												var me = this;
												if(!Ext.isEmpty(me.barData)){													
													try
													{
														var barChart = {};
														barChart = jQuery.extend(true, {}, getHighChartsBarInstance('barGraphPanel-body',270,600),barChart);
														barChart.setData(me.barData['XML_DATA'], currentDateFormat, '','netflowconversationbar');
														barChart.drawChart();
													}
													catch (barChartEx)
													{
														console.log(barChartEx);
													}
												}
											}
										}										
									};
								}								
								
								var tableData = jsonData['tableData'];
								var protocolTableColumns = tableData['tableColumns'];
								var gridValues = tableData['tableValues'];
								if(gridValues!=null && gridValues.length>0)
								{
									var columnArr = new Array();
									var fieldModel = new Array();
									var columns = new Array();
									var colIdx = 0;
									for (var key in protocolTableColumns) { 
										fieldModel.push({
											name: 'COLUMVal_' + colIdx,
											type: 'FLOATORSTRING'
										});
										columns.push({
											header: protocolTableColumns[key],
											dataIndex: 'COLUMVal_' + colIdx,
											align: 'left',
											flex: 1,
											sortable: true,
											renderer: function(value, metaData, record, row, col, store, gridView)
											{
												var column = gridView.getHeaderAtIndex(col);
												var dataIndexVal = column.dataIndex;
												return value;
											}
										});
										colIdx++;
									}
									var ackStore = Ext.data.Store({
										fields: fieldModel,
										data: gridValues,
										/*sortOnLoad : true,
										sorters : {
											property : 'COLUMVal_1',
											direction : 'DESC'
										}*/
									});
									protocolGridPanel = {
										xtype: 'grid',
										id: 'gridDisplay',
										store: ackStore,
										height: 290,
										margin:'0 10 10 10',
										title: jsonData['TABLE_TITLE'],//tableData['TABLE_TITLE'],
										cls: 'gridSkin',
										header:{
											style:{
												'padding':'2px 10px 0px 10px' 
											}
										},
										columns: columns,
										tools: [	{
											xtype:'tbfill',
										},
										{
											xtype: 'trigger',
											trigger1Cls: 'x-form-clear-trigger',
											trigger2Cls: 'x-form-search-trigger',
											name: 'gridSearch',
											margin: '0 10 2 10',
											id: 'gridSearch',
											cls: 'whitedropdown_search',
											emptyText: 'Search',
											labelAlign: 'top',
											width: 200,
											hidden: false,
											getTriggerMarkup: function() {
												var me = this,
													i = 0,
													hideTrigger = (me.readOnly || me.hideTrigger),
													triggerCls,
													triggerBaseCls = me.triggerBaseCls,
													triggerConfigs = [],
													unselectableCls = Ext.dom.Element.unselectableCls,
													style = 'width:' + me.triggerWidth + 'px;' + (hideTrigger ? 'display:none;' : ''),
													cls = me.extraTriggerCls + ' ' + Ext.baseCSSPrefix + 'trigger-cell ' + unselectableCls;

												// TODO this trigger<n>Cls API design doesn't feel clean, especially where it butts up against the
												// single triggerCls config. Should rethink this, perhaps something more structured like a list of
												// trigger config objects that hold cls, handler, etc.
												// triggerCls is a synonym for trigger1Cls, so copy it.
												if (!me.trigger1Cls) {
													me.trigger1Cls = me.triggerCls;
												}
												for (i = 0; (triggerCls = me['trigger' + (i + 1) + 'Cls']) || i < 1; i++) {
													if (i == 0)
													{
														triggerConfigs.push({
															tag: 'td',
															role: 'presentation',
															valign: 'top',
															cls: cls,
															id : 'MyTrigger_'+i,
															style: style + "display:none;",
															cn: {
																cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
																role: 'presentation'
															}
														});
													}
													else
													{
														triggerConfigs.push({
															tag: 'td',
															role: 'presentation',
															valign: 'top',
															cls: cls,
															id : 'MyTrigger_'+i,
															style: style,
															cn: {
																cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
																role: 'presentation'
															}
														});
													}
												}
												triggerConfigs[0].cn.cls += ' ' + triggerBaseCls + '-first';
												return Ext.DomHelper.markup(triggerConfigs);
											},
											onTrigger1Click: function () {
											this.reset();
											},
											onTrigger2Click : function() {
												appCnt.textFieldSearch();
											},
										},{ 
											xtype: 'button',
											iconCls: 'iconMaximize',
											style:{'background':'transparent','border':'none'},
											listeners:{
												'afterrender': function () {
														Ext.create('Ext.tip.ToolTip', {
															target: this.id,
															anchor: 'top',
															cls: 'yellowTip',
															trackMouse: true,
															html:"Maximize View"
														});
													}
											},
											handler: function()
											{												
												var ackMaxStore = Ext.create('Ext.data.Store',{
													fields: fieldModel,
													pageSize: gridPageSize,
													autoLoad: true,
													proxy: {
														type: 'ajax',
														url: netflowLastLoadedURL+"&isFromGridPage=true",
														reader: {
															type: 'json',
															root : 'gridValues',
															page:'page',
															start:'start',
															limit:'limit',
															totalProperty : 'totalCount'
														}
													},
													listeners: {
														load: function(store, records, successful, eOpts) {
															var configPanl = Ext.getCmp('netflowmainpanel');
															if (successful) {
																configPanl.setLoading(false, false);
																						
															}else{
																configPanl.setLoading(true, true);
															}
														}
													}
												});	
												var bbar;
												ackMaxStore.on("load", function(component, records) {					
													var storeLength = ackMaxStore.data.length;
													var currentPageSize = ackMaxStore.pageSize;
													var currentTotalCount = ackMaxStore.totalCount;
													var currentPage ='';
													if(ackMaxStore.proxy.reader.rawData != null)
													{
														currentPage = ackMaxStore.proxy.reader.rawData.page;
													}
													var pageSize = ackMaxStore.pageSize;
													var totalpages = currentTotalCount/pageSize;
													totalpages = totalpages.toString();
													if(totalpages.indexOf('.') >-1)
													{
														totalpages = parseInt(totalpages);
														totalpages = totalpages +1;

													}else{
														totalpages = parseInt(totalpages);
													}

													if(currentPage > totalpages)
													{
														currentPage = totalpages;
														//store.loadPage(currentPage);
														configPanl.setLoading(true, true);
														
													}										  

													if((currentTotalCount-storeLength) == 0 ||  (currentPage == 1 && currentTotalCount <= currentPageSize) )
													{
														Ext.getCmp('maxPagingtoolbar').hide();
													}else{
														Ext.getCmp('maxPagingtoolbar').show();
													}
												});
												var gridMaxView = Ext.create('utilities.GenericWindow',
												{
													title:jsonData['TABLE_TITLE'],
													width: '90%',
													height: '90%',
													cssMask:true,
													padding:'5 10 10 10',
													resizable   : false,
													draggable   : true,
													closeAction: 'destroy',
													layout:'fit',
													scroll:true,
													border:false,
													items:{
														xtype:'grid',
														store: ackMaxStore,
														columns: columns,
														layout:'fit',
														cls: 'gridSkin',
														bbar: new Ext.PagingToolbar({
															store:ackMaxStore,
															id:'maxPagingtoolbar',
															cls:"pagingtoolbar",
															pageSize:gridPageSize,
															displayInfo: true,
															displayMsg:"Displaying {0} - {1} of {2}",
															listeners:{
																beforechange:function(){
																	var searchTextBoxObj=Ext.getCmp('gridSearch');
																	if(searchTextBoxObj != null)
																	 {
																		var searchValue = searchTextBoxObj.value ;
																		if(searchValue != '')
																		{
																			var grid = Ext.getCmp('gridDisplay');
																			if(grid != '')
																			{
																				grid.store.filters.clear();
																			}
																			searchTextBoxObj.reset();
																		}
																	 }
																}
															}
														}),
													},
													bodyStyle:{'overflow-y': 'auto'},
												}).show();
											}
										}]
									}
								}
								else
								{
									protocolGridPanel = {
										xtype:'panel',
										height: 220,
										margin:'0 10 10 10',
										layout:{
											type:'fit',
										},
										ui:'egGraphPanel',
										title: jsonData['TABLE_TITLE'],//tableData['TABLE_TITLE'],
										items:[
											{
												xtype:'container',
												html:'<table width="100%" height="100%"><tr><td valign="middle" align="center"><div class="iconInformation" ></div><div >'+noMeasureExcl+'</div></td></tr></table>' 
											}
										]				
									}
								}

								pieChartPanel = {
									xtype:'panel',
									tab:'Protocols',
									header:false,
									margin:5,
									layout:{
										type:'hbox',
										align:'stretch',
									},
									flex:1,
									items:[
										piePanel,
										barchartPanel
									]
								};
							}else if(isfromInterfaceComboChange){

								var barchartPanel = '';
								var barData = jsonData['comparisonCharts'];
								if(!Ext.isEmpty(barData['NoMeasure']))
								{
									barchartPanel = {
										xtype:'panel',
										flex:.5,
										height:300,
										margin:5,
										layout:{
											type:'fit',
										},
										ui:'egGraphPanel',
										title:jsonData['barTitle'],
										items:[
											{
												xtype:'container',
												html:'<table width="100%" height="100%"><tr><td valign="middle" align="center"><div class="iconInformation" ></div><div >'+barData['NoMeasure']+'</div></td></tr></table>' 
											}
										]																			
									};
								}
								else
								{
									barchartPanel = {
										xtype:'panel',
										flex:.5,
										height:300,
										margin:5,
										ui:'egGraphPanel',
										title:jsonData['barTitle'],
										id:'barGraphPanel',
										barData:barData,
										listeners:
										{
											afterrender:function(){
												var me = this;
												if(!Ext.isEmpty(me.barData)){													
													try
													{
														var barChart = {};
														barChart = jQuery.extend(true, {}, getHighChartsBarInstance('barGraphPanel-body',270,600),barChart);
														barChart.setData(me.barData['XML_DATA'], currentDateFormat, '','netflowconversationbar');
														barChart.drawChart();
													}
													catch (barChartEx)
													{
														console.log(barChartEx);
													}
												}
											}
										}										
									};
								}
								
								var piePanel = '';
								if(!Ext.isEmpty(NOMSG))
								{
									piePanel = {
										xtype:'panel',
										flex:.5,
										height:300,
										margin:5,
										layout:{
											type:'fit',
										},
										ui:'egGraphPanel',
										title:pieTitle,
										items:[
											{
												xtype:'container',
												html:'<table width="100%" height="100%"><tr><td valign="middle" align="center"><div class="iconInformation" ></div><div >'+NOMSG+'</div></td></tr></table>' 
											}
										]
									}
								}
								else
								{
									piePanel = {
										xtype:'panel',
										flex:.5,
										height:300,
										margin:5,
										ui:'egGraphPanel',
										title:pieTitle,
										id:'piechart',
										pieChartData:pieChartData,
										listeners:
										{
											afterrender:function(){
												var me = this;
												if(!Ext.isEmpty(me.pieChartData)){													
													try {
														var barChart = {};
														barChart = jQuery.extend(true, {}, getPieChartsforNetflow('piechart-body', '290', '460'), barChart);
														barChart.setData(me.pieChartData[0]['XML_DATA'], currentDateFormat, '', 'ProtocolPieNetflow');
														barChart.drawChart();
													} catch (barChartEx) {
														console.log(barChartEx);
													}
													$(window).resize(function(){
														if(Ext.isEmpty(NOMSG)){
															if($("#"+"piechart-body").highcharts() != undefined)
															{
																$("#"+"piechart-body").highcharts().reflow();
															}
														}
													});
												}
											}
										}
									};
								}

								pieChartPanel = {
									xtype:'panel',
									tab:'Protocols',
									header:false,
									margin:5,
									layout:{
										type:'hbox',
										align:'stretch',
									},
									flex:1,
									items:[
										piePanel,
										barchartPanel
									]
								};
									
								if (NoMeasure=='undefined' || errorMsg == '-')
								{
									var protocolTableColumns = tableData['tableColumns'];
									var gridValues = tableData['gridValues'];
									var columnArr = new Array();
									var fieldModel = new Array();
									var columns = new Array();
									var colIdx = 0;
									for (var key in protocolTableColumns) {                    

										fieldModel.push({
											name: 'COLUMVal_' + colIdx,
											type: 'string'
										});
										columns.push({
											header: protocolTableColumns[key],
											dataIndex: 'COLUMVal_' + colIdx,
											align: 'left',
											flex: 1,
											sortable: true,
											renderer: function(value, metaData, record, row, col, store, gridView)
											{
												var column = gridView.getHeaderAtIndex(col);
												var dataIndexVal = column.dataIndex;
												
												if (dataIndexVal != null && dataIndexVal == "COLUMVal_5") 
												{
													if(value!=null && value!="-")
													{
														if(value>0.0)
														{
															var barStr = '<table width="100%" cellpadding="0" cellspacing="0" border="0"  height="8" class="prog_border">';
															barStr += '<tr>';
															barStr += '<td align="left" width="100%" height="8" >';
															barStr += '<table width="' + value + '%" height="8"  cellpadding="0" cellspacing="0" border="0">';
															barStr += '<tr>';
															barStr += '<td class="progress_GOOD" width="100%"> </td>';
															barStr += '</tr>';
															barStr += '</table>';
															barStr += '</td>';
															barStr += '</tr>';
															barStr += '</table>';

															value = "<table width='100%' cellpadding='0' cellspacing='0'><tr><td style='width:50px'><span>" + value
															+ "</span></td><td >" + barStr + "</td></tr></table>";
														}
													}
												}
												return value;
											}
										});
										colIdx++;
									}
									var gridPageSize;
									if(selectedEventsPerPage == undefined || selectedEventsPerPage == 'undefined'){
										gridPageSize = parseInt(eventsPerPageArray[0].valueField);
									} else{
										gridPageSize = parseInt(selectedEventsPerPage);
									}
									var queryParams='';
									var tmpURL = '';
									var qryParamsObj={};
									if(netflowLastLoadedURL!=null && netflowLastLoadedURL.indexOf("?")>-1)
									{
										tmpURL = netflowLastLoadedURL.substr(0,netflowLastLoadedURL.indexOf("?"));
										queryParams=netflowLastLoadedURL.substr(netflowLastLoadedURL.indexOf("?")+1);
										if(!Ext.isEmpty(queryParams))
										{
										//	queryParams=decodeURIComponent(queryParams);										
											var queryParamsArr=queryParams.split('&');
											for(var q in queryParamsArr)
											{
												var reqParam=queryParamsArr[q];
												if(reqParam!=null && reqParam.indexOf("=")>-1)
												{
													var reqKey=reqParam.substr(0,reqParam.indexOf("="));
													var reqvalue=reqParam.substr(reqParam.indexOf("=")+1);
													if(reqKey.toLowerCase()=='timeline')
													{
														reqvalue=reqvalue.replace(/\+/g, '%20');
													}
													qryParamsObj[reqKey]=decodeURIComponent(reqvalue);
												}

											}
											qryParamsObj['isFromGridPage']='true';										
										}
									}
									var ackStore = Ext.create('Ext.data.Store',{
										fields: fieldModel,
										pageSize: gridPageSize,
										autoLoad: true,
										proxy: {
											type: 'ajax',
	//										url: netflowLastLoadedURL+"&isFromGridPage=true",
											actionMethods:  {
												create: "POST",
												read: "POST",
												update: "POST",
												destroy: "POST"
											},
										//	limitParam : 'undefined',
											url: tmpURL,
											extraParams : qryParamsObj,
											/*url: tmpURL,
											params: queryParams+"&isFromGridPage=true",
											method : 'POST',*/
											reader: {
												type: 'json',
												root : 'gridValues',
												page:'page',
												start:'start',
												limit:'limit',
												totalProperty : 'totalCount'
											}
										},
										listeners: {
											load: function(store, records, successful, eOpts) {
												var configPanl = Ext.getCmp('netflowmainpanel');
												if (successful) {
													configPanl.setLoading(false, false);
																			
												}else{
													configPanl.setLoading(true, true);
												}
											}
										}
									});	
									var bbar;
									ackStore.on("load", function(component, records) {					
										var storeLength = ackStore.data.length;
										var currentPageSize = ackStore.pageSize;
										var currentTotalCount = ackStore.totalCount;
										var currentPage ='';
										if(ackStore.proxy.reader.rawData != null)
										{
											currentPage = ackStore.proxy.reader.rawData.page;
										}
										var pageSize = ackStore.pageSize;
										var totalpages = currentTotalCount/pageSize;
										totalpages = totalpages.toString();
										if(totalpages.indexOf('.') >-1)
										{
											totalpages = parseInt(totalpages);
											totalpages = totalpages +1;

										}else{
											totalpages = parseInt(totalpages);
										}
									
										if(currentPage > totalpages)
										{
											currentPage = totalpages;
											//store.loadPage(currentPage);
											configPanl.setLoading(true, true);
											
										}										  
								
										if((currentTotalCount-storeLength) == 0 ||  (currentPage == 1 && currentTotalCount <= currentPageSize) )
										{
											if(Ext.getCmp('pagingtoolbar')!=null)
												Ext.getCmp('pagingtoolbar').hide();
										}else{
											if(Ext.getCmp('pagingtoolbar')!=null)
												Ext.getCmp('pagingtoolbar').show();
										}
									});
									protocolGridPanel = {
										xtype: 'grid',
										id: 'gridDisplay',
										store: ackStore,
										height: 290,
										margin:'0 10 10 10',
										title: tableData['TABLE_TITLE'],
										cls: 'gridSkin',
										header:{
											style:{
												'padding':'2px 10px 0px 10px' 
											}
										},
										columns: columns,
										bbar: new Ext.PagingToolbar({
											store:ackStore,
											id:'pagingtoolbar',
											cls:"pagingtoolbar",
											pageSize:gridPageSize,
											displayInfo: true,
											displayMsg:"Displaying {0} - {1} of {2}",
											listeners:{
												beforechange:function(){
													var searchTextBoxObj=Ext.getCmp('gridSearch');
													if(searchTextBoxObj != null)
													 {
														var searchValue = searchTextBoxObj.value ;
														if(searchValue != '')
														{
															var grid = Ext.getCmp('gridDisplay');
															if(grid != '')
															{
																grid.store.filters.clear();
															}
															searchTextBoxObj.reset();
														}
													 }
												}
											}
										}),
										tools: [	{
											xtype:'tbfill',
										},
										{
											xtype: 'trigger',
											trigger1Cls: 'x-form-clear-trigger',
											trigger2Cls: 'x-form-search-trigger',
											name: 'gridSearch',
											margin: '0 10 2 10',
											id: 'gridSearch',
											cls: 'whitedropdown_search',
											emptyText: searchLbl,
											labelAlign: 'top',
											width: 200,
											hidden: false,
											getTriggerMarkup: function() {
												var me = this,
													i = 0,
													hideTrigger = (me.readOnly || me.hideTrigger),
													triggerCls,
													triggerBaseCls = me.triggerBaseCls,
													triggerConfigs = [],
													unselectableCls = Ext.dom.Element.unselectableCls,
													style = 'width:' + me.triggerWidth + 'px;' + (hideTrigger ? 'display:none;' : ''),
													cls = me.extraTriggerCls + ' ' + Ext.baseCSSPrefix + 'trigger-cell ' + unselectableCls;

												// TODO this trigger<n>Cls API design doesn't feel clean, especially where it butts up against the
												// single triggerCls config. Should rethink this, perhaps something more structured like a list of
												// trigger config objects that hold cls, handler, etc.
												// triggerCls is a synonym for trigger1Cls, so copy it.
												if (!me.trigger1Cls) {
													me.trigger1Cls = me.triggerCls;
												}
												for (i = 0; (triggerCls = me['trigger' + (i + 1) + 'Cls']) || i < 1; i++) {
													if (i == 0)
													{
														triggerConfigs.push({
															tag: 'td',
															role: 'presentation',
															valign: 'top',
															cls: cls,
															id : 'MyTrigger_'+i,
															style: style + "display:none;",
															cn: {
																cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
																role: 'presentation'
															}
														});
													}
													else
													{
														triggerConfigs.push({
															tag: 'td',
															role: 'presentation',
															valign: 'top',
															cls: cls,
															id : 'MyTrigger_'+i,
															style: style,
															cn: {
																cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
																role: 'presentation'
															}
														});
													}
												}
												triggerConfigs[0].cn.cls += ' ' + triggerBaseCls + '-first';
												return Ext.DomHelper.markup(triggerConfigs);
											},
											onTrigger1Click: function () {
											this.reset();
											},
											onTrigger2Click : function() {
												appCnt.textFieldSearch();
											},
										},{ 
											xtype: 'button',
											iconCls: 'iconMaximize',
											style:{'background':'transparent','border':'none'},
											listeners:{
												'afterrender': function () {
														Ext.create('Ext.tip.ToolTip', {
															target: this.id,
															anchor: 'top',
															cls: 'yellowTip',
															trackMouse: true,
															html:maximizeViewLbl
														});
													}
											},
											handler: function()
											{
												var ackMaxStore = Ext.create('Ext.data.Store',{
													fields: fieldModel,
													pageSize: gridPageSize,
													autoLoad: true,
													proxy: {
														type: 'ajax',
														url: netflowLastLoadedURL+"&isFromGridPage=true",
														reader: {
															type: 'json',
															root : 'gridValues',
															page:'page',
															start:'start',
															limit:'limit',
															totalProperty : 'totalCount'
														}
													},
													listeners: {
														load: function(store, records, successful, eOpts) {
															var configPanl = Ext.getCmp('netflowmainpanel');
															if (successful) {
																configPanl.setLoading(false, false);
																						
															}else{
																configPanl.setLoading(true, true);
															}
														}
													}
												});	
												var bbar;
												ackMaxStore.on("load", function(component, records) {					
													var storeLength = ackMaxStore.data.length;
													var currentPageSize = ackMaxStore.pageSize;
													var currentTotalCount = ackMaxStore.totalCount;
													var currentPage ='';
													if(ackMaxStore.proxy.reader.rawData != null)
													{
														currentPage = ackMaxStore.proxy.reader.rawData.page;
													}
													var pageSize = ackMaxStore.pageSize;
													var totalpages = currentTotalCount/pageSize;
													totalpages = totalpages.toString();
													if(totalpages.indexOf('.') >-1)
													{
														totalpages = parseInt(totalpages);
														totalpages = totalpages +1;

													}else{
														totalpages = parseInt(totalpages);
													}

													if(currentPage > totalpages)
													{
														currentPage = totalpages;
														//store.loadPage(currentPage);
														configPanl.setLoading(true, true);
														
													}										  

													if((currentTotalCount-storeLength) == 0 ||  (currentPage == 1 && currentTotalCount <= currentPageSize) )
													{
														Ext.getCmp('maxPagingtoolbar').hide();
													}else{
														Ext.getCmp('maxPagingtoolbar').show();
													}
												});
												var gridMaxView = Ext.create('utilities.GenericWindow',
												{
													title:tableData['TABLE_TITLE'],
													width: '90%',
													height: '90%',
													cssMask:true,
													padding:'5 10 10 10',
													resizable   : false,
													draggable   : true,
													closeAction: 'destroy',
													layout:'fit',
													scroll:true,
													border:false,
													items:{
														xtype:'grid',
														store: ackMaxStore,
														columns: columns,
														layout:'fit',
														cls: 'gridSkin',
														bbar: new Ext.PagingToolbar({
															store:ackMaxStore,
															id:'maxPagingtoolbar',
															cls:"pagingtoolbar",
															pageSize:gridPageSize,
															displayInfo: true,
															displayMsg:"Displaying {0} - {1} of {2}",
															listeners:{
																beforechange:function(){
																	var searchTextBoxObj=Ext.getCmp('gridSearch');
																	if(searchTextBoxObj != null)
																	 {
																		var searchValue = searchTextBoxObj.value ;
																		if(searchValue != '')
																		{
																			var grid = Ext.getCmp('gridDisplay');
																			if(grid != '')
																			{
																				grid.store.filters.clear();
																			}
																			searchTextBoxObj.reset();
																		}
																	 }
																}
															}
														}),
													},
													bodyStyle:{'overflow-y': 'auto'},
												}).show();
											}
										}]
									};
								}
								else
								{
									protocolGridPanel = {
										xtype: 'panel',
										height: 260,
										cls:'block1 ',
										header: {
											cls: "netflow_panel_graph_header",
											style: {
												'border-bottom': '1px solid #cccccc !important'
											},
										},
										margin:'0 10 10 10',
										title: protocolsLbl,
										layout:{
											type:'fit',
											align:'stretch',
										},
										items:[
										{
											xtype:'container',
											html:'<table width="100%" height="100%"><tr><td valign="middle" align="center"><div class="iconInformation" ></div><div >'+NoMeasure+'</div></td></tr></table>' 
										}]
									};
								}
							}
							else
							{
								if (pieTitle !=null && pieTitle !='undefined')
								{
									if(pieTitle.length > 90){
										pieTitle = pieTitle.substr(0,90)+'...';
									}
								}								
								var pieChartWidth = 400;
								if(pieChartData.length == 1)
									pieChartWidth = 410;	
								pieChartPanel = {
									xtype:'genericpiechartslider',																		
									template:function(){
										var me = this;
										var sliderItems={};
										
										if (NoMeasure == undefined || NoMeasure == 'undefined')
										{	
											sliderItems = new Ext.XTemplate(
												'<ul>',
												'<tpl for=".">',
													'<li ><div  class="netFlowPieChartRightBorder" style="margin:0 auto 10px 0"><div style="text-align:center;margin:10px 5px 0px 5px;">{XML_DATA.title}</div><div id="chartholder{#}" ></div></div></li>',
												'</tpl>',
												'</ul>'
												
											 );
											}else{
												
												sliderItems = new Ext.XTemplate(
												'<ul >',
												'<li align="center" ><table width="100%" height="200px" align = "center" ><tr><td valign="middle" align="center"><div class="iconInformation" ></div><div > '+noMeasureExcl+'</div></td></tr></table></li>',
												'</ul>'
											);
										}
										return sliderItems;
										doComponentLayout();
									},
									data:pieChartData,									
									loadChart:function(data){
										var me = this;
										if(!Ext.isEmpty(data)){
											var count =1;
											for (var key in data)
											{
												var counter = count++;
												
												try {
													var barChart = {};
													var divWidth = Ext.get('chartholder'+counter).dom;
													barChart = jQuery.extend(true, {}, getPieChartsforNetflow('chartholder'+counter, 250, 410), barChart);
													barChart.setData(data[key]['XML_DATA'], currentDateFormat, '', 'ProtocolPieNetflow');
													barChart.drawChart();
												} catch (barChartEx) {
													console.log(barChartEx);
												}
												$(window).resize(function(){
													if(Ext.isEmpty(NOMSG)){
														if($("#"+"chartholder"+counter).highcharts() != undefined)
														{
															$("#"+"chartholder"+counter).highcharts().reflow();
														}
													}
												});
											}
										}
									},
									tab:'Protocols',
									title:pieTitle,
									margin: 10,
								};
								if (NoMeasure=='undefined' || errorMsg == '-')
								{
									var protocolTableColumns = tableData['tableColumns'];
									var gridValues = tableData['gridValues'];
									var columnArr = new Array();
									var fieldModel = new Array();
									var columns = new Array();
									var colIdx = 0;
									for (var key in protocolTableColumns) {                    

										fieldModel.push({
											name: 'COLUMVal_' + colIdx,
											type: 'string'
										});
										columns.push({
											header: protocolTableColumns[key],
											dataIndex: 'COLUMVal_' + colIdx,
											align: 'left',
											flex: 1,
											sortable: true,
											renderer: function(value, metaData, record, row, col, store, gridView)
											{
												var column = gridView.getHeaderAtIndex(col);
												var dataIndexVal = column.dataIndex;
												
												if (dataIndexVal != null && dataIndexVal == "COLUMVal_5") 
												{
													if(value!=null && value!="-")
													{
														if(value>0.0)
														{
															var barStr = '<table width="100%" cellpadding="0" cellspacing="0" border="0"  height="8" class="prog_border">';
															barStr += '<tr>';
															barStr += '<td align="left" width="100%" height="8" >';
															barStr += '<table width="' + value + '%" height="8"  cellpadding="0" cellspacing="0" border="0">';
															barStr += '<tr>';
															barStr += '<td class="progress_GOOD" width="100%"> </td>';
															barStr += '</tr>';
															barStr += '</table>';
															barStr += '</td>';
															barStr += '</tr>';
															barStr += '</table>';

															value = "<table width='100%' cellpadding='0' cellspacing='0'><tr><td style='width:50px'><span>" + value
															+ "</span></td><td >" + barStr + "</td></tr></table>";
														}
													}
												}
												return value;
											}
										});
										colIdx++;
									}
									var gridPageSize;
									if(selectedEventsPerPage == undefined || selectedEventsPerPage == 'undefined'){
										gridPageSize = parseInt(eventsPerPageArray[0].valueField);
									} else{
										gridPageSize = parseInt(selectedEventsPerPage);
									}
									var queryParams='';
									var tmpURL = '';
									var qryParamsObj={};
									if(netflowLastLoadedURL!=null && netflowLastLoadedURL.indexOf("?")>-1)
									{
										tmpURL = netflowLastLoadedURL.substr(0,netflowLastLoadedURL.indexOf("?"));
										queryParams=netflowLastLoadedURL.substr(netflowLastLoadedURL.indexOf("?")+1);
										if(!Ext.isEmpty(queryParams))
										{
										//	queryParams=decodeURIComponent(queryParams);										
											var queryParamsArr=queryParams.split('&');
											for(var q in queryParamsArr)
											{
												var reqParam=queryParamsArr[q];
												if(reqParam!=null && reqParam.indexOf("=")>-1)
												{
													var reqKey=reqParam.substr(0,reqParam.indexOf("="));
													var reqvalue=reqParam.substr(reqParam.indexOf("=")+1);
													if(reqKey.toLowerCase()=='timeline')
													{
														reqvalue=reqvalue.replace(/\+/g, '%20');
													}
													qryParamsObj[reqKey]=decodeURIComponent(reqvalue);
												}

											}
											qryParamsObj['isFromGridPage']='true';										
										}
									}
									var ackStore = Ext.create('Ext.data.Store',{
										fields: fieldModel,
										pageSize: gridPageSize,
										autoLoad: true,
										proxy: {
											type: 'ajax',
	//										url: netflowLastLoadedURL+"&isFromGridPage=true",
											actionMethods:  {
												create: "POST",
												read: "POST",
												update: "POST",
												destroy: "POST"
											},
										//	limitParam : 'undefined',
											url: tmpURL,
											extraParams : qryParamsObj,
											/*url: tmpURL,
											params: queryParams+"&isFromGridPage=true",
											method : 'POST',*/
											reader: {
												type: 'json',
												root : 'gridValues',
												page:'page',
												start:'start',
												limit:'limit',
												totalProperty : 'totalCount'
											}
										},
										listeners: {
											load: function(store, records, successful, eOpts) {
												var configPanl = Ext.getCmp('netflowmainpanel');
												if (successful) {
													configPanl.setLoading(false, false);
																			
												}else{
													configPanl.setLoading(true, true);
												}
											}
										}
									});	
									var bbar;
									ackStore.on("load", function(component, records) {					
										var storeLength = ackStore.data.length;
										var currentPageSize = ackStore.pageSize;
										var currentTotalCount = ackStore.totalCount;
										var currentPage ='';
										if(ackStore.proxy.reader.rawData != null)
										{
											currentPage = ackStore.proxy.reader.rawData.page;
										}
										var pageSize = ackStore.pageSize;
										var totalpages = currentTotalCount/pageSize;
										totalpages = totalpages.toString();
										if(totalpages.indexOf('.') >-1)
										{
											totalpages = parseInt(totalpages);
											totalpages = totalpages +1;

										}else{
											totalpages = parseInt(totalpages);
										}
									
										if(currentPage > totalpages)
										{
											currentPage = totalpages;
											//store.loadPage(currentPage);
											configPanl.setLoading(true, true);
											
										}										  
								
										if((currentTotalCount-storeLength) == 0 ||  (currentPage == 1 && currentTotalCount <= currentPageSize) )
										{
											if(Ext.getCmp('pagingtoolbar')!=null)
												Ext.getCmp('pagingtoolbar').hide();
										}else{
											if(Ext.getCmp('pagingtoolbar')!=null)
												Ext.getCmp('pagingtoolbar').show();
										}
									});
									protocolGridPanel = {
										xtype: 'grid',
										id: 'gridDisplay',
										store: ackStore,
										height: 300,
										margin:'0 10 10 10',
										title: tableData['TABLE_TITLE'],
										cls: 'gridSkin',
										header:{
											style:{
												'padding':'2px 10px 0px 10px' 
											}
										},
										columns: columns,
										bbar: new Ext.PagingToolbar({
											store:ackStore,
											id:'pagingtoolbar',
											cls:"pagingtoolbar",
											pageSize:gridPageSize,
											displayInfo: true,
											displayMsg:"Displaying {0} - {1} of {2}",
											listeners:{
												beforechange:function(){
													var searchTextBoxObj=Ext.getCmp('gridSearch');
													if(searchTextBoxObj != null)
													 {
														var searchValue = searchTextBoxObj.value ;
														if(searchValue != '')
														{
															var grid = Ext.getCmp('gridDisplay');
															if(grid != '')
															{
																grid.store.filters.clear();
															}
															searchTextBoxObj.reset();
														}
													 }
												}
											}
										}),
										tools: [	{
											xtype:'tbfill',
										},
										{
											xtype: 'trigger',
											trigger1Cls: 'x-form-clear-trigger',
											trigger2Cls: 'x-form-search-trigger',
											name: 'gridSearch',
											margin: '0 10 2 10',
											id: 'gridSearch',
											cls: 'whitedropdown_search',
											emptyText: searchLbl,
											labelAlign: 'top',
											width: 200,
											hidden: false,
											getTriggerMarkup: function() {
												var me = this,
													i = 0,
													hideTrigger = (me.readOnly || me.hideTrigger),
													triggerCls,
													triggerBaseCls = me.triggerBaseCls,
													triggerConfigs = [],
													unselectableCls = Ext.dom.Element.unselectableCls,
													style = 'width:' + me.triggerWidth + 'px;' + (hideTrigger ? 'display:none;' : ''),
													cls = me.extraTriggerCls + ' ' + Ext.baseCSSPrefix + 'trigger-cell ' + unselectableCls;

												// TODO this trigger<n>Cls API design doesn't feel clean, especially where it butts up against the
												// single triggerCls config. Should rethink this, perhaps something more structured like a list of
												// trigger config objects that hold cls, handler, etc.
												// triggerCls is a synonym for trigger1Cls, so copy it.
												if (!me.trigger1Cls) {
													me.trigger1Cls = me.triggerCls;
												}
												for (i = 0; (triggerCls = me['trigger' + (i + 1) + 'Cls']) || i < 1; i++) {
													if (i == 0)
													{
														triggerConfigs.push({
															tag: 'td',
															role: 'presentation',
															valign: 'top',
															cls: cls,
															id : 'MyTrigger_'+i,
															style: style + "display:none;",
															cn: {
																cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
																role: 'presentation'
															}
														});
													}
													else
													{
														triggerConfigs.push({
															tag: 'td',
															role: 'presentation',
															valign: 'top',
															cls: cls,
															id : 'MyTrigger_'+i,
															style: style,
															cn: {
																cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
																role: 'presentation'
															}
														});
													}
												}
												triggerConfigs[0].cn.cls += ' ' + triggerBaseCls + '-first';
												return Ext.DomHelper.markup(triggerConfigs);
											},
											onTrigger1Click: function () {
											this.reset();
											},
											onTrigger2Click : function() {
												appCnt.textFieldSearch();
											},
										},{ 
											xtype: 'button',
											iconCls: 'iconMaximize',
											style:{'background':'transparent','border':'none'},
											listeners:{
												'afterrender': function () {
														Ext.create('Ext.tip.ToolTip', {
															target: this.id,
															anchor: 'top',
															cls: 'yellowTip',
															trackMouse: true,
															html:maximizeViewLbl
														});
													}
											},
											handler: function()
											{
												var ackMaxStore = Ext.create('Ext.data.Store',{
													fields: fieldModel,
													pageSize: gridPageSize,
													autoLoad: true,
													proxy: {
														type: 'ajax',
														url: netflowLastLoadedURL+"&isFromGridPage=true",
														reader: {
															type: 'json',
															root : 'gridValues',
															page:'page',
															start:'start',
															limit:'limit',
															totalProperty : 'totalCount'
														}
													},
													listeners: {
														load: function(store, records, successful, eOpts) {
															var configPanl = Ext.getCmp('netflowmainpanel');
															if (successful) {
																configPanl.setLoading(false, false);
																						
															}else{
																configPanl.setLoading(true, true);
															}
														}
													}
												});	
												var bbar;
												ackMaxStore.on("load", function(component, records) {					
													var storeLength = ackMaxStore.data.length;
													var currentPageSize = ackMaxStore.pageSize;
													var currentTotalCount = ackMaxStore.totalCount;
													var currentPage ='';
													if(ackMaxStore.proxy.reader.rawData != null)
													{
														currentPage = ackMaxStore.proxy.reader.rawData.page;
													}
													var pageSize = ackMaxStore.pageSize;
													var totalpages = currentTotalCount/pageSize;
													totalpages = totalpages.toString();
													if(totalpages.indexOf('.') >-1)
													{
														totalpages = parseInt(totalpages);
														totalpages = totalpages +1;

													}else{
														totalpages = parseInt(totalpages);
													}

													if(currentPage > totalpages)
													{
														currentPage = totalpages;
														//store.loadPage(currentPage);
														configPanl.setLoading(true, true);
														
													}										  

													if((currentTotalCount-storeLength) == 0 ||  (currentPage == 1 && currentTotalCount <= currentPageSize) )
													{
														Ext.getCmp('maxPagingtoolbar').hide();
													}else{
														Ext.getCmp('maxPagingtoolbar').show();
													}
												});
												var gridMaxView = Ext.create('utilities.GenericWindow',
												{
													title:tableData['TABLE_TITLE'],
													width: '90%',
													height: '90%',
													cssMask:true,
													padding:'5 10 10 10',
													resizable   : false,
													draggable   : true,
													closeAction: 'destroy',
													layout:'fit',
													scroll:true,
													border:false,
													items:{
														xtype:'grid',
														store: ackMaxStore,
														columns: columns,
														layout:'fit',
														cls: 'gridSkin',
														bbar: new Ext.PagingToolbar({
															store:ackMaxStore,
															id:'maxPagingtoolbar',
															cls:"pagingtoolbar",
															pageSize:gridPageSize,
															displayInfo: true,
															displayMsg:"Displaying {0} - {1} of {2}",
															listeners:{
																beforechange:function(){
																	var searchTextBoxObj=Ext.getCmp('gridSearch');
																	if(searchTextBoxObj != null)
																	 {
																		var searchValue = searchTextBoxObj.value ;
																		if(searchValue != '')
																		{
																			var grid = Ext.getCmp('gridDisplay');
																			if(grid != '')
																			{
																				grid.store.filters.clear();
																			}
																			searchTextBoxObj.reset();
																		}
																	 }
																}
															}
														}),
													},
													bodyStyle:{'overflow-y': 'auto'},
												}).show();
											}
										}]
									};
								}
								else
								{
									protocolGridPanel = {
										xtype: 'panel',
										height: 260,
										cls:'block1 ',
										header: {
											cls: "netflow_panel_graph_header",
											style: {
												'border-bottom': '1px solid #cccccc !important'
											},
										},
										margin:'0 10 10 10',
										title: protocolsLbl,
										layout:{
											type:'fit',
											align:'stretch',
										},
										items:[
										{
											xtype:'container',
											html:'<table width="100%" height="100%"><tr><td valign="middle" align="center"><div class="iconInformation" ></div><div >'+NoMeasure+'</div></td></tr></table>' 
										}]
									};
								}
							}
						}
						if(showTimelineChart)
						{
							if (NoMeasure==null && NoMeasure=='undefined' || Ext.isEmpty(NoMeasure) && !Ext.isEmpty(chartdata) && chartdata.length >0) {
								var TITLE = chartdata[0]['TITLE'];
								if(TITLE.length > 90){
									TITLE = TITLE.substr(0,90)+'...';
								}
								var TimelineLbl = protocolTimelineCombo['monitor.dashboard.TimeLine'];
								lineChartURL = chartdata[0]['areaChartURL'];
								
								var protocolTimeline = chartdata[0]['Timeline'];
								var startDate = chartdata[0]['startDate'];
								var startHr = chartdata[0]['startHr'];
								var endDate = chartdata[0]['endDate'];
								var endHr = chartdata[0]['endHr'];
								var startMin = chartdata[0]['startMin'];
								var endMin = chartdata[0]['endMin'];
								try
								{
									Ext.Ajax.request({
										url: '/final/servlet/com.egurkha.monitor.CustomTimelineMeasures',//+'&selectedDate='+timeline ,
										scope: this,
										params:lineChartURL,
										async: false,
										method: 'POST',
										success: function (response)
										{
											if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
											{
												var tmpJsonTxt = response.responseText;

												if ( tmpJsonTxt.indexOf('png') == -1 && tmpJsonTxt.indexOf('PNG') == -1 && tmpJsonTxt.indexOf('gif') == -1 && tmpJsonTxt.indexOf('GIF') == -1 && (tmpJsonTxt.indexOf('iconExclamation') == -1 || tmpJsonTxt.indexOf('iconInformation') == -1))
												{
													var jsonData = Ext.decode(tmpJsonTxt);
													if(jsonData!=null && jsonData.hasOwnProperty('DataSet') && (jsonData['DataSet'].length>0) )
													{
														var ProtocolLineChartIdHeight = "";
														var ProtocolLineChartIdWidth = "";
														
														protocolLineChart = {
															xtype: 'panel',
															border: false,
															frame: false,
															margin:'0 10 10 10',
															padding: 0,
															id: 'ProtocolLineChart1',
															ui:'egGraphPanel',
															title:TITLE,
															lineData: jsonData,
															height: 300,
															layout:{
																type:'column',
																align:'stretch',
																pack:'start'
															},
															items:[{
																xtype:'container',
																id: 'ProtocolLineChartId',
																height: 270,
																margin:'20 20 10 20',
																columnWidth:1,
															},{
																xtype:'container',
																id: 'ProtocolLineChartLegendId',
																width:250,
																height:230,
																autoScroll:true,
																border:false,
																margin:'20 0 10 10',
																style:{'border':'0px solid red'},
															}],
															listeners:{
																"boxready": function(ProtocolLineChartId) {
																	var tmp =  netflowLastLoadedURL.substring(netflowLastLoadedURL.indexOf("&interfaceToView=")+17);
																	var liveMeasHtml = "";													
																	var dataSetObj = jsonData['DataSet'];
																	liveMeasHtml += '<table width="100%" ><tr><td>';
																	for ( var dObj in dataSetObj) 
																	{
																		var seriesObj = dataSetObj[dObj];
																		if (seriesObj != null && seriesObj.hasOwnProperty('dispLegend')) 
																		{
																			var legndName = seriesObj['dispLegend'];
																			var measVal = seriesObj['measVal'];
																			if(measVal!=null && measVal!="NA")
																			{
																				var layerModelUrl = seriesObj['layerModelUrl'];
																				var legndColor=seriesObj['color'];
																				var unitForMeas=seriesObj['unit'];
																				var legend_store = legndName;
																				if(legend_store.length > 25){
																					var legndName = legndName.substr(0,24)+'...';
																				}
																				if(legndName!=null && legndName!="-" && measVal!=null && measVal!="-")
																				{
																					liveMeasHtml += '<div style="float:left;width:8px;height:8px;margin:5px 4px;background:'+legndColor+';"></div>';
																					liveMeasHtml += '<div style="float:left;width:150px;height;20px;margin:2px;" ><a href=\'javascript:wayToLayerModelForArea("' + encodeURIComponent(layerModelUrl) + '")\'><span class="status font_normal10" data-qtip="'+legend_store+'">'+legndName+'</span></a>';
																				}
																				liveMeasHtml+='</div>';
																				if(measVal!=null && measVal!="-" )
																				{
																					liveMeasHtml += '<div style="float:left;width:60px;height;20px;margin:2px;" class="font_normal10" data-qtip="'+legend_store+'&nbsp('+unitForMeas+')&nbsp&nbsp'+measVal+'"><a href=\'javascript:wayToLayerModelForArea("' + encodeURIComponent(layerModelUrl) + '")\'>'+measVal+'</a></div>';	
																				}
																				liveMeasHtml+='<div style="clear:both"></div>';
																			}
																		}
																	}
																	liveMeasHtml += '<div style="clear:both" class="font_normal9">* All values are in percentage(%) </div></td></tr></table>';

																	Ext.defer(function(){
																		Ext.getCmp('ProtocolLineChartLegendId').update(liveMeasHtml);	
																	},250);
																	var timelineVal = protocolTimeline.valueField;	
																	var tmpHeight = ProtocolLineChartId.getHeight()-50 ;
																	if(timelineVal == undefined || timelineVal == "undefined" || timelineVal == ''){
																		tmpHeight = ProtocolLineChartId.getHeight()-20;
																	}
																	else {
																		if((timelineVal.indexOf("hour")>-1 || timelineVal.indexOf("mins")>-1) && (timelineVal=="24 hours" == false)){
																			tmpHeight = ProtocolLineChartId.getHeight()-20;
																		}
																	}
																	try {			
																		var lineChart = {};
																		lineChart = jQuery.extend(true, {}, getHighCharts("ProtocolLineChartId", tmpHeight, ProtocolLineChartId.getWidth()-330, this.maxURL,false), lineChart);
																		lineChart.setData(ProtocolLineChartId.lineData, currentDateFormat, this.maxURL, true, 'right');
																		lineChart.drawChart();
																	} catch (e) {
																		console.log("exception in highchart method::" + e)
																	}                                  
																},
																"resize": function(ProtocolLineChartId) {
																	try {			
																		var lineChart = {};
																		var timelineVal = protocolTimeline.valueField;	
																		var tmpHeight = ProtocolLineChartId.getHeight()-50 ;
																		if(timelineVal == undefined || timelineVal == "undefined"){
																			tmpHeight = ProtocolLineChartId.getHeight()-20;
																		}
																		else {
																			if((timelineVal.indexOf("hour")>-1 || timelineVal.indexOf("mins")>-1) && (timelineVal=="24 hours" == false)){
																			tmpHeight = ProtocolLineChartId.getHeight()-20;
																			}
																		}
																		
																		lineChart = jQuery.extend(true, {}, getHighCharts("ProtocolLineChartId", tmpHeight, ProtocolLineChartId.getWidth()-330, this.maxURL,false), lineChart);
																		lineChart.setData(ProtocolLineChartId.lineData, currentDateFormat, this.maxURL, true, 'right');
																		lineChart.drawChart();
																	} catch (e) {
																		console.log("exception in highchart method::" + e)
																	}
																}
															},
															tools: [{ 
																xtype: 'button',
																iconCls: 'iconMaximize',
																lineData: jsonData,
																margin:'0 0 0 20',
																style:{'background':'transparent','border':'none'},
																listeners:{
																	'afterrender': function () {
																		Ext.create('Ext.tip.ToolTip', {
																			target: this.id,
																			anchor: 'top',
																			cls: 'yellowTip',
																			trackMouse: true,
																			html:maximizeViewLbl
																		});
																	}
																},
																handler: function()
																{
																	var maxWindow = Ext.create('utilities.GenericWindow',
																	{
																		xtype:'panel',
																		title:TITLE,
																		lineData:this.lineData,
																		width: '90%',
																		height: '90%',
																		cssMask:true,
																		padding:'5 10 10 10',
																		id:'idForGettingWidthProtocol',
																		resizable   : false,
																		draggable   : true,
																		closeAction: 'destroy',
																		scroll:true,
																		layout:{
																			type:'fit',
																			pack:'center',
																			align:'center'
																		},
																		items:[{
																			xtype:'panel',
																			layout:{
																				type:'vbox',
																				align:'center',
																				pack:'start'
																			},
																			columnWidth:1,
																			items:[{
																				xtype:'container',
																				id: 'maxviewProtocolLineChartLegendId',
																				height:60,
																				autoScroll:true,
																				border:true,
																				layout:'fit',
																				margin:'10 20 10 10',
																			},{
																				xtype:'container',
																				id: 'maxviewProtocolLineChartId',
																				margin:10,
																			}],
																			tbar:[{
																				xtype: 'container',
																				layout:{
																					type:'hbox',
																					pack:'center',
																					align:'center'
																				},
																				flex:1,
																				height:70,
																				defaults: {
																					labelAlign: 'top',
																				},
																				margin:'10 10 0 10',
																				items: [{
																					xtype: 'timeline',
																					cls:'timeline_left',
																					id: 'protocolTimelineNetflow',
																					name: 'protocolTimelineNetflow',
																					margin:'10 0 0 10',
																					hidden: false,
																					hideMinutes : false,
																					layout:{
																						type:'hbox',
																						pack:'center',
																						align:'center'
																					},
																				},{
																					xtype:'button',
																					text:'Submit',
																					margin:'31 0 0 10',
																					text:"SUBMIT",
																					cls:"button20",
																					width:60,
																					id:"protocolSubmitNetflow",
																					name:"protocolSubmitNetflow",
																					listeners: {
																						"click": function(maxlineChartId) {
																							var tmpImgURL = lineChartURL.substring(0,lineChartURL.indexOf("&Timeline"));
																							var timeline = Ext.getCmp("er_timeline").getValue();
																							var startDate = Ext.getCmp("er_stdate").getValue();
																							var startHr = Ext.getCmp("er_sthr").getValue();
																							var startMin = Ext.getCmp("er_stmin").getValue();
																							var endDate = Ext.getCmp("er_enddate").getValue();
																							var endHr = Ext.getCmp("er_endhr").getValue();
																							var endMin = Ext.getCmp("er_endmin").getValue();
																							if(timeline == "Any"){
																								startDate=Ext.Date.dateFormat(startDate,"m/d/Y");
																								endDate=Ext.Date.dateFormat(endDate,"m/d/Y");
																							}
																							else{
																								startDate=Ext.Date.dateFormat(startDate,"m/d/Y");
																								endDate=Ext.Date.dateFormat(endDate,"m/d/Y");
																							}
																							var timelineVal = timeline;	
																							if(timeline == "30 mins"){
																								timeline = "Any";
																							}
																							tmpImgURL = tmpImgURL + "&Timeline="+timeline+"&TimePeriod="+encodeURIComponent(startDate+" "+startHr+":"+startMin+"|"+endDate+" "+endHr+":"+endMin);
																							tmpImgURL = tmpImgURL + lineChartURL.substring(lineChartURL.indexOf("&components"));
																							Ext.Ajax.request({
																								url: tmpImgURL,
																								scope: this,
																								async: false,
																								success: function (response)
																								{
																									if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
																									{
																										var tmpJsonTxt = response.responseText;
																										if ( tmpJsonTxt.indexOf('png') == -1 && tmpJsonTxt.indexOf('PNG') == -1 && tmpJsonTxt.indexOf('gif') == -1 && tmpJsonTxt.indexOf('GIF') == -1 && (tmpJsonTxt.indexOf('iconExclamation') == -1 || tmpJsonTxt.indexOf('iconInformation') == -1))
																										{
																											var tmpJsonData = Ext.decode(tmpJsonTxt);
																											
																											if(tmpJsonData!=null && tmpJsonData.hasOwnProperty('DataSet'))
																											{
																												var liveMeasHtml = "";
																												var dataSetObj = tmpJsonData['DataSet'];
																												liveMeasHtml += '<table width="600px"><tr><td width="100%">';
																												for ( var dObj in dataSetObj) 
																												{
																													liveMeasHtml += '<div style="float:left;margin-right:10px">';
																													var seriesObj = dataSetObj[dObj];
																													if (seriesObj != null && seriesObj.hasOwnProperty('dispLegend')) 
																													{
																														var legndName = seriesObj['dispLegend'];
																														var measVal = seriesObj['measVal'];
																														if(measVal!=null && measVal!="NA")
																														{
																															var layerModelUrl = seriesObj['layerModelUrl'];
																															var legndColor=seriesObj['color'];
																															var unitForMeas=seriesObj['unit'];
																															var legend_store = legndName;
																															if(legend_store.length > 25){
																																var legndName = legndName.substr(0,22)+'...';
																															}
																															if(legndName!=null && legndName!="-" && measVal!=null && measVal!="-")
																															{
																																liveMeasHtml += '<div style="float:left;width:8px;height:8px;margin:5px 4px;background:'+legndColor+';"></div>';
																															
																																liveMeasHtml += '<div style="float:left;width:150px;height;20px;margin:2px 10px 2px 2px;" ><a href=\'javascript:wayToLayerModelForArea("' + encodeURIComponent(layerModelUrl) + '")\'><span class="status font_normal10" data-qtip="'+legend_store+'">'+legndName+'</span></a>';
																															}
																															liveMeasHtml+='</div>';
																															if(measVal!=null && measVal!="-" )
																															{
																																liveMeasHtml += '<div style="float:left;width:60px;height;20px;margin:2px;" class="font_normal10" data-qtip="'+legend_store+'&nbsp('+unitForMeas+')&nbsp&nbsp'+measVal+'"><a href=\'javascript:wayToLayerModelForArea("' + encodeURIComponent(layerModelUrl) + '")\'>'+measVal+'</a></div>';
																															}
																														}
																													}
																													liveMeasHtml+='</div>';
																												}
																												liveMeasHtml += '<div style="clear:both" class="font_normal9">* All values are in percentage(%) </div></td></tr></table>';

																												Ext.defer(function(){
																													Ext.getCmp('maxviewProtocolLineChartLegendId').update(liveMeasHtml);
																													Ext.getCmp('maxviewProtocolLineChartLegendId').addCls('linesquare');
																												},250);
																												
																												var chartContainer = "maxviewProtocolLineChartId";
																												var getIdForSetGraphWH = Ext.get('idForGettingWidthProtocol');
																												var tmpHeight = getIdForSetGraphWH.getHeight()-230 ;
																																			
																												if(timelineVal == undefined || timelineVal == "undefined" || timelineVal == ''){
																													tmpHeight = getIdForSetGraphWH.getHeight()-200 ;
																												}
																												else {
																													if((timelineVal.indexOf("hour")>-1 || timelineVal.indexOf("mins")>-1) && (timelineVal=="24 hours" == false)){
																													tmpHeight = getIdForSetGraphWH.getHeight()-200 ;
																													}
																												}
																												try {
																													var lineChart = {};
																													lineChart = jQuery.extend(true, {}, getHighCharts(chartContainer, tmpHeight, getIdForSetGraphWH.getWidth()-100, this.maxURL,false), lineChart);
																													lineChart.setData(tmpJsonData, currentDateFormat, '', true, 'center');
																													lineChart.drawChart();

																												}catch (e) {
																													console.log("exception in highchart method::" + e)
																												}
																											}
																											else{
																												Ext.getCmp('maxviewProtocolLineChartLegendId').update('');
																												var getIdForSetGraphWH = Ext.get('idForGettingWidthProtocol');
																												Ext.getCmp('maxviewProtocolLineChartLegendId').removeCls('linesquare');
																												var tmpHeight = getIdForSetGraphWH.getHeight()-230 ;
																												Ext.getCmp('maxviewProtocolLineChartId').setHeight(tmpHeight);
																												Ext.getCmp('maxviewProtocolLineChartId').update('<div style="margin-top:85px;"><table width="100%" height="100%"><tr><td valign="middle" align="center"><div class="iconInformation" ></div><div style="font-size:12px">'+noMeasure+'! </div></td></tr></table></div>');	
																											}
																										}
																										else{
																											Ext.getCmp('maxviewProtocolLineChartLegendId').update('');
																											var getIdForSetGraphWH = Ext.get('idForGettingWidthProtocol');
																											Ext.getCmp('maxviewProtocolLineChartLegendId').removeCls('linesquare');
																											var tmpHeight = getIdForSetGraphWH.getHeight()-230 ;
																											Ext.getCmp('maxviewProtocolLineChartId').setHeight(tmpHeight);
																											Ext.getCmp('maxviewProtocolLineChartId').update('<div style="margin-top:85px;"><table width="100%" height="100%"><tr><td valign="middle" align="center"><div class="iconInformation" ></div><div style="font-size:12px">'+noMeasure+'! </div></td></tr></table></div>');	
																										}
																									}
																								}
																							});
																						}
																					},
																				}]
																			}],
																		}],
																		listeners: {
																			"boxready": function(maxlineChartId) {
																				Ext.getCmp("er_timeline").getStore().loadRawData(protocolTimelineComboArray);
																				var selectedTimeline = protocolSelectedTimelineCombo;
																				var timeline = selectedTimeline[0];
																				if(timeline == "Any"){
																					Ext.getCmp("er_timeline").setValue(timeline);
																					Ext.getCmp("er_stdate").setValue(selectedTimeline[1].anyStartDate);
																				
																					Ext.getCmp("er_sthr").setValue(selectedTimeline[1].anyStartHr);
																					Ext.getCmp("er_stmin").setValue(selectedTimeline[1].anyStartMin);
																					Ext.getCmp("er_enddate").setValue(selectedTimeline[1].anyEndDate);
																					Ext.getCmp("er_endhr").setValue(selectedTimeline[1].anyEndHr);
																					Ext.getCmp("er_endmin").setValue(selectedTimeline[1].anyEndMin);
																				}
																				else {
																					Ext.getCmp("er_timeline").setValue(timeline);
																					Ext.getCmp('er_timeline').fireEvent('select',Ext.getCmp('er_timeline'));
																				}
																				
																				var liveMeasHtml = "";
																				var dataSetObj = jsonData['DataSet'];
																				liveMeasHtml += '<table width="660px"><tr><td width="100%">';
																				for ( var dObj in dataSetObj) 
																				{
																					liveMeasHtml += '<div style="float:left;margin-right:30px">';
																					var seriesObj = dataSetObj[dObj];
																					if (seriesObj != null && seriesObj.hasOwnProperty('dispLegend')) 
																					{
																						var legndName = seriesObj['dispLegend'];
																						var measVal = seriesObj['measVal'];
																						if(measVal!=null && measVal!="NA")
																						{
																							var layerModelUrl = seriesObj['layerModelUrl'];
																							var legndColor=seriesObj['color'];
																							var unitForMeas=seriesObj['unit'];
																							var legend_store = legndName;
																							if(legend_store.length > 25){
																								var legndName = legndName.substr(0,22)+'...';
																							}
																							if(legndName!=null && legndName!="-" && measVal!=null && measVal!="-")
																							{
																								liveMeasHtml += '<div style="float:left;width:8px;height:8px;margin:5px 4px;background:'+legndColor+';"></div>';
																							
																								liveMeasHtml += '<div style="float:left;width:150px;height;20px;margin:2px 10px 2px 2px;" ><a href=\'javascript:wayToLayerModelForArea("' + encodeURIComponent(layerModelUrl) + '")\'><span class="status font_normal10" data-qtip="'+legend_store+'">'+legndName+'</span></a>';
																							}
																							liveMeasHtml+='</div>';
																							if(measVal!=null && measVal!="-" )
																							{
																								liveMeasHtml += '<div style="float:left;width:60px;height;20px;margin:2px;" class="font_normal10" data-qtip="'+legend_store+'&nbsp('+unitForMeas+')&nbsp&nbsp'+measVal+'"><a href=\'javascript:wayToLayerModelForArea("' + encodeURIComponent(layerModelUrl) + '")\'>'+measVal+'</a></div>';
																							}
																						}
																					}
																					liveMeasHtml+='</div>';
																				}
																				liveMeasHtml += '<div style="clear:both" class="font_normal9">* All values are in percentage(%) </div></td></tr></table>';

																				Ext.defer(function(){
																					Ext.getCmp('maxviewProtocolLineChartLegendId').update(liveMeasHtml);
																					Ext.getCmp('maxviewProtocolLineChartLegendId').addCls('linesquare');
																										
																				},250);
																				
																				var chartContainer = "maxviewProtocolLineChartId";
																				var getIdForSetGraphWH = Ext.get('idForGettingWidthProtocol');
																				var tmpHeight = getIdForSetGraphWH.getHeight()-230 ;
																				var timelineVal = timeline;								
																				if(timelineVal == undefined || timelineVal == "undefined" || timelineVal == ''){
																					tmpHeight = getIdForSetGraphWH.getHeight()-200 ;
																				}
																				else {
																					if((timelineVal.indexOf("hour")>-1 || timelineVal.indexOf("mins")>-1) && (timelineVal=="24 hours" == false)){
																					tmpHeight = getIdForSetGraphWH.getHeight()-200 ;
																					}
																				}
																				try {
																					var lineChart = {};
																					lineChart = jQuery.extend(true, {}, getHighCharts(chartContainer, tmpHeight, getIdForSetGraphWH.getWidth()-100, this.maxURL,false), lineChart);
																					lineChart.setData(maxlineChartId.lineData, currentDateFormat, '', true, 'center');
																					lineChart.drawChart();

																				}catch (e) {
																					console.log("exception in highchart method::" + e)
																				}
																			},
																			"resize": function(maxlineChartId) {
																				var chartContainer = "maxviewProtocolLineChartId";
																				var getIdForSetGraphWH = Ext.get('idForGettingWidthProtocol');
																				var tmpHeight = getIdForSetGraphWH.getHeight()-230 ;
																				var timelineVal = protocolSelectedTimelineCombo[0];								
																				if(timelineVal == undefined || timelineVal == "undefined" || timelineVal == ''){
																					tmpHeight = getIdForSetGraphWH.getHeight()-200 ;
																				}
																				else {
																					if((timelineVal.indexOf("hour")>-1 || timelineVal.indexOf("mins")>-1) && (timelineVal=="24 hours" == false)){
																					tmpHeight = getIdForSetGraphWH.getHeight()-200 ;
																					}
																				}
																				try {
																					var lineChart = {};
																					lineChart = jQuery.extend(true, {}, getHighCharts(chartContainer, tmpHeight, getIdForSetGraphWH.getWidth()-100, this.maxURL,false), lineChart);
																					lineChart.setData(maxlineChartId.lineData, currentDateFormat, '', true, 'center');
																					lineChart.drawChart();

																				}catch (e) {
																					console.log("exception in highchart method::" + e)
																				}
									
																			}
																		},
																		autoScroll: true,
																		bodyStyle:{'overflow-y': 'auto'},
																	}
																	).show();
																}
															}]
														}
													}
													else
													{
														protocolLineChart = {
														xtype: 'panel',
														border: false,
														frame: false,
														height:200,
														margin:'0 10 10 10',
														padding: 0,
														title:bandwidthAppLbl,
														ui:'egGraphPanel',
														layout:{
															type:'fit',
															align:'stretch',
														},
														items:[{
															xtype:'container',
															html:'<table width="100%" height="100%"><tr><td valign="middle" align="center"><div class="iconInformation" ></div><div >'+noMeasure+'!</div></td></tr></table>' 
														}]
													}
													}
												}
												else
												{
													protocolLineChart = {
														xtype: 'panel',
														border: false,
														frame: false,
														margin:'0 10 10 10',
														padding: 0,
														height:200,
														title:bandwidthAppLbl,
														ui:'egGraphPanel',
														layout:{
															type:'fit',
															align:'stretch',
														},
														items:[{
															xtype:'container',
															html:'<table width="100%" height="100%" border="0"><tr><td valign="middle" align="center"><div class="iconInformation" ></div><div style="font-size:12px">'+noMeasure+'!</div></td></tr></table>' 
														}]
													}
												}
											}
										},
										failure: function(response)
										{
											console.log(response);
										}
									});
								}
								catch (e) 
								{
									console.log("exception in loading charts::" + e)
								}
							}
							else
							{
								protocolLineChart = {
									xtype: 'panel',
									border: false,
									frame: false,
									padding: 0,
									height:200,
									title:bandwidthAppLbl,
									ui:'egGraphPanel',
									margin:'0 10 10 10',
									layout:{
										type:'fit',
										align:'stretch',
									},
									items:[{
										xtype:'container',
										html:'<table width="100%" height="100%"><tr><td valign="middle" align="center"><div class="iconInformation" ></div><div >'+noMeasure+'!</div></td></tr></table>' 
									}]
								} 				
							}
						}
					}
				}
			});
			if(dataAvailable == "true")
			{
				if(showTimelineChart) {
					panelItems = {
						autoScroll: true,
						scroll: true,
						layout: {
							type: 'auto',
						},
						flex:1,
						items:[
						{
							xtype: 'panel',
							flex:1,
							layout: {
								type: 'vbox',
								pack: 'start',
								align:'stretch'
							},
							defaults:{
								margin:10,
							},
							items: [
								pieChartPanel,
								protocolGridPanel,
								protocolLineChart
							]
						}]
					};
				}
				else
				{
					panelItems = {
						autoScroll: true,
						scroll: true,
						style:{
							//'border':'2px solid red',
						},
						border:true,
						flex:1,
						layout: {
							type: 'vbox',
							pack: 'start',
							align:'stretch'
						},
						defaults:{
							margin:5,
						},
						items: [
							pieChartPanel,
							protocolGridPanel
						]
					};
				}
			}
			else {
				NoMeasure = NOMSG;
				if (NoMeasure=='undefined' || NoMeasure == undefined)
				{
					NoMeasure = noMeasure +"!";
				}
				var getHeightForNoMeasures = Ext.getBody().getHeight()-100;
				panelItems = {
					autoScroll: false,
					scroll: false,
					height:getHeightForNoMeasures,
					layout: {
						type: 'fit',
						align: 'stretch'
					},
					scroll: false,
					autoScroll: false,
					flex:1,
					items:[
					{
						xtype: 'panel',
						scroll: false,
						autoScroll: false,
						flex:1,
						layout:{
							type:'fit',
							align:'stretch',
						},
						defaults:{
							margin:0,
						},
						items:[{
							xtype:'container',
							html:'<table width="100%" height="100%"><tr><td valign="middle" align="center"><div class="iconInformation" ></div><div>'+NoMeasure+'</div></td></tr></table>' 
						}]
					}]
				}; 
			}
		}
		else if (activeTab == "topsources") 
		{
			var flowsUrl = newCard.DataURL;
			var interafceLastSelected = localStorage.getItem("interfaceLastSelectedView");
			if(interafceLastSelected!=null && !Ext.isEmpty(interafceLastSelected))
			{
				interfaceSelectedView = interafceLastSelected;
			}
			var showSelectedView = localStorage.getItem("showLastSelectedView");
			if(showSelectedView!=null && !Ext.isEmpty(showSelectedView))
			{
				showVal = showSelectedView;
			}   
			var timelinetSelectedView = localStorage.getItem("timelineLastSelectedView");
			if(timelinetSelectedView!=null && !Ext.isEmpty(timelinetSelectedView))
			{
				globalTimeline = timelinetSelectedView;
			} 
			if(interfaceSelectedView != null){
				if(flowsUrl!=null && flowsUrl.indexOf("interfaceToView")>0)
				{
					flowsUrl = flowsUrl.replace(/(interfaceToView=)[^\&]+/, '$1' + encodeURIComponent(interfaceSelectedView));				
				}
				else
				{
					flowsUrl = flowsUrl+"&interfaceToView="+encodeURIComponent(interfaceSelectedView);
				}
				if(flowsUrl!=null && flowsUrl.indexOf("infosToArea")>0)
				{
					flowsUrl = flowsUrl.replace(/(infosToArea=)[^\&]+/, '$1' + interfaceSelectedView);
				}
				else
				{
					flowsUrl = flowsUrl+"&infosToArea="+encodeURIComponent(interfaceSelectedView);
				}
			}
			if(showVal != null){
				if(flowsUrl.indexOf("show") > -1)
				{
					flowsUrl = flowsUrl.replace(/(show=)[^\&]+/, '$1' + encodeURIComponent(showVal));
				}
				else
				{
					
					flowsUrl += '&show='+encodeURIComponent(showVal);
				}
			}
			if(globalTimeline != null){
				if(flowsUrl.indexOf("selectedTimeline") > -1)
				{
					flowsUrl = flowsUrl.replace(/(selectedTimeline=)[^\&]+/, '$1' + encodeURIComponent(globalTimeline));
				}
				else
				{
					
					flowsUrl += '&selectedTimeline='+encodeURIComponent(globalTimeline);
				}
				if(flowsUrl.indexOf("timeline") > -1)
				{
					flowsUrl = flowsUrl.replace(/(timeline=)[^\&]+/, '$1' + encodeURIComponent(globalTimeline));
				}
				else
				{
					
					flowsUrl += '&timeline='+encodeURIComponent(globalTimeline);
				}
			}
			netflowLastLoadedURL = flowsUrl;
			if(netflowLastLoadedURL!=null && netflowLastLoadedURL.indexOf("&ciscoSelectedType=")>0)
			{
				netflowLastLoadedURL = netflowLastLoadedURL.replace(/(ciscoSelectedType=)[^\&]+/, '$1' + 'flows');
			}
			else
			{
				netflowLastLoadedURL=netflowLastLoadedURL+'&ciscoSelectedType=flows';
			}
		
			var getHeightForNoMeasures = Ext.getBody().getHeight()-100;
			var topSourcesPieChart = [];
			var topSourcesPieChartPanel = '';
			var topSourcesGridPanel = '';		
			var queryParams='';
			var tmpURL = '';
			if(flowsUrl!=null && flowsUrl.indexOf("?")>-1)
			{
				tmpURL = flowsUrl.substr(0,flowsUrl.indexOf("?"));
				queryParams=flowsUrl.substr(flowsUrl.indexOf("?")+1);
			}
			Ext.Ajax.request({
				url: tmpURL,
				params:queryParams+'&flowsTest=TopSourceTest',
				method : 'POST',
				scope: this,
				async: false,
				success: function (response)
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						var jsonText = response.responseText;
						var jsonData = Ext.decode(jsonText);
						var timelineCombo = jsonData['timelineCombo'];
						var selectedTimelineCombo = timelineCombo['selectedTimelineCombo'];
						var timelineComboArray = timelineCombo['timelineComboArray'];
						var TimelineComboLabel = timelineCombo['monitor.dashboard.TimeLine'];
						var flowsInterfaceCombo = jsonData['flowsInterfaceCombo'];	
						var flowsInterfaceSelectedCombo = jsonData['flowsInterfaceSelectedCombo'];
						var showCombo = jsonData['showCombo'];
						var eventsPerPageCombo = jsonData['eventsPerPageCombo'];
						var fromView = jsonData['fromView'];
						var eventsPerPageArray = '';
						var selectedEventsPerPage = '';
						var showComboArray = "";
						var selectedShowCombo = "";
						var topsourceData ="";
						var errorMsg ="";
						if(jsonData['flowsPieArr']!=null && jsonData['flowsPieArr'].length>0)
						{
							topsourceData = jsonData['flowsPieArr'][0]['DATA_0'];
							dataAvailable = topsourceData['Data'];
							errorMsg = topsourceData['ErrorMsg'];
						}
						if(fromView!=null && fromView =='SummaryView')
						{
							dataAvailable = jsonData['Data'];
						}
						var timelineTitle = jsonData['timelineTitle'];
						if(timelineTitle!=null)
						{
							newCard.timelineTitle = timelineTitle;
						}

						var pieChartData = jsonData['pieChart'];						
						if(pieChartData!=null){
							NOMSG = pieChartData[0]['NOMSG'];
						}
						var pieTitle = jsonData['pieTitle'];

						newCard.timelineComboArray =timelineComboArray;
						newCard.selectedTimelineCombo = selectedTimelineCombo;
						if(flowsInterfaceCombo!=null)
						{
							newCard.flowsInterfaceCombo = flowsInterfaceCombo;
							newCard.flowsInterfaceSelectedCombo = flowsInterfaceSelectedCombo;
						}
						if(showCombo != null){
							showComboArray = showCombo['showComboArray'];
							selectedShowCombo = showCombo['selectedShowCombo'];
							newCard.showComboArray = showComboArray;
							newCard.selectedShowCombo = selectedShowCombo;
						}
						if(eventsPerPageCombo != null){
							eventsPerPageArray=eventsPerPageCombo['eventsPerPageArray']; 
							selectedEventsPerPage=eventsPerPageCombo['selectedEventsPerPage'];
							newCard.eventsPerPageArray = eventsPerPageArray;
							newCard.selectedEventsPerPage = selectedEventsPerPage;
						}
						this.addNetflowTabtoolbar(newCard);
						var isfromInterfaceComboChange = jsonData['isfromInterfaceComboChange'];
						var isInterfaceCountExceeded = jsonData['isInterfaceCountExceeded'];
						if(dataAvailable!=null && dataAvailable=='true')
						{
							if(fromView!=null && fromView =='SummaryView' && isInterfaceCountExceeded)
							{
								var piePanel = '';
								if(!Ext.isEmpty(NOMSG))
								{
									piePanel = {
										xtype:'panel',
										flex:.5,
										height:300,
										margin:5,
										layout:{
											type:'fit',
										},
										ui:'egGraphPanel',
										title:pieTitle,
										items:[
											{
												xtype:'container',
												html:'<table width="100%" height="100%"><tr><td valign="middle" align="center"><div class="iconInformation" ></div><div >'+NOMSG+'</div></td></tr></table>' 
											}
										]
									}
								}
								else
								{
									piePanel = {
										xtype:'panel',
										flex:.5,
										height:300,
										margin:5,
										ui:'egGraphPanel',
										title:pieTitle,
										id:'topSourcepiechart',
										pieChartData:pieChartData,
										listeners:
										{
											afterrender:function(){
												var me = this;
												if(!Ext.isEmpty(me.pieChartData)){													
													try {
														var barChart = {};
														barChart = jQuery.extend(true, {}, getPieChartsforNetflow('topSourcepiechart-body', '290', '600'), barChart);
														barChart.setData(me.pieChartData[0]['XML_DATA'], currentDateFormat, '', 'ProtocolPieNetflow');
														barChart.drawChart();
													} catch (barChartEx) {
														console.log(barChartEx);
													}
													$(window).resize(function(){
														if(Ext.isEmpty(NOMSG)){
															if($("#"+"topSourcepiechart-body").highcharts() != undefined)
															{
																$("#"+"topSourcepiechart-body").highcharts().reflow();
															}
														}
													});
												}
											}
										}
									};
								}
								
								var barchartPanel = '';
								var barData = jsonData['comparisonCharts'];
								if(!Ext.isEmpty(barData['NoMeasure']))
								{
									barchartPanel = {
										xtype:'panel',
										flex:.5,
										height:300,
										margin:5,
										layout:{
											type:'fit',
										},
										ui:'egGraphPanel',
										title:jsonData['barTitle'],
										items:[
											{
												xtype:'container',
												html:'<table width="100%" height="100%"><tr><td valign="middle" align="center"><div class="iconInformation" ></div><div >'+barData['NoMeasure']+'</div></td></tr></table>' 
											}
										]																			
									};
								}
								else
								{
									barchartPanel = {
										xtype:'panel',
										flex:.5,
										height:300,
										margin:5,
										ui:'egGraphPanel',
										title:jsonData['barTitle'],
										id:'topSourcebarGraphPanel',
										barData:barData,
										listeners:
										{
											afterrender:function(){
												var me = this;
												if(!Ext.isEmpty(me.barData)){													
													try
													{
														var barChart = {};
														barChart = jQuery.extend(true, {}, getHighChartsBarInstance('topSourcebarGraphPanel-body',270,600),barChart);
														barChart.setData(me.barData['XML_DATA'], currentDateFormat, '','netflowconversationbar');
														barChart.drawChart();
													}
													catch (barChartEx)
													{
														console.log(barChartEx);
													}
												}
											}
										}										
									};
								}								
								
								var topSourceGridPanel = '';
								var tableData = jsonData['tableData'];
								var topSourceTableColumns = tableData['tableColumns'];
								var gridValues = tableData['tableValues'];
								if(gridValues!=null && gridValues.length>0)
								{									
									var columnArr = new Array();
									var fieldModel = new Array();
									var columns = new Array();
									var colIdx = 0;
									for (var key in topSourceTableColumns) { 
										fieldModel.push({
											name: 'COLUMVal_' + colIdx,
											type: 'FLOATORSTRING'
										});
										columns.push({
											header: topSourceTableColumns[key],
											dataIndex: 'COLUMVal_' + colIdx,
											align: 'left',
											flex: 1,
											sortable: true,
											renderer: function(value, metaData, record, row, col, store, gridView)
											{
												var column = gridView.getHeaderAtIndex(col);
												var dataIndexVal = column.dataIndex;
												return value;
											}
										});
										colIdx++;
									}
									var ackStore = Ext.data.Store({
										fields: fieldModel,
										data: gridValues,
										sortOnLoad : true,
										/*sorters : {
											property : 'COLUMVal_1',
											direction : 'DESC'
										}*/
									});
									topSourceGridPanel = {
										xtype: 'grid',
										id: 'gridDisplay',
										store: ackStore,
										height: 290,
										margin:'0 10 10 10',
										title: jsonData['TABLE_TITLE'],//tableData['TABLE_TITLE'],
										cls: 'gridSkin',
										header:{
											style:{
												'padding':'2px 10px 0px 10px' 
											}
										},
										columns: columns,
										tools: [	{
											xtype:'tbfill',
										},
										{
											xtype: 'trigger',
											trigger1Cls: 'x-form-clear-trigger',
											trigger2Cls: 'x-form-search-trigger',
											name: 'gridSearch',
											margin: '0 10 2 10',
											id: 'gridSearch',
											cls: 'whitedropdown_search',
											emptyText: 'Search',
											labelAlign: 'top',
											width: 200,
											hidden: false,
											getTriggerMarkup: function() {
												var me = this,
													i = 0,
													hideTrigger = (me.readOnly || me.hideTrigger),
													triggerCls,
													triggerBaseCls = me.triggerBaseCls,
													triggerConfigs = [],
													unselectableCls = Ext.dom.Element.unselectableCls,
													style = 'width:' + me.triggerWidth + 'px;' + (hideTrigger ? 'display:none;' : ''),
													cls = me.extraTriggerCls + ' ' + Ext.baseCSSPrefix + 'trigger-cell ' + unselectableCls;

												// TODO this trigger<n>Cls API design doesn't feel clean, especially where it butts up against the
												// single triggerCls config. Should rethink this, perhaps something more structured like a list of
												// trigger config objects that hold cls, handler, etc.
												// triggerCls is a synonym for trigger1Cls, so copy it.
												if (!me.trigger1Cls) {
													me.trigger1Cls = me.triggerCls;
												}
												for (i = 0; (triggerCls = me['trigger' + (i + 1) + 'Cls']) || i < 1; i++) {
													if (i == 0)
													{
														triggerConfigs.push({
															tag: 'td',
															role: 'presentation',
															valign: 'top',
															cls: cls,
															id : 'MyTrigger_'+i,
															style: style + "display:none;",
															cn: {
																cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
																role: 'presentation'
															}
														});
													}
													else
													{
														triggerConfigs.push({
															tag: 'td',
															role: 'presentation',
															valign: 'top',
															cls: cls,
															id : 'MyTrigger_'+i,
															style: style,
															cn: {
																cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
																role: 'presentation'
															}
														});
													}
												}
												triggerConfigs[0].cn.cls += ' ' + triggerBaseCls + '-first';
												return Ext.DomHelper.markup(triggerConfigs);
											},
											onTrigger1Click: function () {
											this.reset();
											},
											onTrigger2Click : function() {
												appCnt.textFieldSearch();
											},
										},{ 
											xtype: 'button',
											iconCls: 'iconMaximize',
											style:{'background':'transparent','border':'none'},
											listeners:{
												'afterrender': function () {
														Ext.create('Ext.tip.ToolTip', {
															target: this.id,
															anchor: 'top',
															cls: 'yellowTip',
															trackMouse: true,
															html:"Maximize View"
														});
													}
											},
											handler: function()
											{
												var ackMaxStore = Ext.create('Ext.data.Store',{
													fields: fieldModel,
													pageSize: gridPageSize,
													autoLoad: true,
													proxy: {
														type: 'ajax',
														url: netflowLastLoadedURL+"&tab=Top sources&flowsTest=TopSourceTest&isFromGridPage=true",
														reader: {
															type: 'json',
															root : 'gridValues',
															page:'page',
															start:'start',
															limit:'limit',
															totalProperty : 'totalCount'
														}
													},
													listeners: {
														load: function(store, records, successful, eOpts) {
															var configPanl = Ext.getCmp('netflowmainpanel');
															if (successful) {
																configPanl.setLoading(false, false);
																						
															}else{
																configPanl.setLoading(true, true);
															}
														}
													}
												});	
												var bbar;
												ackMaxStore.on("load", function(component, records) {					
													var storeLength = ackMaxStore.data.length;
													var currentPageSize = ackMaxStore.pageSize;
													var currentTotalCount = ackMaxStore.totalCount;
													var currentPage ='';
													if(ackMaxStore.proxy.reader.rawData != null)
													{
														currentPage = ackMaxStore.proxy.reader.rawData.page;
													}
													var pageSize = ackMaxStore.pageSize;
													var totalpages = currentTotalCount/pageSize;
													totalpages = totalpages.toString();
													if(totalpages.indexOf('.') >-1)
													{
														totalpages = parseInt(totalpages);
														totalpages = totalpages +1;

													}else{
														totalpages = parseInt(totalpages);
													}

													if(currentPage > totalpages)
													{
														currentPage = totalpages;
														//store.loadPage(currentPage);
														configPanl.setLoading(true, true);
														
													}										  

													if((currentTotalCount-storeLength) == 0 ||  (currentPage == 1 && currentTotalCount <= currentPageSize) )
													{
														Ext.getCmp('maxPagingtoolbar').hide();
													}else{
														Ext.getCmp('maxPagingtoolbar').show();
													}
												});
												var gridMaxView = Ext.create('utilities.GenericWindow',
												{
													title:jsonData['TABLE_TITLE'],
													width: '90%',
													height: '90%',
													cssMask:true,
													padding:'5 10 10 10',
													resizable   : false,
													draggable   : true,
													closeAction: 'destroy',
													layout:'fit',
													scroll:true,
													border:false,
													items:{
														xtype:'grid',
														store: ackMaxStore,
														columns: columns,
														layout:'fit',
														cls: 'gridSkin',
														bbar: new Ext.PagingToolbar({
															store:ackMaxStore,
															id:'maxPagingtoolbar',
															cls:"pagingtoolbar",
															pageSize:gridPageSize,
															displayInfo: true,
															displayMsg:"Displaying {0} - {1} of {2}",
															listeners:{
																beforechange:function(){
																	var searchTextBoxObj=Ext.getCmp('gridSearch');
																	if(searchTextBoxObj != null)
																	 {
																		var searchValue = searchTextBoxObj.value ;
																		if(searchValue != '')
																		{
																			var grid = Ext.getCmp('gridDisplay');
																			if(grid != '')
																			{
																				grid.store.filters.clear();
																			}
																			searchTextBoxObj.reset();
																		}
																	 }
																}
															}
														}),
													},
													bodyStyle:{'overflow-y': 'auto'},
												}).show();
											}
										}]
									}
								}
								else
								{
									topSourceGridPanel = {
										xtype:'panel',
										height: 220,
										margin:'0 10 10 10',
										layout:{
											type:'fit',
										},
										ui:'egGraphPanel',
										title: jsonData['TABLE_TITLE'],//tableData['TABLE_TITLE'],
										items:[
											{
												xtype:'container',
												html:'<table width="100%" height="100%"><tr><td valign="middle" align="center"><div class="iconInformation" ></div><div >'+noMeasureExcl+'</div></td></tr></table>' 
											}
										]				
									}
								}

								pieChartPanel = {
									xtype:'panel',
									tab:'Protocols',
									header:false,
									margin:5,
									layout:{
										type:'hbox',
										align:'stretch',
									},
									flex:1,
									items:[
										piePanel,
										barchartPanel
									]
								};

								panelItems = {
									autoScroll: false,
									scroll: false,
									layout: {
										type: 'fit',
										align: 'stretch'
									},
									items:[
									{
										xtype: 'panel',
										scroll: true,
										autoScroll: false,
										layout: {
											type: 'auto',
											pack: 'start',
											align: 'stretch'
										},
										flex: 1,
										defaults:{
											margin:10,
										},
										items: [
											pieChartPanel,
											topSourceGridPanel
										]
									}]
								};
							}
							else if(isfromInterfaceComboChange)
							{
								var pieChartTitle = topsourceData['PIE_TITLE'];
								//pieChartTitle += " - "+flowsInterfaceSelectedCombo;
								var pieChartData = topsourceData['pieChart'];
								if(pieChartTitle.length > 110){
									pieChartTitle = pieChartTitle.substr(0,105)+'...';
								}
								var piePanel = '';
								if(!Ext.isEmpty(NOMSG))
								{
									piePanel = {
										xtype:'panel',
										flex:.5,
										height:300,
										margin:5,
										layout:{
											type:'fit',
										},
										ui:'egGraphPanel',
										title:pieChartTitle,
										items:[
											{
												xtype:'container',
												html:'<table width="100%" height="100%"><tr><td valign="middle" align="center"><div class="iconInformation" ></div><div >'+NOMSG+'</div></td></tr></table>' 
											}
										]
									}
								}
								else
								{
									piePanel = {
										xtype:'panel',
										flex:.5,
										height:300,
										margin:5,
										ui:'egGraphPanel',
										title:pieChartTitle,
										id:'topSourcepiechart',
										pieChartData:pieChartData,
										listeners:
										{
											afterrender:function(){
												var me = this;
												if(!Ext.isEmpty(me.pieChartData)){													
													try {
														var barChart = {};
														barChart = jQuery.extend(true, {}, getPieChartsforNetflow('topSourcepiechart-body', '290', '460'), barChart);
														barChart.setData(me.pieChartData[0]['XML_DATA'], currentDateFormat, '', 'ProtocolPieNetflow');
														barChart.drawChart();
													} catch (barChartEx) {
														console.log(barChartEx);
													}
													$(window).resize(function(){
														if(Ext.isEmpty(NOMSG)){
															if($("#"+"topSourcepiechart-body").highcharts() != undefined)
															{
																$("#"+"topSourcepiechart-body").highcharts().reflow();
															}
														}
													});
												}
											}
										}
									};
								}
								
								var barchartPanel = '';
								var barData = jsonData['comparisonCharts'];
								if(!Ext.isEmpty(barData['NoMeasure']))
								{
									barchartPanel = {
										xtype:'panel',
										flex:.5,
										height:300,
										margin:5,
										layout:{
											type:'fit',
										},
										ui:'egGraphPanel',
										title:jsonData['barTitle'],
										items:[
											{
												xtype:'container',
												html:'<table width="100%" height="100%"><tr><td valign="middle" align="center"><div class="iconInformation" ></div><div >'+barData['NoMeasure']+'</div></td></tr></table>' 
											}
										]																			
									};
								}
								else
								{
									barchartPanel = {
										xtype:'panel',
										flex:.5,
										height:300,
										margin:5,
										ui:'egGraphPanel',
										title:jsonData['barTitle'],
										id:'topSourcebarGraphPanel',
										barData:barData,
										listeners:
										{
											afterrender:function(){
												var me = this;
												if(!Ext.isEmpty(me.barData)){													
													try
													{
														var barChart = {};
														barChart = jQuery.extend(true, {}, getHighChartsBarInstance('topSourcebarGraphPanel-body',270,600),barChart);
														barChart.setData(me.barData['XML_DATA'], currentDateFormat, '','netflowconversationbar');
														barChart.drawChart();
													}
													catch (barChartEx)
													{
														console.log(barChartEx);
													}
												}
											}
										}										
									};
								}
								pieChartPanel = {
									xtype:'panel',
									tab:'Protocols',
									header:false,
									margin:5,
									layout:{
										type:'hbox',
										align:'stretch',
									},
									flex:1,
									items:[
										piePanel,
										barchartPanel
									]
								};
								var tableData = topsourceData['tableData'];
								var tableTitle = tableData[0]['TABLE_TITLE'];
								//tableTitle += " - "+flowsInterfaceSelectedCombo;
								var tableColumns = tableData[0]['tableColumns'];
								var gridValues = tableData[0]['gridValues'];

								var fieldModel = new Array();
								var columns = new Array();
								var colIdx = 0;
								for (var key in tableColumns) {
										fieldModel.push({
										name: 'COLUMVal_' + colIdx,
										type: 'string'
									});
									columns.push({
										header: tableColumns[key],
										dataIndex: 'COLUMVal_' + colIdx,
										align: 'left',
										flex: 1,
										sortable: true,
										renderer: function(value, metaData, record, row, col, store, gridView)
										{
											var column = gridView.getHeaderAtIndex(col);
											var dataIndexVal = column.dataIndex;
											if (dataIndexVal != null && dataIndexVal == "COLUMVal_5") 
											{
												if(value!=null && value!="-")
												{
													if(value>0.0)
													{
														var barStr = '<table width="100%" cellpadding="0" cellspacing="0" border="0"  height="8" class="prog_border">';
														barStr += '<tr>';
														barStr += '<td align="left" width="100%" height="8" >';
														barStr += '<table width="' + value + '%" height="8"  cellpadding="0" cellspacing="0" border="0">';
														barStr += '<tr>';
														barStr += '<td class="progress_GOOD" width="100%"> </td>';
														barStr += '</tr>';
														barStr += '</table>';
														barStr += '</td>';
														barStr += '</tr>';
														barStr += '</table>';

														value = "<table width='100%' cellpadding='0' cellspacing='0'><tr><td style='width:50px'><span>" + value
														+ "</span></td><td >" + barStr + "</td></tr></table>";
													}
												}
											}
											return value;
										}
									});
									colIdx++;
								}
								var gridPageSize;
								if(selectedEventsPerPage == undefined || selectedEventsPerPage == 'undefined'){
									gridPageSize = parseInt(eventsPerPageArray[0].valueField);
								} else{
									gridPageSize = parseInt(selectedEventsPerPage);
								}
								var queryParams='';
								var tmpURL = '';
								var qryParamsObj={};
								if(netflowLastLoadedURL!=null && netflowLastLoadedURL.indexOf("?")>-1)
								{
									tmpURL = netflowLastLoadedURL.substr(0,netflowLastLoadedURL.indexOf("?"));
									queryParams=netflowLastLoadedURL.substr(netflowLastLoadedURL.indexOf("?")+1);
									if(!Ext.isEmpty(queryParams))
									{
										var queryParamsArr=queryParams.split('&');
										for(var q in queryParamsArr)
										{
											var reqParam=queryParamsArr[q];
											if(reqParam!=null && reqParam.indexOf("=")>-1)
											{
												var reqKey=reqParam.substr(0,reqParam.indexOf("="));
												var reqvalue=reqParam.substr(reqParam.indexOf("=")+1);
												if(reqKey.toLowerCase()=='timeline')
												{
													reqvalue=reqvalue.replace(/\+/g, '%20');
												}
												qryParamsObj[reqKey]=decodeURIComponent(reqvalue);
											}
										}
										qryParamsObj['isFromGridPage']='true';
										qryParamsObj['flowsTest']='TopSourceTest';									
									}
								}
								var ackStore = Ext.create('Ext.data.Store',{
									fields: fieldModel,
									pageSize: gridPageSize,
									autoLoad: true,
									proxy: {
										type: 'ajax',
									actionMethods:  {
										create: "POST",
										read: "POST",
										update: "POST",
										destroy: "POST"
									},
									url: tmpURL,
									extraParams : qryParamsObj,
										reader: {
											type: 'json',
											root : 'gridValues',
											page:'page',
											start:'start',
											limit:'limit',
											totalProperty : 'totalCount'
										}
									},
									listeners: {
										load: function(store, records, successful, eOpts) {
											var configPanl = Ext.getCmp('netflowmainpanel');
											if (successful) {
													configPanl.setLoading(false, false);
																			
											}else{
												configPanl.setLoading(true, true);
											}
										}
									}
								});
								var bbar;
								ackStore.on("load", function(component, records) {					
									var storeLength = ackStore.data.length;
									var currentPageSize = ackStore.pageSize;
									var currentTotalCount = ackStore.totalCount;
									var currentPage ='';
									if(ackStore.proxy.reader.rawData != null)
									{
										currentPage = ackStore.proxy.reader.rawData.page;
									}
									var pageSize = ackStore.pageSize;
									var totalpages = currentTotalCount/pageSize;
									totalpages = totalpages.toString();
									if(totalpages.indexOf('.') >-1)
									{
										totalpages = parseInt(totalpages);
										totalpages = totalpages +1;

									}else{
										totalpages = parseInt(totalpages);
									}
								
									if(currentPage > totalpages)
									{
										currentPage = totalpages;
										//store.loadPage(currentPage);
										configPanl.setLoading(true, true);
										
									}										  

									if((currentTotalCount-storeLength) == 0 ||  (currentPage == 1 && currentTotalCount <= currentPageSize) )
									{
										Ext.getCmp('pagingtoolbar').hide();
									}else{
										Ext.getCmp('pagingtoolbar').show();
									}
								});
								var gridHeight = Ext.getBody().getHeight()-390;
								if(gridHeight <350){
									gridHeight = 350;
								}
								topSourcesGridPanel = {
									xtype: 'grid',
									id: 'gridDisplay',
									store: ackStore,
									height: gridHeight,
									margin:'0 10 10 10',
									title: tableTitle,
									cls: 'gridSkin',
									header:{
										style:{
											'padding':'2px 10px 0px 10px' 
										}
									},
									columns: columns,
									bbar: new Ext.PagingToolbar({
										store:ackStore,
										id:'pagingtoolbar',
										cls:"pagingtoolbar",
										pageSize:gridPageSize,
										displayInfo: true,
										displayMsg:"Displaying {0} - {1} of {2}",
										listeners:{
											beforechange:function(){
												
												var searchTextBoxObj=Ext.getCmp('gridSearch');
													if(searchTextBoxObj != null)
													 {
														var searchValue = searchTextBoxObj.value ;
														if(searchValue != '')
														{
															var grid = Ext.getCmp('gridDisplay');
															if(grid != '')
															{
																grid.store.filters.clear();
															}
															searchTextBoxObj.reset();
														}
													 }
											}
										}
									}),
									tools: [{
									xtype:'tbfill',
								},
								{
									xtype: 'trigger',
									trigger1Cls: 'x-form-clear-trigger',
									trigger2Cls: 'x-form-search-trigger',
									name: 'gridSearch',
									margin: '0 10 2 10',
									id: 'gridSearch',
									cls: 'whitedropdown_search',
									emptyText: searchLbl,
									labelAlign: 'top',
									width: 200,
									hidden: false,
										getTriggerMarkup: function() {
											var me = this,
												i = 0,
												hideTrigger = (me.readOnly || me.hideTrigger),
												triggerCls,
												triggerBaseCls = me.triggerBaseCls,
												triggerConfigs = [],
												unselectableCls = Ext.dom.Element.unselectableCls,
												style = 'width:' + me.triggerWidth + 'px;' + (hideTrigger ? 'display:none;' : ''),
												cls = me.extraTriggerCls + ' ' + Ext.baseCSSPrefix + 'trigger-cell ' + unselectableCls;

											// TODO this trigger<n>Cls API design doesn't feel clean, especially where it butts up against the
											// single triggerCls config. Should rethink this, perhaps something more structured like a list of
											// trigger config objects that hold cls, handler, etc.
											// triggerCls is a synonym for trigger1Cls, so copy it.
											if (!me.trigger1Cls) {
												me.trigger1Cls = me.triggerCls;
											}

											// Create as many trigger elements as we have trigger<n>Cls configs, but always at least one
											for (i = 0; (triggerCls = me['trigger' + (i + 1) + 'Cls']) || i < 1; i++) {
												if (i == 0)
												{
													triggerConfigs.push({
														tag: 'td',
														role: 'presentation',
														valign: 'top',
														cls: cls,
														id : 'MyTrigger_'+i,
														style: style + "display:none;",
														cn: {
															cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
															role: 'presentation'
														}
													});
												}
												else
												{
													triggerConfigs.push({
														tag: 'td',
														role: 'presentation',
														valign: 'top',
														cls: cls,
														id : 'MyTrigger_'+i,
														style: style,
														cn: {
															cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
															role: 'presentation'
														}
													});
												}
											}
											triggerConfigs[0].cn.cls += ' ' + triggerBaseCls + '-first';
											return Ext.DomHelper.markup(triggerConfigs);
										},
										onTrigger1Click: function () {
										this.reset();
										},
										onTrigger2Click : function() {
											appCnt.textFieldSearch();
										},
										
									},{ 
										xtype: 'button',
										iconCls: 'iconMaximize',
										style:{'background':'transparent','border':'none'},
										listeners:{
											'afterrender': function () {
												Ext.create('Ext.tip.ToolTip', {
													target: this.id,
													anchor: 'top',
													cls: 'yellowTip',
													trackMouse: true,
													html:maximizeViewLbl
												});
											}
										},
										handler: function()
										{
											var ackMaxStore = Ext.create('Ext.data.Store',{
												fields: fieldModel,
												pageSize: gridPageSize,
												autoLoad: true,
												proxy: {
													type: 'ajax',
													url: netflowLastLoadedURL+"&flowsTest=TopSourceTest&isFromGridPage=true",
													reader: {
														type: 'json',
														root : 'gridValues',
														page:'page',
														start:'start',
														limit:'limit',
														totalProperty : 'totalCount'
													}
												},
												listeners: {
													load: function(store, records, successful, eOpts) {
														var configPanl = Ext.getCmp('netflowmainpanel');
														if (successful) {
																configPanl.setLoading(false, false);
																					
														}else{
															configPanl.setLoading(true, true);
														}
													}
												}
											});
											var bbar;
											ackMaxStore.on("load", function(component, records) {					
												var storeLength = ackMaxStore.data.length;
												var currentPageSize = ackMaxStore.pageSize;
												var currentTotalCount = ackMaxStore.totalCount;
												var currentPage ='';
												if(ackMaxStore.proxy.reader.rawData != null)
												{
													currentPage = ackMaxStore.proxy.reader.rawData.page;
												}
												var pageSize = ackMaxStore.pageSize;
												var totalpages = currentTotalCount/pageSize;
												totalpages = totalpages.toString();
												if(totalpages.indexOf('.') >-1)
												{
													totalpages = parseInt(totalpages);
													totalpages = totalpages +1;

												}else{
													totalpages = parseInt(totalpages);
												}

												if(currentPage > totalpages)
												{
													currentPage = totalpages;
													//store.loadPage(currentPage);
													configPanl.setLoading(true, true);
												
												}										  

												if((currentTotalCount-storeLength) == 0 ||  (currentPage == 1 && currentTotalCount <= currentPageSize) )
												{
													Ext.getCmp('maxPagingtoolbar').hide();
												}else{
													Ext.getCmp('maxPagingtoolbar').show();
												}
											});
											var gridMaxView = Ext.create('utilities.GenericWindow',
											{
												title:tableTitle,
												width: '90%',
												height: '90%',
												cssMask:true,
												padding:'5 10 10 10',
												resizable   : false,
												draggable   : true,
												closeAction: 'destroy',
												scroll:true,
												layout:'fit',
												border:false,
												items:{
													xtype:'grid',
													store: ackMaxStore,
													columns: columns,
													cls: 'gridSkin',
													layout:'fit',
													bbar: new Ext.PagingToolbar({
														store:ackMaxStore,
														id:'maxPagingtoolbar',
														cls:"pagingtoolbar",
														pageSize:gridPageSize,
														displayInfo: true,
														displayMsg:"Displaying {0} - {1} of {2}",
														listeners:{
															beforechange:function(){
																
																var searchTextBoxObj=Ext.getCmp('gridSearch');
																	if(searchTextBoxObj != null)
																	 {
																		var searchValue = searchTextBoxObj.value ;
																		if(searchValue != '')
																		{
																			var grid = Ext.getCmp('gridDisplay');
																			if(grid != '')
																			{
																				grid.store.filters.clear();
																			}
																			searchTextBoxObj.reset();
																		}
																	 }
															}
														}
													}),
												},
												autoScroll: true,
												bodyStyle:{'overflow-y': 'auto'},
											}).show();
										}
									}]
								}
								panelItems = {
									autoScroll: false,
									scroll: false,
									layout: {
										type: 'fit',
										align: 'stretch'
									},
									items:[
									{
										xtype: 'panel',
										scroll: true,
										autoScroll: false,
										layout: {
											type: 'auto',
											pack: 'start',
											align: 'stretch'
										},
										flex: 1,
										defaults:{
											margin:10,
										},
										items: [
											pieChartPanel,
											topSourcesGridPanel
										]
									}]
								};

							
							}
							else
							{
								var pieChartTitle = topsourceData['PIE_TITLE'];
								//pieChartTitle += " - "+flowsInterfaceSelectedCombo;
								var pieChartData = topsourceData['pieChart'];
								if(pieChartTitle.length > 110){
									pieChartTitle = pieChartTitle.substr(0,105)+'...';
								}
								var pieChartWidth = 400;
								if(pieChartData.length == 1)
									pieChartWidth = 950;
								var pieChartPanel = {
									xtype:'genericpiechartslider',
									template:function(){
										var me = this;
										var sliderItems={};
										if(Ext.isEmpty(NOMSG)){
											
										sliderItems = new Ext.XTemplate(
											'<ul>',
											'<tpl for=".">',
												'<li ><div  class="netFlowPieChartRightBorder" style="margin:5 auto 10px 0"><div style="text-align:center;margin:10px 5px 0px 5px;">{XML_DATA.title}</div><div id="chart2holder{#}"></div></div></li>',
											'</tpl>',
											'</ul>'
											
										 );
										}else{
											sliderItems = new Ext.XTemplate(
											'<ul>',
											'<li><table width="100%" height="200px"><tr><td valign="middle" align="center"><div class="iconInformation" ></div><div > '+noMeasureExcl+'</div></td></tr></table></li>',
											'</ul>'
											
										 );
										}
											return sliderItems;
									},
									data:pieChartData,
									loadChart:function(data){
										var me = this;
										if(!Ext.isEmpty(data)){
											var count =1;
											for (var key in data)
											{
												var counter = count++;
												try {
													var barChart = {};
													barChart = jQuery.extend(true, {}, getPieChartsforNetflow('chart2holder'+counter, 250, pieChartWidth), barChart);
													barChart.setData(data[key]['XML_DATA'], currentDateFormat, '', 'ProtocolPieNetflow');
													barChart.drawChart();
												} catch (barChartEx) {
													console.log(barChartEx);
												}
												$(window).resize(function(){
													if(Ext.isEmpty(NOMSG)){
														if($("#"+"chart2holder"+counter).highcharts() != undefined)
														{
															$("#"+"chart2holder"+counter).highcharts().reflow();
														}
													}
												});
											}
										}
									},
									tab:'topSource',
									title:pieChartTitle
								};
								var tableData = topsourceData['tableData'];
								var tableTitle = tableData[0]['TABLE_TITLE'];
								//tableTitle += " - "+flowsInterfaceSelectedCombo;
								var tableColumns = tableData[0]['tableColumns'];
								var gridValues = tableData[0]['gridValues'];

								var fieldModel = new Array();
								var columns = new Array();
								var colIdx = 0;
								for (var key in tableColumns) {
										fieldModel.push({
										name: 'COLUMVal_' + colIdx,
										type: 'string'
									});
									columns.push({
										header: tableColumns[key],
										dataIndex: 'COLUMVal_' + colIdx,
										align: 'left',
										flex: 1,
										sortable: true,
										renderer: function(value, metaData, record, row, col, store, gridView)
										{
											var column = gridView.getHeaderAtIndex(col);
											var dataIndexVal = column.dataIndex;
											if (dataIndexVal != null && dataIndexVal == "COLUMVal_5") 
											{
												if(value!=null && value!="-")
												{
													if(value>0.0)
													{
														var barStr = '<table width="100%" cellpadding="0" cellspacing="0" border="0"  height="8" class="prog_border">';
														barStr += '<tr>';
														barStr += '<td align="left" width="100%" height="8" >';
														barStr += '<table width="' + value + '%" height="8"  cellpadding="0" cellspacing="0" border="0">';
														barStr += '<tr>';
														barStr += '<td class="progress_GOOD" width="100%"> </td>';
														barStr += '</tr>';
														barStr += '</table>';
														barStr += '</td>';
														barStr += '</tr>';
														barStr += '</table>';

														value = "<table width='100%' cellpadding='0' cellspacing='0'><tr><td style='width:50px'><span>" + value
														+ "</span></td><td >" + barStr + "</td></tr></table>";
													}
												}
											}
											return value;
										}
									});
									colIdx++;
								}
								var gridPageSize;
								if(selectedEventsPerPage == undefined || selectedEventsPerPage == 'undefined'){
									gridPageSize = parseInt(eventsPerPageArray[0].valueField);
								} else{
									gridPageSize = parseInt(selectedEventsPerPage);
								}
								var queryParams='';
								var tmpURL = '';
								var qryParamsObj={};
								if(netflowLastLoadedURL!=null && netflowLastLoadedURL.indexOf("?")>-1)
								{
									tmpURL = netflowLastLoadedURL.substr(0,netflowLastLoadedURL.indexOf("?"));
									queryParams=netflowLastLoadedURL.substr(netflowLastLoadedURL.indexOf("?")+1);
									if(!Ext.isEmpty(queryParams))
									{
										var queryParamsArr=queryParams.split('&');
										for(var q in queryParamsArr)
										{
											var reqParam=queryParamsArr[q];
											if(reqParam!=null && reqParam.indexOf("=")>-1)
											{
												var reqKey=reqParam.substr(0,reqParam.indexOf("="));
												var reqvalue=reqParam.substr(reqParam.indexOf("=")+1);
												if(reqKey.toLowerCase()=='timeline')
												{
													reqvalue=reqvalue.replace(/\+/g, '%20');
												}
												qryParamsObj[reqKey]=decodeURIComponent(reqvalue);
											}
										}
										qryParamsObj['isFromGridPage']='true';
										qryParamsObj['flowsTest']='TopSourceTest';									
									}
								}
								var ackStore = Ext.create('Ext.data.Store',{
									fields: fieldModel,
									pageSize: gridPageSize,
									autoLoad: true,
									proxy: {
										type: 'ajax',
									actionMethods:  {
										create: "POST",
										read: "POST",
										update: "POST",
										destroy: "POST"
									},
									url: tmpURL,
									extraParams : qryParamsObj,
										reader: {
											type: 'json',
											root : 'gridValues',
											page:'page',
											start:'start',
											limit:'limit',
											totalProperty : 'totalCount'
										}
									},
									listeners: {
										load: function(store, records, successful, eOpts) {
											var configPanl = Ext.getCmp('netflowmainpanel');
											if (successful) {
												configPanl.setLoading(false, false);
											}else{
												configPanl.setLoading(true, true);
											}
										}
									}
								});
								var bbar;
								ackStore.on("load", function(component, records) {					
									var storeLength = ackStore.data.length;
									var currentPageSize = ackStore.pageSize;
									var currentTotalCount = ackStore.totalCount;
									var currentPage ='';
									if(ackStore.proxy.reader.rawData != null)
									{
										currentPage = ackStore.proxy.reader.rawData.page;
									}
									var pageSize = ackStore.pageSize;
									var totalpages = currentTotalCount/pageSize;
									totalpages = totalpages.toString();
									if(totalpages.indexOf('.') >-1)
									{
										totalpages = parseInt(totalpages);
										totalpages = totalpages +1;
									}else{
										totalpages = parseInt(totalpages);
									}
									if(currentPage > totalpages)
									{
										currentPage = totalpages;
										configPanl.setLoading(true, true);
									}										  
									if((currentTotalCount-storeLength) == 0 ||  (currentPage == 1 && currentTotalCount <= currentPageSize) )
									{
										Ext.getCmp('pagingtoolbar').hide();
									}
									else
									{
										Ext.getCmp('pagingtoolbar').show();
									}
								});
								var gridHeight = Ext.getBody().getHeight()-390;
								if(gridHeight <350){
									gridHeight = 350;
								}
								topSourcesGridPanel = {
									xtype: 'grid',
									id: 'gridDisplay',
									store: ackStore,
									height: gridHeight,
									margin:'0 10 10 10',
									title: tableTitle,
									cls: 'gridSkin',
									header:{
										style:{
											'padding':'2px 10px 0px 10px' 
										}
									},
									columns: columns,
									bbar: new Ext.PagingToolbar({
										store:ackStore,
										id:'pagingtoolbar',
										cls:"pagingtoolbar",
										pageSize:gridPageSize,
										displayInfo: true,
										displayMsg:"Displaying {0} - {1} of {2}",
										listeners:{
											beforechange:function(){
												
												var searchTextBoxObj=Ext.getCmp('gridSearch');
													if(searchTextBoxObj != null)
													 {
														var searchValue = searchTextBoxObj.value ;
														if(searchValue != '')
														{
															var grid = Ext.getCmp('gridDisplay');
															if(grid != '')
															{
																grid.store.filters.clear();
															}
															searchTextBoxObj.reset();
														}
													 }
											}
										}
									}),
									tools: [{
										xtype:'tbfill',
									},
									{
										xtype: 'trigger',
										trigger1Cls: 'x-form-clear-trigger',
										trigger2Cls: 'x-form-search-trigger',
										name: 'gridSearch',
										margin: '0 10 2 10',
										id: 'gridSearch',
										cls: 'whitedropdown_search',
										emptyText: searchLbl,
										labelAlign: 'top',
										width: 200,
										hidden: false,
											getTriggerMarkup: function() {
											var me = this,
												i = 0,
												hideTrigger = (me.readOnly || me.hideTrigger),
												triggerCls,
												triggerBaseCls = me.triggerBaseCls,
												triggerConfigs = [],
												unselectableCls = Ext.dom.Element.unselectableCls,
												style = 'width:' + me.triggerWidth + 'px;' + (hideTrigger ? 'display:none;' : ''),
												cls = me.extraTriggerCls + ' ' + Ext.baseCSSPrefix + 'trigger-cell ' + unselectableCls;

											// TODO this trigger<n>Cls API design doesn't feel clean, especially where it butts up against the
											// single triggerCls config. Should rethink this, perhaps something more structured like a list of
											// trigger config objects that hold cls, handler, etc.
											// triggerCls is a synonym for trigger1Cls, so copy it.
											if (!me.trigger1Cls) {
												me.trigger1Cls = me.triggerCls;
											}

											// Create as many trigger elements as we have trigger<n>Cls configs, but always at least one
											for (i = 0; (triggerCls = me['trigger' + (i + 1) + 'Cls']) || i < 1; i++) {
												if (i == 0)
												{
													triggerConfigs.push({
														tag: 'td',
														role: 'presentation',
														valign: 'top',
														cls: cls,
														id : 'MyTrigger_'+i,
														style: style + "display:none;",
														cn: {
															cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
															role: 'presentation'
														}
													});
												}
												else
												{
													triggerConfigs.push({
														tag: 'td',
														role: 'presentation',
														valign: 'top',
														cls: cls,
														id : 'MyTrigger_'+i,
														style: style,
														cn: {
															cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
															role: 'presentation'
														}
													});
												}
											}
											triggerConfigs[0].cn.cls += ' ' + triggerBaseCls + '-first';
											return Ext.DomHelper.markup(triggerConfigs);
										},
										onTrigger1Click: function () {
										this.reset();
										},
										onTrigger2Click : function() {
											appCnt.textFieldSearch();
										},
										
									},{ 
										xtype: 'button',
										iconCls: 'iconMaximize',
										style:{'background':'transparent','border':'none'},
										listeners:{
											'afterrender': function () {
												Ext.create('Ext.tip.ToolTip', {
													target: this.id,
													anchor: 'top',
													cls: 'yellowTip',
													trackMouse: true,
													html:maximizeViewLbl
												});
											}
										},
										handler: function()
										{
											var ackMaxStore = Ext.create('Ext.data.Store',{
												fields: fieldModel,
												pageSize: gridPageSize,
												autoLoad: true,
												proxy: {
													type: 'ajax',
													url: netflowLastLoadedURL+"&tab=Top sources&flowsTest=TopSourceTest&isFromGridPage=true",
													reader: {
														type: 'json',
														root : 'gridValues',
														page:'page',
														start:'start',
														limit:'limit',
														totalProperty : 'totalCount'
													}
												},
												listeners: {
													load: function(store, records, successful, eOpts) {
														var configPanl = Ext.getCmp('netflowmainpanel');
														if (successful) {
																configPanl.setLoading(false, false);
																					
														}else{
															configPanl.setLoading(true, true);
														}
													}
												}
											});
											var bbar;
											ackMaxStore.on("load", function(component, records) {					
												var storeLength = ackMaxStore.data.length;
												var currentPageSize = ackMaxStore.pageSize;
												var currentTotalCount = ackMaxStore.totalCount;
												var currentPage ='';
												if(ackMaxStore.proxy.reader.rawData != null)
												{
													currentPage = ackMaxStore.proxy.reader.rawData.page;
												}
												var pageSize = ackMaxStore.pageSize;
												var totalpages = currentTotalCount/pageSize;
												totalpages = totalpages.toString();
												if(totalpages.indexOf('.') >-1)
												{
													totalpages = parseInt(totalpages);
													totalpages = totalpages +1;

												}else{
													totalpages = parseInt(totalpages);
												}
												if(currentPage > totalpages)
												{
													currentPage = totalpages;
													configPanl.setLoading(true, true);
												}										  
												if((currentTotalCount-storeLength) == 0 ||  (currentPage == 1 && currentTotalCount <= currentPageSize) )
												{
													Ext.getCmp('maxPagingtoolbar').hide();
												}else{
													Ext.getCmp('maxPagingtoolbar').show();
												}
											});
											var gridMaxView = Ext.create('utilities.GenericWindow',
											{
												title:tableTitle,
												width: '90%',
												height: '90%',
												cssMask:true,
												padding:'5 10 10 10',
												resizable   : false,
												draggable   : true,
												closeAction: 'destroy',
												scroll:true,
												layout:'fit',
												border:false,
												items:{
													xtype:'grid',
													store: ackMaxStore,
													columns: columns,
													cls: 'gridSkin',
													layout:'fit',
													bbar: new Ext.PagingToolbar({
														store:ackMaxStore,
														id:'maxPagingtoolbar',
														cls:"pagingtoolbar",
														pageSize:gridPageSize,
														displayInfo: true,
														displayMsg:"Displaying {0} - {1} of {2}",
														listeners:{
															beforechange:function(){
																var searchTextBoxObj=Ext.getCmp('gridSearch');
																if(searchTextBoxObj != null)
																 {
																	var searchValue = searchTextBoxObj.value ;
																	if(searchValue != '')
																	{
																		var grid = Ext.getCmp('gridDisplay');
																		if(grid != '')
																		{
																			grid.store.filters.clear();
																		}
																		searchTextBoxObj.reset();
																	}
																 }
															}
														}
													}),
												},
												autoScroll: true,
												bodyStyle:{'overflow-y': 'auto'},
											}).show();
										}
									}]
								}
								panelItems = {
									autoScroll: false,
									scroll: false,
									layout: {
										type: 'fit',
										align: 'stretch'
									},
									items:[
									{
										xtype: 'panel',
										scroll: true,
										autoScroll: false,
										layout: {
											type: 'auto',
											pack: 'start',
											align: 'stretch'
										},
										flex: 1,
										defaults:{
											margin:10,
										},
										items: [
											pieChartPanel,
											topSourcesGridPanel
										]
									}]
								};
							}
						}
						else
						{
							if (errorMsg=='undefined' || errorMsg == undefined || errorMsg == "")
							{
								errorMsg = NoMeasure +"!";
							}
							panelItems = {
								autoScroll: false,
								scroll: false,
								height:getHeightForNoMeasures,
								layout: {
									type: 'fit',
									align: 'stretch'
								},
								scroll: false,
								autoScroll: false,
								flex:1,
								items:[
								{
									xtype: 'panel',
									scroll: false,
									autoScroll: false,
									flex:1,
									layout:{
										type:'fit',
										align:'stretch',
									},
									defaults:{
										margin:0,
									},
									items:[{
										xtype:'container',
										html:'<table width="100%" height="100%"><tr><td valign="middle" align="center"><div class="iconInformation" ></div><div>'+errorMsg+'</div></td></tr></table>' 
									}]
								}]
							};  
						}
					}
				}
			});			
		}
		else if (activeTab == "topdestinations") 
		{
			var flowsUrl = newCard.DataURL;
			var interafceLastSelected = localStorage.getItem("interfaceLastSelectedView");
			if(interafceLastSelected!=null && !Ext.isEmpty(interafceLastSelected))
			{
				interfaceSelectedView = interafceLastSelected;
			}
			var showSelectedView = localStorage.getItem("showLastSelectedView");
			if(showSelectedView!=null && !Ext.isEmpty(showSelectedView))
			{
				showVal = showSelectedView;
			}   
			var timelinetSelectedView = localStorage.getItem("timelineLastSelectedView");
			if(timelinetSelectedView!=null && !Ext.isEmpty(timelinetSelectedView))
			{
				globalTimeline = timelinetSelectedView;
			} 
			if(interfaceSelectedView != null){
				if(flowsUrl!=null && flowsUrl.indexOf("interfaceToView")>0)
				{
					flowsUrl = flowsUrl.replace(/(interfaceToView=)[^\&]+/, '$1' + encodeURIComponent(interfaceSelectedView));				
				}
				else
				{
					flowsUrl = flowsUrl+"&interfaceToView="+encodeURIComponent(interfaceSelectedView);
				}
				if(flowsUrl!=null && flowsUrl.indexOf("infosToArea")>0)
				{
					flowsUrl = flowsUrl.replace(/(infosToArea=)[^\&]+/, '$1' + interfaceSelectedView);
				}
				else
				{
					flowsUrl = flowsUrl+"&infosToArea="+encodeURIComponent(interfaceSelectedView);
				}
			}
			if(showVal != null){
				if(flowsUrl.indexOf("show") > -1)
				{
					flowsUrl = flowsUrl.replace(/(show=)[^\&]+/, '$1' + encodeURIComponent(showVal));
				}
				else
				{
					
					flowsUrl += '&show='+encodeURIComponent(showVal);
				}
			}
			if(globalTimeline != null){
				if(flowsUrl.indexOf("selectedTimeline") > -1)
				{
					flowsUrl = flowsUrl.replace(/(selectedTimeline=)[^\&]+/, '$1' + encodeURIComponent(globalTimeline));
				}
				else
				{
					
					flowsUrl += '&selectedTimeline='+encodeURIComponent(globalTimeline);
				}
				if(flowsUrl.indexOf("timeline") > -1)
				{
					flowsUrl = flowsUrl.replace(/(timeline=)[^\&]+/, '$1' + encodeURIComponent(globalTimeline));
				}
				else
				{
					
					flowsUrl += '&timeline='+encodeURIComponent(globalTimeline);
				}
			}
			netflowLastLoadedURL = flowsUrl;
			if(netflowLastLoadedURL!=null && netflowLastLoadedURL.indexOf("&ciscoSelectedType=")>0)
			{
				netflowLastLoadedURL = netflowLastLoadedURL.replace(/(ciscoSelectedType=)[^\&]+/, '$1' + 'flows');
			}
			else
			{
				netflowLastLoadedURL=netflowLastLoadedURL+'&ciscoSelectedType=flows';
			}

			var getHeightForNoMeasures = Ext.getBody().getHeight()-100
			
			
			var topDestPieChart = [];
			var topDestPieChartPanel = '';
			var topDestGridPanel = '';
			var queryParams='';
			var tmpURL = '';
			if(flowsUrl!=null && flowsUrl.indexOf("?")>-1)
			{
				tmpURL = flowsUrl.substr(0,flowsUrl.indexOf("?"));
				queryParams=flowsUrl.substr(flowsUrl.indexOf("?")+1);
			}
			Ext.Ajax.request({
				url: tmpURL,
				method : 'POST',
				params: queryParams+'&flowsTest=TopDestTest',
				scope: this,
				async: false,
				success: function (response)
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						var jsonText = response.responseText;
						var jsonData = Ext.decode(jsonText);

						var timelineCombo = jsonData['timelineCombo'];
						var selectedTimelineCombo = timelineCombo['selectedTimelineCombo'];
						var timelineComboArray = timelineCombo['timelineComboArray'];
						var TimelineComboLabel = timelineCombo['monitor.dashboard.TimeLine'];
						var flowsInterfaceCombo = jsonData['flowsInterfaceCombo'];
						var showCombo = jsonData['showCombo'];
						var showComboArray = showCombo['showComboArray'];
						var selectedShowCombo = showCombo['selectedShowCombo'];
						var eventsPerPageCombo = jsonData['eventsPerPageCombo'];
						var eventsPerPageArray = '';
						var selectedEventsPerPage = '';
						var fromView = jsonData['fromView'];						
						var timelineTitle = jsonData['timelineTitle'];
						if(timelineTitle!=null)
						{
							newCard.timelineTitle = timelineTitle;
						}

						var pieChartData = jsonData['pieChart'];						
						if(pieChartData!=null){
							NOMSG = pieChartData[0]['NOMSG'];
						}
						var pieTitle = jsonData['pieTitle'];
						var topDestData = '';
						var dataAvailable = '';
						var errorMsg = '';
						if(jsonData['flowsPieArr']!=null && jsonData['flowsPieArr'].length>0)
						{
							topDestData = jsonData['flowsPieArr'][0]['DATA_0'];
							dataAvailable = topDestData['Data'];
							errorMsg = topDestData['ErrorMsg'];
						}
						if(fromView!=null && fromView =='SummaryView')
						{
							dataAvailable = jsonData['Data'];
						}

						var timelineTitle = jsonData['timelineTitle'];
						if(timelineTitle!=null)
						{
							newCard.timelineTitle = timelineTitle;
						}
						var flowsInterfaceSelectedCombo = jsonData['flowsInterfaceSelectedCombo'];
						newCard.timelineComboArray =timelineComboArray;
						newCard.selectedTimelineCombo = selectedTimelineCombo;
						if(flowsInterfaceCombo!=null)
						{
							newCard.flowsInterfaceCombo = flowsInterfaceCombo;
							newCard.flowsInterfaceSelectedCombo = flowsInterfaceSelectedCombo;
						}
						if(showCombo != null){
							newCard.showComboArray = showComboArray;
							newCard.selectedShowCombo = selectedShowCombo;
						}
						
						if(eventsPerPageCombo != null){
							eventsPerPageArray=eventsPerPageCombo['eventsPerPageArray']; 
							selectedEventsPerPage=eventsPerPageCombo['selectedEventsPerPage'];
							newCard.eventsPerPageArray = eventsPerPageArray;
							newCard.selectedEventsPerPage = selectedEventsPerPage;
						}
						var isfromInterfaceComboChange = jsonData['isfromInterfaceComboChange'];
						var isInterfaceCountExceeded = jsonData['isInterfaceCountExceeded'];
						this.addNetflowTabtoolbar(newCard);
						if(dataAvailable!=null && dataAvailable=='true')
						{	
							if(fromView!=null && fromView =='SummaryView' && isInterfaceCountExceeded)
							{
								var piePanel = '';
								if(!Ext.isEmpty(NOMSG))
								{
									piePanel = {
										xtype:'panel',
										flex:.5,
										height:300,
										margin:5,
										ui:'egGraphPanel',
										layout:{
											type:'fit',
										},
										title:pieTitle,
										items:[
											{
												xtype:'container',
												html:'<table width="100%" height="100%"><tr><td valign="middle" align="center"><div class="iconInformation" ></div><div >'+NOMSG+'</div></td></tr></table>' 
											}
										]
									}
								}
								else
								{
									piePanel = {
										xtype:'panel',
										flex:.5,
										height:300,
										margin:5,
										ui:'egGraphPanel',
										title:pieTitle,
										id:'topdestpiechart',
										pieChartData:pieChartData,
										listeners:
										{
											afterrender:function(){
												var me = this;
												if(!Ext.isEmpty(me.pieChartData)){													
													try {
														var barChart = {};
														barChart = jQuery.extend(true, {}, getPieChartsforNetflow('topdestpiechart-body', '290', '600'), barChart);
														barChart.setData(me.pieChartData[0]['XML_DATA'], currentDateFormat, '', 'ProtocolPieNetflow');
														barChart.drawChart();
													} catch (barChartEx) {
														console.log(barChartEx);
													}
													$(window).resize(function(){
														if(Ext.isEmpty(NOMSG)){
															if($("#"+"topdestpiechart-body").highcharts() != undefined)
															{
																$("#"+"topdestpiechart-body").highcharts().reflow();
															}
														}
													});
												}
											}
										}
									};
								}
								
								var barchartPanel = '';
								var barData = jsonData['comparisonCharts'];
								if(!Ext.isEmpty(barData['NoMeasure']))
								{
									barchartPanel = {
										xtype:'panel',
										flex:.5,
										height:300,
										margin:5,
										layout:{
											type:'fit',
										},
										ui:'egGraphPanel',
										title:jsonData['barTitle'],
										items:[
											{
												xtype:'container',
												html:'<table width="100%" height="100%"><tr><td valign="middle" align="center"><div class="iconInformation" ></div><div >'+barData['NoMeasure']+'</div></td></tr></table>' 
											}
										]																			
									};
								}
								else
								{
									barchartPanel = {
										xtype:'panel',
										flex:.5,
										height:300,
										margin:5,
										ui:'egGraphPanel',
										title:jsonData['barTitle'],
										id:'topdestbarGraphPanel',
										barData:barData,
										listeners:
										{
											afterrender:function(){
												var me = this;
												if(!Ext.isEmpty(me.barData)){													
													try
													{
														var barChart = {};
														barChart = jQuery.extend(true, {}, getHighChartsBarInstance('topdestbarGraphPanel-body',270,600),barChart);
														barChart.setData(me.barData['XML_DATA'], currentDateFormat, '','netflowconversationbar');
														barChart.drawChart();
													}
													catch (barChartEx)
													{
														console.log(barChartEx);
													}
												}
											}
										}										
									};
								}								
								
								var tableData = jsonData['tableData'];
								var topDestTableColumns = tableData['tableColumns'];
								var gridValues = tableData['tableValues'];
								if(gridValues!=null && gridValues.length>0)
								{
									var columnArr = new Array();
									var fieldModel = new Array();
									var columns = new Array();
									var colIdx = 0;
									for (var key in topDestTableColumns) { 
										fieldModel.push({
											name: 'COLUMVal_' + colIdx,
											type: 'FLOATORSTRING'
										});
										columns.push({
											header: topDestTableColumns[key],
											dataIndex: 'COLUMVal_' + colIdx,
											align: 'left',
											flex: 1,
											sortable: true,
											renderer: function(value, metaData, record, row, col, store, gridView)
											{
												var column = gridView.getHeaderAtIndex(col);
												var dataIndexVal = column.dataIndex;
												return value;
											}
										});
										colIdx++;
									}
									var ackStore = Ext.data.Store({
										fields: fieldModel,
										data: gridValues,
										/*sortOnLoad : true,
										sorters : {
											property : 'COLUMVal_1',
											direction : 'DESC'
										}*/
									});
									topDestGridPanel = {
										xtype: 'grid',
										id: 'gridDisplay',
										store: ackStore,
										height: 290,
										margin:'0 10 10 10',
										title: jsonData['TABLE_TITLE'],//tableData['TABLE_TITLE'],
										cls: 'gridSkin',
										header:{
											style:{
												'padding':'2px 10px 0px 10px' 
											}
										},
										columns: columns,
										tools: [	{
											xtype:'tbfill',
										},
										{
											xtype: 'trigger',
											trigger1Cls: 'x-form-clear-trigger',
											trigger2Cls: 'x-form-search-trigger',
											name: 'gridSearch',
											margin: '0 10 2 10',
											id: 'gridSearch',
											cls: 'whitedropdown_search',
											emptyText: 'Search',
											labelAlign: 'top',
											width: 200,
											hidden: false,
											getTriggerMarkup: function() {
												var me = this,
													i = 0,
													hideTrigger = (me.readOnly || me.hideTrigger),
													triggerCls,
													triggerBaseCls = me.triggerBaseCls,
													triggerConfigs = [],
													unselectableCls = Ext.dom.Element.unselectableCls,
													style = 'width:' + me.triggerWidth + 'px;' + (hideTrigger ? 'display:none;' : ''),
													cls = me.extraTriggerCls + ' ' + Ext.baseCSSPrefix + 'trigger-cell ' + unselectableCls;

												// TODO this trigger<n>Cls API design doesn't feel clean, especially where it butts up against the
												// single triggerCls config. Should rethink this, perhaps something more structured like a list of
												// trigger config objects that hold cls, handler, etc.
												// triggerCls is a synonym for trigger1Cls, so copy it.
												if (!me.trigger1Cls) {
													me.trigger1Cls = me.triggerCls;
												}
												for (i = 0; (triggerCls = me['trigger' + (i + 1) + 'Cls']) || i < 1; i++) {
													if (i == 0)
													{
														triggerConfigs.push({
															tag: 'td',
															role: 'presentation',
															valign: 'top',
															cls: cls,
															id : 'MyTrigger_'+i,
															style: style + "display:none;",
															cn: {
																cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
																role: 'presentation'
															}
														});
													}
													else
													{
														triggerConfigs.push({
															tag: 'td',
															role: 'presentation',
															valign: 'top',
															cls: cls,
															id : 'MyTrigger_'+i,
															style: style,
															cn: {
																cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
																role: 'presentation'
															}
														});
													}
												}
												triggerConfigs[0].cn.cls += ' ' + triggerBaseCls + '-first';
												return Ext.DomHelper.markup(triggerConfigs);
											},
											onTrigger1Click: function () {
											this.reset();
											},
											onTrigger2Click : function() {
												appCnt.textFieldSearch();
											},
										},{ 
											xtype: 'button',
											iconCls: 'iconMaximize',
											style:{'background':'transparent','border':'none'},
											listeners:{
												'afterrender': function () {
														Ext.create('Ext.tip.ToolTip', {
															target: this.id,
															anchor: 'top',
															cls: 'yellowTip',
															trackMouse: true,
															html:"Maximize View"
														});
													}
											},
											handler: function()
											{
												var ackMaxStore = Ext.create('Ext.data.Store',{
													fields: fieldModel,
													pageSize: gridPageSize,
													autoLoad: true,
													proxy: {
														type: 'ajax',
														url: netflowLastLoadedURL+"&tab=Top Destinations&flowsTest=TopDestTest&isFromGridPage=true",
														reader: {
															type: 'json',
															root : 'gridValues',
															page:'page',
															start:'start',
															limit:'limit',
															totalProperty : 'totalCount'
														}
													},
													listeners: {
														load: function(store, records, successful, eOpts) {
															var configPanl = Ext.getCmp('netflowmainpanel');
															if (successful) {
																configPanl.setLoading(false, false);
																						
															}else{
																configPanl.setLoading(true, true);
															}
														}
													}
												});	
												var bbar;
												ackMaxStore.on("load", function(component, records) {					
													var storeLength = ackMaxStore.data.length;
													var currentPageSize = ackMaxStore.pageSize;
													var currentTotalCount = ackMaxStore.totalCount;
													var currentPage ='';
													if(ackMaxStore.proxy.reader.rawData != null)
													{
														currentPage = ackMaxStore.proxy.reader.rawData.page;
													}
													var pageSize = ackMaxStore.pageSize;
													var totalpages = currentTotalCount/pageSize;
													totalpages = totalpages.toString();
													if(totalpages.indexOf('.') >-1)
													{
														totalpages = parseInt(totalpages);
														totalpages = totalpages +1;

													}else{
														totalpages = parseInt(totalpages);
													}

													if(currentPage > totalpages)
													{
														currentPage = totalpages;
														//store.loadPage(currentPage);
														configPanl.setLoading(true, true);
														
													}										  

													if((currentTotalCount-storeLength) == 0 ||  (currentPage == 1 && currentTotalCount <= currentPageSize) )
													{
														Ext.getCmp('maxPagingtoolbar').hide();
													}else{
														Ext.getCmp('maxPagingtoolbar').show();
													}
												});
												var gridMaxView = Ext.create('utilities.GenericWindow',
												{
													title:jsonData['TABLE_TITLE'],
													width: '90%',
													height: '90%',
													cssMask:true,
													padding:'5 10 10 10',
													resizable   : false,
													draggable   : true,
													closeAction: 'destroy',
													layout:'fit',
													scroll:true,
													border:false,
													items:{
														xtype:'grid',
														store: ackMaxStore,
														columns: columns,
														layout:'fit',
														cls: 'gridSkin',
														bbar: new Ext.PagingToolbar({
															store:ackMaxStore,
															id:'maxPagingtoolbar',
															cls:"pagingtoolbar",
															pageSize:gridPageSize,
															displayInfo: true,
															displayMsg:"Displaying {0} - {1} of {2}",
															listeners:{
																beforechange:function(){
																	var searchTextBoxObj=Ext.getCmp('gridSearch');
																	if(searchTextBoxObj != null)
																	 {
																		var searchValue = searchTextBoxObj.value ;
																		if(searchValue != '')
																		{
																			var grid = Ext.getCmp('gridDisplay');
																			if(grid != '')
																			{
																				grid.store.filters.clear();
																			}
																			searchTextBoxObj.reset();
																		}
																	 }
																}
															}
														}),
													},
													bodyStyle:{'overflow-y': 'auto'},
												}).show();
											}
										}]
									}
								}
								else
								{
									topDestGridPanel = {
										xtype:'panel',
										height: 220,
										margin:'0 10 10 10',
										layout:{
											type:'fit',
										},
										ui:'egGraphPanel',
										title: jsonData['TABLE_TITLE'],//tableData['TABLE_TITLE'],
										items:[
											{
												xtype:'container',
												html:'<table width="100%" height="100%"><tr><td valign="middle" align="center"><div class="iconInformation" ></div><div >'+noMeasureExcl+'</div></td></tr></table>' 
											}
										]
									};
								}

								pieChartPanel = {
									xtype:'panel',
									tab:'Protocols',
									header:false,
									margin:5,
									layout:{
										type:'hbox',
										align:'stretch',
									},
									flex:1,
									items:[
										piePanel,
										barchartPanel
									]
								};

								panelItems = {
									autoScroll: false,
									scroll: false,
									layout: {
										type: 'fit',
										align: 'stretch'
									},
									items:[
									{
										xtype: 'panel',
										scroll: true,
										autoScroll: false,
										layout: {
											type: 'auto',
											pack: 'start',
											align: 'stretch'
										},
										flex: 1,
										defaults:{
											margin:10,
										},
										items: [
											pieChartPanel,
											topDestGridPanel
										]
									}]
								};
							}
							else if(isfromInterfaceComboChange)
							{
								var pieChartTitle = topDestData['PIE_TITLE'];
								//pieChartTitle += " - "+flowsInterfaceSelectedCombo;
								var pieChartData = topDestData['pieChart'];
								if(pieChartTitle.length > 110){
									pieChartTitle = pieChartTitle.substr(0,105)+'...';
								}
								var piePanel = '';
								if(!Ext.isEmpty(NOMSG))
								{
									piePanel = {
										xtype:'panel',
										flex:.5,
										height:300,
										margin:5,
										ui:'egGraphPanel',
										layout:{
											type:'fit',
										},
										title:pieChartTitle,
										items:[
											{
												xtype:'container',
												html:'<table width="100%" height="100%"><tr><td valign="middle" align="center"><div class="iconInformation" ></div><div >'+NOMSG+'</div></td></tr></table>' 
											}
										]
									}
								}
								else
								{
									piePanel = {
										xtype:'panel',
										flex:.5,
										height:300,
										margin:5,
										ui:'egGraphPanel',
										title:pieChartTitle,
										id:'topdestpiechart',
										pieChartData:pieChartData,
										listeners:
										{
											afterrender:function(){
												var me = this;
												if(!Ext.isEmpty(me.pieChartData)){													
													try {
														var barChart = {};
														barChart = jQuery.extend(true, {}, getPieChartsforNetflow('topdestpiechart-body', '290', '460'), barChart);
														barChart.setData(me.pieChartData[0]['XML_DATA'], currentDateFormat, '', 'ProtocolPieNetflow');
														barChart.drawChart();
													} catch (barChartEx) {
														console.log(barChartEx);
													}
													$(window).resize(function(){
														if(Ext.isEmpty(NOMSG)){
															if($("#"+"topdestpiechart-body").highcharts() != undefined)
															{
																$("#"+"topdestpiechart-body").highcharts().reflow();
															}
														}
													});
												}
											}
										}
									};
								}
								
								var barchartPanel = '';
								var barData = jsonData['comparisonCharts'];
								if(!Ext.isEmpty(barData['NoMeasure']))
								{
									barchartPanel = {
										xtype:'panel',
										flex:.5,
										height:300,
										margin:5,
										layout:{
											type:'fit',
										},
										ui:'egGraphPanel',
										title:jsonData['barTitle'],
										items:[
											{
												xtype:'container',
												html:'<table width="100%" height="100%"><tr><td valign="middle" align="center"><div class="iconInformation" ></div><div >'+barData['NoMeasure']+'</div></td></tr></table>' 
											}
										]																			
									};
								}
								else
								{
									barchartPanel = {
										xtype:'panel',
										flex:.5,
										height:300,
										margin:5,
										ui:'egGraphPanel',
										title:jsonData['barTitle'],
										id:'topdestbarGraphPanel',
										barData:barData,
										listeners:
										{
											afterrender:function(){
												var me = this;
												if(!Ext.isEmpty(me.barData)){													
													try
													{
														var barChart = {};
														barChart = jQuery.extend(true, {}, getHighChartsBarInstance('topdestbarGraphPanel-body',270,600),barChart);
														barChart.setData(me.barData['XML_DATA'], currentDateFormat, '','netflowconversationbar');
														barChart.drawChart();
													}
													catch (barChartEx)
													{
														console.log(barChartEx);
													}
												}
											}
										}										
									};
								}
								pieChartPanel = {
									xtype:'panel',
									tab:'Protocols',
									header:false,
									margin:5,
									layout:{
										type:'hbox',
										align:'stretch',
									},
									flex:1,
									items:[
										piePanel,
										barchartPanel
									]
								};
								
								var tableData = topDestData['tableData'];
								var tableTitle = tableData[0]['TABLE_TITLE'];
								//tableTitle += " - "+flowsInterfaceSelectedCombo;
								var tableColumns = tableData[0]['tableColumns'];
								var gridValues = tableData[0]['gridValues'];
								var fieldModel = new Array();
								var columns = new Array();
								var colIdx = 0;
								for (var key in tableColumns) {
									fieldModel.push({
										name: 'COLUMVal_' + colIdx,
										type: 'string'
									});
									columns.push({
										header: tableColumns[key],
										dataIndex: 'COLUMVal_' + colIdx,
										align: 'left',
										flex: 1,
										sortable: true,
										renderer: function(value, metaData, record, row, col, store, gridView)
										{
											var column = gridView.getHeaderAtIndex(col);
											var dataIndexVal = column.dataIndex;
											if (dataIndexVal != null && dataIndexVal == "COLUMVal_5") 
											{
												if(value!=null && value!="-")
												{
													if(value>0.0)
													{
														var barStr = '<table width="100%" cellpadding="0" cellspacing="0" border="0"  height="8" class="prog_border">';
														barStr += '<tr>';
														barStr += '<td align="left" width="100%" height="8" >';
														barStr += '<table width="' + value + '%" height="8"  cellpadding="0" cellspacing="0" border="0">';
														barStr += '<tr>';
														barStr += '<td class="progress_GOOD" width="100%"> </td>';
														barStr += '</tr>';
														barStr += '</table>';
														barStr += '</td>';
														barStr += '</tr>';
														barStr += '</table>';

														value = "<table width='100%' cellpadding='0' cellspacing='0'><tr><td style='width:50px'><span>" + value
														+ "</span></td><td >" + barStr + "</td></tr></table>";
													}
												}
											}
											return value;
										}
									});
									colIdx++;
								}
								var gridPageSize;
								if(selectedEventsPerPage == undefined || selectedEventsPerPage == 'undefined'){
									gridPageSize = parseInt(eventsPerPageArray[0].valueField);
								} else{
									gridPageSize = parseInt(selectedEventsPerPage);
								}
								var queryParams='';
								var tmpURL = '';
								var qryParamsObj={};
								if(netflowLastLoadedURL!=null && netflowLastLoadedURL.indexOf("?")>-1)
								{
									tmpURL = netflowLastLoadedURL.substr(0,netflowLastLoadedURL.indexOf("?"));
									queryParams=netflowLastLoadedURL.substr(netflowLastLoadedURL.indexOf("?")+1);
									if(!Ext.isEmpty(queryParams))
									{
										var queryParamsArr=queryParams.split('&');									
										for(var q in queryParamsArr)
										{
											var reqParam=queryParamsArr[q];
											if(reqParam!=null && reqParam.indexOf("=")>-1)
											{
												var reqKey=reqParam.substr(0,reqParam.indexOf("="));
												var reqvalue=reqParam.substr(reqParam.indexOf("=")+1);
												if(reqKey.toLowerCase()=='timeline')
												{
													reqvalue=reqvalue.replace(/\+/g, '%20');
												}
												qryParamsObj[reqKey]=decodeURIComponent(reqvalue);
											}
										}
										qryParamsObj['isFromGridPage']='true';
										qryParamsObj['flowsTest']='TopDestTest';									
									}
								}
								var ackStore = Ext.create('Ext.data.Store',{
									fields: fieldModel,
									pageSize: gridPageSize,
									autoLoad: true,
									proxy: {
										type: 'ajax',
									actionMethods:  {
										create: "POST",
										read: "POST",
										update: "POST",
										destroy: "POST"
									},
									url: tmpURL,
									extraParams : qryParamsObj,									
										reader: {
											type: 'json',
											root : 'gridValues',
											page:'page',
											start:'start',
											limit:'limit',
											totalProperty : 'totalCount'
										}
									},
									listeners: {
										load: function(store, records, successful, eOpts) {
											var configPanl = Ext.getCmp('netflowmainpanel');
											if (successful) {
													configPanl.setLoading(false, false);
																		
											}else{
												configPanl.setLoading(true, true);
											}
										}
									}
								});
								var bbar;
								ackStore.on("load", function(component, records) {					
									var storeLength = ackStore.data.length;
									var currentPageSize = ackStore.pageSize;
									var currentTotalCount = ackStore.totalCount;
									var currentPage ='';
									if(ackStore.proxy.reader.rawData != null)
									{
										currentPage = ackStore.proxy.reader.rawData.page;
									}
									var pageSize = ackStore.pageSize;
									var totalpages = currentTotalCount/pageSize;
									totalpages = totalpages.toString();
									if(totalpages.indexOf('.') >-1)
									{
										totalpages = parseInt(totalpages);
										totalpages = totalpages +1;

									}else{
										totalpages = parseInt(totalpages);
									}

									if(currentPage > totalpages)
									{
										currentPage = totalpages;
										configPanl.setLoading(true, true);
										
									}										  

									if((currentTotalCount-storeLength) == 0 ||  (currentPage == 1 && currentTotalCount <= currentPageSize) )
									{
										Ext.getCmp('pagingtoolbar').hide();
									}else{
										Ext.getCmp('pagingtoolbar').show();
									}
								});
								var gridHeight = Ext.getBody().getHeight()-390;
								if(gridHeight <350){
									gridHeight = 350;
								}
								topDestGridPanel = {
									xtype: 'grid',
									store: ackStore,
									id:'gridDisplay',
									autoScroll: true,
									scroll: true,
									title: tableTitle,
									flex:1,
									height:gridHeight,
									cls: 'gridSkin',
									header:{
										style:{
											'padding':'2px 10px 0px 10px' 
										}
									},
									columns: columns,
									bbar: new Ext.PagingToolbar({
										store:ackStore,
										id:'pagingtoolbar',
										cls:"pagingtoolbar",
										pageSize:gridPageSize,
										displayInfo: true,
										displayMsg:"Displaying {0} - {1} of {2}",
										listeners:{
											beforechange:function(){
												var searchTextBoxObj=Ext.getCmp('gridSearch');
												if(searchTextBoxObj != null)
												 {
													var searchValue = searchTextBoxObj.value ;
													if(searchValue != '')
													{
														var grid = Ext.getCmp('gridDisplay');
														if(grid != '')
														{
															grid.store.filters.clear();
														}
														searchTextBoxObj.reset();
													}
												 }
											}
										}
									}),
									tools: [{
										xtype:'tbfill',
									},
									{
										xtype: 'trigger',
										trigger1Cls: 'x-form-clear-trigger',
										trigger2Cls: 'x-form-search-trigger',
										name: 'gridSearch',
										margin: '0 10 2 10',
										id: 'gridSearch',
										cls: 'whitedropdown_search',
										emptyText: searchLbl,
										labelAlign: 'top',
										width: 200,
										hidden: false,
										getTriggerMarkup: function() {
											var me = this,
												i = 0,
												hideTrigger = (me.readOnly || me.hideTrigger),
												triggerCls,
												triggerBaseCls = me.triggerBaseCls,
												triggerConfigs = [],
												unselectableCls = Ext.dom.Element.unselectableCls,
												style = 'width:' + me.triggerWidth + 'px;' + (hideTrigger ? 'display:none;' : ''),
												cls = me.extraTriggerCls + ' ' + Ext.baseCSSPrefix + 'trigger-cell ' + unselectableCls;

											// TODO this trigger<n>Cls API design doesn't feel clean, especially where it butts up against the
											// single triggerCls config. Should rethink this, perhaps something more structured like a list of
											// trigger config objects that hold cls, handler, etc.
											// triggerCls is a synonym for trigger1Cls, so copy it.
											if (!me.trigger1Cls) {
												me.trigger1Cls = me.triggerCls;
											}

											// Create as many trigger elements as we have trigger<n>Cls configs, but always at least one
											for (i = 0; (triggerCls = me['trigger' + (i + 1) + 'Cls']) || i < 1; i++) {
												if (i == 0)
												{
													triggerConfigs.push({
														tag: 'td',
														role: 'presentation',
														valign: 'top',
														cls: cls,
														id : 'MyTrigger_'+i,
														style: style + "display:none;",
														cn: {
															cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
															role: 'presentation'
														}
													});
												}
												else
												{
													triggerConfigs.push({
														tag: 'td',
														role: 'presentation',
														valign: 'top',
														cls: cls,
														id : 'MyTrigger_'+i,
														style: style,
														cn: {
															cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
															role: 'presentation'
														}
													});
												}
											}
											triggerConfigs[0].cn.cls += ' ' + triggerBaseCls + '-first';
											return Ext.DomHelper.markup(triggerConfigs);
										},
										onTrigger1Click: function () {
										this.reset();
										},
										onTrigger2Click : function() {
											appCnt.textFieldSearch();
										},
										
									},{ 
										xtype: 'button',
										iconCls: 'iconMaximize',
										style:{'background':'transparent','border':'none'},
										listeners:{
											'afterrender': function () {
													Ext.create('Ext.tip.ToolTip', {
														target: this.id,
														anchor: 'top',
														cls: 'yellowTip',
														trackMouse: true,
														html:maximizeViewLbl
													});
												}
										},
										handler: function()
										{
											var ackMaxStore = Ext.create('Ext.data.Store',{
												fields: fieldModel,
												pageSize: gridPageSize,
												autoLoad: true,
												proxy: {
													type: 'ajax',
													url: netflowLastLoadedURL+"&flowsTest=TopDestTest&isFromGridPage=true",
													reader: {
														type: 'json',
														root : 'gridValues',
														page:'page',
														start:'start',
														limit:'limit',
														totalProperty : 'totalCount'
													}
												},
												listeners: {
													load: function(store, records, successful, eOpts) {
														var configPanl = Ext.getCmp('netflowmainpanel');
														if (successful) {
																configPanl.setLoading(false, false);
																					
														}else{
															configPanl.setLoading(true, true);
														}
													}
												}
											});
											var bbar;
											ackMaxStore.on("load", function(component, records) {					
												var storeLength = ackMaxStore.data.length;
												var currentPageSize = ackMaxStore.pageSize;
												var currentTotalCount = ackMaxStore.totalCount;
												var currentPage ='';
												if(ackMaxStore.proxy.reader.rawData != null)
												{
													currentPage = ackMaxStore.proxy.reader.rawData.page;
												}
												var pageSize = ackMaxStore.pageSize;
												var totalpages = currentTotalCount/pageSize;
												totalpages = totalpages.toString();
												if(totalpages.indexOf('.') >-1)
												{
													totalpages = parseInt(totalpages);
													totalpages = totalpages +1;

												}else{
													totalpages = parseInt(totalpages);
												}
												if(currentPage > totalpages)
												{
													currentPage = totalpages;
													configPanl.setLoading(true, true);
												}										  
												if((currentTotalCount-storeLength) == 0 ||  (currentPage == 1 && currentTotalCount <= currentPageSize) )
												{
													Ext.getCmp('maxPagingtoolbar').hide();
												}else{
													Ext.getCmp('maxPagingtoolbar').show();
												}
											});
											var gridMaxView = Ext.create('utilities.GenericWindow',
											{
												title:tableTitle,
												width: '90%',
												height: '90%',
												cssMask:true,
												padding:'5 10 10 10',
												resizable   : false,
												draggable   : true,
												closeAction: 'destroy',
												scroll:true,
												layout:'fit',
												border:false,
												items:{
													xtype:'grid',
													store: ackMaxStore,
													columns: columns,
													cls: 'gridSkin',
													layout:'fit',
													 bbar: new Ext.PagingToolbar({
														store:ackMaxStore,
														id:'maxPagingtoolbar',
														cls:"pagingtoolbar",
														pageSize:gridPageSize,
														displayInfo: true,
														displayMsg:"Displaying {0} - {1} of {2}",
														listeners:{
															beforechange:function(){
																var searchTextBoxObj=Ext.getCmp('gridSearch');
																if(searchTextBoxObj != null)
																 {
																	var searchValue = searchTextBoxObj.value ;
																	if(searchValue != '')
																	{
																		var grid = Ext.getCmp('gridDisplay');
																		if(grid != '')
																		{
																			grid.store.filters.clear();
																		}
																		searchTextBoxObj.reset();
																	}
																 }
															}
														}
													}),
												},
												autoScroll: true,
												bodyStyle:{'overflow-y': 'auto'},
											}).show();
										}
									}]
								}
								panelItems = {
									autoScroll: false,
									scroll: false,
									layout: {
										type: 'fit',
										align: 'stretch'
									},
									items:[
									{
										xtype: 'panel',
										scroll: true,
										autoScroll: false,
										layout: {
											type: 'auto',
											pack: 'start',
											align: 'stretch'
										},
										flex: 1,
										defaults:{
											margin:10,
										},
										items: [
											pieChartPanel,
											topDestGridPanel
										]
									}]
								};

							}
							else
							{
								var pieChartTitle = topDestData['PIE_TITLE'];
								//pieChartTitle += " - "+flowsInterfaceSelectedCombo;
								var pieChartData = topDestData['pieChart'];
								if(pieChartTitle.length > 110){
									pieChartTitle = pieChartTitle.substr(0,105)+'...';
								}
								var pieChartWidth = 400;
								if(pieChartData.length == 1)
									pieChartWidth = 950;
								var pieChartPanel = {
									xtype:'genericpiechartslider',
									template:function(){
										var me = this;
										var sliderItems={};
										if(Ext.isEmpty(NOMSG)){
											
										sliderItems = new Ext.XTemplate(
											'<ul>',
											'<tpl for=".">',
												'<li ><div  class="netFlowPieChartRightBorder" style="margin:5 auto 10px 0"><div style="text-align:center;margin:10px 5px 0px 5px;">{XML_DATA.title}</div><div id="chart3holder{#}" ></div></div></li>',
											'</tpl>',
											'</ul>'
											
										 );
										}else{
											sliderItems = new Ext.XTemplate(
											'<ul>',
											'<li><table width="100%" height="200px"><tr><td valign="middle" align="center"><div class="iconInformation" ></div><div > '+noMeasureExcl+'</div></td></tr></table></li>',
											'</ul>'
											
										 );
										}
											return sliderItems;
									},
									data:pieChartData,
									loadChart:function(data){
										var me = this;
										if(!Ext.isEmpty(data)){
											var count =1;
											for (var key in data)
											{
												var counter = count++;
												try {
													var barChart = {};
													barChart = jQuery.extend(true, {}, getPieChartsforNetflow('chart3holder'+counter, 250, pieChartWidth), barChart);
													barChart.setData(data[key]['XML_DATA'], currentDateFormat, '', 'ProtocolPieNetflow');
													barChart.drawChart();
												} catch (barChartEx) {
													console.log(barChartEx);
												}
												$(window).resize(function(){
													if(Ext.isEmpty(NOMSG)){
														if($("#"+"chart3holder"+counter).highcharts() != undefined)
														{
															$("#"+"chart3holder"+counter).highcharts().reflow();
														}
													}
												});
											}
										}
									},
									tab:'TopDestinations',
									title:pieChartTitle,
								};
								var tableData = topDestData['tableData'];
								var tableTitle = tableData[0]['TABLE_TITLE'];
								//tableTitle += " - "+flowsInterfaceSelectedCombo;
								var tableColumns = tableData[0]['tableColumns'];
								var gridValues = tableData[0]['gridValues'];
							
								var fieldModel = new Array();
								var columns = new Array();
								var colIdx = 0;
								for (var key in tableColumns) {
									fieldModel.push({
										name: 'COLUMVal_' + colIdx,
										type: 'string'
									});
									columns.push({
										header: tableColumns[key],
										dataIndex: 'COLUMVal_' + colIdx,
										align: 'left',
										flex: 1,
										sortable: true,
										renderer: function(value, metaData, record, row, col, store, gridView)
										{
											var column = gridView.getHeaderAtIndex(col);
											var dataIndexVal = column.dataIndex;
											if (dataIndexVal != null && dataIndexVal == "COLUMVal_5") 
											{
												if(value!=null && value!="-")
												{
													if(value>0.0)
													{
														var barStr = '<table width="100%" cellpadding="0" cellspacing="0" border="0"  height="8" class="prog_border">';
														barStr += '<tr>';
														barStr += '<td align="left" width="100%" height="8" >';
														barStr += '<table width="' + value + '%" height="8"  cellpadding="0" cellspacing="0" border="0">';
														barStr += '<tr>';
														barStr += '<td class="progress_GOOD" width="100%"> </td>';
														barStr += '</tr>';
														barStr += '</table>';
														barStr += '</td>';
														barStr += '</tr>';
														barStr += '</table>';

														value = "<table width='100%' cellpadding='0' cellspacing='0'><tr><td style='width:50px'><span>" + value
														+ "</span></td><td >" + barStr + "</td></tr></table>";
													}
												}
											}
											return value;
										}
									});
									colIdx++;
								}
								var gridPageSize;
								if(selectedEventsPerPage == undefined || selectedEventsPerPage == 'undefined'){
									gridPageSize = parseInt(eventsPerPageArray[0].valueField);
								} else{
									gridPageSize = parseInt(selectedEventsPerPage);
								}
								var queryParams='';
								var tmpURL = '';
								var qryParamsObj={};
								if(netflowLastLoadedURL!=null && netflowLastLoadedURL.indexOf("?")>-1)
								{
									tmpURL = netflowLastLoadedURL.substr(0,netflowLastLoadedURL.indexOf("?"));
									queryParams=netflowLastLoadedURL.substr(netflowLastLoadedURL.indexOf("?")+1);
									if(!Ext.isEmpty(queryParams))
									{
										var queryParamsArr=queryParams.split('&');
										for(var q in queryParamsArr)
										{
											var reqParam=queryParamsArr[q];
											if(reqParam!=null && reqParam.indexOf("=")>-1)
											{
												var reqKey=reqParam.substr(0,reqParam.indexOf("="));
												var reqvalue=reqParam.substr(reqParam.indexOf("=")+1);
												if(reqKey.toLowerCase()=='timeline')
												{
													reqvalue=reqvalue.replace(/\+/g, '%20');
												}
												qryParamsObj[reqKey]=decodeURIComponent(reqvalue);
											}
										}
										qryParamsObj['isFromGridPage']='true';
										qryParamsObj['flowsTest']='TopDestTest';									
									}
								}
								var ackStore = Ext.create('Ext.data.Store',{
									fields: fieldModel,
									pageSize: gridPageSize,
									autoLoad: true,
									proxy: {
										type: 'ajax',
									actionMethods:  {
										create: "POST",
										read: "POST",
										update: "POST",
										destroy: "POST"
									},
									url: tmpURL,
									extraParams : qryParamsObj,
										reader: {
											type: 'json',
											root : 'gridValues',
											page:'page',
											start:'start',
											limit:'limit',
											totalProperty : 'totalCount'
										}
									},
									listeners: {
										load: function(store, records, successful, eOpts) {
											var configPanl = Ext.getCmp('netflowmainpanel');
											if (successful) {
												configPanl.setLoading(false, false);
											}else{
												configPanl.setLoading(true, true);
											}
										}
									}
								});
								var bbar;
								ackStore.on("load", function(component, records) {					
									var storeLength = ackStore.data.length;
									var currentPageSize = ackStore.pageSize;
									var currentTotalCount = ackStore.totalCount;
									var currentPage ='';
									if(ackStore.proxy.reader.rawData != null)
									{
										currentPage = ackStore.proxy.reader.rawData.page;
									}
									var pageSize = ackStore.pageSize;
									var totalpages = currentTotalCount/pageSize;
									totalpages = totalpages.toString();
									if(totalpages.indexOf('.') >-1)
									{
										totalpages = parseInt(totalpages);
										totalpages = totalpages +1;
									}else{
										totalpages = parseInt(totalpages);
									}
									if(currentPage > totalpages)
									{
										currentPage = totalpages;
										configPanl.setLoading(true, true);
									}										  
									if((currentTotalCount-storeLength) == 0 ||  (currentPage == 1 && currentTotalCount <= currentPageSize) )
									{
										Ext.getCmp('pagingtoolbar').hide();
									}
									else
									{
										Ext.getCmp('pagingtoolbar').show();
									}
								});
								var gridHeight = Ext.getBody().getHeight()-390;
								if(gridHeight <350){
									gridHeight = 350;
								}
								topDestGridPanel = {
									xtype: 'grid',
									store: ackStore,
									id:'gridDisplay',
									autoScroll: true,
									scroll: true,
									title: tableTitle,
									flex:1,
									height:gridHeight,
									cls: 'gridSkin',
									header:{
										style:{
											'padding':'2px 10px 0px 10px' 
										}
									},
									columns: columns,
									bbar: new Ext.PagingToolbar({
										store:ackStore,
										id:'pagingtoolbar',
										cls:"pagingtoolbar",
										pageSize:gridPageSize,
										displayInfo: true,
										displayMsg:"Displaying {0} - {1} of {2}",
										listeners:{
											beforechange:function(){
												
												var searchTextBoxObj=Ext.getCmp('gridSearch');
													if(searchTextBoxObj != null)
													 {
														var searchValue = searchTextBoxObj.value ;
														if(searchValue != '')
														{
															var grid = Ext.getCmp('gridDisplay');
															if(grid != '')
															{
																grid.store.filters.clear();
															}
															searchTextBoxObj.reset();
														}
													 }
											}
										}
									}),
									tools: [{
										xtype:'tbfill',
									},
									{
										xtype: 'trigger',
										trigger1Cls: 'x-form-clear-trigger',
										trigger2Cls: 'x-form-search-trigger',
										name: 'gridSearch',
										margin: '0 10 2 10',
										id: 'gridSearch',
										cls: 'whitedropdown_search',
										emptyText: searchLbl,
										labelAlign: 'top',
										width: 200,
										hidden: false,
											getTriggerMarkup: function() {
											var me = this,
												i = 0,
												hideTrigger = (me.readOnly || me.hideTrigger),
												triggerCls,
												triggerBaseCls = me.triggerBaseCls,
												triggerConfigs = [],
												unselectableCls = Ext.dom.Element.unselectableCls,
												style = 'width:' + me.triggerWidth + 'px;' + (hideTrigger ? 'display:none;' : ''),
												cls = me.extraTriggerCls + ' ' + Ext.baseCSSPrefix + 'trigger-cell ' + unselectableCls;

											// TODO this trigger<n>Cls API design doesn't feel clean, especially where it butts up against the
											// single triggerCls config. Should rethink this, perhaps something more structured like a list of
											// trigger config objects that hold cls, handler, etc.
											// triggerCls is a synonym for trigger1Cls, so copy it.
											if (!me.trigger1Cls) {
												me.trigger1Cls = me.triggerCls;
											}

											// Create as many trigger elements as we have trigger<n>Cls configs, but always at least one
											for (i = 0; (triggerCls = me['trigger' + (i + 1) + 'Cls']) || i < 1; i++) {
												if (i == 0)
												{
													triggerConfigs.push({
														tag: 'td',
														role: 'presentation',
														valign: 'top',
														cls: cls,
														id : 'MyTrigger_'+i,
														style: style + "display:none;",
														cn: {
															cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
															role: 'presentation'
														}
													});
												}
												else
												{
													triggerConfigs.push({
														tag: 'td',
														role: 'presentation',
														valign: 'top',
														cls: cls,
														id : 'MyTrigger_'+i,
														style: style,
														cn: {
															cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
															role: 'presentation'
														}
													});
												}
											}
											triggerConfigs[0].cn.cls += ' ' + triggerBaseCls + '-first';
											return Ext.DomHelper.markup(triggerConfigs);
										},
										onTrigger1Click: function () {
										this.reset();
										},
										onTrigger2Click : function() {
											appCnt.textFieldSearch();
										},
										
									},{ 
										xtype: 'button',
										iconCls: 'iconMaximize',
										style:{'background':'transparent','border':'none'},
										listeners:{
											'afterrender': function () {
													Ext.create('Ext.tip.ToolTip', {
														target: this.id,
														anchor: 'top',
														cls: 'yellowTip',
														trackMouse: true,
														html:maximizeViewLbl
													});
												}
										},
										handler: function()
										{
											var ackMaxStore = Ext.create('Ext.data.Store',{
												fields: fieldModel,
												pageSize: gridPageSize,
												autoLoad: true,
												proxy: {
													type: 'ajax',
													url: netflowLastLoadedURL+"&tab=Top Destinations&flowsTest=TopDestTest&isFromGridPage=true",
													reader: {
														type: 'json',
														root : 'gridValues',
														page:'page',
														start:'start',
														limit:'limit',
														totalProperty : 'totalCount'
													}
												},
												listeners: {
													load: function(store, records, successful, eOpts) {
														var configPanl = Ext.getCmp('netflowmainpanel');
														if (successful) {
																configPanl.setLoading(false, false);
																					
														}else{
															configPanl.setLoading(true, true);
														}
													}
												}
											});
											var bbar;
											ackMaxStore.on("load", function(component, records) {					
												var storeLength = ackMaxStore.data.length;
												var currentPageSize = ackMaxStore.pageSize;
												var currentTotalCount = ackMaxStore.totalCount;
												var currentPage ='';
												if(ackMaxStore.proxy.reader.rawData != null)
												{
													currentPage = ackMaxStore.proxy.reader.rawData.page;
												}
												var pageSize = ackMaxStore.pageSize;
												var totalpages = currentTotalCount/pageSize;
												totalpages = totalpages.toString();
												if(totalpages.indexOf('.') >-1)
												{
													totalpages = parseInt(totalpages);
													totalpages = totalpages +1;

												}else{
													totalpages = parseInt(totalpages);
												}
												if(currentPage > totalpages)
												{
													currentPage = totalpages;
													configPanl.setLoading(true, true);
												}										  
												if((currentTotalCount-storeLength) == 0 ||  (currentPage == 1 && currentTotalCount <= currentPageSize) )
												{
													Ext.getCmp('maxPagingtoolbar').hide();
												}else{
													Ext.getCmp('maxPagingtoolbar').show();
												}
											});
											var gridMaxView = Ext.create('utilities.GenericWindow',
											{
												title:tableTitle,
												width: '90%',
												height: '90%',
												cssMask:true,
												padding:'5 10 10 10',
												resizable   : false,
												draggable   : true,
												closeAction: 'destroy',
												scroll:true,
												layout:'fit',
												border:false,
												items:{
													xtype:'grid',
													store: ackMaxStore,
													columns: columns,
													cls: 'gridSkin',
													layout:'fit',
													 bbar: new Ext.PagingToolbar({
														store:ackMaxStore,
														id:'maxPagingtoolbar',
														cls:"pagingtoolbar",
														pageSize:gridPageSize,
														displayInfo: true,
														displayMsg:"Displaying {0} - {1} of {2}",
														listeners:{
															beforechange:function(){
																var searchTextBoxObj=Ext.getCmp('gridSearch');
																if(searchTextBoxObj != null)
																 {
																	var searchValue = searchTextBoxObj.value ;
																	if(searchValue != '')
																	{
																		var grid = Ext.getCmp('gridDisplay');
																		if(grid != '')
																		{
																			grid.store.filters.clear();
																		}
																		searchTextBoxObj.reset();
																	}
																 }
															}
														}
													}),
												},
												autoScroll: true,
												bodyStyle:{'overflow-y': 'auto'},
											}).show();
										}
									}]
								}
								panelItems = {
									autoScroll: false,
									scroll: false,
									layout: {
										type: 'fit',
										align: 'stretch'
									},
									items:[
									{
										xtype: 'panel',
										scroll: true,
										autoScroll: false,
										layout: {
											type: 'auto',
											pack: 'start',
											align: 'stretch'
										},
										flex: 1,
										defaults:{
											margin:10,
										},
										items: [
											pieChartPanel,
											topDestGridPanel
										]
									}]
								};
							}
						}
						else
						{
							if (errorMsg=='undefined' || errorMsg == undefined || errorMsg == "")
							{
								errorMsg = NoMeasure +"!";
							}
							panelItems = {
								autoScroll: false,
								scroll: false,
								height:getHeightForNoMeasures,
								layout: {
									type: 'fit',
									align: 'stretch'
								},
								scroll: false,
								autoScroll: false,
								flex:1,
								items:[{
									xtype:'container',
									html:'<table width="100%" height="100%"><tr><td valign="middle" align="center"><div class="iconInformation" ></div><div>'+errorMsg+'</div></td></tr></table>' 
								}]
							};  
						}
					}
				}
			});
		}
		else if (activeTab == "topconversations") 
		{
			var flowsUrl = newCard.DataURL;
			var interafceLastSelected = localStorage.getItem("interfaceLastSelectedView");
			if(interafceLastSelected!=null && !Ext.isEmpty(interafceLastSelected))
			{
				interfaceSelectedView = interafceLastSelected;
			}
			var showSelectedView = localStorage.getItem("showLastSelectedView");
			if(showSelectedView!=null && !Ext.isEmpty(showSelectedView))
			{
				showVal = showSelectedView;
			}   
			var timelinetSelectedView = localStorage.getItem("timelineLastSelectedView");
			if(timelinetSelectedView!=null && !Ext.isEmpty(timelinetSelectedView))
			{
				globalTimeline = timelinetSelectedView;
			} 
			if(interfaceSelectedView != null){
				if(flowsUrl!=null && flowsUrl.indexOf("interfaceToView")>0)
				{
					flowsUrl = flowsUrl.replace(/(interfaceToView=)[^\&]+/, '$1' + encodeURIComponent(interfaceSelectedView));				
				}
				else
				{
					flowsUrl = flowsUrl+"&interfaceToView="+encodeURIComponent(interfaceSelectedView);
				}
				if(flowsUrl!=null && flowsUrl.indexOf("infosToArea")>0)
				{
					flowsUrl = flowsUrl.replace(/(infosToArea=)[^\&]+/, '$1' + interfaceSelectedView);
				}
				else
				{
					flowsUrl = flowsUrl+"&infosToArea="+encodeURIComponent(interfaceSelectedView);
				}
			}
			if(showVal != null){
				if(flowsUrl.indexOf("show") > -1)
				{
					flowsUrl = flowsUrl.replace(/(show=)[^\&]+/, '$1' + encodeURIComponent(showVal));
				}
				else
				{
					
					flowsUrl += '&show='+encodeURIComponent(showVal);
				}
			}
			if(globalTimeline != null){
				if(flowsUrl.indexOf("selectedTimeline") > -1)
				{
					flowsUrl = flowsUrl.replace(/(selectedTimeline=)[^\&]+/, '$1' + encodeURIComponent(globalTimeline));
				}
				else
				{
					
					flowsUrl += '&selectedTimeline='+encodeURIComponent(globalTimeline);
				}
				if(flowsUrl.indexOf("timeline") > -1)
				{
					flowsUrl = flowsUrl.replace(/(timeline=)[^\&]+/, '$1' + encodeURIComponent(globalTimeline));
				}
				else
				{
					
					flowsUrl += '&timeline='+encodeURIComponent(globalTimeline);
				}
			}
			netflowLastLoadedURL = flowsUrl;
			if(netflowLastLoadedURL!=null && netflowLastLoadedURL.indexOf("&ciscoSelectedType=")>0)
			{
				netflowLastLoadedURL = netflowLastLoadedURL.replace(/(ciscoSelectedType=)[^\&]+/, '$1' + 'flows');
			}
			else
			{
				netflowLastLoadedURL=netflowLastLoadedURL+'&ciscoSelectedType=flows';
			}
			var getHeightForNoMeasures = Ext.getBody().getHeight()-100
			var topConvPieChart = [];
			var topConvPieChartPanel = '';
			var topConvGridPanel = '';
			var queryParams='';
			var tmpURL = '';
			if(flowsUrl!=null && flowsUrl.indexOf("?")>-1)
			{
				tmpURL = flowsUrl.substr(0,flowsUrl.indexOf("?"));
				queryParams=flowsUrl.substr(flowsUrl.indexOf("?")+1);
			}
			Ext.Ajax.request({
				url: tmpURL,
				params: queryParams+'&flowsTest=TopConverTest',
				method : 'POST',
				scope: this,
				async: false,
				success: function (response)
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						var jsonText = response.responseText;
						var jsonData = Ext.decode(jsonText);

						var timelineCombo = jsonData['timelineCombo'];
						var selectedTimelineCombo = timelineCombo['selectedTimelineCombo'];
						var timelineComboArray = timelineCombo['timelineComboArray'];
						
						var TimelineComboLabel = timelineCombo['monitor.dashboard.TimeLine'];
						var flowsInterfaceCombo = jsonData['flowsInterfaceCombo'];
						
						var showCombo = jsonData['showCombo'];
						var eventsPerPageCombo = jsonData['eventsPerPageCombo'];
						var eventsPerPageArray = '';
						var selectedEventsPerPage = '';						
						var timelineTitle = jsonData['timelineTitle'];

						var pieChartData = jsonData['pieChart'];						
						if(pieChartData!=null){
							NOMSG = pieChartData[0]['NOMSG'];
						}
						var pieTitle = jsonData['pieTitle'];
						var topConvData = '';
						var dataAvailable = '';
						var errorMsg = '';
						if(jsonData['flowsPieArr']!=null && jsonData['flowsPieArr'].length>0)
						{
							var topConvData = jsonData['flowsPieArr'][0]['DATA_0'];
							dataAvailable = topConvData['Data'];
							errorMsg = topConvData['ErrorMsg'];
						}
						var fromView = jsonData['fromView'];
						if(fromView!=null && fromView =='SummaryView')
						{
							dataAvailable = jsonData['Data'];
						}

						if(timelineTitle!=null)
						{
							newCard.timelineTitle = timelineTitle;
						}
						var flowsInterfaceSelectedCombo = jsonData['flowsInterfaceSelectedCombo'];
						newCard.timelineComboArray =timelineComboArray;
						newCard.selectedTimelineCombo = selectedTimelineCombo;
						if(flowsInterfaceCombo!=null)
						{
							newCard.flowsInterfaceCombo = flowsInterfaceCombo;
							newCard.flowsInterfaceSelectedCombo = flowsInterfaceSelectedCombo;
						}
						if(showCombo != null){
							var showComboArray = showCombo['showComboArray'];
							var selectedShowCombo = showCombo['selectedShowCombo'];
							newCard.showComboArray = showComboArray;
							newCard.selectedShowCombo = selectedShowCombo;
						}
						
						if(eventsPerPageCombo != null){
							eventsPerPageArray=eventsPerPageCombo['eventsPerPageArray']; 
							selectedEventsPerPage=eventsPerPageCombo['selectedEventsPerPage'];
							newCard.eventsPerPageArray = eventsPerPageArray;
							newCard.selectedEventsPerPage = selectedEventsPerPage;
						}
						this.addNetflowTabtoolbar(newCard);
						var isfromInterfaceComboChange = jsonData['isfromInterfaceComboChange'];
						var isInterfaceCountExceeded = jsonData['isInterfaceCountExceeded'];
						if(dataAvailable!=null && dataAvailable=='true')
						{	
							if(fromView!=null && fromView =='SummaryView' && isInterfaceCountExceeded)
							{
								var piePanel = '';
								if(!Ext.isEmpty(NOMSG))
								{
									piePanel = {
										xtype:'panel',
										flex:.5,
										height:300,
										margin:5,
										layout:{
											type:'fit',
										},
										ui:'egGraphPanel',
										title:pieTitle,
										items:[
											{
												xtype:'container',
												html:'<table width="100%" height="100%"><tr><td valign="middle" align="center"><div class="iconInformation" ></div><div >'+NOMSG+'</div></td></tr></table>' 
											}
										]
									}
								}
								else
								{
									piePanel = {
										xtype:'panel',
										flex:.5,
										height:300,
										margin:5,
										ui:'egGraphPanel',
										title:pieTitle,
										id:'topConvpiechart',
										pieChartData:pieChartData,
										listeners:
										{
											afterrender:function(){
												var me = this;
												if(!Ext.isEmpty(me.pieChartData)){													
													try {
														var barChart = {};
														barChart = jQuery.extend(true, {}, getPieChartsforNetflow('topConvpiechart-body', '290', '800'), barChart);
														barChart.setData(me.pieChartData[0]['XML_DATA'], currentDateFormat, '', 'ProtocolPieNetflow');
														barChart.drawChart();
													} catch (barChartEx) {
														console.log(barChartEx);
													}
													$(window).resize(function(){
														if(Ext.isEmpty(NOMSG)){
															if($("#"+"topConvpiechart-body").highcharts() != undefined)
															{
																$("#"+"topConvpiechart-body").highcharts().reflow();
															}
														}
													});
												}
											}
										}
									};
								}
								
								var barchartPanel = '';
								var barData = jsonData['comparisonCharts'];
								if(!Ext.isEmpty(barData['NoMeasure']))
								{
									barchartPanel = {
										xtype:'panel',
										flex:.5,
										height:300,
										margin:5,
										layout:{
											type:'fit',
										},
										ui:'egGraphPanel',
										title:jsonData['barTitle'],
										items:[
											{
												xtype:'container',
												html:'<table width="100%" height="100%"><tr><td valign="middle" align="center"><div class="iconInformation" ></div><div >'+barData['NoMeasure']+'</div></td></tr></table>' 
											}
										]																			
									};
								}
								else
								{
									barchartPanel = {
										xtype:'panel',
										flex:.5,
										height:300,
										margin:5,
										ui:'egGraphPanel',
										title:jsonData['barTitle'],
										id:'topConvbarGraphPanel',
										barData:barData,
										listeners:
										{
											afterrender:function(){
												var me = this;
												if(!Ext.isEmpty(me.barData)){													
													try
													{
														var barChart = {};
														barChart = jQuery.extend(true, {}, getHighChartsBarInstance('topConvbarGraphPanel-body',270,600),barChart);
														barChart.setData(me.barData['XML_DATA'], currentDateFormat, '','netflowconversationbar');
														barChart.drawChart();
													}
													catch (barChartEx)
													{
														console.log(barChartEx);
													}
												}
											}
										}										
									};
								}								
								
								var tableData = jsonData['tableData'];
								var topConvTableColumns = tableData['tableColumns'];
								var gridValues = tableData['tableValues'];
								if(gridValues!=null && gridValues.length>0)
								{
									var columnArr = new Array();
									var fieldModel = new Array();
									var columns = new Array();
									var colIdx = 0;
									for (var key in topConvTableColumns) { 
										fieldModel.push({
											name: 'COLUMVal_' + colIdx,
											type: 'FLOATORSTRING'
										});
										columns.push({
											header: topConvTableColumns[key],
											dataIndex: 'COLUMVal_' + colIdx,
											align: 'left',
											flex: 1,
											sortable: true,
											renderer: function(value, metaData, record, row, col, store, gridView)
											{
												var column = gridView.getHeaderAtIndex(col);
												var dataIndexVal = column.dataIndex;
												return value;
											}
										});
										colIdx++;
									}
									var ackStore = Ext.data.Store({
										fields: fieldModel,
										data: gridValues,
										/*sortOnLoad : true,
										sorters : {
											property : 'COLUMVal_1',
											direction : 'DESC'
										}*/
									});
									topConvGridPanel = {
										xtype: 'grid',
										id: 'gridDisplay',
										store: ackStore,
										height: 290,
										margin:'0 10 10 10',
										title: jsonData['TABLE_TITLE'],//tableData['TABLE_TITLE'],
										cls: 'gridSkin',
										header:{
											style:{
												'padding':'2px 10px 0px 10px' 
											}
										},
										columns: columns,
										tools: [	{
											xtype:'tbfill',
										},
										{
											xtype: 'trigger',
											trigger1Cls: 'x-form-clear-trigger',
											trigger2Cls: 'x-form-search-trigger',
											name: 'gridSearch',
											margin: '0 10 2 10',
											id: 'gridSearch',
											cls: 'whitedropdown_search',
											emptyText: 'Search',
											labelAlign: 'top',
											width: 200,
											hidden: false,
											getTriggerMarkup: function() {
												var me = this,
													i = 0,
													hideTrigger = (me.readOnly || me.hideTrigger),
													triggerCls,
													triggerBaseCls = me.triggerBaseCls,
													triggerConfigs = [],
													unselectableCls = Ext.dom.Element.unselectableCls,
													style = 'width:' + me.triggerWidth + 'px;' + (hideTrigger ? 'display:none;' : ''),
													cls = me.extraTriggerCls + ' ' + Ext.baseCSSPrefix + 'trigger-cell ' + unselectableCls;

												// TODO this trigger<n>Cls API design doesn't feel clean, especially where it butts up against the
												// single triggerCls config. Should rethink this, perhaps something more structured like a list of
												// trigger config objects that hold cls, handler, etc.
												// triggerCls is a synonym for trigger1Cls, so copy it.
												if (!me.trigger1Cls) {
													me.trigger1Cls = me.triggerCls;
												}
												for (i = 0; (triggerCls = me['trigger' + (i + 1) + 'Cls']) || i < 1; i++) {
													if (i == 0)
													{
														triggerConfigs.push({
															tag: 'td',
															role: 'presentation',
															valign: 'top',
															cls: cls,
															id : 'MyTrigger_'+i,
															style: style + "display:none;",
															cn: {
																cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
																role: 'presentation'
															}
														});
													}
													else
													{
														triggerConfigs.push({
															tag: 'td',
															role: 'presentation',
															valign: 'top',
															cls: cls,
															id : 'MyTrigger_'+i,
															style: style,
															cn: {
																cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
																role: 'presentation'
															}
														});
													}
												}
												triggerConfigs[0].cn.cls += ' ' + triggerBaseCls + '-first';
												return Ext.DomHelper.markup(triggerConfigs);
											},
											onTrigger1Click: function () {
											this.reset();
											},
											onTrigger2Click : function() {
												appCnt.textFieldSearch();
											},
										},{ 
											xtype: 'button',
											iconCls: 'iconMaximize',
											style:{'background':'transparent','border':'none'},
											listeners:{
												'afterrender': function () {
														Ext.create('Ext.tip.ToolTip', {
															target: this.id,
															anchor: 'top',
															cls: 'yellowTip',
															trackMouse: true,
															html:"Maximize View"
														});
													}
											},
											handler: function()
											{
												var ackMaxStore = Ext.create('Ext.data.Store',{
													fields: fieldModel,
													pageSize: gridPageSize,
													autoLoad: true,
													proxy: {
														type: 'ajax',
														url: netflowLastLoadedURL+"&tab=Top Conversations&flowsTest=TopConverTest&isFromGridPage=true",
														reader: {
															type: 'json',
															root : 'gridValues',
															page:'page',
															start:'start',
															limit:'limit',
															totalProperty : 'totalCount'
														}
													},
													listeners: {
														load: function(store, records, successful, eOpts) {
															var configPanl = Ext.getCmp('netflowmainpanel');
															if (successful) {
																configPanl.setLoading(false, false);
																						
															}else{
																configPanl.setLoading(true, true);
															}
														}
													}
												});	
												var bbar;
												ackMaxStore.on("load", function(component, records) {					
													var storeLength = ackMaxStore.data.length;
													var currentPageSize = ackMaxStore.pageSize;
													var currentTotalCount = ackMaxStore.totalCount;
													var currentPage ='';
													if(ackMaxStore.proxy.reader.rawData != null)
													{
														currentPage = ackMaxStore.proxy.reader.rawData.page;
													}
													var pageSize = ackMaxStore.pageSize;
													var totalpages = currentTotalCount/pageSize;
													totalpages = totalpages.toString();
													if(totalpages.indexOf('.') >-1)
													{
														totalpages = parseInt(totalpages);
														totalpages = totalpages +1;

													}else{
														totalpages = parseInt(totalpages);
													}

													if(currentPage > totalpages)
													{
														currentPage = totalpages;
														//store.loadPage(currentPage);
														configPanl.setLoading(true, true);
														
													}										  

													if((currentTotalCount-storeLength) == 0 ||  (currentPage == 1 && currentTotalCount <= currentPageSize) )
													{
														Ext.getCmp('maxPagingtoolbar').hide();
													}else{
														Ext.getCmp('maxPagingtoolbar').show();
													}
												});
												var gridMaxView = Ext.create('utilities.GenericWindow',
												{
													title:jsonData['TABLE_TITLE'],
													width: '90%',
													height: '90%',
													cssMask:true,
													padding:'5 10 10 10',
													resizable   : false,
													draggable   : true,
													closeAction: 'destroy',
													layout:'fit',
													scroll:true,
													border:false,
													items:{
														xtype:'grid',
														store: ackMaxStore,
														columns: columns,
														layout:'fit',
														cls: 'gridSkin',
														bbar: new Ext.PagingToolbar({
															store:ackMaxStore,
															id:'maxPagingtoolbar',
															cls:"pagingtoolbar",
															pageSize:gridPageSize,
															displayInfo: true,
															displayMsg:"Displaying {0} - {1} of {2}",
															listeners:{
																beforechange:function(){
																	var searchTextBoxObj=Ext.getCmp('gridSearch');
																	if(searchTextBoxObj != null)
																	 {
																		var searchValue = searchTextBoxObj.value ;
																		if(searchValue != '')
																		{
																			var grid = Ext.getCmp('gridDisplay');
																			if(grid != '')
																			{
																				grid.store.filters.clear();
																			}
																			searchTextBoxObj.reset();
																		}
																	 }
																}
															}
														}),
													},
													bodyStyle:{'overflow-y': 'auto'},
												}).show();
											}
										}]
									}
								}
								else
								{
									topConvGridPanel = {
										xtype:'panel',
										flex:.5,
										height:220,
										margin:'0 10 10 10',
										margin:5,
										layout:{
											type:'fit',
										},
										ui:'egGraphPanel',
										title:jsonData['TABLE_TITLE'],
										items:[
											{
												xtype:'container',
												html:'<table width="100%" height="100%"><tr><td valign="middle" align="center"><div class="iconInformation" ></div><div >'+noMeasureExcl+'</div></td></tr></table>' 
											}
										]	
									}
								}

								pieChartPanel = {
									xtype:'panel',
									tab:'Protocols',
									header:false,
									margin:5,
									layout:{
										type:'hbox',
										align:'stretch',
									},
									flex:1,
									items:[
										piePanel,
										barchartPanel
									]
								};

								panelItems = {
									autoScroll: false,
									scroll: false,
									layout: {
										type: 'fit',
										align: 'stretch'
									},
									items:[
									{
										xtype: 'panel',
										scroll: true,
										autoScroll: false,
										layout: {
											type: 'auto',
											pack: 'start',
											align: 'stretch'
										},
										flex: 1,
										defaults:{
											margin:10,
										},
										items: [
											pieChartPanel,
											topConvGridPanel
										]
									}]
								};
							}
							else if(isfromInterfaceComboChange)
							{
								var pieChartTitle = topConvData['PIE_TITLE'];
								//pieChartTitle += " - "+flowsInterfaceSelectedCombo;
								var pieChartData = topConvData['pieChart'];
								var piePanel = '';
								if(!Ext.isEmpty(NOMSG))
								{
									piePanel = {
										xtype:'panel',
										flex:.5,
										height:300,
										margin:5,
										layout:{
											type:'fit',
										},
										ui:'egGraphPanel',
										title:pieChartTitle,
										items:[
											{
												xtype:'container',
												html:'<table width="100%" height="100%"><tr><td valign="middle" align="center"><div class="iconInformation" ></div><div >'+NOMSG+'</div></td></tr></table>' 
											}
										]
									}
								}
								else
								{
									piePanel = {
										xtype:'panel',
										flex:.5,
										height:300,
										margin:5,
										ui:'egGraphPanel',
										title:pieChartTitle,
										id:'topConvpiechart',
										pieChartData:pieChartData,
										listeners:
										{
											afterrender:function(){
												var me = this;
												if(!Ext.isEmpty(me.pieChartData)){													
													try {
														var barChart = {};
														barChart = jQuery.extend(true, {}, getPieChartsforNetflow('topConvpiechart-body', '290', '460'), barChart);
														barChart.setData(me.pieChartData[0]['XML_DATA'], currentDateFormat, '', 'ProtocolPieNetflow');
														barChart.drawChart();
													} catch (barChartEx) {
														console.log(barChartEx);
													}
													$(window).resize(function(){
														if(Ext.isEmpty(NOMSG)){
															if($("#"+"topConvpiechart-body").highcharts() != undefined)
															{
																$("#"+"topConvpiechart-body").highcharts().reflow();
															}
														}
													});
												}
											}
										}
									};
								}
								
								var barchartPanel = '';
								var barData = jsonData['comparisonCharts'];
								if(!Ext.isEmpty(barData['NoMeasure']))
								{
									barchartPanel = {
										xtype:'panel',
										flex:.5,
										height:300,
										margin:5,
										layout:{
											type:'fit',
										},
										ui:'egGraphPanel',
										title:jsonData['barTitle'],
										items:[
											{
												xtype:'container',
												html:'<table width="100%" height="100%"><tr><td valign="middle" align="center"><div class="iconInformation" ></div><div >'+barData['NoMeasure']+'</div></td></tr></table>' 
											}
										]																			
									};
								}
								else
								{
									barchartPanel = {
										xtype:'panel',
										flex:.5,
										height:300,
										margin:5,
										ui:'egGraphPanel',
										title:jsonData['barTitle'],
										id:'topConvbarGraphPanel',
										barData:barData,
										listeners:
										{
											afterrender:function(){
												var me = this;
												if(!Ext.isEmpty(me.barData)){													
													try
													{
														var barChart = {};
														barChart = jQuery.extend(true, {}, getHighChartsBarInstance('topConvbarGraphPanel-body',270,600),barChart);
														barChart.setData(me.barData['XML_DATA'], currentDateFormat, '','netflowconversationbar');
														barChart.drawChart();
													}
													catch (barChartEx)
													{
														console.log(barChartEx);
													}
												}
											}
										}										
									};
								}
								pieChartPanel = {
									xtype:'panel',
									tab:'Protocols',
									header:false,
									margin:5,
									layout:{
										type:'hbox',
										align:'stretch',
									},
									flex:1,
									items:[
										piePanel,
										barchartPanel
									]
								};

								var tableData = topConvData['tableData'];
								var tableTitle = tableData[0]['TABLE_TITLE'];
								//tableTitle += " - "+flowsInterfaceSelectedCombo;
								var tableColumns = tableData[0]['tableColumns'];
								var gridValues = tableData[0]['gridValues'];
								var fieldModel = new Array();
								var columns = new Array();
								var colIdx = 0;
								for (var key in tableColumns) {
									fieldModel.push({
										name: 'COLUMVal_' + colIdx,
										type: 'string'
									});
									columns.push({
										header: tableColumns[key],
										dataIndex: 'COLUMVal_' + colIdx,
										align: 'left',
										flex: 1,
										sortable: true,
										renderer: function(value, metaData, record, row, col, store, gridView)
										{
											var column = gridView.getHeaderAtIndex(col);
											var dataIndexVal = column.dataIndex;
											if (dataIndexVal != null && dataIndexVal == "COLUMVal_5") 
											{
												if(value!=null && value!="-")
												{
													if(value>0.0)
													{
														var barStr = '<table width="100%" cellpadding="0" cellspacing="0" border="0"  height="8" class="prog_border">';
														barStr += '<tr>';
														barStr += '<td align="left" width="100%" height="8" >';
														barStr += '<table width="' + value + '%" height="8"  cellpadding="0" cellspacing="0" border="0">';
														barStr += '<tr>';
														barStr += '<td class="progress_GOOD" width="100%"> </td>';
														barStr += '</tr>';
														barStr += '</table>';
														barStr += '</td>';
														barStr += '</tr>';
														barStr += '</table>';

														value = "<table width='100%' cellpadding='0' cellspacing='0'><tr><td style='width:50px'><span>" + value
														+ "</span></td><td >" + barStr + "</td></tr></table>";
													}
												}
											}
											return value;
										}
									});
									colIdx++;
								}
								var gridPageSize;
								if(selectedEventsPerPage == undefined || selectedEventsPerPage == 'undefined'){
									gridPageSize = parseInt(eventsPerPageArray[0].valueField);
								} else{
									gridPageSize = parseInt(selectedEventsPerPage);
								}
								var queryParams='';
								var tmpURL = '';
								var qryParamsObj={};
								if(netflowLastLoadedURL!=null && netflowLastLoadedURL.indexOf("?")>-1)
								{
									tmpURL = netflowLastLoadedURL.substr(0,netflowLastLoadedURL.indexOf("?"));
									queryParams=netflowLastLoadedURL.substr(netflowLastLoadedURL.indexOf("?")+1);
									if(!Ext.isEmpty(queryParams))
									{
										var queryParamsArr=queryParams.split('&');									
										for(var q in queryParamsArr)
										{
											var reqParam=queryParamsArr[q];
											if(reqParam!=null && reqParam.indexOf("=")>-1)
											{
												var reqKey=reqParam.substr(0,reqParam.indexOf("="));
												var reqvalue=reqParam.substr(reqParam.indexOf("=")+1);
												if(reqKey.toLowerCase()=='timeline')
												{
													reqvalue=reqvalue.replace(/\+/g, '%20');
												}
												qryParamsObj[reqKey]=decodeURIComponent(reqvalue);
											}
										}
										//qryParamsObj['tab']='Top Conversations';
										qryParamsObj['flowsTest']='TopConverTest';
										qryParamsObj['isFromGridPage']='true';									
									}
								}
								var ackStore = Ext.create('Ext.data.Store',{
									fields: fieldModel,
									pageSize: gridPageSize,
									autoLoad: true,
									proxy: {
										type: 'ajax',
									actionMethods:  {
										create: "POST",
										read: "POST",
										update: "POST",
										destroy: "POST"
									},
									//limitParam : 'undefined',
									url: tmpURL,
									extraParams : qryParamsObj,									
										reader: {
											type: 'json',
											root : 'gridValues',
											page:'page',
											start:'start',
											limit:'limit',
											totalProperty : 'totalCount'
										}
									},
									listeners: {
										load: function(store, records, successful, eOpts) {
											var configPanl = Ext.getCmp('netflowmainpanel');
											if (successful) {
													configPanl.setLoading(false, false);
																		
											}else{
												configPanl.setLoading(true, true);
											}
										}
									}
								});
								var bbar;
								ackStore.on("load", function(component, records) {					
									var storeLength = ackStore.data.length;
									var currentPageSize = ackStore.pageSize;
									var currentTotalCount = ackStore.totalCount;
									var currentPage ='';
									if(ackStore.proxy.reader.rawData != null)
									{
										currentPage = ackStore.proxy.reader.rawData.page;
									}
									var pageSize = ackStore.pageSize;
									var totalpages = currentTotalCount/pageSize;
									totalpages = totalpages.toString();
									if(totalpages.indexOf('.') >-1)
									{
										totalpages = parseInt(totalpages);
										totalpages = totalpages +1;

									}else{
										totalpages = parseInt(totalpages);
									}

									if(currentPage > totalpages)
									{
										currentPage = totalpages;
										//store.loadPage(currentPage);
										configPanl.setLoading(true, true);
										
									}										  

									if((currentTotalCount-storeLength) == 0 ||  (currentPage == 1 && currentTotalCount <= currentPageSize) )
									{
										Ext.getCmp('pagingtoolbar').hide();
									}else{
										Ext.getCmp('pagingtoolbar').show();
									}
								});
								var gridHeight = Ext.getBody().getHeight()-390;
								if(gridHeight <350){
									gridHeight = 350;
								}
								topConvGridPanel = {
									xtype: 'grid',
									id:'gridDisplay',
									store: ackStore,
									margin:'0 10 10 10',
									title: tableTitle,
									flex:1,
									height:gridHeight,
									cls: 'gridSkin',
									header:{
										style:{
											'padding':'2px 10px 0px 10px' 
										}
									},
									columns: columns,
									bbar: new Ext.PagingToolbar({
										store:ackStore,
										id:'pagingtoolbar',
										cls:"pagingtoolbar",
										pageSize:gridPageSize,
										displayInfo: true,
										displayMsg:"Displaying {0} - {1} of {2}",
										listeners:{
											beforechange:function(){
												var searchTextBoxObj=Ext.getCmp('gridSearch');
												if(searchTextBoxObj != null)
												 {
													var searchValue = searchTextBoxObj.value ;
													if(searchValue != '')
													{
														var grid = Ext.getCmp('gridDisplay');
														if(grid != '')
														{
															grid.store.filters.clear();
														}
														searchTextBoxObj.reset();
													}
												 }
											}
										}
									}),
									tools: [{
										xtype:'tbfill',
									},
									{
										xtype: 'trigger',
										trigger1Cls: 'x-form-clear-trigger',
										trigger2Cls: 'x-form-search-trigger',
										name: 'gridSearch',
										margin: '0 10 2 10',
										id: 'gridSearch',
										cls: 'whitedropdown_search',
										emptyText: searchLbl,
										labelAlign: 'top',
										width: 200,
										hidden: false,
										getTriggerMarkup: function() {
											var me = this,
												i = 0,
												hideTrigger = (me.readOnly || me.hideTrigger),
												triggerCls,
												triggerBaseCls = me.triggerBaseCls,
												triggerConfigs = [],
												unselectableCls = Ext.dom.Element.unselectableCls,
												style = 'width:' + me.triggerWidth + 'px;' + (hideTrigger ? 'display:none;' : ''),
												cls = me.extraTriggerCls + ' ' + Ext.baseCSSPrefix + 'trigger-cell ' + unselectableCls;

											// TODO this trigger<n>Cls API design doesn't feel clean, especially where it butts up against the
											// single triggerCls config. Should rethink this, perhaps something more structured like a list of
											// trigger config objects that hold cls, handler, etc.
											// triggerCls is a synonym for trigger1Cls, so copy it.
											if (!me.trigger1Cls) {
												me.trigger1Cls = me.triggerCls;
											}

											// Create as many trigger elements as we have trigger<n>Cls configs, but always at least one
											for (i = 0; (triggerCls = me['trigger' + (i + 1) + 'Cls']) || i < 1; i++) {
												if (i == 0)
												{
													triggerConfigs.push({
														tag: 'td',
														role: 'presentation',
														valign: 'top',
														cls: cls,
														id : 'MyTrigger_'+i,
														style: style + "display:none;",
														cn: {
															cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
															role: 'presentation'
														}
													});
												}
												else
												{
													triggerConfigs.push({
														tag: 'td',
														role: 'presentation',
														valign: 'top',
														cls: cls,
														id : 'MyTrigger_'+i,
														style: style,
														cn: {
															cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
															role: 'presentation'
														}
													});
												}
											}
											triggerConfigs[0].cn.cls += ' ' + triggerBaseCls + '-first';
											return Ext.DomHelper.markup(triggerConfigs);
										},
										onTrigger1Click: function () {
										this.reset();
										},
										onTrigger2Click : function() {
											appCnt.textFieldSearch();
										},
										
									},{ 
										xtype: 'button',
										iconCls: 'iconMaximize',
										style:{'background':'transparent','border':'none'},
										listeners:{
											'afterrender': function () {
													Ext.create('Ext.tip.ToolTip', {
														target: this.id,
														anchor: 'top',
														cls: 'yellowTip',
														trackMouse: true,
														html:maximizeViewLbl
													});
												}
										},
										handler: function()
										{
											var ackMaxStore = Ext.create('Ext.data.Store',{
												fields: fieldModel,
												pageSize: gridPageSize,
												autoLoad: true,
												proxy: {
													type: 'ajax',
													url: netflowLastLoadedURL+"&flowsTest=TopConverTest&isFromGridPage=true",
													reader: {
														type: 'json',
														root : 'gridValues',
														page:'page',
														start:'start',
														limit:'limit',
														totalProperty : 'totalCount'
													}
												},
												listeners: {
													load: function(store, records, successful, eOpts) {
														var configPanl = Ext.getCmp('netflowmainpanel');
														if (successful) {
																configPanl.setLoading(false, false);
																					
														}else{
															configPanl.setLoading(true, true);
														}
													}
												}
											});
											var bbar;
											ackMaxStore.on("load", function(component, records) {					
												var storeLength = ackMaxStore.data.length;
												var currentPageSize = ackMaxStore.pageSize;
												var currentTotalCount = ackMaxStore.totalCount;
												var currentPage ='';
												if(ackMaxStore.proxy.reader.rawData != null)
												{
													currentPage = ackMaxStore.proxy.reader.rawData.page;
												}
												var pageSize = ackMaxStore.pageSize;
												var totalpages = currentTotalCount/pageSize;
												totalpages = totalpages.toString();
												if(totalpages.indexOf('.') >-1)
												{
													totalpages = parseInt(totalpages);
													totalpages = totalpages +1;

												}else{
													totalpages = parseInt(totalpages);
												}

												if(currentPage > totalpages)
												{
													currentPage = totalpages;
													configPanl.setLoading(true, true);
												}										  
												if((currentTotalCount-storeLength) == 0 ||  (currentPage == 1 && currentTotalCount <= currentPageSize) )
												{
													Ext.getCmp('maxPagingtoolbar').hide();
												}else{
													Ext.getCmp('maxPagingtoolbar').show();
												}
											});
											var gridMaxView = Ext.create('utilities.GenericWindow',
											{
												title:tableTitle,
												width: '90%',
												height: '90%',
												cssMask:true,
												padding:'5 10 10 10',
												resizable   : false,
												draggable   : true,
												closeAction: 'destroy',
												layout:'fit',
												scroll:true,
												border:false,
												items:{
													xtype:'grid',
													store: ackMaxStore,
													columns: columns,
													layout:'fit',
													cls: 'gridSkin',
													bbar: new Ext.PagingToolbar({
														store:ackMaxStore,
														id:'maxPagingtoolbar',
														cls:"pagingtoolbar",
														pageSize:gridPageSize,
														displayInfo: true,
														displayMsg:"Displaying {0} - {1} of {2}",
														listeners:{
															beforechange:function(){
																var searchTextBoxObj=Ext.getCmp('gridSearch');
																if(searchTextBoxObj != null)
																 {
																	var searchValue = searchTextBoxObj.value ;
																	if(searchValue != '')
																	{
																		var grid = Ext.getCmp('gridDisplay');
																		if(grid != '')
																		{
																			grid.store.filters.clear();
																		}
																		searchTextBoxObj.reset();
																	}
																 }
															}
														}
													}),
												},
												autoScroll: true,
												bodyStyle:{'overflow-y': 'auto'},
											}).show();
										}
									}]
								}
								panelItems = {
									autoScroll: false,
									scroll: false,
									layout: {
										type: 'fit',
										align: 'stretch'
									},
									items:[
									{
										xtype: 'panel',
										scroll: true,
										autoScroll: false,
										layout: {
											type: 'auto',
											pack: 'start',
											align: 'stretch'
										},
										flex: 1,
										defaults:{
											margin:10,
										},
										items: [
											pieChartPanel,
											topConvGridPanel
										]
									}]
								};
							}
							else
							{
								var pieChartTitle = topConvData['PIE_TITLE'];
								//pieChartTitle += " - "+flowsInterfaceSelectedCombo;
								var pieChartData = topConvData['pieChart'];
								
								var pieChartWidth = 400;
								if(pieChartData.length == 1)
									pieChartWidth = 950;
								if(pieChartTitle.length > 110){
									pieChartTitle = pieChartTitle.substr(0,105)+'...';
								}
								var pieChartPanel = {
									xtype:'genericpiechartslider',
									data:pieChartData,
									template:function(){
										var me = this;
										var sliderItems={};
										if(Ext.isEmpty(NOMSG)){
										sliderItems = new Ext.XTemplate(
											'<ul>',
											'<tpl for=".">',
												'<li ><div  class="netFlowPieChartRightBorder" style="margin:5 auto 10px 0"><div style="text-align:center;margin:10px 5px 0px 5px;">{XML_DATA.title}</div><div id="chart4holder{#}"></div></div></li>',
											'</tpl>',
											'</ul>'
											
										);
										}else{
											sliderItems = new Ext.XTemplate(
											'<ul>',
											'<li><table width="100%" height="200px"><tr><td valign="middle" align="center"><div class="iconInformation" ></div><div > '+noMeasureExcl+'</div></td></tr></table></li>',
											'</ul>'
											
										);
										}
											return sliderItems;
									},
									loadChart:function(data){
										var me = this;
										if(!Ext.isEmpty(data)){
											var count =1;
											for (var key in data)
											{
												var counter = count++;
													try {
													var barChart = {};
													barChart = jQuery.extend(true, {}, getPieChartsforNetflow('chart4holder'+counter, 250, pieChartWidth), barChart);
													barChart.setData(data[key]['XML_DATA'], currentDateFormat, '', 'ProtocolPieNetflow');
													barChart.drawChart();
												} catch (barChartEx) {
													console.log(barChartEx);
												}
												$(window).resize(function(){
													if(Ext.isEmpty(NOMSG)){
														if($("#"+"chart4holder"+counter).highcharts() != undefined)
														{
															$("#"+"chart4holder"+counter).highcharts().reflow();
														}
													}
												});
											}
										}
									},
									tab:'TopConversations',
									title:pieChartTitle
								};

								var tableData = topConvData['tableData'];
								var tableTitle = tableData[0]['TABLE_TITLE'];
								//tableTitle += " - "+flowsInterfaceSelectedCombo;
								var tableColumns = tableData[0]['tableColumns'];
								var gridValues = tableData[0]['gridValues'];
								var fieldModel = new Array();
								var columns = new Array();
								var colIdx = 0;
								for (var key in tableColumns) {
									fieldModel.push({
										name: 'COLUMVal_' + colIdx,
										type: 'string'
									});
									columns.push({
										header: tableColumns[key],
										dataIndex: 'COLUMVal_' + colIdx,
										align: 'left',
										flex: 1,
										sortable: true,
										renderer: function(value, metaData, record, row, col, store, gridView)
										{
											var column = gridView.getHeaderAtIndex(col);
											var dataIndexVal = column.dataIndex;
											if (dataIndexVal != null && dataIndexVal == "COLUMVal_5") 
											{
												if(value!=null && value!="-")
												{
													if(value>0.0)
													{
														var barStr = '<table width="100%" cellpadding="0" cellspacing="0" border="0"  height="8" class="prog_border">';
														barStr += '<tr>';
														barStr += '<td align="left" width="100%" height="8" >';
														barStr += '<table width="' + value + '%" height="8"  cellpadding="0" cellspacing="0" border="0">';
														barStr += '<tr>';
														barStr += '<td class="progress_GOOD" width="100%"> </td>';
														barStr += '</tr>';
														barStr += '</table>';
														barStr += '</td>';
														barStr += '</tr>';
														barStr += '</table>';

														value = "<table width='100%' cellpadding='0' cellspacing='0'><tr><td style='width:50px'><span>" + value
														+ "</span></td><td >" + barStr + "</td></tr></table>";
													}
												}
											}
											return value;
										}
									});
									colIdx++;
								}
								var gridPageSize;
								if(selectedEventsPerPage == undefined || selectedEventsPerPage == 'undefined'){
									gridPageSize = parseInt(eventsPerPageArray[0].valueField);
								} else{
									gridPageSize = parseInt(selectedEventsPerPage);
								}
								var queryParams='';
								var tmpURL = '';
								var qryParamsObj={};
								if(netflowLastLoadedURL!=null && netflowLastLoadedURL.indexOf("?")>-1)
								{
									tmpURL = netflowLastLoadedURL.substr(0,netflowLastLoadedURL.indexOf("?"));
									queryParams=netflowLastLoadedURL.substr(netflowLastLoadedURL.indexOf("?")+1);
									if(!Ext.isEmpty(queryParams))
									{
										var queryParamsArr=queryParams.split('&');									
										for(var q in queryParamsArr)
										{
											var reqParam=queryParamsArr[q];
											if(reqParam!=null && reqParam.indexOf("=")>-1)
											{
												var reqKey=reqParam.substr(0,reqParam.indexOf("="));
												var reqvalue=reqParam.substr(reqParam.indexOf("=")+1);
												if(reqKey.toLowerCase()=='timeline')
												{
													reqvalue=reqvalue.replace(/\+/g, '%20');
												}
												qryParamsObj[reqKey]=decodeURIComponent(reqvalue);
											}
										}
										//qryParamsObj['tab']='Top Conversations';
										qryParamsObj['flowsTest']='TopConverTest';
										qryParamsObj['isFromGridPage']='true';									
									}
								}
								var ackStore = Ext.create('Ext.data.Store',{
									fields: fieldModel,
									pageSize: gridPageSize,
									autoLoad: true,
									proxy: {
										type: 'ajax',
									actionMethods:  {
										create: "POST",
										read: "POST",
										update: "POST",
										destroy: "POST"
									},
									//limitParam : 'undefined',
									url: tmpURL,
									extraParams : qryParamsObj,									
										reader: {
											type: 'json',
											root : 'gridValues',
											page:'page',
											start:'start',
											limit:'limit',
											totalProperty : 'totalCount'
										}
									},
									listeners: {
										load: function(store, records, successful, eOpts) {
											var configPanl = Ext.getCmp('netflowmainpanel');
											if (successful) {
													configPanl.setLoading(false, false);
																		
											}else{
												configPanl.setLoading(true, true);
											}
										}
									}
								});
								var bbar;
								ackStore.on("load", function(component, records) {					
									var storeLength = ackStore.data.length;
									var currentPageSize = ackStore.pageSize;
									var currentTotalCount = ackStore.totalCount;
									var currentPage ='';
									if(ackStore.proxy.reader.rawData != null)
									{
										currentPage = ackStore.proxy.reader.rawData.page;
									}
									var pageSize = ackStore.pageSize;
									var totalpages = currentTotalCount/pageSize;
									totalpages = totalpages.toString();
									if(totalpages.indexOf('.') >-1)
									{
										totalpages = parseInt(totalpages);
										totalpages = totalpages +1;

									}else{
										totalpages = parseInt(totalpages);
									}

									if(currentPage > totalpages)
									{
										currentPage = totalpages;
										//store.loadPage(currentPage);
										configPanl.setLoading(true, true);
										
									}										  

									if((currentTotalCount-storeLength) == 0 ||  (currentPage == 1 && currentTotalCount <= currentPageSize) )
									{
										Ext.getCmp('pagingtoolbar').hide();
									}else{
										Ext.getCmp('pagingtoolbar').show();
									}
								});
								var gridHeight = Ext.getBody().getHeight()-390;
								if(gridHeight <350){
									gridHeight = 350;
								}
								topConvGridPanel = {
									xtype: 'grid',
									id:'gridDisplay',
									store: ackStore,
									margin:'0 10 10 10',
									title: tableTitle,
									flex:1,
									height:gridHeight,
									cls: 'gridSkin',
									header:{
										style:{
											'padding':'2px 10px 0px 10px' 
										}
									},
									columns: columns,
									bbar: new Ext.PagingToolbar({
										store:ackStore,
										id:'pagingtoolbar',
										cls:"pagingtoolbar",
										pageSize:gridPageSize,
										displayInfo: true,
										displayMsg:"Displaying {0} - {1} of {2}",
										listeners:{
											beforechange:function(){
												var searchTextBoxObj=Ext.getCmp('gridSearch');
												if(searchTextBoxObj != null)
												 {
													var searchValue = searchTextBoxObj.value ;
													if(searchValue != '')
													{
														var grid = Ext.getCmp('gridDisplay');
														if(grid != '')
														{
															grid.store.filters.clear();
														}
														searchTextBoxObj.reset();
													}
												 }
											}
										}
									}),
									tools: [{
										xtype:'tbfill',
									},
									{
										xtype: 'trigger',
										trigger1Cls: 'x-form-clear-trigger',
										trigger2Cls: 'x-form-search-trigger',
										name: 'gridSearch',
										margin: '0 10 2 10',
										id: 'gridSearch',
										cls: 'whitedropdown_search',
										emptyText: searchLbl,
										labelAlign: 'top',
										width: 200,
										hidden: false,
										getTriggerMarkup: function() {
											var me = this,
												i = 0,
												hideTrigger = (me.readOnly || me.hideTrigger),
												triggerCls,
												triggerBaseCls = me.triggerBaseCls,
												triggerConfigs = [],
												unselectableCls = Ext.dom.Element.unselectableCls,
												style = 'width:' + me.triggerWidth + 'px;' + (hideTrigger ? 'display:none;' : ''),
												cls = me.extraTriggerCls + ' ' + Ext.baseCSSPrefix + 'trigger-cell ' + unselectableCls;

											// TODO this trigger<n>Cls API design doesn't feel clean, especially where it butts up against the
											// single triggerCls config. Should rethink this, perhaps something more structured like a list of
											// trigger config objects that hold cls, handler, etc.
											// triggerCls is a synonym for trigger1Cls, so copy it.
											if (!me.trigger1Cls) {
												me.trigger1Cls = me.triggerCls;
											}

											// Create as many trigger elements as we have trigger<n>Cls configs, but always at least one
											for (i = 0; (triggerCls = me['trigger' + (i + 1) + 'Cls']) || i < 1; i++) {
												if (i == 0)
												{
													triggerConfigs.push({
														tag: 'td',
														role: 'presentation',
														valign: 'top',
														cls: cls,
														id : 'MyTrigger_'+i,
														style: style + "display:none;",
														cn: {
															cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
															role: 'presentation'
														}
													});
												}
												else
												{
													triggerConfigs.push({
														tag: 'td',
														role: 'presentation',
														valign: 'top',
														cls: cls,
														id : 'MyTrigger_'+i,
														style: style,
														cn: {
															cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
															role: 'presentation'
														}
													});
												}
											}
											triggerConfigs[0].cn.cls += ' ' + triggerBaseCls + '-first';
											return Ext.DomHelper.markup(triggerConfigs);
										},
										onTrigger1Click: function () {
										this.reset();
										},
										onTrigger2Click : function() {
											appCnt.textFieldSearch();
										},
										
									},{ 
										xtype: 'button',
										iconCls: 'iconMaximize',
										style:{'background':'transparent','border':'none'},
										listeners:{
											'afterrender': function () {
													Ext.create('Ext.tip.ToolTip', {
														target: this.id,
														anchor: 'top',
														cls: 'yellowTip',
														trackMouse: true,
														html:maximizeViewLbl
													});
												}
										},
										handler: function()
										{
											var ackMaxStore = Ext.create('Ext.data.Store',{
												fields: fieldModel,
												pageSize: gridPageSize,
												autoLoad: true,
												proxy: {
													type: 'ajax',
													url: netflowLastLoadedURL+"&tab=Top Conversations&flowsTest=TopConverTest&isFromGridPage=true",
													reader: {
														type: 'json',
														root : 'gridValues',
														page:'page',
														start:'start',
														limit:'limit',
														totalProperty : 'totalCount'
													}
												},
												listeners: {
													load: function(store, records, successful, eOpts) {
														var configPanl = Ext.getCmp('netflowmainpanel');
														if (successful) {
																configPanl.setLoading(false, false);
																					
														}else{
															configPanl.setLoading(true, true);
														}
													}
												}
											});
											var bbar;
											ackMaxStore.on("load", function(component, records) {					
												var storeLength = ackMaxStore.data.length;
												var currentPageSize = ackMaxStore.pageSize;
												var currentTotalCount = ackMaxStore.totalCount;
												var currentPage ='';
												if(ackMaxStore.proxy.reader.rawData != null)
												{
													currentPage = ackMaxStore.proxy.reader.rawData.page;
												}
												var pageSize = ackMaxStore.pageSize;
												var totalpages = currentTotalCount/pageSize;
												totalpages = totalpages.toString();
												if(totalpages.indexOf('.') >-1)
												{
													totalpages = parseInt(totalpages);
													totalpages = totalpages +1;

												}else{
													totalpages = parseInt(totalpages);
												}

												if(currentPage > totalpages)
												{
													currentPage = totalpages;
													configPanl.setLoading(true, true);
												}										  
												if((currentTotalCount-storeLength) == 0 ||  (currentPage == 1 && currentTotalCount <= currentPageSize) )
												{
													Ext.getCmp('maxPagingtoolbar').hide();
												}else{
													Ext.getCmp('maxPagingtoolbar').show();
												}
											});
											var gridMaxView = Ext.create('utilities.GenericWindow',
											{
												title:tableTitle,
												width: '90%',
												height: '90%',
												cssMask:true,
												padding:'5 10 10 10',
												resizable   : false,
												draggable   : true,
												closeAction: 'destroy',
												layout:'fit',
												scroll:true,
												border:false,
												items:{
													xtype:'grid',
													store: ackMaxStore,
													columns: columns,
													layout:'fit',
													cls: 'gridSkin',
													bbar: new Ext.PagingToolbar({
														store:ackMaxStore,
														id:'maxPagingtoolbar',
														cls:"pagingtoolbar",
														pageSize:gridPageSize,
														displayInfo: true,
														displayMsg:"Displaying {0} - {1} of {2}",
														listeners:{
															beforechange:function(){
																var searchTextBoxObj=Ext.getCmp('gridSearch');
																if(searchTextBoxObj != null)
																 {
																	var searchValue = searchTextBoxObj.value ;
																	if(searchValue != '')
																	{
																		var grid = Ext.getCmp('gridDisplay');
																		if(grid != '')
																		{
																			grid.store.filters.clear();
																		}
																		searchTextBoxObj.reset();
																	}
																 }
															}
														}
													}),
												},
												autoScroll: true,
												bodyStyle:{'overflow-y': 'auto'},
											}).show();
										}
									}]
								}
								panelItems = {
									autoScroll: false,
									scroll: false,
									layout: {
										type: 'fit',
										align: 'stretch'
									},
									items:[
									{
										xtype: 'panel',
										scroll: true,
										autoScroll: false,
										layout: {
											type: 'auto',
											pack: 'start',
											align: 'stretch'
										},
										flex: 1,
										defaults:{
											margin:10,
										},
										items: [
											pieChartPanel,
											topConvGridPanel
										]
									}]
								};
							}
						}
						else
						{
							if (errorMsg=='undefined' || errorMsg == undefined)
							{
								errorMsg = noMeasure +"!";
							}
							panelItems = {
								autoScroll: false,
								scroll: false,
								height:getHeightForNoMeasures,
								layout: {
									type: 'fit',
									align: 'stretch'
								},
								scroll: false,
								autoScroll: false,
								flex:1,
								items:[{
									xtype:'container',
									html:'<table width="100%" height="100%"><tr><td valign="middle" align="center"><div class="iconInformation" ></div><div>'+errorMsg+'</div></td></tr></table>' 
								}]
							};  
						}
					}
				}
			});
		}
		return panelItems;
	},
	loadTabPanel: function() 
	{
		var me = this;
		var tab=["Overview","Protocols","Top Sources","Top Destinations","Top Conversations"];
		var tabItems = [];
		
		netflowLastLoadedURL = "/final/monitor/EgNetflowDashboardJSON.jsp?tab=Network&hostName="+encodeURIComponent(requestParams.hostName)+"&compType="+encodeURIComponent(componentType)+"&ciscoSelectedType=overview&screenWidth=1012&screenHeight=570";
		
		Ext.Ajax.request({
			url:netflowLastLoadedURL,
			method: 'POST',
			success: function(response) {

				if (response.status == 200 && !Ext.isEmpty(response.responseText)) {

					var jsonText = response.responseText;	
					var jsonData = Ext.decode(jsonText);
					var interfaceArr = jsonData['interfaceArr'];
					var protocolsURL = jsonData['protocolsURL'];
					var flowsURL = jsonData['flowsURL'];
					var activeTab = localStorage.getItem("netflowactivetab");
					if(activeTab==null || activeTab=='null' || activeTab=='')
					{
						activeTab = 'topconversations';
					}
					
					for (var i=0;i<tab.length;i++) {
						var data1='';
						var URL='';
						var tabTitle =overviewLbl;
						if(tab[i]=='Overview')
						{
							data1 = jsonData;
							tabTitle =overviewLbl;
						}
						else if(tab[i]=='Protocols')
						{
							URL = protocolsURL;
							tabTitle =protocolsLbl;
						}
						else if(tab[i]=='Top Sources')
						{
							URL = flowsURL;
							tabTitle =sourcesLbl;
						}
						else if(tab[i]=='Top Destinations')
						{
							URL = flowsURL;
							tabTitle =destinationsLbl;
						}
						else if( tab[i]=='Top Conversations')
						{
							URL = flowsURL;
							tabTitle =conversationsLbl;
						}
						tabItems.push({
							title: tabTitle,
							id:tab[i].replace(/\s/g,'').toLowerCase(),
							data: data1,
							DataURL: URL,
							selectedTimeline:'',
							timelineComboArray:'',
							selectedTimelineCombo:'',
							flowsInterfaceCombo:'',
							flowsInterfaceSelectedCombo:'',
							showComboArray:'',
							selectedShowCombo:'',
							timelineTitle:'',
							eventsPerPageArray:'', 
							selectedEventsPerPage:'',
						});
					}
					me.getNetflowmainpanel().removeAll();
					me.getNetflowmainpanel().add(tabItems);
					if (activeTab == 'topconversations') {
						me.getNetflowmainpanel().setActiveTab(4);
					}
					else if (activeTab == 'topdestinations') {
						me.getNetflowmainpanel().setActiveTab(3);
					}
					else if (activeTab == 'topsources') {
						
						me.getNetflowmainpanel().setActiveTab(2);
					}
					else if (activeTab == 'protocols') {
						me.getNetflowmainpanel().setActiveTab(1);
					}
					else{
						me.getNetflowmainpanel().setActiveTab(0);
					}
					if(!Ext.isEmpty(netflowMask))
					{
						Ext.destroy(netflowMask);
						delete netflowMask;
					}
				}
			}
		});
		
	},
	netflowmainpanelRender: function(netflowmainpanelObj) {
			
		var me = this;
		me.loadTabPanel();
	},
	netflowmainpanelBeforeRender: function(netflowmainpanelObj) {
		
		netflowMask = new Ext.LoadMask(Ext.getCmp('ComponentTabPanelId'), {
			msg:loadingLbl+', please wait...',
		});
		netflowMask.show();
	},
	
	showConfigDropdown:function(newCard){
		var isOverviewTab = false;
		var heightVal = 250;
		//var marginLeft='0px';
		if(newCard.title == "Overview"){
			isOverviewTab = true;
			heightVal = 150;
			//marginLeft='250px';
		}
		var me = this;
			var tpl = new Ext.XTemplate('<div style="float:left;margin:0px 0px 0px 4px;color:#f7f7f7" class="settingsfont">'+settingLbl+'</div><div class="iconBg"><div style="text-align:right;float:right;"><div class="iconClose3" id="closeSettings" onclick="JavaScript:closeWin()"></div></div>');
			//config dropdown mode
			var gridMaxSizelabelWidth = 130;
			var gridMaxSizeWidth = 200;
			var activeTabId = newCard.getId();
			if(activeTabId == "topdestinations" || activeTabId == "topconversations")
			{
			    gridMaxSizelabelWidth = 170;
			    gridMaxSizeWidth = 240;
			}
			Ext.create('Ext.container.Container',{
			width:650,
			height:heightVal,
			padding:5,
			id:'configMod_summary',
			name : 'configMod_summary',
			cls:'configMode_popup',
			closeAction: 'destroy',
			items:[{
					xtype:'container',
					cls:'configMode_popupArrow',
					style:{'top':'-14px','left':'618px'}
				},{
					xtype:'container',
					html:tpl.apply(),
					style:{'top':'0px','margin':'2px'}
				},
				{
					xtype: 'panel',
					cls:'configMode_popup_inner',
					
					header: false,
					border: false,
					frame: false,
					layout:{
						type:'vbox',
						pack:'center',
						align:'left'
					},
					flex:1,
					height:heightVal-50,
					defaults: {
						labelAlign: 'top',
						margin: "10 10 10 10",
						labelSeparator: "",
						editable: false
					},
					margin:'0 10 0 10',
					items: [{
						xtype:'container',
						margin:'0 20 10 20',
						layout:{
							type:'hbox'
							
							
						},
						items:[
							{
						xtype:'container',
						
						//margin:'10 0 10 22',
						hidden:isOverviewTab,
						items: [{
							fieldLabel: interfacesLbl,
							labelAlign:'top',
							//xtype: 'checkcombo',
							xtype: 'scrollcombo',
							width: 300,
							id:'flowInterfaces',
							name:'flowInterfaces',
							margin:'0 10 0 0',
							editable: false,
							//multiSelect:true,
							//forceSelection:true,
							labelWidth:80,
							baseCls:'emptyCls',
							queryMode: 'local',
							labelSeparator:'',
							valueField: 'valueField',
							displayField: 'displayField',
							cls:'dropdown',
							//emptyText:'All interfaces',
							//allText: 'All interfaces',
							store:new Ext.data.Store({
								fields: ['valueField','displayField'],
								data: []
							}),
							//addAllSelector: true,
							listeners:
							{
								'select': function(obj)
								{
									Ext.defer(function(){
										me.selectFlowInterfaces(obj);
									},500);
								}
								
							}
						},
						]
					},{	
						xtype:'container',
						
						
						//margin:'10 10 10 22',
						hidden:isOverviewTab,
						items: [{
							xtype:'scrollcombo',
							fieldLabel:showLbl,
							labelWidth:45,
							width:150,
							margin:'0 20 0 10',
							//margin:'10 10 0 22',
							labelAlign:'top',
							queryMode: 'local',
							displayField: 'displayField',
							valueField: 'valueField',
							labelSeparator:'',
							cls: 'dropdown',
							id:'showCombo',
							name:'showCombo',
							editable:false,
							//hidden:isOverviewTab,
							store:new Ext.data.Store({
								fields: ['valueField','displayField'],
								data:[]
							}),
							listeners:
							{
								'select': function(obj)
								{
									
									Ext.defer(function(){
										me.showSelect(obj);
									},500);
								}
							}
						}
						]

					}
						]
						
						},{
						xtype:"splitter",height:2,margin:"2px 0px 0px 2px",draggable:false,hidden:isOverviewTab,style:{"cursor":"default"}
					},{
						xtype:'timeline',
						cls:'timeline_left',
						id: 'timelineCombo',
						name: 'timelineCombo',
						width: 570,
						margin:'10 0 0 10',
						hidden: false,
						hideMinutes : false,
						layout:{
							type:'hbox',
							pack:'center',
							align:'center'
						},
					},			
					
					{
						xtype:"splitter",height:2,margin:"2px 0px 0px 2px",draggable:false,hidden:isOverviewTab,style:{"cursor":"default"}
					},
					
					{
						xtype:'button',
						text:'Submit',
						style:{'margin-left':'250px'},
						text:submitLbl,
						cls:"button20",
						margin:'10 10 10 255',
						width:60,
						id:"submitSettings",
						name:"submitSettings",
						listeners: {
							
							"click": function() {
								
								var timeline = Ext.getCmp("er_timeline").getValue();
								
								if(timeline=="Any"){
																														
									var startDate = Ext.getCmp("er_stdate").getValue();
									var startHr = Ext.getCmp("er_sthr").getValue();
									var startMin = Ext.getCmp("er_stmin").getValue();
									var endDate = Ext.getCmp("er_enddate").getValue();
									var endHr = Ext.getCmp("er_endhr").getValue();
									var endMin = Ext.getCmp("er_endmin").getValue();
									startDate=Ext.Date.dateFormat(startDate,"m/d/Y");
									endDate=Ext.Date.dateFormat(endDate,"m/d/Y");
									
									var sDate=startDate+" "+startHr+":"+startMin;
									var eDate=endDate+" "+endHr+":"+endMin;
									
									if(new Date(sDate).getTime()>=new Date(eDate).getTime())
									{
										Ext.Msg.show({
													title: alertLbl,
													msg: startDlessE+'.',
													buttons: Ext.Msg.OK,
													width: 400,
													icon: 'iconExclamation'
													});
											return;
									}
									timeline = "Any "+startDate+" "+startHr+":"+startMin+":00|"+endDate+" "+endHr+":"+endMin+":00";
									
								}
								Ext.getCmp('configMod_summary').destroy();
								netflowMask = new Ext.LoadMask(Ext.getCmp('ComponentTabPanelId'), {
									msg: loadingLbl+'...',
								});
								netflowMask.show();
								if(isOverviewTab){
									me.overviewTimelineSelect(timeline);
								}
								else {
									Ext.defer(function(){
										me.timelineSelect(timeline);
									},500);
								}
							}
						}
					}
				]
			}],
			renderTo:'ComponentTabPanelId-body'
		});
		this.setValueWithOptionInList('er_timeline',newCard.timelineComboArray,newCard.selectedTimelineCombo);
		Ext.getCmp('er_timeline').fireEvent('select',Ext.getCmp('er_timeline'));
		this.setValueWithOptionInList('flowInterfaces', newCard.flowsInterfaceCombo, newCard.flowsInterfaceSelectedCombo );
		this.setValueWithOptionInList('showCombo', newCard.showComboArray, newCard.selectedShowCombo );
		this.setValueWithOptionInList('eventsPerPage', newCard.eventsPerPageArray, newCard.selectedEventsPerPage );
	},
});
function closeWin(){
	Ext.getCmp('configMod_summary').destroy();
	Ext.getCmp('settingsBtn').setDisabled(false);
}

