var isFlag = true;
var isTabularViewClicked = false;
var ciscoData = '';
Ext.define('componentDashboard.controller.NetworkController', {
    extend: 'Ext.app.Controller',
	//reqiures:['componentDashboard.view.network.NetworkMainPanel'],
	requires : ['componentDashboard.view.network.NetworkMainPanel','utilities.ScrollTabPanel','componentDashboard.view.network.SubNetworkPanel','componentDashboard.view.network.SubNetworkTabPanel','componentDashboard.view.network.NetworkTimeLinePanel','componentDashboard.view.network.ciscoMainPanel','componentDashboard.view.network.networkFullViewPanel','utilities.CustomGrid'],
    refs:[
		{ref:'subnetworkpanel', selector:'subnetworkpanel'},
		{ref:'networkmainpanel', selector:'networkmainpanel'},
		{ref:'subnetworktabpanel', selector:'subnetworktabpanel'},
    	{ref:'networktimeline', selector:'networktimeline'},
    	{ref:'ciscomainpanel', selector:'ciscomainpanel'},
    	{ref:'subciscopanel', selector:'subciscopanel'},
		{ref:'ciscodialpanel', selector:'ciscodialpanel'},
		{ ref: 'maximizeview',selector: 'maximizeview'},
		{ref: 'main',selector: 'main'},		
		{ref: 'protocolspanel',selector: 'protocolspanel' },
		{ref: 'ciscoflowspanel',selector: 'ciscoflowspanel' },
		{ref:'networkfullviewpanel', selector:'networkfullviewpanel'}
		],
    init: function()
	{
	   networkController = this;
	   this.control({
		   'subnetworkpanel combo[id="networksubsystem"]':
		   {
				'select': this.selectSubSystem
		   },
		   'networkmainpanel':
		   {
				'beforeshow': this.beforeShowNetworkPanel
		   },
		   'subciscopanel combo[id="ciscosubsystem"]':
		   {
				'select': this.selectCiscoSubSystem
		   },
		   'ciscodialpanel button[id="cisco_TabularView"]':
		   {
				'click':this.onTabularViewButton
		   },
		   'ciscodialpanel button[id="cisco_FullGridView"]':
			{
				'click':this.onFullGridViewButton
			},
			'ciscodialpanel combo[id="cisco_Timeline"]':
			{
				select:this.onSelectTimeLine
			},
			'ciscodialpanel button[id="cisco_DialGridButton"]':
			{
				'click':this.dialGridViewButton
			},
			'protocolspanel combo[id="interfaceCombo"]':
		    {
				'select':this.interfaceComboLoad
		    },
			'subciscopanel combo[id="flowInterfaces"]':
		    {
				'select': this.selectFlowInterfaces
		    },
			'networkfullviewpanel':
			{
				'boxready': this.loadFullViewPanel
			},
			'maximizeview':
			{
				'boxready': this.loadMaximizedView
			}
	   });
    },
	selectSubSystem: function( obj )
    {
    	var getVal = obj.getValue();
		netLastLoadedURL = '';		// To reset the URLs and Tabs
    	netCurrentTabId = '';
		netLastGraphTypeLoaded = '';
    	if ( getVal != undefined )
    	{
    		if ( getVal.toLowerCase() == 'overview' )
    		{
    			Ext.getCmp('Netoverviewpanel').show();
    		}
    		else
    		{
    			Ext.getCmp('Netoverviewpanel').hide();
    		}
    		var subsystem = Ext.getCmp('networksubsystem').getValue();
			if ( Ext.isEmpty( subsystem ) || subsystem.length == 0 )
			{
				subsystem = 'Overview';
			}
			Ext.getCmp('networkmainpanel').fireEvent('beforeshow', Ext.getCmp('networkmainpanel'));
    	}
    },
	networkDefaultLoad: function(jsonData)
	{
		if(Ext.getCmp('subNetworkPanelId')==null || Ext.getCmp('subNetworkPanelId')==undefined)
		{
			this.getNetworkmainpanel().add(
				{
				xtype:'subnetworkpanel',
				id:'subNetworkPanelId',
				name:'subNetworkPanelId',
				margin:0,
				bodyPadding:0,
				border:true
			}
			,{
				xtype:'subnetworktabpanel',
				id:'subnetworktabpanelID',
				name:'subnetworktabpanelID'
			},
			{
				xtype:'ciscomainpanel',
				hidden:true
			});
		}

		var fullviewIdObj = Ext.getCmp('net_fullviewId');
		if(fullviewIdObj!=null)
		{
			fullviewIdObj.destroy();
			Ext.getCmp('subNetworkPanelId').show();
			Ext.getCmp('subnetworktabpanelID').show();
		}
		var isFlag = 'default';
		isNetworkTabSelected = true;
		Ext.getCmp('networkmainpanel').suspendEvents(true);
		var objectArr = new Array();
		var me = this;
		if ( jsonData != '' && jsonData != null && !Ext.isEmpty(jsonData))
		{
			var screenLabels = jsonData['screenLabels'];
			objectArr['networksubsystem'] = screenLabels['subsystemTitle'];
			me.loadScreenLabels(objectArr);
			var subsystemCombo = jsonData['subsystemCombo'];
			var selectedValues = jsonData['selectedValues'];
			me.setValueWithOptionInList('networksubsystem', subsystemCombo, selectedValues['subsystemSelected']);
			var subsystem = jsonData['SUBSYSTEM'];
		//	publicJSON = jsonData;

			if ( subsystem != undefined )
			{
				if ( subsystem.toLowerCase() == 'overview' )
				{
					Ext.getCmp('Netoverviewpanel').show();
					var overviewData = jsonData['OVERVIEW'];
					me.showOverview(overviewData);
					var getTabURL = jsonData['TAB_URL'];
					/*var selectedGraphType = jsonData['selectedGraphType'];
					if(selectedGraphType!=null && selectedGraphType!="" && selectedGraphType.toLowerCase()!="null")
					{
						if(selectedGraphType=="Network_summaryGraph" || selectedGraphType=="Network_trendGraph")
						{
							netCurrentTabId = "Network_measureGraph";
						}
						else
						{
							netCurrentTabId = selectedGraphType;
						}
					}
					else
					{
						selectedGraphType = Ext.getCmp('Nettabpanel').getActiveTab().getId();
					}*/

					me.showTabs(getTabURL);
					/*var getInnerTabURL = jsonData['INNER_TAB_URL'];
					getInnerTabURL = encodeURI(getInnerTabURL);
					if ( !Ext.isEmpty( netCurrentTabId ) )
					{
						me.loadInnerTab(netCurrentTabId, getInnerTabURL,isFlag);
					}
					else
					{
						me.loadInnerTab(selectedGraphType, getInnerTabURL,isFlag);
					}*/
					var getTabName = Ext.getCmp(Ext.getCmp('Nettabpanel').getActiveTab().getId()).tabName;
		
					if ( getTabName.toLowerCase() == 'history' && isDisableTrendComputation == false)
					{
						Ext.getCmp('net-history-tool').show();
						Ext.getCmp('net-calendar-tool').show();
						Ext.getCmp('net-history-tool').show();
						Ext.getCmp('net-summary-tool').show();
						Ext.getCmp('net-area-tool').show();
						//Ext.getCmp('net-calendar-btn').fireEvent('loadTime', Ext.getCmp('net-calendar-btn'));
					}
					else
					{
						Ext.getCmp('net-history-tool').hide();
						Ext.getCmp('net-calendar-tool').hide();
						Ext.getCmp('net-history-tool').hide();
						Ext.getCmp('net-summary-tool').hide();
						Ext.getCmp('net-area-tool').hide();
					}
				}
				else
				{
					Ext.getCmp('Netoverviewpanel').hide();
					var getTabURL = jsonData['TAB_URL'];
					/*var selectedGraphType = jsonData['selectedGraphType'];
					if(selectedGraphType!=null && selectedGraphType!="" && selectedGraphType.toLowerCase()!="null")
					{
						if(selectedGraphType=="Network_summaryGraph" || selectedGraphType=="Network_trendGraph")
						{
							netCurrentTabId = "Network_measureGraph";
						}
						else
						{
							netCurrentTabId = selectedGraphType;
						}
					}
					else
					{
						selectedGraphType = Ext.getCmp('Nettabpanel').getActiveTab().getId();
					}*/

					me.showTabs(getTabURL);
					/*var getInnerTabURL = jsonData['INNER_TAB_URL'];
					getInnerTabURL = encodeURI(getInnerTabURL);
					if ( !Ext.isEmpty( netCurrentTabId ) )
					{
						me.loadInnerTab(netCurrentTabId, getInnerTabURL,isFlag);
					}
					else
					{
						me.loadInnerTab(selectedGraphType, getInnerTabURL,isFlag);
					}*/

					var getTabName = Ext.getCmp(Ext.getCmp('Nettabpanel').getActiveTab().getId()).tabName;
					if ( getTabName.toLowerCase() == 'history' && isDisableTrendComputation == false )
					{
						Ext.getCmp('net-history-tool').show();
						Ext.getCmp('net-calendar-tool').show();
						Ext.getCmp('net-history-tool').show();
						Ext.getCmp('net-summary-tool').show();
						Ext.getCmp('net-area-tool').show();
						//Ext.getCmp('net-calendar-btn').fireEvent('loadTime', Ext.getCmp('net-calendar-btn'));
					}
					else
					{
						Ext.getCmp('net-history-tool').hide();
						Ext.getCmp('net-calendar-tool').hide();
						Ext.getCmp('net-history-tool').hide();
						Ext.getCmp('net-summary-tool').hide();
						Ext.getCmp('net-area-tool').hide();
					}
				}
			}
			Ext.getCmp('networkmainpanel').resumeEvents();
			var mask = null;
			var wholeViewport = document.getElementsByTagName("body")[0];
			if ( !Ext.isEmpty( Ext.get( wholeViewport ) ) )
			{
				mask = new Ext.LoadMask(Ext.get(wholeViewport), {msg:loadingLbl+"...",cls:'maskDash'});
				mask.hide();
			}
		}
	},
	beforeShowNetworkPanel : function( obj )
	{

		if(Ext.getCmp('subNetworkPanelId')==null || Ext.getCmp('subNetworkPanelId')==undefined)
		{
			this.getNetworkmainpanel().add(
				{
				xtype:'subnetworkpanel',
				id:'subNetworkPanelId',
				name:'subNetworkPanelId',
				margin:0,
				bodyPadding:0,
				border:true
			}
			,{
				xtype:'subnetworktabpanel',
				id:'subnetworktabpanelID',
				name:'subnetworktabpanelID'
			},
			{
				xtype:'ciscomainpanel',
				hidden:true
			});
		}

		if ( Ext.getCmp('componentsDropDown') != undefined && Ext.getCmp('componentsDropDown') != null )
		{
			var getCmpVal = Ext.getCmp('componentsDropDown').getValue();
			if ( !Ext.isEmpty( getCmpVal ) )
			{
				componentType = getCmpVal.substring(0, getCmpVal.indexOf(':'));
				componentName = getCmpVal.substring(getCmpVal.indexOf(':')+1);
			}
		}
		if(isIncludedNetflowDeviceAvailable || isExcludedNetflowDeviceAvailable)
		{
			Ext.getCmp('ciscomainpanel').show();
			Ext.getCmp('subNetworkPanelId').hide();
			Ext.getCmp('subnetworktabpanelID').hide();
			this.afterCiscoPanelRendered( obj );
			return;
		}
		var getElObj = Ext.getCmp(obj.getId()).getEl();
		getElObj.mask(loadingLbl+"...", "maskCenter");
		var me = this;
		var subsystem = Ext.getCmp('networksubsystem').getValue();

		if ( Ext.isEmpty( subsystem ) || subsystem.length == 0 )
		{
			subsystem = 'Overview';
		}

		netLastLoadedURL = '/final/monitor/egNetDashBoardJSON.jsp?tab=Network&hostName='+encodeURIComponent(requestParams.hostName)+'&compType='+encodeURIComponent(componentType)+'&subsystem='+encodeURIComponent(subsystem)+'&screenWidth=1012&screenHeight=570&host='+encodeURIComponent(requestParams.compname)+'&time_line=24 hours&starttime=&endtime=&starthr=&endhr=&format='+encodeURIComponent(dateFormatForTimeline);

		if( netLastGraphTypeLoaded!=null && netLastGraphTypeLoaded!=null && !Ext.isEmpty(netLastGraphTypeLoaded) && netLastGraphTypeLoaded!=undefined)
		{
			if( netLastLoadedURL.indexOf('graphType') > -1 )
			{
				netLastLoadedURL=netLastLoadedURL.replace(/(graphType=)[^\&]+/, '$1' + netLastGraphTypeLoaded);
			}
			else
			{
				netLastLoadedURL += "&graphType="+netLastGraphTypeLoaded;
			}
		}

		Ext.Ajax.request({
			//url: '/final/monitor/egNetDashBoardJSON.jsp',
			url: netLastLoadedURL,
			method: 'POST',
			//params: 'tab=Network&hostName='+encodeURIComponent(requestParams.hostName)+'&compType='+encodeURIComponent(componentType)+'&subsystem='+encodeURIComponent(subsystem)+'&screenWidth=1012&screenHeight=570&host='+encodeURIComponent(requestParams.compname)+'&time_line=&starttime=&endtime=&starthr=&endhr=&format='+encodeURIComponent(dateFormatForTimeline),
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					getElObj.unmask();
					var jsonText = response.responseText;
					var jsonData = Ext.decode( jsonText );
					me.networkDefaultLoad(jsonData);
				}
			}
		});
		Ext.getCmp('networkmainpanel').resumeEvents();
		var mask = null;
		var wholeViewport = document.getElementsByTagName("body")[0];
		if ( !Ext.isEmpty( Ext.get( wholeViewport ) ) )
		{
			mask = new Ext.LoadMask(Ext.get(wholeViewport), {msg:loadingLbl+"...",cls:'maskDash'});
			mask.hide();
		}
	},
	networkRefreshFunc: function(jsonData)
	{
		var isFlag = 'refresh';
		var me=this;
		if ( jsonData != '' && jsonData != null && !Ext.isEmpty(jsonData))
		{
			var subsystem = Ext.getCmp('networksubsystem').getValue();
			if ( subsystem.toLowerCase() == 'overview' )
			{
				Ext.getCmp('Netoverviewpanel').show();
				var overviewData = jsonData['OVERVIEW'];
				me.showOverview(overviewData);
				var getTabName = Ext.getCmp(Ext.getCmp('Nettabpanel').getActiveTab().getId()).tabName;
				var getInnerTabURL = jsonData['INNER_TAB_URL'];
				getInnerTabURL = encodeURI(getInnerTabURL);
				me.loadInnerTab("Network_"+netLastGraphTypeLoaded, getInnerTabURL,isFlag);
			}
			else
			{
				Ext.getCmp('Netoverviewpanel').hide();
				var getTabName = Ext.getCmp(Ext.getCmp('Nettabpanel').getActiveTab().getId()).tabName;
				var getInnerTabURL = jsonData['INNER_TAB_URL'];
				getInnerTabURL = encodeURI(getInnerTabURL);
				me.loadInnerTab("Network_"+netLastGraphTypeLoaded, getInnerTabURL,isFlag);
				
			}
		}
	},
	loadScreenLabels: function ( ObjectArr )
	{
		for ( var key in ObjectArr )
		{
			if ( Ext.getCmp(key) != undefined )
			{
				Ext.getCmp(key).setFieldLabel(ObjectArr[key]);
			}
		}
	},
	setValueWithOptionInList : function(fieldName, list, value)
	{		
		if ( !Ext.isEmpty( list) && list!=null && list!=undefined)
		{
			Ext.getCmp(fieldName).getStore().loadRawData(list);
		
			Ext.getCmp(fieldName).suspendEvents(false);
			if( !Ext.isEmpty(value) )
			{
				Ext.getCmp(fieldName).setValue(value);
			}
			else
			{
				Ext.getCmp(fieldName).setValue(list[0].valueField);
			}
			Ext.getCmp(fieldName).resumeEvents();
		}
	},
	showOverview: function( overviewData )
	{
		var isFlag = 'default';
		var currentAlertsObj = Ext.getCmp('netCurrentAlerts');
		var title = overviewData['alertTitle'];
		var currentAlertArr = new Array();
		var resArr = new Array();
		currentAlertArr.push({
			xtype:'container',
			id:'NetAlertsTitleID',
			//padding: '0px 0px 0px 35%',
			html: '<div class="title"><b>'+title+'</b></div>'
		});
		var alertsData = overviewData['ALERTS'];
		if ( alertsData != undefined )
		{
			if ( alertsData == '-' )
			{
				var NO_ALERTS = overviewData['NO_ALERTS'];
				currentAlertArr.push({
					xtype: 'container',
					id:'NetNoAlerts_ID',
					width: '100%',
					padding: '10px 10px 10px 10px',
					html: '<div class="iconNoalarms" style="margin:5% auto 0 auto"></div><div style="text-align:center;">'+NO_ALERTS+' </div>'
				});
			}
			else
			{
				var openalertTitle = alertsData['OPEN_ALERT_TITLE'];
				var openAlerts = alertsData['OPEN_ALERTS'];
				var distribTitle = alertsData['DISTRIBUTION_TITLE'];
				var distribValsHTML = '';
				if ( alertsData['DISTRIBUTION_CRITICAL_VALUE'] != undefined && alertsData['DISTRIBUTION_CRITICAL_VALUE'] > 0)
				{
					var distribDesc = alertsData['DISTRIBUTION_CRITICAL_DESC'];
					var linkHTML = '';
					if ( alertsData['DISTRIBUTION_CRITICAL_LINK'] != undefined )
					{
						var linkData = alertsData['DISTRIBUTION_CRITICAL_LINK'];
						var methodName = linkData['METHOD_NAME'];
						var params = linkData['PARAMS'];
						var getParams = params.split('|');
						var genHTML = '<div style="text-align:center;" >'+alertsData['DISTRIBUTION_CRITICAL_VALUE']+'</div>';
						distribValsHTML += '<td><div class="bar12_high" style="float:left;width:100%;text-align:center;height: 13px !important">'+genHTML+'</div></td>';
					}
					else
					{
						distribValsHTML += '<td><div class="bar12_high" style="float:left;text-align:width:100%;center;height: 13px !important">'+alertsData['DISTRIBUTION_CRITICAL_VALUE']+'</div></td>';
					}
				}
				if ( alertsData['DISTRIBUTION_MAJOR_VALUE'] != undefined && alertsData['DISTRIBUTION_MAJOR_VALUE'] > 0)
				{
					var distribDesc = alertsData['DISTRIBUTION_MAJOR_DESC'];
					var linkHTML = '';
					if ( alertsData['DISTRIBUTION_MAJOR_LINK'] != undefined )
					{
						var linkData = alertsData['DISTRIBUTION_MAJOR_LINK'];
						var methodName = linkData['METHOD_NAME'];
						var params = linkData['PARAMS'];
						var getParams = params.split('|');
						var genHTML = '<div style="text-align:center;" >'+alertsData['DISTRIBUTION_MAJOR_VALUE']+'</div>';
						distribValsHTML += '<td><div class="bar12_intermediate" style="float:left;text-align:width:100%;center;height: 13px !important">'+genHTML+'</div></td>';
					}
					else
					{
						distribValsHTML += '<td><div class="bar12_intermediate" style="float:left;width:100%;text-align:center;height: 13px !important">'+alertsData['DISTRIBUTION_MAJOR_VALUE']+'</div></td>';
					}
				}
				if ( alertsData['DISTRIBUTION_MINOR_VALUE'] != undefined && alertsData['DISTRIBUTION_MINOR_VALUE'] > 0)
				{
					var distribDesc = alertsData['DISTRIBUTION_MINOR_DESC'];
					var linkHTML = '';
					if ( alertsData['DISTRIBUTION_MINOR_LINK'] != undefined )
					{
						var linkData = alertsData['DISTRIBUTION_MINOR_LINK'];
						var methodName = linkData['METHOD_NAME'];
						var params = linkData['PARAMS'];
						var getParams = params.split('|');
						var genHTML = '<div style="text-align:center;" >'+alertsData['DISTRIBUTION_MINOR_VALUE']+'</div>';
						distribValsHTML += '<td><div class="bar12_low" style="float:left;width:100%;text-align:center;height: 13px !important">'+genHTML+'</div></div></td>';
					}
					else
					{
						distribValsHTML += '<td><div class="bar12_low" style="float:left;width:100%;text-align:center;height: 13px !important">'+alertsData['DISTRIBUTION_MINOR_VALUE']+'</div></td>';
					}
				}
				distribValsHTML = '<table width="100%"><tr>'+distribValsHTML+'</tr></table>';
				currentAlertArr.push(
					/* {
					xtype: 'container',
					layout:'column',
					columnWidth: 0.5,
					width: '100%',
					padding: '4px 0px 4px 0px',
					items:[
						{
							xtype: 'container',
							id:'NetOpenAlertsTitleId',
							width:'100%',
							html: '<div style="text-align:right;padding:0px 5px 0 5px"><div class="summaryOpenProblems" style="position:absolute;top:11px;left:42%"></div><div><b><span style="font-size:23px">'+openAlerts+'</span></b></div><div id="networkopenAlerts"><span style="font-size:12px;font-weight:bold"><b>'+openalertTitle+'</b></span></div></div>'
						}
					]
				}, */
				{
					xtype: 'container',
					layout: 'hbox',
					items:[
//						{
//							xtype: 'container',
//							html: '<div style="border: 0px solid red;">'+distribTitle+'</div>'
//						},
						{
							xtype: 'container',
							id:'NetdistribHTMLId',
							width:'100%',
							padding:10,							
							html:'<table width="100%" height="100%" style="margin-top: 16px;"><tr><td width="5%"></td><td width="90%"></td></tr><tr><td width="5%"><div class="summaryOpenProblems" style="top:25px;"></td><td width="90%"><div style="float: right" class="font_no">'+openAlerts+'</div><div class="font_bold12" style="margin-top: 16px;float: right;margin-right: -8px;">'+openalertTitle+'</div></td></tr></table><div class="outer_round" style="margin-top: 5px;">'+distribValsHTML+'</div>'
						}
					]
				}
				);
			}
		}
		if(Ext.getCmp('NetAlertsTitleID')!=null)
		{
			Ext.getCmp('NetAlertsTitleID').update('<div class="title"><b>'+title+'</b></div>');
			if ( alertsData == '-' )
			{
				if(Ext.getCmp('NetNoAlerts_ID')!=null)
				{
					Ext.getCmp('NetNoAlerts_ID').update('<div class="iconNoalarms" style="margin:5% auto 0 auto"></div><div style="text-align:center;">'+NO_ALERTS+' </div>');
				}
				else
				{
					currentAlertsObj.removeAll();
					currentAlertsObj.add(currentAlertArr);
					currentAlertsObj.doComponentLayout();
				}
			}
			else
			{
				if(Ext.getCmp('NetdistribHTMLId')!=null)
				{	
					//Ext.getCmp('NetOpenAlertsTitleId').update('<div style="text-align:right;padding:0px 5px 0 5px"><div class="summaryOpenProblems" style="position:absolute;top:11px;left:42%"></div><div><b><span style="font-size:23px">'+openAlerts+'</span></b></div><div id="networkopenAlerts"><span style="font-size:12px;fonr-weight:bold"><b>'+openalertTitle+'</b></span></div></div>');
					Ext.getCmp('NetdistribHTMLId').update('<table width="100%" height="100%" style="margin-top: 16px;"><tr><td width="5%"></td><td width="90%"></td></tr><tr><td width="5%"><div class="summaryOpenProblems" style="top:25px;"></td><td width="90%"><div style="float: right" class="font_no">'+openAlerts+'</div><div class="font_bold12" style="margin-top: 16px;float: right;margin-right: -8px;">'+openalertTitle+'</div></td></tr></table><div class="outer_round" style="margin-top: 5px;">'+distribValsHTML+'</div>');
				}
				else
				{
					currentAlertsObj.removeAll();
					currentAlertsObj.add(currentAlertArr);
					currentAlertsObj.doComponentLayout();
				}
			}
		}
		else
		{
			currentAlertsObj.removeAll();
			currentAlertsObj.add(currentAlertArr);
			currentAlertsObj.doComponentLayout();
		}

		/**********To Load Current Events *************/

		var currentEvents = overviewData['EVENTS'];
		var eventCriticalPageUrl = overviewData['eventUrl1'];
		var eventMajorPageUrl = overviewData['eventUrl2'];
		var eventMinorPageUrl = overviewData['eventUrl3'];
		var eventsTitle = currentEvents['eventsTitle'];
		if ( eventsTitle == undefined && currentEvents == '-' )
		{
			eventsTitle = overviewData['eventsTitle'];
		}
		var currenEventsObj = Ext.getCmp('netCurrentEvents');
		var currentEventArr = new Array();
		currentEventArr.push({
			xtype: 'container',
			id:'NeteventsTitleID',
			width: '100%',			
			padding: '10px 10px 2px 10px',				
			html: '<div class="title"><b>'+eventsTitle+'</b></div>'
		});
		if ( currentEvents != undefined )
		{
			if ( currentEvents == '-' )
			{
				var NO_EVENTS = overviewData['NO_EVENTS'];
				currentEventArr.push({
					xtype: 'container',
					id:'NetNo_EVENTSID',
					width: '100%',
					padding: '0px 10px 10px 10px',	
					html: '<div class="iconNoalarms" style="margin:1.5% auto 0 auto""></div><div style="text-align:center;">'+NO_EVENTS+' </div>'
				});
			}
			else
			{
				//var swfPath = currentEvents['SWF_PATH'];
				//var xmlData = currentEvents['XML_DATA'];
				var distribEvtsHTML = '';
				var criticalEvtCount = currentEvents['criticalEvtCount'];
				var majorEvtCount = currentEvents['majorEvtCount'];
				var minorEvtCount = currentEvents['minorEvtCount'];
				if (criticalEvtCount != undefined && criticalEvtCount > 0)
				{
					if (eventCriticalPageUrl!=undefined)
					{
						var genHTML = '<div onclick="javascript:goToAlarmHistory(\''+eventCriticalPageUrl+'\');" style="text-align:center;cursor:pointer" >'+criticalEvtCount+'</div>';
						distribEvtsHTML += '<td><div class="bar12_high" style="text-align:center;color:#ffffff;height: 13px !important">'+genHTML+'</div></td>'
					}
					else
					{
						distribEvtsHTML += '<td><div class="bar12_high" style="float:left;width:24px;text-align:center;display:none;height: 13px !important">'+criticalEvtCount+'</div></td>';
					}
				}
				if (majorEvtCount != undefined && majorEvtCount > 0)
				{
					if(eventMajorPageUrl!=undefined)
					{
						var genHTML = '<div onclick="javascript:goToAlarmHistory(\''+eventMajorPageUrl+'\');" style="text-align:center;cursor:pointer" >'+majorEvtCount+'</div>';
						distribEvtsHTML += '<td><div class="bar12_intermediate" style="text-align:center;color:#ffffff;height: 13px !important">'+genHTML+'</div></td>'
					}
					else
					{
						distribEvtsHTML += '<td><div class="bar12_intermediate" style="float:left;width:24px;text-align:center;display:none;height: 13px !important">'+majorEvtCount+'</div></td>';
					}
				}
				if (minorEvtCount != undefined && minorEvtCount > 0)
				{
					if (eventMinorPageUrl!=undefined)
					{
						var genHTML = '<div onclick="javascript:goToAlarmHistory(\''+eventMinorPageUrl+'\');" style="text-align:center;cursor:pointer" >'+minorEvtCount+'</div>';
						distribEvtsHTML += '<td><div class="bar12_low" style="text-align:center;color:#ffffff;height: 13px !important">'+genHTML+'</div></td>'
					}
					else
					{
						distribEvtsHTML += '<td><div class="bar12_low" style="float:left;width:24px;text-align:center;display:none;height: 13px !important">'+minorEvtCount+'</div></td>';
					}
				}
				distribEvtsHTML = '<table width="100%"><tr>'+distribEvtsHTML+'</tr></table>';
				//var dataArray = new Array();
				//dataArray[dataArray.length] = swfPath;
				//dataArray[dataArray.length] = xmlData;
				var totalEventsTitle = currentEvents['monitor.dashboard.Total Events'];
				var totalEvents = currentEvents['TOTAL_EVENTS'];
				var avgDurationTitle = currentEvents['monitor.dashboard.Avg Duration'];
				var avgDuration = currentEvents['AVG_DURATION'];
				var maxDurationTitle = currentEvents['monitor.dashboard.Max Duration'];
				var maxDuration = currentEvents['MAX_DURATION'];

				currentEventArr.push({
					xtype: 'container',
					layout: {
						type: 'hbox',
						align: 'stretch'
					},
					defaults:{
						height:72
					},
					width: '100%',
					items:[
						{
							xtype: 'container',
							layout: 'vbox',
							cls:'fancy_border',
							flex:4,
							width: '100%',							
							items:[
								{
									xtype: 'container',
									id:'NettotalEventsID',
									width: '100%',
									padding:10,									
									html: '<table width="100%" height="100%" style="margin-top: 5px;"><tr><td width="5%"></td><td width="90%"></td></tr><tr><td width="5%"><div class="totalEvents" style="top:25px;"></td><td width="90%"><div style="float: right" class="font_no">'+totalEvents+'</div><div style="margin-top: 16px;float: right;margin-right: -8px;" class="font_bold">'+totalEventsTitle+'</div></td></tr></table><div class="outer_round" style="margin-top: 5px;">'+distribEvtsHTML+'</div>'									
								}
							]
						},
						{
							xtype: 'container',
							cls:'fancy_border',
							flex:2,
							layout: 'vbox',
							items:[

								{
									xtype: 'container',
									id:'NetavgDurationID',
									width: '100%',
									style:{'text-align':'right','padding':'0 12px 0 12px'},
									html: '<div><div class="summaryAverageDuration" style="position:absolute;top:30px;"></div><div class="font_no" style="margin:12px 0 14px 0px;">'+avgDuration+'</div><div class="font_bold">'+avgDurationTitle+'</b></div></div>'
								}
							]
						},
						{
							xtype: 'container',
							layout: 'vbox',
							flex:2,
							cls:'fancy_border',
							items:[

								{
									xtype: 'container',
									id:'NetmaxDurationID',
									width: '100%',
									style:{'text-align':'right','padding':'0 12px 0 12px'},
									html: '<div><div class="summaryMaximumDuration" style="position:absolute;top:30px;"></div><div class="font_no" style="margin:12px 0 14px 0px;">'+maxDuration+'</div><div style=""><div class="font_bold">'+maxDurationTitle+'</div></div></div>'
								}
							]
						}
					]
				});
			}
		}
		if(Ext.getCmp('NeteventsTitleID')!=null)
		{
			Ext.getCmp('NeteventsTitleID').update('<div class="title"><b>'+eventsTitle+'</b></div>');
			if ( currentEvents == '-' )
			{
				if(Ext.getCmp('NetNo_EVENTSID')!=null)
				{
					Ext.getCmp('NetNo_EVENTSID').update('<div class="iconNoalarms" style="margin:1.5% auto 0 auto""></div><div style="text-align:center;">'+NO_EVENTS+' </div>');
				}
				else
				{
					currenEventsObj.removeAll();
					currenEventsObj.add(currentEventArr);
					currenEventsObj.doComponentLayout();
				}
			}
			else
			{
				if(Ext.getCmp('NettotalEventsID')!=null && Ext.getCmp('NetavgDurationID')!=null &&Ext.getCmp('NetmaxDurationID')!=null)
				{
					//Ext.getCmp('NetdistribEvtsHTMLID').update('<div class="outer_round">'+distribEvtsHTML+'</div>');
					Ext.getCmp('NettotalEventsID').update('<table width="100%" height="100%" style="margin-top: 5px;"><tr><td width="5%"></td><td width="90%"></td></tr><tr><td width="5%"><div class="totalEvents" style="top:25px;"></td><td width="90%"><div style="float: right" class="font_no">'+totalEvents+'</div><div style="margin-top: 16px;float: right;margin-right: -8px;" class="font_bold">'+totalEventsTitle+'</div></td></tr></table><div class="outer_round" style="margin-top: 5px;">'+distribEvtsHTML+'</div>');
					Ext.getCmp('NetavgDurationID').update('<div><div class="summaryAverageDuration" style="position:absolute;top:30px;"></div><div class="font_no" style="margin:12px 0 14px 0px;">'+avgDuration+'</div><div class="font_bold">'+avgDurationTitle+'</b></div></div>');
					Ext.getCmp('NetmaxDurationID').update('<div><div class="summaryMaximumDuration" style="position:absolute;top:30px;"></div><div class="font_no" style="margin:12px 0 14px 0px;">'+maxDuration+'</div><div style=""><div class="font_bold">'+maxDurationTitle+'</div></div></div>');
				}
				else
				{
					currenEventsObj.removeAll();
					currenEventsObj.add(currentEventArr);
					currenEventsObj.doComponentLayout();
				}
				
			}
		}
		else
		{
			currenEventsObj.removeAll();
			currenEventsObj.add(currentEventArr);
			currenEventsObj.doComponentLayout();
		}
	/*	var getEvenContObj = Ext.getCmp('net-eventChartContainer');
		if ( getEvenContObj != undefined )
		{
			var getDataArray = getEvenContObj.dataArray;
			var swfPath = getDataArray[0];
			var xmlData = getDataArray[1];
			if ( xmlData != undefined )
			{
				if ( FusionCharts('net-currentEventsChart') )
				{
					FusionCharts('net-currentEventsChart').dispose();
				}
				var myChart = new FusionCharts(swfPath,'net-currentEventsChart', '100%', '100%','0','1');
				myChart.setXMLData(xmlData);
				myChart.setTransparent(true);
				myChart.render('net-barChart');
			}
		}*/
	},
	showTabs: function( URL )
	{
		var isFlag = 'default';
		var subSystemVal = Ext.getCmp('networksubsystem').getValue();
		var me = this;
		var subnetworktabObj = this.getSubnetworktabpanel();
		var subnetworktabEl = subnetworktabObj.getEl();
		subnetworktabObj.removeAll();
		subnetworktabEl.mask(loadingLbl+"...", "maskCenter");
		var jsonText = '', jsonData = '';
		var tabs = new Array();
		Ext.Ajax.request({
			url: URL,
			method: 'GET',
			async: false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					subnetworktabEl.unmask();
					jsonText = response.responseText;
					jsonData = Ext.decode( jsonText );
					tabs = jsonData['tabs'];
				}
			},
			failure: function()
			{
				alert('I am in failure...');
			}
		});
		var tabArr = new Array();
		if ( !Ext.isEmpty( tabs ) )
		{
			for ( var i = 0; i < tabs.length; i++ )
			{
				var tmpTab = tabs[i];
				var tabName = tmpTab['TAB_NAME'];
				var tabTitle = tmpTab['TAB_MAPPING_NAME'];
				var methodName = tmpTab['METHOD_NAME'];
				var params = tmpTab['PARAMS'];
				var no_params = params.split('|');
				var tabId = tmpTab['TAB_ID'];
				var no_params = params.split('|');

				var getTmpTimelineData = jsonData['TimelineWindow'];
				timelineVals['timeline'] = getTmpTimelineData[0]['selected'];
				timelineVals['starttime'] = getTmpTimelineData[1]['value'];
				timelineVals['starthour'] = getTmpTimelineData[2]['selected'];
				timelineVals['endtime'] = getTmpTimelineData[3]['value'];
				timelineVals['endhour'] = getTmpTimelineData[4]['selected'];

				tabArr.push({
					title: tabTitle,
					id: tabId,
					tabName: tabName,
					dataArray: tmpTab,
					xtype: 'container',
					layout: 'vbox',
					listeners:
					{
						'afterrender': function()
						{
							if ( Ext.get('net-configModApp') != undefined ) // ensure net-configModApp is close before show tab panel
							{
								Ext.get('net-configModApp').destroy();
							}
							var tmpDataArray = this.dataArray;
							var URL = '';
							if ( tmpDataArray['TAB_NAME'].toLowerCase() == 'at-a-glance' )
							{
								if ( subSystemVal.toLowerCase() == 'overview' )
								{
									URL = "/final/monitor/egDashboardOverviewJSON.jsp";
									URL += "?"+"hostName="+encodeURIComponent(componentName)+"&compType="+encodeURIComponent(componentType)+"&tab=Network"
								}

								me.loadInnerTab(tmpDataArray['TAB_ID'], URL,isFlag);
							}
							else if ( tmpDataArray['TAB_NAME'].toLowerCase() == 'details' || tmpDataArray['TAB_NAME'].toLowerCase() == 'comparison' )
							{
								var timelineData = jsonData['TimelineWindow'];
								var timeline = timelineData[0]['selected'];
								var starttime = timelineData[1]['value'];
								var starthour = timelineData[2]['selected'];
								var endtime = timelineData[3]['value'];
								var endhour = timelineData[4]['selected'];
								URL = '/final/monitor/egDashboardHistoryJSON.jsp';
								var no_params= tmpDataArray['PARAMS'].split('|');

								me.loadInnerTab(tmpDataArray['TAB_ID'], URL+'?tab=Network&hostName='+encodeURIComponent(componentName)+'&compType='+encodeURIComponent(componentType)+'&subsystem='+encodeURIComponent(Ext.getCmp('networksubsystem').getValue())+'&graphType='+encodeURIComponent(no_params[2])+'&showGraph='+encodeURIComponent(no_params[2])+'&time_line=&starttime='+encodeURIComponent(starttime)+'&endtime='+encodeURIComponent(endtime)+'&starthr='+encodeURIComponent(starthour)+'&endhr='+encodeURIComponent(endhour)+'&format='+encodeURIComponent(dateFormatForTimeline)+'&host='+encodeURIComponent(componentName),isFlag);
							}
							else if ( tmpDataArray['TAB_NAME'].toLowerCase() == 'history' )
							{

								var timelineData = jsonData['TimelineWindow'];
								var timeline = timelineData[0]['selected'];
								var starttime = timelineData[1]['value'];
								var starthour = timelineData[2]['selected'];
								var endtime = timelineData[3]['value'];
								var endhour = timelineData[4]['selected'];
								URL = '/final/monitor/egDashboardHistoryJSON.jsp';
								var no_params= tmpDataArray['PARAMS'].split('|');
								me.loadInnerTab(tmpDataArray['TAB_ID'], URL+'?tab=Network&hostName='+encodeURIComponent(componentName)+'&compType='+encodeURIComponent(componentType)+'&subsystem='+encodeURIComponent(Ext.getCmp('networksubsystem').getValue())+'&graphType='+encodeURIComponent(no_params[2])+'&showGraph='+encodeURIComponent(no_params[2])+'&time_line=&starttime='+encodeURIComponent(starttime)+'&endtime='+encodeURIComponent(endtime)+'&starthr='+encodeURIComponent(starthour)+'&endhr='+encodeURIComponent(endhour)+'&format='+encodeURIComponent(dateFormatForTimeline)+'&host='+encodeURIComponent(componentName),isFlag);
							}

						}
					}
				});
			}
		}
		if ( !Ext.isEmpty( tabArr ) )
		{
			subnetworktabObj.add({
				xtype: 'scrolltabPanel',
				id: 'Nettabpanel',
				dataArray: URL,
				name: 'Nettabpanel',
				flex:1,
				//overflowX:'hidden',
				//overflowY:'auto',
				plain: false,
				cls: 'tablayout tabpanel componenttopborder',
				border: false,
				frame: false,
				defaults:{
					border:true,
					frame:true
				},
				activeTab:netCurrentTabId,
				listeners:{
					render: function()
					{
						var getId = '';
						this.items.each(function(obj)
						{
			                obj.tab.on('click', function()
			                {
			                	getId = obj.id;
								netCurrentTabId = getId;
								
			                    if ( obj.tabName.toLowerCase() == 'history' && isDisableTrendComputation == false)
			                    {
			                    	Ext.getCmp('net-history-tool').show();
			                    	Ext.getCmp('net-calendar-tool').show();
			                    	Ext.getCmp('net-history-tool').show();
			                    	Ext.getCmp('net-summary-tool').show();
			                    	Ext.getCmp('net-area-tool').show();
			                    }
			                    else
			                    {
			                    	Ext.getCmp('net-history-tool').hide();
			                    	Ext.getCmp('net-calendar-tool').hide();
			                    	Ext.getCmp('net-history-tool').hide();
			                    	Ext.getCmp('net-summary-tool').hide();
			                    	Ext.getCmp('net-area-tool').hide();
			                    }
			                });
			            });
						this.tabBar.add(
							{
								xtype:'tbfill',
								id: 'net-tab-seperator'
							},
							{
								xtype: 'toolbar',
								ui:'footer',
								width:27,
								hidden: true,
								id: 'net-calendar-tool',
								cls:'iconBg',
								height:21,
								margin:'0 50 0 0',
								dock: 'right',
								items:[
									{
										xtype: 'button',
										iconCls:'iconCalendar',
										id: 'net-calendar-btn',
										hidden:true,
										//tooltip:'Calendar',
										handler: function()
										{
											Ext.get('net-configModApp').animate({to: {'top':11},listeners:{ afteranimate:function(){  Ext.get('net-configModApp').setStyle('left', '');}}}).show();
										},

										listeners:
										{
											'click': function()
											{
												var configModObj = Ext.get('net-configModApp');
												if (Ext.isEmpty(configModObj))
												{
													var tpl = new Ext.XTemplate('<div style="float:left;margin:4px 0px 0px 4px"><b>'+defSettingsLbl+'</b></div><div style="text-align:right;float:right;"><div class="iconClose3" id="net-closeSettingsApp"></div></div>');
													Ext.create('Ext.container.Container',
													{
														width: 530,
														id:'net-configModApp',
														padding:5,
														closeAction:'hide',
														cls:'configMode_popup',
														style:{'position':'absolute'},

														items:[
															{
																xtype:'container',
																cls:'configMode_popupArrow',
																style:{'top':'-14px','left':'400px'}
															},
															{
																xtype:'container',
																html:tpl.apply(),
																style:{'top':'0px','margin':'2px'}
															},{
																xtype:'networktimeline',
																//width:530,
																height:60
															}
														],
														renderTo: 'Nettabpanel-body'

													});
												}
												else
												{
													configModObj.show();
												}
												Ext.getBody().on('click',function()
												{
													var configobj = Ext.get('net-configModApp');
													if ( configobj != null && configobj != undefined )
													{
														configobj.hide();
													}
													configobj.animate({duration: 500,to: {y: -500}});
												},null,{delegate:'#net-closeSettingsApp'});
												Ext.Ajax.request({
													url: URL,
													method: 'GET',
													async: false,
													success: function( response )
													{
														if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
														{
															var tmpJsonText = response.responseText;
															var tmpJsonData = Ext.decode( tmpJsonText );
															var timelineData = tmpJsonData['TimelineWindow'];
															var timeline = timelineData[0]['selected'];
															var starttime = timelineData[1]['value'];
															var starthour = timelineData[2]['selected'];
															var endtime = timelineData[3]['value'];
															var endhour = timelineData[4]['selected'];

															var erTimelineObj = Ext.getCmp('net_er_timeline');
															erTimelineObj.getStore().loadRawData(timelineData[0]['items']);
															var selTimeline = erTimelineObj.getValue();
															var startTimeObj = Ext.getCmp('net_er_stdate');
															var endTimeObj = Ext.getCmp('net_er_enddate');
															var startHrObj = Ext.getCmp('net_er_sthr');
															var endHrObj = Ext.getCmp('net_er_endhr');
															if(selTimeline!=null && selTimeline!="")
															{
																erTimelineObj.setValue(selTimeline);
																var startTimeVal = startTimeObj.getValue();
																var endTimeVal = endTimeObj.getValue();
																var startHrVal = startHrObj.getValue();
																var endHrVal = endHrObj.getValue();

																startTimeObj.setValue(startTimeVal);
																endTimeObj.setValue(endTimeVal);
																startHrObj.setValue(startHrVal);
																endHrObj.setValue(endHrVal);
															}
															else
															{
																erTimelineObj.setValue(timeline);
																startTimeObj.setValue(starttime);
																endTimeObj.setValue(endtime);
																startHrObj.setValue(starthour);
																endHrObj.setValue(endhour);
															}

														}
													}
												});
											},
											'afterrender': function( obj )
											{
												obj.addListener('loadTime');
												Ext.create('Ext.tip.ToolTip', {
																	target: this.id,
																	anchor: 'top',
																	cls: 'yellowTip',
																	trackMouse: true,
																	html: 'Calendar'
																});
											}
										}
									}
								]
							},
							{
								xtype: 'toolbar',
								id: 'net-history-tool',
								hidden: true,
								ui:'footer',
								layout:'hbox',
								width: 27,
								cls: 'iconBg',
								height: 21,
								margin: '0 0 0 0',
								dock: 'right',
								items: [
									{
										xtype: 'button',
										id: 'net-history-bar',
										iconCls: 'iconLineChart',
										//tooltip:'History View',
										listeners:{
											'afterrender': function () {
																Ext.create('Ext.tip.ToolTip', {
																	target: this.id,
																	anchor: 'top',
																	cls: 'yellowTip',
																	trackMouse: true,
																	html: historyViewText
																});
															}
										},
										handler: function()
										{
											me.callView('measureGraph');
										}
									},
									{
										  xtype: 'tbseparator',
											margin:'2 0 0 0'
									}
								]
							},
							{
								xtype: 'toolbar',
								width: 27,
								layout:'hbox',
								ui:'footer',
								cls: 'iconBg',
								hidden: true,
								id: 'net-summary-tool',
								height: 21,
								margin: '0 0 0 0',
								dock: 'right',
								items: [
									{
										xtype: 'button',
										iconCls: 'iconBarChart',
										//tooltip:'Summary View',
										listeners:{
											'afterrender': function () {
																Ext.create('Ext.tip.ToolTip', {
																	target: this.id,
																	anchor: 'top',
																	cls: 'yellowTip',
																	trackMouse: true,
																	html: summaryViewText
																});
															}
										},
										handler: function()
										{
											me.callView('summaryGraph');
										}
									},{
										  xtype: 'tbseparator',
											margin:'2 0 0 0'
									}
								]
							},
							{
								xtype: 'toolbar',
								width: 27,
								layout:'hbox',
								ui:'footer',
								hidden: true,
								id: 'net-area-tool',
								cls: 'iconBg',
								height: 21,
								margin: '0 0 0 0',
								dock: 'right',
								items: [
									{
										xtype: 'button',
										iconCls: 'iconAreaChart',
										//tooltip:'Trend View',
										listeners:{
											'afterrender': function () {
																Ext.create('Ext.tip.ToolTip', {
																	target: this.id,
																	anchor: 'top',
																	cls: 'yellowTip',
																	trackMouse: true,
																	html: trendViewText
																});
															}
										},
										handler: function()
										{
											me.callView('trendGraph');
										}
									}
								]
							});
					},
					'click': function()
					{
						alert('I am clicking...');
					}
				},
				items: tabArr

			});
		}
		subnetworktabObj.doComponentLayout();
		subnetworktabObj.show();
	},
	loadInnerTab: function( tabId, URL ,isFlag)
	{
		if(tabId == 'Network_trendGraph' || tabId == 'Network_summaryGraph' )
		{
			tabId='Network_measureGraph';
		}
		var subsystem = Ext.getCmp('networksubsystem').getValue();
		var serverType =componentType;
		var me = this;
		
		var getEl ="";
		if (!Ext.isEmpty(Ext.getCmp(tabId)))
		{
			getEl = Ext.getCmp(tabId).getEl();
		}

		var getTabObj = Ext.getCmp(tabId);
		if(isFlag == 'default')
		{
			getTabObj.removeAll();
		}
		
		var defaultHeight = 0;
		if ( !Ext.isEmpty( subsystem ) && subsystem.toLowerCase() != 'overview' )
		{
			defaultHeight = 133;
		}
		getTabObj.setHeight((Ext.getBody().getHeight()-265)+defaultHeight);
		var getDataArray = getTabObj.dataArray;
		var tabName = getDataArray['TAB_NAME'];
		var jsonText = '', jsonData = '';
		getEl.mask(loadingLbl+"...","maskCenter");
		Ext.Ajax.request({
			url: URL+'&screenWidth='+(Ext.getBody().getViewSize().width)+'&screenHeight='+(Ext.getBody().getViewSize().height),
			method: 'POST',
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					jsonText = response.responseText;
					getEl.unmask();
					jsonData = Ext.decode( jsonText );
					netgraphUrl = jsonData['hiddens'];					
					if ( tabName.toLowerCase() == 'at-a-glance' )
					{
						if ( subsystem.toLowerCase() == 'overview' )
						{
							me.showAtAGlance( tabId, jsonData ,isFlag );
						}
					}
					else if ( tabName.toLowerCase() == 'details' || tabName.toLowerCase() == 'comparison' )
					{
						me.showDetailsTab( tabId, jsonData ,isFlag );
					}
					else if ( tabName.toLowerCase() == 'history' )
					{
						me.showHistoryTab( tabId, jsonData ,isFlag);
					}


				}
			}
		});
	},
	showAtAGlance: function( tabId, resultData,isFlag )
	{
		var atAGlanceObj = Ext.getCmp(tabId);
		atAGlanceObj.setHeight(Ext.getBody().getHeight()-265);
		atAGlanceObj.setAutoScroll(true);
		var atAGlanceArr = new Array();
		if(isFlag == 'default')
		{
			atAGlanceObj.removeAll();
			atAGlanceObj.add({
				xtype: 'container',
				id: 'nethealthdialpanel',
				//style:{'border':'1px #c3c3c3 solid'},
				cls:'datapanel border_theme',				
				width: '100%',
				margin:'10 10 5 10',
				padding:'8 0 8 0',
				layout: 'hbox'
			});
			atAGlanceObj.add({
				xtype: 'container',
				id: 'nethopDelaypanel',
				cls:'datapanel border_theme',
				//style:{'border':'1px #c3c3c3 solid'},
				width: '100%',
				margin:'5 10 5 10',
				hidden:true,
				//height: 20,
				//padding: 4,
				layout: 'hbox'
			});
			atAGlanceObj.add({
				xtype: 'container',
				id: 'netdigitalpanel',
				cls:'datapanel border_theme',
				//style:{'border':'1px #c3c3c3 solid'},
				width: '100%',
				margin:'5 10 5 10',
				padding:'8 0 8 0',
				//height: 100,
				layout: 'hbox',
				defaults:{
					cls:'containerDigitalData'
				}
			});
	
			atAGlanceObj.add({
				xtype: 'container',
				id: 'netconfigpanel',
				width: '100%',
				layout:
				{
					type: 'column',
					align: 'stretch'
				},
				defaults:
		        {
		           margin:'5 10 5 10',
		            columnWidth: 0.5,
					cls:'datapanel  border_theme',
					//style:{'border':'1px #c3c3c3 solid'}
		        }
			});
			atAGlanceObj.doComponentLayout();
		}
	
		var getHealthDialObj = Ext.getCmp('nethealthdialpanel');
		var getDigitalObj = Ext.getCmp('netdigitalpanel');
		var configObj = Ext.getCmp('netconfigpanel');
		var hopDelayObj = Ext.getCmp('nethopDelaypanel');
		getDigitalObj.removeAll();
		configObj.removeAll();
		hopDelayObj.removeAll();
		if ( !Ext.isEmpty( resultData ) )
		{
			atAGlanceArr.splice(0, atAGlanceArr.length);
			// To Load Health Chart
			var healthData = resultData['HEALTH'];
			if ( !Ext.isEmpty( healthData ) )
			{
				var healthArr = new Array();
				var healthTitle = healthData['TITLE'];
				var xmlData = healthData['XML_DATA'];
				var swfPath = healthData['SWF_PATH'];
				var chartHeight = Math.round(healthData['HEIGHT']);
				var chartWidth = Math.round(healthData['WIDTH']);
				chartHeight=chartHeight+10;
				if ( xmlData == '-' )
				{
					var errorMsg = healthData['MSG'];	
					healthArr.push(
						{
							xtype: 'container',
							cls: 'componentnetworkseperator',
							padding: 0,
							margin: 0,
							layout:{
								type: 'vbox',
								align: 'stretch'
							},
							items:[
								{
									xtype: 'label',
									align: 'center',
									html: '<div style="text-align:center;" class="font_bold12">'+healthTitle+'</div>'
								},
								{
									xtype: 'container',
									height: 200,
									//height: chartHeight,
									flex: 1,
									width: chartWidth,
									html: '<table width="100%" height="100%" style="text-align:center"><tr><td><div class="iconInformation" style="margin:0px auto"></div><div>'+errorMsg+'</div></td></tr></table>'
								}
							]
						}
					);
				}
				else
				{
					healthArr.push(
						{
							xtype: 'container',
							cls:'componentnetworkseperator',
							//margin:'-5 0 0 0',
							width:255,
							layout:{
								type: 'vbox',
								align: 'stretch'
							},				
															
							items:[{
									xtype: 'label',
									align: 'center',
									//margin:'10 0 0 0',
									html: '<div style="text-align:center;" class="font_bold12">'+healthTitle+'</div>'
								},
								{
									xtype: 'container',
									height: chartHeight,									
									id: 'net-tmpChart',
									width: chartWidth,
									//margin:'-5 0 0 0',
									html: '<div id="net-HealthChart" style="width:'+chartWidth+'px;height:'+chartHeight+'px;margin-top: -20px;"></div>'
								}]
						}
					);
				}
				getHealthDialObj.removeAll();
				getHealthDialObj.add(healthArr);
				getHealthDialObj.doComponentLayout();
				if ( xmlData != '-' )
				{
						try
						{
							var barChart = {};
							barChart = jQuery.extend(true, {}, getHighChartsBarInstance('net-HealthChart', 150, 220), barChart);
							barChart.setData(xmlData, currentDateFormat, '','pie');
							barChart.drawChart();
						}
						catch (barChartEx)
						{
							console.log(barChartEx);
						}
					
				}
			}

			// To Load Dial Chart

			var dialData = resultData['DIAL'];
			layerModelURL = resultData['hiddens'];
//			dialData = null;
			if ( !Ext.isEmpty( dialData ) && dialData!='-')
			{
				atAGlanceArr.splice(0, atAGlanceArr.length);
				for ( var i = 0; i < dialData.length; i++ )
				{	
					var title = dialData[i]['TITLE'];
					var toolTipTitle = dialData[i]['TOOL_TIP_TITLE'];
					var Dial_Fullview = dialData[i]['Dial_Fullview'];
					var methodName = dialData[i]['METHOD_NAME'];
					var params = dialData[i]['PARAMS'];
					var subTitle_Dial = dialData[i]['subTitle_Dial'];
					var chartHeight = Math.round(dialData[i]['HEIGHT']);
					var chartWidth = Math.round(dialData[i]['WIDTH']);
					var xmlData = dialData[i]['XML_DATA'];
					var swfPath = dialData[i]['SWF_PATH'];
					var cmpType= dialData[i]['CMP_TYPE'];
					var DialPARAMS = dialData[i]['DialPARAMS'];
					var dialInterfaceFlag = dialData[i]['dialInterfaceFlag'] ;
					if(chartHeight==null || chartHeight==undefined)
					{
						chartWidth="255";
						chartHeight="150"
					}
					var chartheightobj=parseInt(chartHeight)-15;
					if(Dial_Fullview != '' && Dial_Fullview=='true' && Dial_Fullview!= undefined )
					{
						var fullviewcls='iconMaximize';
					}
					else
					{
						var fullviewcls='';
					}
					if(subTitle_Dial==undefined || subTitle_Dial=="" )
					{
						subTitle_Dial="";
					}
					//	if ( xmlData != '-' )
					{
						atAGlanceArr.push({
							xtype: 'container',
							//height:165,
							//style:{'height':'165px !important'},
							layout:{
								type: 'vbox',
								width: chartWidth,
								//padding: '0px 5px 0px 5px',
								align: 'stretch'
							},
							items:[{
									xtype: 'container',
									margin:'0 0 0 0',
									style: {'text-align':'center'},									
									align: 'center',
									html: '<div style="text-align:center;" title="'+toolTipTitle+'" class="font_bold"><span >'+title+'</span><span class='+fullviewcls+' style="float:right;cursor:pointer;margin-right:10px;" onclick="javascript:'+methodName+'(\''+params+'\');"></span></div>'								
								},
								{
									xtype: 'label',
									padding:'0 0 0 0',
									height:15,
									html: '<div style="text-align:center;cursor:pointer;margin-top:0px;height:15px;overflow: hidden;-o-text-overflow:ellipsis;text-overflow: ellipsis;white-space:nowrap;padding:0px 4px" data-qtip="'+subTitle_Dial+'" class="font_text" "><b>'+subTitle_Dial+'</b></div>'
								},
								{
									xtype: 'container',
									width:'100%',
									id: 'net-dialChart-'+i,
									dataArray: dialData[i],
									//margin:'20 0 0 0',
									flex:1,
									align: 'center',
									style:{'text-align':'center'},
									html: '<div id="net-chart-'+i+'" style="border:0px solid blue;width:'+chartWidth+'px;height:'+chartheightobj+'px;margin:0px auto"></div>'
									//html: '<div id="net-chart-'+i+'"  style="border:0px solid blue;width:100%;height:100%;text-align:center"></div>'
								}]
						});
					}
				}
				var outerArr = new Array();				
				outerArr.push({
					xtype: 'container',
					width: '100%',
					id: 'netdialpanel',
					flex: 0.25,
					margin:'0 10 0 10',
					padding:'0 0 3 0',
					layout: {
						type: 'hbox',
						//padding:'0 10 10 10',		
						align: 'stretch'
					},
					defaults:{
						cls:'containerDigitalData',
						flex:0.25,
						height:160
					},
					items: atAGlanceArr
				});
				getHealthDialObj.add(outerArr);
				getHealthDialObj.doComponentLayout();

				for ( var i = 0; i < dialData.length; i++ )
				{
					var getObj = Ext.getCmp('net-dialChart-'+i);
					if ( !Ext.isEmpty( getObj ) )
					{
						var getDataArray = getObj.dataArray;
						var xmlData = getDataArray['XML_DATA'];
						var swfPath = getDataArray['SWF_PATH'];
						var dialInterfaceFlag = getDataArray['dialInterfaceFlag'];
						
						if ( xmlData != '-' )
						{	
							if(dialInterfaceFlag!=undefined && dialInterfaceFlag=="false" && dialInterfaceFlag!="true")
						{							
							
								getHighChartsGuage('net-chart-'+i,xmlData)
							
						}	 
						else
							{
								Ext.get('net-chart-'+i).update('<div style="margin-top:50px;vertical-align:middle;display:inline-block;text-align: center;font-size:12px;"><img src=\"/final/images/spacer.gif\" class=\"iconAlert\" style=\"vertical-align: middle\"> <span >'+xmlData+'</span></div>');
								
							}
						} 
						else
						{
							Ext.get('net-chart-'+i).update('<div style="border:0px solid blue;margin:0px auto"><div class="iconInformation" width="100%" style="text-align:center;margin:0px auto;margin-top: 20px;"></div><div style="text-align:center;margin:0px auto;">'+noMeasureExcl+'</div></div>');
						}
					}
				}
			}
			else
			{
				getHealthDialObj.add({
					xtype: 'container',
					width: '100%',
					id: 'netdialpanel',
					height:207,
					flex: 0.25,
					margin:'0 10 0 10',
					padding:'0 0 8 0',
					layout: {
						type: 'hbox',
						//padding: '0px 5px 0px 5px',
						align: 'stretch'
					}
				});
				getHealthDialObj.doComponentLayout();
			}

			// Hop delay
			var hopDelay = resultData['hopObj'];
			if(!Ext.isEmpty(hopDelay))
			{
				var hopWidth = hopDelay['WIDTH'];
				var hopHeight = hopDelay['HEIGHT'];
				var hopTitle = hopDelay['TITLE'];
				var hopdelayArr = new Array();
				atAGlanceArr.splice(0, atAGlanceArr.length);
				var Msg = hopDelay['NoMess'];
				if(Msg == 'true' )
				{
					/**var getMsg = hopDelay['HopMsg'];
					var hopMsg=['HopMsg'];
					hopdelayArr.push({
						xtype: 'container',
						height: hopHeight,
						width: hopWidth,
						cls:'last_border',
						padding:'0px 0px 0px 0px',
						margin:10,
						html :'<div style="text-align:center;" class="font_bold12">'+hopTitle+'</div><table width="100%"><tr><td align="center"><div class="iconExclamation" style="margin:33px auto 0px auto"></div>'+getMsg+' </td></tr></table>'
					});
					//hopDelayObj.add(hopdelayArr);
					hopDelayObj.doComponentLayout();
					**/
				}
				else
				{
					hopdelayArr.push({
						xtype: 'container',
						height: hopHeight,
						//cls:'fancy_border',
						width: hopWidth,
						cls:'last_border',
						margin:'10 10 10 10',
						padding:'0 0 10 0',
						html: '<div style="border:0px solid red;text-align:center;margin:5px 0px 5px 10px;"><div class="font_bold12">'+hopTitle+'</div><div class="x-table" style="margin-top: 6px;"><table class="x-grid-table x-grid-table-resizer border-theme" cellspacing="0" cellpadding="1px" border="0" width="100%" style="width:100%"><thead><tr class="x-grid-row"><td class="x-grid-cell" align="center" style="padding:4px 4px 2px 4px">'+hopDelay['COLUMN_0']+'</td><td class="x-grid-cell" align="center" style="padding:4px 4px 2px 4px">'+hopDelay['COLUMN_1']+'</td></tr></thead><tr class="x-grid-row"><td class="x-grid-cell" >'+hopDelay['COLUMN_0_val']+'</td><td align="center" class="x-grid-cell" ><div class="measuresInnerTable"><table cellpadding="0" border="0" style="border-bottom:0px;border: 0px;" ><tr><td align="center" style="border-bottom:0px;padding:4px 4px 0px 4px" > '+hopDelay['COLUMN_1_val_0']+'</td><td align="center" style="border-bottom:0px;padding:4px 4px 0px 4px">'+hopDelay['COLUMN_1_val_1']+'</td><td align="center" style="border-bottom:0px;border:0px !important;padding:4px 4px 0px 4px">'+hopDelay['COLUMN_1_val_2']+'</td></tr></table></div></td></tr></table></div></div>'
					});
					//hopDelayObj.add(hopdelayArr);
					//hopDelayObj.doLayout();
				}
				getHealthDialObj.add(hopdelayArr);
			}
			
			
			// To load Digital Data
			var digitalData = resultData['DIGITAL'];
			//digitalData = null;
			if ( !Ext.isEmpty( digitalData ) )
			{
				atAGlanceArr.splice(0, atAGlanceArr.length);
				for ( var i = 0;i < digitalData.length; i++ )
				{
					var heading = digitalData[i]['IMG_HEADING'];
					var imgSRC = digitalData[i]['IMG_SRC'];
					var height = digitalData[i]['HEIGHT'];
					var width = digitalData[i]['WIDTH'];
					var unit = digitalData[i]['UNIT'];
					var cmpType = digitalData[i]['CMP_TYPE'];
					var containerWidth = Math.round(digitalData[i]['CONTAINER_WIDTH']);
					if(imgSRC!='-')
					{
						atAGlanceArr.push({
							xtype: 'panel',							
							flex:.25,
							id:'containerDigitalData'+i,
							cls:'containerDigitalData',
							//height: 95,
							margin:'10 0 0 0',
							layout:
							{
								type: 'vbox',
								align: 'stretch'
							},
							items:[
								{
									xtype: 'label',									
									html: '<div style="text-align:center;" class="font_bold12">'+heading+'</div>'
								},
								{
									xtype: 'container',
									id:'digitalChartID'+i,									
									height:65,
									margin:'8 0 0 0',
									style:{'text-align':'center','height':'65px !important'},
									dataArray: digitalData[i],
									listeners:{
										'afterrender': function(container)
										{
											var tmpDataArray = this.dataArray;
											var imgsrc = tmpDataArray['IMG_SRC'];
											var imgHeight = tmpDataArray['HEIGHT'];
											var imgWidth = tmpDataArray['WIDTH'];
											var imgTitle = tmpDataArray['IMG_TITLE'];
											var methodName = tmpDataArray['METHOD_NAME'];
											var params = tmpDataArray['PARAMS'];
											var genImage = '<img src="'+imgsrc+'" title="'+imgTitle+'" style="cursor:pointer" onclick="javascript:'+methodName+'(\''+params+'\');"/>';
											imgHeight= Math.round(imgHeight);
											this.setHeight(imgHeight);
											this.update(genImage);
										}
									}
								},
								{
									xtype: 'label',
									html: '<div style="text-align:center"><b>'+unit+'</b></div>'
								}
							]
						});
					}
					else
					{
						atAGlanceArr.push({
							xtype: 'panel',
							//padding: 5,
							flex:.25,
							id:'containerDigitalData'+i,
							cls:'containerDigitalData',
							height: 95,
							layout:
							{
								type: 'vbox',
								align: 'stretch'
							},
							items:[
								{
									xtype: 'label',
									html: '<div style="text-align:center;" class="font_bold12">'+heading+'</div>'
								},
								{
									xtype: 'container',
									id:'digitalChartID'+i,
									height:75,
									margin:'8 0 0 0',
									style:{'text-align':'center','height':'75px !important'},
									listeners:{
										'afterrender': function(container)
										{
											var digitalId=this.id;
											Ext.get(container.id).update('<div style="border:0px solid blue;margin:0px auto"><div class="iconInformation" width="100%" style="text-align:center;margin:0px auto"></div><div style="text-align:center;margin:0px auto;">'+noMeasureExcl+'</div></div>');
										}
									}
								}
							]
						});
					}
				}
			}
			if ( (dialData == undefined || Ext.isEmpty(dialData)) && (digitalData == undefined  || Ext.isEmpty(digitalData)))
			{
				var noGraphTitle = resultData['NET_TAB_NoGraphTitle'];
				var dialDigitalMsg = resultData['DIAL_DIGITAL_MSG'];
				var noMeasureMsg = testExcludedorDisabledMsg;

				if( dialDigitalMsg == undefined || Ext.isEmpty(dialDigitalMsg)){
					noMeasureMsg = noMeasure;
				}
				Ext.getCmp('netdialpanel').removeAll();
				Ext.getCmp('netdialpanel').flex =1;
				var dialNoMes = {
					
					xtype:'container',
					margin:'1px 0px 0px 0',
					width:'100%',
					height:200,
					//style:{'border':'1px solid red'},
					html:'<div class="noGraphTitle" style="padding-top:5px;">'+noGraphTitle+'</div><table width="100%" height="189px" style="text-align:center"><tr><td><div class="iconInformation" style="margin:0px auto"></div><div>'+noMeasureMsg+'</div></td></tr></table>'
					//html:'<div style="text-align:center"><b>'+noGraphTitle+'</b></div><table width="100%" style="margin-top:30px"><tr><td align="center" ><div class="iconExclamation" style="margin:0px auto"></div><div>'+noMeasure+'</div></td></tr></table>'
				};
				var dialObj = Ext.getCmp('netdialpanel');
				dialObj.removeAll();
				dialObj.add(dialNoMes);
				dialObj.doComponentLayout();
				getDigitalObj.hide();
			}
			else if ( Ext.isEmpty( dialData ) )
			{				
				var noGraphTitle = resultData['NET_TAB_NoGraphTitle'];
				var dialMsg = resultData['DIAL_MSG'];
				var noMeasureMsg = testExcludedorDisabledMsg;
				if( dialMsg == undefined || Ext.isEmpty(dialMsg)){
					noMeasureMsg = noMeasure;
				}
				Ext.getCmp('netdialpanel').removeAll();
				Ext.getCmp('netdialpanel').flex =1;
				var dialNoMes = {
					xtype:'container',
					margin:'1px 0px 0px 0',
					//style:{'border':'1px solid blue'},
					width:'100%',
					height:150,
					html:'<div class="noGraphTitle" style="padding-top:0px;">'+noGraphTitle+'</div><table width="100%" height="130px" style="text-align:center"><tr><td><div class="iconInformation" style="margin:0px auto"></div><div>'+noMeasureMsg+'</div></td></tr></table>'
					//html:'<div style="text-align:center"><b>'+noGraphTitle+'</b></div><table width="100%" style="margin-top:30px"><tr><td align="center" ><div class="iconExclamation" style="margin:0px auto"></div><div>'+noMeasure+'</div></td></tr></table>'
				};
				var dialObj = Ext.getCmp('netdialpanel');
				dialObj.removeAll();
				dialObj.add(dialNoMes);
				dialObj.doComponentLayout();
				//getDigitalObj.hide();
			}
			/*else if ( Ext.isEmpty( digitalData ))
			{
				var noGraphTitle = resultData['DIGITAL_TITLE'];
				
				getDigitalObj.removeAll();
				var dialNoMes = {
					xtype:'container',
					margin:'1px 0px 0px 0',
					html:'<div style="text-align:center"><b>'+noGraphTitle+'</b></div><table width="100%" style="margin-top:30px"><tr><td align="center" ><div class="iconExclamation" style="margin:0px auto"></div><div>'+noMeasure+'</div></td></tr></table>'
				};
				getDigitalObj.add(dialNoMes);
				getDigitalObj.doComponentLayout();
			}*/
			else if(Ext.isEmpty( digitalData )){
				getDigitalObj.hide();
			}

			getDigitalObj.add(atAGlanceArr);
			if(Ext.getCmp('containerDigitalData0')){
				Ext.getCmp('containerDigitalData0').addCls('first');
			}
			getDigitalObj.doComponentLayout();

			// To load configurations

			var configsData = resultData['CONFIG_DATAS'];
			if ( !Ext.isEmpty( configsData ) )
			{
				atAGlanceArr.splice(0, atAGlanceArr.length);
				var cnt = 0; //To count no of sparkline
				for ( var i = 0; i < configsData.length; i++ )
				{
					var configData = configsData[i];
					var configurationTitle = configData['TITLE'];
					var type = configData['TYPE'];
					type = type.toLowerCase();
					var adminPermission = configData['ADMIN_PERMISSION'];
					var toolsArr = new Array();
					if ( adminPermission.toLowerCase() == 'true' )
					{
						toolsArr.push({
									xtype: 'button',
									iconCls: 'iconMaximize',
									dataArray: 'netconfig-'+i,
									handler: function()
									{
										var tmpDataArray = this.dataArray;
									}
								}
								/*{
									xtype: 'button',
									iconCls: 'iconClose',
									dataArray: 'netconfig-'+i,
									handler: function()
									{
										var tmpDataArray = this.dataArray;
										Ext.getCmp(tmpDataArray).destroy();
										applicationController.callMe();

									}
								}*/
							);
					}
					else
					{
						toolsArr.push({
									xtype: 'button',
									iconCls: 'iconMaximize',
									dataArray: 'netconfig-'+i,
									handler: function()
									{
										var tmpDataArray = this.dataArray;
									}
								});
					}
					if ( type == 'table' )
					{
						var configuration = configData['CONFIGURATION'];
						var genHTML = '';
						if ( !Ext.isEmpty(configuration) && configuration != '-' )
						{
							genHTML = '<div class="x-table"><table cellspacing="0" width="100%" cellpadding="0" border="0" class="x-grid-table x-grid-table-resizer"><tbody>';
							for ( var j = 0; j < configuration.length; j++ )
							{
								var getVal = '';
								if ( configuration[j]['TITLE'] != undefined )
								{
									genHTML +='<tr class="x-grid-row"><td colspan="2" class=" x-grid-cell x-grid-cell-first"><div class="x-grid-cell-inner">'+configuration[j]['TITLE']+'</div></td></tr>';
								}
								else
								{
									var getVal1 = '', getVal2 = '';
									if ( configuration[j]['VALUE_1'] != undefined )
									{
										getVal1 = configuration[j]['VALUE_1'];
									}
									if ( configuration[j]['VALUE_2'] != undefined )
									{
										getVal2 = configuration[j]['VALUE_2'];
									}
									genHTML +='<tr class="x-grid-row"><td class=" x-grid-cell x-grid-cell-first"><div class="x-grid-cell-inner">'+getVal1+'</div></td><td class=" x-grid-cell x-grid-cell-first"><div class="x-grid-cell-inner">'+getVal2+'</div></td></tr>';
								}
							}

							genHTML +='</tbody></table></div>';
						}
						else
						{
							var msg = configData['MSG'];
							genHTML = '<table cellspacing="0" cellpadding="0" border="0" width="100%"><tbody><tr class="x-grid-row"><td width="100%" height="170px" valign="middle" align="center"><div class="iconInformation" width="100%" style="text-align:center;margin:0px auto"></div><div>'+msg+'</div></td></tr></tbody></table>';
						}


						var configInfos = configData['configInfos'];
						var isHideToolbar = true;
						var configInfosLable = '';
						var configSelectedInfos = '';
						if(configInfos!=null && configInfos!='undefined' && configInfos!='-')
						{
							isHideToolbar = false;
							configInfosLable = configData['configInfosLable'];
							configSelectedInfos = configData['configSelectedInfos'];
						}
						atAGlanceArr.push(
						{
							xtype: 'commonPanel',
							//cls: 'block2',
							height: 200,
							padding:0,
							layout:'fit',
							title: configurationTitle,
							id: 'netconfig-'+i,
							//tools:toolsArr,
							tools: [
								{
									xtype : 'combo',
									hidden: isHideToolbar,
									labelWidth:45,
									fieldLabel: configInfosLable,
									store: new Ext.data.Store({
										fields: ['displayField', 'valueField'],
										data : configInfos
									}),
									value:configSelectedInfos,
									cls:'dropdown ',
									queryMode: 'local',
									stateId : componentName+'_AdapterInfos',
									stateful : true,
									displayField: 'displayField',
									valueField: 'valueField',
									listeners:{											 
										'select': function(combo)
										{
											var me=this;											
											var URL = "/final/monitor/egDashboardOverviewJSON.jsp";
											URL += "?"+"hostName="+encodeURIComponent(componentName)+"&compType="+encodeURIComponent(componentType)+"&selectedConfigInfos="+encodeURIComponent(combo.value)+"&tab=Network";
											Ext.Ajax.request({
												url: URL,
												method: 'GET',
												async: false,
												success: function( response )
												{
													if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
													{
														jsonText = response.responseText;	
														//console.log("jsonText",jsonText);
														jsonData = Ext.decode( jsonText );
														var CONFIG_DATAS = jsonData['CONFIG_DATAS'];
														for ( var i = 0; i < CONFIG_DATAS.length; i++ )
														{
															var configData = CONFIG_DATAS[i];
															var configurationTitle = configData['TITLE'];
															var type = configData['TYPE'];
															type = type.toLowerCase();
															if ( type == 'table' )
															{
																var CONFIGURATION = configData['CONFIGURATION'];
																var genHTML1 = '';
																if ( !Ext.isEmpty(CONFIGURATION) && CONFIGURATION != '-' )
																{
																	genHTML1 = '<div class="x-table"><table cellspacing="0" width="100%" cellpadding="0" border="0" class="x-grid-table x-grid-table-resizer"><tbody>';
																	for ( var j = 0; j < CONFIGURATION.length; j++ )
																	{
																		var getVal = '';
																		if ( CONFIGURATION[j]['TITLE'] != undefined )
																		{
																			genHTML1 +='<tr class="x-grid-row"><td colspan="2" class=" x-grid-cell x-grid-cell-first"><div class="x-grid-cell-inner">'+CONFIGURATION[j]['TITLE']+'</div></td></tr>';
																		}
																		else
																		{
																			var getVal1 = '', getVal2 = '';
																			if ( CONFIGURATION[j]['VALUE_1'] != undefined )
																			{
																				getVal1 = CONFIGURATION[j]['VALUE_1'];
																			}
																			if ( CONFIGURATION[j]['VALUE_2'] != undefined )
																			{
																				getVal2 = CONFIGURATION[j]['VALUE_2'];
																			}
																			genHTML1 +='<tr class="x-grid-row"><td class=" x-grid-cell x-grid-cell-first"><div class="x-grid-cell-inner">'+getVal1+'</div></td><td class=" x-grid-cell x-grid-cell-first"><div class="x-grid-cell-inner">'+getVal2+'</div></td></tr>';
																		}
																	}

																	genHTML1 +='</tbody></table></div>';
																}
																else
																{
																	var msg = CONFIG_DATAS['MSG'];
																	genHTML1 = '<table cellspacing="0" cellpadding="0" border="0" width="100%"><tbody><tr class="x-grid-row"><td width="100%" height="170px" valign="middle" align="center"><div class="iconInformation" width="100%" style="text-align:center;margin:0px auto"></div><div>'+msg+'</div></td></tr></tbody></table>';
																}
																me.up('panel').update(genHTML1);
															}
														}
													}
												},
												failure: function()
												{
													alert('I am in failure...');
												}
											});											
										}										
									}
								}
							],
							html: genHTML							
						});
					}
					else if ( type == 'spark' )
					{
						var configuration = configData['CONFIGURATION'];
						var genHTML = '';
						if ( configuration != '-' )
						{
							genHTML = '<div class="x-table"><table cellspacing="0" cellpadding="0" border="0" class="x-grid-table x-grid-table-resizer" width="100%"><tbody>';
							for ( var j = 0; j < configuration.length; j++ )
							{
								var conData = configuration[j];
								genHTML += '<tr class="x-grid-row" height="20px">';
								var genTD = '';
								for ( var kk in conData )
								{
									var getValue = conData[kk];
									if ( kk.toLowerCase() == 'state' )
									{
										genTD += '<td class="x-grid-cell x-grid-cell-first" width="30px"><div class="x-grid-cell-inner"><div class="state_'+getValue+'"></div></div></td>';
									}
									else if ( kk.toLowerCase() == 'link' )
									{
										var getLinkObj = getValue;
										var getMeasures = getLinkObj['MEASURE'];
										if ( getLinkObj['METHOD_NAME'] != undefined && getLinkObj['PARAMS'] != undefined )
										{
											var methodName = getLinkObj['METHOD_NAME'];
											var params = getLinkObj['PARAMS'];
											genTD += '<td class="x-grid-cell x-grid-cell-first"><div class="x-grid-cell-inner"><a href="javascript:void(0);" onclick="javascript:'+methodName+'(\''+params+'\');" title="'+getMeasures+'">'+getMeasures+'</a></div></td>';
										}
										else
										{
											genTD += '<td class="x-grid-cell x-grid-cell-first"><div class="x-grid-cell-inner">'+getMeasures+'</div></td>';
										}
									}
									else if ( kk.toLowerCase() == 'xml_data' )
									{
										var xmlData = getValue;
										if ( xmlData != '-' )
										{
											var swfPath = getValue['SWF_PATH'];
											genTD += '<td class="x-grid-cell x-grid-cell-first" width="100px"><div class="x-grid-cell-inner"><div id="net-chartSparkContainer'+cnt+'" style="border:0px solid red;height:20px;cursor:pointer"></div></div></td>';
										}
										else
										{
											genTD += '<td class="x-grid-cell x-grid-cell-first" width="100px"><div class="x-grid-cell-inner"><div id="net-chartSparkContainer'+cnt+'" style="border:0px solid red;height:20px;">'+xmlData+'</div></div></td>';
										}
										cnt++;
									}
									else if ( kk.toLowerCase() == 'value' )
									{
										if(getValue!=undefined && getValue > 0 && getValue!='' && !isNaN(getValue))
										{
											genTD += '<td class="x-grid-cell x-grid-cell-first" width="100px"><div class="x-grid-cell-inner">'+Number(getValue).toFixed(2)+'</div></td>';
										}
										else
										{
											genTD += '<td class="x-grid-cell x-grid-cell-first" width="100px"><div class="x-grid-cell-inner">'+getValue+'</div></td>';
										}
									}
								}
								genHTML += genTD+'</tr>';
							}
							genHTML +='</tbody></table></div>';
						}
						else
						{
							var msg = configData['MSG'];
							genHTML = '<table cellspacing="0" cellpadding="0" border="0" width="100%"><tbody><tr class="x-grid-row"><td width="100%" height="170px" valign="middle" align="center"><div class="iconInformation" width="100%" style="text-align:center;margin:0px auto"></div><div>'+msg+'</div></td></tr></tbody></table>';
						}
						
						atAGlanceArr.push(
						{
							xtype: 'commonPanel',
							//cls: 'block2',
							height: 200,
							padding:0,
							title: configurationTitle,
							dataArray: configuration,
							id: 'netconfig-'+i,
							//tools: toolsArr,
							html: genHTML
						});
					}
					else if ( type == 'grid' )
					{
						var XType = '';
						var columnWidth = 0.5;
						if ( configData['COLUMN_WIDTH'] != undefined )
						{
							columnWidth = configData['COLUMN_WIDTH'];
						}
						if ( configData['GRID_COLUMNS'] != undefined && configData['GRID_VALUES'] != undefined )
						{
							var gridCols = configData['GRID_COLUMNS'];
							var gridVals = configData['GRID_VALUES'];
							var columnArr = new Array();
							var gridStoreModel = new Array();
							if ( !Ext.isEmpty( gridCols ) )
							{
								for ( var l = 0 ; l < gridCols.length; l++ )
								{
									if(l==0)
									{
										gridStoreModel[gridStoreModel.length] = {name : 'COLUMN_'+l , type : 'string'};
									}
									else
									{
										gridStoreModel[gridStoreModel.length] = {name : 'COLUMN_'+l , type : 'FLOATORSTRING'};
									}
									columnArr.push({
										header: gridCols[l],
										flex: 0.2,
										dataIndex: 'COLUMN_'+l,
										renderer: function(value, metaData, record, row, col, store, gridView)
										{
											if( col == 1)
											{
												var tooltitle = value['TOOLTIP_TITLE'];
												var status = value['STATUS'];
												
												if(status == 'up'){												
													value = '<img title ="' + tooltitle + '" src="/final/images/spacer.gif" class="iconArrowUp" border="0">';
												} else if(status == 'down' ){
													value = '<img title ="' + tooltitle + '" src="/final/images/spacer.gif" class="iconArrowDown" border="0">';
												}
											} 
											return value;
										}
									});
								}
							}
							XType = {
								xtype: 'customgrid',
								cls:'gridSkin',
								width: '100%',
								//height:250,
								layout:'fit',
								flex:1,
								autoScroll: true,
								store: new Ext.data.Store({
									fields: gridStoreModel,
									data: gridVals
								}),
								columns: columnArr
							};
						}
						else
						{
							var msg = configData['MSG'];
							XType = {
								xtype: 'container',
								width: '100%',
								height: 200,
								html: '<table cellspacing="0" cellpadding="0" border="0" class="x-grid-table x-grid-table-resizer" width="100%"><tbody><tr class="x-grid-row"><td width="100%" height="170px" valign="middle" align="center"><div class="iconInformation" width="100%" style="text-align:center;margin:0px auto"></div><div>'+msg+' </div></td></tr></tbody></table>'
							};
						}
						if (XType!='')
						{
						atAGlanceArr.push(
						{
							xtype: 'commonPanel',
							//cls: 'block2',
							layout:{type:'vbox',align:'stretch'},
							flex:1,
							padding:0,
							columnWidth: columnWidth,
							height:250,
							title: configurationTitle,
							id: 'netconfig-'+i,
							//tools: toolsArr,
							items: [XType]
						});
						}

					}
					else if(type == 'fusion_chart')
					{
						var XML_DATA = configData['XML_DATA'];
						var SWF_PATH = configData['SWF_PATH'];
						var HEIGHT = configData['HEIGHT'];
						var WIDTH = configData['WIDTH'];
						atAGlanceArr.push(
						{
							xtype: 'panel',
							//cls: 'block1',
							frame:false,
							height: 200,
							title: configurationTitle,
							id: 'netconfig-'+i,
							//tools: toolsArr,
							html: '<div id="net-LayerwiseHealth" style="margin:0px auto 0px auto"></div>',
							listeners:{
							'afterrender': function(container)
							{
								if ( XML_DATA != '-' )
								{
										try
										{
											var barChart = {};
											barChart = jQuery.extend(true, {}, getHighChartsBarInstance('net-LayerwiseHealth',140,450), barChart);										
											barChart.setData(XML_DATA, currentDateFormat,"",'stackedBar');
											barChart.drawChart();
										}
										catch (barChartEx)
										{
											console.log(barChartEx);
										}
									
								}
								else
								{
									Ext.get('net-LayerwiseHealth').update('<div style="border:0px solid blue;margin:0px auto"><div class="iconInformation" width="100%" style="text-align:center;margin:0px auto;margin-top: 20px;"></div><div style="text-align:center;margin:0px auto;">'+noMeasureExcl+'</div></div>');
								}
							}
							}
						});
					}
					else
					{
						atAGlanceArr.push(
						{
							xtype: 'commonPanel',
							//cls: 'block2',
							height: 200,
							padding:0,
							title: configurationTitle,
							id: 'netconfig-'+i,
							//tools: toolsArr,
							 html: '<table cellspacing="0" cellpadding="0" border="0" class="x-grid-table x-grid-table-resizer" width="100%"><tbody><tr class="x-grid-row"><td width="100%" height="170px" valign="middle" align="center"><div class="iconInformation" width="100%" style="text-align:center;margin:0px auto"></div><div>'+noMeasureExcl+'</div></td></tr></tbody></table>'
						});
					}
				}
				configObj.add(atAGlanceArr);
				configObj.doComponentLayout();
				var counter = 0;
				for ( var ii = 0; ii < configObj.items.length; ii++ )
				{
					var getSparkBlockObj = Ext.getCmp('netconfig-'+ii);
					if ( getSparkBlockObj != undefined && getSparkBlockObj.dataArray != null )
					{
						var getDataArray = getSparkBlockObj.dataArray;
						var arrCnt = 0;
						for ( var jj = counter; jj < cnt; jj++ )
						{
							var getInnerHTML = getSparkBlockObj.getEl().dom.innerHTML;
							if ( getInnerHTML.indexOf('net-chartSparkContainer'+jj) > -1 )
							{
								var tmpXMLData = getDataArray[arrCnt]['XML_DATA'];
								if ( tmpXMLData != '-' )
								{
									var swfPath = getDataArray[arrCnt]['SPARK_PATH'];
								    var sparkChart = getSparkCharts('net-chartSparkContainer'+jj,'90','20',tmpXMLData,swfPath);

								}
							}
							arrCnt++;
						}
						counter += getSparkBlockObj.dataArray.length;
					}
				}
			}
		}
		netLastGraphTypeLoaded = 'SummaryAtGlance';
	},
	showDetailsTab: function( tabId, resultData ,isFlag)
	{
		var detailsObj = Ext.getCmp(tabId);
		detailsObj.setAutoScroll(true);
		if(isFlag == 'default')
		{
			detailsObj.removeAll();
			detailsObj.add({
			xtype: 'container',
			id: 'net-details-outer-panel',
			width: detailsObj.getWidth(),
			height: detailsObj.getHeight(),
			autoScroll: true,
			width:'100%',
			layout:{
				type: 'column'
			},
			defaults:{
				columnWidth: 0.333,
				cls:'datapanel',
				//margin:'5 0 10 10',
				//style:{'border':'#c3c3c3 1px solid'}
			}
		});
		detailsObj.doComponentLayout();
		}
		var defaultHeight = 0;
		var subSystemVal = Ext.getCmp('networksubsystem').getValue();
		if ( !Ext.isEmpty( subSystemVal ) && subSystemVal.toLowerCase() != 'overview' )
		{
			//defaultHeight = 133;
		}
		//detailsObj.setHeight( ( Ext.getBody().getHeight()-265 ) + defaultHeight );
		
		var tmpHeight = detailsObj.getHeight();
		//detailsObj.setAutoScroll(true);
		var outerChartArr = new Array();
		
		var outerObj = Ext.getCmp('net-details-outer-panel');
		outerObj.removeAll();
		var chartsData = resultData['CHARTS'];
		var hopDelayData = resultData['detailHopArr'];
		if ( !Ext.isEmpty( chartsData ) )
		{
			if ( chartsData['NO_CHARTS'] != undefined && chartsData['NO_CHARTS'] == 'true' )
			{
				var getMsg = chartsData['NO_CHARTS_MSG'];
				outerChartArr.push({
					xtype: 'panel',
					layout:'fit',
					columnWidth: 1,
					margin:10,
					border:true,
					frame:true,
					height:detailsObj.getHeight()-20,
					cls:'block1',
					html :'<table width="100%" height="100%" style="text-align:center"><tr><td><div class="iconInformation" style="margin:0px auto 0px auto"></div><div>'+getMsg+'</div></td></tr></table>'
				});
				outerObj.add(outerChartArr);
				outerObj.doComponentLayout();
			}
			else
			{
				var chartArr = new Array();
				for ( var i = 0; i < chartsData.length; i++ )
				{
					var chartData = chartsData[i];
					var tmpHeight = chartsData[i]['HEIGHT'];
					var tmpWidth = chartsData[i]['WIDTH'];
					var ddGraphUrlLarge = chartsData[i]['ddGraphUrlLarge'];
					outerChartArr.push({
						xtype: 'container', // Detail chart
						cls:'datapanel optionalListPanel',
						//style:{'border':'1px solid blue'},
						id: 'net-bar-container-'+i,
						dataArray: chartData,
						max:ddGraphUrlLarge,
						chartCnt : i,
						width : tmpWidth,
						height : tmpHeight,
						margin:'10 10 10 10',
						autoScroll : true,
						scroll : true,
						html:'<div id="net-barChart'+i+'" style="border 1px solid red;cursor:pointer;width:'+tmpWidth+'px;height:'+tmpHeight+'px"></div>',
						listeners : {
							'afterrender' : function()
							{
									//lineChart.setData(tmpJsonData,currentDateFormat,maxViewUrl,false,'bottom');
									try
									{
										//Ext.get("net-barChart"+i).setHeight(tmpHeight);
										//var barGraphHeight=this.dataArray['XML_DATA']['barGraphHeight'];
										var barGraphHeight=Ext.get('net-barChart'+this.chartCnt).getHeight();
										var barGraphWidth=Ext.get('net-barChart'+this.chartCnt).getWidth();
										var barChart = {};
										barChart = jQuery.extend(true, {}, getHighChartsBarInstance('net-barChart'+this.chartCnt, barGraphHeight,barGraphWidth), barChart);										
										var maxUrl=this.dataArray['ddGraphUrlLarge'];
										barChart.setData(this.dataArray['XML_DATA'], currentDateFormat, maxUrl,'bar');
										barChart.drawChart();
									}
									catch (barChartEx)
									{
										console.log(barChartEx);
									}
							},
							'resize' : function()
							{
									//lineChart.setData(tmpJsonData,currentDateFormat,maxViewUrl,false,'bottom');
									try
									{
										//Ext.get("net-barChart"+i).setHeight(tmpHeight);
										//var barGraphHeight=this.dataArray['XML_DATA']['barGraphHeight'];
										var barGraphHeight=Ext.get('net-barChart'+this.chartCnt).getHeight();
										var barGraphWidth=Ext.get('net-barChart'+this.chartCnt).getWidth();
										var barChart = {};
										barChart = jQuery.extend(true, {}, getHighChartsBarInstance('net-barChart'+this.chartCnt, barGraphHeight,barGraphWidth), barChart);										
										var maxUrl=this.dataArray['ddGraphUrlLarge'];
										barChart.setData(this.dataArray['XML_DATA'], currentDateFormat, maxUrl,'bar');
										barChart.drawChart();
									}
									catch (barChartEx)
									{
										console.log(barChartEx);
									}
							}
						}
					});
				}
				outerObj.add(outerChartArr);
				outerObj.doComponentLayout();
			}
		}
		else
		{
			outerChartArr.push({
				xtype: 'panel',
				layout:'fit',
				columnWidth: 1,
				margin:10,
				border:true,
				frame:true,
				height:detailsObj.getHeight()-20,
				cls:'block1',
				html :'<table width="100%" height="100%" style="text-align:center"><tr><td><div class="iconInformation" style="margin:0px auto 0px auto"></div><div>'+noMeasureExcl+'</div></td></tr></table>'
			});
			outerObj.add(outerChartArr);
			outerObj.doComponentLayout();
		}
			
		var hopDelayArr = new Array();
		if(!Ext.isEmpty(hopDelayData))
		{
			var hopDelayDatas = hopDelayData[0];
			var title = hopDelayDatas['TABLETITLE'];
			var type = hopDelayDatas['TYPE'];
			var emptyMsg = hopDelayDatas['Msg'];
			var gridwidth= detailsObj.getWidth()-5;
			if( emptyMsg!='true')
			{
				var delayCont = {
				xtype: 'container',
				height: 228,
				width: '100%',
				cls:'datapanel optionalListPanel',
				padding: '5% 0% 5% 0%',
				margin:'10 10 10 10',
				html: '<div style="border:0px solid red;text-align:center;margin:5px" ><div class="font_bold12">'+title+'</div><div class="x-table themeborder" style="margin-top: 6px;"><table class="x-grid-table x-grid-table-resizer" cellspacing="0" cellpadding="0" border="0"> <col style="width:25%"><col style="width:13%"><col style="width:13%"><col style="width:13%"><col style="width:41%"><thead><tr class="x-grid-row"><td class="x-grid-cell" align="center"><div class="x-grid-cell-inner ">'+hopDelayDatas['COLUMN_0']+'</div></td><td class="x-grid-cell" align="center"><div class="x-grid-cell-inner ">'+hopDelayDatas['COLUMN_1']+'</div></td><td class="x-grid-cell" align="center"><div class="x-grid-cell-inner ">'+hopDelayDatas['COLUMN_2']+'</div></td><td class="x-grid-cell" align="center"><div class="x-grid-cell-inner ">'+hopDelayDatas['COLUMN_3']+'</div></td><td class="x-grid-cell" align="center"><div class="x-grid-cell-inner ">'+hopDelayDatas['COLUMN_4']+'</div></td></tr></thead><tbody><tr><td class="x-grid-cell" align="center"><div class="x-grid-cell-inner ">'+hopDelayDatas['COLUMN_0_val']+'</div></td><td class="x-grid-cell" align="center" ><div class="x-grid-cell-inner ">'+hopDelayDatas['COLUMN_1_val']+'</div></td><td class="x-grid-cell" align="center" ><div class="x-grid-cell-inner ">'+hopDelayDatas['COLUMN_2_val']+'</div></td><td class="x-grid-cell" align="center" ><div class="x-grid-cell-inner ">'+hopDelayDatas['COLUMN_3_val']+'</div></td><td style="width:300px;padding:0px; height:24px" align="center" class="x-grid-cell" style="border-right: 1px solid #d7d7d7;"><div class="x-grid-cell-inner "><table cellpadding="1" cellpadding="0" border="0" style="table-layout:fixed;width:150px;height:20px" class="hop" ><tr><td align="center" class="x-grid-cell" >'+hopDelayDatas['COLUMN_4_val_0']+'</td><td align="center">'+hopDelayDatas['COLUMN_4_val_1']+'</td><td align="center" class="x-grid-cell"> '+hopDelayDatas['COLUMN_4_val_2']+'</td></tr></tbody></table></div></td></table></div></div>'
				}
			}
			outerObj.add(delayCont);
			outerObj.doLayout();
			//outerObj.doComponentLayout();
		}
		netLastGraphTypeLoaded = 'DDgraph';

	},
	showHistoryTab: function ( tabId, resultData,isFlag )
	{
		var uptimeVal = resultData['uptimeURL'];
		var historyObj = Ext.getCmp(tabId);
		historyObj.setAutoScroll(true);
		if(isFlag == 'default')
		{
			historyObj.removeAll();
		}
		var isUptimeEnabled = false;
		if( uptimeVal!=null && !Ext.isEmpty(uptimeVal) && uptimeVal!=undefined)
		{
			this.loadUptimeSummary(tabId,uptimeVal,isFlag);
			isUptimeEnabled = true;
		}
		var subSystemVal = Ext.getCmp('networksubsystem').getValue();
		var defaultHeight = 0;
		if ( !Ext.isEmpty( subSystemVal ) && subSystemVal.toLowerCase() != 'overview' )
		{
			//defaultHeight = 133;
		}
		historyObj.setAutoScroll(true);
		historyObj.setHeight((Ext.getBody().getHeight()-265)+defaultHeight);
		if ( historyObj.getEl() != undefined )
		{
			historyObj.getEl().mask(loadingLbl+"...", "maskCenter");
		}
		var tmpHeight = historyObj.getHeight();
		var subsystem = Ext.getCmp('networksubsystem').getValue();
		var chartsData = resultData['CHARTS'];
		var hiddens = resultData['hiddens'];
		netLastGraphTypeLoaded = hiddens['graphType'];
		if ( !Ext.isEmpty( chartsData )  )
		{
			if ( chartsData['NO_CHARTS'] != undefined && chartsData['NO_CHARTS'] == 'true' )
			{
				var getMsg = chartsData['NO_CHARTS_MSG'];
					if(subsystem == 'Overview')
				{
					var marginvar="margin:6% auto 0px auto"
				}
				else
				{
					var marginvar="margin:9% auto 0px auto"
				}
				if(isFlag == 'default')
				{
					historyObj.add({
						xtype: 'container',
						id:'NetnoCharts_Measure',
						height:350,
						width:'100%',
						margin:'0px 0px 0px 0px',
						html :'<table width="200px" height="200px" style="'+marginvar+'"><tr><td align="center"><div class="iconInformation" style="margin:0px auto"></div>'+getMsg+'</td></tr></table>'
					});
				}
				else if(Ext.getCmp('NetnoCharts_Measure')!=null)
				{
					Ext.getCmp('NetnoCharts_Measure').update('<table width="200px" height="200px" style="'+marginvar+'"><tr><td align="center"><div class="iconInformation" style="margin:0px auto"></div>'+getMsg+'</td></tr></table>');
				}
				else
				{
					historyObj.add({
						xtype: 'container',
						id:'NetnoCharts_Measure',
						height:350,
						width:'100%',
						margin:'0px 0px 0px 0px',
						html :'<table width="200px" height="200px" style="'+marginvar+'"><tr><td align="center"><div class="iconInformation" style="margin:0px auto"></div>'+getMsg+'</td></tr></table>'
					});
				}
			}
		}
		else if ( !Ext.isEmpty( resultData['MEASURE_GRAPHS'] ) && hiddens['graphType'] == 'measureGraph' )
		{
			var chartArr = new Array();
			var measureData = resultData['MEASURE_GRAPHS'];
			if (isFlag=='default')
			{
				historyObj.add({
					xtype: 'container',
					id: 'net-chart-container',
					width: '100%',
					//autoScroll: true,
					margin:'10',
					//height: ( 315 + defaultHeight ),
					layout: 'column',
					defaults:{
					columnWidth: 0.333,
					cls:'datapanel',
					
					//style:{'border':'red 1px solid','text-align':'center'}
				}
				});
				historyObj.doComponentLayout();
			}
			for ( var i = 0; i < measureData.length; i++ )
			{
				var chartData = measureData[i];
				var tmpHeight = chartData['HEIGHT'];
				var tmpWidth = chartData['WIDTH'];
				var chartTitle = chartData['TITLE'];
				var toolTipTitle = chartData['TOOLTIP_TITLE'];
				var imgSrc = chartData['IMG_SRC'];
				var hightChartEnabled = chartData['HIGH_CHART'];
				var genHTML = '';
				if ( hightChartEnabled == 'false' )
				{
					var maxViewUrl = measureData[i]['PARAMS'];					
					genHTML = '<img onClick="javascript:MeasureGraphOnClick(\''+maxViewUrl+'\');" src="'+imgSrc+'" height="'+tmpHeight+'" width="'+tmpWidth+'" />';
				}
				else
				{
					genHTML = '<div id="net-high-chart-'+i+'" style="border:0px solid yellow;height:'+tmpHeight+'px;width:'+tmpWidth+'px;margin:0px auto;"></div>';
				}
				chartArr.push({
					xtype: 'panel',
					id: 'net-measure-graph-'+i,
					cls:'datapanel optionalListPanel cursor',
					margin:'5',					
					padding:0,
					bodyPadding:5,
					width: '100%',
					dataArray: chartData,
					items: [
						
						{
							xtype: 'label',
							style:{'text-align':'center'},
							html: '<div title="'+toolTipTitle+'" class="font_bold" style="padding:5px;margin-top:7px;text-align:center">'+chartTitle+'</div>'
						},
						{
							xtype: 'container',
							width: '100%',
							html: genHTML
						}
					]
				});
			}
			Ext.getCmp('net-chart-container').removeAll();
			Ext.getCmp('net-chart-container').add(chartArr);
			Ext.getCmp('net-chart-container').doComponentLayout();
			for ( var i = 0; i < measureData.length; i++ )
			{
				var imgSrc = measureData[i]['IMG_SRC'];
				if ( measureData[i]['HIGH_CHART'] == 'true' )
				{
					var maxViewUrl = measureData[i]['PARAMS'];
					if ( Ext.get('net-high-chart-'+i) != null && Ext.get('net-high-chart-'+i) != 'null' && Ext.get('net-high-chart-'+i) != undefined )
					{
						Ext.Ajax.request({
							url: imgSrc,
							method: 'GET',
							async: false,
							success: function( response )
							{
								if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
								{
									var tmpJsonTxt = response.responseText;
									if ( tmpJsonTxt.indexOf('png') == -1 && tmpJsonTxt.indexOf('PNG') == -1 && tmpJsonTxt.indexOf('gif') == -1 && tmpJsonTxt.indexOf('GIF') == -1 )
									{
										var tmpJsonData = Ext.decode( tmpJsonTxt );
										try
										{
											var lineChart = {};
											lineChart = jQuery.extend(true, {}, getHighCharts('net-high-chart-'+i, measureData[i]['HEIGHT'],measureData[i]['WIDTH'],maxViewUrl), lineChart);
											if ( tmpJsonData.hasOwnProperty('title'))
											{
												tmpJsonData.title='';
											}
											tmpJsonData['legVerAlignWBottom'] = true;
											lineChart.setData(tmpJsonData,currentDateFormat,maxViewUrl,true,'bottom');
											lineChart.drawChart();
										}
										catch (e)
										{
											alert("e::"+e)
										}
									}
									else
									{
										Ext.get('net-high-chart-'+i).update('<table width="100%" height="200px"><tr><td align="center"><div class="iconInformation" style="margin:0px auto;margin-top:-50px"></div>'+noMeasureExcl+'</td></tr></table>');
									}
								}
								else
								{
									Ext.get('net-high-chart-'+i).update('<table width="100%" height="200px"><tr><td align="center"><div class="iconInformation" style="margin:0px auto;margin-top:-50px"></div>'+noMeasureExcl+'</td></tr></table>');
								}
							}
						});
					}
				}
			}
		}
		else if ( !Ext.isEmpty( resultData['SUMMARY_GRAPHS'] ) && hiddens['graphType'] == 'summaryGraph' )
		{
			var chartArr = new Array();
			var measureData = resultData['SUMMARY_GRAPHS'];
			if(isFlag == 'default')
			{
				historyObj.add({
					xtype: 'container',
					id: 'net-chart-container',
					width: '100%',
					autoScroll: !isUptimeEnabled,
					//height: ( 600 + defaultHeight ),
					layout: 'column',
					defaults: {
						columnWidth: 0.5
					}
				});
				historyObj.doComponentLayout();
			}
			for ( var i = 0; i < measureData.length; i++ )
			{
				var chartData = measureData[i];
				var tmpWidth = chartData['WIDTH'];
				var tmpHeight = chartData['HEIGHT'];
				var chartTitle = chartData['TITLE'];
				var toolTipTitle = chartData['TOOLTIP_TITLE'];
			
				var maxUrl = chartData['summryFullviewGraphUrl'];
				chartArr.push(
					{
						xtype:'container',
						margin:5,
						cls:'containerShadow',
						items:[
							{
								xtype: 'label',
								html: '<div style="text-align: center;margin-top: 10px;"><span title="'+toolTipTitle+'" style="padding:5px;text-align:center">'+chartTitle+'</span></div>'
							},
							{
								xtype: 'container',								
								margin:'10',								
								width: '100%',
								id: 'net-summary-graph-'+i,
								dataArray: chartData,
								MaxURL :maxUrl,
								style:{
									cursor:'pointer'
								},
								html: '<div style="text-align:center;padding:0px 0px" ><div id="net-summaryChart-'+i+'" style="width:'+tmpWidth+'px;height:'+tmpHeight+'px;margin:0px auto"></div></div>',							
								listeners : {
									'afterrender' : function(comp)
									{
										var xmlData = this.dataArray['XML_DATA'];								
											try
											{
												var barChart = {};
												barChart = jQuery.extend(true, {}, getHighChartsBarInstance(comp.id, 250, tmpWidth), barChart);
												barChart.setData(xmlData, currentDateFormat, comp.MaxURL,'stackedColumn');
												barChart.drawChart();
											}
											catch (barChartEx)
											{
												console.log(barChartEx);
											}
										}
								}
							}]					
						
				});
			}
			Ext.getCmp('net-chart-container').removeAll();
			Ext.getCmp('net-chart-container').add(chartArr);
			Ext.getCmp('net-chart-container').doLayout();
		}
		else if ( !Ext.isEmpty( resultData['TREND_GRAPHS'] ) && hiddens['graphType'] == 'trendGraph' )
		{
			var chartArr = new Array();
			var measureData = resultData['TREND_GRAPHS'];
			if(isFlag == 'default')
			{
				historyObj.add({
					xtype: 'container',
					id: 'net-chart-container',
					width: '100%',
					autoScroll: !isUptimeEnabled,
					margin:10,
					//height: (600 + defaultHeight ),
					layout: 'column',
					defaults: {
						columnWidth: 0.33
					}
				});
				historyObj.doComponentLayout();
			}
			for ( var i = 0; i < measureData.length; i++ )
			{
				var chartData = measureData[i];
				var tmpWidth = chartData['WIDTH'];
				var tmpHeight = chartData['HEIGHT'];
				var chartTitle = chartData['TITLE'];
				var toolTipTitle = chartData['TOOLTIP_TITLE'];
					chartArr.push({
						xtype: 'panel',
						cls:'datapanel optionalListPanel cursor',
						margin:'5',
						//padding:5,
						bodyPadding:5,
						id: 'net-trend-graph-'+i,
						width: '100%',
						//style : 'border:2px solid red',
						dataArray: chartData,
						items: [
							{
								xtype: 'label',
								style:{'text-align':'center'},
								html: '<div title="'+toolTipTitle+'" class="font_bold" style="padding:5px;margin-top:7px;text-align:center" >'+chartTitle+'</div>'
							},
							{
								xtype: 'container',
								id : 'net-trendChart-'+i,
								//style : 'border:2px solid blue',
								width: '100%',
								height : parseInt(tmpHeight)
								//html: '<div id="sys-trendChart-'+i+'" style="border:1px solid yellow;cursor:pointer;height:'+tmpHeight+'px;width:100%"></div>'
								//<div style="text-align:center"><div data-qtip="'+toolTipTitle+'"     data-qclass="yellowTip"><b>'+chartTitle+'</b></div>
							}
						]

					});
			}
			Ext.getCmp('net-chart-container').removeAll();
			Ext.getCmp('net-chart-container').add(chartArr);
			Ext.getCmp('net-chart-container').doComponentLayout();
			for ( var i = 0; i < measureData.length; i++ )
			{
				var getSummaryObj = Ext.getCmp('net-trend-graph-'+i);
				var tmpDataArray = getSummaryObj.dataArray;
				var charwidth = getSummaryObj.getWidth();
				var xmlData = tmpDataArray['XML_DATA'];
				if ( xmlData != '-' )
				{
						try
						{
							var chartWidth = tmpDataArray['WIDTH'];
							var chartHeight = tmpDataArray['HEIGHT'];
							var maxUrl = tmpDataArray['minMaxtrendFullView'];
							//chartHeight=220;
							var lineChart = {};
							lineChart = jQuery.extend(true, {}, createLineChart('net-trendChart-'+i,chartHeight,charwidth-16,false), lineChart);
							lineChart.setData(xmlData, currentDateFormat,maxUrl ,'line',true);
							lineChart.drawChart();
						}
						catch (barChartEx)
						{
							console.log(barChartEx);
						}
					}
				}			
		}
		if ( Ext.getCmp('net-calendar-btn') != undefined )
		{
			//Ext.getCmp('net-calendar-btn').fireEvent('loadTime', Ext.getCmp('net-calendar-btn'));
		}
		if ( historyObj.getEl() != undefined )
		{
			historyObj.getEl().unmask();
		}
	},
	loadUptimeSummary : function(tabId , uptimeURL ,isFlag)
    {
		var uptimeArr ='';
        var atAGlanceArr = new Array();
        Ext.Ajax.request({
            url: uptimeURL,
            method: 'POST',
            async: false,
            success: function( response )
            {
                if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
                {
                    var jsonText = response.responseText;
                    var jsonData = Ext.decode( jsonText );
                    uptimeArr = jsonData['uptimeArr'];
                    var uptimeDatas = uptimeArr[0];
                    var rebootDatas = uptimeArr[1];
                    var tableTitle = uptimeDatas['tableTitle'];
                    var historyObj = Ext.getCmp(tabId);
                    if(isFlag=='default')
					{
	                    historyObj.removeAll();
	                    historyObj.add({
	                        xtype: 'container',
	                        columnWidth: 3.0,
	                        layout: 'column',
	                        width:'100%',
	                        defaults:{
	                        columnWidth:0.5},
	                        padding: 4,
	                        id: 'net-uptime-container'
	                    });
	                    historyObj.doComponentLayout();
					}
                    var uptimeObj = Ext.getCmp('net-uptime-container');
                    var RebootTitle = rebootDatas['RebootTitle'];
                    var msg = rebootDatas['Msg'];
                    var genHTML="";
                    var genaHTML="";

                    if( tableTitle!=null && !Ext.isEmpty(tableTitle) )
                    {
                        genHTML = '<table cellspacing="0" cellpadding="0" border="0" class="x-grid-table x-grid-table-resizer" width="100%"><tbody>'
                                    +'<tr class="x-grid-row"><td width="100%" height="170px" valign="middle" align="center"><div class="iconInformation" width="100%" style="text-align:center;"></div><div>'+noMeasureExcl+'</div></td></tr></tbody></table>';
                    }
                    else
                    {
                        genHTML = '<table cellspacing="0" cellpadding="0" border="0" class="x-grid-table x-grid-table-resizer" width="100%"><tbody>';
                        genHTML += '<tr class="x-grid-row" height="20px">';
                        genHTML += '<td class="x-grid-cell" >'+uptimeDatas['COLUMN_0']+'</td>'
                        genHTML += '<td class="x-grid-cell">'+uptimeDatas['COLUMN_0_val']+'</td>';
                        genHTML += '</tr>';
                        genHTML += '<tr class="x-grid-row" height="20px">';
                        genHTML += '<td class="x-grid-cell">'+uptimeDatas['COLUMN_1']+'</td>';
                        genHTML += '<td class="x-grid-cell">'+uptimeDatas['COLUMN_1_val']+'</td>';
                        genHTML += '</tr>';
                        genHTML += '<tr class="x-grid-row" height="20px">';
                        genHTML += '<td class="x-grid-cell">'+uptimeDatas['COLUMN_2']+'</td>';
                        genHTML += '<td class="x-grid-cell">'+uptimeDatas['COLUMN_2_val']+'</td>';
                        genHTML += '</tr>';
                        genHTML += '<tr class="x-grid-row" height="20px">';
                        genHTML += '<td class="x-grid-cell">'+uptimeDatas['COLUMN_3']+'</td>';
                        genHTML += '<td class="x-grid-cell">'+uptimeDatas['COLUMN_3_val']+'</td>';
                        genHTML += '</tr>';
                        genHTML += '<tr class="x-grid-row" height="20px">';
                        genHTML += '<td class="x-grid-cell">'+uptimeDatas['COLUMN_4']+'</td>';
                        genHTML += '<td class="x-grid-cell">'+uptimeDatas['COLUMN_4_val']+'</td>';
                        genHTML += '</tr>';
                        genHTML +='</tbody></table>';
                    }

                    if( msg!=null && msg == 'true' )
                    {
                        genaHTML = '<table cellspacing="0" cellpadding="0" border="0" class="x-grid-table x-grid-table-resizer" width="100%"><tbody>'
                                    +'<tr class="x-grid-row"><td width="100%" height="170px" valign="middle" align="center"><div class="iconInformation" width="100%" style="text-align:center;"></div><div>'+rebootDatas['EmptyMsg']+'! </div></td></tr></tbody></table>';
                    }
                    else
                    {
                        genaHTML = '<div class="x-table"><table cellspacing="0" cellpadding="0" border="0" class="x-grid-table x-grid-table-resizer" width="100%"><tbody>';
                        genaHTML += '<tr class="x-grid-row" height="20px">';
                        genaHTML += '<td class="x-grid-cell" >'+rebootDatas['COLUMN_0']+'</td>'
                        genaHTML += '<td class="x-grid-cell">'+rebootDatas['COLUMN_1_val']+'</td>';
                        genaHTML += '</tr>';
                        genaHTML += '<tr class="x-grid-row" height="20px">';
                        genaHTML += '<td class="x-grid-cell">'+rebootDatas['COLUMN_1']+'</td>';
                        genaHTML += '<td class="x-grid-cell">'+rebootDatas['COLUMN_2_val']+'</td>';
                        genaHTML += '</tr>';
                        genaHTML +='</tbody></table></div>';
                    }
                    atAGlanceArr.push({
                            xtype: 'commonPanel',
                            id: 'net-uptimeSum',
                            //width: 300,
                            padding:'0px 10px 0px 0px',
                            height: 200 ,
                            title:tableTitle,
                            html : genHTML
                    });
                    atAGlanceArr.push({
                            xtype: 'commonPanel',
                            id: 'net-rebootSum',
                            //width: 300,
							height: 200 ,
                            padding:'0px 0px 0px 0px',
                            title:RebootTitle,
                            html : genaHTML
                    });
                    uptimeObj.removeAll();
                    uptimeObj.add(atAGlanceArr);
                    uptimeObj.doComponentLayout();
                }
            }
           });
    },
	callView: function( graphType )
    {
    	var isFlag = 'default';
    	var getPanelObj = Ext.getCmp(Ext.getCmp('Nettabpanel').getActiveTab().getId());
    	getPanelObj.getEl().mask(loadingLbl+'...', 'maskCenter');
    	var me = this;
    	var tmpTimeline = (Ext.getCmp('net_er_timeline')!=undefined)?Ext.getCmp('net_er_timeline').getValue():timelineVals['timeline'];
    	///var startDt = Ext.Date.format((Ext.getCmp('net_er_stdate') != undefined)?Ext.getCmp('net_er_stdate').getValue():timelineVals['starttime'], mgrDateFormat);
    	//var endDt = Ext.Date.format((Ext.getCmp('net_er_enddate') != undefined )?Ext.getCmp('net_er_enddate').getValue():timelineVals['endtime'], mgrDateFormat);
		var startDt="";
		var endDt="";
		if((Ext.getCmp('net_er_stdate') != undefined))
		{
			startDt = formatDate(Ext.getCmp('net_er_stdate').getValue(), mgrDisplayDateFormat);			
		}
		else
		{
			startDt = timelineVals['starttime'];
		}
		if((Ext.getCmp('net_er_enddate') != undefined))
		{
			endDt = formatDate(Ext.getCmp('net_er_enddate').getValue(), mgrDisplayDateFormat);
		}
		else
		{
			endDt = timelineVals['endtime'];
		}
		var netTimelineObj = Ext.get('net-configModApp');
		if(!Ext.isEmpty(netTimelineObj))
		{
			netTimelineObj.hide();
			netTimelineObj=null;
		}
    	var starthr = (Ext.getCmp('net_er_sthr') != undefined )?Ext.getCmp('net_er_sthr').getValue():timelineVals['starthour'];
    	var endhr = (Ext.getCmp('net_er_endhr') != undefined )?Ext.getCmp('net_er_endhr').getValue():timelineVals['endhour'];
		var genParams = '';
		if (graphType == 'summaryGraph' || graphType == 'trendGraph' )
		{
    		genParams = 'tab=Network&hostName='+encodeURIComponent(requestParams.hostName)+'&compType='+encodeURIComponent(componentType)+'&subsystem='+encodeURIComponent(Ext.getCmp('networksubsystem').getValue())+'&graphType='+encodeURIComponent(graphType)+'&showGraph='+encodeURIComponent(graphType)+'&time_line=24 hours&starttime='+encodeURIComponent(startDt)+'&endtime='+encodeURIComponent(endDt)+'&starthr='+encodeURIComponent(starthr)+'&endhr='+encodeURIComponent(endhr)+'&format='+encodeURIComponent(dateFormatForTimeline)+'&host='+encodeURIComponent(requestParams.hostName);
		}
		else
		{
			genParams = 'tab=Network&hostName='+encodeURIComponent(requestParams.hostName)+'&compType='+encodeURIComponent(componentType)+'&subsystem='+encodeURIComponent(Ext.getCmp('networksubsystem').getValue())+'&graphType='+encodeURIComponent(graphType)+'&showGraph='+encodeURIComponent(graphType)+'&time_line=1 hour&starttime='+encodeURIComponent(startDt)+'&endtime='+encodeURIComponent(endDt)+'&starthr='+encodeURIComponent(starthr)+'&endhr='+encodeURIComponent(endhr)+'&format='+encodeURIComponent(dateFormatForTimeline)+'&host='+encodeURIComponent(requestParams.hostName);
		}
		netLastLoadedURL = '/final/monitor/egNetDashBoardJSON.jsp?'+genParams;  
		me.loadInnerTab(Ext.getCmp('Nettabpanel').getActiveTab().getId(), '/final/monitor/egDashboardHistoryJSON.jsp?'+genParams,isFlag);
	   	netLastGraphTypeLoaded = graphType;
    },
//cisco dashboard
	AreaGraphOnClick: function(urlData)
	{
		Ext.getCmp('ciscomainpanel').hide();	
		Ext.getCmp('subNetworkPanelId').hide();
		Ext.getCmp('subnetworktabpanelID').hide();
		var wobj =  this.getNetworkmainpanel();	
		wobj.remove('maximizeview');
		wobj.add({
			xtype:'maximizeview',		
			width : (Ext.getBody().getViewSize().width-10),
			height : (Ext.getBody().getViewSize().height-60),
			Dataurl:urlData		
		});	
		wobj.doLayout();
		wobj.show();
	},
	filterDecode : function(text)
	{
		//['%;()=]
		var filterEncodeChar = ['[',']','(',')','=','%','\''];
		var filterDecodeText = ['|lsbr|','|rsbr|','|lbr|','|rbr|','|eq|','|per|','|squot|'];
		try
		{
			if(text != null && text != undefined && !Ext.isEmpty(text))
			{
				for(var a in filterEncodeChar)
				{
					var encode_char = filterEncodeChar[a];
					var decode_char = filterDecodeText[a];
					do
					{
						text=text.replace(decode_char,encode_char);
					}
					while (text.indexOf(decode_char)>-1);
				}
			}
		}
		catch (e)
		{
		}
		return text;
	},
	loadMaximizedView: function()
	{
		var me =this;
		var fullViewPanelObj = Ext.getCmp('maximize');
		var urlData = fullViewPanelObj.Dataurl;			
		var isHighChartEnabled = '';
		var graphFormat = '';
		if(urlData.lastIndexOf('&') >0 )
		{
			graphFormat = urlData.substring(urlData.lastIndexOf('&')+1);
			graphFormat  = graphFormat.split('=');
			graphFormat = graphFormat[1];
		}		
		if (graphFormat!=null && graphFormat.toLowerCase() == 'highcharts')
		{		
			Ext.Ajax.request({
				url:urlData,
				method: 'POST',
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						var tmpJsonTxt = response.responseText;							
						if ( tmpJsonTxt.indexOf('png') == -1 && tmpJsonTxt.indexOf('PNG') == -1 && tmpJsonTxt.indexOf('gif') == -1 && tmpJsonTxt.indexOf('GIF') == -1 )
						{				
							var chartData=Ext.decode(tmpJsonTxt);
							var subsystemVal = Ext.getCmp('ciscosubsystem').getValue();
							if(subsystemVal!=null && subsystemVal=='protocols')
							{
								var titleforProtocol = Ext.getCmp('bandwidthMainPanel').title;
								var interfaceVal = Ext.getCmp('interfaceCombo').getValue();
								var title = titleforProtocol.substring(0,titleforProtocol.indexOf("-"))+" for "+interfaceVal+" - "+ titleforProtocol.substring(titleforProtocol.indexOf("-")+1);
								title = me.filterDecode(title);
								fullViewPanelObj.setTitle(title);
							}
							else
							{
								var title = chartData['title'];
								title = title.replace("percent","%");
								title = me.filterDecode(title);
								fullViewPanelObj.setTitle(title);
							}
							fullViewPanelObj.add({
								xtype: 'container',	
								id:'netareaChrtCont',								
								padding:'5 3px 0 10px',
								layout:{type:'vbox',align:'stretch'},
								margin:'20px 0px 0px 0px',
								items:[
									{
										xtype:'container',
										height: 58,
										scroll:true,
										id:'protocolArealegend',
										autoScroll:true,
										overflowY:'auto',
										cls:'scrollCon',
										
									},{
										xtype:'container',
										flex:1,
										id : 'net_Area_high_chart_max',
										html : '<div id="net_Area_high_chart" style="margin-top:20px;border:0px solid yellow;"></div>',
										listeners : {
											
									'afterrender': function(thisObj)
									{										
										var liveMeasHtml = "";
										//console.log("thisObj",thisObj.up('panel').getWidth()-15);
										//console.log("thisObj",thisObj.up('panel').getHeight());
										var net_Area_high_chart_maxWidth = thisObj.up('panel').getWidth()-15;
										var net_Area_high_chart_maxHeight = thisObj.up('panel').getHeight()-90;
										var dataSetObj = chartData['DataSet'];
										if ((dataSetObj != null && !Ext.isEmpty(dataSetObj))) 
										{
											liveMeasHtml += '<div class="chartCount" style="position:relative;z-index:88;">';
											liveMeasHtml += '<ul>';
											for ( var dObj in dataSetObj) 
											{
												var seriesObj = dataSetObj[dObj];
												if (seriesObj != null && seriesObj.hasOwnProperty('dispLegend')) 
												{												
													var legndName = seriesObj['dispLegend'];
													var measVal = seriesObj['measVal'];
													var layerModelUrl = seriesObj['layerModelUrl'];
													var legndColor=seriesObj['color'];
													var unitForMeas=seriesObj['unit'];
													liveMeasHtml += '<li style="display:block">';
													liveMeasHtml += '<div style="margin-top:-10px;float:left;" "><span class="chartLegend" style="color:'+legndColor+';display: inline-block !important;">.</span>';
													if(legndName!=null && legndName!="-" && measVal!=null && measVal!="-")
													{
														liveMeasHtml += '<a  href=\'javascript:wayToLayerModelForArea("' + encodeURIComponent(layerModelUrl) + '")\'><span class="status font_bold netflowLabel">'+legndName+'</span></a>';
													}
													else
													{
														liveMeasHtml += '<span class="status font_bold">'+legndName+'</span>';
													}
													if(unitForMeas!=null && unitForMeas!="-" && measVal!=null && measVal!="-")
													{
														liveMeasHtml += '<a href=\'javascript:wayToLayerModelForArea("' + encodeURIComponent(layerModelUrl) + '")\'><span class="matric font_bold"> ('+unitForMeas+')</span></a>';
													}
													else
													{
														liveMeasHtml += '<span class="matric font_bold"> ('+unitForMeas+')</span>';
													}
													liveMeasHtml+='</div>';
													if(measVal!=null && measVal!="-" )
													{
														liveMeasHtml += '<div class="font_bold" style="padding-left:8px;float:left"><a href=\'javascript:wayToLayerModelForArea("' + encodeURIComponent(layerModelUrl) + '")\'>'+measVal+'</a></div>';	
													}
													else
													{
														liveMeasHtml += '<div class="font_bold" style="padding-left:8px">'+measVal+'</div>';
													}
													liveMeasHtml+='<div style="clear:both"></div>';
													liveMeasHtml+='</li>';
												}
											}
											liveMeasHtml += '</ul>';
											liveMeasHtml += '</div>';
											Ext.get('protocolArealegend').update(liveMeasHtml);	
										}
										try
										{											
											var lineChart = {};
											var net_Area_high_chart_max_Width =	Ext.getCmp('net_Area_high_chart_max').getWidth();
											//console.log("net_Area_high_chart_max_Width",net_Area_high_chart_max_Width);
											lineChart = jQuery.extend(true, {}, getHighCharts('net_Area_high_chart', net_Area_high_chart_maxHeight,net_Area_high_chart_maxWidth,''), lineChart);
											lineChart.setData(chartData,currentDateFormat,'',true,'bottom');
											lineChart.drawChart();
										}
										catch (e)
										{
											alert("e::"+e)
										}	
									}
								}
									}	
								]
							});										
						}
						else
						{
							fullViewPanelObj.update(tmpJsonTxt);
						}							
					}
					else
					{						
						fullViewPanelObj.update("<table border='0' height='100%' width='100%'><tr><td align='center'><img src='/final/monitor/eg_images/gray/graph_error_message.gif'></td></tr></table>");
					}
				}
			});		
		}
		else if(graphFormat!=null && graphFormat.toLowerCase() == 'easycharts')
		{
			fullViewPanelObj.update('<table width="600px" height="360px"><tr><td align="center" valign="middle"><img  src="' + urlData + '" border="0" /></td></tr></table>');
		}
	},
	ciscoDefaultLoad: function(jsonData)
	{
		if(Ext.getCmp('subNetworkPanelId')==null || Ext.getCmp('subNetworkPanelId')==undefined)
		{
			this.getNetworkmainpanel().add(
			{
				xtype:'subnetworkpanel',
				id:'subNetworkPanelId',
				name:'subNetworkPanelId',
				margin:0,
				bodyPadding:0,
				border:true
			}
			,{
				xtype:'subnetworktabpanel',
				id:'subnetworktabpanelID',
				name:'subnetworktabpanelID'
			},
			{
				xtype:'ciscomainpanel',
				hidden:true
			});
		}

		Ext.getCmp('ciscomainpanel').show();
		Ext.getCmp('subNetworkPanelId').hide();
		Ext.getCmp('subnetworktabpanelID').hide();
		var me=this;
		//Ext.getCmp('networkmainpanel').suspendEvents(true);
		var getElObj = this.getMain().getEl();
		getElObj.mask(loadingLbl+"...", "maskCenter");
		if ( jsonData != '' && jsonData != null && !Ext.isEmpty(jsonData))
		{
			getElObj.unmask();
			ciscoData = jsonData;
			var subsystemCombo = jsonData['subSystemArr'];
			var subsystem = jsonData['subsystemSelected'];
			me.setValueWithOptionInList('ciscosubsystem', subsystemCombo, subsystem );

			if ( subsystem != undefined )
			{				
				if ( subsystem.toLowerCase() == 'overview' )
				{					
					Ext.getCmp('ciscodialpanel').show();
					Ext.getCmp('currentAlertBar').show();
					Ext.getCmp('protocolpanelID').hide();
					Ext.getCmp('flowspanelID').hide();
					Ext.getCmp("cisco_Timeline").getStore().loadRawData(jsonData['GRID_DATA']['TIMELINE_VALUES']);
					var selectedTimeline='1 hour';
					if(jsonData['GRID_DATA'].hasOwnProperty('selectedTimeline'))
					{
						selectedTimeline=jsonData['GRID_DATA']['selectedTimeline'];
					}
					Ext.getCmp("cisco_Timeline").setValue(selectedTimeline);
					var main_Title=jsonData['GRID_DATA']['MAIN_TITLE'];
					Ext.getCmp('cisco_areachartView').setTitle(main_Title);
					var overviewData = jsonData['OVERVIEW'];
					if(isExcludedNetflowDeviceAvailable)
					{
						Ext.getCmp('ciscooverviewpanel').show();
						me.showCiscoOverview(overviewData);
					}
					else if(isIncludedNetflowDeviceAvailable)
					{
						me.showNetflowOverview(overviewData);
					}
					var dialData=jsonData['FUSION-CHART']['dialChartValues'];
					layerModelURL = jsonData['hiddens'];
					var NoMeasure=jsonData['NoMeasure'];
					
					if(Ext.getCmp('cisco_TabularView')!=null && Ext.getCmp('cisco_TabularView').clicked==true)
					{						
						isFlag = true;
						this.onTabularViewButton(Ext.getCmp('cisco_TabularView'));
						
					}else
					{						
						me.loadAreaCharts();
					}

					var resultObj = Ext.getCmp('cisco_dialpanel');
					resultObj.removeAll();
					if(!Ext.isEmpty(dialData) && dialData!=null && dialData!=undefined)
					{
						Ext.getCmp('cisco_dialpanel').defaults.columnWidth = (1/dialData.length);
						for ( var i = 0; i < dialData.length ; i++ )
						{
							var xmlData=dialData[i]['dialXMLData'];
							var swfPath=dialData[i]['FusionChartsURL'];
							var dialGraphHeight=dialData[i]['dialGraphHeight'];
							var tooltip=dialData[i]['tooltip'];
							var dialGraphWidth=dialData[i]['dialGraphWidth'];
							var unit=dialData[i]['unit'];
							if(xmlData!=null && xmlData!=" " && xmlData!=undefined && xmlData!="-")
							{
								var chartDatObj = new Date();
								var rndrId = 'Fusionchart'+i+'_'+chartDatObj.getMinutes()+"_"+chartDatObj.getSeconds();
								var chartDispDivId = 'Dial_chart'+i;
								resultObj.add(
								{
									xtype: 'container',
									//height:500,
									chartRndrId : rndrId,
									chartDivId : chartDispDivId,
									cls:'searchSeperatorLine',
									id:'Fusion_chart'+i,
									chartXmlData : xmlData,
									dataArray: dialData,
									padding:10,
									items:[
										{
											xtype: 'label',
											width:'150',											
										html: '<div style="font-weight:bold;text-align: center;font-size:12px">'+tooltip+' ('+unit+')</div>'
										},
										{
											xtype: 'container',											
											html: '<div id="Dial_chart'+i+'" style="height:' + dialGraphHeight + 'px;width:'+dialGraphWidth+'px;border:0px solid red;margin:auto;"></div>'
										}],
									listeners :
									{
										'afterrender' : function()
										{											
												getHighChartsGuage(this.chartDivId,this.chartXmlData);
										}
									}
								});
							}
							/*else
							{
								var emptyMsg = dialData[i]['EmptyMsg'];							
								resultObj.add(
							{
								xtype: 'container',
									cls:'searchSeperatorLine',
									id:'Fusion_chart'+i,								
									padding:10,
									height:150,
									items:[
										{
											xtype: 'label',
											width:'150',											
											html: '<div style="font-weight:bold;text-align: center;font-size:12px">'+tooltip+' ('+unit+')</div>'
										},
										{
											xtype: 'container',																		
											html:'<table width="100%" height="100%"><tr><td align="center"><div class="iconExclamation" style="margin-top:30px"></div>'+emptyMsg+'</td></tr></table>'
									}]
								});
							}*/					
						}
					}
					else
					{
						Ext.getCmp('cisco_dialpanel').defaults.columnWidth =1;
						
						var noGraphTitle = jsonData['NET_TAB_NoGraphTitle'];
						var dialMsg = jsonData['DIAL_MSG'];
						var noMeasureMsg = testExcludedorDisabledMsg;
	
						if( dialMsg == undefined || Ext.isEmpty(dialMsg)){
							noMeasureMsg = noMeasure;
						}
						resultObj.add(
						{
							xtype: 'container',
							margin:5,
							border:true,
							frame:true,
							width:'100%',
							height:120,
							html:'<div class="noGraphTitle" style="padding-top:0px;">'+noGraphTitle+'</div><table width="100%" height="100px" style="text-align:center"><tr><td><div class="iconInformation" style="margin:0px auto"></div><div>'+noMeasureMsg+'</div></td></tr></table>'
														
						});
					}
					if(!Ext.isEmpty(dialData)){
						var lstEl = dialData.length - 1;						
						Ext.getCmp('Fusion_chart'+lstEl).addCls('lastChild');
					}
				}
				else if( subsystem.toLowerCase() == 'protocols')
				{
					var protocolsURL = jsonData['protocolsURL'];
					protocolsURL = encodeURI(protocolsURL);
					var ineterfaceArr = jsonData['ineterfaceArr'];
					var NOtestMSG=jsonData['NOtestMSG'];
					me.loadProtocolsPanel( protocolsURL , ineterfaceArr,NOtestMSG);
				}
				else if( subsystem.toLowerCase() == 'flows')
				{
					var flowsURL = jsonData['flowsURL'];
					flowsURL = encodeURI(flowsURL);
					me.loadFlowsPanel(flowsURL);
				}
			}//ciscodialpanel
		}
		//Ext.getCmp('networkmainpanel').resumeEvents();
		var mask = null;
		var wholeViewport = document.getElementsByTagName("body")[0];
		if ( !Ext.isEmpty( Ext.get( wholeViewport ) ) )
		{
			mask = new Ext.LoadMask(Ext.get(wholeViewport), {msg:loadingLbl+"...",cls:'maskDash'});
			mask.hide();
		}
	},
	afterCiscoPanelRendered: function(obj)
	{
		var me=this;
		var getCiscoPanelObj = Ext.getCmp(obj.getId());
		var getElObj = this.getMain().getEl();
		getElObj.mask(loadingLbl+"...", "maskCenter");		
		
		if(subSystemFromRequest!=null && subSystemFromRequest!="")
		{			
			Ext.getCmp('ciscosubsystem').setValue(subSystemFromRequest);
		}

		var subsystem = Ext.getCmp('ciscosubsystem').getValue();
		if ( Ext.isEmpty( subsystem ) || subsystem.length == 0 )
		{
			subsystem = 'Overview';
		}			
		ciscoLastLoadedURL = "/final/monitor/EgCiscoDashboardJSON.jsp?tab=Network&hostName="+encodeURIComponent(requestParams.hostName)+"&compType="+encodeURIComponent(componentType)+"&ciscoSelectedType="+encodeURIComponent(subsystem)+"&screenWidth=1012&screenHeight=570";
		
		Ext.Ajax.request({
			url:ciscoLastLoadedURL,
			method: 'POST',
			scope: this,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					getElObj.unmask();
					var jsonText = response.responseText;
					var jsonData = Ext.decode( jsonText );
					me.ciscoDefaultLoad(jsonData);
				}
			}
		});
	},
	selectCiscoSubSystem: function( obj )
    {
    	var getVal = obj.getValue();
		subSystemFromRequest = getVal;
    	if ( getVal != undefined )
    	{
    		if ( getVal.toLowerCase() == 'overview' )
    		{
				if(isExcludedNetflowDeviceAvailable)
				{
    				Ext.getCmp('ciscooverviewpanel').show();
				}
    		}
    		else
    		{
    			Ext.getCmp('ciscooverviewpanel').hide();
    		}
    		var subsystem = Ext.getCmp('ciscosubsystem').getValue();
			if ( Ext.isEmpty( subsystem ) || subsystem.length == 0 )
			{
				subsystem = 'Overview';
			}
			Ext.getCmp('networkmainpanel').fireEvent('beforeshow', Ext.getCmp('networkmainpanel'));
    	}
    },
	showNetflowOverview: function(overviewData)
	{
		if(!Ext.isEmpty(Ext.getCmp('flowInterfaces'))){
			Ext.destroy(Ext.getCmp('flowInterfaces'));
		} 
		if(!Ext.isEmpty(Ext.getCmp('netflow_fullview_settings'))){
			Ext.destroy(Ext.getCmp('netflow_fullview_settings'));
		}
		var currentAlertsObj = Ext.getCmp('currentAlertBar');
		var title = overviewData['alertTitle'];
		var currentAlertArr = new Array();
		var resArr = new Array();
		
		var alertsData = overviewData['ALERTS'];
		var eventCriticalPageUrl = overviewData['eventUrl1'];
		var eventMajorPageUrl = overviewData['eventUrl2'];
		var eventMinorPageUrl = overviewData['eventUrl3'];

		if ( alertsData != undefined )
		{
			if ( alertsData != '-' )
			{
				var openalertTitle = alertsData['OPEN_ALERT_TITLE'];
				var openAlerts = alertsData['OPEN_ALERTS'];
				var distribTitle = alertsData['DISTRIBUTION_TITLE'];
				var distribValsHTML = '';
				if ( alertsData['DISTRIBUTION_CRITICAL_VALUE'] != undefined )
				{
					var distribDesc = alertsData['DISTRIBUTION_CRITICAL_DESC'];
					var linkHTML = '';
					if ( alertsData['DISTRIBUTION_CRITICAL_LINK'] != undefined )
					{
						var linkData = alertsData['DISTRIBUTION_CRITICAL_LINK'];
						var methodName = linkData['METHOD_NAME'];
						var params = linkData['PARAMS'];
						var getParams = params.split('|');
						
						if (eventCriticalPageUrl!=undefined)
						{
							distribValsHTML += '<td><div style="text-align:center;cursor:pointer" onclick="javascript:goToAlarmHistory(\''+eventCriticalPageUrl+'\');" class="bar12_low" style="text-align:center;color:#ffffff;height: 13px !important;">'+alertsData['DISTRIBUTION_CRITICAL_VALUE']+'</div></td>'
						}
						else
						{
							distribValsHTML += '<td><div class="bar12_high" style="float:left;width:24px;text-align:center;display:none;height: 13px !important;">'+alertsData['DISTRIBUTION_CRITICAL_VALUE']+'</div></td>';
						}
					}
					else
					{
						distribValsHTML += '<td><div class="bar12_high" style="float:left;text-align:center;display:none;height: 13px !important">'+alertsData['DISTRIBUTION_CRITICAL_VALUE']+'</div></td>';
					}
				}
				if ( alertsData['DISTRIBUTION_MAJOR_VALUE'] != undefined )
				{
					var distribDesc = alertsData['DISTRIBUTION_MAJOR_DESC'];
					var linkHTML = '';
					if ( alertsData['DISTRIBUTION_MAJOR_LINK'] != undefined )
					{
						var linkData = alertsData['DISTRIBUTION_MAJOR_LINK'];
						var methodName = linkData['METHOD_NAME'];
						var params = linkData['PARAMS'];
						var getParams = params.split('|');

						if(eventMajorPageUrl!=undefined)
						{
							distribValsHTML += '<td><div style="text-align:center;cursor:pointer" onclick="javascript:goToAlarmHistory(\''+eventMajorPageUrl+'\');" class="bar12_low" style="text-align:center;color:#ffffff;height: 13px !important;">'+alertsData['DISTRIBUTION_MAJOR_VALUE']+'</div></td>'
						}
						else
						{
							distribValsHTML += '<td><div class="bar12_intermediate" style="float:left;width:24px;text-align:center;display:none;height: 13px !important;">'+alertsData['DISTRIBUTION_MAJOR_VALUE']+'</div></td>';
						}
					}
					else
					{
						distribValsHTML += '<td><div class="bar12_intermediate" style="display:none;width:100%;text-align:center;height: 13px !important;">'+alertsData['DISTRIBUTION_MAJOR_VALUE']+'</div></td>';
					}
				}
				if ( alertsData['DISTRIBUTION_MINOR_VALUE'] != undefined )
				{
					var distribDesc = alertsData['DISTRIBUTION_MINOR_DESC'];
					var linkHTML = '';
					if ( alertsData['DISTRIBUTION_MINOR_LINK'] != undefined )
					{
						var linkData = alertsData['DISTRIBUTION_MINOR_LINK'];
						var methodName = linkData['METHOD_NAME'];
						var params = linkData['PARAMS'];
						var getParams = params.split('|');
						if (eventMinorPageUrl!=undefined)
						{
							//.var genHTML = '<div onclick="javascript:goToAlarmHistory(\''+eventMinorPageUrl+'\');" style="text-align:center;cursor:pointer" >'+alertsData['DISTRIBUTION_MINOR_VALUE']+'</div>';
							distribValsHTML += '<td><div style="text-align:center;cursor:pointer" onclick="javascript:goToAlarmHistory(\''+eventMinorPageUrl+'\');" class="bar12_low" style="text-align:center;color:#ffffff;height: 13px !important;">'+alertsData['DISTRIBUTION_MINOR_VALUE']+'</div></td>'
						}
						else
						{
							distribValsHTML += '<td><div class="bar12_low" style="float:left;width:24px;text-align:center;display:none;height: 13px !important;">'+alertsData['DISTRIBUTION_MINOR_VALUE']+'</div></td>';
						}
					}
					else
					{
						distribValsHTML += '<td><div class="bar12_low" style="display:none;text-align:center;height: 13px !important">'+alertsData['DISTRIBUTION_MINOR_VALUE']+'</div></td>';
					}
				}
				distribValsHTML = '<table width="100%"><tr>'+distribValsHTML+'</tr></table>';

				currentAlertArr.push(					
				{
					xtype: 'container',
					width:450,
					style:{'margin-left':'100px'},
					html: '<div style="display:inline-block"  ><table width="100%" height="100%"><tr><td width="90%"><div style="font-size:13px;font-weight:bold;margin-top: 16px;float: right;margin-right: -8px;">'+openalertTitle+'</div></td></tr></table></div><div style="display:inline-block; margin-left:20px;width:250px;height:17px"  >'+distribValsHTML+'</div>'						
				});
			}
		}
		currentAlertsObj.removeAll();
		currentAlertsObj.add(currentAlertArr);
		currentAlertsObj.doComponentLayout();
	},
	showCiscoOverview: function(overviewData)
	{
		//alert('showCiscoOverview--');
		if(!Ext.isEmpty(Ext.getCmp('flowInterfaces'))){
			Ext.destroy(Ext.getCmp('flowInterfaces'));
		} 
		if(!Ext.isEmpty(Ext.getCmp('netflow_fullview_settings'))){
			Ext.destroy(Ext.getCmp('netflow_fullview_settings'));
		}
		var currentAlertsObj = Ext.getCmp('ciscoCurrentAlerts');
		var title = overviewData['alertTitle'];
		var currentAlertArr = new Array();
		var resArr = new Array();
		currentAlertArr.push({
			xtype:'container',
			//padding: '0px 5px 0px 10px',
			padding: '10px 10px 10px 10px',
			html: '<div class="title"><b>'+title+'</b></div>'
		});
		var alertsData = overviewData['ALERTS'];
		if ( alertsData != undefined )
		{
			if ( alertsData == '-' )
			{
				var NO_ALERTS = overviewData['NO_ALERTS'];
				currentAlertArr.push({
					xtype: 'container',
					width: '100%',					
					margin:10,
					html: '<table width="100%" height="100%"><tr><td valign="middle" align="center"><div class="iconNoalarms" style="margin:0px auto"></div><div style="font-size:12px;">'+NO_ALERTS+'</div></td></tr></table>'
				});
			}
			else
			{
				var openalertTitle = alertsData['OPEN_ALERT_TITLE'];
				var openAlerts = alertsData['OPEN_ALERTS'];
				var distribTitle = alertsData['DISTRIBUTION_TITLE'];
				var distribValsHTML = '';
				if ( alertsData['DISTRIBUTION_CRITICAL_VALUE'] != undefined )
				{
					var distribDesc = alertsData['DISTRIBUTION_CRITICAL_DESC'];
					var linkHTML = '';
					if ( alertsData['DISTRIBUTION_CRITICAL_LINK'] != undefined )
					{
						var linkData = alertsData['DISTRIBUTION_CRITICAL_LINK'];
						var methodName = linkData['METHOD_NAME'];
						var params = linkData['PARAMS'];
						var getParams = params.split('|');

						var genHTML = '<div style="width:100%;text-align:center;" >'+alertsData['DISTRIBUTION_CRITICAL_VALUE']+'</div>';
						distribValsHTML += '<td><div class="bar12_high" style="text-align:center;color:#ffffff;height: 13px !important;">'+genHTML+'</div></td>'
					}
					else
					{
						distribValsHTML += '<td><div class="bar12_high" style="float:left;text-align:center;display:none;height: 13px !important">'+alertsData['DISTRIBUTION_CRITICAL_VALUE']+'</div></td>';
					}
				}
				if ( alertsData['DISTRIBUTION_MAJOR_VALUE'] != undefined )
				{
					var distribDesc = alertsData['DISTRIBUTION_MAJOR_DESC'];
					var linkHTML = '';
					if ( alertsData['DISTRIBUTION_MAJOR_LINK'] != undefined )
					{
						var linkData = alertsData['DISTRIBUTION_MAJOR_LINK'];
						var methodName = linkData['METHOD_NAME'];
						var params = linkData['PARAMS'];
						var getParams = params.split('|');
						var genHTML = '<div style="text-align:center;" >'+alertsData['DISTRIBUTION_MAJOR_VALUE']+'</div>';
						distribValsHTML += '<td><div class="bar12_intermediate" style="width:100%;text-align:center;color:#ffffff;height: 13px !important;">'+genHTML+'</div></td>';
					}
					else
					{
						distribValsHTML += '<td><div class="bar12_intermediate" style="display:none;width:100%;text-align:center;height: 13px !important;">'+alertsData['DISTRIBUTION_MAJOR_VALUE']+'</div></td>';
					}
				}
				if ( alertsData['DISTRIBUTION_MINOR_VALUE'] != undefined )
				{
					var distribDesc = alertsData['DISTRIBUTION_MINOR_DESC'];
					var linkHTML = '';
					if ( alertsData['DISTRIBUTION_MINOR_LINK'] != undefined )
					{
						var linkData = alertsData['DISTRIBUTION_MINOR_LINK'];
						var methodName = linkData['METHOD_NAME'];
						var params = linkData['PARAMS'];
						var getParams = params.split('|');
						var genHTML = '<div style="text-align:center;" >'+alertsData['DISTRIBUTION_MINOR_VALUE']+'</div>';
						distribValsHTML += '<td><div class="bar12_low" style="width:100%;text-align:center;color:#ffffff;height: 13px !important;">'+genHTML+'</div></td>';
					}
					else
					{
						distribValsHTML += '<td><div class="bar12_low" style="display:none;text-align:center;height: 13px !important">'+alertsData['DISTRIBUTION_MINOR_VALUE']+'</div></td>';
					}
				}
				distribValsHTML = '<table width="100%"><tr>'+distribValsHTML+'</tr></table>';
				currentAlertArr.push(					
						{

					xtype: 'container',
					layout: 'hbox',
					padding:'0 10 10 10',
					items:[
						{
							xtype: 'container',
							width: '100%',
							html: '<table width="100%" height="100%"><tr><td width="5%"></td><td width="90%"></td></tr><tr><td width="5%"><div class="summaryOpenProblems" style="top:25px;"></td><td width="90%"><div style="font-size: 17px;font-weight:bold;float: right">'+openAlerts+'</div><div style="font-size:12px;font-weight:bold;margin-top: 16px;float: right;margin-right: -8px;">'+openalertTitle+'</div></td></tr></table><div class="outer_round" style="margin-top: 5px;">'+distribValsHTML+'</div>'
							//html: '<div class="outer_round">'+distribValsHTML+'</div>'
						}

					]
				});
			}
		}
		currentAlertsObj.removeAll();
		currentAlertsObj.add(currentAlertArr);
		currentAlertsObj.doComponentLayout();
		
		
		if(!isIncludedNetflowDeviceAvailable)
		{
			var uptimeTitle = overviewData['UPTIME_TITLE'];
			var uptime  = overviewData['UPTIME'];
			var currentUptimeArr = new Array();
			var curretUptime = Ext.getCmp('ciscoUptime');
			if ( uptime != undefined && !Ext.isEmpty(uptime) && uptime!=null && uptimeTitle != undefined &&!Ext.isEmpty(uptimeTitle) && uptimeTitle!=null)
			{
				currentUptimeArr.push({
					xtype: 'container',
					width: '100%',
					margin:'10 10 25 10',
					padding: '10px 10px 2px 10px',
					html: '<div  class="title"><b>'+uptimeTitle+'</b></div><br/><div class="font_bold" style="font-size:14px;text-align:center">'+uptime+'</div>'
				});
			}else{
				currentUptimeArr.push({
					xtype: 'container',
					width: '100%',
					margin:'10 10 10 10',
					html: '<div  class="title"><b>Device UpTime</b></div><div style="text-align:center"><div class="iconInformation" style="margin:0px auto"></div><div style="font-size:12px">No data found!</div></div>'
				});
			}
			curretUptime.removeAll();
			curretUptime.add(currentUptimeArr);
			curretUptime.doComponentLayout();
		}
	},
	onTabularViewButton:function(obj)
	{
		if(isFlag==true)
		{
			obj.clicked = true;
			Ext.getCmp('cisco_TabularView').setIconCls('iconAreaChart');
			Ext.getCmp('tabularbtnToolTip').update(graphicalViewLbl);
			var resultObj = Ext.getCmp('cisco_areachartView');
			Ext.getCmp("cisco_Timeline").hide();
			
			resultObj.removeAll();
			var gridDataVal=ciscoData['GRID_DATA']['STATE_VALUES'];
			var gridColumns=ciscoData['GRID_DATA']['COLUMN_VALUES'];
			var NO_MEASURE=gridColumns['Interface_NOMes'];
			if(NO_MEASURE!=null && NO_MEASURE!=undefined )
			{
				Ext.getCmp("cisco_FullGridView").hide();
				resultObj.removeAll();
				resultObj.add({
					xtype: 'container',
					id:'errorpanel',
					padding:80,
					columnWidth:1,
					//width: '500px',
					html :'<table width="100%" ><tr><td align="center"><div class="iconInformation" style="margin:0px auto"></div>'+NO_MEASURE+'</td></tr></table>'
				});
				resultObj.doComponentLayout();
			}
			else
			{
				Ext.getCmp("cisco_FullGridView").show();
				var href= ciscoData['GRID_DATA']['comparisonTableFullViewURL'];
				var columnArr = new Array();

				var fieldModel = new Array();
				var flexVal, width;
				var columns = new Array();
				var colIdx = 0;
				for ( var key in gridColumns)
				{				  
					if(colIdx==0)
					{
						fieldModel.push({ name : 'COLUMN_'+colIdx , type : 'string' });
					}
					else
					{
						fieldModel.push({ name : 'COLUMN_'+colIdx , type : 'FLOATORSTRING' });
					}
					columns.push({
						header: gridColumns[key],
						dataIndex: 'COLUMN_'+colIdx,
						//align: 'left',
						flex:(colIdx==0?0.25:0.12),						
						sortable: true,
						renderer:function( value, metaData, record, row, col, store, gridView )
						{
							if ( col == 1 )
							{
								return '<div class="'+value+'" style="border:0px solid red;margin:0px;padding:0px;cursorointer"></div>';
							}
							else
							{
								return value;
							}
						}
					});
					colIdx++;
				}

				var ackStore = Ext.data.Store({
					fields: fieldModel,
					data: gridDataVal,
					//height:250,
					pageSize:10,
					proxy:{
						type:'pagingmemory',
						reader:{
							type:'json'
						}
					}
				});
				var dockedItemsArr = new Array();
				dockedItemsArr.push( {
									xtype:"pagingtoolbar",
									cls:"pagingtoolbar",
									dock:"bottom",
									displayInfo:true,
									cls:"pagingtoolbar",
									id:"ackPagingToolBar",
									name:"ackPagingToolBar",
									pageSize:10,
									store: ackStore,
									displayInfo:true,
									displayMsg:displayTopicsLbl,
									emptyMsg:noTopicsLbl,
									listeners:{
									change:function(pagetool, pageData, eOpts){
									//pagetool.up('cisco_customgrid').getStore().loadPage(pageData.currentPage);
							}
						}
				});
				resultObj.add({
					xtype: 'customgrid',
					cls:'gridSkin',
					anchor:'100%',
					columnWidth: 1,
					width: '100%',
					id:'cisco_customgrid',
					name:'cisco_customgrid',
					store: ackStore,

					dockedItems : dockedItemsArr,
					columns: columns
				});
				resultObj.doComponentLayout();
			}
			isFlag=false;
		}
		else if(isFlag==false)
		{
			var resultObj = Ext.getCmp('cisco_areachartView');
			resultObj.removeAll();
			Ext.getCmp("cisco_Timeline").show();
			Ext.getCmp('cisco_TabularView').setIconCls('iconData');
			Ext.getCmp('tabularbtnToolTip').update(dataViewLbl);
			Ext.getCmp('cisco_TabularView').show();
			Ext.getCmp('cisco_DialGridButton').hide();
			Ext.getCmp('cisco_FullGridView').hide();
			this.loadAreaCharts();
			isFlag=true;
			obj.clicked = false;
		}
	},
	loadAreaCharts:function()
	{	
		var isAxisTimeReq = false;
		var legendPos = "bottom";
		var getElObj = this.getMain().getEl();
		getElObj.mask(loadingLbl+"...", "maskCenter");
		var timeline = Ext.getCmp("cisco_Timeline").getValue();
		var url=ciscoData['AREACHART_URL'];
		url = encodeURI(url);
		var resultObject = Ext.getCmp('cisco_areachartView');
		if(ciscoLastLoadedURL!=null && ciscoLastLoadedURL.indexOf("&selectedTimeline=")>0)
		{
			ciscoLastLoadedURL = ciscoLastLoadedURL.replace(/(selectedTimeline=)[^\&]+/, '$1' + timeline);
		}
		else
		{
			ciscoLastLoadedURL=ciscoLastLoadedURL+'&selectedTimeline='+timeline;
		}
		Ext.Ajax.request({
				url: url+'&selectedDate='+timeline ,
				scope: this,
				async: false,
				success: function (response)
				{
					resultObject.removeAll();
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						var getMainWidth = this.getMain().getWidth(),
							getMainHeight = this.getMain().getHeight();
						var jsonText = response.responseText;
						var jsonData = Ext.decode(jsonText);
						var areaValues=jsonData['AREACHART_DATA'];
						var NoMeasure=jsonData['NoMeasureMsg'];
						
						if ( !Ext.isEmpty( areaValues ) )
						{
							var highChartUrls = new Array();
							var legendIds1 = new Array();
							var highChartIds = new Array();
							var highChartHeight = new Array();
							var highChartWidth = new Array();							
							var j=0;
							for ( var key in areaValues )
							{
								var areaTitle = areaValues[key]['Title'];
								var imgURL = areaValues[key]['areaChartURL'];
								var type = areaValues[key]['Type'];
								var graphFormat = areaValues[key]['GRAPH_FORMAT'];
									
								var imgHeight = 230;
								var imgWidth = 450;
								var dataArray = new Array();
								dataArray[0] = areaTitle;
								dataArray[1] = imgURL;
								dataArray[2] = type;								
								var imgDiv = '';								
								if(!Ext.isEmpty(graphFormat))
								{
									if(graphFormat.indexOf("highchart") > -1)
									{
										imgDiv = '<div style="cursor:pointer" id="netareaDesktopChart'+key+'"></div>';
										highChartIds.push('netareaDesktopChart'+key);
										highChartUrls.push(imgURL);
										legendIds1.push('ciscoArealegend'+key);
										highChartHeight.push(imgHeight);										
									}
								}
								var set_width  = Ext.getCmp('cisco_areachartView');
								
								var new_netareablockWidth  = Math.round((set_width.body.dom.clientWidth / 2)-20);
								resultObject.add(
								{
									xtype: 'panel',
									id: 'netareablock'+key,
									//itemId: 'netareablock'+key,
									cls: 'datapanel',
									//header:{cls:'headerwhite'},
									dataArray: dataArray,
									border:true,
									frame:true,
									title:(areaTitle.replace("percent","%")),
									width: new_netareablockWidth,
									height: 280,
									items:[
										{
												xtype:'container',
												layout:{
													type:'vbox',
													align:'stretch'
												},
												margin:'0 5 0 0',
												items:[{
														xtype:'container',
														//width: 150,
														flex:1,
														height:56, //  give ur height
														id:'ciscoArealegend'+key,
														autoScroll:true,
														overflowY:'auto',
														cls:'scrollCon'   //  i have given css in light theme copy and add in dark theme
														//margin:'14 0 0 0',
														//style:{'background':'#ededed'},
												}]
										},
										{
											xtype: 'container',
											layout:{
											type:'vbox',
											align: 'stretch'
										},
											flex:1,
											//height: 300,
											margin:'0px 0px 0px 0px',
											id:'netareaDesktopChart'+key,
											itemId:'loopchart',
											style:{cursor:'pointer',},
											items:[
												{
													xtype: 'container',
													//flex:.7,
													height:'100%',
													width: '100%',
													margin:'0px 5px 2px 10px',
													dataArray: imgURL,
													html: imgDiv,
													listeners:{
															'afterrender': function()
															{
																var URL = this.dataArray;
																var temp = Ext.getCmp('netareablock'+key);
															
																imgWidth = Math.round(temp.el.dom.offsetWidth)
																if(!Ext.isEmpty(graphFormat))
																{
																	//URL = URL.replace(/(Title=)[^\&]+/, '$1' + areaTitle);	
																	if(graphFormat.indexOf("highchart") > -1){

																		setAreaHighChart(highChartUrls[j],highChartIds[j],legendIds1[j],highChartHeight[j],imgWidth,URL,isAxisTimeReq,legendPos,true,"area","overview",temp);
																	}
																	else
																	{
																		this.update('<img onClick="javascript:AreaGraphOnClick(\''+URL+'\');" src="'+URL+'&height=180&width=550&mode=2D" />');
																	}
																}
																j = j+1;
															}
													}
												}
											]
										},/*{
											xtype:'container',
											layout:{ 
												type:'hbox',
												//align:'middle',
												pack:'center',
											},
											height:'100%',
											//style:{'border':'1px solid blue'},
											items:[
											{
												xtype:'container',
												width: 200,
												defaults:{
													height:'100%',
												},
												id:'ciscoArealegend'+key,
												overflowY:'auto',
												margin:'0 10 0 0',
												style:{'background':'#ededed'},
											}
											]
										},*/
									]
								});
							}
						}	
						else
						{
							resultObject.add(
							{
								xtype: 'container',
								padding:80,
								columnWidth:1,
								//width: '500px',
								html :'<table width="100%" ><tr><td align="center"><div class="iconInformation" style="margin:0px auto"></div>'+noMeasure+'</td></tr></table>'
							});
						}
						resultObject.doComponentLayout();
					}
				}
			});
			getElObj.unmask();
			isFlag = true;
	},
	onFullGridViewButton:function()
	{
		Ext.getCmp('ciscooverviewpanel').hide();
		Ext.getCmp('ciscosubsystem').hide();
		Ext.getCmp('cisco_dialpanel').hide();
		Ext.getCmp('cisco_DialGridButton').show();
		Ext.getCmp('cisco_TabularView').hide();
		Ext.getCmp('cisco_FullGridView').hide();
	},
	onSelectTimeLine:function(obj)
	{
		this.loadAreaCharts();
	},
	dialGridViewButton:function()
	{
		if(isExcludedNetflowDeviceAvailable)
		{
			Ext.getCmp('ciscooverviewpanel').show();
		}
		Ext.getCmp('ciscosubsystem').show();
		Ext.getCmp('cisco_dialpanel').show();
		Ext.getCmp('cisco_TabularView').fireEvent('click',Ext.getCmp('cisco_TabularView'));
		Ext.getCmp('cisco_FullGridView').show();
	},
	ciscoAreaChartOnClick:function(idInx)
	{
		var thisObj=Ext.getCmp(idInx);
		var getMainWidth = this.getMain().getWidth(),
		getMainHeight = this.getMain().getHeight();
		var obj=Ext.widget('maximizeview', {
					width: getMainWidth,
					height: getMainHeight,
					id : 'Maximize',
					html:'<div id="areaChart" style="text-align:center;margin-top:25% width:'+(getMainWidth-40)+'px; height:400px;"><div class="iconInformation" style="margin:0px auto"></div></div>'
				}).show();
			var tmpArray = Ext.getCmp(idInx).dataArray;
			if ( !Ext.isEmpty( tmpArray['XML_DATA'] ))
			{
				var swfPath = tmpArray['AreaSwfpath'];
				var myChart = new FusionCharts(swfPath,'Area-Chart', '100%', '100%','0','1');
				myChart.setXMLData(tmpArray['XML_DATA']);
				myChart.setTransparent(true);
				myChart.render('areaChart');
			}
			else
			{
				Ext.get('areaChart').update('<div style="text-align:center;margin-top:25%" ><div class="iconInformation" style="margin:0px auto"></div><div>'+noMeasureExcl+'</div></div>');
			}
	},
	loadProtocolsPanel: function(protocolurl,ineterfaceArr,NOtestMSG)
	{
		if(protocolLastLoadedURL!=null)
		{
			protocolurl = protocolLastLoadedURL;
		}
		
		if(!Ext.isEmpty(Ext.getCmp('flowInterfaces'))){
			Ext.destroy(Ext.getCmp('flowInterfaces'));
		}
		if(!Ext.isEmpty(Ext.getCmp('netflow_fullview_settings'))){
			Ext.destroy(Ext.getCmp('netflow_fullview_settings'));
		}
		var isAxisTimeReq = false;
		var legendPos = "bottom";
		var me=this;
		Ext.getCmp('ciscooverviewpanel').hide();
		Ext.getCmp('currentAlertBar').hide();
		Ext.getCmp('ciscodialpanel').hide();
		Ext.getCmp('flowspanelID').hide();
		Ext.getCmp('protocolpanelID').show();
		Ext.getCmp('interfaceCombo').show();
		Ext.getCmp('TimelineCombo').show();

		var currentTrafficObj = Ext.getCmp('currentTrafficPanel');
		if(!Ext.isEmpty(currentTrafficObj))
			currentTrafficObj.removeAll();

		var currentTrafficData = ineterfaceArr;
		if(NOtestMSG!=null && !Ext.isEmpty(NOtestMSG) && NOtestMSG!=undefined)
		{
			var protocol_currentTrafficObj = Ext.getCmp('Protocol_currentTrafficPanel');
			protocol_currentTrafficObj.removeAll();
			var protocol_currentTrafficHeight = Ext.getCmp('Protocol_currentTrafficPanel')+'-body';
			protocol_currentTrafficObj.add(
			{
				xtype: 'container',
				layout:{
					type:'vbox',
					pack:'center',
					align:'center',
				},
				width:'100%',
				items:[
					{
						xtype: 'container',
						//margin: '15px',
						height:protocol_currentTrafficObj.getHeight()-25,
						width:'100%',						
						//margin:'20px 0px 0px 200px',
						html :'<table width="100%" height="100%"><tr><td align="center"><div class="iconInformation" style="margin:0px auto"></div>'+NOtestMSG+'</td></tr></table>'
					}]
			});
			Ext.getCmp('ProtocolTab_panel').hide();
		}
		else
		{
			if( currentTrafficData!=null && !Ext.isEmpty(currentTrafficData) && currentTrafficData!= undefined)
			{
				var trafficTitle = currentTrafficData[0]['currenTraffic'];
				var unit = currentTrafficData[0]['unit'];
				Ext.getCmp('Protocol_currentTrafficPanel').setTitle(trafficTitle);
				var AREACHART = currentTrafficData[0]['AREACHART'];
				var XML_FLAG = currentTrafficData[0]['XML_FLAG'];
				var NOMSG = currentTrafficData[0]['NOMSG'];
				if (AREACHART!=null && !Ext.isEmpty(AREACHART) && AREACHART=='false')
				{
					var protocol_currentTrafficObj = Ext.getCmp('Protocol_currentTrafficPanel');
					protocol_currentTrafficObj.removeAll();

					protocol_currentTrafficObj.add(
					{
						xtype: 'container',
						//flex:1,
						layout:{
							type:'vbox',
							pack:'center',
							align:'center',
						},
						width:'100%',
						items:[
							{
								xtype: 'container',
								height:200,
								//margin:'20px 0px 0px 200px',
								html :' <table width="100%" height="150px"><tr><td align="center"><div class="iconInformation" style="margin:0px auto"></div>'+NOMSG+'</td></tr></table>'
							}]
					});
					Ext.getCmp('ProtocolTab_panel').hide();
				}
				else
				{
					var span = new Array();
					var ProtocolPieChartNavigationValue = Math.ceil(currentTrafficData.length /3) ;					
					for(var k=0; k<ProtocolPieChartNavigationValue;k++){
							if(k ==0){
							span += '<div class="pie_dot pie_dot_light" id="piechartdot_'+ k +'" style="height:6px; width:6px"></div>';
						}else{
							span += '<div class="pie_dot" id="piechartdot_'+ k +'" style="height:6px; width:6px"></div>';
						}
					}
					Ext.get('center_div').update(span);
					/*if(ProtocolPieChartNavigationValue == 1){
						Ext.getCmp('ProtocolTab_panel').hide();
					}*/					
					if( currentTrafficData.length == 1){
							currentTrafficObj.defaults.columnWidth = 1;
					}				
					for(var i=0; i < currentTrafficData.length ; i++)
					{
						if (XML_FLAG!=null && !Ext.isEmpty(XML_FLAG) && XML_FLAG=='false')
						{
							currentTrafficObj.add(
							{
								xtype: 'panel',
								flex:1,
								items:[
									{
										xtype: 'container',
										height:150,
										//width:'100%',
										//margin:'20px 0px 0px 200px',
										html :'<table width="100%" height="150px"><tr><td align="center"><div class="iconInformation" style="margin:0px auto"></div><div>'+NOMSG+'</div></td></tr></table>'
									}]
							});
						}
						else
						{
							var xmlData = currentTrafficData[i]['XML_DATA'];
							var swfPath = currentTrafficData[i]['SWF_PATH'];
							var mappingName = currentTrafficData[i]['COLUMN_0'];
							var pieGraphWidth = currentTrafficData[i]['pieGraphWidth'];
							var getMainWidth = this.getMain().getWidth(),
							getMainHeight = this.getMain().getHeight();
							var chartDatObj = new Date();
							var rndrId = 'piechart_'+i+'_'+chartDatObj.getMinutes()+"_"+chartDatObj.getSeconds();
							var chartDispDivId = 'piechart_'+i;

							var colWidth = 0.33344;
							if(currentTrafficData.length == 2){
								colWidth = 0.5;
							}else if(currentTrafficData.length == 1){
								colWidth = 1;
							}
							currentTrafficObj.defaults.columnWidth=colWidth;
							var fontColor = (strSkin == 'Light')?"#2a292a":'#c0c0c0';
							currentTrafficObj.add(
							{
								id:chartDispDivId,
								xtype: 'container',
								chartRndrId : rndrId,
								layout:{
										type:'vbox',
										align:'stretch'
								},
								defaults:{
									flex:1,
									height:200
								},
								//width: 300,
								flex:.24,
								chartDivId : chartDispDivId,
								id:'pie_chart'+i,
								chartxmlData : xmlData,
								dataArray: currentTrafficData,
								items:[
									/*{
										xtype:'container',
										height:20,
										html:'<div style="text-align:center" class="font_bold12">'+mappingName+'</div>',
									},*/
									{
										xtype: 'container',
										style:{"text-align":"center"},
										margin:'0px',
										html: '<div class="mytemp"  id="piechart_'+i+'" style="margin:0px auto"></div>',
									}],
									listeners :
									{
										'afterrender' : function(c)
										{

											var netflowPie_Width = currentTrafficObj.getWidth()/3;
												try
												{	
													var barChart = {};
													barChart = jQuery.extend(true, {}, getHighChartsBarInstance('piechart_'+i, 180, netflowPie_Width), barChart);
													if(componentType=='NetflowDevice')
													{
														barChart.setData(this.chartxmlData, currentDateFormat, '','ProtocolPieNetflow');
													}
													else
													{
														barChart.setData(this.chartxmlData, currentDateFormat, '','Ciscopie');
													}
													barChart.drawChart();
												}
												catch (barChartEx)
												{
													console.log(barChartEx);
												}
											}
										}
							});
						}
					}
				}
				
				/*var set_Id = Ext.getCmp('currentTrafficPanel').items.items[0].id;
				//Ext.getCmp(set_Id).addCls('pieSeperatorLine')
				Ext.getCmp('currentTrafficPanel').items.each(function(d,indx){
						Ext.getCmp(d.id).addCls('pieSeperatorLine')
				});*/
				if(!Ext.isEmpty(currentTrafficObj))
				{
					if(currentTrafficData.length == 1){
						currentTrafficObj.items.each(function(d,indx){
								Ext.getCmp(d.id).addCls('pieSeperatorlastChild')
						});
					}else if(currentTrafficData.length == 2){
						currentTrafficObj.items.each(function(d,indx){
						if((indx%2)==1){
								Ext.getCmp(d.id).addCls('pieSeperatorlastChild')
							}else{
								Ext.getCmp(d.id).addCls('pieSeperatorLine')
							}
						});
					}else if(currentTrafficData.length > 2){
						currentTrafficObj.items.each(function(d,indx){
						if((indx%3)==2){
								Ext.getCmp(d.id).addCls('pieSeperatorlastChild')
							}else{
								Ext.getCmp(d.id).addCls('pieSeperatorLine')
							}
						});
					}
					currentTrafficObj.doComponentLayout();
				}				
			}
		}

		var bandwidthObj = Ext.getCmp('bandwidthpanel');
		bandwidthObj.removeAll();

		Ext.Ajax.request({
				url: protocolurl ,
				scope: this,
				async: false,
				success: function (response)
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						var getMainWidth = this.getMain().getWidth(),
							getMainHeight = this.getMain().getHeight();
						var jsonText = response.responseText;						
						var jsonData = Ext.decode(jsonText);
						var NoTestMsg = jsonData['NoTestMsg'];
						var bandwidthData = jsonData['CHARTNTABLE_DATA'];
						var ProtocolTimelineCombo = jsonData['ProtocolTimelineCombo'];
						var ProtocolTimelineComboArray = ProtocolTimelineCombo['ProtocolTimelineComboArray'];
						var protocolSelectedTimelineCombo = ProtocolTimelineCombo['protocolSelectedTimelineCombo'];
						if (NoTestMsg!=null && !Ext.isEmpty(NoTestMsg) && NoTestMsg!=undefined )
						{
							Ext.getCmp('interfaceCombo').hide();
							Ext.getCmp('TimelineCombo').hide();
							bandwidthObj.add(
							{
								xtype: 'panel',
								width:'100%',
								height:bandwidthObj.getHeight()-25,
								layout:'fit',
								style:{'border':'0px solid blue'},
								items:[
									{
										xtype: 'container',
										height:'100%',
										width:'100%',
										margin:'20px 0px 0px 0px',
										html :'<table width="100%" height="100%"><tr><td align="center"><div class="iconInformation" style="margin:0px auto"></div><div>'+NoTestMsg+'</div></td></tr></table>'

									}]
							});
						}
						else if(bandwidthData!=null && bandwidthData!=undefined && !Ext.isEmpty(bandwidthData))
						{
							var bandwidthTitle = bandwidthData[0]['TITLE'];
							var NoMeasureMsg = bandwidthData[0]['NoMeasureMsg'];
							if (NoMeasureMsg!=null && !Ext.isEmpty(NoMeasureMsg) && NoMeasureMsg!=undefined )
							{
								Ext.getCmp('interfaceCombo').hide();
								Ext.getCmp('TimelineCombo').hide();
								bandwidthObj.add(
								{
									xtype: 'container',
									flex:1,
									height:'100%',
									width:'100%',
									layout:'fit',
									style:{'border':'0px solid red'},
									items:[{
										xtype: 'container',
										height:'100%',
										width:'100%',
										html :'<table width="100%" height="100%" ><tr><td align="center"><div class="iconInformation" style="margin:0px auto"></div><div>'+NoMeasureMsg+'</div></td></tr></table>'
									}]
								});
							}
							else
							{
								var interfaceName = bandwidthData[0]['COLUMNAM_0'];
								var interfaceComboValue = bandwidthData[0]['COLUMNVAL_0'];
								me.setValueWithOptionInList('interfaceCombo', interfaceComboValue, bandwidthData[0]['selectedCombo']);

								me.setValueWithOptionInList('TimelineCombo', ProtocolTimelineComboArray, protocolSelectedTimelineCombo);

								Ext.getCmp('bandwidthMainPanel').setTitle(bandwidthTitle);

								var areaValues=jsonData['CHARTNTABLE_DATA'];
								
								if ( !Ext.isEmpty( areaValues ) )
								{
									var highChartUrls = new Array();
									var highChartIds = new Array();
									var legendIds1 = new Array();
									var highChartHeight = new Array();
									var highChartWidth = new Array();							
									var jk=0;
									for ( var key in areaValues )
									{
										var areaTitle = areaValues[key]['Title'];
										var imgURL = areaValues[key]['areaChartURL'];
										var type = areaValues[key]['Type'];
										var graphFormat = areaValues[key]['GRAPH_FORMAT'];
											
										var imgHeight = 200;
										var imgWidth =550;
										var dataArray = new Array();
										dataArray[0] = areaTitle;
										dataArray[1] = imgURL;
										dataArray[2] = type;								
										var imgDiv = '';								
										if(!Ext.isEmpty(graphFormat))
										{
											if(graphFormat.indexOf("highchart") > -1)
											{
												imgDiv = '<div id="netProtocolareaDesktopChart'+key+'"></div>';
												highChartIds.push('netProtocolareaDesktopChart'+key);
												highChartUrls.push(imgURL);
												legendIds1.push('protocolArealegend'+key);
												highChartHeight.push(imgHeight);										
											}
										}
										bandwidthObj.add(
											/*{
												xtype: 'label',
												margin: '3px',
												html: '<div style="text-align:center;border:0px solid red;margin-left:2px" ><b>'+areaTitle+'</b></div>'
											},*/
											{
												xtype: 'container',
												id: 'netProtoareablock'+key,
												itemId: 'netProtoareablock'+key,
												cls: 'block1',
												layout:{type:'hbox'},
												dataArray: dataArray,
												style:{'border':'0px !important'},
												flex:1,
												//border:true,
												//frame:true,
												width: '100%',
												//title:areaTitle,
												//width: '100%',
												//height: '500px',										
												items:[
													{
														xtype: 'container',
														layout:{type:'hbox',align:'stretch'},
														flex:0.8,
														height: '100%',
														margin:'20px 0px 10px 0px',
														id:'netProtocolareaDesktopChart'+key,
														style:{
															cursor:'pointer',
														},
														items:[												
															{
																xtype: 'container',
																//flex:.7,
																//height:350,
																width: '100%',
																dataArray: imgURL,
																html: imgDiv,
																listeners:{
																		'afterrender': function()
																		{
																			var loop = Math.round(Ext.getCmp('protocolpanelID').getWidth() - 360);
																			imgWidth = loop;
																			var temp = Ext.getCmp('netProtoareablock'+key);
																			var URL = this.dataArray;
																			highChartHeight = Ext.getCmp('netProtocolareaDesktopChart'+key).el.dom.clientHeight;
																			if(!Ext.isEmpty(graphFormat))
																			{																		
																				if(graphFormat.indexOf("highchart") > -1){
																					setAreaHighChart(highChartUrls[jk],highChartIds[jk],legendIds1[jk],highChartHeight[jk],imgWidth,URL,isAxisTimeReq,legendPos,false,"area","protocol",temp);
																				}
																				else
																				{																			
																					 this.update('<table width="600px" height="400px"><tr><td align="center" valign="middle"><img onClick="javascript:AreaGraphOnClick(\''+URL+'\');" src="' + URL + '" border="0" /></td></tr></table>');	
																				}
																			}
																			jk = jk+1;


																			$('.pie_dot').click(function(){
																				var pie_Id  = this.id.split("_")[1];
																				$(this).addClass("pie_dot_light").siblings().removeClass("pie_dot_light").addClass("pie_dot");
																				var setHeight = Math.round(pie_Id*200);

																				if(pie_Id == 0){
																					$('.pie_column').css({"top":setHeight});
																				}else{
																					$('.pie_column').css({"top":-setHeight});
																				}
																			})
																		}
																}
															}
														]
													},{
														xtype:'container',
														width:200,
														//flex:0.2,
														//autoScroll:true,
														overflowY:'auto',
														margin:'0 10 0 0',
														height:'100%',
														layout: {
															type: 'vbox',
															align: 'center',
															pack: 'center',
														},
														items:[{
															xtype:'container',
															id:'protocolArealegend'+key,
															//style:{'border':'1px solid red'},
															width:200,
														}]
													}
												]
											});
									}
								}							
							}
						}
						bandwidthObj.doComponentLayout();
					}
				}
			});
	},
	protocolTimelineSelect: function(obj)
	{
		var val = obj.getValue();
		var subsystem = Ext.getCmp('ciscosubsystem').getValue();
		var protocolURL = '/final/monitor/EgCiscoDashHelperJSON.jsp?tab=Network&hostName='+encodeURIComponent(requestParams.hostName)+'&compType='+encodeURIComponent(componentType)+'&ciscoSelectedType='+encodeURIComponent(subsystem)+'&screenWidth=1012&screenHeight=570&subsystem=Protocols&blockType=Protocols';
		
		if(protocolURL.indexOf("&protocolTimeline")>0)
		{
			protocolURL = protocolURL.replace(/(protocolTimeline=)[^\&]+/, '$1' + encodeURIComponent(val));	
		}
		else
		{
			protocolURL += '&protocolTimeline='+encodeURIComponent(val);
		}
		var interfaceVal = Ext.getCmp('interfaceCombo').getValue();
		if(protocolURL.indexOf("&selectedInterface")>0)
		{
			protocolURL = protocolURL.replace(/(selectedInterface=)[^\&]+/, '$1' + encodeURIComponent(interfaceVal));			
		}
		else
		{
			protocolURL += '&selectedInterface='+encodeURIComponent(interfaceVal);
		}		
		protocolLastLoadedURL = protocolURL;
		var bandwidthObj = Ext.getCmp('bandwidthpanel');
		bandwidthObj.removeAll();
		
		var isAxisTimeReq = false;
		var legendPos = "bottom";
		var me=this;
		Ext.Ajax.request({
				url: protocolURL ,
				scope: this,
				async: false,
				success: function (response)
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						var getMainWidth = this.getMain().getWidth(),
							getMainHeight = this.getMain().getHeight();
						var jsonText = response.responseText;
						var jsonData = Ext.decode(jsonText);
						var NoTestMsg = jsonData['NoTestMsg'];
						var bandwidthData = jsonData['CHARTNTABLE_DATA'];
						//var ProtocolTimelineCombo = jsonData['ProtocolTimelineCombo'];
						//var ProtocolTimelineComboArray = ProtocolTimelineCombo['ProtocolTimelineComboArray'];
						//var protocolSelectedTimelineCombo = ProtocolTimelineCombo['protocolSelectedTimelineCombo'];
						if (NoTestMsg!=null && !Ext.isEmpty(NoTestMsg) && NoTestMsg!=undefined )
						{
							Ext.getCmp('interfaceCombo').hide();
							Ext.getCmp('TimelineCombo').hide();
							bandwidthObj.add(
							{
								xtype: 'panel',
								width:'100%',
								items:[
									{
										xtype: 'container',
										height:200,
										width:'100%',
										margin:'20px 0px 0px 0px',
										html :'<table width="100%" height="150px"><tr><td align="center"><div class="iconInformation" style="margin:0px auto"></div><div>'+NoTestMsg+'</div></td></tr></table>'

									}]
							});
						}
						else if(bandwidthData!=null && bandwidthData!=undefined && !Ext.isEmpty(bandwidthData))
						{
							var bandwidthTitle = bandwidthData[0]['TITLE'];
							var NoMeasureMsg = bandwidthData[0]['NoMeasureMsg'];
							if (NoMeasureMsg!=null && !Ext.isEmpty(NoMeasureMsg) && NoMeasureMsg!=undefined )
							{
								Ext.getCmp('interfaceCombo').hide();
								Ext.getCmp('TimelineCombo').hide();
								bandwidthObj.add(
								{
									xtype: 'container',
									flex:1,
									items:[
										{
											xtype: 'container',
											height:150,
											width:'100%',
											html :'<table width="100%" height="100%" ><tr><td align="center"><div class="iconInformation" style="margin:0px auto"></div><div>'+NoMeasureMsg+'</div></td></tr></table>'
										}]
								});
							}
							else
							{
								var interfaceName = bandwidthData[0]['COLUMNAM_0'];
								var interfaceComboValue = bandwidthData[0]['COLUMNVAL_0'];
								me.setValueWithOptionInList('interfaceCombo', interfaceComboValue, bandwidthData[0]['selectedCombo']);

								//me.setValueWithOptionInList('TimelineCombo', ProtocolTimelineComboArray, protocolSelectedTimelineCombo);

								Ext.getCmp('bandwidthMainPanel').setTitle(bandwidthTitle);

								var areaValues=jsonData['CHARTNTABLE_DATA'];
								
								if ( !Ext.isEmpty( areaValues ) )
								{
									var highChartUrls = new Array();
									var highChartIds = new Array();
									var legendIds1 = new Array();
									var highChartHeight = new Array();
									var highChartWidth = new Array();							
									var jk=0;
									for ( var key in areaValues )
									{
										var areaTitle = areaValues[key]['Title'];
										var imgURL = areaValues[key]['areaChartURL'];
										var type = areaValues[key]['Type'];
										var graphFormat = areaValues[key]['GRAPH_FORMAT'];
											
										var imgHeight = 200;
										var imgWidth =550;
										var dataArray = new Array();
										dataArray[0] = areaTitle;
										dataArray[1] = imgURL;
										dataArray[2] = type;								
										var imgDiv = '';								
										if(!Ext.isEmpty(graphFormat))
										{
											if(graphFormat.indexOf("highchart") > -1)
											{
												imgDiv = '<div id="netProtocolareaDesktopChart'+key+'"></div>';
												highChartIds.push('netProtocolareaDesktopChart'+key);
												highChartUrls.push(imgURL);
												legendIds1.push('protocolArealegend'+key);
												highChartHeight.push(imgHeight);										
											}
										}
										bandwidthObj.add(
											/*{
												xtype: 'label',
												margin: '3px',
												html: '<div style="text-align:center;border:0px solid red;margin-left:2px" ><b>'+areaTitle+'</b></div>'
											},*/
											{
												xtype: 'container',
												id: 'netProtoareablock'+key,
												itemId: 'netProtoareablock'+key,
												cls: 'block1',
												layout:{type:'hbox'},
												dataArray: dataArray,
												border:true,
												frame:true,
												width: '100%',
												style:{'border':'0px !important'},
												flex:1,
												//title:areaTitle,
												//width: '100%',
												//height: '500px',	
												items:[
													{
														xtype: 'container',
														layout:{type:'hbox',align:'stretch'},
														flex:0.8,
														height: '100%',
														margin:'20px 0px 10px 0px',
														id:'netProtocolareaDesktopChart'+key,
														style:{
															cursor:'pointer',
														},
														items:[												
															{
																xtype: 'container',
																//flex:.7,
																//height:350,
																width: '100%',
																//margin:'10px 0px 0px 70px',
																dataArray: imgURL,
																html: imgDiv,
																listeners:{
																		'afterrender': function()
																		{
																			var loop = Math.round(Ext.getCmp('protocolpanelID').getWidth() - 360);
																			imgWidth = loop;
																			var temp = Ext.getCmp('netProtoareablock'+key);
																			var URL = this.dataArray;
																			//highChartHeight = Ext.getCmp('bandwidthpanel').el.dom.clientHeight; 
																			highChartHeight = Ext.getCmp('netProtocolareaDesktopChart'+key).el.dom.clientHeight;
																			
																			if(!Ext.isEmpty(graphFormat))
																			{																		
																				if(graphFormat.indexOf("highchart") > -1){
																					setAreaHighChart(highChartUrls[jk],highChartIds[jk],legendIds1[jk],highChartHeight[jk],imgWidth,URL,isAxisTimeReq,legendPos,false,"area","protocol",temp);
																				}
																				else
																				{																			
																					 this.update('<table width="600px" height="400px"><tr><td align="center" valign="middle"><img onClick="javascript:AreaGraphOnClick(\''+URL+'\');" src="' + URL + '" border="0" /></td></tr></table>');	
																				}
																			}
																			jk = jk+1;


																			$('.pie_dot').click(function(){
																				var pie_Id  = this.id.split("_")[1];
																				$(this).addClass("pie_dot_light").siblings().removeClass("pie_dot_light").addClass("pie_dot");
																				var setHeight = Math.round(pie_Id*200);

																				if(pie_Id == 0){
																					$('.pie_column').css({"top":setHeight});
																				}else{
																					$('.pie_column').css({"top":-setHeight});
																				}
																			})
																		}
																}
															}
														]
													},{
														xtype:'container',
														width:200,
														//flex:0.2,
														//autoScroll:true,
														overflowY:'auto',
														margin:'0 10 0 0',
														height:'100%',
														layout: {
															type: 'vbox',
															align: 'center',
															pack: 'center',
														},
														items:[{
															xtype:'container',
															id:'protocolArealegend'+key,
															//style:{'border':'1px solid red'},
															width:200,
														}]
													}
												]
											});
									}
								}							
							}
						}
						bandwidthObj.doComponentLayout();
					}
				}
			});
	},
	ciscoPieChartOnClick:function(idInx)
	{
		var thisObj=Ext.getCmp(idInx);
		var getMainWidth = this.getMain().getWidth(),
		getMainHeight = this.getMain().getHeight();
		var obj=Ext.widget('maximizeview', {
					width: getMainWidth,
					height: getMainHeight,
					id : 'Maximize',
					html:'<div id="areaChart" style="text-align:center;margin-top:25% width:'+(getMainWidth-40)+'px; height:400px;"><div class="iconInformation" style="margin:0px auto"></div></div>'
				}).show();
			var tmpArray = Ext.getCmp(idInx).dataArray;
			if ( !Ext.isEmpty( tmpArray['XML_DATA'] ))
			{
				var swfPath = tmpArray['AreaSwfpath'];
				if ( FusionCharts('Area-Chart') )
				{
					FusionCharts('Area-Chart').dispose();
				}
				var myChart = new FusionCharts(swfPath,'Area-Chart', '100%', '100%','0','1');
				myChart.setXMLData(tmpArray['XML_DATA']);
				myChart.setTransparent(true);
				myChart.render('areaChart');
			}
			else
			{
				Ext.get('areaChart').update('<div style="text-align:center;margin-top:25%" ><div class="iconInformation" style="margin:0px auto"></div><div>'+noMeasureExcl+' </div></div>');
			}
	},
	loadFlowsPanel: function(flowsURL)
	{		
		if(selectedInterface!=null && selectedParentID!=null)
		{
			this.loadDetailsTable(selectedInterface,selectedParentID);
		}
		else
		{		
			var me=this;
			var flag = false;
			//var setHeight =0;
			var store_tab = new Array();
			var tab_index = '';
			var getFlowObj = Ext.getCmp('flowspanelID');		
			var flowArr = new Array();
			getFlowObj.removeAll();
			Ext.getCmp('ciscooverviewpanel').hide();
			Ext.getCmp('currentAlertBar').hide();
			Ext.getCmp('ciscodialpanel').hide();
			Ext.getCmp('protocolpanelID').hide();
			Ext.getCmp('interfaceCombo').hide();
			Ext.getCmp('TimelineCombo').hide();
			Ext.getCmp('flowspanelID').show();
			Ext.Ajax.request({
					url: flowsURL,
					scope: this,
					async: false,
					success: function (response)
					{
						if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
						{
							var getMainWidth = this.getMain().getWidth(),
								getMainHeight = this.getMain().getHeight();
							var jsonText = response.responseText;
							var jsonData = Ext.decode(jsonText);							
							if(isIncludedNetflowDeviceAvailable)
							{
								if(!Ext.isEmpty(Ext.getCmp('flowInterfaces'))){
									Ext.destroy(Ext.getCmp('flowInterfaces'));
								}
								if(!Ext.isEmpty(Ext.getCmp('netflow_fullview_settings'))){
									Ext.destroy(Ext.getCmp('netflow_fullview_settings'));
								}
								if(!Ext.isEmpty(Ext.getCmp('netflow_configMod'))){
									Ext.destroy(Ext.getCmp('netflow_configMod'));
								}
								var flowsInterfaceCombo = jsonData['flowsInterfaceCombo'];								
								Ext.getCmp('ciscomainpanel').down('toolbar').add(
								{
									fieldLabel: 'Interfaces',
									labelAlign:'left',
									xtype: 'checkcombo', //XTYPE                   
									width: 300,
									id:'flowInterfaces',
									name:'flowInterfaces',
									editable: false,
									multiSelect:true,
									
									forceSelection:false,
									labelWidth:80,
									queryMode: 'local',
									labelSeparator:'',
									valueField: 'valueField',
									displayField: 'displayField',
									cls:'dropdown',
									flowsURL:flowsURL,
									emptyText:'All interfaces',
									allText: 'All interfaces',    
									store:new Ext.data.Store({
										fields: ['valueField','displayField'],
										//data: flowsInterfaceCombo
									}),
									//selectedValues:jsonData['flowsInterfaceSelectedCombo'],
									//value:jsonData['flowsInterfaceSelectedCombo'],
									addAllSelector: true										
								});	
								
								if(flowsInterfaceCombo!=null)
								{
									me.setValueWithOptionInList('flowInterfaces', flowsInterfaceCombo, jsonData['flowsInterfaceSelectedCombo'] );
								}								
									
								var flowHeight = Math.round($('#ciscomainpanel').height() - 55);
								getFlowObj.add({
									xtype: 'scrolltabPanel',
									id:'flowtabpanel',
									margin:'0 10 10 10',
									height:flowHeight,
									listeners: {
										'tabchange': function(obj)
										{
											var activeItem = obj.getLayout().activeItem;
											var activeTabID = obj.items.indexOf(activeItem);
											//var activeTabID = obj.getActiveTab().activeIndex;
											netflowSelectedTabIndex = activeTabID;
											if(activeTabID!=null && activeTabID!=undefined)
											{
												netflowSelectedTabIndex = activeTabID;
												if(flag ==true)
												{
													for(var i=0; i<store_tab.length; i++){
														if(netflowSelectedTabIndex == store_tab[i].tab_index){
															$('.pie_column').css({"top":-store_tab[i].setHeight});
														}
													}	
												}
											}
										}
									}
								});						
								Ext.getCmp('flowtabpanel').tabBar.addTool([
									{
										xtype:'tbfill'
									},
									{
										xtype: 'scrollcombo',
										fieldLabel: 'Timeline',
										id: 'netflow_high_er_timeline',
										name: 'netflow_high_er_timeline',
										displayField: 'displayField',
										valueField: 'valueField',
										queryMode: 'local', 
										labelWidth:55,
										labelSeparator:'',
										margin:'2 5 0 0',
										width: 150,
										defaultListConfig: {
											maxHeight: 300,
											shadow: "sides"
										},
										cls: 'dropdown',
										defaultListConfig: {
											shadow: 'sides'
										},
										editable:false,
										store:new Ext.data.Store({
											fields: ['valueField','displayField'],
											data:[]
										}),
										value: '',
										listeners:
										{
											'select': function(obj)
											{
												componentDashboard.app.getController("NetworkController").timelineSelect(obj);
											}
										}
									}										
								]);							
								
								var TimelineCombo = jsonData['timelineCombo']['timelineComboArray'];
								var TimelineComboLabel = jsonData['timelineCombo']['monitor.dashboard.TimeLine'];
								var selectedTimeline = jsonData['timelineCombo']['selectedTimelineCombo'];
								me.setValueWithOptionInList('netflow_high_er_timeline', TimelineCombo, selectedTimeline );
								Ext.getCmp('netflow_high_er_timeline').setFieldLabel(TimelineComboLabel);
								
								var flowsInterfaceSelectedCombo = jsonData['flowsInterfaceSelectedCombo'];
								
								$('#flowInterfaces-inputEl').attr('data-qtip',flowsInterfaceSelectedCombo);
								//Ext.getCmp('flowInterfaces').setValue(flowsInterfaceSelectedCombo);
								
					
								var flowsPieArr = jsonData['flowsPieArr'];
								for(var i=0;i<flowsPieArr.length;i++)
								{									
									var data = flowsPieArr[i]['DATA_'+i];
									var dataAvailable = data['Data'];
									var pieTitle = data['PIE_TITLE'];
									var MaxValues = data['MaxJSON'];
									var tableData = data['tableData'];
									var pieData = data['pieChart'];	
									var gridValues="";
									var tableColumns = "";
									var TABLE_TITLE ="";
									var TABLE_TIMELINE_TITLE ="";
									if(tableData!=null && tableData!=undefined)
									{
										gridValues=tableData[0]['gridValues'];
										tableColumns=tableData[0]['tableColumns'];
										TABLE_TITLE=tableData[0]['TABLE_TITLE'];
										TABLE_TIMELINE_TITLE=tableData[0]['TABLE_TIMELINE_TITLE'];
									}
									var cnt = 0;
									if(pieData!=null && pieData!=undefined && pieData.length==1)
									{	
										cnt = 1;									
									}
									//TABLE_TITLE += " for "+flowsInterfaceSelectedCombo.toLowerCase();
									//pieTitle += " for "+flowsInterfaceSelectedCombo.toLowerCase();

									TABLE_TITLE += " for "+flowsInterfaceSelectedCombo;
									pieTitle += " for "+flowsInterfaceSelectedCombo;

									var columnArr = new Array();
									var gridStoreModel = new Array();
									if ( !Ext.isEmpty( tableColumns ) )
									{
										for ( var l = cnt; l < tableColumns.length; l++ )
										{
											//gridStoreModel.push('COLUMVal_'+l);

											gridStoreModel.push({
												name : 'COLUMVal_'+l,
												type : 'FLOATORSTRING'
											});
											columnArr.push({
												header: tableColumns[l],
												flex: 0.2,
												dataIndex: 'COLUMVal_'+l,
												MaxValues : MaxValues,
												renderer: function(value, metaData, record, row, col, store, gridView)
												{
													var column = gridView.getHeaderAtIndex(col);
													var dataIndexVal = column.dataIndex;
													if (dataIndexVal != null && dataIndexVal == "COLUMVal_5") 
													{
														if(value!=null && value!="-")
														{
															var intf=record.get('COLUMVal_0');
															if(cnt==1)
															{
																intf = flowsInterfaceSelectedCombo;
															}
															//var  bPercentVal= column.MaxValues[intf];
															if(value>0.0)
															{
																//var barFillPercent=(parseFloat(value)/bPercentVal)*100;
																//barFillPercent=Ext.util.Format.number(barFillPercent, '000.00');
																var barStr = '<table width="100%" cellpadding="0" cellspacing="0" border="0"  height="8" class="prog_border">';
																barStr += '<tr>';
																barStr += '<td align="left" width="100%" height="8" >';
																barStr += '<table width="' + value + '%" height="8"  cellpadding="0" cellspacing="0" border="0">';
																barStr += '<tr>';
																barStr += '<td class="progress_GOOD" width="100%"> </td>';
																barStr += '</tr>';
																barStr += '</table>';
																barStr += '</td>';
																barStr += '</tr>';
																barStr += '</table>';

																value = "<table width='100%' cellpadding='0' cellspacing='0'><tr><td style='width:50px'><span>" + value
																+ "</span></td><td >" + barStr + "</td></tr></table>";
															}
														}
													}
													return value;
												}
											});
										}
									}
									if(dataAvailable!=null && (dataAvailable=='false' || gridValues.length == 0))
									{
										var mappingName = data['mappingName'];									
										var ErrorMsg = data['ErrorMsg'];									
										Ext.getCmp('flowtabpanel').add(
										{
											xtype: 'panel',
											cls: 'datapanel',
											//header:{cls:'headerwhite'},
											margin:10,
											frame:true,
											border:true,
											//id:'Fusn_chart'+i,
											title:mappingName,
											items:[
												{
													xtype: 'container',
													height:'100%',
													width:'100%',
													margin:10,
													html :'<table width="100%" height="100%"><tr><td valign="middle" align="center"><div class="iconInformation" style="margin:0px auto"></div><div style="font-size:12px">'+ErrorMsg+'</div></td></tr></table>'
												}]
										});
										Ext.getCmp('flowtabpanel').setActiveTab(netflowSelectedTabIndex);
									}
									else if(dataAvailable!=null && dataAvailable=='true')
									{									
										
										var chartDatObj = new Date();	
									
										if(tableData!=null && tableData!=undefined && !Ext.isEmpty(tableData))
										{	
											var span = new Array();
											var pieArray = new Array();
											var tableArray = new Array();
											var pieChartWidth ='';
											var pieContainerDefaultheight ="";
											var pieChartNavigationValue ='';
											var pieNavigationArray =new Array();
											if(pieData!=null && pieData!=undefined && !Ext.isEmpty(pieData))
											{
												for(var j=0;j<pieData.length;j++)
												{
													var title = pieData[j]['TITLE'];
												}
												if(title.indexOf('Conversations')>0){
													pieChartNavigationValue = Math.ceil(pieData.length /2) ;
												}else{
													pieChartNavigationValue = Math.ceil(pieData.length /3) ;
												}
												///pieNavigationArray.push(pieChartNavigationValue)
												for(var k=0; k<pieChartNavigationValue;k++){
													if(k ==0){
														span += '<div class="pie_dot pie_dot_light" id="piechartdot_'+ k +'" style="height:6px; width:6px"></div>';
													}else{
														span += '<div class="pie_dot" id="piechartdot_'+ k +'" style="height:6px; width:6px"></div>';
													}
													
												}
												for(var j=0;j<pieData.length;j++)
												{
													var rnderId = 'flowsFusnchart'+j+'_'+chartDatObj.getMinutes()+"_"+chartDatObj.getSeconds();
													var title = pieData[j]['TITLE'];	
													pieChartWidth = 350;
													
													if(title.indexOf('Conversations')>0)
													{
														pieChartWidth = 600;
													}
													var pieXmlData = pieData[j]['XML_DATA'];									
													var Interface = pieData[j]['Interface'];
													var SWF_PATH = pieData[j]['SWF_PATH'];
													var WIDTH = pieData[j]['width'];
													var HEIGHT = pieData[j]['height'];	
													var pieChart = {
														xtype:'container',
														id:title+j,
														width:'100%',
														cls:'pieSeperatorLine',
														items:[{
																	xtype:'container',
																	chartRendrId : rnderId,
																	dataArray: pieXmlData,
																	pieInterface : Interface,
																	pieWidth:pieChartWidth,
																	height:180,
																	width:'100%',
																	margin:'0 0 10 0',
																	style:{'text-align':'center'},		
																	listeners :
																	{
																		'afterrender' : function(d)
																		{
																			var date = new Date().getTime();
																				try
																				{
																					var passingParameter ='';
																					if(cnt==1)
																					{
																						passingParameter = 'pieNetflowforOne';
																					}
																					else
																					{
																						passingParameter = 'pieNetflow';
																					}
																					var xml_data = this.dataArray;
																					var barChart = {};
																					barChart = jQuery.extend(true, {}, getHighChartsBarInstance(d.id, 180, this.pieWidth), barChart);
																					barChart.setData(xml_data, currentDateFormat, '',passingParameter);
																					barChart.drawChart();
																				}
																				catch (barChartEx)
																				{
																					console.log(barChartEx);
																				}
																		}
																	}
																}	
															]
																
													};
													pieArray.push(pieChart);
													//pieContainerDefaultheight = $('.pieSeperatorLine').height();
												}	
											}
											var table_height = Math.round(($("#flowtabpanel").height())-330)

											var template = { 
												xtype: 'customgrid',
												cls:'gridSkin',
												width: '100%',
												id : 'detailsView_'+i,
												gridId:'detailsView_'+i,
												//height:table_height,
												flex:1,
												scroll:true,
												autoScroll: true,
												overflowY:'auto',
												style:{'border':'0px solid black !important'},
												store: new Ext.data.Store({
													fields: gridStoreModel,
													data: gridValues,
													sortOnLoad : true,
													sorters : {
														property : 'COLUMVal_2',
														direction : 'DESC'
													}
												}),
												stateId : 'grid_data_' + i,
												stateful : true,
												columns: columnArr
											}
											tableArray.push({
												xtype: 'container',
												flex:1,
												layout:{
													type:'vbox',
													align:'stretch',
												},
												items:[template]
											});
											var colWidth = 0.33344;
											if(pieData.length == 2){
												colWidth = 0.5;
											}
											if(title.indexOf('Conversations')>0)
											{
												colWidth = 0.5;
											}
											if(cnt==1){
												colWidth = 1;
												Ext.getCmp('flowtabpanel').add(
												{
													xtype: 'panel',
													chartDivId : 'flowsDial_chart'+i,
													dataArray: pieXmlData,
													cls: 'datapanel datapnl',										
													border:true,
													frame:true,
													id:'Fusn_chart'+i,
													tableId:'detailsView_'+i,
													activeIndex:i,
													title:title,
													layout:{
														type:'vbox',
														pack: 'center',
														align:'center'
													},
													//overflowY:'scroll',
													items:[
														{
															xytpe:'panel',
															width:'100%',
															cls:'datapanel',
															flex:1,
															layout:{
																type:'hbox',
																align:'middle',
																pack:'center',
															},
															//height:'',
															margin:'7 6 0 6',
															title:pieTitle,
															items:[
																{	
																	xtype:'container',
																	layout:'column',
																	cls:'pie_column',														
																	width:575,
																	defaults:{columnWidth: colWidth},
																	items:pieArray
																},{
																	xtype:'panel',
																	//layout:'fit',
																	layout:{
																		type:'vbox',
																		align:'stretch',
																	},
																	//style:{'z-index':'1','border':'1px solid black !important'},
																	flex:1,
																	border:false,
																	frame:false,
																	//title:'hi welcome',
																	overflowY:'auto',
																	id:'netflowsPanel'+i,
																	cls:'datapanel netdatapanel',
																	margin:'0 10 0 10',
																	items:tableArray,
																}
															]
														}
													],
												});	
											}else{
												Ext.getCmp('flowtabpanel').add(
												{
													xtype: 'panel',
													chartDivId : 'flowsDial_chart'+i,
													dataArray: pieXmlData,
													cls: 'datapanel datapnl',										
													border:true,
													frame:true,
													id:'Fusn_chart'+i,
													tableId:'detailsView_'+i,
													activeIndex:i,
													title:title,
													layout:{
														type:'vbox',
														pack: 'center',
														align:'center'
													},
													pieChartNavigationValue:pieChartNavigationValue,
													//overflowY:'scroll',
													items:[
														{
															xytpe:'panel',
															layout:'vbox',
															width:'100%',
															cls:'datapanel',
															height:190,
															margin:'7 6 0 6',
															style:{'z-index':'1'},
															title:pieTitle,
															items:[
																{	
																	xtype:'container',
																	layout:'column',
																	cls:'pie_column',
																	width:"100%",
																	defaults:{columnWidth: colWidth},
																	items:pieArray
																}
															]
														},{
															xtype:'container',
															margin:'0 7 -2 7',
															itemdId:'page_navig',
															cls:'page_navig',
															layout:{
																type:'fit',
																pack: 'center',
																align:'center'
															},
															html:'<div id="corner_left"></div><span id="center_div">'+span+'</span><div id="corner_right"></div>',
														},/*{
															xtype:'panel',
															cls:'page_con',
															margin:'0 7 0 7',
															layout:{
																type:'fit',
																pack: 'center',
																align:'center'
															},
															//html: '<div id="netflowNavigation"><div class="pagenation">'+span+'</div><div>',	
														},*/{
															xtype:'panel',
															//layout:'fit',
															layout:{
																type:'vbox',
																align:'stretch',
															},
															flex:1,
															width:'100%',
															border:false,
															frame:false,
															title:TABLE_TITLE,
															overflowY:'auto',
															id:'netflowsPanel'+i,
															cls:'datapanel netdatapanel',
															margin:'7 6 0 6',
															tools:[
																/*{
																	xtype:'label',
																	text:TABLE_TIMELINE_TITLE,
																	cls:'netflowLabel',
																	margin:'0 9 0 0',
																},*/{
																	xtype:'tbseparator',
																	margin:'0 8 0 0',
																},{
																	xtype:'button',
																	width:20,
																	margin:'2px -2px 0px 0px',
																	id:'iconMaximize'+i,
																	iconCls:'iconMaximize',
																	style:{
																		background:'none',border:'0px',
																	},
																	handler: function(c){
																		var temp  = Ext.getCmp('flowtabpanel').getActiveTab().activeIndex;
																		if(netflowSelectedTabIndex == temp){
																			Ext.getCmp('flowtabpanel').getComponent(temp).getComponent(0).hide();
																			Ext.getCmp('flowtabpanel').getComponent(temp).getComponent(1).hide();
																			Ext.getCmp('netGridButton'+temp).show();
																			Ext.getCmp('iconMaximize'+temp).hide()
																		}
																		Ext.getCmp('flowtabpanel').doLayout();
																	}
																},{
																	xtype:'button',
																	hidden:true,
																	width:20,
																	margin:'2px -2px 0px 0px',
																	iconCls:'iconMinimize',
																	id:'netGridButton'+i,
																	style:{
																			background:'none',border:'0px'
																		},
																	handler: function(c){
																		var temp  = Ext.getCmp('flowtabpanel').getActiveTab().activeIndex;
																		if(netflowSelectedTabIndex == temp){
																			Ext.getCmp('flowtabpanel').getComponent(temp).getComponent(0).show();
																			Ext.getCmp('flowtabpanel').getComponent(temp).getComponent(1).show();
																			Ext.getCmp('netGridButton'+temp).hide();
																			Ext.getCmp('iconMaximize'+temp).show()
																		}
																		Ext.getCmp('flowtabpanel').doLayout();
																	}
																}		
															],
															items:tableArray,
														}
													],
													listeners: {
														'afterrender': function(c){
															$('.pie_dot').click(function(){
																var pie_Id  = this.id.split("_")[1];
																$(this).addClass("pie_dot_light").siblings().removeClass("pie_dot_light").addClass("pie_dot");
																var setHeight = Math.round(pie_Id*190);

																if(pie_Id == 0){
																	$('.pie_column').css({"top":setHeight});
																}else{
																	$('.pie_column').css({"top":-setHeight});
																}
																tab_index = Ext.getCmp('flowtabpanel').getActiveTab().activeIndex;
																flag = true;
																store_tab.push({flag:flag, tab_index:tab_index, setHeight:setHeight})
															})
														}
													}
												});	
											}
											
											Ext.getCmp('flowtabpanel').setActiveTab(netflowSelectedTabIndex);
										}
										//alert(pieData.length)
										if(pieData.length == 1){
											Ext.getCmp('flowtabpanel').getComponent(i).getComponent(0).getComponent(0).items.each(function(d,indx){
													Ext.getCmp(d.id).addCls('pieSeperatorlastChild')
											});
										}else if(pieData.length == 2){
											Ext.getCmp('flowtabpanel').getComponent(i).getComponent(0).getComponent(0).items.each(function(d,indx){
											if((indx%2)==1){
													Ext.getCmp(d.id).addCls('pieSeperatorlastChild')
												}else{
													Ext.getCmp(d.id).addCls('pieSeperatorLine')
												}
											});
										}else{
											if(title=='Top Conversations'){
												Ext.getCmp('flowtabpanel').getComponent(i).getComponent(0).getComponent(0).items.each(function(d,indx){
													if((indx%2)==1){
														Ext.getCmp(d.id).addCls('pieSeperatorlastChild')
													}else{
														Ext.getCmp(d.id).addCls('pieSeperatorLine')
													}
												});
											}else{
												Ext.getCmp('flowtabpanel').getComponent(i).getComponent(0).getComponent(0).items.each(function(d,i){
													if((i%3)==2){							
														Ext.getCmp(d.id).addCls('pieSeperatorlastChild')
													}else{
														Ext.getCmp(d.id).addCls('pieSeperatorLine')
													}
												});
											}
										}
										Ext.getCmp('ciscomainpanel').doComponentLayout();	 
									}
								}
								//Ext.getCmp('flowtabpanel').setActiveTab(netflowSelectedTabIndex);
								getFlowObj.doComponentLayout();	
							}
							else if(isExcludedNetflowDeviceAvailable)
							{
								var flowData = jsonData['folwsArr'];
								var tableObj = jsonData['tableObj'];
								var gridJsons = jsonData['gridJsons'];
								var genHTML;
								var NoTestMsg=jsonData['NoTestMsg'];
								if(NoTestMsg!=null && !Ext.isEmpty(NoTestMsg))
								{
									for ( var i = 0; i < flowData.length; i++ )
									{
										var flow_MappingName = flowData[i]['mappingName'];
										getFlowObj.add(
											{
												xtype: 'panel',
												cls: 'datapanel',
												//header:{cls:'headerwhite'},
												margin:10,
												frame:true,
												border:true,
												//id:'Fusn_chart'+i,
												title:flow_MappingName,
												items:[
													{
														xtype: 'container',
														height:150,
														width:'100%',
														margin:10,
														html :'<table width="100%" height="100%"><tr><td valign="middle" align="center"><div class="iconInformation" style="margin:0px auto"></div><div style="font-size:12px">'+NoTestMsg+'</div></td></tr></table>'
													}]
											});
									}
								}
								else
								{
									for ( var i = 0; i < flowData.length; i++ )
									{
										var flow_MappingName = flowData[i]['mappingName'];
										var noMesMsg = flowData[i]['noMesMsg'];
										if(noMesMsg!=null && !Ext.isEmpty(noMesMsg))
										{
											getFlowObj.add(
											{
												xtype: 'panel',
												cls: 'datapanel',
												//header:{cls:'headerwhite'},
												margin:10,
												frame:true,
												border:true,
												id:'Fusn_chart'+i,
												title:flow_MappingName,
												items:[
													{
														xtype: 'container',
														height:150,
														width:'100%',
														margin:10,
														html :'<table width="100%" height="100%"><tr><td valign="middle" align="center"><div class="iconInformation" style="margin:0px auto"></div><div style="font-size:12px">'+noMesMsg+'</div></td></tr></table>'

													}]
											});
										}
										else
										{
											var flow_MappingName = flowData[i]['mappingName'];
											var flow_XML_DATA = flowData[i]['XML_DATA'];
											var flow_width = flowData[i]['width'];
											var flow_height = flowData[i]['height'];
											var flow_SWF_PATH = flowData[i]['SWF_PATH'];
											var chartDatObj = new Date();
											var rnderId = 'flowsFusnchart'+i+'_'+chartDatObj.getMinutes()+"_"+chartDatObj.getSeconds();
											var chartDispDivId = 'flowsDial_chart'+i;


											var gridvalues = flowData[i]['gridvalues'];
											var TABLE_TITLE = gridvalues['TABLE_TITLE'];
											var tableColumns = gridvalues['tableColumns'];
											var gridValues = gridvalues['gridValues'];

											genHTML = '<div class="x-table" style="border: 1px solid #adadad"><table cellspacing="0" cellpadding="0" border="0" class="x-grid-table x-grid-table-resizer nowrap"><table class="x-grid-table x-grid-table-resizer nowrap"  width="100%">';
											genHTML +='<thead width="100%">'
											genHTML +='<tr class="x-grid-row" width="100%">'
										//	genHTML +='<th colspan="2" class="x-grid-cell" style="padding:4px;width:800px;">'
											genHTML +='<div class="x-grid-cell" width="100%" style="height:30px;margin-left							:10px;color:#000" class="font_bold"><div class="font_bold" style="color:#000;margin-top:7px">'+TABLE_TITLE+'</div></div>'
											//genHTML +='</th>'
											genHTML +='</tr>'
											genHTML +='</thead>'
											genHTML +='<thead width="100%">'
											genHTML += '<tr class="x-grid-row" >';
											genHTML += '<td class="x-grid-cell" ><div class="x-grid-cell-inner">'+tableColumns['COLUMNNAME_0']+'</div></td>'
											genHTML += '<td class="x-grid-cell" ><div class="x-grid-cell-inner">'+tableColumns['COLUMNNAME_1']+'</div></td>'
											genHTML += '<td class="x-grid-cell" ><div class="x-grid-cell-inner">'+tableColumns['COLUMNNAME_2']+'</div></td>'
											genHTML += '<td class="x-grid-cell" ><div class="x-grid-cell-inner">'+tableColumns['COLUMNNAME_3']+'</div></td>'
											genHTML += '</tr>';
											genHTML +='</thead>'
											genHTML +='<tbody>'
											for ( var k = 0; k < gridValues.length; k++ )
											{
												genHTML += '<tr class="x-grid-row">';
												genHTML += '<td class="x-grid-cell" ><div class="x-grid-cell-inner">'+gridValues[k]['COLUMVal_0']+'</div></td>'
												genHTML += '<td class="x-grid-cell"><div class="x-grid-cell-inner">'+gridValues[k]['COLUMVal_1']+'</div></td>';
												genHTML += '<td class="x-grid-cell"><div class="x-grid-cell-inner">'+gridValues[k]['COLUMVal_2']+'</div></td>';
												genHTML += '<td class="x-grid-cell"><div class="x-grid-cell-inner">'+gridValues[k]['COLUMVal_3']+'</div></td>';
												genHTML += '</tr>';

											}
											genHTML +='</tbody></table></div>';


											getFlowObj.add(
												{
													xtype: 'panel',
													chartDivId : 'flowsDial_chart'+i,
													dataArray: flowData[i],
													cls: 'datapanel',
													//header:{cls:'headerwhite'},
													border:true,
													frame:true,
													margin:10,
													id:'Fusn_chart'+i,
													title:flow_MappingName,
													items:[{
															xtype: 'container',
															//labelAlign:'center',
															padding:'10px 325px 10px 10px',
															html: '<div class="f12-bold" style="text-align:center;">'+flow_MappingName+'</div>'									
														},
														{
															xtype: 'container',
															chartRendrId : rnderId,
															height:200,
															width:'100%',
															html: '<div id="flowsDial_chart'+i+'" style="height:' + flow_height + 'px;width:'+flow_width+'px;border:0px solid red;float:left;"></div>'
														},
														{
															xtype: 'panel',
															padding:'10px 10px 10px 10px',
															html : genHTML
														}],
													listeners :
													{
														'afterrender' : function()
														{
															var date = new Date().getTime();
																try
																{
																	var xml_data = this.dataArray['XML_DATA'];
																	var barChart = {};
																	barChart = jQuery.extend(true, {}, getHighChartsBarInstance('flowsDial_chart'+i, 200, 900), barChart);
																	barChart.setData(xml_data, currentDateFormat, '','Ciscopie');
																	barChart.drawChart();
																}
																catch (barChartEx)
																{
																	console.log(barChartEx);
																}
															}
													}
												});

											}
										}
									}
									getFlowObj.doComponentLayout();
								}
							}
						}
				});
		}
	},
	loadDetailsTable: function(pieInterface,parentID)
	{
		selectedInterface = pieInterface;
		selectedParentID = parentID;
		var title = Ext.getCmp('flowtabpanel').getActiveTab().title;
		
		var tempId = Ext.getCmp('flowtabpanel').getActiveTab().id;
		var panelID = Ext.getCmp(tempId).getComponent(2).id;
		if(parentID.indexOf(title)>-1)
		{
			Ext.getCmp(tempId).getComponent(2).removeAll();
			var tablePanelObj = Ext.getCmp(tempId).getComponent(2);

			$('#'+tempId+' .pieSeperatorLine').removeClass('PieBackground');
			Ext.getCmp(parentID).addCls('PieBackground');
			var flowsObj =  Ext.getCmp('flowInterfaces');
			var URL = '';
			if(flowsObj!=undefined && flowsObj!=null)
			{
				URL = Ext.getCmp('flowInterfaces').flowsURL;
				if(URL!=null && URL.indexOf("interfaceToView")>0)
				{
					URL = URL.replace(/(interfaceToView=)[^\&]+/, '$1' + encodeURIComponent(pieInterface));
				}
				else
				{
					URL = URL+"&interfaceToView="+encodeURIComponent(pieInterface);
				}
				flowsDetailsLastLoadedURL = URL;
			}
			
			if(URL==null || URL==undefined || URL=='')
			{
				URL = flowsDetailsLastLoadedURL;
			}			

			Ext.Ajax.request({
				url: URL,
				scope: this,
				async: false,
				success: function (response)
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						var getMainWidth = this.getMain().getWidth(),
							getMainHeight = this.getMain().getHeight();
						var jsonText = response.responseText;
						var jsonData = Ext.decode(jsonText);

						var flowsPieArr = jsonData['flowsPieArr'];
						var pieArray = new Array();
						var tableArray = new Array();
						for(var i=0;i<flowsPieArr.length;i++)
						{						
							var data = flowsPieArr[i]['DATA_'+i];
							var dataAvailable = data['Data'];
							if(dataAvailable!=null && dataAvailable=='true')
							{
								var MaxValues = data['MaxJSON'];
								var tableData = data['tableData'];
								var flowsTitle = tableData[0]['tableColumns'][1];
								if(title.toUpperCase().indexOf(flowsTitle)>-1)
								{		
									var gridValues="";
									var tableColumns = "";
									var TABLE_TITLE ="";
									var TABLE_TIMELINE_TITLE ="";
									if(tableData!=null && tableData!=undefined)
									{
										gridValues=tableData[0]['gridValues'];
										tableColumns=tableData[0]['tableColumns'];
										TABLE_TITLE=tableData[0]['TABLE_TITLE'];
										TABLE_TITLE += " for "+pieInterface;
										tablePanelObj.setTitle(TABLE_TITLE);
										TABLE_TIMELINE_TITLE=tableData[0]['TABLE_TIMELINE_TITLE'];
									}
									var columnArr = new Array();
									var gridStoreModel = new Array();
									if ( !Ext.isEmpty( tableColumns ) )
									{
										for ( var l = 1 ; l < tableColumns.length; l++ )
										{
											gridStoreModel.push({
												name : 'COLUMVal_'+l,
												type : 'FLOATORSTRING'
											});
											columnArr.push({
												header: tableColumns[l],
												flex: 0.2,
												dataIndex: 'COLUMVal_'+l,
												MaxValues : MaxValues,
												renderer: function(value, metaData, record, row, col, store, gridView)
												{
													var column = gridView.getHeaderAtIndex(col);
													var dataIndexVal = column.dataIndex;
													
													if (dataIndexVal != null && dataIndexVal == "COLUMVal_5") 
													{
														if(value!=null && value!="-")
														{
															//var  bPercentVal= column.MaxValues[pieInterface];
															if(value>0.0)
															{
																//var barFillPercent=(parseFloat(value)/bPercentVal)*100;
																//barFillPercent=Ext.util.Format.number(barFillPercent, '000.00');
																var barStr = '<table width="100%" cellpadding="0" cellspacing="0" border="0"  height="8" class="prog_border">';
																barStr += '<tr>';
																barStr += '<td align="left" width="100%" height="8" >';
																barStr += '<table width="' + value + '%" height="8"  cellpadding="0" cellspacing="0" border="0">';
																barStr += '<tr>';
																barStr += '<td class="progress_GOOD" width="100%"> </td>';
																barStr += '</tr>';
																barStr += '</table>';
																barStr += '</td>';
																barStr += '</tr>';
																barStr += '</table>';

																value = "<table width='100%' cellpadding='0' cellspacing='0'><tr><td style='width:50px'><span>" + value
																+ "</span></td><td >" + barStr + "</td></tr></table>";
															}
														}
													}
													return value;
												}
											});
										}
									}
									
									var template = { 
										xtype: 'customgrid',
										cls:'gridSkin',
										width: '100%',
										id : 'detailsView_'+i,
										//height:table_height,
										layout:'fit',
										flex:1,
										scroll:true,
										autoScroll: true,
										overflowY:'auto',
										style:{'border':'0px solid black !important'},
										store: new Ext.data.Store({
											fields: gridStoreModel,
											data: gridValues,
											sortOnLoad : true,
											sorters : {
												property : 'COLUMVal_2',
												direction : 'DESC'
											}
										}),
										stateId : 'grid_data_' + i,
										stateful : true,
										columns: columnArr
									}
									tableArray.push({
										xtype: 'container',
										flex:1,
										layout:{
											type:'vbox',
											align:'stretch',
										},
										items:[template]
									});
								}
							}
						}
						Ext.getCmp(panelID).add({
							xtype: 'panel',
							flex:1,
							layout:{
									type:'vbox',
									align:'stretch',
								},
							scroll:true,
							autoScroll: true,
							overflowY:'auto',
							items:tableArray
						});
					}
				}
			});
		}
	},
	selectFlowInterfaces: function(obj)
	{
		selectedInterface=null;
		selectedParentID=null;
		var getVal = obj.getValue();
		getVal = getVal.replace(",",", ");
		var getValList = getVal.split(",");
		var valueList = getVal.split(",").length;		
		if(getVal!=null && !Ext.isEmpty(getVal) && getVal!=undefined)
		{
			var getFlowObj = Ext.getCmp('flowspanelID');
			getFlowObj.removeAll();
			var flowHeight = Math.round($('#ciscomainpanel').height() - 55);
			getFlowObj.add({
				xtype: 'scrolltabPanel',
				id:'flowtabpanel',
				margin:'0 10 10 10',
				height:flowHeight,
				listeners: {
					'tabchange': function(obj)
					{
						netflowSelectedTabIndex = obj.getActiveTab().activeIndex;
					}
				}
			});	
			Ext.getCmp('flowtabpanel').tabBar.addTool([
				{
					xtype:'tbfill'
				},
				{
					xtype: 'scrollcombo',
					fieldLabel: 'Timeline',
					id: 'netflow_high_er_timeline',
					name: 'netflow_high_er_timeline',
					displayField: 'displayField',
					valueField: 'valueField',
					queryMode: 'local', 
					labelWidth:60,
					labelSeparator:'',
					margin:'2 5 0 0',
					width: 150,
					defaultListConfig: {
						maxHeight: 300,
						shadow: "sides"
					},
					cls: 'dropdown',
					defaultListConfig: {
						shadow: 'sides'
					},
					editable:false,
					store:new Ext.data.Store({
						fields: ['valueField','displayField'],
						data:[]
					}),
					value: '',
					listeners:
					{					
						'select': function(obj)
						{
							componentDashboard.app.getController("NetworkController").timelineSelect(obj);
						}
					}
				}										
			]);
			var flowsUrl = obj.flowsURL;	
			if(flowsUrl!=null && flowsUrl.indexOf("interfaceToView")>0)
			{
				flowsUrl = flowsUrl.replace(/(interfaceToView=)[^\&]+/, '$1' + encodeURIComponent(getVal));
			}
			else
			{
				flowsUrl = flowsUrl+"&interfaceToView="+encodeURIComponent(getVal);
			}
			var flowsParas = flowsUrl.substring(flowsUrl.indexOf("?")+1);			
			ciscoLastLoadedURL = ciscoLastLoadedURL.substring(0,ciscoLastLoadedURL.indexOf("?")+1)+flowsParas;
			Ext.Ajax.request({
					url: flowsUrl,
					scope: this,
					async: false,
					success: function (response)
					{
						if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
						{
							var getMainWidth = this.getMain().getWidth(),
								getMainHeight = this.getMain().getHeight();
							var jsonText = response.responseText;
							var jsonData = Ext.decode(jsonText);	

							var TimelineCombo = jsonData['timelineCombo']['timelineComboArray'];
							var TimelineComboLabel = jsonData['timelineCombo']['monitor.dashboard.TimeLine'];
							var selectedTimeline = jsonData['timelineCombo']['selectedTimelineCombo'];
							this.setValueWithOptionInList('netflow_high_er_timeline', TimelineCombo, selectedTimeline );
							Ext.getCmp('netflow_high_er_timeline').setFieldLabel(TimelineComboLabel);

							var flowsInterfaceSelectedCombo = jsonData['flowsInterfaceSelectedCombo'];
							$('#flowInterfaces-inputEl').attr('data-qtip',flowsInterfaceSelectedCombo);
							var flowsPieArr = jsonData['flowsPieArr'];
							
							
							for(var i=0;i<flowsPieArr.length;i++)
							{
								var chartDatObj = new Date();
								var data = flowsPieArr[i]['DATA_'+i];
								var dataAvailable = data['Data'];
								var MaxValues = data['MaxJSON'];
								var pieTitle = data['PIE_TITLE'];
								var tableData = data['tableData'];
								var pieData = data['pieChart'];		
								var gridValues="";
								var tableColumns = "";
								var TABLE_TITLE ="";
								var TABLE_TIMELINE_TITLE ="";
								if(tableData!=null && tableData!=undefined)
								{
									gridValues=tableData[0]['gridValues'];
									tableColumns=tableData[0]['tableColumns'];
									TABLE_TITLE=tableData[0]['TABLE_TITLE'];
									TABLE_TIMELINE_TITLE=tableData[0]['TABLE_TIMELINE_TITLE'];
								}
								var cnt = 0;
								if(valueList==1)
								{
									cnt = 1;									
								}
								TABLE_TITLE += " for "+getVal;
								pieTitle += " for "+getVal;

								var columnArr = new Array();
								var gridStoreModel = new Array();
								if ( !Ext.isEmpty( tableColumns ) )
								{									
									for ( var l = cnt ; l < tableColumns.length; l++ )
									{
										gridStoreModel.push({
											name : 'COLUMVal_'+l,
											type : 'FLOATORSTRING'
										});
										columnArr.push({
											header: tableColumns[l],
											flex: 0.2,
											dataIndex: 'COLUMVal_'+l,
											MaxValues : MaxValues,
											renderer: function(value, metaData, record, row, col, store, gridView)
											{
												var column = gridView.getHeaderAtIndex(col);
												var dataIndexVal = column.dataIndex;
												if (dataIndexVal != null && dataIndexVal == "COLUMVal_5") 
												{
													if(value!=null && value!="-")
													{
														var intf=record.get('COLUMVal_0');
														if(cnt==1)
														{
															intf = getVal;
														}														
														//var  bPercentVal= column.MaxValues[intf];
														if(value>0.0)
														{
															//var barFillPercent=(parseFloat(value)/bPercentVal)*100;
															//barFillPercent=Ext.util.Format.number(barFillPercent, '000.00');
															var barStr = '<table width="100%" cellpadding="0" cellspacing="0" border="0"  height="8" class="prog_border">';
															barStr += '<tr>';
															barStr += '<td align="left" width="100%" height="8" >';
															barStr += '<table width="' + value + '%" height="8"  cellpadding="0" cellspacing="0" border="0">';
															barStr += '<tr>';
															barStr += '<td class="progress_GOOD" width="100%"> </td>';
															barStr += '</tr>';
															barStr += '</table>';
															barStr += '</td>';
															barStr += '</tr>';
															barStr += '</table>';

															value = "<table width='100%' cellpadding='0' cellspacing='0'><tr><td style='width:50px'><span>" + value
															+ "</span></td><td >" + barStr + "</td></tr></table>";
														}
													}
												}
												return value;
											}
										});
									}
								}
								if(dataAvailable!=null && (dataAvailable=='false' || gridValues.length == 0))
								{
									var mappingName = data['mappingName'];									
									var ErrorMsg = data['ErrorMsg'];									
									Ext.getCmp('flowtabpanel').add(
									{
										xtype: 'panel',
										cls: 'datapanel',
										//header:{cls:'headerwhite'},
										margin:10,
										frame:true,
										border:true,
										//id:'Fusn_chart'+i,
										title:mappingName,
										items:[
											{
												xtype: 'container',
												height:'100%',
												width:'100%',
												margin:10,
												html :'<table width="100%" height="100%"><tr><td valign="middle" align="center"><div class="iconInformation" style="margin:0px auto"></div><div style="font-size:12px">'+ErrorMsg+'</div></td></tr></table>'
											}]
									});
									Ext.getCmp('flowtabpanel').setActiveTab(netflowSelectedTabIndex);
								}
								else if(dataAvailable!=null && dataAvailable=='true')
								{	
									if(tableData!=null && tableData!=undefined && !Ext.isEmpty(tableData))
									{	
										var span = new Array();
										var pieArray = new Array();
										var tableArray = new Array();
										var pieChartWidth ='';
										var pieContainerDefaultheight ="";
										var pieChartNavigationValue ='';
										var pieNavigationArray =new Array();
										
										
										if(pieData!=null && pieData!=undefined && !Ext.isEmpty(pieData))
										{
											for(var j=0;j<pieData.length;j++)
											{
												var title = pieData[j]['TITLE'];
											}
											if(title.indexOf('Conversations')>0){
												pieChartNavigationValue = Math.ceil(pieData.length /2) ;
											}else{
												pieChartNavigationValue = Math.ceil(pieData.length /3) ;
											}
											///pieNavigationArray.push(pieChartNavigationValue)
											for(var k=0; k<pieChartNavigationValue;k++){
												if(k ==0){
													span += '<div class="pie_dot pie_dot_light" id="piechartdot_'+ k +'" style="height:6px; width:6px"></div>';
												}else{
													span += '<div class="pie_dot" id="piechartdot_'+ k +'" style="height:6px; width:6px"></div>';
												}
												
											}
											var pagenav = {
												xtype:'container',
												margin:'0 7 0 7',
												//id:'page_navig',
												itemdId:'page_navig',
												layout:{
													type:'fit',
													pack: 'center',
													align:'center'
												},
												html:'<div id="corner_left"></div><div id="center_div">'+span+'</div><div id="corner_right"></div>',
											}
											if(pieChartNavigationValue == 1){
												//var pagenav = {
													//xtype:'container',
													//html:'hide'
												//}
											}
											for(var j=0;j<pieData.length;j++)
											{
												var rnderId = 'flowsFusnchart'+j+'_'+chartDatObj.getMinutes()+"_"+chartDatObj.getSeconds();
												var title = pieData[j]['TITLE'];	
												pieChartWidth = 350;
												
												if(title.indexOf('Conversations')>0)
												{
													pieChartWidth = 600;
												}
												var pieXmlData = pieData[j]['XML_DATA'];									
												var Interface = pieData[j]['Interface'];
												var SWF_PATH = pieData[j]['SWF_PATH'];
												var WIDTH = pieData[j]['width'];
												var HEIGHT = pieData[j]['height'];	
												var pieChart = {
													xtype:'container',
													id:title+j,
													cls:'pieSeperatorLine',
													items:[{
																xtype:'container',
																chartRendrId : rnderId,
																dataArray: pieXmlData,
																pieInterface : Interface,
																pieWidth:pieChartWidth,
																height:180,
																width:'100%',
																margin:'0 0 10 0',
																style:{'text-align':'center'},		
																listeners :
																{
																	'afterrender' : function(d)
																	{
																		var date = new Date().getTime();
																			try
																			{	
																				var passingParameter ='';
																				if(cnt==1)
																				{
																					passingParameter = 'pieNetflowforOne';
																				}
																				else
																				{
																					passingParameter = 'pieNetflow';
																				}
																				var xml_data = this.dataArray;
																				var barChart = {};
																				barChart = jQuery.extend(true, {}, getHighChartsBarInstance(d.id, 180, this.pieWidth), barChart);
																				barChart.setData(xml_data, currentDateFormat, '',passingParameter);
																				barChart.drawChart();
																			}
																			catch (barChartEx)
																			{
																				console.log(barChartEx);
																			}
																	}
																}
															}	
														]
															
												};
												pieArray.push(pieChart);
												pieContainerDefaultheight = $('.pieSeperatorLine').height();
											}	
										}
										var table_height = Math.round(($("#flowtabpanel").height())-330)

										var template = { 
											xtype: 'customgrid',
											cls:'gridSkin',
											width: '100%',
											id : 'detailsView_'+i,
											gridId:'detailsView_'+i,
											//height:table_height,
											flex:1,
											scroll:true,
											autoScroll: true,
											overflowY:'auto',
											style:{'border':'0px solid black !important'},
											store: new Ext.data.Store({
												fields: gridStoreModel,
												data: gridValues,
												sortOnLoad : true,
												sorters : {
													property : 'COLUMVal_2',
													direction : 'DESC'
												}
											}),
											stateId : 'grid_data_' + i,
											stateful : true,
											columns: columnArr
										}
										tableArray.push({
											xtype: 'container',
											flex:1,
											overflowY:'auto',
											layout:{
												type:'vbox',
												align:'stretch',
											},
											items:[template]
										});
										var colWidth = 0.33344;
										if(valueList == 2){
											colWidth = 0.5;
										}
										if(title.indexOf('Conversations')>0)
										{
											colWidth = 0.5;
										}
										if(cnt == 1){
											colWidth = 1;
											Ext.getCmp('flowtabpanel').add(
											{
												xtype: 'panel',
												chartDivId : 'flowsDial_chart'+i,
												dataArray: pieXmlData,
												cls: 'datapanel datapnl',										
												border:true,
												frame:true,
												id:'Fusn_chart'+i,
												tableId:'detailsView_'+i,
												activeIndex:i,
												title:title,
												layout:{
													type:'vbox',
													pack: 'center',
													align:'center'
												},
												//overflowY:'scroll',
												items:[
													{
														xytpe:'panel',
														width:'100%',
														cls:'datapanel',
														flex:1,
														layout:{
															type:'hbox',
															align:'middle',
															pack:'center',
														},
														//height:'',
														margin:'7 6 0 6',
														title:pieTitle,
														items:[
															{	
																xtype:'container',
																layout:'column',
																cls:'pie_column',
																width:575,
																defaults:{columnWidth: colWidth},
																items:pieArray
															},{
																xtype:'panel',
																layout:{
																	type:'vbox',
																	align:'stretch',
																},
																//style:{'z-index':'1','border':'1px solid black !important'},
																flex:1,
																border:false,
																frame:false,
																overflowY:'auto',
																id:'netflowsPanel'+i,
																cls:'datapanel netdatapanel',
																margin:'0 10 0 10',
																items:tableArray,
															}
														]
													}
												],
											});	
										}else
										{
										Ext.getCmp('flowtabpanel').add(
											{
												xtype: 'panel',
												chartDivId : 'flowsDial_chart'+i,
												dataArray: pieXmlData,
												cls: 'datapanel datapnl',										
												border:true,
												frame:true,
												id:'Fusn_chart'+i,
												tableId:'detailsView_'+i,
												activeIndex:i,
												title:title,
												layout:{
													type:'vbox',
													pack: 'center',
													align:'center'
												},
												pieChartNavigationValue:pieChartNavigationValue,
												//overflowY:'scroll',
												items:[
													{
														xytpe:'panel',
														layout:'vbox',
														width:'100%',
														cls:'datapanel',
														height:190,
														margin:'7 6 0 6',
														title:pieTitle,
														style:{'z-index':'1'},
														items:[
															{	
																xtype:'container',
																layout:'column',
																cls:'pie_column',														
																width:"100%",
																defaults:{columnWidth: colWidth},
																items:pieArray
															}
														]
													},pagenav,{
														xtype:'panel',
														//layout:'fit',
														layout:{
															type:'vbox',
															align:'stretch',
														},
														flex:1,
														width:'100%',
														border:false,
														frame:false,
														title:TABLE_TITLE,
														overflowY:'auto',
														id:'netflowsPanel'+i,
														cls:'datapanel netdatapanel',
														margin:'7 6 0 6',
														tools:[
															/*{
																xtype:'label',
																text:TABLE_TIMELINE_TITLE,
																cls:'netflowLabel',
																margin:'0 9 0 0',
															},*/{
																xtype:'tbseparator',
																margin:'0 10 0 0',
															},{
																xtype:'button',
																width:20,
																margin:'0px 0px 0px 0px',
																id:'iconMaximize'+i,
																iconCls:'iconMaximize',
																style:{
																	background:'none',border:'0px',
																},
																handler: function(c){
																	var temp  = Ext.getCmp('flowtabpanel').getActiveTab().activeIndex;
																	if(netflowSelectedTabIndex == temp){
																		Ext.getCmp('flowtabpanel').getComponent(temp).getComponent(0).hide();
																		Ext.getCmp('flowtabpanel').getComponent(temp).getComponent(1).hide();
																		Ext.getCmp('netGridButton'+temp).show();
																		Ext.getCmp('iconMaximize'+temp).hide()
																	}
																	Ext.getCmp('flowtabpanel').doLayout();
																}
															},{
																xtype:'button',
																hidden:true,
																width:20,
																margin:'0px 0px 0px 0px',
																iconCls:'iconMinimize',
																id:'netGridButton'+i,
																style:{
																		background:'none',border:'0px'
																	},
																handler: function(c){
																	var temp  = Ext.getCmp('flowtabpanel').getActiveTab().activeIndex;
																	if(netflowSelectedTabIndex == temp){
																		Ext.getCmp('flowtabpanel').getComponent(temp).getComponent(0).show();
																		Ext.getCmp('flowtabpanel').getComponent(temp).getComponent(1).show();
																		Ext.getCmp('netGridButton'+temp).hide();
																		Ext.getCmp('iconMaximize'+temp).show()
																	}
																	Ext.getCmp('flowtabpanel').doLayout();
																}
															}		
														],
														items:tableArray,
													}
												],
												listeners: {
													'afterrender': function(c){
														/*if(valueList == 1 || this.pieChartNavigationValue == 1){
															
															Ext.get(c.id).select('.page_navig').hide();
															Ext.ComponentQuery.query("container[itemdId =page_navig]").forEach(function(d){
																	d.hide();
															});
															Ext.ComponentQuery.query("container[itemdId =page_navig]")[0].hide()
														}*/
														$('.pie_dot').click(function(){
														
															getFlowObj.doComponentLayout();		
															var pie_Id  = this.id.split("_")[1];
															$(this).addClass("pie_dot_light").siblings().removeClass("pie_dot_light").addClass("pie_dot");
															var setHeight = Math.round(pie_Id*pieContainerDefaultheight);
															
															if(pie_Id == 0){
																$('.pie_column').css({"top":setHeight});
															}else{
																$('.pie_column').css({"top":-setHeight});
															}
															tab_index = Ext.getCmp('flowtabpanel').getActiveTab().activeIndex;
															flag = true;
															//store_tab.push({flag:flag, tab_index:tab_index, setHeight:setHeight})
														})
													}
												}
											});
										}
										
										Ext.getCmp('flowtabpanel').setActiveTab(netflowSelectedTabIndex);
									}
								
									if(valueList == 1){
										Ext.getCmp('flowtabpanel').getComponent(i).getComponent(0).getComponent(0).items.each(function(d,indx){
												Ext.getCmp(d.id).addCls('pieSeperatorlastChild')
										});
									}else if(valueList == 2){
										Ext.getCmp('flowtabpanel').getComponent(i).getComponent(0).getComponent(0).items.each(function(d,indx){
										if((indx%2)==1){
												Ext.getCmp(d.id).addCls('pieSeperatorlastChild')
											}else{
												Ext.getCmp(d.id).addCls('pieSeperatorLine')
											}
										});
									}else{
										if(title=='Top Conversations'){
											Ext.getCmp('flowtabpanel').getComponent(i).getComponent(0).getComponent(0).items.each(function(d,indx){
												if((indx%2)==1){
													Ext.getCmp(d.id).addCls('pieSeperatorlastChild')
												}else{
													Ext.getCmp(d.id).addCls('pieSeperatorLine')
												}
											});
										}else{
											Ext.getCmp('flowtabpanel').getComponent(i).getComponent(0).getComponent(0).items.each(function(d,i){
												if((i%3)==2){							
													Ext.getCmp(d.id).addCls('pieSeperatorlastChild')
												}else{
													Ext.getCmp(d.id).addCls('pieSeperatorLine')
												}
											});
										}
									}
								}
							}
							getFlowObj.doComponentLayout();							
													
						}
					}
			});
		}
	},
	interfaceComboLoad: function()
	{
		var isAxisTimeReq = false;
		var legendPos = "bottom";
		var cbandwidthObj = Ext.getCmp('bandwidthpanel');
		cbandwidthObj.removeAll();
		var subsystem = Ext.getCmp('ciscosubsystem').getValue();
		var comboVal = Ext.getCmp('interfaceCombo').getValue();
		var timelineVal = Ext.getCmp('TimelineCombo').getValue();
		
		var protocolURL = '/final/monitor/EgCiscoDashHelperJSON.jsp?tab=Network&hostName='+encodeURIComponent(requestParams.hostName)+'&compType='+encodeURIComponent(componentType)+'&ciscoSelectedType='+encodeURIComponent(subsystem)+'&screenWidth=1012&screenHeight=570&subsystem=Protocols&blockType=Protocols';
		
		if(protocolURL.indexOf("&selectedInterface")>0)
		{
			protocolURL = protocolURL.replace(/(selectedInterface=)[^\&]+/, '$1' + encodeURIComponent(comboVal));
		}
		else
		{
			protocolURL += '&selectedInterface='+encodeURIComponent(comboVal);
		}
		if(protocolURL.indexOf("&protocolTimeline")>0)
		{
			protocolURL = protocolURL.replace(/(protocolTimeline=)[^\&]+/, '$1' + encodeURIComponent(timelineVal));	
		}
		else
		{
			protocolURL += '&protocolTimeline='+encodeURIComponent(timelineVal);
		}
		protocolLastLoadedURL = protocolURL;
		Ext.Ajax.request({
				url:protocolURL,
				scope: this,
				success: function (response)
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						var getMainWidth = this.getMain().getWidth(),
							getMainHeight = this.getMain().getHeight();
						var jsonText = response.responseText;						
						var jsonData = Ext.decode(jsonText);
						var areaValues = jsonData['CHARTNTABLE_DATA'];
						var interfaceName = areaValues[0]['COLUMNAM_0'];
								
						if ( !Ext.isEmpty( areaValues ) )
						{
							var highChartUrls = new Array();
							var highChartIds = new Array();
							var legendIds1 = new Array();
							var highChartHeight = new Array();
							var highChartWidth = new Array();							
							var j=0;
							for ( var key in areaValues )
							{
								var areaTitle = areaValues[key]['Title'];
								var imgURL = areaValues[key]['areaChartURL'];
								var type = areaValues[key]['Type'];
								var graphFormat = areaValues[key]['GRAPH_FORMAT'];
									
								var imgHeight=200;
								var imgWidth =550;
								var dataArray = new Array();
								dataArray[0] = areaTitle;
								dataArray[1] = imgURL;
								dataArray[2] = type;								
								var imgDiv = '';								
								if(!Ext.isEmpty(graphFormat))
								{
									if(graphFormat.indexOf("highchart") > -1)
									{
										imgDiv = '<div id="netareaDesktopChartDiv'+key+'" style="margin:20px 0px 0px 0px;padding:0px 0px 0px 90px"></div>';
										highChartIds.push('netareaDesktopChartDiv'+key);
										legendIds1.push('protocolInterfaceArealegend'+key);
										highChartUrls.push(imgURL);
										highChartHeight.push(imgHeight);										
									}
								}
								
								cbandwidthObj.add(
								{									
									xtype: 'panel',									
									cls: 'block1',
									layout:{type:'hbox',align:'stretch'},
									dataArray: dataArray,
									title:areaTitle,
									width: '100%',
									flex:1,
									id:'netareaChartDiv'+key,
									items:[										
										{
											xtype: 'container',
											//width: '100%',
											height: 220,
											layout:{type:'hbox',align:'stretch'},
											flex:0.8,
											margin:'20px 0px 10px 0px',
											id:'netareaDesktopChartDiv'+key,
											URL: imgURL,
											html: imgDiv,
											style:{
												cursor:'pointer'
											},
											listeners:
											{												
												'afterrender': function()
												{
													var url = this.URL;
													if(!Ext.isEmpty(graphFormat))
													{
														var loop = Math.round(Ext.getCmp('protocolpanelID').getWidth() - 360);
														imgWidth = loop;
														var temp = Ext.getCmp('netareaChartDiv'+key)
														highChartHeight = Ext.getCmp('netareaChartDiv'+key).el.dom.clientHeight;
														if(graphFormat.indexOf("highchart") > -1){
															setAreaHighChart(highChartUrls[j],highChartIds[j],legendIds1[j],highChartHeight[j],imgWidth,url,isAxisTimeReq,legendPos,false,"area","protocol",temp);
														}
														else
														{
															this.update('<img onClick="javascript:AreaGraphOnClick(\''+url+'\');" src="'+url+'&height=180&width=550&mode=2D" />');
														}
													}
													j = j+1;
												}
											}
										},
										{
											xtype:'container',
											width:200,
											//flex:0.2,
											overflowY:'auto',
											margin:'0 10 0 0',
											height:'100%',
											layout: {
												type: 'vbox',
												align: 'center',
												pack: 'center',
											},
											items:[{
												xtype:'container',
												id:'protocolInterfaceArealegend'+key,
												width:200,
											}]
										}
									]
								});
							}
						}						
						cbandwidthObj.doComponentLayout();					
					}
				}
		});
	},
	ddOnclick: function(urlData)
	{
		Ext.getCmp('subNetworkPanelId').hide();
		Ext.getCmp('subnetworktabpanelID').hide();
		comboChangeURL = '/final/monitor/egDashTimelineJSON.jsp?'+urlData+'&graphType=DDgraph';
		var networkObj = this.getNetworkmainpanel();
		networkObj.remove('networkfullviewpanel');
		var fullviewObj = {
			xtype:'networkfullviewpanel',
			Dataurl:'/final/monitor/egDashTimelineJSON.jsp?'+urlData+'&graphType=DDgraph',
			viewType:'barGraph',
			gtype:'bar'
		};
		networkObj.add(fullviewObj);
		networkObj.doLayout();	
	},
	comparisionBarOnclick: function(urlData)
	{
		Ext.getCmp('subNetworkPanelId').hide();
		Ext.getCmp('subnetworktabpanelID').hide();
		urlData = urlData.split('?');
		var params = urlData[1];
		comboChangeURL = '/final/monitor/egDashTimelineJSON.jsp?'+params+'&graphType=comparisionBargraph';
		var wobj = this.getNetworkmainpanel();
		wobj.remove('networkfullviewpanel');
		var fullviewObj = {
			xtype:'networkfullviewpanel',
			width : (Ext.getBody().getViewSize().width-10),
			height : (Ext.getBody().getViewSize().height-60),
			Dataurl:'/final/monitor/egDashTimelineJSON.jsp?'+params+'&graphType=comparisionBargraph',
			viewType:'barGraph',
			gtype:'bar'
		};
		wobj.add(fullviewObj);
		wobj.doLayout();
	},
	trendGraphOnclick: function(urlData)
	{		
		Ext.getCmp('subNetworkPanelId').hide();
		Ext.getCmp('subnetworktabpanelID').hide();
		urlData = urlData.split('?');
		var params = urlData[1];
		comboChangeURL = '/final/monitor/egDashTimelineJSON.jsp?'+params+'&graphType=Trendgraph';
		var wobj = this.getNetworkmainpanel();
		wobj.remove('networkfullviewpanel');
		var fullviewObj = {
			xtype:'networkfullviewpanel',
			width : (Ext.getBody().getViewSize().width-10),
			height : (Ext.getBody().getViewSize().height-60),
			Dataurl:'/final/monitor/egDashTimelineJSON.jsp?'+params+'&graphType=Trendgraph',
			viewType:'trendGraph',
			gtype:'trend'
		};
		wobj.add(fullviewObj);
		wobj.doLayout();
	},
	summaryGraphOnclick: function(urlData)
	{		
		Ext.getCmp('subNetworkPanelId').hide();
		Ext.getCmp('subnetworktabpanelID').hide();
		urlData = urlData.split('?');
		var params = urlData[1];
		comboChangeURL = '/final/monitor/egDashTimelineJSON.jsp?'+params+'&graphType=Summarygraph';
		var wobj = this.getNetworkmainpanel();
		wobj.remove('networkfullviewpanel');
		var fullviewObj = {
			xtype:'networkfullviewpanel',
			width : (Ext.getBody().getViewSize().width-10),
			height : (Ext.getBody().getViewSize().height-60),
			Dataurl:'/final/monitor/egDashTimelineJSON.jsp?'+params+'&graphType=Summarygraph',
			viewType:'Summarygraph',
			gtype:'summary'
		};
		wobj.add(fullviewObj);
		wobj.doLayout();
	},
	
	DDGraphOnClick: function(urlData)
	{
		Ext.getCmp('subNetworkPanelId').hide();
		Ext.getCmp('subnetworktabpanelID').hide();
		urlData = urlData.split('?');
		var params = urlData[1];
		comboChangeURL = '/final/monitor/egDashTimelineJSON.jsp?'+params+'&graphType=DDgraph';
		var wobj = this.getNetworkmainpanel();
		wobj.remove('networkfullviewpanel');
		var fullviewObj = {
			xtype:'networkfullviewpanel',
			width : (Ext.getBody().getViewSize().width-10),
			height : (Ext.getBody().getViewSize().height-60),
			Dataurl:'/final/monitor/egDashTimelineJSON.jsp?'+params+'&graphType=DDgraph',
			viewType:'barGraph',
			gtype:'bar'
		};
		wobj.add(fullviewObj);
		wobj.doLayout();
	},
	ComparisonGraphGraphOnClick: function(urlData)
	{
		Ext.getCmp('subNetworkPanelId').hide();
		Ext.getCmp('subnetworktabpanelID').hide();
		urlData = urlData.split('?');
		var params = urlData[1];
		comboChangeURL = '/final/monitor/egDashTimelineJSON.jsp?'+params+'&graphType=comparisionBargraph';
		var wobj = this.getNetworkmainpanel();
		wobj.remove('networkfullviewpanel');
		var fullviewObj = {
			xtype:'networkfullviewpanel',
			width : (Ext.getBody().getViewSize().width-10),
			height : (Ext.getBody().getViewSize().height-60),
			Dataurl:'/final/monitor/egDashTimelineJSON.jsp?'+params+'&graphType=comparisionBargraph',
			viewType:'barGraph',
			gtype:'bar'
		};
		wobj.add(fullviewObj);
		wobj.doLayout();
	},	
	MeasureGraphOnClick: function(urlData)
	{
		Ext.getCmp('subNetworkPanelId').hide();
		Ext.getCmp('subnetworktabpanelID').hide();
		urlData = urlData.split('?');
		var params = urlData[1];
		comboChangeURL = '/final/monitor/egDashTimelineJSON.jsp?'+params+'&graphType=measureGraph';
		var wobj = this.getNetworkmainpanel();
		wobj.remove('networkfullviewpanel');
		var fullviewObj = {
			xtype:'networkfullviewpanel',
			width : (Ext.getBody().getViewSize().width-10),
			height : (Ext.getBody().getViewSize().height-60),
			Dataurl:'/final/monitor/egDashTimelineJSON.jsp?'+params+'&graphType=measureGraph',
			viewType:'measureGraph',
			gtype:'measure'
		};
		wobj.add(fullviewObj);
		wobj.doLayout();
	},	
	loadFullViewPanel: function()
	{
		var me =this;
		var fullViewPanelObj = Ext.getCmp('net_fullviewId');
		var urlData = fullViewPanelObj.Dataurl;
		var fullViewPnlObj = fullViewPanelObj.up('panel');
		fullViewPanelObj.setLoading(true,true);
		urlData +='&screenWidth='+(fullViewPnlObj.getWidth()-10)+'&screenHeight='+(fullViewPnlObj.getHeight());
		var viewType = Ext.getCmp('net_fullviewId').viewType;
		if (viewType == 'barGraph')
		{
			Ext.getCmp('net_period').hide();
		//	Ext.getCmp('net_modeID').hide();
			Ext.getCmp('net_graphID').hide();
			Ext.getCmp('net_Show').show();
		}
		else if (viewType == 'trendGraph')
		{
			Ext.getCmp('net_period').show();
		//	Ext.getCmp('net_modeID').show();
			Ext.getCmp('net_graphID').show();
			Ext.getCmp('net_Show').hide();
		}
		else if (viewType == 'Summarygraph')
		{
			Ext.getCmp('net_period').show();
		//	Ext.getCmp('net_modeID').show();
			Ext.getCmp('net_Show').hide();
		}
		else if (viewType == 'measureGraph' )
		{
			Ext.getCmp('net_period').hide();
			Ext.getCmp('net_Show').hide();
		//	Ext.getCmp('net_modeID').show();
		}
		Ext.Ajax.request({
			url:urlData,
			scope:this,
			method: 'POST',
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					var dateArray = jsonData['dateArrayValues'];
					var trendGrpDuration = jsonData['trendGrpDuration'];
					if (trendGrpDuration!=null && trendGrpDuration!='' && !Ext.isEmpty(trendGrpDuration))
					{
						var durationLabel = trendGrpDuration['monitor.dashboard.Duration'];
						var selectedDuration = trendGrpDuration['selectedDuration'];
						var durationComboVal = trendGrpDuration['trendGrpDurationArr'];

						var durationObj = Ext.getCmp('net_period');
						durationObj.setFieldLabel(durationLabel);
						durationObj.getStore().loadRawData(durationComboVal);
						durationObj.setValue(selectedDuration);
					}
					var barGraphVal = jsonData['BARGRAPH'];
					if( barGraphVal!=null && barGraphVal!=''& !Ext.isEmpty(barGraphVal))
					{
						var showLabel = barGraphVal['monitor.common.Show'];
						var selectedShowVal = barGraphVal['selectedShowCombo'];
						var showComboVal = barGraphVal['barGraphShowCombo'];
					//	var historyLabel = barGraphVal['monitor.measure.History'];
						var showComboObj = Ext.getCmp('net_Show');
						showComboObj.setFieldLabel(showLabel);
						showComboObj.getStore().loadRawData(showComboVal);
						showComboObj.setValue(selectedShowVal);
					}
					var timelineValues = jsonData['timelineCombo'];
					if ( timelineValues!=null && timelineValues!=''& !Ext.isEmpty(timelineValues) )
					{
						var timelineLabel = timelineValues['monitor.dashboard.TimeLine'];
						var selectedTimelineCombo = timelineValues['selectedTimelineCombo'];
						var TimelineComboVal = timelineValues['timelineCombo'];

						var timelineObj = Ext.getCmp('net_high_er_timeline');
						timelineObj.setFieldLabel(timelineLabel);
						timelineObj.getStore().loadRawData(TimelineComboVal);
						timelineObj.setValue(selectedTimelineCombo);
					}	
					var fromData = jsonData['fromValues'];
					if ( fromData!=null && fromData!=''& !Ext.isEmpty(fromData) )
					{
						var fromlabel = fromData['monitor.VirtualDashboard.From'];
						var isFromDisabled = fromData['from'];
						var fromValue = fromData['value'];
						var fromObj = Ext.getCmp('net_high_er_stdate');
						fromObj.setFieldLabel(fromlabel);
						fromObj.setDisabled(isFromDisabled);						
						
						fromObj.dataArray = dateArray[0];
						fromObj.setValue(dateArray[6]);
					}
					var startHr = jsonData['startHr'];
					if ( startHr!=null && startHr!=''& !Ext.isEmpty(startHr) )
					{
						var hrLabel = startHr['monitor.VirtualDashboard.Hr'];
						var isStartHrEnabled = startHr['isStartHrEnabled'];
						var selectedStartHr = startHr['selectedStartHr'];
						var startHrCmbo = startHr['startHrArray'];

						var startHrObj = Ext.getCmp('net_high_er_sthr');
						startHrObj.setFieldLabel(hrLabel);
						startHrObj.getStore().loadRawData(startHrCmbo);						
						startHrObj.setDisabled(isStartHrEnabled);

						startHrObj.dataArray = dateArray[2];
						startHrObj.setValue(dateArray[7]);
					}
					var toValues = jsonData['toValues'];
					if ( toValues!=null && toValues!=''& !Ext.isEmpty(toValues) )
					{
						var toLabel = toValues['monitor.VirtualDashboard.To'];
						var isToDisabled = toValues['to'];
						var value = toValues['value'];
						var toObj = Ext.getCmp('net_high_er_enddate');
						toObj.setDisabled(isToDisabled);
						toObj.setFieldLabel(toLabel);					

						toObj.dataArray = dateArray[1];
						toObj.setValue(dateArray[9]);
					}
					var endHr = jsonData['endHr'];
					if ( endHr!=null && endHr!=''& !Ext.isEmpty(endHr) )
					{
						var hrLabel = endHr['monitor.VirtualDashboard.Hr'];
						var isEndHrEnabled = endHr['isEndHrEnabled'];
						var selectedEndHr = endHr['selectedEndHr'];
						var endHrCmbo = endHr['endHrArray'];

						var endHrObj = Ext.getCmp('net_high_er_endhr');
						endHrObj.setFieldLabel(hrLabel);
						endHrObj.getStore().loadRawData(endHrCmbo);						
						endHrObj.setDisabled(isEndHrEnabled);

						endHrObj.dataArray = dateArray[3];
						endHrObj.setValue(dateArray[10]);
					}
				/*	var ModeCombo = jsonData['ModeCombo'];
					if (ModeCombo!=null && ModeCombo!=undefined && ModeCombo!='')
					{
						var modeComboVal = ModeCombo['comparisonBarModeArr'];
						var selectedMode = ModeCombo['selectedMode'];

						var modeObj = Ext.getCmp('net_modeID');
						modeObj.getStore().loadRawData(modeComboVal);
						modeObj.setValue(selectedMode);
					}*/
					var GraphCombo = jsonData['GraphCombo'];
					if (GraphCombo!=null && GraphCombo!=undefined && GraphCombo!='')
					{
						var graphLabel = GraphCombo['monitor.dashboard.Graph'];
						var graphComboVal = GraphCombo['trendGraph'];
						var selectedGraph = GraphCombo['selectedGraph'];

						var graphObj = Ext.getCmp('net_graphID');
						graphObj.setFieldLabel(graphLabel);
						graphObj.getStore().loadRawData(graphComboVal);
						graphObj.setValue(selectedGraph);
					}
					var ddGraphLink = jsonData['ddGraphObj'];
					if ( ddGraphLink!=null && ddGraphLink!=''& !Ext.isEmpty(ddGraphLink) )
					{
						var DetailsLink = ddGraphLink['DetailsLink'];
						var DetailsLabel = ddGraphLink['DetailsLabel'];
						if (DetailsLink == 'true')
						{
							Ext.getCmp('net_detailsID').show();
						}
					}
					var fullViewContObj = Ext.getCmp('net_fullViewBarId');
					fullViewContObj.removeAll();
					fullViewContObj.update('');
					if (viewType == 'measureGraph' )
					{
						var MeasureGraphImage = jsonData['MeasureGraphImage'];
						if (MeasureGraphImage!=null && MeasureGraphImage!=''& !Ext.isEmpty(MeasureGraphImage) && MeasureGraphImage!=undefined)
						{
							var DATA = MeasureGraphImage['DATA'];
							var HIGH_CHART = MeasureGraphImage['HIGH_CHART'];
							var isHighChartEnabled = '';
							if (HIGH_CHART == 'highcharts')
							{
								isHighChartEnabled = true;
							}
							else
							{
								isHighChartEnabled = false;
							}
							var minMaxTable = jsonData['minMaxTable'];
							var minMaxTableHeadersArray = '';
							var measuresTableDataArray = '';
							if (minMaxTable!=null && minMaxTable!=''& !Ext.isEmpty(minMaxTable) && minMaxTable!=undefined)
							{
								minMaxTableHeadersArray = minMaxTable['minMaxTableHeadersArray'];
							}
							var measuresTable = jsonData['measuresTable'];
							if (measuresTable!=null && measuresTable!=''& !Ext.isEmpty(measuresTable) && measuresTable!=undefined)
							{						
								measuresTableDataArray = measuresTable['measuresTableDataArray'];	
							}
							if (DATA == 'true')
							{
								var img_src = MeasureGraphImage['iframeSrc'];
								me.loadMeasureGraph(img_src,isHighChartEnabled);
							}
							else
							{
								var Msg = MeasureGraphImage['Msg'];
								fullViewContObj.update(Msg);
								fullViewPanelObj.setLoading(false);
							}
						}
					}
					else
					{
						var FullViewXmlData = jsonData['FullViewXmlData'];
						if ( FullViewXmlData!=null && FullViewXmlData!=''& !Ext.isEmpty(FullViewXmlData) )
						{
							var data = FullViewXmlData['DATA'];							
							if (data == 'true')
							{			
								var WIDTH = FullViewXmlData['WIDTH'];
								var HEIGHT = FullViewXmlData['HEIGHT'];
								HEIGHT = parseInt(HEIGHT);
								fullViewContObj.add({
									xtype: 'container',
									id: 'net_fullViewPanelBigId',
									style:{'text-align':'center','margin':'20px auto'},
									xmlData:FullViewXmlData,
									width:WIDTH,
									height:HEIGHT,
									listeners:
									{
										'afterrender': function(thisObj)
										{
												var XMLDATA = thisObj.xmlData['XMLDATA'];
												try
												{
													if (viewType == 'Summarygraph')
													{
														var barChart = {};
														barChart = jQuery.extend(true, {}, getHighChartsBarInstance(thisObj.id, 480,WIDTH), barChart);	
														barChart.setData(XMLDATA, currentDateFormat, '','stackedColumn');
														barChart.drawChart();
													}
													else if (viewType == 'trendGraph')
													{
														var widthInPix = thisObj.xmlData['WIDTH'];
														var heightInPix = thisObj.xmlData['HEIGHT'];
														var lineChart = {};
														lineChart = jQuery.extend(true, {}, createLineChart(thisObj.id,parseInt(heightInPix),(parseInt(widthInPix) -20)), lineChart);
														lineChart.setData(XMLDATA, currentDateFormat,'' ,'line',true);
														lineChart.drawChart();
													}
													else
													{
														var barChart = {};
														barChart = jQuery.extend(true, {}, getHighChartsBarInstance(thisObj.id, 450,WIDTH -150), barChart);	
														barChart.setData(XMLDATA, currentDateFormat, '','bar');
														barChart.drawChart();
													}
													fullViewPanelObj.setLoading(false);
												}
												catch (barChartEx)
												{
													console.log(barChartEx);
												}
											}
									}
								});										
							}
							else
							{
								var msg = FullViewXmlData['MSG'];
								fullViewContObj.update(msg);
							}						
						}
					}
				}
			}
		});		
	},
	loadFullViewGraph: function(urlData)
	{
		var fullViewPanelObj = Ext.getCmp('net_fullviewId');
		var fullViewPnlObj = fullViewPanelObj.up('panel');
		fullViewPanelObj.setLoading(true,true);
		urlData +='&screenWidth='+(fullViewPnlObj.getWidth()-10)+'&screenHeight='+(fullViewPnlObj.getHeight());
		var fullViewContObj = Ext.getCmp('net_fullViewBarId');
		fullViewContObj.removeAll();
		fullViewContObj.update('');
		var me = this;
		var viewType = Ext.getCmp('net_fullviewId').viewType;		
		Ext.Ajax.request({
			url:urlData,
			scope:this,
			method: 'POST',
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					if (viewType == 'measureGraph' )
					{
						var MeasureGraphImage = jsonData['MeasureGraphImage'];
						if (MeasureGraphImage!=null && MeasureGraphImage!=''& !Ext.isEmpty(MeasureGraphImage) && MeasureGraphImage!=undefined)
						{
							var DATA = MeasureGraphImage['DATA'];
							var HIGH_CHART = MeasureGraphImage['HIGH_CHART'];
							var isHighChartEnabled = '';
							if (HIGH_CHART == 'highcharts')
							{
								isHighChartEnabled = true;
							}
							else
							{
								isHighChartEnabled = false;
							}
							var minMaxTable = jsonData['minMaxTable'];
							var minMaxTableHeadersArray = '';
							var measuresTableDataArray = '';
							if (minMaxTable!=null && minMaxTable!=''& !Ext.isEmpty(minMaxTable) && minMaxTable!=undefined)
							{
								minMaxTableHeadersArray = minMaxTable['minMaxTableHeadersArray'];
							}
							var measuresTable = jsonData['measuresTable'];
							if (measuresTable!=null && measuresTable!=''& !Ext.isEmpty(measuresTable) && measuresTable!=undefined)
							{						
								measuresTableDataArray = measuresTable['measuresTableDataArray'];	
							}
							if (DATA == 'true')
							{
								var img_src = MeasureGraphImage['iframeSrc'];
								me.loadMeasureGraph(img_src,isHighChartEnabled);
							}
							else
							{
								var Msg = MeasureGraphImage['Msg'];
								fullViewContObj.update(Msg);
								fullViewPanelObj.setLoading(false);
							}							
						}
					}
					else
					{
						var FullViewXmlData = jsonData['FullViewXmlData'];
						if ( FullViewXmlData!=null && FullViewXmlData!=''& !Ext.isEmpty(FullViewXmlData) )
						{
							var data = FullViewXmlData['DATA'];
							var fullViewContObj = Ext.getCmp('net_fullViewBarId');
							if (data == 'true')
							{		
								var WIDTH = FullViewXmlData['WIDTH'];
								var HEIGHT = FullViewXmlData['HEIGHT'];
								HEIGHT = parseInt(HEIGHT);
								fullViewContObj.add({
									xtype: 'container',
									id: 'net_fullViewPanelBigId',
									xmlData:FullViewXmlData,
									width:WIDTH,
									height:HEIGHT,
									listeners:
									{
										'afterrender': function(thisObj)
										{
												var XMLDATA = thisObj.xmlData['XMLDATA'];
												try
												{													
													if (viewType == 'Summarygraph')
													{
														var barChart = {};
														barChart = jQuery.extend(true, {}, getHighChartsBarInstance(thisObj.id, 480,1280), barChart);
														barChart.setData(XMLDATA, currentDateFormat, '','stackedColumn');
														barChart.drawChart();
													}
													else if (viewType == 'trendGraph')
													{
														var widthInPix = thisObj.xmlData['WIDTH'];
														var heightInPix = thisObj.xmlData['HEIGHT'];
														var lineChart = {};
														lineChart = jQuery.extend(true, {}, createLineChart(thisObj.id,heightInPix,widthInPix),lineChart);
														lineChart.setData(XMLDATA, currentDateFormat,'' ,'line',true);
														lineChart.drawChart();
													}
													else
													{
														var barChart = {};
														var chartcontainer=parseInt(fullViewPanelObj.getWidth())-100;
														barChart = jQuery.extend(true, {}, getHighChartsBarInstance(thisObj.id, 490,chartcontainer), barChart);										
														barChart.setData(XMLDATA, currentDateFormat, '','bar');
														barChart.drawChart();
													}
													fullViewPanelObj.setLoading(false);
												}
												catch (barChartEx)
												{
													console.log(barChartEx);
												}
										}
									}
								});										
							}
							else
							{
								var msg = FullViewXmlData['MSG'];
								fullViewContObj.update( '<table width="100%" height="300"><tr><td valign="middle" align="center"><div class="iconInformation" style="margin-top:5%"></div><div style="font-size:12px">'+msg+'</div></td></tr></table>');
								fullViewPanelObj.setLoading(false);
							}
						}
					}
				}
			}
		});		
	},
	dateDiff: function( fromDate,toDate )
    {
    	var oneDay=24*60*60*1000;   //hours*mins*seconds*millisecs
		var fromDate=new Date(fromDate);
		var toDate=new Date(toDate);
		var diffDays = Math.round(Math.abs(fromDate.getTime()-toDate.getTime())/(oneDay));
		return diffDays;
    },

	goBtnOnClick: function()
	{
		var fromHrObj =  Ext.getCmp('net_high_er_sthr');
		var toHrObj =  Ext.getCmp('net_high_er_endhr');

		var showValue = Ext.getCmp('net_Show').getValue();
		var timelineVal = Ext.getCmp('net_high_er_timeline').getValue();
		var fromValue = Ext.getCmp('net_high_er_stdate').getValue();
		fromValue = formatDate(Ext.getCmp('net_high_er_stdate').getValue(), mgrDisplayDateFormat);
		var fromHr = fromHrObj.getValue();

		var ToValue = Ext.getCmp('net_high_er_enddate').getValue();
		ToValue = formatDate(Ext.getCmp('net_high_er_enddate').getValue(), mgrDisplayDateFormat);
		var toHr = toHrObj.getValue();

		var modeVal = '2D';//Ext.getCmp('net_modeID').getValue();
		var durationVal = Ext.getCmp('net_period').getValue();
		var graphVal = Ext.getCmp('net_graphID').getValue();

		var viewType = Ext.getCmp('net_fullviewId').viewType;

		//Date validation
		var today = new Date();
		var diffDays = this.dateDiff(new Date(fromValue),new Date(ToValue));
		var currentDate = today.getMonth() + "/" + today.getDay() + "/" + today.getYear();
		if(timelineVal!=null && timelineVal.toLowerCase() == 'any')
		{		
			if(new Date(fromValue) > new Date(ToValue))
			{
				Ext.MessageBox.show({
					title: alertLbl,
					msg: _stDateLessThanEndDateMsg,
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
			
				return false;
			}
			if(new Date(fromValue).valueOf() == new Date(ToValue).valueOf())
			{	
				if(fromHr > toHr)
				{
					Ext.MessageBox.show({
					title: alertLbl,
					msg: _stDateLessThanEndDateMsg,
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
					});
				
					return false;
				}
			}			
			if(today < new Date(fromValue) )
			{
				Ext.MessageBox.show({
					title: alertLbl,
					msg: _fromdatelesserThanMsg,
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
					});
					return false;
			}
		}
		if ( viewType =='measureGraph')
		{
			if( diffDays > 14 )
			{
				Ext.MessageBox.show({
				title: alertLbl,
				msg: _timelineTwoWeeksMsg,
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				return false;
			}
		}

		if (viewType == 'barGraph')
		{
			comboChangeURL = comboChangeURL.replace(/(priority=)[^\&]+/, '$1' + showValue);
		}
		else if (viewType == 'trendGraph')
		{
			comboChangeURL = comboChangeURL.replace(/(mode=)[^\&]+/, '$1' + modeVal);
			if (comboChangeURL.indexOf('duration') > 0)
			{
				comboChangeURL = comboChangeURL.replace(/(duration=)[^\&]+/, '$1' + durationVal);
			}
			else
			{
				comboChangeURL += '&duration='+durationVal;
			}
			if (comboChangeURL.indexOf('trendType') > 0)
			{
				comboChangeURL = comboChangeURL.replace(/(trendType=)[^\&]+/, '$1' + graphVal);
			}
			else
			{
				comboChangeURL += '&trendType='+graphVal;
			}
			//comboChangeURL += '&duration='+durationVal+'&trendType='+graphVal;
		}
		else if ( viewType =='Summarygraph')
		{
			comboChangeURL = comboChangeURL.replace(/(mode=)[^\&]+/, '$1' + modeVal);
			if (comboChangeURL.indexOf('duration') > 0)
			{
				comboChangeURL = comboChangeURL.replace(/(duration=)[^\&]+/, '$1' + encodeURIComponent(durationVal));
			}
			else
			{
				comboChangeURL += '&duration='+encodeURIComponent(durationVal);
			}
		}
		else if ( viewType =='measureGraph')
		{
			comboChangeURL = comboChangeURL.replace(/(mode=)[^\&]+/, '$1' + modeVal);
		}
		comboChangeURL = comboChangeURL.replace(/(timeline_compare=)[^\&]+/, '$1' + encodeURIComponent(timelineVal));
		comboChangeURL = comboChangeURL.replace(/(starttime=)[^\&]+/, '$1' + encodeURIComponent(fromValue));
		comboChangeURL = comboChangeURL.replace(/(starthr=)[^\&]+/, '$1' + fromHrObj.dataArray);
		comboChangeURL = comboChangeURL.replace(/(endtime=)[^\&]+/, '$1' + encodeURIComponent(ToValue));
		comboChangeURL = comboChangeURL.replace(/(endhr=)[^\&]+/, '$1' + toHrObj.dataArray);
		if (comboChangeURL.indexOf('durationChanged') > 0)
		{
			comboChangeURL = comboChangeURL.replace(/(durationChanged=)[^\&]+/, '$1' + 'false');
		}
		this.loadFullViewGraph(comboChangeURL);	
		Ext.get('net_configMod').animate({duration: 500,to: {y: -350}});
	},
	timelineSelect: function(obj)
	{
		selectedInterface=null;
		selectedParentID=null;
		var timelineVal = obj.getValue();		
		if(ciscoLastLoadedURL.indexOf("timeline") > -1)
		{
			ciscoLastLoadedURL = ciscoLastLoadedURL.replace(/(timeline=)[^\&]+/, '$1' + timelineVal);
		}
		else
		{
			ciscoLastLoadedURL += '&timeline='+timelineVal;
		}

		Ext.Ajax.request({
			url: ciscoLastLoadedURL,
			scope: this,
			async: false,
			success: function (response)
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var getMainWidth = this.getMain().getWidth(),
						getMainHeight = this.getMain().getHeight();
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					this.ciscoDefaultLoad(jsonData);
				}
			}
		});
	},
	durationComboChange: function(obj)
	{
		var durationVal = obj.getValue();
		if (comboChangeURL.indexOf('duration') > 0)
		{
			comboChangeURL = comboChangeURL.replace(/(duration=)[^\&]+/, '$1' + durationVal);
		}
		else
		{
			comboChangeURL += '&duration='+durationVal;
		}
		if (comboChangeURL.indexOf('durationChanged') > 0)
		{
			comboChangeURL = comboChangeURL.replace(/(durationChanged=)[^\&]+/, '$1' + 'true');
		}
		else
		{
			comboChangeURL +='&durationChanged=true';		
		}
		Ext.Ajax.request({
			url:comboChangeURL,
			method: 'POST',
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					var timelineValues = jsonData['timelineCombo'];
					if ( timelineValues!=null && timelineValues!=''& !Ext.isEmpty(timelineValues) )
					{
						var timelineLabel = timelineValues['monitor.dashboard.TimeLine'];
						var selectedTimelineCombo = timelineValues['selectedTimelineCombo'];						
						var TimelineComboVal = timelineValues['timelineCombo'];

						var timelineObj = Ext.getCmp('net_high_er_timeline');
						timelineObj.setFieldLabel(timelineLabel);
						timelineObj.getStore().loadRawData(TimelineComboVal);
						timelineObj.setValue(selectedTimelineCombo);
					}	
					Ext.getCmp('net_high_er_timeline').fireEvent('select',Ext.getCmp('net_high_er_timeline'));
					/*var fromData = jsonData['fromValues'];
					if ( fromData!=null && fromData!=''& !Ext.isEmpty(fromData) )
					{
						var fromlabel = fromData['monitor.VirtualDashboard.From'];
						var isFromDisabled = fromData['from'];
						var fromValue = fromData['value'];
						var fromObj = Ext.getCmp('net_high_er_stdate');
						fromObj.setFieldLabel(fromlabel);
						fromObj.setDisabled(isFromDisabled);
						fromObj.setValue(fromValue);
					}
					var startHr = jsonData['startHr'];
					if ( startHr!=null && startHr!=''& !Ext.isEmpty(startHr) )
					{
						var hrLabel = startHr['monitor.VirtualDashboard.Hr'];
						var isStartHrEnabled = startHr['isStartHrEnabled'];
						var selectedStartHr = startHr['selectedStartHr'];
						var startHrCmbo = startHr['startHrArray'];

						var startHrObj = Ext.getCmp('net_high_er_sthr');
						startHrObj.setFieldLabel(hrLabel);
						startHrObj.getStore().loadRawData(startHrCmbo);
						startHrObj.setValue(selectedStartHr);
						startHrObj.setDisabled(isStartHrEnabled);
					}
					var toValues = jsonData['toValues'];
					if ( toValues!=null && toValues!=''& !Ext.isEmpty(toValues) )
					{
						var toLabel = toValues['monitor.VirtualDashboard.To'];
						var isToDisabled = toValues['to'];
						var value = toValues['value'];
						var toObj = Ext.getCmp('net_high_er_enddate');
						toObj.setDisabled(isToDisabled);
						toObj.setFieldLabel(toLabel);
						toObj.setValue(value);
					}
					var endHr = jsonData['endHr'];
					if ( endHr!=null && endHr!=''& !Ext.isEmpty(endHr) )
					{
						var hrLabel = endHr['monitor.VirtualDashboard.Hr'];
						var isEndHrEnabled = endHr['isEndHrEnabled'];
						var selectedEndHr = endHr['selectedEndHr'];
						var endHrCmbo = endHr['endHrArray'];

						var endHrObj = Ext.getCmp('net_high_er_endhr');
						endHrObj.setFieldLabel(hrLabel);
						endHrObj.getStore().loadRawData(endHrCmbo);
						endHrObj.setValue(selectedEndHr);
						endHrObj.setDisabled(isEndHrEnabled);
					}*/
				}
			}
		});		
	},
	loadMeasureGraph: function(imgSrc,isHighChartEnabled)
	{
		var MeasurementTable_Highcharts='';
		var minMaxTableHeadersArray = '';
		var measuresTableDataArray = '';
		var fullViewContObj = Ext.getCmp('net_fullViewBarId');
		var fullViewPanelObj = Ext.getCmp('net_fullviewId');
		fullViewContObj.removeAll();
		fullViewContObj.update('');		
		if (isHighChartEnabled)
		{			
			Ext.Ajax.request({
				url:imgSrc,
				method: 'POST',
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						var tmpJsonTxt = response.responseText;						
						var chartData = Ext.decode(tmpJsonTxt);
						var errorMsg = chartData['ERROR'];
						if(errorMsg!=null && errorMsg!=undefined && !Ext.isEmpty(errorMsg) && errorMsg=='NO_DATA_FOUND')
						{
							Ext.getCmp('net_measureTableID').update('');
							fullViewContObj.update('<div class="iconInformation" style="margin:15% auto 0 auto"></div><div style="text-align:center;">'+noMeasure+'</div>');							
							fullViewPanelObj.setLoading(false);
						}
						else
						{
							MeasurementTable_Highcharts = chartData['MeasurementTable_Highcharts'];
							var minMaxTable = MeasurementTable_Highcharts['minMaxTable'];						
							if (minMaxTable!=null && minMaxTable!=''& !Ext.isEmpty(minMaxTable) && minMaxTable!=undefined)
							{
								minMaxTableHeadersArray = minMaxTable['minMaxTableHeadersArray'];
							}
							var measuresTable = MeasurementTable_Highcharts['measuresTable'];
							if (measuresTable!=null && measuresTable!=''& !Ext.isEmpty(measuresTable) && measuresTable!=undefined)
							{						
								measuresTableDataArray = measuresTable['measuresTableDataArray'];	
							}
							if ( tmpJsonTxt.indexOf('png') == -1 && tmpJsonTxt.indexOf('PNG') == -1 && tmpJsonTxt.indexOf('gif') == -1 && tmpJsonTxt.indexOf('GIF') == -1 )
							{							
								fullViewContObj.add({
									xtype: 'container',
									id: 'net_fullViewPanelHighChatrBigId',
									html : '<div id="net_high-chart-measuregraph" style="border:0px solid yellow;height:300px;"></div>',
									listeners:
									{
										'afterrender': function(thisObj)
										{
										
											try
											{											
												var lineChart = {};
												lineChart = jQuery.extend(true, {}, getHighCharts('net_high-chart-measuregraph', 345,900,''), lineChart);
												lineChart.setData(chartData,currentDateFormat,'',true,'bottom');
												lineChart.drawChart();
												fullViewPanelObj.setLoading(false);
											}
											catch (e)
											{
												alert("e::"+e)
											}
											if (!Ext.isEmpty(minMaxTableHeadersArray) && minMaxTableHeadersArray!=undefined && minMaxTableHeadersArray!=null && minMaxTableHeadersArray!='' && measuresTableDataArray!=undefined && measuresTableDataArray!=null && measuresTableDataArray!='' && !Ext.isEmpty(measuresTableDataArray))
											{
												 var str='';
												 str += '<div class="x-table" style="width:600px;margin:20px auto 0px auto;padding-bottom:0px"> '
												+ '<table cellspacing="0" cellpadding="0" border="0"  class="gridSkin x-grid-table x-grid-table-resizer">'
												+ '<thead>'
												+ '<tr class="x-grid-row">'
												+ '<th class=" x-grid-cell" style="width:50px">'
												+ '<div class="x-grid-cell-inner" style="margin-left: 12px;">'+minMaxTableHeadersArray[0]['name']+'</div>'
												+ '</th>'
												+ '<th class=" x-grid-cell x-grid-cell-first" style="width: 210px;">'
												+ '<div class="x-grid-cell-inner">'+minMaxTableHeadersArray[1]['name']+'</div>'		
												+ '</th>'
												+ '<th class=" x-grid-cell" style="width: 50px;">'
												+ '<div class="x-grid-cell-inner">'+minMaxTableHeadersArray[2]['name']+'</div>'
												+ '</th>'
												+ '<th class=" x-grid-cell" style="width: 50px;">'
												+ '<div class="x-grid-cell-inner" >'+minMaxTableHeadersArray[3]['name']+'</div>'
												+ '</th>'
												+ '<th class=" x-grid-cell" style="width: 50px;">'
												+ '<div class="x-grid-cell-inner">'+minMaxTableHeadersArray[4]['name']+'</div>'
												+ '</th>'
												+ '</tr>'
												+ '</thead>'
												+ '<tbody>';
												for ( var j = 0; j < measuresTableDataArray.length ; j++ )
												{
													var records = measuresTableDataArray[j];
													str += '<tr class="x-grid-row">'
													for (var k in records )
													{
														if (k == 'value0')
														{
															str += '<td class=" x-grid-cell x-grid-cell-first"  style="vertical-align:middle" width="50px">'
															 + '<div class="x-grid-cell-inner"  ><span id="id_colorcheck" style="display: inline-block;background:'+records[k]+';height: 10px;width: 10px;margin-left: 22px;"><span></div>'
															 + '</td>';	
														}
														else
														{
															str += '<td class=" x-grid-cell x-grid-cell-first">'
															+ '<div class="x-grid-cell-inner" >'+records[k]+'</div>'
															+ '</td>';				
														}
													}
													str += '</tr>';
												}
												str += '</tbody>'
												+ '</table>'
												+ '</div>';
												Ext.getCmp('net_measureTableID').update(str);
											}
										}
									}
								});										
							}
							else
							{
								fullViewContObj.update(tmpJsonTxt);
								fullViewPanelObj.setLoading(false);
							}
						}						
					}
					else
					{						
						fullViewContObj.update("<table border='0' height='100%' width='100%'><tr><td align='center'><img src='/final/monitor/eg_images/gray/graph_error_message.gif'></td></tr></table>");
						fullViewPanelObj.setLoading(false);
					}
				}
			});
		}
		else
		{
	        fullViewContObj.update('<table width="100%" height="360px"><tr><td align="center" valign="middle"><img src="' + imgSrc + '" border="0" /></td></tr></table>');
		fullViewPanelObj.setLoading(false);
		}	
		
	}
});