Ext.define('componentDashboard.controller.SystemController', {
    extend: 'Ext.app.Controller',
    requires:['componentDashboard.view.system.SystemTimeLine','componentDashboard.view.system.systemLowerPanel','componentDashboard.view.system.systemUpperPanel','componentDashboard.view.system.sysFullViewPanel','utilities.CustomGrid'],
   	refs:[
    		{ref:'systemlowerpanel', selector:'systemlowerpanel'},
    		{ref:'compdashdetailsMaintab', selector:'compdashdetailsMaintab'},
    		{ref:'systemupperpanel', selector:'systemupperpanel'},
    		{ref:'systemtimeline', selector:'systemtimeline'},
    		{ref:'sysfullviewpanel', selector:'sysfullviewpanel'}
    	],
    	 init: function() {
    	 	systemController=this;
	   this.control({

		   'compdashdetailsMaintab':
		   {
		   		'beforeshow': this.afterSystemPanelRendered
		   },
		   'systemupperpanel combo[id="systemsubsystem"]':
		   {
				'select': this.selectSubSystem
		   },
		   'sysfullviewpanel':
		   {
				'boxready': this.loadFullViewPanel
		   }
	   });
    },

    selectSubSystem: function( obj )
    {
		var me=this;
    	var getVal = obj.getValue();
		sysLastLoadedURL = '';		// To reset the URLs and Tabs
    	sysCurrentTabId = '';
		sysLastGraphTypeLoaded ='';
    	if ( getVal != undefined )
    	{
    		if ( getVal.toLowerCase() == 'overview' )
    		{
    			Ext.getCmp('systemOverviewpanel').show();
				Ext.getCmp('systemupperpanelId').setHeight(130);
    		}
    		else
    		{	
    			Ext.getCmp('systemupperpanelId').setHeight(35);
    			Ext.getCmp('systemOverviewpanel').hide();
    		}
    		var subsystem = Ext.getCmp('systemsubsystem').getValue();
			if ( Ext.isEmpty( subsystem ) || subsystem.length == 0 )
			{
				subsystem = 'Overview';
			}
			//	Ext.getCmp('compdashdetailsMaintab').fireEvent('beforeshow', Ext.getCmp('systemsubsystem'));
			me.afterSystemPanelRendered(Ext.getCmp('compdashdetailsMaintab'));
    	}
		//Ext.state.Manager.set('systemsubsystem', getVal);
    },
    systemDefaultLoad : function(jsonData)
    {
		if(Ext.getCmp('systemupperpanelId')==null || Ext.getCmp('systemupperpanelId')==undefined)
		{
			this.getCompdashdetailsMaintab().add(
				{
					xtype:'systemupperpanel',
					id:'systemupperpanelId',
				},
				{
					xtype:'systemlowerpanel',
					id:'systemlowerpanelId',
					margin:'10 0 10 0',
					flex:1,
				}
			);
		}

		var fullviewIdObj = Ext.getCmp('sys-fullviewId');
		if(fullviewIdObj!=null)
		{
			fullviewIdObj.destroy();
			Ext.getCmp('systemupperpanelId').show();
			Ext.getCmp('systemlowerpanelId').show();
		}
    	var isFlag = 'default';
    	me = this;
		Ext.getCmp('compdashdetailsMaintab').suspendEvents(true);
		var objectArr = new Array();
		var me = this;
		/*var subsystem = Ext.getCmp('systemsubsystem').getValue();
		if ( Ext.isEmpty( subsystem ) || subsystem.length == 0 )
		{
			subsystem = 'Overview';
		}*/
    	if ( jsonData != '' && jsonData != null && !Ext.isEmpty(jsonData))
    	{
			//systemPublicJSON = jsonData;
			var screenLabels = jsonData['screenLabels'];
			objectArr['systemsubsystem'] = screenLabels['subsystemTitle'];
			me.loadScreenLabels(objectArr);
			var subsystemCombo = jsonData['subsystemCombo'];
			var selectedValues = jsonData['selectedValues'];
			me.setValueWithOptionInList('systemsubsystem', subsystemCombo, selectedValues['subsystemSelected']);
			var subsystem = jsonData['SUBSYSTEM'];
			//publicJSON = jsonData;
			if ( subsystem != undefined )
			{
				if ( subsystem.toLowerCase() == 'overview' )
				{
					Ext.getCmp('systemOverviewpanel').show();
					Ext.getCmp('systemupperpanelId').setHeight(130);
					var overviewData = jsonData['OVERVIEW'];
					me.showOverview(overviewData);
					var getTabURL = jsonData['TAB_URL'];

					var selectedGraphType = jsonData['selectedGraphType'];
					if(selectedGraphType!=null && selectedGraphType!="" && selectedGraphType.toLowerCase()!="null")
					{
						if(selectedGraphType=="System_summaryGraph" || selectedGraphType=="System_trendGraph")
						{
							sysCurrentTabId = "System_measureGraph";
						}
						else
						{
							sysCurrentTabId = selectedGraphType;
						}
					}
					else
					{
						selectedGraphType = Ext.getCmp('systabpanel').getActiveTab().getId();
					}
					me.showTabs(getTabURL);
					var getInnerTabURL = jsonData['INNER_TAB_URL'];
					getInnerTabURL = encodeURI(getInnerTabURL);
					if ( !Ext.isEmpty( sysCurrentTabId ) )
					{
						me.loadInnerTab(sysCurrentTabId, getInnerTabURL,isFlag);
					}
					else
					{
						me.loadInnerTab(selectedGraphType, getInnerTabURL,isFlag);
					}
					var getTabName = Ext.getCmp(Ext.getCmp('systabpanel').getActiveTab().getId()).tabName;
					if ( getTabName.toLowerCase() == 'history' && isDisableTrendComputation == false)
					{
						Ext.getCmp('sys-history-tool').show();
						Ext.getCmp('sys-calendar-tool').show();
						Ext.getCmp('sys-history-tool').show();
						Ext.getCmp('sys-summary-tool').show();
						Ext.getCmp('sys-area-tool').show();
						//Ext.getCmp('sys-calendar-btn').fireEvent('loadTime', Ext.getCmp('sys-calendar-btn'));
					}
					else
					{

						Ext.getCmp('sys-history-tool').hide();
						Ext.getCmp('sys-calendar-tool').hide();
						Ext.getCmp('sys-history-tool').hide();
						Ext.getCmp('sys-summary-tool').hide();
						Ext.getCmp('sys-area-tool').hide();

					}
				}
				else
				{
					Ext.getCmp('systemOverviewpanel').hide();
					Ext.getCmp('systemupperpanelId').setHeight(35);
					var getTabURL = jsonData['TAB_URL'];
					var selectedGraphType = jsonData['selectedGraphType'];
					if(selectedGraphType!=null && selectedGraphType!="" && selectedGraphType.toLowerCase()!="null")
					{
						if(selectedGraphType=="System_summaryGraph" || selectedGraphType=="System_trendGraph")
						{
							sysCurrentTabId = "System_measureGraph";
						}
						else
						{
							sysCurrentTabId = selectedGraphType;
						}
					}
					else
					{
						selectedGraphType = Ext.getCmp('systabpanel').getActiveTab().getId();
					}
					me.showTabs(getTabURL);
					var getInnerTabURL = jsonData['INNER_TAB_URL'];
					getInnerTabURL = encodeURI(getInnerTabURL);
					if ( !Ext.isEmpty( sysCurrentTabId ) )
					{
						me.loadInnerTab(sysCurrentTabId, getInnerTabURL,isFlag);
					}
					else
					{
						me.loadInnerTab(selectedGraphType, getInnerTabURL,isFlag);
					}
					var getTabName = Ext.getCmp(Ext.getCmp('systabpanel').getActiveTab().getId()).tabName;
					if ( getTabName.toLowerCase() == 'history' && isDisableTrendComputation == false)
					{
						Ext.getCmp('sys-history-tool').show();
						Ext.getCmp('sys-calendar-tool').show();
						Ext.getCmp('sys-history-tool').show();
						Ext.getCmp('sys-summary-tool').show();
						Ext.getCmp('sys-area-tool').show();
						//Ext.getCmp('sys-calendar-btn').fireEvent('loadTime', Ext.getCmp('sys-calendar-btn'));
					}
					else
					{
						Ext.getCmp('sys-history-tool').hide();
						Ext.getCmp('sys-calendar-tool').hide();
						Ext.getCmp('sys-history-tool').hide();
						Ext.getCmp('sys-summary-tool').hide();
						Ext.getCmp('sys-area-tool').hide();
					}
				}
			}
		}
        Ext.getCmp('compdashdetailsMaintab').resumeEvents();
		var mask = null;
        var wholeViewport = document.getElementsByTagName("body")[0];
        if ( !Ext.isEmpty( Ext.get( wholeViewport ) ) )
        {
            mask = new Ext.LoadMask(Ext.get(wholeViewport), {msg:loadingLbl+"...",cls:'maskDash'});
            mask.hide();
        }
    },
    afterSystemPanelRendered : function(obj){
    	me = this;

		if(Ext.getCmp('systemupperpanelId')==null || Ext.getCmp('systemupperpanelId')==undefined)
		{
			this.getCompdashdetailsMaintab().add(
				{
					xtype:'systemupperpanel',
					id:'systemupperpanelId',
				},
				{
					xtype:'systemlowerpanel',
					id:'systemlowerpanelId',
					margin:'10 0 10 0',
					flex:1,
				}
			);
		}

		if ( Ext.getCmp('componentsDropDown') != undefined && Ext.getCmp('componentsDropDown') != null )
		{
			var getCmpVal = Ext.getCmp('componentsDropDown').getValue();
			if ( !Ext.isEmpty( getCmpVal ) )
			{
				componentType = getCmpVal.substring(0, getCmpVal.indexOf(':'));
				componentName = getCmpVal.substring(getCmpVal.indexOf(':')+1);
			}
		}
		Ext.getCmp('compdashdetailsMaintab').suspendEvents(true);
		var getApplicationPanelObj = Ext.getCmp(obj.getId());
		var getElObj = Ext.getCmp(obj.getId()).getEl();
		getElObj.mask(loadingLbl+"...", "maskCenter");
		var objectArr = new Array();
		var me = this;
		var subsystem = null;
		if(Ext.getCmp('systemsubsystem')!=null && Ext.getCmp('systemsubsystem')!=undefined)
			subsystem = Ext.getCmp('systemsubsystem').getValue();

		var serverType = componentType;
		if ( Ext.isEmpty( subsystem ) || subsystem.length == 0 )
		{
			subsystem = 'Overview';
		}

		sysLastLoadedURL = '/final/monitor/egSysDashBoardJSON.jsp?tab=System&hostName='+encodeURIComponent(requestParams.hostName)+'&compType='+encodeURIComponent(componentType)+'&subsystem='+encodeURIComponent(subsystem)+'&screenWidth=1012&screenHeight=570&host='+encodeURIComponent(requestParams.compname)+'&time_line=&starttime=&endtime=&starthr=&endhr=&format='+encodeURIComponent(dateFormatForTimeline);

		if( sysLastGraphTypeLoaded!=null && sysLastGraphTypeLoaded!=null && !Ext.isEmpty(sysLastGraphTypeLoaded) && sysLastGraphTypeLoaded!=undefined)
		{
			if( sysLastLoadedURL.indexOf('graphType') > -1 )
			{
				sysLastLoadedURL=sysLastLoadedURL.replace(/(graphType=)[^\&]+/, '$1' + sysLastGraphTypeLoaded);
			}
			else
			{
				sysLastLoadedURL += "&graphType="+sysLastGraphTypeLoaded;
			}
		}

		Ext.Ajax.request({
		   url:sysLastLoadedURL,
            method: 'POST',
			scope: this,
			success: function (response)
            {
            	if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
            	{
            		getElObj.unmask();
            		var jsonText = response.responseText;
					var jsonData = Ext.decode( jsonText );
					me.systemDefaultLoad(jsonData);
				}
            }
		});
		 Ext.getCmp('compdashdetailsMaintab').resumeEvents();
		var mask = null;
		var wholeViewport = document.getElementsByTagName("body")[0];
		if ( !Ext.isEmpty( Ext.get( wholeViewport ) ) )
		{
			mask = new Ext.LoadMask(Ext.get(wholeViewport), {msg:loadingLbl+"...",cls:'maskDash'});
			mask.hide();
		}
    },
	SystemRefreshFunc: function(jsonData)
	{
		var isFlag = 'refresh';
		var me=this;
		if ( jsonData != '' && jsonData != null && !Ext.isEmpty(jsonData))
		{
			var subsystem = Ext.getCmp('systemsubsystem').getValue();
			if ( subsystem.toLowerCase() == 'overview' )
			{
				Ext.getCmp('systemOverviewpanel').show();
				Ext.getCmp('systemupperpanelId').setHeight(130);
				var overviewData = jsonData['OVERVIEW'];
				me.showOverview(overviewData);
				var getTabName = Ext.getCmp(Ext.getCmp('systabpanel').getActiveTab().getId()).tabName;
				var getInnerTabURL = jsonData['INNER_TAB_URL'];
				getInnerTabURL = encodeURI(getInnerTabURL);
				me.loadInnerTab("System_"+sysLastGraphTypeLoaded, getInnerTabURL,isFlag);
			}
			else
			{
				Ext.getCmp('systemOverviewpanel').hide();
				Ext.getCmp('systemupperpanelId').setHeight(35);
				var getTabName = Ext.getCmp(Ext.getCmp('systabpanel').getActiveTab().getId()).tabName;
				var getInnerTabURL = jsonData['INNER_TAB_URL'];
				getInnerTabURL = encodeURI(getInnerTabURL);
				me.loadInnerTab("System_"+sysLastGraphTypeLoaded, getInnerTabURL,isFlag);
			}
		}
	},
    showOverview: function( overviewData )
	{
		var currentAlertsObj = Ext.getCmp('systemCurrentAlerts');
		var currentUptimeObj = Ext.getCmp('systemUptimeEvent');
		var sysUptime = overviewData['SYSTEM_UPTIME'];
		var timeData = overviewData['DATE_DIFF'];
		var title = overviewData['alertTitle'];
		var currentAlertArr = new Array();
		var sysUptimeArr = new Array();
		var resArr = new Array();
		currentAlertArr.push({
			xtype:'container',
			id:'alertTitleId',
			padding: '0px 0px 0px 35%',
			html: '<div class="title"><b>'+title+'</b></div>'
		});
		if(timeData != undefined && timeData!='-')
		{
			sysUptimeArr.push({
				xtype:'container',
				id:'sysUptimeDataId',
				padding: '30px 10px 0px 10px',
				html: '<div class="title"><b>'+sysUptime+'</b></div><div style="text-align:center;" class="font_bold12">'+timeData+'</div>'
			});

		}
		else if(timeData == '-')
		{
			sysUptimeArr.push({
				xtype:'container',
				id:'sysUptimeDataId',
				padding: '30px 10px 0px 10px',
				html: '<div class="title"><b>'+sysUptime+'</b></div><div style="text-align:center;"><div class="iconInformation" style="margin:0% auto 0px auto;"></div><div style="text-align:center;">'+noMeasureExcl+'</div></div>'
			});
		}

		var alertsData = overviewData['ALERTS'];
		if ( alertsData != undefined )
		{
			if ( alertsData == '-' )
			{
				var NO_ALERTS = overviewData['NO_ALERTS'];
				currentAlertArr.push({
					xtype: 'container',
					id:'noAletrsID',
					width: '100%',
					html: '<div class="iconNoalarms" style="margin:8% auto 0px auto;"></div><div style="text-align:center;">'+NO_ALERTS+'</div>'
				});
				if(timeData == undefined || timeData==' ')
				{
					sysUptimeArr.push({
					xtype: 'container',
						id:'sysUptimeId',
					width: '100%',
					html: '<div class="title"><b>'+sysUptime+'</b></div><div style="text-align:center;"><div class="iconExclamation" style="margin:5% auto 0px auto;"></div><div style="text-align:center;">'+noMeasureExcl+'</div></div>'
				});
				}
			}
			else
			{
				var openalertTitle = alertsData['OPEN_ALERT_TITLE'];
				var openAlerts = alertsData['OPEN_ALERTS'];
				var distribTitle = alertsData['DISTRIBUTION_TITLE'];
				var distribValsHTML = '';
				if ( alertsData['DISTRIBUTION_CRITICAL_VALUE'] != undefined && alertsData['DISTRIBUTION_CRITICAL_VALUE'] > 0)
				{

					var distribDesc = alertsData['DISTRIBUTION_CRITICAL_DESC'];
					var linkHTML = '';
					if ( alertsData['DISTRIBUTION_CRITICAL_LINK'] != undefined )
					{
						var linkData = alertsData['DISTRIBUTION_CRITICAL_LINK'];
						var methodName = linkData['METHOD_NAME'];
						var params = linkData['PARAMS'];
						var getParams = params.split('|');

						var genHTML = '<div style="width:100%;text-align:center;" >'+alertsData['DISTRIBUTION_CRITICAL_VALUE']+'</div>';
						distribValsHTML += '<td><div class="bar12_high" style="width:100%;text-align:center;height:12px !important">'+genHTML+'</div></td>';
					}
					else
					{
						distribValsHTML += '<td><div class="bar12_high" style="float:left;text-align:center;display:none;height:12px !important">'+alertsData['DISTRIBUTION_CRITICAL_VALUE']+'</div></td>';

					}

				}
				if ( alertsData['DISTRIBUTION_MAJOR_VALUE'] != undefined && alertsData['DISTRIBUTION_MAJOR_VALUE'] > 0)
				{
					var distribDesc = alertsData['DISTRIBUTION_MAJOR_DESC'];
					var linkHTML = '';
					if ( alertsData['DISTRIBUTION_MAJOR_LINK'] != undefined )
					{
						var linkData = alertsData['DISTRIBUTION_MAJOR_LINK'];
						var methodName = linkData['METHOD_NAME'];
						var params = linkData['PARAMS'];
						var getParams = params.split('|');
						var genHTML = '<div style="text-align:center;" >'+alertsData['DISTRIBUTION_MAJOR_VALUE']+'</div>';
						distribValsHTML += '<td><div class="bar12_intermediate" style="float:left;width:100%;text-align:center;height:12px !important">'+genHTML+'</div></td>';
					}
					else
					{
						distribValsHTML += '<td><div class="bar12_intermediate" style="display:none;float:left;width:100%;text-align:center;height:12px !important">'+alertsData['DISTRIBUTION_MAJOR_VALUE']+'</div></td>';
					}
				}
				if ( alertsData['DISTRIBUTION_MINOR_VALUE'] != undefined && alertsData['DISTRIBUTION_MINOR_VALUE'] > 0)
				{
					var distribDesc = alertsData['DISTRIBUTION_MINOR_DESC'];
					var linkHTML = '';
					if ( alertsData['DISTRIBUTION_MINOR_LINK'] != undefined )
					{
						var linkData = alertsData['DISTRIBUTION_MINOR_LINK'];
						var methodName = linkData['METHOD_NAME'];
						var params = linkData['PARAMS'];
						var getParams = params.split('|');
						var genHTML = '<div style=text-align:center;" >'+alertsData['DISTRIBUTION_MINOR_VALUE']+'</div>';
						distribValsHTML += '<td><div class="bar12_low" style="width:100%;float:left;text-align:center;height: 12px !important">'+genHTML+'</div></div></td>';
					}
					else
					{
						distribValsHTML += '<td><div class="bar12_low" style="display:none;float:left;text-align:center;height:12px !important">'+alertsData['DISTRIBUTION_MINOR_VALUE']+'</div></td>';
					}
				}
				distribValsHTML = '<table width="100%"><tr>'+distribValsHTML+'</tr></table>';
				currentAlertArr.push({
					xtype: 'container',
					layout:'column',
					columnWidth: 0.5,
					width: '100%',
					padding: 0,
					items:[
						{
							xtype: 'container',
							id:'openalertTitleId',
							width: '100%',
							padding:10,
							html:'<table width="100%" height="100%" style="margin-top:12px;"><tr><td rowspan="2"><div class="summaryOpenProblems" style="top:25px;"></td><td width="90%"><div style="float:right;margin-right:5px;" class="font_no">'+openAlerts+'</div></td></tr><tr><td><div class="font_bold12" style="float: right;margin-right:5px;" id="system-openAlerts">'+openalertTitle+'</div></td></tr><tr><td colspan="2"><div class="outer_round" style="margin-top: 5px;">'+distribValsHTML+'</div></td></tr></table>'
							//html: '<div style="text-align:right;padding:0px 5px 0 5px"><div class="summaryOpenProblems" style="position:absolute;top:22px;left:4.5%"></div><div><b><span style="font-size:23px">'+openAlerts+'</span></b></div><div id="system-openAlerts"><span style="font-size:12px;fonr-weight:bold"><b>'+openalertTitle+'</b></span></div></div>'
						}

					]
				}
			/*	{
					xtype: 'container',
					layout: 'hbox',
					padding: '0px 5px 0px 5px',
					items:[
						{
							xtype: 'container',
							id:'openalertDataId',
							width: '100%',
							//<div>'+distribTitle+'<div>
							html: '<div class="outer_round">'+distribValsHTML+'</div>'
						}

					]
				} */
				);
			}
		}
		/********************For refresh system current alert event *****************/
		if(Ext.getCmp('alertTitleId')!=null )
		{
			//alert(Ext.getCmp('alertTitleId'));
			Ext.getCmp('alertTitleId').update('<div class="title"><b>'+title+'</b></div>');
			if ( alertsData == '-' )
			{
				if(Ext.getCmp('noAletrsID')!=null)
				{
					Ext.getCmp('noAletrsID').update('<div class="iconNoalarms" style="margin:8% auto 0px auto;"></div><div style="text-align:center;">'+NO_ALERTS+'</div>');
				}
				else
				{
					currentAlertsObj.removeAll();
					currentAlertsObj.add(currentAlertArr);
					currentAlertsObj.doComponentLayout( )
				}
			}
			else
			{
				if(Ext.getCmp('openalertTitleId')!=null)
				{
					Ext.getCmp('openalertTitleId').update('<table width="100%" height="100%" style="margin-top:12px;"><tr><td rowspan="2"><div class="summaryOpenProblems" style="top:25px;"></td><td width="90%"><div style="float: right;margin-right:5px;" class="font_no">'+openAlerts+'</div></td></tr><tr><td><div class="font_bold12" style="float:right;margin-right:5px;" id="system-openAlerts">'+openalertTitle+'</div></td></tr><tr><td colspan="2"><div class="outer_round" style="margin-top:5px;">'+distribValsHTML+'</div></td></tr></table>');
					//Ext.getCmp('openalertDataId').update('<div class="outer_round">'+distribValsHTML+'</div>');
				}
				else
				{
					currentAlertsObj.removeAll();
					currentAlertsObj.add(currentAlertArr);
					currentAlertsObj.doComponentLayout( )
			  }
			}
		}
		else
		{	
			currentAlertsObj.removeAll();
			currentAlertsObj.add(currentAlertArr);
			currentAlertsObj.doComponentLayout( )
		}
		/********************For refresh system uptime event *****************/
		if(Ext.getCmp('sysUptimeDataId')!=null || Ext.getCmp('sysUptimeId')!=null)
		{
			//alert("sysUptimeDataId------>"+Ext.getCmp('sysUptimeDataId'));
			if(timeData != undefined && timeData != '-')
			{
				if(Ext.getCmp('sysUptimeDataId')!=null)
				{
					Ext.getCmp('sysUptimeDataId').update('<div class="title"><b>'+sysUptime+'</b></div><div style="text-align:center" class="font_bold12">'+timeData+'</div>');
				}
				else
				{
					currentUptimeObj.removeAll();
					currentUptimeObj.add(sysUptimeArr);
					currentUptimeObj.doComponentLayout( )
				}
			}
			else if(timeData == '-')
			{
				sysUptimeArr.push({
					xtype:'container',
					id:'sysUptimeDataId',
					padding: '30px 10px 0px 10px',
					html: '<div class="title"><b>'+sysUptime+'</b></div><div style="text-align:center;"><div class="iconInformation" style="margin:0% auto 0px auto;"></div><div style="text-align:center;">'+noMeasureExcl+'</div></div>'
				});
			}
			else
			{
				if(Ext.getCmp('sysUptimeId')!=null)
				{
					Ext.getCmp('sysUptimeId').update('<div class="title"><b>'+sysUptime+'</b></div><div style="text-align:center;"><div class="iconInformation" style="margin:5% auto 0px auto;"></div><div style="text-align:center;">No data Found</div></div>');
				}
				else
				{
					currentUptimeObj.removeAll();
					currentUptimeObj.add(sysUptimeArr);
					currentUptimeObj.doComponentLayout( )
				
				}
			}
		}
		else
		{
			currentUptimeObj.removeAll();
			currentUptimeObj.add(sysUptimeArr);
			currentUptimeObj.doComponentLayout( )
		}
		/**********To Load Current Events *************/

		var currentEvents = overviewData['EVENTS'];
		var eventCriticalPageUrl = overviewData['eventUrl1'];
		var eventMajorPageUrl = overviewData['eventUrl2'];
		var eventMinorPageUrl = overviewData['eventUrl3'];
		var eventsTitle = currentEvents['eventsTitle'];
		if ( eventsTitle == undefined && currentEvents == '-' )
		{
			eventsTitle = overviewData['eventsTitle'];
		}
		var currenEventsObj = Ext.getCmp('systemCurrentEvents');
		var currentEventArr = new Array();
		currentEventArr.push({
			xtype: 'container',
			id:'eventsTitleId',
			width: '100%',
			html: '<div class="title"><b>'+eventsTitle+'</b></div>'
		});
		if ( currentEvents != undefined )
		{
			if ( currentEvents == '-' )
			{
				var NO_EVENTS = overviewData['NO_EVENTS'];
				currentEventArr.push({
					xtype: 'container',
					id:'NO_EVENTS_Id',
					width: '100%',
					html: '<div class="iconNoalarms" style="margin:2% auto 0px auto"></div><div style="text-align:center;">'+NO_EVENTS+'</div>'
				});
			}
			else
			{
				//var swfPath = currentEvents['SWF_PATH'];
				//var xmlData = currentEvents['XML_DATA'];
				var distribEvtsHTML = '';
				var criticalEvtCount = currentEvents['criticalEvtCount'];
				var majorEvtCount = currentEvents['majorEvtCount'];
				var minorEvtCount = currentEvents['minorEvtCount'];
				if (criticalEvtCount != undefined && criticalEvtCount > 0)
				{
					if (eventCriticalPageUrl!=undefined)
					{
						var genHTML = '<div onclick="javascript:goToAlarmHistory(\''+eventCriticalPageUrl+'\');" style="text-align:center;cursor:pointer" >'+criticalEvtCount+'</div>';
						distribEvtsHTML += '<td><div class="bar12_high" style="text-align:center;color:#ffffff;height:12px !important">'+genHTML+'</div></td>'
					}
					else
					{
						distribEvtsHTML += '<td><div class="bar12_high" style="float:left;width:24px;text-align:center;display:none;height:12px !important">'+criticalEvtCount+'</div></td>';
					}
				}
				if (majorEvtCount != undefined && majorEvtCount > 0)
				{
					if(eventMajorPageUrl!=undefined)
					{
						var genHTML = '<div onclick="javascript:goToAlarmHistory(\''+eventMajorPageUrl+'\');" style="text-align:center;cursor:pointer" >'+majorEvtCount+'</div>';
						distribEvtsHTML += '<td><div class="bar12_intermediate" style="text-align:center;color:#ffffff;height: 12px !important">'+genHTML+'</div></td>'
					}
					else
					{
						distribEvtsHTML += '<td><div class="bar12_intermediate" style="float:left;width:24px;text-align:center;display:none;height:12px !important">'+majorEvtCount+'</div></td>';
					}
				}
				if (minorEvtCount != undefined && minorEvtCount > 0)
				{
					if (eventMinorPageUrl!=undefined)
					{
						var genHTML = '<div onclick="javascript:goToAlarmHistory(\''+eventMinorPageUrl+'\');" style="text-align:center;cursor:pointer" >'+minorEvtCount+'</div>';
						distribEvtsHTML += '<td><div class="bar12_low" style="text-align:center;color:#ffffff;height:12px !important">'+genHTML+'</div></td>'
					}
					else
					{
						distribEvtsHTML += '<td><div class="bar12_low" style="float:left;width:24px;text-align:center;display:none;height:12px !important">'+minorEvtCount+'</div></td>';
					}
				}
				distribEvtsHTML = '<table width="100%"><tr>'+distribEvtsHTML+'</tr></table>';
				//var dataArray = new Array();
				//dataArray[dataArray.length] = swfPath;
				//dataArray[dataArray.length] = xmlData;
				var totalEventsTitle = currentEvents['monitor.dashboard.Total Events'];
				var totalEvents = currentEvents['TOTAL_EVENTS'];
				var avgDurationTitle = currentEvents['monitor.dashboard.Avg Duration'];
				var avgDuration = currentEvents['AVG_DURATION'];
				var maxDurationTitle = currentEvents['monitor.dashboard.Max Duration'];
				var maxDuration = currentEvents['MAX_DURATION'];

				currentEventArr.push({
					xtype: 'container',
					id:'currentEventsId',
					layout: {
						type: 'hbox',
						align: 'stretch'
					},
					defaults:{
						height:79
					},
					width: '100%',
					items:[
						{
							xtype: 'container',
							flex:.5,
							cls:'fancy_border',							
							height:86,
							items:[
								{
									xtype: 'container',
									id:'distribEvtsHTMLId',
									//width: '100%',
									padding:10,
									html: '<table width="100%" height="100%" style="margin-top:12px;"><tr><td rowspan="2"><div class="totalEvents" style="top:25px;"></td><td width="90%"><div style="float:right;margin-right:5px;" class="font_no">'+totalEvents+'</div></td></tr><tr><td><div  class="font_bold12" style="float:right;margin-right:5px">'+totalEventsTitle+'</div></td></tr><tr><td colspan="2"><div class="outer_round" style="margin-top:5px;">'+distribEvtsHTML+'</div></td></tr></table>'
								}]
						},

					/*	{
							xtype: 'container',
							layout: 'vbox',
							cls:'fancy_border',
							flex:2,

							items:[
								{
									xtype: 'container',
									id:'totalEventsId',
									width: '100%',
									style:{'text-align':'right','padding':'0 12px 0 12px'},
									html: '<div><div class="totalEvents" style="position:absolute;top:40px;"></div><div class="font_no" style="margin:12px 0 14px 0px;">'+totalEvents+'</div><div class="font_bold">'+totalEventsTitle+'</div></div>'
								}

							]
						}, */

						{
							xtype: 'container',
							cls:'fancy_border',
							layout: 'vbox',
							flex:.25,
							items:[
								{
									xtype: 'container',
									id:'avgDurationId',
									width: '95%',
									style:{'text-align':'right','padding':'5 12px 5 12px'},
									html: '<div><div class="summaryAverageDuration" style="position:absolute;top:30px;"></div><div class="font_no" style="margin:18px 0 14px 0px;">'+avgDuration+'</div><div class="font_bold">'+avgDurationTitle+'</div></div>'
								}

							]
						},

						{
							xtype: 'container',
							cls:'fancy_border last',
							layout: 'vbox',
							flex:.25,
							items:[
								{
									xtype: 'container',
									id:'maxDurationId',
									width: '95%',
									style:{'text-align':'right','padding':'5 12px 5 12px'},
									html: '<div><div class="summaryMaximumDuration" style="position:absolute;top:30px;left: 10px;"></div><div class="font_no" style="margin:18px 0 14px 0px;">'+maxDuration+'</div><div class="font_bold">'+maxDurationTitle+'</div></div>'
								}

							]
						}
					]
				});
			}
		}

		/*********** To load History of events *************/
		if(Ext.getCmp('eventsTitleId')!=null)
		{
			//alert(Ext.getCmp("eventsTitleId"));
			Ext.getCmp('eventsTitleId').update('<div class="title"><b>'+eventsTitle+'</b></div>');
			if ( currentEvents == '-' )
			{
				if(Ext.getCmp('NO_EVENTS_Id')!=null)
				{
					Ext.getCmp('NO_EVENTS_Id').update('<div class="iconNoalarms" style="margin:2% auto 0px auto"></div><div style="text-align:center;">'+NO_EVENTS+'</div>');
				}
				else
				{
					currentEventArr.push({
					xtype: 'container',
					id:'NO_EVENTS_Id',
					width: '100%',
					html: '<div class="iconNoalarms" style="margin:2% auto 0px auto"></div><div style="text-align:center;">'+NO_EVENTS+'</div>'
					});
					currenEventsObj.removeAll();
					currenEventsObj.add(currentEventArr);
					currenEventsObj.doComponentLayout( );
				}
			}
			else
			{
				if(Ext.getCmp('distribEvtsHTMLId')!=null  && Ext.getCmp('avgDurationId')!=null && Ext.getCmp('maxDurationId')!=null)
				{
					Ext.getCmp('distribEvtsHTMLId').update('<table width="100%" height="100%" style="margin-top: 12px;"><tr><td rowspan="2"><div class="totalEvents" style="top:25px;"></td><td width="90%"><div style="float:right;margin-right:5px" class="font_no">'+totalEvents+'</div></td></tr><tr><td><div class="font_bold12" style="float:right;margin-right:5px;">'+totalEventsTitle+'</div></td></tr><tr><td colspan="2"><div class="outer_round" style="margin-top:5px;">'+distribEvtsHTML+'</div></td></tr></table>');
					//Ext.getCmp('totalEventsId').update('<div><div class="totalEvents" style="position:absolute;top:40px;"></div><div class="font_no" style="margin:12px 0 14px 0px;">'+totalEvents+'</div><div class="font_bold">'+totalEventsTitle+'</div></div>');
					Ext.getCmp('avgDurationId').update('<div><div class="summaryAverageDuration" style="position:absolute;top:30px;"></div><div class="font_no" style="margin:18px 0 14px 0px;">'+avgDuration+'</div><div class="font_bold">'+avgDurationTitle+'</div></div>');
					Ext.getCmp('maxDurationId').update('<div><div class="summaryMaximumDuration" style="position:absolute;top:30px;left: 10px;"></div><div class="font_no" style="margin:18px 0 14px 0px;">'+maxDuration+'</div><div class="font_bold">'+maxDurationTitle+'</div></div>');
				}
				else
				{
					currenEventsObj.removeAll();
					currenEventsObj.add(currentEventArr);
					currenEventsObj.doComponentLayout( );
				}
			}
		}
		else
		{
			
			currenEventsObj.removeAll();
			currenEventsObj.add(currentEventArr);
			currenEventsObj.doComponentLayout( );
		}

	/*	var getEvenContObj = Ext.getCmp('sys-eventChartContainer');
		if ( getEvenContObj != undefined )
		{
			var getDataArray = getEvenContObj.dataArray;

			var swfPath = getDataArray[0];
			var xmlData = getDataArray[1];

			if ( xmlData != undefined )
			{
				if ( FusionCharts('sys-currentEventsChart') )
				{
					FusionCharts('sys-currentEventsChart').dispose();
				}
				var myChart = new FusionCharts(swfPath,'sys-currentEventsChart', '100%', '100%','0','1');

				myChart.setXMLData(xmlData);
				myChart.setTransparent(true);
				myChart.render('sys-barChart');
			}
		}*/
	},
   setValueWithOptionInList : function(fieldName, list, value)
	{
		if(Ext.getCmp(fieldName)!=null && Ext.getCmp(fieldName)!=undefined)
		{
			if ( !Ext.isEmpty( list) )
			{
				Ext.getCmp(fieldName).getStore().loadRawData(list);
			}
			Ext.getCmp(fieldName).suspendEvents(false);
			if( !Ext.isEmpty(value) )
			{
				Ext.getCmp(fieldName).setValue(value);
			}
			else
			{
				Ext.getCmp(fieldName).setValue(list[0].valueField);
			}
			Ext.getCmp(fieldName).resumeEvents();
		}
	},
 loadScreenLabels: function ( ObjectArr )
	{
		for ( var key in ObjectArr )
		{
			if ( Ext.getCmp(key) != undefined )
			{
				Ext.getCmp(key).setFieldLabel(ObjectArr[key]);
			}
		}
	},
	showTabs: function( URL )
	{
		var isFlag = 'default';
		var subSystemVal = Ext.getCmp('systemsubsystem').getValue();
		var me = this;
		var subSystemtabObj = this.getSystemlowerpanel();
		var subSystemtabEl = subSystemtabObj.getEl();
		subSystemtabEl.mask(loadingLbl+"...", "maskCenter");
		subSystemtabObj.removeAll();
		var jsonText = '', jsonData = '';
		var tabs = new Array();
		Ext.Ajax.request({
			url: URL,
			method: 'GET',
			async: false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					subSystemtabEl.unmask();
					jsonText = response.responseText;
					jsonData = Ext.decode( jsonText );
					tabs = jsonData['tabs'];
				}
			},
			failure: function()
			{
				alert('Failure...');
			}
		});
		var tabArr = new Array();
		if ( !Ext.isEmpty( tabs ) )
		{
			for ( var i = 0; i < tabs.length; i++ )
			{
				var tmpTab = tabs[i];
				var tabName = tmpTab['TAB_NAME'];
				var tabTitle = tmpTab['TAB_MAPPING_NAME'];
				var methodName = tmpTab['METHOD_NAME'];
				var params = tmpTab['PARAMS'];
				var no_params = params.split('|');
				var tabId = tmpTab['TAB_ID'];
				var no_params = params.split('|');

				var getTmpTimelineData = jsonData['TimelineWindow'];
				timelineVals['timeline'] = getTmpTimelineData[0]['selected'];
				timelineVals['starttime'] = getTmpTimelineData[1]['value'];
				timelineVals['starthour'] = getTmpTimelineData[2]['selected'];
				timelineVals['endtime'] = getTmpTimelineData[3]['value'];
				timelineVals['endhour'] = getTmpTimelineData[4]['selected'];

				tabArr.push({
					title: tabTitle,
					id: tabId,
					tabName: tabName,
					dataArray: tmpTab,
					xtype: 'container',
					layout: 'vbox',
					listeners:
					{
						'beforeshow': function()
						{
							if ( Ext.get('sys-configModApp') != undefined ) // ensure sys-configModApp is close before show tab panel
							{
								Ext.get('sys-configModApp').destroy();
							}
							var tmpDataArray = this.dataArray;
							var URL = '';
							if ( tmpDataArray['TAB_NAME'].toLowerCase() == 'at-a-glance' )
							{
								if ( subSystemVal.toLowerCase() == 'overview' )
								{
									URL = "/final/monitor/egDashboardOverviewJSON.jsp";
									URL += "?"+"hostName="+encodeURIComponent(componentName)+"&compType="+encodeURIComponent(componentType)+"&tab=System"
								}

								me.loadInnerTab(tmpDataArray['TAB_ID'], URL,isFlag);
							}
							else if ( tmpDataArray['TAB_NAME'].toLowerCase() == 'details' || tmpDataArray['TAB_NAME'].toLowerCase() == 'comparison' )
							{
								var timelineData = jsonData['TimelineWindow'];
									var timeline = timelineData[0]['selected'];
									var starttime = timelineData[1]['value'];
									var starthour = timelineData[2]['selected'];
									var endtime = timelineData[3]['value'];
									var endhour = timelineData[4]['selected'];
									URL = '/final/monitor/egDashboardHistoryJSON.jsp';
									var no_params= tmpDataArray['PARAMS'].split('|');
								me.loadInnerTab(tmpDataArray['TAB_ID'], URL+'?tab=System&hostName='+encodeURIComponent(componentName)+'&compType='+encodeURIComponent(componentType)+'&subsystem='+encodeURIComponent(Ext.getCmp('systemsubsystem').getValue())+'&graphType='+encodeURIComponent(no_params[2])+'&showGraph='+encodeURIComponent(no_params[2])+'&time_line=&starttime='+encodeURIComponent(starttime)+'&endtime='+encodeURIComponent(endtime)+'&starthr='+encodeURIComponent(starthour)+'&endhr='+encodeURIComponent(endhour)+'&format='+encodeURIComponent(dateFormatForTimeline)+'&host='+encodeURIComponent(componentName),isFlag);
							}
							else if ( tmpDataArray['TAB_NAME'].toLowerCase() == 'history' )
							{
								var timelineData = jsonData['TimelineWindow'];
									var timeline = timelineData[0]['selected'];
									var starttime = timelineData[1]['value'];
									var starthour = timelineData[2]['selected'];
									var endtime = timelineData[3]['value'];
									var endhour = timelineData[4]['selected'];
									URL = '/final/monitor/egDashboardHistoryJSON.jsp';
									var no_params= tmpDataArray['PARAMS'].split('|');
								me.loadInnerTab(tmpDataArray['TAB_ID'], URL+'?tab=System&hostName='+encodeURIComponent(componentName)+'&compType='+encodeURIComponent(componentType)+'&subsystem='+encodeURIComponent(Ext.getCmp('systemsubsystem').getValue())+'&graphType='+encodeURIComponent(no_params[2])+'&showGraph='+encodeURIComponent(no_params[2])+'&time_line=&starttime='+encodeURIComponent(starttime)+'&endtime='+encodeURIComponent(endtime)+'&starthr='+encodeURIComponent(starthour)+'&endhr='+encodeURIComponent(endhour)+'&format='+encodeURIComponent(dateFormatForTimeline)+'&host='+encodeURIComponent(componentName),isFlag);
							}

						}
					}
				});
			}
		}
		if ( !Ext.isEmpty( tabArr ) )
		{
			subSystemtabObj.add({
				xtype: 'scrolltabPanel',
				id: 'systabpanel',
				dataArray: URL,
				//scroll:true,
				//autoScroll: true,
				//overflowX:'hidden',
				//overflowY:'auto',
				name: 'systabpanel',
				flex:1,
				layout:
				{
					type: 'fit',
					//align: 'stretch'
				},
				plain: false,
				
				border: false,
				frame: false,
				defaults:{

					border:true,
					frame:true
				},
				activeTab:sysCurrentTabId,
				listeners:{

					render: function()
					{
						var getId = '';
						this.items.each(function(obj)
						{

							obj.tab.on('click', function()
			                {
			                	getId = obj.id;
								sysCurrentTabId = getId;
								
			                    if ( obj.tabName.toLowerCase() == 'history' && isDisableTrendComputation == false)
			                    {
			                    	Ext.getCmp('sys-history-tool').show();
			                    	Ext.getCmp('sys-calendar-tool').show();
			                    	Ext.getCmp('sys-history-tool').show();
			                    	Ext.getCmp('sys-summary-tool').show();
			                    	Ext.getCmp('sys-area-tool').show();
			                    }
			                    else
			                    {
			                    	Ext.getCmp('sys-history-tool').hide();
			                    	Ext.getCmp('sys-calendar-tool').hide();
			                    	Ext.getCmp('sys-history-tool').hide();
			                    	Ext.getCmp('sys-summary-tool').hide();
			                    	Ext.getCmp('sys-area-tool').hide();
			                    }
								//sysCurrentTabId.doComponentLayout();
			                }

							);
			            });
						this.tabBar.add(
							{
								xtype:'tbfill',
								id: 'sys-tab-seperator'
							},
							{
								xtype: 'toolbar',
								width:27,
								hidden: true,
								layout:'hbox',
								ui:'footer',
								id: 'sys-calendar-tool',
								cls:'iconBg',
								height:21,
								margin:'0 50 0 0',
								dock: 'right',
								items:[
									{
										xtype: 'button',
										iconCls:'iconCalendar',
										id: 'sys-calendar-btn',
										hidden:true,
										//tooltip:'Calendar',
										handler: function()
										{
											Ext.get('sys-configModApp').animate({to: {'top':11},listeners:{ afteranimate:function(){  Ext.get('sys-configModApp').setStyle('left', '');}}}).show();
										},
										listeners:
										{
											afterrender: function () {
												Ext.create('Ext.tip.ToolTip', {
													target: this.id,
													anchor: 'top',
													cls: 'yellowTip',
													trackMouse: true,
													html: 'Calendar'
												});
											},
											'click': function()
											{
												var SysConfigModObj = Ext.get('sys-configModApp');

												if (Ext.isEmpty(SysConfigModObj))
												{
													var tpl = new Ext.XTemplate('<div style="float:left;margin:4px 0px 0px 4px"><b>'+defSettingsLbl+'</b></div><div style="text-align:right;float:right;"><div class="iconClose3" id="sys-closeSettingsApp"></div></div>');

													Ext.create('Ext.container.Container',
													{
														width: 530,
														id:'sys-configModApp',
														cls:'configMode_popup',
														closeAction:'hide',
														padding:5,
														style:{'position':'absolute'},
														items:[
															{
																xtype:'container',
																cls:'configMode_popupArrow',
																style:{'top':'-14px','left':'400px'}
															},
															{
																xtype:'container',
																html:tpl.apply(),
																style:{'top':'0px','margin':'2px'}
															},{
																xtype:'systemtimeline',
																//width:530,
																height:60
															}
														],
														renderTo: 'systabpanel-body'
													});
												}
												else
												{
													SysConfigModObj.show();
												}

												Ext.getBody().on('click',function()
												{
													var configobj = Ext.get('sys-configModApp');
													if ( configobj != null && configobj != undefined )
													{
														configobj.hide();
													}
													configobj.animate({duration: 500,to: {y: -500}});
												},null,{delegate:'#sys-closeSettingsApp'});
												Ext.Ajax.request({
													url: URL,
													method: 'GET',
													async: false,
													success: function( response )
													{
														if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
														{
															var tmpJsonText = response.responseText;
															var tmpJsonData = Ext.decode( tmpJsonText );
															var timelineData = tmpJsonData['TimelineWindow'];
															var timeline = timelineData[0]['selected'];
															var starttime = timelineData[1]['value'];
															var starthour = timelineData[2]['selected'];
															var endtime = timelineData[3]['value'];
															var endhour = timelineData[4]['selected'];

															var erTimelineObj = Ext.getCmp('sys_er_timeline');
															erTimelineObj.getStore().loadRawData(timelineData[0]['items']);
															var selTimeline = erTimelineObj.getValue();
															var startTimeObj = Ext.getCmp('sys_er_stdate');
															var endTimeObj = Ext.getCmp('sys_er_enddate');
															var startHrObj = Ext.getCmp('sys_er_sthr');
															var endHrObj = Ext.getCmp('sys_er_endhr');
															if(selTimeline!=null && selTimeline!="")
															{
																erTimelineObj.setValue(selTimeline);
																var startTimeVal = startTimeObj.getValue();
																var endTimeVal = endTimeObj.getValue();
																var startHrVal = startHrObj.getValue();
																var endHrVal = endHrObj.getValue();

																startTimeObj.setValue(startTimeVal);
																endTimeObj.setValue(endTimeVal);
																startHrObj.setValue(startHrVal);
																endHrObj.setValue(endHrVal);
															}
															else
															{
																erTimelineObj.setValue(timeline);
																startTimeObj.setValue(starttime);
																endTimeObj.setValue(endtime);
																startHrObj.setValue(starthour);
																endHrObj.setValue(endhour);
															}

														}
													}
												});
											},
												'afterrender': function( obj )
											{
												obj.addListener('loadTime');
												Ext.create('Ext.tip.ToolTip', {
																	target: this.id,
																	anchor: 'top',
																	cls: 'yellowTip',
																	trackMouse: true,
																	html: 'Calendar'
																});
											}
										}
									}
								]
							},
							{
								xtype: 'toolbar',
								id: 'sys-history-tool',
								hidden: true,
								ui:'footer',
								layout:'hbox',
								//width: 27,
								cls: 'iconBg',
								height: 21,
								//margin: '0 0 0 0',
								dock: 'right',
								items: [
									{
										xtype: 'button',
										id: 'sys-history-bar',
										iconCls: 'iconLineChart',
									//	tooltip:'History View',
										listeners:{
											afterrender: function () {
																Ext.create('Ext.tip.ToolTip', {
																	target: this.id,
																	anchor: 'top',
																	cls: 'yellowTip',
																	trackMouse: true,
																	html: historyViewText
																});
															}
										},
										handler: function()
										{
											me.callView('measureGraph');
										}
									},
									{
										  xtype: 'tbseparator',
											margin:'0 3 0 3'
									}
								]
							},

							{
								xtype: 'toolbar',
								//width: 27,
								layout:'hbox',
								ui:'footer',
								cls: 'iconBg',
								hidden: true,
								id: 'sys-summary-tool',
								height: 21,
								//margin: '0 5 0 5',
								dock: 'right',
								items: [
									{
										xtype: 'button',
										iconCls: 'iconBarChart',
										//tooltip:'Summary View',
										listeners:{
											afterrender: function () {
																Ext.create('Ext.tip.ToolTip', {
																	target: this.id,
																	anchor: 'top',
																	cls: 'yellowTip',
																	trackMouse: true,
																	html: summaryViewText
																});
															}
										},
										handler: function()
										{
											me.callView('summaryGraph');
										}
									},{
										  xtype: 'tbseparator',
											margin:'0 3 0 3'
									}
								]
							},

							{
								xtype: 'toolbar',
								//width: 27,
								ui:'footer',
								hidden: true,
								id: 'sys-area-tool',
								cls: 'iconBg',
								height: 21,
								margin: '0 0 0 0',
								dock: 'right',
								items: [
									{
										xtype: 'button',
										iconCls: 'iconAreaChart',
										//tooltip:'Trend View',
										listeners:{
											afterrender: function () {
																Ext.create('Ext.tip.ToolTip', {
																	target: this.id,
																	anchor: 'top',
																	cls: 'yellowTip',
																	trackMouse: true,
																	html: trendViewText
																});
															}
										},
										handler: function()
										{
											me.callView('trendGraph');
										}
									}
								]
							});
					},

					'click': function()
					{
						alert('I am clicking...');
					}
				},
				items: tabArr
			});
		}
		//subSystemtabObj.doLayout( );
		subSystemtabObj.show();
	},
	loadInnerTab: function( tabId, URL ,isFlag)
	{
		if(tabId == 'System_trendGraph' || tabId == 'System_summaryGraph' )
		{
			tabId='System_measureGraph';
		}

		var subsystem = Ext.getCmp('systemsubsystem').getValue();
		var me = this;
		var getEl = Ext.getCmp(tabId).getEl();
		var getTabObj = Ext.getCmp(tabId);
		getTabObj.setAutoScroll(true);
		if(isFlag == 'default')
		{
			getTabObj.removeAll();
		}
		var defaultHeight = 0;
		if ( !Ext.isEmpty( subsystem ) && subsystem.toLowerCase() != 'overview' )
		{
			//defaultHeight = 133;
		}
		//getTabObj.setHeight((Ext.getBody().getHeight()-240)+defaultHeight);
		var getDataArray = getTabObj.dataArray;
		var tabName = getDataArray['TAB_NAME'];
		var jsonText = '', jsonData = '';
		if(!Ext.isEmpty(getEl)){
		getEl.mask(loadingLbl+"...","maskCenter");
		}
		Ext.Ajax.request({
			url: URL+'&screenWidth='+(Ext.getBody().getViewSize().width)+'&screenHeight='+(Ext.getBody().getViewSize().height),
			method: 'POST',
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					jsonText = response.responseText;
					getEl.unmask();
					jsonData = Ext.decode( jsonText );
					sysgraphUrl = jsonData['hiddens'];

					if ( tabName.toLowerCase() == 'at-a-glance' )
					{
						if ( subsystem.toLowerCase() == 'overview' )
						{
							me.showAtAGlance( tabId, jsonData ,isFlag);
						}
					}
					else if ( tabName.toLowerCase() == 'details' || tabName.toLowerCase() == 'comparison' )
					{
						me.showDetailsTab( tabId, jsonData,isFlag );
					}
					else if ( tabName.toLowerCase() == 'history' )
					{
						me.showHistoryTab( tabId, jsonData ,isFlag);
					}
				}
			}
		});
	},

	showDetailsTab: function( tabId, resultData ,isFlag )
	{
		var detailsObj = Ext.getCmp(tabId);
		detailsObj.setAutoScroll(true);
		
		if(isFlag == 'default')
		{
			detailsObj.removeAll();
			detailsObj.add({
			xtype: 'container',
			id: 'sys_details-outer-panel',
			width: '100%',
			//autoScroll: true,
			margin:'10 10 10 10',
			layout:{
				type: 'column',
				//align: 'stretch'
			},
			defaults:{
				columnWidth: 0.333,
				height:250,
				cls:'datapanel optionalListPanel'
				}
			});
			detailsObj.doComponentLayout( );
		}
		
		var defaultHeight = 0;
		var subSystemVal = Ext.getCmp('systemsubsystem').getValue();
		
		if ( !Ext.isEmpty( subSystemVal ) && subSystemVal.toLowerCase() != 'overview' )
		{
			//defaultHeight = 133;
		}
		
		//var tmpHeight = detailsObj.getHeight();
		//detailsObj.setAutoScroll(true);
		var outerChartArr = new Array();
	
		var outerObj = Ext.getCmp('sys_details-outer-panel');
		
		outerObj.removeAll();
		
		var chartsData = resultData['CHARTS'];
		var sysSummary = resultData['DISK_SUMMARY'];
		var sysHistory = resultData['DISK_HISTORY'];
		var diskESX = resultData['DISK_ESX'];

		var hopDelayData = resultData['detailHopArr'];
		if ( !Ext.isEmpty( chartsData ) )
		{
			if ( chartsData['NO_CHARTS'] != undefined && chartsData['NO_CHARTS'] == 'true' )
			{
				
				if(subSystemVal == 'Overview') 
				{
					var cheight=Ext.getBody().getViewSize().height-260;	
				}
				else
				{
					var cheight=Ext.getBody().getViewSize().height-150;	
				}
				var getMsg = chartsData['NO_CHARTS_MSG'];
				outerChartArr.push({
					xtype: 'container',
					height:cheight,					
					width: '100%',
					border:true,
					frame:false,
					width: '100%',
					columnWidth:1.0,
					style:{'text-align':'center'},
					html :'<table width="100%" height="100%"><tr><td align="center"><div class="iconInformation"></div>'+getMsg+' </td></tr></table>'
				});

				//outerObj.add(outerChartArr);
				//outerObj.doComponentLayout( );
			}
			else
			{
				var chartArr = new Array();

				for ( var i = 0; i < chartsData.length; i++ )
				{
					var chartData = chartsData[i];
					var ddGraphUrlLarge = chartsData[i]['ddGraphUrlLarge'];
					var tmpHeight = chartData['HEIGHT'];
					var tmpWidth = chartData['WIDTH'];
					outerChartArr.push({
						xtype: 'container', // Detail chart
						cls:'datapanel optionalListPanel',
						//style:{'border':'1px solid blue'},
						id: 'sys_bar-container-'+i,
						dataArray: chartData,
						max:ddGraphUrlLarge,
						chartCnt : i,
						width : tmpWidth,
						height : parseInt(tmpHeight),
						autoScroll : false,
						scroll : false,
						margin:'5',
						html:'<div id="sys-barChart'+i+'" style="border 1px solid red;cursor:pointer;width:'+tmpWidth+'px;height:'+tmpHeight+'px"></div>',
						listeners : {
							'afterrender' : function()
							{
									try
									{
										//var barGraphHeight=this.dataArray['XML_DATA']['barGraphHeight'];
										Ext.get("sys-barChart"+this.chartCnt).setHeight(tmpHeight-3);
										var barGraphHeight=Ext.get('sys-barChart'+this.chartCnt).getHeight();
										var barGraphWidth=Ext.get('sys-barChart'+this.chartCnt).getWidth();
										var barChart = {};
										barChart = jQuery.extend(true, {}, getHighChartsBarInstance('sys-barChart'+this.chartCnt, barGraphHeight,barGraphWidth), barChart);
										var maxUrl=this.dataArray['ddGraphUrlLarge'];
										barChart.setData(this.dataArray['XML_DATA'], currentDateFormat, maxUrl,'bar');
										barChart.drawChart();
									}
									catch (barChartEx)
									{
										console.log(barChartEx);
									}
							},
							'resize': function()
							{
									try
									{
										//var barGraphHeight=this.dataArray['XML_DATA']['barGraphHeight'];
										Ext.get("sys-barChart"+this.chartCnt).setHeight(tmpHeight-3);
										var barGraphHeight=Ext.get('sys-barChart'+this.chartCnt).getHeight();
										var barGraphWidth=Ext.get('sys-barChart'+this.chartCnt).getWidth();
										var barChart = {};
										barChart = jQuery.extend(true, {}, getHighChartsBarInstance('sys-barChart'+this.chartCnt, barGraphHeight,barGraphWidth), barChart);
										var maxUrl=this.dataArray['ddGraphUrlLarge'];
										barChart.setData(this.dataArray['XML_DATA'], currentDateFormat, maxUrl,'bar');
										barChart.drawChart();
									}
									catch (barChartEx)
									{
										console.log(barChartEx);
									}
							}
						}
					});
				}
			}
		}

		var hopDelayArr = new Array();
		if(!Ext.isEmpty(hopDelayData))
		{
			var hopDelayDatas = hopDelayData[0];
			var title = hopDelayDatas['TABLETITLE'];
			var type = hopDelayDatas['TYPE'];
			var emptyMsg = hopDelayDatas['Msg'];
			if( emptyMsg!='true')
			{
				var delayCont = {
				xtype: 'container',
				width: '100%',
				html: '<div>'+title+'<table border="1"><tr><th>'+hopDelayDatas['COLUMN_0']+'</th><th>'+hopDelayDatas['COLUMN_1']+'</th><th>'+hopDelayDatas['COLUMN_2']+'</th><th>'+hopDelayDatas['COLUMN_3']+'</th><th>'+hopDelayDatas['COLUMN_4']+'</th></tr><tr><td align="center">'+hopDelayDatas['COLUMN_0_val']+'</td><td align="center">'+hopDelayDatas['COLUMN_1_val']+'</td><td align="center">'+hopDelayDatas['COLUMN_2_val']+'</td><td align="center">'+hopDelayDatas['COLUMN_3_val']+'</td><td style="width:300px;padding:0px; height:24px" align="center"><table  cellpadding="1" cellpadding="0" border="0"  style="table-layout:fixed;width:150px;height:20px" class="hop"><tr><td align="center">'+hopDelayDatas['COLUMN_4_val_0']+'</td><td align="center">'+hopDelayDatas['COLUMN_4_val_1']+'</td><td align="center">'+hopDelayDatas['COLUMN_4_val_2']+'</td></tr>	</table></td>			</table></div>'
				}
			}
			outerObj.add(delayCont);
			//outerObj.doComponentLayout( );
		}
		if ( !Ext.isEmpty( sysSummary ) )
		{
				var title = sysSummary['TITLE'];
				var SUMMARY = sysSummary['SUMMARY'];
				var msg = sysSummary['NO_CHARTS_MSG'];
				var COULUMN_NAME = sysSummary['COULUMN_NAME'];
				var COULUMN_VALUE = sysSummary['COULUMN_VALUE'];
				var getMsg = msg;
				var genHTML=" ";


						if ( msg != undefined  )
						{
							genHTML = '<div class="x-table"><table cellspacing="0" cellpadding="0" border="0" class="x-grid-table x-grid-table-resizer" width="100%"><tbody>'
									+'<tr class="x-grid-row"><td width="100%" height="170px" valign="middle" align="center"><div class="iconInformation" width="100%" style="text-align:center;"></div><div>'+getMsg+'</div></td></tr></tbody></table></div>';
						}
						else
						{
							var col1Data = COULUMN_NAME['COLUMNNAM_0'];
							var col2Data = COULUMN_NAME['COLUMNNAM_1'];
							var col3Data = COULUMN_NAME['COLUMNNAM_2'];
							var col4Data = COULUMN_NAME['COLUMNNAM_3'];
							genHTML = '<div class="x-table"><table cellspacing="0" cellpadding="0" border="0" class="x-grid-table x-grid-table-resizer" width="100%"><thead>';
							genHTML += '<tr class="x-grid-row">';
							genHTML +='<td class="x-grid-cell x-grid-cell-first" width="800px"><div class="x-grid-cell-inner"  style="text-align:center">'+col1Data+'</div></td>';
							genHTML +='<td class="x-grid-cell"><div class="x-grid-cell-inner" style="text-align:center">'+ col2Data+'</div></td>';
							genHTML +='<td class="x-grid-cell"><div class="x-grid-cell-inner"  style="text-align:center">'+ col3Data+'</div></td>';
							genHTML +='<td class="x-grid-cell"><div class="x-grid-cell-inner"  style="text-align:center">'+ col4Data+'</div></td>';
							genHTML +='</tr></thead>';
							for ( var j = 0; j < COULUMN_VALUE.length; j++ )
							{
								var colVal0Data = COULUMN_VALUE[j]['COLUMN_0'];
								var colVal1Data = COULUMN_VALUE[j]['COLUMN_1'];
								var colVal2Data = COULUMN_VALUE[j]['COLUMN_2'];
								var colVal3Data = COULUMN_VALUE[j]['COLUMN_3'];
								genHTML += '<tbody><tr class="x-grid-row">';
								var genTD = '';
								genTD += '<td class="x-grid-cell" ><div class="x-grid-cell-inner"  style="text-align:center">'+colVal0Data+'</div></td>'
								genTD += '<td class="x-grid-cell"><div class="x-grid-cell-inner"  style="text-align:center">'+colVal1Data+'</div></td>';
								genTD += '<td class="x-grid-cell"><div class="x-grid-cell-inner"  style="text-align:center">'+colVal2Data+'</div></td>';
								genTD += '<td class="x-grid-cell"><div class="x-grid-cell-inner"  style="text-align:center">'+colVal3Data+'</div></td>';
								genHTML += genTD+'</tr>';
							}
							genHTML +='</tbody></table></div>';
						}
				outerChartArr.push({
							xtype: 'commonPanel',
							cls: 'datapanel',
							frame:true,
							height: 250,
							columnWidth: 1.0,
							padding:'0px 0px 0px 0px',
							title: title,
							id: 'Sys-configS-'+i,
							html:genHTML

						});
			}
		if ( !Ext.isEmpty( sysHistory ) )
		{
			var genHTML = '';
			for(var i=0;i<sysHistory.length;i++){
				var msg = sysHistory[i]['NO_CHARTS_MSG'];
				var title = sysHistory[i]['TITLE'];
				var sysHistoryArr = sysHistory[i];
				var history = sysHistory[i]['HISTORY'];
				var imgSrc = sysHistory[i]['IMAGE_URL'];
				var tmpWidth = sysHistory[i]['WIDTH'];
				var getMsg = msg;
			}
			outerChartArr.push({
				xtype: 'panel',
				cls: 'datapanel',
				height: 330,
				columnWidth: 1.0,
				padding:'0px 0px 0px 0px',
				title: title,
				items:[
				{
					xtype:'panel',
					margin:10,
					id: 'sys-config1-'+i,
					height: 330,					
					padding:'0px 0px 0px 0px',
					listeners : 
					{
						'afterrender' : function()
						{
							if(imgSrc!=null && imgSrc!='' && !Ext.isEmpty(imgSrc))
							{
								Ext.Ajax.request({
								url: imgSrc,
								method:'post',
								success: function( response )
									{
										if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
										{
											var tmpJsonTxt = response.responseText;											
											if ( tmpJsonTxt.indexOf('png') == -1 && tmpJsonTxt.indexOf('PNG') == -1 && tmpJsonTxt.indexOf('gif') == -1 && tmpJsonTxt.indexOf('GIF') == -1 )
											{
												var tmpJsonData = Ext.decode( tmpJsonTxt );
												try
												{
													var lineChart = {};
													lineChart = jQuery.extend(true, {}, getHighCharts('sys-config1-'+i, 260,1150,''), lineChart);
													lineChart.setData(tmpJsonData,currentDateFormat,'',false,'right');
													lineChart.drawChart();
												}
												catch (e)
												{
													console.log("e::"+e)
												}
											}
										}
										else
										{
											genHTML = '<div class="x-table"><table cellspacing="0" cellpadding="0" border="0" class="x-grid-table x-grid-table-resizer" width="100%"><tbody>'+'<tr class="x-grid-row"><td width="100%" height="170px" valign="middle" align="center"><div class="iconInformation" width="100%" style="text-align:center;"></div><div>'+getMsg+'</div></td></tr></tbody></table></div>';
											Ext.get('sys-config1-'+i).update(genHTML);
										}
									}
								});
								//genHTML = '<div style="text-align:center"><img src="'+imgSrc+'" /></div>';
							}
						}
					}
				}]
			});		
		}
			if ( !Ext.isEmpty( diskESX ) )
			{
				var title = diskESX['TITLE'];
				var fullview_URL = diskESX['FULLVIEW_URL'];
				var msg = diskESX['NO_CHARTS_MSG'];
				var no_charts = diskESX['NO_CHARTS'];
				var COULUMN_NAME = diskESX['Disk_ESX_COLUMNNAME'];
				var COULUMN_VALUE = diskESX['Disk_ESX_COLUMNVAL'];
				var getMsg = msg;
				var genHTML=" ";
				if ( msg != undefined  )
				{
					genHTML = '<div class="x-table"><table cellspacing="0" cellpadding="0" border="0" class="x-grid-table x-grid-table-resizer" width="100%"><tbody>'
							+'<tr class="x-grid-row"><td width="100%" height="170px" valign="middle" align="center"><div class="iconInformation" width="100%" style="text-align:center;"></div><div>'+getMsg+'</div></td></tr></tbody></table></div>';
				}
				else
					{
						var col1Data = COULUMN_NAME['COLUMNNAM_0'];
						var col2Data = COULUMN_NAME['COLUMNNAM_1'];
						var col3Data = COULUMN_NAME['COLUMNNAM_2'];
						var col4Data = COULUMN_NAME['COLUMNNAM_3'];
						var col5Data = COULUMN_NAME['COLUMNNAM_3'];
						var col6Data = COULUMN_NAME['COLUMNNAM_3'];
						genHTML = '<div class="x-table"><table cellspacing="0" cellpadding="0" border="0" class="x-grid-table x-grid-table-resizer" width="100%"><thead>';
						genHTML += '<tr class="x-grid-row">';

						for ( var j = 0; j < COULUMN_NAME.length; j++ )
						{
							var colNam0Data = COULUMN_NAME[j]['COLUMNNAM_0'];
							var colNam1Data = COULUMN_NAME[j]['COLUMNNAM_1'];
							var colNam2Data = COULUMN_NAME[j]['COLUMNNAM_2'];
							var colNam3Data = COULUMN_NAME[j]['COLUMNNAM_3'];
							var colNam4Data = COULUMN_NAME[j]['COLUMNNAM_4'];
							var colNam5Data = COULUMN_NAME[j]['COLUMNNAM_5'];
							var colNam6Data = COULUMN_NAME[j]['COLUMNNAM_6'];

							var genTD = '';
							genTD += '<td class="x-grid-cell x-grid-cell-first" ><div class="x-grid-cell-inner">'+colNam0Data+'</div></td>'
							genTD += '<td class="x-grid-cell"><div class="x-grid-cell-inner">'+colNam1Data+'</div></td>';
							genTD += '<td class="x-grid-cell"><div class="x-grid-cell-inner">'+colNam2Data+'</div></td>';
							genTD += '<td class="x-grid-cell"><div class="x-grid-cell-inner">'+colNam3Data+'</div></td>';
							genTD += '<td class="x-grid-cell"><div class="x-grid-cell-inner">'+colNam4Data+'</div></td>';
							genTD += '<td class="x-grid-cell"><div class="x-grid-cell-inner">'+colNam5Data+'</div></td>';
							genTD += '<td class="x-grid-cell"><div class="x-grid-cell-inner">'+colNam6Data+'</div></td>';
							genHTML += genTD+'</tr>';
							genHTML +='</thead>';
						}
						for ( var j = 0; j < COULUMN_VALUE.length; j++ )
						{
							var colVal0Data = COULUMN_VALUE[j]['COLUMN_0'];
							var colVal1Data = COULUMN_VALUE[j]['COLUMN_1'];
							var colVal2Data = COULUMN_VALUE[j]['COLUMN_2'];
							var colVal3Data = COULUMN_VALUE[j]['COLUMN_3'];
							var colVal4Data = COULUMN_VALUE[j]['COLUMN_4'];
							var colVal5Data = COULUMN_VALUE[j]['COLUMN_5'];
							var colVal6Data = COULUMN_VALUE[j]['COLUMN_6'];

							genHTML += '<tbody><tr class="x-grid-row">';
							var genTD = '';
							genTD += '<td class="x-grid-cell x-grid-cell-first" ><div class="x-grid-cell-inner">'+colVal0Data+'</div></td>'
							genTD += '<td class="x-grid-cell"><div class="x-grid-cell-inner"><img class='+colVal1Data+' src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw=="/></div></td>';
							genTD += '<td class="x-grid-cell"><div class="x-grid-cell-inner">'+colVal2Data+'</div></td>';
							genTD += '<td class="x-grid-cell"><div class="x-grid-cell-inner">'+colVal3Data+'</div></td>';
							genTD += '<td class="x-grid-cell"><div class="x-grid-cell-inner">'+colVal4Data+'</div></td>';
							genTD += '<td class="x-grid-cell"><div class="x-grid-cell-inner">'+colVal5Data+'</div></td>';
							genTD += '<td class="x-grid-cell"><div class="x-grid-cell-inner">'+colVal6Data+'</div></td>';
							genHTML += genTD+'</tr>';
						}
						genHTML +='</tbody></table></div>';
					}
					outerChartArr.push({
						xtype: 'commonPanel',
						cls: 'block1',
						frame:true,
						height: 250,
						columnWidth: 0.5,
						padding:'0px 0px 0px 0px',
						title: title,
						id: 'Sys-configS-'+i,
						html:genHTML

					});
			}

			outerObj.add(outerChartArr);
			outerObj.doLayout();
			sysLastGraphTypeLoaded = 'DDgraph';
			
	},
	showAtAGlance: function( tabId, resultData ,isFlag)
	{
		var atAGlanceObj = Ext.getCmp(tabId);
		atAGlanceObj.setAutoScroll(true);
		var atAGlanceArr = new Array();
		if(isFlag == 'default')
		{
			atAGlanceObj.removeAll();
			atAGlanceObj.add({
			xtype: 'panel',
			id: 'sysHealthDialPanel',
			cls:'block1',
			frame:true,
			border:true,
			width: '100%',
			//height:172,
			margin:'10 10 5 10',
			padding:'8 0 8 0',
			layout: 'hbox'
		});

		atAGlanceObj.add({
			xtype: 'panel',
			id: 'sysDigitalPanel',
			width: '100%',
			padding: '0 0 10 0',
			cls:'block1 backgroundDailChart',
			frame:true,
			border:true,
			margin:'10 10 10 10',
			//height: 100,
			layout: 'hbox'
		});

		atAGlanceObj.add({
			xtype: 'panel',
			id: 'sysConfigPanel',
			margin:'0 5 10 5',
			width: '100%',
			layout:
			{
				type: 'column',
				align: 'stretch'

				},
				defaults:
				{
					margin:'5 5 5 5',
					columnWidth: 0.5,
					cls:'datapanel'
				}
			});
			atAGlanceObj.doComponentLayout( );
		}
		
		var getHealthDialObj = Ext.getCmp('sysHealthDialPanel');
		var getDigitalObj = Ext.getCmp('sysDigitalPanel');
		var configObj = Ext.getCmp('sysConfigPanel');
	//	var hopDelayObj = Ext.getCmp('sysHopDelayPanel');
		getDigitalObj.removeAll();
		configObj.removeAll();
	//	hopDelayObj.removeAll();
		//getHealthDialObj.removeAll();
		if ( !Ext.isEmpty( resultData ) )
		{
			//atAGlanceArr.splice(0, atAGlanceArr.length);
			atAGlanceArr = new Array();
			// To Load Health Chart
			var healthData = resultData['HEALTH'];
			if ( !Ext.isEmpty( healthData ) )
			{
				var healthArr = new Array();
				var healthTitle = healthData['TITLE'];
				var xmlData = healthData['XML_DATA'];
				var swfPath = healthData['SWF_PATH'];
				var chartHeight = Math.round(healthData['HEIGHT']);
				var chartWidth = Math.round(healthData['WIDTH']);
				if ( xmlData == '-' )
				{
					var errorMsg = healthData['MSG'];
					healthArr.push(
						{
							xtype: 'container',
							cls:'componentnetworkseperator',
							padding:0,
							margin:0,
							layout:{
								type: 'vbox',
								align: 'stretch'
							},
							items:[
								{
									xtype: 'label',
									id:'healthTitleLabel',
									align: 'center',
									html: '<div class="font_bold12"  style="text-align:center">'+healthTitle+'</div>'
								},
								{
									xtype: 'container',
									id:'HealthData',
									height:200,
									//height: chartHeight,
									width: chartWidth,
									html:  '<table width="100%" height="100%" style="text-align:center"><tr><td><div class="iconInformation" style="margin:0px auto"></div><div>'+errorMsg+'</div></td></tr></table>'

								}
							]
						}
					);
				}
				else
				{
					healthArr.push(
						{
							xtype: 'container',
							cls:'componentnetworkseperator',
							//style:{'border':"#000 1px solid"},
							
								height:172,
							margin:'13 0 0 0',
							width:262,
							items:[
								{
									xtype: 'container',
									id:'healthTitleLbl',
									margin:'0 0 0 0',
									align: 'center',
									style: {'position':'relative','z-index':'9999'},
									html: '<div style="text-align:center;" class="font_bold">'+healthTitle+'</div>'
									
								},
								{
									xtype: 'container',
									//flex:1,
									height: chartHeight,
									
									id: 'sys-tmpChartq',
									width: '100%',
									html: '<div id="sysHealthChart" style="margin-top:-15px"></div>'
								}
							]
						}
					);
				}
				getHealthDialObj.removeAll();
				getHealthDialObj.add(healthArr);
				getHealthDialObj.doComponentLayout( );
				if ( xmlData != '-' )
				{
						try
						{
							var barChart = {};
							barChart = jQuery.extend(true, {}, getHighChartsBarInstance('sysHealthChart', 145, 225), barChart);
							barChart.setData(xmlData, currentDateFormat, '','pie');
							barChart.drawChart();
						}
						catch (barChartEx)
						{
							console.log(barChartEx);
						}
				}
			}

			// To Load Dial Chart

			var dialData = resultData['DIAL'];
			layerModelURL = resultData['hiddens'];
//			dialData = null;
			if ( !Ext.isEmpty( dialData ) && dialData!='-')
			{
				atAGlanceArr.splice(0, atAGlanceArr.length);

				for ( var i = 0; i < dialData.length; i++ )
				{
					var title = dialData[i]['TITLE'];
					var toolTipTitle = dialData[i]['TOOL_TIP_TITLE'];
					var Dial_Fullview = dialData[i]['Dial_Fullview'];
					var methodName = dialData[i]['METHOD_NAME'];
					var params = dialData[i]['PARAMS'];
					var chartHeight = Math.round(dialData[i]['HEIGHT']);
					var chartWidth = Math.round(dialData[i]['WIDTH']);
					var xmlData = dialData[i]['XML_DATA'];
					var swfPath = dialData[i]['SWF_PATH'];
					var subTitle_Dial = dialData[i]['subTitle_Dial'];
					var DialPARAMS = dialData[i]['DialPARAMS'];
					//if ( xmlData != '-' )
					var chartheightobj=parseInt(chartHeight)-25;
					if(Dial_Fullview != '' && Dial_Fullview=='true' && Dial_Fullview!= undefined )
					{
						var fullviewcls='iconMaximize';
					}
					else
					{
						var fullviewcls='';
					}
					if(subTitle_Dial==undefined || subTitle_Dial=="" )
					{
						subTitle_Dial=" ";
					}
					{
							atAGlanceArr.push({
							xtype: 'container',
							flex:.20,
							cls:'componentnetworkseperator',
							//height:174,
							margin:'13 0 0 0',
							layout:{
								type: 'vbox',
								width: chartWidth,
								//padding: '0px 5px 0px 5px',
								align: 'stretch'
							},
							items:[
								{
									xtype: 'container',
									margin:'0 0 0 0',
									style: {'text-align':'center'},

									align: 'center',
									html: '<div style="text-align:center;" title="'+toolTipTitle+'" class="font_bold"><span >'+title+'</span><span class='+fullviewcls+' style="float:right;cursor:pointer;margin-right: 10px;" onclick="javascript:'+methodName+'(\''+params+'\');"></span></div>'
								},
								{
									xtype: 'label',
									padding:'0 0 0 0',
									height:15,
									html: '<div style="text-align:center;cursor:pointer;margin-top:5px;height:15px;overflow: hidden;-o-text-overflow:ellipsis;text-overflow:ellipsis;white-space:nowrap;padding:0px 4px" data-qtip="'+subTitle_Dial+'" onclick="javascript:wayToLayerModel(\''+DialPARAMS+'\');" class="font_text"><b>'+subTitle_Dial+'</b></div>'
								},
								{
									xtype: 'container',
									id: 'sysDialChartCont-'+i,
									dataArray: dialData[i],
									align: 'center',
									
									html: '<div id="sysDialchart'+i+'" style="margin:0px auto;width:'+chartWidth+'px;height:'+chartheightobj+'px;"></div>'
								}
							]
						});
					}
				}
				var outerArr = new Array();
				outerArr.push({
					xtype: 'container',
					
					id: 'sysDialpanel',
					flex:1,
					layout: {
						type: 'hbox',
						padding : '0px 0px 0px 0px',
						align: 'stretch'
					},
					dialData : dialData,
					items: atAGlanceArr,
					listeners : 
					{
						'afterrender' : function(comp)
						{
							for ( var i = 0; i < this.dialData.length; i++ )
							{
								var getObj = Ext.getCmp('sysDialChartCont-'+i);
								var getDataArray = getObj.dataArray;
								var xmlData = getDataArray['XML_DATA'];
								var swfPath = dialData[i]['SWF_PATH'];
								if ( xmlData != '-' )
								{
										getHighChartsGuage('sysDialchart'+i,xmlData);
								}
								else
									{
										Ext.get('sysDialchart'+i).update('<div style="border:0px solid blue;margin:0px auto"><div class="iconInformation" width="100%" style="text-align:center;margin:0px auto;margin-top: 30px;"></div><div style="text-align:center;margin:0px auto;">'+noMeasureExcl+'</div></div>');
									}
							}
						}
					}
				});
				getHealthDialObj.add(outerArr);
				getHealthDialObj.doComponentLayout();
				
			}
			else
			{
				getHealthDialObj.add({
					xtype: 'container',
					width: '100%',
					id: 'sysDialpanel',
					margin:'0 10 0 10',
					padding:'0 0 8 0',
					height:207,
					flex: 0.25,
					layout: {
						type: 'hbox',
						//padding: '0px 0px 0px 0px',
						align: 'stretch'
					}
				});
			}

			getHealthDialObj.doComponentLayout();
			// Hop delay
			var hopDelay = resultData['hopObj'];
			if(!Ext.isEmpty(hopDelay))
			{

				var hopWidth = hopDelay['WIDTH'];
				var hopHeight = hopDelay['HEIGHT'];
				var hopTitle = hopDelay['TITLE'];
				var hopdelayArr = new Array();
				atAGlanceArr.splice(0, atAGlanceArr.length);
				var Msg = hopDelay['NoMess'];
				if(Msg == 'true' )
				{
					var getMsg = hopDelay['HopMsg'];
					var hopMsg=['HopMsg'];
					hopdelayArr.push({
						xtype: 'container',
						id:'hopDelay',
						cls:'fancy_border',
						height: hopHeight,
						width: hopWidth,
						html: '<div class="title"><b>'+hopTitle+'</b></div><div style="border:0px solid blue;text-align:center;"><div class="iconInformation"></div></div><div style="border:0px solid green;text-align:center;">'+getMsg+'</div>'
					});
				//	hopDelayObj.add(hopdelayArr);
				//	hopDelayObj.doComponentLayout( );
				}
				else
				{
					hopdelayArr.push({
						xtype: 'container',
						id:'hopDelayCon',
						height: hopHeight,
						width: hopWidth,
						html: '<div class="title"><b>'+hopTitle+'</b><table cellspacing="0" cellpadding="2px" border="0"><tr><td class="eg_75bold tdborder2_jvm" align="center">'+hopDelay['COLUMN_0']+'</td><td class="eg_75bold tdborder2_jvm" align="center">'+hopDelay['COLUMN_1']+'</td></tr><tr><td class="tdborder_jvm" >'+hopDelay['COLUMN_0_val']+'</td><td class="tdborder_jvm" style="width:300px;padding:0px; height:24px" align="center" ><table cellpadding="1" cellpadding="0" border="0" style="table-layout:fixed;width:150px;height:20px" class="hop"><tr><td align="center"> '+hopDelay['COLUMN_1_val_0']+' </td><td align="center">'+hopDelay['COLUMN_1_val_1']+'</td><td align="center">'+hopDelay['COLUMN_1_val_2']+'</td>	</tr></table></td></tr></table></div>'
					});
					//hopDelayObj.add(hopdelayArr);
					//hopDelayObj.doComponentLayout( );
				}

				/*********for Hop delay refresh function ******/
				if(Ext.getCmp('hopDelay') !=null )
				{
					Ext.getCmp('hopDelay').update('<div class="title"><b>'+hopTitle+'</b></div><div style="border:0px solid blue;text-align:center;"><div class="iconInformation"></div></div><div style="border:0px solid green;text-align:center;">'+getMsg+'</div>');
				}
				else if(Ext.getCmp('hopDelayCon')!=null)
				{
					Ext.getCmp('hopDelayCon').update('<div class="title"><b>'+hopTitle+'</b><table cellspacing="0" cellpadding="2px" border="0"><tr><td class="eg_75bold tdborder2_jvm" align="center">'+hopDelay['COLUMN_0']+'</td><td class="eg_75bold tdborder2_jvm" align="center">'+hopDelay['COLUMN_1']+'</td></tr><tr><td class="tdborder_jvm" >'+hopDelay['COLUMN_0_val']+'</td><td class="tdborder_jvm" style="width:300px;padding:0px; height:24px" align="center" ><table cellpadding="1" cellpadding="0" border="0" style="table-layout:fixed;width:150px;height:20px" class="hop"><tr><td align="center"> '+hopDelay['COLUMN_1_val_0']+' </td><td align="center">'+hopDelay['COLUMN_1_val_1']+'</td><td align="center">'+hopDelay['COLUMN_1_val_2']+'</td>	</tr></table></td></tr></table></div>');
				}
				else
				{
					getHealthDialObj.add(hopdelayArr);
				}
				
			//	getDigitalObj.doComponentLayout( );
			}
			// To load Digital Data

			var digitalData = resultData['DIGITAL'];
//			digitalData = null;
			if ( !Ext.isEmpty( digitalData ) )
			{
				atAGlanceArr.splice(0, atAGlanceArr.length);
				for ( var i = 0;i < digitalData.length; i++ )
				{
					var heading = digitalData[i]['IMG_HEADING'];
					var imgSRC = digitalData[i]['IMG_SRC'];
					var height = digitalData[i]['HEIGHT'];
					var width = digitalData[i]['WIDTH'];
					var unit = digitalData[i]['UNIT'];
					var containerWidth = Math.round(digitalData[i]['CONTAINER_WIDTH']);
					if(imgSRC!='-')
					{
						atAGlanceArr.push({
							xtype: 'container', // Digital meter
							padding: '0 0 5 0',
							flex:1,
							id:'digitalContainer'+i,
							cls:'componentnetworkseperator',
							width: containerWidth,
							
							margin:'10 0 0 0',
							layout:
							{
								type: 'vbox',
								align: 'stretch'
							},
							items:[
								{
									xtype: 'label',
									padding:'0 0 0 0',
									html: '<div style="text-align:center;" class="font_bold">'+heading+'</div>'
								},
								{
									xtype: 'container',
									id:'Sys_digitalChartId'+i,
									width:'100%',
									height:30,
									style:{'text-align':'center'},
									padding: '3px 0px 0px 0px',
									dataArray: digitalData[i],
									listeners:{
										'afterrender': function(container)
										{
											var tmpDataArray = this.dataArray;
											var imgsrc = tmpDataArray['IMG_SRC'];
											var imgHeight = tmpDataArray['HEIGHT'];
											var imgWidth = tmpDataArray['WIDTH'];
											var imgTitle = tmpDataArray['IMG_TITLE'];
											var methodName = tmpDataArray['METHOD_NAME'];
											var params = tmpDataArray['PARAMS'];
											var genImage = '<img style="vertical-align:middle;cursor:pointer" src="'+imgsrc+'" title="'+imgTitle+'" style="cursor:pointer" onclick="javascript:'+methodName+'(\''+params+'\');"/>';
											imgHeight= Math.round(imgHeight);
											this.setHeight(imgHeight);
											this.update(genImage);
										}
									}
								},
								{
									xtype: 'label',
									html: '<div style="text-align:center;font-size:11px;">'+unit+'</div>'
								}
							]
						});
					}
					else
					{
						atAGlanceArr.push({
							xtype: 'container', // Digital meter
							//padding: 5,
							flex:1,
							id:'digitalContainer'+i,
							cls:'componentnetworkseperator',
							width: containerWidth,
							height: 80,
							layout:
							{
								type: 'vbox',
								align: 'stretch'
							},
							items:[
								{
									xtype: 'label',
									padding:'5 0 5 0',
									html: '<div style="text-align:center;" class="font_bold">'+heading+'</div>'
								},
								{
									xtype: 'container',
									id:'Sys_digitalChartId'+i,
									width:'100%',
									style:{'text-align':'center'},
									padding: '0px 0px 0px 0px',
								//	dataArray: digitalData[i],
									listeners:{
										'afterrender': function(container)
										{
											var digitalId=this.id;
											Ext.get(container.id).update('<div style="border:0px solid blue;margin:0px auto"><div class="iconInformation" width="100%" style="text-align:center;margin:0px auto;margin-top: 0px;"></div><div style="text-align:center;margin:0px auto;">'+noMeasureExcl+'</div></div>');
										}
									}
								}
							]
						});
					}
				}

			}

			if ( (dialData == undefined || Ext.isEmpty(dialData)) && (digitalData == undefined  || Ext.isEmpty(digitalData)))
			{
				var noGraphTitle = resultData['SYS_TAB_NoGraphTitle'];
				var dialDigitalMsg = resultData['DIAL_DIGITAL_MSG'];
				var noMeasureMsg = testExcludedorDisabledMsg;
				
				if( dialDigitalMsg == undefined || Ext.isEmpty(dialDigitalMsg)){
					noMeasureMsg = noMeasure;
				}
				Ext.getCmp('sysDialpanel').flex=1;
				Ext.getCmp('sysDialpanel').removeAll();
					var dialNoMes = {
					xtype:'container',
					height:200,
					margin:'1px 0px 0px 0',
					width:'100%',
					//style:{'border':'1px solid red'},
					//margin:5,
					html:'<div class="noGraphTitle" style="padding-top:5px;">'+noGraphTitle+'</div><table width="100%" height="189px" style="text-align:center"><tr><td><div class="iconInformation" style="margin:0px auto"></div><div>'+noMeasureMsg+'</div></td></tr></table>'
					//html:'<div style="text-align:center"><b>'+noGraphTitle+'</b></div><br/><div class="iconInformation" style="margin:0px auto"></div><div style="text-align:center">'+noMeasure+'</div>'
				};
				var dialObj = Ext.getCmp('sysDialpanel');
				dialObj.removeAll();
				dialObj.add(dialNoMes);
				dialObj.doComponentLayout( );
				getDigitalObj.hide();
			}
			else if ( Ext.isEmpty( dialData ) )
			{				
				var noGraphTitle = resultData['SYS_TAB_NoGraphTitle'];
				
				var dialMsg = resultData['DIAL_MSG'];
				var noMeasureMsg = testExcludedorDisabledMsg;
				if( dialMsg == undefined || Ext.isEmpty(dialMsg)){
					noMeasureMsg = noMeasure;
				}
				Ext.getCmp('sysDialpanel').flex=1;
				Ext.getCmp('sysDialpanel').removeAll();
				var dialNoMes = {
					xtype:'container',
					margin:'1px 0px 0px 0',
					width:'100%',
					html:'<div class="noGraphTitle" style="padding-top:15px;">'+noGraphTitle+'</div><table width="100%" height="130px" style="text-align:center"><tr><td><div class="iconInformation" style="margin:0px auto"></div><div>'+noMeasureMsg+'</div></td></tr></table>'
					//html:'<div style="text-align:center"><b>'+noGraphTitle+'</b></div><table width="100%" style="margin-top:30px"><tr><td align="center" ><div class="iconInformation" style="margin:0px auto"></div><div>'+noMeasure+'</div></td></tr></table>'
				};
				var dialObj = Ext.getCmp('sysDialpanel');
				dialObj.removeAll();
				dialObj.add(dialNoMes);
				dialObj.doComponentLayout();
				//getDigitalObj.hide();
			}
			/*else if ( Ext.isEmpty( digitalData ) )
			{
				var noGraphTitle = resultData['DIGITAL_TITLE'];
				
				getDigitalObj.removeAll();
				var dialNoMes = {
					xtype:'container',
					margin:'1px 0px 0px 0',
					html:'<div style="text-align:center"><b>'+noGraphTitle+'</b></div><table width="100%" style="margin-top:30px"><tr><td align="center" ><div class="iconInformation" style="margin:0px auto"></div><div>'+noMeasure+'</div></td></tr></table>'
				};				
				getDigitalObj.add(dialNoMes);
				getDigitalObj.doComponentLayout();
				//getDigitalObj.hide();
			}*/
			else if(Ext.isEmpty( digitalData )){
				getDigitalObj.hide();
			}


			getDigitalObj.add(atAGlanceArr);

			getDigitalObj.doComponentLayout( );
		}

			// To load configurations

			var configsData = resultData['CONFIG_DATAS'];
			if ( !Ext.isEmpty( configsData ) )
			{
				atAGlanceArr.splice(0, atAGlanceArr.length);
				var cnt = 0; //To count no of sparkline
				for ( var i = 0; i < configsData.length; i++ )
				{
					var configData = configsData[i];
					var configurationTitle = configData['TITLE'];
					var type = configData['TYPE'];
					type = type.toLowerCase();
					var adminPermission = configData['ADMIN_PERMISSION'];
					var toolsArr = new Array();
//					if ( adminPermission.toLowerCase() == 'true' )
//					{
//						toolsArr.push(
//								/*{
//									xtype: 'button',
//									iconCls: 'iconMaximize',
//									dataArray: 'sysConfig-'+i,
//									handler: function()
//									{
//										var tmpDataArray = this.dataArray;
//									}
//								},{
//									xtype: 'button',
//									iconCls: 'iconClose',
//									dataArray: 'config-'+i,
//									handler: function()
//									{
//										var tmpDataArray = this.dataArray;
//										Ext.getCmp(tmpDataArray).destroy();
//										applicationController.callMe();
//
//									}
//								}*/
//							);
//					}
//					else
//					{
//						toolsArr.push({
//									xtype: 'button',
//									iconCls: 'iconMaximize',
//									dataArray: 'sysConfig-'+i,
//									handler: function()
//									{
//										var tmpDataArray = this.dataArray;
//									}
//								});
//					}
					if ( type == 'table' )
					{
						var configuration = configData['CONFIGURATION'];
						var genHTML = '';
						if ( configuration != '-' )
						{
							genHTML = '<div class="x-table"><table cellspacing="0" width="100%" cellpadding="0" border="0" class="x-grid-table x-grid-table-resizer"><tbody>';
							for ( var j = 0; j < configuration.length; j++ )
							{
								var getVal = '';
								if ( configuration[j]['TITLE'] != undefined )
								{
									genHTML +='<tr class="x-grid-row"><td colspan="2" class=" x-grid-cell x-grid-cell-first"><div class="x-grid-cell-inner">'+configuration[j]['TITLE']+'</div></td></tr>';
								}
								else
								{
									var getVal1 = '', getVal2 = '';
									if ( configuration[j]['VALUE_1'] != undefined )
									{
										getVal1 = configuration[j]['VALUE_1'];
									}
									if ( configuration[j]['VALUE_2'] != undefined )
									{
										getVal2 = configuration[j]['VALUE_2'];
									}
									genHTML +='<tr class="x-grid-row"><td class=" x-grid-cell x-grid-cell-first"><div class="x-grid-cell-inner">'+getVal1+'</div></td><td class=" x-grid-cell x-grid-cell-first"><div class="x-grid-cell-inner">'+getVal2+'</div></td></tr>';
								}
							}

							genHTML +='</tbody></table></div>';
						}
						else
						{
							var msg = configData['MSG'];
							genHTML = '<table width="100%" height="150px" style="text-align:center"><tr><td><div class="iconInformation" style="margin:0px auto 0px auto"></div><div>'+msg+'</div></td></tr></table>';
						}

						atAGlanceArr.push(
						{
							xtype: 'panel',
							cls:'datapanel',
							height: 200,
							frame:false,
							padding:0,
							scroll:true,
							autoScroll:true,
							title: configurationTitle,
							id: 'sysConfig-'+i,
							tools:toolsArr,
							html: genHTML
						});
					}
					else if ( type == 'spark' )
					{
						var configuration = configData['CONFIGURATION'];
						var genHTML = '';
						if ( configuration != '-' )
						{
							genHTML = '<div class="x-table"><table cellspacing="0" cellpadding="0" border="0" class="x-grid-table x-grid-table-resizer" width="100%"><tbody>';
							for ( var j = 0; j < configuration.length; j++ )
							{
								var conData = configuration[j];
								genHTML += '<tr class="x-grid-row" height="20px">';
								var genTD = '';
								for ( var kk in conData )
								{
									var getValue = conData[kk];
									if ( kk.toLowerCase() == 'state' )
									{
										genTD += '<td class="x-grid-cell x-grid-cell-first" width="30px"><div class="x-grid-cell-inner"><img src="/final/images/clear.png" class="state_'+getValue+'" style="vertical-align:middle;display:inline-block"/></div></td>';
									}
									else if ( kk.toLowerCase() == 'link' )
									{
										var getLinkObj = getValue;
										var getMeasures = getLinkObj['MEASURE'];
										if ( getLinkObj['METHOD_NAME'] != undefined && getLinkObj['PARAMS'] != undefined )
										{
											var methodName = getLinkObj['METHOD_NAME'];
											var params = getLinkObj['PARAMS'];
											genTD += '<td class="x-grid-cell x-grid-cell-first"><div class="x-grid-cell-inner"><a href="javascript:void(0);" onclick="javascript:'+methodName+'(\''+params+'\');" title="'+getMeasures+'">'+getMeasures+'</a></div></td>';
										}
										else
										{
											genTD += '<td class="x-grid-cell x-grid-cell-first"><div class="x-grid-cell-inner">'+getMeasures+'</div></td>';
										}
									}
									else if ( kk.toLowerCase() == 'xml_data' )
									{
										var xmlData = getValue;
										if ( xmlData != '-' )
										{
											//var swfPath = getValue['SWF_PATH'];
											genTD += '<td class="x-grid-cell x-grid-cell-first" width="150px"><div class="x-grid-cell-inner"><div id="system-chartSparkContainer'+cnt+'" style="border:0px solid red;height:20px;cursor:pointer"></div></div></td>';
										    
										}
										else
										{
											genTD += '<td class="x-grid-cell x-grid-cell-first" width="150px"><div class="x-grid-cell-inner"><div id="system-chartSparkContainer'+cnt+'" style="border:0px solid red;height:20px;">'+xmlData+'</div></div></td>';
										}
										cnt++;
									}
									else if ( kk.toLowerCase() == 'value' )
									{
										if(getValue!=undefined && getValue > 0 && getValue!='' && !isNaN(getValue))
										{
											genTD += '<td class="x-grid-cell x-grid-cell-first" width="100px"><div class="x-grid-cell-inner">'+Number(getValue).toFixed(2)+'</div></td>';
										}
										else
										{
											genTD += '<td class="x-grid-cell x-grid-cell-first" width="100px"><div class="x-grid-cell-inner">'+getValue+'</div></td>';
										}
									}
								}
								genHTML += genTD+'</tr>';
							}
							genHTML +='</tbody></table></div>';
						}
						else
						{
							var msg = configData['MSG'];
							genHTML = '<table width="100%" height="150px" style="text-align:center"><tr><td><div class="iconInformation" style="margin:0px auto 0px auto"></div><div>'+msg+'</div></td></tr></table>';
						}

						atAGlanceArr.push(
						{
							xtype: 'panel',
							//cls: 'block1',
							frame:true,
							autoScroll:true,
							padding:0,
							height: 200,
							title: configurationTitle,
							dataArray: configuration,
							id: 'sysConfig-'+i,
							tools: toolsArr,
							html: genHTML
						});
					}
					else if ( type == 'grid' )
					{
						var XType = '';
						var columnWidth = 0.5;
						if ( configData['COLUMN_WIDTH'] != undefined )
						{
							columnWidth = configData['COLUMN_WIDTH'];
						}
						if ( configData['GRID_COLUMNS'] != undefined && configData['GRID_VALUES'] != undefined )
						{
							var gridCols = configData['GRID_COLUMNS'];
							var gridVals = configData['GRID_VALUES'];
							var columnArr = new Array();
							var gridStoreModel = new Array();
							if ( !Ext.isEmpty( gridCols ) )
							{
								for ( var l = 0 ; l < gridCols.length; l++ )
								{
									if(l==0)
									{
										gridStoreModel[gridStoreModel.length] = {name : 'COLUMN_'+l , type : 'string'};
									}
									else
									{
										gridStoreModel[gridStoreModel.length] = {name : 'COLUMN_'+l , type : 'FLOATORSTRING'};
									}
									columnArr.push({
										header: gridCols[l],
										flex: 0.2,
										dataIndex: 'COLUMN_'+l
									});
								}
							}
							XType = {
								xtype: 'customgrid',
								width: '100%',
								height: 174,
								cls:'gridSkin',
								autoScroll: false,
								scroll:true,
								
								store: new Ext.data.Store({
									fields: gridStoreModel,
									data: gridVals
								}),
								columns: columnArr
							};
						}
						else
						{
							var msg = configData['MSG'];
							XType = {
								xtype: 'container',
								width: '100%',
								height: 200,
								html: '<div style="text-align:center;margin:8% auto 0px auto"><div class="iconInformation" style="margin:0px auto" ></div><div>'+msg+'</div></div>'
							};
						}
						if (XType!='')
						{
							atAGlanceArr.push(
						{
							xtype: 'panel',
							//cls: 'block1',
							
							frame:false,
							height: 200,
							columnWidth: columnWidth,
							title: configurationTitle,
							id: 'sysConfig-'+i,
							tools: toolsArr,
							items: [XType]
						});
						}

					}
					else if ( type == 'linear' )
					{
						var configuration = configData['SUMMARY'];
						var msg = configData['MSG'];

						var columnnFData = configData['COLUMN_0'];
						var columnnSData = configData['COLUMN_1'];
						var genHTML = '';
						var processorCPUUsageDialsArr=[];
						if ( configuration != '-' )
						{
							for ( var j = 0; j < configuration.length; j++ )
							{
								var k = j+1
								if(j%3==0){
									if(j>1) {
										processorCPUUsageDialsArr.push({
										xtype: 'container',
										flex:1,
										columnWidth : 1,
										height: 1,
										
									});
									}
								}
							
								processorCPUUsageDialsArr.push({
									xtype: 'container',
									id: 'sysLinearguage-'+j,
									cls:  k%3 == 0 ? '' : 'componentnetworkseperator',
									height : 150,
									style : {
										marginTop: '10px !important',
										marginBottom: '10px !important',
									},
									layout: 'column',
									
									columnWidth : 1/3,
									flex:1,
									listeners:{
										resize:function(con, width, height, oldWidth, oldHeight, eOpts){
											if(!Ext.isEmpty(oldWidth)){
												if(width<height){
													width = width+(height-width);
												}
												else {
													height =height+(width -height);
												}
												$('#'+con.id).highcharts().setSize(width, height, false);
												
											}
										}	
									}
									//align: 'center'
									//html: '<div id="sysDialchart'+i+'" style="margin:0px auto;width:100%;height:100%"></div>'
								});
							}
							
							/*genHTML = '<div class="x-table" ><table cellspacing="0" cellpadding="0" border="0" class="x-grid-table x-grid-table-resizer" width="100%"><thead>';
								genHTML += '<tr class="x-grid-row">';
								genHTML +='<th class="x-grid-cell x-grid-cell-first" width="150px" ><div class="x-grid-cell-inner" style=""><b>'+columnnFData+'</b></div></th>';
								genHTML +='<th class="x-grid-cell" ><div class="x-grid-cell-inner"><b>'+ columnnSData+'</b></div></th>';
								genHTML +='</tr></thead>';
								genHTML += '<tbody>';
							for ( var j = 0; j < configuration.length; j++ )
							{
								var conData = configuration[j];
								var col0Data = configuration[j]['COLUMN_0'];
								var col1Data = configuration[j]['COLUMN_1'];
								genHTML += '<tr class="x-grid-row">';
								var genTD = '';
								genTD += '<td class="x-grid-cell" ><div class="x-grid-cell-inner" style="margin-top:40px;">'+col0Data+'</div></td><td class="x-grid-cell"><div class="x-grid-cell-inner" id="sysLinearguage-'+j+'" style="height:100px"></div></td>';
								genHTML += genTD+'</tr>';
							}
							genHTML +='</tbody></table></div>';*/
						}
						else
						{
							var msg = configData['MSG'];
							genHTML = '<div style="text-align:center;margin:8% auto 0px auto"><div class="iconInformation" width="100%" style="text-align:center;margin:0px auto"></div><div>'+msg+'</div></div>';
						}
						if(processorCPUUsageDialsArr.length > 0){
							atAGlanceArr.push(
							{
								xtype: 'panel',
								
								scroll:true,
								autoScroll:true,
								frame:false,
								height: 200,
								flex:1,
								title: configurationTitle,
								dataArray: configuration,
								id: 'sysConfig-'+i,
								ui: 'sysConfigPanel',
								tools: toolsArr,
								layout : {
									type : 'column'
								},
								items : processorCPUUsageDialsArr
								//html: genHTML
							});
						}else{
							atAGlanceArr.push(
							{
								xtype: 'panel',
								
								scroll:true,
								autoScroll:true,
								frame:false,
								height: 200,
								flex:1,
								title: configurationTitle,
								id: 'sysConfig-'+i,
								ui: 'sysConfigPanel',
								tools: toolsArr,
								html: '<table cellspacing="0" cellpadding="0" border="0" class="x-grid-table x-grid-table-resizer" width="100%"><tbody><tr class="x-grid-row"><td width="100%" height="170px" valign="middle" align="center"><div class="iconInformation" width="100%" style="text-align:center;margin:0px auto"></div><div>'+noMeasureExcl+'</div></td></tr></tbody></table>'
							});
						}
					}
					else if(type == 'fusion_chart')
					{
						var XML_DATA = configData['XML_DATA'];
						var SWF_PATH = configData['SWF_PATH'];
						var HEIGHT = configData['HEIGHT'];
						var WIDTH = configData['WIDTH'];
						atAGlanceArr.push(
						{
							xtype: 'panel',
							//cls: 'block1',
							frame:false,
							height: 200,
							title: configurationTitle,
							id: 'sysConfigLayerHealth'+i,
							chartCnt : i,
							tools: toolsArr,
							html: '<div id="sys-LayerwiseHealth" style="margin:0px auto 0px auto"></div>',
							listeners:{
								'afterrender': function(container)
								{
									if ( XML_DATA != '-' )
									{
												try
												{
													var barChart = {};
													barChart = jQuery.extend(true, {}, getHighChartsBarInstance('sys-LayerwiseHealth', 130,450), barChart);										
													barChart.setData(XML_DATA, currentDateFormat, "",'stackedBar');
													barChart.drawChart();
												}
												catch (barChartEx)
												{
													console.log(barChartEx);
												}
										}
										else
										{
											Ext.get('sys-LayerwiseHealth').update('<div style="border:0px solid blue;margin:0px auto"><div class="iconInformation" width="100%" style="text-align:center;margin:0px auto;margin-top: 20px;"></div><div style="text-align:center;margin:0px auto;">'+noMeasureExcl+'</div></div>');
										}
									}
							}
						});
					}
					else
					{
						atAGlanceArr.push(
						{
							xtype: 'panel',
							//cls: 'block1',
							frame:false,
							height: 200,
							title: configurationTitle,
							id: 'sysConfig-'+i,
							tools: toolsArr,
							html: '<table cellspacing="0" cellpadding="0" border="0" class="x-grid-table x-grid-table-resizer" width="100%"><tbody><tr class="x-grid-row"><td width="100%" height="170px" valign="middle" align="center"><div class="iconInformation" width="100%" style="text-align:center;margin:0px auto"></div><div>'+noMeasureExcl+'</div></td></tr></tbody></table>'
						});
					}
				}
				configObj.removeAll();
				configObj.add(atAGlanceArr);
				configObj.doComponentLayout( );
				var counter = 0;
				for ( var ii = 0; ii < configObj.items.length; ii++ )
				{
					var getType = configData['TYPE'];
					var getSparkBlockObj = Ext.getCmp('sysConfig-'+ii);
					if ( getSparkBlockObj != undefined && getSparkBlockObj.dataArray != null )
					{
						var getDataArray = getSparkBlockObj.dataArray;
						var arrCnt = 0;
						for ( var jj = counter; jj < cnt; jj++ )
						{
							var getInnerHTML = getSparkBlockObj.getEl().dom.innerHTML;
							if ( getInnerHTML.indexOf('system-chartSparkContainer'+jj) > -1 )
							{
								var chartDatObj = new Date();
								var rndrId = 'system-chartSparkContainer'+i+'_'+chartDatObj.getMinutes()+"_"+chartDatObj.getSeconds();
								var tmpXMLData = getDataArray[arrCnt]['XML_DATA'];
								if ( tmpXMLData != '-' )
								{
									var swfPath = getDataArray[arrCnt]['SPARK_PATH'];
									var sparkChart = getSparkCharts('system-chartSparkContainer'+jj,'90','20',tmpXMLData,swfPath);
								}
							}
							arrCnt++;
						}
						counter += getSparkBlockObj.dataArray.length;
					}
				}

				for ( var ii = 0; ii < configsData.length; ii++ )
				{
					var configData = configsData[ii];
					if ( configData['TYPE'].toLowerCase() == 'linear' )
					{
						var getBlockObj = Ext.getCmp('sysConfig-'+ii);
						//alert(getBlockObj+' '+getBlockObj.dataArray);
						if ( getBlockObj != undefined && getBlockObj.dataArray != undefined )
						{
							var tmpDataArray = getBlockObj.dataArray;
							for ( var j = 0 ; j < tmpDataArray.length; j++ )
							{
								var col1Data = tmpDataArray[j]['COLUMN_1'];
								var imgId = 'sysLinearguage-'+j;
								getHighChartsGuage(imgId,col1Data);
								
							}
						}
					}
				}
			}

		sysLastGraphTypeLoaded = 'SummaryAtGlance';
	},
	showHistoryTab: function ( tabId, resultData, isFlag)
	{
		var uptimeVal = resultData['uptimeURL'];
		var historyObj = Ext.getCmp(tabId);
		historyObj.setAutoScroll(true);
		if(isFlag == 'default')
		{
			historyObj.removeAll();
		}
		
		var isUptimeEnabled = false;

		if( uptimeVal!=null && !Ext.isEmpty(uptimeVal) && uptimeVal!=undefined)
		{
			this.loadUptimeSummary(tabId,uptimeVal, isFlag);
			isUptimeEnabled = true;
		}
		var subSystemVal = Ext.getCmp('systemsubsystem').getValue();
		//var defaultHeight = 0;

		if ( !Ext.isEmpty( subSystemVal ) && subSystemVal.toLowerCase() != 'overview' )
		{
			//defaultHeight = 133;
		}
		//historyObj.setHeight((Ext.getBody().getHeight()-240)+defaultHeight);
		//historyObj.setAutoScroll(true);
		if ( historyObj.getEl() != undefined )
		{
			historyObj.getEl().mask(loadingLbl+"...", "maskCenter");
		}
		var tmpHeight = historyObj.getHeight();
		var chartsData = resultData['CHARTS'];
		var hiddens = resultData['hiddens'];
		var subsystem = Ext.getCmp('systemsubsystem').getValue();
		sysLastGraphTypeLoaded = hiddens['graphType'];
		if ( !Ext.isEmpty( chartsData ) )
		{
			if ( chartsData['NO_CHARTS'] != undefined && chartsData['NO_CHARTS'] == 'true' )
			{
				var getMsg = chartsData['NO_CHARTS_MSG'];
				if(subsystem == 'Overview')
				{
					var marginvar="margin:11% auto 0px auto"
				}
				else
				{
					var marginvar="margin:16% auto 0px auto"
				}
				if (isFlag == 'default')
				{
					historyObj.add({
					xtype: 'container',
					id:'noCharts_Measure',
					//height: tmpHeight,
					width: '100%',
					html :'<div align="center" style="'+marginvar+'"><div class="iconInformation" style="margin:0px auto"></div><div>'+getMsg+'</div></div>'
				});
				}
				else if(Ext.getCmp('noCharts_Measure')!=null) 
				{
					Ext.getCmp('noCharts_Measure').update('<div align="center" style="'+marginvar+'"><div class="iconInformation" style="margin:0px auto"></div><div>'+getMsg+'</div></div>');
				}
				else
				{
					historyObj.add({
					xtype: 'container',
					id:'noCharts_Measure',
					//height: tmpHeight,
					width: '100%',
					html :'<div align="center" style="'+marginvar+'"><div class="iconInformation" style="margin:0px auto"></div><div>'+getMsg+'</div></div>'
					});
				}
			}
		}
		else if ( !Ext.isEmpty( resultData['MEASURE_GRAPHS'] ) && hiddens['graphType'] == 'measureGraph' )
		{
			var chartArr = new Array();
			var measureData = resultData['MEASURE_GRAPHS'];
			if (isFlag=='default')
			{
				historyObj.add({
					xtype: 'panel',
					id: 'sys-chart-container',

				width: '100%',
				//autoScroll: true,
				//height: ( 315 + defaultHeight ),
				margin:'10 10 10 10',
				layout: 'column',
				defaults: {
					columnWidth: 0.333
				}
			});
		
			historyObj.doComponentLayout( );
			}
			for ( var i = 0; i < measureData.length; i++ )
			{
				var chartData = measureData[i];
				var tmpHeight = chartData['HEIGHT'];
				var tmpWidth = chartData['WIDTH'];
				var chartTitle = chartData['TITLE'];
				var toolTipTitle = chartData['TOOLTIP_TITLE'];
				var imgSrc = chartData['IMG_SRC'];
				var hightChartEnabled = chartData['HIGH_CHART'];
				var genHTML = '';
				if ( hightChartEnabled == 'false' )
				{
					var maxViewUrl = measureData[i]['PARAMS'];
					genHTML = '<img onClick="javascript:MeasureGraphOnClick(\''+maxViewUrl+'\');" src="'+imgSrc+'" height="'+tmpHeight+'" width="'+tmpWidth+'" />';
				}
				else
				{
					genHTML = '<div id="sys-high-chart-'+i+'" style="border:0px solid yellow;height:'+tmpHeight+'px;width:'+tmpWidth+'px;margin:0px auto"></div>';
				}
				chartArr.push({
					xtype: 'panel',
					cls:'datapanel optionalListPanel cursor',
					margin:'5',
					//padding:5,
					id: 'sys-measure-graph-'+i,
					width: '100%',
					dataArray: chartData,
					items: [
						{
							xtype: 'label',
							style:{'text-align':'center'},
							html: '<div title="'+toolTipTitle+'" class="font_bold" style="padding:15px 5px 0px 5px">'+chartTitle+'</div>'
						},
						{
							xtype: 'container',
							width: '100%',
							html: '<div>'+genHTML+'</div></div>'
							//<div style="text-align:center"><div data-qtip="'+toolTipTitle+'"     data-qclass="yellowTip"><b>'+chartTitle+'</b></div>
						}
					]

				});
			}

			Ext.getCmp('sys-chart-container').removeAll();
			Ext.getCmp('sys-chart-container').add(chartArr);
			//Ext.getCmp('sys-chart-container').doLayout();
			for ( var i = 0; i < measureData.length; i++ )
			{
				var imgSrc = measureData[i]['IMG_SRC'];
				if ( measureData[i]['HIGH_CHART'] == 'true' )
				{
					var maxViewUrl = measureData[i]['PARAMS'];
					if ( Ext.get('sys-high-chart-'+i) != null && Ext.get('sys-high-chart-'+i) != 'null' && Ext.get('sys-high-chart-'+i) != undefined )
					{
						Ext.Ajax.request({
							url: imgSrc,
							method: 'GET',
							async: false,
							success: function( response )
							{
								if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
								{
									var tmpJsonTxt = response.responseText;
									if ( tmpJsonTxt.indexOf('png') == -1 && tmpJsonTxt.indexOf('PNG') == -1 && tmpJsonTxt.indexOf('gif') == -1 && tmpJsonTxt.indexOf('GIF') == -1 )
									{
										var tmpJsonData = Ext.decode( tmpJsonTxt );

										try
										{
											var lineChart = {};
											lineChart = jQuery.extend(true, {}, getHighCharts('sys-high-chart-'+i, measureData[i]['HEIGHT'],measureData[i]['WIDTH'],maxViewUrl), lineChart);
											if ( tmpJsonData.hasOwnProperty('title'))
											{
												tmpJsonData.title='';
											}
											tmpJsonData['legVerAlignWBottom'] = true;
											lineChart.setData(tmpJsonData,currentDateFormat,maxViewUrl,false,'bottom');
											lineChart.drawChart();
										}
										catch (e)
										{
											alert("e::"+e)
										}
									}
									else
									{
										Ext.get('sys-high-chart-'+i).update('<table width="100%" height="100%" style="text-align:center"><tr><td><div class="iconInformation" style="margin:-16px auto 0px auto"></div><div>'+noMeasureExcl+'</div></td></tr></table>');
									}
								}
								else
								{
									Ext.get('sys-high-chart-'+i).update('<table width="100%" height="100%" style="text-align:center"><tr><td><div class="iconInformation" style="margin:-16px auto 0px auto"></div><div>'+noMeasureExcl+'</div></td></tr></table>');
								}
							}
						});
					}
				}
			}
		}
		else if ( !Ext.isEmpty( resultData['SUMMARY_GRAPHS'] ) && hiddens['graphType'] == 'summaryGraph' )
		{
			var chartArr = new Array();
			var measureData = resultData['SUMMARY_GRAPHS'];
			if(isFlag == 'default')
			{
				historyObj.add({
				xtype: 'panel',
				//style:{'border':'2px green solid'},
				id: 'sys-chart-container',
				width: '100%',
				//autoScroll: !isUptimeEnabled,
				//height: ( 315 + defaultHeight ),
				layout: 'column',
				defaults: {
					columnWidth: 0.5
					}
				});
				historyObj.doLayout( );
			}			
			
			for ( var i = 0; i < measureData.length; i++ )
			{
				var chartData = measureData[i];
				var tmpWidth = chartData['WIDTH'];
				var tmpHeight = chartData['HEIGHT'];
				var chartTitle = chartData['TITLE'];
				var toolTipTitle = chartData['TOOLTIP_TITLE'];
				var maxUrl = chartData['summryFullviewGraphUrl'];
				chartArr.push(
					{
						xtype:'container',
						margin:10,
						cls:'containerShadow',
						items:[
						{
							xtype: 'label',
							style:{'text-align':'center'},
							html: '<div title="'+toolTipTitle+'" class="font_bold" style="padding:15px 5px 0px 5px">'+chartTitle+'</div>'
						},
						{ 
							xtype: 'container',
							margin:'10',
							width: '100%',
							id: 'sys-summary-graph-'+i,
							dataArray: chartData,
							MaxURL :maxUrl,
							style:{
								cursor:'pointer'
							},
							html: '<div style="text-align:center;padding:0px 0px" ><div id="sys-summaryChart-'+i+'" style="width:'+tmpWidth+'px;height:'+tmpHeight+'px;margin:0px auto"></div></div>',
							listeners : {
								'afterrender' : function()
								{
									var xmlData = this.dataArray['XML_DATA'];
									if ( xmlData != '-' )
									{
											try
											{
												var barChart = {};
												barChart = jQuery.extend(true, {}, getHighChartsBarInstance(this.id, 250, tmpWidth), barChart);
												barChart.setData(xmlData, currentDateFormat,this.MaxURL ,'stackedColumn');
												barChart.drawChart();
											}
											catch (barChartEx)
											{
												console.log(barChartEx);
										}
									}
								}
							}
						}
					]
				});
			}
			Ext.getCmp('sys-chart-container').removeAll();
			Ext.getCmp('sys-chart-container').add(chartArr);
			historyObj.doLayout( );
			//Ext.getCmp('sys-chart-container').doComponentLayout( );			
		}
		else if ( !Ext.isEmpty( resultData['TREND_GRAPHS'] ) && hiddens['graphType'] == 'trendGraph' )
		{
			var chartArr = new Array();
			var measureData = resultData['TREND_GRAPHS'];
			if(isFlag == 'default')
			{	
				historyObj.add({
				xtype: 'panel',
				id: 'sys-chart-container',
				width: '100%',				
				//overflowX:'hidden',
				//overflowY:'auto',
				//autoScroll: !isUptimeEnabled,
				//style:{'overflowX':'hidden','overflow-Y':'auto'},
				//height: ( 315 + defaultHeight ),
				layout: 'column',
				defaults: {
					columnWidth: 0.33
					}
				});
				historyObj.doLayout();
			}
			
			
			for ( var i = 0; i < measureData.length; i++ )
			{
				var chartData = measureData[i];
				var tmpWidth = chartData['WIDTH'];
				var tmpHeight = chartData['HEIGHT'];
				var chartTitle = chartData['TITLE'];
					chartArr.push({
						xtype: 'panel',
						cls:'datapanel optionalListPanel cursor',
						margin:'10',
						//padding:5,
						id: 'sys-trend-graph-'+i,
						width: '100%',
						//style : 'border:2px solid red',
						dataArray: chartData,
						items: [
							{
								xtype: 'label',
								style:{'text-align':'center'},
								html: '<div title="'+toolTipTitle+'" style="margin-top:7px;text-align:center" class="font_bold">'+chartTitle+'</div>'
							},
							{
								xtype: 'container',
								id : 'sys-trendChart-'+i,
								//style : 'border:2px solid blue',
								width: '100%',
								height : parseInt(tmpHeight)
								//html: '<div id="sys-trendChart-'+i+'" style="border:1px solid yellow;cursor:pointer;height:'+tmpHeight+'px;width:100%"></div>'
								//<div style="text-align:center"><div data-qtip="'+toolTipTitle+'"     data-qclass="yellowTip"><b>'+chartTitle+'</b></div>
							}
						]

					});
			}
			Ext.getCmp('sys-chart-container').removeAll();
			Ext.getCmp('sys-chart-container').add(chartArr);
			historyObj.doComponentLayout( );
			for ( var i = 0; i < measureData.length; i++ )
			{
				var getSummaryObj = Ext.getCmp('sys-trend-graph-'+i);
				var tmpDataArray = getSummaryObj.dataArray;
				var charwidth = getSummaryObj.getWidth();
				var xmlData = tmpDataArray['XML_DATA'];
				if ( xmlData != '-' )
				{
						try
						{
							var chartWidth = tmpDataArray['WIDTH'];
							var chartHeight = tmpDataArray['HEIGHT'];
							var maxUrl = tmpDataArray['minMaxtrendFullView'];
							//chartHeight=220;
							var lineChart = {};
							lineChart = jQuery.extend(true, {}, createLineChart('sys-trendChart-'+i,chartHeight,charwidth-10,false), lineChart);
							lineChart.setData(xmlData, currentDateFormat,maxUrl ,'line',true);
							lineChart.drawChart();
						}
						catch (barChartEx)
						{
							console.log(barChartEx);
						}
				}
			}
		}

		if ( Ext.getCmp('sys-calendar-btn') != undefined )
		{
			//Ext.getCmp('sys-calendar-btn').fireEvent('loadTime', Ext.getCmp('sys-calendar-btn'));
		}
		if ( historyObj.getEl() != undefined )
		{
			historyObj.getEl().unmask();
			
		}
			
	},

    callView: function( graphType )
    {
		var isFlag = 'default';
    	var getPanelObj = Ext.getCmp(Ext.getCmp('systabpanel').getActiveTab().getId());
    	getPanelObj.getEl().mask(loadingLbl+'...', 'maskCenter');
    	var me = this;
    	var tmpTimeline = (Ext.getCmp('sys_er_timeline')!=undefined)?Ext.getCmp('sys_er_timeline').getValue():timelineVals['timeline'];

		var startDt="";
		var endDt="";
		if((Ext.getCmp('sys_er_stdate') != undefined))
		{
			startDt = formatDate(Ext.getCmp('sys_er_stdate').getValue(), mgrDisplayDateFormat);	
		}
		else
		{
			startDt = timelineVals['starttime'];
		}
		if((Ext.getCmp('sys_er_enddate') != undefined))
		{
			endDt = formatDate(Ext.getCmp('sys_er_enddate').getValue(), mgrDisplayDateFormat);
		}
		else
		{
			endDt = timelineVals['endtime'];
		}
    	var starthr = (Ext.getCmp('sys_er_sthr') != undefined )?Ext.getCmp('sys_er_sthr').getValue():timelineVals['starthour'];
    	var endhr = (Ext.getCmp('sys_er_endhr') != undefined )?Ext.getCmp('sys_er_endhr').getValue():timelineVals['endhour'];
		var genParams = '';
		if (graphType == 'summaryGraph' || graphType == 'trendGraph' )
		{
    		genParams = 'tab=System&hostName='+encodeURIComponent(requestParams.hostName)+'&compType='+encodeURIComponent(componentType)+'&subsystem='+encodeURIComponent(Ext.getCmp('systemsubsystem').getValue())+'&graphType='+encodeURIComponent(graphType)+'&showGraph='+encodeURIComponent(graphType)+'&time_line=24 hours&starttime='+encodeURIComponent(startDt)+'&endtime='+encodeURIComponent(endDt)+'&starthr='+encodeURIComponent(starthr)+'&endhr='+encodeURIComponent(endhr)+'&format='+encodeURIComponent(dateFormatForTimeline)+'&host='+encodeURIComponent(requestParams.hostName);
		}
		else
		{
			genParams = 'tab=System&hostName='+encodeURIComponent(requestParams.hostName)+'&compType='+encodeURIComponent(componentType)+'&subsystem='+encodeURIComponent(Ext.getCmp('systemsubsystem').getValue())+'&graphType='+encodeURIComponent(graphType)+'&showGraph='+encodeURIComponent(graphType)+'&time_line=1 hour&starttime='+encodeURIComponent(startDt)+'&endtime='+encodeURIComponent(endDt)+'&starthr='+encodeURIComponent(starthr)+'&endhr='+encodeURIComponent(endhr)+'&format='+encodeURIComponent(dateFormatForTimeline)+'&host='+encodeURIComponent(requestParams.hostName);
		}
		sysLastLoadedURL = '/final/monitor/egSysDashBoardJSON.jsp?'+genParams;
		me.loadInnerTab(Ext.getCmp('systabpanel').getActiveTab().getId(), '/final/monitor/egDashboardHistoryJSON.jsp?'+genParams,isFlag);
	sysLastGraphTypeLoaded = graphType;
    },
    loadUptimeSummary : function(tabId , uptimeURL,isFlag )
	{
		var uptimeArr ='';
		var atAGlanceArr = new Array();
		Ext.Ajax.request({
    		url: uptimeURL,
    		method: 'POST',
			async: false,
    		success: function( response )
    		{
    			if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
    			{
    				var jsonText = response.responseText;
    				var jsonData = Ext.decode( jsonText );
					uptimeArr = jsonData['uptimeArr'];
					var uptimeDatas = uptimeArr[0];
					var rebootDatas = uptimeArr[1];
					var tableTitle = uptimeDatas['tableTitle'];
					var historyObj = Ext.getCmp(tabId);
					
					if(isFlag=='default')
					{
						historyObj.removeAll();
						historyObj.add({
							xtype: 'container',
							columnWidth: 3.0,
							layout: 'column',
							width:'100%',
							defaults:{
							columnWidth:0.5},
							padding: 4,
							id: 'sys-uptime-container'
						});
						historyObj.doComponentLayout( );
					}

					var uptimeObj = Ext.getCmp('sys-uptime-container');
					var RebootTitle = rebootDatas['RebootTitle'];
					var msg = rebootDatas['Msg'];
					var genHTML="";
					var genaHTML="";

					if( tableTitle!=null && !Ext.isEmpty(tableTitle) )
					{
						genHTML = '<div class="x-table"><table cellspacing="0" cellpadding="0" border="0" class="x-grid-table x-grid-table-resizer" width="100%"><tbody>';
						genHTML += '<tr class="x-grid-row">';
						genHTML += '<td class="x-grid-cell" ><div class="x-grid-cell-inner">'+uptimeDatas['COLUMN_0']+'</div></td>'
						genHTML += '<td class="x-grid-cell"><div class="x-grid-cell-inner">'+uptimeDatas['COLUMN_0_val']+'</div></td>';
						genHTML += '</tr>';
						genHTML += '<tr class="x-grid-row">';
						genHTML += '<td class="x-grid-cell"><div class="x-grid-cell-inner">'+uptimeDatas['COLUMN_1']+'</div></td>';
						genHTML += '<td class="x-grid-cell"><div class="x-grid-cell-inner">'+uptimeDatas['COLUMN_1_val']+'</div></td>';
						genHTML += '</tr>';
						genHTML += '<tr class="x-grid-row">';
						genHTML += '<td class="x-grid-cell"><div class="x-grid-cell-inner">'+uptimeDatas['COLUMN_2']+'</div></td>';
						genHTML += '<td class="x-grid-cell"><div class="x-grid-cell-inner">'+uptimeDatas['COLUMN_2_val']+'</div></td>';
						genHTML += '</tr>';
						genHTML += '<tr class="x-grid-row">';
						genHTML += '<td class="x-grid-cell"><div class="x-grid-cell-inner">'+uptimeDatas['COLUMN_3']+'</div></td>';
						genHTML += '<td class="x-grid-cell"><div class="x-grid-cell-inner">'+uptimeDatas['COLUMN_3_val']+'</div></td>';
						genHTML += '</tr>';
						genHTML += '<tr class="x-grid-row">';
						genHTML += '<td class="x-grid-cell"><div class="x-grid-cell-inner">'+uptimeDatas['COLUMN_4']+'</div></td>';
						genHTML += '<td class="x-grid-cell"><div class="x-grid-cell-inner">'+uptimeDatas['COLUMN_4_val']+'</div></td>';
						genHTML += '</tr>';
						genHTML +='</tbody></table></div>';

					}
					else
					{

						genHTML = '<div width="100%" align="center"><div class="iconInformation" width="100%" style="text-align:center;margin:0px auto"></div><div>'+noMeasureExcl+'</div>';
					}

					if( msg!=null && msg == 'true' )
					{
						 genaHTML += '<div style="text-align:center;margin:5% 0px 0px 0px"><div class="iconInformation"  style="text-align:center;margin:0px auto"></div><div>'+rebootDatas['EmptyMsg']+'!</div></div>';
					}
					else
					{
						genaHTML = '<div class="x-table"><table class="x-grid-table x-grid-table-resizer" cellspacing="0" cellpadding="0" border="0" class="x-grid-table x-grid-table-resizer" width="100%"><tbody>';
						genaHTML += '<tr class="x-grid-row" >';
						genaHTML += '<td class="x-grid-cell" ><div class="x-grid-cell-inner">'+rebootDatas['COLUMN_0']+'</div></td>'
						genaHTML += '<td class="x-grid-cell"><div class="x-grid-cell-inner">'+rebootDatas['COLUMN_1_val']+'</div></td>';
						genaHTML += '</tr>';
						genaHTML += '<tr class="x-grid-row">';
						genaHTML += '<td class="x-grid-cell"><div class="x-grid-cell-inner">'+rebootDatas['COLUMN_1']+'</div></td>';
						genaHTML += '<td class="x-grid-cell"><div class="x-grid-cell-inner">'+rebootDatas['COLUMN_2_val']+'</div></td>';
						genaHTML += '</tr>';
						genaHTML +='</tbody></table></div>';
					}
					atAGlanceArr.push({
							xtype: 'commonPanel',
							id: 'sys-uptimeSum',
							cls:'datapanel',
							frame:true,
							padding:'0px 0px 0px 0px',
							height: 140 ,
							title:tableTitle,
							html : genHTML
					});
					atAGlanceArr.push({
							xtype: 'commonPanel',
							id: 'sys-rebootSum',
							height:140 ,
							cls:'datapanel',
							frame:true,
							padding:'0px 0px 0px 0px',
							title:RebootTitle,
							html : genaHTML
					});
					uptimeObj.removeAll();
					uptimeObj.add(atAGlanceArr);
					uptimeObj.doComponentLayout( );
				}
			}
	   	});
	},
	ddOnclick: function(urlData)
	{
		Ext.getCmp('systemupperpanelId').hide();
		Ext.getCmp('systemlowerpanelId').hide();
		comboChangeURL = '/final/monitor/egDashTimelineJSON.jsp?'+urlData+'&graphType=DDgraph';
		var networkObj = this.getCompdashdetailsMaintab();
		networkObj.remove('sysfullviewpanel');
		var fullviewObj = {
			xtype:'sysfullviewpanel',
			Dataurl:'/final/monitor/egDashTimelineJSON.jsp?'+urlData+'&graphType=DDgraph',
			viewType:'barGraph',
			gtype:'bar'
		};
		networkObj.add(fullviewObj);
		networkObj.doLayout();	
	},
	comparisionBarOnclick: function(urlData)
	{
		Ext.getCmp('systemupperpanelId').hide();
		Ext.getCmp('systemlowerpanelId').hide();
		urlData = urlData.split('?');
		var params = urlData[1];
		comboChangeURL = '/final/monitor/egDashTimelineJSON.jsp?'+params+'&graphType=comparisionBargraph';
		var wobj = this.getCompdashdetailsMaintab();
		wobj.remove('sysfullviewpanel');
		var fullviewObj = {
			xtype:'sysfullviewpanel',
			width : (Ext.getBody().getViewSize().width),
			height : (Ext.getBody().getViewSize().height-60),
			Dataurl:'/final/monitor/egDashTimelineJSON.jsp?'+params+'&graphType=comparisionBargraph',
			viewType:'barGraph',
			gtype:'bar'
		};
		wobj.add(fullviewObj);
		wobj.doLayout();
	},
	trendGraphOnclick: function(urlData)
	{		
		Ext.getCmp('systemupperpanelId').hide();
		Ext.getCmp('systemlowerpanelId').hide();
		urlData = urlData.split('?');
		var params = urlData[1];
		comboChangeURL = '/final/monitor/egDashTimelineJSON.jsp?'+params+'&graphType=Trendgraph';
		var wobj = this.getCompdashdetailsMaintab();
		wobj.remove('sysfullviewpanel');
		var fullviewObj = {
			xtype:'sysfullviewpanel',
			width : (Ext.getBody().getViewSize().width),
			height : (Ext.getBody().getViewSize().height-60),
			Dataurl:'/final/monitor/egDashTimelineJSON.jsp?'+params+'&graphType=Trendgraph',
			viewType:'trendGraph',
			gtype:'trend'
		};
		wobj.add(fullviewObj);
		wobj.doLayout();
	},
	summaryGraphOnclick: function(urlData)
	{		
		Ext.getCmp('systemupperpanelId').hide();
		Ext.getCmp('systemlowerpanelId').hide();
		urlData = urlData.split('?');
		var params = urlData[1];
		comboChangeURL = '/final/monitor/egDashTimelineJSON.jsp?'+params+'&graphType=Summarygraph';
		var wobj = this.getCompdashdetailsMaintab();
		wobj.remove('sysfullviewpanel');
		var fullviewObj = {
			xtype:'sysfullviewpanel',
			width : (Ext.getBody().getViewSize().width),
			height : (Ext.getBody().getViewSize().height-60),
			Dataurl:'/final/monitor/egDashTimelineJSON.jsp?'+params+'&graphType=Summarygraph',
			viewType:'Summarygraph',
			gtype:'summary'
		};
		wobj.add(fullviewObj);
		wobj.doLayout();
	},
	ComparisonGraphGraphOnClick: function(urlData)
	{
		Ext.getCmp('systemupperpanelId').hide();
		Ext.getCmp('systemlowerpanelId').hide();
		urlData = urlData.split('?');
		var params = urlData[1];
		comboChangeURL = '/final/monitor/egDashTimelineJSON.jsp?'+params+'&graphType=comparisionBargraph';
		var wobj = this.getCompdashdetailsMaintab();
		wobj.remove('sysfullviewpanel');
		var fullviewObj = {
			xtype:'sysfullviewpanel',
			width:'100%',
			//width : (Ext.getBody().getViewSize().width),
			height : (Ext.getBody().getViewSize().height-60),
			Dataurl:'/final/monitor/egDashTimelineJSON.jsp?'+params+'&graphType=comparisionBargraph',
			viewType:'barGraph',
			gtype:'bar'
		};
		
		wobj.add(fullviewObj);
		wobj.doLayout();
	},
	DDGraphOnClick: function(urlData)
	{
		Ext.getCmp('systemupperpanelId').hide();
		Ext.getCmp('systemlowerpanelId').hide();
		urlData = urlData.split('?');
		var params = urlData[1];
		comboChangeURL = '/final/monitor/egDashTimelineJSON.jsp?'+params+'&graphType=DDgraph';
		var wobj = this.getCompdashdetailsMaintab();
		wobj.remove('sysfullviewpanel');
		var fullviewObj = {
			xtype:'sysfullviewpanel',
			width:'100%',
			//width : (Ext.getBody().getViewSize().width),
			height : (Ext.getBody().getViewSize().height-60),
			Dataurl:'/final/monitor/egDashTimelineJSON.jsp?'+params+'&graphType=DDgraph',
			viewType:'barGraph',
			gtype:'bar'
		};
		
		wobj.add(fullviewObj);
		wobj.doLayout();
	},
	MeasureGraphOnClick: function(urlData)
	{
		Ext.getCmp('systemupperpanelId').hide();
		Ext.getCmp('systemlowerpanelId').hide();
		urlData = urlData.split('?');
		var params = urlData[1];
		comboChangeURL = '/final/monitor/egDashTimelineJSON.jsp?'+params+'&graphType=measureGraph';
		var wobj = this.getCompdashdetailsMaintab();
		wobj.remove('sysfullviewpanel');
		var fullviewObj = {
			xtype:'sysfullviewpanel',
			width:'100%',
			//width : (Ext.getBody().getViewSize().width),
			height : (Ext.getBody().getViewSize().height-60),
			Dataurl:'/final/monitor/egDashTimelineJSON.jsp?'+params+'&graphType=measureGraph',
			viewType:'measureGraph',
			gtype:'measure'
		};
		
		wobj.add(fullviewObj);
		wobj.doLayout();
	},
	loadFullViewPanel: function()
	{
		var me =this;
		var fullViewPanelObj = Ext.getCmp('sys-fullviewId');
		var urlData = fullViewPanelObj.Dataurl;
		var fullViewPnlObj = fullViewPanelObj.up('panel');
		fullViewPanelObj.setLoading(true,true);
		fullViewPanelObj.setWidth(fullViewPnlObj.getWidth());
		fullViewPanelObj.doComponentLayout();
		urlData +='&screenWidth='+(fullViewPnlObj.getWidth())+'&screenHeight='+(fullViewPnlObj.getHeight());
		var viewType = Ext.getCmp('sys-fullviewId').viewType;
		if (viewType == 'barGraph')
		{
			Ext.getCmp('sys-period').hide();
//			Ext.getCmp('sys-modeID').hide();
			Ext.getCmp('sys-graphID').hide();
			Ext.getCmp('sys-Show').show();
		}
		else if (viewType == 'trendGraph')
		{
			Ext.getCmp('sys-period').show();
//			Ext.getCmp('sys-modeID').show();
			Ext.getCmp('sys-graphID').show();
			Ext.getCmp('sys-Show').hide();
		}
		else if (viewType == 'Summarygraph')
		{
			Ext.getCmp('sys-period').show();
//			Ext.getCmp('sys-modeID').show();
			Ext.getCmp('sys-Show').hide();
		}
		else if (viewType == 'measureGraph' )
		{
			Ext.getCmp('sys-period').hide();
			Ext.getCmp('sys-Show').hide();
//			Ext.getCmp('sys-modeID').show();
		}
		Ext.Ajax.request({
			url:urlData,
			scope:this,
			method: 'POST',
			success: function( response )
			{

				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					var dateArray = jsonData['dateArrayValues'];
					var trendGrpDuration = jsonData['trendGrpDuration'];
					if (trendGrpDuration!=null && trendGrpDuration!='' && !Ext.isEmpty(trendGrpDuration))
					{
						var durationLabel = trendGrpDuration['monitor.dashboard.Duration'];
						var selectedDuration = trendGrpDuration['selectedDuration'];
						var durationComboVal = trendGrpDuration['trendGrpDurationArr'];

						var durationObj = Ext.getCmp('sys-period');
						durationObj.setFieldLabel(durationLabel);
						durationObj.getStore().loadRawData(durationComboVal);
						durationObj.setValue(selectedDuration);
					}
					var barGraphVal = jsonData['BARGRAPH'];
					if( barGraphVal!=null && barGraphVal!=''& !Ext.isEmpty(barGraphVal))
					{
						var showLabel = barGraphVal['monitor.common.Show'];
						var selectedShowVal = barGraphVal['selectedShowCombo'];
						var showComboVal = barGraphVal['barGraphShowCombo'];
					//	var historyLabel = barGraphVal['monitor.measure.History'];
						var showComboObj = Ext.getCmp('sys-Show');
						showComboObj.setFieldLabel(showLabel);
						showComboObj.getStore().loadRawData(showComboVal);
						showComboObj.setValue(selectedShowVal);
					}
					var timelineValues = jsonData['timelineCombo'];
					if ( timelineValues!=null && timelineValues!=''& !Ext.isEmpty(timelineValues) )
					{
						var timelineLabel = timelineValues['monitor.dashboard.TimeLine'];
						var selectedTimelineCombo = timelineValues['selectedTimelineCombo'];
						var TimelineComboVal = timelineValues['timelineCombo'];

						var timelineObj = Ext.getCmp('sys-high_er_timeline');
						timelineObj.setFieldLabel(timelineLabel);
						timelineObj.getStore().loadRawData(TimelineComboVal);
						timelineObj.setValue(selectedTimelineCombo);
					}	
					var fromData = jsonData['fromValues'];
					if ( fromData!=null && fromData!=''& !Ext.isEmpty(fromData) )
					{
						var fromlabel = fromData['monitor.VirtualDashboard.From'];
						var isFromDisabled = fromData['from'];
						var fromValue = fromData['value'];
						var fromObj = Ext.getCmp('sys-high_er_stdate');
						fromObj.setFieldLabel(fromlabel);
						fromObj.setDisabled(isFromDisabled);						
						
						fromObj.dataArray = dateArray[0];
						fromObj.setValue(dateArray[6]);
					}
					var startHr = jsonData['startHr'];
					if ( startHr!=null && startHr!=''& !Ext.isEmpty(startHr) )
					{
						var hrLabel = startHr['monitor.VirtualDashboard.Hr'];
						var isStartHrEnabled = startHr['isStartHrEnabled'];
						var selectedStartHr = startHr['selectedStartHr'];
						var startHrCmbo = startHr['startHrArray'];

						var startHrObj = Ext.getCmp('sys-high_er_sthr');
						startHrObj.setFieldLabel(hrLabel);
						startHrObj.getStore().loadRawData(startHrCmbo);						
						startHrObj.setDisabled(isStartHrEnabled);

						startHrObj.dataArray = dateArray[2];
						startHrObj.setValue(dateArray[7]);
					}
					var toValues = jsonData['toValues'];
					if ( toValues!=null && toValues!=''& !Ext.isEmpty(toValues) )
					{
						var toLabel = toValues['monitor.VirtualDashboard.To'];
						var isToDisabled = toValues['to'];
						var value = toValues['value'];
						var toObj = Ext.getCmp('sys-high_er_enddate');
						toObj.setDisabled(isToDisabled);
						toObj.setFieldLabel(toLabel);					

						toObj.dataArray = dateArray[1];
						toObj.setValue(dateArray[9]);
					}
					var endHr = jsonData['endHr'];
					if ( endHr!=null && endHr!=''& !Ext.isEmpty(endHr) )
					{
						var hrLabel = endHr['monitor.VirtualDashboard.Hr'];
						var isEndHrEnabled = endHr['isEndHrEnabled'];
						var selectedEndHr = endHr['selectedEndHr'];
						var endHrCmbo = endHr['endHrArray'];

						var endHrObj = Ext.getCmp('sys-high_er_endhr');
						endHrObj.setFieldLabel(hrLabel);
						endHrObj.getStore().loadRawData(endHrCmbo);						
						endHrObj.setDisabled(isEndHrEnabled);

						endHrObj.dataArray = dateArray[3];
						endHrObj.setValue(dateArray[10]);
					}
					var ModeCombo="2D";
				/*	var ModeCombo = jsonData['ModeCombo'];
					if (ModeCombo!=null && ModeCombo!=undefined && ModeCombo!='')
					{
						var modeComboVal = ModeCombo['comparisonBarModeArr'];
						var selectedMode = ModeCombo['selectedMode'];

						var modeObj = Ext.getCmp('sys-modeID');
						modeObj.getStore().loadRawData(modeComboVal);
						modeObj.setValue(selectedMode);
					}*/
					var GraphCombo = jsonData['GraphCombo'];
					if (GraphCombo!=null && GraphCombo!=undefined && GraphCombo!='')
					{
						var graphLabel = GraphCombo['monitor.dashboard.Graph'];
						var graphComboVal = GraphCombo['trendGraph'];
						var selectedGraph = GraphCombo['selectedGraph'];

						var graphObj = Ext.getCmp('sys-graphID');
						graphObj.setFieldLabel(graphLabel);
						graphObj.getStore().loadRawData(graphComboVal);
						graphObj.setValue(selectedGraph);
					}
					var ddGraphLink = jsonData['ddGraphObj'];
					if ( ddGraphLink!=null && ddGraphLink!=''& !Ext.isEmpty(ddGraphLink) )
					{
						var DetailsLink = ddGraphLink['DetailsLink'];
						var DetailsLabel = ddGraphLink['DetailsLabel'];
						if (DetailsLink == 'true')
						{
							Ext.getCmp('sys_detailsID').show();
						}
					}
					var fullViewContObj = Ext.getCmp('sys-fullViewBarId');
					fullViewContObj.removeAll();
					fullViewContObj.update('');
					if (viewType == 'measureGraph' )
					{
						var MeasureGraphImage = jsonData['MeasureGraphImage'];
						if (MeasureGraphImage!=null && MeasureGraphImage!=''& !Ext.isEmpty(MeasureGraphImage) && MeasureGraphImage!=undefined)
						{
							var DATA = MeasureGraphImage['DATA'];
							var Title = MeasureGraphImage['TITLE'];
							var HIGH_CHART = MeasureGraphImage['HIGH_CHART'];
							var isHighChartEnabled = '';
							if (HIGH_CHART == 'highcharts')
							{
								isHighChartEnabled = true;
							}
							else
							{
								isHighChartEnabled = false;
							}
							var minMaxTable = jsonData['minMaxTable'];
							var minMaxTableHeadersArray = '';
							var measuresTableDataArray = '';
							if (minMaxTable!=null && minMaxTable!=''& !Ext.isEmpty(minMaxTable) && minMaxTable!=undefined)
							{
								minMaxTableHeadersArray = minMaxTable['minMaxTableHeadersArray'];
							}
							var measuresTable = jsonData['measuresTable'];
							if (measuresTable!=null && measuresTable!=''& !Ext.isEmpty(measuresTable) && measuresTable!=undefined)
							{						
								measuresTableDataArray = measuresTable['measuresTableDataArray'];	
							}
							if (DATA == 'true')
							{
								var img_src = MeasureGraphImage['iframeSrc'];
								fullViewPanelObj.setTitle(Title);
								me.loadMeasureGraph(img_src,isHighChartEnabled);
							}
							else
							{
								var Msg = MeasureGraphImage['Msg'];
								fullViewContObj.update(Msg);
								fullViewPanelObj.setLoading(false);
							}
						}
					}
					else
					{
						var FullViewXmlData = jsonData['FullViewXmlData'];
						if ( FullViewXmlData!=null && FullViewXmlData!=''& !Ext.isEmpty(FullViewXmlData) )
						{
							var data = FullViewXmlData['DATA'];							
							if (data == 'true')
							{			
								var WIDTH = FullViewXmlData['WIDTH'];
								var HEIGHT = FullViewXmlData['HEIGHT'];
								HEIGHT = parseInt(HEIGHT);
								fullViewContObj.add({
									xtype: 'container',
									id: 'sys-fullViewPanelBigId',
									style:{'text-align':'center','margin':'20px auto'},
									xmlData:FullViewXmlData,
									width:WIDTH,
									height:HEIGHT,
									listeners:
									{
										'afterrender': function(thisObj)
										{
												var XMLDATA = thisObj.xmlData['XMLDATA'];
												try
												{													
													if (viewType == 'Summarygraph')
													{
														var barChart = {};
														barChart = jQuery.extend(true, {}, getHighChartsBarInstance(thisObj.id, HEIGHT,WIDTH), barChart);
														barChart.setData(XMLDATA, currentDateFormat, '','stackedColumn');
														barChart.drawChart();
													}
													else if (viewType == 'trendGraph')
													{
														var lineChart = {};
														lineChart = jQuery.extend(true, {}, createLineChart(thisObj.id,HEIGHT,WIDTH),lineChart);
														lineChart.setData(XMLDATA, currentDateFormat,'' ,'line',true);
														lineChart.drawChart();
													}
													else
													{
														var barChart = {};
														barChart = jQuery.extend(true, {}, getHighChartsBarInstance(thisObj.id, HEIGHT,WIDTH), barChart);
														barChart.setData(XMLDATA, currentDateFormat, '','bar');
														barChart.drawChart();
													}
													fullViewPanelObj.setLoading(false);
												}
												catch (barChartEx)
												{
													console.log(barChartEx);
												}
										}
									}
								});										
							}
							else
							{
								var msg = FullViewXmlData['MSG'];
								fullViewContObj.update(msg);
							}						
						}
					}
				}
			}
		});		
	},
	loadFullViewGraph: function(urlData)
	{
		var fullViewPanelObj = Ext.getCmp('sys-fullviewId');
		var fullViewPnlObj = fullViewPanelObj.up('panel');
		fullViewPanelObj.setLoading(true,true);
		urlData +='&screenWidth='+(fullViewPnlObj.getWidth()-10)+'&screenHeight='+(fullViewPnlObj.getHeight());
		var fullViewContObj = Ext.getCmp('sys-fullViewBarId');
		fullViewContObj.removeAll();
		fullViewContObj.update('');
		var me = this;
		var viewType = Ext.getCmp('sys-fullviewId').viewType;		
		Ext.Ajax.request({
			url:urlData,
			scope:this,
			method: 'POST',
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					if (viewType == 'measureGraph' )
					{
						var MeasureGraphImage = jsonData['MeasureGraphImage'];
						if (MeasureGraphImage!=null && MeasureGraphImage!=''& !Ext.isEmpty(MeasureGraphImage) && MeasureGraphImage!=undefined)
						{
							var DATA = MeasureGraphImage['DATA'];
							var Title = MeasureGraphImage['TITLE'];
							var HIGH_CHART = MeasureGraphImage['HIGH_CHART'];
							var isHighChartEnabled = '';
							if (HIGH_CHART == 'highcharts')
							{
								isHighChartEnabled = true;
							}
							else
							{
								isHighChartEnabled = false;
							}
							var minMaxTable = jsonData['minMaxTable'];
							var minMaxTableHeadersArray = '';
							var measuresTableDataArray = '';
							if (minMaxTable!=null && minMaxTable!=''& !Ext.isEmpty(minMaxTable) && minMaxTable!=undefined)
							{
								minMaxTableHeadersArray = minMaxTable['minMaxTableHeadersArray'];
							}
							var measuresTable = jsonData['measuresTable'];
							if (measuresTable!=null && measuresTable!=''& !Ext.isEmpty(measuresTable) && measuresTable!=undefined)
							{						
								measuresTableDataArray = measuresTable['measuresTableDataArray'];	
							}
							if (DATA == 'true')
							{
								var img_src = MeasureGraphImage['iframeSrc'];
								fullViewPanelObj.setTitle(Title);
								me.loadMeasureGraph(img_src,isHighChartEnabled);
							}
							else
							{
								var Msg = MeasureGraphImage['Msg'];
								fullViewContObj.update(Msg);
								fullViewPanelObj.setLoading(false);
							}							
						}
					}
					else
					{
						var FullViewXmlData = jsonData['FullViewXmlData'];
						if ( FullViewXmlData!=null && FullViewXmlData!=''& !Ext.isEmpty(FullViewXmlData) )
						{
							var data = FullViewXmlData['DATA'];
							var fullViewContObj = Ext.getCmp('sys-fullViewBarId');
							if (data == 'true')
							{		
								var WIDTH = FullViewXmlData['WIDTH'];
								var HEIGHT = FullViewXmlData['HEIGHT'];
								HEIGHT = parseInt(HEIGHT);
								fullViewContObj.add({
									xtype: 'container',
									id: 'sys-fullViewPanelBigId',
									xmlData:FullViewXmlData,
									width:WIDTH,
									height:HEIGHT,
									listeners:
									{
										'afterrender': function(thisObj)
										{
												var XMLDATA = thisObj.xmlData['XMLDATA'];
												var widthInPix = thisObj.xmlData['WIDTH'];
												var heightInPix = thisObj.xmlData['HEIGHT'];
												try
												{
													if (viewType == 'Summarygraph')
													{
														var barChart = {};
														barChart = jQuery.extend(true, {}, getHighChartsBarInstance(thisObj.id, heightInPix,widthInPix), barChart);
														barChart.setData(XMLDATA, currentDateFormat, '','stackedColumn');
														barChart.drawChart();
													}
													else if (viewType == 'trendGraph')
													{
														var lineChart = {};
														lineChart = jQuery.extend(true, {}, createLineChart(thisObj.id,parseInt(heightInPix),(parseInt(widthInPix) -20)), lineChart);
														lineChart.setData(XMLDATA, currentDateFormat,'' ,'line',true);
														lineChart.drawChart();
													}
													else
													{
														var barChart = {};
														var sysShowValue =  Ext.getCmp('sys-Show').getValue();
														if(sysShowValue == 'ALL')
														{
															chartcontainerHeight = 580;
														}
														else
														{
															chartcontainerHeight = 490;
														}
														var chartcontainerWidth=parseInt(fullViewPanelObj.getWidth())-100;
														barChart = jQuery.extend(true, {}, getHighChartsBarInstance(thisObj.id, chartcontainerHeight,chartcontainerWidth), barChart);
														barChart.setData(XMLDATA, currentDateFormat, '','bar');
														barChart.drawChart();
													}	
													fullViewPanelObj.setLoading(false);
												}
												catch (barChartEx)
												{
													console.log(barChartEx);
												}
										}
									}
								});										
							}
							else
							{
								var msg = FullViewXmlData['MSG'];
								fullViewContObj.update( '<table width="100%" height="300"><tr><td valign="middle" align="center"><div class="iconInformation" style="margin-top:5%"></div><div style="font-size:12px">'+msg+'</div></td></tr></table>');
								fullViewPanelObj.setLoading(false);
							}						
						}
					}
				}
			}
		});		
	},
	dateDiff: function( fromDate,toDate )
    {
    	var oneDay=24*60*60*1000;   //hours*mins*seconds*millisecs
		var fromDate=new Date(fromDate);
		var toDate=new Date(toDate);
		var diffDays = Math.round(Math.abs(fromDate.getTime()-toDate.getTime())/(oneDay));
		return diffDays;
    },
	goBtnOnClick: function()
	{		
		var showValue = Ext.getCmp('sys-Show').getValue();
		var timelineVal = Ext.getCmp('sys-high_er_timeline').getValue();
		var fromValue = Ext.getCmp('sys-high_er_stdate').getValue();
		fromValue = formatDate(Ext.getCmp('sys-high_er_stdate').getValue(), mgrDisplayDateFormat);
		var fromHrObj =  Ext.getCmp('sys-high_er_sthr');
		var toHrObj =  Ext.getCmp('sys-high_er_endhr');
		var fromHr =fromHrObj.getValue();

		var ToValue = Ext.getCmp('sys-high_er_enddate').getValue();
		ToValue = formatDate(Ext.getCmp('sys-high_er_enddate').getValue(), mgrDisplayDateFormat);
		var toHr = toHrObj.getValue();
		//Date validation

		var today = new Date();
		var diffDays = this.dateDiff(new Date(fromValue),new Date(ToValue));
		var currentDate = today.getMonth() + "/" + today.getDay() + "/" + today.getYear();
		if(timelineVal!=null && timelineVal.toLowerCase() == 'any')
		{
			if(new Date(fromValue) > new Date(ToValue))
			{
				Ext.MessageBox.show({
					title: alertLbl,
					msg: _stDateLessThanEndDateMsg,
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
				return false;
			}
			if(new Date(fromValue).valueOf() == new Date(ToValue).valueOf())
			{	
				if(fromHr > toHr)
				{
					Ext.MessageBox.show({
					title: alertLbl,
					msg: _stDateLessThanEndDateMsg,
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
					});
					return false;
				}
			}
			
			if(today < new Date(fromValue) )
			{
				Ext.MessageBox.show({
					title: alertLbl,
					msg: _fromdatelesserThanMsg,
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
					});
					return false;
			}
		}
		if ( viewType =='measureGraph')
		{
			if( diffDays > 14 )
			{
				Ext.MessageBox.show({
				title: alertLbl,
				msg: _timelineTwoWeeksMsg,
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
				});
				return false;
			}
		}
		

		var modeVal = '2D';//Ext.getCmp('sys-modeID').getValue();
		var durationVal = Ext.getCmp('sys-period').getValue();
		var graphVal = Ext.getCmp('sys-graphID').getValue();

		var viewType = Ext.getCmp('sys-fullviewId').viewType;
		if (viewType == 'barGraph')
		{
			comboChangeURL = comboChangeURL.replace(/(priority=)[^\&]+/, '$1' + showValue);
		}
		else if (viewType == 'trendGraph')
		{
			comboChangeURL = comboChangeURL.replace(/(mode=)[^\&]+/, '$1' + modeVal);
			if (comboChangeURL.indexOf('duration') > 0)
			{
				comboChangeURL = comboChangeURL.replace(/(duration=)[^\&]+/, '$1' + durationVal);
			}
			else
			{
				comboChangeURL += '&duration='+durationVal;
			}
			if (comboChangeURL.indexOf('trendType') > 0)
			{
				comboChangeURL = comboChangeURL.replace(/(trendType=)[^\&]+/, '$1' + graphVal);
			}
			else
			{
				comboChangeURL += '&trendType='+graphVal;
			}
			//comboChangeURL += '&duration='+durationVal+'&trendType='+graphVal;
		}
		else if ( viewType =='Summarygraph')
		{
			comboChangeURL = comboChangeURL.replace(/(mode=)[^\&]+/, '$1' + modeVal);
			if (comboChangeURL.indexOf('duration') > 0)
			{
				comboChangeURL = comboChangeURL.replace(/(duration=)[^\&]+/, '$1' + encodeURIComponent(durationVal));
			}
			else
			{
				comboChangeURL += '&duration='+encodeURIComponent(durationVal);
			}
		}
		else if ( viewType =='measureGraph')
		{
			comboChangeURL = comboChangeURL.replace(/(mode=)[^\&]+/, '$1' + modeVal);
		}
		
		comboChangeURL = comboChangeURL.replace(/(timeline_compare=)[^\&]+/, '$1' + encodeURIComponent(timelineVal));		
		comboChangeURL = comboChangeURL.replace(/(starttime=)[^\&]+/, '$1' + encodeURIComponent(fromValue));
		comboChangeURL = comboChangeURL.replace(/(starthr=)[^\&]+/, '$1' + fromHrObj.dataArray);
		comboChangeURL = comboChangeURL.replace(/(endtime=)[^\&]+/, '$1' + encodeURIComponent(ToValue));
		comboChangeURL = comboChangeURL.replace(/(endhr=)[^\&]+/, '$1' + toHrObj.dataArray);
		if (comboChangeURL.indexOf('durationChanged') > 0)
		{
			comboChangeURL = comboChangeURL.replace(/(durationChanged=)[^\&]+/, '$1' + 'false');
		}	
		else
		{
			comboChangeURL +='&durationChanged=false';
		}
		this.loadFullViewGraph(comboChangeURL);	
		Ext.get('sys_configMod').animate({duration: 500,to: {y: -350}});
	},
	durationComboChange: function(obj)
	{
		var durationVal = obj.getValue();
		if (comboChangeURL.indexOf('duration') > 0)
		{
			comboChangeURL = comboChangeURL.replace(/(duration=)[^\&]+/, '$1' + durationVal);
		}
		else
		{
			comboChangeURL += '&duration='+durationVal;
		}
		if (comboChangeURL.indexOf('durationChanged') > 0)
		{
			comboChangeURL = comboChangeURL.replace(/(durationChanged=)[^\&]+/, '$1' + 'true');
		}
		else
		{
			comboChangeURL +='&durationChanged=true';		
		}				
		Ext.Ajax.request({
			url:comboChangeURL,
			method: 'POST',
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);

					var timelineValues = jsonData['timelineCombo'];
					if ( timelineValues!=null && timelineValues!=''& !Ext.isEmpty(timelineValues) )
					{
						var timelineLabel = timelineValues['monitor.dashboard.TimeLine'];
						var selectedTimelineCombo = timelineValues['selectedTimelineCombo'];						
						var TimelineComboVal = timelineValues['timelineCombo'];

						var timelineObj = Ext.getCmp('sys-high_er_timeline');
						timelineObj.setFieldLabel(timelineLabel);
						timelineObj.getStore().loadRawData(TimelineComboVal);
						timelineObj.setValue(selectedTimelineCombo);
					}
					Ext.getCmp('sys-high_er_timeline').fireEvent('select',Ext.getCmp('sys-high_er_timeline'));
					/*var fromData = jsonData['fromValues'];
					if ( fromData!=null && fromData!=''& !Ext.isEmpty(fromData) )
					{
						var fromlabel = fromData['monitor.VirtualDashboard.From'];
						var isFromDisabled = fromData['from'];
						var fromValue = fromData['value'];
						var fromObj = Ext.getCmp('sys-high_er_stdate');
						fromObj.setFieldLabel(fromlabel);
						fromObj.setDisabled(isFromDisabled);						
						fromObj.setValue(fromValue);
					}
					var startHr = jsonData['startHr'];
					if ( startHr!=null && startHr!=''& !Ext.isEmpty(startHr) )
					{
						var hrLabel = startHr['monitor.VirtualDashboard.Hr'];
						var isStartHrEnabled = startHr['isStartHrEnabled'];
						var selectedStartHr = startHr['selectedStartHr'];
						var startHrCmbo = startHr['startHrArray'];

						var startHrObj = Ext.getCmp('sys-high_er_sthr');
						startHrObj.setFieldLabel(hrLabel);
						startHrObj.getStore().loadRawData(startHrCmbo);
						startHrObj.setValue(selectedStartHr);
						startHrObj.setDisabled(isStartHrEnabled);
					}
					var toValues = jsonData['toValues'];
					if ( toValues!=null && toValues!=''& !Ext.isEmpty(toValues) )
					{
						var toLabel = toValues['monitor.VirtualDashboard.To'];
						var isToDisabled = toValues['to'];
						var value = toValues['value'];
						var toObj = Ext.getCmp('sys-high_er_enddate');
						toObj.setDisabled(isToDisabled);
						toObj.setFieldLabel(toLabel);
						toObj.setValue(value);
					}
					var endHr = jsonData['endHr'];
					if ( endHr!=null && endHr!=''& !Ext.isEmpty(endHr) )
					{
						var hrLabel = endHr['monitor.VirtualDashboard.Hr'];
						var isEndHrEnabled = endHr['isEndHrEnabled'];
						var selectedEndHr = endHr['selectedEndHr'];
						var endHrCmbo = endHr['endHrArray'];

						var endHrObj = Ext.getCmp('sys-high_er_endhr');
						endHrObj.setFieldLabel(hrLabel);
						endHrObj.getStore().loadRawData(endHrCmbo);
						endHrObj.setValue(selectedEndHr);
						endHrObj.setDisabled(isEndHrEnabled);
					}*/
				}
			}
		});		
	},
	loadMeasureGraph: function(imgSrc,isHighChartEnabled)
	{
		var MeasurementTable_Highcharts='';
		var minMaxTableHeadersArray = '';
		var measuresTableDataArray = '';
		var fullViewContObj = Ext.getCmp('sys-fullViewBarId');
		var fullViewPanelObj = Ext.getCmp('sys-fullviewId');
		fullViewContObj.removeAll();
		fullViewContObj.update('');		
		if (isHighChartEnabled)
		{			
			Ext.Ajax.request({
				url:imgSrc,
				method: 'POST',
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
					{
						var tmpJsonTxt = response.responseText;	
						var chartData = Ext.decode(tmpJsonTxt);
						var errorMsg = chartData['ERROR'];
						if(errorMsg!=null && errorMsg!=undefined && !Ext.isEmpty(errorMsg) && errorMsg=='NO_DATA_FOUND')
						{
							Ext.getCmp('sys-measureTableID').update('');
							fullViewContObj.update('<div class="iconInformation" style="margin:15% auto 0 auto"></div><div style="text-align:center;">'+noMeasure+'</div>');							
							fullViewPanelObj.setLoading(false);
						}
						else
						{
							MeasurementTable_Highcharts = chartData['MeasurementTable_Highcharts'];
							var minMaxTable = MeasurementTable_Highcharts['minMaxTable'];
							
							if (minMaxTable!=null && minMaxTable!=''& !Ext.isEmpty(minMaxTable) && minMaxTable!=undefined)
							{
								minMaxTableHeadersArray = minMaxTable['minMaxTableHeadersArray'];
							}
							var measuresTable = MeasurementTable_Highcharts['measuresTable'];
							if (measuresTable!=null && measuresTable!=''& !Ext.isEmpty(measuresTable) && measuresTable!=undefined)
							{						
								measuresTableDataArray = measuresTable['measuresTableDataArray'];	
							}
							if ( tmpJsonTxt.indexOf('png') == -1 && tmpJsonTxt.indexOf('PNG') == -1 && tmpJsonTxt.indexOf('gif') == -1 && tmpJsonTxt.indexOf('GIF') == -1 )
							{							
								fullViewContObj.add({
									xtype: 'container',
									id: 'sys-fullViewPanelHighChatrBigId',
									html : '<div id="sys-high-chart-measuregraph" style="border:0px solid yellow;height:300px;"></div>',
									listeners:
									{
										'afterrender': function(thisObj)
										{
											
											try
											{												
												var lineChart = {};
												lineChart = jQuery.extend(true, {}, getHighCharts('sys-high-chart-measuregraph',  345,900,''), lineChart);
												lineChart.setData(chartData,currentDateFormat,'',true,'bottom');
												lineChart.drawChart();
												fullViewPanelObj.setLoading(false);
											}
											catch (e)
											{
												alert("e::"+e)
											}	
											if (!Ext.isEmpty(minMaxTableHeadersArray) && minMaxTableHeadersArray!=undefined && minMaxTableHeadersArray!=null && minMaxTableHeadersArray!='' && measuresTableDataArray!=undefined && measuresTableDataArray!=null && measuresTableDataArray!='' && !Ext.isEmpty(measuresTableDataArray))
											{		
												 var str='';
												 str += '<div class="x-table" style="width:600px;margin:20px auto 0px auto;padding-bottom:0px"> '
												+ '<table cellspacing="0" cellpadding="0" border="0"  class="gridSkin x-grid-table x-grid-table-resizer">'
												+ '<thead>'
												+ '<tr class="x-grid-row">'
												+ '<th class=" x-grid-cell" style="width:50px">'
												+ '<div class="x-grid-cell-inner" style="margin-left: 12px;">'+minMaxTableHeadersArray[0]['name']+'</div>'
												+ '</th>'
												+ '<th class=" x-grid-cell x-grid-cell-first" style="width: 210px;">'
												+ '<div class="x-grid-cell-inner">'+minMaxTableHeadersArray[1]['name']+'</div>'		
												+ '</th>'
												+ '<th class=" x-grid-cell" style="width: 50px;">'
												+ '<div class="x-grid-cell-inner">'+minMaxTableHeadersArray[2]['name']+'</div>'
												+ '</th>'
												+ '<th class=" x-grid-cell" style="width: 50px;">'
												+ '<div class="x-grid-cell-inner" >'+minMaxTableHeadersArray[3]['name']+'</div>'
												+ '</th>'
												+ '<th class=" x-grid-cell" style="width: 50px;">'
												+ '<div class="x-grid-cell-inner">'+minMaxTableHeadersArray[4]['name']+'</div>'
												+ '</th>'
												+ '</tr>'
												+ '</thead>'
												+ '<tbody>';
												for ( var j = 0; j < measuresTableDataArray.length ; j++ )
												{
													var records = measuresTableDataArray[j];
													str += '<tr class="x-grid-row">'
													for (var k in records )
													{
														if (k == 'value0')
														{
															str += '<td class=" x-grid-cell x-grid-cell-first" style="vertical-align:middle" width="50px">'
															 + '<div class="x-grid-cell-inner"  ><span id="id_colorcheck" style="display: inline-block;background:'+records[k]+';height: 10px;width: 10px;margin-left: 22px;"><span></div>'
															 + '</td>';	
														}
														else
														{
															str += '<td class=" x-grid-cell x-grid-cell-first">'
															+ '<div class="x-grid-cell-inner" >'+records[k]+'</div>'
															+ '</td>';				
														}
													}
													str += '</tr>';
												}
												str += '</tbody>'
												+ '</table>'
												+ '</div>';
												Ext.getCmp('sys-measureTableID').update(str);
											}
										}
									}
								});										
							}
							else
							{
								fullViewContObj.update(tmpJsonTxt);
								fullViewPanelObj.setLoading(false);
							}
						}
					}
					else
					{						
						fullViewContObj.update("<table border='0' height='100%' width='100%'><tr><td align='center'><img src='/final/monitor/eg_images/gray/graph_error_message.gif'></td></tr></table>");
						fullViewPanelObj.setLoading(false);
					}
				}
			});
		}
		else
		{
	        fullViewContObj.update('<table width="100%" height="360px"><tr><td align="center" valign="middle"><img src="' + imgSrc + '" border="0" /></td></tr></table>');
		fullViewPanelObj.setLoading(false);
		}		
		
	},
	DialChartFullView : function(url)
	{
		Ext.Ajax.request({
		url: url,
		method: 'GET',
		async: false,
		success: function( response )
		{
			if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
			{
				var JsonData =response.responseText;
				JsonData = Ext.decode(response.responseText);
				var dialChartTable = JsonData['dialChartTable'];
				var gTable = JsonData['MOREINFOS_DIAL_Table'];
				if(gTable!=null && gTable!="" && gTable!=undefined)
				{
					var dialHeader= gTable['dialHeader'];
					var printWindow = new Ext.Window({
							title: dialHeader,
							//closeAction: 'destory',
							width: '50%',
							height: 500,
							padding:'5 10 10 10',
							id: 'dialChart',
							name: 'dialChart',
							resizable: 'true',
							modal: true,
							ghost: false,
							closeAction: 'destroy',
							scroll:true,
							autoScroll: true,
							//layout:{type:'column'},
							bodyStyle:{'overflow-y': 'auto'},
							listeners: {
								hide:  function(win) {
									if (this.modal) {
										var dom = Ext.dom.Query.select('.x-mask');
										var el = Ext.fly(dom[0]);
										el.removeCls('windowModal');
									}
								},
								'show' : function(obj)
								{
									if (this.modal) {
										var dom = Ext.dom.Query.select('.x-mask');
										var el = Ext.fly(dom[0]);
										el.addCls('windowModal');
									}
									var tableDataArray = gTable['tableDataArray'];
									var tableHeadersArray = gTable['tableHeadersArray'];
									var outerArr = new Array();		
									var atAGlanceArr = new Array();	
									if( tableDataArray!=null && !Ext.isEmpty(tableDataArray) )
									{
										genHTML = '<div class="x-table"><table cellspacing="0" cellpadding="0" border="0" class="x-grid-table x-grid-table-resizer" width="100%">';
										genHTML += '<thead>'
										genHTML += '<tr class="x-grid-row">';
										genHTML += '<th class="x-grid-cell" ><div class="x-grid-cell-inner">'+tableHeadersArray[0]['COLUMN_1']+'</div></th>'
										genHTML += '<th class="x-grid-cell" ><div class="x-grid-cell-inner">'+tableHeadersArray[1]['COLUMN_2']+'</div></th>';
										genHTML += '</tr>';
										genHTML += '</thead>'
										genHTML += '<tbody>'
										for(var i=0;i<tableDataArray.length;i++)
										{
											genHTML += '<tr class="x-grid-row">';
											genHTML += '<td class="x-grid-cell" ><div class="x-grid-cell-inner">'+tableDataArray[i]['COLUMN_0']+'</div></td>'
											genHTML += '<td class="x-grid-cell" ><div class="x-grid-cell-inner">'+tableDataArray[i]['COLUMN_1']+'</div></td>';
											genHTML += '</tr>';											
										}
										genHTML +='</tbody></table></div>';
									}
									atAGlanceArr.push(
									{
										xtype: 'container',
										cls:'last_border',
										margin:'10 10 10 10',
										padding:'0 0 10 0',
										html:genHTML
									});
									this.removeAll();
									this.add(atAGlanceArr);	
									this.doComponentLayout();
								}
								}							
						}).show();
				}
				else
				{
					//Width increased 67% to 68% if browser  Firefox or IE
					var widthVar = '67%';
					if (navigator.userAgent.search("Firefox")  >= 0 || navigator.userAgent.toLowerCase().lastIndexOf('rv:11') > -1) 
					{
						widthVar = '68%';
					}
				var dialHeader= dialChartTable['dialHeader'];
				var printWindow = new Ext.Window({
                        title: dialHeader,
                        //closeAction: 'destory',
                        width: widthVar,
                        height: 500,
						padding:'5 10 10 10',
                        id: 'dialChart',
                        name: 'dialChart',
                        resizable: 'true',
						modal: true,
						ghost: false,
						closeAction: 'destroy',
						scroll:true,
						autoScroll: true,
						layout:{type:'column'},
						bodyStyle:{'overflow-y': 'auto'},
						listeners: {
							hide:  function(win) {
								if (this.modal) {
									var dom = Ext.dom.Query.select('.x-mask');
									var el = Ext.fly(dom[0]);
									el.removeCls('windowModal');
								}
							},
							'show' : function(obj)
							{
								if (this.modal) {
									var dom = Ext.dom.Query.select('.x-mask');
									var el = Ext.fly(dom[0]);
									el.addCls('windowModal');
								}
								//var dailFullviewObj=Ext.getCmp('DailFullview');
								var tableDataArray = dialChartTable['tableDataArray'];
								layerModelURL = JsonData['hiddens'];
								var outerArr = new Array();		
								var atAGlanceArr = new Array();	
								for(var i=0;i<tableDataArray.length;i++)
								{
										var fcId = tableDataArray[i]['fcId'];
										var chartHeight =115;
										var chartWidth = 191;
										var xmlData = tableDataArray[i]['chartXMLData'];
										var divId = tableDataArray[i]['divId'];
										var chartInd = tableDataArray[i]['chartInd'];
										var chartTitle = tableDataArray[i]['chartTitle'];
										var swfPath = tableDataArray[i]['movie'];
										atAGlanceArr.push({
										xtype: 'container',
										width:200,
										height:180,
										cls:'containerShadow',
										margin:'10 10 0 10',
										layout:{
											//type: 'hbox',											
											align: 'stretch'
										},
										items:[{
												xtype: 'label',
												margin:10,
												align: 'center',
												html: '<div style="text-align:center;overflow: hidden;-o-text-overflow:ellipsis;text-overflow:ellipsis;white-space:nowrap;" class="font_bold12" data-qtip="'+chartTitle+'">'+chartTitle+'</div>'
												},{
												xtype: 'container',												
												id: 'dialChart-'+i,												
												dataArray: tableDataArray[i],												
												cnt:i,
												margin:'0 10 10 10',
												layout:{
												//type: 'hbox',											
												align: 'center'
												},
												width:chartWidth,
												height:chartHeight,												
												html: '<div id="dialFullviewchart-'+i+'" style="border:0px solid blue;width:'+chartWidth+'px;height:'+chartHeight+'px;margin:0px auto"></div>',
												listeners: {
												'afterrender' : function(container)
												{
													var xmlData = this.dataArray['chartXMLData'];
													var swfPath = this.dataArray['movie'];
													if ( xmlData != '-' )
													{							
															getHighChartsGuage('dialFullviewchart-'+this.cnt,xmlData);
													}
												}
											}
										}]
									});
								}		
								this.removeAll();
								this.add(atAGlanceArr);								
								this.doComponentLayout();
							}
							}							
                    }).show();
				}
				}
				else
				{
					alert('Failure Dial fullview request');
				}
			}
		});
	}
});