var stmin = '';
var enmin = '';
var mgr_stmin = '';
var mgr_enmin = '';
Ext.define('componentDashboard.view.Application.ApplicationTimeLinePanel', {
    alias: 'widget.applicationtimeline',
    requires: ['utilities.DatePicker'],
    extend: 'Ext.form.Panel',
	cls:'configMode_popup_inner',
    layout: 'column',
  	defaults:{
			labelSeparator : '',
			labelAlign: 'top',
			margin: '8 5 8 10',
			editable: false
	},
    items: [{
        xtype: 'combo',
        fieldLabel: 'Timeline',
        id: 'er_timeline',
        name: 'er_timeline',
        displayField: 'name',
        valueField: 'value',
        queryMode: 'local',
        store: Ext.data.Store({
            fields: ['name', 'value'],
            data: []
        }),
        width: 90,
        cls: 'dropdown',
        defaultListConfig: {
            loadingHeight: 70,
            minWidth: 90,
            maxHeight: 300,
            shadow: 'sides'
        },
        listeners: {
            'select': function (obj) {
                if (obj.getValue() == 'Any') {
                    Ext.getCmp('er_enddate').setDisabled(false);
                    Ext.getCmp('er_endhr').setDisabled(false);
                    Ext.getCmp('er_sthr').setDisabled(false);
                    Ext.getCmp('er_stdate').setDisabled(false);
                } else {
                    Ext.getCmp('er_enddate').setDisabled(true);
                    Ext.getCmp('er_endhr').setDisabled(true);
                    Ext.getCmp('er_sthr').setDisabled(true);
                    Ext.getCmp('er_stdate').setDisabled(true);
                    var timeline = Ext.getCmp("er_timeline").getValue();
                    var strtdt = Ext.getCmp("er_stdate").getValue();
                    var enddt = Ext.getCmp("er_enddate").getValue();
                    var strthour = Ext.getCmp("er_sthr").getValue();
                    var endhr = Ext.getCmp("er_endhr").getValue();

					if(timeline=="Any")
					{
						strtdt = Ext.Date.dateFormat(strtdt, 'm/d/Y');
						enddt = Ext.Date.dateFormat(enddt, 'm/d/Y');
					}
					else
					{
						strtdt = Ext.Date.dateFormat(strtdt, mgrDateFormat);
						enddt = Ext.Date.dateFormat(enddt, mgrDateFormat);
					}                    
                    // strtdt = Ext.Date.dateFormat(strtdt, mgrDateFormat);
                    //enddt = Ext.Date.dateFormat(enddt, mgrDateFormat);
                    var no_params = "&P0=[" + timeline + "]&P1=[" + strtdt + "]&P2=[" + enddt + "]&P3=[" + strthour + "]&P4=[" + endhr + "]&P5=[" + dateFormatForTimeline + "]";
					if(appLastGraphTypeLoaded!=null && (appLastGraphTypeLoaded=='summaryGraph' || appLastGraphTypeLoaded=='trendGraph'))
					{
						//var period = Ext.getCmp("period").getValue();
						no_params += "&P6=[H]&P7=[]&F=getTimeForSummary";
					}
					else
					{
						no_params +="&F=getTime";
					}
					var param = "C=id" + no_params;
                   console.log(param);
                    Ext.Ajax.request({
                        url: '/final/servlet/com.eg.ErRemoteScriptingServlet',
                        params: param,
                        scope: this,
                        method: 'POST',
                        success: function (response) {
                            var jsontext = response.responseText;
                            var jsonData = Ext.decode(jsontext);
                            if (!Ext.isEmpty(jsonData)) {
                                var timedata = jsonData.timeline;
                                Ext.getCmp("er_stdate").setValue(timedata[6]);
                                Ext.getCmp("er_stdate").dataArray = timedata[0];
                                Ext.getCmp("er_enddate").setValue(timedata[7]);
                                Ext.getCmp("er_enddate").dataArray = timedata[1];
                                Ext.getCmp("er_sthr").setValue(timedata[8]);
                                Ext.getCmp("er_sthr").dataArray = timedata[2];
                                Ext.getCmp("er_endhr").setValue(timedata[9]);
                                Ext.getCmp("er_endhr").dataArray = timedata[3];
                                stmin = timedata[10];
                                enmin = timedata[11];
                                mgr_stmin = timedata[4];
                                mgr_enmin = timedata[5];
                            }
                        }
                    });
                }
            }
        }
    }, {
        xtype: 'datepicker',
        id: 'er_stdate',
        name: 'er_stdate',
        format: mgrDateFormat,
        fieldLabel: 'From',
        cls: 'datepicker',
        disabled: true,
        dataArray: null,
		listeners: {
			'select': function (obj) {
				var timeline = Ext.getCmp("er_timeline").getValue();
				var strtdt = Ext.getCmp("er_stdate").getValue();
				var enddt = Ext.getCmp("er_enddate").getValue();
				var strthour = Ext.getCmp("er_sthr").getValue();
				var endhr = Ext.getCmp("er_endhr").getValue();
				
				if(timeline=="Any")
				{
					strtdt = Ext.Date.dateFormat(strtdt, 'm/d/Y');
					enddt = Ext.Date.dateFormat(enddt, 'm/d/Y');
				}
				else
				{
					strtdt = Ext.Date.dateFormat(strtdt, mgrDateFormat);
					enddt = Ext.Date.dateFormat(enddt, mgrDateFormat);
				}
				var no_params = "&P0=[" + timeline + "]&P1=[" + strtdt + "]&P2=[" + enddt + "]&P3=[" + strthour + "]&P4=[" + endhr + "]&P5=[" + dateFormatForTimeline + "]";
				
				if(appLastGraphTypeLoaded!=null && (appLastGraphTypeLoaded=='summaryGraph' || appLastGraphTypeLoaded=='trendGraph'))
				{
					//var period = Ext.getCmp("period").getValue();
					no_params += "&P6=[H]&P7=[]&F=getTimeForSummary";
				}
				else
				{
					no_params +="&F=getTime";
				}
				var param = "C=id" + no_params;
				if(appLastGraphTypeLoaded=='summaryGraph' || appLastGraphTypeLoaded=='trendGraph')
				{
					Ext.Ajax.request({
						url: '/final/servlet/com.eg.ErRemoteScriptingServlet',
						params: param,
						scope: this,
						method: 'POST',
						success: function (response) {
							var jsontext = response.responseText;
							var jsonData = Ext.decode(jsontext);
							if (!Ext.isEmpty(jsonData)) {
								var timedata = jsonData.timeline;
								Ext.getCmp("er_stdate").setValue(timedata[6]);
								Ext.getCmp("er_stdate").dataArray = timedata[0];
								Ext.getCmp("er_enddate").setValue(timedata[7]);
								Ext.getCmp("er_enddate").dataArray = timedata[1];							
								Ext.getCmp("er_sthr").setValue(timedata[8]);
								Ext.getCmp("er_endhr").setValue(timedata[9]);
								Ext.getCmp("er_sthr").dataArray = timedata[2];
								Ext.getCmp("er_endhr").dataArray = timedata[3];
								stmin = timedata[10];
								enmin = timedata[11];
								mgr_stmin = timedata[4];
								mgr_enmin = timedata[5];
							}
						}
					});
				}
			}
		}
    }, {
        xtype: 'combo',
        width: 50,
        id: 'er_sthr',
        name: 'er_sthr',
        defaultListConfig: {
            loadingHeight: 70,
            minWidth: 50,
            maxHeight: 300,
            shadow: 'sides'
        },
        store: ['00', '01', '02', '03', '04', '05', '06', '07', '08', '09', '10', '11', '12', '13', '14', '15', '16', '17', '18', '19', '20', '21', '22', '23'],
        displayField: 'displayField',
        valueField: 'valueField',
        queryMode: 'local',
        fieldLabel: 'Hr',
        cls: 'dropdown',
        disabled: true,
        dataArray: null,
        listeners: {
            'select': function () {
                formated_sdate = Ext.Date.dateFormat(Ext.getCmp("er_stdate").getValue(), mgrDateFormat);
                //formated_edate = Ext.Date.dateFormat(Ext.getCmp("er_enddate").getValue(), mgrDateFormat);
                var dateValue = formated_sdate + " " + this.getValue() + ":" + mgr_stmin + ":00";
                var param = "date=" + dateValue + "&method=getDateTime&isReverse=true&isFromReporter=true";
                Ext.Ajax.request({
                    url: '/final/servlet/com.eg.EgTimeZoneConverterServlet',
                    params: param,
                    scope: this,
                    method: 'POST',
                    success: function (response) {
                        var responseText = response.responseText;
                        responseText = Ext.String.trim(responseText);
                        var dt = responseText.substring(0, responseText.lastIndexOf(" "));
                        var tim = responseText.substring(responseText.lastIndexOf(" ") + 1);
                        Ext.getCmp("er_stdate").dataArray = dt;
                        if (tim != null && (tim.indexOf(":") == tim.lastIndexOf(":"))) {
                            Ext.getCmp("er_sthr").dataArray = tim.substring(0, tim.indexOf(":"));
                            mgr_stmin = tim.substring(tim.indexOf(":") + 1, tim.length);
                        } else if (tim != null && tim.length > 0 && tim.indexOf(":") > -1) {
                            Ext.getCmp("er_sthr").dataArray = tim.substring(0, tim.indexOf(":"));
                            mgr_stmin = tim.substring(tim.indexOf(":") + 1, tim.lastIndexOf(":"));
                        }
                    }
                });
            }
        }
    }, {
        xtype: 'datepicker',
        id: 'er_enddate',
        name: 'er_enddate',
        format: mgrDateFormat,
        fieldLabel: 'To',
        cls: 'datepicker',
        //width: 115,
        disabled: true,
        dataArray: null,
		listeners: {
			'select': function (obj) {
				var timeline = Ext.getCmp("er_timeline").getValue();
				var strtdt = Ext.getCmp("er_stdate").getValue();
				var enddt = Ext.getCmp("er_enddate").getValue();
				var strthour = Ext.getCmp("er_sthr").getValue();
				var endhr = Ext.getCmp("er_endhr").getValue();

				if(timeline=="Any")
				{
					strtdt = Ext.Date.dateFormat(strtdt, 'm/d/Y');
					enddt = Ext.Date.dateFormat(enddt, 'm/d/Y');
				}
				else
				{
					strtdt = Ext.Date.dateFormat(strtdt, mgrDateFormat);
					enddt = Ext.Date.dateFormat(enddt, mgrDateFormat);
				}
				var no_params = "&P0=[" + timeline + "]&P1=[" + strtdt + "]&P2=[" + enddt + "]&P3=[" + strthour + "]&P4=[" + endhr + "]&P5=[" + dateFormatForTimeline + "]";
				if(appLastGraphTypeLoaded!=null && (appLastGraphTypeLoaded=='summaryGraph' || appLastGraphTypeLoaded=='trendGraph'))
				{
					//var period = Ext.getCmp("period").getValue();
					no_params += "&P6=[H]&P7=[]&F=getTimeForSummary";
				}
				else
				{
					no_params +="&F=getTime";
				}
				var param = "C=id" + no_params;
				if(appLastGraphTypeLoaded=='summaryGraph' || appLastGraphTypeLoaded=='trendGraph')
				{
					Ext.Ajax.request({
						url: '/final/servlet/com.eg.ErRemoteScriptingServlet',
						params: param,
						scope: this,
						method: 'POST',
						success: function (response) {
							var jsontext = response.responseText;
							var jsonData = Ext.decode(jsontext);
							if (!Ext.isEmpty(jsonData)) {
								var timedata = jsonData.timeline;
								Ext.getCmp("er_stdate").setValue(timedata[6]);
								Ext.getCmp("er_stdate").dataArray = timedata[0];
								Ext.getCmp("er_enddate").setValue(timedata[7]);
								Ext.getCmp("er_enddate").dataArray = timedata[1];			
								Ext.getCmp("er_sthr").setValue(timedata[8]);
								Ext.getCmp("er_endhr").setValue(timedata[9]);
								Ext.getCmp("er_sthr").dataArray = timedata[2];
								Ext.getCmp("er_endhr").dataArray = timedata[3];
								stmin = timedata[10];
								enmin = timedata[11];
								mgr_stmin = timedata[4];
								mgr_enmin = timedata[5];
							}
						}
					});
				}
			}
		}
    }, {
        xtype: 'combo',
        width: 50,
        defaultListConfig: {
            loadingHeight: 70,
            minWidth: 50,
            maxHeight: 300,
            shadow: 'sides'
        },
        fieldLabel: 'Hr',
        cls: 'dropdown',
        id: 'er_endhr',
        name: 'er_endhr',
        store: ['00', '01', '02', '03', '04', '05', '06', '07', '08', '09', '10', '11', '12', '13', '14', '15', '16', '17', '18', '19', '20', '21', '22', '23'],
        displayField: 'displayField',
        valueField: 'valueField',
        queryMode: 'local',
        disabled: true,
        dataArray: null,
        listeners: {
            'select': function () {
                formated_sdate = Ext.Date.dateFormat(Ext.getCmp("er_enddate").getValue(), mgrDateFormat);
                //formated_edate = Ext.Date.dateFormat(Ext.getCmp("er_enddate").getValue(), mgrDateFormat);
                var dateValue = formated_sdate + " " + this.getValue() + ":" + mgr_enmin + ":00";
                var param = "date=" + dateValue + "&method=getDateTime&isReverse=true&isFromReporter=true";
                Ext.Ajax.request({
                    url: '/final/servlet/com.eg.EgTimeZoneConverterServlet',
                    params: param,
                    scope: this,
                    method: 'POST',
                    success: function (response) {
                        var responseText = response.responseText;
                        var dt = responseText.substring(0, responseText.lastIndexOf(" "));
                        var tim = responseText.substring(responseText.lastIndexOf(" ") + 1);
                        Ext.getCmp("er_enddate").dataArray = dt;
                        if (tim != null && (tim.indexOf(":") == tim.lastIndexOf(":"))) {
                            Ext.getCmp("er_endhr").dataArray = tim.substring(0, tim.indexOf(":"));
                            mgr_enmin = tim.substring(tim.indexOf(":") + 1, tim.length);
                        } else if (tim != null && tim.length > 0 && tim.indexOf(":") > -1) {
                            Ext.getCmp("er_endhr").dataArray = tim.substring(0, tim.indexOf(":"));
                            mgr_enmin = tim.substring(tim.indexOf(":") + 1, tim.lastIndexOf(":"));
                        }
                    }
                });
            }
        }
    },{
    	xtype: 'button',
    	margin: '25 5 0 5',
    	cls: 'button20',
    	id: 'timelineGo',
    	text: 'Go',
    	listeners:{
    		'click': function()
    		{
    			applicationController.callView(appLastGraphTypeLoaded);
    		}
    	}
    }]
});