Ext.define('componentDashboard.view.CompDashLayersTab', {
	extend: 'Ext.panel.Panel',
	requires : ['componentDashboard.view.Layers.Measures',
				'componentDashboard.view.Layers.LayersList'],
	alias:'widget.compdashlayerstab',
	cls : 'comp-dash-layers-tab',
	border : false,
	layersList:null,
	measuresPanel:null,
	headerContainer:null,
	maskFull:null,
	style:{'border':'none !important'},
	layout : {
		type:'hbox',
		align:'stretch'
	},
	createTabUI : function(jsonData)
	{
		this.refreshData();
	},
	createTabRefreshUI : function(jsonData)
	{
		this.refreshUIData();
	},
	refreshData : function(url){
		var layerUrl = '';
		if(!Ext.isEmpty(url)){
			layerUrl = url;
			if(layerUrl.indexOf('clearMeasureSession') > -1)
				requestParams.tabUrl = layerUrl.substring(0,layerUrl.indexOf('clearMeasureSession'));
			else
				requestParams.tabUrl = layerUrl;
		}
		else
			layerUrl = requestParams.tabUrl;

		var isfromRum = requestParams.isfromRum;
		var isfromCitrix = requestParams.isfromCitrix;
		var me = this;
		me.removeAll(); //me.destroy(); -- not able to use destroy here... because views are removed.. 
		var dockedItems = me.getDockedItems('toolbar');
        for(var dockedCounter = 0 ; dockedCounter < dockedItems.length ; dockedCounter++){
        	me.removeDocked(dockedItems[dockedCounter]);
        }
		if(!Ext.isEmpty(requestParams.isMoreInfosTreeView) && (requestParams.isMoreInfosTreeView || requestParams.isMoreInfosTreeView =="true")){
			layerUrl = layerUrl+'&MoreInfosTreeView=true';
		}
		var isFromNewServiceDashboard = false;
		if((requestParams.service_Topology!= null && requestParams.service_Topology !='' && requestParams.service_Topology =='true' )||(requestParams.isToLayerModel!= null && requestParams.isToLayerModel !='' && requestParams.isToLayerModel =='true' ) ||(isfromRum!=null && isfromRum!='null' && isfromRum!='' && isfromRum!='undefined'&& isfromRum=='true') ||(isfromCitrix!=null && isfromCitrix!='null' && isfromCitrix!='' && isfromCitrix!='undefined'&& isfromCitrix=='true'))
		{
			isFromNewServiceDashboard = true;
		}

		if(isFromNewServiceDashboard && layerUrl.indexOf("refreshing=") == -1)//isToLayerModel
		{
			if(layerUrl.indexOf("filterBy=") > -1)
			{
				layerUrl=layerUrl.replace(/(filterBy=).*?(&)/,'$1' + requestParams.filterBy + '$2');
			}
			else
			{
				var urlData = layerUrl.split("?");
				var secUrl = urlData[0]+"?"+"filterBy="+requestParams.filterBy+"&"+urlData[1];
				layerUrl = secUrl;
			}

			if(isfromRum!=null && isfromRum!='null' && isfromRum!='' && isfromRum!='undefined'&& isfromRum=='true')
			{
				layerUrl = layerUrl+"&appliesTo="+requestParams.selectedRum;
			}
			else
			{
				layerUrl = layerUrl+"&appliesTo=Service:"+requestParams.subFilter;
			}
			layerUrl = layerUrl+"&isFromLayerModel=true&isFromServiceMenu="+isFromServiceMenu+"&isFromZoneMain="+isFromZoneMain+"&isFromZoneMenu="+isFromZoneMenu+"&isFromServiceGroup="+isFromServiceGroup+"&refreshing=true";
		}
		Ext.Ajax.request({
			url : layerUrl,
			scope:this,
			disableCaching:false,
			timeout:280000,
			success: function(response){
				var layerJsonText = null;
				layerJsonText = response.responseText;
				if(!Ext.isEmpty(layerJsonText))
				{
					var layerJsonData=null;
					layerJsonData=Ext.decode(layerJsonText);

					delete layerJsonText;
					Ext.destroy(layerJsonText);

					if(!Ext.isEmpty(layerJsonData.layerURL))
					{
						Ext.Ajax.request({
							url : layerJsonData.layerURL,
							scope : this,
							disableCaching:false,
							timeout:280000,
							success : function(response){

								var jsonText = null;
								jsonText = response.responseText;
								if(!Ext.isEmpty(jsonText))
								{
									var jsonData=null;
									jsonData=Ext.decode(jsonText);

									delete jsonText;
									Ext.destroy(jsonText);

									if(!Ext.isEmpty(jsonData))
									{
										componentDetailUrl = jsonData.componentDetailsURL;
										var toolbarRightItems = jsonData.toolbarItemsArray;
										var transactionIconArray = jsonData.transactionIconArray;
										var isTransactionIconEnabled = false;
										try
										{
											if(transactionIconArray.length>0)
												isTransactionIconEnabled = true;
										}
										catch (e)
										{
											isTransactionIconEnabled = false;
										}
										me.up('componenttabpanel').setLayerToolbar(toolbarRightItems,jsonData.componentToolTip,jsonData.componentState);
										var assetIcon = '';
										var remoteIcon = '';
										var endUserIcon = '';
										var transactionIcon = '';
										var netScalarIcon = '';
										try
										{
											if(isTransactionIconEnabled)
												transactionIcon = '<span style=\"margin:0px 0px 0px 0px;cursor:pointer;display:inline-block;\"><a href="javascript:LoadResourceConsumption(\''+transactionIconArray[0].href+'\');" data-qtip="'+transactionIconArray[0].text+'" data-qclass=\"yellowTip\"><img src=\"../images/clear.png\" class=\"iconTransactionDark\" width=\"20px\" height=\"20px\"/></a></span>';
										}
										catch (e)
										{
										}	
										if(!Ext.isEmpty(jsonData.endUserUrl)){
												endUserIcon = '<span style=\"margin:0px 0px 0px 0px;cursor:pointer;display:inline-block;\"><a href="javascript:LoadResourceConsumption(\''+jsonData.endUserUrl+'\');" data-qtip="'+jsonData.endUserText+'" data-qclass=\"yellowTip\"><img src=\"../images/clear.png\" class=\"iconResourceUsageLayerModel\" width=\"20px\" height=\"20px\"/></a></span>';
											}
										if(showAssetInfoInLayers) 
										{
											if(!Ext.isEmpty(jsonData.assetInfoURL)){
												assetIcon = '<span style=\"margin:0px 0px 0px 0px;cursor:pointer;display:inline-block;\"><a href="javascript:loadPopup(\''+jsonData.assetInfoURL+'\');" data-qtip="'+assetInfoLbl+'" data-qclass=\"yellowTip\"><img src=\"../images/clear.png\" class=\"iconAssetConfigLayer\" width=\"20px\" height=\"20px\"/></a></span>';
											}
											if(!Ext.isEmpty(jsonData.remoteUrl)){
												remoteIcon ='<span style=\"margin:0px 0px 0px 0px;display:inline-block;\" class="iconRemoteControlLayermodel handSymbol"  data-qclass="yellowTip" data-qtip="'+remoteControlLbl+'" href="javascript:void(0);" onclick = \'javascript:openRemoteControl("'+jsonData.remoteUrl+'");\'></span>';
											}
										}
										var selected_compState = jsonData.componentState;
										var selected_componentState = selected_compState.substring(selected_compState.indexOf("_")+1);
										var compType=jsonData.compType;
										if(compType!=null && compType=='Citrix_NetScaler' && !isFromNetscaler)
										{
											netScalarIcon = '<span style=\"margin:0px 0px 0px 0px;cursor:pointer;display:inline-block;\"><a href="javascript:LoadNetscalerTopology();" data-qtip="'+netscalerLbl+'" data-qclass=\"yellowTip\"><img src=\"../images/clear.png\" class=\"iconNetScaler\" width=\"20px\" height=\"20px\"/></a></span>';
										}
										if(!Ext.isEmpty(selected_compTypeText))
										{
											$('#componentsDropDown-inputEl').removeClass('state_GOOD');
											$('#componentsDropDown-inputEl').removeClass('state_HIGH');
											$('#componentsDropDown-inputEl').removeClass('state_INTERMEDIATE');
											$('#componentsDropDown-inputEl').removeClass('state_LOW');
											$('#componentsDropDown-inputEl').removeClass('state_UNKNOWN');
											$('#componentsDropDown-inputEl').addClass('state_'+selected_componentState);
										}
										else if(!Ext.isEmpty(selected_serverTypeText) && !Ext.isEmpty(selected_serverNameText))
										{
											$('#componentNameCombo-inputEl').removeClass('state_GOOD');
											$('#componentNameCombo-inputEl').removeClass('state_HIGH');
											$('#componentNameCombo-inputEl').removeClass('state_INTERMEDIATE');
											$('#componentNameCombo-inputEl').removeClass('state_LOW');
											$('#componentNameCombo-inputEl').removeClass('state_UNKNOWN');
											$('#componentNameCombo-inputEl').addClass('state_'+selected_componentState);
										}

										if(!Ext.isEmpty(requestParams.isMoreInfosTreeView) && (requestParams.isMoreInfosTreeView || requestParams.isMoreInfosTreeView =="true"))
										{
											$('#layerPopupHeaderStateId').removeClass('state_GOOD');
											$('#layerPopupHeaderStateId').removeClass('state_HIGH');
											$('#layerPopupHeaderStateId').removeClass('state_INTERMEDIATE');
											$('#layerPopupHeaderStateId').removeClass('state_LOW');
											$('#layerPopupHeaderStateId').removeClass('state_UNKNOWN');

											$('#layerPopupHeaderStateId').addClass('state_'+selected_componentState);

										}

										if(jsonData.layersJson!=null && jsonData.layersJson!=undefined && jsonData.layersJson.Nodeinfo!=null && jsonData.layersJson.Nodeinfo!=undefined && !Ext.isEmpty(jsonData.layersJson.Nodeinfo)&& Ext.isEmpty(jsonData.layersJson.errormsg))
										{
											if( !Ext.isEmpty(compType) && (compType!= undefined) && (compType=='Real_user_monitor'))
											{
												if(!Ext.isEmpty(requestParams.isMoreInfosTreeView) && (requestParams.isMoreInfosTreeView || requestParams.isMoreInfosTreeView =="true"))
												{
													Ext.getCmp("layerPopupHeader").update('<div><span style="float:left" class="layerListTitle"><a style="color:#fff" href="javascript:void(0);" onclick = \'javascript:parent.componenetDetailsPopUp("'+componentDetailUrl+'");\'>'+decodeURI(jsonData.layersTitle)+'</a></span></div>');
													layersList = Ext.create('componentDashboard.view.Layers.LayersList',{
														jsonData:jsonData.layersJson.Nodeinfo,
														jsonMoreInfoData:jsonData.layersJson.MoreInfosNodeInfo,
														title :jsonData.layersTitle,
														//title:'<div><span style="float:left"><a style="color:#fff" href="javascript:void(0);" onclick = \'javascript:componenetDetailsPopUp("'+componentDetailUrl+'");\'>'+decodeURI(jsonData.layersTitle)+'</a></span></div>',
														//+'<div style="display:inline-block;float:right"><div class="userProfileSeparator" style="height:17px;display:inline-block;position:absolute;left:'+tabwidth+'"></div><span style="display:inline-block;width:22px" class="iconLayermodelToRum handSymbol"  data-qclass="yellowTip" data-qtip="RUM Dashboard" href="javascript:void(0);" onclick = \'javascript:parent.DashboardToRumApp("'+jsonData.layersTitle+'");\'></span>'+'<span style="display:inline-block" class="iconAlarmHistory handSymbol"  data-qclass="yellowTip" data-qtip="History of Alarms" href="javascript:void(0);" onclick = \'javascript:parent.LayersToHistoryOfAlarm("'+jsonData.layersTitle+'","'+compType+'");\'></span>'+assetIcon+'</div></div> ',
														flex :0.35,
														header:false,
														//minWidth:450,
														margin :'0 8 9 5',	
													});
												}
												else
												{ 
													var titleStr='';
													if(jsonData.hasOwnProperty('showInstantMaintenanceConfigIcon') && !Ext.isEmpty(jsonData.showInstantMaintenanceConfigIcon) && jsonData.showInstantMaintenanceConfigIcon==true)
													{
														titleStr='<div><span style="float:left" class="layerListTitle"><a style="color:#fff" href="javascript:void(0);" onclick = \'javascript:componenetDetailsPopUp("'+componentDetailUrl+'");\'>'+decodeURI(jsonData.layersTitle)+'</a></span>';
															titleStr=titleStr+'<div id="toolbarLayer" style="border:#000 0px solid;display:inline-block;float:right;height:'+uPsHeight+'" ><span style="display:inline-block;" class="iconLayermodelToRum handSymbol"  data-qclass="yellowTip" data-qtip="RUM Dashboard" href="javascript:void(0);" onclick = \'javascript:DashboardToRumApp("'+jsonData.layersTitle+'");\'></span>'+
														'<span style="display:inline-block" class="iconAlarmHistory handSymbol"  data-qclass="yellowTip" data-qtip="'+HisofAlarmsLbl+'" href="javascript:void(0);" onclick = \'javascript:LayersToHistoryOfAlarm("'+jsonData.layersTitle+'","'+compType+'");\'></span>'+assetIcon+''+remoteIcon+''+endUserIcon+''+transactionIcon+''+netScalarIcon+'<span data-qtip="'+instMainPlcyTitle+'" data-qclass="yellowTip"><a style="color:#fff" href="javascript:void(0);" onclick = \'javascript:showMaintenanceOptsForComp("'+jsonData.hostNameToCheckMaintenance+'","'+jsonData.portNoToCheckMaintenance+'","'+jsonData.sidToCheckMaintenance+'","'+jsonData.layersTitle+'"); \'><img  class=\"iconMaintenancePolicyLayerModel\" src=\"/final/images/clear.png\"/></a></span></div><div style="clear:both"></div></div> ';
													}
													else
													{
														titleStr='<div><span style="float:left" class="layerListTitle"><a style="color:#fff" href="javascript:void(0);" onclick = \'javascript:componenetDetailsPopUp("'+componentDetailUrl+'");\'>'+decodeURI(jsonData.layersTitle)+'</a></span>';
														titleStr=titleStr+'<div  id="toolbarLayer" style="border:#000 0px solid;display:inline-block;float:right;height:'+uPsHeight+'"><span style="display:inline-block;" class="iconLayermodelToRum handSymbol"  data-qclass="yellowTip" data-qtip="RUM Dashboard" href="javascript:void(0);" onclick = \'javascript:DashboardToRumApp("'+jsonData.layersTitle+'");\'></span>'+
														'<span style="display:inline-block" class="iconAlarmHistory handSymbol"  data-qclass="yellowTip" data-qtip="'+HisofAlarmsLbl+'" href="javascript:void(0);" onclick = \'javascript:LayersToHistoryOfAlarm("'+jsonData.layersTitle+'","'+compType+'");\'></span>'+assetIcon+''+remoteIcon+''+endUserIcon+''+transactionIcon+''+netScalarIcon+'</div><div style="clear:both"></div></div> '
													}
													layersList = Ext.create('componentDashboard.view.Layers.LayersList',{
														jsonData:jsonData.layersJson.Nodeinfo,
														//title : jsonData.layersTitle,
														title : titleStr,
														flex :0.35,
														minWidth:450
													});
												}
											}
											else
											{
												if(!Ext.isEmpty(requestParams.isMoreInfosTreeView) && (requestParams.isMoreInfosTreeView || requestParams.isMoreInfosTreeView =="true"))
												{
													Ext.getCmp("layerPopupHeader").update('<div><span style="float:left;margin-left:5px"><a style="color:#fff" href="javascript:void(0);" onclick = \'javascript:parent.componenetDetailsPopUp("'+componentDetailUrl+'");\'>'+decodeURI(jsonData.layersTitle)+'</a></span></div>');
													//var remoteUrl = jsonData.remoteUrl;
													var layerTitle;
													//if(remoteUrl == 'undefined' || remoteUrl == undefined)
												//	{
													//	layerTitle ='<div ><span style="float:left"><a style="color:#fff" href="javascript:void(0);" onclick = \'javascript:componenetDetailsPopUp("'+componentDetailUrl+'");\'>'+decodeURI(jsonData.layersTitle)+''+remoteIcon+''+endUserIcon+'</a></span></div>';
												//	}
													//else {
														//layerTitle = '<div><span style="float:left"><a style="color:#fff" href="javascript:void(0);" onclick = \'javascript:componenetDetailsPopUp("'+componentDetailUrl+'");\'>'+decodeURI(jsonData.layersTitle)+'</a></span><div style="float:left;margin: 2px 0 0 5px;" class="iconRemoteControlLayermodel handSymbol"  data-qclass="yellowTip" data-qtip="Remote Control" href="javascript:void(0);" onclick=openRemoteControl("'+remoteUrl+'")></div></div>';
													//}
													if(jsonData.hasOwnProperty('showInstantMaintenanceConfigIcon') && !Ext.isEmpty(jsonData.showInstantMaintenanceConfigIcon) && jsonData.showInstantMaintenanceConfigIcon==true)
													{
														layerTitle='<div><span style="float:left" class="layerListTitle"><a style="color:#fff" href="javascript:void(0);" onclick = \'javascript:componenetDetailsPopUp("'+componentDetailUrl+'");\'>'+decodeURI(jsonData.layersTitle)+''+remoteIcon+''+endUserIcon+''+transactionIcon+''+netScalarIcon+'</a></span><span data-qtip="'+instMainPlcyTitle+'" data-qclass="yellowTip"><a style="color:#fff" href="javascript:void(0);" onclick = \'javascript:showMaintenanceOptsForComp("'+jsonData.hostNameToCheckMaintenance+'","'+jsonData.portNoToCheckMaintenance+'","'+jsonData.sidToCheckMaintenance+'","'+jsonData.layersTitle+'"); \'><img class=\"iconMaintenancePolicyLayerModel\" src=\"/final/images/clear.png\"/></a></span><div style="clear:both"></div></div>';
													}
													else
													{
														layerTitle='<div><span style="float:left" class="layerListTitle"><a style="color:#fff" href="javascript:void(0);" onclick = \'javascript:componenetDetailsPopUp("'+componentDetailUrl+'");\'>'+decodeURI(jsonData.layersTitle)+''+remoteIcon+''+endUserIcon+''+transactionIcon+''+netScalarIcon+'</a></span><div style="clear:both"></div></div>';
													}
													layersList = Ext.create('componentDashboard.view.Layers.LayersList',{
														jsonData:jsonData.layersJson.Nodeinfo,
														jsonMoreInfoData:jsonData.layersJson.MoreInfosNodeInfo,
														title : layerTitle,
														//title : '<div ><span style="float:left"><a style="color:#fff" href="javascript:void(0);" onclick = \'javascript:componenetDetailsPopUp("'+componentDetailUrl+'");\'>'+decodeURI(jsonData.layersTitle)+'</a></span></div>',
														header:false,
														flex :0.35,
														margin:'0 6 10 10',
														minWidth:420
													});
												}
												else
												{
													//var remoteUrl = jsonData.remoteUrl;
													var layerTitle = '';													
													
													//if(remoteUrl == 'undefined' || remoteUrl == undefined)
													{
														layerTitle += '<div><span style="float:left" class="layerListTitle"><a style="color:#fff" href="javascript:void(0);" onclick = \'javascript:componenetDetailsPopUp("'+componentDetailUrl+'");\'>'+decodeURI(jsonData.layersTitle)+'</a></span>'+'<div  id="toolbarLayer" style="border:#000 0px solid;display:inline-block;float:right"><span style="display:inline-block" class="iconAlarmHistory   handSymbol"  data-qclass="yellowTip" data-qtip="'+HisofAlarmsLbl+'" href="javascript:void(0);" onclick = \'javascript:LayersToHistoryOfAlarm("'+jsonData.layersTitle+'","'+compType+'");\'></span>'+''+assetIcon+''+remoteIcon+''+endUserIcon+''+transactionIcon+''+netScalarIcon;
													}
													//else {
														//layerTitle = '<div><span style="float:left"><a style="color:#fff" href="javascript:void(0);" onclick = \'javascript:componenetDetailsPopUp("'+componentDetailUrl+'");\'>'+decodeURI(jsonData.layersTitle)+'</a></span><div style="float:left;margin: 2px 0 0 5px;" class="iconRemoteControlLayermodel handSymbol"  data-qclass="yellowTip" data-qtip="Remote Control" href="javascript:void(0);" onclick=openRemoteControl("'+remoteUrl+'")></div>'+'<div style="display:inline-block;float:right"><div class="userProfileSeparator" style="height:17px;display:inline-block;position:absolute;left:'+tabwidth+'"></div><span style="display:inline-block" class="iconAlarmHistory   handSymbol"  data-qclass="yellowTip" data-qtip="History of Alarms" href="javascript:void(0);" onclick = \'javascript:LayersToHistoryOfAlarm("'+jsonData.layersTitle+'","'+compType+'");\'></span>'+assetIcon+'</div></div>';
													//}
													if(jsonData.hasOwnProperty('showInstantMaintenanceConfigIcon') && !Ext.isEmpty(jsonData.showInstantMaintenanceConfigIcon) && jsonData.showInstantMaintenanceConfigIcon==true)
													{
														layerTitle=layerTitle+'<span data-qtip="'+instMainPlcyTitle+'" data-qclass="yellowTip"><a style="color:#fff" href="javascript:void(0);" onclick = \'javascript:showMaintenanceOptsForComp("'+jsonData.hostNameToCheckMaintenance+'","'+jsonData.portNoToCheckMaintenance+'","'+jsonData.sidToCheckMaintenance+'","'+jsonData.layersTitle+'"); \'><img  class=\"iconMaintenancePolicyLayerModel\" src=\"/final/images/clear.png\"/></a></span>';
													}
													layerTitle=layerTitle+'</div><div style="clear:both"></div></div>';
													
													layersList = Ext.create('componentDashboard.view.Layers.LayersList',{
														jsonData:jsonData.layersJson.Nodeinfo,
														title : layerTitle,
														//title : '<div><span style="float:left"><a style="color:#fff" href="javascript:void(0);" onclick = \'javascript:componenetDetailsPopUp("'+componentDetailUrl+'");\'>'+decodeURI(jsonData.layersTitle)+'</a></span>'+'<div style="display:inline-block;float:right"><div class="userProfileSeparator" style="height:17px;display:inline-block;position:absolute;left:'+tabwidth+'"></div><span style="display:inline-block" class="iconAlarmHistory   handSymbol"  data-qclass="yellowTip" data-qtip="History of Alarms" href="javascript:void(0);" onclick = \'javascript:LayersToHistoryOfAlarm("'+jsonData.layersTitle+'","'+compType+'");\'></span>'+assetIcon+'</div></div>',
														flex :0.35,
														minWidth:450
													});
												}
											}
										}
										else if(jsonData.layersJson!=null && jsonData.layersJson!=undefined && jsonData.layersJson.errormsg!=null && jsonData.layersJson.errormsg!=undefined && !Ext.isEmpty(jsonData.layersJson.errormsg))
										{
											if(!Ext.isEmpty(compType) && (compType!= undefined) && (compType=='Real_user_monitor'))
											{
												if(!Ext.isEmpty(requestParams.isMoreInfosTreeView) && (requestParams.isMoreInfosTreeView || requestParams.isMoreInfosTreeView =="true"))
												{
													var titleStr='';
													if(jsonData.hasOwnProperty('showInstantMaintenanceConfigIcon') && !Ext.isEmpty(jsonData.showInstantMaintenanceConfigIcon) && jsonData.showInstantMaintenanceConfigIcon==true)
													{
														titleStr='<div><span style="display:inline-block;"><a style="color:#fff" href="javascript:void(0);" onclick = \'javascript:parent.componenetDetailsPopUp("'+componentDetailUrl+'");\'>'+decodeURI(jsonData.layersTitle)+'</a></span><span data-qtip="'+instMainPlcyTitle+'" data-qclass="yellowTip"><a style="color:#fff" href="javascript:void(0);" onclick = \'javascript:showMaintenanceOptsForComp("'+jsonData.hostNameToCheckMaintenance+'","'+jsonData.portNoToCheckMaintenance+'","'+jsonData.sidToCheckMaintenance+'","'+jsonData.layersTitle+'"); \'><img  class=\"iconMaintenancePolicyLayerModel\" src=\"/final/images/clear.png\"/></a></span></div>';
													}
													else
													{
														titleStr='<div><span style="display:inline-block;"><a style="color:#fff" href="javascript:void(0);" onclick = \'javascript:parent.componenetDetailsPopUp("'+componentDetailUrl+'");\'>'+decodeURI(jsonData.layersTitle)+'</a></span></div>';
													}
													Ext.getCmp("layerPopupHeader").update(titleStr);

													layersList = Ext.create('componentDashboard.view.Layers.LayersList',{
														jsonErrData:jsonData.layersJson.errormsg,
														//title : '<div><span style="display:inline-block;"><a style="color:#fff" href="javascript:void(0);" onclick = \'javascript:componenetDetailsPopUp("'+componentDetailUrl+'");\'>'+decodeURI(jsonData.layersTitle)+'</a></span></div> ',
														flex :0.35,
														minWidth:450
													});
												}
												else
												{
													var titleStr='<div><span style="display:inline-block;"><a style="color:#fff" href="javascript:void(0);" onclick = \'javascript:componenetDetailsPopUp("'+componentDetailUrl+'");\'>'+decodeURI(jsonData.layersTitle)+'</a></span>'
														+'<div id="toolbarLayer" style="border:#000 0px solid;display:inline-block;float:right;height:'+uPsHeight+'"><span style="display:inline-block;" class="iconLayermodelToRum handSymbol"  data-qclass="yellowTip" data-qtip="RUM Dashboard" href="javascript:void(0);" onclick = \'javascript:DashboardToRumApp("'+jsonData.layersTitle+'");\'></span>'+
														'<span style="display:inline-block" class="iconAlarmHistory handSymbol"  data-qclass="yellowTip" data-qtip="'+HisofAlarmsLbl+'" href="javascript:void(0);" onclick = \'javascript:LayersToHistoryOfAlarm("'+jsonData.layersTitle+'","'+compType+'");\'></span>'+assetIcon+''+remoteIcon+''+endUserIcon+''+transactionIcon+''+netScalarIcon;
													if(jsonData.hasOwnProperty('showInstantMaintenanceConfigIcon') && !Ext.isEmpty(jsonData.showInstantMaintenanceConfigIcon) && jsonData.showInstantMaintenanceConfigIcon==true)
													{
														titleStr=titleStr+'<span data-qtip="'+instMainPlcyTitle+'" data-qclass="yellowTip"><a style="color:#fff" href="javascript:void(0);" onclick = \'javascript:showMaintenanceOptsForComp("'+jsonData.hostNameToCheckMaintenance+'","'+jsonData.portNoToCheckMaintenance+'","'+jsonData.sidToCheckMaintenance+'","'+jsonData.layersTitle+'"); \'><img  class=\"iconMaintenancePolicyLayerModel\" src=\"/final/images/clear.png\"/></a></span>';
													}
													
													titleStr=titleStr+'</div></div> '
													layersList = Ext.create('componentDashboard.view.Layers.LayersList',{
														jsonErrData:jsonData.layersJson.errormsg,
														//title : jsonData.layersTitle,
														//title : '<table><tr><td><a style="color:#fff" href="javascript:void(0);" onclick = \'javascript:componenetDetailsPopUp("'+componentDetailUrl+'");\'>'+decodeURI(jsonData.layersTitle)+'</a></td><td style="padding-left:5px"><div style="float:left" class="iconLayermodelToRum handSymbol"  data-qclass="yellowTip" data-qtip="RUM Dashboard" href="javascript:void(0);" onclick = \'javascript:DashboardToRumApp("'+jsonData.layersTitle+'");\'> </div></td><td style="padding-left:5px"><div style="float:left;margin-top:-4px" class="iconAlarmHistory  handSymbol"  data-qclass="yellowTip" data-qtip="History of Alarms" href="javascript:void(0);" onclick = \'javascript:LayersToHistoryOfAlarm("'+jsonData.layersTitle+'","'+compType+'");\'> </div></td></tr></table>'+assetIcon,
														title : titleStr,
														flex :0.35,
														minWidth:450
													});
												}
											}
											else
											{
												if(!Ext.isEmpty(requestParams.isMoreInfosTreeView) && (requestParams.isMoreInfosTreeView || requestParams.isMoreInfosTreeView =="true"))
												{
													Ext.getCmp("layerPopupHeader").update('<div><span style="float:left" class="layerListTitle"><a style="color:#fff" href="javascript:void(0);" onclick = \'javascript:parent.componenetDetailsPopUp("'+componentDetailUrl+'");\'>'+decodeURI(jsonData.layersTitle)+'</a></span></div>');
													//var remoteUrl = jsonData.remoteUrl;
													var layerTitle;
													//if(remoteUrl == 'undefined' || remoteUrl == undefined)
													{
														layerTitle = '<div><span style="float:left" class="layerListTitle"><a style="color:#fff" href="javascript:void(0);" onclick = \'javascript:componenetDetailsPopUp("'+componentDetailUrl+'");\'>'+decodeURI(jsonData.layersTitle)+''+remoteIcon+''+endUserIcon+''+transactionIcon+''+netScalarIcon+'</a></span>';
													}
													//else {
														////layerTitle = '<div><span style="float:left"><a style="color:#fff" href="javascript:void(0);" onclick = \'javascript:componenetDetailsPopUp("'+componentDetailUrl+'");\'>'+decodeURI(jsonData.layersTitle)+'</a></span><div style="float:left;margin: 2px 0 0 5px;" class="iconRemoteControlLayermodel handSymbol"  data-qclass="yellowTip" data-qtip="Remote Control" href="javascript:void(0);" onclick=openRemoteControl("'+remoteUrl+'")> </div></div>';
													//}
													if(jsonData.hasOwnProperty('showInstantMaintenanceConfigIcon') && !Ext.isEmpty(jsonData.showInstantMaintenanceConfigIcon) && jsonData.showInstantMaintenanceConfigIcon==true)
													{
														layerTitle+='<span data-qtip="'+instMainPlcyTitle+'" data-qclass="yellowTip"><a style="color:#fff" href="javascript:void(0);" onclick = \'javascript:showMaintenanceOptsForComp("'+jsonData.hostNameToCheckMaintenance+'","'+jsonData.portNoToCheckMaintenance+'","'+jsonData.sidToCheckMaintenance+'","'+jsonData.layersTitle+'"); \'><img class=\"iconMaintenancePolicyLayerModel\" src=\"/final/images/clear.png\"/></a></span>';
													}
													layerTitle=layerTitle+'<div style="clear:both"></div></div>';
													layersList = Ext.create('componentDashboard.view.Layers.LayersList',{
														jsonErrData:jsonData.layersJson.errormsg,
														//title : '<div><span style="float:left"><a style="color:#fff" href="javascript:void(0);" onclick = \'javascript:componenetDetailsPopUp("'+componentDetailUrl+'");\'>'+decodeURI(jsonData.layersTitle)+'</a></span></div>',
														title : layerTitle,
														flex :0.35,
														minWidth:450
													});
												}
												else
												{
													//var remoteUrl = jsonData.remoteUrl;
													var layerTitle = '';
													
													

													//if(remoteUrl == 'undefined' || remoteUrl == undefined)
													{
														 layerTitle += '<div><span style="float:left" class="layerListTitle"><a style="color:#fff" href="javascript:void(0);" onclick = \'javascript:componenetDetailsPopUp("'+componentDetailUrl+'");\'>'+decodeURI(jsonData.layersTitle)+'</a></span>'+'<div  id="toolbarLayer" style="border:#000 0px solid;display:inline-block;float:right"><span style="display:inline-block" class="iconAlarmHistory   handSymbol"  data-qclass="yellowTip" data-qtip="'+HisofAlarmsLbl+'" href="javascript:void(0);" onclick = \'javascript:LayersToHistoryOfAlarm("'+jsonData.layersTitle+'","'+compType+'");\'></span>'+assetIcon+''+remoteIcon+''+endUserIcon+''+transactionIcon+''+netScalarIcon+'</div></div>';
													}
													//else {
														//layerTitle = '<div><span style="float:left"><a style="color:#fff" href="javascript:void(0);" onclick = \'javascript:componenetDetailsPopUp("'+componentDetailUrl+'");\'>'+decodeURI(jsonData.layersTitle)+'</a></span><div style="float:left;margin: 2px 0 0 5px;" class="iconRemoteControlLayermodel handSymbol"  data-qclass="yellowTip" data-qtip="Remote Control" href="javascript:void(0);" onclick=openRemoteControl("'+remoteUrl+'")></div>'+'<div style="display:inline-block;float:right"><div class="userProfileSeparator" style="height:17px;display:inline-block;position:absolute;left:'+tabwidth+'"></div><span style="display:inline-block" class="iconAlarmHistory   handSymbol"  data-qclass="yellowTip" data-qtip="History of Alarms" href="javascript:void(0);" onclick = \'javascript:LayersToHistoryOfAlarm("'+jsonData.layersTitle+'","'+compType+'");\'></span>'+assetIcon+''+remoteIcon;
													//}
													if(jsonData.hasOwnProperty('showInstantMaintenanceConfigIcon') && !Ext.isEmpty(jsonData.showInstantMaintenanceConfigIcon) && jsonData.showInstantMaintenanceConfigIcon==true)
													{
														layerTitle+='<span data-qtip="'+instMainPlcyTitle+'" data-qclass="yellowTip"><a style="color:#fff" href="javascript:void(0);" onclick = \'javascript:showMaintenanceOptsForComp("'+jsonData.hostNameToCheckMaintenance+'","'+jsonData.portNoToCheckMaintenance+'","'+jsonData.sidToCheckMaintenance+'","'+jsonData.layersTitle+'"); \'><img  class=\"iconMaintenancePolicyLayerModel\" src=\"/final/images/clear.png\"/></a></span>';
													}
													layerTitle +='</div><div style="clear:both"></div></div>'
													layersList = Ext.create('componentDashboard.view.Layers.LayersList',{
														jsonErrData:jsonData.layersJson.errormsg,
														title : layerTitle,
														//title : '<table><tr><td><a style="color:#fff" href="javascript:void(0);" onclick = \'javascript:componenetDetailsPopUp("'+componentDetailUrl+'");\'>'+decodeURI(jsonData.layersTitle)+'</a></td><td style="padding-left:5px"><div style="float:left;margin-top:-4px" class="iconAlarmHistory  handSymbol"  data-qclass="yellowTip" data-qtip="History of Alarms" href="javascript:void(0);" onclick = \'javascript:LayersToHistoryOfAlarm("'+jsonData.layersTitle+'","'+compType+'");\'> </div></td></tr></table>'+assetIcon,
														//title : '<div><span style="float:left"><a style="color:#fff" href="javascript:void(0);" onclick = \'javascript:componenetDetailsPopUp("'+componentDetailUrl+'");\'>'+decodeURI(jsonData.layersTitle)+'</a></span>'+'<div style="display:inline-block;float:right"><div class="userProfileSeparator" style="height:17px;display:inline-block;position:absolute;left:'+tabwidth+'"></div><span style="display:inline-block" class="iconAlarmHistory   handSymbol"  data-qclass="yellowTip" data-qtip="History of Alarms" href="javascript:void(0);" onclick = \'javascript:LayersToHistoryOfAlarm("'+jsonData.layersTitle+'","'+compType+'");\'></span>'+assetIcon+'</div></div>',
														flex :0.35,
														minWidth:450
													});
												}
											}
										}
										var measuresUrl = jsonData.measuresUrl;
										measuresPanel = Ext.create('componentDashboard.view.Layers.Measures',{
											url : Ext.isEmpty(measuresUrl)?"/final/monitor/egDashBoardDispCompMeasure.jsp?":measuresUrl,
											flex : 1,
										});

										if(!Ext.isEmpty(requestParams.isMoreInfosTreeView) && (requestParams.isMoreInfosTreeView || requestParams.isMoreInfosTreeView =="true"))
										{
											if(!Ext.isEmpty(jsonData.externalMonitors))
											{
												headerContainer = Ext.create('Ext.panel.Panel',{
												layout : {
													type:'vbox',
													align:'stretch'
												},
												id:'headerConId',
												style:{'border':'0px solid red`'},
												flex :0.65,
												items:[
													{
														xtype:'container',
														style:{'border':'1px solid red`'},
														layout:'column',
														padding:'0 0 0 0',
														items:[
															{
																columnWidth:.49,
																xtype:'combo',
																cls:'dropdown',
																name:'externalmonitors',
																labelSeparator:'',
																labelAlign:'right',
																style:{'color':'#fff'},
																id:'externalmonitors',
																labelWidth:120,
																margin:'6 8 0 15',
																editable: false,
																fieldLabel:extMonitorsLbl,
																//width:200,
																displayField : 'name',
																valueField : 'value',
																value:jsonData.selected,
																queryMode:'local',
																store : new Ext.data.Store({
																		fields : ['name', 'value'],
																		data : jsonData.externalMonitors
																})
															}
														]
													},measuresPanel]
												});
											}
											else
											{
												measuresPanel.margin='0 4 0 0';
												measuresPanel.padding=0;
												headerContainer = Ext.create('Ext.panel.Panel',{
													layout : {
														type:'vbox',
														align:'stretch'
													},
													margin :'0 8 10 0',
													id:'headerConId',
													flex :0.65,
													items:[measuresPanel]
												});
											}
										}
										else
										{
											if(!Ext.isEmpty(jsonData.externalMonitors))
											{
												headerContainer = Ext.create('Ext.panel.Panel',{
												layout : {
													type:'vbox',
													align:'stretch'
												},
												id:'headerConId',
												style:{'border':'0px solid red'},
												flex :0.65,
												items:[
													{
														xtype:'container',
														layout:'column',
														padding:'0 0 0 0',
														items:[
															{
																columnWidth:.49,
																xtype:'combo',
																cls:'dropdown',
																name:'externalmonitors',
																labelSeparator:'',
																labelAlign:'right',
																style:{'color':'#fff'},
																id:'externalmonitors',
																labelWidth:120,
																margin:'6 8 0 15',
																editable: false,
																fieldLabel:extMonitorsLbl,
																//width:200,
																displayField : 'name',
																valueField : 'value',
																value:jsonData.selected,
																queryMode:'local',
																store : new Ext.data.Store({
																		fields : ['name', 'value'],
																		data : jsonData.externalMonitors
																})
															},
															{	columnWidth:.0025,
																margin:'8 0 0 0',
																xtype:'tbseparator'
															},
															{
																xtype:'container',id:'heading',height:33,
																columnWidth:.50,
																padding:0,
																margin:0,
																style:{'word-wrap':'break-word'}
															}
														]
													},measuresPanel]
												});
											}
											else
											{
												headerContainer = Ext.create('Ext.panel.Panel',{
													layout : {
														type:'vbox',
														align:'stretch'
													},
													id:'headerConId',
													flex :0.65,
													items:[{xtype:'container',id:'heading',height:33},measuresPanel]
												});
											}
										}
										
										me.add(layersList);

										me.add(headerContainer);

										var layerController = componentDashboard.app.getController("LayersController");

										layerController.afterLayersTreeRender();

										var record = layerController.recordClicked;
										if(!Ext.isEmpty(record)){
											for(var rec = 0; rec < record.length;rec++){
												layerController.recordOpen(record[rec]);
											}
										}
										if(!Ext.isEmpty(layerController.rootCauseNode)){
											layerController.recordClicked = new Array();
											layerController.recordClicked.push(layerController.rootCauseNode);
											layerController.rootCauseNode = null;
										}

										if(!Ext.isEmpty(this.mask)){
											this.mask.hide();
										}
									}
									else if(!Ext.isEmpty(jsonData.errormsg))
									{
										me.update(jsonData.errormsg);
									}
									delete jsonData;
									Ext.destroy(jsonData);
								}
							}
						});
					}
				}
			},
			failure : function(){
				//window.location.href="/final/servlet/com.eg.EgMonitorController?monCmd=dashboard";
				//window.parent.location.href="/final/servlet/com.egurkha.Logout";
			}
		});
	},
	refreshUIData : function(url){
		var layerUrl = '';
		if(!Ext.isEmpty(url)){
			layerUrl = url;
			if(layerUrl.indexOf('clearMeasureSession') > -1)
				requestParams.tabUrl = layerUrl.substring(0,layerUrl.indexOf('clearMeasureSession'));
			else
				requestParams.tabUrl = layerUrl;
		}
		else
			layerUrl = requestParams.tabUrl;
		var me = this;
		//me.removeAll();
		var dockedItems = me.getDockedItems('toolbar');
        	for(var dockedCounter = 0 ; dockedCounter < dockedItems.length ; dockedCounter++){
        		me.removeDocked(dockedItems[dockedCounter]);
       	 	}

		//var maskFull = new Ext.LoadMask(me,{msg:'Please wait..'});
		//maskFull.show();
		if(!Ext.isEmpty(requestParams.isMoreInfosTreeView) && (requestParams.isMoreInfosTreeView || requestParams.isMoreInfosTreeView =="true")){
			layerUrl = layerUrl+'&MoreInfosTreeView=true';
		}
		Ext.Ajax.request({
			url : layerUrl,
			scope:this,
			disableCaching:false,
			timeout:280000,
			success: function(response){
				var layerJsonText = null;
				layerJsonText = response.responseText;
				if(!Ext.isEmpty(layerJsonText))
				{
					var layerJsonData = null;
					layerJsonData=Ext.decode(layerJsonText);

					delete layerJsonText;
					Ext.destroy(layerJsonText);

					if(!Ext.isEmpty(layerJsonData.layerURL))
					{
						Ext.Ajax.request({
							url : layerJsonData.layerURL,
							scope : this,
							disableCaching:false,
							timeout:280000,
							success : function(response){
								var jsonText = null;
								jsonText = response.responseText;
								if(!Ext.isEmpty(jsonText))
								{
									var jsonData=null;
									jsonData=Ext.decode(jsonText);

									delete jsonText;
									Ext.destroy(jsonText);

									if(!Ext.isEmpty(jsonData))
									{
										componentDetailUrl = jsonData.componentDetailsURL;
										var toolbarRightItems = jsonData.toolbarItemsArray;
										me.up('componenttabpanel').setLayerToolbar(toolbarRightItems,jsonData.componentToolTip,jsonData.componentState);
										var transactionIconArray = jsonData.transactionIconArray;
										var isTransactionIconEnabled = false;
										try
										{
											if(transactionIconArray.length>0)
												isTransactionIconEnabled = true;
										}
										catch (e)
										{
											isTransactionIconEnabled = false;
										}
										var assetIcon = '';
										var remoteIcon = '';
										var endUserIcon = '';
										var transactionIcon = '';
										var netScalarIcon = '';
										if(isTransactionIconEnabled)
											transactionIcon = '<span style=\"margin:0px 0px 0px 0px;cursor:pointer;display:inline-block;\"><a href="javascript:LoadResourceConsumption(\''+transactionIconArray[0].href+'\');" data-qtip="'+transactionIconArray[0].text+'" data-qclass=\"yellowTip\"><img src=\"../images/clear.png\" class=\"iconTransactionDark\" width=\"20px\" height=\"20px\"/></a></span>';

										

										if(!Ext.isEmpty(jsonData.endUserUrl)){
												endUserIcon = '<span style=\"margin:0px 0px 0px 0px;cursor:pointer;display:inline-block;position:relative\"><a href="javascript:LoadResourceConsumption(\''+jsonData.endUserUrl+'\');" data-qtip="'+jsonData.endUserText+'" data-qclass=\"yellowTip\"><img src=\"../images/clear.png\" class=\"iconResourceUsageLayerModel\" width=\"20px\" height=\"20px\"/></a></span>';
											}
										if(showAssetInfoInLayers) {
											if(!Ext.isEmpty(jsonData.assetInfoURL)){
												
												assetIcon = '<span style=\"margin:0px 0px 0px 0px;cursor:pointer;display:inline-block;position:relative;top:2px\"><a href="javascript:loadPopup(\''+jsonData.assetInfoURL+'\');" data-qtip="'+assetInfoLbl+'" data-qclass=\"yellowTip\"><img src=\"../images/clear.png\" class=\"iconAssetConfigLayer\" width=\"20px\" height=\"20px\" /></a></span>';
											}
										}
										if(!Ext.isEmpty(jsonData.remoteUrl)){
												remoteIcon ='<span style=\"margin: 0px 0 0 0px;display:inline-block;position:relative;\" class="iconRemoteControlLayermodel handSymbol"  data-qclass="yellowTip" data-qtip="'+remoteControlLbl+'" href="javascript:void(0);" onclick = \'javascript:openRemoteControl("'+jsonData.remoteUrl+'");\'></span>';
											}
										var selected_compState = jsonData.componentState;
										var selected_componentState = selected_compState.substring(selected_compState.indexOf("_")+1);
										var compType=jsonData.compType;
										if(compType!=null && compType=='Citrix_NetScaler' && !isFromNetscaler)
										{
											netScalarIcon = '<span style=\"margin:0px 0px 0px 0px;cursor:pointer;display:inline-block;\"><a href="javascript:LoadNetscalerTopology();" data-qtip="'+netscalerLbl+'" data-qclass=\"yellowTip\"><img src=\"../images/clear.png\" class=\"iconNetScaler\" width=\"20px\" height=\"20px\"/></a></span>';
										}

										if(!Ext.isEmpty(selected_compTypeText))
										{
											$('#componentsDropDown-inputEl').removeClass('state_GOOD');
											$('#componentsDropDown-inputEl').removeClass('state_HIGH');
											$('#componentsDropDown-inputEl').removeClass('state_INTERMEDIATE');
											$('#componentsDropDown-inputEl').removeClass('state_LOW');
											$('#componentsDropDown-inputEl').removeClass('state_UNKNOWN');
											$('#componentsDropDown-inputEl').addClass('state_'+selected_componentState);
										}
										else if(!Ext.isEmpty(selected_serverTypeText) && !Ext.isEmpty(selected_serverNameText))
										{
											$('#componentNameCombo-inputEl').removeClass('state_GOOD');
											$('#componentNameCombo-inputEl').removeClass('state_HIGH');
											$('#componentNameCombo-inputEl').removeClass('state_INTERMEDIATE');
											$('#componentNameCombo-inputEl').removeClass('state_LOW');
											$('#componentNameCombo-inputEl').removeClass('state_UNKNOWN');
											$('#componentNameCombo-inputEl').addClass('state_'+selected_componentState);
										}

										if(!Ext.isEmpty(requestParams.isMoreInfosTreeView) && (requestParams.isMoreInfosTreeView || requestParams.isMoreInfosTreeView =="true"))
										{
											$('#layerPopupHeaderStateId').removeClass('state_GOOD');
											$('#layerPopupHeaderStateId').removeClass('state_HIGH');
											$('#layerPopupHeaderStateId').removeClass('state_INTERMEDIATE');
											$('#layerPopupHeaderStateId').removeClass('state_LOW');
											$('#layerPopupHeaderStateId').removeClass('state_UNKNOWN');

											$('#layerPopupHeaderStateId').addClass('state_'+selected_componentState);
										}

										if(jsonData.layersJson!=null && jsonData.layersJson!=undefined && jsonData.layersJson.Nodeinfo!=null && jsonData.layersJson.Nodeinfo!=undefined && !Ext.isEmpty(jsonData.layersJson.Nodeinfo)&& Ext.isEmpty(jsonData.layersJson.errormsg))
										{
											if(!Ext.isEmpty(layersList) && !Ext.isEmpty(compType) && (compType=='Real_user_monitor'))
											{
												var tabwidth = '81%';
												if(!Ext.isEmpty(assetIcon) && !Ext.isEmpty(remoteIcon))
													 tabwidth = '77%';
												if(Ext.isEmpty(assetIcon) && !Ext.isEmpty(remoteIcon))
													 tabwidth = '84%';
												if(!Ext.isEmpty(assetIcon) && Ext.isEmpty(remoteIcon))
													 tabwidth = '83%';
												if(Ext.isEmpty(assetIcon) && Ext.isEmpty(remoteIcon))
													 tabwidth = '88%';
												layersList.jsonErrData=null;
												layersList.jsonData=jsonData.layersJson.Nodeinfo;
												
												/*if(!Ext.isEmpty(requestParams.isMoreInfosTreeView) && (requestParams.isMoreInfosTreeView || requestParams.isMoreInfosTreeView =="true"))
												{
													layersList.jsonMoreInfoData=jsonData.layersJson.MoreInfosNodeInfo;
												}*/
												//layersList.setTitle('<table><tr><td><a style="color:#fff" href="javascript:void(0);" onclick = \'javascript:componenetDetailsPopUp("'+componentDetailUrl+'");\'>'+decodeURI(jsonData.layersTitle)+'</a> </td><td style="padding-left:5px"><div style="float:left" class="iconLayermodelToRum handSymbol"  data-qclass="yellowTip" data-qtip="RUM Dashboard" href="javascript:void(0);" onclick = \'javascript:DashboardToRumApp("'+jsonData.layersTitle+'");\'> </div></td><td style="padding-left:5px"><div style="float:left;margin-top:-4px" class="iconAlarmHistory  handSymbol"  data-qclass="yellowTip" data-qtip="History of Alarms" href="javascript:void(0);" onclick = \'javascript:LayersToHistoryOfAlarm("'+jsonData.layersTitle+'","'+compType+'");\'> </div></td></tr></table>'+assetIcon);

												if(!Ext.isEmpty(requestParams.isMoreInfosTreeView) && (requestParams.isMoreInfosTreeView || requestParams.isMoreInfosTreeView =="true"))
												{
													layersList.jsonMoreInfoData=jsonData.layersJson.MoreInfosNodeInfo;
													//layersList.setTitle('<div><span style="float:left"><a style="color:#fff" href="javascript:void(0);" onclick = \'javascript:componenetDetailsPopUp("'+componentDetailUrl+'");\'>'+decodeURI(jsonData.layersTitle)+'</a></span></div>');
												}
												else
												{
													var titleStr='';
													if(jsonData.hasOwnProperty('showInstantMaintenanceConfigIcon') && !Ext.isEmpty(jsonData.showInstantMaintenanceConfigIcon) && jsonData.showInstantMaintenanceConfigIcon==true)
													{
														titleStr='<div><span style="float:left" class="layerListTitle"><a style="color:#fff" href="javascript:void(0);" onclick = \'javascript:componenetDetailsPopUp("'+componentDetailUrl+'");\'>'+decodeURI(jsonData.layersTitle)+'</a></span>'+'<div  id="toolbarLayer" style="border:#000 0px solid;display:inline-block;float:right;height:'+uPsHeight+'"><span style="display:inline-block;" class="iconLayermodelToRum handSymbol"  data-qclass="yellowTip" data-qtip="'+rumDashBoardLbl+'" href="javascript:void(0);" onclick = \'javascript:DashboardToRumApp("'+jsonData.layersTitle+'");\'></span>'+'<span style="display:inline-block" class="iconAlarmHistory handSymbol"  data-qclass="yellowTip" data-qtip="'+HisofAlarmsLbl+'" href="javascript:void(0);" onclick = \'javascript:LayersToHistoryOfAlarm("'+jsonData.layersTitle+'","'+compType+'");\'></span>'+assetIcon+''+remoteIcon;
														titleStr+='<span data-qtip="'+instMainPlcyTitle+'" data-qclass="yellowTip"><a style="color:#fff" href="javascript:void(0);" onclick = \'javascript:showMaintenanceOptsForComp("'+jsonData.hostNameToCheckMaintenance+'","'+jsonData.portNoToCheckMaintenance+'","'+jsonData.sidToCheckMaintenance+'","'+jsonData.layersTitle+'"); \'><img  class=\"iconMaintenancePolicyLayerModel\" src=\"/final/images/clear.png\"/></a></span></div></div>';
													}
													else
													{
														titleStr='<div><span style="float:left" class="layerListTitle"><a style="color:#fff" href="javascript:void(0);" onclick = \'javascript:componenetDetailsPopUp("'+componentDetailUrl+'");\'>'+decodeURI(jsonData.layersTitle)+'</a></span>'+'<div  id="toolbarLayer" style="border:#000 0px solid;display:inline-block;float:right;height:'+uPsHeight+'"><span style="display:inline-block;" class="iconLayermodelToRum handSymbol"  data-qclass="yellowTip" data-qtip="'+rumDashBoardLbl+'" href="javascript:void(0);" onclick = \'javascript:DashboardToRumApp("'+jsonData.layersTitle+'");\'></span>'+'<span style="display:inline-block" class="iconAlarmHistory handSymbol"  data-qclass="yellowTip" data-qtip="'+HisofAlarmsLbl+'" href="javascript:void(0);" onclick = \'javascript:LayersToHistoryOfAlarm("'+jsonData.layersTitle+'","'+compType+'");\'></span>'+assetIcon+''+remoteIcon+'</div></div>';
													}
													layersList.setTitle(titleStr);
												}
												
												layersList.loadData();
											}
											else if(!Ext.isEmpty(layersList))
											{
												layersList.jsonErrData=null;
												layersList.jsonData=jsonData.layersJson.Nodeinfo;
												if(!Ext.isEmpty(requestParams.isMoreInfosTreeView) && (requestParams.isMoreInfosTreeView || requestParams.isMoreInfosTreeView =="true"))
												{
													layersList.jsonMoreInfoData=jsonData.layersJson.MoreInfosNodeInfo;
												}
												//layersList.setTitle('<table><tr><td><a style="color:#fff" href="javascript:void(0);" onclick = \'javascript:componenetDetailsPopUp("'+componentDetailUrl+'");\'>'+decodeURI(jsonData.layersTitle)+'</a></td><td style="padding-left:5px"><div style="float:left;margin-top:-4px" class="iconAlarmHistory  handSymbol"  data-qclass="yellowTip" data-qtip="History of Alarms" href="javascript:void(0);" onclick = \'javascript:LayersToHistoryOfAlarm("'+jsonData.layersTitle+'","'+compType+'");\'> </div></td></tr></table>'+assetIcon)
												if(!Ext.isEmpty(requestParams.isMoreInfosTreeView) && (requestParams.isMoreInfosTreeView || requestParams.isMoreInfosTreeView =="true"))
												{
													var titleStr='';
													if(jsonData.hasOwnProperty('showInstantMaintenanceConfigIcon') && !Ext.isEmpty(jsonData.showInstantMaintenanceConfigIcon) && jsonData.showInstantMaintenanceConfigIcon==true)
													{
														titleStr='<div><span style="float:left" class="layerListTitle"><a style="color:#fff" href="javascript:void(0);" onclick = \'javascript:componenetDetailsPopUp("'+componentDetailUrl+'");\'>'+decodeURI(jsonData.layersTitle)+''+remoteIcon+''+endUserIcon+''+transactionIcon+''+netScalarIcon+'</a></span>';
														titleStr+='<span data-qtip="'+instMainPlcyTitle+'" data-qclass="yellowTip"><a style="color:#fff" href="javascript:void(0);" onclick = \'javascript:showMaintenanceOptsForComp("'+jsonData.hostNameToCheckMaintenance+'","'+jsonData.portNoToCheckMaintenance+'","'+jsonData.sidToCheckMaintenance+'","'+jsonData.layersTitle+'"); \'><img class=\"iconMaintenancePolicyLayerModel\" src=\"/final/images/clear.png\"/></a></span></div>';
													}
													else
													{
														titleStr='<div><span style="float:left" class="layerListTitle"><a style="color:#fff" href="javascript:void(0);" onclick = \'javascript:componenetDetailsPopUp("'+componentDetailUrl+'");\'>'+decodeURI(jsonData.layersTitle)+''+remoteIcon+''+endUserIcon+''+transactionIcon+''+netScalarIcon+'</a></span></div>';
													}
													//layersList.setTitle('<div><span style="float:left"><a style="color:#fff" href="javascript:void(0);" onclick = \'javascript:componenetDetailsPopUp("'+componentDetailUrl+'");\'>'+decodeURI(jsonData.layersTitle)+'</a></span></div>');
													//var remoteUrl = jsonData.remoteUrl;
													//if(remoteUrl == 'undefined' || remoteUrl == undefined)
													{
														layersList.setTitle(titleStr);
													}
													//else {
														//layersList.setTitle('<div><span style="float:left"><a style="color:#fff" href="javascript:void(0);" onclick = \'javascript:componenetDetailsPopUp("'+componentDetailUrl+'");\'>'+decodeURI(jsonData.layersTitle)+'</a></span><div style="float:left;margin: 2px 0 0 5px;" class="iconRemoteControlLayermodel handSymbol"  data-qclass="yellowTip" data-qtip="Remote Control" href="javascript:void(0);" onclick = \'javascript:openRemoteControl("'+remoteUrl+'");\'></div></div>');
													//}
												}
												else
												{
													//layersList.setTitle('<div><span style="float:left"><a style="color:#fff" href="javascript:void(0);" onclick = \'javascript:componenetDetailsPopUp("'+componentDetailUrl+'");\'>'+decodeURI(jsonData.layersTitle)+'</a></span>'+'<div style="display:inline-block;float:right"><div class="userProfileSeparator" style="height:17px;display:inline-block;position:absolute;left:'+tabwidth+'"></div><span style="display:inline-block" class="iconAlarmHistory   handSymbol"  data-qclass="yellowTip" data-qtip="History of Alarms" href="javascript:void(0);" onclick = \'javascript:LayersToHistoryOfAlarm("'+jsonData.layersTitle+'","'+compType+'");\'></span>'+assetIcon+'</div></div>');
													//var remoteUrl = jsonData.remoteUrl;
													//if(remoteUrl == 'undefined' || remoteUrl == undefined)
													
													var layerTitle = '';
													{
														layerTitle += '<div><span style="float:left" class="layerListTitle"><a style="color:#fff" href="javascript:void(0);" onclick = \'javascript:componenetDetailsPopUp("'+componentDetailUrl+'");\'>'+decodeURI(jsonData.layersTitle)+'</a></span>'+'<div id="toolbarLayer" style="border:#000 0px solid;display:inline-block;float:right"><span style="display:inline-block" class="iconAlarmHistory   handSymbol"  data-qclass="yellowTip" data-qtip="'+HisofAlarmsLbl+'" href="javascript:void(0);" onclick = \'javascript:LayersToHistoryOfAlarm("'+jsonData.layersTitle+'","'+compType+'");\'></span>'+assetIcon+''+remoteIcon+''+endUserIcon+''+transactionIcon+''+netScalarIcon;
													}
													
													if(jsonData.hasOwnProperty('showInstantMaintenanceConfigIcon') && !Ext.isEmpty(jsonData.showInstantMaintenanceConfigIcon) && jsonData.showInstantMaintenanceConfigIcon==true)
													{
														layerTitle+='<span data-qtip="'+instMainPlcyTitle+'" data-qclass="yellowTip"><a style="color:#fff" href="javascript:void(0);" onclick = \'javascript:showMaintenanceOptsForComp("'+jsonData.hostNameToCheckMaintenance+'","'+jsonData.portNoToCheckMaintenance+'","'+jsonData.sidToCheckMaintenance+'","'+jsonData.layersTitle+'"); \'><img class=\"iconMaintenancePolicyLayerModel\" src=\"/final/images/clear.png\"/></a></span>';
													}
													layerTitle=layerTitle+'</div><div style="clear:both"></div></div>';
													layersList.setTitle(layerTitle);
													//else {
														//layersList.setTitle('<div><span style="float:left"><a style="color:#fff" href="javascript:void(0);" onclick = \'javascript:componenetDetailsPopUp("'+componentDetailUrl+'");\'>'+decodeURI(jsonData.layersTitle)+'</a></span><div style="float:left;margin: 2px 0 0 5px;" class="iconRemoteControlLayermodel handSymbol"  data-qclass="yellowTip" data-qtip="Remote Control" href="javascript:void(0);" onclick = \'javascript:openRemoteControl("'+remoteUrl+'");\'></div>'+'<div style="display:inline-block;float:right"><div class="userProfileSeparator" style="height:17px;display:inline-block;position:absolute;left:'+tabwidth+'"></div><span style="display:inline-block" class="iconAlarmHistory   handSymbol"  data-qclass="yellowTip" data-qtip="History of Alarms" href="javascript:void(0);" onclick = \'javascript:LayersToHistoryOfAlarm("'+jsonData.layersTitle+'","'+compType+'");\'></span>'+assetIcon+'</div></div>');
													//}
												}
												layersList.loadData();
											}
										}
										else if(jsonData.layersJson!=null && jsonData.layersJson!=undefined && jsonData.layersJson.errormsg!=null && jsonData.layersJson.errormsg!=undefined && !Ext.isEmpty(jsonData.layersJson.errormsg))
										{
											if(!Ext.isEmpty(layersList) && !Ext.isEmpty(compType) && (compType=='Real_user_monitor'))
											{
												var tabwidth = '81%';
												if(!Ext.isEmpty(assetIcon) && !Ext.isEmpty(remoteIcon))
													 tabwidth = '77%';
												if(Ext.isEmpty(assetIcon) && !Ext.isEmpty(remoteIcon))
													 tabwidth = '84%';
												if(!Ext.isEmpty(assetIcon) && Ext.isEmpty(remoteIcon))
													 tabwidth = '83%';
												if(Ext.isEmpty(assetIcon) && Ext.isEmpty(remoteIcon))
													 tabwidth = '88%';

												layersList.jsonData=null;
												layersList.jsonErrData=jsonData.layersJson.errormsg;
												//layersList.setTitle('<table><tr><td><a style="color:#fff" href="javascript:void(0);" onclick = \'javascript:componenetDetailsPopUp("'+componentDetailUrl+'");\'>'+decodeURI(jsonData.layersTitle)+'</a></td><td style="padding-left:5px"><div style="float:left" class="iconLayermodelToRum handSymbol"  data-qclass="yellowTip" data-qtip="RUM Dashboard" href="javascript:void(0);" onclick = \'javascript:DashboardToRumApp("'+jsonData.layersTitle+'");\'> </div></td><td style="padding-left:5px"><div style="float:left;margin-top:-4px" class="iconAlarmHistory  handSymbol"  data-qclass="yellowTip" data-qtip="History of Alarms" href="javascript:void(0);" onclick = \'javascript:LayersToHistoryOfAlarm("'+jsonData.layersTitle+'","'+compType+'");\'> </div></td></tr></table>'+assetIcon);

												if(!Ext.isEmpty(requestParams.isMoreInfosTreeView) && (requestParams.isMoreInfosTreeView || requestParams.isMoreInfosTreeView =="true"))
												{
													var titleStr='';
													if(jsonData.hasOwnProperty('showInstantMaintenanceConfigIcon') && !Ext.isEmpty(jsonData.showInstantMaintenanceConfigIcon) && jsonData.showInstantMaintenanceConfigIcon==true)
													{
														titleStr='<div><span style="float:left" class="layerListTitle"><a style="color:#fff" href="javascript:void(0);" onclick = \'javascript:componenetDetailsPopUp("'+componentDetailUrl+'");\'>'+decodeURI(jsonData.layersTitle)+'</a></span>';
														titleStr+='<span data-qtip="'+instMainPlcyTitle+'" data-qclass="yellowTip"><a style="color:#fff" href="javascript:void(0);" onclick = \'javascript:showMaintenanceOptsForComp("'+jsonData.hostNameToCheckMaintenance+'","'+jsonData.portNoToCheckMaintenance+'","'+jsonData.sidToCheckMaintenance+'","'+jsonData.layersTitle+'"); \'><img  class=\"iconMaintenancePolicyLayerModel\" src=\"/final/images/clear.png\"/></a></span></div>';
													}
													else
													{
														titleStr='<div><span style="float:left" class="layerListTitle"><a style="color:#fff" href="javascript:void(0);" onclick = \'javascript:componenetDetailsPopUp("'+componentDetailUrl+'");\'>'+decodeURI(jsonData.layersTitle)+'</a></span></div>';
													}
													layersList.setTitle();
												}
												else
												{
													layersList.setTitle('<div><span style="float:left" class="layerListTitle"><a style="color:#fff" href="javascript:void(0);" onclick = \'javascript:componenetDetailsPopUp("'+componentDetailUrl+'");\'>'+decodeURI(jsonData.layersTitle)+'</a></span>'+'<div  id="toolbarLayer" style="border:#000 0px solid;display:inline-block;float:right;height:'+uPsHeight+'"><span style="display:inline-block;" class="iconLayermodelToRum handSymbol"  data-qclass="yellowTip" data-qtip="'+rumDashBoardLbl+'" href="javascript:void(0);" onclick = \'javascript:DashboardToRumApp("'+jsonData.layersTitle+'");\'></span>'+'<span style="display:inline-block" class="iconAlarmHistory handSymbol"  data-qclass="yellowTip" data-qtip="'+HisofAlarmsLbl+'" href="javascript:void(0);" onclick = \'javascript:LayersToHistoryOfAlarm("'+jsonData.layersTitle+'","'+compType+'");\'></span>'+assetIcon+''+remoteIcon+'</div></div>');
												}

												layersList.loadData();
											}
											else if(!Ext.isEmpty(layersList))
											{
												layersList.jsonData=null;
												layersList.jsonErrData=jsonData.layersJson.errormsg;
												//layersList.setTitle('<table><tr><td><a style="color:#fff" href="javascript:void(0);" onclick = \'javascript:componenetDetailsPopUp("'+componentDetailUrl+'");\'>'+decodeURI(jsonData.layersTitle)+'</a></td><td style="padding-left:5px"><div style="float:left;margin-top:-4px" class="iconAlarmHistory  handSymbol"  data-qclass="yellowTip" data-qtip="History of Alarms" href="javascript:void(0);" onclick = \'javascript:LayersToHistoryOfAlarm("'+jsonData.layersTitle+'","'+compType+'");\'> </div></td></tr></table>'+assetIcon);

												if(!Ext.isEmpty(requestParams.isMoreInfosTreeView) && (requestParams.isMoreInfosTreeView || requestParams.isMoreInfosTreeView =="true"))
												{
													var titleStr='';
													if(jsonData.hasOwnProperty('showInstantMaintenanceConfigIcon') && !Ext.isEmpty(jsonData.showInstantMaintenanceConfigIcon) && jsonData.showInstantMaintenanceConfigIcon==true)
													{
														titleStr='<div><span style="float:left" class="layerListTitle"><a style="color:#fff" href="javascript:void(0);" onclick = \'javascript:componenetDetailsPopUp("'+componentDetailUrl+'");\'>'+decodeURI(jsonData.layersTitle)+''+remoteIcon+''+endUserIcon+''+transactionIcon+''+netScalarIcon+'</a></span>';
														titleStr+='<span data-qtip="'+instMainPlcyTitle+'" data-qclass="yellowTip"><a style="color:#fff" href="javascript:void(0);" onclick = \'javascript:showMaintenanceOptsForComp("'+jsonData.hostNameToCheckMaintenance+'","'+jsonData.portNoToCheckMaintenance+'","'+jsonData.sidToCheckMaintenance+'","'+jsonData.layersTitle+'"); \'><img class=\"iconMaintenancePolicyLayerModel\" src=\"/final/images/clear.png\"/></a></div>';
													}
													else
													{
														titleStr='<div><span style="float:left" class="layerListTitle"><a style="color:#fff" href="javascript:void(0);" onclick = \'javascript:componenetDetailsPopUp("'+componentDetailUrl+'");\'>'+decodeURI(jsonData.layersTitle)+'</a></span></div>';
													}
													//layersList.setTitle('');
													//var remoteUrl = jsonData.remoteUrl;
													//if(remoteUrl == 'undefined' || remoteUrl == undefined)
													{
														layersList.setTitle(titleStr);
													}
													//else{
														//layersList.setTitle('<div><span style="float:left"><a style="color:#fff" href="javascript:void(0);" onclick = \'javascript:componenetDetailsPopUp("'+componentDetailUrl+'");\'>'+decodeURI(jsonData.layersTitle)+'</a></span><div style="float:left;margin: 2px 0 0 5px;" class="iconRemoteControlLayermodel handSymbol"  data-qclass="yellowTip" data-qtip="Remote Control" href="javascript:void(0);" onclick = \'javascript:openRemoteControl("'+remoteUrl+'");\'></div></div>');
													//}
												}
												else
												{
													//layersList.setTitle('<div><span style="float:left"><a style="color:#fff" href="javascript:void(0);" onclick = \'javascript:componenetDetailsPopUp("'+componentDetailUrl+'");\'>'+decodeURI(jsonData.layersTitle)+'</a></span>'+'<div style="display:inline-block;float:right"><div class="userProfileSeparator" style="height:17px;display:inline-block;position:absolute;left:'+tabwidth+'"></div><span style="display:inline-block" class="iconAlarmHistory   handSymbol"  data-qclass="yellowTip" data-qtip="History of Alarms" href="javascript:void(0);" onclick = \'javascript:LayersToHistoryOfAlarm("'+jsonData.layersTitle+'","'+compType+'");\'></span>'+assetIcon+'</div></div>');
													//var remoteUrl = jsonData.remoteUrl;
													var layerTitle = '';

													//if(remoteUrl == 'undefined' || remoteUrl == undefined)
													{
														layerTitle += '<div><span style="float:left" class="layerListTitle"><a style="color:#fff" href="javascript:void(0);" onclick = \'javascript:componenetDetailsPopUp("'+componentDetailUrl+'");\'>'+decodeURI(jsonData.layersTitle)+'</a></span>'+'<div  id="toolbarLayer" style="border:#000 0px solid;display:inline-block;float:right"><span style="display:inline-block" class="iconAlarmHistory   handSymbol"  data-qclass="yellowTip" data-qtip="'+HisofAlarmsLbl+'" href="javascript:void(0);" onclick = \'javascript:LayersToHistoryOfAlarm("'+jsonData.layersTitle+'","'+compType+'");\'></span>'+assetIcon+''+remoteIcon+''+endUserIcon+''+transactionIcon+''+netScalarIcon;
													}
													
													if(jsonData.hasOwnProperty('showInstantMaintenanceConfigIcon') && !Ext.isEmpty(jsonData.showInstantMaintenanceConfigIcon) && jsonData.showInstantMaintenanceConfigIcon==true)
													{
														layerTitle+='<span data-qtip="'+instMainPlcyTitle+'" data-qclass="yellowTip"><a style="color:#fff" href="javascript:void(0);" onclick = \'javascript:showMaintenanceOptsForComp("'+jsonData.hostNameToCheckMaintenance+'","'+jsonData.portNoToCheckMaintenance+'","'+jsonData.sidToCheckMaintenance+'","'+jsonData.layersTitle+'"); \'><img  class=\"iconMaintenancePolicyLayerModel\" src=\"/final/images/clear.png\"/></a></div>';
													}
													layerTitle=layerTitle+'</div><div style="clear:both"></div></div>';

													layersList.setTitle(layerTitle);
													//else {
														//layersList.setTitle('<div><span style="float:left"><a style="color:#fff" href="javascript:void(0);" onclick = \'javascript:componenetDetailsPopUp("'+componentDetailUrl+'");\'>'+decodeURI(jsonData.layersTitle)+'</a></span><div style="float:left;margin: 2px 0 0 5px;" class="iconRemoteControlLayermodel handSymbol"  data-qclass="yellowTip" data-qtip="Remote Control" href="javascript:void(0);" onclick = \'javascript:openRemoteControl("'+remoteUrl+'");\'> </div>'+'<div style="display:inline-block;float:right"><div class="userProfileSeparator" style="height:17px;display:inline-block;position:absolute;left:'+tabwidth+'"></div><span style="display:inline-block" class="iconAlarmHistory   handSymbol"  data-qclass="yellowTip" data-qtip="History of Alarms" href="javascript:void(0);" onclick = \'javascript:LayersToHistoryOfAlarm("'+jsonData.layersTitle+'","'+compType+'");\'></span>'+assetIcon+'</div></div>');
													//}
												}
												layersList.loadData();
											}
										}

										var measuresUrl = jsonData.measuresUrl;

										if(!Ext.isEmpty(measuresPanel))
										{
											measuresPanel.changeUrl(Ext.isEmpty(measuresUrl)?"/final/monitor/egDashBoardDispCompMeasure.jsp?":measuresUrl);
											measuresPanel.reloadData();
										}
										else
										{
											measuresPanel = Ext.create('componentDashboard.view.Layers.Measures',{
												url : Ext.isEmpty(measuresUrl)?"/final/monitor/egDashBoardDispCompMeasure.jsp?":measuresUrl,
												flex : 1,
											});
										}

										if(Ext.isEmpty(headerContainer))
										{
											headerContainer = Ext.create('Ext.panel.Panel',{
												layout : {
													type:'vbox',
													align:'stretch'
												},
												flex :0.65,
												items:[{xtype:'container',id:'heading',height:22},measures]
											});
											me.add(headerContainer);
										}

										var layerController = null;
										layerController = componentDashboard.app.getController("LayersController");

										layerController.afterLayersTreeRender();

										var record = layerController.recordClicked;
										if(!Ext.isEmpty(record)){
											for(var rec = 0; rec < record.length;rec++){
												layerController.recordOpen(record[rec]);
											}
										}
										if(!Ext.isEmpty(layerController.rootCauseNode)){
											layerController.recordClicked = new Array();
											layerController.recordClicked.push(layerController.rootCauseNode);
											layerController.rootCauseNode = null;
										}
									}

									delete jsonData;
									Ext.destroy(jsonData);
								}
							}
						});
					}

					delete layerJsonData;
					Ext.destroy(layerJsonData);
				}
			},
			failure : function(){
				//window.location.href="/final/servlet/com.eg.EgMonitorController?monCmd=dashboard";
				//window.parent.location.href="/final/servlet/com.egurkha.Logout";
			}
		});
	}
});