Ext.define('componentDashboard.view.CompDashSystemTab', {
	extend: 'utilities.ScrollPanel',
	//requires:['componentDashboard.model.componentSystemCombo','componentDashboard.view.system.systemUpperPanel','componentDashboard.view.system.systemLowerPanel','componentDashboard.view.system.systemInnerTabPanel'],
	alias:'widget.compdashsystemtab',
	layout : 'column',
	autoScroll:true,
	scroll:true,
	bodyCls : 'systemTab-bg',
	url : null,
	items : [],
	initComponent : function(){
		var me = this;
		this.callParent();
	},
	
	createTabUI:function(jsonData){
		var me = this;
		me.removeAll();
		var topToolbar=this.getDockedComponent(0);
		if(!Ext.isEmpty(topToolbar)){
			this.removeDocked( topToolbar, true);
		}
		var comboStore=Ext.create('Ext.data.Store',{
			model:'componentDashboard.model.componentSystemCombo',
		    proxy: {
		        type: 'memory',
		        reader: {
		            type: 'json',
		            root:'tokenLayer'
		        }
		    },
		    data:jsonData.tokenArray
		});
		/*var emptyValue='';
		if(!Ext.isEmpty(jsonData.tokenArray[0]))
			emptyValue = jsonData.tokenArray[0].value*/
		
		me.addDocked([{
			xtype : 'toolbar',
			docked : 'top',
			cls : 'component-list-right-panel-header',
			items : ['->',{
				xtype:'combo',								 // System ---> Combo
				cls:'dropdown subsystem-combo',
				store:comboStore,
				margin:2,
				width : 250,
				labelWidth : 100,
				maxWidth : 250,
			//	emptyText:emptyValue,
	    	   fieldLabel:jsonData.subsystem.text,
	    	   editable:false,
	    	   displayField:'value',
	    	   id:'subsystemSelect',
	    	   valueField:'value',
	    	   value : jsonData.selected
	    	}]
		}]);
		var innerTabPanel = {
				xtype : 'systeminnertabpanel',
				columnWidth : 1,
				historyUrl:jsonData.historyUrl,
				ataGlanceUrl :jsonData.systemUrl,
				tabsInfoUrl :  jsonData.tabsInfoUrl
		};
	if(Ext.isEmpty(jsonData.url))
	{
		var upperPanel = {
				xtype : 'systemupperpanel',
				jsonData :jsonData,
				columnWidth : 1
		};
		me.add(upperPanel);
		me.add(innerTabPanel);
		if(!Ext.isEmpty(this.mask)){
			this.mask.hide();}
	}
	else{
		Ext.Ajax.request({
			url : jsonData.url+"&tab=System",
			method : 'POST',
			scope:this,
			success : function(response, opts){
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				var upperPanel = {
						xtype : 'systemupperpanel',
						jsonData :jsonData,
						columnWidth : 1
				};
				me.add(upperPanel);
				me.add(innerTabPanel);
				if(!Ext.isEmpty(this.mask)){
			this.mask.hide();}
			},
			failure : function(){
				//alert("failure");
				}
		});
	}

	}
});