Ext.define('componentDashboard.view.CompDashVirtualTab', {
	extend: 'utilities.ScrollPanel',
	alias:'widget.compdashvirtualtab',
	//requires:['componentDashboard.view.virtual.insideUpperPanel','componentDashboard.view.virtual.virtualGraphPanel','componentDashboard.view.virtual.virtualUpperPanel','componentDashboard.view.virtual.virtualOutsideGraphPanel','componentDashboard.view.virtual.virtualOutsideUpperPanel','componentDashboard.view.virtual.VirtualTabInsideview','componentDashboard.view.virtual.MeasuresData'],
	layout : {
		type:'vbox',
		align:'stretch',
		defaultMargins:'10 10 0 10'
	},
	jsonData:null,
	currentTab:null,
	//bodyCls:'virtual-tab-upper-Background',
	cls:'TabBgStatic',
	url : null,
	border:false,

	createTabUI:function(jsonData){
		this.jsonData=jsonData;
		var me = this;
		me.removeAll();
		var dockedItems = me.getDockedItems('toolbar');
        for(var dockedCounter = 0 ; dockedCounter < dockedItems.length ; dockedCounter++){
        	me.removeDocked(dockedItems[dockedCounter]);
        }
		var middlePanel;
		var upperPanel;
		var subsystem =jsonData.hiddenFields.subsystem; 
		if((subsystem.indexOf('Analysis')>-1))
		{
			middlePanel={
				xtype: 'virtualgraphpanel',
				jsonData: jsonData,
				flex:1
			};
			upperPanel={
					xtype:'virtualupperpanel',
					jsonData: jsonData,
					autoHeight:true
			};
			me.add([upperPanel,middlePanel]);
		}
		else if((subsystem.indexOf('OutsideView')>-1))
		{
			middlePanel={
					xtype: 'virtualoutsidegraphpanel',
					jsonData: jsonData,
					flex:1
				};
			upperPanel={
					xtype:'virtualoutsideupperpanel',
					jsonData: jsonData,
					autoHeight:true
			};
			me.add([upperPanel,middlePanel]);
		}
		else
		{
			upperPanel = {
					xtype:'insideupperpanel',
					jsonData: jsonData,
					autoHeight:true
			};
			middlePanel = {
					xtype:'virtualtabinsideview',
					autoHeight:true,
					activeTab:0,
					flex:1
			};
			me.add([upperPanel,middlePanel]);
			insideVMrefresh = false;
		}
		//me.add([upperPanel,middlePanel]);
		this.doLayout();
		if(!Ext.isEmpty(this.mask)){
			this.mask.hide();}
	},
	createTabUIRefresh:function(jsonData,currentTab){
		this.jsonData=jsonData;
		this.currentTab=currentTab;
		var me = this;
		me.removeAll();
		var dockedItems = me.getDockedItems('toolbar');
        for(var dockedCounter = 0 ; dockedCounter < dockedItems.length ; dockedCounter++){
        	me.removeDocked(dockedItems[dockedCounter]);
        }
		var middlePanel;
		var upperPanel;
		var subsystem =jsonData.hiddenFields.subsystem; 
		if((subsystem.indexOf('Analysis')>-1))
		{
			middlePanel={
				xtype: 'virtualgraphpanel',
				jsonData: jsonData,
				flex:1
			};
			upperPanel={
					xtype:'virtualupperpanel',
					jsonData: jsonData,
					autoHeight:true
			};
			me.add([upperPanel,middlePanel]);
		}
		else if((subsystem.indexOf('OutsideView')>-1))
		{
			middlePanel={
					xtype: 'virtualoutsidegraphpanel',
					jsonData: jsonData,
					flex:1
				};
			upperPanel={
					xtype:'virtualoutsideupperpanel',
					jsonData: jsonData,
					autoHeight:true
			};
			me.add([upperPanel,middlePanel]);
		}
		else
		{
			upperPanel = {
					xtype:'insideupperpanel',
					jsonData: jsonData,
					autoHeight:true
			};
			middlePanel = {
					xtype:'virtualtabinsideview',
					autoHeight:true,
					activeTab:currentTab,
					flex:1
			};
			me.add([upperPanel,middlePanel]);
		}
		insideVMrefresh = true;
		//me.add([upperPanel,middlePanel]);
		this.doLayout();
		if(!Ext.isEmpty(this.mask)){
			this.mask.hide();}
	}
});
