if(requestParams.isMoreInfosTreeView)
{
	Ext.define('componentDashboard.view.ComponentTabPanel', {
	extend: 'Ext.tab.Panel',
	requires : ['componentDashboard.view.CompDashLayersTab','componentDashboard.view.system.CompDashDetailsTab','componentDashboard.view.Application.ThreadDetails','componentDashboard.view.network.NetworkMainPanel'],
	alias:'widget.componenttabpanel',
	id:"ComponentTabPanelId",
	tabsInfo:null,
	cls:'tablayout',
	bodyCls:'tablayoutBodyColor',
	initComponent : function() {
		var mask = null;
		var wholeViewport = document.getElementsByTagName("body")[0];
		if(!Ext.isEmpty(Ext.get(wholeViewport))){
			mask = new Ext.LoadMask(Ext.get(wholeViewport), {msg:"Loading...",cls:'maskDash'});
			mask.show();
		}
	
	 var itemsArray=new Array();
	 if(!Ext.isEmpty(this.tabsInfo)){
		 for(var i=0;i<this.tabsInfo.length;i++){
			 var type=this.tabsInfo[i].type;
			 var cmpXtype=this.getTabXtype(this.tabsInfo[i].type);
			 if ( cmpXtype == 'applicationpanel' )
			 {
				 //this.tabsInfo[i].name = 'Application';
				 this.tabsInfo[i].index = '3';
			 }
			 else if ( cmpXtype == 'networkmainpanel' )
			 {
				//this.tabsInfo[i].name = 'Network';
				 this.tabsInfo[i].index = '2';
			 }
			 else if ( cmpXtype == 'compdashdetailsMaintab' )
			 {
				 //this.tabsInfo[i].name = 'System';
				 this.tabsInfo[i].index = '1';
			 }
			 else if ( cmpXtype == 'interfacepanel' )
			 {
				 //this.tabsInfo[i].name = 'Interfaces';
				 this.tabsInfo[i].index = '4';
			 }
			 else if ( cmpXtype == 'custom' )
			 {
				//this.tabsInfo[i].name = 'Network';
				 this.tabsInfo[i].index = '5';
			 }

			 itemsArray.push({
				 xtype:cmpXtype,
				 title:this.tabsInfo[i].name,
				 itemId:type.toLowerCase(),
				 tabIndex:this.tabsInfo[i].index,
				 mask:mask
			 });
		 }
	 }
	
	this.items=itemsArray;
	this.callParent();
	},
	
	getTabXtype:function(type){
		switch(type.toLowerCase()){
			case 'system': cmpXtype='compdashdetailsMaintab';
							break;
			case 'network': cmpXtype='networkmainpanel';
							break;
			case 'layers': cmpXtype='compdashlayerstab';
							break;
			case 'custom': cmpXtype='compdashcustomtab';
							break;
			case 'virtual': cmpXtype='compdashvirtualtab';
							break;
			case 'application': cmpXtype='applicationpanel';
							break;
			case 'interfaces': cmpXtype='interfacepanel';
							break;
					}
		return cmpXtype;
	},

	onRender : function(){
		this.getTabBar().add([{
			xtype : 'tbfill',
			hidden : hideAddCustomDashboardIcon
		},{
			xtype:'container',
			border:true,
			hidden : hideAddCustomDashboardIcon,
			cls:'iconIstamDashboardAdd',
			width:22,
			height:10,
			padding:0,
			margin:'4px 0px 0px 0px',
			items:{
				xtype : 'button',
				//cls:'overflowBt',
				hidden:false,
				width:22,
				height:19,
				style:{background:'none',border:'0px'},
				itemId:'istamDashboardCreate',
				handler : function()
				{
					document.location="/final/monitor/egDashboardProfile.jsp?compType="+hostTypeEncoded+"&hostName="+hostNameEncoded;
				}
			}
		},{
			xtype : 'tbfill'
		},{
			xtype:'combo',
			cls:'dropdown',
			hidden:true,
			itemId:'componentTypeCombo',
			id: 'componentTypeCombo',
			width:265,
			editable:false,
			labelWidth:35,
			labelStyle:'padding:2px 0px 0px;text-align:right',
			fieldLabel:'Type',
			labelAlign:'left',
			 labelSeparator: '' ,
			displayField:'text',
			valueField:'value',
			queryMode:'local',
			store:Ext.create('Ext.data.Store',{
				fields:['value','text']
			}),
			margin:'3 0 0 10'
		},{
			xtype:'scrollcombo',
			cls:'dropdown',
			hidden:true,
			labelStyle:'padding:2px 0px 0px;text-align:right',
			itemId:'componentNameCombo',
			id: 'componentNameCombo',
			style:{background:'none',border:'2px'},
			width:265,
			labelWidth:35,
			 labelSeparator: '' ,
			fieldLabel:'Name',
			editable:true,
			labelAlign:'left',
			displayField:'text',
			valueField:'value',
			queryMode:'local',
			store:Ext.create('Ext.data.Store',{
				fields:['state',{name:'text',convert:function(value, record){
					return decodeURI(value);
				}},'value']
			}),
			margin:'3 0 0 10',
			tpl: Ext.create('Ext.XTemplate',
				'<ul>',
				'<tpl for=".">',
					'<li class="x-boundlist-item"><img src="/final/images/spacer.gif" style="padding-left:18px;vertical-align:middle" class="state_{state}"/>{text}</li>',
				'</tpl>',
				'</ul>'
			)
		},{
			xtype:'scrollcombo',
			cls:'dropdown',
			hidden:true,
			itemId:'componentsDropDown',
			labelStyle:'padding:2px 0px 0px;text-align:right',
			id: 'componentsDropDown',
			style:{background:'none',border:'0px'},
			width:310,
			labelWidth:70,
			editable:true,
			 labelSeparator: '' ,
			fieldLabel:'Component',
			labelAlign:'left',
			displayField:'text',
			valueField:'value',
			
			queryMode:'local',
			store:Ext.create('Ext.data.Store',{
				fields:['state',{name:'text',convert:function(value, record){
					return decodeURI(value);
				}},'value']
			}),
			margin:'2 10 0 10',
			tpl: Ext.create('Ext.XTemplate',
				//'<ul style="display:inline-block;white-space:nowrap">',
				'<ul style="white-space:nowrap">',
				'<tpl for=".">',
					'<li class="x-boundlist-item"><img src="/final/images/spacer.gif" style="padding-left:18px;vertical-align:middle" class="state_{state}"/>{text}</li>',
				'</tpl>',
				'</ul>'
			)
		},{
			xtype : 'button',
			iconCls:'iconComponent_GRAY',
			cls:'overflowBt',
			hidden:true,
			style:{background:'none',border:'0px'},
			itemId:'compoentDetails'
		},/*{
			xtype : 'tbfill'

		},*/{
				xtype: 'tbseparator',
				itemId:'iconButtonSeparator',
				margin:'6 0 0 10',
				padding:0
			},
			{
				xtype: 'toolbar',
				defaults:{
				xtype: 'button',
				hidden:true,
				margin:'5 0 0 0',
				padding:'0 5 0 5',
				style: {
					background: 'none',
					border: '0px'
				}
			},
			items:[{ 
				iconCls: 'iconSettings',
				itemId:'iconSettings',
				
				listeners:{
					afterrender:function(){
						Ext.create('Ext.tip.ToolTip',{
							target: this.id,
							anchor: 'top',
							cls: 'yellowTip',
							trackMouse: true,
							html: 'Settings'
						});
					}
				}
			},{
				xtype: 'tbseparator',
				itemId:'iconSettingsSeparator',
				padding:0
			},{
				iconCls:'iconService',
				itemId:'iconService',
				
				action:'layerTool',
				listeners:{
					afterrender: function(){
						Ext.create('Ext.tip.ToolTip',{
							target: this.id,
							anchor: 'top',
							cls: 'yellowTip',
							trackMouse: true,
							html: 'Service'
						});
					}
				}
			},{
				xtype: 'tbseparator',
				padding:0,
				itemId:'iconServiceSeparator',
				
			},{
				iconCls:'iconTransactions',
				itemId:'iconTransactions',
				
				action:'layerTool',
				listeners:{
					afterrender: function(){
						Ext.create('Ext.tip.ToolTip',{
							target: this.id,
							anchor: 'top',
							cls: 'yellowTip',
							trackMouse: true,
							html: 'Transactions'
						});
					}
				}
			},{
				xtype: 'tbseparator',
				padding:0,
				itemId:'iconTransactionsSeparator',
				
			},{
				iconCls:'iconTransactions',
				itemId:'iconEmuTransactions',
				
				action:'layerTool',
				listeners:{
					afterrender: function(){
						Ext.create('Ext.tip.ToolTip',{
							target: this.id,
							anchor: 'top',
							cls: 'yellowTip',
							trackMouse: true,
							html: simulatedTransactionFlow
						});
					}
				}
			},{
				xtype: 'tbseparator',
				padding:0,
				itemId:'iconEmuTransactionsSeparator',
				
			},{
				iconCls:'iconConfigUser',
				itemId:'iconConfigUser',
				//action:'layerTool',
				listeners:{
					afterrender: function(){
						Ext.create('Ext.tip.ToolTip',{
							target: this.id,
							anchor: 'top',
							cls: 'yellowTip',
							trackMouse: true,
							html: 'Config'
						});
					}
				}
			},{
				xtype: 'tbseparator',
				padding:0,
				itemId:'iconConfigUserSeparator',
			
			},{
				iconCls:'iconComponent',
				itemId:'iconComponent',
				action:'layerTool',
				
				listeners:{
					afterrender: function(){
						Ext.create('Ext.tip.ToolTip',{
							target: this.id,
							anchor: 'top',
							cls: 'yellowTip',
							trackMouse: true,
							html: 'Server'
						});
					}
				}
			},{
				xtype: 'tbseparator',
				padding:0,
				itemId:'iconComponentSeparator',
			},{
				iconCls:'iconTopology',
				itemId:'iconTopology',
				
				action:'layerTool',
				listeners:{
					afterrender: function(){
						Ext.create('Ext.tip.ToolTip',{
							target: this.id,
							anchor: 'top',
							cls: 'yellowTip',
							trackMouse: true,
							html: 'Topology'
						});
					}
				}
			},{
				xtype: 'tbseparator',
				padding:0,
				itemId:'iconTopologySeparator',
			},{
				iconCls:'iconVirtualTopology',
				itemId:'iconVirtualTopology',
				action:'layerTool',
				
				listeners:{
					afterrender: function(){
						Ext.create('Ext.tip.ToolTip',{
							target: this.id,
							anchor: 'top',
							cls: 'yellowTip',
							trackMouse: true,
							html: 'Virtual Topology'
						});
					}
				}
			},{
				xtype: 'tbseparator',
				padding:0,
				itemId:'iconVirtualTopologySeparator',
			},{
				iconCls:'iconDesktop',
				itemId:'iconDesktop',
				
				action:'layerTool',
				listeners:{
						afterrender: function(){
							Ext.create('Ext.tip.ToolTip',{
								target: this.id,
								anchor: 'top',
								cls: 'yellowTip',
								trackMouse: true,
								html: 'Desktop'
							});
						}
					}
				}		
			]
		},{
			xtype : 'button',
			margin:'4 4 0 4',
			iconCls:'iconBack',
			text : requestParams.backText,
			action : 'back',
			cls:'backbutton'
		}]);
		this.callParent();
	},

	setLayerToolbar:function(data,componentToolTip,componentState){
		this.down('button[itemId=compoentDetails]').setTooltip(componentToolTip);
		this.down('button[itemId=compoentDetails]').setIconCls(componentState);

		if(!requestParams.configChangeIcon == true || requestParams.configChangeIcon == 'true'){
			//this.down('button[itemId=iconConfigUser]').link = requestParams.configChangeLink;
			var isFromMonitor = true;
			var configurl = requestParams.configChangeLink;
			var compName = "";
			if(requestParams.configChangeLink != null && requestParams.configChangeLink != "")
			{
				var params = configurl.substring(configurl.indexOf("?")+1,configurl.length);
				var paramsArray = params.split("&");
				for(var i=0;i<paramsArray.length;i++)
				{
					var temp_param = paramsArray[i];
					if(temp_param.indexOf("componentName") > -1)
					{
						compName = temp_param.substring(temp_param.indexOf("=")+1);
					}
				}
			}
			var url = "/final/servlet/com.eg.EcConfigurationServletNew?ec_rtype=ChangeNew&ec_option1=Component Name&ec_timeline=1+day&ec_prevtimeline=1+day&ec_option2="+compName+"&ec_changetype=Latest&ec_viewchange=byInformation&fromPage=configChange&ec_criteria=Component&fromMonitor="+isFromMonitor;
			this.down('button[itemId=iconConfigUser]').setHandler(function(handler, scope) {

				if (!Ext.getCmp("configContainer"))
				{
					var xaxis = 415;
					if(!Ext.isEmpty(Ext.getCmp('ComponentTabPanelId')) && Ext.getCmp('ComponentTabPanelId')!=undefined)
						xaxis = Ext.getCmp('ComponentTabPanelId').getWidth()-935;

					Ext.create('Ext.container.Container',{
						padding:0,
						floating:true,
						frame:false,
						width:900,
						hidden:true,
						height:357,
						x:xaxis,
						y:25,
						shadow:true,
						floatable:true,
						id:'configContainer',
						cls:'configPopupWindow',
						items:[
							{
								xtype:'container',
								cls:'configPopupArrow',
								style:{'top':"-6px",'left':"854px"}
							},
							{
								xtype:'container',
								cls:'configPopfont',
								padding:0,
								html:'<table cellspacing="0" cellpadding="0" border="0"><tr><td style="width:100%"><div style="float:left;margin:0px 0px 0px 4px;border-bottom:none;padding:0px 0px 3px 0px" class="configPopfont">CONFIGURATION CHANGES FOR '+compName.substring(0,compName.indexOf(":"))+' DURING LAST 24 hrs</div></td><td style="color:#01a6f6;font-weight:bold;width:92px;display:block"><div style="float:left;margin-top:0px"><a href="'+configurl+'" class="configLink">More details</a></div><div class="configSeparator" style="margin-right:5px;margin-top:0px;"></div></td><td><div style="text-align:right;width:25px"><div class="iconClose3" style="margin-top:-4px"></div></div></td></tr></table>',
								style:{'top':'0px','margin':'2px'}
							},
							{
								xtype:'panel',
								id:'configDataPanel',
								height:320,
								cls:'configPopupWindow_inner',
								html:'<iframe width="900" height=315" border="0" scrolling="yes" marginwidth="0px" marginheight="0px" frameborder="0"  src="'+url+'"> </iframe>'
							
							}
							
						]
					}).show();

					Ext.select('.iconClose3').on('click',function(){
			
							Ext.getCmp("configContainer").hide();
							Ext.getCmp("configContainer").removeAll();
							Ext.getCmp("configContainer").destroy();
							//Ext.get("configDetails").destroy();
					},this);

				}
			});
			this.down('button[itemId=iconConfigUser]').show();
		}
		else{
			this.down('button[itemId=iconConfigUser]').hide();
		}

		if(!Ext.isEmpty(data) && data.length > 0){
			for(i=0;i<data.length;i++){
				switch(data[i].icon){
					case 'SERVICES':{
						this.down('button[itemId=iconService]').link = data[i].href;
						this.down('button[itemId=iconService]').show();
						this.down('tbseparator[itemId=iconServiceSeparator]').show();
						break;
					}
					case 'TOPOLOGY':{
						data[i].href = data[i].href+'&LayerModelTopology=yes';
						this.down('button[itemId=iconTopology]').link = data[i].href;
						this.down('button[itemId=iconTopology]').show();
						this.down('tbseparator[itemId=iconTopologySeparator]').show();
						break;
					}
					case 'EMULATED_TRANSACTIONS':{
						this.down('button[itemId=iconEmuTransactions]').link = data[i].href;
						this.down('button[itemId=iconEmuTransactions]').show();
						this.down('tbseparator[itemId=iconEmuTransactionsSeparator]').show();
						break;
					}
					case 'TRANSACTIONS':{
						this.down('button[itemId=iconTransactions]').link = data[i].href;
						this.down('button[itemId=iconTransactions]').show();
						this.down('tbseparator[itemId=iconTransactionsSeparator]').show();
						break;
					}
					case 'VIRTUAL TOPOLOGY':{
						this.down('button[itemId=iconVirtualTopology]').setIconCls('iconVirtualTopology_'+data[i].hostState);
						this.down('button[itemId=iconVirtualTopology]').link = data[i].href;
						this.down('button[itemId=iconVirtualTopology]').show();
						this.down('tbseparator[itemId=iconVirtualTopologySeparator]').show();
						break;
					}
					case 'SERVERS':{
						this.down('button[itemId=iconComponent]').link = data[i].href;
						this.down('button[itemId=iconComponent]').show();
						this.down('tbseparator[itemId=iconComponentSeparator]').show();
						break;
					}
					case 'DESKTOPS':{
						this.down('button[itemId=iconDesktop]').link = data[i].href;
						this.down('button[itemId=iconDesktop]').show();
						break;
					}
				}
			}
			this.down('tbseparator[itemId=iconButtonSeparator]').show();
		}
		else
			this.down('tbseparator[itemId=iconButtonSeparator]').hide();
	}
});
}
else if(requiresBasic && (!requiresWithVirtual))
{
Ext.define('componentDashboard.view.ComponentTabPanel', {
	extend: 'Ext.tab.Panel',
	//requires : ['componentDashboard.view.CompDashSystemTab','componentDashboard.view.CompDashNetworkTab','componentDashboard.view.CompDashLayersTab','componentDashboard.view.CompDashCustomTab','componentDashboard.view.CompDashVirtualTab','componentDashboard.view.Application.ApplicationPanel','componentDashboard.view.Interfaces.InterfaceTab','componentDashboard.view.network.NetworkMainPanel','componentDashboard.view.system.CompDashDetailsTab'],
	//requires : ['componentDashboard.view.CompDashLayersTab','componentDashboard.view.system.CompDashDetailsTab','componentDashboard.view.Application.ThreadDetails','componentDashboard.view.network.NetworkMainPanel','componentDashboard.view.Application.ApplicationPanel','componentDashboard.view.CompDashVirtualTab','componentDashboard.view.Interfaces.InterfaceTab','componentDashboard.view.CompDashCustomTab'],
	requires : ['componentDashboard.view.CompDashLayersTab','componentDashboard.view.system.CompDashDetailsTab','componentDashboard.view.Application.ThreadDetails','componentDashboard.view.network.NetworkMainPanel','componentDashboard.view.CompDashCustomTab','componentDashboard.view.netflow.NetflowMainPanel'],
	//requires : ['componentDashboard.view.CompDashSystemTab','componentDashboard.view.CompDashNetworkTab','componentDashboard.view.CompDashLayersTab','componentDashboard.view.network.NetworkMainPanel','componentDashboard.view.system.CompDashDetailsTab','componentDashboard.view.Application.ThreadDetails'],
	alias:'widget.componenttabpanel',
	id:"ComponentTabPanelId",
	tabsInfo:null,
	cls:'tablayout',
	bodyCls:'tablayoutBodyColor',
	initComponent : function() {
		var mask = null;
		var wholeViewport = document.getElementsByTagName("body")[0];
		if(!Ext.isEmpty(Ext.get(wholeViewport))){
			mask = new Ext.LoadMask(Ext.get(wholeViewport), {msg:"Loading...",cls:'maskDash'});
			mask.show();
		}
	
	 var itemsArray=new Array();
	 if(!Ext.isEmpty(this.tabsInfo)){
		 for(var i=0;i<this.tabsInfo.length;i++){
			 var type=this.tabsInfo[i].type;
			 var cmpXtype=this.getTabXtype(this.tabsInfo[i].type);
			 if ( cmpXtype == 'applicationpanel' )
			 {
				 //this.tabsInfo[i].name = 'Application';
				 this.tabsInfo[i].index = '3';
			 }
			 else if ( cmpXtype == 'networkmainpanel' )
			 {
				//this.tabsInfo[i].name = 'Network';
				 this.tabsInfo[i].index = '2';
			 }
			 else if ( cmpXtype == 'netflowmainpanel' )
			 {
				 //this.tabsInfo[i].name = 'NetFlow';
				 this.tabsInfo[i].index = '1';
			 }
			 else if ( cmpXtype == 'compdashdetailsMaintab' )
			 {
				 //this.tabsInfo[i].name = 'System';
				 this.tabsInfo[i].index = '1';
			 }
			 else if ( cmpXtype == 'interfacepanel' )
			 {
				 //this.tabsInfo[i].name = 'Interfaces';
				 this.tabsInfo[i].index = '4';
			 }
			 else if ( cmpXtype == 'custom' )
			 {
				//this.tabsInfo[i].name = 'Network';
				 this.tabsInfo[i].index = '5';
			 }
			
			if (cmpXtype == 'netflowmainpanel')
			{
				itemsArray.push({
					xtype:'panel',
					flex:1,
					layout:'fit',
					bodyPadding:10,
					title:this.tabsInfo[i].name,
					itemId:type.toLowerCase(),
					mask:mask,
					tabIndex:this.tabsInfo[i].index,
					bodyCls :'TabBgStatic',
					items:[{
						xtype:'netflowmainpanel'
					}]
				});
			}
			else{
				 itemsArray.push({
					 xtype:cmpXtype,
					 title:this.tabsInfo[i].name,
					 itemId:type.toLowerCase(),
					 activeTab:0,
					 tabIndex:this.tabsInfo[i].index,
					 mask:mask
				 });
			}
		}
	 }	
	this.items=itemsArray;
	this.callParent();
	},
	
	getTabXtype:function(type){
		switch(type.toLowerCase()){
			case 'system': cmpXtype='compdashdetailsMaintab';
							break;
			case 'network': cmpXtype='networkmainpanel';
							break;
			case 'layers': cmpXtype='compdashlayerstab';
							break;
			case 'custom': cmpXtype='compdashcustomtab';
							break;
			case 'virtual': cmpXtype='compdashvirtualtab';
							break;
			case 'application': cmpXtype='applicationpanel';
							break;
			case 'interfaces': cmpXtype='interfacepanel';
							break; 
			case 'netflow': cmpXtype='netflowmainpanel';
							break;
		}
		return cmpXtype;
	},

	onRender : function(){
		this.getTabBar().add([{
			xtype : 'tbfill',
			hidden : hideAddCustomDashboardIcon
		},{
			xtype:'container',
			border:true,
			hidden : hideAddCustomDashboardIcon,
			cls:'iconIstamDashboardAdd',
			width:22,
			height:10,
			padding:0,
			margin:'4px 0px 0px 0px',
			items:{
				xtype : 'button',
				//cls:'overflowBt',
				hidden:false,
				width:22,
				height:19,
				style:{background:'none',border:'0px'},
				itemId:'istamDashboardCreate',
				handler : function()
				{
					document.location="/final/monitor/egDashboardProfile.jsp?compType="+hostTypeEncoded+"&hostName="+hostNameEncoded;
				}
			}
		},{
			xtype : 'tbfill'
		},{
			xtype:'combo',
			cls:'dropdown',
			hidden:true,
			itemId:'componentTypeCombo',
			id: 'componentTypeCombo',
			width:265,
			editable:false,
			labelWidth:35,
			labelStyle:'padding:2px 0px 0px;text-align:right',
			fieldLabel:'Type',
			labelAlign:'left',
			 labelSeparator: '' ,
			displayField:'text',
			valueField:'value',
			queryMode:'local',
			store:Ext.create('Ext.data.Store',{
				fields:['value','text']
			}),
			margin:'3 0 0 10'
		},{
			xtype:'scrollcombo',
			cls:'dropdown',
			hidden:true,
			labelStyle:'padding:2px 0px 0px;text-align:right',
			itemId:'componentNameCombo',
			id: 'componentNameCombo',
			style:{background:'none',border:'2px'},
			width:265,
			labelWidth:35,
			 labelSeparator: '' ,
			fieldLabel:'Name',
			editable:true,
			labelAlign:'left',
			displayField:'text',
			valueField:'value',
			queryMode:'local',
			store:Ext.create('Ext.data.Store',{
				fields:['state',{name:'text',convert:function(value, record){
					return decodeURI(value);
				}},'value']
			}),
			margin:'3 0 0 10',
			tpl: Ext.create('Ext.XTemplate',
				'<ul>',
				'<tpl for=".">',
					'<li class="x-boundlist-item"><img src="/final/images/spacer.gif" style="padding-left:18px;vertical-align:middle" class="state_{state}"/>{text}</li>',
				'</tpl>',
				'</ul>'
			)
		},{
			xtype:'scrollcombo',
			cls:'dropdown',
			hidden:true,
			itemId:'componentsDropDown',
			labelStyle:'padding:2px 0px 0px;text-align:right',
			id: 'componentsDropDown',
			style:{background:'none',border:'0px'},
			width:310,
			labelWidth:70,
			editable:true,
			 labelSeparator: '' ,
			fieldLabel:'Component',
			labelAlign:'left',
			displayField:'text',
			valueField:'value',
			
			queryMode:'local',
			store:Ext.create('Ext.data.Store',{
				fields:['state',{name:'text',convert:function(value, record){
					return decodeURI(value);
				}},'value']
			}),
			margin:'2 10 0 10',
			tpl: Ext.create('Ext.XTemplate',
				//'<ul style="display:inline-block;white-space:nowrap">',
				'<ul style="white-space:nowrap">',
				'<tpl for=".">',
					'<li class="x-boundlist-item"><img src="/final/images/spacer.gif" style="padding-left:18px;vertical-align:middle" class="state_{state}"/>{text}</li>',
				'</tpl>',
				'</ul>'
			)
		},{
			xtype : 'button',
			iconCls:'iconComponent_GRAY',
			cls:'overflowBt',
			hidden:true,
			style:{background:'none',border:'0px'},
			itemId:'compoentDetails'
		},/*{
			xtype : 'tbfill'

		},*/{
				xtype: 'tbseparator',
				itemId:'iconButtonSeparator',
				margin:'6 0 0 10',
				padding:0
			},{
			xtype: 'toolbar',
			defaults:{
				xtype: 'button',
				hidden:true,
				margin:'5 0 0 0',
				padding:'0 5 0 5',
				style: {
					background: 'none',
					border: '0px'
				}
			},
			items:[{ 
				iconCls: 'iconSettings',
				itemId:'iconSettings',
				
				listeners:{
					afterrender:function(){
						Ext.create('Ext.tip.ToolTip',{
							target: this.id,
							anchor: 'top',
							cls: 'yellowTip',
							trackMouse: true,
							html: 'Settings'
						});
					}
				}
			},{
				xtype: 'tbseparator',
				itemId:'iconSettingsSeparator',
				padding:0
			},{
				iconCls:'iconService',
				itemId:'iconService',
				
				action:'layerTool',
				listeners:{
					afterrender: function(){
						Ext.create('Ext.tip.ToolTip',{
							target: this.id,
							anchor: 'top',
							cls: 'yellowTip',
							trackMouse: true,
							html: 'Service'
						});
					}
				}
			},{
				xtype: 'tbseparator',
				padding:0,
				itemId:'iconServiceSeparator',
				
			},{
				iconCls:'iconTransactions',
				itemId:'iconTransactions',
				
				action:'layerTool',
				listeners:{
					afterrender: function(){
						Ext.create('Ext.tip.ToolTip',{
							target: this.id,
							anchor: 'top',
							cls: 'yellowTip',
							trackMouse: true,
							html: 'Transactions'
						});
					}
				}
			},{
				xtype: 'tbseparator',
				padding:0,
				itemId:'iconTransactionsSeparator',
				
			},{
				iconCls:'iconTransactions',
				itemId:'iconEmuTransactions',
				
				action:'layerTool',
				listeners:{
					afterrender: function(){
						Ext.create('Ext.tip.ToolTip',{
							target: this.id,
							anchor: 'top',
							cls: 'yellowTip',
							trackMouse: true,
							html: simulatedTransactionFlow
						});
					}
				}
			},{
				xtype: 'tbseparator',
				padding:0,
				itemId:'iconEmuTransactionsSeparator',
				
			},{
				iconCls:'iconConfigUser',
				itemId:'iconConfigUser',
				//action:'layerTool',
				listeners:{
					afterrender: function(){
						Ext.create('Ext.tip.ToolTip',{
							target: this.id,
							anchor: 'top',
							cls: 'yellowTip',
							trackMouse: true,
							html: 'Config'
						});
					}
				}
			},{
				xtype: 'tbseparator',
				padding:0,
				itemId:'iconConfigUserSeparator',
			
			},{
				iconCls:'iconComponent',
				itemId:'iconComponent',
				action:'layerTool',
				
				listeners:{
					afterrender: function(){
						Ext.create('Ext.tip.ToolTip',{
							target: this.id,
							anchor: 'top',
							cls: 'yellowTip',
							trackMouse: true,
							html: 'Server'
						});
					}
				}
			},{
				xtype: 'tbseparator',
				padding:0,
				itemId:'iconComponentSeparator',
			},{
				iconCls:'iconTopology',
				itemId:'iconTopology',
				
				action:'layerTool',
				listeners:{
					afterrender: function(){
						Ext.create('Ext.tip.ToolTip',{
							target: this.id,
							anchor: 'top',
							cls: 'yellowTip',
							trackMouse: true,
							html: 'Topology'
						});
					}
				}
			},{
				xtype: 'tbseparator',
				padding:0,
				itemId:'iconTopologySeparator',
			},{
				iconCls:'iconVirtualTopology',
				itemId:'iconVirtualTopology',
				action:'layerTool',
				
				listeners:{
					afterrender: function(){
						Ext.create('Ext.tip.ToolTip',{
							target: this.id,
							anchor: 'top',
							cls: 'yellowTip',
							trackMouse: true,
							html: 'Virtual Topology'
						});
					}
				}
			},{
				xtype: 'tbseparator',
				padding:0,
				itemId:'iconVirtualTopologySeparator',
			},{
				iconCls:'iconDesktop',
				itemId:'iconDesktop',
				
				action:'layerTool',
				listeners:{
						afterrender: function(){
							Ext.create('Ext.tip.ToolTip',{
								target: this.id,
								anchor: 'top',
								cls: 'yellowTip',
								trackMouse: true,
								html: 'Desktop'
							});
						}
					}
				}		
			]
		},{
			xtype : 'button',
			margin:'4 4 0 4',
			iconCls:'iconBack',
			text : requestParams.backText,
			action : 'back',
			cls:'backbutton'
		}]);
		this.callParent();
	},

	setLayerToolbar:function(data,componentToolTip,componentState){
		this.down('button[itemId=compoentDetails]').setTooltip(componentToolTip);
		this.down('button[itemId=compoentDetails]').setIconCls(componentState);

		if(!requestParams.configChangeIcon == true || requestParams.configChangeIcon == 'true'){
			//this.down('button[itemId=iconConfigUser]').link = requestParams.configChangeLink;
			var isFromMonitor = true;
			var configurl = requestParams.configChangeLink;
			var compName = "";
			if(requestParams.configChangeLink != null && requestParams.configChangeLink != "")
			{
				var params = configurl.substring(configurl.indexOf("?")+1,configurl.length);
				var paramsArray = params.split("&");
				for(var i=0;i<paramsArray.length;i++)
				{
					var temp_param = paramsArray[i];
					if(temp_param.indexOf("componentName") > -1)
					{
						compName = temp_param.substring(temp_param.indexOf("=")+1);
					}
				}
			}
			var url = "/final/servlet/com.eg.EcConfigurationServletNew?ec_rtype=ChangeNew&ec_option1=Component Name&ec_timeline=1+day&ec_prevtimeline=1+day&ec_option2="+compName+"&ec_changetype=Latest&ec_viewchange=byInformation&fromPage=configChange&ec_criteria=Component&fromMonitor="+isFromMonitor;
			this.down('button[itemId=iconConfigUser]').setHandler(function(handler, scope) {
				try
				{
					xaxis = Ext.getBody().getViewSize().width-950;
				}
				catch (ee)
				{
					xaxis = 415;
				}
				if (!Ext.getCmp("configContainer"))
				{
					var xaxis = 415;
					if(!Ext.isEmpty(Ext.getCmp('ComponentTabPanelId')) && Ext.getCmp('ComponentTabPanelId')!=undefined)
						xaxis = Ext.getCmp('ComponentTabPanelId').getWidth()-935;

					Ext.create('Ext.container.Container',{
						padding:0,
						floating:true,
						frame:false,
						width:900,
						hidden:true,
						height:357,
						x:xaxis,
						y:25,
						shadow:true,
						floatable:true,
						id:'configContainer',
						cls:'configPopupWindow',
						items:[
							{
								xtype:'container',
								cls:'configPopupArrow',
								style:{'top':"-6px",'left':"854px"}
							},
							{
								xtype:'container',
								cls:'configPopfont',
								padding:0,
								html:'<table cellspacing="0" cellpadding="0" border="0"><tr><td style="width:100%"><div style="float:left;margin:0px 0px 0px 4px;border-bottom:none;padding:0px 0px 3px 0px" class="configPopfont">CONFIGURATION CHANGES FOR '+compName.substring(0,compName.indexOf(":"))+' DURING LAST 24 hrs</div></td><td style="color:#01a6f6;font-weight:bold;width:92px;display:block"><div style="float:left;margin-top:0px"><a href="'+configurl+'" class="configLink">More details</a></div><div class="configSeparator" style="margin-right:5px;margin-top:0px;"></div></td><td><div style="text-align:right;width:25px"><div class="iconClose3" style="margin-top:-4px"></div></div></td></tr></table>',
								style:{'top':'0px','margin':'2px'}
							},
							{
								xtype:'panel',
								id:'configDataPanel',
								height:320,
								cls:'configPopupWindow_inner',
								html:'<iframe width="900" height=315" border="0" scrolling="yes" marginwidth="0px" marginheight="0px" frameborder="0"  src="'+url+'"> </iframe>'
							
							}
							
						]
					}).show();

					Ext.select('.iconClose3').on('click',function(){
			
							Ext.getCmp("configContainer").hide();
							Ext.getCmp("configContainer").removeAll();
							Ext.getCmp("configContainer").destroy();
							//Ext.get("configDetails").destroy();
					},this);

					Ext.EventManager.onWindowResize(function()
					 {
						try
						{
							Ext.getCmp("configContainer").setPosition(Ext.getBody().getViewSize().width-950,25);
						}
						catch (eee)
						{
						
						}
					 });

				}
			});
			this.down('button[itemId=iconConfigUser]').show();
		}
		else{
			this.down('button[itemId=iconConfigUser]').hide();
		}

		if(!Ext.isEmpty(data) && data.length > 0){
			for(i=0;i<data.length;i++){
				switch(data[i].icon){
					case 'SERVICES':{
						this.down('button[itemId=iconService]').link = data[i].href;
						this.down('button[itemId=iconService]').show();
						this.down('tbseparator[itemId=iconServiceSeparator]').show();
						break;
					}
					case 'TOPOLOGY':{
						data[i].href = data[i].href+'&LayerModelTopology=yes';
						this.down('button[itemId=iconTopology]').link = data[i].href;
						this.down('button[itemId=iconTopology]').show();
						this.down('tbseparator[itemId=iconTopologySeparator]').show();
						break;
					}
					case 'EMULATED_TRANSACTIONS':{
						this.down('button[itemId=iconEmuTransactions]').link = data[i].href;
						this.down('button[itemId=iconEmuTransactions]').show();
						this.down('tbseparator[itemId=iconEmuTransactionsSeparator]').show();
						break;
					}
					case 'TRANSACTIONS':{
						this.down('button[itemId=iconTransactions]').link = data[i].href;
						this.down('button[itemId=iconTransactions]').show();
						this.down('tbseparator[itemId=iconTransactionsSeparator]').show();
						break;
					}
					case 'VIRTUAL TOPOLOGY':{
						this.down('button[itemId=iconVirtualTopology]').setIconCls('iconVirtualTopology_'+data[i].hostState);
						this.down('button[itemId=iconVirtualTopology]').link = data[i].href;
						this.down('button[itemId=iconVirtualTopology]').show();
						this.down('tbseparator[itemId=iconVirtualTopologySeparator]').show();
						break;
					}
					case 'SERVERS':{
						this.down('button[itemId=iconComponent]').link = data[i].href;
						this.down('button[itemId=iconComponent]').show();
						this.down('tbseparator[itemId=iconComponentSeparator]').show();
						break;
					}
					case 'DESKTOPS':{
						this.down('button[itemId=iconDesktop]').link = data[i].href;
						this.down('button[itemId=iconDesktop]').show();
						break;
					}
				}
			}
			this.down('tbseparator[itemId=iconButtonSeparator]').show();
		}
		else
			this.down('tbseparator[itemId=iconButtonSeparator]').hide();
	}
});
}
else if(requiresBasic && requiresWithVirtual)
{
Ext.define('componentDashboard.view.ComponentTabPanel', {
	extend: 'Ext.tab.Panel',
	//requires : ['componentDashboard.view.CompDashSystemTab','componentDashboard.view.CompDashNetworkTab','componentDashboard.view.CompDashLayersTab','componentDashboard.view.CompDashCustomTab','componentDashboard.view.CompDashVirtualTab','componentDashboard.view.Application.ApplicationPanel','componentDashboard.view.Interfaces.InterfaceTab','componentDashboard.view.network.NetworkMainPanel','componentDashboard.view.system.CompDashDetailsTab'],
	//requires : ['componentDashboard.view.CompDashLayersTab','componentDashboard.view.system.CompDashDetailsTab','componentDashboard.view.Application.ThreadDetails','componentDashboard.view.network.NetworkMainPanel','componentDashboard.view.Application.ApplicationPanel','componentDashboard.view.CompDashVirtualTab','componentDashboard.view.Interfaces.InterfaceTab','componentDashboard.view.CompDashCustomTab'],
	requires : ['componentDashboard.view.CompDashLayersTab','componentDashboard.view.system.CompDashDetailsTab','componentDashboard.view.Application.ThreadDetails','componentDashboard.view.network.NetworkMainPanel','componentDashboard.view.CompDashVirtualTab','componentDashboard.view.netflow.NetflowMainPanel'],
	//requires : ['componentDashboard.view.CompDashSystemTab','componentDashboard.view.CompDashNetworkTab','componentDashboard.view.CompDashLayersTab','componentDashboard.view.CompDashVirtualTab','componentDashboard.view.network.NetworkMainPanel','componentDashboard.view.system.CompDashDetailsTab','componentDashboard.view.Application.ThreadDetails'],
	alias:'widget.componenttabpanel',
	tabsInfo:null,
	//ui:'newTabPanelBasic ',/*vijay:don't change this style *//*Reverted as it is causing problems*/
	cls:'tablayout',
	//bodyCls:'tablayoutBodyColor',
	bodyCls:'tablayoutBodyColor',
	initComponent : function() {
		var mask = null;
		var wholeViewport = document.getElementsByTagName("body")[0];
		if(!Ext.isEmpty(Ext.get(wholeViewport))){
			mask = new Ext.LoadMask(Ext.get(wholeViewport), {msg:"Loading...",cls:'maskDash'});
			mask.show();
		}
	
	 var itemsArray=new Array();
	 if(!Ext.isEmpty(this.tabsInfo)){
		 for(var i=0;i<this.tabsInfo.length;i++){
			 var type=this.tabsInfo[i].type;
			 var cmpXtype=this.getTabXtype(this.tabsInfo[i].type);
			 if ( cmpXtype == 'applicationpanel' )
			 {
				 //this.tabsInfo[i].name = 'Application';
				 this.tabsInfo[i].index = '3';
			 }
			 else if ( cmpXtype == 'networkmainpanel' )
			 {
				//this.tabsInfo[i].name = 'Network';
				 this.tabsInfo[i].index = '2';
			 }
			 else if ( cmpXtype == 'netflowmainpanel' )
			 {
				 this.tabsInfo[i].index = '1';
			 }
			 else if ( cmpXtype == 'compdashdetailsMaintab' )
			 {
				// this.tabsInfo[i].name = 'System';
				 this.tabsInfo[i].index = '1';
			 }
			 else if ( cmpXtype == 'interfacepanel' )
			 {
				 //this.tabsInfo[i].name = 'Interfaces';
				 this.tabsInfo[i].index = '4';
			 }
			 else if ( cmpXtype == 'custom' )
			 {
				//this.tabsInfo[i].name = 'Network';
				 this.tabsInfo[i].index = '5';
			 }

			 itemsArray.push({
				 xtype:cmpXtype,
				 title:this.tabsInfo[i].name,
				 itemId:type.toLowerCase(),
				 tabIndex:this.tabsInfo[i].index,
				 mask:mask
			 });
		 }
	 }
	
	this.items=itemsArray;
	this.callParent();
	},
	
	getTabXtype:function(type){
		switch(type.toLowerCase()){
			case 'system': cmpXtype='compdashdetailsMaintab';
							break;
			case 'network': cmpXtype='networkmainpanel';
							break;
			case 'layers': cmpXtype='compdashlayerstab';
							break;
			case 'custom': cmpXtype='compdashcustomtab';
							break;
			case 'virtual': cmpXtype='compdashvirtualtab';
							break;
			case 'application': cmpXtype='applicationpanel';
							break;
			case 'interfaces': cmpXtype='interfacepanel';
							break;
			case 'netflow': cmpXtype='netflowmainpanel';
							break;
		}
		return cmpXtype;
	},

	onRender : function(){
		this.getTabBar().add([{
			xtype : 'tbfill',
			hidden : hideAddCustomDashboardIcon
		},{
			xtype:'container',
			border:true,
			hidden : hideAddCustomDashboardIcon,
			cls:'iconIstamDashboardAdd',
			width:22,
			height:10,
			padding:0,
			margin:'4px 0px 0px 0px',
			items:{
				xtype : 'button',
				//cls:'overflowBt',
				hidden:false,
				width:22,
				height:19,
				style:{background:'none',border:'0px'},
				itemId:'istamDashboardCreate',
				handler : function()
				{
					document.location="/final/monitor/egDashboardProfile.jsp?compType="+hostTypeEncoded+"&hostName="+hostNameEncoded;
				}
			}
		},{
			xtype : 'tbfill'
		},{
			xtype:'combo',
			cls:'dropdown',
			hidden:true,
			itemId:'componentTypeCombo',
			id: 'componentTypeCombo',
			width:265,
			editable:false,
			labelWidth:35,
			labelStyle:'padding:2px 0px 0px;text-align:right',
			fieldLabel:'Type',
			labelAlign:'left',
			 labelSeparator: '' ,
			displayField:'text',
			valueField:'value',
			queryMode:'local',
			store:Ext.create('Ext.data.Store',{
				fields:['value','text']
			}),
			margin:'3 0 0 10'
		},{
			xtype:'combo',
			cls:'dropdown',
			hidden:true,
			labelStyle:'padding:2px 0px 0px;text-align:right',
			itemId:'componentNameCombo',
			id: 'componentNameCombo',
			style:{background:'none',border:'2px'},
			width:265,
			labelWidth:35,
			 labelSeparator: '' ,
			fieldLabel:'Name',
			editable:false,
			labelAlign:'left',
			displayField:'text',
			valueField:'value',
			queryMode:'local',
			store:Ext.create('Ext.data.Store',{
				fields:['state',{name:'text',convert:function(value, record){
					return decodeURI(value);
				}},'value']
			}),
			margin:'3 0 0 10',
			tpl: Ext.create('Ext.XTemplate',
				'<ul>',
				'<tpl for=".">',
					'<li class="x-boundlist-item"><img src="/final/images/spacer.gif" style="padding-left:18px;vertical-align:middle" class="state_{state}"/>{text}</li>',
				'</tpl>',
				'</ul>'
			)
		},{
			xtype:'scrollcombo',
			cls:'dropdown',
			hidden:true,
			itemId:'componentsDropDown',
			labelStyle:'padding:2px 0px 0px;text-align:right',
			id: 'componentsDropDown',
			style:{background:'none',border:'0px'},
			width:310,
			labelWidth:70,
			editable:true,
			 labelSeparator: '' ,
			fieldLabel:'Component',
			labelAlign:'left',
			displayField:'text',
			valueField:'value',
			
			queryMode:'local',
			store:Ext.create('Ext.data.Store',{
				fields:['state',{name:'text',convert:function(value, record){
					return decodeURI(value);
				}},'value']
			}),
			margin:'2 10 0 10',
			tpl: Ext.create('Ext.XTemplate',
				//'<ul style="display:inline-block;white-space:nowrap">',
				'<ul style="white-space:nowrap">',
				'<tpl for=".">',
					'<tpl if="state">',
						'<li class="x-boundlist-item"><img src="/final/images/spacer.gif" style="padding-left:18px;vertical-align:middle" class="state_{state}"/>{text}</li>',
					'<tpl else>',
						'<li class="x-boundlist-item"><img src="/final/images/spacer.gif" style="vertical-align:middle" class="state_{state}"/>{text}</li>',
				'</tpl>',
				'</tpl>',
				'</ul>'
			)
		},{
			xtype : 'button',
			iconCls:'iconComponent_GRAY',
			cls:'overflowBt',
			hidden:true,
			style:{background:'none',border:'0px'},
			itemId:'compoentDetails'
		},/*{
			xtype : 'tbfill'

		},*/{
				xtype: 'tbseparator',
				itemId:'iconButtonSeparator',
				margin:'6 0 0 10',
				padding:0
			},{
			xtype: 'toolbar',
			defaults:{
				xtype: 'button',
				hidden:true,
				margin:'5 0 0 0',
				padding:'0 5 0 5',
				style: {
					background: 'none',
					border: '0px'
				}
			},
			items:[{ 
				iconCls: 'iconSettings',
				itemId:'iconSettings',
				
				listeners:{
					afterrender:function(){
						Ext.create('Ext.tip.ToolTip',{
							target: this.id,
							anchor: 'top',
							cls: 'yellowTip',
							trackMouse: true,
							html: 'Settings'
						});
					}
				}
			},{
				xtype: 'tbseparator',
				itemId:'iconSettingsSeparator',
				padding:0
			},{
				iconCls:'iconService',
				itemId:'iconService',
				
				action:'layerTool',
				listeners:{
					afterrender: function(){
						Ext.create('Ext.tip.ToolTip',{
							target: this.id,
							anchor: 'top',
							cls: 'yellowTip',
							trackMouse: true,
							html: 'Service'
						});
					}
				}
			},{
				xtype: 'tbseparator',
				padding:0,
				itemId:'iconServiceSeparator',
				
			},{
				iconCls:'iconTransactions',
				itemId:'iconTransactions',
				
				action:'layerTool',
				listeners:{
					afterrender: function(){
						Ext.create('Ext.tip.ToolTip',{
							target: this.id,
							anchor: 'top',
							cls: 'yellowTip',
							trackMouse: true,
							html: 'Transactions'
						});
					}
				}
			},{
				xtype: 'tbseparator',
				padding:0,
				itemId:'iconTransactionsSeparator',
				
			},{
				iconCls:'iconTransactions',
				itemId:'iconEmuTransactions',
				
				action:'layerTool',
				listeners:{
					afterrender: function(){
						Ext.create('Ext.tip.ToolTip',{
							target: this.id,
							anchor: 'top',
							cls: 'yellowTip',
							trackMouse: true,
							html: simulatedTransactionFlow
						});
					}
				}
			},{
				xtype: 'tbseparator',
				padding:0,
				itemId:'iconEmuTransactionsSeparator',
				
			},{
				iconCls:'iconConfigUser',
				itemId:'iconConfigUser',
				//action:'layerTool',
				listeners:{
					afterrender: function(){
						Ext.create('Ext.tip.ToolTip',{
							target: this.id,
							anchor: 'top',
							cls: 'yellowTip',
							trackMouse: true,
							html: 'Config'
						});
					}
				}
			},{
				xtype: 'tbseparator',
				padding:0,
				itemId:'iconConfigUserSeparator',
			
			},{
				iconCls:'iconComponent',
				itemId:'iconComponent',
				action:'layerTool',
				
				listeners:{
					afterrender: function(){
						Ext.create('Ext.tip.ToolTip',{
							target: this.id,
							anchor: 'top',
							cls: 'yellowTip',
							trackMouse: true,
							html: 'Server'
						});
					}
				}
			},{
				xtype: 'tbseparator',
				padding:0,
				itemId:'iconComponentSeparator',
			},{
				iconCls:'iconTopology',
				itemId:'iconTopology',
				
				action:'layerTool',
				listeners:{
					afterrender: function(){
						Ext.create('Ext.tip.ToolTip',{
							target: this.id,
							anchor: 'top',
							cls: 'yellowTip',
							trackMouse: true,
							html: 'Topology'
						});
					}
				}
			},{
				xtype: 'tbseparator',
				padding:0,
				itemId:'iconTopologySeparator',
			},{
				iconCls:'iconVirtualTopology',
				itemId:'iconVirtualTopology',
				action:'layerTool',
				
				listeners:{
					afterrender: function(){
						Ext.create('Ext.tip.ToolTip',{
							target: this.id,
							anchor: 'top',
							cls: 'yellowTip',
							trackMouse: true,
							html: 'Virtual Topology'
						});
					}
				}
			},{
				xtype: 'tbseparator',
				padding:0,
				itemId:'iconVirtualTopologySeparator',
			},{
				iconCls:'iconDesktop',
				itemId:'iconDesktop',
				
				action:'layerTool',
				listeners:{
						afterrender: function(){
							Ext.create('Ext.tip.ToolTip',{
								target: this.id,
								anchor: 'top',
								cls: 'yellowTip',
								trackMouse: true,
								html: 'Desktop'
							});
						}
					}
				}		
			]
		},{
			xtype : 'button',
			margin:'4 4 0 4',
			iconCls:'iconBack',
			text : requestParams.backText,
			action : 'back',
			cls:'backbutton'
		}]);
		this.callParent();
	},

	setLayerToolbar:function(data,componentToolTip,componentState){
		this.down('button[itemId=compoentDetails]').setTooltip(componentToolTip);
		this.down('button[itemId=compoentDetails]').setIconCls(componentState);

		if(!requestParams.configChangeIcon == true || requestParams.configChangeIcon == 'true'){
			//this.down('button[itemId=iconConfigUser]').link = requestParams.configChangeLink;
			var isFromMonitor = true;
			var configurl = requestParams.configChangeLink;
			var compName = "";
			if(requestParams.configChangeLink != null && requestParams.configChangeLink != "")
			{
				var params = configurl.substring(configurl.indexOf("?")+1,configurl.length);
				var paramsArray = params.split("&");
				for(var i=0;i<paramsArray.length;i++)
				{
					var temp_param = paramsArray[i];
					if(temp_param.indexOf("componentName") > -1)
					{
						compName = temp_param.substring(temp_param.indexOf("=")+1);
					}
				}
			}
			var url = "/final/servlet/com.eg.EcConfigurationServletNew?ec_rtype=ChangeNew&ec_option1=Component Name&ec_timeline=1+day&ec_prevtimeline=1+day&ec_option2="+compName+"&ec_changetype=Latest&ec_viewchange=byInformation&fromPage=configChange&ec_criteria=Component&fromMonitor="+isFromMonitor;
			this.down('button[itemId=iconConfigUser]').setHandler(function(handler, scope) {
				try
				{
					xaxis = Ext.getBody().getViewSize().width-950;
				}
				catch (ee)
				{
					xaxis = 415;
				}
				if (!Ext.getCmp("configContainer"))
				{
			
					Ext.create('Ext.container.Container',{
						padding:0,
						floating:true,
						frame:false,
						width:900,
						hidden:true,
						height:357,
						x:415,
						y:25,
						shadow:true,
						floatable:true,
						id:'configContainer',
						cls:'configPopupWindow',
						items:[
							{
								xtype:'container',
								cls:'configPopupArrow',
								style:{'top':"-6px",'left':"854px"}
							},
							{
								xtype:'container',
								cls:'configPopfont',
								padding:0,
								html:'<table cellspacing="0" cellpadding="0" border="0"><tr><td style="width:100%"><div style="float:left;margin:0px 0px 0px 4px;border-bottom:none;padding:0px 0px 3px 0px" class="configPopfont">CONFIGURATION DETAILS FOR '+compName.substring(0,compName.indexOf(":"))+' DURING LAST 24 hrs</div></td><td style="color:#01a6f6;font-weight:bold;width:92px;display:block"><div style="float:left;margin-top:0px"><a href="'+configurl+'" class="configLink">More details</a></div><div class="configSeparator" style="margin-right:5px;margin-top:0px;"></div></td><td><div style="text-align:right;width:25px"><div class="iconClose3" style="margin-top:-4px"></div></div></td></tr></table>',
								style:{'top':'0px','margin':'2px'}
							},
							{
								xtype:'panel',
								id:'configDataPanel',
								height:320,
								cls:'configPopupWindow_inner',
								html:'<iframe width="900" height=315" border="0" scrolling="yes" marginwidth="0px" marginheight="0px" frameborder="0"  src="'+url+'"> </iframe>'
							
							}
							
						]
					}).show();

					Ext.select('.iconClose3').on('click',function(){
			
							Ext.getCmp("configContainer").hide();
							Ext.getCmp("configContainer").removeAll();
							Ext.getCmp("configContainer").destroy();
							//Ext.get("configDetails").destroy();
					},this);
					Ext.EventManager.onWindowResize(function()
					 {
						try
						{
							Ext.getCmp("configContainer").setPosition(Ext.getBody().getViewSize().width-950,25);
						}
						catch (eee)
						{
						
						}
					 });

				}
			});
			this.down('button[itemId=iconConfigUser]').show();
		}
		else{
			this.down('button[itemId=iconConfigUser]').hide();
		}

		if(!Ext.isEmpty(data) && data.length > 0){
			for(i=0;i<data.length;i++){
				switch(data[i].icon){
					case 'SERVICES':{
						this.down('button[itemId=iconService]').link = data[i].href;
						this.down('button[itemId=iconService]').show();
						this.down('tbseparator[itemId=iconServiceSeparator]').show();
						break;
					}
					case 'TOPOLOGY':{
						data[i].href = data[i].href+'&LayerModelTopology=yes';
						this.down('button[itemId=iconTopology]').link = data[i].href;
						this.down('button[itemId=iconTopology]').show();
						this.down('tbseparator[itemId=iconTopologySeparator]').show();
						break;
					}
					case 'EMULATED_TRANSACTIONS':{
						this.down('button[itemId=iconEmuTransactions]').link = data[i].href;
						this.down('button[itemId=iconEmuTransactions]').show();
						this.down('tbseparator[itemId=iconEmuTransactionsSeparator]').show();
						break;
					}
					case 'TRANSACTIONS':{
						this.down('button[itemId=iconTransactions]').link = data[i].href;
						this.down('button[itemId=iconTransactions]').show();
						this.down('tbseparator[itemId=iconTransactionsSeparator]').show();
						break;
					}
					case 'VIRTUAL TOPOLOGY':{
						this.down('button[itemId=iconVirtualTopology]').setIconCls('iconVirtualTopology_'+data[i].hostState);
						this.down('button[itemId=iconVirtualTopology]').link = data[i].href;
						this.down('button[itemId=iconVirtualTopology]').show();
						this.down('tbseparator[itemId=iconVirtualTopologySeparator]').show();
						break;
					}
					case 'SERVERS':{
						this.down('button[itemId=iconComponent]').link = data[i].href;
						this.down('button[itemId=iconComponent]').show();
						this.down('tbseparator[itemId=iconComponentSeparator]').show();
						break;
					}
					case 'DESKTOPS':{
						this.down('button[itemId=iconDesktop]').link = data[i].href;
						this.down('button[itemId=iconDesktop]').show();
						break;
					}
				}
			}
			this.down('tbseparator[itemId=iconButtonSeparator]').show();
		}
		else
			this.down('tbseparator[itemId=iconButtonSeparator]').hide();
	}
});
}
else if((!requiresBasic) && requiresWithApplication)
{
Ext.define('componentDashboard.view.ComponentTabPanel', {
	extend: 'Ext.tab.Panel',
	//requires : ['componentDashboard.view.CompDashSystemTab','componentDashboard.view.CompDashNetworkTab','componentDashboard.view.CompDashLayersTab','componentDashboard.view.CompDashCustomTab','componentDashboard.view.CompDashVirtualTab','componentDashboard.view.Application.ApplicationPanel','componentDashboard.view.Interfaces.InterfaceTab','componentDashboard.view.network.NetworkMainPanel','componentDashboard.view.system.CompDashDetailsTab'],
	requires : ['componentDashboard.view.CompDashLayersTab','componentDashboard.view.system.CompDashDetailsTab','componentDashboard.view.Application.ThreadDetails','componentDashboard.view.network.NetworkMainPanel','componentDashboard.view.Application.ApplicationPanel','componentDashboard.view.netflow.NetflowMainPanel'],
	alias:'widget.componenttabpanel',
	tabsInfo:null,
	cls:'tablayout',
	bodyCls:'tablayoutBodyColor',
	initComponent : function() {
		var mask = null;
		var wholeViewport = document.getElementsByTagName("body")[0];
		if(!Ext.isEmpty(Ext.get(wholeViewport))){
			mask = new Ext.LoadMask(Ext.get(wholeViewport), {msg:"Loading...",cls:'maskDash'});
			mask.show();
		}
	
	 var itemsArray=new Array();
	 if(!Ext.isEmpty(this.tabsInfo)){
		 for(var i=0;i<this.tabsInfo.length;i++){
			 var type=this.tabsInfo[i].type;
			 var cmpXtype=this.getTabXtype(this.tabsInfo[i].type);
			 if ( cmpXtype == 'applicationpanel' )
			 {
				 //this.tabsInfo[i].name = 'Application';
				 this.tabsInfo[i].index = '3';
			 }
			 else if ( cmpXtype == 'networkmainpanel' )
			 {
				//this.tabsInfo[i].name = 'Network';
				 this.tabsInfo[i].index = '2';
			 }
			 else if ( cmpXtype == 'netflowmainpanel' )
			 {
				 this.tabsInfo[i].index = '1';
			 }
			 else if ( cmpXtype == 'compdashdetailsMaintab' )
			 {
				// this.tabsInfo[i].name = 'System';
				 this.tabsInfo[i].index = '1';
			 }
			 else if ( cmpXtype == 'interfacepanel' )
			 {
				 //this.tabsInfo[i].name = 'Interfaces';
				 this.tabsInfo[i].index = '4';
			 }
			 else if ( cmpXtype == 'custom' )
			 {
				//this.tabsInfo[i].name = 'Network';
				 this.tabsInfo[i].index = '5';
			 }

			 itemsArray.push({
				 xtype:cmpXtype,
				 title:this.tabsInfo[i].name,
				 itemId:type.toLowerCase(),
				 tabIndex:this.tabsInfo[i].index,
				 mask:mask
			 });
		 }
	 }
	
	this.items=itemsArray;
	this.callParent();
	},
	
	getTabXtype:function(type){
		switch(type.toLowerCase()){
			case 'system': cmpXtype='compdashdetailsMaintab';
							break;
			case 'network': cmpXtype='networkmainpanel';
							break;
			case 'layers': cmpXtype='compdashlayerstab';
							break;
			case 'custom': cmpXtype='compdashcustomtab';
							break;
			case 'virtual': cmpXtype='compdashvirtualtab';
							break;
			case 'application': cmpXtype='applicationpanel';
							break;
			case 'interfaces': cmpXtype='interfacepanel';
							break;
			case 'netflow': cmpXtype='netflowmainpanel';
							break;
		}
		return cmpXtype;
	},

	onRender : function(){
		this.getTabBar().add([{
			xtype : 'tbfill',
			hidden : hideAddCustomDashboardIcon
		},{
			xtype:'container',
			border:true,
			hidden : hideAddCustomDashboardIcon,
			cls:'iconIstamDashboardAdd',
			width:22,
			height:10,
			padding:0,
			margin:'4px 0px 0px 0px',
			items:{
				xtype : 'button',
				//cls:'overflowBt',
				hidden:false,
				width:22,
				height:19,
				style:{background:'none',border:'0px'},
				itemId:'istamDashboardCreate',
				handler : function()
				{
					document.location="/final/monitor/egDashboardProfile.jsp?compType="+hostTypeEncoded+"&hostName="+hostNameEncoded;
				}
			}
		},{
			xtype : 'tbfill'
		},{
			xtype:'combo',
			cls:'dropdown',
			hidden:true,
			itemId:'componentTypeCombo',
			id: 'componentTypeCombo',
			width:265,
			editable:false,
			labelWidth:35,
			labelStyle:'padding:2px 0px 0px;text-align:right',
			fieldLabel:'Type',
			labelAlign:'left',
			 labelSeparator: '' ,
			displayField:'text',
			valueField:'value',
			queryMode:'local',
			store:Ext.create('Ext.data.Store',{
				fields:['value','text']
			}),
			margin:'3 0 0 10'
		},{
			xtype:'combo',
			cls:'dropdown',
			hidden:true,
			labelStyle:'padding:2px 0px 0px;text-align:right',
			itemId:'componentNameCombo',
			id: 'componentNameCombo',
			style:{background:'none',border:'2px'},
			width:265,
			labelWidth:35,
			 labelSeparator: '' ,
			fieldLabel:'Name',
			editable:false,
			labelAlign:'left',
			displayField:'text',
			valueField:'value',
			queryMode:'local',
			store:Ext.create('Ext.data.Store',{
				fields:['state',{name:'text',convert:function(value, record){
					return decodeURI(value);
				}},'value']
			}),
			margin:'3 0 0 10',
			tpl: Ext.create('Ext.XTemplate',
				'<ul>',
				'<tpl for=".">',
					'<li class="x-boundlist-item"><img src="/final/images/spacer.gif" style="padding-left:18px;vertical-align:middle" class="state_{state}"/>{text}</li>',
				'</tpl>',
				'</ul>'
			)
		},{
			xtype:'scrollcombo',
			cls:'dropdown',
			hidden:true,
			itemId:'componentsDropDown',
			labelStyle:'padding:2px 0px 0px;text-align:right',
			id: 'componentsDropDown',
			style:{background:'none',border:'0px'},
			width:310,
			labelWidth:70,
			editable:true,
			 labelSeparator: '' ,
			fieldLabel:'Component',
			labelAlign:'left',
			displayField:'text',
			valueField:'value',
			
			queryMode:'local',
			store:Ext.create('Ext.data.Store',{
				fields:['state',{name:'text',convert:function(value, record){
					return decodeURI(value);
				}},'value']
			}),
			margin:'2 10 0 10',
			tpl: Ext.create('Ext.XTemplate',
				//'<ul style="display:inline-block;white-space:nowrap">',
				'<ul style="white-space:nowrap">',
				'<tpl for=".">',
					'<li class="x-boundlist-item"><img src="/final/images/spacer.gif" style="padding-left:18px;vertical-align:middle" class="state_{state}"/>{text}</li>',
				'</tpl>',
				'</ul>'
			)
		},{
			xtype : 'button',
			iconCls:'iconComponent_GRAY',
			cls:'overflowBt',
			hidden:true,
			style:{background:'none',border:'0px'},
			itemId:'compoentDetails'
		},/*{
			xtype : 'tbfill'

		},*/{
				xtype: 'tbseparator',
				itemId:'iconButtonSeparator',
				margin:'6 0 0 10',
				padding:0
			},{
			xtype: 'toolbar',
			defaults:{
				xtype: 'button',
				hidden:true,
				margin:'5 0 0 0',
				padding:'0 5 0 5',
				style: {
					background: 'none',
					border: '0px'
				}
			},
			items:[{ 
				iconCls: 'iconSettings',
				itemId:'iconSettings',
				
				listeners:{
					afterrender:function(){
						Ext.create('Ext.tip.ToolTip',{
							target: this.id,
							anchor: 'top',
							cls: 'yellowTip',
							trackMouse: true,
							html: 'Settings'
						});
					}
				}
			},{
				xtype: 'tbseparator',
				itemId:'iconSettingsSeparator',
				padding:0
			},{
				iconCls:'iconService',
				itemId:'iconService',
				
				action:'layerTool',
				listeners:{
					afterrender: function(){
						Ext.create('Ext.tip.ToolTip',{
							target: this.id,
							anchor: 'top',
							cls: 'yellowTip',
							trackMouse: true,
							html: 'Service'
						});
					}
				}
			},{
				xtype: 'tbseparator',
				padding:0,
				itemId:'iconServiceSeparator',
				
			},{
				iconCls:'iconTransactions',
				itemId:'iconTransactions',
				
				action:'layerTool',
				listeners:{
					afterrender: function(){
						Ext.create('Ext.tip.ToolTip',{
							target: this.id,
							anchor: 'top',
							cls: 'yellowTip',
							trackMouse: true,
							html: 'Transactions'
						});
					}
				}
			},{
				xtype: 'tbseparator',
				padding:0,
				itemId:'iconTransactionsSeparator',
				
			},{
				iconCls:'iconTransactions',
				itemId:'iconEmuTransactions',
				
				action:'layerTool',
				listeners:{
					afterrender: function(){
						Ext.create('Ext.tip.ToolTip',{
							target: this.id,
							anchor: 'top',
							cls: 'yellowTip',
							trackMouse: true,
							html: simulatedTransactionFlow
						});
					}
				}
			},{
				xtype: 'tbseparator',
				padding:0,
				itemId:'iconEmuTransactionsSeparator',
				
			},{
				iconCls:'iconConfigUser',
				itemId:'iconConfigUser',
				//action:'layerTool',
				listeners:{
					afterrender: function(){
						Ext.create('Ext.tip.ToolTip',{
							target: this.id,
							anchor: 'top',
							cls: 'yellowTip',
							trackMouse: true,
							html: 'Config'
						});
					}
				}
			},{
				xtype: 'tbseparator',
				padding:0,
				itemId:'iconConfigUserSeparator',
			
			},{
				iconCls:'iconComponent',
				itemId:'iconComponent',
				action:'layerTool',
				
				listeners:{
					afterrender: function(){
						Ext.create('Ext.tip.ToolTip',{
							target: this.id,
							anchor: 'top',
							cls: 'yellowTip',
							trackMouse: true,
							html: 'Server'
						});
					}
				}
			},{
				xtype: 'tbseparator',
				padding:0,
				itemId:'iconComponentSeparator',
			},{
				iconCls:'iconTopology',
				itemId:'iconTopology',
				
				action:'layerTool',
				listeners:{
					afterrender: function(){
						Ext.create('Ext.tip.ToolTip',{
							target: this.id,
							anchor: 'top',
							cls: 'yellowTip',
							trackMouse: true,
							html: 'Topology'
						});
					}
				}
			},{
				xtype: 'tbseparator',
				padding:0,
				itemId:'iconTopologySeparator',
			},{
				iconCls:'iconVirtualTopology',
				itemId:'iconVirtualTopology',
				action:'layerTool',
				
				listeners:{
					afterrender: function(){
						Ext.create('Ext.tip.ToolTip',{
							target: this.id,
							anchor: 'top',
							cls: 'yellowTip',
							trackMouse: true,
							html: 'Virtual Topology'
						});
					}
				}
			},{
				xtype: 'tbseparator',
				padding:0,
				itemId:'iconVirtualTopologySeparator',
			},{
				iconCls:'iconDesktop',
				itemId:'iconDesktop',
				
				action:'layerTool',
				listeners:{
						afterrender: function(){
							Ext.create('Ext.tip.ToolTip',{
								target: this.id,
								anchor: 'top',
								cls: 'yellowTip',
								trackMouse: true,
								html: 'Desktop'
							});
						}
					}
				}		
			]
		},{
			xtype : 'button',
			margin:'4 4 0 4',
			iconCls:'iconBack',
			text : requestParams.backText,
			action : 'back',
			cls:'backbutton'
		}]);
		this.callParent();
	},

	setLayerToolbar:function(data,componentToolTip,componentState){
		this.down('button[itemId=compoentDetails]').setTooltip(componentToolTip);
		this.down('button[itemId=compoentDetails]').setIconCls(componentState);

		if(!requestParams.configChangeIcon == true || requestParams.configChangeIcon == 'true'){
			//this.down('button[itemId=iconConfigUser]').link = requestParams.configChangeLink;
			var isFromMonitor = true;
			var configurl = requestParams.configChangeLink;
			var compName = "";
			if(requestParams.configChangeLink != null && requestParams.configChangeLink != "")
			{
				var params = configurl.substring(configurl.indexOf("?")+1,configurl.length);
				var paramsArray = params.split("&");
				for(var i=0;i<paramsArray.length;i++)
				{
					var temp_param = paramsArray[i];
					if(temp_param.indexOf("componentName") > -1)
					{
						compName = temp_param.substring(temp_param.indexOf("=")+1);
					}
				}
			}
			var url = "/final/servlet/com.eg.EcConfigurationServletNew?ec_rtype=ChangeNew&ec_option1=Component Name&ec_timeline=1+day&ec_prevtimeline=1+day&ec_option2="+compName+"&ec_changetype=Latest&ec_viewchange=byInformation&fromPage=configChange&ec_criteria=Component&fromMonitor="+isFromMonitor;
			this.down('button[itemId=iconConfigUser]').setHandler(function(handler, scope) {
				var xaxis = 415;
				try
				{
					xaxis = Ext.getBody().getViewSize().width-950;
				}
				catch (ee)
				{
					xaxis = 415;
				}

				if (!Ext.getCmp("configContainer"))
				{
			
					Ext.create('Ext.container.Container',{
						padding:0,
						floating:true,
						frame:false,
						width:900,
						hidden:true,
						height:357,
						//x:415,
						x:xaxis,
						y:25,
						shadow:true,
						floatable:true,
						id:'configContainer',
						cls:'configPopupWindow',
						items:[
							{
								xtype:'container',
								cls:'configPopupArrow',
								style:{'top':"-6px",'left':"854px"}
							},
							{
								xtype:'container',
								cls:'configPopfont',
								padding:0,
								html:'<table cellspacing="0" cellpadding="0" border="0"><tr><td style="width:100%"><div style="float:left;margin:0px 0px 0px 4px;border-bottom:none;padding:0px 0px 3px 0px" class="configPopfont">CONFIGURATION DETAILS FOR '+compName.substring(0,compName.indexOf(":"))+' DURING LAST 24 hrs</div></td><td style="color:#01a6f6;font-weight:bold;width:92px;display:block"><div style="float:left;margin-top:0px"><a href="'+configurl+'" class="configLink">More details</a></div><div class="configSeparator" style="margin-right:5px;margin-top:0px;"></div></td><td><div style="text-align:right;width:25px"><div class="iconClose3" style="margin-top:-4px"></div></div></td></tr></table>',
								style:{'top':'0px','margin':'2px'}
							},
							{
								xtype:'panel',
								id:'configDataPanel',
								height:320,
								cls:'configPopupWindow_inner',
								html:'<iframe width="900" height=315" border="0" scrolling="yes" marginwidth="0px" marginheight="0px" frameborder="0"  src="'+url+'"> </iframe>'
							
							}
							
						]
					}).show();

					Ext.select('.iconClose3').on('click',function(){
			
							Ext.getCmp("configContainer").hide();
							Ext.getCmp("configContainer").removeAll();
							Ext.getCmp("configContainer").destroy();
							//Ext.get("configDetails").destroy();
					},this);

					Ext.EventManager.onWindowResize(function()
					 {
						try
						{
							Ext.getCmp("configContainer").setPosition(Ext.getBody().getViewSize().width-950,25);
						}
						catch (eee)
						{
						
						}
					 });

				}
			});
			this.down('button[itemId=iconConfigUser]').show();
		}
		else{
			this.down('button[itemId=iconConfigUser]').hide();
		}

		if(!Ext.isEmpty(data) && data.length > 0){
			for(i=0;i<data.length;i++){
				switch(data[i].icon){
					case 'SERVICES':{
						this.down('button[itemId=iconService]').link = data[i].href;
						this.down('button[itemId=iconService]').show();
						this.down('tbseparator[itemId=iconServiceSeparator]').show();
						break;
					}
					case 'TOPOLOGY':{
						data[i].href = data[i].href+'&LayerModelTopology=yes';
						this.down('button[itemId=iconTopology]').link = data[i].href;
						this.down('button[itemId=iconTopology]').show();
						this.down('tbseparator[itemId=iconTopologySeparator]').show();
						break;
					}
					case 'EMULATED_TRANSACTIONS':{
						this.down('button[itemId=iconEmuTransactions]').link = data[i].href;
						this.down('button[itemId=iconEmuTransactions]').show();
						this.down('tbseparator[itemId=iconEmuTransactionsSeparator]').show();
						break;
					}
					case 'TRANSACTIONS':{
						this.down('button[itemId=iconTransactions]').link = data[i].href;
						this.down('button[itemId=iconTransactions]').show();
						this.down('tbseparator[itemId=iconTransactionsSeparator]').show();
						break;
					}
					case 'VIRTUAL TOPOLOGY':{
						this.down('button[itemId=iconVirtualTopology]').setIconCls('iconVirtualTopology_'+data[i].hostState);
						this.down('button[itemId=iconVirtualTopology]').link = data[i].href;
						this.down('button[itemId=iconVirtualTopology]').show();
						this.down('tbseparator[itemId=iconVirtualTopologySeparator]').show();
						break;
					}
					case 'SERVERS':{
						this.down('button[itemId=iconComponent]').link = data[i].href;
						this.down('button[itemId=iconComponent]').show();
						this.down('tbseparator[itemId=iconComponentSeparator]').show();
						break;
					}
					case 'DESKTOPS':{
						this.down('button[itemId=iconDesktop]').link = data[i].href;
						this.down('button[itemId=iconDesktop]').show();
						break;
					}
				}
			}
			this.down('tbseparator[itemId=iconButtonSeparator]').show();
		}
		else
			this.down('tbseparator[itemId=iconButtonSeparator]').hide();
	}
});
}
else if((!requiresBasic) && requiresWithInterface)
{
Ext.define('componentDashboard.view.ComponentTabPanel', {
	extend: 'Ext.tab.Panel',
	//requires : ['componentDashboard.view.CompDashSystemTab','componentDashboard.view.CompDashNetworkTab','componentDashboard.view.CompDashLayersTab','componentDashboard.view.CompDashCustomTab','componentDashboard.view.CompDashVirtualTab','componentDashboard.view.Application.ApplicationPanel','componentDashboard.view.Interfaces.InterfaceTab','componentDashboard.view.network.NetworkMainPanel','componentDashboard.view.system.CompDashDetailsTab'],
	requires : ['componentDashboard.view.CompDashLayersTab','componentDashboard.view.system.CompDashDetailsTab','componentDashboard.view.Application.ThreadDetails','componentDashboard.view.network.NetworkMainPanel','componentDashboard.view.Interfaces.InterfaceTab','componentDashboard.view.netflow.NetflowMainPanel'],
	alias:'widget.componenttabpanel',
	tabsInfo:null,
	cls:'tablayout',
	bodyCls:'tablayoutBodyColor',
	initComponent : function() {
		var mask = null;
		var wholeViewport = document.getElementsByTagName("body")[0];
		if(!Ext.isEmpty(Ext.get(wholeViewport))){
			mask = new Ext.LoadMask(Ext.get(wholeViewport), {msg:"Loading...",cls:'maskDash'});
			mask.show();
		}
	
	 var itemsArray=new Array();
	 if(!Ext.isEmpty(this.tabsInfo)){
		 for(var i=0;i<this.tabsInfo.length;i++){
			 var type=this.tabsInfo[i].type;
			 var cmpXtype=this.getTabXtype(this.tabsInfo[i].type);
			 if ( cmpXtype == 'applicationpanel' )
			 {
				// this.tabsInfo[i].name = 'Application';
				 this.tabsInfo[i].index = '3';
			 }
			 else if ( cmpXtype == 'networkmainpanel' )
			 {
				//this.tabsInfo[i].name = 'Network';
				 this.tabsInfo[i].index = '2';
			 }
			 else if ( cmpXtype == 'netflowmainpanel' )
			 {
				 this.tabsInfo[i].index = '1';
			 }
			 else if ( cmpXtype == 'compdashdetailsMaintab' )
			 {
				 //this.tabsInfo[i].name = 'System';
				 this.tabsInfo[i].index = '1';
			 }
			 else if ( cmpXtype == 'interfacepanel' )
			 {
				 //this.tabsInfo[i].name = 'Interfaces';
				 this.tabsInfo[i].index = '4';
			 }
			 else if ( cmpXtype == 'custom' )
			 {
				//this.tabsInfo[i].name = 'Network';
				 this.tabsInfo[i].index = '5';
			 }

			 itemsArray.push({
				 xtype:cmpXtype,
				 title:this.tabsInfo[i].name,
				 itemId:type.toLowerCase(),
				 tabIndex:this.tabsInfo[i].index,
				 mask:mask
			 });
		 }
	 }
	
	this.items=itemsArray;
	this.callParent();
	},
	
	getTabXtype:function(type){
		switch(type.toLowerCase()){
			case 'system': cmpXtype='compdashdetailsMaintab';
							break;
			case 'network': cmpXtype='networkmainpanel';
							break;
			case 'layers': cmpXtype='compdashlayerstab';
							break;
			case 'custom': cmpXtype='compdashcustomtab';
							break;
			case 'virtual': cmpXtype='compdashvirtualtab';
							break;
			case 'application': cmpXtype='applicationpanel';
							break;
			case 'interfaces': cmpXtype='interfacepanel';
							break;
			case 'netflow': cmpXtype='netflowmainpanel';
							break;
		}
		return cmpXtype;
	},

	onRender : function(){
		this.getTabBar().add([{
			xtype : 'tbfill',
			hidden : hideAddCustomDashboardIcon
		},{
			xtype:'container',
			border:true,
			hidden : hideAddCustomDashboardIcon,
			cls:'iconIstamDashboardAdd',
			width:22,
			height:10,
			padding:0,
			margin:'4px 0px 0px 0px',
			items:{
				xtype : 'button',
				//cls:'overflowBt',
				hidden:false,
				width:22,
				height:19,
				style:{background:'none',border:'0px'},
				itemId:'istamDashboardCreate',
				handler : function()
				{
					document.location="/final/monitor/egDashboardProfile.jsp?compType="+hostTypeEncoded+"&hostName="+hostNameEncoded;
				}
			}
		},{
			xtype : 'tbfill'
		},{
			xtype:'combo',
			cls:'dropdown',
			hidden:true,
			itemId:'componentTypeCombo',
			id: 'componentTypeCombo',
			width:265,
			editable:false,
			labelWidth:35,
			labelStyle:'padding:2px 0px 0px;text-align:right',
			fieldLabel:'Type',
			labelAlign:'left',
			 labelSeparator: '' ,
			displayField:'text',
			valueField:'value',
			queryMode:'local',
			store:Ext.create('Ext.data.Store',{
				fields:['value','text']
			}),
			margin:'3 0 0 10'
		},{
			xtype:'combo',
			cls:'dropdown',
			hidden:true,
			labelStyle:'padding:2px 0px 0px;text-align:right',
			itemId:'componentNameCombo',
			id: 'componentNameCombo',
			style:{background:'none',border:'2px'},
			width:265,
			labelWidth:35,
			 labelSeparator: '' ,
			fieldLabel:'Name',
			editable:false,
			labelAlign:'left',
			displayField:'text',
			valueField:'value',
			queryMode:'local',
			store:Ext.create('Ext.data.Store',{
				fields:['state',{name:'text',convert:function(value, record){
					return decodeURI(value);
				}},'value']
			}),
			margin:'3 0 0 10',
			tpl: Ext.create('Ext.XTemplate',
				'<ul>',
				'<tpl for=".">',
					'<li class="x-boundlist-item"><img src="/final/images/spacer.gif" style="padding-left:18px;vertical-align:middle" class="state_{state}"/>{text}</li>',
				'</tpl>',
				'</ul>'
			)
		},{
			xtype:'scrollcombo',
			cls:'dropdown',
			hidden:true,
			itemId:'componentsDropDown',
			labelStyle:'padding:2px 0px 0px;text-align:right',
			id: 'componentsDropDown',
			style:{background:'none',border:'0px'},
			width:310,
			labelWidth:70,
			editable:true,
			 labelSeparator: '' ,
			fieldLabel:'Component',
			labelAlign:'left',
			displayField:'text',
			valueField:'value',
			
			queryMode:'local',
			store:Ext.create('Ext.data.Store',{
				fields:['state',{name:'text',convert:function(value, record){
					return decodeURI(value);
				}},'value']
			}),
			margin:'2 10 0 10',
			tpl: Ext.create('Ext.XTemplate',
				//'<ul style="display:inline-block;white-space:nowrap">',
				'<ul style="white-space:nowrap">',
				'<tpl for=".">',
					'<li class="x-boundlist-item"><img src="/final/images/spacer.gif" style="padding-left:18px;vertical-align:middle" class="state_{state}"/>{text}</li>',
				'</tpl>',
				'</ul>'
			)
		},{
			xtype : 'button',
			iconCls:'iconComponent_GRAY',
			cls:'overflowBt',
			hidden:true,
			style:{background:'none',border:'0px'},
			itemId:'compoentDetails'
		},/*{
			xtype : 'tbfill'

		},*/{
				xtype: 'tbseparator',
				itemId:'iconButtonSeparator',
				margin:'6 0 0 10',
				padding:0
			},{
			xtype: 'toolbar',
			defaults:{
				xtype: 'button',
				hidden:true,
				margin:'5 0 0 0',
				padding:'0 5 0 5',
				style: {
					background: 'none',
					border: '0px'
				}
			},
			items:[{ 
				iconCls: 'iconSettings',
				itemId:'iconSettings',
				
				listeners:{
					afterrender:function(){
						Ext.create('Ext.tip.ToolTip',{
							target: this.id,
							anchor: 'top',
							cls: 'yellowTip',
							trackMouse: true,
							html: 'Settings'
						});
					}
				}
			},{
				xtype: 'tbseparator',
				itemId:'iconSettingsSeparator',
				padding:0
			},{
				iconCls:'iconService',
				itemId:'iconService',
				
				action:'layerTool',
				listeners:{
					afterrender: function(){
						Ext.create('Ext.tip.ToolTip',{
							target: this.id,
							anchor: 'top',
							cls: 'yellowTip',
							trackMouse: true,
							html: 'Service'
						});
					}
				}
			},{
				xtype: 'tbseparator',
				padding:0,
				itemId:'iconServiceSeparator',
				
			},{
				iconCls:'iconTransactions',
				itemId:'iconTransactions',
				
				action:'layerTool',
				listeners:{
					afterrender: function(){
						Ext.create('Ext.tip.ToolTip',{
							target: this.id,
							anchor: 'top',
							cls: 'yellowTip',
							trackMouse: true,
							html: 'Transactions'
						});
					}
				}
			},{
				xtype: 'tbseparator',
				padding:0,
				itemId:'iconTransactionsSeparator',
				
			},{
				iconCls:'iconTransactions',
				itemId:'iconEmuTransactions',
				
				action:'layerTool',
				listeners:{
					afterrender: function(){
						Ext.create('Ext.tip.ToolTip',{
							target: this.id,
							anchor: 'top',
							cls: 'yellowTip',
							trackMouse: true,
							html: simulatedTransactionFlow
						});
					}
				}
			},{
				xtype: 'tbseparator',
				padding:0,
				itemId:'iconEmuTransactionsSeparator',
				
			},{
				iconCls:'iconConfigUser',
				itemId:'iconConfigUser',
				//action:'layerTool',
				listeners:{
					afterrender: function(){
						Ext.create('Ext.tip.ToolTip',{
							target: this.id,
							anchor: 'top',
							cls: 'yellowTip',
							trackMouse: true,
							html: 'Config'
						});
					}
				}
			},{
				xtype: 'tbseparator',
				padding:0,
				itemId:'iconConfigUserSeparator',
			
			},{
				iconCls:'iconComponent',
				itemId:'iconComponent',
				action:'layerTool',
				
				listeners:{
					afterrender: function(){
						Ext.create('Ext.tip.ToolTip',{
							target: this.id,
							anchor: 'top',
							cls: 'yellowTip',
							trackMouse: true,
							html: 'Server'
						});
					}
				}
			},{
				xtype: 'tbseparator',
				padding:0,
				itemId:'iconComponentSeparator',
			},{
				iconCls:'iconTopology',
				itemId:'iconTopology',
				
				action:'layerTool',
				listeners:{
					afterrender: function(){
						Ext.create('Ext.tip.ToolTip',{
							target: this.id,
							anchor: 'top',
							cls: 'yellowTip',
							trackMouse: true,
							html: 'Topology'
						});
					}
				}
			},{
				xtype: 'tbseparator',
				padding:0,
				itemId:'iconTopologySeparator',
			},{
				iconCls:'iconVirtualTopology',
				itemId:'iconVirtualTopology',
				action:'layerTool',
				
				listeners:{
					afterrender: function(){
						Ext.create('Ext.tip.ToolTip',{
							target: this.id,
							anchor: 'top',
							cls: 'yellowTip',
							trackMouse: true,
							html: 'Virtual Topology'
						});
					}
				}
			},{
				xtype: 'tbseparator',
				padding:0,
				itemId:'iconVirtualTopologySeparator',
			},{
				iconCls:'iconDesktop',
				itemId:'iconDesktop',
				
				action:'layerTool',
				listeners:{
						afterrender: function(){
							Ext.create('Ext.tip.ToolTip',{
								target: this.id,
								anchor: 'top',
								cls: 'yellowTip',
								trackMouse: true,
								html: 'Desktop'
							});
						}
					}
				}		
			]
		},{
			xtype : 'button',
			margin:'4 4 0 4',
			iconCls:'iconBack',
			text : requestParams.backText,
			action : 'back',
			cls:'backbutton'
		}]);
		this.callParent();
	},

	setLayerToolbar:function(data,componentToolTip,componentState){
		this.down('button[itemId=compoentDetails]').setTooltip(componentToolTip);
		this.down('button[itemId=compoentDetails]').setIconCls(componentState);

		if(!requestParams.configChangeIcon == true || requestParams.configChangeIcon == 'true'){
			//this.down('button[itemId=iconConfigUser]').link = requestParams.configChangeLink;
			var isFromMonitor = true;
			var configurl = requestParams.configChangeLink;
			var compName = "";
			if(requestParams.configChangeLink != null && requestParams.configChangeLink != "")
			{
				var params = configurl.substring(configurl.indexOf("?")+1,configurl.length);
				var paramsArray = params.split("&");
				for(var i=0;i<paramsArray.length;i++)
				{
					var temp_param = paramsArray[i];
					if(temp_param.indexOf("componentName") > -1)
					{
						compName = temp_param.substring(temp_param.indexOf("=")+1);
					}
				}
			}
			var url = "/final/servlet/com.eg.EcConfigurationServletNew?ec_rtype=ChangeNew&ec_option1=Component Name&ec_timeline=1+day&ec_prevtimeline=1+day&ec_option2="+compName+"&ec_changetype=Latest&ec_viewchange=byInformation&fromPage=configChange&ec_criteria=Component&fromMonitor="+isFromMonitor;
			this.down('button[itemId=iconConfigUser]').setHandler(function(handler, scope) {
				try
				{
					xaxis = Ext.getBody().getViewSize().width-950;
				}
				catch (ee)
				{
					xaxis = 415;
				}
				if (!Ext.getCmp("configContainer"))
				{
			
					Ext.create('Ext.container.Container',{
						padding:0,
						floating:true,
						frame:false,
						width:900,
						hidden:true,
						height:357,
						x:415,
						y:25,
						shadow:true,
						floatable:true,
						id:'configContainer',
						cls:'configPopupWindow',
						items:[
							{
								xtype:'container',
								cls:'configPopupArrow',
								style:{'top':"-6px",'left':"854px"}
							},
							{
								xtype:'container',
								cls:'configPopfont',
								padding:0,
								html:'<table cellspacing="0" cellpadding="0" border="0"><tr><td style="width:100%"><div style="float:left;margin:0px 0px 0px 4px;border-bottom:none;padding:0px 0px 3px 0px" class="configPopfont">CONFIGURATION DETAILS FOR '+compName.substring(0,compName.indexOf(":"))+' DURING LAST 24 hrs</div></td><td style="color:#01a6f6;font-weight:bold;width:92px;display:block"><div style="float:left;margin-top:0px"><a href="'+configurl+'" class="configLink">More details</a></div><div class="configSeparator" style="margin-right:5px;margin-top:0px;"></div></td><td><div style="text-align:right;width:25px"><div class="iconClose3" style="margin-top:-4px"></div></div></td></tr></table>',
								style:{'top':'0px','margin':'2px'}
							},
							{
								xtype:'panel',
								id:'configDataPanel',
								height:320,
								cls:'configPopupWindow_inner',
								html:'<iframe width="900" height=315" border="0" scrolling="yes" marginwidth="0px" marginheight="0px" frameborder="0"  src="'+url+'"> </iframe>'
							
							}
							
						]
					}).show();

					Ext.select('.iconClose3').on('click',function(){
			
							Ext.getCmp("configContainer").hide();
							Ext.getCmp("configContainer").removeAll();
							Ext.getCmp("configContainer").destroy();
							//Ext.get("configDetails").destroy();
					},this);
					Ext.EventManager.onWindowResize(function()
					 {
						try
						{
							Ext.getCmp("configContainer").setPosition(Ext.getBody().getViewSize().width-950,25);
						}
						catch (eee)
						{
						
						}
					 });

				}
			});
			this.down('button[itemId=iconConfigUser]').show();
		}
		else{
			this.down('button[itemId=iconConfigUser]').hide();
		}

		if(!Ext.isEmpty(data) && data.length > 0){
			for(i=0;i<data.length;i++){
				switch(data[i].icon){
					case 'SERVICES':{
						this.down('button[itemId=iconService]').link = data[i].href;
						this.down('button[itemId=iconService]').show();
						this.down('tbseparator[itemId=iconServiceSeparator]').show();
						break;
					}
					case 'TOPOLOGY':{
						data[i].href = data[i].href+'&LayerModelTopology=yes';
						this.down('button[itemId=iconTopology]').link = data[i].href;
						this.down('button[itemId=iconTopology]').show();
						this.down('tbseparator[itemId=iconTopologySeparator]').show();
						break;
					}
					case 'EMULATED_TRANSACTIONS':{
						this.down('button[itemId=iconEmuTransactions]').link = data[i].href;
						this.down('button[itemId=iconEmuTransactions]').show();
						this.down('tbseparator[itemId=iconEmuTransactionsSeparator]').show();
						break;
					}
					case 'TRANSACTIONS':{
						this.down('button[itemId=iconTransactions]').link = data[i].href;
						this.down('button[itemId=iconTransactions]').show();
						this.down('tbseparator[itemId=iconTransactionsSeparator]').show();
						break;
					}
					case 'VIRTUAL TOPOLOGY':{
						this.down('button[itemId=iconVirtualTopology]').setIconCls('iconVirtualTopology_'+data[i].hostState);
						this.down('button[itemId=iconVirtualTopology]').link = data[i].href;
						this.down('button[itemId=iconVirtualTopology]').show();
						this.down('tbseparator[itemId=iconVirtualTopologySeparator]').show();
						break;
					}
					case 'SERVERS':{
						this.down('button[itemId=iconComponent]').link = data[i].href;
						this.down('button[itemId=iconComponent]').show();
						this.down('tbseparator[itemId=iconComponentSeparator]').show();
						break;
					}
					case 'DESKTOPS':{
						this.down('button[itemId=iconDesktop]').link = data[i].href;
						this.down('button[itemId=iconDesktop]').show();
						break;
					}
				}
			}
			this.down('tbseparator[itemId=iconButtonSeparator]').show();
		}
		else
			this.down('tbseparator[itemId=iconButtonSeparator]').hide();
	}
});
}
else
{
Ext.define('componentDashboard.view.ComponentTabPanel', {
	extend: 'Ext.tab.Panel',
	//requires : ['componentDashboard.view.CompDashSystemTab','componentDashboard.view.CompDashNetworkTab','componentDashboard.view.CompDashLayersTab','componentDashboard.view.CompDashCustomTab','componentDashboard.view.CompDashVirtualTab','componentDashboard.view.Application.ApplicationPanel','componentDashboard.view.Interfaces.InterfaceTab','componentDashboard.view.network.NetworkMainPanel','componentDashboard.view.system.CompDashDetailsTab'],
	requires : ['componentDashboard.view.CompDashLayersTab','componentDashboard.view.system.CompDashDetailsTab','componentDashboard.view.Application.ThreadDetails','componentDashboard.view.network.NetworkMainPanel','componentDashboard.view.Application.ApplicationPanel','componentDashboard.view.CompDashVirtualTab','componentDashboard.view.Interfaces.InterfaceTab','componentDashboard.view.CompDashCustomTab','componentDashboard.view.netflow.NetflowMainPanel'],
	alias:'widget.componenttabpanel',
	tabsInfo:null,
	cls:'tablayout',
	bodyCls:'tablayoutBodyColor',
	initComponent : function() {
		var mask = null;
		var wholeViewport = document.getElementsByTagName("body")[0];
		if(!Ext.isEmpty(Ext.get(wholeViewport))){
			mask = new Ext.LoadMask(Ext.get(wholeViewport), {msg:"Loading...",cls:'maskDash'});
			mask.show();
		}
	
	 var itemsArray=new Array();
	 if(!Ext.isEmpty(this.tabsInfo)){
		 for(var i=0;i<this.tabsInfo.length;i++){
			 var type=this.tabsInfo[i].type;
			 var cmpXtype=this.getTabXtype(this.tabsInfo[i].type);
			 if ( cmpXtype == 'applicationpanel' )
			 {
				 //this.tabsInfo[i].name = 'Application';
				 this.tabsInfo[i].index = '3';
			 }
			 else if ( cmpXtype == 'networkmainpanel' )
			 {
				//this.tabsInfo[i].name = 'Network';
				 this.tabsInfo[i].index = '2';
			 }
			 else if ( cmpXtype == 'netflowmainpanel' )
			 {
				 this.tabsInfo[i].index = '1';
			 }
			 else if ( cmpXtype == 'compdashdetailsMaintab' )
			 {
				 //this.tabsInfo[i].name = 'System';
				 this.tabsInfo[i].index = '1';
			 }
			 else if ( cmpXtype == 'interfacepanel' )
			 {
				 //this.tabsInfo[i].name = 'Interfaces';
				 this.tabsInfo[i].index = '4';
			 }
			 else if ( cmpXtype == 'custom' )
			 {
				//this.tabsInfo[i].name = 'Network';
				 this.tabsInfo[i].index = '5';
			 }

			 itemsArray.push({
				 xtype:cmpXtype,
				 title:this.tabsInfo[i].name,
				 itemId:type.toLowerCase(),
				 tabIndex:this.tabsInfo[i].index,
				 mask:mask
			 });
		 }
	 }
	
	this.items=itemsArray;
	this.callParent();
	},
	
	getTabXtype:function(type){
		switch(type.toLowerCase()){
			case 'system': cmpXtype='compdashdetailsMaintab';
							break;
			case 'network': cmpXtype='networkmainpanel';
							break;
			case 'layers': cmpXtype='compdashlayerstab';
							break;
			case 'custom': cmpXtype='compdashcustomtab';
							break;
			case 'virtual': cmpXtype='compdashvirtualtab';
							break;
			case 'application': cmpXtype='applicationpanel';
							break;
			case 'interfaces': cmpXtype='interfacepanel';
							break;
			case 'netflow': cmpXtype='netflowmainpanel';
							break;
		}
		return cmpXtype;
	},

	onRender : function(){
		this.getTabBar().add([{
			xtype : 'tbfill',
			hidden : hideAddCustomDashboardIcon
		},{
			xtype:'container',
			border:true,
			hidden : hideAddCustomDashboardIcon,
			cls:'iconIstamDashboardAdd',
			width:22,
			height:10,
			padding:0,
			margin:'4px 0px 0px 0px',
			items:{
				xtype : 'button',
				//cls:'overflowBt',
				hidden:false,
				width:22,
				height:19,
				style:{background:'none',border:'0px'},
				itemId:'istamDashboardCreate',
				handler : function()
				{
					document.location="/final/monitor/egDashboardProfile.jsp?compType="+hostTypeEncoded+"&hostName="+hostNameEncoded;
				}
			}
		},{
			xtype : 'tbfill'
		},{
			xtype:'combo',
			cls:'dropdown',
			hidden:true,
			itemId:'componentTypeCombo',
			id: 'componentTypeCombo',
			width:265,
			editable:false,
			labelWidth:35,
			labelStyle:'padding:2px 0px 0px;text-align:right',
			fieldLabel:'Type',
			labelAlign:'left',
			 labelSeparator: '' ,
			displayField:'text',
			valueField:'value',
			queryMode:'local',
			store:Ext.create('Ext.data.Store',{
				fields:['value','text']
			}),
			margin:'3 0 0 10'
		},{
			xtype:'combo',
			cls:'dropdown',
			hidden:true,
			labelStyle:'padding:2px 0px 0px;text-align:right',
			itemId:'componentNameCombo',
			id: 'componentNameCombo',
			style:{background:'none',border:'2px'},
			width:265,
			labelWidth:35,
			 labelSeparator: '' ,
			fieldLabel:'Name',
			editable:false,
			labelAlign:'left',
			displayField:'text',
			valueField:'value',
			queryMode:'local',
			store:Ext.create('Ext.data.Store',{
				fields:['state',{name:'text',convert:function(value, record){
					return decodeURI(value);
				}},'value']
			}),
			margin:'3 0 0 10',
			tpl: Ext.create('Ext.XTemplate',
				'<ul>',
				'<tpl for=".">',
					'<li class="x-boundlist-item"><img src="/final/images/spacer.gif" style="padding-left:18px;vertical-align:middle" class="state_{state}"/>{text}</li>',
				'</tpl>',
				'</ul>'
			)
		},{
			xtype:'scrollcombo',
			cls:'dropdown',
			hidden:true,
			itemId:'componentsDropDown',
			labelStyle:'padding:2px 0px 0px;text-align:right',
			id: 'componentsDropDown',
			style:{background:'none',border:'0px'},
			width:310,
			labelWidth:70,
			editable:true,
			 labelSeparator: '' ,
			fieldLabel:'Component',
			labelAlign:'left',
			displayField:'text',
			valueField:'value',
			
			queryMode:'local',
			store:Ext.create('Ext.data.Store',{
				fields:['state',{name:'text',convert:function(value, record){
					return decodeURI(value);
				}},'value']
			}),
			margin:'2 10 0 10',
			tpl: Ext.create('Ext.XTemplate',
				//'<ul style="display:inline-block;white-space:nowrap">',
				'<ul style="white-space:nowrap">',
				'<tpl for=".">',
					'<li class="x-boundlist-item"><img src="/final/images/spacer.gif" style="padding-left:18px;vertical-align:middle" class="state_{state}"/>{text}</li>',
				'</tpl>',
				'</ul>'
			)
		},{
			xtype : 'button',
			iconCls:'iconComponent_GRAY',
			cls:'overflowBt',
			hidden:true,
			style:{background:'none',border:'0px'},
			itemId:'compoentDetails'
		},/*{
			xtype : 'tbfill'

		},*/{
				xtype: 'tbseparator',
				itemId:'iconButtonSeparator',
				margin:'6 0 0 10',
				padding:0
			},{
			xtype: 'toolbar',
			defaults:{
				xtype: 'button',
				hidden:true,
				margin:'5 0 0 0',
				padding:'0 5 0 5',
				style: {
					background: 'none',
					border: '0px'
				}
			},
			items:[{ 
				iconCls: 'iconSettings',
				itemId:'iconSettings',
				
				listeners:{
					afterrender:function(){
						Ext.create('Ext.tip.ToolTip',{
							target: this.id,
							anchor: 'top',
							cls: 'yellowTip',
							trackMouse: true,
							html: 'Settings'
						});
					}
				}
			},{
				xtype: 'tbseparator',
				itemId:'iconSettingsSeparator',
				padding:0
			},{
				iconCls:'iconService',
				itemId:'iconService',
				
				action:'layerTool',
				listeners:{
					afterrender: function(){
						Ext.create('Ext.tip.ToolTip',{
							target: this.id,
							anchor: 'top',
							cls: 'yellowTip',
							trackMouse: true,
							html: 'Service'
						});
					}
				}
			},{
				xtype: 'tbseparator',
				padding:0,
				itemId:'iconServiceSeparator',
				
			},{
				iconCls:'iconTransactions',
				itemId:'iconTransactions',
				
				action:'layerTool',
				listeners:{
					afterrender: function(){
						Ext.create('Ext.tip.ToolTip',{
							target: this.id,
							anchor: 'top',
							cls: 'yellowTip',
							trackMouse: true,
							html: 'Transactions'
						});
					}
				}
			},{
				xtype: 'tbseparator',
				padding:0,
				itemId:'iconTransactionsSeparator',
				
			},{
				iconCls:'iconTransactions',
				itemId:'iconEmuTransactions',
				
				action:'layerTool',
				listeners:{
					afterrender: function(){
						Ext.create('Ext.tip.ToolTip',{
							target: this.id,
							anchor: 'top',
							cls: 'yellowTip',
							trackMouse: true,
							html: simulatedTransactionFlow
						});
					}
				}
			},{
				xtype: 'tbseparator',
				padding:0,
				itemId:'iconEmuTransactionsSeparator',
				
			},{
				iconCls:'iconConfigUser',
				itemId:'iconConfigUser',
				//action:'layerTool',
				listeners:{
					afterrender: function(){
						Ext.create('Ext.tip.ToolTip',{
							target: this.id,
							anchor: 'top',
							cls: 'yellowTip',
							trackMouse: true,
							html: 'Config'
						});
					}
				}
			},{
				xtype: 'tbseparator',
				padding:0,
				itemId:'iconConfigUserSeparator',
			
			},{
				iconCls:'iconComponent',
				itemId:'iconComponent',
				action:'layerTool',
				
				listeners:{
					afterrender: function(){
						Ext.create('Ext.tip.ToolTip',{
							target: this.id,
							anchor: 'top',
							cls: 'yellowTip',
							trackMouse: true,
							html: 'Server'
						});
					}
				}
			},{
				xtype: 'tbseparator',
				padding:0,
				itemId:'iconComponentSeparator',
			},{
				iconCls:'iconTopology',
				itemId:'iconTopology',
				
				action:'layerTool',
				listeners:{
					afterrender: function(){
						Ext.create('Ext.tip.ToolTip',{
							target: this.id,
							anchor: 'top',
							cls: 'yellowTip',
							trackMouse: true,
							html: 'Topology'
						});
					}
				}
			},{
				xtype: 'tbseparator',
				padding:0,
				itemId:'iconTopologySeparator',
			},{
				iconCls:'iconVirtualTopology',
				itemId:'iconVirtualTopology',
				action:'layerTool',
				
				listeners:{
					afterrender: function(){
						Ext.create('Ext.tip.ToolTip',{
							target: this.id,
							anchor: 'top',
							cls: 'yellowTip',
							trackMouse: true,
							html: 'Virtual Topology'
						});
					}
				}
			},{
				xtype: 'tbseparator',
				padding:0,
				itemId:'iconVirtualTopologySeparator',
			},{
				iconCls:'iconDesktop',
				itemId:'iconDesktop',
				
				action:'layerTool',
				listeners:{
						afterrender: function(){
							Ext.create('Ext.tip.ToolTip',{
								target: this.id,
								anchor: 'top',
								cls: 'yellowTip',
								trackMouse: true,
								html: 'Desktop'
							});
						}
					}
				}		
			]
		},{
			xtype : 'button',
			margin:'4 4 0 4',
			iconCls:'iconBack',
			text : requestParams.backText,
			action : 'back',
			cls:'backbutton'
		}]);
		this.callParent();
	},

	setLayerToolbar:function(data,componentToolTip,componentState){
		this.down('button[itemId=compoentDetails]').setTooltip(componentToolTip);
		this.down('button[itemId=compoentDetails]').setIconCls(componentState);

		if(!requestParams.configChangeIcon == true || requestParams.configChangeIcon == 'true'){
			//this.down('button[itemId=iconConfigUser]').link = requestParams.configChangeLink;
			var isFromMonitor = true;
			var configurl = requestParams.configChangeLink;
			var compName = "";
			if(requestParams.configChangeLink != null && requestParams.configChangeLink != "")
			{
				var params = configurl.substring(configurl.indexOf("?")+1,configurl.length);
				var paramsArray = params.split("&");
				for(var i=0;i<paramsArray.length;i++)
				{
					var temp_param = paramsArray[i];
					if(temp_param.indexOf("componentName") > -1)
					{
						compName = temp_param.substring(temp_param.indexOf("=")+1);
					}
				}
			}
			var url = "/final/servlet/com.eg.EcConfigurationServletNew?ec_rtype=ChangeNew&ec_option1=Component Name&ec_timeline=1+day&ec_prevtimeline=1+day&ec_option2="+compName+"&ec_changetype=Latest&ec_viewchange=byInformation&fromPage=configChange&ec_criteria=Component&fromMonitor="+isFromMonitor;
			this.down('button[itemId=iconConfigUser]').setHandler(function(handler, scope) {
				try
				{
					xaxis = Ext.getBody().getViewSize().width-950;
				}
				catch (ee)
				{
					xaxis = 415;
				}

				if (!Ext.getCmp("configContainer"))
				{
			
					Ext.create('Ext.container.Container',{
						padding:0,
						floating:true,
						frame:false,
						width:900,
						hidden:true,
						height:357,
						x:415,
						y:25,
						shadow:true,
						floatable:true,
						id:'configContainer',
						cls:'configPopupWindow',
						items:[
							{
								xtype:'container',
								cls:'configPopupArrow',
								style:{'top':"-6px",'left':"854px"}
							},
							{
								xtype:'container',
								cls:'configPopfont',
								padding:0,
								html:'<table cellspacing="0" cellpadding="0" border="0"><tr><td style="width:100%"><div style="float:left;margin:0px 0px 0px 4px;border-bottom:none;padding:0px 0px 3px 0px" class="configPopfont">CONFIGURATION DETAILS FOR '+compName.substring(0,compName.indexOf(":"))+' DURING LAST 24 hrs</div></td><td style="color:#01a6f6;font-weight:bold;width:92px;display:block"><div style="float:left;margin-top:0px"><a href="'+configurl+'" class="configLink">More details</a></div><div class="configSeparator" style="margin-right:5px;margin-top:0px;"></div></td><td><div style="text-align:right;width:25px"><div class="iconClose3" style="margin-top:-4px"></div></div></td></tr></table>',
								style:{'top':'0px','margin':'2px'}
							},
							{
								xtype:'panel',
								id:'configDataPanel',
								height:320,
								cls:'configPopupWindow_inner',
								html:'<iframe width="900" height=315" border="0" scrolling="yes" marginwidth="0px" marginheight="0px" frameborder="0"  src="'+url+'"> </iframe>'
							
							}
							
						]
					}).show();

					Ext.select('.iconClose3').on('click',function(){
			
							Ext.getCmp("configContainer").hide();
							Ext.getCmp("configContainer").removeAll();
							Ext.getCmp("configContainer").destroy();
							//Ext.get("configDetails").destroy();
					},this);
					Ext.EventManager.onWindowResize(function()
					 {
						try
						{
							Ext.getCmp("configContainer").setPosition(Ext.getBody().getViewSize().width-950,25);
						}
						catch (eee)
						{
						
						}
					 });

				}
			});
			this.down('button[itemId=iconConfigUser]').show();
		}
		else{
			this.down('button[itemId=iconConfigUser]').hide();
		}

		if(!Ext.isEmpty(data) && data.length > 0){
			for(i=0;i<data.length;i++){
				switch(data[i].icon){
					case 'SERVICES':{
						this.down('button[itemId=iconService]').link = data[i].href;
						this.down('button[itemId=iconService]').show();
						this.down('tbseparator[itemId=iconServiceSeparator]').show();
						break;
					}
					case 'TOPOLOGY':{
						data[i].href = data[i].href+'&LayerModelTopology=yes';
						this.down('button[itemId=iconTopology]').link = data[i].href;
						this.down('button[itemId=iconTopology]').show();
						this.down('tbseparator[itemId=iconTopologySeparator]').show();
						break;
					}
					case 'EMULATED_TRANSACTIONS':{
						this.down('button[itemId=iconEmuTransactions]').link = data[i].href;
						this.down('button[itemId=iconEmuTransactions]').show();
						this.down('tbseparator[itemId=iconEmuTransactionsSeparator]').show();
						break;
					}
					case 'TRANSACTIONS':{
						this.down('button[itemId=iconTransactions]').link = data[i].href;
						this.down('button[itemId=iconTransactions]').show();
						this.down('tbseparator[itemId=iconTransactionsSeparator]').show();
						break;
					}
					case 'VIRTUAL TOPOLOGY':{
						this.down('button[itemId=iconVirtualTopology]').setIconCls('iconVirtualTopology_'+data[i].hostState);
						this.down('button[itemId=iconVirtualTopology]').link = data[i].href;
						this.down('button[itemId=iconVirtualTopology]').show();
						this.down('tbseparator[itemId=iconVirtualTopologySeparator]').show();
						break;
					}
					case 'SERVERS':{
						this.down('button[itemId=iconComponent]').link = data[i].href;
						this.down('button[itemId=iconComponent]').show();
						this.down('tbseparator[itemId=iconComponentSeparator]').show();
						break;
					}
					case 'DESKTOPS':{
						this.down('button[itemId=iconDesktop]').link = data[i].href;
						this.down('button[itemId=iconDesktop]').show();
						break;
					}
				}
			}
			this.down('tbseparator[itemId=iconButtonSeparator]').show();
		}
		else
			this.down('tbseparator[itemId=iconButtonSeparator]').hide();
	}
});
}