Ext.define('componentDashboard.view.Layers.AggregateWindow',{
	extend:'Ext.window.Window',
	alias:'widget.aggregatewindow',
	height:460,
	width:760,
	bodyBorder:false,
	bodyPadding:10,
	padding:'4 10 10 10',
	title:'Details of Aggregate Measure Calculation',
	closable:true,
	draggable:true,
	modal:true,
	scroll:true,
	autoScroll:true,
	closeAction:'hide',
	layout:'vbox',
	defaults:{
		margin:5
	},

	items:[{
			xtype:'panel',
			itemId:'informationPanel_common',
			width:'100%',
			cls:'aggMeasureInfoTableHeader',
			id:'aggMeasureInfoId',
			title:'',
			hidden: false,
			//layout:'hbox',
			height:'auto',
			border:false,
			manageOverflow:2,
			//cls:'informationPanel',
			//cls:'displayfieldCLS',
			layout: {
				type: 'table',
				align:'stretch',
				// The total column count must be specified here
				columns:2,
				tableAttrs: {
					cls:'aggMeasureInfoTable',
					width:'100%',
				},
				tdAttrs: {
					width:'50%',
				}
			},
			defaults:{
				labelWidth:150,
				//labelWidth:150,
				//labelStyle:'padding-left:10px;padding-bottom:5px',
				labelSeparator:'',
				margin:0,
				padding:0,
				width:'50%',
				labelAlign:'left',

			},
			items:[{
					xtype:'displayfield',
					width:'100%',
					//cls:'displayfieldCLS',
					//style:{'background-color':'#FAFAFA','border-bottom':'#c3c3c3 1px solid'},
					fieldLabel:'Conponent Type',
					itemId:'componentType',
					value:'Windows Aggregate'
				},{
					xtype:'displayfield',
					width:'100%',
					//cls:'displayfieldCLS',
					//style:{'background-color':'#FAFAFA','border-bottom':'#c3c3c3 1px solid'},
					fieldLabel:'Conponent Name',
					itemId:'componentName',
					value:'win_agg'
				},{
					xtype:'displayfield',
					width:'100%',
					//cls:'displayfieldCLS',
					//labelStyle:'padding-left:10px;padding-bottom:0px',
					fieldLabel:'Test Name',
					itemId:'test',
					value:'Disk Space Aggregate'
				},{
					xtype:'displayfield',
					width:'100%',
					//labelStyle:'padding-left:10px;padding-bottom:0px',
					//cls:'displayfieldCLS',
					fieldLabel:'Measure Name',
					itemId:'measure',
					value:'Total Capacity (MB)'
				},{
					xtype:'displayfield',
					width:'100%',
					//cls:'displayfieldCLS',
					//labelStyle:'padding-left:10px;padding-bottom:0px',
					fieldLabel:'Start Time',
					itemId:'starttime',
					value:'-'
				},{
					xtype:'displayfield',
					width:'100%',
					//labelStyle:'padding-left:10px;padding-bottom:0px',
					//cls:'displayfieldCLS',
					fieldLabel:'End Time',
					itemId:'endtime',
					value:'-'
				}]
	},{
			xtype:'panel',
			itemId:'conditionPanel',
			width:'100%',
			cls:'aggMeasureInfoTableHeader',
			id:'conditionPanel',
			title:'',
			hidden: false,
			//layout:'hbox',
			height:'auto',
			border:false,
			manageOverflow:2,
			//cls:'informationPanel',
			//cls:'displayfieldCLS',
			layout: {
				type: 'table',
				align:'stretch',
				// The total column count must be specified here
				columns:2,
				tableAttrs: {
					cls:'aggMeasureInfoTable',
					width:'100%',
				},
				tdAttrs: {
					width:'50%',
				}
			},
			defaults:{
				labelWidth:200,
				//labelWidth:150,
				//labelStyle:'padding-left:10px;padding-bottom:5px',
				labelSeparator:'',
				margin:0,
				padding:0,
				width:'50%',
				labelAlign:'left',

			},
			items:[{
					xtype:'displayfield',
					id:'targetcondition',
					width:'100%',
					//cls:'displayfieldCLS',
					//labelStyle:'padding-left:10px;padding-bottom:0px',
					fieldLabel:'Target Operation',
					itemId:'targetcondition',
					value:'Disk Space Aggregate'
				},{
					xtype:'displayfield',
					id:'targetvalue',
					width:'100%',
					//labelStyle:'padding-left:10px;padding-bottom:0px',
					//cls:'displayfieldCLS',
					fieldLabel:'Target Value',
					itemId:'targetvalue',
					value:'Total Capacity (MB)'
				},{
					xtype:'displayfield',
					id:'target_components',
					width:'100%',
					//cls:'displayfieldCLS',
					//labelStyle:'padding-left:10px;padding-bottom:0px',
					fieldLabel:'Target Components',
					itemId:'target_components',
					value:'Not Applicable',
					//style:{'background-color':'#FAFAFA','border-bottom':'#c3c3c3 0px solid !important'},
				},{
					xtype:'displayfield',
					id:'target_violation_by',
					width:'100%',
					//labelStyle:'padding-left:10px;padding-bottom:0px',
					//cls:'displayfieldCLS',
					fieldLabel:'Target Violation By Descriptors',
					itemId:'target_violation_by',
					value:'Not Applicable'
					//style:{'background-color':'#FAFAFA','border-bottom':'#c3c3c3 0px solid !important'},
			}]
	},
	{

		id: 'radioContainer',
		width:'100%',
		layout:'column',
		margin:4,
		hidden: true,
		xtype: 'radiogroup',
		fieldLabel: 'Show descriptors',
		labelWidth:150,
		//width:'100%',
		//hidden: false,
		listeners: {
			change: function(radiogroup, radio) {
				if(Ext.getCmp(this.id).getValue().descriptorAggregation=='Yes') {
					componentDashboard.app.getController("Main").openAggregateDetails(aggregateReloadURL+'&showViolatedDescriptors=Yes');
				}
				else {
					componentDashboard.app.getController("Main").openAggregateDetails(aggregateReloadURL+'&showViolatedDescriptors=No');
				}
			}
		},
		items: [
			{
				xtype: 'radiofield',
				boxLabel: 'All',
				name: 'descriptorAggregation',
				id:'nda1',
				columnWidth:.3,
				cls:'radiobt',
				inputValue: 'No',
				checked: true
			},
			{
				xtype: 'radiofield',
				boxLabel: 'With violations only',
				name: 'descriptorAggregation',
				id:'nda2',
				columnWidth:.3,
				cls:'radiobt',
				inputValue: 'Yes'
			}
		]
	},
	{
		xtype:'container',
		width:'100%',
		layout:'fit',
		itemId:'middleContainer',
		html:'This is the aggregate information panel!'
	},
	{
		xtype:'container',
		itemId:'bottomContainer',
		width:'100%'
	}],
	listeners: {
		show: function (f){
			if (this.modal) {
				var g = Ext.dom.Query.select(".x-mask");
				var e = Ext.fly(g[0]);
				e.addCls("windowModal");
			}
		},
		hide: function (f) {
			if (this.modal) {
				var g = Ext.dom.Query.select(".x-mask");
				var e = Ext.fly(g[0]);
				e.removeCls("windowModal");
			}
		},
		afterrender: function () {

		Ext.EventManager.onWindowResize(function () {
			var e = this;
			e.center();
			}, this);
		}
	},
	initComponent:function(){
		this.callParent();
	},

	setData:function(json){

		var commonPanel = Ext.getCmp('aggMeasureInfoId');
		commonPanel.setTitle(json.screenLabels.measurementTime+' : '+json.measurementTime);

		commonPanel.down('displayfield#componentType').setFieldLabel(json.screenLabels.componentType);
		commonPanel.down('displayfield#componentType').setValue(json.componentType);

		commonPanel.down('displayfield#componentName').setFieldLabel(json.screenLabels.componentName);
		commonPanel.down('displayfield#componentName').setValue(json.componentName);

		commonPanel.down('displayfield#test').setFieldLabel(json.screenLabels.test);
		commonPanel.down('displayfield#test').setValue(json.test);

		commonPanel.down('displayfield#measure').setFieldLabel(json.screenLabels.measure);
		commonPanel.down('displayfield#measure').setValue(json.measure);

		commonPanel.down('displayfield#starttime').setFieldLabel(json.screenLabels.starttime);
		commonPanel.down('displayfield#starttime').setValue(json.starttime);

		commonPanel.down('displayfield#endtime').setFieldLabel(json.screenLabels.endtime);
		commonPanel.down('displayfield#endtime').setValue(json.endtime);


		if(json.condition != null && json.condition=='true')
		{
			var conditonPanelObj = Ext.getCmp('conditionPanel');
			conditonPanelObj.setVisible(true);
			Ext.getCmp('targetcondition').setVisible(true);
			Ext.getCmp('targetvalue').setVisible(true);
			Ext.getCmp('target_components').setVisible(true);
			Ext.getCmp('target_violation_by').setVisible(true);
			if(json.show_info_details=='true') {

				var radioContain = Ext.getCmp('radioContainer');
				radioContain.suspendEvents();
				radioContain.setValue({'descriptorAggregation':json.showViolatedDescriptors});
				radioContain.setVisible(true);
				radioContain.resumeEvents();
			}
			else {
				Ext.getCmp('radioContainer').setVisible(false);
			}
			conditonPanelObj.down('displayfield#targetcondition').setValue(json.targetOperation);
			conditonPanelObj.down('displayfield#targetvalue').setValue(json.targetValue);
			conditonPanelObj.down('displayfield#target_components').setValue('Not Applicable');
			if(json.isMainTestDescBased=='true' && json.isAggTestDescBased=='false') {
				conditonPanelObj.down('displayfield#target_violation_by').setValue(json.target_violation_by);
			}
			else {
				conditonPanelObj.down('displayfield#target_violation_by').setValue('Not Applicable');
			}
		}
		else if(json.multi_condition != null && json.multi_condition=='true')
		{
			var conditonPanelObj = Ext.getCmp('conditionPanel');
			conditonPanelObj.setVisible(true);
			Ext.getCmp('targetcondition').setVisible(true);
			Ext.getCmp('targetvalue').setVisible(true);
			Ext.getCmp('target_components').setVisible(true);
			Ext.getCmp('target_violation_by').setVisible(true);
			if(json.show_info_details != null && json.show_info_details=='true') {
				var radioContain = Ext.getCmp('radioContainer');
				radioContain.suspendEvents();
				radioContain.setValue({'descriptorAggregation':json.showViolatedDescriptors});
				radioContain.setVisible(true);
				radioContain.resumeEvents();
			}
			else {
				Ext.getCmp('radioContainer').setVisible(false);
			}
			conditonPanelObj.down('displayfield#targetcondition').setValue(json.targetOperation);
			conditonPanelObj.down('displayfield#targetvalue').setValue(json.targetValue);
			conditonPanelObj.down('displayfield#target_components').setValue(json.target_components);

			if(json.isMainTestDescBased=='true' && json.isAggTestDescBased=='false') {
				conditonPanelObj.down('displayfield#target_violation_by').setValue(json.target_violation_by);
			}
			else {
				conditonPanelObj.down('displayfield#target_violation_by').setValue('Not Applicable');
			}
		}
		else
		{
			var conditonPanelObj = Ext.getCmp('conditionPanel');
			conditonPanelObj.setVisible(false);
			Ext.getCmp('targetcondition').setVisible(false);
			Ext.getCmp('targetvalue').setVisible(false);
			Ext.getCmp('target_components').setVisible(false);
			Ext.getCmp('target_violation_by').setVisible(false);
			conditonPanelObj.down('displayfield#targetcondition').setValue('Not Applicable');
			conditonPanelObj.down('displayfield#targetvalue').setValue('Not Applicable');
			conditonPanelObj.down('displayfield#target_components').setValue('Not Applicable');
			conditonPanelObj.down('displayfield#target_violation_by').setValue('Not Applicable');
			Ext.getCmp('radioContainer').setVisible(false);
		}
		this.down('container#middleContainer').update(json.infoLine1+'</br>'+json.infoLine2);
		this.down('container#bottomContainer').update(json.aggregateTable);
	}
});