Ext.define('componentDashboard.view.Layers.AlarmDetails',{
	extend:'Ext.window.Window',
	alias:'widget.alarmdetails',
	bodyBorder:false,
	bodyPadding:'10 10 0 10',
	//padding:'4 10 10 10',
	frame:true,
	width:750,
	maxHeight:210,
	minHeight:210,
	height:500,
	scroll:true,
	autoScroll:true,
	title:alarmDetailsTitle1,
	closable:true,
	resizable:false,
	draggable:false,
	modal: true,
	ghost:false,
	closeAction:'hide',
	//	layout:{type:'fit'},
	shadow:'sides',
	shadowOffset:40,
	items:[{
		xtype:'container',
		margin:'5 5 0 5',
		itemId:'informationPanel',
		width:'100%',
		layout:'hbox',
		defaults:{
			margin:5
		},
		items:[{  
			xtype:'fieldcontainer',
			width:'50%',
			defaults:{
				labelWidth:150,
				labelSeparator:''
			},
			items:[{
				xtype:'displayfield',
				fieldLabel:'COMPONENT TYPE',
				itemId:'componentType',
				value:'esx_10.33'
			},{
				xtype:'displayfield',
				fieldLabel:'LAYER',
				itemId:'layer',
				value:'Outside View'
			}]
		},{
			xtype:'fieldcontainer',
			width:'50%',
			defaults:{
				labelWidth:150,
				labelSeparator:''
			},
			items:[{
				xtype:'displayfield',
				fieldLabel:'COMPONENT NAME',
				itemId:'componentName',
				value:'VMWare vSphere ESX'
			},{
				xtype:'displayfield',
				fieldLabel:'MSMT HOST',
				itemId:'measurementHost',
				value:'Disk Space VM'
			}]
		}]
	},{
		xtype:'panel',
		itemId:'bottomContainer',
		cls:'datapanel',
		frame:false,
		margin:'0 0 10 0',
		itemId:'tableHeader',
		title:'Event Details',
		bodyPadding:'0 0 5 0',	
		padding:0,
		//height:83,
		//height:'auto',
		
		items:[{
			xtype:'container',
			//height:'auto',
			//layout:'fit',
			margin:'0 0 0 0',
			padding:0,
			itemId:'tableContainer'
		}]
	},{
		xtype:'panel',
		cls:'datapanel',
		frame:false,
		//cls:'innerblock2',
		id:'acknowledge',
		margin:'10 0 0 0',
		title:'Acknowledgement Details',
		width:'100%',
		bodyPadding:0,
		padding:0,
	//	height:83,
		//layout:'fit',
		items:[{
			xtype:'container',
			margin:'0 0 0 0',
			padding:0,
			itemId:'tableContainerAcknowledge'
		}]
	}],
	
	initComponent:function(){
		this.callParent();
	},
		listeners: {
                    show: function (f) {

                        if (this.modal) {
                            var g = Ext.dom.Query.select(".x-mask");
                            var e = Ext.fly(g[0]);
                            e.addCls("windowModal");
                        }
                    },
                    hide: function (f) {
                        if (this.modal) {
                            var g = Ext.dom.Query.select(".x-mask");
                            var e = Ext.fly(g[0]);
                            e.removeCls("windowModal");
                        }
                    },
                    afterrender: function () {
						
                        Ext.EventManager.onWindowResize(function () {
                            var e = this;
                            e.center();
                        }, this);
                    }
                },
	setData:function(json){
		this.down('displayfield#componentType').setFieldLabel(json.screenLabels.componentType);
		this.down('displayfield#componentType').setValue(json.componentType);

		this.down('displayfield#componentName').setFieldLabel(json.screenLabels.componentName);
		this.down('displayfield#componentName').setValue(json.componentName);

		this.down('displayfield#layer').setFieldLabel(json.screenLabels.layer);
		this.down('displayfield#layer').setValue(json.layer);

		this.down('displayfield#measurementHost').setFieldLabel(json.screenLabels.measurementHost);
		this.down('displayfield#measurementHost').setValue(json.measurementHost);
	}
});