Ext.define('headerbutton',{
	extend:'Ext.AbstractPlugin',
	alias: 'plugin.headericons',
	iconCls:'',
	headerButtons: [],
	layersTreeStore:null,
	treePanel:null,
	init:function(panel){
		this.panel = panel;
		this.callParent();
		panel.on('render', this.onHeaderIcons, this);
	},
	onHeaderIcons:function(){
		this.header = this.panel.getHeader();
		
		if(this.header){
			this.header.insert(0, this.headerButtons);
		}
	}
});  //Plugin by feroz

Ext.define('componentDashboard.view.Layers.LayersList', {
			extend : 'Ext.panel.Panel',
			requires : ['componentDashboard.view.Layers.LayersTree'],
			alias : 'widget.layerslist',
			layout : 'fit',
			cls:'layerListPanel',
			plugins:[{
                    ptype: "headericons",
					headerButtons : [
                        {
                            xtype : 'button',
							iconCls:'iconComponent_GRAY',
							cls:'overflowBt layer_state_button',
							margin:'0 5 0 0',
							style:{background:'none',border:'0px'},
							itemId:'compoentDetails'
                        }
                    ]
                }],
			jsonData : null,
			jsonMoreInfoData:null,
			jsonErrData:null,
			emptyText:'No Data',
			autoDestroy:true,
			border : true,
			screenLabels : null,
			title : null,
			margin :'1 0 5 5',
			//flex:0.5,
			width:450,
			padding:0,
			header:{
				padding:0,
				height:32/*F*/
			},
			bodyPadding:0,
			//style:{'border':'1px solid yellow'},
			cls : 'layers-list',
			bodyCls : 'bottom-left-radius bottom-right-radius top-left-radius top-right-radius',
			initComponent : function() {
				
				var me = this;
				/*layersTreeStore = Ext.create('Ext.data.TreeStore', {
							root : me.jsonData,				// Display layer Structure
							batchUpdateMode:'complete'
						});
				treePanel = Ext.create('componentDashboard.view.Layers.LayersTree', {
							store : layersTreeStore,
							rootVisible:false,
							border : true,
							//style:{'border':'1px solid orange'},
						});
				
				this.items = [treePanel];*/
				this.layersTreeStore=null;
				this.treePanel=null;
				this.loadData();
				this.callParent();
				
			},
			loadData : function() {
				
				var me = this;

				if(me.jsonData!=null && me.jsonData!=undefined && !Ext.isEmpty(me.jsonData) && Ext.isEmpty(me.jsonErrData) )
				{
					if(Ext.isEmpty(this.layersTreeStore) || this.layersTreeStore==null)
					{
						this.layersTreeStore = Ext.create('Ext.data.TreeStore', {
								root : me.jsonData,				// Display layer Structure
								batchUpdateMode:'complete'
							});
					}

					if(Ext.isEmpty(this.treePanel) || this.treePanel==null)
					{
						if(!Ext.isEmpty(requestParams.isMoreInfosTreeView) && (requestParams.isMoreInfosTreeView || requestParams.isMoreInfosTreeView =="true"))
						{
							Ext.apply(me,{bodyCls:'moreinfosbody'});

							this.treePanel = Ext.create('componentDashboard.view.Layers.LayersTree', {
								store : this.layersTreeStore,
								flex:1,
								padding:0,
								margin:0,
								bodyPadding:0,
								viewConfig:{
									padding:0,
									margin:0,
									scroll:true,
									autoScroll:true
								},
								rootVisible:false,
								border : false
							});
							this.items = [
								Ext.create('Ext.panel.Panel',
								{
									layout:{type:'vbox',align:'stretch'},
									ui:'layermodel_moreinfos '+me.jsonMoreInfoData.state,
									border:5,
									header:{
										padding:'4 8',
									},
									tools:[
									{
										xtype:'toolbar',
										width:190,
										items:[
										{
											xtype:'button',
											width:24,
											pressedCls:'empty',
											overCls:'empty',
											focusCls : 'empty',
											height:24,
											scale:'medium',
											iconCls:'iconLiveGraph',
											hidden:(!me.jsonMoreInfoData.VirtualIcon),
											handler:function(){
												//console.log("me.jsonMoreInfoData.virtualURL--->",me.jsonMoreInfoData.virtualURL);
												goToLiveGraph(me.jsonMoreInfoData.virtualURL);
											}
										},
										'->',
										{
											xtype:'button',
											id:'show-search',
											width:24,
											height:24,
											overCls:'empty',
											pressedCls:'empty',
											focusCls : 'empty',
											scale:'medium',
											iconCls:'iconTopologySearch',
											handler:function(btn){
												Ext.getCmp('moreinfos-searchbox').show();
												btn.hide();
											}
										},
										{
											xtype:'triggerfield',
											width:150,
											height:24,
											cls:'whitedropdown_search',
											hidden:true,
											selectOnFocus: true,
											enableKeyEvents:true,
											emptyText:'Search',
											serachUrl:me.jsonMoreInfoData.hiddenvalue+"&currLayerState="+me.jsonMoreInfoData.state,
											treePanel:this.treePanel,
											id:'moreinfos-searchbox',
											onTriggerClick: function(e) {
												Ext.getCmp('moreinfo_search_trigger').onTriggerClick(e)
												//this.fireEvent("ontriggerclick", Ext.getCmp('moreinfo_search_trigger'), e);
											},
											listeners:{
												keyup:function(){
													Ext.getCmp('moreinfo_search_trigger').setValue(this.getValue());
												},
												show:function(field){
													Ext.Function.defer(function(){
														field.focus(true,100);
													},50);
												},
												specialKey : function(field, e){
													// from controller
													Ext.getCmp('moreinfo_search_trigger').fireEvent("specialKey",Ext.getCmp('moreinfo_search_trigger'), e);
													var searchValur = this.getValue();
													if(searchValur != null && searchValur != 'null' && searchValur != '')
														this.show();
													else
													{
														if (e.getKey() == e.ENTER)
														{
															this.hide();
															Ext.getCmp('show-search').show();
															this.setValue("");
														}
													}
												},
												/*blur:function(){
													this.hide();
													Ext.getCmp('show-search').show();
													this.setValue("");
												}*/
											}
										}]
									}
								],
								margin:8,
								flex:1,
								scroll:true,
								autoScroll:false,
								title:'<img style="vertical-align: middle;" src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" class="x-tree-icon '+me.jsonMoreInfoData.iconCls+'"/> '+me.jsonMoreInfoData.text,
								items:[this.treePanel]
							})];
						}
						else
						{
							 this.treePanel = Ext.create('componentDashboard.view.Layers.LayersTree', {
									store : this.layersTreeStore,
									rootVisible:false,
									border : false,
								//	style:{'border':'1px solid orange'}
								});
							this.items = [this.treePanel];
						}
					}
					else if(!Ext.isEmpty(this.treePanel))
					{
						if(!Ext.isEmpty(requestParams.isMoreInfosTreeView) && (requestParams.isMoreInfosTreeView || requestParams.isMoreInfosTreeView =="true"))
						{
							this.treePanel.suspendEvents();
							this.treePanel.setRootNode(me.jsonData);
							this.treePanel.resumeEvents();
							this.treePanel.view.refresh();
						}
						else
						{
							this.treePanel.suspendEvents();
							this.treePanel.setRootNode(me.jsonData);
							this.treePanel.resumeEvents();
							this.treePanel.view.refresh();
						}

						Ext.defer(function(){
							try
							{
								
								if(topPoc!=null && topPoc!=undefined && topPoc!="")
									$("#layerview").scrollTop(topPoc);
							}
							catch (ee)
							{
								console.log("Scroll Top Poc--->",topPoc);
							}
						},1000);
					}
				}
				else if(me.jsonErrData!=null && me.jsonErrData!=undefined &&  !Ext.isEmpty(me.jsonErrData))
				{
					layersErrorPanel = Ext.create('Ext.panel.Panel',{
						cls:'datapanel',
						html:'<div style="text-align:center;margin:50% 0 auto 0"><div class="iconExclamation" style="margin:0 auto"></div>'+me.jsonErrData+'</div>',
						width:450,
						layout:'fit',
						height:'100%',
						margin:'0 0 5 0'
					});
					this.items = [layersErrorPanel];
				}

				me.jsonData = null;
			}
		});