Ext.define('componentDashboard.view.system.CompDashHistoryTab', {
	extend: 'Ext.panel.Panel',
	alias:'widget.compdashhistorytab',
	layout:'fit',
	items : [],
	autoScroll:false,
	graphType:null,
	url:null,
	starttime:null,
	endtime:null,
	timeline:null,
	jsonData:null,
	starthr:null,
	cls:'history-tab-panel-bg',
	bodyCls:'history-tab-panel-bg',
	endhr:null,
	minHeight:500,
	setData:function()
	{
			var me = this;
			var params = {};
			if(me.graphType==null)
				me.graphType='measureGraph';
			var controller=componentDashboard.app.getController('SystemController');
			if(this.timeline==null)
				this.timeline=controller.timeLineInfo.data[0].selected;
			if(this.starttime==null)
				this.starttime=controller.timeLineInfo.data[1].value;
			if(this.endtime==null)
				this.endtime=controller.timeLineInfo.data[3].value;
    	   	if(this.timeline!=null)params['time_line']=this.timeline;
    	   	if(this.starttime!=null)params['starttime']=this.starttime;
    	   	if(this.endtime!=null)params['endtime']=this.endtime;
    	   	if(this.starthr!=null)params['starthr']=this.starthr;
    	   	if(this.endhr!=null)params['endhr']=this.endhr;
    	   	params['screenWidth']= Ext.getBody().getViewSize().width - 200;
    	 	params['screenHeight']= Ext.getBody().getViewSize().height - 150;
			var urlchanged=me.url+'&graphType='+me.graphType+'&showGraph='+me.graphType;
			var wholeViewport = document.getElementsByTagName("body")[0];
			if(!Ext.isEmpty(Ext.get(wholeViewport))){
				mask = new Ext.LoadMask(Ext.get(wholeViewport), {msg:"Loading...",cls:'maskDash'});
				mask.show();
			}
			Ext.Ajax.request({
				url : urlchanged,
				scope : this,
				method : 'GET',
				params : params,
				success : function(response, opts){
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					me.jsonData=jsonData;
					var chartItems = new Array();
					if(!Ext.isEmpty(jsonData.Uptime))
					{
						for(var i=0;i<jsonData.Uptime.Grids.length;i++)
						{
							chartItems.push(this.returnDiskGrid(jsonData.Uptime.Grids[i],1/3));
						}
					}
					var chartLength = jsonData.History.length;
					var columnWidth = 1/3;
					for(var i=0;i<chartLength;i++){
						if(!Ext.isEmpty(jsonData.History[i].Graph))
						{
							if(jsonData.History[i].Graph.GraphType=='measureGraph')
								chartItems.push(this.returnChart(jsonData.History[i],columnWidth,"HistoryTab"+i));
							else if(jsonData.History[i]!='undefined')
								chartItems.push(this.charts(jsonData.History[i],columnWidth,"HistoryTab"+i));
						}
					}
					var chartPanel;
					if(chartItems.length>0)
					{
						chartPanel = {
								xtype : 'panel',
								layout : 'column',
								align: 'center',
								columnWidth : 1,
								bodyCls:'history-tab-panel-bg history-mask',
								cls : 'header-image details-history-header-image',
								items : chartItems
						};
					}
					else
					{
						chartPanel = Ext.create('ErrorPanel',{
							errorMsg : '<div style="text-align:center;"><img src="/final/images/clear.png" class="list-empty" /><br/><div class="list-empty-text">'+ jsonData.History[0].errorMsg +'</div></div>',
							layout:'fit',
							align:'center'
						});
					}
	        		this.add(chartPanel);
	        		if(!Ext.isEmpty(mask)){
	        			mask.hide();}
				},
				failure : function(){
					//alert("failure");
					}
			});
		
		},
		returnChart : function(jsondata,columnWid,id){
			var chartPanel;
			chartPanel = {
						xtype : 'panel',
						border:false,
						html : '<div style="width:100%;height:100%;"class="systemTab-bg"><img id="'+id+'" src = "'+jsondata.Graph.GraphFile+'" onload="graphload(\''+id+'\');"/></div>',
						cls : 'history-tab-header-image history-tab-header',
						bodyCls:'history-tab-panel-bg',
						columnWidth : columnWid,
						layout : 'fit',
						minHeight : 230,
						type:'fusion',
						title : jsondata.title,
						padding:'5 5 7 0'
				}
			return chartPanel;
		},
		charts:function(jsondata,columnWid,id)
		{
			var htmlstring,titlemodified,chartPanel;
			if(!jsondata.errorMsg)
			{
				htmlstring = this.returnChartHTML(jsondata.Graph,id);
				chartPanel = {
					xtype : 'panel',
					border:false,
					height : 260,
					html : htmlstring,
					cls : 'header-image',
					bodyCls:'history-tab-panel-bg',
					type:'flash',
					//title : jsondata.title,
					//layout:'column',
					columnWidth : columnWid,
					padding:'5 5 7 5',
					tbar: this.titlemodified(jsondata)
				}
			}
			return chartPanel;	
		},
		returnChartHTML :function(jsonData,id){
			var htmlstring;
			htmlstring = '<div style="width:100%; height:100%;" class="systemTab-bg">'
			+'<object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="//fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0" width="90%" height="90%" id="'+id+'" flashVars="&dataXML='+ jsonData.dataXML +'&chartWidth= "90%" &chartHeight= "90%"  align="center" valign="middle">'
			+'<param name="FlashVars" value="&dataXML='+ jsonData.dataXML +'&chartWidth= "90%" &chartHeight= "90%"/>'
			+'<param name="quality" value="high" />'
			+'<param name="WMode" value="Transparent"/>'
			+'<param name="movie" value="/final/FusionCharts/swf/'+jsonData.GraphFile+'" />'
			+'<embed wmode="transparent" src="/final/FusionCharts/swf/'+jsonData.GraphFile+'" flashVars="&dataXML='+jsonData.dataXML+'&chartWidth= "90%" &chartHeight= "90%" quality="high" width="90%" height="90%" align="center" valign="middle" name="'+ jsonData.GraphFile +'Name" type="application/x-shockwave-flash" pluginspage="//www.macromedia.com/go/getflashplayer"/>'
			+'</object>'
			+'</div>';
			return htmlstring;
		},
		titlemodified:function(jsondata){
			var returnArray=new Array();
			returnArray[0]={
					xtype: 'label',
			        text: jsondata.title,
			        align: 'center',
			        margin: '5 0 0 0',
			        padding:'5 5 7 15',
			        maxWidth: 200,
			        cls: 'history-tab-label history-tab-header'
			};
			var combodata=jsondata.Combo;
			if(!Ext.isEmpty(combodata))
			{
				var comboStore=Ext.create('Ext.data.Store',{
					fields:['name','value'],
				    proxy: {
				        type: 'memory',
				        reader: {
				            type: 'json',
				            root:'items'
				        }
				    },
				    data:combodata
				});
	//			for(j=0;j<combodata.items.length;j++)
	//			{
				returnArray[1]={
						xtype:'tbfill'
				};	
				returnArray[2]={
							xtype:'combo',
							store:comboStore,
				    	   name:combodata.Name,
				    	   id:combodata.Name,
				    	   editable:false,
				    	   //margin:'5 5 0 70',
				    	   displayField:'name',
				    	   valueField:'value',
				    	   value:combodata.items[0].value,
				    	   width:120,
				    	   cls:'dropdown'
					};
				//}
				
			}
			return returnArray;
		},
		returnDiskGrid : function(json,col){
			
			var fieldsArray = new Array();
			var diskTable;
			if(Ext.isEmpty(json.errorMsg)){
				if(!Ext.isEmpty(json.headers))
				{
					for(var i=0 ; i<json.headers.length ; i++){
						fieldsArray.push("value"+i);
					}
				}
				else
				{
					for(var i=0 ; i<2 ; i++){
						fieldsArray.push("value"+i);
					}
				}
			var tempStore = Ext.create('Ext.data.Store', {
			    fields : fieldsArray,
			    proxy: {
			    	type: 'memory',
			         reader: {
			             type: 'json',
			             root: 'valueArray'
			         }
			     },
			     data :json.items
			 });
			var columnsArray = new Array();
			var flag;
			if(!Ext.isEmpty(json.headers))
			{
				for(var i=0 ; i<json.headers.length ; i++){
					columnsArray.push({  
						text: json.headers[i].name,
						flex:1,
						dataIndex: "value"+i,
						menuDisabled :true
					});
				}
				flag=false;
			}
			else{
				for(var i=0 ; i<2 ; i++){
					columnsArray.push({  
						text: 'Data',
						flex:1,
						dataIndex: 'value'+i,
						menuDisabled :true
					});
				}
				flag=true;
			}
			 diskTable = {
					xtype :'customgrid',
					hideHeaders:flag,
					store : tempStore,
					border :true,
					columns : columnsArray,
					cls:'grid-header-position'
			};
			 col=0.5;
			}
		else{
			diskTable = this.errorPanelNoTitle(json.errorMsg);
		}
		var diskTablePanel = {
				xtype : 'panel',
				layout :'fit',
				title : json.title,
				cls : 'header-image-grid',
				padding :10,
				height: 200,
				columnWidth : col,
				bodyCls:'systemTab-bg grid-border',
				items : [diskTable]

		};
		
		return 	diskTablePanel;
		
		},
		errorPanelNoTitle:function(errorMsg){

			return Ext.create('Ext.panel.Panel',{
				bodyCls : 'grid-border',
				border : false,
				html : '<div style="text-align:center;padding:30px; top:100px ; height:155px" class="system-error-bg"><img src="/final/images/clear.png" class="list-empty system-error-bg" /><br/><div class="list-empty-text system-error-bg">'+errorMsg+'</div></div>'
			});
		}
});