Ext.define('componentDashboard.view.system.TimeLine', {
	extend: 'Ext.window.Window',
	alias:'widget.timeline',
	header:true,
	resizable: false,
	width: 350,
	items:[],
	layout:'fit',
	data:null,
	closeAction:'hide',
	jsonData:null,
	cls:'measure-graph-panel',
	initComponent:function(){
		var tempPanel = this.setData(this.jsonData);
		this.items = [tempPanel];
		this.callParent();
	},
	setData : function(jsonData){
		var rightTopPanel;
		if(!Ext.isEmpty(jsonData.TimelineWindow)){
			 rightTopPanel = {
				xtype : 'panel',
				layout:'column',
				//columnWidth: 0.4,
				header:false,
				border:false,
				items:[{
					xtype:'combo',
					padding:10,
					store: Ext.create('Ext.data.Store',{
						fields:['value','name'],
						proxy:{
							type: 'memory',
							reader: {
								type: 'json',
								root:'Measures'
							}
						},
						data:jsonData.TimelineWindow[0].items
					}),
					displayField:'name',
					name:'timeline',
					cls:'dropdown',
					valueField:'value',
					value: jsonData.TimelineWindow[0].selected, 
					editable:false,
					action:'timeline'
				},{
					xtype:'datefield',
					labelWidth:40,
					padding:10,
					width:170,
					cls:'datepicker',
					format:'M d, Y',
					editable:false,
					value: new Date(jsonData.TimelineWindow[1].value),
					fieldLabel: jsonData.TimelineWindow[1].name,
					action:'starttime',
					disabled:true
				},{
					xtype:'combo',
					padding:10,
					labelWidth:20,
					width:90,
					store: Ext.create('Ext.data.Store',{
						fields:['value','name'],
						proxy:{
							type: 'memory',
							reader: {
								type: 'json',
								root:'StartHours'
							}
						},
						data:jsonData.TimelineWindow[2].items
					}),
					fieldLabel: jsonData.TimelineWindow[2].name,
					displayField:'name',
					cls:'dropdown',
					valueField:'value',
					editable:false,
					value: new Date().getHours(),
					action:'starthour',
					disabled:true
				},{
					xtype:'datefield',
					labelWidth:40,
					padding:10,
					width:170,
					cls:'datepicker',
					editable:false,
					format:'M d, Y',
					value: new Date(jsonData.TimelineWindow[3].value),
					fieldLabel: jsonData.TimelineWindow[3].name,
					action:'endtime',
					disabled:true
				},{
					xtype:'combo',
					padding:10,
					labelWidth:20,
					width:90,
					store: Ext.create('Ext.data.Store',{
						fields:['value','name'],
						proxy:{
							type: 'memory',
							reader: {
								type: 'json',
								root:'EndHours'
							}
						},
						data:jsonData.TimelineWindow[4].items
					}),
					fieldLabel: jsonData.TimelineWindow[4].name,
					displayField:'name',
					cls:'dropdown',
					valueField:'value',
					editable:false,
					value: new Date().getHours(),
					action:'endhour',
					disabled:true
				}
				,{
					xtype:'button',
					action:'submit',
					margin: 10,
					padding:10,
					hidden:true,
					cls:'iconMinViewNew'
				}]
			};
		}
		return rightTopPanel;
		
	}
});