Ext.define('componentDashboard.view.virtual.MeasureTab', {
	extend: 'Ext.panel.Panel',
	alias:'widget.measuretab',
	bodyCls : 'systemTab-bg',
	layout : {
		type:'vbox',
		align:'stretch'
	},
	items:[],
	createTabUI : function(jsonData){
	
		if(Ext.isEmpty(jsonData.viewComboSelected)){
		var panelItems = new Array();
		for(var i=0 ; i<jsonData.tableData.length ; i++){
			var mask;
			var wholeViewport = document.getElementsByTagName("body")[0];
	    	if(!Ext.isEmpty(Ext.get(wholeViewport))){
				mask = new Ext.LoadMask(Ext.get(wholeViewport), {msg:"Loading...",cls:'maskDash'});
				mask.show();
			}
				//panelItems.push(this.createGridLikePanel(jsonData.tableData[i]));
				this.add(this.createGridLikePanel(jsonData.tableData[i]));
				if(!Ext.isEmpty(mask)){
					mask.hide();}
				}
		}
		//this.add(panelItems);
		
		else if(jsonData.viewComboSelected== -1){
			this.add(this.errorPanelNoTitle(jsonData.NoDataAvailable.errorMessage));
		}
	},
	
	createGridLikePanel : function(panelData){
		
		var dockedItemsArray = new Array();
		var defLink ='#';
		var hrefLink = (!Ext.isEmpty(panelData.headerLink))?panelData.headerLink:defLink;
		
		var headerBox = {
				xtype:'container',
				items:[{
					xtype : 'label',
					html : '<div class="state_'+panelData.iconCls+'"></div>'/*,
					flex:.1*/
				},{
					xtype : 'label',
					cls:'measureTab-headerTop',
					padding:' 0 5 5 0',
					html : '<a href="'+ hrefLink+'">'+panelData.headerText+'</a>'/*,
					flex:1*/
				}],
			//	flex : 1,
				layout:'hbox'
		}
		dockedItemsArray.push(headerBox);
		dockedItemsArray.push('->');
		dockedItemsArray.push({
			xtype : 'label',
			text : panelData.header
		//	flex:1
		});
		dockedItemsArray.push('->');
		if(!Ext.isEmpty(panelData.infoImg)){
			dockedItemsArray.push({
				xtype : 'button',
				action:'info',
				cls:'measure-toolbar-plainButton ',
				html :'<div class="iconInfo"></div>',
				functParam : panelData.infoParam 
			});
		}
		
	if(!Ext.isEmpty(panelData.helpImg)){
		dockedItemsArray.push({
				xtype : 'button',
				action:'help',
				cls:'measure-toolbar-plainButton ',
				html : '<div class="iconHelp"></div>',
				functParam : panelData.helpParam
			});
		}
	
	/*	var buttonBox = {
				xtype:'container',
				items:boxItem,
				flex : .25,
				layout:'hbox'
		};*/
		//dockedItemsArray.push(buttonBox);
		var panelItemsArray=new Array();
		var calcHeight =40;
		if(!Ext.isEmpty(panelData.data)){
			
			if(Ext.isEmpty(panelData.headers)){
				panelItemsArray = this.createPanelItems(panelData.data);
				 calcHeight = panelData.data.length*38 + 30;
			}
			else{
				panelItemsArray = this.returnMeasureGrid(panelData);
				 calcHeight = 150;
			}
	}
		
			var specialPanel = {
				xtype:'panel',
				bodyCls : 'systemTab-bg',
				padding:'10 0 0 0',
				dockedItems:[{
					xtype : 'toolbar',
					cls : 'component-list-right-panel-header component-list-right-panel-header-right',
					//layout : 'hbox',
					height : 25,
					flex : 1,
					items : dockedItemsArray
				}],
				//layout:'vbox',
				height : calcHeight,
				items:panelItemsArray
		};
		return specialPanel;
	},
	createPanelItems : function(itemData) {
						var itemsArray = new Array();
						for ( var i = 0; i < itemData.length; i++) {
							var innerLabelArray = new Array();
							var htmlString ;
							innerLabelArray.push({
									xtype : 'container',
									items : [{
										xtype : 'label',
										padding:5,
										width:20,
										html:(!Ext.isEmpty(itemData[i][0].state))?'-1-<div style="width:20px ;margin-left:7px !important; float:left;" class=state_'+itemData[i][2].state+'></div style="padding-top:3px;"><div>'+itemData[i][0].data+'</div>':'-2-<div style="padding-top:3px;">'+itemData[i][0].data+'</div>',
										flex : 1
									}/*, {
										xtype : 'label',
										padding:'8 0 0 10',
										//cls:'virtual-measure-label',
										text : itemData[i][0].data,
										html:(!Ext.isEmpty(itemData[i][0].param1))?'<a  href="javascript:chekWindow(\''+itemData[i][0].param1+'\',\''+itemData[i][0].param2 +
												'\')">'+itemData[i][0].data+'</a>':'<a>'+itemData[i][0].data+'</a>',
										flex : 1
									}*/, {
										xtype : 'label',
										padding:5,
										text : ':',
										flex : .25
									}, {
										xtype : 'label',
										padding:'8 0 0 10',
									//	text : itemData[i][1].data,
										html:(!Ext.isEmpty(itemData[i][1].param1))?'-3-<a  href="javascript:chekWindow(\''+itemData[i][1].param1+'\',\''+itemData[i][1].param2 +'\')">'+itemData[i][1].data+'</a>':'-4-<a>'+itemData[i][1].data+'</a>',
										flex : .75
									} ],
									flex : 1,
									layout : {type:'hbox',align:'stretch'}
								});
								innerLabelArray.push({
									xtype : 'container',
									items : [{
										xtype : 'label',
										padding:5,
										width:20,
										html:(!Ext.isEmpty(itemData[i][2].state))?'-5-<div style="width:20px ;margin-left:7px !important; float:left;" class=state_'+itemData[i][2].state+'></div style="padding-top:3px;"><div>'+itemData[i][2].data+'</div>':'-6-<div style="padding-top:3px;"></div>',
										flex : 1
									}/*, {
										xtype : 'label',
										padding:'8 0 0 10',
									//	cls:'virtual-measure-label',
										text : itemData[i][2].data,
										html:(!Ext.isEmpty(itemData[i][2].param1))?'<a  href="javascript:chekWindow(\''+itemData[i][2].param1+'\',\''+itemData[i][2].param2 +
												'\')">'+itemData[i][2].data+'</a>':'<a>'+itemData[i][2].data+'</a>',
										flex : 1
									}*/, {
										xtype : 'label',
										padding:5,
										text :(itemData[i][2].data==' ')?'' : ':',
										flex : .25
									},{
										xtype : 'label',
										padding:'8 0 0 10',
									//	text : itemData[i][3].data,
										html:(!Ext.isEmpty(itemData[i][3].param1))?'-7-<a  href="javascript:chekWindow(\''+itemData[i][3].param1+'\',\''+itemData[i][3].param2+'\')">'+itemData[i][3].data+'</a>':'-8-<a>'+itemData[i][1].data+'</a>',
										flex : .75
									} ],
									flex : 1,
									layout : 'hbox'
								});
						

							var singleRowBox = {
								xtype : 'container',
								items : innerLabelArray,
								flex : 1,
								layout : 'hbox'
							};
							itemsArray.push(singleRowBox);
						}
						return itemsArray;
					},
					
	returnMeasureGrid : function(json){
						
						var fieldsArray = new Array();
						var measureTable;
						var dataArray = new Array();
						for(var j=0 ; j<json.data.length ; j++){
							var rowObject = new Object();
							for(var k=0 ; k<json.data[j].length ; k++){
								rowObject['data'+k] =json.data[j][k].data;
								if(k==0){
									rowObject['link'] = (!Ext.isEmpty(json.data[j][k].link))?json.data[j][k].link:''
									}
							}
							dataArray.push(rowObject);
						}
						
						for(var i=0 ; i<json.headers.length ; i++){
								fieldsArray.push('data'+i);
							}
						fieldsArray.push('link' );
						var tempStore = Ext.create('Ext.data.Store', {
						    fields : fieldsArray,
						    proxy: {
						    	type: 'memory',
						         reader: {
						             type: 'json',
						             root: 'data'
						         }
						     },
						     data :dataArray
						 });
						var columnsArray = new Array();
						for(var i=0 ; i<json.headers.length ; i++){
							columnsArray.push({  
								text: json.headers[i].data,
								flex:(i==0)?6:1,
								dataIndex: 'data'+i,
								menuDisabled :true,
								renderer:function(value,metaData,record,rowIndex,colIndex){
									var defLink ='#';
									var hrefLink = (!Ext.isEmpty(record.data.link))?record.data.link:defLink;
									return  '<div class = "zoneuser-left"><a href="'+ hrefLink+'">'+value+'</a></div>';
						   }

							});
						}
						
						measureTable = {
								xtype :'customgrid',
								store : tempStore,
								border :true,
								columns : columnsArray,
								bodyCls : 'grid-different-bg',
								cls:'grid-header-position'
						};
					
						return 	measureTable;
						
					},
	errorPanelNoTitle:function(errorMsg){

		return Ext.create('Ext.panel.Panel',{
			bodyCls : 'grid-border',
			border : false,
			html : '<div style="text-align:center;padding:30px; top:100px ; height:155px" class="system-error-bg"><img src="/final/images/clear.png" class="list-empty system-error-bg" /><br/><div class="list-empty-text system-error-bg">'+errorMsg+'</div></div>'
		});
	}
});