
Ext.define('componentDashboard.view.virtual.Measures',{
	extend : 'Ext.panel.Panel',
	requires:['Ext.layout.container.Fit','componentDashboard.view.virtual.MeasuresGrid','componentDashboard.store.virtual.Measures'],
	alias:'widget.insidemeasures',
	layout:'fit',
	url : null,
	border:true,
	header:false,
	screenLabels:null,
	bodyPadding:0,
	padding:0,
	frame:false,
	cls:'insideViewMeasuresOuter',
	measureGrid:null,
	onRender : function(){
		this.callParent();
		this.refreshData(true);
	},
	changeUrl : function(newUrl){
		this.url=newUrl;
	},
	refreshData : function(updateLabels){
		var me = this;

		if(!Ext.isEmpty(this.getEl())){
			this.getEl().mask("Loading...","maskCenter");
		}
		Ext.Ajax.request({
			url : this.url+'&isFromVirtualInside=true',
			scope:this,
			disableCaching:false,
			success: function(response){
				this.removeAll(true);
				if(this.getDockedComponent('insidetestInfoToolbar')){
					this.removeDocked(this.getDockedComponent('insidetestInfoToolbar'),true);
				}
				if(this.getDockedComponent('titleInfoToolbar')){
					this.removeDocked(this.getDockedComponent('titleInfoToolbar'),true);
				}
				
				this.measureGrid=null;
				if(this.getDockedComponent('insidetestInfoToolbar')){
					this.removeDocked(this.getDockedComponent('insidetestInfoToolbar'),true);
				}
				var jsonText = null;
				jsonText = response.responseText;

				var jsonData = null;
				jsonData=Ext.decode(jsonText);

				jsonText = null;
				delete jsonText;
				Ext.destroy(jsonText);

				if(!Ext.isEmpty(jsonData.screenLabels)){
					var measuresTitle = jsonData.screenLabels["Measurements"] ? "&nbsp;" : "Measurements";
					if(!Ext.isEmpty(jsonData.screenLabels["LastMeasurementTime"])){
						measuresTitle += "<span>" + jsonData.screenLabels["LastMeasurementTime"] + " <img height='20' style='position:relative;top:5px;left:5px;width:10px' src='/final/images/clear.png' class='userProfileSeparator'/> </span>";
					}

					if(!Ext.isEmpty(Ext.getCmp('heading')))
					{
						if(!Ext.isEmpty(requestParams.isMoreInfosTreeView) && (requestParams.isMoreInfosTreeView || requestParams.isMoreInfosTreeView =="true"))
						{
							Ext.getCmp('heading').update("<div class='layerModelMeasureTime'>" + measuresTitle + "<span ><img style='margin-top:-7px;vertical-align:middle;' class='iconClose_moreinfo mouse' src='/final/images/clear.png' onclick='closeMoreInfoLayerTreePopUp();'/></span></div>");
						}
						else
						{
							Ext.getCmp('heading').update("<div class='layerModelMeasureTime'>" + measuresTitle + "</div>");
						}
					}
					else if(!Ext.isEmpty(Ext.getCmp('layerPopupMeasurementTime')))
					{
						if(!Ext.isEmpty(requestParams.isMoreInfosTreeView) && (requestParams.isMoreInfosTreeView || requestParams.isMoreInfosTreeView =="true"))
						{
							Ext.getCmp('layerPopupMeasurementTime').update("<div class='layerModelMeasureTime'>" + measuresTitle + "<span ><img style='margin-top:-7px;vertical-align:middle;margin-right:-16px' class='iconClose_moreinfo mouse' src='/final/images/clear.png' onclick='closeMoreInfoLayerTreePopUp();'/></span></div>");
						}
						else
						{
							Ext.getCmp('layerPopupMeasurementTime').update("<div class='layerModelMeasureTime'>" + measuresTitle + "</div>");
						}
					}
				}

				if(!Ext.isEmpty(jsonData.testInfo)){
					this.suspendEvents(true);
					var lastMeasurementTimeVar = '';
					if(!Ext.isEmpty(jsonData.screenLabels.LastMeasurementTime)){
						lastMeasurementTimeVar = jsonData.screenLabels.LastMeasurementTime;
					}
					var measuresToolbar = Ext.create('Ext.toolbar.Toolbar',{
						xtype : 'toolbar',
						cls:'insideViewMeasuresToolbar',
						margin:'0 0 0 0',
						itemId : 'insidetestInfoToolbar',
						items : ["->",{
							xtype : 'container',
							shrinkWrap:1,
							style:{'white-space': 'nowrap','overflow':' hidden','text-overflow':' ellipsis','aligh':'right','padding':'2px 0px 0px 0px'},
							id: 'insidetestInfoToolbarId',
							html : '<span class="font_normal11">'+lastMeasurementTimeVar+'</span>'
							}]
					});

					if(!Ext.isEmpty(jsonData.stackInfo)){
						measuresToolbar.add({xtype: 'tbseparator'},{
								xtype : 'label',
								id: 'insidestackInfoId',
								margin : '0 0 0 10',
								html : '<a href="javascript:void(0)" data-qtip="Stack Trace" data-qclass="yellowTip" onclick="stackTraceClicked(\''+jsonData.stackInfo.urlParam1+'\',\''+jsonData.stackInfo.urlParam2+'\')"><img class="iconStackTrace" style="margin-top:2px" src="/final/images/clear.png" /></a>'
						},{xtype: 'tbseparator'});
					}
					if(!Ext.isEmpty(jsonData.Logon_Details_Support)){
						measuresToolbar.add({
								xtype : 'label',
								id: 'insideLogon_DetailsId',
								margin : '0 0 0 10',
								html : '<a href="javascript:void(0)" data-qtip="'+jsonData.Logon_Details_Support.logonTooltip+'" data-qclass="yellowTip" onclick="LogonDetailsPopUp(\''+jsonData.Logon_Details_Support.urlParam1+'\',\''+jsonData.Logon_Details_Support.titleforLogon+'\')"><img class="iconLogonDetails mouse" style="margin-top:2px" src="/final/images/clear.png" /></a>'
						});
					}

					if(!Ext.isEmpty(jsonData.detailInfo))
					{
						if(!Ext.isEmpty(jsonData.detailInfo["methodSuper"]) && jsonData.detailInfo["methodSuper"]==true)
						{
							if(!Ext.isEmpty(requestParams.isMoreInfosTreeView) && (requestParams.isMoreInfosTreeView || requestParams.isMoreInfosTreeView =="true"))
							{
								measuresToolbar.add({xtype: 'tbseparator'},{
									xtype : 'label',
									id: 'insidedetailInfoId',
									margin : '0 0 0 0',
									html : '<a href="javascript:void(0)" data-qtip="'+detailInfoLbl+'" data-qclass="yellowTip" onclick="parent.detailsClicked("'+encodeURI(jsonData.detailInfo["urlParam1"])+'","'+encodeURI(jsonData.detailInfo["urlParam2"])+'","'+encodeURI(jsonData.detailInfo["urlParam3"])+'")"><img class="iconInfo" src="/final/images/clear.png" style="margin-top:2px" /></a>'
								},{xtype: 'tbseparator'});
							}
							else
							{
								measuresToolbar.add({xtype: 'tbseparator'},{
									xtype : 'label',
									id: 'insidedetailInfoId',
									margin : '0 0 0 0',
									html : '<a href="javascript:void(0)" data-qtip="'+detailInfoLbl+'" data-qclass="yellowTip" onclick="detailsClicked("'+encodeURI(jsonData.detailInfo["urlParam1"])+'","'+encodeURI(jsonData.detailInfo["urlParam2"])+'","'+encodeURI(jsonData.detailInfo["urlParam3"])+'")"><img class="iconInfo" src="/final/images/clear.png" style="margin-top:2px" /></a>'
								},{xtype: 'tbseparator'});
							}
						}
						else
						{
							if(!Ext.isEmpty(requestParams.isMoreInfosTreeView) && (requestParams.isMoreInfosTreeView || requestParams.isMoreInfosTreeView =="true"))
							{
								measuresToolbar.add({xtype: 'tbseparator'},{
									xtype : 'label',
									id: 'insidedetailInfoId',
									margin : '0 0 0 0',
									html : '<a href="javascript:void(0)"  data-qtip="'+infoLbl+'" data-qclass="yellowTip" onclick=parent.detailsClicked("'+encodeURI(jsonData.detailInfo["urlParam1"])+'","'+encodeURI(jsonData.detailInfo["urlParam2"])+'","'+encodeURI(jsonData.detailInfo["urlParam3"])+'")><img class="iconInfo" style="margin-top:2px" src="/final/images/clear.png"/></a>'
								},{xtype: 'tbseparator'});
							}
							else
							{
								measuresToolbar.add({xtype: 'tbseparator'},{
									xtype : 'label',
									id: 'insidedetailInfoId',
									margin : '0 0 0 0',
									html : '<a href="javascript:void(0)"  data-qtip="'+infoLbl+'" data-qclass="yellowTip" onclick=detailsClicked("'+encodeURI(jsonData.detailInfo["urlParam1"])+'","'+encodeURI(jsonData.detailInfo["urlParam2"])+'","'+encodeURI(jsonData.detailInfo["urlParam3"])+'")><img class="iconInfo" style="margin-top:2px" src="/final/images/clear.png"/></a>'
								},{xtype: 'tbseparator'});
							}
						}
					}

					if(!Ext.isEmpty(jsonData.helpInfo)){
						if(!Ext.isEmpty(jsonData.helpInfo["methodSuper"]) && jsonData.helpInfo["methodSuper"]==true){
							measuresToolbar.add({
								xtype : 'label',
								id: 'insidehelpInfoId',
								margin : '0 0 0 0',
								html : '<a href="javascript:void(0)" data-qtip="'+helpLbl+'" data-qclass="yellowTip" onclick=HelpWin_Sm("'+encodeURI(jsonData.helpInfo["urlParam1"])+'","'+encodeURI(jsonData.helpInfo["urlParam2"])+'")><img class="iconLayermodelHelp" style="margin-top:0px" src="/final/images/clear.png"/></a>'
							});
						} else {
							measuresToolbar.add({
								xtype : 'label',
								id: 'insidehelpInfoId',
								margin : '0 5 0 0',
								html : '<a href="javascript:void(0)"  data-qtip="'+helpLbl+'" data-qclass="yellowTip" onclick=HelpWin("'+encodeURI(jsonData.helpInfo["urlParam1"])+'")><img style="margin-top:5px;" class="iconLayermodelHelp" src="/final/images/clear.png"/></a>'
							});
						}
					};

					var timelineToolbar = Ext.create('Ext.toolbar.Toolbar',{
						xtype : 'toolbar',
						cls:'insideViewMeasuresToolbar2',
						margin:'0 0 0 0',
		        		itemId : 'titleInfoToolbar',
						padding:5,
		        		items : [{
		        			xtype : 'container',
							width:'100%',
							shrinkWrap:1,
							style:{'white-space': 'nowrap','overflow':' hidden','text-overflow':' ellipsis'},
							html : '<img class="state_'+jsonData.testInfo["State"]+'" src="/final/images/clear.png" style="vertical-align:middle;margin-left:4px;margin-right:10px;"/><span class="font_bold11" data-qtip="'+jsonData.testInfo["Testname"]+(jsonData.testInfo["TestDesc"]?jsonData.testInfo["TestDesc"]:"")+(jsonData.testInfo["unit"]?"("+jsonData.testInfo["unit"]+")":"")+'" data-qclass="yellowTip">'+jsonData.testInfo["Testname"]+(jsonData.testInfo["TestDesc"]?jsonData.testInfo["TestDesc"]:"")+(jsonData.testInfo["unit"]?"("+jsonData.testInfo["unit"]+")":"")+'</span>'
						}]
					});

		        	this.addDocked(measuresToolbar);
		        	this.addDocked(timelineToolbar);
					this.resumeEvents(true);
		        }
		        if(!Ext.isEmpty(jsonData.errormsg)){
		        	var msgPanel = Ext.create('utilities.ErrorPanel',{
		        		bodyCls : 'bottom-left-radius bottom-right-radius',
						errorMsg : '<div style="text-align:center;margin-top:25%"><div class="iconInformation" style="margin:0 auto"></div>'+jsonData.errormsg["msg"]+'</div>'
		        		});

		        	this.add(msgPanel);
		        } else if(!Ext.isEmpty(jsonData.gridInfo)){
		        	var insideMeasureStore = null;
		        	var measureConfig = null;
		        	if(!Ext.isEmpty(jsonData.groupingGrid) && (jsonData.groupingGrid==true || jsonData.groupingGrid=='true')){
		        		insideMeasureStore = Ext.create('componentDashboard.store.virtual.Measures',{
		        			data : jsonData,
		        			groupField : "groupingIndex",
							remoteGroup: true
		        		});
		        		measureConfig={store:insideMeasureStore,features: [{ftype:'grouping',collapsible:false,groupHeaderTpl: '<span style="padding-left:5px">{name}</span>'}]};
		        	} else {
		        		insideMeasureStore = Ext.create('componentDashboard.store.virtual.Measures',{
		        			data : jsonData,
						sortOnLoad : false
		        		});
			        	measureConfig={store:insideMeasureStore};
		        	}
			        this.insideMeasureGrid=Ext.create('componentDashboard.view.virtual.MeasuresGrid',measureConfig);
					this.add(this.insideMeasureGrid);
				}
				else if(!Ext.isEmpty(jsonData.unknownInfo))
				{
					var unknownGridInfo = jsonData.unknownInfo;
					var propertyGridSource = {};
					for(var sourceCounter = 0 ; sourceCounter < unknownGridInfo.length ; sourceCounter++){
						propertyGridSource[""+unknownGridInfo[sourceCounter]["key"]] =
						unknownGridInfo[sourceCounter]["value"];
					}
					
					var unknownPanel = Ext.create('utilities.ScrollPanel',{
						style:{border:'0px solid yellow'},
						bodyPadding:0,
						padding:0,
						itemId:'insideunknownPanelId',
						layout : {
							type : 'vbox',
							align : 'stretch'
						},
						items : []
					});
					var unknownGrid = Ext.create('Ext.grid.property.Grid', {
						source : propertyGridSource,
						itemId:'insideunknownGridId',
						cls : "propertyGrid gridSkin",
						style:{'border':'0px #000 solid !important'},
						hideHeaders : true,
						border:false,
						width : '100%',
						margin:0,
						nameColumnWidth : "40%",
						listeners: {
							'beforeedit':{
								fn:function(){
									return false;
								}
							}
						}
					});
		        	unknownPanel.add(unknownGrid);
		        	for(var testStatusInfoCounter = 0 ; testStatusInfoCounter < jsonData.testStatusInfo.length ; testStatusInfoCounter++){
		        		var testStatus = jsonData.testStatusInfo[testStatusInfoCounter];

		        		if(!Ext.isEmpty(testStatus["AgentText"])){
			        		unknownPanel.add({
			        			xtype : 'container',
								itemId:'insideAgentTextId',
								cls:'panelWithoutHeader commonPanelBg',
			        			padding :5,
								margin:'6 10 0 6' ,
			        			html :  '<div style="width:16px;height:16px;margin:5px 4px 0 0;float:left"><img class="iconAgentNotReported" src="/final/images/clear.png"/></div><div style="float:left;padding-top:6px;height:90px" class="agent-text">' + testStatus["AgentText"] + '</div>'
			        		});
		        		}

						if(!Ext.isEmpty(testStatus["Text"])){
							unknownPanel.add({
								xtype:'container',
								itemId:'insideTextId',
								cls:'panelWithoutHeader commonPanelBg',
								margin:'6 6 0 6',
								padding :8,
								html:(!Ext.isEmpty(testStatus["PreText"])?testStatus["PreText"]:"")+testStatus["Text"]+(!Ext.isEmpty(testStatus["PostText"])?testStatus["PostText"]:"")
							});
						}
					}
					this.add(unknownPanel);
				}
				if(!Ext.isEmpty(this.getEl())){
					 this.getEl().unmask();
				}

				jsonData = null;
				delete jsonData;
				Ext.destroy(jsonData);
			},
			failure : function(){
				if(!Ext.isEmpty(this.getEl())){
					this.getEl().unmask();
				}
				//window.location.href = "/final/monitor/egMonDashboard.jsp";
			}
		});
	},
	reloadData : function(){
		if(this.getDockedComponent('insidetestInfoToolbar')){
			var testInfoToolbarIdObj=Ext.getCmp('insidetestInfoToolbarId');
			if(!Ext.isEmpty(testInfoToolbarIdObj))
			{
				testInfoToolbarIdObj.update("");
			}
		}
		if(!Ext.isEmpty(this.getEl())){
		}

		Ext.Ajax.request({
			url : this.url+'&isFromVirtualInside=true',
			scope:this,
			disableCaching:false,
			success: function(response){
				var jsonText = null;
				jsonText = response.responseText;
				if(!Ext.isEmpty(jsonText))
				{
					var jsonData=null;
					jsonData=Ext.decode(jsonText);

					jsonText = null;
					delete jsonText;
					Ext.destroy(jsonText);

					if(!Ext.isEmpty(jsonData.screenLabels))
					{
						var measuresTitle = jsonData.screenLabels["Measurements"] ? "&nbsp;" : "Measurements";
						if(!Ext.isEmpty(jsonData.screenLabels["LastMeasurementTime"])){
							measuresTitle += "<span>" + jsonData.screenLabels["LastMeasurementTime"] + "<img height='20' style='position:relative;top:5px;left:5px;width:10px' src='/final/images/clear.png' class='userProfileSeparator'/> </span>";
						}

						if(!Ext.isEmpty(Ext.getCmp('heading')))
						{
							if(!Ext.isEmpty(requestParams.isMoreInfosTreeView) && (requestParams.isMoreInfosTreeView || requestParams.isMoreInfosTreeView =="true"))
							{
								Ext.getCmp('heading').update("<div class='layerModelMeasureTime'>" + measuresTitle + "<span ><img style='margin-top:-7px;vertical-align:middle;' class='iconClose_moreinfo mouse' src='/final/images/clear.png' onclick='closeMoreInfoLayerTreePopUp();'/></span></div>");
							}
							else
							{
								Ext.getCmp('heading').update("<div class='layerModelMeasureTime'>" + measuresTitle + "</div>");
							}
						}
						else if(!Ext.isEmpty(Ext.getCmp('layerPopupMeasurementTime')))
						{
							if(!Ext.isEmpty(requestParams.isMoreInfosTreeView) && (requestParams.isMoreInfosTreeView || requestParams.isMoreInfosTreeView =="true"))
							{
								Ext.getCmp('layerPopupMeasurementTime').update("<div class='layerModelMeasureTime'>" + measuresTitle + "<span ><img style='margin-top:-7px;vertical-align:middle;margin-right:-16px' class='iconClose_moreinfo mouse' src='/final/images/clear.png' onclick='closeMoreInfoLayerTreePopUp();'/></span></div>");
							}
							else
							{
								Ext.getCmp('layerPopupMeasurementTime').update("<div class='layerModelMeasureTime'>" + measuresTitle + "</div>");
							}
						}
					}

					if(!Ext.isEmpty(jsonData.testInfo))
					{
						var testInfoToolbarIdObj = Ext.getCmp('insidetestInfoToolbarId');
						if(!Ext.isEmpty(testInfoToolbarIdObj))
						{
							testInfoToolbarIdObj.update('<img class="state_'+jsonData.testInfo["State"]+'" src="/final/images/clear.png" style="vertical-align:middle;margin-left:4px;margin-right:10px;"/><span class="font_bold11" data-qtip="'+jsonData.testInfo["Testname"]+(jsonData.testInfo["TestDesc"]?jsonData.testInfo["TestDesc"]:"")+(jsonData.testInfo["unit"]?"("+jsonData.testInfo["unit"]+")":"")+'" data-qclass="yellowTip">'+jsonData.testInfo["Testname"]+(jsonData.testInfo["TestDesc"]?jsonData.testInfo["TestDesc"]:"")+(jsonData.testInfo["unit"]?"("+jsonData.testInfo["unit"]+")":"")+'</span>');
						}

						if(!Ext.isEmpty(jsonData.stackInfo)){
							var stackInfoIdObj=Ext.getCmp('insidestackInfoId');
							if(!Ext.isEmpty(stackInfoIdObj))
							{
								stackInfoIdObj.update('<a href="javascript:void(0)" data-qtip="'+stackTraceLbl+'" data-qclass="yellowTip" onclick="stackTraceClicked(\''+jsonData.stackInfo.urlParam1+'\',\''+jsonData.stackInfo.urlParam2+'\')"><img class="iconStackTrace" style="margin-top:2px" src="/final/images/clear.png"/></a>');
							}
						}

						if(!Ext.isEmpty(jsonData.Logon_Details_Support))
						{
							var logon_DetailsIdIdObj=Ext.getCmp('insideLogon_DetailsId');
							if(!Ext.isEmpty(logon_DetailsIdIdObj))
							{
								logon_DetailsIdIdObj.update('<a href="javascript:void(0)" data-qtip="'+jsonData.Logon_Details_Support.logonTooltip+'" data-qclass="yellowTip" onclick="LogonDetailsPopUp(\''+jsonData.Logon_Details_Support.urlParam1+'\',\''+jsonData.Logon_Details_Support.titleforLogon+'\')"><img class="iconLogonDetails mouse" style="margin-top:2px" src="/final/images/clear.png" /></a>');
							}
						}

						if(!Ext.isEmpty(jsonData.detailInfo))
						{
							if(!Ext.isEmpty(jsonData.detailInfo["methodSuper"]) && jsonData.detailInfo["methodSuper"]==true)
							{
								var detailInfoIdObj=Ext.getCmp('insidedetailInfoId');
								if(!Ext.isEmpty(detailInfoIdObj))
								{
									if(!Ext.isEmpty(requestParams.isMoreInfosTreeView) && (requestParams.isMoreInfosTreeView || requestParams.isMoreInfosTreeView =="true"))
									{
										detailInfoIdObj.update('<a href="javascript:void(0)" data-qtip="'+detailInfoLbl+'" data-qclass="yellowTip" onclick="parent.detailsClicked("'+encodeURI(jsonData.detailInfo["urlParam1"])+'","'+encodeURI(jsonData.detailInfo["urlParam2"])+'","'+encodeURI(jsonData.detailInfo["urlParam3"])+'")"><img class="iconInfo" src="/final/images/clear.png" style="margin-top:2px" /></a>');
									}
									else
									{
										detailInfoIdObj.update('<a href="javascript:void(0)" data-qtip="'+detailInfoLbl+'" data-qclass="yellowTip" onclick="detailsClicked("'+encodeURI(jsonData.detailInfo["urlParam1"])+'","'+encodeURI(jsonData.detailInfo["urlParam2"])+'","'+encodeURI(jsonData.detailInfo["urlParam3"])+'")"><img class="iconInfo" src="/final/images/clear.png" style="margin-top:2px" /></a>');
									}
								}
							}
							else
							{
								var detailInfoIdObj=Ext.getCmp('insidedetailInfoId');
								if(!Ext.isEmpty(detailInfoIdObj))
								{
									if(!Ext.isEmpty(requestParams.isMoreInfosTreeView) && (requestParams.isMoreInfosTreeView || requestParams.isMoreInfosTreeView =="true"))
									{
										detailInfoIdObj.update('<a href="javascript:void(0)"  data-qtip="'+infoLbl+'" data-qclass="yellowTip" onclick=parent.detailsClicked("'+encodeURI(jsonData.detailInfo["urlParam1"])+'","'+encodeURI(jsonData.detailInfo["urlParam2"])+'","'+encodeURI(jsonData.detailInfo["urlParam3"])+'")><img class="iconInfo" src="/final/images/clear.png" style="margin-top:2px" /></a>');
									}
									else
									{
										detailInfoIdObj.update('<a href="javascript:void(0)"  data-qtip="'+infoLbl+'" data-qclass="yellowTip" onclick=detailsClicked("'+encodeURI(jsonData.detailInfo["urlParam1"])+'","'+encodeURI(jsonData.detailInfo["urlParam2"])+'","'+encodeURI(jsonData.detailInfo["urlParam3"])+'")><img class="iconInfo" src="/final/images/clear.png" style="margin-top:2px" /></a>');
									}
								}
							}
						}

						if(!Ext.isEmpty(jsonData.helpInfo))
						{
							if(!Ext.isEmpty(jsonData.helpInfo["methodSuper"]) && jsonData.helpInfo["methodSuper"]==true)
							{
								var helpInfoIdObj=Ext.getCmp('insidehelpInfoId');
								if(!Ext.isEmpty(helpInfoIdObj))
								{
									helpInfoIdObj.update('<a href="javascript:void(0)" data-qtip="'+helpLbl+'" data-qclass="yellowTip" onclick=HelpWin_Sm("'+encodeURI(jsonData.helpInfo["urlParam1"])+'","'+encodeURI(jsonData.helpInfo["urlParam2"])+'")><img class="iconLayermodelHelp" style="margin-top:0px" src="/final/images/clear.png"/></a>');
								}
							}
							else
							{
								var helpInfoIdObj=Ext.getCmp('insidehelpInfoId');
								if(!Ext.isEmpty(helpInfoIdObj))
								{
									helpInfoIdObj.update('<a href="javascript:void(0)" data-qtip="'+helpLbl+'" data-qclass="yellowTip" onclick=HelpWin("'+encodeURI(jsonData.helpInfo["urlParam1"])+'")><img style="margin-top:5px;" class="iconLayermodelHelp" src="/final/images/clear.png"/></a>');
								}
							}
						};
					}

					if(!Ext.isEmpty(jsonData.errormsg))
					{
						var msgPanel = Ext.create('utilities.ErrorPanel',{
							bodyCls : 'bottom-left-radius bottom-right-radius',
							errorMsg : '<div style="text-align:center;margin-top:25%"><div class="iconInformation" style="margin:0 auto"></div>'+jsonData.errormsg["msg"]+'</div>'
							});
						this.add(msgPanel);
					}
					else if(!Ext.isEmpty(jsonData.gridInfo))
					{
						if(!Ext.isEmpty(this.measureGrid))
						{
							this.measureGrid.getStore().loadRawData(jsonData);
						}
					}
					else if(!Ext.isEmpty(jsonData.unknownInfo))
					{
						var unknownGridInfo = jsonData.unknownInfo;
						var propertyGridSource = {};
						for(var sourceCounter = 0 ; sourceCounter < unknownGridInfo.length ; sourceCounter++){
							propertyGridSource[""+unknownGridInfo[sourceCounter]["key"]]=unknownGridInfo[sourceCounter]["value"];
						}
						var unknownPanel = Ext.create('utilities.ScrollPanel',{
							bodyCls : 'bottom-left-radius bottom-right-radius commonPanelBg',
							style:{border:'1px solid yellow'},
							bodyPadding:0,
							padding:0,
							layout : {
								type : 'vbox',
								align : 'stretch'
							},
							items : []
						});
						var unknownGrid = Ext.create('Ext.grid.property.Grid', {
							source : propertyGridSource,
							cls : "propertyGrid",
							hideHeaders : true,
							border:false,
							width : '100%',
							style:{border:'1px solid red'},
							margin:0,
							nameColumnWidth : "40%",
							listeners: {
								'beforeedit':{
									fn:function(){
										return false;
									}
								}
							}
						});
						unknownPanel.add(unknownGrid);
						for(var testStatusInfoCounter = 0 ; testStatusInfoCounter < jsonData.testStatusInfo.length ; testStatusInfoCounter++){
							var testStatus = jsonData.testStatusInfo[testStatusInfoCounter];

							if(!Ext.isEmpty(testStatus["AgentText"])){
								unknownPanel.add({
									xtype : 'container',
									cls:'panelWithoutHeader commonPanelBg',
									padding :5,
									margin:'6 10 0 6',
									html :  '<div style="width:16px;height:16px;5px 4px 0 0;float:left"><img class="iconAgentNotReported" src="/final/images/clear.png"/></div><div style="float:left;padding-top:6px;height:90px" class="agent-text">' + testStatus["AgentText"] + '</div>'
								});
							}

							if(!Ext.isEmpty(testStatus["Text"])){
								unknownPanel.add({
									xtype:'container',
									cls:'panelWithoutHeader commonPanelBg',
									margin:'6 6 0 6' ,
									padding :8,
									html:(!Ext.isEmpty(testStatus["PreText"])?testStatus["PreText"]+"":"")+testStatus["Text"]+(!Ext.isEmpty(testStatus["PostText"])?testStatus["PostText"]+"":"")
								});
							}
						}
						this.add(unknownPanel);
					}
					jsonData = null;
					delete jsonData;
					Ext.destroy(jsonData);
				}
			},
			failure : function(){
				//window.location.href = "/final/monitor/egMonDashboard.jsp";
			}
		});
	}
});




