Ext.define('componentDashboard.view.virtual.TestInfo',{
	alias:'widget.testinfo',
	extend:'Ext.window.Window',
	height:400,
	width:650,
	bodyBorder:false,
	bodyPadding:10,
	frame:true,
	autoScroll:true,
	closable:true,
	draggable:true,
	closeAction:'hide',
	layout:'anchor',
	title:testStatusInfoTitle,
	//currentImgCls:null,
	shadow:'sides',
	shadowOffset:40,
	//style:{'border':'1px solid orange'},
	items:[{
		xtype:'fieldcontainer',
		itemId:'top',
		width:'100%',
		defaults:{
			labelSeparator:''
		},
		layout : {
			type : 'vbox',
			pack  : 'center',
		},
			items:[{
			xtype: 'displayfield',
			labelAlign:'left',
			labelWidth:200,
			name: 'measurementshost',
			id: 'measurementshost',
			
		},{
			xtype: 'displayfield',
			labelAlign:'left',
			labelWidth:200,
			id: 'componenttype',
			name: 'componenttype',
			
		},{
			xtype: 'displayfield',
			labelAlign:'left',
			labelWidth:200,
			name: 'component',
			id: 'component',
			
		},{
			xtype: 'displayfield',
			labelAlign:'left',
			labelWidth:200,
			name: 'testname',
			id: 'testname',
		
		},{
			xtype: 'displayfield',
			labelAlign:'left',
			labelWidth:200,
			name: 'description',
			id: 'description',
			
		},{
			xtype: 'displayfield',
			labelAlign:'left',
			labelWidth:200,
			name: 'testtype',
			id: 'testtype',

		},{
			xtype: 'displayfield',
			labelAlign:'left',
			labelWidth:200,
			name: 'testfrequency',
			id: 'testfrequency',
		
		},{
			xtype: 'displayfield',
			labelAlign:'left',
			labelWidth:200,
			name: 'time',
			id: 'time',
		
		},{
			xtype: 'displayfield',
			labelAlign:'left',
			labelWidth:200,
			name: 'teststate',
			id: 'teststate',
		
		}]
	},{
			xtype:'container',
			width:'100%',
			itemId:'tableContainer',
	},{
		xtype:'fieldcontainer',
		itemId:'bottom',
		width:'100%',
		layout : {
			type : 'vbox',
			pack  : 'center',
		},
		items:[{
			xtype: 'displayfield',
			labelAlign:'left',
			labelWidth:200,
			name: 'quick',
			id: 'quick',
		
		},{
			xtype: 'displayfield',
			labelAlign:'left',
			labelWidth:200,
			name: 'policyname',
			id: 'policyname',
		
		},{
			xtype: 'displayfield',
			labelAlign:'left',
			labelWidth:200,
			name: 'policytime',
			id: 'policytime',
		
		}]
	}],
	
	initComponent:function(){
		this.callParent();
	},

	setTestDetailsData:function(json){
		var fieldContainer = this.child('fieldcontainer#top');
		var bottomFieldContainer = this.child('fieldcontainer#bottom');
		fieldContainer.getComponent('measurementshost').setFieldLabel(json.screenLabels.MeasurementHost);
		fieldContainer.getComponent('measurementshost').setValue(json.measureHost.MeasurementHostValue);
		fieldContainer.getComponent('measurementshost').show();

		fieldContainer.getComponent('componenttype').setFieldLabel(json.screenLabels.ComponentTypeDisplay);
		fieldContainer.getComponent('componenttype').setValue(json.displayValue.ComponentTypeValue);

		if(!Ext.isEmpty(json.ipAddress)){
		fieldContainer.getComponent('component').setFieldLabel(json.screenLabels.ComponentValue);
		fieldContainer.getComponent('component').setValue(json.displayComponentValue.Component + ' ('+json.ipAddress.ipAddr +')');
		}
		else {
		fieldContainer.getComponent('component').setFieldLabel(json.screenLabels.ComponentValue);
		fieldContainer.getComponent('component').setValue(json.displayComponentValue.Component);
		}

		fieldContainer.getComponent('testname').setFieldLabel(json.screenLabels.Testname);
		fieldContainer.getComponent('testname').setValue(json.testNameValue.TestNameData);
		
		if(!Ext.isEmpty(json.getReverse)){
			fieldContainer.getComponent('description').setFieldLabel(json.screenLabels.Description);
			fieldContainer.getComponent('description').setValue(json.getReverse.getReverseValue);
		}
	
		fieldContainer.getComponent('testtype').setFieldLabel(json.screenLabels.TestTypeDisplay);
		fieldContainer.getComponent('testtype').setValue(json.testTypeValue.TestType);

		fieldContainer.getComponent('testfrequency').setFieldLabel(json.screenLabels.TestFrequency);
		fieldContainer.getComponent('testfrequency').setValue(json.testFrequencyValue.frequencyOfTest);

		fieldContainer.getComponent('time').setFieldLabel(json.screenLabels.TimeSincelast);
		fieldContainer.getComponent('time').setValue(json.timeSince.timeSinceLastMeasure);

		fieldContainer.getComponent('teststate').setFieldLabel(json.screenLabels.Teststate);
		fieldContainer.getComponent('teststate').setValue(json.testStateValue.TestStateData);

		bottomFieldContainer.hide();
		
		if(!Ext.isEmpty(json.policyNames1Object) && !Ext.isEmpty(json.policyNames1Obj)){
			bottomFieldContainer.getComponent('quick').setFieldLabel(json.screenLabels.QuickMaintenanceDetails);
			bottomFieldContainer.getComponent('policyname').setFieldLabel(json.screenLabels.policyName);
			bottomFieldContainer.getComponent('policyname').setValue(json.policyNames1Object.policyNames1);
			bottomFieldContainer.getComponent('policytime').setFieldLabel(json.screenLabels.PolicyTime);
			bottomFieldContainer.getComponent('policytime').setValue(json.policyNames1Obj.PolicyTime);
			bottomFieldContainer.show();
		}

		this.doLayout();
		this.show();
	}
});